//this file is part of NeoMule
//Copyright (C)2006 David Xanatos ( Xanatos@Lycos.at / http://neomule.sourceforge.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


#pragma once
#include "Neo\GUI\CP\TreeOptionsCtrl.h" // NEO - [TreeControl] <-- Xanatos --

#ifdef LANCAST // NEO: NLC - [NeoLanCast] -- Xanatos -->

class CPPgLancast : public CPropertyPage
{
	DECLARE_DYNAMIC(CPPgLancast)

public:
	CPPgLancast();
	virtual ~CPPgLancast();

// Dialog Data
	enum { IDD = IDD_PPG_MOD };

protected:
	CTreeOptionsCtrl m_ctrlTreeOptions; // NEO - [TreeControl] <-- Xanatos --
	bool m_bInitializedTreeOpts;

	HTREEITEM m_htiLanSupport;
		HTREEITEM m_htiLancastUpload;
			HTREEITEM m_htiMaxLanUpload;
			HTREEITEM m_htiDirectLanUpload;
			HTREEITEM m_htiLanUploadSlots;
				HTREEITEM m_htiMaxLanUploadSlots;
			HTREEITEM m_htiLanUploadBufferSize;
		HTREEITEM m_htiLancastDownload;
			HTREEITEM m_htiMaxLanDownload;
			HTREEITEM m_htiDirectLanDownload;
			HTREEITEM m_htiLanDownloadBufferSize;
		HTREEITEM m_htiCustomLanCastAdapter;
			HTREEITEM m_htiCustomLanCastMask;
		HTREEITEM m_htiLancast;
			HTREEITEM m_htiLancastEnabled;
			HTREEITEM m_htiCustomizedLanCast;
				HTREEITEM m_htiLanCastPort;
			HTREEITEM m_htiLanCastReask;
				HTREEITEM m_htiLANIntervals;
				HTREEITEM m_htiLanReaskIntervals;
				HTREEITEM m_htiNnPLanReaskIntervals;
			HTREEITEM m_htiAutoBroadcastLanFiles;
			HTREEITEM m_htiUseLanMultiTransfer;
#ifdef VOODOO // NEO: VOODOO - [UniversalPartfileInterface]
		HTREEITEM m_htiVoodoo;
			HTREEITEM m_htiUseVoodooTransfer;
			HTREEITEM m_htiSlaveAllowed;
			HTREEITEM m_htiSlaveHosting;
			HTREEITEM m_htiAutoConnectVoodoo;
			HTREEITEM m_htiUseVirtualVoodooFiles;
			HTREEITEM m_htiHideVoodooFiles;
			HTREEITEM m_htiUseVoodooSourceExchange;
			HTREEITEM m_htiUseVoodooSearch;
			HTREEITEM m_htiVoodooNeoCommands;
			HTREEITEM m_htiVoodooNeoPreferences;
			HTREEITEM m_htiVoodooSpell;
			HTREEITEM m_htiVoodooPort;
			HTREEITEM m_htiVoodooCastEnabled;
				HTREEITEM m_htiSearchForSlaves;
				HTREEITEM m_htiSearchForMaster;
#endif // VOODOO // NEO: VOODOO END


	bool	m_bLancastEnabled;

	int		m_iMaxLanDownload;
	bool	m_bDirectLanDownload;
	bool	m_bSetLanDownloadBuffer;
	int		m_iLanDownloadBufferSize;

	int 	m_iMaxLanUpload;
	bool	m_bDirectLanUpload;
	bool	m_bSetLanUploadBuffer;
	int		m_iLanUploadBufferSize;

	int		m_iMaxLanUploadSlots;

	bool	m_bCustomizedLanCast;
	CString	m_sLanCastGroup;
	int		m_uLanCastPort;

	bool	m_bCustomLanCastAdapter;
	DWORD	m_uLanCastAdapterIPAdress;
	DWORD	m_uLanCastAdapterSubNet;

	int		m_iLANIntervals;

	int		m_iLanReaskIntervals;
	int		m_iNnPLanReaskIntervals;

	bool	m_bAutoBroadcastLanFiles;
	int		m_iAutoBroadcastLanFiles;

	bool	m_bUseLanMultiTransfer;

#ifdef VOODOO // NEO: VOODOO - [UniversalPartfileInterface]
	bool	m_bUseVoodooTransfer;
	bool	m_bSlaveAllowed;
	bool	m_bSlaveHosting;

	CString	m_sVoodooSpell;
	int		m_nVoodooPort;

	UINT	m_uAutoConnectVoodoo;

	UINT	m_uUseVirtualVoodooFiles;
	bool	m_bHideVoodooFiles;

	UINT	m_uUseVoodooSourceExchange;

	bool	m_bUseVoodooSearch;

	bool	m_bVoodooNeoCommands;
	bool	m_bVoodooNeoPreferences;

	UINT	m_uVoodooCastEnabled;

	UINT	m_uSearchForSlaves;
	UINT	m_uSearchForMaster;
	int		m_iVoodooSearchIntervals;
#endif // VOODOO // NEO: VOODOO END

	void ClearAllMembers();

	//void Localize();
	void LoadSettings();

	virtual BOOL OnInitDialog();
	virtual BOOL OnApply();
	virtual BOOL OnKillActive();
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	virtual BOOL OnCommand(WPARAM wParam, LPARAM lParam);

	DECLARE_MESSAGE_MAP()
	afx_msg void OnDestroy();
	afx_msg LRESULT OnTreeOptsCtrlNotify(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT DrawTreeItemHelp(WPARAM wParam, LPARAM lParam);
	afx_msg void OnHelp();
	afx_msg BOOL OnHelpInfo(HELPINFO* pHelpInfo);

	void CheckEnable();
};

#endif //LANCAST // NEO: NLC END <-- Xanatos --