//this file is part of NeoMule
//Copyright (C)2006 David Xanatos ( Xanatos@Lycos.at / http://neomule.sourceforge.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


#pragma once
#include "Neo\GUI\CP\TreeOptionsCtrl.h" // NEO - [TreeControl]

class CPPgFileTweaks : public CPropertyPage
{
	DECLARE_DYNAMIC(CPPgFileTweaks)

public:
	CPPgFileTweaks();
	virtual ~CPPgFileTweaks();

	void SetFiles(const CSimpleArray<CObject*>* paFiles) { m_paFiles = paFiles; m_bDataChanged = true;} // NEO: FCFG - [FileConfiguration]

	// Dialog Data
	enum { IDD = IDD_PPG_MOD };

protected:
	// NEO: FCFG - [FileConfiguration]
	//CString m_strCaption;
	const CSimpleArray<CObject*>* m_paFiles;
	bool m_bDataChanged;
	uint32 m_timer;
	static LPCTSTR sm_pszNotAvail;
	// NEO: FCFG END

	CTreeOptionsCtrl m_ctrlTreeOptions; // NEO - [TreeControl]
	bool m_bInitializedTreeOpts;

	HTREEITEM m_htiChunkSelectionMode;
		HTREEITEM m_htiChunkSelectionModeDefeult;
		HTREEITEM m_htiChunkSelectionModeNormal;
		HTREEITEM m_htiChunkSelectionModeICS;
		HTREEITEM m_htiChunkSelectionModeRC4;
		// NEO: RC4 - [RareChunksV4]
		HTREEITEM m_htiRareChunkV4Orde;
			HTREEITEM m_htiRareChunkV4OrdeNormal;
			HTREEITEM m_htiRareChunkV4OrdeLeft;
			HTREEITEM m_htiRareChunkV4OrdeRight;
			HTREEITEM m_htiRareChunkV4SameBlock;
		// NEO: RC4 END
		// NEO: SCT - [SubChunkTransfer]
		HTREEITEM m_htiSubChunkTransfer;
			HTREEITEM m_htiSubChunkTransferDefault;
			HTREEITEM m_htiSubChunkTransferEnable;
			HTREEITEM m_htiSubChunkTransferDisable;
		// NEO: SCT END
		// NEO: NPC - [NeoPartCatch]
		HTREEITEM m_htiPartCatch;
			HTREEITEM m_htiPartCatchDefault;
			HTREEITEM m_htiPartCatchReal;
			HTREEITEM m_htiPartCatchRealHiden;
			HTREEITEM m_htiPartCatchHiden;
			HTREEITEM m_htiPartCatchDisable;
		// NEO: NPC END
#ifdef A4AF_CATS // NEO: MAC - [MorphA4AFCategories]
	HTREEITEM m_htiA4AFFlags;
		HTREEITEM m_htiA4AFFlagsNone;
		HTREEITEM m_htiA4AFFlagsOn;
		HTREEITEM m_htiA4AFFlagsOff;
#endif // A4AF_CATS // NEO: MAC END
#ifdef LANCAST // NEO: NLC - [NeoLanCast]
	HTREEITEM m_htiLanCastReask;
		HTREEITEM m_htiDisableLAN;
		HTREEITEM m_htiLANIntervals;
		HTREEITEM m_htiLanReaskIntervals;
		HTREEITEM m_htiNnPLanReaskIntervals;
#endif //LANCAST // NEO: NLC END

	int		m_iChunkSelectionMode;
	// NEO: RC4 - [RareChunksV4]
	int		m_iRareChunkV4Orde;
	UINT	m_bRareChunkV4SameBlock;
	// NEO: RC4 END

	int		m_iSubChunkTransfer; // NEO: SCT - [SubChunkTransfer]

	int		m_iPartCatch; // NEO: NPC - [NeoPartCatch]

#ifdef A4AF_CATS // NEO: MAC - [MorphA4AFCategories]
	int		m_iA4AFFlags;
#endif // A4AF_CATS // NEO: MAC END

#ifdef LANCAST // NEO: NLC - [NeoLanCast]
	UINT	m_bDisableLAN;
	int		m_iLANIntervals;

	int		m_iLanReaskIntervals;
	int		m_iNnPLanReaskIntervals;
#endif //LANCAST // NEO: NLC END

	void ClearAllMembers();

	//void Localize();
	void RefreshData(); // NEO: FCFG - [FileConfiguration]

	virtual BOOL OnInitDialog();
	virtual BOOL OnApply();
	virtual BOOL OnKillActive();
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	virtual BOOL OnCommand(WPARAM wParam, LPARAM lParam);
	virtual BOOL OnSetActive(); // NEO: FCFG - [FileConfiguration]

	DECLARE_MESSAGE_MAP()
	afx_msg void OnTimer(UINT nIDEvent); // NEO: FCFG - [FileConfiguration]
	afx_msg void OnDestroy();
	afx_msg LRESULT OnDataChanged(WPARAM, LPARAM); // NEO: FCFG - [FileConfiguration]

	afx_msg LRESULT OnTreeOptsCtrlNotify(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT DrawTreeItemHelp(WPARAM wParam, LPARAM lParam);
	afx_msg void OnHelp();
	afx_msg BOOL OnHelpInfo(HELPINFO* pHelpInfo);

private:
};
