//this file is part of eMule
//Copyright (C)2002 Merkur ( devs@emule-project.net / http://www.emule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#include "stdafx.h"
#include "emule.h"
#include "ClientDetailDialog.h"
#include "UpDownClient.h"
#include "PartFile.h"
#include "ClientCredits.h"
#include "otherfunctions.h"
#include "Server.h"
#include "ServerList.h"
#include "SharedFileList.h"
#include "HighColorTab.hpp"
#include "UserMsgs.h"
#include "preferences.h"
#include ".\clientdetaildialog.h"
#ifdef IP2COUNTRY // NEO: IP2C - [IPtoCountry] -- Xanatos -->
#include "Neo\GUI\IP2Country.h"
#endif // IP2COUNTRY // NEO: IP2C END <-- Xanatos --
#ifdef NATTUNNELING // NEO: UTCP - [UserModeTCP] -- Xanatos -->
#include "EMSocket.h"
#include "Neo/AbstractSocket.h"
#include "neo/functions.h"
#endif //NATTUNNELING // NEO: UTCP END <-- Xanatos --
#include "ListenSocket.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


///////////////////////////////////////////////////////////////////////////////
// CClientDetailPage

IMPLEMENT_DYNAMIC(CClientDetailPage, CResizablePage)

BEGIN_MESSAGE_MAP(CClientDetailPage, CResizablePage)
	ON_MESSAGE(UM_DATA_CHANGED, OnDataChanged)
END_MESSAGE_MAP()

CClientDetailPage::CClientDetailPage()
	: CResizablePage(CClientDetailPage::IDD,0)
{
	m_paClients = NULL;
	m_bDataChanged = false;
	m_strCaption	= GetResString(IDS_CD_TITLE);
	m_psp.pszTitle	= m_strCaption;
	m_psp.dwFlags  |= PSP_USETITLE;

}

CClientDetailPage::~CClientDetailPage()
{
}

void CClientDetailPage::DoDataExchange(CDataExchange* pDX)
{
	CResizablePage::DoDataExchange(pDX);
}

BOOL CClientDetailPage::OnInitDialog()
{
	CResizablePage::OnInitDialog();
	InitWindowStyles(this);

	AddAnchor(IDC_STATIC30, TOP_LEFT, TOP_RIGHT);
	AddAnchor(IDC_STATIC55, TOP_LEFT, TOP_RIGHT); // NEO: MOD <-- Xanatos --
	AddAnchor(IDC_STATIC40, TOP_LEFT, TOP_RIGHT);
	AddAnchor(IDC_STATIC50, TOP_LEFT, TOP_RIGHT);
#ifdef WEBCACHE // NEO: WC - [WebCache] -- Xanatos -->
	AddAnchor(IDC_STATIC63, TOP_LEFT, TOP_RIGHT);
#endif // NEO: WC END <-- Xanatos --
	AddAnchor(IDC_DDOWNLOADING, TOP_LEFT, TOP_RIGHT);
	AddAnchor(IDC_UPLOADING, TOP_LEFT, TOP_RIGHT);

	AddAnchor(IDC_OBFUSCATION_STAT, TOP_LEFT, TOP_RIGHT);

	Localize();
	return TRUE;
}

BOOL CClientDetailPage::OnSetActive()
{
	if (!CResizablePage::OnSetActive())
		return FALSE;

	if (m_bDataChanged)
	{
		CUpDownClient* client = STATIC_DOWNCAST(CUpDownClient, (*m_paClients)[0]);

		CString buffer;
		if (client->GetIP()/*GetUserName()*/) // NEO: FIX - [StabilityFix] <-- Xanatos --
			GetDlgItem(IDC_DNAME)->SetWindowText(client->GetUserName());
		else
			GetDlgItem(IDC_DNAME)->SetWindowText(_T("?"));
		
		if (client->HasValidHash())
			GetDlgItem(IDC_DHASH)->SetWindowText(md4str(client->GetUserHash()));
		else
			GetDlgItem(IDC_DHASH)->SetWindowText(_T("?"));
		
		GetDlgItem(IDC_DSOFT)->SetWindowText(client->DbgGetFullClientSoftVer()); // NEO: MIDI - [ModIDInfo] <-- Xanatos --

		if (client->SupportsCryptLayer() && thePrefs.IsClientCryptLayerSupported() && (client->RequestsCryptLayer() || thePrefs.IsClientCryptLayerRequested()) 
			&& (client->IsObfuscatedConnectionEstablished() || !(client->socket != NULL && client->socket->IsConnected())))
		{
			buffer = GetResString(IDS_ENABLED);
		}
		else if (client->SupportsCryptLayer())
			buffer = GetResString(IDS_SUPPORTED);
		else
			buffer = GetResString(IDS_IDENTNOSUPPORT);
#if defined(_DEBUG) || defined(_BETA)
		if (client->IsObfuscatedConnectionEstablished())
			buffer += _T("(In Use)");
#endif
		GetDlgItem(IDC_OBFUSCATION_STAT)->SetWindowText(buffer);

		buffer.Format(_T("%s"),(client->HasLowID() ? GetResString(IDS_IDLOW):GetResString(IDS_IDHIGH)));
		GetDlgItem(IDC_DID)->SetWindowText(buffer);

		// NEO: MOD -- Xanatos -->
		buffer.Format(_T("%s:%i"), ipstr(client->GetIP()), client->GetUserPort());
		GetDlgItem(IDC_DIP)->SetWindowText(buffer);
		// NEO: MOD END <-- Xanatos --

#ifdef IP2COUNTRY // NEO: IP2C - [IPtoCountry] -- Xanatos -->
		GetDlgItem(IDC_DSCOUNTRY)->SetWindowText(client->GetCountryName(true));
#endif // IP2COUNTRY // NEO: IP2C END <-- Xanatos --

		if (client->GetServerIP()){
			GetDlgItem(IDC_DSIP)->SetWindowText(ipstr(client->GetServerIP(),client->GetServerPort())); // NEO: MOD <-- Xanatos --
			CServer* cserver = theApp.serverlist->GetServerByIPTCP(client->GetServerIP(), client->GetServerPort());
			if (cserver)
				GetDlgItem(IDC_DSNAME)->SetWindowText(cserver->GetListName());
			else
				GetDlgItem(IDC_DSNAME)->SetWindowText(_T("?"));
		}
		else{
			GetDlgItem(IDC_DSIP)->SetWindowText(_T("?"));
			GetDlgItem(IDC_DSNAME)->SetWindowText(_T("?"));
		}


	// NEO: MOD -- Xanatos -->
	if(client->GetCommentVersion())
		buffer.Format(GetResString(IDS_X_CD_PV),client->GetCommentVersion());	
	else
		buffer.Format(GetResString(IDS_X_CD_US));
	GetDlgItem(IDC_DPCOMMENTS)->SetWindowText(buffer);

	if(client->GetIncompletePartVersion() || client->GetSubChunksVer())
		buffer.Format(GetResString(IDS_X_CD_PV2),(UINT)client->GetIncompletePartVersion(),(UINT)client->GetSubChunksVer());
	else
		buffer.Format(GetResString(IDS_X_CD_US));
	GetDlgItem(IDC_DPINCP)->SetWindowText(buffer);

	if(client->GetHidenPartStatusVersion() || client->GetBlockedPartStatusVersion())
		buffer.Format(GetResString(IDS_X_CD_PV2),(UINT)client->GetHidenPartStatusVersion(),(UINT)client->GetBlockedPartStatusVersion());
	else
		buffer.Format(GetResString(IDS_X_CD_US));
	GetDlgItem(IDC_DPREALP)->SetWindowText(buffer);

	if(client->GetNeoModProtVersion())
		buffer.Format(GetResString(IDS_X_CD_PV),client->GetNeoModProtVersion());	
	else
		buffer.Format(GetResString(IDS_X_CD_US));
	GetDlgItem(IDC_DNMP)->SetWindowText(buffer);

	if(client->GetNeoXSVersion())
		buffer.Format(GetResString(IDS_X_CD_PV),client->GetNeoXSVersion());	
	else
		buffer.Format(GetResString(IDS_X_CD_US));
	GetDlgItem(IDC_DNMXS)->SetWindowText(buffer);

#ifdef NATTUNNELING // NEO: UTCP - [UserModeTCP] -- Xanatos -->
	if(!thePrefs.IsNATSupportEnabled())
		buffer.Format(GetResString(IDS_DISABLED));
	else if(client->GetNatTraversalVersion() > 0)
		buffer.Format(GetResString(IDS_X_CD_PV4),(UINT)client->GetNatTraversalVersion(), (UINT)client->GetNatPort()
		, client->IsSymetricNat() ? GetResString(IDS_X_CD_PV4_4) : client->IsFullConeNat() ? GetResString(IDS_X_CD_PV4_2) :  client->IsNATPortRelaiable() ? GetResString(IDS_X_CD_PV4_3) : _T("")
		, GetResString(client->socket && client->socket->m_Socket->IsNatSocket() ? IDS_YES : IDS_NO));
	else
		buffer.Format(GetResString(IDS_X_CD_US));
	GetDlgItem(IDC_DUDP)->SetWindowText(buffer);
#endif //NATTUNNELING // NEO: UTCP END <-- Xanatos --


	if(client->GetExtraInfoVersion())
		buffer.Format(GetResString(IDS_X_CD_PV),client->GetExtraInfoVersion());
	else
		buffer.Format(GetResString(IDS_X_CD_US));
	GetDlgItem(IDC_DPNXI)->SetWindowText(buffer);


	if(client->GetDownloadTimeVersion())
		buffer.Format(GetResString(IDS_X_CD_PV),client->GetDownloadTimeVersion());
	else
		buffer.Format(GetResString(IDS_X_CD_US));
	GetDlgItem(IDC_DPEDT)->SetWindowText(buffer);

	if(client->GetL2HACSupport())
		buffer.Format(GetResString(IDS_X_CD_S));
	else
		buffer.Format(GetResString(IDS_X_CD_US));
	GetDlgItem(IDC_DPL2HAC)->SetWindowText(buffer);
	// NEO: MOD END <-- Xanatos --


		CKnownFile* file = theApp.sharedfiles->GetFileByID(client->GetUploadFileID());
		if (file)
			GetDlgItem(IDC_DDOWNLOADING)->SetWindowText(file->GetFileName() );
		else
			GetDlgItem(IDC_DDOWNLOADING)->SetWindowText(_T("-"));

		if (client->GetRequestFile())
			GetDlgItem(IDC_UPLOADING)->SetWindowText( client->GetRequestFile()->GetFileName()  );
		else 
			GetDlgItem(IDC_UPLOADING)->SetWindowText(_T("-"));

		GetDlgItem(IDC_DDUP)->SetWindowText(CastItoXBytes(client->GetTransferredDown(), false, false));

		GetDlgItem(IDC_DDOWN)->SetWindowText(CastItoXBytes(client->GetTransferredUp(), false, false));

		buffer.Format(_T("%s"), CastItoXBytes(client->GetDownloadDatarate(), false, true));
		GetDlgItem(IDC_DAVUR)->SetWindowText(buffer);

		buffer.Format(_T("%s"),CastItoXBytes(client->GetDatarate(), false, true));
		GetDlgItem(IDC_DAVDR)->SetWindowText(buffer);
		
		if (client->Credits()){
			GetDlgItem(IDC_DUPTOTAL)->SetWindowText(CastItoXBytes(client->Credits()->GetDownloadedTotal(), false, false));
			GetDlgItem(IDC_DDOWNTOTAL)->SetWindowText(CastItoXBytes(client->Credits()->GetUploadedTotal(), false, false));
			// NEO: NCS - [NeoCreditSystem] -- Xanatos -->
			float modif = 1.0F;
			if(thePrefs.UseCreditSystem())
				if (thePrefs.UseNeoCreditSystem())
					modif = client->Credits()->GetNeoScoreRatio(client->GetRequestFile() != NULL /*client->GetDownloadState() == DS_ONQUEUE*/,client->GetIP());
				else
					modif = client->Credits()->GetScoreRatio(client->GetIP());
			buffer.Format(_T("%.1f"),modif);
			// NEO: NCS END <-- Xanatos --
			GetDlgItem(IDC_DRATIO)->SetWindowText(buffer);
			// NEO: RSR - [RemoteScoreRatio] -- Xanatos -->
			buffer.Format(_T("%.1f"),(float)client->Credits()->GetRemoteScoreRatio());
			GetDlgItem(IDC_DREMOTERATIO)->SetWindowText(buffer);
			// NEO: RSR END <-- Xanatos --
			
			
			if (theApp.clientcredits->CryptoAvailable()){
				switch(client->Credits()->GetCurrentIdentState(client->GetIP())){
					case IS_NOTAVAILABLE:
						GetDlgItem(IDC_CDIDENT)->SetWindowText(GetResString(IDS_IDENTNOSUPPORT));
						break;
					case IS_IDFAILED:
						GetDlgItem(IDC_CDIDENT)->SetWindowText(GetResString(IDS_IDENTFAILED));
						break;
					case IS_IDNEEDED:
						GetDlgItem(IDC_CDIDENT)->SetWindowText(GetResString(IDS_X_IDENTNEED)); // NEO: MOD <-- Xanatos --
						break;
					case IS_IDBADGUY:
						GetDlgItem(IDC_CDIDENT)->SetWindowText(GetResString(IDS_X_IDBADGUY)); // NEO: MOD <-- Xanatos --
						break;
					case IS_IDENTIFIED:
						GetDlgItem(IDC_CDIDENT)->SetWindowText(GetResString(IDS_IDENTOK));
						break;
				}
			}
			else
				GetDlgItem(IDC_CDIDENT)->SetWindowText(GetResString(IDS_IDENTNOSUPPORT));
		}	
		else{
			GetDlgItem(IDC_DDOWNTOTAL)->SetWindowText(_T("?"));
			GetDlgItem(IDC_DUPTOTAL)->SetWindowText(_T("?"));
			GetDlgItem(IDC_DRATIO)->SetWindowText(_T("?"));
			GetDlgItem(IDC_DREMOTERATIO)->SetWindowText(_T("?")); // NEO: RSR - [RemoteScoreRatio] <-- Xanatos --
			GetDlgItem(IDC_CDIDENT)->SetWindowText(_T("?"));
		}

		if (client->GetIP()/*GetUserName()*/ && client->Credits()!=NULL){ // NEO: FIX - [StabilityFix] <-- Xanatos --
			buffer.Format(_T("%.1f"),(float)client->GetScore(false,client->IsDownloading(),true));
			GetDlgItem(IDC_DRATING)->SetWindowText(buffer);
		}
		else
			GetDlgItem(IDC_DRATING)->SetWindowText(_T("?"));

		if (client->GetUploadState() != US_NONE && client->Credits()!=NULL){
			// NEO: MOD -- Xanatos -->
			buffer.Format(_T("%u"),client->GetScore(false,client->IsDownloading(),false));
			if(client->GetFriendSlot())
				buffer.Append(GetResString(IDS_FRIENDDETAIL));
			GetDlgItem(IDC_DSCORE)->SetWindowText(buffer);
			// NEO: MOD END <-- Xanatos --
		}
		else
			GetDlgItem(IDC_DSCORE)->SetWindowText(_T("-"));

		if (client->GetKadPort() )
			buffer.Format( _T("%s"), GetResString(IDS_CONNECTED));
		else
			buffer.Format( _T("%s"), GetResString(IDS_DISCONNECTED));
		GetDlgItem(IDC_CLIENTDETAIL_KADCON)->SetWindowText(buffer);

#ifdef WEBCACHE // NEO: WC - [WebCache] -- Xanatos -->
		GetDlgItem(IDC_DWCE)->SetWindowText(client->SupportsWebCache() ? GetResString(IDS_YES) : GetResString(IDS_NO));
		GetDlgItem(IDC_WEBCACHE)->SetWindowText(client->GetWebCacheName()); // Superlexx - webcache //JP changed to new GetWebcacheName-function
		double percentSessions = 0;
		if (client->WebCachedBlockRequests != 0)
			percentSessions = (double) 100 * client->SuccessfulWebCachedBlockDownloads / client->WebCachedBlockRequests;
		buffer.Format( _T("%u/%u (%1.1f%%)"), client->SuccessfulWebCachedBlockDownloads, client->WebCachedBlockRequests, percentSessions );
		GetDlgItem(IDC_WCSTATISTICS)->SetWindowText(buffer); //JP Client WC-Statistics
		if (client->IsTrustedOHCBSender())
			buffer.Format(GetResString(IDS_YES));
		else
			buffer.Format(GetResString(IDS_NO));
		GetDlgItem(IDC_TRUSTEDOHCBSENDER)->SetWindowText(buffer); //JP Is trusted OHCB sender
#endif // NEO: WC END <-- Xanatos --

		m_bDataChanged = false;
	}
	return TRUE;
}

LRESULT CClientDetailPage::OnDataChanged(WPARAM, LPARAM)
{
	m_bDataChanged = true;
	return 1;
}

void CClientDetailPage::Localize()
{
	GetDlgItem(IDC_STATIC30)->SetWindowText(GetResString(IDS_CD_GENERAL));
	GetDlgItem(IDC_STATIC31)->SetWindowText(GetResString(IDS_CD_UNAME));
	GetDlgItem(IDC_STATIC32)->SetWindowText(GetResString(IDS_CD_UHASH));
	GetDlgItem(IDC_STATIC33)->SetWindowText(GetResString(IDS_CD_CSOFT) + _T(':'));
	GetDlgItem(IDC_STATIC35)->SetWindowText(GetResString(IDS_CD_SIP));
	GetDlgItem(IDC_STATIC36)->SetWindowText(GetResString(IDS_X_CD_IP)); // NEO: MOD <-- Xanatos --
	GetDlgItem(IDC_STATIC38)->SetWindowText(GetResString(IDS_CD_SNAME));
	GetDlgItem(IDC_STATIC_OBF_LABEL)->SetWindowText(GetResString(IDS_OBFUSCATION) + _T(':'));

	// NEO: MOD -- Xanatos -->
	GetDlgItem(IDC_STATIC55)->SetWindowText(GetResString(IDS_X_CD_PROTOCOL));
	GetDlgItem(IDC_STATIC56)->SetWindowText(GetResString(IDS_X_CD_COMMENTS));
	GetDlgItem(IDC_STATIC59)->SetWindowText(GetResString(IDS_X_CD_INCPARTS));
	GetDlgItem(IDC_STATIC61)->SetWindowText(GetResString(IDS_X_CD_REALPARTS));
	GetDlgItem(IDC_STATIC70)->SetWindowText(GetResString(IDS_X_CD_NEOPROT));
	GetDlgItem(IDC_STATIC71)->SetWindowText(GetResString(IDS_X_CD_NEOXS));
	GetDlgItem(IDC_STATIC74)->SetWindowText(GetResString(IDS_X_CD_NATTRAVERSAL));
	GetDlgItem(IDC_STATIC58)->SetWindowText(GetResString(IDS_X_CD_EXTRAINFO));
	GetDlgItem(IDC_STATIC60)->SetWindowText(GetResString(IDS_X_CD_EDT));
	GetDlgItem(IDC_STATIC62)->SetWindowText(GetResString(IDS_X_CD_L2HAC));
	// NEO: MOD END <-- Xanatos --

	GetDlgItem(IDC_STATIC40)->SetWindowText(GetResString(IDS_CD_TRANS));
	GetDlgItem(IDC_STATIC41)->SetWindowText(GetResString(IDS_CD_CDOWN));
	GetDlgItem(IDC_STATIC42)->SetWindowText(GetResString(IDS_CD_DOWN));
	GetDlgItem(IDC_STATIC43)->SetWindowText(GetResString(IDS_CD_ADOWN));
	GetDlgItem(IDC_STATIC44)->SetWindowText(GetResString(IDS_CD_TDOWN));
	GetDlgItem(IDC_STATIC45)->SetWindowText(GetResString(IDS_CD_UP));
	GetDlgItem(IDC_STATIC46)->SetWindowText(GetResString(IDS_CD_AUP));
	GetDlgItem(IDC_STATIC47)->SetWindowText(GetResString(IDS_CD_TUP));
	GetDlgItem(IDC_STATIC48)->SetWindowText(GetResString(IDS_CD_UPLOADREQ));

	GetDlgItem(IDC_STATIC50)->SetWindowText(GetResString(IDS_CD_SCORES));
	GetDlgItem(IDC_STATIC51)->SetWindowText(GetResString(IDS_CD_MOD));
	GetDlgItem(IDC_STATIC52)->SetWindowText(GetResString(IDS_CD_RATING));
	GetDlgItem(IDC_STATIC53)->SetWindowText(GetResString(IDS_CD_USCORE));
	GetDlgItem(IDC_STATIC133x)->SetWindowText(GetResString(IDS_CD_IDENT));
	GetDlgItem(IDC_CLIENTDETAIL_KAD)->SetWindowText(GetResString(IDS_KADEMLIA) + _T(":"));

	GetDlgItem(IDC_STATIC54)->SetWindowText(GetResString(IDS_X_CD_REMOTE_MOD)); // NEO: RSR - [RemoteScoreRatio] <-- Xanatos --

#ifdef IP2COUNTRY // NEO: IP2C - [IPtoCountry] -- Xanatos -->
	GetDlgItem(IDC_STATIC78)->SetWindowText(GetResString(IDS_X_COUNTRY)); 
#endif // IP2COUNTRY // NEO: IP2C END <-- Xanatos --

#ifdef WEBCACHE // NEO: WC - [WebCache] -- Xanatos -->
	GetDlgItem(IDC_STATIC63)->SetWindowText(GetResString(IDS_X_CD_WEBCACHE));
	GetDlgItem(IDC_STATIC65)->SetWindowText(GetResString(IDS_X_CD_WEBCACHE_SUPPORT));
	GetDlgItem(IDC_STATIC64)->SetWindowText(GetResString(IDS_X_CD_WEBCACHE_NAME));
	GetDlgItem(IDC_STATIC66)->SetWindowText(GetResString(IDS_X_CD_WEBCACHE_SUC));
	GetDlgItem(IDC_STATIC67)->SetWindowText(GetResString(IDS_X_CD_WEBCACHE_TRU));
#endif // NEO: WC END <-- Xanatos --
}


///////////////////////////////////////////////////////////////////////////////
// CClientDetailDialog

IMPLEMENT_DYNAMIC(CClientDetailDialog, CListViewWalkerModelessPropertySheet) // NEO: MLD - [ModelesDialogs] <-- Xanatos --

BEGIN_MESSAGE_MAP(CClientDetailDialog, CListViewWalkerModelessPropertySheet) // NEO: MLD - [ModelesDialogs] <-- Xanatos --
	ON_WM_DESTROY()
END_MESSAGE_MAP()

CClientDetailDialog::CClientDetailDialog(CUpDownClient* pClient, CListCtrlItemWalk* pListCtrl, UINT uInvokePage) // NEO: MOD - [ClientsDetails] <-- Xanatos --
	: CListViewWalkerModelessPropertySheet(pListCtrl) // NEO: MLD - [ModelesDialogs] <-- Xanatos --
{
	m_uInvokePage = uInvokePage; // NEO: MOD - [ClientsDetails] <-- Xanatos --
	m_aItems.Add(pClient);
	Construct();
}

CClientDetailDialog::CClientDetailDialog(const CSimpleArray<CUpDownClient*>* paClients, CListCtrlItemWalk* pListCtrl, UINT uInvokePage) // NEO: MOD - [ClientsDetails] <-- Xanatos --
	: CListViewWalkerModelessPropertySheet(pListCtrl) // NEO: MLD - [ModelesDialogs] <-- Xanatos --
{
	m_uInvokePage = uInvokePage; // NEO: MOD - [ClientsDetails] <-- Xanatos --
	for (int i = 0; i < paClients->GetSize(); i++)
		m_aItems.Add((*paClients)[i]);
	Construct();
}

void CClientDetailDialog::Construct()
{
	m_psh.dwFlags &= ~PSH_HASHELP;
	m_psh.dwFlags |= PSH_NOAPPLYNOW;

	m_wndClient.m_psp.dwFlags &= ~PSP_HASHELP;
	m_wndClient.m_psp.dwFlags |= PSP_USEICONID;
	m_wndClient.m_psp.pszIcon = _T("CLIENTDETAILS");
	m_wndClient.SetClients(&m_aItems);
	AddPage(&m_wndClient);

#ifdef NEO_CD // NEO: NCD - [NeoClientDatabase] -- Xanatos -->
	if(thePrefs.EnableSourceList()){
		m_wndSource.m_psp.dwFlags &= ~PSP_HASHELP;
		m_wndSource.m_psp.dwFlags |= PSP_USEICONID;
		m_wndSource.m_psp.pszIcon = _T("SOURCESAVER");
		m_wndSource.SetClients(&m_aItems);
		AddPage(&m_wndSource);
	}
#endif // NEO_CD // NEO: NCD END <-- Xanatos --

	// NEO: NXI - [NeoExtraInfo] -- Xanatos -->
	if(thePrefs.SendExtraInfo()){
		m_wndExtraInfo.m_psp.dwFlags &= ~PSP_HASHELP;
		m_wndExtraInfo.m_psp.dwFlags |= PSP_USEICONID;
		m_wndExtraInfo.m_psp.pszIcon = _T("CLIENTEXTRAINFO");
		m_wndExtraInfo.SetClients(&m_aItems);
		AddPage(&m_wndExtraInfo);
	}
	// NEO: NXI END <-- Xanatos --

	// NEO: RFL - [RequestFileList] -- Xanatos -->
	m_wndReqFiles.m_psp.dwFlags &= ~PSP_HASHELP;
	m_wndReqFiles.m_psp.dwFlags |= PSP_USEICONID;
	m_wndReqFiles.m_psp.pszIcon = _T("CLIENTREQFILES");
	m_wndReqFiles.SetClients(&m_aItems);
	AddPage(&m_wndReqFiles);
	// NEO: RFL END <-- Xanatos --

	// NEO: XSF - [ExtendedSharedFiles] -- Xanatos -->
	m_wndSharedFiles.m_psp.dwFlags &= ~PSP_HASHELP;
	m_wndSharedFiles.m_psp.dwFlags |= PSP_USEICONID;
	m_wndSharedFiles.m_psp.pszIcon = _T("VIEWFILES");
	m_wndSharedFiles.SetClients(&m_aItems);
	AddPage(&m_wndSharedFiles);
	// NEO: XSF END <-- Xanatos --

#ifdef ARGOS // NEO: NA - [NeoArgos] -- Xanatos -->
	if(thePrefs.UseArgosSystem()){
		m_wndArgos.m_psp.dwFlags &= ~PSP_HASHELP;
		m_wndArgos.m_psp.dwFlags |= PSP_USEICONID;
		m_wndArgos.m_psp.pszIcon = _T("ARGOS");
		m_wndArgos.SetClients(&m_aItems);
		AddPage(&m_wndArgos);
	}
#endif // ARGOS // NEO: NA END <-- Xanatos --

	// NEO: MOD - [ClientsDetails] -- Xanatos -->
	LPCTSTR pPshStartPage = MAKEINTRESOURCE(IDD_SOURCEDETAILWND);
	if (m_uInvokePage != 0)
		pPshStartPage = MAKEINTRESOURCE(m_uInvokePage);
	for (int i = 0; i < m_pages.GetSize(); i++)
	{
		CPropertyPage* pPage = GetPage(i);
		if (pPage->m_psp.pszTemplate == pPshStartPage)
		{
			m_psh.nStartPage = i;
			break;
		}
	}
	// NEO: MOD END <-- Xanatos --
}

CClientDetailDialog::~CClientDetailDialog()
{
}

void CClientDetailDialog::OnDestroy()
{
	CListViewWalkerModelessPropertySheet::OnDestroy(); // NEO: MLD - [ModelesDialogs] <-- Xanatos --
}

BOOL CClientDetailDialog::OnInitDialog()
{		
	EnableStackedTabs(FALSE);
	BOOL bResult =  CListViewWalkerModelessPropertySheet::OnInitDialog(); // NEO: MLD - [ModelesDialogs] <-- Xanatos --
	HighColorTab::UpdateImageList(*this);
	InitWindowStyles(this);
	EnableSaveRestore(_T("ClientDetailDialog")); // call this after(!) OnInitDialog
	SetWindowText(GetResString(IDS_CD_TITLE));
	return bResult;
}

// NEO: MLD - [ModelesDialogs] -- Xanatos -->
//////////////////////////////////////////////////////////////////////////////
// CClientDetailDialogInterface

CClientDetailDialogInterface::CClientDetailDialogInterface(CUpDownClient* owner)
	: CListViewWalkerModelessPropertySheetInterface(STATIC_DOWNCAST(CObject, owner))
{
}

void CClientDetailDialogInterface::OpenDetailDialog(CListCtrlItemWalk* pListCtrl, UINT uInvokePage)	// NEO: MOD - [ClientsDetails]
{
	CSimpleArray<CUpDownClient*> aClients;
	aClients.Add(STATIC_DOWNCAST(CUpDownClient, GetOwner()));
	OpenDetailDialog(&aClients, pListCtrl, uInvokePage);
}

void CClientDetailDialogInterface::OpenDetailDialog(const CSimpleArray<CUpDownClient*>* paClients, CListCtrlItemWalk* pListCtrl, UINT uInvokePage) // NEO: MOD - [ClientsDetails]
{
	CSimpleArray<CListViewWalkerModelessPropertySheetInterface*> aInterfaces;
	for (int i = 0; i < paClients->GetSize(); i++)
		aInterfaces.Add(STATIC_DOWNCAST(CListViewWalkerModelessPropertySheetInterface, (*paClients)[i]->GetDetailDialogInterface()));
	OpenPropertySheet(&aInterfaces, paClients, pListCtrl, uInvokePage); // NEO: MOD - [ClientsDetails]
}

// NEO: XSF - [ExtendedSharedFiles]
void CClientDetailDialogInterface::UpdateTree(CString newDir)
{
	for (int i = 0; i < GetPropertySheetCount(); i++)
		STATIC_DOWNCAST(CClientDetailDialog, GetPropertySheet(i))->UpdateTree(newDir);
}
// NEO: XSF END

CListViewWalkerModelessPropertySheet* CClientDetailDialogInterface::CreatePropertySheet(va_list args)
{
	const CSimpleArray<CUpDownClient*>* paClients = (const CSimpleArray<CUpDownClient*>*)va_arg(args, LPVOID);
	CListCtrlItemWalk* pListCtrl = va_arg(args, CListCtrlItemWalk*);
	UINT uInvokePage = va_arg(args, UINT);
	return STATIC_DOWNCAST(CListViewWalkerModelessPropertySheet, new CClientDetailDialog(paClients, pListCtrl, uInvokePage)); // NEO: MOD - [ClientsDetails]
}
// NEO: MLD <-- Xanatos --

