//this file is part of eMule
//Copyright (C)2002-2005 Merkur ( devs@emule-project.net / http://www.emule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include "stdafx.h"
#include <io.h>
#include <share.h>
#include <iphlpapi.h>
#include "emule.h"
#include "Preferences.h"
#include "Opcodes.h"
#include "OtherFunctions.h"
#include "Ini2.h"
#include "DownloadQueue.h"
#include "UploadQueue.h"
#include "Statistics.h"
#include "MD5Sum.h"
#include "PartFile.h"
#include "ServerConnect.h"
#include "ListenSocket.h"
#include "ServerList.h"
#include "SharedFileList.h"
#include "UpDownClient.h"
#include "SafeFile.h"
#include "emuledlg.h"
#include "StatisticsDlg.h"
#include "Log.h"
#include "MuleToolbarCtrl.h"
// NEO: NCFG - [NeoConfiguration] -- Xanatos -->
#include "Neo/functions.h" 
#include "Neo/defaults.h" 
#include "Neo/NeoOpCodes.h" 
#include "Neo/IniStrings.h" 
// NEO: NCFG END <-- Xanatos --
// NEO: NATS - [NatSupport] -- Xanatos -->
#include "packets.h"
#include "clientlist.h"
#include "clientudpsocket.h"
#include "kademlia/kademlia/kademlia.h"
#include "kademlia/kademlia/prefs.h"
// NEO: NATS END <-- Xanatos --

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

CPreferencesEx thePrefs; // NEO: NCFG - [NeoConfiguration] <-- Xanatos --

int		CPreferences::m_iDbgHeap;
CString	CPreferences::strNick;
#ifndef NEO_BC // NEO: NBC -- Xanatos -->
uint16	CPreferences::minupload;
#endif // NEO_BC // NEO: NBC END <-- Xanatos --
uint16	CPreferences::maxupload;
uint16	CPreferences::maxdownload;
uint16	CPreferences::port;
uint16	CPreferences::udpport;
uint16	CPreferences::kadport; // NEO: KAX - [KadAuxPort] <-- Xanatos --
uint16	CPreferences::nServerUDPPort;
UINT	CPreferences::maxconnections;
UINT	CPreferences::maxhalfconnections;
bool	CPreferences::m_bConditionalTCPAccept;
bool	CPreferences::reconnect;
bool	CPreferences::m_bUseServerPriorities;
bool	CPreferences::m_bUseUserSortedServerList;
TCHAR	CPreferences::incomingdir[MAX_PATH];
TCHAR	CPreferences::tempdir[MAX_PATH]; // NEO: MTD - [MultiTempDirectories] <-- Xanatos --
bool	CPreferences::ICH;
bool	CPreferences::m_bAutoUpdateServerList;
bool	CPreferences::updatenotify;
bool	CPreferences::mintotray;
bool	CPreferences::autoconnect;
bool	CPreferences::m_bAutoConnectToStaticServersOnly;
bool	CPreferences::autotakeed2klinks;
bool	CPreferences::addnewfilespaused;
UINT	CPreferences::depth3D;
//bool	CPreferences::m_bEnableMiniMule; // NEO: MM - [NeoMiniMule] <-- Xanatos --
int		CPreferences::m_iStraightWindowStyles;
bool	CPreferences::m_bRTLWindowsLayout;
CString	CPreferences::m_strSkinProfile;
CString	CPreferences::m_strSkinProfileDir;
bool	CPreferences::m_bAddServersFromServer;
bool	CPreferences::m_bAddServersFromClients;
//UINT	CPreferences::maxsourceperfile; // NEO: NST - [NeoSourceTweaks] <-- Xanatos --
UINT	CPreferences::trafficOMeterInterval;
UINT	CPreferences::statsInterval;
uchar	CPreferences::userhash[16];
WINDOWPLACEMENT CPreferences::EmuleWindowPlacement;
int		CPreferences::maxGraphDownloadRate;
int		CPreferences::maxGraphUploadRate;
uint32	CPreferences::maxGraphUploadRateEstimated = 0;
bool	CPreferences::beepOnError;
bool	CPreferences::m_bIconflashOnNewMessage;
bool	CPreferences::confirmExit;
DWORD	CPreferences::m_adwStatsColors[41]; // NEO: NSTI - [NewSystemTrayIcon] // NEO: CTB - [CoolToolBar] // NEO: MOD - [NeoStats] <-- Xanatos -- 
bool	CPreferences::splashscreen;
bool	CPreferences::filterLANIPs;
bool	CPreferences::m_bAllocLocalHostIP;
bool	CPreferences::onlineSig;
uint64	CPreferences::cumDownOverheadTotal;
uint64	CPreferences::cumDownOverheadFileReq;
uint64	CPreferences::cumDownOverheadSrcEx;
uint64	CPreferences::cumDownOverheadServer;
uint64	CPreferences::cumDownOverheadKad;
uint64	CPreferences::cumDownOverheadTotalPackets;
uint64	CPreferences::cumDownOverheadFileReqPackets;
uint64	CPreferences::cumDownOverheadSrcExPackets;
uint64	CPreferences::cumDownOverheadServerPackets;
uint64	CPreferences::cumDownOverheadKadPackets;
uint64	CPreferences::cumUpOverheadTotal;
uint64	CPreferences::cumUpOverheadFileReq;
uint64	CPreferences::cumUpOverheadSrcEx;
uint64	CPreferences::cumUpOverheadServer;
uint64	CPreferences::cumUpOverheadKad;
uint64	CPreferences::cumUpOverheadTotalPackets;
uint64	CPreferences::cumUpOverheadFileReqPackets;
uint64	CPreferences::cumUpOverheadSrcExPackets;
uint64	CPreferences::cumUpOverheadServerPackets;
uint64	CPreferences::cumUpOverheadKadPackets;
uint32	CPreferences::cumUpSuccessfulSessions;
uint32	CPreferences::cumUpFailedSessions;
uint32	CPreferences::cumUpAvgTime;
uint64	CPreferences::cumUpData_EDONKEY;
uint64	CPreferences::cumUpData_EDONKEYHYBRID;
uint64	CPreferences::cumUpData_EMULE;
uint64	CPreferences::cumUpData_MLDONKEY;
uint64	CPreferences::cumUpData_AMULE;
uint64	CPreferences::cumUpData_EMULECOMPAT;
uint64	CPreferences::cumUpData_SHAREAZA;
uint64	CPreferences::sesUpData_EDONKEY;
uint64	CPreferences::sesUpData_EDONKEYHYBRID;
uint64	CPreferences::sesUpData_EMULE;
uint64	CPreferences::sesUpData_MLDONKEY;
uint64	CPreferences::sesUpData_AMULE;
uint64	CPreferences::sesUpData_EMULECOMPAT;
uint64	CPreferences::sesUpData_SHAREAZA;
uint64	CPreferences::cumUpDataPort_4662;
uint64	CPreferences::cumUpDataPort_OTHER;
uint64	CPreferences::cumUpDataPort_PeerCache;
uint64	CPreferences::sesUpDataPort_4662;
uint64	CPreferences::sesUpDataPort_OTHER;
uint64	CPreferences::sesUpDataPort_PeerCache;
uint64	CPreferences::cumUpData_File;
uint64	CPreferences::cumUpData_Partfile;
uint64	CPreferences::sesUpData_File;
uint64	CPreferences::sesUpData_Partfile;
uint32	CPreferences::cumDownCompletedFiles;
uint32	CPreferences::cumDownSuccessfulSessions;
uint32	CPreferences::cumDownFailedSessions;
uint32	CPreferences::cumDownAvgTime;
uint64	CPreferences::cumLostFromCorruption;
uint64	CPreferences::cumSavedFromCompression;
uint32	CPreferences::cumPartsSavedByICH;
uint32	CPreferences::sesDownSuccessfulSessions;
uint32	CPreferences::sesDownFailedSessions;
uint32	CPreferences::sesDownAvgTime;
uint32	CPreferences::sesDownCompletedFiles;
uint64	CPreferences::sesLostFromCorruption;
uint64	CPreferences::sesSavedFromCompression;
uint32	CPreferences::sesPartsSavedByICH;
uint64	CPreferences::cumDownData_EDONKEY;
uint64	CPreferences::cumDownData_EDONKEYHYBRID;
uint64	CPreferences::cumDownData_EMULE;
uint64	CPreferences::cumDownData_MLDONKEY;
uint64	CPreferences::cumDownData_AMULE;
uint64	CPreferences::cumDownData_EMULECOMPAT;
uint64	CPreferences::cumDownData_SHAREAZA;
uint64	CPreferences::cumDownData_URL;
#ifdef WEBCACHE // NEO: WC - [WebCache] -- Xanatos -->
uint64	CPreferences::cumDownData_WEBCACHE; //jp webcache statistics
#endif // NEO: WC END <-- Xanatos --
uint64	CPreferences::sesDownData_EDONKEY;
uint64	CPreferences::sesDownData_EDONKEYHYBRID;
uint64	CPreferences::sesDownData_EMULE;
uint64	CPreferences::sesDownData_MLDONKEY;
uint64	CPreferences::sesDownData_AMULE;
uint64	CPreferences::sesDownData_EMULECOMPAT;
uint64	CPreferences::sesDownData_SHAREAZA;
uint64	CPreferences::sesDownData_URL;
#ifdef WEBCACHE // NEO: WC - [WebCache] -- Xanatos -->
uint64	CPreferences::sesDownData_WEBCACHE; //jp webcache statistics
uint32	CPreferences::ses_successfullPROXYREQUESTS; //jp webcache statistics
uint32	CPreferences::ses_PROXYREQUESTS;
uint32	CPreferences::ses_successfull_WCDOWNLOADS;
uint32	CPreferences::ses_WEBCACHEREQUESTS;
#endif // NEO: WC END <-- Xanatos --
uint64	CPreferences::cumDownDataPort_4662;
uint64	CPreferences::cumDownDataPort_OTHER;
uint64	CPreferences::cumDownDataPort_PeerCache;
uint64	CPreferences::sesDownDataPort_4662;
uint64	CPreferences::sesDownDataPort_OTHER;
uint64	CPreferences::sesDownDataPort_PeerCache;
float	CPreferences::cumConnAvgDownRate;
float	CPreferences::cumConnMaxAvgDownRate;
float	CPreferences::cumConnMaxDownRate;
float	CPreferences::cumConnAvgUpRate;
float	CPreferences::cumConnMaxAvgUpRate;
float	CPreferences::cumConnMaxUpRate;
time_t	CPreferences::cumConnRunTime;
uint32	CPreferences::cumConnNumReconnects;
uint32	CPreferences::cumConnAvgConnections;
uint32	CPreferences::cumConnMaxConnLimitReached;
uint32	CPreferences::cumConnPeakConnections;
uint32	CPreferences::cumConnTransferTime;
uint32	CPreferences::cumConnDownloadTime;
uint32	CPreferences::cumConnUploadTime;
uint32	CPreferences::cumConnServerDuration;
uint32	CPreferences::cumSrvrsMostWorkingServers;
uint32	CPreferences::cumSrvrsMostUsersOnline;
uint32	CPreferences::cumSrvrsMostFilesAvail;
uint32	CPreferences::cumSharedMostFilesShared;
uint64	CPreferences::cumSharedLargestShareSize;
uint64	CPreferences::cumSharedLargestAvgFileSize;
uint64	CPreferences::cumSharedLargestFileSize;
time_t	CPreferences::stat_datetimeLastReset;
UINT	CPreferences::statsConnectionsGraphRatio;
UINT	CPreferences::statsMemoryGraphRatio; // NEO: SI - [SysInfo] <-- Xanatos --
UINT	CPreferences::statsTransferGraphRatio; // NEO: SI - [SysInfo] <-- Xanatos --
UINT	CPreferences::statsSourceGraphRatio; // NEO: SI - [SysInfo] <-- Xanatos --
UINT	CPreferences::statsSaveInterval;
TCHAR	CPreferences::statsExpandedTreeItems[256];
bool	CPreferences::m_bShowVerticalHourMarkers;
uint64	CPreferences::totalDownloadedBytes;
uint64	CPreferences::totalUploadedBytes;
WORD	CPreferences::m_wLanguageID;
bool	CPreferences::transferDoubleclick;
EViewSharedFilesAccess CPreferences::m_iSeeShares;
UINT	CPreferences::m_iToolDelayTime;
bool	CPreferences::bringtoforeground;
UINT	CPreferences::splitterbarPosition;
UINT	CPreferences::splitterbarPositionSvr;
UINT	CPreferences::splitterbarPositionStat;
UINT	CPreferences::splitterbarPositionStat_HL;
UINT	CPreferences::splitterbarPositionStat_HR;
UINT	CPreferences::splitterbarPositionFriend;
UINT	CPreferences::splitterbarPositionIRC;
UINT	CPreferences::splitterbarPositionShared;
UINT	CPreferences::m_uTransferWnd1;
UINT	CPreferences::m_uTransferWnd2;
UINT	CPreferences::m_uLastCategory; // NEO: MAC - [MorphA4AFCategories] <-- Xanatos --
UINT	CPreferences::m_uDeadServerRetries;
DWORD	CPreferences::m_dwServerKeepAliveTimeout;
UINT	CPreferences::statsMax;
UINT	CPreferences::statsAverageMinutes;
CString	CPreferences::notifierConfiguration;
bool	CPreferences::notifierOnDownloadFinished;
bool	CPreferences::notifierOnNewDownload;
bool	CPreferences::notifierOnChat;
bool	CPreferences::notifierOnLog;
bool	CPreferences::notifierOnImportantError;
bool	CPreferences::notifierOnEveryChatMsg;
bool	CPreferences::notifierOnNewVersion;
ENotifierSoundType CPreferences::notifierSoundType = ntfstNoSound;
CString	CPreferences::notifierSoundFile;
TCHAR	CPreferences::m_sircserver[50];
TCHAR	CPreferences::m_sircnick[30];
TCHAR	CPreferences::m_sircchannamefilter[50];
bool	CPreferences::m_bircaddtimestamp;
bool	CPreferences::m_bircusechanfilter;
UINT	CPreferences::m_iircchanneluserfilter;
TCHAR	CPreferences::m_sircperformstring[255];
bool	CPreferences::m_bircuseperform;
bool	CPreferences::m_birclistonconnect;
bool	CPreferences::m_bircacceptlinks;
bool	CPreferences::m_bircacceptlinksfriends;
bool	CPreferences::m_bircsoundevents;
bool	CPreferences::m_bircignoremiscmessage;
bool	CPreferences::m_bircignorejoinmessage;
bool	CPreferences::m_bircignorepartmessage;
bool	CPreferences::m_bircignorequitmessage;
bool	CPreferences::m_bircignoreemuleprotoaddfriend;
bool	CPreferences::m_bircallowemuleprotoaddfriend;
bool	CPreferences::m_bircignoreemuleprotosendlink;
bool	CPreferences::m_birchelpchannel;
bool	CPreferences::m_bRemove2bin;
bool	CPreferences::m_bShowCopyEd2kLinkCmd;
bool	CPreferences::m_bpreviewprio;
bool	CPreferences::m_bSmartServerIdCheck;
uint8	CPreferences::smartidstate;
bool	CPreferences::m_bSafeServerConnect;
UINT	CPreferences::startMinimized; // NEO: MOD <-- Xanatos --
bool	CPreferences::m_bAutoStart;
bool	CPreferences::m_bRestoreLastMainWndDlg;
int		CPreferences::m_iLastMainWndDlgID;
bool	CPreferences::m_bRestoreLastLogPane;
int		CPreferences::m_iLastLogPaneID;
UINT	CPreferences::MaxConperFive;
bool	CPreferences::checkDiskspace;
UINT	CPreferences::m_uMinFreeDiskSpace;
bool	CPreferences::m_bSparsePartFiles;
CString	CPreferences::m_strYourHostname;
bool	CPreferences::m_bEnableVerboseOptions;
bool	CPreferences::m_bVerbose;
bool	CPreferences::m_bFullVerbose;
bool	CPreferences::m_bDebugSourceExchange;
bool	CPreferences::m_bLogBannedClients;
bool	CPreferences::m_bLogRatingDescReceived;
bool	CPreferences::m_bLogSecureIdent;
bool	CPreferences::m_bLogFilteredIPs;
bool	CPreferences::m_bLogFileSaving;
bool	CPreferences::m_bLogA4AF; // ZZ:DownloadManager
bool	CPreferences::m_bLogUlDlEvents;
bool	CPreferences::m_bLogAICHEvents; // NEO: MOD - [LogAICH] <-- Xanatos --
#if defined(_DEBUG) || defined(USE_DEBUG_DEVICE)
bool	CPreferences::m_bUseDebugDevice = true;
#else
bool	CPreferences::m_bUseDebugDevice = false;
#endif
int		CPreferences::m_iDebugServerTCPLevel;
int		CPreferences::m_iDebugServerUDPLevel;
int		CPreferences::m_iDebugServerSourcesLevel;
int		CPreferences::m_iDebugServerSearchesLevel;
int		CPreferences::m_iDebugClientTCPLevel;
int		CPreferences::m_iDebugClientUDPLevel;
int		CPreferences::m_iDebugClientKadUDPLevel;
int		CPreferences::m_iDebugSearchResultDetailLevel;
bool	CPreferences::m_bupdatequeuelist;
bool	CPreferences::m_bManualAddedServersHighPriority;
bool	CPreferences::m_btransferfullchunks;
int		CPreferences::m_istartnextfile;
bool	CPreferences::m_bshowoverhead;
bool	CPreferences::m_bDAP;
bool	CPreferences::m_bUAP;
bool	CPreferences::m_bDisableKnownClientList;
bool	CPreferences::m_bDisableQueueList;
bool	CPreferences::m_bExtControls;
bool	CPreferences::m_bTransflstRemain;
UINT	CPreferences::versioncheckdays;
bool	CPreferences::showRatesInTitle;
TCHAR	CPreferences::TxtEditor[MAX_PATH];
CString	CPreferences::m_strVideoPlayer;
CString CPreferences::m_strVideoPlayerArgs;
bool	CPreferences::moviePreviewBackup;
int		CPreferences::m_iPreviewSmallBlocks;
bool	CPreferences::m_bPreviewCopiedArchives;
int		CPreferences::m_iInspectAllFileTypes;
bool	CPreferences::m_bPreviewOnIconDblClk;
bool	CPreferences::indicateratings;
bool	CPreferences::watchclipboard;
bool	CPreferences::filterserverbyip;
bool	CPreferences::m_bFirstStart;
bool	CPreferences::m_bCreditSystem;
bool	CPreferences::log2disk;
bool	CPreferences::debug2disk;
int		CPreferences::iMaxLogBuff;
UINT	CPreferences::uMaxLogFileSize;
ELogFileFormat CPreferences::m_iLogFileFormat = Unicode;
bool	CPreferences::scheduler;
bool	CPreferences::dontcompressblocks; // NEO: MOD <-- Xanatos --
bool	CPreferences::dontcompressavi;
bool	CPreferences::msgonlyfriends;
bool	CPreferences::msgsecure;
UINT	CPreferences::filterlevel;
UINT	CPreferences::m_iFileBufferSize;
UINT	CPreferences::m_iFileBufferTime; // NEO: MOD - [BufferCustomisation] <-- Xanatos --
UINT	CPreferences::m_iQueueSize;
int		CPreferences::m_iCommitFiles;
UINT	CPreferences::maxmsgsessions;
uint32	CPreferences::versioncheckLastAutomatic;
CString	CPreferences::messageFilter;
CString	CPreferences::commentFilter;
CString	CPreferences::filenameCleanups;
TCHAR	CPreferences::datetimeformat[64];
TCHAR	CPreferences::datetimeformat4log[64];
LOGFONT CPreferences::m_lfHyperText;
LOGFONT CPreferences::m_lfLogText;
COLORREF CPreferences::m_crLogError = RGB(255, 0, 0);
COLORREF CPreferences::m_crLogWarning = RGB(128, 0, 128);
COLORREF CPreferences::m_crLogSuccess = RGB(0, 0, 255);
int		CPreferences::m_iExtractMetaData;
bool	CPreferences::m_bAdjustNTFSDaylightFileTime = true;
bool	CPreferences::m_bAdvWebsrv; // NEO: WAM - [WebInterfaceAccountManagement] <-- Xanatos --
TCHAR	CPreferences::m_sWebPassword[256];
TCHAR	CPreferences::m_sWebLowPassword[256];
CUIntArray CPreferences::m_aAllowedRemoteAccessIPs;
uint16	CPreferences::m_nWebPort;
bool	CPreferences::m_bWebEnabled;
bool	CPreferences::m_bWebUseGzip;
int		CPreferences::m_nWebPageRefresh;
bool	CPreferences::m_bWebLowEnabled;
TCHAR	CPreferences::m_sWebResDir[MAX_PATH];
int		CPreferences::m_iWebTimeoutMins;
int		CPreferences::m_iWebFileUploadSizeLimitMB;
bool	CPreferences::m_bAllowAdminHiLevFunc;
TCHAR	CPreferences::m_sTemplateFile[MAX_PATH];
ProxySettings CPreferences::proxy;
UINT	CPreferences::showCatTabInfos; // NEO: MOD - [MoreCategoryInfo] <-- Xanatos --
//bool	CPreferences::resumeSameCat;
bool	CPreferences::dontRecreateGraphs;
bool	CPreferences::autofilenamecleanup;
bool	CPreferences::m_bUseAutocompl;
UINT	CPreferences::m_uShowDwlPercentage; // NEO: MOD - [Percentage] <-- Xanatos --
bool	CPreferences::m_bRemoveFinishedDownloads;
UINT	CPreferences::m_iMaxChatHistory;
bool	CPreferences::m_bShowActiveDownloadsBold;
int		CPreferences::m_iSearchMethod;
bool	CPreferences::m_bAdvancedSpamfilter;
bool	CPreferences::m_bUseSecureIdent;
TCHAR	CPreferences::m_sMMPassword[256];
bool	CPreferences::m_bMMEnabled;
uint16	CPreferences::m_nMMPort;
bool	CPreferences::networkkademlia;
bool	CPreferences::networked2k;
EToolbarLabelType CPreferences::m_nToolbarLabels;
CString	CPreferences::m_sToolbarBitmap;
CString	CPreferences::m_sToolbarBitmapFolder;
CString	CPreferences::m_sToolbarSettings;
bool	CPreferences::m_bReBarToolbar;
CSize	CPreferences::m_sizToolbarIconSize;
//bool	CPreferences::m_bPreviewEnabled;
bool	CPreferences::m_bAutomaticArcPreviewStart;
#ifndef NEO_BC // NEO: NBC -- Xanatos -->
bool	CPreferences::m_bDynUpEnabled;
int		CPreferences::m_iDynUpPingTolerance;
int		CPreferences::m_iDynUpGoingUpDivider;
int		CPreferences::m_iDynUpGoingDownDivider;
int		CPreferences::m_iDynUpNumberOfPings;
int		CPreferences::m_iDynUpPingToleranceMilliseconds;
bool	CPreferences::m_bDynUpUseMillisecondPingTolerance;
#endif // NEO_BC // NEO: NBC END <-- Xanatos --
bool    CPreferences::m_bAllocFull;
// ZZ:DownloadManager -->
bool    CPreferences::m_bA4AFSaveCpu;
// ZZ:DownloadManager <--
bool    CPreferences::m_bHighresTimer;
CStringList CPreferences::shareddir_list;
CStringList CPreferences::sharedsubdir_list; // NEO: SSD - [ShareSubDirectories] <-- Xanatos --
CStringList CPreferences::sharedfile_list; // NEO: SSF - [ShareSingleFiles] <-- Xanatos --
CStringList CPreferences::addresses_list;
// NEO: MTD - [MultiTempDirectories] -- Xanatos -->
CStringList CPreferences::tempdir_list;
int		CPreferences::use_tempdir;
// NEO: MTD END <-- Xanatos --
// NEO: VSF - [VirtualSharedFiles] -- Xanatos -->
CRBMap<CString, CString> CPreferences::m_fileToVDir_map;
CRBMap<CString, CString> CPreferences::m_dirToVDir_map;
CRBMap<CString, CString> CPreferences::m_dirToVDirWithSD_map;
// NEO: VSF END <-- Xanatos --
CString CPreferences::appdir;
CString CPreferences::configdir;
CString CPreferences::m_strWebServerDir;
CString CPreferences::m_strLangDir;
CString CPreferences::m_strFileCommentsFilePath;
CString	CPreferences::m_strLogDir;
Preferences_Ext_Struct* CPreferences::prefsExt;
WORD	CPreferences::m_wWinVer;
CArray<Category_Struct*,Category_Struct*> CPreferences::catMap;
UINT	CPreferences::m_nWebMirrorAlertLevel;
bool	CPreferences::m_bRunAsUser;
bool	CPreferences::m_bPreferRestrictedOverUser;
UINT	CPreferences::m_uUseOldTimeRemaining; // NEO: MOD <-- Xanatos --
uint32	CPreferences::m_uPeerCacheLastSearch;
bool	CPreferences::m_bPeerCacheWasFound;
bool	CPreferences::m_bPeerCacheEnabled;
uint16	CPreferences::m_nPeerCachePort;
bool	CPreferences::m_bPeerCacheShow;

// bool	CPreferences::m_bOpenPortsOnStartUp; // NEO: IFWS <-- Xanatos --
int		CPreferences::m_byLogLevel;
bool	CPreferences::m_bTrustEveryHash;
bool	CPreferences::m_bRememberAICH; // NEO: MOD - [RemoveUnusedAICHhashes] <-- Xanatos --
bool	CPreferences::m_bRememberCancelledFiles;
bool	CPreferences::m_bRememberDownloadedFiles;

bool	CPreferences::m_bNotifierSendMail;
CString	CPreferences::m_strNotifierMailServer;
CString	CPreferences::m_strNotifierMailSender;
CString	CPreferences::m_strNotifierMailReceiver;

bool	CPreferences::m_bWinaTransToolbar;

bool	CPreferences::m_bCryptLayerRequested;
bool	CPreferences::m_bCryptLayerSupported;
bool	CPreferences::m_bCryptLayerRequired;

/* Xanatos:
* All Neo Preferences variables:
*/
// NCFG - [NeoConfiguration] -- Xanatos -->

#ifdef NEO_BC // NEO: NBC - [NeoBandwidthControl]
bool	CPreferencesEx::m_bManageConnections;
float	CPreferencesEx::m_fManageConnectionsFactor;

UINT	CPreferencesEx::m_uNAFCEnabled;
bool	CPreferencesEx::m_bISPCustomIP;
DWORD	CPreferencesEx::m_uISPZone;
DWORD	CPreferencesEx::m_uISPMask;
bool	CPreferencesEx::m_bBindToAdapter;


bool	CPreferencesEx::m_bCheckConnection;
bool	CPreferencesEx::m_bStaticLowestPing;
int		CPreferencesEx::m_iPingMode;
bool	CPreferencesEx::m_bNoTTL;
bool	CPreferencesEx::m_bManualHostToPing;
CString CPreferencesEx::m_sPingServer;

bool	CPreferencesEx::m_bAutoMSS;
int		CPreferencesEx::m_iMSS;

bool	CPreferencesEx::m_bUseDoubleSendSize;


bool	CPreferencesEx::m_bDirectDownload;
bool	CPreferencesEx::m_bDirectReceivingTCP;
bool	CPreferencesEx::m_bDirectReceivingUDP;
int		CPreferencesEx::m_iBCTimeDown;
int		CPreferencesEx::m_iBCPriorityDown;
UINT	CPreferencesEx::m_uSetDownloadBuffer;
int		CPreferencesEx::m_iDownloadBufferSize;

//bool	CPreferencesEx::m_bDirectUpload;
UINT	CPreferencesEx::m_uUseBlockedQueue;
bool	CPreferencesEx::m_bDirectSendingTCP;
bool	CPreferencesEx::m_bDirectSendingUDP;
int		CPreferencesEx::m_iBCTimeUp;
int		CPreferencesEx::m_iBCPriorityUp;
UINT	CPreferencesEx::m_uSetUploadBuffer;
int		CPreferencesEx::m_iUploadBufferSize;

int		CPreferencesEx::m_iDatarateSamples;

bool	CPreferencesEx::m_bIncludeOverhead;
bool	CPreferencesEx::m_bIncludeTCPAck;
bool	CPreferencesEx::m_bConnectionsOverHead;
bool	CPreferencesEx::m_bSessionRatio;


int		CPreferencesEx::m_iDownloadControl;
float	CPreferencesEx::m_fMinBCDownload;
float	CPreferencesEx::m_fMaxBCDownload;


int		CPreferencesEx::m_iUploadControl;
float	CPreferencesEx::m_fMinBCUpload;
float	CPreferencesEx::m_fMaxBCUpload;


float	CPreferencesEx::m_fMaxDownStream;
float	CPreferencesEx::m_fMaxUpStream;


bool	CPreferencesEx::m_bMinimizeOpenedSlots;
UINT	CPreferencesEx::m_uCumulateBandwidth;
UINT	CPreferencesEx::m_uBadwolfsUpload;

int		CPreferencesEx::m_iMaxReservedSlots;

bool	CPreferencesEx::m_bIncreaseTrickleSpeed;
float	CPreferencesEx::m_fIncreaseTrickleSpeed;

#ifdef NEO_UBT // NEO: BM - [BandwidthModeration]
UINT	CPreferencesEx::m_uSeparateReleaseBandwidth;
float	CPreferencesEx::m_fReleaseSlotSpeed;
float	CPreferencesEx::m_fReleaseBandwidthPercentage;

bool	CPreferencesEx::m_bSeparateFriendBandwidth;
float	CPreferencesEx::m_fFriendSlotSpeed;
float	CPreferencesEx::m_fFriendBandwidthPercentage;
#endif // NEO_UBT // NEO: BM END

bool	CPreferencesEx::m_bOpenMoreSlotsWhenNeeded;
bool	CPreferencesEx::m_bCheckSlotDatarate;

bool	CPreferencesEx::m_bIsTrickleBlocking;
bool	CPreferencesEx::m_bIsDropBlocking;

//bool	CPreferencesEx::m_bAllowOverSending;


bool	CPreferencesEx::m_bDynUpGoingDivider;
int		CPreferencesEx::m_iDynUpGoingUpDivider;
int		CPreferencesEx::m_iDynUpGoingDownDivider;

int		CPreferencesEx::m_iUpMaxPingMethod;
int		CPreferencesEx::m_iBasePingUp;
int		CPreferencesEx::m_iPingUpTolerance;
int		CPreferencesEx::m_iPingUpProzent;


bool	CPreferencesEx::m_bDynDownGoingDivider;
int		CPreferencesEx::m_iDynDownGoingUpDivider;
int		CPreferencesEx::m_iDynDownGoingDownDivider;
	
int		CPreferencesEx::m_iDownMaxPingMethod;
int		CPreferencesEx::m_iBasePingDown;
int		CPreferencesEx::m_iPingDownTolerance;
int		CPreferencesEx::m_iPingDownProzent;
#endif // NEO_BC // NEO: NBC END


bool	CPreferencesEx::m_bOnlyCompleteFiles; // NEO: OCF - [OnlyCompleetFiles]
int		CPreferencesEx::m_iToOldComplete;
bool	CPreferencesEx::m_bUseCustomPermissions; // NEO: SSP - [ShowSharePermissions]
bool	CPreferencesEx::m_bUseSaveComments; // NEO: XC - [ExtendedComments]
bool	CPreferencesEx::m_bUseKnownComments; // NEO: XCk - [ExtendedKnownComments]
UINT	CPreferencesEx::m_uInteligentChunkSelecting; // NEO: ICS - [InteligentChunkSelection]
UINT	CPreferencesEx::m_uSubChunkTransfer; // NEO: SCT - [SubChunkTransfer]
UINT	CPreferencesEx::m_uSubChunkVerification; // NEO: SCV - [SubChunkVerification]
UINT	CPreferencesEx::m_uRealPartStatus; // NEO: RPS - [RealPartStatus]
UINT	CPreferencesEx::m_uShareAlsoEmptyFiles; // NEO: SEF - [ShareAlsoEmptyFiles]

// NEO: NXI - [NeoExtraInfo]
bool	CPreferencesEx::m_bSendExtraInfo;
bool	CPreferencesEx::m_bSendExtraInfoBandwidth;
UINT	CPreferencesEx::m_uSendExtraInfoUpTime;
bool	CPreferencesEx::m_bSendExtraInfoDlFile;
UINT	CPreferencesEx::m_uSendExtraInfoUlFile;
bool	CPreferencesEx::m_bSendExtraInfoWaitingUsers;
CString	CPreferencesEx::m_sSendExtraInfoString;
// NEO: NXI END
DWORD	CPreferencesEx::m_dAppPriority;
// NEO: MOD - [NiceHash]
bool	CPreferencesEx::m_bUseHashingDelay;
int		CPreferencesEx::m_iHashingDelay;
// NEO: MOD END
// NEO: MOD - [RelaxCPU]
bool	CPreferencesEx::m_bUseProcessingDelay;
int		CPreferencesEx::m_iProcessingDelay;
// NEO: MOD END
// NEO: MOD - [RefreshShared]
bool	CPreferencesEx::m_bRefreshShared;
int		CPreferencesEx::m_iRefreshSharedIntervals;
// NEO: MOD END
bool	CPreferencesEx::m_bPauseOnFileComplete; // NEO: POFC - [PauseOnFileComplete]
bool	CPreferencesEx::m_bEstimatedDownloadTime; // NEO: EDT - [EstimatedDownloadTime] 
UINT	CPreferencesEx::m_uLowID2HighIDAutoCallback; // NEO: L2H - [LowID2HighIDAutoCallback]
UINT	CPreferencesEx::m_uAntiHideOS; // NEO: AHOS - [AntiHideOS]
// NEO: DKA - [DownloadKeepAlive]
bool	CPreferencesEx::m_bEnableDownloadKeepAlive;
int		CPreferencesEx::m_iDownloadKeepAliveTimeout;
// NEO: DKA END
// NEO: TCR - [TCPConnectionRetry]
bool	CPreferencesEx::m_bTCPConnectionRetry;
int		CPreferencesEx::m_iTCPConnectionRetry;
// NEO: TCR END
bool	CPreferencesEx::m_bTCPDisableNagle;

// NEO: NST - [NeoSourceTweaks]
int		CPreferencesEx::m_iHardLimit;
int		CPreferencesEx::m_iSwapLimit;
int		CPreferencesEx::m_iCleanUpLimit;
bool	CPreferencesEx::m_bCalcStandardLimits;

bool	CPreferencesEx::m_bXSDisable;
int		CPreferencesEx::m_iXSLimit;
int		CPreferencesEx::m_iXSIntervals;
int		CPreferencesEx::m_iXSClientIntervals;
int		CPreferencesEx::m_iXSAnswerLimit;
int		CPreferencesEx::m_iXSDelayValue;

bool	CPreferencesEx::m_bSVRDisable;
int		CPreferencesEx::m_iSVRLimit;
int		CPreferencesEx::m_iSVRIntervals;

bool	CPreferencesEx::m_bKADDisable;
int		CPreferencesEx::m_iKADLimit;
int		CPreferencesEx::m_iKADIntervals;
int		CPreferencesEx::m_iKADAmount;
int		CPreferencesEx::m_iKADDelayValue;

bool	CPreferencesEx::m_bUDPDisable;
int		CPreferencesEx::m_iUDPLimit;
int		CPreferencesEx::m_iUDPIntervals;
int		CPreferencesEx::m_iGlobalUDPIntervals;
int		CPreferencesEx::m_iUDPAmount;
// NEO: XUC - [ExtendedUdpCache]
UINT	CPreferencesEx::m_uUDPCache;
int		CPreferencesEx::m_iUDPCache;
// NEO: XUC END
int		CPreferencesEx::m_iRareFileLimit;
// NEO: NST END

// NEO: NSD - [NeoSourceDrop]
int		CPreferencesEx::m_iLow2LowCleanUpTime;
#if defined(NEO_SK) || defined(NEO_SS) // NEO: NSK - [NeoSourceKeeper] // NEO: NSS - [NeoSourceStorage]
int		CPreferencesEx::m_iBadCleanUpTime;
int		CPreferencesEx::m_iGoneCleanUpTime;
int		CPreferencesEx::m_iSuspendCleanUpTime;
#endif // NEO_SK // NEO_SS // NEO: NSK END // NEO: NSS END
int		CPreferencesEx::m_iNnPCleanUpTime;
int		CPreferencesEx::m_iFullQCleanUpTime;
// NEO: NSD END

// NEO: SR - [SpreadReask]
bool	CPreferencesEx::m_bSpreadReask;
int		CPreferencesEx::m_iSpreadReask;
// NEO: SR END

// NEO: OCC - [ObelixConnectionControl]
bool	CPreferencesEx::m_bObelixConnectionControl;
int		CPreferencesEx::m_iObelixConnectionControlValue;
// NEO: OCC END

// NEO: ASL - [AutoSoftLock]
bool	CPreferencesEx::m_bAutoSoftLock;
int		CPreferencesEx::m_iAutoSoftLockValue;
// NEO: ASL END

// NEO: AHL - [AutoHardLimit]
int		CPreferencesEx::m_iAutoHardLimit;
int		CPreferencesEx::m_iGlobalHardLimit;
int		CPreferencesEx::m_iMinimalHardLimit;
int		CPreferencesEx::m_iAutoHardLimitTimer;
// NEO: AHL END

// NEO: XSC - [ExtremeSourceCache]
bool	CPreferencesEx::m_bSourceCache;
int		CPreferencesEx::m_iSourceCacheLimit;
int		CPreferencesEx::m_iSourceCacheTime;
// NEO: XSC END

// NEO: DR - [DownloadReask]
int		CPreferencesEx::m_iReaskIntervals;

bool	CPreferencesEx::m_bDontNnPReask;
int		CPreferencesEx::m_iNnPReaskIntervals;

bool	CPreferencesEx::m_bDontFullQReask;
int		CPreferencesEx::m_iFullQReaskIntervals;
// NEO: DR END

#ifdef NEO_SK // NEO: NSK - [NeoSourceKeeper]
bool	CPreferencesEx::m_bEnableSourceKeeper;
#endif // NEO_SK // NEO: NSK END
#ifdef NEO_SS // NEO: NSS - [NeoSourceStorage]
bool	CPreferencesEx::m_bEnableSourceStorage;
UINT	CPreferencesEx::m_uAutoSaveSources;
int		CPreferencesEx::m_iAutoSaveSourcesIntervals;
int		CPreferencesEx::m_iSourceStorageLimit;
UINT	CPreferencesEx::m_bAutoLoadStoredSources;
bool	CPreferencesEx::m_bUseStorageBootstrap;
int		CPreferencesEx::m_iStorageBootstrapTime;
int		CPreferencesEx::m_iStorageBootstrapRequirement;
bool	CPreferencesEx::m_bStoreLowIDSources;
bool	CPreferencesEx::m_bStoreAlsoA4AFSources;
UINT	CPreferencesEx::m_uStoreSourcesFileStatus;

bool	CPreferencesEx::m_bAutoReaskStoredSources;
int		CPreferencesEx::m_iAutoReaskStoredSourcesLimit;
bool	CPreferencesEx::m_bTotalSourceRestore;
bool	CPreferencesEx::m_bUseAutoReaskStoredSourcesDelay;
int		CPreferencesEx::m_iAutoReaskStoredSourcesDelay;

int		CPreferencesEx::m_iAutoReaskLoadedSourcesDelay;

bool	CPreferencesEx::m_bGroupStoredSourceReask;
int		CPreferencesEx::m_iStoredSourceGroupIntervals;
int		CPreferencesEx::m_iStoredSourceGroupSize;

bool	CPreferencesEx::m_bUseSmoothOutOfDate;
int		CPreferencesEx::m_iMaxStoredFaildCount;
int		CPreferencesEx::m_iStoredOutOfDate;
#endif // NEO_SS // NEO: NSS END
#ifdef NEO_CD // NEO: NCD - [NeoClientDatabase]
bool	CPreferencesEx::m_bEnableSourceList;
UINT	CPreferencesEx::m_uSaveGlobalSourceList;
int		CPreferencesEx::m_iGlobalSourceListCleanUpTime;
bool	CPreferencesEx::m_bGlobalSourceListCleanUp;
int		CPreferencesEx::m_iGlobalSourceListCleanUpIntervals;
bool	CPreferencesEx::m_bFastSourceCleanUp;
bool	CPreferencesEx::m_bSaveSourceFileList;
int		CPreferencesEx::m_iSourceFileListCleanUpTime;
bool	CPreferencesEx::m_bSaveSourceDataInClient;

bool	CPreferencesEx::m_bIPZoneCheck;

bool	CPreferencesEx::m_bSourceHashMonitor;
int		CPreferencesEx::m_iSourceHashMonitorBadTime;
int		CPreferencesEx::m_iSourceHashMonitorMaxBad;

int		CPreferencesEx::m_iTableAmountToStore;

int		CPreferencesEx::m_iIgnoreUnreachableInterval;
int		CPreferencesEx::m_iIgnoreUndefinedInterval;
int		CPreferencesEx::m_iBeginNewTableInterval;
#endif // NEO_CD // NEO: NCD END
#ifdef NEO_SA // NEO: NSA - [NeoSourceAnaliser]
bool	CPreferencesEx::m_bEnableSourceAnalizer;
int		CPreferencesEx::m_iAnaliseIntervals;
int		CPreferencesEx::m_iTableAmountToAnalise;

bool	CPreferencesEx::m_bDontStoreTemporarySources;

int		CPreferencesEx::m_iPropabilityMode;
float	CPreferencesEx::m_fEnhancedFactor;

int		CPreferencesEx::m_iReaskPropability;
int		CPreferencesEx::m_iReservePropability;

bool	CPreferencesEx::m_bAutoReserveReask;
int		CPreferencesEx::m_iReserveReaskPropability;
bool	CPreferencesEx::m_bUseReaskReserveSourcesDelay;
int		CPreferencesEx::m_iReaskReserveSourcesDelay;
int		CPreferencesEx::m_iReaskReserveSourcesLimit;

bool	CPreferencesEx::m_bAutoTemporaryReask;
int		CPreferencesEx::m_iTemporaryReaskPropability;
bool	CPreferencesEx::m_bUseReaskTemporarySourcesDelay;
int		CPreferencesEx::m_iReaskTemporarySourcesDelay;
int		CPreferencesEx::m_iReaskTemporarySourcesLimit;

//int		CPreferencesEx::m_iMinAnalisisQuality;

//bool	CPreferencesEx::m_bAutoUnsureReask;
//bool	CPreferencesEx::m_bUseReaskUnsureSourcesDelay;
//int		CPreferencesEx::m_iReaskUnsureSourcesDelay;
//int		CPreferencesEx::m_iReaskUnsureSourcesLimit;

bool	CPreferencesEx::m_bUseUnpredictedPropability;
int		CPreferencesEx::m_iUnpredictedPropability;
bool	CPreferencesEx::m_bUseReaskUnpredictedSourcesDelay;
int		CPreferencesEx::m_iReaskUnpredictedSourcesDelay;
int		CPreferencesEx::m_iReaskUnpredictedSourcesLimit;

UINT	CPreferencesEx::m_uFailTolerance;
int		CPreferencesEx::m_iMaxFailTolerance;
UINT	CPreferencesEx::m_uRetryUnreachable;
int		CPreferencesEx::m_iRetryUnreachableIntervals;
int		CPreferencesEx::m_iUnreachableReaskPropability;
int		CPreferencesEx::m_iReaskUnreachableSourcesLimit;

bool	CPreferencesEx::m_bHandleTableGaps;
float	CPreferencesEx::m_fPriorityGapRatio;
int		CPreferencesEx::m_iMaxGapSize;
int		CPreferencesEx::m_iMaxGapTime;
bool	CPreferencesEx::m_bCheckPriorityIP;
float	CPreferencesEx::m_fPriorityIPRatio;
bool	CPreferencesEx::m_bCheckPortIntegrity;
float	CPreferencesEx::m_fPortIntegrityRatio;
float	CPreferencesEx::m_fMaxMidleDiscrepanceHigh;
float	CPreferencesEx::m_fMaxMidleDiscrepanceLow;
int		CPreferencesEx::m_iLastSeenDurationThreshold;
UINT	CPreferencesEx::m_uLinkTimePropability;
int		CPreferencesEx::m_iLinkTimeThreshold;
bool	CPreferencesEx::m_bUseDualLinkedTableGravity;
int		CPreferencesEx::m_iDualLinkedTableGravity;
bool	CPreferencesEx::m_bReliableTimeMagnification;
int		CPreferencesEx::m_iMaxReliableTime;
int		CPreferencesEx::m_iTempralIPBorderLine;
#endif // NEO_SA // NEO: NSA END

// NEO: DS - [DropSources]
UINT	CPreferencesEx::m_uDropNnP;
int		CPreferencesEx::m_iDropNnPLimit;
int		CPreferencesEx::m_iDropNnPLimitMode;
int		CPreferencesEx::m_iDropNnPTimer;

UINT	CPreferencesEx::m_uDropFullQ;
int		CPreferencesEx::m_iDropFullQLimit;
int		CPreferencesEx::m_iDropFullQLimitMode;
int		CPreferencesEx::m_iDropFullQTimer;

UINT	CPreferencesEx::m_uDropHighQ;
int		CPreferencesEx::m_iDropHighQValue;
int		CPreferencesEx::m_iDropHighQLimit;
int		CPreferencesEx::m_iDropHighQLimitMode;
int		CPreferencesEx::m_iDropHighQTimer;

bool	CPreferencesEx::m_bUseDontAskThisIP;
int		CPreferencesEx::m_iDontAskThisIPTime;
// NEO: DS END

// NEO: NSD - [NeoSourceDrop]
#ifdef NEO_SK // NEO: NSK - [NeoSourceKeeper]
bool	CPreferencesEx::m_bDropUnreachable;
int		CPreferencesEx::m_iDropUnreachableLimit;
int		CPreferencesEx::m_iDropUnreachableLimitMode;
int		CPreferencesEx::m_iDropUnreachableTimer;
#endif // NEO_SK // NEO: NSK END
#ifdef NEO_SS // NEO: NSS - [NeoSourceStorage]
bool	CPreferencesEx::m_bDropOutOfDate;
bool	CPreferencesEx::m_bDropOutOfDateSmooth;
int		CPreferencesEx::m_iDropOutOfDateFails;
int		CPreferencesEx::m_iDropOutOfDateTime;
int		CPreferencesEx::m_iDropOutOfDateLimit;
int		CPreferencesEx::m_iDropOutOfDateLimitMode;
int		CPreferencesEx::m_iDropOutOfDateTimer;
#endif // NEO_SS // NEO: NSS END
#ifdef NEO_SA // NEO: NSA - [NeoSourceAnaliser]
bool	CPreferencesEx::m_bDropRetired;
int		CPreferencesEx::m_iDropRetiredLimit;
int		CPreferencesEx::m_iDropRetiredLimitMode;
int		CPreferencesEx::m_iDropRetiredTimer;

bool	CPreferencesEx::m_bDropLoaded;
int		CPreferencesEx::m_iDropLoadedLimit;
int		CPreferencesEx::m_iDropLoadedLimitMode;
int		CPreferencesEx::m_iDropLoadedTimer;
#endif // NEO_SA // NEO: NSA END
// NEO: NSD END

// NEO: NCAP - [NeoCustomAutoPriority]
bool	CPreferencesEx::m_bDynamicAutoDownPriority;
float	CPreferencesEx::m_fDynamicDownPriorityFactor;
int		CPreferencesEx::m_iLowDownPrioThreshold;
int		CPreferencesEx::m_iHighDownPrioThreshold;
// NEO: NCAP END

UINT	CPreferencesEx::m_uPartTraffic; // NEO: NPT - [NeoPartTraffic]
int		CPreferencesEx::m_iPartTrafficColor; // NEO: NPT - [NeoPartTraffic]
bool	CPreferencesEx::m_bClassicShareStatusBar;

bool	CPreferencesEx::m_bSaveUploadQueueWaitTime; // NEO: SQ - [SaveUploadQueue]

// NEO: TQ - [TweakUploadQueue]
bool	CPreferencesEx::m_bInfiniteQueue;

UINT	CPreferencesEx::m_uQueueOverFlowRelease;
int		CPreferencesEx::m_iQueueOverFlowRelease;

UINT	CPreferencesEx::m_uQueueOverFlowEx;
int		CPreferencesEx::m_iQueueOverFlowEx;

UINT	CPreferencesEx::m_uQueueOverFlowDef;
int		CPreferencesEx::m_iQueueOverFlowDef;

UINT	CPreferencesEx::m_uQueueOverFlowCF;
int		CPreferencesEx::m_iQueueOverFlowCF;
// NEO: TQ END

bool	CPreferencesEx::m_bUseMultiQueue; // NEO: MQ - [MultiQueue]
bool	CPreferencesEx::m_bUseRandomQueue; // NEO: RQ - [RandomQueue]

bool	CPreferencesEx::m_bOldPrioritySystem;

// NEO: NMFS - [NiceMultiFriendSlots]
bool	CPreferencesEx::m_bFriendSlotLimit;
int		CPreferencesEx::m_iFriendSlotLimit;
// NEO: NMFS END

// NEO: RT - [ReleaseTweaks]
int		CPreferencesEx::m_iReleaseLevel; 
int 	CPreferencesEx::m_iReleaseMode;

int		CPreferencesEx::m_iReleaseLimitMode; 
bool	CPreferencesEx::m_bReleaseLimitUnion;
int		CPreferencesEx::m_iReleaseLimitCompleteMode; 

int		CPreferencesEx::m_iReleaseLimit; 
int		CPreferencesEx::m_iReleaseLimitHigh; 
int		CPreferencesEx::m_iReleaseLimitLow; 

int		CPreferencesEx::m_iReleaseLimitComplete; 
int		CPreferencesEx::m_iReleaseLimitCompleteHigh; 
int		CPreferencesEx::m_iReleaseLimitCompleteLow; 

bool	CPreferencesEx::m_bLimitUnion;

int		CPreferencesEx::m_iSourceLimitMode; 
bool	CPreferencesEx::m_bSourceLimitUnion;
int		CPreferencesEx::m_iSourceLimitCompleteMode; 

int		CPreferencesEx::m_iSourceLimit; 
int		CPreferencesEx::m_iSourceLimitHigh; 
int		CPreferencesEx::m_iSourceLimitLow; 

int		CPreferencesEx::m_iSourceLimitComplete; 
int		CPreferencesEx::m_iSourceLimitCompleteHigh; 
int		CPreferencesEx::m_iSourceLimitCompleteLow; 

bool	CPreferencesEx::m_bReleaseNeedComplete; 
int		CPreferencesEx::m_iReleaseNeedCompleteLimit; 

UINT	CPreferencesEx::m_uReleaseSlotLimit;
int		CPreferencesEx::m_iReleaseSlotLimit;
// NEO: RT END

// NEO: NCAP - [NeoCustomAutoPriority]
bool	CPreferencesEx::m_bDynamicAutoUpPriority;
float	CPreferencesEx::m_fDynamicUpPriorityFactor;
int		CPreferencesEx::m_iLowUpPrioThreshold;
int		CPreferencesEx::m_iHighUpPrioThreshold;
// NEO: NCAP END

// NEO: PRSF - [PushSmallRareFiles]
bool	CPreferencesEx::m_bPushSmallFiles;
int		CPreferencesEx::m_iPushSmallFilesSize;

bool	CPreferencesEx::m_bPushRareFiles;
int		CPreferencesEx::m_iPushRareFilesValue;

bool	CPreferencesEx::m_bPushRatioFiles;
int		CPreferencesEx::m_iPushRatioFilesValue;
// NEO: PRSF END

bool	CPreferencesEx::m_bNeoScoreSystem; // NEO: NFS - [NeoScoreSystem]
bool	CPreferencesEx::m_bNeoCreditSystem; // NEO: NCS - [NeoCreditSystem]
int		CPreferencesEx::m_iOtherCreditSystem; // NEO: OCS - [OtherCreditSystems]

// NEO: IPS - [InteligentPartSharing]
bool	CPreferencesEx::m_bInteligentPartSharing;
int		CPreferencesEx::m_iInteligentPartSharingTimer;
int 	CPreferencesEx::m_iMaxProzentToHide;

int		CPreferencesEx::m_iHideOverAvaliblyParts;
int		CPreferencesEx::m_iHideOverAvaliblyMode;
float	CPreferencesEx::m_fHideOverAvaliblyValue;
int		CPreferencesEx::m_iHideOverAvaliblyCatch;

int		CPreferencesEx::m_iHideOverSharedParts;
int		CPreferencesEx::m_iHideOverSharedMode;
float	CPreferencesEx::m_fHideOverSharedValue;
int		CPreferencesEx::m_iHideOverSharedCalc;
	
int		CPreferencesEx::m_iDontHideUnderAvaliblyParts;
int		CPreferencesEx::m_iDontHideUnderAvaliblyMode;
float	CPreferencesEx::m_fDontHideUnderAvaliblyValue;

int		CPreferencesEx::m_iBlockHighOverAvaliblyParts;
float	CPreferencesEx::m_fBlockHighOverAvaliblyFactor;

int		CPreferencesEx::m_iBlockHighOverSharedParts;
float	CPreferencesEx::m_fBlockHighOverSharedFactor;

int		CPreferencesEx::m_iShowAlwaysNeeded;
int		CPreferencesEx::m_iShowAlwaysParts;

int		CPreferencesEx::m_iShowAlwaysIncomplete;
// NEO: IPS END

CString	CPreferencesEx::m_sCommunity; // NEO: NC - [NiceCommunity]

#ifdef ARGOS // NEO: NA - [NeoArgos]
bool	CPreferencesEx::m_bUseArgosSystem;

int		CPreferencesEx::m_iCreditCompensation;

bool	CPreferencesEx::m_bTrustUnArgosHashThief;
bool	CPreferencesEx::m_bTrustUnArgosHashChanged;
bool	CPreferencesEx::m_bTrustUnArgosGhostMode;
bool	CPreferencesEx::m_bTrustUnArgosAgressiv;
int		CPreferencesEx::m_iArgosTrustTime;

UINT	CPreferencesEx::m_uCloseMaellaBackdoor;

UINT	CPreferencesEx::m_uDontBanFriends;
UINT	CPreferencesEx::m_uDontBanCommunity;

int		CPreferencesEx::m_iArgosProcessTime;
int		CPreferencesEx::m_iArgosTrackTime;
int		CPreferencesEx::m_iArgosGenericBanTime;
int		CPreferencesEx::m_iArgosCorruptedSenderTime;
int		CPreferencesEx::m_iArgosFileScannerTime;
int		CPreferencesEx::m_iArgosFileFakerTime;
int		CPreferencesEx::m_iArgosAgressionBanTime;
int		CPreferencesEx::m_iArgosOpCodeTime;
int		CPreferencesEx::m_iArgosHashChangedTime;
int		CPreferencesEx::m_iArgosRankFlooderTime;
int		CPreferencesEx::m_iArgosGhostModeTime;	
int		CPreferencesEx::m_iArgosFailedTime;
int		CPreferencesEx::m_iArgosXSExploitTime;
int		CPreferencesEx::m_iArgosNickChangerTime;
int		CPreferencesEx::m_iArgosModChangerTime;
int		CPreferencesEx::m_iArgosSpamTime;
int		CPreferencesEx::m_iArgosBadHelloTime;
int		CPreferencesEx::m_iArgosBadProtTime;

int		CPreferencesEx::m_iArgosGPLBreakerPunishment;
int		CPreferencesEx::m_iArgosHardLeecherPunishment;
int		CPreferencesEx::m_iArgosNormalLeecherPunishment;
int		CPreferencesEx::m_iArgosSoftLeecherPunishment;
int		CPreferencesEx::m_iArgosBadModPunishment;
int		CPreferencesEx::m_iArgosNickThiefPunishment;
int		CPreferencesEx::m_iArgosModThiefPunishment;
int		CPreferencesEx::m_iArgosHashThiefPunishment;
int		CPreferencesEx::m_iArgosCreditHackPunishment;
int		CPreferencesEx::m_iArgosHashChangedPunishment;
int		CPreferencesEx::m_iArgosGhostModePunishment;
int		CPreferencesEx::m_iArgosFakeClientPunishment;
int		CPreferencesEx::m_iArgosAgressonPunishment;
int		CPreferencesEx::m_iArgosFileScannerPunishment;
int		CPreferencesEx::m_iArgosFileFakerPunishment;
int		CPreferencesEx::m_iArgosCorruptedSenderPunishment;
int		CPreferencesEx::m_iArgosRankFlooderPunishment;
int		CPreferencesEx::m_iArgosFailedPunishment;
int		CPreferencesEx::m_iArgosXSExploitPunishment;
int		CPreferencesEx::m_iArgosNickChangerPunishment;
int		CPreferencesEx::m_iArgosModChangerPunishment;
int		CPreferencesEx::m_iArgosSpamPunishment;
int		CPreferencesEx::m_iArgosBadHelloPunishment;
int		CPreferencesEx::m_iArgosBadProtPunishment;

bool	CPreferencesEx::m_bArgosLeecherModDetection;
UINT	CPreferencesEx::m_uArgosLeecherNickDetection;
int		CPreferencesEx::m_iArgosDetectionLevel;
bool	CPreferencesEx::m_bArgosOpcodeDetection;
bool	CPreferencesEx::m_bArgosLeecherHashDetection;
bool	CPreferencesEx::m_bArgosNickThiefDetection;
bool	CPreferencesEx::m_bPlainAntiNickThief;
bool	CPreferencesEx::m_bArgosModThiefDetection;
bool	CPreferencesEx::m_bArgosHashThiefDetection;
bool	CPreferencesEx::m_bArgosThiefZoneDetection;
bool	CPreferencesEx::m_bArgosCreditHackDetection;
bool	CPreferencesEx::m_bHashChangeDetection;
int		CPreferencesEx::m_iHashChangeDetectionMode;
bool	CPreferencesEx::m_bArgosGhostModDetection;
UINT	CPreferencesEx::m_uArgosFakeClientDetection;
UINT	CPreferencesEx::m_uAgressionDetection;
int		CPreferencesEx::m_iAgressionIntervals;
int		CPreferencesEx::m_iAgressionThreshold;
bool	CPreferencesEx::m_bFileScannerDetection;
bool	CPreferencesEx::m_bFileFakerDetection;
bool	CPreferencesEx::m_bBadSenderDetection;
bool	CPreferencesEx::m_bRankFloodDetection;
bool	CPreferencesEx::m_bFailedDetection;
int		CPreferencesEx::m_iFailedTries;
int		CPreferencesEx::m_iFailedThreshold;
bool	CPreferencesEx::m_bXSExploitDetection;
int		CPreferencesEx::m_iXSExploitIntervals;
int		CPreferencesEx::m_iXSExploitThreshold;
bool	CPreferencesEx::m_bNickChangerDetection;
int		CPreferencesEx::m_iNickChangeIntervals;
int		CPreferencesEx::m_iNickChangeThreshold;
bool	CPreferencesEx::m_bModChangerDetection;
int		CPreferencesEx::m_iModChangeIntervals;
int		CPreferencesEx::m_iModChangeThreshold;
bool	CPreferencesEx::m_bSpamDetection;
bool	CPreferencesEx::m_bBadHelloDetection;
//bool	CPreferencesEx::m_bMD4HelloDetection;
UINT	CPreferencesEx::m_ueMCryptDetection;
bool	CPreferencesEx::m_bBadProtDetection;
UINT	CPreferencesEx::m_uDLPDetection;

bool	CPreferencesEx::m_bArgosLogLeechers;
#endif // ARGOS // NEO: NA END

bool	CPreferencesEx::m_bUseChunkDots; // NEO: MOD - [ChunkDots]
bool	CPreferencesEx::m_bUseRelativeChunkDisplay; // NEO: MOD - [RelativeChunkDisplay]
bool	CPreferencesEx::m_bUseTreeStyle; // NEO: NTS - [NeoTreeStyle]
bool	CPreferencesEx::m_bShowFileTypeIcon; // NEO: NI - [NewIcons]
bool	CPreferencesEx::m_bShowFileStatusIcons; // NEO: FSI - [FileStatusIcons]
bool	CPreferencesEx::m_bCollorShareFiles;
bool	CPreferencesEx::m_bShowBanner;
bool	CPreferencesEx::m_bShowHashProgres;
UINT	CPreferencesEx::m_uUsePlusSpeedMeter; // NEO: PSM - [PlusSpeedMeter]
// NEO: NSTI - [NewSystemTrayIcon]
bool	CPreferencesEx::m_bShowSystemTrayUpload;
bool	CPreferencesEx::m_bThinSystemTrayBars;
int		CPreferencesEx::m_iTrayBarsMaxCollor;
// NEO: NSTI END
bool	CPreferencesEx::m_bStaticTrayIcon; // NEO: STI - [StaticTray]
UINT	CPreferencesEx::m_uDisableAutoSort; // NEO: SE - [SortExtension]
UINT	CPreferencesEx::m_uShowClientPercentage; // NEO: MOD - [Percentage]

// NEO: SI - [SysInfo]
bool	CPreferencesEx::m_bDrawSysInfoGraph;
bool	CPreferencesEx::m_bShowSysInfoOnTitle;
// NEO: SI END

// NEO: NTB - [NeoToolbarButtons]
UINT	CPreferencesEx::m_uNeoToolbar;
int		CPreferencesEx::m_iNeoToolbarButtonCount;
CArray<UINT> CPreferencesEx::m_NeoToolbarButtons;
// NEO: NTB END
	
// NEO: CTB - [CoolToolBar]
bool	CPreferencesEx::m_bCoolToolbar;
UINT	CPreferencesEx::m_uCoolToolbarText;
int		CPreferencesEx::m_iCoolToolbarCenter;
int		CPreferencesEx::m_iCoolToolbarRight;
int		CPreferencesEx::m_iCoolToolbarButtonCount;
CArray<UINT> CPreferencesEx::m_CoolToolbarButtons;
// NEO: CTB END

// NEO: NMX - [NeoMenuXP]
bool	CPreferencesEx::m_bShowXPSideBar;
bool	CPreferencesEx::m_bShowXPBitmap;
int 	CPreferencesEx::m_iXPMenuStyle;
bool	CPreferencesEx::m_bGrayMenuIcon;
// NEO: NMX END

// NEO: MM - [NeoMiniMule]
bool	CPreferencesEx::m_bEnableMiniMule;
bool	CPreferencesEx::m_bAutoShowMiniMule;
bool	CPreferencesEx::m_bMiniMuleOnTop;
bool	CPreferencesEx::m_bUpdateHidenMiniMule;
UINT	CPreferencesEx::m_uMiniMuleTransparency;
bool	CPreferencesEx::m_bMiniMuleBack;
CString	CPreferencesEx::m_sMiniMuleLabel;
// NEO: MM END

// NEO: IM - [InvisibelMode]
bool	CPreferencesEx::m_bInvisibleMode;		
UINT	CPreferencesEx::m_iInvisibleModeHotKeyModifier;
TCHAR	CPreferencesEx::m_cInvisibleModeHotKey;
// NEO: IM END

// NEO: TPP - [TrayPasswordProtection]
bool	CPreferencesEx::m_bTrayPasswordProtection;
CString	CPreferencesEx::m_sTrayPassword;
// NEO: TPP END

bool	CPreferencesEx::m_bShowMyFullInfo;

bool	CPreferencesEx::m_bSmoothStatisticsGraphs;

// NEO: MMR - [MorphMassRemane]
int      CPreferencesEx::m_SimpleCleanupOptions;
CString  CPreferencesEx::m_SimpleCleanupSearch;
CString  CPreferencesEx::m_SimpleCleanupReplace;
CString  CPreferencesEx::m_SimpleCleanupSearchChars;
CString  CPreferencesEx::m_SimpleCleanupReplaceChars;
// NEO: MMR END

// NEO: CRC - [MorphCRCTag]
bool	CPreferencesEx::m_bDontAddCRCToFilename;
bool	CPreferencesEx::m_bCRC32ForceUppercase;
bool	CPreferencesEx::m_bCRC32ForceAdding;
CString	CPreferencesEx::m_sCRC32Prefix;
CString	CPreferencesEx::m_sCRC32Suffix;
// NEO: CRC END

int		CPreferencesEx::m_iMaxUploadSlots;
int		CPreferencesEx::m_iMinUploadSlots;
float	CPreferencesEx::m_fUploadPerSlots;

// NEO: QS - [QuickStart]
UINT	CPreferencesEx::m_uQuickStart;
int		CPreferencesEx::m_iQuickStartTime;
int		CPreferencesEx::m_iQuickStartTimePerFile;
UINT	CPreferencesEx::m_iQuickMaxConperFive;
UINT	CPreferencesEx::m_iQuickMaxHalfOpen;
UINT	CPreferencesEx::m_iQuickMaxConnections;

bool	CPreferencesEx::m_bOnQuickStart;
// NEO: QS END

// NEO: RIC - [ReaskOnIDChange]
UINT	CPreferencesEx::m_uCheckIPChange;
bool	CPreferencesEx::m_bInformOnIPChange;
bool	CPreferencesEx::m_bReAskOnIPChange;
bool	CPreferencesEx::m_bQuickStartOnIPChange; // NEO: QS - [QuickStart]
bool	CPreferencesEx::m_bCheckL2HIDChange;
bool	CPreferencesEx::m_bReconnectKadOnIPChange;
bool	CPreferencesEx::m_bRebindSocketsOnIPChange;
// NEO: RIC END

// NEO: RLD - [ReconnectOnLowID]
bool	CPreferencesEx::m_bReConnectOnLowID;
int		CPreferencesEx::m_iReConnectOnLowID;
// NEO: RLD END

// NEO: RKF - [RecheckKadFirewalled]
bool	CPreferencesEx::m_bRecheckKadFirewalled;
int		CPreferencesEx::m_iRecheckKadFirewalled;
// NEO: RKF END

#ifdef LANCAST // NEO: NLC - [NeoLanCast]
bool	CPreferencesEx::m_bLancastEnabled;

uint16	CPreferencesEx::m_iMaxLanDownload;
bool	CPreferencesEx::m_bDirectLanDownload;
bool	CPreferencesEx::m_bSetLanDownloadBuffer;
int		CPreferencesEx::m_iLanDownloadBufferSize;

uint16	CPreferencesEx::m_iMaxLanUpload;
bool	CPreferencesEx::m_bDirectLanUpload;
bool	CPreferencesEx::m_bSetLanUploadBuffer;
int		CPreferencesEx::m_iLanUploadBufferSize;

int		CPreferencesEx::m_iMaxLanUploadSlots;

bool	CPreferencesEx::m_bCustomizedLanCast;
CString	CPreferencesEx::m_sLanCastGroup;
uint16	CPreferencesEx::m_uLanCastPort;

bool	CPreferencesEx::m_bCustomLanCastAdapter;
DWORD	CPreferencesEx::m_uLanCastAdapterIPAdress;
DWORD	CPreferencesEx::m_uLanCastAdapterSubNet;

int		CPreferencesEx::m_iLANIntervals;

int		CPreferencesEx::m_iLanReaskIntervals;
int		CPreferencesEx::m_iNnPLanReaskIntervals;

bool	CPreferencesEx::m_bAutoBroadcastLanFiles;
int		CPreferencesEx::m_iAutoBroadcastLanFiles;

bool	CPreferencesEx::m_bUseLanMultiTransfer;
#endif //LANCAST // NEO: NLC END

#ifdef VOODOO // NEO: VOODOO - [UniversalPartfileInterface]
bool	CPreferencesEx::m_bUseVoodooTransfer;
bool	CPreferencesEx::m_bSlaveAllowed;
bool	CPreferencesEx::m_bSlaveHosting;

CString	CPreferencesEx::m_sVoodooSpell;
uint16	CPreferencesEx::m_nVoodooPort;

UINT	CPreferencesEx::m_uAutoConnectVoodoo;

UINT	CPreferencesEx::m_uUseVirtualVoodooFiles;
bool	CPreferencesEx::m_bHideVoodooFiles;

UINT	CPreferencesEx::m_uUseVoodooSourceExchange;

bool	CPreferencesEx::m_bUseVoodooSearch;

bool	CPreferencesEx::m_bVoodooNeoCommands;
bool	CPreferencesEx::m_bVoodooNeoPreferences;

UINT	CPreferencesEx::m_uVoodooCastEnabled;

UINT	CPreferencesEx::m_uSearchForSlaves;
UINT	CPreferencesEx::m_uSearchForMaster;
int		CPreferencesEx::m_iVoodooSearchIntervals;
#endif // VOODOO // NEO: VOODOO END

#ifdef A4AF_CATS // NEO: MAC - [MorphA4AFCategories]
bool	CPreferencesEx::m_bShowCatNames;
UINT	CPreferencesEx::m_uShowCategoryFlags;
bool	CPreferencesEx::m_bActiveCatDefault;
bool	CPreferencesEx::m_bSelCatOnAdd;
bool	CPreferencesEx::m_bAutoSetResumeOrder;
bool	CPreferencesEx::m_bSmallFileDLPush;
int		CPreferencesEx::m_iSmallFileDLPush;
bool	CPreferencesEx::m_bStartDLInEmptyCats;
int		CPreferencesEx::m_iStartDLInEmptyCats;
bool	CPreferencesEx::m_bUseAutoCat;
bool	CPreferencesEx::m_bCheckAlreadyDownloaded;

bool	CPreferencesEx::m_bStartNextFileByPriority;

bool	CPreferencesEx::m_bSmartA4AFSwapping;
int		CPreferencesEx::m_iAdvancedA4AFMode; // 0 = disabled, 1 = balance, 2 = stack
#endif // A4AF_CATS // NEO: MAC END

UINT	CPreferencesEx::m_uUseLugdunumCredits; // NEO: KLC - [KhaosLugdunumCredits]
bool	CPreferencesEx::m_bPreferShareAll; // NEO: PSA - [PreferShareAll]
// NEO: ASF - [AdvancedServerFilter]
bool	CPreferencesEx::m_bDontRemoveStaticServers;
bool	CPreferencesEx::m_bServerFilterAutoDel;
int		CPreferencesEx::m_iServerFilter;
CString CPreferencesEx::m_sServerFilterVal;
bool	CPreferencesEx::m_bServerFilterDataless;
// NEO: ASF END

#ifdef IP2COUNTRY // NEO: IP2C - [IP2Country]
int		CPreferencesEx::m_iIP2CountryNameMode;
UINT	CPreferencesEx::m_uIP2CountryShowFlag;
#endif // IP2COUNTRY // NEO: IP2C END
bool	CPreferencesEx::m_bUseFakeCheck; // NEO: FC - [FakeCheck]

// NEO: FDC - [FileNameDisparityCheck]
bool	CPreferencesEx::m_bUseFileCheck;
int		CPreferencesEx::m_iFileCheckSensitivity;
bool	CPreferencesEx::m_bUseFileCheckThreshold;
int		CPreferencesEx::m_iFileCheckThreshold;
int		CPreferencesEx::m_iFileCheckAmount;
// NEO: FDC END

// NEO: FN - [FunnyNick]
bool	CPreferencesEx::m_bUseFunnyNick;
CString CPreferencesEx::m_sFunnyNickFilter;
CString CPreferencesEx::m_sFunnyNickSymbol;
// NEO: FN END

// NEO: AU - [AutoUpdate]
bool	CPreferencesEx::m_bAutoRuntimeUpdate;
int		CPreferencesEx::m_iRuntimeUpdateIntervals;

TCHAR	CPreferencesEx::m_sUpdateURLIPFilter[256];
bool	CPreferencesEx::m_bAutoUpdateIPFilter;
SYSTEMTIME CPreferencesEx::m_IPFilterVersion;

#ifdef ARGOS // NEO: NA - [NeoArgos]
TCHAR	CPreferencesEx::m_sUpdateURLLeechersList[256];
bool	CPreferencesEx::m_bUpdateLeechersStartup;
SYSTEMTIME CPreferencesEx::m_LeechersVersion;
#endif // ARGOS // NEO: NA END

#ifdef IP2COUNTRY // NEO: IP2C - [IP2Country]
TCHAR	CPreferencesEx::m_sUpdateURLIP2Country[256];
bool	CPreferencesEx::m_bAutoUpdateIP2Country; 
SYSTEMTIME CPreferencesEx::m_IP2CountryVersion;
#endif // IP2COUNTRY // NEO: IP2C END

// NEO: FC - [FakeCheck]
TCHAR	CPreferencesEx::m_sUpdateURLFakeList[256];
bool	CPreferencesEx::m_bUpdateFakeStartup;
SYSTEMTIME CPreferencesEx::m_FakesVersion;
// NEO: FC END
// NEO: AU END

// NEO: IFWS - [ICSFirewall]
UINT	CPreferencesEx::m_uICFSupport;
bool	CPreferencesEx::m_bICFClearOnClose;
// NEO: IFWS END

// NEO: UPNP - [UPnPNat]
UINT	CPreferencesEx::m_uUPnPNat;
bool	CPreferencesEx::m_bUPnPClearOnClose;
bool	CPreferencesEx::m_bUPnPTryRandom;
// NEO: UPNP END

// NEO: NATS - [NatSupport]
bool	CPreferencesEx::m_bNATSupportEnabled;
float	CPreferencesEx::m_fNATPortRefreshIvterval;
int		CPreferencesEx::m_iNATPortMaxLatencyTime;
int		CPreferencesEx::m_iNATPortMaxFails;
bool	CPreferencesEx::m_bNATPortFastRefresh;

#ifdef NATTUNNELING // NEO: NATT - [NatTraversal]
bool	CPreferencesEx::m_bNATPortRelaiable;
bool	CPreferencesEx::m_bNATTraversalEnabled;
bool	CPreferencesEx::m_bDontTrustNatPorts;
int		CPreferencesEx::m_iNatCharacteristic;
UINT	CPreferencesEx::m_uLowIDUplaodCallBack; // NEO: LUC - [LowIDUplaodCallBack]
#endif //NATTUNNELING // NEO: NATT END
UINT	CPreferencesEx::m_uReuseTCPPort;

uint32	CPreferencesEx::m_uUDPPortPingTime;
uint16	CPreferencesEx::m_uUDPPortPingFails;
uint32	CPreferencesEx::m_iIPExternal;
bool	CPreferencesEx::m_bUDPPingPending;
bool	CPreferencesEx::m_bKADPingPending;

uint16	CPreferencesEx::m_iTCPExternal;
uint16	CPreferencesEx::m_iUDPExternal;
uint16	CPreferencesEx::m_iKADExternal; // NEO: KAX - [KadAuxPort]
// NEO: NATS END
// NEO: NCFG END <-- Xanatos --

#ifdef WEBCACHE // NEO: WC - [WebCache] -- Xanatos -->
bool	CPreferencesEx::HighIDConfirmed;
CString	CPreferencesEx::webcacheName;
uint16	CPreferencesEx::webcachePort;
uint16	CPreferencesEx::webcacheBlockLimit;
bool	CPreferencesEx::PersistentConnectionsForProxyDownloads; //jp persistent proxy connections
bool	CPreferencesEx::webcacheExtraTimeout;
bool	CPreferencesEx::webcacheCachesLocalTraffic;
UINT	CPreferencesEx::webcacheEnabled;
bool	CPreferencesEx::webcacheLimitles;
bool	CPreferencesEx::WCAutoupdate; //jp WCAutoupdate
bool	CPreferencesEx::detectWebcacheOnStart; //jp detect webcache on startup
uint32	CPreferencesEx::webcacheLastSearch;
CString	CPreferencesEx::webcacheLastResolvedName;
uint32	CPreferencesEx::webcacheLastGlobalIP;
//JP proxy configuration test start
bool	CPreferencesEx::WebCacheDisabledThisSession;//jp temp disabled
uint32	CPreferencesEx::WebCachePingSendTime;//jp check proxy config
bool	CPreferencesEx::expectingWebCachePing;//jp check proxy config
//JP proxy configuration test end
uint8	CPreferencesEx::webcacheTrustLevel;
bool	CPreferencesEx::m_bLogWebCacheEvents;
//bool	CPreferencesEx::m_bWebCacheShow;

bool CPreferencesEx::UsesCachedTCPPort()  //jp
{
	uint16 port = thePrefs.GetPort();
	if (port==80 
		|| port==21 
		|| port==443
		|| port==563
		|| port==70
		|| port==210 
		|| (port>=1025 && port<=65535)) 
		return true;
	else return false;
}

bool CPreferencesEx::IsWebCacheTestPossible()//jp check proxy config
{
	return (theApp.GetPublicIP() != 0 && HighIDConfirmed && !theApp.listensocket->TooManySockets(true));
}
#endif // NEO: WC END <-- Xanatos --

CPreferences::CPreferences()
{
#ifdef _DEBUG
	m_iDbgHeap = 1;
#endif
}

CPreferences::~CPreferences()
{
	delete prefsExt;
}

LPCTSTR CPreferences::GetConfigFile()
{
	return theApp.m_pszProfileName;
}

void CPreferences::Init()
{
	srand((uint32)time(0)); // we need random numbers sometimes

	prefsExt = new Preferences_Ext_Struct;
	memset(prefsExt, 0, sizeof *prefsExt);

	//get application start directory
	TCHAR buffer[490];
	::GetModuleFileName(0, buffer, 490);
	LPTSTR pszFileName = _tcsrchr(buffer, L'\\') + 1;
	*pszFileName = L'\0';

	appdir = buffer;
	configdir = appdir + CONFIGFOLDER;
	m_strWebServerDir = appdir + L"webserver\\";
	m_strLangDir = appdir + L"lang\\";
	m_strFileCommentsFilePath = configdir + L"fileinfo.ini";
	m_strLogDir = appdir + L"logs\\";

	///////////////////////////////////////////////////////////////////////////
	// Create 'config' directory (and optionally move files from application directory)
	//
	::CreateDirectory(GetConfigDir(), 0);

	///////////////////////////////////////////////////////////////////////////
	// Create 'logs' directory (and optionally move files from application directory)
	//
	::CreateDirectory(GetLogDir(), 0);
	CFileFind ff;
	BOOL bFoundFile = ff.FindFile(GetAppDir() + L"eMule*.log", 0);
	while (bFoundFile)
	{
		bFoundFile = ff.FindNextFile();
		if (ff.IsDots() || ff.IsSystem() || ff.IsDirectory() || ff.IsHidden())
			continue;
		MoveFile(ff.GetFilePath(), GetLogDir() + ff.GetFileName());
	}


	CreateUserHash();

	// load preferences.dat or set standart values
	TCHAR* fullpath = new TCHAR[_tcslen(configdir)+16];
	_stprintf(fullpath,L"%spreferences.dat",configdir);
	FILE* preffile = _tfsopen(fullpath,L"rb", _SH_DENYWR);
	delete[] fullpath;

	LoadPreferences();
	// NEO: NCFG - [NeoConfiguration] -- Xanatos -->
	thePrefs.LoadNeoPreferences();
	LoadVirtualDirs(); // NEO: VSF - [VirtualSharedFiles]
	LoadTempDirs(); // NEO: MTD - [MultiTempDirectories]
	LoadSharedDirs(); // NEO: SSD - [ShareSubDirectories]
	LoadSharedFiles(); // NEO: SSF - [ShareSingleFiles]
	// NEO: NCFG END <-- Xanatos --

	if (!preffile){
		SetStandartValues();
	}
	else{
		fread(prefsExt,sizeof(Preferences_Ext_Struct),1,preffile);
		if (ferror(preffile))
			SetStandartValues();

		md4cpy(userhash, prefsExt->userhash);
		EmuleWindowPlacement = prefsExt->EmuleWindowPlacement;

		fclose(preffile);
		smartidstate = 0;
	}

	// serverlist addresses
	// filename update to reasonable name
	if (PathFileExists( configdir + L"adresses.dat") ) {
		if (PathFileExists( configdir + L"addresses.dat") )
			DeleteFile( configdir + L"adresses.dat");
		else 
			MoveFile( configdir + L"adresses.dat", configdir + L"addresses.dat");
	}

	fullpath = new TCHAR[_tcslen(configdir) + 20];
	_stprintf(fullpath, L"%saddresses.dat", configdir);
	CStdioFile* sdirfile = new CStdioFile();
	bool bIsUnicodeFile = IsUnicodeFile(fullpath);
	if (sdirfile->Open(fullpath, CFile::modeRead | CFile::shareDenyWrite | (bIsUnicodeFile ? CFile::typeBinary : 0)))
	{
		try {
			if (bIsUnicodeFile)
				sdirfile->Seek(sizeof(WORD), SEEK_CUR); // skip BOM

			CString toadd;
			while (sdirfile->ReadString(toadd))
			{
				toadd.Trim(L" \t\r\n"); // need to trim '\r' in binary mode
				if (toadd.IsEmpty())
					continue;
				addresses_list.AddHead(toadd);
			}
		}
		catch (CFileException* ex) {
			ASSERT(0);
			ex->Delete();
		}
		sdirfile->Close();
	}
	delete sdirfile;
	delete[] fullpath;
	fullpath = NULL;

	userhash[5] = 14;
	userhash[14] = 111;

	// Explicitly inform the user about errors with incoming/temp folders!
	if (!PathFileExists(GetIncomingDir()) && !::CreateDirectory(GetIncomingDir(),0)) {
		CString strError;
		strError.Format(GetResString(IDS_ERR_CREATE_DIR), GetResString(IDS_PW_INCOMING), GetIncomingDir(), GetErrorMessage(GetLastError()));
		AfxMessageBox(strError, MB_ICONERROR);
		_stprintf(incomingdir,L"%sincoming",appdir);
		if (!PathFileExists(GetIncomingDir()) && !::CreateDirectory(GetIncomingDir(),0)){
			strError.Format(GetResString(IDS_ERR_CREATE_DIR), GetResString(IDS_PW_INCOMING), GetIncomingDir(), GetErrorMessage(GetLastError()));
			AfxMessageBox(strError, MB_ICONERROR);
		}
	}
	if (!PathFileExists(GetTempDir()) && !::CreateDirectory(GetTempDir(),0)) {
		CString strError;
		strError.Format(GetResString(IDS_ERR_CREATE_DIR), GetResString(IDS_PW_TEMP), GetTempDir(), GetErrorMessage(GetLastError()));
		AfxMessageBox(strError, MB_ICONERROR);
		
		//tempdir.SetAt(0,appdir + L"temp" );
		_stprintf(tempdir,L"%stemp",appdir); // NEO: MTD - [MultiTempDirectories] <-- Xanatos --
		if (!PathFileExists(GetTempDir()) && !::CreateDirectory(GetTempDir(),0)){
			strError.Format(GetResString(IDS_ERR_CREATE_DIR), GetResString(IDS_PW_TEMP), GetTempDir(), GetErrorMessage(GetLastError()));
			AfxMessageBox(strError, MB_ICONERROR);
		}
	}

	// Create 'skins' directory
	if (!PathFileExists(GetSkinProfileDir()) && !CreateDirectory(GetSkinProfileDir(), 0)) {
		m_strSkinProfileDir = appdir + L"skins";
		CreateDirectory(GetSkinProfileDir(), 0);
	}

	// Create 'toolbars' directory
	if (!PathFileExists(GetToolbarBitmapFolderSettings()) && !CreateDirectory(GetToolbarBitmapFolderSettings(), 0)) {
		m_sToolbarBitmapFolder = appdir + L"skins";
		CreateDirectory(GetToolbarBitmapFolderSettings(), 0);
	}


	if (((int*)userhash[0]) == 0 && ((int*)userhash[1]) == 0 && ((int*)userhash[2]) == 0 && ((int*)userhash[3]) == 0)
		CreateUserHash();
}

void CPreferences::Uninit()
{
	while (!catMap.IsEmpty())
	{
		Category_Struct* delcat = catMap.GetAt(0); 
		catMap.RemoveAt(0); 
		delete delcat;
	}
}

void CPreferences::SetStandartValues()
{
	CreateUserHash();

	WINDOWPLACEMENT defaultWPM;
	defaultWPM.length = sizeof(WINDOWPLACEMENT);
	defaultWPM.rcNormalPosition.left=10;defaultWPM.rcNormalPosition.top=10;
	defaultWPM.rcNormalPosition.right=700;defaultWPM.rcNormalPosition.bottom=500;
	defaultWPM.showCmd=0;
	EmuleWindowPlacement=defaultWPM;
	versioncheckLastAutomatic=0;

//	Save();
}

// NEO: SSH - [SlugFillerSafeHash] -- Xanatos --
/*bool CPreferences::IsTempFile(const CString& rstrDirectory, const CString& rstrName)
{
	bool bFound = false;
	// NEO: MTD - [MultiTempDirectories] -- Xanatos -->
	if (CompareDirectories(rstrDirectory, GetTempDir()) == 0)
			bFound = true; //ok, found a directory
	if(!bFound)
		for (POSITION pos = tempdir_list.GetHeadPosition();pos != 0;tempdir_list.GetNext(pos)){
			CString folder = tempdir_list.GetAt(pos);
			if (!CompareDirectories(rstrDirectory, folder)){
				bFound = true; //ok, found a directory
				break;
			}
		}
	// NEO: MTD END <-- Xanatos --
	
	if(!bFound) //found nowhere - not a tempfile...
		return false;

	// do not share a file from the temp directory, if it matches one of the following patterns
	CString strNameLower(rstrName);
	strNameLower.MakeLower();
	strNameLower += L"|"; // append an EOS character which we can query for
	static const LPCTSTR _apszNotSharedExts[] = {
		L"%u.part" L"%c", 
		L"%u.part.met" L"%c", 
		L"%u.part.met" PARTMET_BAK_EXT L"%c", 
		L"%u.part.met" PARTMET_TMP_EXT L"%c" 
	};
	for (int i = 0; i < ARRSIZE(_apszNotSharedExts); i++){
		UINT uNum;
		TCHAR iChar;
		// "misuse" the 'scanf' function for a very simple pattern scanning.
		if (_stscanf(strNameLower, _apszNotSharedExts[i], &uNum, &iChar) == 2 && iChar == L'|')
			return true;
	}

	return false;
}*/

// SLUGFILLER: SafeHash
bool CPreferences::IsConfigFile(const CString& rstrDirectory, const CString& rstrName)
{
	if (CompareDirectories(rstrDirectory, configdir))
		return false;

	// do not share a file from the config directory, if it contains one of the following extensions
	static const LPCTSTR _apszNotSharedExts[] = { L".met.bak", L".ini.old" };
	for (int i = 0; i < ARRSIZE(_apszNotSharedExts); i++){
		int iLen = _tcslen(_apszNotSharedExts[i]);
		if (rstrName.GetLength()>=iLen && rstrName.Right(iLen).CompareNoCase(_apszNotSharedExts[i])==0)
			return true;
	}

	// do not share following files from the config directory
	static const LPCTSTR _apszNotSharedFiles[] = 
	{
		L"AC_SearchStrings.dat",
		L"AC_ServerMetURLs.dat",
		L"addresses.dat",
		L"category.ini",
		L"clients.met",
		L"cryptkey.dat",
		L"emfriends.met",
		L"fileinfo.ini",
		L"ipfilter.dat",
		L"known.met",
		L"KnownPrefs.met", // NEO: FCFG - [FileConfiguration] <-- Xanatos --
		L"preferences.dat",
		L"preferences.ini",
		L"server.met",
		L"server.met.new",
		L"server_met.download",
		L"server_met.old",
		L"shareddir.dat",
		L"sharedsubdir.dat", // NEO: SSD - [ShareSubDirectories] <-- Xanatos --
		L"sharedfiles.dat", // NEO: SSF - [ShareSingleFiles] <-- Xanatos --
		L"staticservers.dat",
		L"tempdir.dat", // NEO: MTD - [MultiTempDirectories] <-- Xanatos --
		L"virtualdirs.ini", // NEO: VSF - [VirtualSharedFiles] <-- Xanatos --
		L"webservices.dat"
	};
	for (int i = 0; i < ARRSIZE(_apszNotSharedFiles); i++){
		if (rstrName.CompareNoCase(_apszNotSharedFiles[i])==0)
			return true;
	}

	return false;
}
// SLUGFILLER: SafeHash

#ifndef NEO_BC // NEO: NBC -- Xanatos -->
uint16 CPreferences::GetMaxDownload(){
    return (uint16)(GetMaxDownloadInBytesPerSec()/1024);
}

uint64 CPreferences::GetMaxDownloadInBytesPerSec(bool dynamic){
//dont be a Lam3r :)
	UINT maxup;
	if (dynamic && thePrefs.IsDynUpEnabled() && theApp.uploadqueue->GetWaitingUserCount() != 0 && theApp.uploadqueue->GetDatarate() != 0) {
		maxup = theApp.uploadqueue->GetDatarate();
	} else {
		maxup = GetMaxUpload()*1024;
	}

	if (maxup < 4*1024)
		return (((maxup < 10*1024) && ((uint64)maxup*3 < maxdownload*1024)) ? (uint64)maxup*3 : maxdownload*1024);
	return (((maxup < 10*1024) && ((uint64)maxup*4 < maxdownload*1024)) ? (uint64)maxup*4 : maxdownload*1024);
}
#endif // NEO_BC // NEO: NBC END <-- Xanatos --

// -khaos--+++> A whole bunch of methods!  Keep going until you reach the end tag.
void CPreferences::SaveStats(int bBackUp){
	// This function saves all of the new statistics in my addon.  It is also used to
	// save backups for the Reset Stats function, and the Restore Stats function (Which is actually LoadStats)
	// bBackUp = 0: DEFAULT; save to statistics.ini
	// bBackUp = 1: Save to statbkup.ini, which is used to restore after a reset
	// bBackUp = 2: Save to statbkuptmp.ini, which is temporarily created during a restore and then renamed to statbkup.ini

	CString fullpath(configdir);
	if (bBackUp == 1)
		fullpath += L"statbkup.ini";
	else if (bBackUp == 2)
		fullpath += L"statbkuptmp.ini";
	else
		fullpath += L"statistics.ini";
	
	CIni ini(fullpath, L"Statistics");

	// Save cumulative statistics to preferences.ini, going in order as they appear in CStatisticsDlg::ShowStatistics.
	// We do NOT SET the values in prefs struct here.

    // Save Cum Down Data
	ini.WriteUInt64(L"TotalDownloadedBytes", theStats.sessionReceivedBytes + GetTotalDownloaded());
	ini.WriteInt(L"DownSuccessfulSessions", cumDownSuccessfulSessions);
	ini.WriteInt(L"DownFailedSessions", cumDownFailedSessions);
	ini.WriteInt(L"DownAvgTime", (GetDownC_AvgTime() + GetDownS_AvgTime()) / 2);
	ini.WriteUInt64(L"LostFromCorruption", cumLostFromCorruption + sesLostFromCorruption);
	ini.WriteUInt64(L"SavedFromCompression", sesSavedFromCompression + cumSavedFromCompression);
	ini.WriteInt(L"PartsSavedByICH", cumPartsSavedByICH + sesPartsSavedByICH);

	ini.WriteUInt64(L"DownData_EDONKEY", GetCumDownData_EDONKEY());
	ini.WriteUInt64(L"DownData_EDONKEYHYBRID", GetCumDownData_EDONKEYHYBRID());
	ini.WriteUInt64(L"DownData_EMULE", GetCumDownData_EMULE());
	ini.WriteUInt64(L"DownData_MLDONKEY", GetCumDownData_MLDONKEY());
	ini.WriteUInt64(L"DownData_LMULE", GetCumDownData_EMULECOMPAT());
	ini.WriteUInt64(L"DownData_AMULE", GetCumDownData_AMULE());
	ini.WriteUInt64(L"DownData_SHAREAZA", GetCumDownData_SHAREAZA());
	ini.WriteUInt64(L"DownData_URL", GetCumDownData_URL());
#ifdef WEBCACHE // NEO: WC - [WebCache] -- Xanatos -->
	ini.WriteUInt64(L"DownData_WEBCACHE", GetCumDownData_WEBCACHE()); // Superlexx - webcache - statistics
#endif // NEO: WC END <-- Xanatos --
	ini.WriteUInt64(L"DownDataPort_4662", GetCumDownDataPort_4662());
	ini.WriteUInt64(L"DownDataPort_OTHER", GetCumDownDataPort_OTHER());
	ini.WriteUInt64(L"DownDataPort_PeerCache", GetCumDownDataPort_PeerCache());

	ini.WriteUInt64(L"DownOverheadTotal",theStats.GetDownDataOverheadFileRequest() +
										theStats.GetDownDataOverheadSourceExchange() +
										theStats.GetDownDataOverheadServer() +
										theStats.GetDownDataOverheadKad() +
										theStats.GetDownDataOverheadOther() +
										GetDownOverheadTotal());
	ini.WriteUInt64(L"DownOverheadFileReq", theStats.GetDownDataOverheadFileRequest() + GetDownOverheadFileReq());
	ini.WriteUInt64(L"DownOverheadSrcEx", theStats.GetDownDataOverheadSourceExchange() + GetDownOverheadSrcEx());
	ini.WriteUInt64(L"DownOverheadServer", theStats.GetDownDataOverheadServer() + GetDownOverheadServer());
	ini.WriteUInt64(L"DownOverheadKad", theStats.GetDownDataOverheadKad() + GetDownOverheadKad());
	
	ini.WriteUInt64(L"DownOverheadTotalPackets", theStats.GetDownDataOverheadFileRequestPackets() + 
												theStats.GetDownDataOverheadSourceExchangePackets() + 
												theStats.GetDownDataOverheadServerPackets() + 
												theStats.GetDownDataOverheadKadPackets() + 
												theStats.GetDownDataOverheadOtherPackets() + 
												GetDownOverheadTotalPackets());
	ini.WriteUInt64(L"DownOverheadFileReqPackets", theStats.GetDownDataOverheadFileRequestPackets() + GetDownOverheadFileReqPackets());
	ini.WriteUInt64(L"DownOverheadSrcExPackets", theStats.GetDownDataOverheadSourceExchangePackets() + GetDownOverheadSrcExPackets());
	ini.WriteUInt64(L"DownOverheadServerPackets", theStats.GetDownDataOverheadServerPackets() + GetDownOverheadServerPackets());
	ini.WriteUInt64(L"DownOverheadKadPackets", theStats.GetDownDataOverheadKadPackets() + GetDownOverheadKadPackets());

	// Save Cumulative Upline Statistics
	ini.WriteUInt64(L"TotalUploadedBytes", theStats.sessionSentBytes + GetTotalUploaded());
	ini.WriteInt(L"UpSuccessfulSessions", theApp.uploadqueue->GetSuccessfullUpCount() + GetUpSuccessfulSessions());
	ini.WriteInt(L"UpFailedSessions", theApp.uploadqueue->GetFailedUpCount() + GetUpFailedSessions());
	ini.WriteInt(L"UpAvgTime", (theApp.uploadqueue->GetAverageUpTime() + GetUpAvgTime())/2);
	ini.WriteUInt64(L"UpData_EDONKEY", GetCumUpData_EDONKEY());
	ini.WriteUInt64(L"UpData_EDONKEYHYBRID", GetCumUpData_EDONKEYHYBRID());
	ini.WriteUInt64(L"UpData_EMULE", GetCumUpData_EMULE());
	ini.WriteUInt64(L"UpData_MLDONKEY", GetCumUpData_MLDONKEY());
	ini.WriteUInt64(L"UpData_LMULE", GetCumUpData_EMULECOMPAT());
	ini.WriteUInt64(L"UpData_AMULE", GetCumUpData_AMULE());
	ini.WriteUInt64(L"UpData_SHAREAZA", GetCumUpData_SHAREAZA());
	ini.WriteUInt64(L"UpDataPort_4662", GetCumUpDataPort_4662());
	ini.WriteUInt64(L"UpDataPort_OTHER", GetCumUpDataPort_OTHER());
	ini.WriteUInt64(L"UpDataPort_PeerCache", GetCumUpDataPort_PeerCache());
	ini.WriteUInt64(L"UpData_File", GetCumUpData_File());
	ini.WriteUInt64(L"UpData_Partfile", GetCumUpData_Partfile());

	ini.WriteUInt64(L"UpOverheadTotal", theStats.GetUpDataOverheadFileRequest() + 
										theStats.GetUpDataOverheadSourceExchange() + 
										theStats.GetUpDataOverheadServer() + 
										theStats.GetUpDataOverheadKad() + 
										theStats.GetUpDataOverheadOther() + 
										GetUpOverheadTotal());
	ini.WriteUInt64(L"UpOverheadFileReq", theStats.GetUpDataOverheadFileRequest() + GetUpOverheadFileReq());
	ini.WriteUInt64(L"UpOverheadSrcEx", theStats.GetUpDataOverheadSourceExchange() + GetUpOverheadSrcEx());
	ini.WriteUInt64(L"UpOverheadServer", theStats.GetUpDataOverheadServer() + GetUpOverheadServer());
	ini.WriteUInt64(L"UpOverheadKad", theStats.GetUpDataOverheadKad() + GetUpOverheadKad());

	ini.WriteUInt64(L"UpOverheadTotalPackets", theStats.GetUpDataOverheadFileRequestPackets() + 
										theStats.GetUpDataOverheadSourceExchangePackets() + 
										theStats.GetUpDataOverheadServerPackets() + 
										theStats.GetUpDataOverheadKadPackets() + 
										theStats.GetUpDataOverheadOtherPackets() + 
										GetUpOverheadTotalPackets());
	ini.WriteUInt64(L"UpOverheadFileReqPackets", theStats.GetUpDataOverheadFileRequestPackets() + GetUpOverheadFileReqPackets());
	ini.WriteUInt64(L"UpOverheadSrcExPackets", theStats.GetUpDataOverheadSourceExchangePackets() + GetUpOverheadSrcExPackets());
	ini.WriteUInt64(L"UpOverheadServerPackets", theStats.GetUpDataOverheadServerPackets() + GetUpOverheadServerPackets());
	ini.WriteUInt64(L"UpOverheadKadPackets", theStats.GetUpDataOverheadKadPackets() + GetUpOverheadKadPackets());

	// Save Cumulative Connection Statistics
	float tempRate = 0.0F;

	// Download Rate Average
	tempRate = theStats.GetAvgDownloadRate(AVG_TOTAL);
	ini.WriteFloat(L"ConnAvgDownRate", tempRate);
	
	// Max Download Rate Average
	if (tempRate > GetConnMaxAvgDownRate())
		SetConnMaxAvgDownRate(tempRate);
	ini.WriteFloat(L"ConnMaxAvgDownRate", GetConnMaxAvgDownRate());
	
	// Max Download Rate
	tempRate = (float)theApp.downloadqueue->GetDatarate() / 1024;
	if (tempRate > GetConnMaxDownRate())
		SetConnMaxDownRate(tempRate);
	ini.WriteFloat(L"ConnMaxDownRate", GetConnMaxDownRate());
	
	// Upload Rate Average
	tempRate = theStats.GetAvgUploadRate(AVG_TOTAL);
	ini.WriteFloat(L"ConnAvgUpRate", tempRate);
	
	// Max Upload Rate Average
	if (tempRate > GetConnMaxAvgUpRate())
		SetConnMaxAvgUpRate(tempRate);
	ini.WriteFloat(L"ConnMaxAvgUpRate", GetConnMaxAvgUpRate());
	
	// Max Upload Rate
	tempRate = (float)theApp.uploadqueue->GetDatarate() / 1024;
	if (tempRate > GetConnMaxUpRate())
		SetConnMaxUpRate(tempRate);
	ini.WriteFloat(L"ConnMaxUpRate", GetConnMaxUpRate());
	
	// Overall Run Time
	ini.WriteInt(L"ConnRunTime", (UINT)((GetTickCount() - theStats.starttime)/1000 + GetConnRunTime()));
	
	// Number of Reconnects
	ini.WriteInt(L"ConnNumReconnects", (theStats.reconnects>0) ? (theStats.reconnects - 1 + GetConnNumReconnects()) : GetConnNumReconnects());
	
	// Average Connections
	if (theApp.serverconnect->IsConnected())
		ini.WriteInt(L"ConnAvgConnections", (UINT)((theApp.listensocket->GetAverageConnections() + cumConnAvgConnections)/2));
	
	// Peak Connections
	if (theApp.listensocket->GetPeakConnections() > cumConnPeakConnections)
		cumConnPeakConnections = theApp.listensocket->GetPeakConnections();
	ini.WriteInt(L"ConnPeakConnections", cumConnPeakConnections);
	
	// Max Connection Limit Reached
	if (theApp.listensocket->GetMaxConnectionReached() + cumConnMaxConnLimitReached > cumConnMaxConnLimitReached)
		ini.WriteInt(L"ConnMaxConnLimitReached", theApp.listensocket->GetMaxConnectionReached() + cumConnMaxConnLimitReached);
	
	// Time Stuff...
	ini.WriteInt(L"ConnTransferTime", GetConnTransferTime() + theStats.GetTransferTime());
	ini.WriteInt(L"ConnUploadTime", GetConnUploadTime() + theStats.GetUploadTime());
	ini.WriteInt(L"ConnDownloadTime", GetConnDownloadTime() + theStats.GetDownloadTime());
	ini.WriteInt(L"ConnServerDuration", GetConnServerDuration() + theStats.GetServerDuration());
	
	// Compare and Save Server Records
	uint32 servtotal, servfail, servuser, servfile, servlowiduser, servtuser, servtfile;
	float servocc;
	theApp.serverlist->GetStatus(servtotal, servfail, servuser, servfile, servlowiduser, servtuser, servtfile, servocc);
	
	if (servtotal - servfail > cumSrvrsMostWorkingServers)
		cumSrvrsMostWorkingServers = servtotal - servfail;
	ini.WriteInt(L"SrvrsMostWorkingServers", cumSrvrsMostWorkingServers);

	if (servtuser > cumSrvrsMostUsersOnline)
		cumSrvrsMostUsersOnline = servtuser;
	ini.WriteInt(L"SrvrsMostUsersOnline", cumSrvrsMostUsersOnline);

	if (servtfile > cumSrvrsMostFilesAvail)
		cumSrvrsMostFilesAvail = servtfile;
	ini.WriteInt(L"SrvrsMostFilesAvail", cumSrvrsMostFilesAvail);

	// Compare and Save Shared File Records
	if ((UINT)theApp.sharedfiles->GetCount() > cumSharedMostFilesShared)
		cumSharedMostFilesShared = theApp.sharedfiles->GetCount();
	ini.WriteInt(L"SharedMostFilesShared", cumSharedMostFilesShared);

	uint64 bytesLargestFile = 0;
	uint64 allsize = theApp.sharedfiles->GetDatasize(bytesLargestFile);
	if (allsize > cumSharedLargestShareSize)
		cumSharedLargestShareSize = allsize;
	ini.WriteUInt64(L"SharedLargestShareSize", cumSharedLargestShareSize);
	if (bytesLargestFile > cumSharedLargestFileSize)
		cumSharedLargestFileSize = bytesLargestFile;
	ini.WriteUInt64(L"SharedLargestFileSize", cumSharedLargestFileSize);

	if (theApp.sharedfiles->GetCount() != 0) {
		uint64 tempint = allsize/theApp.sharedfiles->GetCount();
		if (tempint > cumSharedLargestAvgFileSize)
			cumSharedLargestAvgFileSize = tempint;
	}

	ini.WriteUInt64(L"SharedLargestAvgFileSize", cumSharedLargestAvgFileSize);
	ini.WriteInt(L"statsDateTimeLastReset", stat_datetimeLastReset);

	// If we are saving a back-up or a temporary back-up, return now.
	if (bBackUp != 0)
		return;
}

void CPreferences::SetRecordStructMembers() {

	// The purpose of this function is to be called from CStatisticsDlg::ShowStatistics()
	// This was easier than making a bunch of functions to interface with the record
	// members of the prefs struct from ShowStatistics.

	// This function is going to compare current values with previously saved records, and if
	// the current values are greater, the corresponding member of prefs will be updated.
	// We will not write to INI here, because this code is going to be called a lot more often
	// than SaveStats()  - Khaos

	CString buffer;

	// Servers
	uint32 servtotal, servfail, servuser, servfile, servlowiduser, servtuser, servtfile;
	float servocc;
	theApp.serverlist->GetStatus( servtotal, servfail, servuser, servfile, servlowiduser, servtuser, servtfile, servocc );
	if ((servtotal-servfail)>cumSrvrsMostWorkingServers) cumSrvrsMostWorkingServers = (servtotal-servfail);
	if (servtuser>cumSrvrsMostUsersOnline) cumSrvrsMostUsersOnline = servtuser;
	if (servtfile>cumSrvrsMostFilesAvail) cumSrvrsMostFilesAvail = servtfile;

	// Shared Files
	if ((UINT)theApp.sharedfiles->GetCount() > cumSharedMostFilesShared)
		cumSharedMostFilesShared = theApp.sharedfiles->GetCount();
	uint64 bytesLargestFile = 0;
	uint64 allsize=theApp.sharedfiles->GetDatasize(bytesLargestFile);
	if (allsize>cumSharedLargestShareSize) cumSharedLargestShareSize = allsize;
	if (bytesLargestFile>cumSharedLargestFileSize) cumSharedLargestFileSize = bytesLargestFile;
	if (theApp.sharedfiles->GetCount() != 0) {
		uint64 tempint = allsize/theApp.sharedfiles->GetCount();
		if (tempint>cumSharedLargestAvgFileSize) cumSharedLargestAvgFileSize = tempint;
	}
} // SetRecordStructMembers()

void CPreferences::SaveCompletedDownloadsStat(){

	// This function saves the values for the completed
	// download members to INI.  It is called from
	// CPartfile::PerformFileComplete ...   - Khaos

	TCHAR* fullpath = new TCHAR[_tcslen(configdir)+MAX_PATH]; // i_a
	_stprintf(fullpath,L"%sstatistics.ini",configdir);
	
	CIni ini( fullpath, L"Statistics" );

	delete[] fullpath;

	ini.WriteInt(L"DownCompletedFiles",			GetDownCompletedFiles());
	ini.WriteInt(L"DownSessionCompletedFiles",	GetDownSessionCompletedFiles());
} // SaveCompletedDownloadsStat()

void CPreferences::Add2SessionTransferData(UINT uClientID, UINT uClientPort, BOOL bFromPF, 
										   BOOL bUpDown, uint32 bytes, bool privatTransferred, bool releaseTransferred) // NEO: BM - [BandwidthModeration] // NEO: PTM - [PrivatTransferManagement] <-- Xanatos --
{
	//	This function adds the transferred bytes to the appropriate variables,
	//	as well as to the totals for all clients. - Khaos
	//	PARAMETERS:
	//	uClientID - The identifier for which client software sent or received this data, eg SO_EMULE
	//	uClientPort - The remote port of the client that sent or received this data, eg 4662
	//	bFromPF - Applies only to uploads.  True is from partfile, False is from non-partfile.
	//	bUpDown - True is Up, False is Down
	//	bytes - Number of bytes sent by the client.  Subtract header before calling.

	switch (bUpDown){
		case true:
			//	Upline Data
			switch (uClientID){
				// Update session client breakdown stats for sent bytes...
				case SO_EMULE:
				case SO_OLDEMULE:		sesUpData_EMULE+=bytes;			break;
				case SO_EDONKEYHYBRID:	sesUpData_EDONKEYHYBRID+=bytes;	break;
				case SO_EDONKEY:		sesUpData_EDONKEY+=bytes;		break;
				case SO_MLDONKEY:		sesUpData_MLDONKEY+=bytes;		break;
				case SO_AMULE:			sesUpData_AMULE+=bytes;			break;
				case SO_SHAREAZA:		sesUpData_SHAREAZA+=bytes;		break;
				case SO_CDONKEY:
				case SO_LPHANT:
				case SO_XMULE:			sesUpData_EMULECOMPAT+=bytes;	break;
			}

			switch (uClientPort){
				// Update session port breakdown stats for sent bytes...
				case 4662:				sesUpDataPort_4662+=bytes;		break;
				case (UINT)-1:			sesUpDataPort_PeerCache+=bytes;	break;
				//case (UINT)-2:		sesUpDataPort_URL+=bytes;		break;
				default:				sesUpDataPort_OTHER+=bytes;		break;
			}

			if (bFromPF)				sesUpData_Partfile+=bytes;
			else						sesUpData_File+=bytes;

			//	Add to our total for sent bytes...
			theApp.UpdateSentBytes(bytes, privatTransferred, releaseTransferred); // NEO: PTM - [PrivatTransferManagement] // NEO: BM - [BandwidthModeration] <-- Xanatos --

			break;

		case false:
			// Downline Data
			switch (uClientID){
                // Update session client breakdown stats for received bytes...
				case SO_EMULE:
				case SO_OLDEMULE:		sesDownData_EMULE+=bytes;		break;
				case SO_EDONKEYHYBRID:	sesDownData_EDONKEYHYBRID+=bytes;break;
				case SO_EDONKEY:		sesDownData_EDONKEY+=bytes;		break;
				case SO_MLDONKEY:		sesDownData_MLDONKEY+=bytes;	break;
				case SO_AMULE:			sesDownData_AMULE+=bytes;		break;
				case SO_SHAREAZA:		sesDownData_SHAREAZA+=bytes;	break;
				case SO_CDONKEY:
				case SO_LPHANT:
				case SO_XMULE:			sesDownData_EMULECOMPAT+=bytes;	break;
				case SO_URL:			sesDownData_URL+=bytes;			break;
#ifdef WEBCACHE // NEO: WC - [WebCache] -- Xanatos -->
				case SO_WEBCACHE:		sesDownData_WEBCACHE+=bytes;	break; // Superlexx - webcache - statistics
#endif // NEO: WC END <-- Xanatos --
			}

			switch (uClientPort){
				// Update session port breakdown stats for received bytes...
				// For now we are only going to break it down by default and non-default.
				// A statistical analysis of all data sent from every single port/domain is
				// beyond the scope of this add-on.
				case 4662:				sesDownDataPort_4662+=bytes;	break;
				case (UINT)-1:			sesDownDataPort_PeerCache+=bytes;break;
				//case (UINT)-2:		sesDownDataPort_URL+=bytes;		break;
				default:				sesDownDataPort_OTHER+=bytes;	break;
			}

			//	Add to our total for received bytes...
			theApp.UpdateReceivedBytes(bytes, privatTransferred, releaseTransferred); // NEO: PTM - [PrivatTransferManagement] // NEO: BM - [BandwidthModeration] <-- Xanatos --
	}
}

// Reset Statistics by Khaos

void CPreferences::ResetCumulativeStatistics(){

	// Save a backup so that we can undo this action
	SaveStats(1);

	// SET ALL CUMULATIVE STAT VALUES TO 0  :'-(

	totalDownloadedBytes=0;
	totalUploadedBytes=0;
	cumDownOverheadTotal=0;
	cumDownOverheadFileReq=0;
	cumDownOverheadSrcEx=0;
	cumDownOverheadServer=0;
	cumDownOverheadKad=0;
	cumDownOverheadTotalPackets=0;
	cumDownOverheadFileReqPackets=0;
	cumDownOverheadSrcExPackets=0;
	cumDownOverheadServerPackets=0;
	cumDownOverheadKadPackets=0;
	cumUpOverheadTotal=0;
	cumUpOverheadFileReq=0;
	cumUpOverheadSrcEx=0;
	cumUpOverheadServer=0;
	cumUpOverheadKad=0;
	cumUpOverheadTotalPackets=0;
	cumUpOverheadFileReqPackets=0;
	cumUpOverheadSrcExPackets=0;
	cumUpOverheadServerPackets=0;
	cumUpOverheadKadPackets=0;
	cumUpSuccessfulSessions=0;
	cumUpFailedSessions=0;
	cumUpAvgTime=0;
	cumUpData_EDONKEY=0;
	cumUpData_EDONKEYHYBRID=0;
	cumUpData_EMULE=0;
	cumUpData_MLDONKEY=0;
	cumUpData_AMULE=0;
	cumUpData_EMULECOMPAT=0;
	cumUpData_SHAREAZA=0;
	cumUpDataPort_4662=0;
	cumUpDataPort_OTHER=0;
	cumUpDataPort_PeerCache=0;
	cumDownCompletedFiles=0;
	cumDownSuccessfulSessions=0;
	cumDownFailedSessions=0;
	cumDownAvgTime=0;
	cumLostFromCorruption=0;
	cumSavedFromCompression=0;
	cumPartsSavedByICH=0;
	cumDownData_EDONKEY=0;
	cumDownData_EDONKEYHYBRID=0;
	cumDownData_EMULE=0;
	cumDownData_MLDONKEY=0;
	cumDownData_AMULE=0;
	cumDownData_EMULECOMPAT=0;
	cumDownData_SHAREAZA=0;
	cumDownData_URL=0;
#ifdef WEBCACHE // NEO: WC - [WebCache] -- Xanatos -->
	cumDownData_WEBCACHE=0; // Superlexx - webcache - statistics
#endif // NEO: WC END <-- Xanatos --
	cumDownDataPort_4662=0;
	cumDownDataPort_OTHER=0;
	cumDownDataPort_PeerCache=0;
	cumConnAvgDownRate=0;
	cumConnMaxAvgDownRate=0;
	cumConnMaxDownRate=0;
	cumConnAvgUpRate=0;
	cumConnRunTime=0;
	cumConnNumReconnects=0;
	cumConnAvgConnections=0;
	cumConnMaxConnLimitReached=0;
	cumConnPeakConnections=0;
	cumConnDownloadTime=0;
	cumConnUploadTime=0;
	cumConnTransferTime=0;
	cumConnServerDuration=0;
	cumConnMaxAvgUpRate=0;
	cumConnMaxUpRate=0;
	cumSrvrsMostWorkingServers=0;
	cumSrvrsMostUsersOnline=0;
	cumSrvrsMostFilesAvail=0;
    cumSharedMostFilesShared=0;
	cumSharedLargestShareSize=0;
	cumSharedLargestAvgFileSize=0;

	// Set the time of last reset...
	time_t timeNow;
	time(&timeNow);
	stat_datetimeLastReset = timeNow;

	// Save the reset stats
	SaveStats();
	theApp.emuledlg->statisticswnd->ShowStatistics(true);
}


// Load Statistics
// This used to be integrated in LoadPreferences, but it has been altered
// so that it can be used to load the backup created when the stats are reset.
// Last Modified: 2-22-03 by Khaos
bool CPreferences::LoadStats(int loadBackUp)
{
	// loadBackUp is 0 by default
	// loadBackUp = 0: Load the stats normally like we used to do in LoadPreferences
	// loadBackUp = 1: Load the stats from statbkup.ini and create a backup of the current stats.  Also, do not initialize session variables.
	CString sINI;
	CFileFind findBackUp;

	switch (loadBackUp) {
		case 0:{
			// for transition...
			if(PathFileExists(configdir+L"statistics.ini"))
				sINI.Format(L"%sstatistics.ini", configdir);
			else
				sINI.Format(L"%spreferences.ini", configdir);

			break;
			   }
		case 1:
			sINI.Format(L"%sstatbkup.ini", configdir);
			if (!findBackUp.FindFile(sINI))
				return false;
			SaveStats(2); // Save our temp backup of current values to statbkuptmp.ini, we will be renaming it at the end of this function.
			break;
	}

	BOOL fileex = PathFileExists(sINI);
	CIni ini(sINI, L"Statistics");

	totalDownloadedBytes			= ini.GetUInt64(L"TotalDownloadedBytes");
	totalUploadedBytes				= ini.GetUInt64(L"TotalUploadedBytes");

	// Load stats for cumulative downline overhead
	cumDownOverheadTotal			= ini.GetUInt64(L"DownOverheadTotal");
	cumDownOverheadFileReq			= ini.GetUInt64(L"DownOverheadFileReq");
	cumDownOverheadSrcEx			= ini.GetUInt64(L"DownOverheadSrcEx");
	cumDownOverheadServer			= ini.GetUInt64(L"DownOverheadServer");
	cumDownOverheadKad				= ini.GetUInt64(L"DownOverheadKad");
	cumDownOverheadTotalPackets		= ini.GetUInt64(L"DownOverheadTotalPackets");
	cumDownOverheadFileReqPackets	= ini.GetUInt64(L"DownOverheadFileReqPackets");
	cumDownOverheadSrcExPackets		= ini.GetUInt64(L"DownOverheadSrcExPackets");
	cumDownOverheadServerPackets	= ini.GetUInt64(L"DownOverheadServerPackets");
	cumDownOverheadKadPackets		= ini.GetUInt64(L"DownOverheadKadPackets");

	// Load stats for cumulative upline overhead
	cumUpOverheadTotal				= ini.GetUInt64(L"UpOverHeadTotal");
	cumUpOverheadFileReq			= ini.GetUInt64(L"UpOverheadFileReq");
	cumUpOverheadSrcEx				= ini.GetUInt64(L"UpOverheadSrcEx");
	cumUpOverheadServer				= ini.GetUInt64(L"UpOverheadServer");
	cumUpOverheadKad				= ini.GetUInt64(L"UpOverheadKad");
	cumUpOverheadTotalPackets		= ini.GetUInt64(L"UpOverHeadTotalPackets");
	cumUpOverheadFileReqPackets		= ini.GetUInt64(L"UpOverheadFileReqPackets");
	cumUpOverheadSrcExPackets		= ini.GetUInt64(L"UpOverheadSrcExPackets");
	cumUpOverheadServerPackets		= ini.GetUInt64(L"UpOverheadServerPackets");
	cumUpOverheadKadPackets			= ini.GetUInt64(L"UpOverheadKadPackets");

	// Load stats for cumulative upline data
	cumUpSuccessfulSessions			= ini.GetInt(L"UpSuccessfulSessions");
	cumUpFailedSessions				= ini.GetInt(L"UpFailedSessions");
	cumUpAvgTime					= ini.GetInt(L"UpAvgTime");

	// Load cumulative client breakdown stats for sent bytes
	cumUpData_EDONKEY				= ini.GetUInt64(L"UpData_EDONKEY");
	cumUpData_EDONKEYHYBRID			= ini.GetUInt64(L"UpData_EDONKEYHYBRID");
	cumUpData_EMULE					= ini.GetUInt64(L"UpData_EMULE");
	cumUpData_MLDONKEY				= ini.GetUInt64(L"UpData_MLDONKEY");
	cumUpData_EMULECOMPAT			= ini.GetUInt64(L"UpData_LMULE");
	cumUpData_AMULE					= ini.GetUInt64(L"UpData_AMULE");
	cumUpData_SHAREAZA				= ini.GetUInt64(L"UpData_SHAREAZA");

	// Load cumulative port breakdown stats for sent bytes
	cumUpDataPort_4662				= ini.GetUInt64(L"UpDataPort_4662");
	cumUpDataPort_OTHER				= ini.GetUInt64(L"UpDataPort_OTHER");
	cumUpDataPort_PeerCache			= ini.GetUInt64(L"UpDataPort_PeerCache");

	// Load cumulative source breakdown stats for sent bytes
	cumUpData_File					= ini.GetUInt64(L"UpData_File");
	cumUpData_Partfile				= ini.GetUInt64(L"UpData_Partfile");

	// Load stats for cumulative downline data
	cumDownCompletedFiles			= ini.GetInt(L"DownCompletedFiles");
	cumDownSuccessfulSessions		= ini.GetInt(L"DownSuccessfulSessions");
	cumDownFailedSessions			= ini.GetInt(L"DownFailedSessions");
	cumDownAvgTime					= ini.GetInt(L"DownAvgTime");

	// Cumulative statistics for saved due to compression/lost due to corruption
	cumLostFromCorruption			= ini.GetUInt64(L"LostFromCorruption");
	cumSavedFromCompression			= ini.GetUInt64(L"SavedFromCompression");
	cumPartsSavedByICH				= ini.GetInt(L"PartsSavedByICH");

	// Load cumulative client breakdown stats for received bytes
	cumDownData_EDONKEY				= ini.GetUInt64(L"DownData_EDONKEY");
	cumDownData_EDONKEYHYBRID		= ini.GetUInt64(L"DownData_EDONKEYHYBRID");
	cumDownData_EMULE				= ini.GetUInt64(L"DownData_EMULE");
	cumDownData_MLDONKEY			= ini.GetUInt64(L"DownData_MLDONKEY");
	cumDownData_EMULECOMPAT			= ini.GetUInt64(L"DownData_LMULE");
	cumDownData_AMULE				= ini.GetUInt64(L"DownData_AMULE");
	cumDownData_SHAREAZA			= ini.GetUInt64(L"DownData_SHAREAZA");
	cumDownData_URL					= ini.GetUInt64(L"DownData_URL");
#ifdef WEBCACHE // NEO: WC - [WebCache] -- Xanatos -->
	cumDownData_WEBCACHE			= ini.GetUInt64(L"DownData_WEBCACHE"); // Superlexx - webcache - statistics
#endif // NEO: WC END <-- Xanatos --

	// Load cumulative port breakdown stats for received bytes
	cumDownDataPort_4662			= ini.GetUInt64(L"DownDataPort_4662");
	cumDownDataPort_OTHER			= ini.GetUInt64(L"DownDataPort_OTHER");
	cumDownDataPort_PeerCache		= ini.GetUInt64(L"DownDataPort_PeerCache");

	// Load stats for cumulative connection data
	cumConnAvgDownRate				= ini.GetFloat(L"ConnAvgDownRate");
	cumConnMaxAvgDownRate			= ini.GetFloat(L"ConnMaxAvgDownRate");
	cumConnMaxDownRate				= ini.GetFloat(L"ConnMaxDownRate");
	cumConnAvgUpRate				= ini.GetFloat(L"ConnAvgUpRate");
	cumConnMaxAvgUpRate				= ini.GetFloat(L"ConnMaxAvgUpRate");
	cumConnMaxUpRate				= ini.GetFloat(L"ConnMaxUpRate");
	cumConnRunTime					= ini.GetInt(L"ConnRunTime");
	cumConnTransferTime				= ini.GetInt(L"ConnTransferTime");
	cumConnDownloadTime				= ini.GetInt(L"ConnDownloadTime");
	cumConnUploadTime				= ini.GetInt(L"ConnUploadTime");
	cumConnServerDuration			= ini.GetInt(L"ConnServerDuration");
	cumConnNumReconnects			= ini.GetInt(L"ConnNumReconnects");
	cumConnAvgConnections			= ini.GetInt(L"ConnAvgConnections");
	cumConnMaxConnLimitReached		= ini.GetInt(L"ConnMaxConnLimitReached");
	cumConnPeakConnections			= ini.GetInt(L"ConnPeakConnections");

	// Load date/time of last reset
	stat_datetimeLastReset			= ini.GetInt(L"statsDateTimeLastReset");

	// Smart Load For Restores - Don't overwrite records that are greater than the backed up ones
	if (loadBackUp == 1)
	{
		// Load records for servers / network
		if ((UINT)ini.GetInt(L"SrvrsMostWorkingServers") > cumSrvrsMostWorkingServers)
			cumSrvrsMostWorkingServers = ini.GetInt(L"SrvrsMostWorkingServers");

		if ((UINT)ini.GetInt(L"SrvrsMostUsersOnline") > cumSrvrsMostUsersOnline)
			cumSrvrsMostUsersOnline = ini.GetInt(L"SrvrsMostUsersOnline");

		if ((UINT)ini.GetInt(L"SrvrsMostFilesAvail") > cumSrvrsMostFilesAvail)
			cumSrvrsMostFilesAvail = ini.GetInt(L"SrvrsMostFilesAvail");

		// Load records for shared files
		if ((UINT)ini.GetInt(L"SharedMostFilesShared") > cumSharedMostFilesShared)
			cumSharedMostFilesShared =	ini.GetInt(L"SharedMostFilesShared");

		uint64 temp64 = ini.GetUInt64(L"SharedLargestShareSize");
		if (temp64 > cumSharedLargestShareSize)
			cumSharedLargestShareSize = temp64;

		temp64 = ini.GetUInt64(L"SharedLargestAvgFileSize");
		if (temp64 > cumSharedLargestAvgFileSize)
			cumSharedLargestAvgFileSize = temp64;

		temp64 = ini.GetUInt64(L"SharedLargestFileSize");
		if (temp64 > cumSharedLargestFileSize)
			cumSharedLargestFileSize = temp64;

		// Check to make sure the backup of the values we just overwrote exists.  If so, rename it to the backup file.
		// This allows us to undo a restore, so to speak, just in case we don't like the restored values...
		CString sINIBackUp;
		sINIBackUp.Format(L"%sstatbkuptmp.ini", configdir);
		if (findBackUp.FindFile(sINIBackUp)){
			CFile::Remove(sINI);				// Remove the backup that we just restored from
			CFile::Rename(sINIBackUp, sINI);	// Rename our temporary backup to the normal statbkup.ini filename.
		}

		// Since we know this is a restore, now we should call ShowStatistics to update the data items to the new ones we just loaded.
		// Otherwise user is left waiting around for the tick counter to reach the next automatic update (Depending on setting in prefs)
		theApp.emuledlg->statisticswnd->ShowStatistics();
	}
	// Stupid Load -> Just load the values.
	else
	{
		// Load records for servers / network
		cumSrvrsMostWorkingServers	= ini.GetInt(L"SrvrsMostWorkingServers");
		cumSrvrsMostUsersOnline		= ini.GetInt(L"SrvrsMostUsersOnline");
		cumSrvrsMostFilesAvail		= ini.GetInt(L"SrvrsMostFilesAvail");

		// Load records for shared files
		cumSharedMostFilesShared	= ini.GetInt(L"SharedMostFilesShared");
		cumSharedLargestShareSize	= ini.GetUInt64(L"SharedLargestShareSize");
		cumSharedLargestAvgFileSize = ini.GetUInt64(L"SharedLargestAvgFileSize");
		cumSharedLargestFileSize	= ini.GetUInt64(L"SharedLargestFileSize");

		// Initialize new session statistic variables...
		sesDownCompletedFiles		= 0;
		
		sesUpData_EDONKEY			= 0;
		sesUpData_EDONKEYHYBRID		= 0;
		sesUpData_EMULE				= 0;
		sesUpData_MLDONKEY			= 0;
		sesUpData_AMULE				= 0;
		sesUpData_EMULECOMPAT		= 0;
		sesUpData_SHAREAZA			= 0;
		sesUpDataPort_4662			= 0;
		sesUpDataPort_OTHER			= 0;
		sesUpDataPort_PeerCache		= 0;

		sesDownData_EDONKEY			= 0;
		sesDownData_EDONKEYHYBRID	= 0;
		sesDownData_EMULE			= 0;
		sesDownData_MLDONKEY		= 0;
		sesDownData_AMULE			= 0;
		sesDownData_EMULECOMPAT		= 0;
		sesDownData_SHAREAZA		= 0;
		sesDownData_URL				= 0;
#ifdef WEBCACHE // NEO: WC - [WebCache] -- Xanatos -->
		sesDownData_WEBCACHE		= 0; // Superlexx - webcache - statistics
		ses_WEBCACHEREQUESTS		= 0; //jp webcache statistics (from proxy)
		ses_successfull_WCDOWNLOADS	= 0; //jp webcache statistics (from proxy)
		ses_PROXYREQUESTS           = 0; //jp webcache statistics (via proxy)
		ses_successfullPROXYREQUESTS= 0; //jp webcache statistics (via proxy)
#endif // NEO: WC END <-- Xanatos --
		sesDownDataPort_4662		= 0;
		sesDownDataPort_OTHER		= 0;
		sesDownDataPort_PeerCache	= 0;

		sesDownSuccessfulSessions	= 0;
		sesDownFailedSessions		= 0;
		sesPartsSavedByICH			= 0;
	}

	if (!fileex || (stat_datetimeLastReset==0 && totalDownloadedBytes==0 && totalUploadedBytes==0))
	{
		time_t timeNow;
		time(&timeNow);
		stat_datetimeLastReset = timeNow;
	}

	return true;
}

// This formats the UTC long value that is saved for stat_datetimeLastReset
// If this value is 0 (Never reset), then it returns Unknown.
CString CPreferences::GetStatsLastResetStr(bool formatLong)
{
	// formatLong dictates the format of the string returned.
	// For example...
	// true: DateTime format from the .ini
	// false: DateTime format from the .ini for the log
	CString	returnStr;
	if (GetStatsLastResetLng()) {
		tm *statsReset;
		TCHAR szDateReset[128];
		time_t lastResetDateTime = (time_t) GetStatsLastResetLng();
		statsReset = localtime(&lastResetDateTime);
		if (statsReset){
			_tcsftime(szDateReset, ARRSIZE(szDateReset), formatLong ? GetDateTimeFormat() : L"%c", statsReset);
			returnStr = szDateReset;
		}
	}
	if (returnStr.IsEmpty())
		returnStr = GetResString(IDS_UNKNOWN);
	return returnStr;
}

// <-----khaos-

bool CPreferences::Save(){

	bool error = false;
	TCHAR* fullpath = new TCHAR[_tcslen(configdir)+MAX_PATH]; // i_a
	_stprintf(fullpath,L"%spreferences.dat",configdir);

	FILE* preffile = _tfsopen(fullpath,L"wb", _SH_DENYWR);
	delete[] fullpath;
	prefsExt->version = PREFFILE_VERSION;
	if (preffile){
		prefsExt->version=PREFFILE_VERSION;
		prefsExt->EmuleWindowPlacement=EmuleWindowPlacement;
		md4cpy(prefsExt->userhash, userhash);

		error = fwrite(prefsExt,sizeof(Preferences_Ext_Struct),1,preffile)!=1;
		if (thePrefs.GetCommitFiles() >= 2 || (thePrefs.GetCommitFiles() >= 1 && !theApp.emuledlg->IsRunning())){
			fflush(preffile); // flush file stream buffers to disk buffers
			(void)_commit(_fileno(preffile)); // commit disk buffers to disk
		}
		fclose(preffile);
	}
	else
		error = true;

	SavePreferences();
	// NEO: NCFG - [NeoConfiguration] -- Xanatos -->
	thePrefs.SaveNeoPreferences();
	if(SaveVirtualDirs()) // NEO: VSF - [VirtualSharedFiles]
		error = true;
	SaveStats();
#ifdef A4AF_CATS // NEO: MAC - [MorphA4AFCategories]
	SaveCats();
#endif // A4AF_CATS // NEO: MAC END
	if(SaveTempDirs()) // NEO: MTD - [MultiTempDirectories]
		error = true;
	if(SaveSharedDirs()) // NEO: SSD - [ShareSubDirectories]
		error = true;
	if(SaveSharedFiles()) // NEO: SSF - [ShareSingleFiles]
		error = true;
	// NEO: NCFG END <-- Xanatos --

	::CreateDirectory(GetIncomingDir(),0);
	::CreateDirectory(GetTempDir(),0);
	return error;
}

void CPreferences::CreateUserHash()
{
	for (int i = 0; i < 8; i++)
	{
		uint16 random = GetRandomUInt16();
		memcpy(&userhash[i*2], &random, 2);
	}

	// mark as emule client. that will be need in later version
	userhash[5] = 14;
	userhash[14] = 111;
}

int CPreferences::GetRecommendedMaxConnections() {
	int iRealMax = ::GetMaxWindowsTCPConnections();
	if(iRealMax == -1 || iRealMax > 520)
		return 500;

	if(iRealMax < 20)
		return iRealMax;

	if(iRealMax <= 256)
		return iRealMax - 10;

	return iRealMax - 20;
}

void CPreferences::SavePreferences()
{
	CString buffer;
	
	CIni ini(GetConfigFile(), L"eMule");
	//---
	//ini.WriteString(L"AppVersion", theApp.m_strCurVersionLong); // NEO: MOD <-- Xanatos --
	//---

#ifdef _DEBUG
	ini.WriteInt(L"DebugHeap", m_iDbgHeap);
#endif

	ini.WriteStringUTF8(L"Nick", strNick);
	ini.WriteString(L"IncomingDir", incomingdir);
	// NEO: MTD - [MultiTempDirectories] -- Xanatos -->
	ini.WriteString(L"TempDir", tempdir);
	ini.WriteInt(L"CurrentTempDir", use_tempdir); 
	// NEO: MTD END <-- Xanatos --

#ifndef NEO_BC // NEO: NBC -- Xanatos -->
    ini.WriteInt(L"MinUpload", minupload);
#endif // NEO_BC // NEO: NBC END <-- Xanatos --
	ini.WriteInt(L"MaxUpload",maxupload);
	ini.WriteInt(L"MaxDownload",maxdownload);
	ini.WriteInt(L"MaxConnections",maxconnections);
	ini.WriteInt(L"MaxHalfConnections",maxhalfconnections);
	ini.WriteBool(L"ConditionalTCPAccept", m_bConditionalTCPAccept);
	ini.WriteInt(L"Port",port);
	ini.WriteInt(L"UDPPort",udpport);
	ini.WriteInt(L"KADPort",kadport); // NEO: KAX - [KadAuxPort] <-- Xanatos --
	ini.WriteInt(L"ServerUDPPort", nServerUDPPort);
	//ini.WriteInt(L"MaxSourcesPerFile",maxsourceperfile ); // NEO: NST - [NeoSourceTweaks] <-- Xanatos --
	ini.WriteWORD(L"Language",m_wLanguageID);
	ini.WriteInt(L"SeeShare",m_iSeeShares);
	ini.WriteInt(L"ToolTipDelay",m_iToolDelayTime);
	ini.WriteInt(L"StatGraphsInterval",trafficOMeterInterval);
	ini.WriteInt(L"StatsInterval",statsInterval);
	ini.WriteBool(L"DontCompressBlocks",dontcompressblocks); // NEO: MOD <-- Xanatos --
	ini.WriteBool(L"DontCompressAvi",dontcompressavi); // NEO: MOD <-- Xanatos --
	ini.WriteInt(L"DownloadCapacity",maxGraphDownloadRate);
	ini.WriteInt(L"UploadCapacityNew",maxGraphUploadRate);
	ini.WriteInt(L"DeadServerRetry",m_uDeadServerRetries);
	ini.WriteInt(L"ServerKeepAliveTimeout",m_dwServerKeepAliveTimeout);
	ini.WriteInt(L"SplitterbarPosition",splitterbarPosition+2);
	ini.WriteInt(L"SplitterbarPositionServer",splitterbarPositionSvr);
	ini.WriteInt(L"SplitterbarPositionStat",splitterbarPositionStat+1);
	ini.WriteInt(L"SplitterbarPositionStat_HL",splitterbarPositionStat_HL+1);
	ini.WriteInt(L"SplitterbarPositionStat_HR",splitterbarPositionStat_HR+1);
	ini.WriteInt(L"SplitterbarPositionFriend",splitterbarPositionFriend);
	ini.WriteInt(L"SplitterbarPositionIRC",splitterbarPositionIRC+2);
	ini.WriteInt(L"SplitterbarPositionShared",splitterbarPositionShared);
	ini.WriteInt(L"TransferWnd1",m_uTransferWnd1);
	ini.WriteInt(L"TransferWnd2",m_uTransferWnd2);
	ini.WriteInt(L"LastCategory",m_uLastCategory); // NEO: MAC - [MorphA4AFCategories] <-- Xanatos --
	ini.WriteInt(L"VariousStatisticsMaxValue",statsMax);
	ini.WriteInt(L"StatsAverageMinutes",statsAverageMinutes);
	ini.WriteInt(L"MaxConnectionsPerFiveSeconds",MaxConperFive);
	ini.WriteInt(L"Check4NewVersionDelay",versioncheckdays);

	ini.WriteBool(L"Reconnect",reconnect);
	ini.WriteBool(L"Scoresystem",m_bUseServerPriorities);
	ini.WriteBool(L"ICH", ICH); // NEO: MOD <-- Xanatos --
	ini.WriteBool(L"Serverlist",m_bAutoUpdateServerList);
	ini.WriteBool(L"UpdateNotifyTestClient",updatenotify);
	ini.WriteBool(L"MinToTray",mintotray);
	ini.WriteBool(L"AddServersFromServer",m_bAddServersFromServer);
	ini.WriteBool(L"AddServersFromClient",m_bAddServersFromClients);
	ini.WriteBool(L"Splashscreen",splashscreen);
	ini.WriteBool(L"BringToFront",bringtoforeground);
	ini.WriteBool(L"TransferDoubleClick",transferDoubleclick);
	ini.WriteBool(L"BeepOnError",beepOnError);
	ini.WriteBool(L"ConfirmExit",confirmExit);
	ini.WriteBool(L"FilterBadIPs",filterLANIPs);
    ini.WriteBool(L"Autoconnect",autoconnect);
	ini.WriteBool(L"OnlineSignature",onlineSig);
	ini.WriteInt(L"StartupMinimized",startMinimized); // NEO: MOD <-- Xanatos --
	ini.WriteBool(L"AutoStart",m_bAutoStart);
	ini.WriteBool(L"RestoreLastMainWndDlg",m_bRestoreLastMainWndDlg); // NEO: MOD <-- Xanatos --
	ini.WriteInt(L"LastMainWndDlgID",m_iLastMainWndDlgID);
	ini.WriteBool(L"RestoreLastLogPane",m_bRestoreLastLogPane); // NEO: MOD <-- Xanatos --
	ini.WriteInt(L"LastLogPaneID",m_iLastLogPaneID);
	ini.WriteBool(L"SafeServerConnect",m_bSafeServerConnect);
	ini.WriteBool(L"ShowRatesOnTitle",showRatesInTitle);
	ini.WriteBool(L"IconflashOnNewMessage",m_bIconflashOnNewMessage); // NEO: MOD <-- Xanatos --
	ini.WriteBool(L"IndicateRatings",indicateratings);
	ini.WriteBool(L"WatchClipboard4ED2kFilelinks",watchclipboard);
	ini.WriteInt(L"SearchMethod",m_iSearchMethod);
	ini.WriteBool(L"CheckDiskspace",checkDiskspace);
	ini.WriteInt(L"MinFreeDiskSpace",m_uMinFreeDiskSpace);
	ini.WriteBool(L"SparsePartFiles",m_bSparsePartFiles);
	ini.WriteString(L"YourHostname",m_strYourHostname);

	// Barry - New properties...
    ini.WriteBool(L"AutoConnectStaticOnly", m_bAutoConnectToStaticServersOnly);
	ini.WriteBool(L"AutoTakeED2KLinks", autotakeed2klinks);
    ini.WriteBool(L"AddNewFilesPaused", addnewfilespaused);
    ini.WriteInt (L"3DDepth", depth3D);  
	//ini.WriteBool(L"MiniMule", m_bEnableMiniMule);

	ini.WriteString(L"NotifierConfiguration", notifierConfiguration);
	ini.WriteBool(L"NotifyOnDownload", notifierOnDownloadFinished);
	ini.WriteBool(L"NotifyOnNewDownload", notifierOnNewDownload);
	ini.WriteBool(L"NotifyOnChat", notifierOnChat);
	ini.WriteBool(L"NotifyOnLog", notifierOnLog);
	ini.WriteBool(L"NotifyOnImportantError", notifierOnImportantError);
	ini.WriteBool(L"NotifierPopEveryChatMessage", notifierOnEveryChatMsg);
	ini.WriteBool(L"NotifierPopNewVersion", notifierOnNewVersion);
	ini.WriteInt(L"NotifierUseSound", (int)notifierSoundType);
	ini.WriteString(L"NotifierSoundPath", notifierSoundFile);

	ini.WriteString(L"TxtEditor",TxtEditor);
	ini.WriteString(L"VideoPlayer",m_strVideoPlayer);
	ini.WriteString(L"VideoPlayerArgs",m_strVideoPlayerArgs);
	ini.WriteString(L"MessageFilter",messageFilter);
	ini.WriteString(L"CommentFilter",commentFilter);
	ini.WriteString(L"DateTimeFormat",GetDateTimeFormat());
	ini.WriteString(L"DateTimeFormat4Log",GetDateTimeFormat4Log());
	ini.WriteString(L"WebTemplateFile",m_sTemplateFile);
	ini.WriteString(L"FilenameCleanups",filenameCleanups);
	ini.WriteInt(L"ExtractMetaData",m_iExtractMetaData);

	ini.WriteString(L"DefaultIRCServerNew",m_sircserver);
	ini.WriteString(L"IRCNick",m_sircnick);
	ini.WriteBool(L"IRCAddTimestamp", m_bircaddtimestamp);
	ini.WriteString(L"IRCFilterName", m_sircchannamefilter);
	ini.WriteInt(L"IRCFilterUser", m_iircchanneluserfilter);
	ini.WriteBool(L"IRCUseFilter", m_bircusechanfilter);
	ini.WriteString(L"IRCPerformString", m_sircperformstring);
	ini.WriteBool(L"IRCUsePerform", m_bircuseperform);
	ini.WriteBool(L"IRCListOnConnect", m_birclistonconnect);
	ini.WriteBool(L"IRCAcceptLink", m_bircacceptlinks);
	ini.WriteBool(L"IRCAcceptLinkFriends", m_bircacceptlinksfriends);
	ini.WriteBool(L"IRCSoundEvents", m_bircsoundevents);
	ini.WriteBool(L"IRCIgnoreMiscMessages", m_bircignoremiscmessage);
	ini.WriteBool(L"IRCIgnoreJoinMessages", m_bircignorejoinmessage);
	ini.WriteBool(L"IRCIgnorePartMessages", m_bircignorepartmessage);
	ini.WriteBool(L"IRCIgnoreQuitMessages", m_bircignorequitmessage);
	ini.WriteBool(L"IRCIgnoreEmuleProtoAddFriend", m_bircignoreemuleprotoaddfriend);
	ini.WriteBool(L"IRCAllowEmuleProtoAddFriend", m_bircallowemuleprotoaddfriend);
	ini.WriteBool(L"IRCIgnoreEmuleProtoSendLink", m_bircignoreemuleprotosendlink);
	ini.WriteBool(L"IRCHelpChannel", m_birchelpchannel);
	ini.WriteBool(L"SmartIdCheck", m_bSmartServerIdCheck);
	ini.WriteBool(L"Verbose", m_bVerbose);
	ini.WriteBool(L"DebugSourceExchange", m_bDebugSourceExchange);	// do *not* use the according 'Get...' function here!
	ini.WriteBool(L"LogBannedClients", m_bLogBannedClients);			// do *not* use the according 'Get...' function here!
	ini.WriteBool(L"LogRatingDescReceived", m_bLogRatingDescReceived);// do *not* use the according 'Get...' function here!
	ini.WriteBool(L"LogSecureIdent", m_bLogSecureIdent);				// do *not* use the according 'Get...' function here!
	ini.WriteBool(L"LogFilteredIPs", m_bLogFilteredIPs);				// do *not* use the according 'Get...' function here!
	ini.WriteBool(L"LogFileSaving", m_bLogFileSaving);				// do *not* use the according 'Get...' function here!
    ini.WriteBool(L"LogA4AF", m_bLogA4AF);                           // do *not* use the according 'Get...' function here!
	ini.WriteBool(L"LogUlDlEvents", m_bLogUlDlEvents);
	ini.WriteBool(L"LogAICHEvents", m_bLogAICHEvents); // NEO: MOD - [LogAICH] <-- Xanatos --
#if defined(_DEBUG) || defined(USE_DEBUG_DEVICE)
	// following options are for debugging or when using an external debug device viewer only.
	ini.WriteInt(L"DebugServerTCP",m_iDebugServerTCPLevel);
	ini.WriteInt(L"DebugServerUDP",m_iDebugServerUDPLevel);
	ini.WriteInt(L"DebugServerSources",m_iDebugServerSourcesLevel);
	ini.WriteInt(L"DebugServerSearches",m_iDebugServerSearchesLevel);
	ini.WriteInt(L"DebugClientTCP",m_iDebugClientTCPLevel);
	ini.WriteInt(L"DebugClientUDP",m_iDebugClientUDPLevel);
	ini.WriteInt(L"DebugClientKadUDP",m_iDebugClientKadUDPLevel);
#endif
	ini.WriteBool(L"PreviewPrio", m_bpreviewprio);
	ini.WriteBool(L"UpdateQueueListPref", m_bupdatequeuelist);
	ini.WriteBool(L"ManualHighPrio", m_bManualAddedServersHighPriority);
	ini.WriteBool(L"FullChunkTransfers", m_btransferfullchunks);
	ini.WriteBool(L"ShowOverhead", m_bshowoverhead);
	ini.WriteBool(L"VideoPreviewBackupped", moviePreviewBackup);
	ini.WriteInt(L"PreviewSmallBlocks",m_iPreviewSmallBlocks); // NEO: MOD <-- Xanatos --
	ini.WriteBool(L"PreviewCopiedArchives", m_bPreviewCopiedArchives); // NEO: MOD <-- Xanatos --
	ini.WriteInt(L"InspectAllFileTypes", m_iInspectAllFileTypes); // NEO: MOD <-- Xanatos --
	ini.WriteInt(L"StartNextFile", m_istartnextfile);

	//ini.DeleteKey(L"FileBufferSizePref"); // delete old 'file buff size' setting
	ini.WriteInt(L"FileBufferSize", m_iFileBufferSize);
	ini.WriteInt(L"FileBufferTime", m_iFileBufferTime); // NEO: MOD - [BufferCustomisation] <-- Xanatos --

	//ini.DeleteKey(L"QueueSizePref"); // delete old 'queue size' setting
	ini.WriteInt(L"QueueSize", m_iQueueSize);

	ini.WriteInt(L"CommitFiles", m_iCommitFiles);
	ini.WriteBool(L"DAPPref", m_bDAP);
	ini.WriteBool(L"UAPPref", m_bUAP);
	ini.WriteBool(L"PreviewOnIconDblClk",m_bPreviewOnIconDblClk); // NEO: MOD <-- Xanatos --
	ini.WriteBool(L"FilterServersByIP",filterserverbyip);
	ini.WriteBool(L"DisableKnownClientList",m_bDisableKnownClientList);
	ini.WriteBool(L"DisableQueueList",m_bDisableQueueList);
	ini.WriteBool(L"UseCreditSystem",m_bCreditSystem);
	ini.WriteBool(L"SaveLogToDisk",log2disk);
	ini.WriteInt(L"MaxLogFileSize", uMaxLogFileSize); // NEO: MOD <-- Xanatos --
	ini.WriteInt(L"MaxLogBuff", iMaxLogBuff/1024); // NEO: MOD <-- Xanatos --
	ini.WriteInt(L"LogFileFormat", (int)m_iLogFileFormat); // NEO: MOD <-- Xanatos --
	ini.WriteBool(L"SaveDebugToDisk",debug2disk);
	ini.WriteBool(L"EnableScheduler",scheduler);
	ini.WriteBool(L"MessagesFromFriendsOnly",msgonlyfriends);
	ini.WriteBool(L"MessageFromValidSourcesOnly",msgsecure);
	ini.WriteInt(L"ShowInfoOnCatTabs",showCatTabInfos); // NEO: MOD - [MoreCategoryInfo] <-- Xanatos --
	ini.WriteBool(L"DontRecreateStatGraphsOnResize",dontRecreateGraphs);
	ini.WriteBool(L"AutoFilenameCleanup",autofilenamecleanup);
	ini.WriteBool(L"ShowExtControls",m_bExtControls);
	ini.WriteBool(L"UseAutocompletion",m_bUseAutocompl);
	ini.WriteBool(L"NetworkKademlia",networkkademlia);
	ini.WriteBool(L"NetworkED2K",networked2k);
	ini.WriteBool(L"AutoClearCompleted",m_bRemoveFinishedDownloads);
	ini.WriteBool(L"TransflstRemainOrder",m_bTransflstRemain);
	ini.WriteInt(L"UseSimpleTimeRemainingcomputation",m_uUseOldTimeRemaining); // NEO: MOD <-- Xanatos --
	ini.WriteBool(L"AllocateFullFile",m_bAllocFull);

	ini.WriteInt(L"VersionCheckLastAutomatic", versioncheckLastAutomatic);
	ini.WriteInt(L"FilterLevel",filterlevel);

	ini.WriteBool(L"SecureIdent", m_bUseSecureIdent);// change the name in future version to enable it by default
	ini.WriteBool(L"AdvancedSpamFilter",m_bAdvancedSpamfilter);
	ini.WriteInt(L"ShowDwlPercentage",m_uShowDwlPercentage); // NEO: MOD - [Percentage] <-- Xanatos --
	ini.WriteBool(L"RemoveFilesToBin",m_bRemove2bin);
	ini.WriteBool(L"ShowCopyEd2kLinkCmd",m_bShowCopyEd2kLinkCmd);
	ini.WriteBool(L"AutoArchivePreviewStart", m_bAutomaticArcPreviewStart);
	ini.WriteInt(L"MaxChatHistoryLines",m_iMaxChatHistory); // NEO: MOD <-- Xanatos --
	ini.WriteInt(L"MaxMessageSessions",maxmsgsessions); // NEO: MOD <-- Xanatos --
	ini.WriteBool(L"ShowActiveDownloadsBold", m_bShowActiveDownloadsBold); // NEO: MOD <-- Xanatos --

	// Toolbar
	ini.WriteString(L"ToolbarSetting", m_sToolbarSettings);
	ini.WriteString(L"ToolbarBitmap", m_sToolbarBitmap );
	ini.WriteString(L"ToolbarBitmapFolder", m_sToolbarBitmapFolder);
	ini.WriteInt(L"ToolbarLabels", m_nToolbarLabels);
	ini.WriteInt(L"ToolbarIconSize", m_sizToolbarIconSize.cx);
	ini.WriteBool(L"ReBarToolbar", m_bReBarToolbar); // NEO: MOD <-- Xanatos --
	ini.WriteBool(L"RTLWindowsLayout",m_bRTLWindowsLayout); // NEO: MOD <-- Xanatos --
	ini.WriteInt(L"StraightWindowStyles",m_iStraightWindowStyles); // NEO: MOD <-- Xanatos --
	ini.WriteString(L"SkinProfile", m_strSkinProfile);
	ini.WriteString(L"SkinProfileDir", m_strSkinProfileDir);

	ini.WriteBinary(L"HyperTextFont", (LPBYTE)&m_lfHyperText, sizeof m_lfHyperText);
	ini.WriteBinary(L"LogTextFont", (LPBYTE)&m_lfLogText, sizeof m_lfLogText);

	ini.WriteColRef(L"LogErrorColor", m_crLogError); // NEO: MOD <-- Xanatos --
	ini.WriteColRef(L"LogWarningColor", m_crLogWarning); // NEO: MOD <-- Xanatos --
	ini.WriteColRef(L"LogSuccessColor", m_crLogSuccess); // NEO: MOD <-- Xanatos --

#ifndef NEO_BC // NEO: NBC -- Xanatos -->
	// ZZ:UploadSpeedSense -->
    ini.WriteBool(L"USSEnabled", m_bDynUpEnabled);
    ini.WriteBool(L"USSUseMillisecondPingTolerance", m_bDynUpUseMillisecondPingTolerance);
    ini.WriteInt(L"USSPingTolerance", m_iDynUpPingTolerance);
	ini.WriteInt(L"USSPingToleranceMilliseconds", m_iDynUpPingToleranceMilliseconds); // EastShare - Add by TAHO, USS limit
    ini.WriteInt(L"USSGoingUpDivider", m_iDynUpGoingUpDivider);
    ini.WriteInt(L"USSGoingDownDivider", m_iDynUpGoingDownDivider);
    ini.WriteInt(L"USSNumberOfPings", m_iDynUpNumberOfPings);
	// ZZ:UploadSpeedSense <--
#endif // NEO_BC // NEO: NBC END <-- Xanatos --

    ini.WriteBool(L"A4AFSaveCpu", m_bA4AFSaveCpu); // ZZ:DownloadManager
    ini.WriteBool(L"HighresTimer", m_bHighresTimer);
	ini.WriteInt(L"WebMirrorAlertLevel", m_nWebMirrorAlertLevel);
	ini.WriteBool(L"RunAsUnprivilegedUser", m_bRunAsUser);
	ini.WriteBool(L"PreferRestrictedOverUser", m_bPreferRestrictedOverUser); // NEO: MOD <-- Xanatos --
	//ini.WriteBool(L"OpenPortsOnStartUp", m_bOpenPortsOnStartUp); // NEO: IFWS <-- Xanatos --
	ini.WriteInt(L"DebugLogLevel", m_byLogLevel);
	ini.WriteBool(L"AICHTrustEveryHash", m_bTrustEveryHash); // NEO: MOD <-- Xanatos --
	ini.WriteBool(L"RememberAICH", m_bRememberAICH); // NEO: MOD - [RemoveUnusedAICHhashes] <-- Xanatos --
	ini.WriteInt(L"WinXPSP2", IsRunningXPSP2());
	ini.WriteBool(L"RememberCancelledFiles", m_bRememberCancelledFiles);
	ini.WriteBool(L"RememberDownloadedFiles", m_bRememberDownloadedFiles);

	ini.WriteBool(L"NotifierSendMail", m_bNotifierSendMail);
	ini.WriteString(L"NotifierMailSender", m_strNotifierMailSender);
	ini.WriteString(L"NotifierMailServer", m_strNotifierMailServer);
	ini.WriteString(L"NotifierMailRecipient", m_strNotifierMailReceiver);

	ini.WriteBool(L"WinaTransToolbar", m_bWinaTransToolbar);

	ini.WriteBool(L"CryptLayerRequested", m_bCryptLayerRequested);
	ini.WriteBool(L"CryptLayerRequired", m_bCryptLayerRequired);
	ini.WriteBool(L"CryptLayerSupported", m_bCryptLayerSupported);	


	///////////////////////////////////////////////////////////////////////////
	// Section: "Proxy"
	//
	ini.WriteBool(L"ProxyEnablePassword",proxy.EnablePassword,L"Proxy");
	ini.WriteBool(L"ProxyEnableProxy",proxy.UseProxy,L"Proxy");
	ini.WriteString(L"ProxyName",CStringW(proxy.name),L"Proxy");
	ini.WriteString(L"ProxyPassword",CStringW(proxy.password),L"Proxy");
	ini.WriteString(L"ProxyUser",CStringW(proxy.user),L"Proxy");
	ini.WriteInt(L"ProxyPort",proxy.port,L"Proxy");
	ini.WriteInt(L"ProxyType",proxy.type,L"Proxy");


	///////////////////////////////////////////////////////////////////////////
	// Section: "Statistics"
	//
	ini.WriteInt(L"statsConnectionsGraphRatio", statsConnectionsGraphRatio,L"Statistics");
	ini.WriteInt(L"statsMemoryGraphRatio", statsMemoryGraphRatio,L"Statistics"); // NEO: SI - [SysInfo] <-- Xanatos --
	ini.WriteInt(L"statsTransferGraphRatio", statsTransferGraphRatio,L"Statistics"); // NEO: SI - [SysInfo] <-- Xanatos --
	ini.WriteInt(L"statsSourceGraphRatio", statsSourceGraphRatio,L"Statistics"); // NEO: SI - [SysInfo] <-- Xanatos --

	ini.WriteString(L"statsExpandedTreeItems", statsExpandedTreeItems);
	CString buffer2;
	for (int i=0;i<GetNumStatsColors();i++) { // NEO: MOD - [NeoStats] <-- Xanatos --
		buffer.Format(L"0x%06x",GetStatsColor(i));
		buffer2.Format(L"StatColor%i",i);
		ini.WriteString(buffer2,buffer,L"Statistics" );
	}
	ini.WriteBool(L"ShowVerticalHourMarkers", m_bShowVerticalHourMarkers, L"Statistics"); // NEO: MOD <-- Xanatos --


	///////////////////////////////////////////////////////////////////////////
	// Section: "WebServer"
	//
	ini.WriteBool(L"UseAdvWebsrv", m_bAdvWebsrv); // NEO: WAM - [WebInterfaceAccountManagement] <-- Xanatos --
	ini.WriteString(L"Password", GetWSPass(), L"WebServer");
	ini.WriteString(L"PasswordLow", GetWSLowPass());
	ini.WriteInt(L"Port", m_nWebPort);
	ini.WriteBool(L"Enabled", m_bWebEnabled);
	ini.WriteBool(L"UseGzip", m_bWebUseGzip);
	ini.WriteInt(L"PageRefreshTime", m_nWebPageRefresh);
	ini.WriteBool(L"UseLowRightsUser", m_bWebLowEnabled);
	ini.WriteBool(L"AllowAdminHiLevelFunc",m_bAllowAdminHiLevFunc);
	ini.WriteInt(L"WebTimeoutMins", m_iWebTimeoutMins);
	ini.WriteInt(L"MaxFileUploadSizeMB", m_iWebFileUploadSizeLimitMB ); // NEO: MOD <-- Xanatos --


	///////////////////////////////////////////////////////////////////////////
	// Section: "MobileMule"
	//
	ini.WriteString(L"Password", GetMMPass(), L"MobileMule");
	ini.WriteBool(L"Enabled", m_bMMEnabled);
	ini.WriteInt(L"Port", m_nMMPort);


	///////////////////////////////////////////////////////////////////////////
	// Section: "PeerCache"
	//
	ini.WriteInt(L"LastSearch", m_uPeerCacheLastSearch, L"PeerCache");
	ini.WriteBool(L"Found", m_bPeerCacheWasFound);
	ini.WriteBool(L"Enabled", m_bPeerCacheEnabled);
	ini.WriteInt(L"PCPort", m_nPeerCachePort);
	ini.WriteBool(L"Show", m_bPeerCacheShow); // NEO: MOD <-- Xanatos --

}

void CPreferences::ResetStatsColor(int index)
{
	switch(index)
	{
		case  0: m_adwStatsColors[ 0]=RGB(  0,  0, 64);break;
		case  1: m_adwStatsColors[ 1]=RGB(192,192,255);break;
		case  2: m_adwStatsColors[ 2]=RGB(128,255,128);break;
		case  3: m_adwStatsColors[ 3]=RGB(  0,210,  0);break;
		case  4: m_adwStatsColors[ 4]=RGB(  0,128,  0);break;
		case  5: m_adwStatsColors[ 5]=RGB(255,128,128);break;
		case  6: m_adwStatsColors[ 6]=RGB(200,  0,  0);break;
		case  7: m_adwStatsColors[ 7]=RGB(140,  0,  0);break;
		case  8: m_adwStatsColors[ 8]=RGB(150,150,255);break;
		case  9: m_adwStatsColors[ 9]=RGB(192,  0,192);break;
		case 10: m_adwStatsColors[10]=RGB(255,255,128);break;
		//case 11: m_adwStatsColors[11]=RGB(  0,255,  0);break; // NEO: MOD <-- Xanatos --
		case 12: m_adwStatsColors[12]=RGB(255,255,255);break;
		case 13: m_adwStatsColors[13]=RGB(255,255,255);break;
		case 14: m_adwStatsColors[14]=RGB(255,190,190);break;
			
		case 15: m_adwStatsColors[15]=RGB(50 , 50,255);break; 
		case 16: m_adwStatsColors[16]=RGB(192,192,192);break; 
		case 17: m_adwStatsColors[17]=RGB(192,192,192);break; 
		// NEO: MOD END <-- Xanatos --
		// NEO: SI - [SysInfo] -- Xanatos -->
		case 18: m_adwStatsColors[18]=RGB(140,  0,  0);break; 
		case 19: m_adwStatsColors[19]=RGB(  0,  0,140);break; 
		// NEO: SI END <-- Xanatos --
		// NEO: MOD - [NeoStats] -- Xanatos -->
		case 20: m_adwStatsColors[20]=RGB(255,255,255);break;
		case 21: m_adwStatsColors[21]=RGB(0,128,128);break;
		case 22: m_adwStatsColors[22]=RGB(0,128,0);break;
		case 23: m_adwStatsColors[23]=RGB(128,0,255);break;
		case 24: m_adwStatsColors[24]=RGB(255,128,0);break;
		case 25: m_adwStatsColors[25]=RGB(255,0,0);break;
		case 26: m_adwStatsColors[26]=RGB(0,255,0);break;
		// NEO: MOD END <-- Xanatos --
		case 27: m_adwStatsColors[27]=RGB(0,200,0);break;
		case 28: m_adwStatsColors[28]=RGB(200,0,0);break;
		case 29: m_adwStatsColors[29]=RGB(0,0,255);break;
		// NEO: NSTI - [NewSystemTrayIcon] -- Xanatos -->
		case 30: m_adwStatsColors[30]=RGB(0,255,0);break; //down max
		case 31: m_adwStatsColors[31]=RGB(255,255,0);break; //down min
		case 32: m_adwStatsColors[32]=RGB(255,0,0);break; //up max
		case 33: m_adwStatsColors[33]=RGB(255,0,255);break; //up min
		// NEO: NSTI END <-- Xanatos --
		// NEO: CTB - [CoolToolBar] -- Xanatos -->
		case 34: m_adwStatsColors[34]=RGB(0,255,0);break; //down max
		case 35: m_adwStatsColors[35]=RGB(255,255,0);break; //down min
		case 36: m_adwStatsColors[36]=RGB(255,0,0);break; //up max
		case 37: m_adwStatsColors[37]=RGB(255,0,255);break; //up min
		case 38: m_adwStatsColors[38]=RGB(  0,  0, 64);break; //back
		case 39: m_adwStatsColors[39]=RGB(96, 96, 128);break; //grid
		case 40: m_adwStatsColors[40]=RGB(192,192,255);break; //text
		// NEO: END END <-- Xanatos --
	}
}

void CPreferences::GetAllStatsColors(int iCount, LPDWORD pdwColors)
{
	memset(pdwColors, 0, sizeof(*pdwColors) * iCount);
	memcpy(pdwColors, m_adwStatsColors, sizeof(*pdwColors) * min(ARRSIZE(m_adwStatsColors), iCount));
}

bool CPreferences::SetAllStatsColors(int iCount, const DWORD* pdwColors)
{
	bool bModified = false;
	int iMin = min(ARRSIZE(m_adwStatsColors), iCount);
	for (int i = 0; i < iMin; i++)
	{
		if (m_adwStatsColors[i] != pdwColors[i])
		{
			m_adwStatsColors[i] = pdwColors[i];
			bModified = true;
		}
	}
	return bModified;
}

void CPreferences::IniCopy(CString si, CString di) {
	CIni ini(GetConfigFile(), L"eMule");
	
	CString s=ini.GetString(si);

	ini.SetSection(L"ListControlSetup");
	
	ini.WriteString(di,s);
}

// Imports the tablesetups of emuleversions (.ini) <0.46b		- temporary
void CPreferences::ImportOldTableSetup() {

	IniCopy(L"DownloadColumnHidden" ,	L"DownloadListCtrlColumnHidden" );
	IniCopy(L"DownloadColumnWidths" ,	L"DownloadListCtrlColumnWidths" );
	IniCopy(L"DownloadColumnOrder" ,		L"DownloadListCtrlColumnOrders" );
	IniCopy(L"TableSortItemDownload" ,	L"DownloadListCtrlTableSortItem" );
	IniCopy(L"TableSortAscendingDownload" , L"DownloadListCtrlTableSortAscending" );

	IniCopy(L"ONContactListCtrlColumnHidden" ,	L"ONContactListCtrlColumnHidden" );
	IniCopy(L"ONContactListCtrlColumnWidths" ,	L"ONContactListCtrlColumnWidths" );
	IniCopy(L"ONContactListCtrlColumnOrders" ,		L"ONContactListCtrlColumnOrders" );

	IniCopy(L"KadSearchListCtrlColumnHidden" ,	L"KadSearchListCtrlColumnHidden" );
	IniCopy(L"KadSearchListCtrlColumnWidths" ,	L"KadSearchListCtrlColumnWidths" );
	IniCopy(L"KadSearchListCtrlColumnOrders" ,		L"KadSearchListCtrlColumnOrders" );
	
	IniCopy(L"UploadColumnHidden" ,		L"UploadListCtrlColumnHidden" );
	IniCopy(L"UploadColumnWidths" ,		L"UploadListCtrlColumnWidths" );
	IniCopy(L"UploadColumnOrder" ,		L"UploadListCtrlColumnOrders" );
	IniCopy(L"TableSortItemUpload" ,		L"UploadListCtrlTableSortItem" );
	IniCopy(L"TableSortAscendingUpload", L"UploadListCtrlTableSortAscending" );

	IniCopy(L"QueueColumnHidden" ,		L"QueueListCtrlColumnHidden" );
	IniCopy(L"QueueColumnWidths" ,		L"QueueListCtrlColumnWidths" );
	IniCopy(L"QueueColumnOrder" ,		L"QueueListCtrlColumnOrders" );
	IniCopy(L"TableSortItemQueue" ,		L"QueueListCtrlTableSortItem" );
	IniCopy(L"TableSortAscendingQueue" , L"QueueListCtrlTableSortAscending" );

	IniCopy(L"SearchColumnHidden" ,		L"SearchListCtrlColumnHidden" );
	IniCopy(L"SearchColumnWidths" ,		L"SearchListCtrlColumnWidths" );
	IniCopy(L"SearchColumnOrder" ,		L"SearchListCtrlColumnOrders" );
	IniCopy(L"TableSortItemSearch" ,		L"SearchListCtrlTableSortItem" );
	IniCopy(L"TableSortAscendingSearch", L"SearchListCtrlTableSortAscending" );

	IniCopy(L"SharedColumnHidden" ,		L"SharedFilesCtrlColumnHidden" );
	IniCopy(L"SharedColumnWidths" ,		L"SharedFilesCtrlColumnWidths" );
	IniCopy(L"SharedColumnOrder" ,		L"SharedFilesCtrlColumnOrders" );
	IniCopy(L"TableSortItemShared" ,		L"SharedFilesCtrlTableSortItem" );
	IniCopy(L"TableSortAscendingShared", L"SharedFilesCtrlTableSortAscending" );

	IniCopy(L"ServerColumnHidden" ,		L"ServerListCtrlColumnHidden" );
	IniCopy(L"ServerColumnWidths" ,		L"ServerListCtrlColumnWidths" );
	IniCopy(L"ServerColumnOrder" ,		L"ServerListCtrlColumnOrders" );
	IniCopy(L"TableSortItemServer" ,		L"ServerListCtrlTableSortItem" );
	IniCopy(L"TableSortAscendingServer", L"ServerListCtrlTableSortAscending" );

	IniCopy(L"ClientListColumnHidden" ,		L"ClientListCtrlColumnHidden" );
	IniCopy(L"ClientListColumnWidths" ,		L"ClientListCtrlColumnWidths" );
	IniCopy(L"ClientListColumnOrder" ,		L"ClientListCtrlColumnOrders" );
	IniCopy(L"TableSortItemClientList" ,		L"ClientListCtrlTableSortItem" );
	IniCopy(L"TableSortAscendingClientList", L"ClientListCtrlTableSortAscending" );

	IniCopy(L"FilenamesListColumnHidden" ,	L"FileDetailDlgNameColumnHidden" );
	IniCopy(L"FilenamesListColumnWidths" ,	L"FileDetailDlgNameColumnWidths" );
	IniCopy(L"FilenamesListColumnOrder" ,	L"FileDetailDlgNameColumnOrders" );
	IniCopy(L"TableSortItemFilenames" ,		L"FileDetailDlgNameTableSortItem" );
	IniCopy(L"TableSortAscendingFilenames",  L"FileDetailDlgNameTableSortAscending" );

	IniCopy(L"IrcMainColumnHidden" ,		L"IrcNickListCtrlColumnHidden" );
	IniCopy(L"IrcMainColumnWidths" ,		L"IrcNickListCtrlColumnWidths" );
	IniCopy(L"IrcMainColumnOrder" ,		L"IrcNickListCtrlColumnOrders" );
	IniCopy(L"TableSortItemIrcMain" ,	L"IrcNickListCtrlTableSortItem" );
	IniCopy(L"TableSortAscendingIrcMain",L"IrcNickListCtrlTableSortAscending" );

	IniCopy(L"IrcChannelsColumnHidden" ,		L"IrcChannelListCtrlColumnHidden" );
	IniCopy(L"IrcChannelsColumnWidths" ,		L"IrcChannelListCtrlColumnWidths" );
	IniCopy(L"IrcChannelsColumnOrder" ,		L"IrcChannelListCtrlColumnOrders" );
	IniCopy(L"TableSortItemIrcChannels" ,	L"IrcChannelListCtrlTableSortItem" );
	IniCopy(L"TableSortAscendingIrcChannels",L"IrcChannelListCtrlTableSortAscending" );

	IniCopy(L"DownloadClientsColumnHidden" ,		L"DownloadClientsCtrlColumnHidden" );
	IniCopy(L"DownloadClientsColumnWidths" ,		L"DownloadClientsCtrlColumnWidths" );
	IniCopy(L"DownloadClientsColumnOrder" ,		L"DownloadClientsCtrlColumnOrders" );
}

void CPreferences::LoadPreferences()
{
	TCHAR buffer[256];

	m_bFirstStart = !PathFileExists(GetConfigDir() + L"preferences.dat"); // NEO: MOD <-- Xanatos --

	CIni ini(GetConfigFile(), L"eMule");

	// import old (<0.46b) table setups - temporary
	if (ini.GetInt(L"SearchListCtrlTableSortItem",-1,L"ListControlSetup")==-1)
		ImportOldTableSetup();

	ini.SetSection(L"eMule");

	//CString strCurrVersion, strPrefsVersion;

	//strCurrVersion = theApp.m_strCurVersionLong;
	//strPrefsVersion = ini.GetString(L"AppVersion");

	//m_bFirstStart = false;
	//if (strCurrVersion != strPrefsVersion)

#ifdef _DEBUG
	m_iDbgHeap = ini.GetInt(L"DebugHeap", 1);
#else
	m_iDbgHeap = 0;
#endif

	m_nWebMirrorAlertLevel = ini.GetInt(L"WebMirrorAlertLevel",0);
	updatenotify=ini.GetBool(L"UpdateNotifyTestClient",true);

	SetUserNick(ini.GetStringUTF8(L"Nick", DEFAULT_NICK));
	if (strNick.IsEmpty() || IsDefaultNick(strNick))
		SetUserNick(DEFAULT_NICK);

	_stprintf(buffer,L"%sIncoming",appdir);
	_stprintf(incomingdir,L"%s",ini.GetString(L"IncomingDir",buffer ));
	MakeFoldername(incomingdir);

	// load tempdir(s) setting
	_stprintf(buffer,L"%sTemp",appdir);

	// NEO: MTD - [MultiTempDirectories] -- Xanatos -->
	_stprintf(tempdir,L"%s",ini.GetString(L"TempDir",buffer));
	MakeFoldername(tempdir);
	use_tempdir = ini.GetInt(L"CurrentTempDir", AUTO_TEMPDIR); 
	// NEO: MTD END <-- Xanatos --

	maxGraphDownloadRate=ini.GetInt(L"DownloadCapacity",96);
	if (maxGraphDownloadRate==0)
		maxGraphDownloadRate=96;
	
	maxGraphUploadRate = ini.GetInt(L"UploadCapacityNew",-1);
	if (maxGraphUploadRate == 0)
		maxGraphUploadRate = UNLIMITED;
	else if (maxGraphUploadRate == -1){
		// converting value from prior versions
		int nOldUploadCapacity = ini.GetInt(L"UploadCapacity", 16);
		if (nOldUploadCapacity == 16 && ini.GetInt(L"MaxUpload",12) == 12){
			// either this is a complete new install, or the prior version used the default value
			// in both cases, set the new default values to unlimited
			maxGraphUploadRate = UNLIMITED;
			ini.WriteInt(L"MaxUpload",UNLIMITED, L"eMule");
		}
		else
			maxGraphUploadRate = nOldUploadCapacity; // use old custoum value
	}

#ifndef NEO_BC // NEO: NBC -- Xanatos -->
	minupload=(uint16)ini.GetInt(L"MinUpload", 1);
#endif // NEO_BC // NEO: NBC END <-- Xanatos --
	maxupload=(uint16)ini.GetInt(L"MaxUpload",UNLIMITED);
	if (maxupload > maxGraphUploadRate && maxupload != UNLIMITED)
		maxupload = (uint16)(maxGraphUploadRate * .8);
	
	maxdownload=(uint16)ini.GetInt(L"MaxDownload", UNLIMITED);
	if (maxdownload > maxGraphDownloadRate && maxdownload != UNLIMITED)
		maxdownload = (uint16)(maxGraphDownloadRate * .8);
	maxconnections=ini.GetInt(L"MaxConnections",GetRecommendedMaxConnections());
	maxhalfconnections=ini.GetInt(L"MaxHalfConnections",9);
	m_bConditionalTCPAccept = ini.GetBool(L"ConditionalTCPAccept", false);

	// reset max halfopen to a default if OS changed to SP2 or away
	int dwSP2 = ini.GetInt(L"WinXPSP2", -1);
	int dwCurSP2 = IsRunningXPSP2();
	if (dwSP2 != dwCurSP2){
		if (dwCurSP2 == 0)
			maxhalfconnections = 50;
		else if (dwCurSP2 == 1)
			maxhalfconnections = 9;
	}

	port = (uint16)ini.GetInt(L"Port", 0);
	if (port == 0)
		port = thePrefs.GetRandomTCPPort();

	// 0 is a valid value for the UDP port setting, as it is used for disabling it.
	int iPort = ini.GetInt(L"UDPPort", INT_MAX/*invalid port value*/);
	if (iPort == INT_MAX)
		udpport = thePrefs.GetRandomUDPPort();
	else
		udpport = (uint16)iPort;

	kadport = (uint16)ini.GetInt(L"KADPort",-1); // NEO: KAX - [KadAuxPort] <-- Xanatos -- // -1 = dont use kad yux, share clientUDPsocket
	nServerUDPPort = (uint16)ini.GetInt(L"ServerUDPPort", -1); // 0 = Don't use UDP port for servers, -1 = use a random port (for backward compatibility)
	//maxsourceperfile=ini.GetInt(L"MaxSourcesPerFile",400 ); // NEO: NST - [NeoSourceTweaks] <-- Xanatos --
	m_wLanguageID=ini.GetWORD(L"Language",0);
	m_iSeeShares=(EViewSharedFilesAccess)ini.GetInt(L"SeeShare",vsfaNobody);
	m_iToolDelayTime=ini.GetInt(L"ToolTipDelay",1);
	trafficOMeterInterval=ini.GetInt(L"StatGraphsInterval",3);
	statsInterval=ini.GetInt(L"statsInterval",5);
	dontcompressblocks=ini.GetBool(L"DontCompressBlocks",false); // NEO: MOD <-- Xanatos --
	dontcompressavi=ini.GetBool(L"DontCompressAvi",false);

	m_uDeadServerRetries=ini.GetInt(L"DeadServerRetry",1);
	if (m_uDeadServerRetries > MAX_SERVERFAILCOUNT)
		m_uDeadServerRetries = MAX_SERVERFAILCOUNT;
	m_dwServerKeepAliveTimeout=ini.GetInt(L"ServerKeepAliveTimeout",0);
	splitterbarPosition=ini.GetInt(L"SplitterbarPosition",75);
	if (splitterbarPosition < 9)
		splitterbarPosition = 9;
	else if (splitterbarPosition > 93)
		splitterbarPosition = 93;
	splitterbarPositionStat=ini.GetInt(L"SplitterbarPositionStat",30);
	splitterbarPositionStat_HL=ini.GetInt(L"SplitterbarPositionStat_HL",66);
	splitterbarPositionStat_HR=ini.GetInt(L"SplitterbarPositionStat_HR",33);
	if (splitterbarPositionStat_HR+1>=splitterbarPositionStat_HL){
		splitterbarPositionStat_HL = 66;
		splitterbarPositionStat_HR = 33;
	}
	splitterbarPositionFriend=ini.GetInt(L"SplitterbarPositionFriend",300);
	splitterbarPositionShared=ini.GetInt(L"SplitterbarPositionShared",179);
	splitterbarPositionIRC=ini.GetInt(L"SplitterbarPositionIRC",200);
	splitterbarPositionSvr=ini.GetInt(L"SplitterbarPositionServer",75);
	if (splitterbarPositionSvr>90 || splitterbarPositionSvr<10)
		splitterbarPositionSvr=75;

	m_uTransferWnd1 = ini.GetInt(L"TransferWnd1",0);
	m_uTransferWnd2 = ini.GetInt(L"TransferWnd2",0); // NEO: MOD <-- Xanatos --
	m_uLastCategory = ini.GetInt(L"LastCategory",0); // NEO: MAC - [MorphA4AFCategories] <-- Xanatos --

	statsMax=ini.GetInt(L"VariousStatisticsMaxValue",100);
	statsAverageMinutes=ini.GetInt(L"StatsAverageMinutes",5);
	MaxConperFive=ini.GetInt(L"MaxConnectionsPerFiveSeconds",GetDefaultMaxConperFive());

	reconnect = ini.GetBool(L"Reconnect", true);
	m_bUseServerPriorities = ini.GetBool(L"Scoresystem", true);
	m_bUseUserSortedServerList = ini.GetBool(L"UserSortedServerList", false);
	ICH = ini.GetBool(L"ICH", true);
	m_bAutoUpdateServerList = ini.GetBool(L"Serverlist", false);

	mintotray=ini.GetBool(L"MinToTray",false);
	m_bAddServersFromServer=ini.GetBool(L"AddServersFromServer",true);
	m_bAddServersFromClients=ini.GetBool(L"AddServersFromClient",false);
	splashscreen=ini.GetBool(L"Splashscreen",true);
	bringtoforeground=ini.GetBool(L"BringToFront",true);
	transferDoubleclick=ini.GetBool(L"TransferDoubleClick",true);
	beepOnError=ini.GetBool(L"BeepOnError",true);
	confirmExit=ini.GetBool(L"ConfirmExit",true);
#ifdef _DEBUG // NEO: MOD <-- Xanatos --
	filterLANIPs=ini.GetBool(L"FilterBadIPs",false); // NEO: MOD <-- Xanatos --
#else
	filterLANIPs=ini.GetBool(L"FilterBadIPs",true);
#endif
	m_bAllocLocalHostIP=ini.GetBool(L"AllowLocalHostIP",false);
	autoconnect=ini.GetBool(L"Autoconnect",false);
	showRatesInTitle=ini.GetBool(L"ShowRatesOnTitle",false);
	m_bIconflashOnNewMessage=ini.GetBool(L"IconflashOnNewMessage",false);

	onlineSig=ini.GetBool(L"OnlineSignature",false);
	startMinimized=ini.GetInt(L"StartupMinimized",FALSE); // NEO: MOD <-- Xanatos --
	m_bAutoStart=ini.GetBool(L"AutoStart",false);
	m_bRestoreLastMainWndDlg=ini.GetBool(L"RestoreLastMainWndDlg",false);
	m_iLastMainWndDlgID=ini.GetInt(L"LastMainWndDlgID",0);
	m_bRestoreLastLogPane=ini.GetBool(L"RestoreLastLogPane",false);
	m_iLastLogPaneID=ini.GetInt(L"LastLogPaneID",0);
	m_bSafeServerConnect =ini.GetBool(L"SafeServerConnect",false);

	m_bTransflstRemain =ini.GetBool(L"TransflstRemainOrder",false);
	filterserverbyip=ini.GetBool(L"FilterServersByIP",false);
	filterlevel=ini.GetInt(L"FilterLevel",127);
	checkDiskspace=ini.GetBool(L"CheckDiskspace",false);
	m_uMinFreeDiskSpace=ini.GetInt(L"MinFreeDiskSpace",20*1024*1024);
	m_bSparsePartFiles=ini.GetBool(L"SparsePartFiles",false);
	m_strYourHostname=ini.GetString(L"YourHostname", L"");

	// Barry - New properties...
	m_bAutoConnectToStaticServersOnly = ini.GetBool(L"AutoConnectStaticOnly",false); 
	autotakeed2klinks = ini.GetBool(L"AutoTakeED2KLinks",true); 
	addnewfilespaused = ini.GetBool(L"AddNewFilesPaused",false); 
	depth3D = ini.GetInt(L"3DDepth", 5);
	//m_bEnableMiniMule = ini.GetBool(L"MiniMule", true); // NEO: MM - [NeoMiniMule] <-- Xanatos --

	// Notifier
	notifierConfiguration = ini.GetString(L"NotifierConfiguration", GetConfigDir() + L"Notifier.ini");
    notifierOnDownloadFinished = ini.GetBool(L"NotifyOnDownload");
	notifierOnNewDownload = ini.GetBool(L"NotifyOnNewDownload");
    notifierOnChat = ini.GetBool(L"NotifyOnChat");
    notifierOnLog = ini.GetBool(L"NotifyOnLog");
	notifierOnImportantError = ini.GetBool(L"NotifyOnImportantError");
	notifierOnEveryChatMsg = ini.GetBool(L"NotifierPopEveryChatMessage");
	notifierOnNewVersion = ini.GetBool(L"NotifierPopNewVersion");
    notifierSoundType = (ENotifierSoundType)ini.GetInt(L"NotifierUseSound", ntfstNoSound);
	notifierSoundFile = ini.GetString(L"NotifierSoundPath");

	_stprintf(datetimeformat,L"%s",ini.GetString(L"DateTimeFormat",L"%A, %c"));
	if (_tcslen(datetimeformat)==0) _tcscpy(datetimeformat,L"%A, %c");
	_stprintf(datetimeformat4log,L"%s",ini.GetString(L"DateTimeFormat4Log",L"%c"));
	if (_tcslen(datetimeformat4log)==0) _tcscpy(datetimeformat4log,L"%c");

	_stprintf(m_sircserver,L"%s",ini.GetString(L"DefaultIRCServerNew",L"ircchat.emule-project.net"));
	_stprintf(m_sircnick,L"%s",ini.GetString(L"IRCNick"));
	m_bircaddtimestamp=ini.GetBool(L"IRCAddTimestamp",true);
	_stprintf(m_sircchannamefilter,L"%s",ini.GetString(L"IRCFilterName", L"" ));
	m_bircusechanfilter=ini.GetBool(L"IRCUseFilter", false);
	m_iircchanneluserfilter=ini.GetInt(L"IRCFilterUser", 0);
	_stprintf(m_sircperformstring,L"%s",ini.GetString(L"IRCPerformString", L"" ));
	m_bircuseperform=ini.GetBool(L"IRCUsePerform", false);
	m_birclistonconnect=ini.GetBool(L"IRCListOnConnect", true);
	m_bircacceptlinks=ini.GetBool(L"IRCAcceptLink", true);
	m_bircacceptlinksfriends=ini.GetBool(L"IRCAcceptLinkFriends", true);
	m_bircsoundevents=ini.GetBool(L"IRCSoundEvents", false);
	m_bircignoremiscmessage=ini.GetBool(L"IRCIgnoreMiscMessages", false);
	m_bircignorejoinmessage=ini.GetBool(L"IRCIgnoreJoinMessages", true);
	m_bircignorepartmessage=ini.GetBool(L"IRCIgnorePartMessages", true);
	m_bircignorequitmessage=ini.GetBool(L"IRCIgnoreQuitMessages", true);
	m_bircignoreemuleprotoaddfriend=ini.GetBool(L"IRCIgnoreEmuleProtoAddFriend", false);
	m_bircallowemuleprotoaddfriend=ini.GetBool(L"IRCAllowEmuleProtoAddFriend", true);
	m_bircignoreemuleprotosendlink=ini.GetBool(L"IRCIgnoreEmuleProtoSendLink", false);
	m_birchelpchannel=ini.GetBool(L"IRCHelpChannel",true);
	m_bSmartServerIdCheck=ini.GetBool(L"SmartIdCheck",true);

	log2disk = ini.GetBool(L"SaveLogToDisk",false);
	uMaxLogFileSize = ini.GetInt(L"MaxLogFileSize", 1024*1024);
	iMaxLogBuff = ini.GetInt(L"MaxLogBuff",64) * 1024;
	m_iLogFileFormat = (ELogFileFormat)ini.GetInt(L"LogFileFormat", Unicode);
	m_bEnableVerboseOptions=ini.GetBool(L"VerboseOptions", true);
	if (m_bEnableVerboseOptions)
	{
		m_bVerbose=ini.GetBool(L"Verbose",false);
		m_bFullVerbose=ini.GetBool(L"FullVerbose",false);
		debug2disk=ini.GetBool(L"SaveDebugToDisk",false);
		m_bDebugSourceExchange=ini.GetBool(L"DebugSourceExchange",false);
		m_bLogBannedClients=ini.GetBool(L"LogBannedClients", true);
		m_bLogRatingDescReceived=ini.GetBool(L"LogRatingDescReceived",true);
		m_bLogSecureIdent=ini.GetBool(L"LogSecureIdent",true);
		m_bLogFilteredIPs=ini.GetBool(L"LogFilteredIPs",true);
		m_bLogFileSaving=ini.GetBool(L"LogFileSaving",false);
        m_bLogA4AF=ini.GetBool(L"LogA4AF",false); // ZZ:DownloadManager
		m_bLogUlDlEvents=ini.GetBool(L"LogUlDlEvents",true);
		m_bLogAICHEvents=ini.GetBool(_T("LogAICHEvents"),true); // NEO: MOD - [LogAICH] <-- Xanatos --
	}
	else
	{
		if (m_bRestoreLastLogPane && m_iLastLogPaneID>=2)
			m_iLastLogPaneID = 1;
	}
#if defined(_DEBUG) || defined(USE_DEBUG_DEVICE)
	// following options are for debugging or when using an external debug device viewer only.
	m_iDebugServerTCPLevel = ini.GetInt(L"DebugServerTCP", 0);
	m_iDebugServerUDPLevel = ini.GetInt(L"DebugServerUDP", 0);
	m_iDebugServerSourcesLevel = ini.GetInt(L"DebugServerSources", 0);
	m_iDebugServerSearchesLevel = ini.GetInt(L"DebugServerSearches", 0);
	m_iDebugClientTCPLevel = ini.GetInt(L"DebugClientTCP", 0);
	m_iDebugClientUDPLevel = ini.GetInt(L"DebugClientUDP", 0);
	m_iDebugClientKadUDPLevel = ini.GetInt(L"DebugClientKadUDP", 0);
	m_iDebugSearchResultDetailLevel = ini.GetInt(L"DebugSearchResultDetailLevel", 0);
#else
	// for normal release builds ensure that those options are all turned off
	m_iDebugServerTCPLevel = 0;
	m_iDebugServerUDPLevel = 0;
	m_iDebugServerSourcesLevel = 0;
	m_iDebugServerSearchesLevel = 0;
	m_iDebugClientTCPLevel = 0;
	m_iDebugClientUDPLevel = 0;
	m_iDebugClientKadUDPLevel = 0;
	m_iDebugSearchResultDetailLevel = 0;
#endif

	m_bpreviewprio=ini.GetBool(L"PreviewPrio",false);
	m_bupdatequeuelist=ini.GetBool(L"UpdateQueueListPref",false);
	m_bManualAddedServersHighPriority=ini.GetBool(L"ManualHighPrio",false);
	m_btransferfullchunks=ini.GetBool(L"FullChunkTransfers",true);
	m_istartnextfile=ini.GetInt(L"StartNextFile",0);
	m_bshowoverhead=ini.GetBool(L"ShowOverhead",false);
	moviePreviewBackup=ini.GetBool(L"VideoPreviewBackupped",true);
	m_iPreviewSmallBlocks=ini.GetInt(L"PreviewSmallBlocks", 0);
	m_bPreviewCopiedArchives=ini.GetBool(L"PreviewCopiedArchives", true);
	m_iInspectAllFileTypes=ini.GetInt(L"InspectAllFileTypes", 0);
	m_bAllocFull=ini.GetBool(L"AllocateFullFile",0);
	m_bAutomaticArcPreviewStart=ini.GetBool(L"AutoArchivePreviewStart", true );

	// read file buffer size (with backward compatibility)
	//m_iFileBufferSize=ini.GetInt(L"FileBufferSizePref",0); // old setting
	//if (m_iFileBufferSize == 0)
	//	m_iFileBufferSize = 256*1024;
	//else
	//	m_iFileBufferSize = ((m_iFileBufferSize*15000 + 512)/1024)*1024;
	m_iFileBufferSize=ini.GetInt(L"FileBufferSize",256*1024);
	m_iFileBufferTime=ini.GetInt(L"FileBufferTime",60*1000); // NEO: MOD - [BufferCustomisation] <-- Xanatos --

	// read queue size (with backward compatibility)
	//m_iQueueSize=ini.GetInt(L"QueueSizePref",0); // old setting
	//if (m_iQueueSize == 0)
	//	m_iQueueSize = 50*100;
	//else
	//	m_iQueueSize = m_iQueueSize*100;
	m_iQueueSize=ini.GetInt(L"QueueSize",50*100);

	m_iCommitFiles=ini.GetInt(L"CommitFiles", 1); // 1 = "commit" on application shut down; 2 = "commit" on each file saveing
	versioncheckdays=ini.GetInt(L"Check4NewVersionDelay",5);
	m_bDAP=ini.GetBool(L"DAPPref",true);
	m_bUAP=ini.GetBool(L"UAPPref",true);
	m_bPreviewOnIconDblClk=ini.GetBool(L"PreviewOnIconDblClk",false);
	indicateratings=ini.GetBool(L"IndicateRatings",true);
	watchclipboard=ini.GetBool(L"WatchClipboard4ED2kFilelinks",false);
	m_iSearchMethod=ini.GetInt(L"SearchMethod",0);

	showCatTabInfos=ini.GetInt(L"ShowInfoOnCatTabs",FALSE); // NEO: MOD - [MoreCategoryInfo] <-- Xanatos --
//	resumeSameCat=ini.GetBool(L"ResumeNextFromSameCat",false);
	dontRecreateGraphs =ini.GetBool(L"DontRecreateStatGraphsOnResize",false);
	m_bExtControls =ini.GetBool(L"ShowExtControls",true); // NEO: MOD <-- Xanatos --

	versioncheckLastAutomatic=ini.GetInt(L"VersionCheckLastAutomatic",0);
	m_bDisableKnownClientList=ini.GetBool(L"DisableKnownClientList",false);
	m_bDisableQueueList=ini.GetBool(L"DisableQueueList",false);
	m_bCreditSystem=ini.GetBool(L"UseCreditSystem",true);
	scheduler=ini.GetBool(L"EnableScheduler",false);
	msgonlyfriends=ini.GetBool(L"MessagesFromFriendsOnly",false);
	msgsecure=ini.GetBool(L"MessageFromValidSourcesOnly",true);
	autofilenamecleanup=ini.GetBool(L"AutoFilenameCleanup",false);
	m_bUseAutocompl=ini.GetBool(L"UseAutocompletion",true);
	m_uShowDwlPercentage=ini.GetInt(L"ShowDwlPercentage",false); // NEO: MOD - [Percentage] <-- Xanatos --
	networkkademlia=ini.GetBool(L"NetworkKademlia",true); // NEO: MOD <-- Xanatos --
	networked2k=ini.GetBool(L"NetworkED2K",true);
	m_bRemove2bin=ini.GetBool(L"RemoveFilesToBin",true);
	m_bShowCopyEd2kLinkCmd=ini.GetBool(L"ShowCopyEd2kLinkCmd",false);

	m_iMaxChatHistory=ini.GetInt(L"MaxChatHistoryLines",100);
	if (m_iMaxChatHistory < 1)
		m_iMaxChatHistory = 100;
	maxmsgsessions=ini.GetInt(L"MaxMessageSessions",50);
	m_bShowActiveDownloadsBold = ini.GetBool(L"ShowActiveDownloadsBold", false);

	_snwprintf(TxtEditor,_countof(TxtEditor),L"%s",ini.GetString(L"TxtEditor",L"notepad.exe"));
	m_strVideoPlayer = ini.GetString(L"VideoPlayer", L"");
	m_strVideoPlayerArgs = ini.GetString(L"VideoPlayerArgs",L"");
	_snwprintf(m_sTemplateFile,_countof(m_sTemplateFile),L"%s",ini.GetString(L"WebTemplateFile", GetConfigDir()+L"eMule.tmpl"));

	messageFilter=ini.GetStringLong(L"MessageFilter",DEF_MSG_FILTER); // NEO: NA - [NeoArgos] <-- Xanatos --
	commentFilter = ini.GetStringLong(L"CommentFilter",L"http://|https://|ftp://|www.|ftp.");
	commentFilter.MakeLower();
	filenameCleanups=ini.GetStringLong(L"FilenameCleanups",L"http|www.|.com|.de|.org|.net|shared|powered|sponsored|sharelive|filedonkey|");
	m_iExtractMetaData = ini.GetInt(L"ExtractMetaData", 1); // 0=disable, 1=mp3, 2=MediaDet
	if (m_iExtractMetaData > 1)
		m_iExtractMetaData = 1;
	m_bAdjustNTFSDaylightFileTime=ini.GetBool(L"AdjustNTFSDaylightFileTime", true);

	m_bUseSecureIdent=ini.GetBool(L"SecureIdent",true);
	m_bAdvancedSpamfilter=ini.GetBool(L"AdvancedSpamFilter",true);
	m_bRemoveFinishedDownloads=ini.GetBool(L"AutoClearCompleted",false);
	m_uUseOldTimeRemaining = ini.GetInt(L"UseSimpleTimeRemainingcomputation",FALSE); // NEO: MOD <-- Xanatos --

	// Toolbar
	m_sToolbarSettings = ini.GetString(L"ToolbarSetting", strDefaultToolbar);
	m_sToolbarBitmap = ini.GetString(L"ToolbarBitmap", L"");
	m_sToolbarBitmapFolder = ini.GetString(L"ToolbarBitmapFolder", appdir + L"skins");
	m_nToolbarLabels = (EToolbarLabelType)ini.GetInt(L"ToolbarLabels", CMuleToolbarCtrl::GetDefaultLabelType());
	m_bReBarToolbar = ini.GetBool(L"ReBarToolbar", 1);
	m_sizToolbarIconSize.cx = m_sizToolbarIconSize.cy = ini.GetInt(L"ToolbarIconSize", 32);
	m_iStraightWindowStyles=ini.GetInt(L"StraightWindowStyles",0);
	m_bRTLWindowsLayout = ini.GetBool(L"RTLWindowsLayout");
	m_strSkinProfile = ini.GetString(L"SkinProfile", L"");
	m_strSkinProfileDir = ini.GetString(L"SkinProfileDir", appdir + L"skins");

	LPBYTE pData = NULL;
	UINT uSize = sizeof m_lfHyperText;
	if (ini.GetBinary(L"HyperTextFont", &pData, &uSize) && uSize == sizeof m_lfHyperText)
		memcpy(&m_lfHyperText, pData, sizeof m_lfHyperText);
	else
		memset(&m_lfHyperText, 0, sizeof m_lfHyperText);
	delete[] pData;

	pData = NULL;
	uSize = sizeof m_lfLogText;
	if (ini.GetBinary(L"LogTextFont", &pData, &uSize) && uSize == sizeof m_lfLogText)
		memcpy(&m_lfLogText, pData, sizeof m_lfLogText);
	else
		memset(&m_lfLogText, 0, sizeof m_lfLogText);
	delete[] pData;

	m_crLogError = ini.GetColRef(L"LogErrorColor", m_crLogError);
	m_crLogWarning = ini.GetColRef(L"LogWarningColor", m_crLogWarning);
	m_crLogSuccess = ini.GetColRef(L"LogSuccessColor", m_crLogSuccess);

	if (statsAverageMinutes < 1)
		statsAverageMinutes = 5;

#ifndef NEO_BC // NEO: NBC -- Xanatos -->
	// ZZ:UploadSpeedSense -->
    m_bDynUpEnabled = ini.GetBool(L"USSEnabled", false);
    m_bDynUpUseMillisecondPingTolerance = ini.GetBool(L"USSUseMillisecondPingTolerance", false);
    m_iDynUpPingTolerance = ini.GetInt(L"USSPingTolerance", 500);
	m_iDynUpPingToleranceMilliseconds = ini.GetInt(L"USSPingToleranceMilliseconds", 200);
	if( minupload < 1 )
		minupload = 1;
	m_iDynUpGoingUpDivider = ini.GetInt(L"USSGoingUpDivider", 1000);
    m_iDynUpGoingDownDivider = ini.GetInt(L"USSGoingDownDivider", 1000);
    m_iDynUpNumberOfPings = ini.GetInt(L"USSNumberOfPings", 1);
	// ZZ:UploadSpeedSense <--
#endif // NEO_BC // NEO: NBC END <-- Xanatos --

    m_bA4AFSaveCpu = ini.GetBool(L"A4AFSaveCpu", false); // ZZ:DownloadManager
    m_bHighresTimer = ini.GetBool(L"HighresTimer", false);
	m_bRunAsUser = ini.GetBool(L"RunAsUnprivilegedUser", false);
	m_bPreferRestrictedOverUser = ini.GetBool(L"PreferRestrictedOverUser", false);
	//m_bOpenPortsOnStartUp = ini.GetBool(L"OpenPortsOnStartUp", false); // NEO: IFWS <-- Xanatos --
	m_byLogLevel = ini.GetInt(L"DebugLogLevel", DLP_VERYLOW);
	m_bTrustEveryHash = ini.GetBool(L"AICHTrustEveryHash", false);
	m_bRememberAICH = ini.GetBool(L"RememberAICH", true); // NEO: MOD - [RemoveUnusedAICHhashes] <-- Xanatos --
	m_bRememberCancelledFiles = ini.GetBool(L"RememberCancelledFiles", true);
	m_bRememberDownloadedFiles = ini.GetBool(L"RememberDownloadedFiles", true);

	m_bNotifierSendMail = ini.GetBool(L"NotifierSendMail", false);
#if _ATL_VER >= 0x0710
	if (!IsRunningXPSP2())
		m_bNotifierSendMail = false;
#endif
	m_strNotifierMailSender = ini.GetString(L"NotifierMailSender", L"");
	m_strNotifierMailServer = ini.GetString(L"NotifierMailServer", L"");
	m_strNotifierMailReceiver = ini.GetString(L"NotifierMailRecipient", L"");

	m_bWinaTransToolbar = ini.GetBool(L"WinaTransToolbar", false);

	m_bCryptLayerRequested = ini.GetBool(L"CryptLayerRequested", false);
	m_bCryptLayerRequired = ini.GetBool(L"CryptLayerRequired", false);
	m_bCryptLayerSupported = ini.GetBool(L"CryptLayerSupported", true);

	///////////////////////////////////////////////////////////////////////////
	// Section: "Proxy"
	//
	proxy.EnablePassword = ini.GetBool(L"ProxyEnablePassword",false,L"Proxy");
	proxy.UseProxy = ini.GetBool(L"ProxyEnableProxy",false,L"Proxy");
	proxy.name = CStringA(ini.GetString(L"ProxyName", L"", L"Proxy"));
	proxy.user = CStringA(ini.GetString(L"ProxyUser", L"", L"Proxy"));
	proxy.password = CStringA(ini.GetString(L"ProxyPassword", L"", L"Proxy"));
	proxy.port = (uint16)ini.GetInt(L"ProxyPort",1080,L"Proxy");
	proxy.type = (uint16)ini.GetInt(L"ProxyType",PROXYTYPE_NOPROXY,L"Proxy");


	///////////////////////////////////////////////////////////////////////////
	// Section: "Statistics"
	//
	statsSaveInterval = ini.GetInt(L"SaveInterval", 60, L"Statistics");
	statsConnectionsGraphRatio = ini.GetInt(L"statsConnectionsGraphRatio", 3, L"Statistics");
	statsMemoryGraphRatio = ini.GetInt(L"statsMemoryGraphRatio", 2, L"Statistics"); // NEO: SI - [SysInfo] <-- Xanatos --
	statsTransferGraphRatio = ini.GetInt(L"statsTransferGraphRatio", 1, L"Statistics"); // NEO: SI - [SysInfo] <-- Xanatos --
	statsSourceGraphRatio = ini.GetInt(L"statsSourceGraphRatio", 1, L"Statistics"); // NEO: SI - [SysInfo] <-- Xanatos --

	_stprintf(statsExpandedTreeItems,L"%s",ini.GetString(L"statsExpandedTreeItems",L"111000000100000110000010000011110000010010",L"Statistics"));
	CString buffer2;
	for (int i = 0; i < ARRSIZE(m_adwStatsColors); i++) {
		buffer2.Format(L"StatColor%i", i);
		_stprintf(buffer, L"%s", ini.GetString(buffer2, L"", L"Statistics"));
		m_adwStatsColors[i] = 0;
		if (_stscanf(buffer, L"%i", &m_adwStatsColors[i]) != 1)
			ResetStatsColor(i);
	}
	m_bShowVerticalHourMarkers = ini.GetBool(L"ShowVerticalHourMarkers", true, L"Statistics");

	// -khaos--+++> Load Stats
	// I changed this to a seperate function because it is now also used
	// to load the stats backup and to load stats from preferences.ini.old.
	LoadStats();
	// <-----khaos-

	///////////////////////////////////////////////////////////////////////////
	// Section: "WebServer"
	//
	m_bAdvWebsrv=ini.GetBool(L"UseAdvWebsrv", false); // NEO: WAM - [WebInterfaceAccountManagement] <-- Xanatos --
	_stprintf(m_sWebPassword,L"%s",ini.GetString(L"Password", L"",L"WebServer"));
	_stprintf(m_sWebLowPassword,L"%s",ini.GetString(L"PasswordLow", L""));
	m_nWebPort=(uint16)ini.GetInt(L"Port", 4711);
	m_bWebEnabled=ini.GetBool(L"Enabled", false);
	m_bWebUseGzip=ini.GetBool(L"UseGzip", true);
	m_bWebLowEnabled=ini.GetBool(L"UseLowRightsUser", false);
	m_nWebPageRefresh=ini.GetInt(L"PageRefreshTime", 120);
	m_iWebTimeoutMins=ini.GetInt(L"WebTimeoutMins", 5 );
	m_iWebFileUploadSizeLimitMB=ini.GetInt(L"MaxFileUploadSizeMB", 5 );
	m_bAllowAdminHiLevFunc=ini.GetBool(L"AllowAdminHiLevelFunc", false);
	buffer2 = ini.GetString(L"AllowedIPs");
	int iPos = 0;
	CString strIP = buffer2.Tokenize(L";", iPos);
	while (!strIP.IsEmpty())
	{
		u_long nIP = inet_addr(CStringA(strIP));
		if (nIP != INADDR_ANY && nIP != INADDR_NONE)
			m_aAllowedRemoteAccessIPs.Add(nIP);
		strIP = buffer2.Tokenize(L";", iPos);
	}

	///////////////////////////////////////////////////////////////////////////
	// Section: "MobileMule"
	//
	_stprintf(m_sMMPassword,L"%s",ini.GetString(L"Password", L"",L"MobileMule"));
	m_bMMEnabled = ini.GetBool(L"Enabled", false);
	m_nMMPort = (uint16)ini.GetInt(L"Port", 80);

	///////////////////////////////////////////////////////////////////////////
	// Section: "PeerCache"
	//
	m_uPeerCacheLastSearch = ini.GetInt(L"LastSearch", 0, L"PeerCache");
	m_bPeerCacheWasFound = ini.GetBool(L"Found", false);
	m_bPeerCacheEnabled = ini.GetBool(L"Enabled", true);
	m_nPeerCachePort = (uint16)ini.GetInt(L"PCPort", 0);
	m_bPeerCacheShow = ini.GetBool(L"Show", false);

	LoadCats();
	SetLanguage();
}


WORD CPreferences::GetWindowsVersion(){
	static bool bWinVerAlreadyDetected = false;
	if(!bWinVerAlreadyDetected)
	{	
		bWinVerAlreadyDetected = true;
		m_wWinVer = DetectWinVersion();	
	}	
	return m_wWinVer;
}

UINT CPreferences::GetDefaultMaxConperFive(){
	switch (GetWindowsVersion()){
		case _WINVER_98_:
			return 5;
		case _WINVER_95_:	
		case _WINVER_ME_:
			return MAXCON5WIN9X;
		case _WINVER_2K_:
		case _WINVER_XP_:
			return MAXCONPER5SEC;
		default:
			return MAXCONPER5SEC;
	}
}

//////////////////////////////////////////////////////////
// category implementations
//////////////////////////////////////////////////////////

#ifdef A4AF_CATS // NEO: MAC - [MorphA4AFCategories] -- Xanatos -->
void CPreferences::SaveCats(){

	// Cats
	CString catinif,ixStr,buffer;
	catinif.Format(L"%sCategory.ini",configdir);
	_tremove(catinif);

	CIni catini( catinif, L"Category" );
	catini.WriteInt(L"Count",catMap.GetCount()-1,L"General");
	catini.WriteInt(L"CategoryVersion", 2, L"General"); 
	for (int ix=0;ix<catMap.GetCount();ix++){
		ixStr.Format(L"Cat#%i",ix);
		catini.WriteString(L"Title",catMap.GetAt(ix)->title,ixStr);
		catini.WriteString(L"Incoming",catMap.GetAt(ix)->incomingpath,ixStr);
		catini.WriteString(L"Temp",catMap.GetAt(ix)->temppath,ixStr); // NEO: MTD - [MultiTempDirectories]
		catini.WriteString(L"Comment",catMap.GetAt(ix)->comment,ixStr);
		buffer.Format(L"%lu",catMap.GetAt(ix)->color,ixStr);
		catini.WriteString(L"Color",buffer,ixStr);
		catini.WriteInt(L"a4afPriority",catMap.GetAt(ix)->prio,ixStr);
		catini.WriteInt(L"AdvancedA4AFMode", catMap.GetAt(ix)->iAdvA4AFMode, ixStr);
		// NEO: NRT - [NeoReleaserTweaks]
		catini.WriteInt(L"uplPriority",catMap.GetAt(ix)->boost,ixStr);
		catini.WriteBool(L"ReleaseMode", catMap.GetAt(ix)->release, ixStr);
		// NEO: NRT END

        catini.WriteBool(L"downloadInAlphabeticalOrder", catMap.GetAt(ix)->downloadInAlphabeticalOrder!=FALSE, ixStr);

		catini.WriteInt(L"vfFromCats", catMap.GetAt(ix)->viewfilters.nFromCats, ixStr);
		catini.WriteBool(L"vfVideo", catMap.GetAt(ix)->viewfilters.bVideo!=FALSE, ixStr);
		catini.WriteBool(L"vfAudio", catMap.GetAt(ix)->viewfilters.bAudio!=FALSE, ixStr);
		catini.WriteBool(L"vfArchives", catMap.GetAt(ix)->viewfilters.bArchives!=FALSE, ixStr);
		catini.WriteBool(L"vfImages", catMap.GetAt(ix)->viewfilters.bImages!=FALSE, ixStr);
		catini.WriteBool(L"vfWaiting", catMap.GetAt(ix)->viewfilters.bWaiting!=FALSE, ixStr);
		catini.WriteBool(L"vfTransferring", catMap.GetAt(ix)->viewfilters.bTransferring!=FALSE, ixStr);
		catini.WriteBool(L"vfPaused", catMap.GetAt(ix)->viewfilters.bPaused!=FALSE, ixStr);
		catini.WriteBool(L"vfStopped", catMap.GetAt(ix)->viewfilters.bStopped!=FALSE, ixStr);
		catini.WriteBool(L"vfStandby", catMap.GetAt(ix)->viewfilters.bStandby!=FALSE, ixStr); // NEO: SD - [StandByDL]
		catini.WriteBool(L"vfSuspend", catMap.GetAt(ix)->viewfilters.bSuspend!=FALSE, ixStr); // NEO: SC - [SuspendCollecting]
		catini.WriteBool(L"vfComplete", catMap.GetAt(ix)->viewfilters.bComplete!=FALSE, ixStr);
		catini.WriteBool(L"vfHashing", catMap.GetAt(ix)->viewfilters.bHashing!=FALSE, ixStr);
		catini.WriteBool(L"vfErrorUnknown", catMap.GetAt(ix)->viewfilters.bErrorUnknown!=FALSE, ixStr);
		catini.WriteBool(L"vfCompleting", catMap.GetAt(ix)->viewfilters.bCompleting!=FALSE, ixStr);
		catini.WriteBool(L"vfSeenComplet", catMap.GetAt(ix)->viewfilters.bSeenComplet!=FALSE, ixStr); //MORPH - Added by SiRoB, Seen Complet filter
		catini.WriteUInt64(L"vfFSizeMin", catMap.GetAt(ix)->viewfilters.nFSizeMin, ixStr);
		catini.WriteUInt64(L"vfFSizeMax", catMap.GetAt(ix)->viewfilters.nFSizeMax, ixStr);
		catini.WriteUInt64(L"vfRSizeMin", catMap.GetAt(ix)->viewfilters.nRSizeMin, ixStr);
		catini.WriteUInt64(L"vfRSizeMax", catMap.GetAt(ix)->viewfilters.nRSizeMax, ixStr);
		catini.WriteInt(L"vfTimeRemainingMin", catMap.GetAt(ix)->viewfilters.nTimeRemainingMin, ixStr);
		catini.WriteInt(L"vfTimeRemainingMax", catMap.GetAt(ix)->viewfilters.nTimeRemainingMax, ixStr);
		catini.WriteInt(L"vfSourceCountMin", catMap.GetAt(ix)->viewfilters.nSourceCountMin, ixStr);
		catini.WriteInt(L"vfSourceCountMax", catMap.GetAt(ix)->viewfilters.nSourceCountMax, ixStr);
		catini.WriteInt(L"vfAvailSourceCountMin", catMap.GetAt(ix)->viewfilters.nAvailSourceCountMin, ixStr);
		catini.WriteInt(L"vfAvailSourceCountMax", catMap.GetAt(ix)->viewfilters.nAvailSourceCountMax, ixStr);
		catini.WriteString(L"vfAdvancedFilterMask", catMap.GetAt(ix)->viewfilters.sAdvancedFilterMask, ixStr);

		catini.WriteBool(L"scFileSize", catMap.GetAt(ix)->selectioncriteria.bFileSize!=FALSE, ixStr);
		catini.WriteBool(L"scAdvancedFilterMask", catMap.GetAt(ix)->selectioncriteria.bAdvancedFilterMask!=FALSE, ixStr);

		catini.WriteBool(L"ResumeFileOnlyInSameCat", catMap.GetAt(ix)->bResumeFileOnlyInSameCat!=FALSE, ixStr); 
	}
}

void CPreferences::LoadCats() {
	CString ixStr,catinif;
	TCHAR buffer[100];

	catinif.Format(L"%sCategory.ini",configdir);
	CIni catini;
	
	bool bCreateDefault = false;
	bool bSkipLoad = false;
	if (!PathFileExists(catinif))
	{
		bCreateDefault = true;
		bSkipLoad = true;
	}
	else
	{
		catini.SetFileName(catinif);
		catini.SetSection(L"General");
		if (catini.GetInt(L"CategoryVersion") == 0)
			bCreateDefault = true;
	}

	if (bCreateDefault)
	{
		Category_Struct* defcat=new Category_Struct;

		_stprintf(defcat->title,L"Default");
    	defcat->prio=PR_NORMAL; // ZZ:DownloadManager
		defcat->iAdvA4AFMode = 0;
		// NEO: NRT - [NeoReleaserTweaks]
    	defcat->boost=PR_NORMAL; // ZZ:DownloadManager
		defcat->release = false;
		// NEO: NRT END
		_stprintf(defcat->incomingpath, incomingdir);
		_stprintf(defcat->temppath,L""); // NEO: MTD - [MultiTempDirectories]
		_stprintf(defcat->comment, L"The default category.  It can't be merged or deleted.");
		defcat->color = 0;
		defcat->viewfilters.bArchives = true;
		defcat->viewfilters.bAudio = true;
		defcat->viewfilters.bComplete = true;
		defcat->viewfilters.bCompleting = true;
		defcat->viewfilters.bSeenComplet = true;
		defcat->viewfilters.bErrorUnknown = true;
		defcat->viewfilters.bHashing = true;
		defcat->viewfilters.bImages = true;
		defcat->viewfilters.bPaused = true;
		defcat->viewfilters.bStopped = true;
		defcat->viewfilters.bStandby = true; // NEO: SD - [StandByDL]
		defcat->viewfilters.bSuspend = true; // NEO: SC - [SuspendCollecting]
		defcat->viewfilters.bSuspendFilters = false;
		defcat->viewfilters.bTransferring = true;
		defcat->viewfilters.bVideo = true;
		defcat->viewfilters.bWaiting = true;
		defcat->viewfilters.nAvailSourceCountMax = 0;
		defcat->viewfilters.nAvailSourceCountMin = 0;
		defcat->viewfilters.nFromCats = 2;
		defcat->viewfilters.nFSizeMax = 0;
		defcat->viewfilters.nFSizeMin = 0;
		defcat->viewfilters.nRSizeMax = 0;
		defcat->viewfilters.nRSizeMin = 0;
		defcat->viewfilters.nSourceCountMax = 0;
		defcat->viewfilters.nSourceCountMin = 0;
		defcat->viewfilters.nTimeRemainingMax = 0;
		defcat->viewfilters.nTimeRemainingMin = 0;
		defcat->viewfilters.sAdvancedFilterMask = "";
		defcat->selectioncriteria.bAdvancedFilterMask = false;
		defcat->selectioncriteria.bFileSize = false;
		defcat->bResumeFileOnlyInSameCat = false;
		AddCat(defcat);
		if (bSkipLoad)
		{
			SaveCats();
			return;
		}
	}

	int max=catini.GetInt(L"Count",0,L"General");

	for (int ix = bCreateDefault ? 1 : 0; ix <= max; ix++)
	{
		ixStr.Format(L"Cat#%i",ix);
        catini.SetSection(ixStr);

		Category_Struct* newcat = new Category_Struct;
		_stprintf(newcat->title,L"%s",catini.GetString(L"Title",L"",ixStr));
		_stprintf(newcat->incomingpath,L"%s",catini.GetString(L"Incoming",L"",ixStr));
		MakeFoldername(newcat->incomingpath);
		// NEO: MTD - [MultiTempDirectories]
		_stprintf(newcat->temppath,L"%s",catini.GetString(L"Temp",L"",ixStr));
		MakeFoldername(newcat->temppath); 
		// NEO: MTD END
		_stprintf(buffer,L"%s",catini.GetString(L"Color",L"0",ixStr));
		newcat->color=_tstoi(buffer);
		_stprintf(newcat->comment,L"%s",catini.GetString(L"Comment",L"",ixStr));
		newcat->prio = catini.GetInt(L"a4afPriority",PR_NORMAL,ixStr); // ZZ:DownloadManager
		newcat->iAdvA4AFMode = catini.GetInt(L"AdvancedA4AFMode", 0);
		// NEO: NRT - [NeoReleaserTweaks]
		newcat->boost = catini.GetInt(L"uplPriority",PR_NORMAL,ixStr);
		newcat->release = catini.GetBool(L"ReleaseMode", FALSE, ixStr);
		// NEO: NRT END

        newcat->downloadInAlphabeticalOrder = catini.GetBool(L"downloadInAlphabeticalOrder", FALSE, ixStr); // ZZ:DownloadManager

		newcat->viewfilters.nFromCats = catini.GetInt(L"vfFromCats", ix==0?0:2);
		newcat->viewfilters.bSuspendFilters = false;
		newcat->viewfilters.bVideo = catini.GetBool(L"vfVideo", true);
		newcat->viewfilters.bAudio = catini.GetBool(L"vfAudio", true);
		newcat->viewfilters.bArchives = catini.GetBool(L"vfArchives", true);
		newcat->viewfilters.bImages = catini.GetBool(L"vfImages", true);
		newcat->viewfilters.bWaiting = catini.GetBool(L"vfWaiting", true);
		newcat->viewfilters.bTransferring = catini.GetBool(L"vfTransferring", true);
		newcat->viewfilters.bPaused = catini.GetBool(L"vfPaused", true);
		newcat->viewfilters.bStopped = catini.GetBool(L"vfStopped", true);
		newcat->viewfilters.bStandby = catini.GetBool(L"vfStandby", true); // NEO: SD - [StandByDL]
		newcat->viewfilters.bSuspend = catini.GetBool(L"vfSuspend", true); // NEO: SC - [SuspendCollecting]
		newcat->viewfilters.bComplete = catini.GetBool(L"vfComplete", true);
		newcat->viewfilters.bHashing = catini.GetBool(L"vfHashing", true);
		newcat->viewfilters.bErrorUnknown = catini.GetBool(L"vfErrorUnknown", true);
		newcat->viewfilters.bCompleting = catini.GetBool(L"vfCompleting", true);
		newcat->viewfilters.bSeenComplet = catini.GetBool(L"vfSeenComplet", true); 
		newcat->viewfilters.nFSizeMin = catini.GetUInt64(L"vfFSizeMin", 0);
		newcat->viewfilters.nFSizeMax = catini.GetUInt64(L"vfFSizeMax", 0);
		newcat->viewfilters.nRSizeMin = catini.GetUInt64(L"vfRSizeMin", 0);
		newcat->viewfilters.nRSizeMax = catini.GetUInt64(L"vfRSizeMax", 0);
		newcat->viewfilters.nTimeRemainingMin = catini.GetInt(L"vfTimeRemainingMin", 0);
		newcat->viewfilters.nTimeRemainingMax = catini.GetInt(L"vfTimeRemainingMax", 0);
		newcat->viewfilters.nSourceCountMin = catini.GetInt(L"vfSourceCountMin", 0);
		newcat->viewfilters.nSourceCountMax = catini.GetInt(L"vfSourceCountMax", 0);
		newcat->viewfilters.nAvailSourceCountMin = catini.GetInt(L"vfAvailSourceCountMin", 0);
		newcat->viewfilters.nAvailSourceCountMax = catini.GetInt(L"vfAvailSourceCountMax", 0);
		newcat->viewfilters.sAdvancedFilterMask = catini.GetString(L"vfAdvancedFilterMask", L"");

		newcat->selectioncriteria.bFileSize = catini.GetBool(L"scFileSize", true);
		newcat->selectioncriteria.bAdvancedFilterMask = catini.GetBool(L"scAdvancedFilterMask", true);
		newcat->bResumeFileOnlyInSameCat = catini.GetBool(L"ResumeFileOnlyInSameCat", false);

		AddCat(newcat);
		//if (!PathFileExists(newcat->incomingpath))
		//	::CreateDirectory(newcat->incomingpath, 0);

		// NEO: MTD - [MultiTempDirectories]
		if (!PathFileExists(newcat->temppath))
			_stprintf(newcat->temppath,L"");
		// NEO: MTD END	

	}
}
#else
void CPreferences::SaveCats(){

	// Cats
	CString catinif,ixStr,buffer;
	catinif.Format(L"%sCategory.ini",configdir);
	_tremove(catinif);

	CIni catini( catinif, L"Category" );
	catini.WriteInt(L"Count",catMap.GetCount()-1,L"General");
	for (int ix=0;ix<catMap.GetCount();ix++){
		ixStr.Format(L"Cat#%i",ix);
		catini.WriteString(L"Title",catMap.GetAt(ix)->title,ixStr);
		catini.WriteString(L"Incoming",catMap.GetAt(ix)->incomingpath,ixStr);
		catini.WriteString(L"Comment",catMap.GetAt(ix)->comment,ixStr);
		catini.WriteString(L"RegularExpression",catMap.GetAt(ix)->regexp,ixStr);
		buffer.Format(L"%lu",catMap.GetAt(ix)->color);
		catini.WriteString(L"Color",buffer,ixStr);
		catini.WriteInt(L"a4afPriority",catMap.GetAt(ix)->prio,ixStr); // ZZ:DownloadManager
		catini.WriteString(L"AutoCat",catMap.GetAt(ix)->autocat,ixStr); 
		catini.WriteInt(L"Filter",catMap.GetAt(ix)->filter,ixStr); 
		catini.WriteBool(L"FilterNegator",catMap.GetAt(ix)->filterNeg,ixStr);
		catini.WriteBool(L"AutoCatAsRegularExpression",catMap.GetAt(ix)->ac_regexpeval,ixStr);
        catini.WriteBool(L"downloadInAlphabeticalOrder", catMap.GetAt(ix)->downloadInAlphabeticalOrder!=FALSE, ixStr);
		catini.WriteBool(L"Care4All",catMap.GetAt(ix)->care4all,ixStr);
	}
}

void CPreferences::LoadCats() {
	CString ixStr,catinif,cat_a,cat_b,cat_c;
	TCHAR buffer[100];

	catinif.Format(L"%sCategory.ini",configdir);

	CIni catini( catinif, L"Category" );
	int max=catini.GetInt(L"Count",0,L"General");

	for (int ix=0;ix<=max;ix++){
		ixStr.Format(L"Cat#%i",ix);

		Category_Struct* newcat=new Category_Struct;
		newcat->filter=0;
		_stprintf(newcat->title,L"%s",catini.GetString(L"Title",L"",ixStr));
		_stprintf(newcat->incomingpath,L"%s",catini.GetString(L"Incoming",L"",ixStr));
		MakeFoldername(newcat->incomingpath);
		if (wcslen(newcat->incomingpath) > 0 && !IsShareableDirectory(newcat->incomingpath)){ // NEO: MAC - [MorphA4AFCategories] <-- Xanatos --
			_sntprintf(newcat->incomingpath, ARRSIZE(newcat->incomingpath), L"%s", GetIncomingDir());
			MakeFoldername(newcat->incomingpath);
		}
		_stprintf(newcat->comment,L"%s",catini.GetString(L"Comment",L"",ixStr));
		newcat->prio =catini.GetInt(L"a4afPriority",PR_NORMAL,ixStr); // ZZ:DownloadManager
		newcat->filter=catini.GetInt(L"Filter",0,ixStr);
		newcat->filterNeg =catini.GetBool(L"FilterNegator",FALSE,ixStr);
		newcat->ac_regexpeval  =catini.GetBool(L"AutoCatAsRegularExpression",FALSE,ixStr);
		newcat->care4all=catini.GetBool(L"Care4All",FALSE,ixStr);

		newcat->regexp=catini.GetString(L"RegularExpression",L"",ixStr);
		newcat->autocat=catini.GetString(L"Autocat",L"",ixStr);
        newcat->downloadInAlphabeticalOrder = catini.GetBool(L"downloadInAlphabeticalOrder", FALSE, ixStr); // ZZ:DownloadManager

		_stprintf(buffer,L"%s",catini.GetString(L"Color",L"0",ixStr));
		newcat->color = _tstoi(buffer);

		AddCat(newcat);
		//if (!PathFileExists(newcat->incomingpath)) // NEO: MAC - [MorphA4AFCategories] <-- Xanatos --
		//	::CreateDirectory(newcat->incomingpath,0);
	}
}
#endif // A4AF_CATS // NEO: MAC END <-- Xanatos --
void CPreferences::RemoveCat(int index)	{
	if (index>=0 && index<catMap.GetCount()) { 
		Category_Struct* delcat;
		delcat=catMap.GetAt(index); 
		catMap.RemoveAt(index); 
		delete delcat;
	}
}

#ifndef A4AF_CATS // NEO: MAC - [MorphA4AFCategories] -- Xanatos -->
bool CPreferences::SetCatFilter(int index, int filter){
	if (index>=0 && index<catMap.GetCount()) { 
		Category_Struct* cat;
		cat=catMap.GetAt(index); 
		cat->filter=filter;
		return true;
	} 
	
	return false;
}

int CPreferences::GetCatFilter(int index){
	if (index>=0 && index<catMap.GetCount()) {
		return catMap.GetAt(index)->filter;
	}
	
    return 0;
}

bool CPreferences::GetCatFilterNeg(int index){
	if (index>=0 && index<catMap.GetCount()) {
		return catMap.GetAt(index)->filterNeg;
	}
	
    return false;
}

void CPreferences::SetCatFilterNeg(int index, bool val) {
	if (index>=0 && index<catMap.GetCount()) {
		catMap.GetAt(index)->filterNeg=val;
	}
}
#endif // A4AF_CATS // NEO: MAC END <-- Xanatos --

bool CPreferences::MoveCat(UINT from, UINT to){
	if (from>=(UINT)catMap.GetCount() || to >=(UINT)catMap.GetCount()+1 || from==to) return false;

	Category_Struct* tomove;

	tomove=catMap.GetAt(from);

	if (from < to) {
		catMap.RemoveAt(from);
		catMap.InsertAt(to-1,tomove);
	} else {
		catMap.InsertAt(to,tomove);
		catMap.RemoveAt(from+1);
	}
	
	SaveCats();

	return true;
}


bool CPreferences::IsInstallationDirectory(const CString& rstrDir)
{
	CString strFullPath;
	if (PathCanonicalize(strFullPath.GetBuffer(MAX_PATH), rstrDir))
		strFullPath.ReleaseBuffer();
	else
		strFullPath = rstrDir;
	
	// skip sharing of several special eMule folders
	if (!CompareDirectories(strFullPath, GetAppDir()))			// ".\eMule"
		return true;
	if (!CompareDirectories(strFullPath, GetConfigDir()))		// ".\eMule\config"
		return true;
	if (!CompareDirectories(strFullPath, GetWebServerDir()))	// ".\eMule\webserver"
		return true;
	if (!CompareDirectories(strFullPath, GetLangDir()))			// ".\eMule\lang"
		return true;

	return false;
}

bool CPreferences::IsShareableDirectory(const CString& rstrDir)
{
	if (IsInstallationDirectory(rstrDir))
		return false;

	CString strFullPath;
	if (PathCanonicalize(strFullPath.GetBuffer(MAX_PATH), rstrDir))
		strFullPath.ReleaseBuffer();
	else
		strFullPath = rstrDir;
	
	// skip sharing of several special eMule folders
	//for (int i=0;i<GetTempDirCount();i++)
	//	if (!CompareDirectories(strFullPath, GetTempDir(i)))			// ".\eMule\temp"
	//		return false;

	// NEO: MTD - [MultiTempDirectories] -- Xanatos -->
	if (!CompareDirectories(strFullPath, GetTempDir()))			// ".\eMule\temp"
		return false;

	for (POSITION pos = tempdir_list.GetHeadPosition();pos != 0;tempdir_list.GetNext(pos)){
		CString folder=tempdir_list.GetAt(pos);
		if (!CompareDirectories(strFullPath, folder))
			return false;
	}
	// NEO: MTD END <-- Xanatos --

	return true;
}

void CPreferences::UpdateLastVC()
{
	struct tm tmTemp;
	versioncheckLastAutomatic = safe_mktime(CTime::GetCurrentTime().GetLocalTm(&tmTemp));
}

void CPreferences::SetWSPass(CString strNewPass)
{
	_stprintf(m_sWebPassword, L"%s", MD5Sum(strNewPass).GetHash().GetBuffer(0));
}

void CPreferences::SetWSLowPass(CString strNewPass)
{
	_stprintf(m_sWebLowPassword, L"%s", MD5Sum(strNewPass).GetHash().GetBuffer(0));
}

void CPreferences::SetMMPass(CString strNewPass)
{
	_stprintf(m_sMMPassword, L"%s", MD5Sum(strNewPass).GetHash().GetBuffer(0));
}

void CPreferences::SetMaxUpload(UINT in)
{
	uint16 oldMaxUpload = (uint16)in;
	maxupload = (oldMaxUpload) ? oldMaxUpload : (uint16)UNLIMITED;
}

void CPreferences::SetMaxDownload(UINT in)
{
	uint16 oldMaxDownload = (uint16)in;
	maxdownload = (oldMaxDownload) ? oldMaxDownload : (uint16)UNLIMITED;
}

void CPreferences::SetNetworkKademlia(bool val)
{
	networkkademlia = val; 
}

CString CPreferences::GetHomepageBaseURLForLevel(int nLevel){
	CString tmp;
	if (nLevel == 0)
		tmp = L"http://emule-project.net";
	else if (nLevel == 1)
		tmp = L"http://www.emule-project.org";
	else if (nLevel == 2)
		tmp = L"http://www.emule-project.com";
	else if (nLevel < 100)
		tmp.Format(L"http://www%i.emule-project.net",nLevel-2);
	else if (nLevel < 150)
		tmp.Format(L"http://www%i.emule-project.org",nLevel);
	else if (nLevel < 200)
		tmp.Format(L"http://www%i.emule-project.com",nLevel);
	else if (nLevel == 200)
		tmp = L"http://emule.sf.net";
	else if (nLevel == 201)
		tmp = L"http://www.emuleproject.net";
	else if (nLevel == 202)
		tmp = L"http://sourceforge.net/projects/emule/";
	else
		tmp = L"http://www.emule-project.net";
	return tmp;
}

CString CPreferences::GetVersionCheckBaseURL(){
	CString tmp;
	UINT nWebMirrorAlertLevel = GetWebMirrorAlertLevel();
	if (nWebMirrorAlertLevel < 100)
		tmp = L"http://vcheck.emule-project.net";
	else if (nWebMirrorAlertLevel < 150)
		tmp.Format(L"http://vcheck%i.emule-project.org",nWebMirrorAlertLevel);
	else if (nWebMirrorAlertLevel < 200)
		tmp.Format(L"http://vcheck%i.emule-project.com",nWebMirrorAlertLevel);
	else if (nWebMirrorAlertLevel == 200)
		tmp = L"http://emule.sf.net";
	else if (nWebMirrorAlertLevel == 201)
		tmp = L"http://www.emuleproject.net";
	else
		tmp = L"http://vcheck.emule-project.net";
	return tmp;
}

bool CPreferences::IsDefaultNick(const CString strCheck){
	// not fast, but this function is called often
	for (int i = 0; i != 255; i++){
		if (GetHomepageBaseURLForLevel(i) == strCheck)
			return true;
	}
	return ( strCheck == L"http://emule-project.net" );
}

void CPreferences::SetUserNick(LPCTSTR pszNick)
{
	strNick = pszNick;
	// NEO: XSF - [ExtendedSharedFiles] -- Xanatos -->
	if (theApp.sharedfiles)
		theApp.sharedfiles->ShowLocalFilesDialog(true);
	// NEO: XSF END <-- Xanatos --
}

UINT CPreferences::GetWebMirrorAlertLevel(){
	// Known upcoming DDoS Attacks
	if (m_nWebMirrorAlertLevel == 0){
		// no threats known at this time
	}
	// end
	if (UpdateNotify())
		return m_nWebMirrorAlertLevel;
	else
		return 0;
}

bool CPreferences::IsRunAsUserEnabled(){
	return (GetWindowsVersion() == _WINVER_XP_ || GetWindowsVersion() == _WINVER_2K_) && m_bRunAsUser;
}

bool CPreferences::GetUseReBarToolbar()
{
	return GetReBarToolbar() && theApp.m_ullComCtrlVer >= MAKEDLLVERULL(5,8,0,0);
}

int	CPreferences::GetMaxGraphUploadRate(bool bEstimateIfUnlimited){
	if (maxGraphUploadRate != UNLIMITED || !bEstimateIfUnlimited){
		return maxGraphUploadRate;
	}
	else{
		if (maxGraphUploadRateEstimated != 0){
			return maxGraphUploadRateEstimated +4;
		}
		else
			return 16;
	}
}

void CPreferences::EstimateMaxUploadCap(uint32 nCurrentUpload){
	if (maxGraphUploadRateEstimated+1 < nCurrentUpload){
		maxGraphUploadRateEstimated = nCurrentUpload;
		if (maxGraphUploadRate == UNLIMITED && theApp.emuledlg && theApp.emuledlg->statisticswnd)
			theApp.emuledlg->statisticswnd->SetARange(false, thePrefs.GetMaxGraphUploadRate(true));
	}
}

void CPreferences::SetMaxGraphUploadRate(int in){
	maxGraphUploadRate	=(in) ? in : UNLIMITED;
}

#ifndef NEO_BC // NEO: NBC -- Xanatos -->
bool CPreferences::IsDynUpEnabled()	{
	return m_bDynUpEnabled || maxGraphUploadRate == UNLIMITED;
}
#endif // NEO_BC // NEO: NBC END <-- Xanatos --

bool CPreferences::CanFSHandleLargeFiles()	{
	// NEO: MTD - [MultiTempDirectories] -- Xanatos -->
	bool bResult = !IsFileOnFATVolume(GetTempDir());
	for (POSITION pos = tempdir_list.GetHeadPosition();pos != 0;tempdir_list.GetNext(pos)){
		CString folder=tempdir_list.GetAt(pos);
		if (!IsFileOnFATVolume(folder)){
			bResult = true;
			break;
		}
	}
	// NEO: MTD END <-- Xanatos --
	return bResult && !IsFileOnFATVolume(GetIncomingDir());
}

uint16 CPreferences::GetRandomTCPPort()
{
	// Get table of currently used TCP ports.
	PMIB_TCPTABLE pTCPTab = NULL;
	HMODULE hIpHlpDll = LoadLibrary(_T("iphlpapi.dll"));
	if (hIpHlpDll)
	{
		DWORD (WINAPI *pfnGetTcpTable)(PMIB_TCPTABLE, PDWORD, BOOL);
		(FARPROC&)pfnGetTcpTable = GetProcAddress(hIpHlpDll, "GetTcpTable");
		if (pfnGetTcpTable)
		{
			DWORD dwSize = 0;
			if ((*pfnGetTcpTable)(NULL, &dwSize, FALSE) == ERROR_INSUFFICIENT_BUFFER)
			{
				// The nr. of TCP entries could change (increase) between
				// the two function calls, allocate some more memory.
				dwSize += sizeof(pTCPTab->table[0]) * 50;
				pTCPTab = (PMIB_TCPTABLE)malloc(dwSize);
				if (pTCPTab)
				{
					if ((*pfnGetTcpTable)(pTCPTab, &dwSize, TRUE) != ERROR_SUCCESS)
					{
						free(pTCPTab);
						pTCPTab = NULL;
					}
				}
			}
		}
		FreeLibrary(hIpHlpDll);
	}

	const UINT uValidPortRange = 61000;
	int iMaxTests = uValidPortRange; // just in case, avoid endless loop
	uint16 nPort;
	bool bPortIsFree;
	do {
		// Get random port
		nPort = 4096 + (GetRandomUInt16() % uValidPortRange);

		// The port is by default assumed to be available. If we got a table of currently
		// used TCP ports, we verify that this port is currently not used in any way.
		bPortIsFree = true;
		if (pTCPTab)
		{
			uint16 nPortBE = htons(nPort);
			for (UINT e = 0; e < pTCPTab->dwNumEntries; e++)
			{
				// If there is a TCP entry in the table (regardless of its state), the port
				// is treated as not available.
				if (pTCPTab->table[e].dwLocalPort == nPortBE)
				{
					bPortIsFree = false;
					break;
				}
			}
		}
	}
	while (!bPortIsFree && --iMaxTests > 0);
	free(pTCPTab);
	return nPort;
}

uint16 CPreferences::GetRandomUDPPort()
{
	// Get table of currently used UDP ports.
	PMIB_UDPTABLE pUDPTab = NULL;
	HMODULE hIpHlpDll = LoadLibrary(_T("iphlpapi.dll"));
	if (hIpHlpDll)
	{
		DWORD (WINAPI *pfnGetUdpTable)(PMIB_UDPTABLE, PDWORD, BOOL);
		(FARPROC&)pfnGetUdpTable = GetProcAddress(hIpHlpDll, "GetUdpTable");
		if (pfnGetUdpTable)
		{
			DWORD dwSize = 0;
			if ((*pfnGetUdpTable)(NULL, &dwSize, FALSE) == ERROR_INSUFFICIENT_BUFFER)
			{
				// The nr. of UDP entries could change (increase) between
				// the two function calls, allocate some more memory.
				dwSize += sizeof(pUDPTab->table[0]) * 50;
				pUDPTab = (PMIB_UDPTABLE)malloc(dwSize);
				if (pUDPTab)
				{
					if ((*pfnGetUdpTable)(pUDPTab, &dwSize, TRUE) != ERROR_SUCCESS)
					{
						free(pUDPTab);
						pUDPTab = NULL;
					}
				}
			}
		}
		FreeLibrary(hIpHlpDll);
	}

	const UINT uValidPortRange = 61000;
	int iMaxTests = uValidPortRange; // just in case, avoid endless loop
	uint16 nPort;
	bool bPortIsFree;
	do {
		// Get random port
		nPort = 4096 + (GetRandomUInt16() % uValidPortRange);

		// The port is by default assumed to be available. If we got a table of currently
		// used UDP ports, we verify that this port is currently not used in any way.
		bPortIsFree = true;
		if (pUDPTab)
		{
			uint16 nPortBE = htons(nPort);
			for (UINT e = 0; e < pUDPTab->dwNumEntries; e++)
			{
				if (pUDPTab->table[e].dwLocalPort == nPortBE)
				{
					bPortIsFree = false;
					break;
				}
			}
		}
	}
	while (!bPortIsFree && --iMaxTests > 0);
	free(pUDPTab);
	return nPort;
}


/* Xanatos:
* All Neo Preferences Functions:
*/
// NEO: NCFG - [NeoConfiguration] -- Xanatos -->
CPreferencesEx::CPreferencesEx()
{
#ifdef WEBCACHE // NEO: WC - [WebCache]
	HighIDConfirmed = false;
	//JP set standard values for stuff that doesn't need to be saved. This should probably be somewhere else START
	expectingWebCachePing = false;
	WebCachePingSendTime = 0;
	WebCacheDisabledThisSession = false;
	//JP set standard values for stuff that doesn't need to be saved. This should probably be somewhere else END
#endif // NEO: WC END
	m_bOnQuickStart = false; // NEO: QS - [QuickStart]
	// NEO: NATS - [NatSupport]
	m_uUDPPortPingTime = 0;
	m_uUDPPortPingFails = 0;
	m_iIPExternal = 0;
	m_bUDPPingPending = 0;
	m_bKADPingPending = 0;

	m_iTCPExternal = 0;
	m_iUDPExternal = 0;
	m_iKADExternal = 0; // NEO: KAX - [KadAuxPort]
	// NEO: NATS END
}

void CPreferencesEx::LoadNeoPreferences()
{
	CIni ini(GetConfigFile(), L"Neo");

#ifdef NEO_BC // NEO: NBC - [NeoBandwidthControl]
	m_bManageConnections = ini.GetBool(INI_MANAGE_CONNECTIONS, false);
	m_fManageConnectionsFactor = ini.GetFloat(INI_MANAGE_CONNECTIONS_FACTOR, VAL_CON_CTRL_DEF);

	m_uNAFCEnabled = ini.GetInt(INI_NAFC_ENABLED, 1);
	m_bISPCustomIP = ini.GetBool(INI_ISP_CUSTOM_IP, false);
	m_uISPZone = ini.GetInt(INI_ISP_ZONE, 0);
	m_uISPMask = ini.GetInt(INI_ISP_MASK, 0x0000FFFF);
	m_bBindToAdapter = ini.GetBool(INI_BIND_TO_ADAPTER, false);


	m_bCheckConnection = ini.GetBool(INI_CHECK_CONNECTION, false);
	m_bStaticLowestPing = ini.GetBool(INI_STATIC_LOWEST_PING, false);
	m_iPingMode = ini.GetInt(INI_PING_MODE, 0);
	m_bNoTTL = ini.GetBool(INI_NO_TTL, false);
	m_bManualHostToPing = ini.GetBool(INI_MANUAL_HOST_TO_PING, false);
	m_sPingServer = ini.GetString(INI_PING_SERVER, L"");

	m_bAutoMSS = ini.GetBool(INI_AUTO_MSS, false);
	m_iMSS = ini.GetInt(INI_MSS, 1300);

	m_bUseDoubleSendSize = ini.GetBool(INI_USE_DOUBLE_SEND_SIZE, true);


	m_bDirectDownload = ini.GetBool(INI_DIRECT_DOWNLOAD, true);
	m_bDirectReceivingTCP = ini.GetBool(INI_DIRECT_RECEIVING_TCP, true);
	m_bDirectReceivingUDP = ini.GetBool(INI_DIRECT_RECEIVING_UDP, true);
	m_iBCTimeDown = ini.GetInt(INI_BC_TIME_DOWN, VAL_BC_TIME_DOWN_DEF);
	m_iBCPriorityDown = ini.GetInt(INI_BC_PRIORITY_DOWN, 0);
	m_uSetDownloadBuffer = ini.GetInt(INI_SET_DOWNLOAD_BUFFER, TRUE);
	m_iDownloadBufferSize = ini.GetInt(INI_DOWNLOAD_BUFFER_SIZE, VAL_DOWNLOAD_BUFFER_DEF);
	
	//m_bDirectUpload = ini.GetBool(INI_DIRECT_UPLOAD, false);
	m_uUseBlockedQueue = ini.GetInt(INI_USE_BLOCKED_QUEUE, TRUE);
	m_bDirectSendingTCP = ini.GetBool(INI_DIRECT_SENDING_TCP, false);
	m_bDirectSendingUDP = ini.GetBool(INI_DIRECT_SENDING_UDP, false);
	m_iBCTimeUp = ini.GetInt(INI_BC_TIME_UP, VAL_BC_TIME_UP_DEF);
	m_iBCPriorityUp = ini.GetInt(INI_BC_PRIORITY_UP, 0);
	m_uSetUploadBuffer = ini.GetInt(INI_SET_UPLOAD_BUFFER, 2);
	m_iUploadBufferSize = ini.GetInt(INI_UPLOAD_BUFFER_SIZE, VAL_UPLOAD_BUFFER_DEF);

	m_iDatarateSamples = ini.GetInt(INI_DATARATE_SAMPLES, 10);


	m_bIncludeOverhead = ini.GetBool(INI_INCLUDE_OVERHEAD, false);
	m_bIncludeTCPAck = ini.GetBool(INI_INCLUDE_TCP_ACK, false);
	m_bConnectionsOverHead = ini.GetBool(INI_CONNECTIONS_OVERHEAD, false);
	m_bSessionRatio = ini.GetBool(INI_ZZ_RATIO, false);


	m_iDownloadControl = ini.GetInt(INI_DOWNLOAD_CONTROL, 0);
	m_fMinBCDownload = ini.GetFloat(INI_MIN_BC_DOWNLOAD, 40);
	m_fMaxBCDownload = ini.GetFloat(INI_MAX_BC_DOWNLOAD, 0);


	m_iUploadControl = ini.GetInt(INI_UPLOAD_CONTROL, 0);
	m_fMinBCUpload = ini.GetFloat(INI_MIN_BC_UPLOAD,10);
	m_fMaxBCUpload = ini.GetFloat(INI_MAX_BC_UPLOAD,0);


	m_fMaxDownStream = ini.GetFloat(INI_MAX_DOWN_STREAM,64);
	m_fMaxUpStream = ini.GetFloat(INI_MAX_UP_STREAM,16);


	m_bMinimizeOpenedSlots = ini.GetBool(INI_MINIMIZE_OPENED_SLOTS, false);
	m_uCumulateBandwidth = ini.GetInt(INI_CUMULATE_BANDWIDTH, FALSE);
	m_uBadwolfsUpload = ini.GetInt(INI_BADWOLFS_UPLOAD, 2);

	m_iMaxReservedSlots = ini.GetInt(INI_MAX_RESERVED_SLOTS, VAL_MAX_RESERVED_SLOTS_DEF);
	
	m_bIncreaseTrickleSpeed = ini.GetBool(INI_INCREASE_TRICKLE_SPEED, true);
	m_fIncreaseTrickleSpeed = ini.GetFloat(INI_INCREASE_TRICKLE_SPEED_VALUE, VAL_INCREASE_TRICKLE_SPEED_DEF);

#ifdef NEO_UBT // NEO: BM - [BandwidthModeration]
	m_uSeparateReleaseBandwidth = ini.GetInt(INI_SEPARATE_RELEASE_BANDWIDTH, FALSE);
	m_fReleaseSlotSpeed = ini.GetFloat(INI_RELEASE_SLOT_SPEED, VAL_RELEASE_SLOT_SPEED_DEF);
	m_fReleaseBandwidthPercentage = ini.GetFloat(INI_RELEASE_BANDWIDTH_PERCENTAGE, VAL_RELEASE_BANDWIDTH_PERCENTAGE_DEF);

	m_bSeparateFriendBandwidth = ini.GetBool(INI_SEPARATE_FRIEND_BANDWIDTH, false);
	m_fFriendSlotSpeed = ini.GetFloat(INI_FRIEND_SLOT_SPEED, VAL_FRIEND_SLOT_SPEED_DEF);
	m_fFriendBandwidthPercentage = ini.GetFloat(INI_FRIEND_BANDWIDTH_PERCENTAGE, VAL_FRIEND_BANDWIDTH_PERCENTAGE_DEF);
#endif // NEO_UBT // NEO: BM END

	m_bOpenMoreSlotsWhenNeeded = ini.GetBool(INI_OPEN_MORE_SLOTS_WHEN_NEEDED, true);
	m_bCheckSlotDatarate = ini.GetBool(INI_CHECK_SLOT_DATARATE, true);

	m_bIsTrickleBlocking = ini.GetBool(INI_TRICKLE_BLOCKING, false);
	m_bIsDropBlocking = ini.GetBool(INI_DROP_BLOCKING, true);

	//m_bAllowOverSending = ini.GetBool(INI_ALLOW_OVER_SENDING, true);


	m_bDynUpGoingDivider = ini.GetBool(INI_DYN_UP_GOING_DIVIDER, false);
	m_iDynUpGoingUpDivider = ini.GetInt(INI_DYN_UP_GOING_UP_DIVIDER, VAL_DYN_UP_GOING_UP_DIVIDER_DEF);
	m_iDynUpGoingDownDivider = ini.GetInt(INI_DYN_UP_GOING_DOWN_DIVIDER, VAL_DYN_UP_GOING_DOWN_DIVIDER_DEF);

	m_iUpMaxPingMethod = ini.GetInt(INI_UP_MAX_PING_METHOD, 1);
	m_iBasePingUp = ini.GetInt(INI_BASE_PING_UP, VAL_BASE_PING_UP_DEF);
	m_iPingUpTolerance = ini.GetInt(INI_PING_UP_TOLERANCE, VAL_PING_UP_TOLERANCE_DEF);
	m_iPingUpProzent = ini.GetInt(INI_PING_UP_PROZENT, VAL_PING_UP_PROZENT_DEF);


	m_bDynDownGoingDivider = ini.GetBool(INI_DYN_DOWN_GOING_DIVIDER, false);
	m_iDynDownGoingUpDivider = ini.GetInt(INI_DYN_DOWN_GOING_UP_DIVIDER, VAL_DYN_DOWN_GOING_UP_DIVIDER_DEF);
	m_iDynDownGoingDownDivider = ini.GetInt(INI_DYN_DOWN_GOING_DOWN_DIVIDER, VAL_DYN_DOWN_GOING_DOWN_DIVIDER_DEF);
	
	m_iDownMaxPingMethod = ini.GetInt(INI_DOWN_MAX_PING_METHOD, 1);
	m_iBasePingDown = ini.GetInt(INI_BASE_PING_DOWN, VAL_BASE_PING_DOWN_DEF);
	m_iPingDownTolerance = ini.GetInt(INI_PING_DOWN_TOLERANCE, VAL_PING_DOWN_TOLERANCE_DEF);
	m_iPingDownProzent = ini.GetInt(INI_PING_DOWN_PROZENT, VAL_PING_DOWN_PROZENT_DEF);
#endif // NEO_BC // NEO: NBC END

	m_bOnlyCompleteFiles = ini.GetBool(INI_ONLY_COMPLETE_FILE, true); // NEO: OCF - [OnlyCompleetFiles]
	m_iToOldComplete = ini.GetInt(INI_TO_OLD_COMPLETE,TO_OLD_SOURCE_DEF);
	m_bUseCustomPermissions = ini.GetBool(INI_CUSTOM_SHARE_VIWE_PERMISSIONS, false); // NEO: SSP - [ShowSharePermissions]
	m_bUseSaveComments = ini.GetBool(INI_SAVE_COMMENTS, true); // NEO: XC - [ExtendedComments]
	m_bUseKnownComments = ini.GetBool(INI_KNOWN_COMMENTS, false); // NEO: XCk - [ExtendedKnownComments]
	m_uInteligentChunkSelecting = ini.GetInt(INI_INTELIGENT_CHUNK_SELECTION,2); // NEO: ICS - [InteligentChunkSelection]
	m_uSubChunkTransfer = ini.GetInt(INI_SUB_CHUNK_TRANSFER,2); // NEO: SCT - [SubChunkTransfer]
	m_uSubChunkVerification = ini.GetInt(INI_SUB_CHUNK_VERIFICATION,0); // NEO: SCV - [SubChunkVerification]
	m_uRealPartStatus = ini.GetInt(INI_REAL_PART_STATUS,2); // NEO: RPS - [RealPartStatus]
	m_uShareAlsoEmptyFiles = ini.GetInt(INI_SHAREEMPTYFILES,0); // NEO: SEF - [ShareAlsoEmptyFiles]

	// NEO: NXI - [NeoExtraInfo]
	m_bSendExtraInfo = ini.GetBool(INI_NXI_ENABLE, true);
	m_bSendExtraInfoBandwidth = ini.GetBool(INI_NXI_BW, false);
	m_uSendExtraInfoUpTime = ini.GetInt(INI_NXI_UP_TIME, true);
	m_bSendExtraInfoDlFile = ini.GetBool(INI_NXI_DL_FILE, true);
	m_uSendExtraInfoUlFile = ini.GetInt(INI_NXI_UL_FILE, TRUE);
	m_bSendExtraInfoWaitingUsers = ini.GetBool(INI_NXI_WAITING_USERS, true);
	CString sSI = ini.GetString(INI_NXI_SOME_INFO);
	sSI.Replace(L"\\n",L"\n");
	m_sSendExtraInfoString = sSI;
	// NEO: NXI END
	m_dAppPriority = ini.GetInt(INI_APP_PRIORITY, NORMAL_PRIORITY_CLASS);
	// NEO: MOD - [NiceHash]
	m_bUseHashingDelay = ini.GetBool(INI_USE_HASHING_DELAY, false);
	m_iHashingDelay = ini.GetInt(INI_HASHING_DELAY, VAL_HASHING_DELAY_DEF);
	// NEO: MOD END
	// NEO: MOD - [RelaxCPU]
	m_bUseProcessingDelay = ini.GetBool(INI_USE_PROCESSING_DELAY, false);
	m_iProcessingDelay = ini.GetInt(INI_PROCESSING_DELAY, VAL_PROCESSING_DELAY_DEF);
	// NEO: MOD END
	// NEO: MOD - [RefreshShared]
	m_bRefreshShared = ini.GetBool(INI_REFRESH_SHARED, false);
	m_iRefreshSharedIntervals = ini.GetInt(INI_REFRESH_SHARED_INTERVALS, TIM_REFRESH_SHARED_INTERVALS_DEF);
	// NEO: MOD END
	m_bPauseOnFileComplete = ini.GetBool(INI_PAUSE_ON_FILE_COMPLETE, false); // NEO: POFC - [PauseOnFileComplete]
	m_bEstimatedDownloadTime = ini.GetBool(INI_ESTIMATED_DL_TIME, true); // NEO: EDT - [EstimatedDownloadTime] 
	m_uLowID2HighIDAutoCallback = ini.GetInt(INI_L2HAC, 2); // NEO: L2H - [LowID2HighIDAutoCallback]
	m_uAntiHideOS = ini.GetInt(INI_ANTI_HIDE_OS,2); // NEO: AHOS - [AntiHideOS]
	// NEO: DKA - [DownloadKeepAlive]
	m_bEnableDownloadKeepAlive = ini.GetBool(INI_ENABLE_DOWNLOAD_KEEP_ALIVE, false);
	m_iDownloadKeepAliveTimeout = ini.GetInt(INI_DOWNLOAD_KEEP_ALIVE_TIMEOUT, VAL_DOWNLOAD_KEEP_ALIVE_TIMEOUT_DEF);
	// NEO: DKA END
	// NEO: TCR - [TCPConnectionRetry]
	m_bTCPConnectionRetry = ini.GetBool(INI_TCP_CON_RETRY_ENABLE, false);
	m_iTCPConnectionRetry = ini.GetInt(INI_TCP_CON_RETRY_VALUE, VAL_TCP_CON_RETRY_DEF);
	// NEO: TCR END
	m_bTCPDisableNagle = ini.GetBool(INI_TCP_DISABLE_NAGLE, false);

	// NEO: NST - [NeoSourceTweaks]
	m_iHardLimit = ini.GetInt(INI_HARD_LIMIT, VAL_HARD_LIMIT_DEF);
	m_iSwapLimit = ini.GetInt(INI_SWAP_LIMIT, VAL_SWAP_LIMIT_DEF);
	m_iCleanUpLimit = ini.GetInt(INI_CLEANUP_LIMIT, VAL_CLEANUP_LIMIT_DEF);
	m_bCalcStandardLimits = ini.GetBool(INI_CALC_LIMITS,true);

	m_bXSDisable = ini.GetBool(INI_XS_DISABLE,false);
	m_iXSLimit = ini.GetInt(INI_XS_LIMIT,VAL_XS_LIMIT_DEF);
	m_iXSIntervals = ini.GetInt(INI_XS_INTERVAL,TIM_XS_INTERVAL_DEF);
	m_iXSClientIntervals = ini.GetInt(INI_XS_CLIENT_INTERVAL,TIM_XS_CLIENT_INTERVAL_DEF);
	m_iXSAnswerLimit = ini.GetInt(INI_XS_ANSWER_LIMIT,VAL_XS_ANSWER_LIMIT_DEF);
	m_iXSDelayValue = ini.GetInt(INI_XS_DELAY_VALUE,VAL_XS_DELAY_DEF);

	m_bSVRDisable = ini.GetBool(INI_SVR_DISABLE,false);
	m_iSVRLimit = ini.GetInt(INI_SVR_LIMIT,VAL_SVR_LIMIT_DEF);
	m_iSVRIntervals = ini.GetInt(INI_SVR_INTERVAL,TIM_SVR_INTERVAL_DEF);

	m_bKADDisable = ini.GetBool(INI_KAD_DISABLE,false);
	m_iKADLimit = ini.GetInt(INI_KAD_LIMIT,VAL_KAD_LIMIT_DEF);
	m_iKADIntervals = ini.GetInt(INI_KAD_INTERVAL,TIM_KAD_INTERVAL_DEF);
	m_iKADAmount = ini.GetInt(INI_KAD_AMOUNT,VAL_KAD_AMOUNT_DEF);
	m_iKADDelayValue = ini.GetInt(INI_KAD_DELAY_VALUE,VAL_KAD_DELAY_DEF);

	m_bUDPDisable = ini.GetBool(INI_UDP_DISABLE,false);
	m_iUDPLimit = ini.GetInt(INI_UDP_LIMIT,VAL_UDP_LIMIT_DEF);
	m_iUDPIntervals = ini.GetInt(INI_UDP_INTERVAL,TIM_UDP_INTERVAL_DEF);
	m_iGlobalUDPIntervals = ini.GetInt(INI_GLOBAL_UDP_INTERVAL,TIM_UDP_INTERVAL_DEF);
	m_iUDPAmount = ini.GetInt(INI_UDP_AMOUNT,VAL_UDP_AMOUNT_DEF);
	// NEO: XUC - [ExtendedUdpCache]
	m_uUDPCache = ini.GetInt(INI_UDP_CATCH,TRUE);
	m_iUDPCache = ini.GetInt(INI_UDP_CATCH_AMOUNT,VAL_UDP_CATCH_AMOUNT_DEF);
	// NEO: XUC END
	m_iRareFileLimit = ini.GetInt(INI_RARE_FILE,VAL_RARE_FILE_DEF);
	// NEO: NST END

	// NEO: NSD - [NeoSourceDrop]
	m_iLow2LowCleanUpTime = ini.GetInt(INI_LOW2LOW_CLEANUP_TIME,VAL_CLEANUP_TIME_DEF_L2L);
#if defined(NEO_SK) || defined(NEO_SS) // NEO: NSK - [NeoSourceKeeper] // NEO: NSS - [NeoSourceStorage]
	m_iBadCleanUpTime = ini.GetInt(INI_BAD_CLEANUP_TIME,VAL_CLEANUP_TIME_DEF_BAD);
	m_iGoneCleanUpTime = ini.GetInt(INI_GONE_CLEANUP_TIME,VAL_CLEANUP_TIME_DEF_GON);
	m_iSuspendCleanUpTime = ini.GetInt(INI_SUSPEND_CLEANUP_TIME,VAL_CLEANUP_TIME_DEF_SSP);
#endif // NEO_SK // NEO_SS // NEO: NSK END // NEO: NSS END
	m_iNnPCleanUpTime = ini.GetInt(INI_NNP_CLEANUP_TIME,VAL_CLEANUP_TIME_DEF_NNP);
	m_iFullQCleanUpTime = ini.GetInt(INI_FULLQ_CLEANUP_TIME,VAL_CLEANUP_TIME_DEF_FLQ);
	// NEO: NSD END

	// NEO: SR - [SpreadReask]
	m_bSpreadReask = ini.GetBool(INI_SPREAD_REASK,true);
	m_iSpreadReask = ini.GetInt(INI_SPREAD_REASK_VALUE,VAL_SPREAD_REASK_DEF);
	// NEO: SR END

	// NEO: OCC - [ObelixConnectionControl]
	m_bObelixConnectionControl = ini.GetBool(INI_OCC,false);
	m_iObelixConnectionControlValue = ini.GetInt(INI_OCC_VALUE,VAL_OCC_DEF);
	// NEO: OCC END

	// NEO: ASL - [AutoSoftLock]
	m_bAutoSoftLock = ini.GetBool(INI_ASL,true);
	m_iAutoSoftLockValue = ini.GetInt(INI_ASL_VALUE,VAL_ASL_DEF);
	// NEO: ASL END

	// NEO: AHL - [AutoHardLimit]
	m_iAutoHardLimit = ini.GetInt(INI_AHL,0);
	m_iMinimalHardLimit = ini.GetInt(INI_AHL_MIN_SRC,VAL_AHL_MIN_SRC_DEF);
	m_iGlobalHardLimit = ini.GetInt(INI_AHL_GLOBAL_SRC,VAL_AHL_GLOBAL_SRC_DEF);
	m_iAutoHardLimitTimer = ini.GetInt(INI_AHL_TIMER,TIM_AHL_DEF);
	// NEO: AHL END

	// NEO: XSC - [ExtremeSourceCache]
	m_bSourceCache = ini.GetBool(INI_SOURCE_CACHE,true);
	m_iSourceCacheLimit = ini.GetInt(INI_SOURCE_CACHE_LIMIT,VAL_SOURCE_CACHE_LIMIT_DEF);
	m_iSourceCacheTime = ini.GetInt(INI_SOURCE_CACHE_TIME,TIM_SOURCE_CACHE_TIME_DEF);
	// NEO: XSC END

	// NEO: DR - [DownloadReask]
	m_iReaskIntervals = ini.GetInt(INI_REASK_TIME,TIM_REASK_DEF);

	m_bDontNnPReask = ini.GetBool(INI_REASK_NNP_OFF,false);
	m_iNnPReaskIntervals = ini.GetInt(INI_REASK_NNP_TIME,TIM_REASK_NNP_DEF);

	m_bDontFullQReask = ini.GetBool(INI_REASK_FULLQ_OFF,false);
	m_iFullQReaskIntervals = ini.GetInt(INI_REASK_FULLQ_TIME,TIM_REASK_FULLQ_DEF);
	// NEO: DR END

#ifdef NEO_SK // NEO: NSK - [NeoSourceKeeper]
	m_bEnableSourceKeeper = ini.GetBool(INI_NEO_SOURCE_KEEPER,false);
#endif // NEO_SK // NEO: NSK END
#ifdef NEO_SS // NEO: NSS - [NeoSourceStorage]
	m_bEnableSourceStorage = ini.GetBool(INI_NEO_SOURCE_STORAGE,false);
	m_uAutoSaveSources = ini.GetInt(INI_AUTO_SAVE_SOURCES,2);
	m_iAutoSaveSourcesIntervals = ini.GetInt(INI_AUTO_SAVE_SOURCES_INTERVALS,TIM_AUTO_SAVE_SOURCES_INTERVALS_DEF);
	m_iSourceStorageLimit = ini.GetInt(INI_SOURCE_STORAGE_LIMIT,SOURCE_STORAGE_LIMIT_DEF);
	m_bAutoLoadStoredSources = ini.GetInt(INI_AUTO_LOAD_SOURCES,TRUE);
	m_bUseStorageBootstrap = ini.GetBool(INI_USE_STORAGE_BOOTSTRAP,true);
	m_iStorageBootstrapTime = ini.GetInt(INI_STORAGE_BOOTSTRAP_TIME,STORAGE_BOOTSTRAP_TIME_DEF);
	m_iStorageBootstrapRequirement = ini.GetInt(INI_STORAGE_BOOTSTRAP_REQUIREMENT,STORAGE_BOOTSTRAP_REQUIREMENT_DEF);
	m_bStoreLowIDSources = ini.GetBool(INI_STORE_LOW_ID,false);
	m_bStoreAlsoA4AFSources = ini.GetBool(INI_STORE_A4AF,true);
	m_uStoreSourcesFileStatus = ini.GetInt(INI_STORE_FILE_STATUS,TRUE);

	m_bAutoReaskStoredSources = ini.GetBool(INI_AUTO_REASK_STORED_SOURCES,true);
	m_iAutoReaskStoredSourcesLimit = ini.GetInt(INI_AUTO_REASK_STORED_SOURCES_LIMIT,AUTO_REASK_STORED_SOURCES_LIMIT_DEF);
	m_bTotalSourceRestore = ini.GetBool(INI_TOTAL_SOURCE_RESTORE,false);
	m_bUseAutoReaskStoredSourcesDelay = ini.GetBool(INI_USE_AUTO_REASK_STORED_SOURCES_DELAY,true);
	m_iAutoReaskStoredSourcesDelay = ini.GetInt(INI_AUTO_REASK_STORED_SOURCES_DELAY,AUTO_REASK_STORED_SOURCES_DELAY_DEF);

	m_iAutoReaskLoadedSourcesDelay = ini.GetInt(INI_AUTO_REASK_LOADED_SOURCES_DELAY,AUTO_REASK_LOADED_SOURCES_DELAY_DEF);

	m_bGroupStoredSourceReask = ini.GetBool(INI_GROUP_STORAGE,true);
	m_iStoredSourceGroupIntervals = ini.GetInt(INI_GROUP_INTERVALS,GROUP_INTERVALS_DEF);
	m_iStoredSourceGroupSize = ini.GetInt(INI_GROUP_SIZE,GROUP_SIZE_DEF);

	m_bUseSmoothOutOfDate = ini.GetBool(INI_USE_SMOOTH_OUTOFDATE,true);
	m_iMaxStoredFaildCount = ini.GetInt(INI_OUTOFDATE_MAXFAILS,OUTOFDATE_MAXFAILS_DEF);
	m_iStoredOutOfDate = ini.GetInt(INI_OUTOFDATE_MAXTIME,OUTOFDATE_MAXTIME_DEF);
#endif // NEO_SS // NEO: NSS END
#ifdef NEO_CD // NEO: NCD - [NeoClientDatabase]
	m_bEnableSourceList = ini.GetBool(INI_SOURCE_LIST,true);
	m_uSaveGlobalSourceList = ini.GetInt(INI_SAVE_GLOBAL_SOURCE_LIST,TRUE);
	m_iGlobalSourceListCleanUpTime = ini.GetInt(INI_GLOBAL_SOURCE_LIST_CLEAN_UP_TIME,TIM_GLOBAL_SOURCE_LIST_CLEAN_UP_TIME_DEF);
	m_bGlobalSourceListCleanUp = ini.GetBool(INI_GLOBAL_SOURCE_LIST_CLEAN_UP,true);
	m_iGlobalSourceListCleanUpIntervals = ini.GetInt(INI_GLOBAL_SOURCE_LIST_CLEAN_UP_INTERVALS,TIM_GLOBAL_SOURCE_LIST_CLEAN_UP_INTERVALS_DEF);
	m_bFastSourceCleanUp = ini.GetBool(INI_FAST_SOURCE_CLEAN_UP,false);
	m_bSaveSourceFileList = ini.GetBool(INI_SAVE_SOURCE_FILE_LIST,false);
	m_iSourceFileListCleanUpTime = ini.GetInt(INI_SOURCE_FILE_LIST_CLEAN_UP_TIME,TIM_SOURCE_FILE_LIST_CLEAN_UP_TIME_DEF);
	m_bSaveSourceDataInClient = ini.GetBool(INI_SAVE_SOURCE_DATAS_IN_CLIENTS,true);

	m_bIPZoneCheck = ini.GetBool(INI_USE_IP_ZONE_CHECK,true);

	m_bSourceHashMonitor = ini.GetBool(INI_USE_SOURCE_HASH_MONITOR,true);
	m_iSourceHashMonitorBadTime = ini.GetInt(INI_SOURCE_HASH_MONITOR_BAD_TIME,TIM_SOURCE_HASH_MONITOR_BAD_TIME_DEF);
	m_iSourceHashMonitorMaxBad = ini.GetInt(INI_SOURCE_HASH_MONITOR_MAX_BAD,SOURCE_HASH_MONITOR_MAX_BAD_DEF);

	m_iTableAmountToStore = ini.GetInt(INI_TABLE_AMOUT_TO_STORE,TABLE_AMOUT_TO_STORE_DEF);

	m_iIgnoreUnreachableInterval = ini.GetInt(INI_IGNORE_UNREACHABLE_INTERVAL,IGNORE_UNREACHABLE_INTERVAL_DEF);
	m_iIgnoreUndefinedInterval = ini.GetInt(INI_IGNORE_UNDEFINED_INTERVAL,IGNORE_UNDEFINED_INTERVAL_DEF);
	m_iBeginNewTableInterval = ini.GetInt(INI_BEGIN_NEW_TABLE_INTERVAL,BEGIN_NEW_TABLE_INTERVAL_DEF);
#endif // NEO_CD // NEO: NCD END
#ifdef NEO_SA // NEO: NSA - [NeoSourceAnaliser]
	m_bEnableSourceAnalizer = ini.GetBool(INI_ENABLE_SOURCE_ANALISER,true);
	m_iAnaliseIntervals = ini.GetInt(INI_ANALISIS_INTERVALS,ANALISIS_INTERVALS_DEF);
	m_iTableAmountToAnalise = ini.GetInt(INI_TABLE_AMOUT_TO_ANALISE,TABLE_AMOUT_TO_ANALISE_DEF);

	m_bDontStoreTemporarySources = ini.GetBool(INI_DONT_STORE_TEMP_SOURCES,false);

	m_iPropabilityMode = ini.GetInt(INI_PROBABILITY_MODE,PM_ENHANCED);
	m_fEnhancedFactor = ini.GetFloat(INI_ENHANCED_FACTOR,VAL_ENHANCED_FACTOR_DEF);

	m_iReaskPropability = ini.GetInt(INI_REASK_PROPABILITY,REASK_PROPABILITY_DEF);
	m_iReservePropability = ini.GetInt(INI_RESERVE_PROPABILITY,RESERVE_PROPABILITY_DEF);

	m_bAutoReserveReask = ini.GetBool(INI_AUTO_RESERVE_REASK,false);
	m_iReserveReaskPropability = ini.GetInt(INI_RESERVE_REASK_PROPABILITY,RESERVE_REASK_PROPABILITY_DEF);
	m_bUseReaskReserveSourcesDelay = ini.GetBool(INI_USE_RESERVE_REASK_DELAY,true);
	m_iReaskReserveSourcesDelay = ini.GetInt(INI_RESERVE_REASK_DELAY,RESERVE_REASK_DELAY_DEF);
	m_iReaskReserveSourcesLimit = ini.GetInt(INI_RESERVE_REASK_LIMIT,RESERVE_REASK_LIMIT_DEF);

	m_bAutoTemporaryReask = ini.GetBool(INI_AUTO_TEMPORARY_REASK,true);
	m_iTemporaryReaskPropability = ini.GetInt(INI_TEMPORARY_REASK_PROPABILITY,TEMPORARY_REASK_PROPABILITY_DEF);
	m_bUseReaskTemporarySourcesDelay = ini.GetBool(INI_USE_TEMPORARY_REASK_DELAY,true);
	m_iReaskTemporarySourcesDelay = ini.GetInt(INI_TEMPORARY_REASK_DELAY,TEMPORARY_REASK_DELAY_DEF);
	m_iReaskTemporarySourcesLimit = ini.GetInt(INI_TEMPORARY_REASK_LIMIT,TEMPORARY_REASK_LIMIT_DEF);

	//m_iMinAnalisisQuality = ini.GetInt(INI_MIN_ANALISIS_QUALITY,MIN_ANALISIS_QUALITY_DEF);

	//m_bAutoUnsureReask = ini.GetBool(INI_AUTO_UNSURE_REASK,true);
	//m_bUseReaskUnsureSourcesDelay = ini.GetBool(INI_USE_UNSURE_REASK_DELAY,true);
	//m_iReaskUnsureSourcesDelay = ini.GetInt(INI_UNSURE_REASK_DELAY,UNSURE_REASK_DELAY_DEF);
	//m_iReaskUnsureSourcesLimit = ini.GetInt(INI_UNSURE_REASK_LIMIT,UNSURE_REASK_LIMIT_DEF);

	m_bUseUnpredictedPropability = ini.GetBool(INI_USE_UNPREDICTED_PROPABILITY,true);
	m_iUnpredictedPropability = ini.GetInt(INI_UNPREDICTED_PROPABILITY,UNPREDICTED_PROPABILITY_DEF);
	m_bUseReaskUnpredictedSourcesDelay = ini.GetBool(INI_USE_UNPREDICTED_REASK_DELAY,true);
	m_iReaskUnpredictedSourcesDelay = ini.GetInt(INI_UNPREDICTED_REASK_DELAY,UNPREDICTED_REASK_DELAY_DEF);
	m_iReaskUnpredictedSourcesLimit = ini.GetInt(INI_UNPREDICTED_REASK_LIMIT,UNPREDICTED_REASK_LIMIT_DEF);

	m_uFailTolerance = ini.GetInt(INI_FAIL_TOLERANCE,FALSE);
	m_iMaxFailTolerance = ini.GetInt(INI_MAX_FAIL_TOLERANCE,FAIL_TOLERANCE_DEF);
	m_uRetryUnreachable = ini.GetInt(INI_RETRY_UNREAHABLE,FALSE);
	m_iRetryUnreachableIntervals = ini.GetInt(INI_RETRY_UNREAHABLE_INTERVALS,RETRY_UNREAHABLE_INTERVALS_DEF);
	m_iUnreachableReaskPropability = ini.GetInt(INI_UNREACHABLE_REASK_PROPABILITY,UNREACHABLE_REASK_PROPABILITY_DEF);
	m_iReaskUnreachableSourcesLimit = ini.GetInt(INI_UNREACHABLE_REASK_LIMIT,UNREACHABLE_REASK_LIMIT_DEF);

	m_bHandleTableGaps = ini.GetBool(INI_HANDLE_TABLE_GAPS,true);
	m_fPriorityGapRatio = ini.GetFloat(INI_PRIORITY_GAP_RATIO,PRIORITY_GAP_RATIO_DEF);
	m_iMaxGapSize = ini.GetInt(INI_MAX_GAP_SIZE,MAX_GAP_SIZE_DEF);
	m_iMaxGapTime = ini.GetInt(INI_MAX_GAP_TIME,MAX_GAP_TIME_DEF);
	m_bCheckPriorityIP = ini.GetBool(INI_CHECK_PRIORITY_IP,false);
	m_fPriorityIPRatio = ini.GetFloat(INI_PRIORITY_IP_RATIO,PRIORITY_IP_RATIO_DEF);
	m_bCheckPortIntegrity = ini.GetBool(INI_CHECK_PORT_INTEGRITY,true);
	m_fPortIntegrityRatio = ini.GetFloat(INI_PORT_INTEGRITY_RATIO,PORT_INTEGRITY_RATIO_DEF);
	m_fMaxMidleDiscrepanceHigh = ini.GetFloat(INI_MAX_MIDLE_DISCREPANCE_HIGH,MAX_MIDLE_DISCREPANCE_HIGH_DEF);
	m_fMaxMidleDiscrepanceLow = ini.GetFloat(INI_MAX_MIDLE_DISCREPANCE_LOW,MAX_MIDLE_DISCREPANCE_LOW_DEF);
	m_iLastSeenDurationThreshold = ini.GetInt(INI_LAST_SEEN_DURATION_THRESHOLD,LAST_SEEN_DURATION_THRESHOLD_DEF);
	m_uLinkTimePropability = ini.GetInt(INI_LINK_TIME_PROPABILITY,TRUE);
	m_iLinkTimeThreshold = ini.GetInt(INI_LINK_TIME_THRESHOLD,LINK_TIME_THRESHOLD_DEF);
	m_bUseDualLinkedTableGravity = ini.GetBool(INI_USE_DUAL_LINKED_TABLE_GRAVITY,true);
	m_iDualLinkedTableGravity = ini.GetInt(INI_DUAL_LINKED_TABLE_GRAVITY,DUAL_LINKED_TABLE_GRAVITY_DEF);
	m_bReliableTimeMagnification = ini.GetBool(INI_RELIABLE_TIME_MAGNIFICATION,true);
	m_iMaxReliableTime = ini.GetInt(INI_MAX_RELIABLE_TIME,MAX_RELIABLE_TIME_DEF);
	m_iTempralIPBorderLine = ini.GetInt(INI_TEMPORAL_IP_BORDERLINE,TEMPORAL_IP_BORDERLINE_DEF);
#endif // NEO_SA // NEO: NSA END

	// NEO: DS - [DropSources]
	m_uDropNnP = ini.GetInt(INI_DROP_NNP,FALSE);
	m_iDropNnPLimitMode = ini.GetInt(INI_DROP_NNP_LIMIT_MODE,2);
	m_iDropNnPLimit = ini.GetInt(INI_DROP_NNP_LIMIT,VAL_DROP_LIMIT_DEF(m_iDropNnPLimitMode));
	m_iDropNnPTimer = ini.GetInt(INI_DROP_NNP_TIMER,TIM_DROP_DEF);

	m_uDropFullQ = ini.GetInt(INI_DROP_FULLQ,FALSE);
	m_iDropFullQLimitMode = ini.GetInt(INI_DROP_FULLQ_LIMIT_MODE,2);
	m_iDropFullQLimit = ini.GetInt(INI_DROP_FULLQ_LIMIT,VAL_DROP_LIMIT_DEF(m_iDropFullQLimitMode));
	m_iDropFullQTimer = ini.GetInt(INI_DROP_FULLQ_TIMER,TIM_DROP_DEF);

	m_uDropHighQ = ini.GetInt(INI_DROP_HIGHQ,FALSE);
	m_iDropHighQValue = ini.GetInt(INI_DROP_HIGHQ_VALUE,VAL_DROP_HQ_VALUE_DEF);
	m_iDropHighQLimitMode = ini.GetInt(INI_DROP_HIGHQ_LIMIT_MODE,2);
	m_iDropHighQLimit = ini.GetInt(INI_DROP_HIGHQ_LIMIT,VAL_DROP_LIMIT_DEF(m_iDropHighQLimitMode));
	m_iDropHighQTimer = ini.GetInt(INI_DROP_HIGHQ_TIMER,TIM_DROP_DEF);

	m_bUseDontAskThisIP = ini.GetBool(INI_USE_DONT_ASK_THIS_IP,true);
	m_iDontAskThisIPTime = ini.GetInt(INI_DONT_ASK_THIS_IP_TIME,VAL_DONT_ASK_THIS_IP_TIME_DEF);
	// NEO: DS END

	// NEO: NSD - [NeoSourceDrop]
#ifdef NEO_SK // NEO: NSK - [NeoSourceKeeper]
	m_bDropUnreachable = ini.GetBool(INI_DROP_UNREACHABLE,false);
	m_iDropUnreachableLimitMode = ini.GetInt(INI_DROP_UNREACHABLE_LIMIT_MODE,2);
	m_iDropUnreachableLimit = ini.GetInt(INI_DROP_UNREACHABLE_LIMIT,VAL_CLEAN_LIMIT_DEF(m_iDropUnreachableLimitMode));
	m_iDropUnreachableTimer = ini.GetInt(INI_DROP_UNREACHABLE_TIMER,TIM_DROP_DEF);
#endif // NEO_SK // NEO: NSK END
#ifdef NEO_SS // NEO: NSS - [NeoSourceStorage]
	m_bDropOutOfDate = ini.GetBool(INI_DROP_OUTOFDATE,false);
	m_bDropOutOfDateSmooth = ini.GetBool(INI_DROP_OUTOFDATESMOOTH,false);
	m_iDropOutOfDateFails = ini.GetInt(INI_DROP_OUTOFDATE_FAILS,OUTOFDATE_MAXFAILS_DEF);
	m_iDropOutOfDateTime = ini.GetInt(INI_DROP_OUTOFDATE_TIME,OUTOFDATE_MAXTIME_DEF);
	m_iDropOutOfDateLimitMode = ini.GetInt(INI_DROP_OUTOFDATE_LIMIT_MODE,2);
	m_iDropOutOfDateLimit = ini.GetInt(INI_DROP_OUTOFDATE_LIMIT,VAL_CLEAN_LIMIT_DEF(m_iDropOutOfDateLimitMode));
	m_iDropOutOfDateTimer = ini.GetInt(INI_DROP_OUTOFDATE_TIMER,TIM_DROP_DEF);
#endif // NEO_SS // NEO: NSS END
#ifdef NEO_SA // NEO: NSA - [NeoSourceAnaliser]
	m_bDropRetired = ini.GetBool(INI_DROP_RETIRED,false);
	m_iDropRetiredLimitMode = ini.GetInt(INI_DROP_RETIRED_LIMIT_MODE,2);
	m_iDropRetiredLimit = ini.GetInt(INI_DROP_RETIRED_LIMIT,VAL_CLEAN_LIMIT_DEF(m_iDropRetiredLimitMode));
	m_iDropRetiredTimer = ini.GetInt(INI_DROP_RETIRED_TIMER,TIM_DROP_DEF);

	m_bDropLoaded = ini.GetBool(INI_DROP_LOADED,false);
	m_iDropLoadedLimitMode = ini.GetInt(INI_DROP_LOADED_LIMIT_MODE,2);
	m_iDropLoadedLimit = ini.GetInt(INI_DROP_LOADED_LIMIT,VAL_CLEAN_LIMIT_DEF(m_iDropLoadedLimitMode));
	m_iDropLoadedTimer = ini.GetInt(INI_DROP_LOADED_TIMER,TIM_DROP_DEF);
#endif // NEO_SA // NEO: NSA END
	// NEO: NSD END

	// NEO: NCAP - [NeoCustomAutoPriority]
	m_bDynamicAutoDownPriority = ini.GetBool(INI_DYNAMIC_AUTO_DOWN_PRIORITY,true); 
	m_fDynamicDownPriorityFactor = ini.GetFloat(INI_DYNAMIC_DOWN_PRIORITY_FACTOR,VAL_DYNAMIC_PRIORITY_FACTOR_DEF); 
	m_iLowDownPrioThreshold = ini.GetInt(INI_LOW_DOWN_PRIO_THRESHOLD,VAL_LOW_DOWN_PRIO_THRESHOLD_DEF); 
	m_iHighDownPrioThreshold = ini.GetInt(INI_HIGH_DOWN_PRIO_THRESHOLD,VAL_HIGH_DOWN_PRIO_THRESHOLD_DEF); 
	// NEO: NCAP END

	m_uPartTraffic = ini.GetInt(INI_PART_TRAFFIC,1); // NEO: NPT - [NeoPartTraffic]
	m_iPartTrafficColor = ini.GetInt(INI_PART_TRSFFIC_COLLOR,1); // NEO: NPT - [NeoPartTraffic]
	m_bClassicShareStatusBar = ini.GetBool(INI_CLASSIC_SHARED_BARS,true);

	m_bSaveUploadQueueWaitTime = ini.GetBool(INI_SAVE_QUEUE,false); // NEO: SQ - [SaveUploadQueue]

	// NEO: TQ - [TweakUploadQueue]
	m_bInfiniteQueue = ini.GetBool(INI_INFINITE_QUEUE,false);

	m_uQueueOverFlowRelease = ini.GetInt(INI_QUEUE_OVERFLOW_RELEASE,0);
	m_iQueueOverFlowRelease = ini.GetInt(INI_QUEUE_OVERFLOW_SOURCE_LIMIT,VAL_QUEUE_OVERFLOW_DEF);

	m_uQueueOverFlowEx = ini.GetInt(INI_QUEUE_OVERFLOW_EXTENDED,0);
	m_iQueueOverFlowEx = ini.GetInt(INI_QUEUE_OVERFLOW_EXTENDED_LIMIT,VAL_QUEUE_OVERFLOW_DEF);

	m_uQueueOverFlowDef = ini.GetInt(INI_QUEUE_OVERFLOW_DEFAULT,0);
	m_iQueueOverFlowDef = ini.GetInt(INI_QUEUE_OVERFLOW_DEFAULT_LIMIT,VAL_QUEUE_OVERFLOW_DEF);

	m_uQueueOverFlowCF = ini.GetInt(INI_QUEUE_OVERFLOW_COMFRIEND,0);
	m_iQueueOverFlowCF = ini.GetInt(INI_QUEUE_OVERFLOW_COMFRIEND_LIMIT,VAL_QUEUE_OVERFLOW_DEF);
	// NEO: TQ END

	m_bUseMultiQueue = ini.GetBool(INI_MULTI_QUEUE,false); // NEO: MQ - [MultiQueue]
	m_bUseRandomQueue = ini.GetBool(INI_RANDOM_QUEUE,false); // NEO: RQ - [RandomQueue]

	m_bOldPrioritySystem = ini.GetBool(INI_OLD_PRIOSYS,false);

	// NEO: NMFS - [NiceMultiFriendSlots]
	m_bFriendSlotLimit = ini.GetBool(INI_FRIEND_SLOT_LIMIT,false); 
	m_iFriendSlotLimit = ini.GetInt(INI_FRIEND_SLOT_LIMIT_VALUE,VAL_FRIEND_SLOT_LIMIT_DEF);
	// NEO: NMFS END

	// NEO: RT - [ReleaseTweaks]
	m_iReleaseLevel = ini.GetInt(INI_RELEASE_LEVEL,VAL_RELEASE_LEVEL_DEF); 
	m_iReleaseMode = ini.GetInt(INI_RELEASE_MODE,REL_MIXED);

	m_iReleaseLimitMode = ini.GetInt(INI_RELEASE_LIMIT_MODE,REL_LINEAR);
	m_bReleaseLimitUnion = ini.GetBool(INI_RELEASE_LIMIT_UNION,false);
	m_iReleaseLimitMode = ini.GetInt(INI_RELEASE_LIMIT_COMPLETE_MODE,REL_LINEAR);

	m_iReleaseLimit = ini.GetInt(INI_RELEASE_LIMIT,LIM_BOOTH); 
	m_iReleaseLimitHigh = ini.GetInt(INI_RELEASE_LIMIT_HIGH,VAL_RELEASE_LIMIT_DEF); 
	m_iReleaseLimitLow = ini.GetInt(INI_RELEASE_LIMIT_LOW,VAL_RELEASE_LIMIT_DEF/2); 

	m_iReleaseLimitComplete = ini.GetInt(INI_RELEASE_LIMIT_COMPLETE,LIM_BOOTH); 
	m_iReleaseLimitCompleteHigh = ini.GetInt(INI_RELEASE_LIMIT_COMPLETE_HIGH,VAL_RELEASE_CLIMIT_DEF); 
	m_iReleaseLimitCompleteLow = ini.GetInt(INI_RELEASE_LIMIT_COMPLETE_LOW,VAL_RELEASE_CLIMIT_DEF/2); 

	m_bLimitUnion = ini.GetBool(INI_LIMIT_UNION,false);


	m_iSourceLimitMode = ini.GetInt(INI_SOURCE_LIMIT_MODE,REL_EXPONENTIAL);
	m_bSourceLimitUnion = ini.GetBool(INI_SOURCE_LIMIT_UNION,false);
	m_iSourceLimitCompleteMode = ini.GetInt(INI_SOURCE_LIMIT_COMPLETE_MODE,REL_LINEAR);

	m_iSourceLimit = ini.GetInt(INI_SOURCE_LIMIT,LIM_BOOTH); 
	m_iSourceLimitHigh = ini.GetInt(INI_SOURCE_LIMIT_HIGH,VAL_SOURCE_LIMIT_DEF); 
	m_iSourceLimitLow = ini.GetInt(INI_SOURCE_LIMIT_LOW,VAL_SOURCE_LIMIT_DEF/2); 

	m_iSourceLimitComplete = ini.GetInt(INI_SOURCE_COMPLETE_LIMIT,LIM_BOOTH); 
	m_iSourceLimitCompleteHigh = ini.GetInt(INI_SOURCE_COMPLETE_LIMIT_HIGH,VAL_RELEASE_CLIMIT_DEF); 
	m_iSourceLimitCompleteLow = ini.GetInt(INI_SOURCE_COMPLETE_LIMIT_LOW,VAL_RELEASE_CLIMIT_DEF/2); 

	m_bReleaseNeedComplete = ini.GetBool(INI_RELEASE_NEED_COMPLETE,true); 
	m_iReleaseNeedCompleteLimit = ini.GetInt(INI_RELEASE_NEED_COMPLETE_LIMIT,VAL_RELEASE_CL_DEF); 

	m_uReleaseSlotLimit = ini.GetInt(INI_RELEASE_SLOT_LIMIT,TRUE); 
	m_iReleaseSlotLimit = ini.GetInt(INI_RELEASE_SLOT_LIMIT_VALUE,VAL_RELEASE_SLOT_LIMIT_DEF);
	// NEO: RT END

	// NEO: NCAP - [NeoCustomAutoPriority]
	m_bDynamicAutoUpPriority = ini.GetBool(INI_DYNAMIC_AUTO_UP_PRIORITY,true); 
	m_fDynamicUpPriorityFactor = ini.GetFloat(INI_DYNAMIC_UP_PRIORITY_FACTOR,VAL_DYNAMIC_PRIORITY_FACTOR_DEF); 
	m_iLowUpPrioThreshold = ini.GetInt(INI_LOW_UP_PRIO_THRESHOLD,VAL_LOW_UP_PRIO_THRESHOLD_DEF); 
	m_iHighUpPrioThreshold = ini.GetInt(INI_HIGH_UP_PRIO_THRESHOLD,VAL_HIGH_UP_PRIO_THRESHOLD_DEF); 
	// NEO: NCAP END

	// NEO: PRSF - [PushSmallRareFiles]
	m_bPushSmallFiles = ini.GetBool(INI_PUSH_SMALL_FILES,true);
	m_iPushSmallFilesSize = ini.GetInt(INI_PUSH_SMALL_FILES_SIZE,VAL_PUSH_SMALL_FILES_SIZE_DEF);

	m_bPushRareFiles = ini.GetBool(INI_PUSH_RARE_FILES,true);
	m_iPushRareFilesValue = ini.GetInt(INI_PUSH_RARE_FILES_VALUE,VAL_PUSH_RARE_FILES_VALUE_DEF);

	m_bPushRatioFiles = ini.GetBool(INI_PUSH_RATIO_FILES,true);
	m_iPushRatioFilesValue = ini.GetInt(INI_PUSH_RATIO_FILES_VALUE,VAL_PUSH_RATIO_FILES_VALUE_DEF);
	// NEO: PRSF END

	m_bNeoScoreSystem = ini.GetBool(INI_USE_NEO_SCORE,true); // NEO: NFS - [NeoScoreSystem]
	m_bNeoCreditSystem = ini.GetBool(INI_USE_NEO_CREDIT,true); // NEO: NCS - [NeoCreditSystem]
	m_iOtherCreditSystem = ini.GetInt(INI_CREDIT_SYSTEM,0); // NEO: OCS - [OtherCreditSystems]

	// NEO: IPS - [InteligentPartSharing]
	m_bInteligentPartSharing = ini.GetBool(INI_IPS_ENABLE,false);
	m_iInteligentPartSharingTimer = ini.GetInt(INI_IPS_TIMER,TIM_IPS_TIMER_DEF);
	m_iMaxProzentToHide = ini.GetInt(INI_IPS_MAXIMUM,VAL_IPS_MAX_DEF);

	m_iHideOverAvaliblyParts = ini.GetInt(INI_IPS_HIDE_OA,1);
	m_iHideOverAvaliblyMode = ini.GetInt(INI_IPS_OA_MODE,0);
	m_fHideOverAvaliblyValue = ini.GetFloat(INI_IPS_OA_VALUE,m_iHideOverAvaliblyMode ? VAL_IPS_OA_DEF2 : VAL_IPS_OA_DEF1);
	m_iHideOverAvaliblyCatch = ini.GetInt(INI_IPS_OA_CATCH,2);

	m_iHideOverSharedParts = ini.GetInt(INI_IPS_HIDE_OS,1);
	m_iHideOverSharedMode = ini.GetInt(INI_IPS_OS_MODE,0);
	m_fHideOverSharedValue = ini.GetFloat(INI_IPS_OS_VALUE,m_iHideOverSharedMode ? VAL_IPS_OS_DEF2 : VAL_IPS_OS_DEF1);
	m_iHideOverSharedCalc = ini.GetInt(INI_IPS_OS_CALC,1);
		
	m_iDontHideUnderAvaliblyParts = ini.GetInt(INI_IPS_SHOW_UA,1);
	m_iDontHideUnderAvaliblyMode = ini.GetInt(INI_IPS_UA_MODE,0);
	m_fDontHideUnderAvaliblyValue = ini.GetFloat(INI_IPS_UA_VALUE,m_iDontHideUnderAvaliblyMode ? VAL_IPS_UA_DEF2 : VAL_IPS_UA_DEF1);

	m_iBlockHighOverAvaliblyParts = ini.GetInt(INI_IPS_BLOCK_OA,0);
	m_fBlockHighOverAvaliblyFactor = ini.GetFloat(INI_IPS_OA_FACTOR,VAL_IPS_OAF_DEF);

	m_iBlockHighOverSharedParts = ini.GetInt(INI_IPS_BLOCK_OS,0);
	m_fBlockHighOverSharedFactor = ini.GetFloat(INI_IPS_OS_FACTOR,VAL_IPS_OSF_DEF);

	m_iShowAlwaysNeeded = ini.GetInt(INI_IPS_SHOW_ALWAYS_NEEDED,1);
	m_iShowAlwaysParts = ini.GetInt(INI_IPS_SHOW_ALWAYS_PARTS,VAL_SHOW_ALWAYS_PARTS_DEF);

	m_iShowAlwaysIncomplete = ini.GetInt(INI_IPS_SHOW_ALWAYS_INCOMPLETE,1);
	// NEO: IPS END

	m_sCommunity = ini.GetString(INI_COMMUNITY); // NEO: NC - [NiceCommunity]

#ifdef ARGOS // NEO: NA - [NeoArgos]
	m_bUseArgosSystem = ini.GetBool(INI_USE_ARGOS_SYSTEM,false);

	m_iCreditCompensation = ini.GetInt(INI_CREDIT_COMPENSATION,9);

	m_bTrustUnArgosHashThief = ini.GetBool(INI_TRUST_UNARGOS_HASH_THIEF,true);
	m_bTrustUnArgosHashChanged = ini.GetBool(INI_TRUST_UNARGOS_HASH_CHANGED,true);
	m_bTrustUnArgosGhostMode = ini.GetBool(INI_TRUST_UNARGOS_GHOST_MODE,true);
	m_bTrustUnArgosAgressiv = ini.GetBool(INI_TRUST_UNARGOS_AGRESSIV,false);
	m_iArgosTrustTime = ini.GetInt(INI_ARGOS_TRUST_TIME,TIM_ARGOS_TRUST_TIME_DEF);

	m_uCloseMaellaBackdoor = ini.GetInt(INI_CLOSE_MAELLA_BACKDOOR,TRUE);

	m_uDontBanFriends = ini.GetInt(INI_DONT_BAN_FRIENDS,TRUE);
	m_uDontBanCommunity = ini.GetInt(INI_DONT_BAN_COMMUNITY,FALSE);

	m_iArgosProcessTime = ini.GetInt(INI_ARGOS_PROCESS_TIME,TIM_ARGOS_BAN_TIME_DEF);
	m_iArgosTrackTime = ini.GetInt(INI_ARGOS_TRACK_TIME,TIM_ARGOS_TRACK_TIME_DEF);
	m_iArgosGenericBanTime = ini.GetInt(INI_ARGOS_GENERIC_BAN_TIME,TIM_ARGOS_GENERIC_BAN_TIME_DEF);
	m_iArgosCorruptedSenderTime = ini.GetInt(INI_ARGOS_CORRUPTED_SENDER_TIME,TIM_ARGOS_BAN_TIME_CORRUPT_DEF);
	m_iArgosFileScannerTime = ini.GetInt(INI_ARGOS_FILE_SCANNER_TIME,TIM_ARGOS_BAN_TIME_SCANNER_DEF);
	m_iArgosFileFakerTime = ini.GetInt(INI_ARGOS_FILE_FAKER_TIME,TIM_ARGOS_BAN_TIME_SCANNER_DEF);
	m_iArgosAgressionBanTime = ini.GetInt(INI_ARGOS_AGRESSION_TIME,TIM_ARGOS_BAN_TIME_DEF);
	m_iArgosOpCodeTime = ini.GetInt(INI_ARGOS_OPCODE_TIME,TIM_ARGOS_BAN_TIME_DEF);
	m_iArgosHashChangedTime = ini.GetInt(INI_ARGOS_HASH_CHANGED_TIME,TIM_ARGOS_BAN_TIME_DEF);
	m_iArgosRankFlooderTime = ini.GetInt(INI_ARGOS_RANK_FLOODER_TIME,TIM_ARGOS_BAN_TIME_DEF);
	m_iArgosGhostModeTime = ini.GetInt(INI_ARGOS_GHOST_MODE_TIME,TIM_ARGOS_BAN_TIME_DEF);	
	m_iArgosFailedTime = ini.GetInt(INI_ARGOS_FAILED_TIME,TIM_ARGOS_BAN_TIME_FAILED_DEF);	
	m_iArgosXSExploitTime = ini.GetInt(INI_ARGOS_XS_EXPLOIT_TIME,TIM_ARGOS_BAN_TIME_DEF);
	m_iArgosNickChangerTime = ini.GetInt(INI_ARGOS_NICK_CHANGER_TIME,TIM_ARGOS_BAN_TIME_DEF);
	m_iArgosModChangerTime = ini.GetInt(INI_ARGOS_MOD_CHANGER_TIME,TIM_ARGOS_BAN_TIME_DEF);
	m_iArgosSpamTime = ini.GetInt(INI_ARGOS_SPAMTIME_TIME,TIM_ARGOS_BAN_TIME_DEF);
	m_iArgosBadHelloTime = ini.GetInt(INI_ARGOS_BAD_HELLO_TIME,TIM_ARGOS_BAN_TIME_DEF);
	m_iArgosBadProtTime = ini.GetInt(INI_ARGOS_BAD_PROT_TIME,TIM_ARGOS_BAN_TIME_DEF);

	m_iArgosGPLBreakerPunishment = ini.GetInt(INI_ARGOS_GPL_BREAKER_PUNISHMENT,10);
	m_iArgosHardLeecherPunishment = ini.GetInt(INI_ARGOS_HARD_LEECHER_PUNISHMENT,8);
	m_iArgosNormalLeecherPunishment = ini.GetInt(INI_ARGOS_NORMAL_LEECHER_PUNISHMENT,5);
	m_iArgosSoftLeecherPunishment = ini.GetInt(INI_ARGOS_SOFT_LEECHER_PUNISHMENT,2);
	m_iArgosBadModPunishment = ini.GetInt(INI_ARGOS_BAD_MOD_PUNISHMENT,1);
	m_iArgosNickThiefPunishment = ini.GetInt(INI_ARGOS_NICK_THIEF_PUNISHMENT,5);
	m_iArgosModThiefPunishment = ini.GetInt(INI_ARGOS_MOD_THIEF_PUNISHMENT,9);
	m_iArgosHashThiefPunishment = ini.GetInt(INI_ARGOS_HASH_THIEF_PUNISHMENT,5);
	m_iArgosCreditHackPunishment = ini.GetInt(INI_ARGOS_CREDIT_HACK_PUNISHMENT,7);
	m_iArgosHashChangedPunishment = ini.GetInt(INI_ARGOS_HASH_CHANGED_PUNISHMENT,3);
	m_iArgosGhostModePunishment = ini.GetInt(INI_ARGOS_GHOST_MODE_PUNISHMENT,0);
	m_iArgosFakeClientPunishment = ini.GetInt(INI_ARGOS_FAKE_CLIENT_PUNISHMENT,7);
	m_iArgosAgressonPunishment = ini.GetInt(INI_ARGOS_AGRESSON_PUNISHMENT,100);
	m_iArgosFileScannerPunishment = ini.GetInt(INI_ARGOS_FILE_SCANNER_PUNISHMENT,100);
	m_iArgosFileFakerPunishment = ini.GetInt(INI_ARGOS_FILE_FAKER_PUNISHMENT,100);
	m_iArgosCorruptedSenderPunishment = ini.GetInt(INI_ARGOS_CORRUPTED_SENDER_PUNISHMENT,100);
	m_iArgosRankFlooderPunishment = ini.GetInt(INI_ARGOS_RANK_FLOODER_PUNISHMENT,100);
	m_iArgosFailedPunishment = ini.GetInt(INI_ARGOS_FAILED_PUNISHMENT,100);
	m_iArgosXSExploitPunishment = ini.GetInt(INI_ARGOS_XS_EXPLOIT_PUNISHMENT,100);
	m_iArgosNickChangerPunishment = ini.GetInt(INI_ARGOS_NICK_CHANGER_PUNISHMENT,0);
	m_iArgosModChangerPunishment = ini.GetInt(INI_ARGOS_MOD_CHANGER_PUNISHMENT,0);
	m_iArgosSpamPunishment = ini.GetInt(INI_ARGOS_SPAM_PUNISHMENT,100);
	m_iArgosBadHelloPunishment = ini.GetInt(INI_ARGOS_BAD_HELLO_PUNISHMENT,7);
	m_iArgosBadProtPunishment = ini.GetInt(INI_ARGOS_BAD_PROT_PUNISHMENT,7);

	m_bArgosLeecherModDetection = ini.GetBool(INI_ARGOS_LEECHER_MOD_DETECTION,true);
	m_uArgosLeecherNickDetection = ini.GetInt(INI_ARGOS_LEECHER_NICK_DETECTION,2);
	m_iArgosDetectionLevel = ini.GetInt(INI_ARGOS_DETECTION_LEVEL,2);
	m_bArgosOpcodeDetection = ini.GetBool(INI_ARGOS_OPCODE_DETECTION,true);
	m_bArgosLeecherHashDetection = ini.GetBool(INI_ARGOS_LEECHER_HASH_DETECTION,true);
	m_bArgosNickThiefDetection = ini.GetBool(INI_ARGOS_NICK_THIEF_DETECTION,false);
	m_bPlainAntiNickThief = ini.GetBool(INI_PLAIN_ANTI_NICKT_HIEF,false);
	m_bArgosModThiefDetection = ini.GetBool(INI_ARGOS_MOD_THIEF_DETECTION,true);
	m_bArgosHashThiefDetection = ini.GetBool(INI_ARGOS_HASH_THIEF_DETECTION,false);
	m_bArgosThiefZoneDetection = ini.GetBool(INI_ARGOS_THIEF_ZONE_DETECTION,false);
	m_bArgosCreditHackDetection = ini.GetBool(INI_ARGOS_CREDIT_HACK_DETECTION,true);
	m_bHashChangeDetection = ini.GetBool(INI_HASH_CHANGE_DETECTION,false);
	m_iHashChangeDetectionMode = ini.GetInt(INI_HASH_CHANGE_DETECTION_MODE,1);
	m_bArgosGhostModDetection = ini.GetBool(INI_ARGOS_GHOST_MOD_DETECTION,true);
	m_uArgosFakeClientDetection = ini.GetInt(INI_ARGOS_FAKE_CLIENT_DETECTION,TRUE);
	m_uAgressionDetection = ini.GetInt(INI_AGRESSION_DETECTION,TRUE);
	m_iAgressionIntervals = ini.GetInt(INI_AGRESSION_TIME,TIM_ARGOS_AGRESSION_INTERVALS_DEF);
	m_iAgressionThreshold = ini.GetInt(INI_AGRESSION_THRESHOLD,VAL_ARGOS_AGRESSION_THRESHOLD_DEF);
	m_bFileScannerDetection = ini.GetBool(INI_FILE_SCANNER_DETECTION,true);
	m_bFileFakerDetection = ini.GetBool(INI_FILE_FAKER_DETECTION,true);
	m_bBadSenderDetection = ini.GetBool(INI_BAD_SENDER_DETECTION,true);
	m_bRankFloodDetection = ini.GetBool(INI_RANK_FLOOD_DETECTION,true);
	m_bFailedDetection = ini.GetBool(INI_FAILED_DETECTION,true);
	m_iFailedTries = ini.GetInt(INI_FAILED_TRIES,VAL_ARGOS_FAILED_TRIES_DEF);
	m_iFailedThreshold = ini.GetInt(INI_FAILED_THRESHOLD,VAL_ARGOS_FAILED_THRESHOLD_DEF);
	m_bXSExploitDetection = ini.GetBool(INI_XS_EXPLOIT_DETECTION,true);
	m_iXSExploitIntervals = ini.GetInt(INI_XS_EXPLOIT_INTERVALS,TIM_ARGOS_XS_EXPLOIT_INTERVALS_DEF);
	m_iXSExploitThreshold = ini.GetInt(INI_XS_EXPLOIT_THRESHOLD,VAL_ARGOS_XS_EXPLOIT_THRESHOLD_DEF);
	m_bNickChangerDetection = ini.GetBool(INI_NICK_CHANGER_DETECTION,true);
	m_iNickChangeIntervals = ini.GetInt(INI_NICK_CHANGE_INTERVALS,TIM_ARGOS_NICK_CHANGE_INTERVALS_DEF);
	m_iNickChangeThreshold = ini.GetInt(INI_NICK_CHANGE_THRESHOLD,VAL_ARGOS_NICK_CHANGE_THRESHOLD_DEF);
	m_bModChangerDetection = ini.GetBool(INI_MOD_CHANGER_DETECTION,true);
	m_iModChangeIntervals = ini.GetInt(INI_MOD_CHANGE_INTERVALS,TIM_ARGOS_MOD_CHANGE_INTERVALS_DEF);
	m_iModChangeThreshold = ini.GetInt(INI_MOD_CHANGE_THRESHOLD,VAL_ARGOS_MOD_CHANGE_THRESHOLD_DEF);
	m_bSpamDetection = ini.GetBool(INI_SPAM_DETECTION,true);
	m_bBadHelloDetection = ini.GetBool(INI_BAD_HELLO_DETECTION,true);
	//m_bMD4HelloDetection = ini.GetBool(INI_MD4_HELLO_DETECTION,false);
	m_ueMCryptDetection = ini.GetInt(INI_EMCRYPT_DETECTION,TRUE);
	m_bBadProtDetection = ini.GetBool(INI_BAD_PROT_DETECTION,true);
	m_uDLPDetection = ini.GetInt(INI_DLP_DETECTION,TRUE);

	m_bArgosLogLeechers = ini.GetBool(INI_ARGOS_LOG_LEECHERS,false);
#endif // ARGOS // NEO: NA END

	m_bUseChunkDots = ini.GetBool(INI_USE_CHUNK_DOTS, false); // NEO: MOD - [ChunkDots]
	m_bUseRelativeChunkDisplay = ini.GetBool(INI_USE_RELATIVE_CHUNK_DISPLAY, false); // NEO: MOD - [RelativeChunkDisplay]
	m_bUseTreeStyle = ini.GetBool(INI_USE_TREES_TYLE, true); // NEO: NTS - [NeoTreeStyle]
	m_bShowFileTypeIcon = ini.GetBool(INI_SHOW_FILE_TYPE_ICON, true); // NEO: NI - [NewIcons]
	m_bShowFileStatusIcons = ini.GetBool(INI_SHOW_FILE_STATUS_ICON, true); // NEO: FSI - [FileStatusIcons]
	m_bCollorShareFiles = ini.GetBool(INI_COLLOR_SHARE_FILES, true);
	m_bShowBanner = ini.GetBool(INI_SHOW_BANNER, true);
	m_bShowHashProgres = ini.GetBool(INI_SHOW_HASH_PROGRES, true);
	m_uUsePlusSpeedMeter = ini.GetInt(INI_USE_PLUS_SPEEDMETER, TRUE); // NEO: PSM - [PlusSpeedMeter]
	// NEO: NSTI - [NewSystemTrayIcon]
	m_bShowSystemTrayUpload = ini.GetBool(INI_SHOW_SYSTEM_TRAY_UPLOAD, true);
	m_bThinSystemTrayBars = ini.GetBool(INI_THIN_SYSTEM_TRAY_BARS, false);
	m_iTrayBarsMaxCollor = ini.GetInt(INI_TRAY_BARS_MAX_COLLOR, 1);
	// NEO: NSTI END
	m_bStaticTrayIcon = ini.GetBool(INI_STATIC_TRAY_ICON, false); // NEO: STI - [StaticTray]
	m_uDisableAutoSort = ini.GetInt(INI_DISABLE_AUTO_SORT, 0); // NEO: SE - [SortExtension]
	m_uShowClientPercentage = ini.GetInt(INI_SHOW_CLIENT_PERCENTAGE, FALSE); // NEO: MOD - [Percentage]

	// NEO: SI - [SysInfo]
	m_bDrawSysInfoGraph = ini.GetBool(INI_SYS_INFO_GRAPH, true);
	m_bShowSysInfoOnTitle = ini.GetBool(INI_SYS_INFO_TITLE, false);
	// NEO: SI END

	// NEO: NTB - [NeoToolbarButtons]
	m_uNeoToolbar = ini.GetInt(INI_NEO_TOOLBAR, FALSE);
	m_iNeoToolbarButtonCount = ini.GetInt(INI_NEO_TOOLBAR_BUTTONS, 8);
	m_NeoToolbarButtons.RemoveAll();
	m_NeoToolbarButtons.SetSize(m_iNeoToolbarButtonCount);
	for (int i=0; i<m_iNeoToolbarButtonCount; i++)
		m_NeoToolbarButtons[i] = (ini.GetInt(StrLine(L"%s_%u",INI_NEO_TOOLBAR_BUTTON,i), 0));
	// NEO: NTB END
	
	// NEO: CTB - [CoolToolBar]
	m_bCoolToolbar = ini.GetBool(INI_USE_COOL_TOOLBAR, false);
	m_uCoolToolbarText = ini.GetInt(INI_USE_COOL_TOOLBAR_TEXT, FALSE);
	m_iCoolToolbarCenter = ini.GetInt(INI_COOL_TOOLBAR_CENTER, 0);
	m_iCoolToolbarRight = ini.GetInt(INI_COOL_TOOLBAR_RIGHT, 0);
	m_iCoolToolbarButtonCount = ini.GetInt(INI_COOL_TOOLBAR_BUTTONS, 0);
	m_CoolToolbarButtons.RemoveAll();
	if(m_iCoolToolbarButtonCount > 0)
	{
		m_CoolToolbarButtons.SetSize(m_iCoolToolbarButtonCount);
		for (int i=0; i<m_iCoolToolbarButtonCount; i++)
			m_CoolToolbarButtons[i] = (ini.GetInt(StrLine(L"%s_%u",INI_COOL_TOOLBAR_BUTTON,i), 0));
	}
	// NEO: CTB END

	// NEO: NMX - [NeoMenuXP]
	m_bShowXPSideBar = ini.GetBool(INI_SHOW_XP_SIDEBAR, true);
	m_bShowXPBitmap = ini.GetBool(INI_SHOW_XP_BITMAP, true);
	m_iXPMenuStyle = ini.GetInt(INI_XP_MENU_STYLE, 1);
	m_bGrayMenuIcon = ini.GetBool(INI_GRAY_MENU_ICON, false);
	// NEO: NMX END 

	// NEO: MM - [NeoMiniMule]
	m_bEnableMiniMule = ini.GetBool(INI_ENABLE_MINIMULE, true);
	m_bAutoShowMiniMule = ini.GetBool(INI_AUTO_MINIMULE, false);
	m_bMiniMuleOnTop = ini.GetBool(INI_MINIMULE_ONTOP, false);
	m_bUpdateHidenMiniMule = ini.GetBool(INI_MINIMULE_UPDATE, true);
	m_uMiniMuleTransparency = ini.GetInt(INI_MINIMULE_TRANSPARENCY, 0);
	m_bMiniMuleBack = ini.GetBool(INI_MINIMULE_BACKGROUND, true);
	m_sMiniMuleLabel = ini.GetString(INI_MINIMULE_LABEL, DEF_MINIMULE_LABEL);
	// NEO: MM END

	// NEO: IM - [InvisibelMode]
	SetInvisibleMode( ini.GetBool(INI_INVISIBLEMODE_ENABLE, false),
					  ini.GetInt(INI_INVISIBLEMODE_KEY_MOD, MOD_CONTROL | MOD_SHIFT | MOD_ALT),
					  ini.GetString(INI_INVISIBLEMODE_KEY, L"E").GetAt(0));
	// NEO: IM END

	// NEO: TPP - [TrayPasswordProtection]
	m_bTrayPasswordProtection = ini.GetBool(INI_TRAY_PASSWORD_PROTECTION,FALSE);
	m_sTrayPassword = ini.GetString(INI_TRAY_PASSWORD, L"");
	// NEO: TPP END

	m_bShowMyFullInfo = ini.GetBool(INI_SHOW_MY_FULL_INFO, false);

	m_bSmoothStatisticsGraphs = ini.GetBool(INI_SMOOTH_STATISTICS_GRAPHS, true);

	// NEO: MMR - [MorphMassRemane]
	SetSimpleCleanupOptions (ini.GetInt (INI_SIMPLE_CLEANUP_OPTIONS,3));
	SetSimpleCleanupSearch (ini.GetString (INI_SIMPLE_CLEANUP_SEARCH));
	SetSimpleCleanupReplace (ini.GetString (INI_SIMPLE_CLEANUP_REPLACE));
	// Format of the preferences string for character replacement:
	//      "str";"str";"str";...;"str"
	// Every "str" in SimpleCleanupSearchChars corresponds to a "str"
	// in SimpleCleanupReplaceChars at the same position.
	SetSimpleCleanupSearchChars (ini.GetString (INI_SIMPLE_CLEANUP_SEARCH_CHARS,
								 _T("\"\xE4\";\"\xF6\";\"\xFC\";\"\xC4\";\"\xD6\";\"\xDC\";\"\xDF\"")));/*ISO 8859-4*/
	SetSimpleCleanupReplaceChars (ini.GetString (INI_SIMPLE_CLEANUP_REPLACE_CHARS,
								 _T("\"ae\";\"oe\";\"ue\";\"Ae\";\"Oe\";\"Ue\";\"ss\"")));
	// NEO: MMR END

	// NEO: CRC - [MorphCRCTag] -- Xanatos -->
	m_bDontAddCRCToFilename = ini.GetBool (INI_DONT_ADD_CRC32_TO_FILENAME,false);
	m_bCRC32ForceUppercase = ini.GetBool (INI_FORCE_CRC32_UPPERCASE,false);
	m_bCRC32ForceAdding = ini.GetBool (INI_FORCE_CRC32_ADDING,false);
	m_sCRC32Prefix = ini.GetString (INI_LAST_CRC32_PREFIX,CString(_T("\" [\"")).Trim (_T("\"")));
	m_sCRC32Suffix = ini.GetString (INI_LAST_CRC32_SUFFIX,CString(_T("\"]\"")).Trim (_T("\"")));
	// NEO: CRC END <-- Xanatos --

	m_iMaxUploadSlots = ini.GetInt(INI_MAX_UL_SLOTS,VAL_MAX_UL_SLOTS_DEF);
	m_iMinUploadSlots = ini.GetInt(INI_MIN_UL_SLOTS,VAL_MIN_UL_SLOTS_DEF);
	m_fUploadPerSlots = ini.GetFloat(INI_UL_PER_SLOTS,VAL_UL_PER_SLOTS_DEF);

	// NEO: QS - [QuickStart]
	m_uQuickStart = ini.GetInt(INI_USE_QUICK_START, FALSE);
	m_iQuickStartTime = ini.GetUInt32(INI_QUICK_START_TIME, TIM_QUICK_START_DEF);
	m_iQuickStartTimePerFile = ini.GetUInt32(INI_QUICK_START_TIME_PF, VAL_QUICK_START_PF_DEF);

	m_iQuickMaxConperFive = ini.GetInt(INI_QUICK_START_MAX_CON_PER, (int)(MaxConperFive*1.5));
	m_iQuickMaxHalfOpen = ini.GetInt(INI_QUICK_START_MAX_HALF_CON, (int)(maxhalfconnections));
	m_iQuickMaxConnections = ini.GetInt(INI_QUICK_START_MAX_CON, (int)(maxconnections*1.5));
	// NEO: QS END

	// NEO: RIC - [ReaskOnIDChange]
	m_uCheckIPChange = ini.GetInt(INI_CHECK_ID_CHANGE, 2);
	m_bInformOnIPChange = ini.GetBool(INI_INFORM_ON_ID_CHANGE, false);
	m_bReAskOnIPChange = ini.GetBool(INI_REASK_ON_ID_CHANGE, false);
	m_bQuickStartOnIPChange = ini.GetBool(INI_QUICK_START_ON_ID_CHANGE, false); // NEO: QS - [QuickStart]
	m_bCheckL2HIDChange = ini.GetBool(INI_CHECK_L2H_ID_CHANGE, false);
	m_bReconnectKadOnIPChange = ini.GetBool(INI_RECONNECTKAD_ON_ID_CHANGE, true);
	m_bRebindSocketsOnIPChange = ini.GetBool(INI_REBIND_SOCKETS_ON_IP_CHANGE, false);
	// NEO: RIC END

	// NEO: RKF - [RecheckKadFirewalled]
	m_bRecheckKadFirewalled = ini.GetBool(INI_RECHECK_KAD_FIREWALLED, true);
	m_iRecheckKadFirewalled = ini.GetInt(INI_RECHECK_KAD_FIREWALLED_TIME, TIM_RECHECK_KAD_FIREWALLED_DEF);
	// NEO: RKF END

	// NEO: RLD - [ReconnectOnLowID]
	m_bReConnectOnLowID = ini.GetBool(INI_RECONNECT_ON_LOWID, false);
	m_iReConnectOnLowID = ini.GetInt(INI_RECONNECT_ON_LOWID_TRYS, VAL_RECONNECT_ON_LOWID_TRYS_DEF); 
	// NEO: RLD END

#ifdef LANCAST // NEO: NLC - [NeoLanCast]
	m_bLancastEnabled = ini.GetBool(INI_LANCAST_ENABLED, false);

	m_iMaxLanDownload = (uint16)ini.GetInt(INI_MAX_LAN_DOWNLOAD, 0); 
	m_bDirectLanDownload = ini.GetBool(INI_DIRECT_LAN_DOWNLOAD, true);
	m_bSetLanDownloadBuffer = ini.GetBool(INI_SET_LAN_DOWNLOAD_BUFFER, true);
	m_iLanDownloadBufferSize = ini.GetInt(INI_LAN_DOWNLOAD_BUFFER_SIZE, VAL_LAN_DOWNLOAD_BUFFER_DEF); 

	m_iMaxLanUpload = (uint16)ini.GetInt(INI_MAX_LAN_UPLOAD, 0); 
	m_bDirectLanUpload = ini.GetBool(INI_DIRECT_LAN_UPLOAD, false);
	m_bSetLanUploadBuffer = ini.GetBool(INI_SET_LAN_UPLOAD_BUFFER, true);
	m_iLanUploadBufferSize = ini.GetInt(INI_LAN_UPLOAD_BUFFER_SIZE, VAL_LAN_UPLOAD_BUFFER_DEF); 

	m_iMaxLanUploadSlots = ini.GetInt(INI_MAX_LAN_UPLOAD_SLOTS, VAL_MAX_LAN_UPLOAD_SLOTS_DEF); 

	m_bCustomizedLanCast = ini.GetBool(INI_CUSTOMIZED_LANCAST, false);
	m_sLanCastGroup = ini.GetString(INI_LANCAST_GROUP, LANCAST_GROUP);
	m_uLanCastPort = (uint16)ini.GetInt(INI_LANCAST_PORT, LANCAST_PORT);

	m_bCustomLanCastAdapter = ini.GetBool(INI_CUSTOM_LANCAST_ADAPTER, false);
	m_uLanCastAdapterIPAdress = ini.GetInt(INI_LANCAST_ADAPTER_IPADRESS, 0);
	m_uLanCastAdapterSubNet = ini.GetInt(INI_LANCAST_ADAPTER_SUBNET, 0x0000FFFF);

	m_iLANIntervals = ini.GetInt(INI_LANINTERVALS, TIM_LAN_INTERVAL_DEF); 

	m_iLanReaskIntervals = ini.GetInt(INI_LAN_REASK_INTERVALS, TIM_REASK_LAN_DEF); 
	m_iNnPLanReaskIntervals = ini.GetInt(INI_NNP_LAN_REASK_INTERVALS, TIM_REASK_NNP_LAN_DEF); 

	m_bAutoBroadcastLanFiles = ini.GetBool(INI_AUTO_BROADCAST_LAN_FILES, false);
	m_iAutoBroadcastLanFiles = ini.GetInt(INI_AUTO_BROADCAST_LAN_FILES_TIMER, TIM_AUTO_BROADCAST_LAN_FILES_DEF); 

	m_bUseLanMultiTransfer = ini.GetBool(INI_USE_LAN_MULTI_TRANSFER, true);
#endif //LANCAST // NEO: NLC END

#ifdef VOODOO // NEO: VOODOO - [UniversalPartfileInterface]
	m_bUseVoodooTransfer = ini.GetBool(INI_USE_VOODOO_TRANSFER, false);
	m_bSlaveAllowed = ini.GetBool(INI_SLAVE_ALLOWED, false);
	m_bSlaveHosting = ini.GetBool(INI_SLAVE_HOSTING, false);

	m_sVoodooSpell = ini.GetString(INI_VOODOO_SPELL,L"Voodoo");
	m_nVoodooPort = (uint16)ini.GetInt(INI_VOODOO_PORT, 666); 

	m_uAutoConnectVoodoo = ini.GetInt(INI_AUTO_CONNECT_VOODOO, TRUE);

	m_uUseVirtualVoodooFiles = ini.GetInt(INI_USE_VIRTUAL_VOODOO_FILES, TRUE);
	m_bHideVoodooFiles = ini.GetBool(INI_HIDE_VOODOO_FILES, false);

	m_uUseVoodooSourceExchange = ini.GetInt(INI_USE_VOODOO_SOURCE_EXCHANGE, TRUE);

	m_bUseVoodooSearch = ini.GetBool(INI_USE_VOODOO_SEARCH, true);

	m_bVoodooNeoCommands = ini.GetBool(INI_VOODOO_NEO_COMMANDS, true);
	m_bVoodooNeoPreferences = ini.GetBool(INI_VOODOO_NEO_PREFERENCES, true);

	m_uVoodooCastEnabled = ini.GetInt(INI_VOODOOCAST_ENABLED, 2);

	m_uSearchForSlaves = ini.GetInt(INI_SEARCH_FOR_SLAVES, FALSE); 
	m_uSearchForMaster = ini.GetInt(INI_SEARCH_FOR_MASTER, FALSE); 
	m_iVoodooSearchIntervals = ini.GetInt(INI_VOODOO_SEARCH_INTERVALS, TIM_VOODOO_SEARCH_DEF); 
#endif // VOODOO // NEO: VOODOO END


#ifdef A4AF_CATS // NEO: MAC - [MorphA4AFCategories]
	m_bShowCatNames = ini.GetBool(INI_SHOW_CAT_NAME,true);
	m_uShowCategoryFlags = ini.GetInt(INI_SHOW_CAT_FLAGS,TRUE);
	m_bActiveCatDefault = ini.GetBool(INI_ACTIVE_CAT_DEFAULT, true);
	m_bSelCatOnAdd = ini.GetBool(INI_SEL_CAT_ON_ADD, false);
	m_bAutoSetResumeOrder = ini.GetBool(INI_AUTO_SET_RESUME_ORDER, true);
	m_bSmallFileDLPush = ini.GetBool(INI_SMALL_FILE_DL_PUSH, true);
	m_iSmallFileDLPush = ini.GetInt(INI_SMALL_FILE_DL_PUSH_VAL, 150);
	m_bStartDLInEmptyCats = ini.GetBool(INI_START_DL_IN_EMPTY_CATS, false);
	m_iStartDLInEmptyCats = ini.GetInt(INI_START_DL_IN_EMPTY_CATS_AMOUNT, 5);
	m_bUseAutoCat = ini.GetBool(INI_USE_AUTO_CAT, true);
	m_bCheckAlreadyDownloaded = ini.GetBool(INI_CHECK_ALREADY_DOWNLOADED, false);
	
	m_bStartNextFileByPriority = ini.GetBool(INI_START_NEXT_FILE_BY_PRIORITY, false);

	m_bSmartA4AFSwapping = ini.GetBool(INI_SMART_A4AF_SWAPPING, true);
	m_iAdvancedA4AFMode = ini.GetInt(INI_ADVANCED_A4AF_MODE, 1);
#endif // A4AF_CATS // NEO: MAC END

	m_uUseLugdunumCredits = ini.GetInt(INI_USE_LUGDUNUM_CREDITS, TRUE); // NEO: KLC - [KhaosLugdunumCredits]
	m_bPreferShareAll = ini.GetBool(INI_PREFER_SHARE_ALL, false); // NEO: PSA - [PreferShareAll]
	// NEO: ASF - [AdvancedServerFilter]
	m_bDontRemoveStaticServers = ini.GetBool(INI_DONT_REMOVE_STATIC_SERVERS, true);
	m_bServerFilterAutoDel = ini.GetBool(INI_SERVER_FILTER_AUTO_DEL, false);
	m_iServerFilter = ini.GetInt(INI_SERVER_FILTER, 0);
	m_sServerFilterVal = ini.GetString(INI_SERVER_FILTER_VAL,L"");
	m_bServerFilterDataless = ini.GetBool(INI_SERVER_FILTER_DATALESS, true);
	// NEO: ASF END

#ifdef IP2COUNTRY // NEO: IP2C - [IP2Country]
	m_iIP2CountryNameMode = ini.GetInt(INI_IP2COUNTRY_NAME_MODE, IP2CountryName_DISABLE);
	m_uIP2CountryShowFlag = ini.GetInt(INI_IP2COUNTRY_SHOW_FLAG, FALSE);
#endif // IP2COUNTRY // NEO: IP2C END

	m_bUseFakeCheck = ini.GetBool(INI_USE_FAKE_CHECK, false); // NEO: FC - [FakeCheck]

	// NEO: FDC - [FileNameDisparityCheck]
	m_bUseFileCheck = ini.GetBool(INI_USE_FILE_CHECK, false);
	m_iFileCheckSensitivity = ini.GetInt(INI_FILE_CHECK_SENSITIVITY, VAL_FILE_CHECK_SENSITIVITY_DEF);
	m_bUseFileCheckThreshold = ini.GetBool(INI_USE_FILE_CHECK_THRESHOLD, true);
	m_iFileCheckThreshold = ini.GetInt(INI_FILE_CHECK_THRESHOLD, VAL_FILE_CHECK_THRESHOLD_DEF);
	m_iFileCheckAmount = ini.GetInt(INI_FILE_CHECK_AMOUNT, VAL_FILE_CHECK_AMOUNT_DEF);
	// NEO: FDC END

	// NEO: FN - [FunnyNick]
	m_bUseFunnyNick = ini.GetBool(INI_USE_FUNNY_NICK, false);
	m_sFunnyNickFilter = ini.GetString(INI_FUNNY_NICK_FILTER,DEF_FUNNYNICK_FILTER);
	m_sFunnyNickSymbol = ini.GetString(INI_FUNNY_NICK_SYMBOL,_T(""));
	if(m_sFunnyNickSymbol.IsEmpty())
		m_sFunnyNickSymbol = DEF_FUNNYNICK_SYMBOL;
	// NEO: FN END

	// NEO: AU - [AutoUpdate]
	m_bAutoRuntimeUpdate = ini.GetBool(INI_AUTO_RUNTIME_UPDATE, false);
	m_iRuntimeUpdateIntervals = ini.GetInt(INI_RUNTIME_UPDATE_INTERVALS, 14);
	m_iRuntimeUpdateIntervals = min(m_iRuntimeUpdateIntervals,3);

	LPBYTE pst;
	UINT usize;

	_stprintf(m_sUpdateURLIPFilter,L"%s",ini.GetString(INI_UPDATE_URL_IP_FILTER,L""));
	m_bAutoUpdateIPFilter = ini.GetBool(INI_AUTO_UPDATE_IP_FILTER,false);
	pst = NULL;
	usize = sizeof m_IPFilterVersion;
	if (ini.GetBinary(INI_IP_FILTER_VERSION, &pst, &usize) && usize == sizeof m_IPFilterVersion)
		memcpy(&m_IPFilterVersion, pst, sizeof m_IPFilterVersion);
	else
		memset(&m_IPFilterVersion, 0, sizeof m_IPFilterVersion);
	delete[] pst;

#ifdef ARGOS // NEO: NA - [NeoArgos]
	_stprintf(m_sUpdateURLLeechersList,L"%s",ini.GetString(INI_UPDATE_URL_LEECHERS_LIST,L""));
	m_bUpdateLeechersStartup = ini.GetBool(INI_UPDATE_LEECHERS_STARTUP,false);
	pst = NULL;
	usize = sizeof m_LeechersVersion;
	if (ini.GetBinary(INI_IP_FILTER_VERSION, &pst, &usize) && usize == sizeof m_LeechersVersion)
		memcpy(&m_LeechersVersion, pst, sizeof m_LeechersVersion);
	else
		memset(&m_LeechersVersion, 0, sizeof m_LeechersVersion);
	delete[] pst;
#endif // ARGOS // NEO: NA END

#ifdef IP2COUNTRY // NEO: IP2C - [IP2Country]
	_stprintf(m_sUpdateURLIP2Country,L"%s",ini.GetString(INI_UPDATE_URL_IP2_COUNTRY,L""));
	m_bAutoUpdateIP2Country = ini.GetBool(INI_AUTO_UPDATE_IP2_COUNTRY,false);
	pst = NULL;
	usize = sizeof m_IP2CountryVersion;
	if (ini.GetBinary(INI_IP2_COUNTRY_VERSION, &pst, &usize) && usize == sizeof m_IP2CountryVersion)
		memcpy(&m_IP2CountryVersion, pst, sizeof m_IP2CountryVersion);
	else
		memset(&m_IP2CountryVersion, 0, sizeof m_IP2CountryVersion);
	delete[] pst;
#endif // IP2COUNTRY // NEO: IP2C END

	// NEO: FC - [FakeCheck]
	_stprintf(m_sUpdateURLFakeList,L"%s",ini.GetString(INI_UPDATE_URL_FAKE_LIST,L""));
	m_bUpdateFakeStartup = ini.GetBool(INI_UPDATE_FAKE_STARTUP,false);
	pst = NULL;
	usize = sizeof m_FakesVersion;
	if (ini.GetBinary(INI_FAKES_VERSION, &pst, &usize) && usize == sizeof m_FakesVersion)
		memcpy(&m_FakesVersion, pst, sizeof m_FakesVersion);
	else
		memset(&m_FakesVersion, 0, sizeof m_FakesVersion);
	delete[] pst;
	// NEO: FC END
	// NEO: AU END

	// NEO: IFWS - [ICSFirewall]
	m_uICFSupport = (GetWindowsVersion() == _WINVER_XP_) ? ini.GetInt(INI_ICF_SUPPORT, 2) : FALSE;
	m_bICFClearOnClose = ini.GetBool(INI_ICF_CLEAR_ON_CLOSE, true);
	// NEO: IFWS END

	// NEO: UPNP - [UPnPNat]
	m_uUPnPNat = ini.GetInt(INI_UPNP_NAT, FALSE);
	m_bUPnPClearOnClose = ini.GetBool(INI_UPNP_CLEAR_ON_CLOSE, true);
	m_bUPnPTryRandom = ini.GetBool(INI_UPNP_TRY_RANDOM, false);
	// NEO: UPNP END

	// NEO: NATS - [NatSupport]
	m_bNATSupportEnabled = ini.GetBool(INI_NAT_SUPPORT_ENABLED, true);
	m_fNATPortRefreshIvterval = ini.GetFloat(INI_NAT_PORT_REFRESH_IVTERVAL, VAL_NAT_PORT_REFRESH_IVTERVAL_DEF);
	m_iNATPortMaxLatencyTime = ini.GetInt(INI_NAT_PORT_MAX_LATENCY_TIME, VAL_NAT_PORT_MAX_LATENCY_TIME_DEF);
	m_iNATPortMaxFails = ini.GetInt(INI_NAT_PORT_MAX_FAILS, VAL_NAT_PORT_MAX_FAILS_DEF);
	m_bNATPortFastRefresh = ini.GetBool(INI_NAT_PORT_FAST_REFRESH, false);

#ifdef NATTUNNELING // NEO: NATT - [NatTraversal]
	m_bNATPortRelaiable = ini.GetBool(INI_NAT_PORT_RELAIABLE, false);
	m_bNATTraversalEnabled = ini.GetBool(INI_NAT_TRAVERSAL_ENABLED, true);
	m_bDontTrustNatPorts = ini.GetBool(INI_DONT_TRUST_NAT_PORTS, false);
	m_iNatCharacteristic = ini.GetInt(INI_NAT_TYPE, 0);
	m_uLowIDUplaodCallBack = ini.GetInt(INI_LOWID_UPLAOD_CALLBACK,2); // NEO: LUC - [LowIDUplaodCallBack]
#endif //NATTUNNELING // NEO: NATT END
	m_uReuseTCPPort = ini.GetInt(INI_RE_USE_TCP_PORT, FALSE); 
	// NEO: NATS END

#ifdef WEBCACHE // NEO: WC - [WebCache]
	webcacheName = ini.GetString(INI_WEBCACHE_NAME, L"");
	webcachePort = (uint16)ini.GetInt(INI_WEBCACHE_PORT,0);
	webcacheBlockLimit = (uint16)ini.GetInt(INI_WEBCACHE_BLOCK_LIMIT,0);	
	webcacheExtraTimeout = ini.GetBool(INI_WEBCACHE_EXTRA_TIMEOUT,0);	
	PersistentConnectionsForProxyDownloads = ini.GetBool(INI_PERSISTENT_CONNECTIONS_FOR_PROXY_DOWNLOADS, false);
	WCAutoupdate = ini.GetBool(INI_WCAUTO_UPDATE, true);
	webcacheCachesLocalTraffic = ini.GetBool(INI_WEBCACHE_CACHESLOCAL_TRAFFIC, true);
	webcacheLimitles = ini.GetBool(INI_WEBCACHE_LIMITLES, false);
	webcacheEnabled = ini.GetInt(INI_WEBCACHE_ENABLED, 0); //webcache disabled on first start so webcache detection on start gets called.
	detectWebcacheOnStart = ini.GetBool(INI_DETECT_WEBCACHE_ON_START, true); // jp detect webcache on startup
	webcacheLastSearch=(uint32)ini.GetUInt64(INI_WEBCACHE_LAST_SEARCH,0);
	webcacheLastGlobalIP=(uint32)ini.GetUInt64(INI_WEBCACHE_LAST_GLOBAL_IP,0);
	webcacheLastResolvedName=ini.GetString(INI_WEBCACHE_LAST_RESOLVED_NAME,L"");
	webcacheTrustLevel=(uint8)ini.GetUInt64(INI_WEBCACHE_TRUST_LEVEL,30);
	m_bLogWebCacheEvents = ini.GetBool(INI_LOG_WEB_CACHE_EVENTS, true);
	//m_bWebCacheShow = ini.GetBool(INI_WEB_CACHE_SHOW, true);
#endif // NEO: WC END

	CheckNeoPreferences();
}

void CPreferencesEx::CheckNeoPreferences(){
#ifdef NEO_BC // NEO: NBC - [NeoBandwidthControl]
	MinMax(&m_fManageConnectionsFactor,VAL_CON_CTRL_MIN,VAL_CON_CTRL_MAX);

	MinMax(&m_iBCTimeDown,VAL_BC_TIME_DOWN_MIN,VAL_BC_TIME_DOWN_MAX);
	MinMax(&m_iBCTimeUp,VAL_BC_TIME_UP_MIN,VAL_BC_TIME_UP_MAX);

	MinMax(&m_iDownloadBufferSize,VAL_DOWNLOAD_BUFFER_MIN,VAL_DOWNLOAD_BUFFER_MAX);
	MinMax(&m_iUploadBufferSize,VAL_UPLOAD_BUFFER_MIN,VAL_UPLOAD_BUFFER_MAX);

	MinMax(&m_iDatarateSamples,5,20);


	MinMax(&m_iMaxReservedSlots,VAL_MAX_RESERVED_SLOTS_MIN,VAL_MAX_RESERVED_SLOTS_MAX);

	MinMax(&m_fIncreaseTrickleSpeed,VAL_INCREASE_TRICKLE_SPEED_MIN,VAL_INCREASE_TRICKLE_SPEED_MAX);

#ifdef NEO_UBT // NEO: BM - [BandwidthModeration]
	MinMax(&m_fReleaseSlotSpeed,VAL_RELEASE_SLOT_SPEED_MIN,VAL_RELEASE_SLOT_SPEED_MAX);
	MinMax(&m_fReleaseBandwidthPercentage,VAL_RELEASE_BANDWIDTH_PERCENTAGE_MIN,VAL_RELEASE_BANDWIDTH_PERCENTAGE_MAX);

	MinMax(&m_fFriendSlotSpeed,VAL_FRIEND_SLOT_SPEED_MIN,VAL_FRIEND_SLOT_SPEED_MAX);
	MinMax(&m_fFriendBandwidthPercentage,VAL_FRIEND_BANDWIDTH_PERCENTAGE_MIN,VAL_FRIEND_BANDWIDTH_PERCENTAGE_MAX);
#endif // NEO_UBT // NEO: BM END

	MinMax(&m_iDynUpGoingUpDivider,VAL_DYN_UP_GOING_UP_DIVIDER_MIN,VAL_DYN_UP_GOING_UP_DIVIDER_MAX);
	MinMax(&m_iDynUpGoingDownDivider,VAL_DYN_UP_GOING_DOWN_DIVIDER_MIN,VAL_DYN_UP_GOING_DOWN_DIVIDER_MAX);

	MinMax(&m_iBasePingUp,VAL_BASE_PING_UP_MIN,VAL_BASE_PING_UP_MAX);
	MinMax(&m_iPingUpTolerance,VAL_PING_UP_TOLERANCE_MIN,VAL_PING_UP_TOLERANCE_MAX);
	MinMax(&m_iPingUpProzent,VAL_PING_UP_PROZENT_MIN,VAL_PING_UP_PROZENT_MAX);

	MinMax(&m_iDynDownGoingUpDivider,VAL_DYN_DOWN_GOING_UP_DIVIDER_MIN,VAL_DYN_DOWN_GOING_UP_DIVIDER_MAX);
	MinMax(&m_iDynDownGoingDownDivider,VAL_DYN_DOWN_GOING_DOWN_DIVIDER_MIN,VAL_DYN_DOWN_GOING_DOWN_DIVIDER_MAX);

	MinMax(&m_iBasePingDown,VAL_BASE_PING_DOWN_MIN,VAL_BASE_PING_DOWN_MAX);
	MinMax(&m_iPingDownTolerance,VAL_PING_DOWN_TOLERANCE_MIN,VAL_PING_DOWN_TOLERANCE_MAX);
	MinMax(&m_iPingDownProzent,VAL_PING_DOWN_PROZENT_MIN,VAL_PING_DOWN_PROZENT_MAX);
#endif // NEO_BC // NEO: NBC END

	MinMax(&m_iToOldComplete,TO_OLD_SOURCE_MIN,TO_OLD_SOURCE_MAX);

	MinMax(&m_iHashingDelay,VAL_HASHING_DELAY_MIN,VAL_HASHING_DELAY_MAX); // NEO: MOD - [NiceHash]
	MinMax(&m_iProcessingDelay,VAL_PROCESSING_DELAY_MIN,VAL_PROCESSING_DELAY_MAX); // NEO: MOD - [RelaxCPU]

	MinMax(&m_iRefreshSharedIntervals,TIM_REFRESH_SHARED_INTERVALS_MIN,TIM_REFRESH_SHARED_INTERVALS_MAX); // NEO: MOD - [RefreshShared]

	MinMax(&m_iDownloadKeepAliveTimeout,VAL_DOWNLOAD_KEEP_ALIVE_TIMEOUT_MIN,VAL_DOWNLOAD_KEEP_ALIVE_TIMEOUT_MAX); // NEO: DKA - [DownloadKeepAlive]

	MinMax(&m_iTCPConnectionRetry,VAL_TCP_CON_RETRY_MIN,VAL_TCP_CON_RETRY_MAX); // NEO: TCR - [TCPConnectionRetry]

	// NEO: NST - [NeoSourceTweaks]
	MinMax(&m_iHardLimit,VAL_HARD_LIMIT_MIN,VAL_HARD_LIMIT_MAX);
	MinMax(&m_iSwapLimit,VAL_SWAP_LIMIT_MIN,VAL_SWAP_LIMIT_MAX);
	Maximal(&m_iSwapLimit,m_iHardLimit);
	MinMax(&m_iCleanUpLimit,VAL_CLEANUP_LIMIT_MIN,VAL_CLEANUP_LIMIT_MAX);
	Maximal(&m_iCleanUpLimit,m_iHardLimit);

	MinMax(&m_iXSLimit,VAL_XS_LIMIT_MIN,VAL_XS_LIMIT_MAX);
	Maximal(&m_iXSLimit,m_iHardLimit);
	MinMax(&m_iXSIntervals,TIM_XS_INTERVAL_MIN,TIM_XS_INTERVAL_MAX);
	MinMax(&m_iXSClientIntervals,TIM_XS_CLIENT_INTERVAL_MIN,TIM_XS_CLIENT_INTERVAL_MAX);
	MinMax(&m_iXSAnswerLimit,VAL_XS_ANSWER_LIMIT_MIN,VAL_XS_ANSWER_LIMIT_MAX);
	MinMax(&m_iXSDelayValue,VAL_XS_DELAY_MIN,VAL_XS_DELAY_MAX);

	MinMax(&m_iSVRLimit,VAL_SVR_LIMIT_MIN,VAL_SVR_LIMIT_MAX);
	Maximal(&m_iSVRLimit,m_iXSLimit);
	MinMax(&m_iSVRIntervals,TIM_SVR_INTERVAL_MIN,TIM_SVR_INTERVAL_MAX);

	MinMax(&m_iKADLimit,VAL_KAD_LIMIT_MIN,VAL_KAD_LIMIT_MAX);
	Maximal(&m_iKADLimit,m_iSVRLimit);
	MinMax(&m_iKADIntervals,TIM_KAD_INTERVAL_MIN,TIM_KAD_INTERVAL_MAX);
	MinMax(&m_iKADAmount,VAL_KAD_AMOUNT_MIN,VAL_KAD_AMOUNT_MAX);
	MinMax(&m_iKADDelayValue,VAL_KAD_DELAY_MIN,VAL_KAD_DELAY_MAX);

	MinMax(&m_iUDPLimit,VAL_UDP_LIMIT_MIN,VAL_UDP_LIMIT_MAX);
	Maximal(&m_iUDPLimit,m_iKADLimit);
	MinMax(&m_iUDPIntervals,TIM_UDP_INTERVAL_MIN,TIM_UDP_INTERVAL_MAX);
	MinMax(&m_iGlobalUDPIntervals,TIM_UDP_INTERVAL_MIN,TIM_UDP_INTERVAL_MAX);
	MinMax(&m_iUDPAmount,VAL_UDP_AMOUNT_MIN,VAL_UDP_AMOUNT_MAX);
	
	MinMax(&m_iUDPCache,VAL_UDP_CATCH_AMOUNT_MIN,VAL_UDP_CATCH_AMOUNT_MAX);// NEO: XUC - [ExtendedUdpCache]
	// NEO: NST END

	// NEO: NSD - [NeoSourceDrop]
	MinMax(&m_iLow2LowCleanUpTime,VAL_CLEANUP_TIME_MIN,VAL_CLEANUP_TIME_MAX);
#if defined(NEO_SK) || defined(NEO_SS) // NEO: NSK - [NeoSourceKeeper] // NEO: NSS - [NeoSourceStorage]
	MinMax(&m_iBadCleanUpTime,VAL_CLEANUP_TIME_MIN,VAL_CLEANUP_TIME_MAX);
	MinMax(&m_iGoneCleanUpTime,VAL_CLEANUP_TIME_MIN,VAL_CLEANUP_TIME_MAX);
	MinMax(&m_iSuspendCleanUpTime,VAL_CLEANUP_TIME_MIN,VAL_CLEANUP_TIME_MAX);
#endif // NEO_SK // NEO_SS // NEO: NSK END // NEO: NSS END
	MinMax(&m_iNnPCleanUpTime,VAL_CLEANUP_TIME_MIN,VAL_CLEANUP_TIME_MAX);
	MinMax(&m_iFullQCleanUpTime,VAL_CLEANUP_TIME_MIN,VAL_CLEANUP_TIME_MAX);
	// NEO: NSD END

	// NEO: IPS - [InteligentPartSharing]
	MinMax(&m_iInteligentPartSharingTimer,TIM_IPS_TIMER_MIN,TIM_IPS_TIMER_MAX);
	MinMax(&m_iMaxProzentToHide,VAL_IPS_MAX_MIN,VAL_IPS_MAX_MAX);

	MinMax(&m_fHideOverAvaliblyValue, m_iHideOverAvaliblyMode ? VAL_IPS_OA_MIN2 : VAL_IPS_OA_MIN1, m_iHideOverAvaliblyMode ? VAL_IPS_OA_MAX2 : VAL_IPS_OA_MAX1);
	MinMax(&m_fHideOverSharedValue, m_iHideOverSharedMode ? VAL_IPS_OS_MIN2 : VAL_IPS_OS_MIN1, m_iHideOverSharedMode ? VAL_IPS_OS_MAX2 : VAL_IPS_OS_MAX1);

	MinMax(&m_fDontHideUnderAvaliblyValue, m_iDontHideUnderAvaliblyMode ? VAL_IPS_UA_MIN2 : VAL_IPS_UA_MIN1, m_iDontHideUnderAvaliblyMode ? VAL_IPS_UA_MAX2 : VAL_IPS_UA_MAX1);

	MinMax(&m_fBlockHighOverAvaliblyFactor,VAL_IPS_OAF_MIN,VAL_IPS_OAF_MAX);
	MinMax(&m_fBlockHighOverSharedFactor,VAL_IPS_OSF_MIN,VAL_IPS_OSF_MAX);

	MinMax(&m_iShowAlwaysParts,VAL_SHOW_ALWAYS_PARTS_MIN,VAL_SHOW_ALWAYS_PARTS_MAX);
	// NEO: IPS END

#ifdef ARGOS // NEO: NA - [NeoArgos]
	MinMax(&m_iArgosTrustTime,TIM_ARGOS_TRUST_TIME_MIN,TIM_ARGOS_TRUST_TIME_MAX);

	MinMax(&m_iArgosProcessTime,TIM_ARGOS_BAN_TIME_MIN,TIM_ARGOS_BAN_TIME_MAX);
	MinMax(&m_iArgosTrackTime,TIM_ARGOS_TRACK_TIME_MIN,TIM_ARGOS_TRACK_TIME_MAX);
	MinMax(&m_iArgosGenericBanTime,TIM_ARGOS_GENERIC_BAN_TIME_MIN,TIM_ARGOS_GENERIC_BAN_TIME_MAX);
	MinMax(&m_iArgosAgressionBanTime,TIM_ARGOS_BAN_TIME_MIN,TIM_ARGOS_BAN_TIME_MAX);
	MinMax(&m_iArgosOpCodeTime,TIM_ARGOS_BAN_TIME_MIN,TIM_ARGOS_BAN_TIME_MAX);
	MinMax(&m_iArgosHashChangedTime,TIM_ARGOS_BAN_TIME_MIN,TIM_ARGOS_BAN_TIME_MAX);
	MinMax(&m_iArgosRankFlooderTime,TIM_ARGOS_BAN_TIME_MIN,TIM_ARGOS_BAN_TIME_MAX);
	MinMax(&m_iArgosGhostModeTime,TIM_ARGOS_BAN_TIME_MIN,TIM_ARGOS_BAN_TIME_MAX);
	MinMax(&m_iArgosCorruptedSenderTime,TIM_ARGOS_BAN_BAD_TIME_MIN,TIM_ARGOS_BAN_BAD_TIME_MAX);
	MinMax(&m_iArgosFileScannerTime,TIM_ARGOS_BAN_BAD_TIME_MIN,TIM_ARGOS_BAN_BAD_TIME_MAX);
	MinMax(&m_iArgosFileFakerTime,TIM_ARGOS_BAN_BAD_TIME_MIN,TIM_ARGOS_BAN_BAD_TIME_MAX);
	MinMax(&m_iArgosFailedTime,TIM_ARGOS_BAN_BAD_TIME_MIN,TIM_ARGOS_BAN_BAD_TIME_MAX);
	MinMax(&m_iArgosXSExploitTime,TIM_ARGOS_BAN_TIME_MIN,TIM_ARGOS_BAN_TIME_MAX);
	MinMax(&m_iArgosNickChangerTime,TIM_ARGOS_BAN_TIME_MIN,TIM_ARGOS_BAN_TIME_MAX);
	MinMax(&m_iArgosModChangerTime,TIM_ARGOS_BAN_TIME_MIN,TIM_ARGOS_BAN_TIME_MAX);
	MinMax(&m_iArgosSpamTime,TIM_ARGOS_BAN_TIME_MIN,TIM_ARGOS_BAN_TIME_MAX);
	MinMax(&m_iArgosBadHelloTime,TIM_ARGOS_BAN_TIME_MIN,TIM_ARGOS_BAN_TIME_MAX);
	MinMax(&m_iArgosBadProtTime,TIM_ARGOS_BAN_TIME_MIN,TIM_ARGOS_BAN_TIME_MAX);

	MinMax(&m_iAgressionIntervals,TIM_ARGOS_AGRESSION_INTERVALS_MIN,TIM_ARGOS_AGRESSION_INTERVALS_MAX);
	MinMax(&m_iAgressionThreshold,VAL_ARGOS_AGRESSION_THRESHOLD_MIN,VAL_ARGOS_AGRESSION_THRESHOLD_MAX);

	MinMax(&m_iFailedTries,VAL_ARGOS_FAILED_TRIES_MIN,VAL_ARGOS_FAILED_TRIES_MAX);
	MinMax(&m_iFailedThreshold,VAL_ARGOS_FAILED_THRESHOLD_MIN,VAL_ARGOS_FAILED_THRESHOLD_MAX);

	MinMax(&m_iXSExploitIntervals,TIM_ARGOS_XS_EXPLOIT_INTERVALS_MIN,TIM_ARGOS_XS_EXPLOIT_INTERVALS_MAX);
	MinMax(&m_iXSExploitThreshold,VAL_ARGOS_XS_EXPLOIT_THRESHOLD_MIN,VAL_ARGOS_XS_EXPLOIT_THRESHOLD_MAX);

	MinMax(&m_iNickChangeIntervals,TIM_ARGOS_NICK_CHANGE_INTERVALS_MIN,TIM_ARGOS_NICK_CHANGE_INTERVALS_MAX);
	MinMax(&m_iNickChangeThreshold,VAL_ARGOS_NICK_CHANGE_THRESHOLD_MIN,VAL_ARGOS_NICK_CHANGE_THRESHOLD_MAX);

	MinMax(&m_iModChangeIntervals,TIM_ARGOS_MOD_CHANGE_INTERVALS_MIN,TIM_ARGOS_MOD_CHANGE_INTERVALS_MAX);
	MinMax(&m_iModChangeThreshold,VAL_ARGOS_MOD_CHANGE_THRESHOLD_MIN,VAL_ARGOS_MOD_CHANGE_THRESHOLD_MAX);
#endif // ARGOS // NEO: NA END

	MinMax(&m_iRareFileLimit,VAL_RARE_FILE_MIN,VAL_RARE_FILE_MAX);

	MinMax(&m_iSpreadReask ,VAL_SPREAD_REASK_MIN,VAL_SPREAD_REASK_MAX); // NEO: SR - [SpreadReask]

	MinMax(&m_iObelixConnectionControlValue,VAL_OCC_MIN,VAL_OCC_MAX); // NEO: OCC - [ObelixConnectionControl]

	MinMax(&m_iAutoSoftLockValue,VAL_ASL_MIN,VAL_ASL_MAX); // NEO: ASL - [AutoSoftLock]

	// NEO: AHL - [AutoHardLimit]
	MinMax(&m_iAutoHardLimitTimer,TIM_AHL_MIN,TIM_AHL_MAX);
	MinMax(&m_iMinimalHardLimit,VAL_AHL_MIN_SRC_MIN,VAL_AHL_MIN_SRC_MAX); 
	Maximal(&m_iMinimalHardLimit,m_iHardLimit);
	MinMax(&m_iGlobalHardLimit,VAL_AHL_GLOBAL_SRC_MIN,VAL_AHL_GLOBAL_SRC_MAX); 
	Minimal(&m_iGlobalHardLimit,m_iHardLimit);
	// NEO: AHL END

	// NEO: XSC - [ExtremeSourceCache]
	MinMax(&m_iSourceCacheLimit,VAL_SOURCE_CACHE_LIMIT_MIN,VAL_SOURCE_CACHE_LIMIT_MAX); 
	MinMax(&m_iSourceCacheTime,TIM_SOURCE_CACHE_TIME_MIN,TIM_SOURCE_CACHE_TIME_MAX); 
	// NEO: XSC END

	// NEO: DR - [DownloadReask]
	MinMax(&m_iReaskIntervals,TIM_REASK_MIN,TIM_REASK_MAX);
	MinMax(&m_iNnPReaskIntervals,TIM_REASK_NNP_MIN,TIM_REASK_NNP_MAX);
	MinMax(&m_iFullQReaskIntervals,TIM_REASK_FULLQ_MIN,TIM_REASK_FULLQ_MAX);
	// NEO: DR END

#ifdef NEO_SS // NEO: NSS - [NeoSourceStorage]
	MinMax(&m_iAutoSaveSourcesIntervals,TIM_AUTO_SAVE_SOURCES_INTERVALS_MIN,TIM_AUTO_SAVE_SOURCES_INTERVALS_MAX);
	MinMax(&m_iSourceStorageLimit,SOURCE_STORAGE_LIMIT_MIN,SOURCE_STORAGE_LIMIT_MAX);

	MinMax(&m_iStorageBootstrapTime,STORAGE_BOOTSTRAP_TIME_MIN,STORAGE_BOOTSTRAP_TIME_MAX);
	MinMax(&m_iStorageBootstrapRequirement,STORAGE_BOOTSTRAP_REQUIREMENT_MIN,STORAGE_BOOTSTRAP_REQUIREMENT_MAX);

	MinMax(&m_iAutoReaskStoredSourcesLimit,AUTO_REASK_STORED_SOURCES_LIMIT_MIN,AUTO_REASK_STORED_SOURCES_LIMIT_MAX);
	MinMax(&m_iAutoReaskStoredSourcesDelay,AUTO_REASK_STORED_SOURCES_DELAY_MIN,AUTO_REASK_STORED_SOURCES_DELAY_MAX);

	MinMax(&m_iAutoReaskLoadedSourcesDelay,AUTO_REASK_LOADED_SOURCES_DELAY_MIN,AUTO_REASK_LOADED_SOURCES_DELAY_MAX);

	MinMax(&m_iStoredSourceGroupIntervals,GROUP_INTERVALS_MIN,GROUP_INTERVALS_MAX);
	MinMax(&m_iStoredSourceGroupSize,GROUP_SIZE_MIN,GROUP_SIZE_MAX);
	Minimal(&m_iStoredSourceGroupSize,m_iTableAmountToAnalise);

	MinMax(&m_iMaxStoredFaildCount,OUTOFDATE_MAXFAILS_MIN,OUTOFDATE_MAXFAILS_MAX);
	MinMax(&m_iStoredOutOfDate,OUTOFDATE_MAXTIME_MIN,OUTOFDATE_MAXTIME_MAX);
#endif // NEO_SS // NEO: NSS END
#ifdef NEO_CD // NEO: NCD - [NeoClientDatabase]
	MinMax(&m_iGlobalSourceListCleanUpTime,TIM_GLOBAL_SOURCE_LIST_CLEAN_UP_TIME_MIN,TIM_GLOBAL_SOURCE_LIST_CLEAN_UP_TIME_MAX);
	MinMax(&m_iGlobalSourceListCleanUpIntervals,TIM_GLOBAL_SOURCE_LIST_CLEAN_UP_INTERVALS_MIN,TIM_GLOBAL_SOURCE_LIST_CLEAN_UP_INTERVALS_MAX);
	MinMax(&m_iSourceFileListCleanUpTime,TIM_SOURCE_FILE_LIST_CLEAN_UP_TIME_MIN,TIM_SOURCE_FILE_LIST_CLEAN_UP_TIME_MAX);

	MinMax(&m_iSourceHashMonitorBadTime,TIM_SOURCE_HASH_MONITOR_BAD_TIME_MIN,TIM_SOURCE_HASH_MONITOR_BAD_TIME_MAX);
	MinMax(&m_iSourceHashMonitorMaxBad,SOURCE_HASH_MONITOR_MAX_BAD_MIN,SOURCE_HASH_MONITOR_MAX_BAD_MAX);

	MinMax(&m_iTableAmountToStore,TABLE_AMOUT_TO_STORE_MIN,TABLE_AMOUT_TO_STORE_MAX);

	MinMax(&m_iIgnoreUnreachableInterval,IGNORE_UNREACHABLE_INTERVAL_MIN,IGNORE_UNREACHABLE_INTERVAL_MAX);
	MinMax(&m_iIgnoreUndefinedInterval,IGNORE_UNDEFINED_INTERVAL_MIN,IGNORE_UNDEFINED_INTERVAL_MAX);
	MinMax(&m_iBeginNewTableInterval,BEGIN_NEW_TABLE_INTERVAL_MIN,BEGIN_NEW_TABLE_INTERVAL_MAX);
#endif // NEO_CD // NEO: NCD END
#ifdef NEO_SA // NEO: NSA - [NeoSourceAnaliser]
	MinMax(&m_iAnaliseIntervals,ANALISIS_INTERVALS_MIN,ANALISIS_INTERVALS_MAX);
	MinMax(&m_iTableAmountToAnalise,TABLE_AMOUT_TO_ANALISE_MIN,TABLE_AMOUT_TO_ANALISE_MAX);

	MinMax(&m_fEnhancedFactor,VAL_ENHANCED_FACTOR_MIN,VAL_ENHANCED_FACTOR_MAX);

	MinMax(&m_iReaskPropability,REASK_PROPABILITY_MIN,REASK_PROPABILITY_MAX);
	MinMax(&m_iReservePropability,RESERVE_PROPABILITY_MIN,RESERVE_PROPABILITY_MAX);
	Maximal(&m_iReservePropability,m_iReserveReaskPropability);

	MinMax(&m_iReserveReaskPropability,RESERVE_REASK_PROPABILITY_MIN,RESERVE_REASK_PROPABILITY_MAX);
	Maximal(&m_iReserveReaskPropability,m_iReaskPropability);
	MinMax(&m_iReaskReserveSourcesDelay,RESERVE_REASK_DELAY_MIN,RESERVE_REASK_DELAY_MAX);
	MinMax(&m_iReaskReserveSourcesLimit,RESERVE_REASK_LIMIT_MIN,RESERVE_REASK_LIMIT_MAX);

	MinMax(&m_iTemporaryReaskPropability,TEMPORARY_REASK_PROPABILITY_MIN,TEMPORARY_REASK_PROPABILITY_MAX);
	Maximal(&m_iTemporaryReaskPropability,m_iReaskPropability);
	MinMax(&m_iReaskTemporarySourcesDelay,TEMPORARY_REASK_DELAY_MIN,TEMPORARY_REASK_DELAY_MAX);
	MinMax(&m_iReaskTemporarySourcesLimit,TEMPORARY_REASK_LIMIT_MIN,TEMPORARY_REASK_LIMIT_MAX);

	//MinMax(&m_iMinAnalisisQuality,MIN_ANALISIS_QUALITY_MIN,MIN_ANALISIS_QUALITY_MAX);

	//MinMax(&m_iReaskUnsureSourcesDelay,UNSURE_REASK_DELAY_MIN,UNSURE_REASK_DELAY_MAX);
	//MinMax(&m_iReaskUnsureSourcesLimit,UNSURE_REASK_LIMIT_MIN,UNSURE_REASK_LIMIT_MAX);

	MinMax(&m_iUnpredictedPropability,UNPREDICTED_PROPABILITY_MIN,UNPREDICTED_PROPABILITY_MAX);
	MinMax(&m_iReaskUnpredictedSourcesDelay,UNPREDICTED_REASK_DELAY_MIN,UNPREDICTED_REASK_DELAY_MAX);
	MinMax(&m_iReaskUnpredictedSourcesLimit,UNPREDICTED_REASK_LIMIT_MIN,UNPREDICTED_REASK_LIMIT_MAX);

	MinMax(&m_iRetryUnreachableIntervals,RETRY_UNREAHABLE_INTERVALS_MIN,RETRY_UNREAHABLE_INTERVALS_MAX);
	MinMax(&m_iMaxFailTolerance,FAIL_TOLERANCE_MIN,FAIL_TOLERANCE_MAX);
	MinMax(&m_iUnreachableReaskPropability,UNREACHABLE_REASK_PROPABILITY_MIN,UNREACHABLE_REASK_PROPABILITY_MAX);
	MinMax(&m_iReaskUnreachableSourcesLimit,UNREACHABLE_REASK_LIMIT_MIN,UNREACHABLE_REASK_LIMIT_MAX);

	MinMax(&m_fPriorityGapRatio,PRIORITY_GAP_RATIO_MIN,PRIORITY_GAP_RATIO_MAX);
	MinMax(&m_iMaxGapSize,MAX_GAP_SIZE_MIN,MAX_GAP_SIZE_MAX);
	MinMax(&m_iMaxGapTime,MAX_GAP_TIME_MIN,MAX_GAP_TIME_MAX);
	MinMax(&m_fPriorityIPRatio,PRIORITY_IP_RATIO_MIN,PRIORITY_IP_RATIO_MAX);
	MinMax(&m_fPortIntegrityRatio,PORT_INTEGRITY_RATIO_MIN,PORT_INTEGRITY_RATIO_MAX);
	MinMax(&m_fMaxMidleDiscrepanceHigh,MAX_MIDLE_DISCREPANCE_HIGH_MIN,MAX_MIDLE_DISCREPANCE_HIGH_MAX);
	MinMax(&m_fMaxMidleDiscrepanceLow,MAX_MIDLE_DISCREPANCE_LOW_MIN,MAX_MIDLE_DISCREPANCE_LOW_MAX);
	MinMax(&m_iLastSeenDurationThreshold,LAST_SEEN_DURATION_THRESHOLD_MIN,LAST_SEEN_DURATION_THRESHOLD_MAX);
	MinMax(&m_iLinkTimeThreshold,LINK_TIME_THRESHOLD_MIN,LINK_TIME_THRESHOLD_MAX);
	MinMax(&m_iDualLinkedTableGravity,DUAL_LINKED_TABLE_GRAVITY_MIN,DUAL_LINKED_TABLE_GRAVITY_MAX);
	MinMax(&m_iMaxReliableTime,MAX_RELIABLE_TIME_MIN,MAX_RELIABLE_TIME_MAX);
	MinMax(&m_iTempralIPBorderLine,TEMPORAL_IP_BORDERLINE_MIN,TEMPORAL_IP_BORDERLINE_MAX);
#endif // NEO_SA // NEO: NSA END

	// NEO: DS - [DropSources]
	MinMax(&m_iDropNnPTimer,TIM_DROP_MIN,TIM_DROP_MAX);
	MinMax(&m_iDropNnPLimit,VAL_DROP_LIMIT_MIN(m_iDropNnPLimitMode),VAL_DROP_LIMIT_MAX(m_iDropNnPLimitMode));

	MinMax(&m_iDropFullQTimer,TIM_DROP_MIN,TIM_DROP_MAX);
	MinMax(&m_iDropFullQLimit,VAL_DROP_LIMIT_MIN(m_iDropFullQLimitMode),VAL_DROP_LIMIT_MAX(m_iDropFullQLimitMode));

	MinMax(&m_iDropHighQValue,VAL_DROP_HQ_VALUE_MIN,VAL_DROP_HQ_VALUE_MAX);
	MinMax(&m_iDropHighQLimit,VAL_DROP_LIMIT_MIN(m_iDropHighQLimitMode),VAL_DROP_LIMIT_MAX(m_iDropHighQLimitMode));
	MinMax(&m_iDropHighQTimer,TIM_DROP_MIN,TIM_DROP_MAX);

	MinMax(&m_iDontAskThisIPTime,VAL_DONT_ASK_THIS_IP_TIME_MIN,VAL_DONT_ASK_THIS_IP_TIME_MAX);
	// NEO: DS END

	// NEO: NSD - [NeoSourceDrop]
#ifdef NEO_SK // NEO: NSK - [NeoSourceKeeper]
	MinMax(&m_iDropUnreachableLimit,VAL_CLEAN_LIMIT_MIN(m_iDropUnreachableLimitMode),VAL_CLEAN_LIMIT_MAX(m_iDropUnreachableLimitMode));
	MinMax(&m_iDropUnreachableTimer,TIM_DROP_MIN,TIM_DROP_MAX);
#endif // NEO_SK // NEO: NSK END
#ifdef NEO_SS // NEO: NSS - [NeoSourceStorage]
	MinMax(&m_iDropOutOfDateFails,OUTOFDATE_MAXFAILS_MIN,OUTOFDATE_MAXFAILS_MAX);
	MinMax(&m_iDropOutOfDateTime,OUTOFDATE_MAXTIME_MIN,OUTOFDATE_MAXTIME_MAX);
	MinMax(&m_iDropOutOfDateLimit,VAL_CLEAN_LIMIT_MIN(m_iDropOutOfDateLimitMode),VAL_CLEAN_LIMIT_MAX(m_iDropOutOfDateLimitMode));
	MinMax(&m_iDropOutOfDateTimer,TIM_DROP_MIN,TIM_DROP_MAX);
#endif // NEO_SS // NEO: NSS END
#ifdef NEO_SA // NEO: NSA - [NeoSourceAnaliser]
	MinMax(&m_iDropRetiredLimit,VAL_CLEAN_LIMIT_MIN(m_iDropRetiredLimitMode),VAL_CLEAN_LIMIT_MAX(m_iDropRetiredLimitMode));
	MinMax(&m_iDropRetiredTimer,TIM_DROP_MIN,TIM_DROP_MAX);

	MinMax(&m_iDropLoadedLimit,VAL_CLEAN_LIMIT_MIN(m_iDropLoadedLimitMode),VAL_CLEAN_LIMIT_MAX(m_iDropLoadedLimitMode));
	MinMax(&m_iDropLoadedTimer,TIM_DROP_MIN,TIM_DROP_MAX);
#endif // NEO_SA // NEO: NSA END
	// NEO: NSD END

	// NEO: NCAP - [NeoCustomAutoPriority]
	MinMax(&m_fDynamicDownPriorityFactor,VAL_DYNAMIC_PRIORITY_FACTOR_MIN,VAL_DYNAMIC_PRIORITY_FACTOR_MAX);
	MinMax(&m_iLowDownPrioThreshold,VAL_LOW_DOWN_PRIO_THRESHOLD_MIN,VAL_LOW_DOWN_PRIO_THRESHOLD_MAX);
	MinMax(&m_iHighDownPrioThreshold,VAL_HIGH_DOWN_PRIO_THRESHOLD_MIN,VAL_HIGH_DOWN_PRIO_THRESHOLD_MAX);
	Maximal(&m_iHighDownPrioThreshold,m_iLowDownPrioThreshold);
	// NEO: NCAP END

	MinMax(&m_iMaxUploadSlots,VAL_MAX_UL_SLOTS_MIN,VAL_MAX_UL_SLOTS_MAX);
	MinMax(&m_iMinUploadSlots,VAL_MIN_UL_SLOTS_MIN,VAL_MIN_UL_SLOTS_MAX);
	Maximal(&m_iMinUploadSlots,m_iMaxUploadSlots);
	MinMax(&m_fUploadPerSlots,VAL_UL_PER_SLOTS_MIN,VAL_UL_PER_SLOTS_MAX);

	// NEO: QS - [QuickStart]
	MinMax(&m_iQuickStartTime,TIM_QUICK_START_MIN, TIM_QUICK_START_MAX);
	MinMax(&m_iQuickStartTimePerFile,VAL_QUICK_START_PF_MIN, VAL_QUICK_START_PF_MAX);
	// NEO: QS END

	// NEO: TQ - [TweakUploadQueue]
	MinMax(&m_iQueueOverFlowRelease,VAL_QUEUE_OVERFLOW_MIN,VAL_QUEUE_OVERFLOW_MAX);
	MinMax(&m_iQueueOverFlowEx,VAL_QUEUE_OVERFLOW_MIN,VAL_QUEUE_OVERFLOW_MAX);
	MinMax(&m_iQueueOverFlowDef,VAL_QUEUE_OVERFLOW_MIN,VAL_QUEUE_OVERFLOW_MAX);
	MinMax(&m_iQueueOverFlowCF,VAL_QUEUE_OVERFLOW_MIN,VAL_QUEUE_OVERFLOW_MAX);
	// NEO: TQ END

	// NEO: NMFS - [NiceMultiFriendSlots]
	MinMax(&m_iFriendSlotLimit,VAL_FRIEND_SLOT_LIMIT_MIN,VAL_FRIEND_SLOT_LIMIT_MAX);
	Maximal(&m_iFriendSlotLimit,m_iMinUploadSlots-1);
	// NEO: NMFS END

	MinMax(&m_iRecheckKadFirewalled,TIM_RECHECK_KAD_FIREWALLED_MIN,TIM_RECHECK_KAD_FIREWALLED_MAX); // NEO: RKF - [RecheckKadFirewalled]
	MinMax(&m_iReConnectOnLowID,VAL_RECONNECT_ON_LOWID_TRYS_MIN,VAL_RECONNECT_ON_LOWID_TRYS_MAX); // NEO: RLD - [ReconnectOnLowID]

#ifdef LANCAST // NEO: NLC - [NeoLanCast]
	MinMax(&m_iLanDownloadBufferSize,VAL_LAN_DOWNLOAD_BUFFER_MIN,VAL_LAN_DOWNLOAD_BUFFER_MAX);
	MinMax(&m_iLanUploadBufferSize,VAL_LAN_UPLOAD_BUFFER_MIN,VAL_LAN_UPLOAD_BUFFER_MAX);

	MinMax(&m_iMaxLanUploadSlots,VAL_MAX_LAN_UPLOAD_SLOTS_MIN,VAL_MAX_LAN_UPLOAD_SLOTS_MAX);

	MinMax(&m_iLANIntervals,TIM_LAN_INTERVAL_MIN,TIM_LAN_INTERVAL_MAX);
	
	MinMax(&m_iLanReaskIntervals,TIM_REASK_LAN_MIN,TIM_REASK_LAN_MAX);

	MinMax(&m_iNnPLanReaskIntervals,TIM_REASK_NNP_LAN_MIN,TIM_REASK_NNP_LAN_MAX);
	Minimal(&m_iNnPLanReaskIntervals,m_iLanReaskIntervals);

	MinMax(&m_iAutoBroadcastLanFiles,TIM_AUTO_BROADCAST_LAN_FILES_MIN,TIM_AUTO_BROADCAST_LAN_FILES_MAX);
#endif //LANCAST // NEO: NLC END
#ifdef VOODOO // NEO: VOODOO - [UniversalPartfileInterface]
	MinMax(&m_iVoodooSearchIntervals,TIM_VOODOO_SEARCH_MIN,TIM_VOODOO_SEARCH_MAX);
#endif // VOODOO // NEO: VOODOO END

	// NEO: RT - [ReleaseTweaks]
	MinMax(&m_iReleaseLevel,VAL_RELEASE_LEVEL_MIN,VAL_RELEASE_LEVEL_MAX);
	MinMax(&m_iReleaseLimitHigh,VAL_RELEASE_LIMIT_MIN,VAL_RELEASE_LIMIT_MAX);
	MinMax(&m_iReleaseLimitLow,VAL_RELEASE_LIMIT_MIN,VAL_RELEASE_LIMIT_MAX);
	Maximal(&m_iReleaseLimitLow,m_iReleaseLimitHigh);
	MinMax(&m_iReleaseLimitCompleteHigh,VAL_RELEASE_CLIMIT_MIN,VAL_RELEASE_CLIMIT_MAX);
	MinMax(&m_iReleaseLimitCompleteLow,VAL_RELEASE_CLIMIT_MIN,VAL_RELEASE_CLIMIT_MAX);
	Maximal(&m_iReleaseLimitCompleteLow,m_iReleaseLimitCompleteHigh);
	MinMax(&m_iSourceLimitHigh,VAL_SOURCE_LIMIT_MIN,VAL_SOURCE_LIMIT_MAX);
	MinMax(&m_iSourceLimitLow,VAL_SOURCE_LIMIT_MIN,VAL_SOURCE_LIMIT_MAX);
	Maximal(&m_iSourceLimitLow,m_iSourceLimitHigh);
	MinMax(&m_iSourceLimitCompleteHigh,VAL_RELEASE_CLIMIT_MIN,VAL_RELEASE_CLIMIT_MAX);
	MinMax(&m_iSourceLimitCompleteLow,VAL_RELEASE_CLIMIT_MIN,VAL_RELEASE_CLIMIT_MAX);
	Maximal(&m_iSourceLimitCompleteLow,m_iSourceLimitCompleteHigh);
	MinMax(&m_iReleaseNeedCompleteLimit,VAL_RELEASE_CL_MIN,VAL_RELEASE_CL_MAX);
	MinMax(&m_iReleaseSlotLimit,VAL_RELEASE_SLOT_LIMIT_MIN,VAL_RELEASE_SLOT_LIMIT_MAX);
	Maximal(&m_iReleaseSlotLimit,m_iMaxUploadSlots);
	// NEO: RT END

	// NEO: NCAP - [NeoCustomAutoPriority]
	MinMax(&m_fDynamicUpPriorityFactor,VAL_DYNAMIC_PRIORITY_FACTOR_MIN,VAL_DYNAMIC_PRIORITY_FACTOR_MAX);
	MinMax(&m_iLowUpPrioThreshold,VAL_LOW_UP_PRIO_THRESHOLD_MIN,VAL_LOW_UP_PRIO_THRESHOLD_MAX);
	MinMax(&m_iHighUpPrioThreshold,VAL_HIGH_UP_PRIO_THRESHOLD_MIN,VAL_HIGH_UP_PRIO_THRESHOLD_MAX);
	Maximal(&m_iHighUpPrioThreshold,m_iLowUpPrioThreshold);
	// NEO: NCAP END

	// NEO: PRSF - [PushSmallRareFiles]
	MinMax(&m_iPushSmallFilesSize,VAL_PUSH_SMALL_FILES_SIZE_MIN,VAL_PUSH_SMALL_FILES_SIZE_MAX);
	MinMax(&m_iPushRareFilesValue,VAL_PUSH_RARE_FILES_VALUE_MIN,VAL_PUSH_RARE_FILES_VALUE_MAX);
	MinMax(&m_iPushRatioFilesValue,VAL_PUSH_RATIO_FILES_VALUE_MIN,VAL_PUSH_RATIO_FILES_VALUE_MAX);
	// NEO: PRSF END

	// NEO: FDC - [FileNameDisparityCheck]
	MinMax(&m_iFileCheckSensitivity,VAL_FILE_CHECK_SENSITIVITY_MIN,VAL_FILE_CHECK_SENSITIVITY_MAX);
	MinMax(&m_iFileCheckThreshold,VAL_FILE_CHECK_THRESHOLD_MIN,VAL_FILE_CHECK_THRESHOLD_MAX);
	MinMax(&m_iFileCheckAmount,VAL_FILE_CHECK_AMOUNT_MIN,VAL_FILE_CHECK_AMOUNT_MAX);
	// NEO: FDC END

	// NEO: NATS - [NatSupport]
	MinMax(&m_fNATPortRefreshIvterval,VAL_NAT_PORT_REFRESH_IVTERVAL_MIN,VAL_NAT_PORT_REFRESH_IVTERVAL_MAX);
	MinMax(&m_iNATPortMaxLatencyTime,VAL_NAT_PORT_MAX_LATENCY_TIME_MIN,VAL_NAT_PORT_MAX_LATENCY_TIME_MAX);
	MinMax(&m_iNATPortMaxFails,VAL_NAT_PORT_MAX_FAILS_MIN,VAL_NAT_PORT_MAX_FAILS_MAX);
	// NEO: NATS END

	MinMax(&m_iTrayBarsMaxCollor,1,17); // NEO: NSTI - [NewSystemTrayIcon]
}

void CPreferencesEx::SaveNeoPreferences()
{
	CIni ini(GetConfigFile(), L"Neo");

#ifdef NEO_BC // NEO: NBC - [NeoBandwidthControl]
	ini.WriteBool(INI_MANAGE_CONNECTIONS, m_bManageConnections);
	ini.WriteFloat(INI_MANAGE_CONNECTIONS_FACTOR, m_fManageConnectionsFactor);

	ini.WriteInt(INI_NAFC_ENABLED, m_uNAFCEnabled);
	ini.WriteBool(INI_ISP_CUSTOM_IP, m_bISPCustomIP);
	ini.WriteInt(INI_ISP_ZONE, m_uISPZone);
	ini.WriteInt(INI_ISP_MASK, m_uISPMask);
	ini.WriteBool(INI_BIND_TO_ADAPTER, m_bBindToAdapter);


	ini.WriteBool(INI_CHECK_CONNECTION, m_bCheckConnection);
	ini.WriteBool(INI_STATIC_LOWEST_PING, m_bStaticLowestPing);
	ini.WriteInt(INI_PING_MODE, m_iPingMode);
	ini.WriteBool(INI_NO_TTL, m_bNoTTL);
	ini.WriteBool(INI_MANUAL_HOST_TO_PING, m_bManualHostToPing);
	ini.WriteString(INI_PING_SERVER, m_sPingServer);

	ini.WriteBool(INI_AUTO_MSS, m_bAutoMSS);
	ini.WriteInt(INI_MSS, m_iMSS);

	ini.WriteBool(INI_USE_DOUBLE_SEND_SIZE, m_bUseDoubleSendSize);


	ini.WriteBool(INI_DIRECT_DOWNLOAD, m_bDirectDownload);
	ini.WriteBool(INI_DIRECT_RECEIVING_TCP, m_bDirectReceivingTCP);
	ini.WriteBool(INI_DIRECT_RECEIVING_UDP, m_bDirectReceivingUDP);
	ini.WriteInt(INI_BC_TIME_DOWN, m_iBCTimeDown);
	ini.WriteInt(INI_BC_PRIORITY_DOWN, m_iBCPriorityDown);
	ini.WriteInt(INI_SET_DOWNLOAD_BUFFER, m_uSetDownloadBuffer);
	ini.WriteInt(INI_DOWNLOAD_BUFFER_SIZE, m_iDownloadBufferSize);

	//ini.WriteBool(INI_DIRECT_UPLOAD, m_bDirectUpload);
	ini.WriteInt(INI_USE_BLOCKED_QUEUE, m_uUseBlockedQueue);
	ini.WriteBool(INI_DIRECT_SENDING_TCP, m_bDirectSendingTCP);
	ini.WriteBool(INI_DIRECT_SENDING_UDP, m_bDirectSendingUDP);
	ini.WriteInt(INI_BC_TIME_UP, m_iBCTimeUp);
	ini.WriteInt(INI_BC_PRIORITY_UP, m_iBCPriorityUp);
	ini.WriteInt(INI_SET_UPLOAD_BUFFER, m_uSetUploadBuffer);
	ini.WriteInt(INI_UPLOAD_BUFFER_SIZE, m_iUploadBufferSize);

	ini.WriteInt(INI_DATARATE_SAMPLES, m_iDatarateSamples);


	ini.WriteBool(INI_INCLUDE_OVERHEAD, m_bIncludeOverhead);
	ini.WriteBool(INI_INCLUDE_TCP_ACK, m_bIncludeTCPAck);
	ini.WriteBool(INI_CONNECTIONS_OVERHEAD, m_bConnectionsOverHead);
	ini.WriteBool(INI_ZZ_RATIO, m_bSessionRatio);


	ini.WriteInt(INI_DOWNLOAD_CONTROL, m_iDownloadControl);
	ini.WriteFloat(INI_MIN_BC_DOWNLOAD, m_fMinBCDownload);
	ini.WriteFloat(INI_MAX_BC_DOWNLOAD, m_fMaxBCDownload);


	ini.WriteInt(INI_UPLOAD_CONTROL, m_iUploadControl);
	ini.WriteFloat(INI_MIN_BC_UPLOAD,m_fMinBCUpload);
	ini.WriteFloat(INI_MAX_BC_UPLOAD,m_fMaxBCUpload);


	ini.WriteFloat(INI_MAX_DOWN_STREAM, m_fMaxDownStream);
	ini.WriteFloat(INI_MAX_UP_STREAM, m_fMaxUpStream);


	ini.WriteBool(INI_MINIMIZE_OPENED_SLOTS, m_bMinimizeOpenedSlots);
	ini.WriteInt(INI_CUMULATE_BANDWIDTH, m_uCumulateBandwidth);
	ini.WriteInt(INI_BADWOLFS_UPLOAD, m_uBadwolfsUpload);

	ini.WriteInt(INI_MAX_RESERVED_SLOTS, m_iMaxReservedSlots);
	
	ini.WriteBool(INI_INCREASE_TRICKLE_SPEED, m_bIncreaseTrickleSpeed);
	ini.WriteFloat(INI_INCREASE_TRICKLE_SPEED_VALUE, m_fIncreaseTrickleSpeed);

#ifdef NEO_UBT // NEO: BM - [BandwidthModeration]
	ini.WriteInt(INI_SEPARATE_RELEASE_BANDWIDTH, m_uSeparateReleaseBandwidth);
	ini.WriteFloat(INI_RELEASE_SLOT_SPEED, m_fReleaseSlotSpeed);
	ini.WriteFloat(INI_RELEASE_BANDWIDTH_PERCENTAGE, m_fReleaseBandwidthPercentage);

	ini.WriteBool(INI_SEPARATE_FRIEND_BANDWIDTH, m_bSeparateFriendBandwidth);
	ini.WriteFloat(INI_FRIEND_SLOT_SPEED, m_fFriendSlotSpeed);
	ini.WriteFloat(INI_FRIEND_BANDWIDTH_PERCENTAGE, m_fFriendBandwidthPercentage);
#endif // NEO_UBT // NEO: BM END

	ini.WriteBool(INI_OPEN_MORE_SLOTS_WHEN_NEEDED, m_bOpenMoreSlotsWhenNeeded);
	ini.WriteBool(INI_CHECK_SLOT_DATARATE, m_bCheckSlotDatarate);

	ini.WriteBool(INI_TRICKLE_BLOCKING, m_bIsTrickleBlocking);
	ini.WriteBool(INI_DROP_BLOCKING, m_bIsDropBlocking);

	//ini.WriteBool(INI_ALLOW_OVER_SENDING, m_bAllowOverSending);


	ini.WriteBool(INI_DYN_UP_GOING_DIVIDER, m_bDynUpGoingDivider);
	ini.WriteInt(INI_DYN_UP_GOING_UP_DIVIDER, m_iDynUpGoingUpDivider);
	ini.WriteInt(INI_DYN_UP_GOING_DOWN_DIVIDER, m_iDynUpGoingDownDivider);

	ini.WriteInt(INI_UP_MAX_PING_METHOD, m_iUpMaxPingMethod);
	ini.WriteInt(INI_BASE_PING_UP, m_iBasePingUp);
	ini.WriteInt(INI_PING_UP_TOLERANCE, m_iPingUpTolerance);
	ini.WriteInt(INI_PING_UP_PROZENT, m_iPingUpProzent);


	ini.WriteBool(INI_DYN_DOWN_GOING_DIVIDER, m_bDynDownGoingDivider);
	ini.WriteInt(INI_DYN_DOWN_GOING_UP_DIVIDER, m_iDynDownGoingUpDivider);
	ini.WriteInt(INI_DYN_DOWN_GOING_DOWN_DIVIDER, m_iDynDownGoingDownDivider);
	
	ini.WriteInt(INI_DOWN_MAX_PING_METHOD, m_iDownMaxPingMethod);
	ini.WriteInt(INI_BASE_PING_DOWN, m_iBasePingDown);
	ini.WriteInt(INI_PING_DOWN_TOLERANCE, m_iPingDownTolerance);
	ini.WriteInt(INI_PING_DOWN_PROZENT, m_iPingDownProzent);
#endif // NEO_BC // NEO: NBC END

	ini.WriteBool(INI_ONLY_COMPLETE_FILE, m_bOnlyCompleteFiles); // NEO: OCF - [OnlyCompleetFiles]
	ini.WriteInt(INI_TO_OLD_COMPLETE, m_iToOldComplete);
	ini.WriteBool(INI_CUSTOM_SHARE_VIWE_PERMISSIONS, m_bUseCustomPermissions); // NEO: SSP - [ShowSharePermissions]
	ini.WriteBool(INI_SAVE_COMMENTS, m_bUseSaveComments); // NEO: XC - [ExtendedComments]
	ini.WriteBool(INI_KNOWN_COMMENTS, m_bUseKnownComments); // NEO: XCk - [ExtendedKnownComments]
	ini.WriteInt(INI_INTELIGENT_CHUNK_SELECTION,m_uInteligentChunkSelecting); // NEO: ICS - [InteligentChunkSelection]
	ini.WriteInt(INI_SUB_CHUNK_TRANSFER,m_uSubChunkTransfer); // NEO: SCT - [SubChunkTransfer]
	ini.WriteInt(INI_SUB_CHUNK_VERIFICATION,m_uSubChunkVerification); // NEO: SCV - [SubChunkVerification]
	ini.WriteInt(INI_REAL_PART_STATUS,m_uRealPartStatus); // NEO: RPS - [RealPartStatus]
	ini.WriteInt(INI_SHAREEMPTYFILES,m_uShareAlsoEmptyFiles); // NEO: SEF - [ShareAlsoEmptyFiles]

	// NEO: NXI - [NeoExtraInfo]
	ini.WriteBool(INI_NXI_ENABLE, m_bSendExtraInfo);
	ini.WriteBool(INI_NXI_BW, m_bSendExtraInfoBandwidth);
	ini.WriteInt(INI_NXI_UP_TIME, m_uSendExtraInfoUpTime);
	ini.WriteBool(INI_NXI_DL_FILE, m_bSendExtraInfoDlFile);
	ini.WriteInt(INI_NXI_UL_FILE, m_uSendExtraInfoUlFile);
	ini.WriteBool(INI_NXI_WAITING_USERS, m_bSendExtraInfoWaitingUsers);
	CString sSI = m_sSendExtraInfoString;
	sSI.Replace(L"\n",L"\\n");
	ini.WriteString(INI_NXI_SOME_INFO,sSI);
	// NEO: NXI END
	ini.WriteInt(INI_APP_PRIORITY, m_dAppPriority);
	// NEO: MOD - [NiceHash]
	ini.WriteBool(INI_USE_HASHING_DELAY, m_bUseHashingDelay);
	ini.WriteInt(INI_HASHING_DELAY, m_iHashingDelay);
	// NEO: MOD END
	// NEO: MOD - [RelaxCPU]
	ini.WriteBool(INI_USE_PROCESSING_DELAY, m_bUseProcessingDelay);
	ini.WriteInt(INI_PROCESSING_DELAY, m_iProcessingDelay);
	// NEO: MOD END
	// NEO: MOD - [RefreshShared]
	ini.WriteBool(INI_REFRESH_SHARED, m_bRefreshShared);
	ini.WriteInt(INI_REFRESH_SHARED_INTERVALS, m_iRefreshSharedIntervals);
	// NEO: MOD END
	ini.WriteBool(INI_PAUSE_ON_FILE_COMPLETE, m_bPauseOnFileComplete); // NEO: POFC - [PauseOnFileComplete]
	ini.WriteBool(INI_ESTIMATED_DL_TIME, m_bEstimatedDownloadTime); // NEO: EDT - [EstimatedDownloadTime] 
	ini.WriteInt(INI_L2HAC, m_uLowID2HighIDAutoCallback); // NEO: L2H - [LowID2HighIDAutoCallback]
	ini.WriteInt(INI_ANTI_HIDE_OS,m_uAntiHideOS); // NEO: AHOS - [AntiHideOS]
	// NEO: DKA - [DownloadKeepAlive]
	ini.WriteBool(INI_ENABLE_DOWNLOAD_KEEP_ALIVE, m_bEnableDownloadKeepAlive);
	ini.WriteInt(INI_DOWNLOAD_KEEP_ALIVE_TIMEOUT, m_iDownloadKeepAliveTimeout);
	// NEO: DKA END
	// NEO: TCR - [TCPConnectionRetry]
	ini.WriteBool(INI_TCP_CON_RETRY_ENABLE, m_bTCPConnectionRetry);
	ini.WriteInt(INI_TCP_CON_RETRY_VALUE, m_iTCPConnectionRetry);
	// NEO: TCR END
	ini.WriteBool(INI_TCP_DISABLE_NAGLE, m_bTCPDisableNagle);

	// NEO: NST - [NeoSourceTweaks]
	ini.WriteInt(INI_HARD_LIMIT, m_iHardLimit);
	ini.WriteInt(INI_SWAP_LIMIT, m_iSwapLimit);
	ini.WriteInt(INI_CLEANUP_LIMIT, m_iCleanUpLimit);
	ini.WriteBool(INI_CALC_LIMITS, m_bCalcStandardLimits);

	ini.WriteBool(INI_XS_DISABLE,m_bXSDisable);
	ini.WriteInt(INI_XS_LIMIT,m_iXSLimit);
	ini.WriteInt(INI_XS_INTERVAL,m_iXSIntervals);
	ini.WriteInt(INI_XS_CLIENT_INTERVAL,m_iXSClientIntervals);
	ini.WriteInt(INI_XS_ANSWER_LIMIT,m_iXSAnswerLimit);
	ini.WriteInt(INI_XS_DELAY_VALUE,m_iXSDelayValue);

	ini.WriteBool(INI_SVR_DISABLE,m_bSVRDisable);
	ini.WriteInt(INI_SVR_LIMIT,m_iSVRLimit);
	ini.WriteInt(INI_SVR_INTERVAL,m_iSVRIntervals);

	ini.WriteBool(INI_KAD_DISABLE,m_bKADDisable);
	ini.WriteInt(INI_KAD_LIMIT,m_iKADLimit);
	ini.WriteInt(INI_KAD_INTERVAL,m_iKADIntervals);
	ini.WriteInt(INI_KAD_AMOUNT,m_iKADAmount);
	ini.WriteInt(INI_KAD_DELAY_VALUE,m_iKADDelayValue);

	ini.WriteBool(INI_UDP_DISABLE,m_bUDPDisable);
	ini.WriteInt(INI_UDP_LIMIT,m_iUDPLimit);
	ini.WriteInt(INI_UDP_INTERVAL,m_iUDPIntervals);
	ini.WriteInt(INI_GLOBAL_UDP_INTERVAL,m_iGlobalUDPIntervals);
	ini.WriteInt(INI_UDP_AMOUNT,m_iUDPAmount);
	// NEO: XUC - [ExtendedUdpCache]
	ini.WriteInt(INI_UDP_CATCH,m_uUDPCache);
	ini.WriteInt(INI_UDP_CATCH_AMOUNT,m_iUDPCache);
	// NEO: XUC END
	ini.WriteInt(INI_RARE_FILE,m_iRareFileLimit);
	// NEO: NST END

	// NEO: NSD - [NeoSourceDrop]
	ini.WriteInt(INI_LOW2LOW_CLEANUP_TIME,m_iLow2LowCleanUpTime);
#if defined(NEO_SK) || defined(NEO_SS) // NEO: NSK - [NeoSourceKeeper] // NEO: NSS - [NeoSourceStorage]
	ini.WriteInt(INI_BAD_CLEANUP_TIME,m_iBadCleanUpTime);
	ini.WriteInt(INI_GONE_CLEANUP_TIME,m_iGoneCleanUpTime);
	ini.WriteInt(INI_SUSPEND_CLEANUP_TIME,m_iSuspendCleanUpTime);
#endif // NEO_SK // NEO_SS // NEO: NSK END // NEO: NSS END
	ini.WriteInt(INI_NNP_CLEANUP_TIME,m_iNnPCleanUpTime);
	ini.WriteInt(INI_FULLQ_CLEANUP_TIME,m_iFullQCleanUpTime);
	// NEO: NSD END

	// NEO: SR - [SpreadReask]
	ini.WriteBool(INI_SPREAD_REASK,m_bSpreadReask);
	ini.WriteInt(INI_SPREAD_REASK_VALUE,m_iSpreadReask);
	// NEO: SR END

	// NEO: OCC - [ObelixConnectionControl]
	ini.WriteBool(INI_OCC,m_bObelixConnectionControl);
	ini.WriteInt(INI_OCC_VALUE,m_iObelixConnectionControlValue);
	// NEO: OCC END

	// NEO: ASL - [AutoSoftLock]
	ini.WriteBool(INI_ASL,m_bAutoSoftLock);
	ini.WriteInt(INI_ASL_VALUE,m_iAutoSoftLockValue);
	// NEO: ASL END

	// NEO: AHL - [AutoHardLimit]
	ini.WriteInt(INI_AHL,m_iAutoHardLimit);
	ini.WriteInt(INI_AHL_MIN_SRC,m_iMinimalHardLimit);
	ini.WriteInt(INI_AHL_GLOBAL_SRC,m_iGlobalHardLimit);
	ini.WriteInt(INI_AHL_TIMER,m_iAutoHardLimitTimer);
	// NEO: AHL END

	// NEO: XSC - [ExtremeSourceCache]
	ini.WriteBool(INI_SOURCE_CACHE,m_bSourceCache);
	ini.WriteInt(INI_SOURCE_CACHE_LIMIT,m_iSourceCacheLimit);
	ini.WriteInt(INI_SOURCE_CACHE_TIME,m_iSourceCacheTime);
	// NEO: XSC END

	// NEO: DR - [DownloadReask]
	ini.WriteInt(INI_REASK_TIME,m_iReaskIntervals);

	ini.WriteBool(INI_REASK_NNP_OFF,m_bDontNnPReask);
	ini.WriteInt(INI_REASK_NNP_TIME,m_iNnPReaskIntervals);

	ini.WriteBool(INI_REASK_FULLQ_OFF,m_bDontFullQReask);
	ini.WriteInt(INI_REASK_FULLQ_TIME,m_iFullQReaskIntervals);
	// NEO: DR END

#ifdef NEO_SK // NEO: NSK - [NeoSourceKeeper]
	ini.WriteBool(INI_NEO_SOURCE_KEEPER,m_bEnableSourceKeeper);
#endif // NEO_SK // NEO: NSK END
#ifdef NEO_SS // NEO: NSS - [NeoSourceStorage]
	ini.WriteBool(INI_NEO_SOURCE_STORAGE,m_bEnableSourceStorage);
	ini.GetInt(INI_AUTO_SAVE_SOURCES,m_uAutoSaveSources);
	ini.GetInt(INI_AUTO_SAVE_SOURCES_INTERVALS,m_iAutoSaveSourcesIntervals);
	ini.WriteInt(INI_SOURCE_STORAGE_LIMIT,m_iSourceStorageLimit);
	ini.WriteInt(INI_AUTO_LOAD_SOURCES,m_bAutoLoadStoredSources);
	ini.WriteBool(INI_USE_STORAGE_BOOTSTRAP,m_bUseStorageBootstrap);
	ini.WriteInt(INI_STORAGE_BOOTSTRAP_TIME,m_iStorageBootstrapTime);
	ini.WriteInt(INI_STORAGE_BOOTSTRAP_REQUIREMENT,m_iStorageBootstrapRequirement);
	ini.WriteBool(INI_STORE_LOW_ID,m_bStoreLowIDSources);
	ini.WriteBool(INI_STORE_A4AF,m_bStoreAlsoA4AFSources);
	ini.WriteInt(INI_STORE_FILE_STATUS,m_uStoreSourcesFileStatus);

	ini.WriteBool(INI_AUTO_REASK_STORED_SOURCES,m_bAutoReaskStoredSources);
	ini.WriteInt(INI_AUTO_REASK_STORED_SOURCES_LIMIT,m_iAutoReaskStoredSourcesLimit);
	ini.WriteBool(INI_TOTAL_SOURCE_RESTORE,m_bTotalSourceRestore);
	ini.WriteBool(INI_USE_AUTO_REASK_STORED_SOURCES_DELAY,m_bUseAutoReaskStoredSourcesDelay);
	ini.WriteInt(INI_AUTO_REASK_STORED_SOURCES_DELAY,m_iAutoReaskStoredSourcesDelay);

	ini.WriteInt(INI_AUTO_REASK_LOADED_SOURCES_DELAY,m_iAutoReaskLoadedSourcesDelay);

	ini.WriteBool(INI_GROUP_STORAGE,m_bGroupStoredSourceReask);
	ini.WriteInt(INI_GROUP_INTERVALS,m_iStoredSourceGroupIntervals);
	ini.WriteInt(INI_GROUP_SIZE,m_iStoredSourceGroupSize);

	ini.WriteBool(INI_USE_SMOOTH_OUTOFDATE,m_bUseSmoothOutOfDate);
	ini.WriteInt(INI_OUTOFDATE_MAXFAILS,m_iMaxStoredFaildCount);
	ini.WriteInt(INI_OUTOFDATE_MAXTIME,m_iStoredOutOfDate);
#endif // NEO_SS // NEO: NSS END
#ifdef NEO_CD // NEO: NCD - [NeoClientDatabase]
	ini.WriteBool(INI_SOURCE_LIST,m_bEnableSourceList);
	ini.WriteInt(INI_SAVE_GLOBAL_SOURCE_LIST,m_uSaveGlobalSourceList);
	ini.WriteInt(INI_GLOBAL_SOURCE_LIST_CLEAN_UP_TIME,m_iGlobalSourceListCleanUpTime);
	ini.WriteBool(INI_GLOBAL_SOURCE_LIST_CLEAN_UP,m_bGlobalSourceListCleanUp);
	ini.WriteInt(INI_GLOBAL_SOURCE_LIST_CLEAN_UP_INTERVALS,m_iGlobalSourceListCleanUpIntervals);
	ini.WriteBool(INI_FAST_SOURCE_CLEAN_UP,m_bFastSourceCleanUp);
	ini.WriteBool(INI_SAVE_SOURCE_FILE_LIST,m_bSaveSourceFileList);
	ini.WriteInt(INI_SOURCE_FILE_LIST_CLEAN_UP_TIME,m_iSourceFileListCleanUpTime);
	ini.WriteBool(INI_SAVE_SOURCE_DATAS_IN_CLIENTS,m_bSaveSourceDataInClient);

	ini.WriteBool(INI_USE_IP_ZONE_CHECK,m_bIPZoneCheck);

	ini.WriteBool(INI_USE_SOURCE_HASH_MONITOR,m_bSourceHashMonitor);
	ini.WriteInt(INI_SOURCE_HASH_MONITOR_BAD_TIME,m_iSourceHashMonitorBadTime);
	ini.WriteInt(INI_SOURCE_HASH_MONITOR_MAX_BAD,m_iSourceHashMonitorMaxBad);

	ini.WriteInt(INI_TABLE_AMOUT_TO_STORE,m_iTableAmountToStore);

	ini.WriteInt(INI_IGNORE_UNREACHABLE_INTERVAL,m_iIgnoreUnreachableInterval);
	ini.WriteInt(INI_IGNORE_UNDEFINED_INTERVAL,m_iIgnoreUndefinedInterval);
	ini.WriteInt(INI_BEGIN_NEW_TABLE_INTERVAL,m_iBeginNewTableInterval);
#endif // NEO_CD // NEO: NCD END
#ifdef NEO_SA // NEO: NSA - [NeoSourceAnaliser]
	ini.WriteBool(INI_ENABLE_SOURCE_ANALISER,m_bEnableSourceAnalizer);
	ini.WriteInt(INI_ANALISIS_INTERVALS,m_iAnaliseIntervals);
	ini.WriteInt(INI_TABLE_AMOUT_TO_ANALISE,m_iTableAmountToAnalise);

	ini.WriteBool(INI_DONT_STORE_TEMP_SOURCES,m_bDontStoreTemporarySources);

	ini.WriteInt(INI_PROBABILITY_MODE,m_iPropabilityMode);
	ini.WriteFloat(INI_ENHANCED_FACTOR,m_fEnhancedFactor);

	ini.WriteInt(INI_REASK_PROPABILITY,m_iReaskPropability);
	ini.WriteInt(INI_RESERVE_PROPABILITY,m_iReservePropability);

	ini.WriteBool(INI_AUTO_RESERVE_REASK,m_bAutoReserveReask);
	ini.WriteInt(INI_RESERVE_REASK_PROPABILITY,m_iReserveReaskPropability);
	ini.WriteBool(INI_USE_RESERVE_REASK_DELAY,m_bUseReaskReserveSourcesDelay);
	ini.WriteInt(INI_RESERVE_REASK_DELAY,m_iReaskReserveSourcesDelay);
	ini.WriteInt(INI_RESERVE_REASK_LIMIT,m_iReaskReserveSourcesLimit);

	ini.WriteBool(INI_AUTO_TEMPORARY_REASK,m_bAutoTemporaryReask);
	ini.WriteInt(INI_TEMPORARY_REASK_PROPABILITY,m_iTemporaryReaskPropability);
	ini.WriteBool(INI_USE_TEMPORARY_REASK_DELAY,m_bUseReaskTemporarySourcesDelay);
	ini.WriteInt(INI_TEMPORARY_REASK_DELAY,m_iReaskTemporarySourcesDelay);
	ini.WriteInt(INI_TEMPORARY_REASK_LIMIT,m_iReaskTemporarySourcesLimit);

	//ini.WriteInt(INI_MIN_ANALISIS_QUALITY,m_iMinAnalisisQuality);

	//ini.WriteBool(INI_AUTO_UNSURE_REASK,m_bAutoUnsureReask);
	//ini.WriteBool(INI_USE_UNSURE_REASK_DELAY,m_bUseReaskUnsureSourcesDelay);
	//ini.WriteInt(INI_UNSURE_REASK_DELAY,m_iReaskUnsureSourcesDelay);
	//ini.WriteInt(INI_UNSURE_REASK_LIMIT,m_iReaskUnsureSourcesLimit);

	ini.WriteBool(INI_USE_UNPREDICTED_PROPABILITY,m_bUseUnpredictedPropability);
	ini.WriteInt(INI_UNPREDICTED_PROPABILITY,m_iUnpredictedPropability);
	ini.WriteBool(INI_USE_UNPREDICTED_REASK_DELAY,m_bUseReaskUnpredictedSourcesDelay);
	ini.WriteInt(INI_UNPREDICTED_REASK_DELAY,m_iReaskUnpredictedSourcesDelay);
	ini.WriteInt(INI_UNPREDICTED_REASK_LIMIT,m_iReaskUnpredictedSourcesLimit);

	ini.WriteInt(INI_FAIL_TOLERANCE,m_uFailTolerance);
	ini.WriteInt(INI_MAX_FAIL_TOLERANCE,m_iMaxFailTolerance);
	ini.WriteInt(INI_RETRY_UNREAHABLE,m_uRetryUnreachable);
	ini.WriteInt(INI_RETRY_UNREAHABLE_INTERVALS,m_iRetryUnreachableIntervals);
	ini.WriteInt(INI_UNREACHABLE_REASK_PROPABILITY,m_iUnreachableReaskPropability);
	ini.WriteInt(INI_UNREACHABLE_REASK_LIMIT,m_iReaskUnreachableSourcesLimit);

	ini.WriteBool(INI_HANDLE_TABLE_GAPS,m_bHandleTableGaps);
	ini.WriteFloat(INI_PRIORITY_GAP_RATIO,m_fPriorityGapRatio);
	ini.WriteInt(INI_MAX_GAP_SIZE,m_iMaxGapSize);
	ini.WriteInt(INI_MAX_GAP_TIME,m_iMaxGapTime);
	ini.WriteBool(INI_CHECK_PRIORITY_IP,m_bCheckPriorityIP);
	ini.WriteFloat(INI_PRIORITY_IP_RATIO,m_fPriorityIPRatio);
	ini.WriteBool(INI_CHECK_PORT_INTEGRITY,m_bCheckPortIntegrity);
	ini.WriteFloat(INI_PORT_INTEGRITY_RATIO,m_fPortIntegrityRatio);
	ini.WriteFloat(INI_MAX_MIDLE_DISCREPANCE_HIGH,m_fMaxMidleDiscrepanceHigh);
	ini.WriteFloat(INI_MAX_MIDLE_DISCREPANCE_LOW,m_fMaxMidleDiscrepanceLow);
	ini.WriteInt(INI_LAST_SEEN_DURATION_THRESHOLD,m_iLastSeenDurationThreshold);
	ini.WriteInt(INI_LINK_TIME_PROPABILITY,m_uLinkTimePropability);
	ini.WriteInt(INI_LINK_TIME_THRESHOLD,m_iLinkTimeThreshold);
	ini.WriteBool(INI_USE_DUAL_LINKED_TABLE_GRAVITY,m_bUseDualLinkedTableGravity);
	ini.WriteInt(INI_DUAL_LINKED_TABLE_GRAVITY,m_iDualLinkedTableGravity);
	ini.WriteBool(INI_RELIABLE_TIME_MAGNIFICATION,m_bReliableTimeMagnification);
	ini.WriteInt(INI_MAX_RELIABLE_TIME,m_iMaxReliableTime);
	ini.WriteInt(INI_TEMPORAL_IP_BORDERLINE,m_iTempralIPBorderLine);
#endif // NEO_SA // NEO: NSA END

	// NEO: DS - [DropSources]
	ini.WriteInt(INI_DROP_NNP,m_uDropNnP);
	ini.WriteInt(INI_DROP_NNP_LIMIT,m_iDropNnPLimit);
	ini.WriteInt(INI_DROP_NNP_LIMIT_MODE,m_iDropNnPLimitMode);
	ini.WriteInt(INI_DROP_NNP_TIMER,m_iDropNnPTimer);

	ini.WriteInt(INI_DROP_FULLQ,m_uDropFullQ);
	ini.WriteInt(INI_DROP_FULLQ_LIMIT,m_iDropFullQLimit);
	ini.WriteInt(INI_DROP_FULLQ_LIMIT_MODE,m_iDropFullQLimitMode);
	ini.WriteInt(INI_DROP_FULLQ_TIMER,m_iDropFullQTimer);

	ini.WriteInt(INI_DROP_HIGHQ,m_uDropHighQ);
	ini.WriteInt(INI_DROP_HIGHQ_VALUE,m_iDropHighQValue);
	ini.WriteInt(INI_DROP_HIGHQ_LIMIT,m_iDropHighQLimit);
	ini.WriteInt(INI_DROP_HIGHQ_LIMIT_MODE,m_iDropHighQLimitMode);
	ini.WriteInt(INI_DROP_HIGHQ_TIMER,m_iDropHighQTimer);

	ini.WriteBool(INI_USE_DONT_ASK_THIS_IP,m_bUseDontAskThisIP);
	ini.WriteInt(INI_DONT_ASK_THIS_IP_TIME,m_iDontAskThisIPTime);
	// NEO: DS END

	// NEO: NSD - [NeoSourceDrop]
#ifdef NEO_SK // NEO: NSK - [NeoSourceKeeper]
	ini.WriteBool(INI_DROP_UNREACHABLE,m_bDropUnreachable);
	ini.WriteInt(INI_DROP_UNREACHABLE_LIMIT,m_iDropUnreachableLimit);
	ini.WriteInt(INI_DROP_UNREACHABLE_LIMIT_MODE,m_iDropUnreachableLimitMode);
	ini.WriteInt(INI_DROP_UNREACHABLE_TIMER,m_iDropUnreachableTimer);
#endif // NEO_SK // NEO: NSK END
#ifdef NEO_SS // NEO: NSS - [NeoSourceStorage]
	ini.WriteBool(INI_DROP_OUTOFDATE,m_bDropOutOfDate);
	ini.WriteBool(INI_DROP_OUTOFDATESMOOTH,m_bDropOutOfDateSmooth);
	ini.WriteInt(INI_DROP_OUTOFDATE_FAILS,m_iDropOutOfDateFails);
	ini.WriteInt(INI_DROP_OUTOFDATE_TIME,m_iDropOutOfDateTime);
	ini.WriteInt(INI_DROP_OUTOFDATE_LIMIT,m_iDropOutOfDateLimit);
	ini.WriteInt(INI_DROP_OUTOFDATE_LIMIT_MODE,m_iDropOutOfDateLimitMode);
	ini.WriteInt(INI_DROP_OUTOFDATE_TIMER,m_iDropOutOfDateTimer);
#endif // NEO_SS // NEO: NSS END
#ifdef NEO_SA // NEO: NSA - [NeoSourceAnaliser]
	ini.WriteBool(INI_DROP_RETIRED,m_bDropRetired);
	ini.WriteInt(INI_DROP_RETIRED_LIMIT,m_iDropRetiredLimit);
	ini.WriteInt(INI_DROP_RETIRED_LIMIT_MODE,m_iDropRetiredLimitMode);
	ini.WriteInt(INI_DROP_RETIRED_TIMER,m_iDropRetiredTimer);

	ini.WriteBool(INI_DROP_LOADED,m_bDropLoaded);
	ini.WriteInt(INI_DROP_LOADED_LIMIT,m_iDropLoadedLimit);
	ini.WriteInt(INI_DROP_LOADED_LIMIT_MODE,m_iDropLoadedLimitMode);
	ini.WriteInt(INI_DROP_LOADED_TIMER,m_iDropLoadedTimer);
#endif // NEO_SA // NEO: NSA END
	// NEO: NSD END

	// NEO: NCAP - [NeoCustomAutoPriority]
	ini.WriteBool(INI_DYNAMIC_AUTO_DOWN_PRIORITY,m_bDynamicAutoDownPriority);
	ini.WriteFloat(INI_DYNAMIC_DOWN_PRIORITY_FACTOR,m_fDynamicDownPriorityFactor); 
	ini.WriteInt(INI_LOW_DOWN_PRIO_THRESHOLD,m_iLowDownPrioThreshold); 
	ini.WriteInt(INI_HIGH_DOWN_PRIO_THRESHOLD,m_iHighDownPrioThreshold); 
	// NEO: NCAP END

	ini.WriteInt(INI_PART_TRAFFIC,m_uPartTraffic); // NEO: NPT - [NeoPartTraffic]
	ini.WriteInt(INI_PART_TRSFFIC_COLLOR,m_iPartTrafficColor); // NEO: NPT - [NeoPartTraffic]
	ini.WriteBool(INI_CLASSIC_SHARED_BARS,m_bClassicShareStatusBar);

	ini.WriteBool(INI_SAVE_QUEUE,m_bSaveUploadQueueWaitTime); // NEO: SQ - [SaveUploadQueue]

	// NEO: TQ - [TweakUploadQueue]
	ini.WriteBool(INI_INFINITE_QUEUE,m_bInfiniteQueue);

	ini.WriteInt(INI_QUEUE_OVERFLOW_RELEASE,m_uQueueOverFlowRelease);
	ini.WriteInt(INI_QUEUE_OVERFLOW_SOURCE_LIMIT,m_iQueueOverFlowRelease);

	ini.WriteInt(INI_QUEUE_OVERFLOW_EXTENDED,m_uQueueOverFlowEx);
	ini.WriteInt(INI_QUEUE_OVERFLOW_EXTENDED_LIMIT,m_iQueueOverFlowEx);

	ini.WriteInt(INI_QUEUE_OVERFLOW_DEFAULT,m_uQueueOverFlowDef);
	ini.WriteInt(INI_QUEUE_OVERFLOW_DEFAULT_LIMIT,m_iQueueOverFlowDef);

	ini.WriteInt(INI_QUEUE_OVERFLOW_COMFRIEND,m_uQueueOverFlowCF);
	ini.WriteInt(INI_QUEUE_OVERFLOW_COMFRIEND_LIMIT,m_iQueueOverFlowCF);
	// NEO: TQ END

	ini.WriteBool(INI_MULTI_QUEUE,m_bUseMultiQueue); // NEO: MQ - [MultiQueue]
	ini.WriteBool(INI_RANDOM_QUEUE,m_bUseRandomQueue); // NEO: RQ - [RandomQueue]

	ini.WriteBool(INI_OLD_PRIOSYS,m_bOldPrioritySystem);

	// NEO: NMFS - [NiceMultiFriendSlots]
	ini.WriteBool(INI_FRIEND_SLOT_LIMIT,m_bFriendSlotLimit); 
	ini.WriteInt(INI_FRIEND_SLOT_LIMIT_VALUE,m_iFriendSlotLimit);
	// NEO: NMFS END

	// NEO: RT - [ReleaseTweaks]
	ini.WriteInt(INI_RELEASE_LEVEL,m_iReleaseLevel); 
	ini.WriteInt(INI_RELEASE_MODE,m_iReleaseMode);

	ini.WriteInt(INI_RELEASE_LIMIT_MODE,m_iReleaseLimitMode);
	ini.WriteBool(INI_RELEASE_LIMIT_UNION,m_bReleaseLimitUnion);
	ini.WriteInt(INI_RELEASE_LIMIT_COMPLETE_MODE,m_iReleaseLimitMode);

	ini.WriteInt(INI_RELEASE_LIMIT,m_iReleaseLimit); 
	ini.WriteInt(INI_RELEASE_LIMIT_HIGH,m_iReleaseLimitHigh); 
	ini.WriteInt(INI_RELEASE_LIMIT_LOW,m_iReleaseLimitLow); 

	ini.WriteInt(INI_RELEASE_LIMIT_COMPLETE,m_iReleaseLimitComplete); 
	ini.WriteInt(INI_RELEASE_LIMIT_COMPLETE_HIGH,m_iReleaseLimitCompleteHigh); 
	ini.WriteInt(INI_RELEASE_LIMIT_COMPLETE_LOW,m_iReleaseLimitCompleteLow); 

	ini.WriteBool(INI_LIMIT_UNION,m_bLimitUnion);

	ini.WriteInt(INI_SOURCE_LIMIT_MODE,m_iSourceLimitMode);
	ini.WriteBool(INI_SOURCE_LIMIT_UNION,m_bSourceLimitUnion);
	ini.WriteInt(INI_SOURCE_LIMIT_COMPLETE_MODE,m_iSourceLimitCompleteMode);

	ini.WriteInt(INI_SOURCE_LIMIT,m_iSourceLimit); 
	ini.WriteInt(INI_SOURCE_LIMIT_HIGH,m_iSourceLimitHigh); 
	ini.WriteInt(INI_SOURCE_LIMIT_LOW,m_iSourceLimitLow); 

	ini.WriteInt(INI_SOURCE_COMPLETE_LIMIT,m_iSourceLimitComplete); 
	ini.WriteInt(INI_SOURCE_COMPLETE_LIMIT_HIGH,m_iSourceLimitCompleteHigh); 
	ini.WriteInt(INI_SOURCE_COMPLETE_LIMIT_LOW,m_iSourceLimitCompleteLow); 

	ini.WriteBool(INI_RELEASE_NEED_COMPLETE,m_bReleaseNeedComplete); 
	ini.WriteInt(INI_RELEASE_NEED_COMPLETE_LIMIT,m_iReleaseNeedCompleteLimit); 

	ini.WriteInt(INI_RELEASE_SLOT_LIMIT,m_uReleaseSlotLimit); 
	ini.WriteInt(INI_RELEASE_SLOT_LIMIT_VALUE,m_iReleaseSlotLimit); 

	// NEO: RT END

	// NEO: NCAP - [NeoCustomAutoPriority]
	ini.WriteBool(INI_DYNAMIC_AUTO_UP_PRIORITY,m_bDynamicAutoUpPriority); 
	ini.WriteFloat(INI_DYNAMIC_UP_PRIORITY_FACTOR,m_fDynamicUpPriorityFactor); 
	ini.WriteInt(INI_LOW_UP_PRIO_THRESHOLD,m_iLowUpPrioThreshold); 
	ini.WriteInt(INI_HIGH_UP_PRIO_THRESHOLD,m_iHighUpPrioThreshold); 
	// NEO: NCAP END

	// NEO: PRSF - [PushSmallRareFiles]
	ini.WriteBool(INI_PUSH_SMALL_FILES,m_bPushSmallFiles);
	ini.WriteInt(INI_PUSH_SMALL_FILES_SIZE,m_iPushSmallFilesSize);

	ini.WriteBool(INI_PUSH_RARE_FILES,m_bPushRareFiles);
	ini.WriteInt(INI_PUSH_RARE_FILES_VALUE,m_iPushRareFilesValue);

	ini.WriteBool(INI_PUSH_RATIO_FILES,m_bPushRatioFiles);
	ini.WriteInt(INI_PUSH_RATIO_FILES_VALUE,m_iPushRatioFilesValue);
	// NEO: PRSF END

	ini.WriteBool(INI_USE_NEO_SCORE,m_bNeoScoreSystem); // NEO: NFS - [NeoScoreSystem]
	ini.WriteBool(INI_USE_NEO_CREDIT,m_bNeoCreditSystem); // NEO: NCS - [NeoCreditSystem]
	ini.WriteInt(INI_CREDIT_SYSTEM,m_iOtherCreditSystem); // NEO: OCS - [OtherCreditSystems]

	// NEO: IPS - [InteligentPartSharing]
	ini.WriteBool(INI_IPS_ENABLE,m_bInteligentPartSharing);
	ini.WriteInt(INI_IPS_TIMER,m_iInteligentPartSharingTimer);
	ini.WriteInt(INI_IPS_MAXIMUM,m_iMaxProzentToHide);

	ini.WriteInt(INI_IPS_HIDE_OA,m_iHideOverAvaliblyParts);
	ini.WriteInt(INI_IPS_OA_MODE,m_iHideOverAvaliblyMode);
	ini.WriteFloat(INI_IPS_OA_VALUE,m_fHideOverAvaliblyValue);
	ini.WriteInt(INI_IPS_OA_CATCH,m_iHideOverAvaliblyCatch);

	ini.WriteInt(INI_IPS_HIDE_OS,m_iHideOverSharedParts);
	ini.WriteInt(INI_IPS_OS_MODE,m_iHideOverSharedMode);
	ini.WriteFloat(INI_IPS_OS_VALUE,m_fHideOverSharedValue);
	ini.WriteInt(INI_IPS_OS_CALC,m_iHideOverSharedCalc);
		
	ini.WriteInt(INI_IPS_SHOW_UA,m_iDontHideUnderAvaliblyParts);
	ini.WriteInt(INI_IPS_UA_MODE,m_iDontHideUnderAvaliblyMode);
	ini.WriteFloat(INI_IPS_UA_VALUE,m_fDontHideUnderAvaliblyValue);

	ini.WriteInt(INI_IPS_BLOCK_OA,m_iBlockHighOverAvaliblyParts);
	ini.WriteFloat(INI_IPS_OA_FACTOR,m_fBlockHighOverAvaliblyFactor);

	ini.WriteInt(INI_IPS_BLOCK_OS,m_iBlockHighOverSharedParts);
	ini.WriteFloat(INI_IPS_OS_FACTOR,m_fBlockHighOverSharedFactor);

	ini.WriteInt(INI_IPS_SHOW_ALWAYS_NEEDED,m_iShowAlwaysNeeded);
	ini.WriteInt(INI_IPS_SHOW_ALWAYS_PARTS,m_iShowAlwaysParts);

	ini.WriteInt(INI_IPS_SHOW_ALWAYS_INCOMPLETE,m_iShowAlwaysIncomplete);
	// NEO: IPS END

	ini.WriteString(INI_COMMUNITY,m_sCommunity); // NEO: NC - [NiceCommunity]

#ifdef ARGOS // NEO: NA - [NeoArgos]
	ini.WriteBool(INI_USE_ARGOS_SYSTEM,m_bUseArgosSystem);

	ini.WriteInt(INI_CREDIT_COMPENSATION,m_iCreditCompensation);

	ini.WriteBool(INI_TRUST_UNARGOS_HASH_THIEF,m_bTrustUnArgosHashThief);
	ini.WriteBool(INI_TRUST_UNARGOS_HASH_CHANGED,m_bTrustUnArgosHashChanged);
	ini.WriteBool(INI_TRUST_UNARGOS_GHOST_MODE,m_bTrustUnArgosGhostMode);
	ini.WriteBool(INI_TRUST_UNARGOS_AGRESSIV,m_bTrustUnArgosAgressiv);
	ini.WriteInt(INI_ARGOS_TRUST_TIME,m_iArgosTrustTime);

	ini.WriteInt(INI_CLOSE_MAELLA_BACKDOOR,m_uCloseMaellaBackdoor);

	ini.WriteInt(INI_DONT_BAN_FRIENDS,m_uDontBanFriends);
	ini.WriteInt(INI_DONT_BAN_COMMUNITY,m_uDontBanCommunity);

	ini.WriteInt(INI_ARGOS_PROCESS_TIME,m_iArgosProcessTime);
	ini.WriteInt(INI_ARGOS_TRACK_TIME,m_iArgosTrackTime);
	ini.WriteInt(INI_ARGOS_GENERIC_BAN_TIME,m_iArgosGenericBanTime);
	ini.WriteInt(INI_ARGOS_CORRUPTED_SENDER_TIME,m_iArgosCorruptedSenderTime);
	ini.WriteInt(INI_ARGOS_FILE_SCANNER_TIME,m_iArgosFileScannerTime);
	ini.WriteInt(INI_ARGOS_FILE_FAKER_TIME,m_iArgosFileFakerTime);
	ini.WriteInt(INI_ARGOS_AGRESSION_TIME,m_iArgosAgressionBanTime);
	ini.WriteInt(INI_ARGOS_OPCODE_TIME,m_iArgosOpCodeTime);
	ini.WriteInt(INI_ARGOS_HASH_CHANGED_TIME,m_iArgosHashChangedTime);
	ini.WriteInt(INI_ARGOS_RANK_FLOODER_TIME,m_iArgosRankFlooderTime);
	ini.WriteInt(INI_ARGOS_GHOST_MODE_TIME,m_iArgosGhostModeTime);	
	ini.WriteInt(INI_ARGOS_FAILED_TIME,m_iArgosFailedTime);	
	ini.WriteInt(INI_ARGOS_XS_EXPLOIT_TIME,m_iArgosXSExploitTime);
	ini.WriteInt(INI_ARGOS_NICK_CHANGER_TIME,m_iArgosNickChangerTime);
	ini.WriteInt(INI_ARGOS_MOD_CHANGER_TIME,m_iArgosModChangerTime);
	ini.WriteInt(INI_ARGOS_SPAMTIME_TIME,m_iArgosSpamTime);
	ini.WriteInt(INI_ARGOS_BAD_HELLO_TIME,m_iArgosBadHelloTime);
	ini.WriteInt(INI_ARGOS_BAD_PROT_TIME,m_iArgosBadProtTime);

	ini.WriteInt(INI_ARGOS_GPL_BREAKER_PUNISHMENT,m_iArgosGPLBreakerPunishment);
	ini.WriteInt(INI_ARGOS_HARD_LEECHER_PUNISHMENT,m_iArgosHardLeecherPunishment);
	ini.WriteInt(INI_ARGOS_NORMAL_LEECHER_PUNISHMENT,m_iArgosNormalLeecherPunishment);
	ini.WriteInt(INI_ARGOS_SOFT_LEECHER_PUNISHMENT,m_iArgosSoftLeecherPunishment);
	ini.WriteInt(INI_ARGOS_BAD_MOD_PUNISHMENT,m_iArgosBadModPunishment);
	ini.WriteInt(INI_ARGOS_NICK_THIEF_PUNISHMENT,m_iArgosNickThiefPunishment);
	ini.WriteInt(INI_ARGOS_MOD_THIEF_PUNISHMENT,m_iArgosModThiefPunishment);
	ini.WriteInt(INI_ARGOS_HASH_THIEF_PUNISHMENT,m_iArgosHashThiefPunishment);
	ini.WriteInt(INI_ARGOS_CREDIT_HACK_PUNISHMENT,m_iArgosCreditHackPunishment);
	ini.WriteInt(INI_ARGOS_HASH_CHANGED_PUNISHMENT,m_iArgosHashChangedPunishment);
	ini.WriteInt(INI_ARGOS_GHOST_MODE_PUNISHMENT,m_iArgosGhostModePunishment);
	ini.WriteInt(INI_ARGOS_FAKE_CLIENT_PUNISHMENT,m_iArgosFakeClientPunishment);
	ini.WriteInt(INI_ARGOS_AGRESSON_PUNISHMENT,m_iArgosAgressonPunishment);
	ini.WriteInt(INI_ARGOS_FILE_SCANNER_PUNISHMENT,m_iArgosFileScannerPunishment);
	ini.WriteInt(INI_ARGOS_FILE_FAKER_PUNISHMENT,m_iArgosFileFakerPunishment);
	ini.WriteInt(INI_ARGOS_CORRUPTED_SENDER_PUNISHMENT,m_iArgosCorruptedSenderPunishment);
	ini.WriteInt(INI_ARGOS_RANK_FLOODER_PUNISHMENT,m_iArgosRankFlooderPunishment);
	ini.WriteInt(INI_ARGOS_FAILED_PUNISHMENT,m_iArgosFailedPunishment);
	ini.WriteInt(INI_ARGOS_XS_EXPLOIT_PUNISHMENT,m_iArgosXSExploitPunishment);
	ini.WriteInt(INI_ARGOS_NICK_CHANGER_PUNISHMENT,m_iArgosNickChangerPunishment);
	ini.WriteInt(INI_ARGOS_MOD_CHANGER_PUNISHMENT,m_iArgosModChangerPunishment);
	ini.WriteInt(INI_ARGOS_SPAM_PUNISHMENT,m_iArgosSpamPunishment);
	ini.WriteInt(INI_ARGOS_BAD_HELLO_PUNISHMENT,m_iArgosBadHelloPunishment);
	ini.WriteInt(INI_ARGOS_BAD_PROT_PUNISHMENT,m_iArgosBadProtPunishment);

	ini.WriteBool(INI_ARGOS_LEECHER_MOD_DETECTION,m_bArgosLeecherModDetection);
	ini.WriteInt(INI_ARGOS_LEECHER_NICK_DETECTION,m_uArgosLeecherNickDetection);
	ini.WriteInt(INI_ARGOS_DETECTION_LEVEL,m_iArgosDetectionLevel);
	ini.WriteBool(INI_ARGOS_OPCODE_DETECTION,m_bArgosOpcodeDetection);
	ini.WriteBool(INI_ARGOS_LEECHER_HASH_DETECTION,m_bArgosLeecherHashDetection);
	ini.WriteBool(INI_ARGOS_NICK_THIEF_DETECTION,m_bArgosNickThiefDetection);
	ini.WriteBool(INI_PLAIN_ANTI_NICKT_HIEF,m_bPlainAntiNickThief);
	ini.WriteBool(INI_ARGOS_MOD_THIEF_DETECTION,m_bArgosModThiefDetection);
	ini.WriteBool(INI_ARGOS_HASH_THIEF_DETECTION,m_bArgosHashThiefDetection);
	ini.WriteBool(INI_ARGOS_THIEF_ZONE_DETECTION,m_bArgosThiefZoneDetection);
	ini.WriteBool(INI_ARGOS_CREDIT_HACK_DETECTION,m_bArgosCreditHackDetection);
	ini.WriteBool(INI_HASH_CHANGE_DETECTION,m_bHashChangeDetection);
	ini.WriteInt(INI_HASH_CHANGE_DETECTION_MODE,m_iHashChangeDetectionMode);
	ini.WriteBool(INI_ARGOS_GHOST_MOD_DETECTION,m_bArgosGhostModDetection);
	ini.WriteInt(INI_ARGOS_FAKE_CLIENT_DETECTION,m_uArgosFakeClientDetection);
	ini.WriteInt(INI_AGRESSION_DETECTION,m_uAgressionDetection);
	ini.WriteInt(INI_AGRESSION_TIME,m_iAgressionIntervals);
	ini.WriteInt(INI_AGRESSION_THRESHOLD,m_iAgressionThreshold);
	ini.WriteBool(INI_FILE_SCANNER_DETECTION,m_bFileScannerDetection);
	ini.WriteBool(INI_FILE_FAKER_DETECTION,m_bFileFakerDetection);
	ini.WriteBool(INI_BAD_SENDER_DETECTION,m_bBadSenderDetection);
	ini.WriteBool(INI_RANK_FLOOD_DETECTION,m_bRankFloodDetection);
	ini.WriteBool(INI_FAILED_DETECTION,m_bFailedDetection);
	ini.WriteInt(INI_FAILED_TRIES,m_iFailedTries);
	ini.WriteInt(INI_FAILED_THRESHOLD,m_iFailedThreshold);
	ini.WriteBool(INI_XS_EXPLOIT_DETECTION,m_bXSExploitDetection);
	ini.WriteInt(INI_XS_EXPLOIT_INTERVALS,m_iXSExploitIntervals);
	ini.WriteInt(INI_XS_EXPLOIT_THRESHOLD,m_iXSExploitThreshold);
	ini.WriteBool(INI_NICK_CHANGER_DETECTION,m_bNickChangerDetection);
	ini.WriteInt(INI_NICK_CHANGE_INTERVALS,m_iNickChangeIntervals);
	ini.WriteInt(INI_NICK_CHANGE_THRESHOLD,m_iNickChangeThreshold);
	ini.WriteBool(INI_MOD_CHANGER_DETECTION,m_bModChangerDetection);
	ini.WriteInt(INI_MOD_CHANGE_INTERVALS,m_iModChangeIntervals);
	ini.WriteInt(INI_MOD_CHANGE_THRESHOLD,m_iModChangeThreshold);
	ini.WriteBool(INI_SPAM_DETECTION,m_bSpamDetection);
	ini.WriteBool(INI_BAD_HELLO_DETECTION,m_bBadHelloDetection);
	//ini.WriteBool(INI_MD4_HELLO_DETECTION,m_bMD4HelloDetection);
	ini.WriteInt(INI_EMCRYPT_DETECTION,m_ueMCryptDetection);
	ini.WriteBool(INI_BAD_PROT_DETECTION,m_bBadProtDetection);
	ini.WriteInt(INI_DLP_DETECTION,m_uDLPDetection);

	ini.WriteBool(INI_ARGOS_LOG_LEECHERS,m_bArgosLogLeechers);
#endif // ARGOS // NEO: NA END

	ini.WriteBool(INI_USE_CHUNK_DOTS, m_bUseChunkDots); // NEO: MOD - [ChunkDots]
	ini.WriteBool(INI_USE_RELATIVE_CHUNK_DISPLAY, m_bUseRelativeChunkDisplay); // NEO: MOD - [RelativeChunkDisplay]
	ini.WriteBool(INI_USE_TREES_TYLE, m_bUseTreeStyle); // NEO: NTS - [NeoTreeStyle]
	ini.WriteBool(INI_SHOW_FILE_TYPE_ICON, m_bShowFileTypeIcon); // NEO: NI - [NewIcons]
	ini.WriteBool(INI_SHOW_FILE_STATUS_ICON, m_bShowFileStatusIcons); // NEO: FSI - [FileStatusIcons]
	ini.WriteBool(INI_COLLOR_SHARE_FILES, m_bCollorShareFiles);
	ini.WriteBool(INI_SHOW_BANNER, m_bShowBanner);
	ini.WriteBool(INI_SHOW_HASH_PROGRES, m_bShowHashProgres);
	ini.WriteInt(INI_USE_PLUS_SPEEDMETER, m_uUsePlusSpeedMeter); // NEO: PSM - [PlusSpeedMeter]
	// NEO: NSTI - [NewSystemTrayIcon]
	ini.WriteBool(INI_SHOW_SYSTEM_TRAY_UPLOAD, m_bShowSystemTrayUpload);
	ini.WriteBool(INI_THIN_SYSTEM_TRAY_BARS, m_bThinSystemTrayBars);
	ini.WriteInt(INI_TRAY_BARS_MAX_COLLOR, m_iTrayBarsMaxCollor);
	// NEO: NSTI END
	ini.WriteBool(INI_STATIC_TRAY_ICON, m_bStaticTrayIcon); // NEO: STI - [StaticTray]
	ini.WriteInt(INI_DISABLE_AUTO_SORT, m_uDisableAutoSort); // NEO: SE - [SortExtension]
	ini.WriteInt(INI_SHOW_CLIENT_PERCENTAGE, m_uShowClientPercentage); // NEO: MOD - [Percentage]

	// NEO: SI - [SysInfo]
	ini.WriteBool(INI_SYS_INFO_GRAPH, m_bDrawSysInfoGraph);
	ini.WriteBool(INI_SYS_INFO_TITLE, m_bShowSysInfoOnTitle);
	// NEO: SI END

	// NEO: NTB - [NeoToolbarButtons]
	ini.WriteInt(INI_NEO_TOOLBAR, m_uNeoToolbar);
	m_iNeoToolbarButtonCount = m_NeoToolbarButtons.GetCount(); 
	ini.WriteInt(INI_NEO_TOOLBAR_BUTTONS, m_iNeoToolbarButtonCount);
	for (int i=0; i<m_iNeoToolbarButtonCount; i++)
		ini.WriteInt(StrLine(L"%s_%u",INI_NEO_TOOLBAR_BUTTON,i), m_NeoToolbarButtons[i]);
	// NEO: NTB END

	// NEO: CTB - [CoolToolBar]
	ini.WriteBool(INI_USE_COOL_TOOLBAR, m_bCoolToolbar);
	ini.WriteInt(INI_USE_COOL_TOOLBAR_TEXT, m_uCoolToolbarText); 
	ini.WriteInt(INI_COOL_TOOLBAR_CENTER, m_iCoolToolbarCenter); 
	ini.WriteInt(INI_COOL_TOOLBAR_RIGHT, m_iCoolToolbarRight); 
	m_iCoolToolbarButtonCount = m_CoolToolbarButtons.GetCount(); 
	ini.WriteInt(INI_COOL_TOOLBAR_BUTTONS, m_iCoolToolbarButtonCount);
	for (int i=0; i<m_iCoolToolbarButtonCount; i++)
		ini.WriteInt(StrLine(L"%s_%u",INI_COOL_TOOLBAR_BUTTON,i), m_CoolToolbarButtons[i]);
	// NEO: CTB END

	// NEO: NMX - [NeoMenuXP]
	ini.WriteBool(INI_SHOW_XP_SIDEBAR, m_bShowXPSideBar);
	ini.WriteBool(INI_SHOW_XP_BITMAP, m_bShowXPBitmap);
	ini.WriteInt(INI_XP_MENU_STYLE, m_iXPMenuStyle);
	ini.WriteBool(INI_GRAY_MENU_ICON, m_bGrayMenuIcon);
	// NEO: NMX END 

	// NEO: MM - [NeoMiniMule]
	ini.WriteBool(INI_ENABLE_MINIMULE, m_bEnableMiniMule);
	ini.WriteBool(INI_AUTO_MINIMULE, m_bAutoShowMiniMule);
	ini.WriteBool(INI_MINIMULE_ONTOP, m_bMiniMuleOnTop);
	ini.WriteBool(INI_MINIMULE_UPDATE, m_bUpdateHidenMiniMule);
	ini.WriteInt(INI_MINIMULE_TRANSPARENCY, m_uMiniMuleTransparency);
	ini.WriteBool(INI_MINIMULE_BACKGROUND, m_bMiniMuleBack);
	ini.WriteString(INI_MINIMULE_LABEL, m_sMiniMuleLabel);
	// NEO: MM END

	// NEO: IM - [InvisibelMode]
	ini.WriteBool(INI_INVISIBLEMODE_ENABLE, m_bInvisibleMode);
	ini.WriteString(INI_INVISIBLEMODE_KEY, CString(m_cInvisibleModeHotKey));
	ini.WriteInt(INI_INVISIBLEMODE_KEY_MOD, m_iInvisibleModeHotKeyModifier);
	// NEO: IM END

	// NEO: TPP - [TrayPasswordProtection]
	ini.WriteBool(INI_TRAY_PASSWORD_PROTECTION, m_bTrayPasswordProtection);
	ini.WriteString(INI_TRAY_PASSWORD, m_sTrayPassword);
	// NEO: TPP END

	ini.WriteBool(INI_SHOW_MY_FULL_INFO, m_bShowMyFullInfo);

	ini.WriteBool(INI_SMOOTH_STATISTICS_GRAPHS, m_bSmoothStatisticsGraphs);

	// NEO: MMR - [MorphMassRemane]
	ini.WriteInt (INI_SIMPLE_CLEANUP_OPTIONS,m_SimpleCleanupOptions);
	// Enclose the strings with '"' before writing them to the file.
	// These will be filtered if the string is read again
	ini.WriteString (INI_SIMPLE_CLEANUP_SEARCH,CString ('\"')+m_SimpleCleanupSearch+('\"'));
	ini.WriteString (INI_SIMPLE_CLEANUP_REPLACE,CString ('\"')+m_SimpleCleanupReplace+('\"'));
	ini.WriteString (INI_SIMPLE_CLEANUP_SEARCH_CHARS,CString ('\"')+m_SimpleCleanupSearchChars+('\"'));
	ini.WriteString (INI_SIMPLE_CLEANUP_REPLACE_CHARS,CString ('\"')+m_SimpleCleanupReplaceChars+('\"'));
	// NEO: MMR END

	// NEO: CRC - [MorphCRCTag] -- Xanatos -->
	ini.WriteBool (INI_DONT_ADD_CRC32_TO_FILENAME,m_bDontAddCRCToFilename);
	ini.WriteBool (INI_FORCE_CRC32_UPPERCASE,m_bCRC32ForceUppercase);
	ini.WriteBool (INI_FORCE_CRC32_ADDING,m_bCRC32ForceAdding);
	ini.WriteString (INI_LAST_CRC32_PREFIX,('\"')+m_sCRC32Prefix+('\"'));
	ini.WriteString (INI_LAST_CRC32_SUFFIX,('\"')+m_sCRC32Suffix+('\"'));
	// NEO: CRC END <-- Xanatos --

	ini.WriteInt(INI_MAX_UL_SLOTS,m_iMaxUploadSlots);
	ini.WriteInt(INI_MIN_UL_SLOTS,m_iMinUploadSlots);
	ini.WriteFloat(INI_UL_PER_SLOTS,m_fUploadPerSlots);

	// NEO: QS - [QuickStart]
	ini.WriteInt(INI_USE_QUICK_START, m_uQuickStart);
	ini.WriteUInt32(INI_QUICK_START_TIME, m_iQuickStartTime);
	ini.WriteUInt32(INI_QUICK_START_TIME_PF, m_iQuickStartTimePerFile);

	ini.WriteInt(INI_QUICK_START_MAX_CON_PER, m_iQuickMaxConperFive);
	ini.WriteInt(INI_QUICK_START_MAX_HALF_CON, m_iQuickMaxHalfOpen);
	ini.WriteInt(INI_QUICK_START_MAX_CON, m_iQuickMaxConnections);
	// NEO: QS END

	// NEO: RIC - [ReaskOnIDChange]
	ini.WriteInt(INI_CHECK_ID_CHANGE, m_uCheckIPChange);
	ini.WriteBool(INI_INFORM_ON_ID_CHANGE, m_bInformOnIPChange);
	ini.WriteBool(INI_REASK_ON_ID_CHANGE, m_bReAskOnIPChange);
	ini.WriteBool(INI_QUICK_START_ON_ID_CHANGE, m_bQuickStartOnIPChange); // NEO: QS - [QuickStart]
	ini.WriteBool(INI_CHECK_L2H_ID_CHANGE, m_bCheckL2HIDChange);
	ini.WriteBool(INI_RECONNECTKAD_ON_ID_CHANGE, m_bReconnectKadOnIPChange);
	ini.WriteBool(INI_REBIND_SOCKETS_ON_IP_CHANGE, m_bRebindSocketsOnIPChange);
	// NEO: RIC END

	// NEO: RKF - [RecheckKadFirewalled]
	ini.WriteBool(INI_RECHECK_KAD_FIREWALLED, m_bRecheckKadFirewalled);
	ini.WriteInt(INI_RECHECK_KAD_FIREWALLED_TIME, m_iRecheckKadFirewalled);
	// NEO: RKF END

	// NEO: RLD - [ReconnectOnLowID]
	ini.WriteBool(INI_RECONNECT_ON_LOWID, m_bReConnectOnLowID);
	ini.WriteInt(INI_RECONNECT_ON_LOWID_TRYS, m_iReConnectOnLowID); 
	// NEO: RLD END

#ifdef LANCAST // NEO: NLC - [NeoLanCast]
	ini.WriteBool(INI_LANCAST_ENABLED, m_bLancastEnabled);

	ini.WriteInt(INI_MAX_LAN_DOWNLOAD, m_iMaxLanDownload); 
	ini.WriteBool(INI_DIRECT_LAN_DOWNLOAD, m_bDirectLanDownload);
	ini.WriteBool(INI_SET_LAN_DOWNLOAD_BUFFER, m_bSetLanDownloadBuffer);
	ini.WriteInt(INI_LAN_DOWNLOAD_BUFFER_SIZE, m_iLanDownloadBufferSize); 

	ini.WriteInt(INI_MAX_LAN_UPLOAD, m_iMaxLanUpload); 
	ini.WriteBool(INI_DIRECT_LAN_UPLOAD, m_bDirectLanUpload);
	ini.WriteBool(INI_SET_LAN_UPLOAD_BUFFER, m_bSetLanUploadBuffer);
	ini.WriteInt(INI_LAN_UPLOAD_BUFFER_SIZE, m_iLanUploadBufferSize); 

	ini.WriteInt(INI_MAX_LAN_UPLOAD_SLOTS, m_iMaxLanUploadSlots); 

	ini.WriteBool(INI_CUSTOMIZED_LANCAST, m_bCustomizedLanCast);
	ini.WriteString(INI_LANCAST_GROUP, m_sLanCastGroup);
	ini.WriteInt(INI_LANCAST_PORT, m_uLanCastPort);

	ini.WriteBool(INI_CUSTOM_LANCAST_ADAPTER, m_bCustomLanCastAdapter);
	ini.WriteInt(INI_LANCAST_ADAPTER_IPADRESS, m_uLanCastAdapterIPAdress);
	ini.WriteInt(INI_LANCAST_ADAPTER_SUBNET, m_uLanCastAdapterSubNet);

	ini.WriteInt(INI_LANINTERVALS, m_iLANIntervals); 

	ini.WriteInt(INI_LAN_REASK_INTERVALS, m_iLanReaskIntervals); 
	ini.WriteInt(INI_NNP_LAN_REASK_INTERVALS, m_iNnPLanReaskIntervals); 

	ini.WriteBool(INI_AUTO_BROADCAST_LAN_FILES, m_bAutoBroadcastLanFiles);
	ini.WriteInt(INI_AUTO_BROADCAST_LAN_FILES_TIMER, m_iAutoBroadcastLanFiles); 

	ini.WriteBool(INI_USE_LAN_MULTI_TRANSFER, m_bUseLanMultiTransfer);
#endif //LANCAST // NEO: NLC END

#ifdef VOODOO // NEO: VOODOO - [UniversalPartfileInterface]
	ini.WriteBool(INI_USE_VOODOO_TRANSFER, m_bUseVoodooTransfer);
	ini.WriteBool(INI_SLAVE_ALLOWED, m_bSlaveAllowed);
	ini.WriteBool(INI_SLAVE_HOSTING, m_bSlaveHosting);

	ini.WriteString(INI_VOODOO_SPELL,m_sVoodooSpell);
	ini.WriteInt(INI_VOODOO_PORT, m_nVoodooPort); 

	ini.WriteInt(INI_AUTO_CONNECT_VOODOO, m_uAutoConnectVoodoo);

	ini.WriteInt(INI_USE_VIRTUAL_VOODOO_FILES, m_uUseVirtualVoodooFiles);
	ini.WriteBool(INI_HIDE_VOODOO_FILES, m_bHideVoodooFiles);

	ini.WriteInt(INI_USE_VOODOO_SOURCE_EXCHANGE, m_uUseVoodooSourceExchange);

	ini.WriteBool(INI_USE_VOODOO_SEARCH, m_bUseVoodooSearch);

	ini.WriteBool(INI_VOODOO_NEO_COMMANDS, m_bVoodooNeoCommands);
	ini.WriteBool(INI_VOODOO_NEO_PREFERENCES, m_bVoodooNeoPreferences);

	ini.WriteInt(INI_VOODOOCAST_ENABLED, m_uVoodooCastEnabled);

	ini.WriteInt(INI_SEARCH_FOR_SLAVES, m_uSearchForSlaves); 
	ini.WriteInt(INI_SEARCH_FOR_MASTER, m_uSearchForMaster); 
	ini.WriteInt(INI_VOODOO_SEARCH_INTERVALS, m_iVoodooSearchIntervals); 
#endif // VOODOO // NEO: VOODOO END

#ifdef A4AF_CATS // NEO: MAC - [MorphA4AFCategories]
	ini.WriteBool(INI_SHOW_CAT_NAME, m_bShowCatNames);
	ini.WriteInt(INI_SHOW_CAT_FLAGS, m_uShowCategoryFlags);
	ini.WriteBool(INI_ACTIVE_CAT_DEFAULT, m_bActiveCatDefault);
	ini.WriteBool(INI_SEL_CAT_ON_ADD, m_bSelCatOnAdd);
	ini.WriteBool(INI_AUTO_SET_RESUME_ORDER, m_bAutoSetResumeOrder);
	ini.WriteBool(INI_SMALL_FILE_DL_PUSH, m_bSmallFileDLPush);
	ini.WriteInt(INI_SMALL_FILE_DL_PUSH_VAL, m_iSmallFileDLPush);
	ini.WriteBool(INI_START_DL_IN_EMPTY_CATS, m_bStartDLInEmptyCats);
	ini.WriteInt(INI_START_DL_IN_EMPTY_CATS_AMOUNT, m_iStartDLInEmptyCats);
	ini.WriteBool(INI_USE_AUTO_CAT, m_bUseAutoCat);
	ini.WriteBool(INI_CHECK_ALREADY_DOWNLOADED, m_bCheckAlreadyDownloaded);

	ini.WriteBool(INI_START_NEXT_FILE_BY_PRIORITY, m_bStartNextFileByPriority);

	ini.WriteBool(INI_SMART_A4AF_SWAPPING, m_bSmartA4AFSwapping);
	ini.WriteInt(INI_ADVANCED_A4AF_MODE, m_iAdvancedA4AFMode);
#endif // A4AF_CATS // NEO: MAC END

	ini.WriteInt(INI_USE_LUGDUNUM_CREDITS, m_uUseLugdunumCredits); // NEO: KLC - [KhaosLugdunumCredits]
	ini.WriteBool(INI_PREFER_SHARE_ALL, m_bPreferShareAll); // NEO: PSA - [PreferShareAll]
	// NEO: ASF - [AdvancedServerFilter]
	ini.WriteBool(INI_DONT_REMOVE_STATIC_SERVERS, m_bDontRemoveStaticServers);
	ini.WriteBool(INI_SERVER_FILTER_AUTO_DEL, m_bServerFilterAutoDel);
	ini.WriteInt(INI_SERVER_FILTER, m_iServerFilter);
	ini.WriteString(INI_SERVER_FILTER_VAL, m_sServerFilterVal);
	ini.WriteBool(INI_SERVER_FILTER_DATALESS, m_bServerFilterDataless);
	// NEO: ASF END

#ifdef IP2COUNTRY // NEO: IP2C - [IP2Country]
	ini.WriteInt(INI_IP2COUNTRY_NAME_MODE, m_iIP2CountryNameMode);
	ini.WriteInt(INI_IP2COUNTRY_SHOW_FLAG, m_uIP2CountryShowFlag);
#endif // IP2COUNTRY // NEO: IP2C END

	ini.WriteBool(INI_USE_FAKE_CHECK, m_bUseFakeCheck); // NEO: FC - [FakeCheck]

	// NEO: FDC - [FileNameDisparityCheck]
	ini.WriteBool(INI_USE_FILE_CHECK, m_bUseFileCheck);
	ini.WriteInt(INI_FILE_CHECK_SENSITIVITY, m_iFileCheckSensitivity);
	ini.WriteBool(INI_USE_FILE_CHECK_THRESHOLD, m_bUseFileCheckThreshold);
	ini.WriteInt(INI_FILE_CHECK_THRESHOLD, m_iFileCheckThreshold);
	ini.WriteInt(INI_FILE_CHECK_AMOUNT, m_iFileCheckAmount);
	// NEO: FDC END

	// NEO: FN - [FunnyNick]
	ini.WriteBool(INI_USE_FUNNY_NICK, m_bUseFunnyNick);
	ini.WriteString(INI_FUNNY_NICK_FILTER,m_sFunnyNickFilter);
	ini.WriteString(INI_FUNNY_NICK_SYMBOL,StrLine(L"'%s'", m_sFunnyNickSymbol));
	// NEO: FN END

	// NEO: AU - [AutoUpdate]
	ini.WriteBool(INI_AUTO_RUNTIME_UPDATE, m_bAutoRuntimeUpdate);
	ini.WriteInt(INI_RUNTIME_UPDATE_INTERVALS, m_iRuntimeUpdateIntervals);

	ini.WriteString(INI_UPDATE_URL_IP_FILTER,m_sUpdateURLIPFilter);
	ini.WriteBool(INI_AUTO_UPDATE_IP_FILTER,m_bAutoUpdateIPFilter);
	ini.WriteBinary(INI_IP_FILTER_VERSION, (LPBYTE)&m_IPFilterVersion, sizeof(m_IPFilterVersion));

#ifdef ARGOS // NEO: NA - [NeoArgos]
	ini.WriteString(INI_UPDATE_URL_LEECHERS_LIST,m_sUpdateURLLeechersList);
	ini.WriteBool(INI_UPDATE_LEECHERS_STARTUP,m_bUpdateLeechersStartup);
	ini.WriteBinary(INI_LEECHERS_VERSION, (LPBYTE)&m_LeechersVersion, sizeof(m_LeechersVersion));
#endif // ARGOS // NEO: NA END

#ifdef IP2COUNTRY // NEO: IP2C - [IP2Country]
	ini.WriteString(INI_UPDATE_URL_IP2_COUNTRY,m_sUpdateURLIP2Country);
	ini.WriteBool(INI_AUTO_UPDATE_IP2_COUNTRY,m_bAutoUpdateIP2Country);
	ini.WriteBinary(INI_IP2_COUNTRY_VERSION, (LPBYTE)&m_IP2CountryVersion, sizeof(m_IP2CountryVersion));
#endif // IP2COUNTRY // NEO: IP2C END

	// NEO: FC - [FakeCheck]
	ini.WriteString(INI_UPDATE_URL_FAKE_LIST,m_sUpdateURLFakeList);
	ini.WriteBool(INI_UPDATE_FAKE_STARTUP,m_bUpdateFakeStartup);
	ini.WriteBinary(INI_FAKES_VERSION, (LPBYTE)&m_FakesVersion, sizeof(m_FakesVersion));
	// NEO: FC END
	// NEO: AU END

	// NEO: IFWS - [ICSFirewall]
	ini.WriteInt(INI_ICF_SUPPORT, m_uICFSupport);
	ini.WriteBool(INI_ICF_CLEAR_ON_CLOSE, m_bICFClearOnClose);
	// NEO: IFWS END

	// NEO: UPNP - [UPnPNat]
	ini.WriteInt(INI_UPNP_NAT, m_uUPnPNat);
	ini.WriteBool(INI_UPNP_CLEAR_ON_CLOSE, m_bUPnPClearOnClose);
	ini.WriteBool(INI_UPNP_TRY_RANDOM, m_bUPnPTryRandom);
	// NEO: UPNP END

	// NEO: NATS - [NatSupport]
	ini.WriteBool(INI_NAT_SUPPORT_ENABLED, m_bNATSupportEnabled);
	ini.WriteFloat(INI_NAT_PORT_REFRESH_IVTERVAL, m_fNATPortRefreshIvterval);
	ini.WriteInt(INI_NAT_PORT_MAX_LATENCY_TIME, m_iNATPortMaxLatencyTime);
	ini.WriteInt(INI_NAT_PORT_MAX_FAILS, m_iNATPortMaxFails);
	ini.WriteBool(INI_NAT_PORT_FAST_REFRESH, m_bNATPortFastRefresh);

#ifdef NATTUNNELING // NEO: NATT - [NatTraversal]
	ini.WriteBool(INI_NAT_PORT_RELAIABLE, m_bNATPortRelaiable);
	ini.WriteBool(INI_NAT_TRAVERSAL_ENABLED, m_bNATTraversalEnabled);
	ini.WriteBool(INI_DONT_TRUST_NAT_PORTS, m_bDontTrustNatPorts);
	ini.WriteInt(INI_NAT_TYPE, m_iNatCharacteristic);
	ini.WriteInt(INI_LOWID_UPLAOD_CALLBACK,m_uLowIDUplaodCallBack); // NEO: LUC - [LowIDUplaodCallBack]
#endif //NATTUNNELING // NEO: NATT END
	ini.WriteInt(INI_RE_USE_TCP_PORT, m_uReuseTCPPort);
	// NEO: NATS END

#ifdef WEBCACHE // NEO: WC - [WebCache]
	ini.WriteString(INI_WEBCACHE_NAME, webcacheName);
	ini.WriteInt(INI_WEBCACHE_PORT,webcachePort);
	ini.WriteInt(INI_WEBCACHE_BLOCK_LIMIT,webcacheBlockLimit);	
	ini.WriteBool(INI_WEBCACHE_EXTRA_TIMEOUT,webcacheExtraTimeout);	
	ini.WriteBool(INI_PERSISTENT_CONNECTIONS_FOR_PROXY_DOWNLOADS, PersistentConnectionsForProxyDownloads);
	ini.WriteBool(INI_WCAUTO_UPDATE, WCAutoupdate);
	ini.WriteBool(INI_WEBCACHE_CACHESLOCAL_TRAFFIC, webcacheCachesLocalTraffic);
	ini.WriteInt(INI_WEBCACHE_ENABLED, webcacheEnabled); //webcache disabled on first start so webcache detection on start gets called.
	ini.WriteBool(INI_WEBCACHE_LIMITLES, webcacheLimitles);
	ini.WriteBool(INI_DETECT_WEBCACHE_ON_START, detectWebcacheOnStart); // jp detect webcache on startup
	ini.WriteUInt64(INI_WEBCACHE_LAST_SEARCH,(uint64)webcacheLastSearch);
	ini.WriteUInt64(INI_WEBCACHE_LAST_GLOBAL_IP,(uint64)webcacheLastGlobalIP);
	ini.WriteString(INI_WEBCACHE_LAST_RESOLVED_NAME,webcacheLastResolvedName);
	ini.WriteUInt64(INI_WEBCACHE_TRUST_LEVEL,(uint64)webcacheTrustLevel);
	ini.WriteBool(INI_LOG_WEB_CACHE_EVENTS, m_bLogWebCacheEvents);
	//ini.WriteBool(INI_WEB_CACHE_SHOW, m_bWebCacheShow);
#endif // NEO: WC END
}

#ifdef LANCAST // NEO: NLC - [NeoLanCast]
CString CPreferencesEx::GetLanCastGroup()
{ 
	return (IsCustomizedLanCast() ? m_sLanCastGroup : LANCAST_GROUP); 
}
uint16 CPreferencesEx::GetLanCastPort()
{ 
	return (IsCustomizedLanCast() ? m_uLanCastPort : LANCAST_PORT); 
}
#endif //LANCAST // NEO: NLC END

// NEO: NATS - [NatSupport]
void CPreferencesEx::PerformUDPPortPing(bool bForceBuddy, bool bKad)
{
	thePrefs.SetUDPPingPending(true, bKad);

	if(bForceBuddy == false && thePrefs.IsNATPortFastRefresh())
	{
		// When we already have our port than we can refresh the nat state by pinging it ourselvs
		// this way we save some overhead of our buddy

		CSafeMemFile data(128);

		data.WriteUInt32(bKad ? 'KAD' : 'UDP'); // NEO: KAX - [KadAuxPort] // this is only needed if we have more than one UDP spcket

		Packet* packet = new Packet(&data, OP_MODPROT);
		packet->opcode = OP_UDP_PORTTEST;

		// NEO: KAX - [KadAuxPort]
		if(bKad)
			theApp.clientkad->SendPacket(packet, theApp.GetPublicIP(), GetKADPort(), false, NULL); // it does not mateer on whitch socket we recive the packet only what socket send it ir relevant
		else
		// NEO: KAX END
			theApp.clientudp->SendPacket(packet, theApp.GetPublicIP(), GetUDPPort(), false, NULL);
	}
	else
	{
		// We use our buddy to estimete our extern IP and Port
		// when he sends us a packet comming form us he will tell us the IP and Port he saw

		CSafeMemFile data(128);

		// write own buddyID
		Kademlia::CUInt128 uBuddyID(true);
		uBuddyID.Xor(Kademlia::CKademlia::GetPrefs()->GetKadID());
		byte cID[16];
		uBuddyID.ToByteArray(cID);
		data.WriteHash16(cID); // my kad id

		// Since here all datas are pased unparsed to the buddy (us)
		uchar hash[16]; md4clr(&hash[0]);
		data.WriteHash16(&hash[0]); // a invalid NULL indicates this is a Mod Prot Packet, not a file reask

		// write mod opcode
		data.WriteUInt8(OP_UDP_PORTTEST);

		data.WriteUInt32(bKad ? 'KAD' : 'UDP'); // NEO: KAX - [KadAuxPort] // this is only needed if we have more than one UDP spcket

		// send packet over buddy
		Packet* packet = new Packet(&data, OP_EMULEPROT);
		packet->opcode = OP_REASKCALLBACKUDP;

		// NEO: KAX - [KadAuxPort]
		if(bKad)
			theApp.clientkad->SendPacket(packet, theApp.clientlist->GetBuddy()->GetIP(), theApp.clientlist->GetBuddy()->GetUDPPort(), false, NULL);
		else
		// NEO: KAX END
			theApp.clientudp->SendPacket(packet, theApp.clientlist->GetBuddy()->GetIP(), theApp.clientlist->GetBuddy()->GetUDPPort(), false, NULL);
	}
}
// NEO: NATS END

// NEO: MTD - [MultiTempDirectories]
void CPreferences::LoadTempDirs()
{
	// temporary file directories
	TCHAR* fullpath = new TCHAR[wcslen(configdir)+MAX_PATH]; // i_a
	_stprintf(fullpath,L"%stempdir.dat",configdir);
	CStdioFile* tdirfile = new CStdioFile();
	if (tdirfile->Open(fullpath,CFile::modeRead)){
		CString toadd;
		while (tdirfile->ReadString(toadd))
		{
			TCHAR szFullPath[MAX_PATH];
			if (PathCanonicalize(szFullPath, toadd))
				toadd = szFullPath;

			if (IsInstallationDirectory(toadd))
				continue;

			if (_taccess(toadd, 0) == 0){ // only add directories which still exist
				//if (toadd.Right(1) != L'\\')
				//	toadd.Append(L"\\");
				tempdir_list.AddHead(toadd);
			}
		}
		tdirfile->Close();
	}
	delete tdirfile;
	delete[] fullpath;
}

bool CPreferences::SaveTempDirs()
{
	bool error = false;
	TCHAR* fullpath = new TCHAR[wcslen(configdir)+14];
	_stprintf(fullpath,L"%stempdir.dat",configdir);
	CStdioFile tdirfile;
	if (tdirfile.Open(fullpath,CFile::modeCreate|CFile::modeWrite))
	{
		try{
			for (POSITION pos = tempdir_list.GetHeadPosition();pos != 0;tempdir_list.GetNext(pos)){
				tdirfile.WriteString(tempdir_list.GetAt(pos).GetBuffer());
				tdirfile.Write("\n",1);
			}
			if (thePrefs.GetCommitFiles() >= 2 || (thePrefs.GetCommitFiles() >= 1 && !theApp.emuledlg->IsRunning())){
				tdirfile.Flush(); // flush file stream buffers to disk buffers
				if (_commit(_fileno(tdirfile.m_pStream)) != 0) // commit disk buffers to disk
					AfxThrowFileException(CFileException::hardIO, GetLastError(), tdirfile.GetFileName());
			}
			tdirfile.Close();
		}
		catch(CFileException* error){
			TCHAR buffer[MAX_CFEXP_ERRORMSG];
			error->GetErrorMessage(buffer,ARRSIZE(buffer));
			AddDebugLogLine(true,L"Failed to save %s - %s", fullpath, buffer);
			error->Delete();
		}
	}
	else
		error = true;
	delete[] fullpath;
	fullpath=NULL;

	return error;
}
// NEO: MTD END

// NEO: SSD - [ShareSubDirectories]
void CPreferences::LoadSharedDirs()
{
	// shared directories
	TCHAR* fullpath = new TCHAR[_tcslen(configdir) + MAX_PATH];
	_stprintf(fullpath, L"%sshareddir.dat", configdir);
	CStdioFile* sdirfile = new CStdioFile();
	bool bIsUnicodeFile = IsUnicodeFile(fullpath); // check for BOM
	// open the text file either in ANSI (text) or Unicode (binary), this way we can read old and new files
	// with nearly the same code..
	if (sdirfile->Open(fullpath, CFile::modeRead | CFile::shareDenyWrite | (bIsUnicodeFile ? CFile::typeBinary : 0)))
	{
		try {
			if (bIsUnicodeFile)
				sdirfile->Seek(sizeof(WORD), SEEK_CUR); // skip BOM

			CString toadd;
			while (sdirfile->ReadString(toadd))
			{
				toadd.Trim(L" \t\r\n"); // need to trim '\r' in binary mode
				if (toadd.IsEmpty())
					continue;
				TCHAR szFullPath[MAX_PATH];
				if (PathCanonicalize(szFullPath, toadd))
					toadd = szFullPath;

				if (!IsShareableDirectory(toadd) )
					continue;

				if (_taccess(toadd, 0) == 0) { // only add directories which still exist
					if (toadd.Right(1) != L'\\')
						toadd.Append(L"\\");
					shareddir_list.AddHead(toadd);
				}
			}
		}
		catch (CFileException* ex) {
			ASSERT(0);
			ex->Delete();
		}
		sdirfile->Close();
	}
	delete sdirfile;
	delete[] fullpath;

	// shared directories with subdirectories
	fullpath = new TCHAR[_tcslen(configdir) + MAX_PATH];
	_stprintf(fullpath, L"%ssharedsubdir.dat", configdir);
	sdirfile = new CStdioFile();
	bIsUnicodeFile = IsUnicodeFile(fullpath); // check for BOM
	// open the text file either in ANSI (text) or Unicode (binary), this way we can read old and new files
	// with nearly the same code..
	if (sdirfile->Open(fullpath, CFile::modeRead | CFile::shareDenyWrite | (bIsUnicodeFile ? CFile::typeBinary : 0)))
	{
		try {
			if (bIsUnicodeFile)
				sdirfile->Seek(sizeof(WORD), SEEK_CUR); // skip BOM

			CString toadd;
			while (sdirfile->ReadString(toadd))
			{
				toadd.Trim(L" \t\r\n"); // need to trim '\r' in binary mode
				if (toadd.IsEmpty())
					continue;
				TCHAR szFullPath[MAX_PATH];
				if (PathCanonicalize(szFullPath, toadd))
					toadd = szFullPath;

				if (_taccess(toadd, 0) == 0) { // only add directories which still exist
					if (toadd.Right(1) != L'\\')
						toadd.Append(L"\\");
					sharedsubdir_list.AddHead(toadd);
				}
			}
		}
		catch (CFileException* ex) {
			ASSERT(0);
			ex->Delete();
		}
		sdirfile->Close();
	}
	delete sdirfile;
	delete[] fullpath;
}

bool CPreferences::SaveSharedDirs()
{
	bool error = false;
	TCHAR* fullpath = new TCHAR[_tcslen(configdir) + 14];
	_stprintf(fullpath, L"%sshareddir.dat", configdir);
	CStdioFile sdirfile;
	if (sdirfile.Open(fullpath, CFile::modeCreate | CFile::modeWrite | CFile::shareDenyWrite | CFile::typeBinary))
	{
		try{
			// write Unicode byte-order mark 0xFEFF
			WORD wBOM = 0xFEFF;
			sdirfile.Write(&wBOM, sizeof(wBOM));

			for (POSITION pos = shareddir_list.GetHeadPosition();pos != 0;){
				sdirfile.WriteString(shareddir_list.GetNext(pos));
				sdirfile.Write(L"\r\n", sizeof(TCHAR)*2);
			}
			if (thePrefs.GetCommitFiles() >= 2 || (thePrefs.GetCommitFiles() >= 1 && !theApp.emuledlg->IsRunning())){
				sdirfile.Flush(); // flush file stream buffers to disk buffers
				if (_commit(_fileno(sdirfile.m_pStream)) != 0) // commit disk buffers to disk
					AfxThrowFileException(CFileException::hardIO, GetLastError(), sdirfile.GetFileName());
			}
			sdirfile.Close();
		}
		catch(CFileException* error){
			TCHAR buffer[MAX_CFEXP_ERRORMSG];
			error->GetErrorMessage(buffer,ARRSIZE(buffer));
			if (thePrefs.GetVerbose())
				AddDebugLogLine(true,L"Failed to save %s - %s", fullpath, buffer);
			error->Delete();
		}
	}
	else
		error = true;
	delete[] fullpath;
	fullpath=NULL;

	fullpath = new TCHAR[_tcslen(configdir) + 17];
	_stprintf(fullpath, L"%ssharedsubdir.dat", configdir);
	if (sdirfile.Open(fullpath, CFile::modeCreate | CFile::modeWrite | CFile::shareDenyWrite | CFile::typeBinary))
	{
		try{
			// write Unicode byte-order mark 0xFEFF
			WORD wBOM = 0xFEFF;
			sdirfile.Write(&wBOM, sizeof(wBOM));

			for (POSITION pos = sharedsubdir_list.GetHeadPosition();pos != 0;){
				sdirfile.WriteString(sharedsubdir_list.GetNext(pos).GetBuffer());
				sdirfile.Write(L"\r\n", sizeof(TCHAR)*2);
			}
			if (thePrefs.GetCommitFiles() >= 2 || (thePrefs.GetCommitFiles() >= 1 && !theApp.emuledlg->IsRunning())){
				sdirfile.Flush(); // flush file stream buffers to disk buffers
				if (_commit(_fileno(sdirfile.m_pStream)) != 0) // commit disk buffers to disk
					AfxThrowFileException(CFileException::hardIO, GetLastError(), sdirfile.GetFileName());
			}
			sdirfile.Close();
		}
		catch(CFileException* error){
			TCHAR buffer[MAX_CFEXP_ERRORMSG];
			error->GetErrorMessage(buffer,ARRSIZE(buffer));
			if (thePrefs.GetVerbose())
				AddDebugLogLine(true,L"Failed to save %s - %s", fullpath, buffer);
			error->Delete();
		}
	}
	else
		error = true;
	delete[] fullpath;
	fullpath=NULL;

	return error;
}
// NEO: SSD END

// NEO: SSF - [ShareSingleFiles]
void CPreferences::LoadSharedFiles()
{
	// shared files
	TCHAR* fullpath = new TCHAR[_tcslen(configdir) + MAX_PATH];
	_stprintf(fullpath, L"%ssharedfiles.dat", configdir);
	CStdioFile* sfilefile = new CStdioFile();
	bool bIsUnicodeFile = IsUnicodeFile(fullpath); // check for BOM
	// open the text file either in ANSI (text) or Unicode (binary), this way we can read old and new files
	// with nearly the same code..
	if (sfilefile->Open(fullpath, CFile::modeRead | CFile::shareDenyWrite | (bIsUnicodeFile ? CFile::typeBinary : 0)))
	{
		try {
			if (bIsUnicodeFile)
				sfilefile->Seek(sizeof(WORD), SEEK_CUR); // skip BOM

			CString toadd;
			while (sfilefile->ReadString(toadd))
			{
				toadd.Trim(L" \t\r\n"); // need to trim '\r' in binary mode
				if (toadd.IsEmpty())
					continue;
				TCHAR szFullPath[MAX_PATH];
				if (PathCanonicalize(szFullPath, toadd))
					toadd = szFullPath;

				if (_taccess(toadd, 0) == 0) // only add files which still exist
					sharedfile_list.AddHead(toadd);
			}
		}
		catch (CFileException* ex) {
			ASSERT(0);
			ex->Delete();
		}
		sfilefile->Close();
	}
	delete sfilefile;
	delete[] fullpath;
}

bool CPreferences::SaveSharedFiles()
{
	bool error = false;
	TCHAR* fullpath = new TCHAR[_tcslen(configdir) + MAX_PATH];
	_stprintf(fullpath, L"%ssharedfiles.dat", configdir);
	CStdioFile sfilefile;
	if (sfilefile.Open(fullpath, CFile::modeCreate | CFile::modeWrite | CFile::shareDenyWrite | CFile::typeBinary))
	{
		try{
			// write Unicode byte-order mark 0xFEFF
			WORD wBOM = 0xFEFF;
			sfilefile.Write(&wBOM, sizeof(wBOM));

			for (POSITION pos = sharedfile_list.GetHeadPosition();pos != 0;){
				sfilefile.WriteString(sharedfile_list.GetNext(pos));
				sfilefile.Write(L"\r\n", sizeof(TCHAR)*2);
			}
			if (thePrefs.GetCommitFiles() >= 2 || (thePrefs.GetCommitFiles() >= 1 && !theApp.emuledlg->IsRunning())){
				sfilefile.Flush(); // flush file stream buffers to disk buffers
				if (_commit(_fileno(sfilefile.m_pStream)) != 0) // commit disk buffers to disk
					AfxThrowFileException(CFileException::hardIO, GetLastError(), sfilefile.GetFileName());
			}
			sfilefile.Close();
		}
		catch(CFileException* error){
			TCHAR buffer[MAX_CFEXP_ERRORMSG];
			error->GetErrorMessage(buffer,ARRSIZE(buffer));
			if (thePrefs.GetVerbose())
				AddDebugLogLine(true,L"Failed to save %s - %s", fullpath, buffer);
			error->Delete();
		}
	}
	else
		error = true;
	delete[] fullpath;
	fullpath=NULL;
	return error;
}
// NEO: SSF END

// NEO: VSF - [VirtualSharedFiles]
void CPreferences::LoadVirtualDirs()
{
	CString fullpath;
	fullpath.Format(L"%svirtualdirs.ini", configdir);
	CStdioFile file;
	bool bIsUnicodeFile = IsUnicodeFile(fullpath); // check for BOM
	if (file.Open(fullpath, CFile::modeRead | CFile::shareDenyWrite | (bIsUnicodeFile ? CFile::typeBinary : 0))){
		try {
			if (bIsUnicodeFile)
				file.Seek(sizeof(WORD), SEEK_CUR); // skip BOM

			CString toadd;
			while (file.ReadString(toadd))
			{
				toadd.Trim(L" \t\r\n"); // need to trim '\r' in binary mode
				if (toadd.IsEmpty())
					continue;
				CString type, mapFrom, mapTo;
				int curPos = 0;

				type = toadd.Tokenize(L";", curPos);
				if (curPos == -1)
					continue;

				mapFrom = toadd.Tokenize(L";", curPos);
				if (curPos == -1)
					continue;

				mapTo = toadd.Tokenize(L";", curPos);
				if (curPos != toadd.GetLength()+1)
					continue;

				type.Trim(); 
				mapFrom.Trim(); 
				mapTo.Trim();
				mapFrom.TrimRight(L"\\"); // we can't trim("\\") since there may be unc shares
				mapTo.TrimRight(L"\\"); 
				if (type != L"0" && type != L"1" && type != L"2")
					continue;

				if (type == L"0")
					mapFrom.MakeUpper();
				else {
					mapFrom.MakeLower();
					if (!PathFileExists(mapFrom))
						continue;
				}
				mapTo.MakeLower();

				if (type == L"0")
					m_fileToVDir_map.SetAt(mapFrom, mapTo);
				else if (type== L"1") 
					m_dirToVDir_map.SetAt(mapFrom, mapTo);
				else if (type == L"2")
					m_dirToVDirWithSD_map.SetAt(mapFrom, mapTo);
			}
		}
		catch (CFileException* ex) {
			ASSERT(0);
			ex->Delete();
		}
		file.Close();
	}
}

bool CPreferences::SaveVirtualDirs()
{
	CString fullpath;
	fullpath.Format(L"%svirtualdirs.ini", configdir);
	CStdioFile file;
	CString entry1, entry2, buffer;
	if (file.Open(fullpath,CFile::modeCreate | CFile::modeWrite | CFile::shareDenyWrite | CFile::typeBinary))
	{
		try{
			// write Unicode byte-order mark 0xFEFF
			WORD wBOM = 0xFEFF;
			file.Write(&wBOM, sizeof(wBOM));

			for (POSITION pos = m_fileToVDir_map.GetHeadPosition(); pos != NULL; ) {
				m_fileToVDir_map.GetNextAssoc(pos, entry1, entry2);
				buffer.Format(L"0;%s;%s", entry1, entry2);
				file.WriteString(buffer);
				file.Write(L"\r\n", sizeof(TCHAR)*2);
			}
			for (POSITION pos = m_dirToVDir_map.GetHeadPosition(); pos != NULL; ){
				m_dirToVDir_map.GetNextAssoc(pos, entry1, entry2);
				buffer.Format(L"1;%s;%s", entry1, entry2);
				file.WriteString(buffer);
				file.Write(L"\r\n", sizeof(TCHAR)*2);
			}
			for (POSITION pos = m_dirToVDirWithSD_map.GetHeadPosition(); pos != NULL; ) {
				m_dirToVDirWithSD_map.GetNextAssoc(pos, entry1, entry2);
				buffer.Format(L"2;%s;%s", entry1, entry2);
				file.WriteString(buffer);
				file.Write(L"\r\n", sizeof(TCHAR)*2);
			}
			if (thePrefs.GetCommitFiles() >= 2 || (thePrefs.GetCommitFiles() >= 1 && !theApp.emuledlg->IsRunning())){
				file.Flush(); // flush file stream buffers to disk buffers
				if (_commit(_fileno(file.m_pStream)) != 0) // commit disk buffers to disk
					AfxThrowFileException(CFileException::hardIO, GetLastError(), file.GetFileName());
			}
			file.Close();
		}
		catch(CFileException* error){
			TCHAR buffer[MAX_CFEXP_ERRORMSG];
			error->GetErrorMessage(buffer,ARRSIZE(buffer));
			if (thePrefs.GetVerbose())
				AddDebugLogLine(true,L"Failed to save %s - %s", fullpath, buffer);
			error->Delete();
			return true;
		}
	}

	return false;
}
// NEO: VSF END

// NEO: IM - [InvisibelMode]
void CPreferencesEx::SetInvisibleMode(bool on, UINT keymodifier, TCHAR key) 
{
	m_bInvisibleMode = on;
	m_iInvisibleModeHotKeyModifier = keymodifier;
	m_cInvisibleModeHotKey = key;
	if(theApp.emuledlg!=NULL){
		//Always unregister, the keys could be different.
		theApp.emuledlg->UnRegisterInvisibleHotKey();
		if(m_bInvisibleMode)
			theApp.emuledlg->RegisterInvisibleHotKey();
	}
}
// NEO: IM END
// NEO: NCFG END <-- Xanatos --
