#pragma once
#include "Neo\GUI\CP\DirectoryTreeCtrl.h"

class CPPgDirectories : public CPropertyPage
{
	DECLARE_DYNAMIC(CPPgDirectories)

public:
	CPPgDirectories();									// standard constructor
	virtual ~CPPgDirectories();

// Dialog Data
	enum { IDD = IDD_PPG_DIRECTORIES };

	void Localize(void);

protected:
	CDirectoryTreeCtrl m_ShareSelector;
	CListCtrl m_ctlUncPaths;
	CListCtrl* m_tempfolders; // NEO: MTD - [MultiTempDirectories] <-- Xanatos --

	bool m_templist_dirty; // NEO: MTD - [MultiTempDirectories] <-- Xanatos --

	void LoadSettings(void);
	void FillUncList(void);
	void FillTempList(void); // NEO: MTD - [MultiTempDirectories] <-- Xanatos --

	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	virtual BOOL OnInitDialog();
	virtual BOOL OnApply();
	virtual BOOL OnCommand(WPARAM wParam, LPARAM lParam);

	DECLARE_MESSAGE_MAP()
	afx_msg void OnSettingsChange()					{ SetModified(); }
	afx_msg void OnBnClickedSelincdir();
	afx_msg void OnBnClickedSeltempdir();
	afx_msg void OnBnClickedAddUNC();
	afx_msg void OnBnClickedRemUNC();

	afx_msg void OnHelp();
	afx_msg BOOL OnHelpInfo(HELPINFO* pHelpInfo);
	// NEO: MTD - [MultiTempDirectories] -- Xanatos -->
	afx_msg void OnBnClickedTempadd();
	afx_msg void OnBnClickedTemprem();
	// NEO: MTD END <-- Xanatos --
};
