//this file is part of NeoMule
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


// NEO: EDT - [EstimatedDownloadTime] -- Xanatos -->

#pragma once
#include "NeoOpcodes.h"

class CEdt
{
private:

	// Waiting period estimation
	uint32	m_period[EDT_PERIOD_CACHE];
	int		m_period_cache_next;
	int		m_period_cache_size;

	//uint32	m_last_server_time;
	uint32	m_last_period_time;

	double	m_cached_avg_period;

	double	m_cache_totalrate;

	double WaitingPeriod(uint32 rate);
	uint32 TotalRate();
	uint32 QueuePlacesBefore(double threshold_time);
	bool EstimateWaitingPeriod(uint32 curr_waittime, uint32 rate, uint32 &est_time, uint32 &est_err);

public:

	CEdt();
	void ResetWaitingPeriodCache();
	void AddWaitingPeriod();
	void EstimateTime(CUpDownClient * client, uint32 &est_time, uint32 &est_err);
	CString FormatEDT(uint32 avg_time, uint32 err_time, CTime start_time);
	CString FormatEDT(const CUpDownClient * client);
};

// NEO: EDT END <-- Xanatos --