//this file is part of NeoMule
//Copyright (C)2006 David Xanatos ( Xanatos@Lycos.at / http://neomule.sourceforge.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


#include "stdafx.h"
#include "emule.h"
#include "kademlia/kademlia/tag.h"
#include "VoodooListDlg.h"
#include "OtherFunctions.h"
#include "Preferences.h"
#include "MenuCmds.h"
#include "Packets.h"
#include "KnownFile.h"
#include "UserMsgs.h"
#include "InputBox.h"
#include "log.h"
#include "Neo/Functions.h"
#include "Neo/Voodoo.h"
#include "Neo/lancast.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#ifdef VOODOO // NEO: VOODOO - [UniversalPartfileInterface] -- Xanatos -->

// CVoodooListDlg dialog

#define	PREF_INI_SECTION	_T("VoodooListDlg")

IMPLEMENT_DYNAMIC(CVoodooListDlg, CDialog) // NEO: MLD - [ModelesDialogs]

BEGIN_MESSAGE_MAP(CVoodooListDlg, CModelessResizableDialog) // NEO: MLD - [ModelesDialogs]
	ON_NOTIFY(NM_DBLCLK, IDC_VOODOOLIST, OnNMDblclk)
	ON_NOTIFY(NM_CLICK, IDC_VOODOOLIST, OnClick)

	ON_BN_CLICKED(IDC_CONNECT_TO, OnBnClickedConnectTo)
	ON_BN_CLICKED(IDC_CONNECT, OnBnClickedConnect)
	ON_BN_CLICKED(IDC_DISCONNECT, OnBnClickedDisconnect)
	ON_BN_CLICKED(IDC_SEARCH, OnBnClickedSearch)
	ON_BN_CLICKED(IDC_ADD, OnBnClickedAdd)
	ON_BN_CLICKED(IDC_EDIT, OnBnClickedEdit)
	ON_BN_CLICKED(IDC_REMOVE, OnBnClickedRemove)

	ON_WM_DESTROY()
	ON_WM_TIMER()
END_MESSAGE_MAP()

CVoodooListDlg::CVoodooListDlg()
	: CModelessResizableDialog(CVoodooListDlg::IDD, 0, TRUE) // NEO: MLD - [ModelesDialogs]
{
	m_timer = 0;
}

CVoodooListDlg::~CVoodooListDlg()
{
}

void CVoodooListDlg::DoDataExchange(CDataExchange* pDX)
{
	CModelessResizableDialog::DoDataExchange(pDX); // NEO: MLD - [ModelesDialogs]
	DDX_Control(pDX, IDC_VOODOOLIST, m_VoodooList);
}

BOOL CVoodooListDlg::OnInitDialog()
{
	CModelessResizableDialog::OnInitDialog(); // NEO: MLD - [ModelesDialogs]
	InitWindowStyles(this);

	m_VoodooList.SetName(_T("VoodooList"));
	m_VoodooList.ModifyStyle(LVS_SINGLESEL,0);
	m_VoodooList.SetExtendedStyle(LVS_EX_FULLROWSELECT);
	m_VoodooList.InsertColumn(0, GetResString(IDS_X_VOODOO_NAME), LVCFMT_LEFT, 130); 
	m_VoodooList.InsertColumn(1, GetResString(IDS_X_VOODOO_ADRESS), LVCFMT_LEFT, 120); 
	m_VoodooList.InsertColumn(2, GetResString(IDS_X_VOODOO_ACTION), LVCFMT_LEFT, 50); 
	m_VoodooList.InsertColumn(3, GetResString(IDS_X_VOODOO_TYPE), LVCFMT_LEFT, 80); 
	m_VoodooList.InsertColumn(4, GetResString(IDS_X_VOODOO_USABLE), LVCFMT_LEFT, 50); 
	m_VoodooList.InsertColumn(5, GetResString(IDS_X_VOODOO_STATUS), LVCFMT_LEFT, 100); 
	m_VoodooList.InsertColumn(6, GetResString(IDS_X_VOODOO_SPEED), LVCFMT_LEFT, 100); 

	if(thePrefs.IsExtControlsEnabled())
	{
		m_VoodooList.InsertColumn(7, _T("Ver"), LVCFMT_LEFT, 35); 
		m_VoodooList.InsertColumn(8, _T("64"), LVCFMT_LEFT, 30); 
		m_VoodooList.InsertColumn(9, _T("CH"), LVCFMT_LEFT, 30); 
		m_VoodooList.InsertColumn(10, _T("SD"), LVCFMT_LEFT, 30); 
		m_VoodooList.InsertColumn(11, _T("S"), LVCFMT_LEFT, 30); 
		m_VoodooList.InsertColumn(12, _T("SX"), LVCFMT_LEFT, 30); 
		m_VoodooList.InsertColumn(13, _T("SE"), LVCFMT_LEFT, 30); 
		m_VoodooList.InsertColumn(14, _T("ES"), LVCFMT_LEFT, 30); 
		m_VoodooList.InsertColumn(15, _T("PI"), LVCFMT_LEFT, 30); 
		m_VoodooList.InsertColumn(16, _T("SF"), LVCFMT_LEFT, 30); 
		m_VoodooList.InsertColumn(17, _T("AC"), LVCFMT_LEFT, 30); 
		m_VoodooList.InsertColumn(18, _T("NC"), LVCFMT_LEFT, 30); 
		m_VoodooList.InsertColumn(19, _T("NF"), LVCFMT_LEFT, 30); 
	}

	
	m_VoodooList.LoadSettings();
	
	AddAnchor(IDC_VOODOOLIST, TOP_LEFT, BOTTOM_RIGHT);

	AddAnchor(IDC_SSTATIC, TOP_RIGHT, TOP_RIGHT);
	AddAnchor(IDC_SSTATIC4, TOP_RIGHT);
	AddAnchor(IDC_SSTATIC7, TOP_RIGHT);
	AddAnchor(IDC_IPADDRESS, TOP_RIGHT);
	AddAnchor(IDC_SPORT, TOP_RIGHT);
	AddAnchor(IDC_SSTATIC3, TOP_RIGHT);
	AddAnchor(IDC_SNAME, TOP_RIGHT);
	AddAnchor(IDC_SSTATIC5, TOP_RIGHT);
	AddAnchor(IDC_SSTATIC8, TOP_RIGHT);
	AddAnchor(IDC_SSTATIC9, TOP_RIGHT);
	AddAnchor(IDC_STYPE, TOP_RIGHT);
	AddAnchor(IDC_SSOFTWARE, TOP_RIGHT);
	AddAnchor(IDC_SSPELL, TOP_RIGHT);
	AddAnchor(IDC_USABLE, TOP_RIGHT);

	AddAnchor(IDC_CONNECT_TO, BOTTOM_RIGHT);
	AddAnchor(IDC_CONNECT, BOTTOM_RIGHT);
	AddAnchor(IDC_DISCONNECT, BOTTOM_RIGHT);
	AddAnchor(IDC_SEARCH, BOTTOM_RIGHT);
	AddAnchor(IDC_ADD, BOTTOM_RIGHT);
	AddAnchor(IDC_EDIT, BOTTOM_RIGHT);
	AddAnchor(IDC_REMOVE, BOTTOM_RIGHT);
	AddAnchor(IDOK, BOTTOM_RIGHT);

	EnableSaveRestore(PREF_INI_SECTION);

	ReloadVoodooList();

	SetDlgItemText(IDC_SSTATIC,GetResString(IDS_X_VOODOO_EDITOR));
	SetDlgItemText(IDC_SSTATIC4,GetResString(IDS_X_VOODOO_IPADDRESS));
	SetDlgItemText(IDC_SSTATIC7,GetResString(IDS_X_VOODOO_PORT));
	SetDlgItemText(IDC_SSTATIC3,GetResString(IDS_X_VOODOO_NICK));
	SetDlgItemText(IDC_SSTATIC8,GetResString(IDS_X_VOODOO_CLIENT_ACTION));
	SetDlgItemText(IDC_SSTATIC9,GetResString(IDS_X_VOODOO_CLIENT_SOFTWARE));
	SetDlgItemText(IDC_USABLE,GetResString(IDS_X_VOODOO_USABLE));

	CComboBox* ClientAction = ((CComboBox*)GetDlgItem(IDC_STYPE));
	ClientAction->AddString(GetResString(IDS_X_VOODOO_NOTHING)); ASSERT(VA_NONE == 0);
	ClientAction->AddString(GetResString(IDS_X_VOODOO_SLAVE)); ASSERT(VA_SLAVE == 1);
	ClientAction->AddString(GetResString(IDS_X_VOODOO_MASTER)); ASSERT(VA_MASTER == 2);
	ClientAction->AddString(GetResString(IDS_X_VOODOO_PARTNER)); ASSERT(VA_PARTNER == 3);
	ClientAction->AddString(GetResString(IDS_X_VOODOO_BLOCK)); ASSERT(VA_BLOCK == 4);
	if(thePrefs.UseVoodooTransfer() && thePrefs.IsSlaveAllowed())
		ClientAction->SetCurSel(3);
	else if(thePrefs.UseVoodooTransfer())
		ClientAction->SetCurSel(1);
	else if(thePrefs.IsSlaveAllowed())
		ClientAction->SetCurSel(2);
	else
		ClientAction->SetCurSel(0);

	CComboBox* Software = ((CComboBox*)GetDlgItem(IDC_SSOFTWARE));
	Software->AddString(GetResString(IDS_X_VOODOO_OTHER)); ASSERT(CT_UNKNOWN == 0);
	Software->AddString(GetResString(IDS_X_VOODOO_ED2K)); ASSERT(CT_ED2K == 1);
	Software->AddString(GetResString(IDS_X_VOODOO_BITTORRENT)); ASSERT(CT_BITTORRENT == 2);
	Software->SetCurSel(0);

	SetDlgItemText(IDC_CONNECT_TO,GetResString(IDS_X_VOODOO_CONNECT_TO));
	SetDlgItemText(IDC_CONNECT,GetResString(IDS_X_VOODOO_CONNECT));
	SetDlgItemText(IDC_DISCONNECT,GetResString(IDS_X_VOODOO_DISCONNECT));
	SetDlgItemText(IDC_SEARCH,GetResString(IDS_X_VOODOO_SEARCH_ORDER));
	SetDlgItemText(IDC_ADD,GetResString(IDS_X_VOODOO_ADD));
	SetDlgItemText(IDC_EDIT,GetResString(IDS_X_VOODOO_EDIT));
	SetDlgItemText(IDC_REMOVE,GetResString(IDS_X_VOODOO_REMOVE));
	SetDlgItemText(IDOK,GetResString(IDS_FD_CLOSE));

	CheckDlgButton(IDC_USABLE,true);
	GetDlgItem(IDC_USABLE)->EnableWindow(FALSE);
	GetDlgItem(IDC_SEARCH)->EnableWindow(thePrefs.IsVoodooCastEnabled());

	// start time for calling 'RefreshData'
	VERIFY( (m_timer = SetTimer(301, 1000, 0)) != NULL );

	return TRUE;  // return TRUE unless you set the focus to a control
				  // EXCEPTION: OCX Property Pages should return FALSE
}

void CVoodooListDlg::OnTimer(UINT /*nIDEvent*/)
{
	ReloadVoodooList();
}

void CVoodooListDlg::ReloadVoodooList()
{
	CWaitCursor curWait;
	m_VoodooList.SetRedraw(FALSE);

	POSITION pos = theApp.voodoo->known_list.GetHeadPosition();
	while (pos)
		LoadVoodooItem(theApp.voodoo->known_list.GetNext(pos));

	for(int i=0;i<m_VoodooList.GetItemCount();i++){
		SVoodooClient* item = (SVoodooClient*)m_VoodooList.GetItemData(i);
		if(theApp.voodoo->known_list.Find(item) == NULL)
			m_VoodooList.DeleteItem(i);
	}

	m_VoodooList.SetRedraw();
}

void CVoodooListDlg::LoadVoodooItem(SVoodooClient* client)
{
	LVFINDINFO find;
	find.flags = LVFI_PARAM;
	find.lParam = (LPARAM)client;
	int iItem = m_VoodooList.FindItem(&find);
	if (iItem == -1)
		iItem = m_VoodooList.InsertItem(LVIF_TEXT|LVIF_PARAM,0,client->m_sName,0,0,1,(LPARAM)client);

	CString strBuff;

	strBuff = client->m_sName;
	m_VoodooList.SetItemText(iItem, 0, strBuff); 

	strBuff = client->clientAddress;
	strBuff.AppendFormat(_T(":%u"),client->clientPort);
	in_addr iaDest;	iaDest.s_addr = inet_addr(CT2CA(client->clientAddress));
	if (iaDest.s_addr == INADDR_NONE && client->clientIP != 0)
		strBuff.AppendFormat(_T(" (%s)"),ipstr(client->clientIP));
	m_VoodooList.SetItemText(iItem, 1, strBuff); 

	strBuff = GetResString((client->m_uAction == VA_PARTNER) ? IDS_X_VOODOO_PARTNER : (client->m_uAction == VA_MASTER) ? IDS_X_VOODOO_MASTER : (client->m_uAction == VA_SLAVE) ? IDS_X_VOODOO_SLAVE : IDS_X_VOODOO_NOTHING);
	m_VoodooList.SetItemText(iItem, 2, strBuff); 

	strBuff = GetResString((client->m_uType == CT_ED2K) ? IDS_X_VOODOO_ED2K : (client->m_uType == CT_BITTORRENT) ? IDS_X_VOODOO_BITTORRENT : IDS_X_VOODOO_OTHER);
	m_VoodooList.SetItemText(iItem, 3, strBuff); 

	strBuff = GetResString(client->m_bUsable ? IDS_YES : IDS_NO);
	m_VoodooList.SetItemText(iItem, 4, strBuff);

	CVoodooSocket* cur_socket = theApp.voodoo->GetVoodooSocket(client->clientIP,client->clientPort,client->socketPort,true);
	if(cur_socket){
		if(cur_socket->IsMaster() && cur_socket->IsSlave())
			strBuff = GetResString(IDS_X_VOODOO_PARTNER);
		else if(cur_socket->IsMaster())
			strBuff = GetResString(IDS_X_VOODOO_MASTER);
		else if(cur_socket->IsSlave())
			strBuff = GetResString(IDS_X_VOODOO_SLAVE);
		else
			strBuff = GetResString(IDS_X_VOODOO_NOTHING);
	}else
		strBuff.Empty();
	m_VoodooList.SetItemText(iItem, 5, strBuff); 

	if(cur_socket)
		strBuff.Format(_T("%.2f/%.2f"), (float)cur_socket->GetUpDatarate()/1000, (float)cur_socket->GetDownDatarate()/1000);
	else
		strBuff.Empty();
	m_VoodooList.SetItemText(iItem, 6, strBuff); 

	if(cur_socket && thePrefs.IsExtControlsEnabled())
	{
		m_VoodooList.SetItemText(iItem, 7, StrLine(_T("%u"),cur_socket->GetVoodooVersion())); 
		m_VoodooList.SetItemText(iItem, 8, StrLine(_T("%u"),cur_socket->Use64Size())); 
		m_VoodooList.SetItemText(iItem, 9, StrLine(_T("%u"),cur_socket->GetCorruptionHandlingVersion())); 
		m_VoodooList.SetItemText(iItem, 10, StrLine(_T("%u"),cur_socket->GetAdvDownloadSyncVersion())); 
		m_VoodooList.SetItemText(iItem, 11, StrLine(_T("%u"),cur_socket->GetSupportsStatisticsVersion())); 
		m_VoodooList.SetItemText(iItem, 12, StrLine(_T("%u"),cur_socket->GetNeoSourceExportVersion())); 
		m_VoodooList.SetItemText(iItem, 13, StrLine(_T("%u"),cur_socket->GetNeoSourceExchangeVersion())); 
		m_VoodooList.SetItemText(iItem, 14, StrLine(_T("%u"),cur_socket->GetExtendedStatesSupport())); 
		m_VoodooList.SetItemText(iItem, 15, StrLine(_T("%u"),cur_socket->GetPriorityInstructionsVersion())); 
		m_VoodooList.SetItemText(iItem, 16, StrLine(_T("%u"),cur_socket->IsVoodooSearchSupported())); 
		m_VoodooList.SetItemText(iItem, 17, StrLine(_T("%u"),cur_socket->GetA4AFCommandsVersion())); 
		m_VoodooList.SetItemText(iItem, 18, StrLine(_T("%u"),cur_socket->GetExtendedComandsVersion())); 
		m_VoodooList.SetItemText(iItem, 19, StrLine(_T("%u"),cur_socket->GetNeoFilePreferencesVersion())); 
	}
	
}

void CVoodooListDlg::OnClick(NMHDR* /*pNMHDR*/, LRESULT *pResult) {
	
	POSITION pos = m_VoodooList.GetFirstSelectedItemPosition();
	if(pos != NULL)
	{
		int index = m_VoodooList.GetNextSelectedItem(pos);
		if (index >= 0){
			SVoodooClient* item = (SVoodooClient*)m_VoodooList.GetItemData(index);
			if(!theApp.voodoo->IsValudKnownClinet(item)){
				ReloadVoodooList();
				return;
			}

			GetDlgItem(IDC_IPADDRESS)->SetWindowText(item->clientAddress);
			GetDlgItem(IDC_SPORT)->SetWindowText(StrLine(_T("%u"),item->clientPort));
			CheckDlgButton(IDC_USABLE,item->m_bUsable);
			GetDlgItem(IDC_SSPELL)->SetWindowText(item->m_sSpell);
			GetDlgItem(IDC_SNAME)->SetWindowText(item->m_sName);
			((CComboBox*)GetDlgItem(IDC_STYPE))->SetCurSel(item->m_uAction);
			((CComboBox*)GetDlgItem(IDC_SSOFTWARE))->SetCurSel(item->m_uType);

			GetDlgItem(IDC_CONNECT)->EnableWindow(item->clientPort != 0);

			CVoodooSocket* cur_socket = theApp.voodoo->GetVoodooSocket(item->clientIP,item->clientPort,item->socketPort);
			GetDlgItem(IDC_DISCONNECT)->EnableWindow(cur_socket != NULL);
		}
	}

	*pResult = 0;
}


void CVoodooListDlg::OnNMDblclk(NMHDR* /*pNMHDR*/, LRESULT *pResult) {
	
	POSITION pos = m_VoodooList.GetFirstSelectedItemPosition();
	if(pos != NULL)
	{
		int index = m_VoodooList.GetNextSelectedItem(pos);
		if (index >= 0){
			SVoodooClient* item = (SVoodooClient*)m_VoodooList.GetItemData(index);
			if(!theApp.voodoo->IsValudKnownClinet(item)){
				ReloadVoodooList();
				return;
			}
			theApp.voodoo->ConnectVoodooClient(item->clientAddress,item->clientPort,(item->m_uAction == VA_NONE) ? VA_QUERY : item->m_uAction);
			m_VoodooList.Update(index);
		}
	}

	*pResult = 0;
}

void CVoodooListDlg::OnBnClickedConnectTo(){

	CString Address;
	GetDlgItem(IDC_IPADDRESS)->GetWindowText(Address);

	CString Port;
	GetDlgItem(IDC_SPORT)->GetWindowText(Port);

	uint16 nPort = (uint16)_tstoi(Port);
	if(nPort == 0)
		nPort = thePrefs.GetVoodooPort();

	uint8 uAction = (uint8)((CComboBox*)GetDlgItem(IDC_STYPE))->GetCurSel();
	if(uAction == VA_NONE)
		uAction = VA_QUERY;

	theApp.voodoo->ConnectVoodooClient(Address,nPort,uAction);
}

void CVoodooListDlg::OnBnClickedConnect(){
	POSITION pos = m_VoodooList.GetFirstSelectedItemPosition();
	while(pos != NULL)
	{
		int index = m_VoodooList.GetNextSelectedItem(pos);
		if (index >= 0){
			SVoodooClient* item = (SVoodooClient*)m_VoodooList.GetItemData(index);
			if(!theApp.voodoo->IsValudKnownClinet(item)){
				ReloadVoodooList();
				return;
			}
			theApp.voodoo->ConnectVoodooClient(item->clientAddress,item->clientPort,(item->m_uAction == VA_NONE) ? VA_QUERY : item->m_uAction);
			m_VoodooList.Update(index);
		}
	}
}

void CVoodooListDlg::OnBnClickedDisconnect(){
	POSITION pos = m_VoodooList.GetFirstSelectedItemPosition();
	while(pos != NULL)
	{
		int index = m_VoodooList.GetNextSelectedItem(pos);
		if (index >= 0){
			SVoodooClient* item = (SVoodooClient*)m_VoodooList.GetItemData(index);
			if(!theApp.voodoo->IsValudKnownClinet(item)){
				ReloadVoodooList();
				return;
			}
			CVoodooSocket* socket = theApp.voodoo->GetVoodooSocket(item->clientIP,item->clientPort,item->socketPort);
			if(socket){
				socket->SetAction(VA_NONE);
				socket->SendGoodBy();
				socket->Disconnect(_T("Manual Disconnect"));
			}
			m_VoodooList.Update(index);
		}
	}
}

void CVoodooListDlg::OnBnClickedSearch(){
	if(thePrefs.IsVoodooCastEnabled()){
		ModLog(GetResString(IDS_X_VOODOO_SEARCH));
		theApp.lancast->SendVoodoo(VA_QUERY);
	}
}

void CVoodooListDlg::OnBnClickedAdd(){

	CString Address;
	GetDlgItem(IDC_IPADDRESS)->GetWindowText(Address);

	DWORD clientIP = inet_addr(CT2CA(Address));
	if(clientIP == INADDR_NONE)
		clientIP = 0;

	CString Port;
	GetDlgItem(IDC_SPORT)->GetWindowText(Port);

	uint16 nPort = (uint16)_tstoi(Port);
	if(nPort == 0)
		nPort = thePrefs.GetVoodooPort();

	if (theApp.voodoo->GetClientByAddress(Address, nPort) != NULL
	 || theApp.voodoo->GetClientByIP(clientIP, nPort) != NULL){
		MessageBox(GetResString(IDS_X_VOODOO_ADD_BOX_DENIDED),GetResString(IDS_X_VOODOO_ADD),MB_ICONEXCLAMATION);
		return;
	}

	SVoodooClient* new_client = new SVoodooClient;
	new_client->clientAddress = Address;
	new_client->clientIP = clientIP;
	new_client->clientPort = nPort;
	GetDlgItem(IDC_SSPELL)->GetWindowText(new_client->m_sSpell);
	new_client->m_bUsable = false; // Query the new added entry first to get a true, when the clinet allows slaving
	GetDlgItem(IDC_SNAME)->GetWindowText(new_client->m_sName);
	new_client->m_uAction = (uint8)((CComboBox*)GetDlgItem(IDC_STYPE))->GetCurSel();
	new_client->m_uType = (uint8)((CComboBox*)GetDlgItem(IDC_SSOFTWARE))->GetCurSel();

	theApp.voodoo->known_list.AddTail(new_client);
	LoadVoodooItem(new_client);
	theApp.voodoo->SaveKnownToFile();

	if(MessageBox(GetResString(IDS_X_VOODOO_ADD_BOX_SUCCES),GetResString(IDS_X_VOODOO_ADD),MB_YESNO | MB_ICONQUESTION) == IDYES)
		theApp.voodoo->ConnectVoodooClient(new_client->clientAddress,new_client->clientPort,VA_QUERY);
}

void CVoodooListDlg::OnBnClickedEdit(){
	POSITION pos = m_VoodooList.GetFirstSelectedItemPosition();
	if(pos != NULL)
	{
		int index = m_VoodooList.GetNextSelectedItem(pos);
		if (index >= 0){
			SVoodooClient* item = (SVoodooClient*)m_VoodooList.GetItemData(index);
			if(!theApp.voodoo->IsValudKnownClinet(item)){
				ReloadVoodooList();
				return;
			}

			if(theApp.voodoo->GetVoodooSocket(item->clientIP,item->clientPort,item->socketPort) != NULL){
				MessageBox(GetResString(IDS_X_VOODOO_EDIT_BOX_DENIDED),GetResString(IDS_X_VOODOO_EDIT),MB_ICONEXCLAMATION);
				return;
			}

			CString Address;
			GetDlgItem(IDC_IPADDRESS)->GetWindowText(Address);

			DWORD clientIP = inet_addr(CT2CA(Address));
			if(clientIP == INADDR_NONE)
				clientIP = 0;

			CString Port;
			GetDlgItem(IDC_SPORT)->GetWindowText(Port);

			uint16 nPort = (uint16)_tstoi(Port);
			if(nPort == 0)
				nPort = thePrefs.GetVoodooPort();

			SVoodooClient* Found;
			if (((Found = theApp.voodoo->GetClientByAddress(Address, nPort)) != NULL && Found != item)
			|| ((Found = theApp.voodoo->GetClientByIP(clientIP, nPort)) != NULL && Found != item)){
				MessageBox(GetResString(IDS_X_VOODOO_ADD_BOX_DENIDED),GetResString(IDS_X_VOODOO_ADD),MB_ICONEXCLAMATION);
				return;
			}

			item->clientAddress = Address;
			item->clientIP = clientIP;
			item->clientPort = nPort;
			GetDlgItem(IDC_SSPELL)->GetWindowText(item->m_sSpell);
			GetDlgItem(IDC_SNAME)->GetWindowText(item->m_sName);
			item->m_uAction = (uint8)((CComboBox*)GetDlgItem(IDC_STYPE))->GetCurSel();
			item->m_uType = (uint8)((CComboBox*)GetDlgItem(IDC_SSOFTWARE))->GetCurSel();

			LoadVoodooItem(item);
			theApp.voodoo->SaveKnownToFile();
		}
	}
}

void CVoodooListDlg::OnBnClickedRemove(){

	if (m_VoodooList.GetSelectedCount() == 0 
	|| IDNO == AfxMessageBox(GetResString(IDS_X_CONFIRM_VOODOODELETE),MB_ICONWARNING | MB_ICONQUESTION | MB_DEFBUTTON2 | MB_YESNO))
		return;
	
	CTypedPtrList<CPtrList, SVoodooClient*> selectedList;
	POSITION pos = m_VoodooList.GetFirstSelectedItemPosition();
	while(pos != NULL)
	{
		int index = m_VoodooList.GetNextSelectedItem(pos);
		if (index >= 0)
			selectedList.AddTail((SVoodooClient*)m_VoodooList.GetItemData(index));
	}

	int iSkiped = 0;
	while (!selectedList.IsEmpty())
	{
		SVoodooClient* item = selectedList.RemoveHead();

		if(theApp.voodoo->GetVoodooSocket(item->clientIP,item->clientPort,item->socketPort) != NULL){
			iSkiped ++;
			continue;
		}

		POSITION toremove = theApp.voodoo->known_list.Find(item);
		if(toremove){
			theApp.voodoo->known_list.RemoveAt(toremove);
			theApp.voodoo->SaveKnownToFile();
			delete item;
		}

		LVFINDINFO find;
		find.flags = LVFI_PARAM;
		find.lParam = (LPARAM)item;
		sint32 result = m_VoodooList.FindItem(&find);
		if (result != (-1) )
			m_VoodooList.DeleteItem(result);
	}
	if(iSkiped)
		AfxMessageBox(StrLine(GetResString(IDS_X_VOODOODELETE_SKIPPED),iSkiped),MB_ICONWARNING | MB_OK);
}

void CVoodooListDlg::OnDestroy()
{
	if (m_timer){
		KillTimer(m_timer);
		m_timer = 0;
	}

	CModelessResizableDialog::OnDestroy(); // NEO: MLD - [ModelesDialogs]
}

#endif // VOODOO // NEO: VOODOO END <-- Xanatos --
