// NEO: ASF - [AdvancedServerFilter] -- Xanatos -->

#pragma once
#include "Modeless.h" // NEO: MLD - [ModelesDialogs]

class CServerList;
class CServer;

class CServerFilter : public CModelessDialog // NEO: MLD - [ModelesDialogs]
{
	DECLARE_DYNAMIC(CServerFilter)

 public:
	CServerFilter(CServerList* sl);
	virtual ~CServerFilter();
	void Localize();

	enum { IDD = IDD_SERVERFILTER };

 protected:
	virtual BOOL OnInitDialog();
	virtual void DoDataExchange(CDataExchange* pDX);

	DECLARE_MESSAGE_MAP()

 public:
	afx_msg void OnBnClickedApply();
	afx_msg void OnBnClickedCancel();
	afx_msg void OnBnClickedFilterRemove();
	afx_msg void OnChangeFilterlist();
	afx_msg void OnChangeFilterOp();

	bool FilterQuery(CServer* srv);
	uint32 ServerItem(CServer* srv, int item);

 private:
	bool m_changes;
	CServerList* serverlist;
	CServerList* backupsrvlist;
	CComboBox filterlist1;
	CComboBox filterlist2;
	CComboBox filterop;
};
// NEO: ASF END <-- Xanatos --
