//this file is part of NeoMule
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


// Modeless.cpp : implementation file
//

#include "stdafx.h"
#include "Modeless.h"
#include "emule.h"
#include "emuleDlg.h"
#include "Neo/CP/PreferencesDlg.h" // NEO: NCFG - [NeoConfiguration] <-- Xanatos --
#include "UserMsgs.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

// NEO: MLD - [ModelesDialogs] -- Xanatos -->

// CModelessDialog

IMPLEMENT_DYNAMIC(CModelessDialog, CDialog)

BEGIN_MESSAGE_MAP(CModelessDialog, CDialog)
	ON_COMMAND(IDOK, OnOK)
	ON_COMMAND(IDCANCEL, OnCancel)
END_MESSAGE_MAP()

CModelessDialog::CModelessDialog(UINT nIDTemplate, CWnd* pParent, BOOL bDeleteOnClose)
	:CDialog(nIDTemplate,pParent)
{
	m_nIDTemplate = nIDTemplate;
	m_pParent = pParent;
	m_bDeleteOnClose = bDeleteOnClose;
	m_bActive = FALSE;
}

void CModelessDialog::OpenDialog()
{
	if (!m_bActive) {
		m_bActive = TRUE;
		Create(m_nIDTemplate, theApp.emuledlg); // WS_SYSMENU | WS_POPUP | WS_CAPTION | DS_MODALFRAME | DS_CONTEXTHELP | WS_VISIBLE | WS_MINIMIZEBOX
	}
	ShowWindow(SW_SHOW);
	SetFocus();
}

void CModelessDialog::CloseDialog()
{
	if (m_bActive)
		DestroyWindow();
}

bool CModelessDialog::IsDialogOpen()
{
	return (m_bActive == TRUE);
}

BOOL CModelessDialog::OnInitDialog()
{
	// Modeless property sheets don't have Ok and Cancel buttons by default
	// This little trick fulls the property sheet into thinking it's modal
	// during it's init, so that it doesn't disable the Ok and Cancel buttons
//	BOOL old_bModeless = m_bModeless;
	UINT old_nFlags = m_nFlags;
//	m_bModeless = FALSE;
	m_nFlags |= WF_CONTINUEMODAL;
	BOOL bResult = CDialog::OnInitDialog();
//	m_bModeless = old_bModeless;
	m_nFlags = old_nFlags;
	return bResult;
}

void CModelessDialog::OnOK()
{
	//SendMessage(WM_COMMAND, ID_APPLY_NOW);
	UpdateData();
	DestroyWindow();
}

void CModelessDialog::OnCancel()
{
	DestroyWindow();
}

void CModelessDialog::PostNcDestroy()
{
	m_bActive = FALSE;
	if (m_bDeleteOnClose)
		delete this;
}



// CModelessResizableDialog

//IMPLEMENT_DYNAMIC(CModelessResizableDialog, CResizableDialog)

BEGIN_MESSAGE_MAP(CModelessResizableDialog, CResizableDialog)
	ON_COMMAND(IDOK, OnOK)
	ON_COMMAND(IDCANCEL, OnCancel)
END_MESSAGE_MAP()

CModelessResizableDialog::CModelessResizableDialog(UINT nIDTemplate, CWnd* pParent, BOOL bDeleteOnClose)
	:CResizableDialog(nIDTemplate,pParent)
{
	m_nIDTemplate = nIDTemplate;
	m_pParent = pParent;
	m_bDeleteOnClose = bDeleteOnClose;
	m_bActive = FALSE;
}

void CModelessResizableDialog::OpenDialog()
{
	if (!m_bActive) {
		m_bActive = TRUE;
		Create(m_nIDTemplate, theApp.emuledlg); // WS_SYSMENU | WS_POPUP | WS_CAPTION | DS_MODALFRAME | DS_CONTEXTHELP | WS_VISIBLE | WS_MINIMIZEBOX
	}
	ShowWindow(SW_SHOW);
	SetFocus();
}

void CModelessResizableDialog::CloseDialog()
{
	if (m_bActive)
		DestroyWindow();
}

bool CModelessResizableDialog::IsDialogOpen()
{
	return (m_bActive == TRUE);
}

BOOL CModelessResizableDialog::OnInitDialog()
{
	// Modeless property sheets don't have Ok and Cancel buttons by default
	// This little trick fulls the property sheet into thinking it's modal
	// during it's init, so that it doesn't disable the Ok and Cancel buttons
//	BOOL old_bModeless = m_bModeless;
	UINT old_nFlags = m_nFlags;
//	m_bModeless = FALSE;
	m_nFlags |= WF_CONTINUEMODAL;
	BOOL bResult = CResizableDialog::OnInitDialog();
//	m_bModeless = old_bModeless;
	m_nFlags = old_nFlags;
	return bResult;
}

void CModelessResizableDialog::OnOK()
{
	//SendMessage(WM_COMMAND, ID_APPLY_NOW);
	UpdateData();
	DestroyWindow();
}

void CModelessResizableDialog::OnCancel()
{
	DestroyWindow();
}

void CModelessResizableDialog::PostNcDestroy()
{
	m_bActive = FALSE;
	if (m_bDeleteOnClose)
		delete this;
}



// CModelessResizableSheet

IMPLEMENT_DYNAMIC(CModelessResizableSheet, CResizableSheet)

BEGIN_MESSAGE_MAP(CModelessResizableSheet, CResizableSheet)
	ON_COMMAND(IDOK, OnOK)
	ON_COMMAND(IDCANCEL, OnCancel)
END_MESSAGE_MAP()

CModelessResizableSheet::CModelessResizableSheet(BOOL bDeleteOnClose)
{
	m_bDeleteOnClose = bDeleteOnClose;
	m_bActive = FALSE;
}

void CModelessResizableSheet::OpenDialog()
{
	if (!m_bActive) {
		m_bActive = TRUE;
		Create(theApp.emuledlg, WS_SYSMENU | WS_POPUP | WS_CAPTION | DS_MODALFRAME | DS_CONTEXTHELP | WS_VISIBLE | WS_MINIMIZEBOX);
	}
	ShowWindow(SW_SHOW);
	SetFocus();
}

void CModelessResizableSheet::CloseDialog()
{
	if (m_bActive)
		DestroyWindow();
}

bool CModelessResizableSheet::IsDialogOpen()
{
	return (m_bActive == TRUE);
}

BOOL CModelessResizableSheet::OnInitDialog()
{
	// Modeless property sheets don't have Ok and Cancel buttons by default
	// This little trick fulls the property sheet into thinking it's modal
	// during it's init, so that it doesn't disable the Ok and Cancel buttons
	BOOL old_bModeless = m_bModeless;
	UINT old_nFlags = m_nFlags;
	m_bModeless = FALSE;
	m_nFlags |= WF_CONTINUEMODAL;
	BOOL bResult = CResizableSheet::OnInitDialog();
	m_bModeless = old_bModeless;
	m_nFlags = old_nFlags;
	return bResult;
}

void CModelessResizableSheet::OnOK()
{
	SendMessage(WM_COMMAND, ID_APPLY_NOW);
	UpdateData();
	DestroyWindow();
}

void CModelessResizableSheet::OnCancel()
{
	DestroyWindow();
}

void CModelessResizableSheet::PostNcDestroy()
{
	m_bActive = FALSE;
	if (m_bDeleteOnClose)
		delete this;
}




// CModelessPropertySheet

IMPLEMENT_DYNAMIC(CModelessPropertySheet, CPropertySheet)

BEGIN_MESSAGE_MAP(CModelessPropertySheet, CPropertySheet)
	ON_COMMAND(IDOK, OnOK)
	ON_COMMAND(IDCANCEL, OnCancel)
END_MESSAGE_MAP()

CModelessPropertySheet::CModelessPropertySheet(BOOL bDeleteOnClose)
{
	m_bDeleteOnClose = bDeleteOnClose;
	m_bActive = FALSE;
}

void CModelessPropertySheet::OpenDialog()
{
	if (!m_bActive) {
		m_bActive = TRUE;
		Create(theApp.emuledlg, WS_SYSMENU | WS_POPUP | WS_CAPTION | DS_MODALFRAME | DS_CONTEXTHELP | WS_VISIBLE | WS_MINIMIZEBOX);
	}
	ShowWindow(SW_SHOW);
	SetFocus();
}

void CModelessPropertySheet::CloseDialog()
{
	if (m_bActive)
		DestroyWindow();
}

bool CModelessPropertySheet::IsDialogOpen()
{
	return (m_bActive == TRUE);
}

BOOL CModelessPropertySheet::OnInitDialog()
{
	// Modeless property sheets don't have Ok and Cancel buttons by default
	// This little trick fulls the property sheet into thinking it's modal
	// during it's init, so that it doesn't disable the Ok and Cancel buttons
	BOOL old_bModeless = m_bModeless;
	UINT old_nFlags = m_nFlags;
	m_bModeless = FALSE;
	m_nFlags |= WF_CONTINUEMODAL;
	BOOL bResult = CPropertySheet::OnInitDialog();
	m_bModeless = old_bModeless;
	m_nFlags = old_nFlags;
	return bResult;
}

void CModelessPropertySheet::OnOK()
{
	SendMessage(WM_COMMAND, ID_APPLY_NOW);
	UpdateData();
	DestroyWindow();
}

void CModelessPropertySheet::OnCancel()
{
	DestroyWindow();
}

void CModelessPropertySheet::PostNcDestroy()
{
	m_bActive = FALSE;
	if (m_bDeleteOnClose)
		delete this;
}





static CMap<CObject*, CObject*, CListViewWalkerModelessPropertySheetInterface*, CListViewWalkerModelessPropertySheetInterface*> m_PropertyInterfaceMap;

// CListViewWalkerModelessPropertySheet

IMPLEMENT_DYNAMIC(CListViewWalkerModelessPropertySheet, CListViewWalkerPropertySheet)

BEGIN_MESSAGE_MAP(CListViewWalkerModelessPropertySheet, CListViewWalkerPropertySheet)
	ON_COMMAND(IDOK, OnOK)
	ON_COMMAND(IDCANCEL, OnCancel)
END_MESSAGE_MAP()

CListViewWalkerModelessPropertySheet::CListViewWalkerModelessPropertySheet(CListCtrlItemWalk* pListCtrl, BOOL bDeleteOnClose)
	: CListViewWalkerPropertySheet(pListCtrl)
{
	m_bDeleteOnClose = bDeleteOnClose;
	m_bActive = FALSE;
}

CListViewWalkerModelessPropertySheet::~CListViewWalkerModelessPropertySheet()
{
	if (m_bActive)
		DestroyWindow();
	for (int i = 0; i < m_interfaces.GetSize(); i++)
		m_interfaces[i]->m_propertySheets.Remove(this);
}

void CListViewWalkerModelessPropertySheet::OpenDialog()
{
	if (!m_bActive) {
		m_bActive = TRUE;
		Create(theApp.emuledlg, WS_SYSMENU | WS_POPUP | WS_CAPTION | DS_MODALFRAME | DS_CONTEXTHELP | WS_VISIBLE | WS_MINIMIZEBOX);
	}
	ShowWindow(SW_SHOW);
	SetFocus();
}

void CListViewWalkerModelessPropertySheet::CloseDialog()
{
	if (m_bActive)
		DestroyWindow();
}

BOOL CListViewWalkerModelessPropertySheet::PreTranslateMessage(MSG* pMsg)
{
	if (pMsg->message == UM_DATA_CHANGED)
	{
		for (int i = 0; i < m_interfaces.GetSize(); i++)
			m_interfaces[i]->m_propertySheets.Remove(this);
		m_interfaces.RemoveAll();
		for (int i = 0; i < m_aItems.GetSize(); i++) {
			CListViewWalkerModelessPropertySheetInterface* cur_interface;
			if (!m_PropertyInterfaceMap.Lookup(m_aItems[i], cur_interface)) {
				ASSERT(FALSE);
				continue;
			}
			cur_interface->m_propertySheets.Add(this);
			m_interfaces.Add(cur_interface);
		}
	}

	return __super::PreTranslateMessage(pMsg);
}

BOOL CListViewWalkerModelessPropertySheet::OnInitDialog()
{
	// Modeless property sheets don't have Ok and Cancel buttons by default
	// This little trick fulls the property sheet into thinking it's modal
	// during it's init, so that it doesn't disable the Ok and Cancel buttons
	BOOL old_bModeless = m_bModeless;
	UINT old_nFlags = m_nFlags;
	m_bModeless = FALSE;
	m_nFlags |= WF_CONTINUEMODAL;
	BOOL bResult = CListViewWalkerPropertySheet::OnInitDialog();
	m_bModeless = old_bModeless;
	m_nFlags = old_nFlags;
	return bResult;
}

void CListViewWalkerModelessPropertySheet::OnOK()
{
	SendMessage(WM_COMMAND, ID_APPLY_NOW);
	UpdateData();
	DestroyWindow();
}

void CListViewWalkerModelessPropertySheet::OnCancel()
{
	DestroyWindow();
}

void CListViewWalkerModelessPropertySheet::PostNcDestroy()
{
	m_bActive = FALSE;
	if (m_bDeleteOnClose)
		delete this;
}

void CListViewWalkerModelessPropertySheet::RemoveData(CObject* toremove)
{
	if (!m_aItems.Remove(toremove))
		return;
	SendMessage(UM_DATA_CHANGED);

	for (int iPage = 0; iPage < GetPageCount(); iPage++)
	{
		CPropertyPage* pPage = GetPage(iPage);
		if (pPage && pPage->m_hWnd)
		{
			pPage->SendMessage(UM_DATA_CHANGED);
			pPage->SetModified(FALSE);
		}
	}
	GetActivePage()->OnSetActive();
}


// CListViewWalkerModelessPropertySheetInterface

IMPLEMENT_DYNAMIC(CListViewWalkerModelessPropertySheetInterface, CObject)

CListViewWalkerModelessPropertySheetInterface::CListViewWalkerModelessPropertySheetInterface(CObject* owner)
{
	m_owner = owner;
	m_PropertyInterfaceMap.SetAt(m_owner, this);
}

CListViewWalkerModelessPropertySheetInterface::~CListViewWalkerModelessPropertySheetInterface()
{
	// Detach interface from all dialogs
	// A multi-object dialog may remain open if it has other items
	for (int i = 0; i < m_propertySheets.GetSize(); i++) {
		CListViewWalkerModelessPropertySheet* propertySheet = m_propertySheets[i];
		propertySheet->m_interfaces.Remove(this);
		if (propertySheet->m_interfaces.GetSize())
			propertySheet->RemoveData(m_owner);
		else
			propertySheet->CloseDialog();
	}
	m_PropertyInterfaceMap.RemoveKey(m_owner);
}

bool CListViewWalkerModelessPropertySheetInterface::IsDialogOpen() const
{
	return (m_propertySheets.GetSize() > 0);
}

void CListViewWalkerModelessPropertySheetInterface::DropControlHandle(CListCtrlItemWalk* pListCtrl)
{
	for (int i = 0; i < m_propertySheets.GetSize(); i++) {
		CListViewWalkerModelessPropertySheet* propertySheet = m_propertySheets[i];
		if(pListCtrl == NULL || propertySheet->m_pListCtrl == pListCtrl)
			propertySheet->m_pListCtrl = NULL;
	}
}

void CListViewWalkerModelessPropertySheetInterface::OpenPropertySheet(const CSimpleArray<CListViewWalkerModelessPropertySheetInterface*>* paOthers, ...)
{
	if (paOthers->Find(this) == -1) {
		ASSERT(FALSE);
		return;
	}
	for (int i = 0; i < m_propertySheets.GetSize(); i++) {	// Do not double-open if avoidable
		CListViewWalkerModelessPropertySheet* propertySheet = m_propertySheets[i];
		bool valid = false;
		// Since there's no add data, only accept a perfect match
		if (propertySheet->m_interfaces.GetSize() == paOthers->GetSize()) {
			valid = true;
			for (int i = 0; i < propertySheet->m_interfaces.GetSize(); i++)
				if (paOthers->Find(propertySheet->m_interfaces[i]) == -1) {
					valid = false;
					break;
				}
		}
		if (valid) {
			propertySheet->OpenDialog();	// Show dialog
			return;
		}
	}
	va_list args;
	va_start(args, paOthers);
	CListViewWalkerModelessPropertySheet* propertySheet = CreatePropertySheet(args);
	va_end(args);
	for (int i = 0; i < paOthers->GetSize(); i++) {
		(*paOthers)[i]->m_propertySheets.Add(propertySheet);
		propertySheet->m_interfaces.Add((*paOthers)[i]);
	}
	propertySheet->OpenDialog();
}

CObject* CListViewWalkerModelessPropertySheetInterface::GetOwner() const
{
	return m_owner;
}

int	CListViewWalkerModelessPropertySheetInterface::GetPropertySheetCount() const
{
	return m_propertySheets.GetSize();
}

CListViewWalkerModelessPropertySheet*	CListViewWalkerModelessPropertySheetInterface::GetPropertySheet(int i) const
{
	return m_propertySheets[i];
}




static CMap<CObject*, CObject*, CListViewWalkerModelessPreferenceSheetInterface*, CListViewWalkerModelessPreferenceSheetInterface*> m_PreferenceInterfaceMap;

// CListViewWalkerModelessPreferenceSheet

IMPLEMENT_DYNAMIC(CListViewWalkerModelessPreferenceSheet, CListViewWalkerPreferenceSheet)

BEGIN_MESSAGE_MAP(CListViewWalkerModelessPreferenceSheet, CListViewWalkerPreferenceSheet)
	ON_COMMAND(IDOK, OnOK)
	ON_COMMAND(IDCANCEL, OnCancel)
END_MESSAGE_MAP()

CListViewWalkerModelessPreferenceSheet::CListViewWalkerModelessPreferenceSheet(CListCtrlItemWalk* pListCtrl, BOOL bDeleteOnClose)
	: CListViewWalkerPreferenceSheet(pListCtrl)
{
	m_bDeleteOnClose = bDeleteOnClose;
	m_bActive = FALSE;
}

CListViewWalkerModelessPreferenceSheet::~CListViewWalkerModelessPreferenceSheet()
{
	if (m_bActive)
		DestroyWindow();
	for (int i = 0; i < m_interfaces.GetSize(); i++)
		m_interfaces[i]->m_PreferencesSheets.Remove(this);
}

void CListViewWalkerModelessPreferenceSheet::OpenDialog()
{
	if (!m_bActive) {
		m_bActive = TRUE;
		Create(theApp.emuledlg, WS_SYSMENU | WS_POPUP | WS_CAPTION | DS_MODALFRAME | DS_CONTEXTHELP | WS_VISIBLE | WS_MINIMIZEBOX);
	}
	ShowWindow(SW_SHOW);
	SetFocus();
}

void CListViewWalkerModelessPreferenceSheet::CloseDialog()
{
	if (m_bActive)
		DestroyWindow();
}

BOOL CListViewWalkerModelessPreferenceSheet::PreTranslateMessage(MSG* pMsg)
{
	if (pMsg->message == UM_DATA_CHANGED)
	{
		for (int i = 0; i < m_interfaces.GetSize(); i++)
			m_interfaces[i]->m_PreferencesSheets.Remove(this);
		m_interfaces.RemoveAll();
		for (int i = 0; i < m_aItems.GetSize(); i++) {
			CListViewWalkerModelessPreferenceSheetInterface* cur_interface;
			if (!m_PreferenceInterfaceMap.Lookup(m_aItems[i], cur_interface)) {
				ASSERT(FALSE);
				continue;
			}
			cur_interface->m_PreferencesSheets.Add(this);
			m_interfaces.Add(cur_interface);
		}
	}

	return __super::PreTranslateMessage(pMsg);
}

BOOL CListViewWalkerModelessPreferenceSheet::OnInitDialog()
{
	// Modeless Preference sheets don't have Ok and Cancel buttons by default
	// This little trick fulls the Preference sheet into thinking it's modal
	// during it's init, so that it doesn't disable the Ok and Cancel buttons
	BOOL old_bModeless = m_bModeless;
	UINT old_nFlags = m_nFlags;
	m_bModeless = FALSE;
	m_nFlags |= WF_CONTINUEMODAL;
	BOOL bResult = CListViewWalkerPreferenceSheet::OnInitDialog();
	m_bModeless = old_bModeless;
	m_nFlags = old_nFlags;
	return bResult;
}

void CListViewWalkerModelessPreferenceSheet::OnOK()
{
	SendMessage(WM_COMMAND, ID_APPLY_NOW);
	UpdateData();
	DestroyWindow();
}

void CListViewWalkerModelessPreferenceSheet::OnCancel()
{
	DestroyWindow();
}

void CListViewWalkerModelessPreferenceSheet::PostNcDestroy()
{
	m_bActive = FALSE;
	if (m_bDeleteOnClose)
		delete this;
}

void CListViewWalkerModelessPreferenceSheet::RemoveData(CObject* toremove)
{
	if (!m_aItems.Remove(toremove))
		return;
	SendMessage(UM_DATA_CHANGED);

	for (int iPage = 0; iPage < GetPageCount(); iPage++)
	{
		CPropertyPage* pPage = GetPage(iPage);
		if (pPage && pPage->m_hWnd)
		{
			pPage->SendMessage(UM_DATA_CHANGED);
			pPage->SetModified(FALSE);
		}
	}
	GetActivePage()->OnSetActive();
}


// CListViewWalkerModelessPreferenceSheetInterface

IMPLEMENT_DYNAMIC(CListViewWalkerModelessPreferenceSheetInterface, CObject)

CListViewWalkerModelessPreferenceSheetInterface::CListViewWalkerModelessPreferenceSheetInterface(CObject* owner)
{
	m_owner = owner;
	m_PreferenceInterfaceMap.SetAt(m_owner, this);
}

CListViewWalkerModelessPreferenceSheetInterface::~CListViewWalkerModelessPreferenceSheetInterface()
{
	// Detach interface from all dialogs
	// A multi-object dialog may remain open if it has other items
	for (int i = 0; i < m_PreferencesSheets.GetSize(); i++) {
		CListViewWalkerModelessPreferenceSheet* PreferencesSheet = m_PreferencesSheets[i];
		PreferencesSheet->m_interfaces.Remove(this);
		if (PreferencesSheet->m_interfaces.GetSize())
			PreferencesSheet->RemoveData(m_owner);
		else
			PreferencesSheet->CloseDialog();
	}
	m_PreferenceInterfaceMap.RemoveKey(m_owner);
}

bool CListViewWalkerModelessPreferenceSheetInterface::IsDialogOpen() const
{
	return (m_PreferencesSheets.GetSize() > 0);
}

void CListViewWalkerModelessPreferenceSheetInterface::DropControlHandle(CListCtrlItemWalk* pListCtrl)
{
	for (int i = 0; i < m_PreferencesSheets.GetSize(); i++) {
		CListViewWalkerModelessPreferenceSheet* PreferencesSheet = m_PreferencesSheets[i];
		if(pListCtrl == NULL || PreferencesSheet->m_pListCtrl == pListCtrl)
			PreferencesSheet->m_pListCtrl = NULL;
	}
}

void CListViewWalkerModelessPreferenceSheetInterface::OpenPreferenceSheet(const CSimpleArray<CListViewWalkerModelessPreferenceSheetInterface*>* paOthers, ...)
{
	if (paOthers->Find(this) == -1) {
		ASSERT(FALSE);
		return;
	}
	for (int i = 0; i < m_PreferencesSheets.GetSize(); i++) {	// Do not double-open if avoidable
		CListViewWalkerModelessPreferenceSheet* PreferencesSheet = m_PreferencesSheets[i];
		bool valid = false;
		// Since there's no add data, only accept a perfect match
		if (PreferencesSheet->m_interfaces.GetSize() == paOthers->GetSize()) {
			valid = true;
			for (int i = 0; i < PreferencesSheet->m_interfaces.GetSize(); i++)
				if (paOthers->Find(PreferencesSheet->m_interfaces[i]) == -1) {
					valid = false;
					break;
				}
		}
		if (valid) {
			PreferencesSheet->OpenDialog();	// Show dialog
			return;
		}
	}
	va_list args;
	va_start(args, paOthers);
	CListViewWalkerModelessPreferenceSheet* PreferencesSheet = CreatePreferencesSheet(args);
	va_end(args);
	for (int i = 0; i < paOthers->GetSize(); i++) {
		(*paOthers)[i]->m_PreferencesSheets.Add(PreferencesSheet);
		PreferencesSheet->m_interfaces.Add((*paOthers)[i]);
	}
	PreferencesSheet->OpenDialog();
}

CObject* CListViewWalkerModelessPreferenceSheetInterface::GetOwner() const
{
	return m_owner;
}

int	CListViewWalkerModelessPreferenceSheetInterface::GetPreferencesSheetCount() const
{
	return m_PreferencesSheets.GetSize();
}

CListViewWalkerModelessPreferenceSheet*	CListViewWalkerModelessPreferenceSheetInterface::GetPreferencesSheet(int i) const
{
	return m_PreferencesSheets[i];
}
// NEO: MLD END <-- Xanatos --