//this file is part of eMule
//Copyright (C)2006 David Xanatos ( Xanatos@Lycos.at / http://neomule.sourceforge.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include "stdafx.h" 
#include "emule.h"
#include "ExtraInfo.h"
#include "OtherFunctions.h"
#include "ClientList.h"
#include "DownloadQueue.h"
#include "UpDownClient.h"
#include "PartFile.h"
#include "UserMsgs.h"
#include "SharedFileList.h"
#include "ClientCredits.h"
#include "Preferences.h"
#include "Neo/NeoOpCodes.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

// NEO: NXI - [NeoExtraInfo] -- Xanatos -->

///////////////////////////////////////////////////////////////////////////////
// CClientExtraInfoPage

IMPLEMENT_DYNAMIC(CClientExtraInfoPage, CResizablePage)

BEGIN_MESSAGE_MAP(CClientExtraInfoPage, CResizablePage)
	ON_MESSAGE(UM_DATA_CHANGED, OnDataChanged)
END_MESSAGE_MAP()

CClientExtraInfoPage::CClientExtraInfoPage()
	: CResizablePage(CClientExtraInfoPage::IDD,0)
{
	m_paClients = NULL;
	m_bDataChanged = false;
	m_strCaption = GetResString(IDS_X_EXTRA_INFO);
	m_psp.pszTitle = m_strCaption;
	m_psp.dwFlags |= PSP_USETITLE;
}

CClientExtraInfoPage::~CClientExtraInfoPage()
{
}

void CClientExtraInfoPage::DoDataExchange(CDataExchange* pDX)
{
	CResizablePage::DoDataExchange(pDX);
}

BOOL CClientExtraInfoPage::OnInitDialog()
{
	CResizablePage::OnInitDialog();
	InitWindowStyles(this);

	AddAnchor(IDC_STATIC30, TOP_LEFT, TOP_RIGHT);
	AddAnchor(IDC_STATIC39, TOP_LEFT, TOP_RIGHT);
	AddAnchor(IDC_STATIC32, TOP_LEFT, TOP_RIGHT);
	AddAnchor(IDC_STATIC49, TOP_LEFT, TOP_RIGHT);
	//AddAnchor(IDC_, TOP_LEFT, TOP_RIGHT);

	Localize();
	return TRUE;
}

BOOL CClientExtraInfoPage::OnSetActive()
{
	if (!CResizablePage::OnSetActive())
		return FALSE;

	if (m_bDataChanged)
	{
		CUpDownClient* client = STATIC_DOWNCAST(CUpDownClient, (*m_paClients)[0]);

		if(client->m_ExtraInfo == NULL){
			DisableDialog();
			return TRUE;
		}
		DisableDialog(false);

		CString buffer;
		
		if (theApp.clientcredits->CryptoAvailable()){
			if(client->m_ExtraInfo->SUIState == 0xFF)  GetDlgItem(IDC_DSUI)->SetWindowText(_T("?"));  else
			switch(client->Credits()->GetCurrentIdentState(client->GetIP())){
				case IS_NOTAVAILABLE:
					GetDlgItem(IDC_DSUI)->SetWindowText(GetResString(IDS_IDENTNOSUPPORT));
					break;
				case IS_IDFAILED:
					GetDlgItem(IDC_DSUI)->SetWindowText(GetResString(IDS_IDENTFAILED));
					break;
				case IS_IDNEEDED:
					GetDlgItem(IDC_DSUI)->SetWindowText(GetResString(IDS_X_IDENTNEED)); // NEO: MOD <-- Xanatos --
					break;
				case IS_IDBADGUY:
					GetDlgItem(IDC_DSUI)->SetWindowText(GetResString(IDS_X_IDBADGUY)); // NEO: MOD <-- Xanatos --
					break;
				case IS_IDENTIFIED:
					GetDlgItem(IDC_DSUI)->SetWindowText(GetResString(IDS_IDENTOK));
					break;
				default:
					GetDlgItem(IDC_DSUI)->SetWindowText(GetResString(IDS_X_EXI_UNKNOWN));
			}		
		}
		else
			GetDlgItem(IDC_DSUI)->SetWindowText(GetResString(IDS_IDENTNOSUPPORT));

		if(client->m_ExtraInfo->UpTime == 0xFFFFFFFF) buffer = _T("?"); else
		GetDlgItem(IDC_DUPTIME)->SetWindowText(CastSecondsToHM(client->m_ExtraInfo->UpTime));

		if(client->m_ExtraInfo->IDAge == 0xFFFFFFFF) buffer = _T("?"); else
		GetDlgItem(IDC_DIDAGE)->SetWindowText(CastSecondsToHM(client->m_ExtraInfo->IDAge));

		if(client->m_ExtraInfo->UploadCapacity == 0xFFFF) buffer = _T("?"); else
		GetDlgItem(IDC_DULBW)->SetWindowText(CastItoXBytes((uint32)KB2B(client->m_ExtraInfo->UploadCapacity), false, true));

		if(client->m_ExtraInfo->DownloadCapacity == 0xFFFF) buffer = _T("?"); else
		GetDlgItem(IDC_DDLBW)->SetWindowText(CastItoXBytes((uint32)KB2B(client->m_ExtraInfo->DownloadCapacity), false, true));

		
		if(client->m_ExtraInfo->FileULPriority == 0xFF) buffer = _T("?"); else
		switch(client->m_ExtraInfo->FileULPriority){
			case PR_VERYLOW: buffer = GetResString(IDS_PRIOVERYLOW); break;
			case PR_LOW: buffer = GetResString(IDS_PRIOLOW); break;
			case PR_NORMAL: buffer = GetResString(IDS_PRIONORMAL); break;
			case PR_HIGH: buffer = GetResString(IDS_PRIOHIGH); break;
			case PR_VERYHIGH: buffer = GetResString(IDS_PRIOVERYHIGH); break;
			default: buffer = GetResString(IDS_X_EXI_UNKNOWN); 
		}
		if(client->m_ExtraInfo->FileULReleasePriority == 0xFF) 
		if(client->m_ExtraInfo->QueueSystem & REMOTE_QS_PAYBACK_FIRST)
			buffer.Append(GetResString(IDS_PRIORELEASE));
		GetDlgItem(IDC_DULPRIO)->SetWindowText(buffer);

		// last seen complete
		if(client->m_ExtraInfo->lastseencompletereqfile == 0xFFFFFFFF) buffer = _T("?"); else
		{
			CTime lastseencompletereqfile = client->m_ExtraInfo->lastseencompletereqfile;
			struct tm* ptimLastSeenComplete = lastseencompletereqfile.GetLocalTm();
			if (ptimLastSeenComplete == NULL)
				buffer.Format(GetResString(IDS_NEVER));
			else{
				buffer.Format(_T("%s   ") + GetResString(IDS_TIMEBEFORE),
							lastseencompletereqfile.Format(thePrefs.GetDateTimeFormat()),
							CastSecondsToLngHM(time(NULL) - safe_mktime(ptimLastSeenComplete)));
			}
		}
		GetDlgItem(IDC_DLASTSEENFILE)->SetWindowText(buffer);

		if(client->m_ExtraInfo->ReqFileSources == 0xFFFF) buffer = _T("?"); else
		buffer.Format(_T("%u"),client->m_ExtraInfo->ReqFileSources);
		GetDlgItem(IDC_DULSRC)->SetWindowText(buffer);

		if(client->m_ExtraInfo->ReqFileCompleteSources == 0xFFFF) buffer = _T("?"); else
		buffer.Format(_T("%u"),client->m_ExtraInfo->ReqFileCompleteSources);
		GetDlgItem(IDC_DULCSRC)->SetWindowText(buffer);


		if(client->m_ExtraInfo->FileDLPriority == 0xFF) buffer = _T("?"); else
			switch(client->m_ExtraInfo->FileDLPriority){
			case PR_LOW: buffer = GetResString(IDS_PRIOLOW); break;
			case PR_NORMAL: buffer = GetResString(IDS_PRIONORMAL); break;
			case PR_HIGH: buffer = GetResString(IDS_PRIOHIGH); break;
			default: buffer = GetResString(IDS_X_EXI_UNKNOWN); 
		}
		GetDlgItem(IDC_DDLPRIO)->SetWindowText(buffer);

		if(client->m_ExtraInfo->UpReqFileSources == 0xFFFF) buffer = _T("?"); else
		buffer.Format(_T("%u"),client->m_ExtraInfo->UpReqFileSources);
		GetDlgItem(IDC_DDLSRC)->SetWindowText(buffer);

		if(client->m_ExtraInfo->UpReqFileCompleteSources == 0xFFFF) buffer = _T("?"); else
		buffer.Format(_T("%u"),client->m_ExtraInfo->UpReqFileCompleteSources);
		GetDlgItem(IDC_DDLCSRC)->SetWindowText(buffer);


		if(client->m_ExtraInfo->CreditSystem == 0xFF) buffer = _T("?"); else
		switch(client->m_ExtraInfo->CreditSystem){
			case REMOTE_CS_NONE: buffer = GetResString(IDS_X_EXI_CS_NONE); break;
			case REMOTE_CS_OFFICIAL: buffer = GetResString(IDS_X_EXI_CS_DEFAULT); break;
			case REMOTE_CS_NEO: buffer = GetResString(IDS_X_EXI_CS_NEO); break;
			case REMOTE_CS_LOVELACE: buffer = GetResString(IDS_X_EXI_CS_LOVELACE); break;
			case REMOTE_CS_PEACE: buffer = GetResString(IDS_X_EXI_CS_PEACE); break;
			case REMOTE_CS_SIVKA: buffer = GetResString(IDS_X_EXI_CS_SIVKA); break;
			case REMOTE_CS_RT: buffer = GetResString(IDS_X_EXI_CS_RT); break;
			case REMOTE_CS_SWAT: buffer = GetResString(IDS_X_EXI_CS_SWAT); break;
			case REMOTE_CS_PAWCIO: buffer = GetResString(IDS_X_EXI_CS_PAWCIO); break;
			case REMOTE_CS_EASTSHARE: buffer = GetResString(IDS_X_EXI_CS_EASTSHARE); break;
			case REMOTE_CS_TK4: buffer = GetResString(IDS_X_EXI_CS_TK4); break;
			case REMOTE_CS_XTREME: buffer = GetResString(IDS_X_EXI_CS_XTREME); break;
			case REMOTE_CS_ZZUL: buffer = GetResString(IDS_X_EXI_CS_ZZUL); break;
			default: buffer = GetResString(IDS_X_EXI_UNKNOWN); 
		}
		/*if(client->m_ExtraInfo->QueueSystem != 0xFF) 
		if(client->m_ExtraInfo->QueueSystem & REMOTE_QS_PAYBACK_FIRST)
			buffer.Append(IDS_X_EXI_CS_PAYBACK);*/
		GetDlgItem(IDC_DCREDITSYS)->SetWindowText(buffer);

		if(client->m_ExtraInfo->QueueSystem != 0xFF){
			buffer = GetResString((client->m_ExtraInfo->QueueSystem & REMOTE_QS_SAVE_WAIT_TIME) ? IDS_YES : IDS_NO);
			GetDlgItem(IDC_DSAVETIME)->SetWindowText(buffer);

			buffer = GetResString((client->m_ExtraInfo->QueueSystem & REMOTE_QS_ONE_PER_FILE) ? IDS_YES : IDS_NO);
			GetDlgItem(IDC_DMULTIQUEUE)->SetWindowText(buffer);

			if(client->m_ExtraInfo->QueueSystem & REMOTE_QS_EXPONENTIAL)
				buffer = GetResString(IDS_X_EXI_QS_EXPONENTIAL);
			else if(client->m_ExtraInfo->QueueSystem & REMOTE_QS_PROBABILISTIC)
				buffer = GetResString(IDS_X_EXI_QS_PROBABILISTIC);
			else
				buffer = GetResString(IDS_X_EXI_QS_DEFAULT);

			if(client->m_ExtraInfo->QueueSystem & REMOTE_QS_OLD_PRIO_SYS)
				buffer.Append(GetResString(IDS_X_EXI_QS_OLDPRIO));

			GetDlgItem(IDC_DQUEUETYPE)->SetWindowText(buffer);
		}else{
			GetDlgItem(IDC_DSAVETIME)->SetWindowText(_T("?"));
			GetDlgItem(IDC_DMULTIQUEUE)->SetWindowText(_T("?"));
			GetDlgItem(IDC_DQUEUETYPE)->SetWindowText(_T("?"));
		}
		

		if(client->m_ExtraInfo->WaitingUsers == 0xFFFFFFFF) buffer = _T("?"); else
		buffer.Format(_T("%u"),client->m_ExtraInfo->WaitingUsers);
		if(client->m_ExtraInfo->QueueSystem == 0xFF) buffer.Append(_T(" ?")); else
		if (client->m_ExtraInfo->QueueSystem & REMOTE_QS_INFINITE){
			buffer.Append(_T(" ") + GetResString(IDS_X_EXI_INFINITE));
		}
		GetDlgItem(IDC_DWAITINGUSERS)->SetWindowText(buffer);



		if(client->m_ExtraInfo->CreditScore == 0) buffer = _T("?"); else
		buffer.Format(_T("%.1f"),(float)client->m_ExtraInfo->CreditScore);
		GetDlgItem(IDC_DRATIO)->SetWindowText(buffer);
		
		if(client->m_ExtraInfo->QueueRating == 0xFFFFFFFF) buffer = _T("?"); else
		buffer.Format(_T("%u"),client->m_ExtraInfo->QueueRating);
		GetDlgItem(IDC_DRATING)->SetWindowText(buffer);
		
		
		if(client->m_ExtraInfo->QueueScore == 0xFFFFFFFF) buffer = _T("?"); else
		buffer.Format(_T("%u"),client->m_ExtraInfo->QueueScore);

		if(client->m_ExtraInfo->PrivatSlot == 0xFF) buffer.Append(_T(" (?)")); else
		if (client->m_ExtraInfo->PrivatSlot == 1)
			buffer.Append(GetResString(IDS_FRIENDDETAIL));
		else if (client->m_ExtraInfo->PrivatSlot == 2 || client->m_ExtraInfo->PrivatSlot == 3)
			buffer.Append(GetResString(IDS_X_NXI_BOOST));

		GetDlgItem(IDC_DSCORE)->SetWindowText(buffer);

		if(client->m_ExtraInfo->WaitingTime == 0xFFFFFFFF) buffer = _T("?"); else
		buffer.Format(_T("%s"),CastSecondsToHM(client->m_ExtraInfo->WaitingTime));
		GetDlgItem(IDC_DWAITING)->SetWindowText(buffer);

		m_bDataChanged = false;
	}
	return TRUE;
}

LRESULT CClientExtraInfoPage::OnDataChanged(WPARAM, LPARAM)
{
	m_bDataChanged = true;
	return 1;
}

void CClientExtraInfoPage::Localize()
{
	GetDlgItem(IDC_STATIC30)->SetWindowText(GetResString(IDS_X_EXI_GENERAL));
	GetDlgItem(IDC_STATIC31)->SetWindowText(GetResString(IDS_X_EXI_SUI_STATE));
	GetDlgItem(IDC_STATIC62)->SetWindowText(GetResString(IDS_X_EXI_UP_TIME));
	GetDlgItem(IDC_STATIC63)->SetWindowText(GetResString(IDS_X_EXI_ID_AGE));
	GetDlgItem(IDC_STATIC57)->SetWindowText(GetResString(IDS_X_EXI_UPLOAD_BW));
	GetDlgItem(IDC_STATIC61)->SetWindowText(GetResString(IDS_X_EXI_DOWNLOAD_BW));

	GetDlgItem(IDC_STATIC49)->SetWindowText(GetResString(IDS_X_EXI_FILES));
	GetDlgItem(IDC_STATIC64)->SetWindowText(GetResString(IDS_X_EXI_UL_PRIO));
	GetDlgItem(IDC_STATIC68)->SetWindowText(GetResString(IDS_X_EXI_DL_PRIO));
	GetDlgItem(IDC_STATIC65)->SetWindowText(GetResString(IDS_X_EXI_FILE_LAST_SEEN));
	GetDlgItem(IDC_STATIC66)->SetWindowText(GetResString(IDS_X_EXI_SEEN_SOURCES));
	GetDlgItem(IDC_STATIC70)->SetWindowText(GetResString(IDS_X_EXI_REQ_SEEN_SOURCES));
	GetDlgItem(IDC_STATIC67)->SetWindowText(GetResString(IDS_X_EXI_SEEN_COLPLETE_SOURCES));
	GetDlgItem(IDC_STATIC71)->SetWindowText(GetResString(IDS_X_EXI_REQ_SEEN_COLPLETE_SOURCES));

	GetDlgItem(IDC_STATIC39)->SetWindowText(GetResString(IDS_X_EXI_QUEUE));
	GetDlgItem(IDC_STATIC55)->SetWindowText(GetResString(IDS_X_EXI_CREDIT_SYSTEM));
	GetDlgItem(IDC_STATIC56)->SetWindowText(GetResString(IDS_X_EXI_SUQWT));
	GetDlgItem(IDC_STATIC58)->SetWindowText(GetResString(IDS_X_EXI_MULTIQ));
	GetDlgItem(IDC_STATIC59)->SetWindowText(GetResString(IDS_X_EXI_QUEUE_TYPE));
	GetDlgItem(IDC_STATIC60)->SetWindowText(GetResString(IDS_X_EXI_WAITING_USERS));

	GetDlgItem(IDC_STATIC32)->SetWindowText(GetResString(IDS_X_EXI_SCORE));
	GetDlgItem(IDC_STATIC51)->SetWindowText(GetResString(IDS_CD_MOD));
	GetDlgItem(IDC_STATIC52)->SetWindowText(GetResString(IDS_CD_RATING));
	GetDlgItem(IDC_STATIC53)->SetWindowText(GetResString(IDS_CD_USCORE));
	GetDlgItem(IDC_STATIC54)->SetWindowText(GetResString(IDS_X_EXI_WT));

}

void CClientExtraInfoPage::DisableDialog(bool bDisable){
	GetDlgItem(IDC_STATIC30)->EnableWindow(!bDisable);
	GetDlgItem(IDC_STATIC31)->EnableWindow(!bDisable);
	GetDlgItem(IDC_STATIC62)->EnableWindow(!bDisable);
	GetDlgItem(IDC_STATIC63)->EnableWindow(!bDisable);
	GetDlgItem(IDC_STATIC57)->EnableWindow(!bDisable);
	GetDlgItem(IDC_STATIC61)->EnableWindow(!bDisable);

	GetDlgItem(IDC_STATIC49)->EnableWindow(!bDisable);
	GetDlgItem(IDC_STATIC64)->EnableWindow(!bDisable);
	GetDlgItem(IDC_STATIC68)->EnableWindow(!bDisable);
	GetDlgItem(IDC_STATIC65)->EnableWindow(!bDisable);
	GetDlgItem(IDC_STATIC66)->EnableWindow(!bDisable);
	GetDlgItem(IDC_STATIC70)->EnableWindow(!bDisable);
	GetDlgItem(IDC_STATIC67)->EnableWindow(!bDisable);
	GetDlgItem(IDC_STATIC71)->EnableWindow(!bDisable);

	GetDlgItem(IDC_STATIC39)->EnableWindow(!bDisable);
	GetDlgItem(IDC_STATIC55)->EnableWindow(!bDisable);
	GetDlgItem(IDC_STATIC56)->EnableWindow(!bDisable);
	GetDlgItem(IDC_STATIC58)->EnableWindow(!bDisable);
	GetDlgItem(IDC_STATIC59)->EnableWindow(!bDisable);
	GetDlgItem(IDC_STATIC60)->EnableWindow(!bDisable);

	GetDlgItem(IDC_STATIC32)->EnableWindow(!bDisable);
	GetDlgItem(IDC_STATIC51)->EnableWindow(!bDisable);
	GetDlgItem(IDC_STATIC52)->EnableWindow(!bDisable);
	GetDlgItem(IDC_STATIC53)->EnableWindow(!bDisable);
	GetDlgItem(IDC_STATIC54)->EnableWindow(!bDisable);


	GetDlgItem(IDC_DSUI)->EnableWindow(!bDisable);
	GetDlgItem(IDC_DUPTIME)->EnableWindow(!bDisable);
	GetDlgItem(IDC_DIDAGE)->EnableWindow(!bDisable);
	GetDlgItem(IDC_DULBW)->EnableWindow(!bDisable);
	GetDlgItem(IDC_DDLBW)->EnableWindow(!bDisable);

	GetDlgItem(IDC_DULPRIO)->EnableWindow(!bDisable);
	GetDlgItem(IDC_DLASTSEENFILE)->EnableWindow(!bDisable);
	GetDlgItem(IDC_DULSRC)->EnableWindow(!bDisable);
	GetDlgItem(IDC_DULCSRC)->EnableWindow(!bDisable);
	GetDlgItem(IDC_DDLPRIO)->EnableWindow(!bDisable);
	GetDlgItem(IDC_DDLSRC)->EnableWindow(!bDisable);
	GetDlgItem(IDC_DDLCSRC)->EnableWindow(!bDisable);

	GetDlgItem(IDC_DCREDITSYS)->EnableWindow(!bDisable);
	GetDlgItem(IDC_DSAVETIME)->EnableWindow(!bDisable);
	GetDlgItem(IDC_DMULTIQUEUE)->EnableWindow(!bDisable);
	GetDlgItem(IDC_DQUEUETYPE)->EnableWindow(!bDisable);
	GetDlgItem(IDC_DWAITINGUSERS)->EnableWindow(!bDisable);

	GetDlgItem(IDC_DRATIO)->EnableWindow(!bDisable);
	GetDlgItem(IDC_DRATING)->EnableWindow(!bDisable);
	GetDlgItem(IDC_DSCORE)->EnableWindow(!bDisable);
	GetDlgItem(IDC_DWAITING)->EnableWindow(!bDisable);



	GetDlgItem(IDC_DSUI)->SetWindowText(_T("?"));
	GetDlgItem(IDC_DUPTIME)->SetWindowText(_T("?"));
	GetDlgItem(IDC_DIDAGE)->SetWindowText(_T("?"));
	GetDlgItem(IDC_DULBW)->SetWindowText(_T("?"));
	GetDlgItem(IDC_DDLBW)->SetWindowText(_T("?"));

	GetDlgItem(IDC_DULPRIO)->SetWindowText(_T("?"));
	GetDlgItem(IDC_DLASTSEENFILE)->SetWindowText(_T("?"));
	GetDlgItem(IDC_DULSRC)->SetWindowText(_T("?"));
	GetDlgItem(IDC_DULCSRC)->SetWindowText(_T("?"));
	GetDlgItem(IDC_DDLPRIO)->SetWindowText(_T("?"));
	GetDlgItem(IDC_DDLSRC)->SetWindowText(_T("?"));
	GetDlgItem(IDC_DDLCSRC)->SetWindowText(_T("?"));

	GetDlgItem(IDC_DCREDITSYS)->SetWindowText(_T("?"));
	GetDlgItem(IDC_DSAVETIME)->SetWindowText(_T("?"));
	GetDlgItem(IDC_DMULTIQUEUE)->SetWindowText(_T("?"));
	GetDlgItem(IDC_DQUEUETYPE)->SetWindowText(_T("?"));
	GetDlgItem(IDC_DWAITINGUSERS)->SetWindowText(_T("?"));

	GetDlgItem(IDC_DRATIO)->SetWindowText(_T("?"));
	GetDlgItem(IDC_DRATING)->SetWindowText(_T("?"));
	GetDlgItem(IDC_DSCORE)->SetWindowText(_T("?"));
	GetDlgItem(IDC_DWAITING)->SetWindowText(_T("?"));
}
// NEO: NXI END <-- Xanatos --