//this file is part of NeoMule
//Copyright (C)2006 David Xanatos ( Xanatos@Lycos.at / http://neomule.sourceforge.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#pragma once

void SetTreeGroup(CTreeOptionsCtrl &hCtrl, HTREEITEM &hItem, LPCTSTR Label, int Icon, HTREEITEM Parent = TVI_ROOT, LPCTSTR Info = NULL);
void SetTreeEdit(CTreeOptionsCtrl &hCtrl, HTREEITEM &hItem, LPCTSTR Label, HTREEITEM Parent, LPCTSTR Info = NULL);
void SetTreeNumEdit(CTreeOptionsCtrl &hCtrl, HTREEITEM &hItem, LPCTSTR Label, HTREEITEM Parent, LPCTSTR Info = NULL);
void DDX_TreeEditE0(CTreeOptionsCtrl* hCtrl, CDataExchange* pDX, int nIDC, HTREEITEM hItem, int& nValue);
void DDX_TreeEditE0f(CTreeOptionsCtrl* hCtrl, CDataExchange* pDX, int nIDC, HTREEITEM hItem, float& nValue);
BOOL CheckTreeEditLimit(CTreeOptionsCtrl &hCtrl, HTREEITEM &hItem, int Min, int Def, int Max);
BOOL CheckTreeEditLimitF(CTreeOptionsCtrl &hCtrl, HTREEITEM &hItem, float Min, float Def, float Max);
void SetTreeCheckEdit(CTreeOptionsCtrl &hCtrl, HTREEITEM &hItem, LPCTSTR Label, HTREEITEM Parent, LPCTSTR Info = NULL, BOOL TreeState = FALSE, BOOL Value = FALSE);
void SetTreeRadioNumEdit(CTreeOptionsCtrl &hCtrl, HTREEITEM &hItem, LPCTSTR Label, HTREEITEM Parent, LPCTSTR Info = NULL, BOOL UnSetable = FALSE, BOOL Value = FALSE);
void SetTreeCheckNumEdit(CTreeOptionsCtrl &hCtrl, HTREEITEM &hItem, LPCTSTR Label, HTREEITEM Parent, LPCTSTR Info = NULL, BOOL TreeState = FALSE, BOOL Value = FALSE);
void SetTreeCheck(CTreeOptionsCtrl &hCtrl, HTREEITEM &hItem, LPCTSTR Label, HTREEITEM Parent,  LPCTSTR Info = NULL, BOOL TreeState = FALSE, BOOL Value = FALSE);
void SetTreeRadio(CTreeOptionsCtrl &hCtrl, HTREEITEM &hItem, LPCTSTR Label, HTREEITEM Parent,  LPCTSTR Info = NULL, BOOL UnSetable = FALSE, BOOL Value = FALSE);
//void SetTreeCheckSpinNumEdit(CTreeOptionsCtrl &hCtrl, HTREEITEM &hItem, LPCTSTR Label, HTREEITEM Parent, LPCTSTR Info = NULL, int Min = 0, int Max = INT_MAX, BOOL TreeState = FALSE, BOOL Value = FALSE);

void SetTreePriority(CTreeOptionsCtrl &hCtrl, HTREEITEM &hItem, LPCTSTR Label, HTREEITEM Parent, LPCTSTR Info);
void DDX_PriorityT(CTreeOptionsCtrl* hCtrl, CDataExchange* pDX, int nIDC, HTREEITEM hItem, int& nValue);
void DDX_PriorityC(CTreeOptionsCtrl* hCtrl, CDataExchange* pDX, int nIDC, HTREEITEM hItem, DWORD& nValue);

class CPriority : public CTreeOptionsCombo
{
public:
	CPriority();
	virtual ~CPriority();

protected:
	DWORD GetWindowStyle();
	//{{AFX_VIRTUAL(CPriority)
	//}}AFX_VIRTUAL

	//{{AFX_MSG(CPriority)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()

  DECLARE_DYNCREATE(CPriority)
};


#ifdef NEO_BC // NEO: NBC - [NeoBandwidthControl]
void SetTreeAdapterIndex(CTreeOptionsCtrl &hCtrl, HTREEITEM &hItem, LPCTSTR Label, HTREEITEM Parent, LPCTSTR Info, BOOL Mask = FALSE, BOOL WithCheck = FALSE, BOOL TreeState = FALSE, BOOL Value = FALSE);
void DDX_AdapterIndex(CTreeOptionsCtrl* hCtrl, CDataExchange* pDX, int nIDC, HTREEITEM hItem, DWORD& nValue);

class CAdapterIndex : public CTreeOptionsCombo
{
public:
	CAdapterIndex();
	virtual ~CAdapterIndex();

protected:
	DWORD GetWindowStyle();
	//{{AFX_VIRTUAL(CAdapterIndex)
	//}}AFX_VIRTUAL

	//{{AFX_MSG(CAdapterIndex)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()

  DECLARE_DYNCREATE(CAdapterIndex)
};
#endif // NEO_BC // NEO: NBC END
