//this file is part of NeoMule
//Copyright (C)2006 David Xanatos ( Xanatos@Lycos.at / http://neomule.sourceforge.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


#pragma once
#include "Neo\GUI\CP\TreeOptionsCtrl.h" // NEO - [TreeControl]

class CPPgSources : public CPropertyPage
{
	DECLARE_DYNAMIC(CPPgSources)

public:
	CPPgSources();
	virtual ~CPPgSources();

	void SetFiles(const CSimpleArray<CObject*>* paFiles) { m_paFiles = paFiles; m_bDataChanged = true; m_bFilePreferences = true; } // NEO: FCFG - [FileConfiguration]

	// Dialog Data
	enum { IDD = IDD_PPG_MOD };

protected:
	// NEO: FCFG - [FileConfiguration]
	//CString m_strCaption;
	const CSimpleArray<CObject*>* m_paFiles;
	bool m_bDataChanged;
	uint32 m_timer;
	static LPCTSTR sm_pszNotAvail;

	bool m_bFilePreferences; // We use the same dialog ro the Prefs and the File Prefs
	// NEO: FCFG END

	CTreeOptionsCtrl m_ctrlTreeOptions; // NEO - [TreeControl]
	bool m_bInitializedTreeOpts;

	// NEO: NST - [NeoSourceTweaks]
	HTREEITEM m_htiSourceCollecting;
		HTREEITEM m_htiCollectingControl;
			HTREEITEM m_htiHardLimit;
			HTREEITEM m_htiSwapLimit;
			HTREEITEM m_htiCleanUpLimit;
			// NEO: NSD - [NeoSourceDrop]
				HTREEITEM m_htiLow2LowCleanUpTime;
#if defined(NEO_SK) || defined(NEO_SS) // NEO: NSK - [NeoSourceKeeper] // NEO: NSS - [NeoSourceStorage]
				HTREEITEM m_htiBadCleanUpTime;
				HTREEITEM m_htiGoneCleanUpTime;
				HTREEITEM m_htiSuspendCleanUpTime;
#endif // NEO_SK // NEO_SS // NEO: NSK END // NEO: NSS END
				HTREEITEM m_htiNnPCleanUpTime;
				HTREEITEM m_htiFullQCleanUpTime;
			// NEO: NSD END
			HTREEITEM m_htiCalcStandardLimits;
				HTREEITEM m_htiCalcStandardLimitsDefault;
				HTREEITEM m_htiCalcStandardLimitsEnable;
				HTREEITEM m_htiCalcStandardLimitsDisable;
			// NEO: AHL - [AutoHardLimit]
			HTREEITEM m_htiAutoHardLimit;
				HTREEITEM m_htiAutoHardLimitDefault;
				HTREEITEM m_htiAutoHardLimitModeMax;
				HTREEITEM m_htiAutoHardLimitModeNew;
				HTREEITEM m_htiAutoHardLimitModeOld;
				HTREEITEM m_htiAutoHardLimitDisable;
				HTREEITEM m_htiMinimalHardLimit;
				HTREEITEM m_htiGlobalHardLimit;
				HTREEITEM m_htiAutoHardLimitTimer;
			// NEO: AHL END
			// NEO: ASL - [AutoSoftLock]
			HTREEITEM m_htiAutoSoftLock;
				HTREEITEM m_htiAutoSoftLockDefault;
				HTREEITEM m_htiAutoSoftLockEnable;
				HTREEITEM m_htiAutoSoftLockDisable;
				HTREEITEM m_htiAutoSoftLockValue;
			// NEO: ASL END
			// NEO: XSC - [ExtremeSourceCache]
			HTREEITEM m_htiSourceCache;
				HTREEITEM m_htiSourceCacheDefault;
				HTREEITEM m_htiSourceCacheEnable;
				HTREEITEM m_htiSourceCacheDisable;
				HTREEITEM m_htiSourceCacheLimit;
				HTREEITEM m_htiSourceCacheTime;
			// NEO: XSC END
#ifdef A4AF_CATS // NEO: MAC - [MorphA4AFCategories]
			HTREEITEM m_htiAdvancedA4AFMode;
				HTREEITEM m_htiAdvancedA4AFModeDisabled;
				HTREEITEM m_htiAdvancedA4AFModeBalance;
				HTREEITEM m_htiAdvancedA4AFModeStack;
				HTREEITEM m_htiSmartA4AFSwapping;
#endif // A4AF_CATS // NEO: MAC END
			// NEO: NCAP - [NeoCustomAutoPriority]
			HTREEITEM m_htiAutoDownPriority;
				HTREEITEM m_htiDynamicAutoDownPriorityDefault;
				HTREEITEM m_htiDynamicAutoDownPriorityEnable;
				HTREEITEM m_htiDynamicAutoDownPriorityDisable;
				HTREEITEM m_htiLowDownPrioThreshold;
				HTREEITEM m_htiHighDownPrioThreshold;
			// NEO: NCAP END
			HTREEITEM m_htiRareFileLimit;
		HTREEITEM m_htiXSSources;
			HTREEITEM m_htiXSDefault;
			HTREEITEM m_htiXSEnable;
			HTREEITEM m_htiXSDisable;
			HTREEITEM m_htiXSLimit;
			HTREEITEM m_htiXSIntervals;
			HTREEITEM m_htiXSClientIntervals;
			HTREEITEM m_htiXSDelay;
		HTREEITEM m_htiSVRSources;
			HTREEITEM m_htiSVRDefault;
			HTREEITEM m_htiSVREnable;
			HTREEITEM m_htiSVRDisable;
			HTREEITEM m_htiSVRLimit;
			HTREEITEM m_htiSVRIntervals;
		HTREEITEM m_htiKADSources;
			HTREEITEM m_htiKADDefault;
			HTREEITEM m_htiKADEnable;
			HTREEITEM m_htiKADDisable;
			HTREEITEM m_htiKADLimit;
			HTREEITEM m_htiKADIntervals;
			HTREEITEM m_htiKADAmount;
			HTREEITEM m_htiKADDelay;
		HTREEITEM m_htiUDPSources;
			HTREEITEM m_htiUDPDefault;
			HTREEITEM m_htiUDPEnable;
			HTREEITEM m_htiUDPDisable;
			HTREEITEM m_htiUDPLimit;
			HTREEITEM m_htiUDPIntervals;
			HTREEITEM m_htiGlobalUDPIntervals;
			HTREEITEM m_htiUDPAmount;
			HTREEITEM m_htiUDPCache; // NEO: XUC - [ExtendedUdpCache]
	// NEO: NST END

	// NEO: DR - [DownloadReask]
	HTREEITEM m_htiDownloadReask;
		HTREEITEM m_htiSpreadReask; // NEO: SR - [SpreadReask]
		HTREEITEM m_htiReask;
			HTREEITEM m_htiReaskIntervals;
		HTREEITEM m_htiNnPReask;
			HTREEITEM m_htiReaskNnPDefault;
			HTREEITEM m_htiReaskNnPEnable;
			HTREEITEM m_htiReaskNnPDisable;
			HTREEITEM m_htiReaskNnPIntervals;
		HTREEITEM m_htiFullQReask;
			HTREEITEM m_htiReaskFullQDefault;
			HTREEITEM m_htiReaskFullQEnable;
			HTREEITEM m_htiReaskFullQDisable;
			HTREEITEM m_htiReaskFullQIntervals;
	// NEO: DR END

	// NEO: DS - [DropSources]
	HTREEITEM m_htiDrop;
		HTREEITEM m_htiUseDontAskThisIP;
			HTREEITEM m_htiUseDontAskThisIPDefault;
			HTREEITEM m_htiUseDontAskThisIPEnable;
			HTREEITEM m_htiUseDontAskThisIPDisable;
			HTREEITEM m_htiDontAskThisIPTime;
		HTREEITEM m_htiDropNnP;
			HTREEITEM m_htiDropNnPDefault;
			HTREEITEM m_htiDropNnPEnable;
			HTREEITEM m_htiDropNnPDisable;
			HTREEITEM m_htiDropNnPLimit;
				HTREEITEM m_htiDropNnPLimitDefault;
				HTREEITEM m_htiDropNnPLimitTotal;
				HTREEITEM m_htiDropNnPLimitRelativ;
				HTREEITEM m_htiDropNnPLimitSpecyfic;
				HTREEITEM m_htiDropNnPLimitDisable;
			HTREEITEM m_htiDropNnPTimer;
		HTREEITEM m_htiDropFullQ;
			HTREEITEM m_htiDropFullQDefault;
			HTREEITEM m_htiDropFullQEnable;
			HTREEITEM m_htiDropFullQDisable;
			HTREEITEM m_htiDropFullQLimit;
				HTREEITEM m_htiDropFullQLimitDefault;
				HTREEITEM m_htiDropFullQLimitTotal;
				HTREEITEM m_htiDropFullQLimitRelativ;
				HTREEITEM m_htiDropFullQLimitSpecyfic;
				HTREEITEM m_htiDropFullQLimitDisable;
			HTREEITEM m_htiDropFullQTimer;
		HTREEITEM m_htiDropHighQ;
			HTREEITEM m_htiDropHighQDefault;
			HTREEITEM m_htiDropHighQEnable;
			HTREEITEM m_htiDropHighQDisable;
			HTREEITEM m_htiDropHighQValue;
			HTREEITEM m_htiDropHighQLimit;
				HTREEITEM m_htiDropHighQLimitDefault;
				HTREEITEM m_htiDropHighQLimitTotal;
				HTREEITEM m_htiDropHighQLimitRelativ;
				HTREEITEM m_htiDropHighQLimitSpecyfic;
				HTREEITEM m_htiDropHighQLimitDisable;
			HTREEITEM m_htiDropHighQTimer;
	// NEO: DS END

	// NEO: FCFG - [FileConfiguration]
	int		m_iHardLimit;
	int		m_iSwapLimit;
	int		m_iCleanUpLimit;
	int		m_iCalcStandardLimits;
	bool	m_bCalcStandardLimits;

	// NEO: NSD - [NeoSourceDrop]
	int		m_iLow2LowCleanUpTime;
#if defined(NEO_SK) || defined(NEO_SS) // NEO: NSK - [NeoSourceKeeper] // NEO: NSS - [NeoSourceStorage]
	int		m_iBadCleanUpTime;
	int		m_iGoneCleanUpTime;
	int		m_iSuspendCleanUpTime;
#endif // NEO_SK // NEO_SS // NEO: NSK END // NEO: NSS END
	int		m_iNnPCleanUpTime;
	int		m_iFullQCleanUpTime;
	// NEO: NSD END

	// NEO: AHL - [AutoHardLimit]
	int		m_iAutoHardLimit;
	int		m_iMinimalHardLimit;
	int		m_iGlobalHardLimit;
	int		m_iAutoHardLimitTimer;
	// NEO: AHL END

	// NEO: ASL - [AutoSoftLock]
	int		m_iAutoSoftLock;
	bool	m_bAutoSoftLock;
	int		m_iAutoSoftLockValue;
	// NEO: ASL END

	// NEO: XSC - [ExtremeSourceCache]
	int		m_iSourceCache;
	bool	m_bSourceCache;
	int		m_iSourceCacheLimit;
	int		m_iSourceCacheTime;
	// NEO: XSC END

#ifdef A4AF_CATS // NEO: MAC - [MorphA4AFCategories]
	bool	m_bSmartA4AFSwapping;
	int		m_iAdvancedA4AFMode;
#endif // A4AF_CATS // NEO: MAC END

	// NEO: NCAP - [NeoCustomAutoPriority]
	int		m_iDynamicAutoDownPriority;
	bool	m_bDynamicAutoDownPriority;
	float	m_fDynamicDownPriorityFactor;
	int		m_iLowDownPrioThreshold;
	int		m_iHighDownPrioThreshold;
	// NEO: NCAP END

	int		m_iRareFileLimit;

	int		m_iXSState;
	bool	m_bXSDisable;
	int		m_iXSLimit;
	int		m_iXSIntervals;
	int		m_iXSClientIntervals;
	int		m_iXSDelayValue;

	int		m_iSVRState;
	bool	m_bSVRDisable;
	int		m_iSVRLimit;
	int		m_iSVRIntervals;

	int		m_iKADState;
	bool	m_bKADDisable;
	int		m_iKADLimit;
	int		m_iKADIntervals;
	int		m_iKADAmount;
	int		m_iKADDelayValue;

	int		m_iUDPState;
	bool	m_bUDPDisable;
	int		m_iUDPLimit;
	int		m_iUDPIntervals;
	int		m_iGlobalUDPIntervals;
	int		m_iUDPAmount;

	// NEO: XUC - [ExtendedUdpCache]
	UINT	m_uUDPCache;
	int		m_iUDPCache;
	// NEO: XUC END
	// NEO: NST END

	// NEO: SR - [SpreadReask]
	bool	m_bSpreadReask;
	int		m_iSpreadReask;
	// NEO: SR END

	// NEO: DR - [DownloadReask]
	int		m_iReaskIntervals;

	int		m_iNnPReask;
	bool	m_bDontNnPReask;
	int		m_iNnPReaskIntervals;

	int		m_iFullQReask;
	bool	m_bDontFullQReask;
	int		m_iFullQReaskIntervals;
	// NEO: DR END

	// NEO: DS - [DropSources]
	bool	m_bUseDontAskThisIP;
	int		m_iUseDontAskThisIP;
	int		m_iDontAskThisIPTime;

	int		m_iDropNnP;
	UINT	m_uDropNnP;
	int		m_iDropNnPLimit;
	int		m_iDropNnPLimitMode;
	int		m_iDropNnPTimer;

	int		m_iDropFullQ;
	UINT	m_uDropFullQ;
	int		m_iDropFullQLimit;
	int		m_iDropFullQLimitMode;
	int		m_iDropFullQTimer;

	int		m_iDropHighQ;
	UINT	m_uDropHighQ;
	int		m_iDropHighQValue;
	int		m_iDropHighQLimit;
	int		m_iDropHighQLimitMode;
	int		m_iDropHighQTimer;
	// NEO: DS END

	void ClearAllMembers();

	//void Localize();
	void LoadSettings();
	void RefreshData(); // NEO: FCFG - [FileConfiguration]

	virtual BOOL OnInitDialog();
	virtual BOOL OnApply();
	virtual BOOL OnKillActive();
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	virtual BOOL OnCommand(WPARAM wParam, LPARAM lParam);
	virtual BOOL OnSetActive(); // NEO: FCFG - [FileConfiguration]

	DECLARE_MESSAGE_MAP()
	afx_msg void OnTimer(UINT nIDEvent); // NEO: FCFG - [FileConfiguration]
	afx_msg void OnDestroy();
	afx_msg LRESULT OnDataChanged(WPARAM, LPARAM); // NEO: FCFG - [FileConfiguration]

	afx_msg LRESULT OnTreeOptsCtrlNotify(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT DrawTreeItemHelp(WPARAM wParam, LPARAM lParam);
	afx_msg void OnHelp();
	afx_msg BOOL OnHelpInfo(HELPINFO* pHelpInfo);

private:
	bool	ForFile() {return m_bFilePreferences;}
	//void	CheckSLEnable(); // NEO: NST - [NeoSourceTweaks]
};
