//this file is part of NeoMule
//Copyright (C)2006 David Xanatos ( Xanatos@Lycos.at / http://neomule.sourceforge.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


#include "stdafx.h"
#include "emule.h"
#include "PPgSourceStorage.h"
#include "Preferences.h"
#include "PartFile.h"
#include "OtherFunctions.h"
#include "Neo/Functions.h"
#include "Neo/GUI/CP/TreeFunctions.h"
#include "Neo/Defaults.h"
#include "UserMsgs.h"
#include "downloadqueue.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif


///////////////////////////////////////////////////////////////////////////////
// CPPgSourceStorage dialog

IMPLEMENT_DYNAMIC(CPPgSourceStorage, CPropertyPage)

BEGIN_MESSAGE_MAP(CPPgSourceStorage, CPropertyPage)
	ON_WM_TIMER() // NEO: FCFG - [FileConfiguration]
	ON_WM_DESTROY()
	ON_MESSAGE(UM_DATA_CHANGED, OnDataChanged) // NEO: FCFG - [FileConfiguration]
	ON_MESSAGE(WM_TREEOPTSCTRL_NOTIFY, OnTreeOptsCtrlNotify)
	ON_MESSAGE(WM_TREEITEM_HELP, DrawTreeItemHelp)
	ON_WM_HELPINFO()
END_MESSAGE_MAP()

CPPgSourceStorage::CPPgSourceStorage()
	: CPropertyPage(CPPgSourceStorage::IDD)
	, m_ctrlTreeOptions(theApp.m_iDfltImageListColorFlags)
{
	// NEO: FCFG - [FileConfiguration]
	m_bFilePreferences = false;

	m_paFiles = NULL;
	m_bDataChanged = false;
	//m_strCaption = GetResString(IDS_FILEINFORMATION);
	//m_psp.pszTitle = m_strCaption;
	//m_psp.dwFlags |= PSP_USETITLE;
	m_timer = 0;
	// NEO: FCFG END
	ClearAllMembers();
	m_ctrlTreeOptions.SetNeoStyle();
}

CPPgSourceStorage::~CPPgSourceStorage()
{
}

void CPPgSourceStorage::ClearAllMembers()
{
	m_bInitializedTreeOpts = false;

	m_htiNeoSourceStorage = NULL;
#ifdef NEO_SK // NEO: NSK - [NeoSourceKeeper]
		m_htiSourceKeeper = NULL;
			m_htiSourceKeeperDefault = NULL;
			m_htiSourceKeeperEnable = NULL;
			m_htiSourceKeeperDisable = NULL;
#endif // NEO_SK // NEO: NSK END
#ifdef NEO_SS // NEO: NSS - [NeoSourceStorage]
		m_htiSourceStorage = NULL;
			m_htiUseSourceStorage = NULL;
				m_htiUseSourceStorageDefault = NULL;
				m_htiUseSourceStorageEnable = NULL;
				m_htiUseSourceStorageDisable = NULL;
			m_htiAutoSaveSources = NULL;
				m_htiAutoSaveSourcesDefault = NULL;
				m_htiAutoSaveSourcesEnable = NULL;
				m_htiAutoSaveSourcesEnable2 = NULL;
				m_htiAutoSaveSourcesDisable = NULL;
				m_htiAutoSaveSourcesIntervals = NULL;
			m_htiSourceStorageLimit = NULL;
			m_htiStoreSources = NULL;
				m_htiStoreLowIDSources = NULL;
					m_htiStoreLowIDSourcesDefault = NULL;
					m_htiStoreLowIDSourcesEnable = NULL;
					m_htiStoreLowIDSourcesDisable = NULL;
				m_htiStoreAlsoA4AFSources = NULL;
					m_htiStoreAlsoA4AFSourcesDefault = NULL;
					m_htiStoreAlsoA4AFSourcesEnable = NULL;
					m_htiStoreAlsoA4AFSourcesDisable = NULL;
				m_htiStoreSourcesFileStatus = NULL;
					m_htiStoreSourcesFileStatusDefault = NULL;
					m_htiStoreSourcesFileStatusEnable = NULL;
					m_htiStoreSourcesFileStatusSemiEnable = NULL;
					m_htiStoreSourcesFileStatusDisable = NULL;
			m_htiAutoLoadStoredSources = NULL;
				m_htiAutoLoadStoredSourcesDefault = NULL;
				m_htiAutoLoadStoredSourcesEnable = NULL;
				m_htiAutoLoadStoredSourcesSemiEnable = NULL;
				m_htiAutoLoadStoredSourcesDisable = NULL;
				m_htiStorageBootstrap = NULL;
					m_htiStorageBootstrapDefault = NULL;
					m_htiStorageBootstrapEnable = NULL;
					m_htiStorageBootstrapDisable = NULL;
					m_htiStorageBootstrapTime = NULL;
					m_htiStorageBootstrapRequirement = NULL;
			m_htiAutoReaskStoredSources = NULL;
				m_htiAutoReaskStoredSourcesDefault = NULL;
				m_htiAutoReaskStoredSourcesEnable = NULL;
				m_htiAutoReaskStoredSourcesDisable = NULL;
				m_htiAutoReaskStoredSourcesLimit = NULL;
					m_htiTotalSourceRestoreDefault = NULL;
					m_htiTotalSourceRestoreEnable = NULL;
					m_htiTotalSourceRestoreDisable = NULL;
				m_htiAutoReaskStoredSourcesDelay = NULL;
					m_htiAutoReaskStoredSourcesDelayDefault = NULL;
					m_htiAutoReaskStoredSourcesDelayEnable = NULL;
					m_htiAutoReaskStoredSourcesDelayDisable = NULL;
				m_htiAutoReaskLoadedSourcesDelay = NULL;
				m_htiGroupStoredSourceReask = NULL;
					m_htiGroupStoredSourceReaskDefault = NULL;
					m_htiGroupStoredSourceReaskEnable = NULL;
					m_htiGroupStoredSourceReaskDisable = NULL;
					m_htiStoredSourceGroupIntervals = NULL;
					m_htiStoredSourceGroupSize = NULL;
			m_htiOutOfDate = NULL;
				m_htiUseSmoothOutOfDate = NULL;
					m_htiUseSmoothOutOfDateDefault = NULL;
					m_htiUseSmoothOutOfDateEnable = NULL;
					m_htiUseSmoothOutOfDateDisable = NULL;
				m_htiMaxStoredFaildCount = NULL;
				m_htiStoredOutOfDate = NULL;
#endif // NEO_SS // NEO: NSS END
#ifdef NEO_CD // NEO: NCD - [NeoClientDatabase]
		m_htiClientDatabase = NULL;
			m_htiEnableSourceList = NULL;
			m_htiSaveGlobalSourceList = NULL;
				m_htiGlobalSourceListCleanUpTime = NULL;
				m_htiGlobalSourceListCleanUp = NULL;
				m_htiFastSourceCleanUp = NULL;
			m_htiSaveSourceFileList = NULL;
				m_htiSourceFileListCleanUpTime = NULL;
			m_htiSaveSourceDataInClient = NULL;

			m_htiIPZoneCheck = NULL;

			m_htiSourceHashMonitor = NULL;
				m_htiSourceHashMonitorBadTime = NULL;
				m_htiSourceHashMonitorMaxBad = NULL;

			m_htiIPTables = NULL;
				m_htiTableAmountToStore = NULL;

				m_htiIgnoreUnreachableInterval = NULL;
				m_htiIgnoreUndefinedInterval = NULL;
				m_htiBeginNewTableInterval = NULL;
#endif // NEO_CD // NEO: NCD END
#ifdef NEO_SA // NEO: NSA - [NeoSourceAnaliser]
		m_htiSourceAnaliser = NULL;
			m_htiSourceAnaliserDefault = NULL;
			m_htiSourceAnaliserEnable = NULL;
			m_htiSourceAnaliserDisable = NULL;
			m_htiAnaliseIntervals = NULL;
			m_htiTableAmountToAnalise = NULL;
			m_htiDontStoreTemporarySources = NULL;
				m_htiDontStoreTemporarySourcesDefault = NULL;
				m_htiDontStoreTemporarySourcesEnable = NULL;
				m_htiDontStoreTemporarySourcesDisable = NULL;
			m_htiReaskManager = NULL;
				m_htiPropabilityMode = NULL;
					m_htiPropabilityModeDefault = NULL;
					m_htiPropabilityModeNormal = NULL;
					m_htiPropabilityModeHigh = NULL;
					m_htiPropabilityModeAuto = NULL;
					m_htiPropabilityModeEnhanced = NULL;
				m_htiReaskPropability = NULL;
				m_htiReservePropability = NULL;
					m_htiAutoReserveReaskDefault = NULL;
					m_htiAutoReserveReaskEnable = NULL;
					m_htiAutoReserveReaskDisable = NULL;
					m_htiReserveReaskPropability = NULL;
					m_htiReaskReserveSourcesDelay = NULL;
						m_htiReaskReserveSourcesDelayDefault = NULL;
						m_htiReaskReserveSourcesDelayEnable = NULL;
						m_htiReaskReserveSourcesDelayDisable = NULL;
					m_htiReaskReserveSourcesLimit = NULL;
				m_htiTemporarySources = NULL;
					m_htiTemporarySourcesDefault = NULL;
					m_htiTemporarySourcesEnable = NULL;
					m_htiTemporarySourcesDisable = NULL;
					m_htiTemporaryReaskPropability = NULL;
					m_htiReaskTemporarySourcesDelay = NULL;
						m_htiReaskTemporarySourcesDelayDefault = NULL;
						m_htiReaskTemporarySourcesDelayEnable = NULL;
						m_htiReaskTemporarySourcesDelayDisable = NULL;
					m_htiReaskTemporarySourcesLimit = NULL;
				//m_htiMinAnalisisQuality = NULL;
					//m_htiAutoUnsureReaskDefault = NULL;
					//m_htiAutoUnsureReaskEnable = NULL;
					//m_htiAutoUnsureReaskDisable = NULL;
					//m_htiReaskUnsureSourcesDelay = NULL;
					//	m_htiReaskUnsureSourcesDelayDefault = NULL;
					//	m_htiReaskUnsureSourcesDelayEnable = NULL;
					//	m_htiReaskUnsureSourcesDelayDisable = NULL;
					//m_htiReaskUnsureSourcesLimit = NULL;
				m_htiUnpredictedPropability = NULL;
					m_htiUnpredictedPropabilityDefault = NULL;
					m_htiUnpredictedPropabilityEnable = NULL;
					m_htiUnpredictedPropabilityDisable = NULL;
					m_htiUnpredictedPropabilityValue = NULL;
					m_htiReaskUnpredictedSourcesDelay = NULL;
						m_htiReaskUnpredictedSourcesDelayDefault = NULL;
						m_htiReaskUnpredictedSourcesDelayEnable = NULL;
						m_htiReaskUnpredictedSourcesDelayDisable = NULL;
					m_htiReaskUnpredictedSourcesLimit = NULL;
				m_htiFailTolerance = NULL;
					m_htiFailToleranceDefault = NULL;
					m_htiFailToleranceEnable = NULL;
					m_htiFailToleranceDisable = NULL;
					m_htiFailToleranceValue = NULL;
					m_htiRetryUnreachable = NULL;
						m_htiRetryUnreachableDefault = NULL;
						m_htiRetryUnreachableEnable = NULL;
						m_htiRetryUnreachableDisable = NULL;
						m_htiRetryUnreachableIntervals = NULL;
					m_htiUnreachableReaskPropability = NULL;
					m_htiReaskUnreachableSourcesLimit = NULL;
			m_htiAdvancedAnalyser = NULL;
				m_htiDisturbanceHandling = NULL;
					m_htiHandleTableGaps = NULL;
						m_htiPriorityGapRatio = NULL;
						m_htiMaxGapSize = NULL;
						m_htiMaxGapTime = NULL;
					m_htiCheckPriorityIP = NULL;
					m_htiCheckPortIntegrity = NULL;
				m_htiMaxMidleDiscrepanceHigh = NULL;
				m_htiMaxMidleDiscrepanceLow = NULL;
				m_htiLastSeenDurationThreshold = NULL;
				m_htiLinkTimeThreshold = NULL;
				m_htiDualLinkedTableGravity = NULL;
				m_htiMaxReliableTime = NULL;
				m_htiTempralIPBorderLine = NULL;
#endif // NEO_SA // NEO: NSA END

	// NEO: NSD - [NeoSourceDrop]
	m_htiDropCleanUp = NULL;
#ifdef NEO_SK // NEO: NSK - [NeoSourceKeeper]
		m_htiDropUnreachable = NULL;
			m_htiDropUnreachableDefault = NULL;
			m_htiDropUnreachableEnable = NULL;
			m_htiDropUnreachableDisable = NULL;
			m_htiDropUnreachableLimit = NULL;
				m_htiDropUnreachableLimitDefault = NULL;
				m_htiDropUnreachableLimitTotal = NULL;
				m_htiDropUnreachableLimitRelativ = NULL;
				m_htiDropUnreachableLimitSpecyfic = NULL;
				m_htiDropUnreachableLimitDisable = NULL;
			m_htiDropUnreachableTimer = NULL;
#endif // NEO_SK // NEO: NSK END
#ifdef NEO_SS // NEO: NSS - [NeoSourceStorage]
		m_htiDropOutOfDate = NULL;
			m_htiDropOutOfDateDefault = NULL;
			m_htiDropOutOfDateEnable = NULL;
			m_htiDropOutOfDateDisable = NULL;
			m_htiDropOutOfDateLimit = NULL;
				m_htiDropOutOfDateLimitDefault = NULL;
				m_htiDropOutOfDateLimitTotal = NULL;
				m_htiDropOutOfDateLimitRelativ = NULL;
				m_htiDropOutOfDateLimitSpecyfic = NULL;
				m_htiDropOutOfDateLimitDisable = NULL;
			m_htiDropOutOfDateTimer = NULL;
			m_htiDropOutOfDatePrefs = NULL;
				m_htiDropOutOfDateSmooth = NULL;
					m_htiDropOutOfDateSmoothDefault = NULL;
					m_htiDropOutOfDateSmoothEnable = NULL;
					m_htiDropOutOfDateSmoothDisable = NULL;
				m_htiDropOutOfDateFails = NULL;
				m_htiDropOutOfDateTime = NULL;
#endif // NEO_SS // NEO: NSS END
#ifdef NEO_SA // NEO: NSA - [NeoSourceAnaliser]
		m_htiDropRetired = NULL;
			m_htiDropRetiredDefault = NULL;
			m_htiDropRetiredEnable = NULL;
			m_htiDropRetiredDisable = NULL;
			m_htiDropRetiredLimit = NULL;
				m_htiDropRetiredLimitDefault = NULL;
				m_htiDropRetiredLimitTotal = NULL;
				m_htiDropRetiredLimitRelativ = NULL;
				m_htiDropRetiredLimitSpecyfic = NULL;
				m_htiDropRetiredLimitDisable = NULL;
			m_htiDropRetiredTimer = NULL;

		m_htiDropLoaded = NULL;
			m_htiDropLoadedDefault = NULL;
			m_htiDropLoadedEnable = NULL;
			m_htiDropLoadedDisable = NULL;
			m_htiDropLoadedLimit = NULL;
				m_htiDropLoadedLimitDefault = NULL;
				m_htiDropLoadedLimitTotal = NULL;
				m_htiDropLoadedLimitRelativ = NULL;
				m_htiDropLoadedLimitSpecyfic = NULL;
				m_htiDropLoadedLimitDisable = NULL;
			m_htiDropLoadedTimer = NULL;
#endif // NEO_SA // NEO: NSA END
	// NEO: NSD END
}

void CPPgSourceStorage::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_MOD_OPTS, m_ctrlTreeOptions);
	if (!m_bInitializedTreeOpts)
	{
		int iImgStorage = 8;
#ifdef NEO_SK // NEO: NSK - [NeoSourceKeeper]
		int iImgSourceKeeper = 8;
#endif // NEO_SK // NEO: NSK END
#ifdef NEO_SS // NEO: NSS - [NeoSourceStorage]
		int iImgSourceStorage = 8;
		int iImgStoreSources = 8;
		int iImgStoreLowID = 8;
		int iImgStoreA4AF = 8;
		int iImgStorePartData = 8;
		int iImgAutoLoad = 8;
		int	iImgAutoSave = 8;
		int iImgAutoReask = 8;
		int iImgBootstrap = 8;
		int iImgTemporaryReask = 8;
		int iImgUnpredicted = 8;
		int iImgGroupReask = 8;
		int	iImgOutOfDate = 8;
		int	iImgSmoothOutOfDate = 8;
#endif // NEO_SS // NEO: NSS END
#ifdef NEO_CD // NEO: NCD - [NeoClientDatabase]
		int	iImgClientDatabase = 8;
		int iImgIPTables = 8;
#endif // NEO_CD // NEO: NCD END
#ifdef NEO_SA // NEO: NSA - [NeoSourceAnaliser]
		int iImgAnaliser = 8;
		int iImgDropTemp = 8;
		int iImgIgnoreUnreahable = 8;
		int iImgFailTolerance = 8;
		int iImgManager = 8;
		int iImgPropabilityMode = 8;
		int iImgAdvanced = 8;
		int iGapHandling = 8;
#endif // NEO_SA // NEO: NSA END

		// NEO: NSD - [NeoSourceDrop]
		int iImgDrop = 8;
#ifdef NEO_SK // NEO: NSK - [NeoSourceKeeper]
		int iImgDropUnreachable = 8;
#endif // NEO_SK // NEO: NSK END
#ifdef NEO_SS // NEO: NSS - [NeoSourceStorage]
		int iImgDropOutOfDate = 8;
#endif // NEO_SS // NEO: NSS END
#ifdef NEO_SA // NEO: NSA - [NeoSourceAnaliser]
		int iImgDropRetired = 8;
		int iImgDropLoaded = 8;
#endif // NEO_SA // NEO: NSA END
		// NEO: NSD END

        CImageList* piml = m_ctrlTreeOptions.GetImageList(TVSIL_NORMAL);
		if (piml){
			iImgStorage = piml->Add(CTempIconLoader(_T("NEOSOURCESTORAGE")));
#ifdef NEO_SK // NEO: NSK - [NeoSourceKeeper]
			iImgSourceKeeper = piml->Add(CTempIconLoader(_T("SOURCEKEEPER")));
#endif // NEO_SK // NEO: NSK END
#ifdef NEO_SS // NEO: NSS - [NeoSourceStorage]
			iImgSourceStorage = piml->Add(CTempIconLoader(_T("STORAGE")));
			iImgStoreSources = piml->Add(CTempIconLoader(_T("STORESOURCES")));
			iImgStoreLowID = piml->Add(CTempIconLoader(_T("STORELOWID")));
			iImgStoreA4AF = piml->Add(CTempIconLoader(_T("STOREA4AF")));
			iImgStorePartData = piml->Add(CTempIconLoader(_T("STOREPARTDATA")));
			iImgAutoLoad = piml->Add(CTempIconLoader(_T("AUTOLOADSOURCES")));
			iImgAutoSave = piml->Add(CTempIconLoader(_T("AUTOSAVESOURCES")));
			iImgAutoReask = piml->Add(CTempIconLoader(_T("AUTOREASKLOADEDSOURCES")));
			iImgBootstrap = piml->Add(CTempIconLoader(_T("BOOTSTRAP")));
			iImgTemporaryReask = piml->Add(CTempIconLoader(_T("AUTOREASKTEMPORARY")));
			iImgUnpredicted = piml->Add(CTempIconLoader(_T("UNPREDICTED")));
			iImgGroupReask = piml->Add(CTempIconLoader(_T("GROUPELOAADEDAUToREASK")));
			iImgOutOfDate = piml->Add(CTempIconLoader(_T("SOURCEOUTOFDATE")));
			iImgSmoothOutOfDate = piml->Add(CTempIconLoader(_T("SOURCEOUTOFDATESMOOTH")));
#endif // NEO_SS // NEO: NSS END
#ifdef NEO_CD // NEO: NCD - [NeoClientDatabase]
			iImgClientDatabase = piml->Add(CTempIconLoader(_T("SOURCEDATABASE")));
			iImgIPTables = piml->Add(CTempIconLoader(_T("IPTABLES")));
#endif // NEO_CD // NEO: NCD END
#ifdef NEO_SA // NEO: NSA - [NeoSourceAnaliser]
			iImgAnaliser = piml->Add(CTempIconLoader(_T("SOURCEANALIZER")));
			iImgDropTemp = piml->Add(CTempIconLoader(_T("DROPTEMPIP")));
			iImgFailTolerance = piml->Add(CTempIconLoader(_T("FAILTOLERANCE")));
			iImgIgnoreUnreahable = piml->Add(CTempIconLoader(_T("IGNOREUNREAHABLE")));
			iImgManager = piml->Add(CTempIconLoader(_T("REASKMANAGER")));
			iImgPropabilityMode = piml->Add(CTempIconLoader(_T("PRIORITYPROPABILITY")));
			iImgAdvanced = piml->Add(CTempIconLoader(_T("ADVANCEDANALISE")));
			iGapHandling = piml->Add(CTempIconLoader(_T("GAPHANDLING")));
#endif // NEO_SA // NEO: NSA END

			// NEO: NSD - [NeoSourceDrop]
			iImgDrop = piml->Add(CTempIconLoader(_T("DROP")));
#ifdef NEO_SK // NEO: NSK - [NeoSourceKeeper]
			iImgDropUnreachable = piml->Add(CTempIconLoader(_T("DROPUNREACHABLE")));
#endif // NEO_SK // NEO: NSK END
#ifdef NEO_SS // NEO: NSS - [NeoSourceStorage]
			iImgDropOutOfDate = piml->Add(CTempIconLoader(_T("DROPOUTOFDATE")));
#endif // NEO_SS // NEO: NSS END
#ifdef NEO_SA // NEO: NSA - [NeoSourceAnaliser]
			iImgDropRetired = piml->Add(CTempIconLoader(_T("DROPRETIRED")));
			iImgDropLoaded = piml->Add(CTempIconLoader(_T("DROPLOADED")));
#endif // NEO_SA // NEO: NSA END
			// NEO: NSD END
		}

		SetTreeGroup(m_ctrlTreeOptions,m_htiNeoSourceStorage,GetResString(IDS_X_SOURCE_STORAGE_PREFS),iImgStorage, TVI_ROOT, GetResString(IDS_X_SOURCE_STORAGE_PREFS_INFO));
#ifdef NEO_SK // NEO: NSK - [NeoSourceKeeper]
			if(ForFile()){
				SetTreeGroup(m_ctrlTreeOptions,m_htiSourceKeeper,GetResString(IDS_X_SOURCE_KEEPER),iImgSourceKeeper, m_htiNeoSourceStorage, GetResString(IDS_X_SOURCE_KEEPER_INFO));
					SetTreeRadio(m_ctrlTreeOptions,m_htiSourceKeeperDefault,GetResString(IDS_X_SOURCE_KEEPER_DEFAULT),m_htiSourceKeeper,GetResString(IDS_X_SOURCE_KEEPER_INFO),TRUE,m_iEnableSourceKeeper == 0);
					SetTreeRadio(m_ctrlTreeOptions,m_htiSourceKeeperEnable,GetResString(IDS_X_SOURCE_KEEPER_ENABLE),m_htiSourceKeeper,GetResString(IDS_X_SOURCE_KEEPER_INFO),TRUE,m_iEnableSourceKeeper == 1);
					SetTreeRadio(m_ctrlTreeOptions,m_htiSourceKeeperDisable,GetResString(IDS_X_SOURCE_KEEPER_DISABLE),m_htiSourceKeeper,GetResString(IDS_X_SOURCE_KEEPER_INFO),TRUE,m_iEnableSourceKeeper == 2);
			}else
				SetTreeCheck(m_ctrlTreeOptions,m_htiSourceKeeper,GetResString(IDS_X_SOURCE_KEEPER),m_htiNeoSourceStorage,GetResString(IDS_X_SOURCE_KEEPER_INFO),FALSE,m_bEnableSourceKeeper);
#endif // NEO_SK // NEO: NSK END
#ifdef NEO_SS // NEO: NSS - [NeoSourceStorage]
			SetTreeGroup(m_ctrlTreeOptions,m_htiSourceStorage,GetResString(IDS_X_SOURCE_SAVER),iImgSourceStorage, m_htiNeoSourceStorage, GetResString(IDS_X_SOURCE_SAVER_INFO));
				if(ForFile()){
					SetTreeRadio(m_ctrlTreeOptions,m_htiUseSourceStorageDefault,GetResString(IDS_X_USE_SOURCE_STORAGE_DEFAULT),m_htiSourceStorage,GetResString(IDS_X_USE_SOURCE_STORAGE_DEFAULT_INFO),TRUE,m_iEnableSourceStorage == 0);
					SetTreeRadio(m_ctrlTreeOptions,m_htiUseSourceStorageEnable,GetResString(IDS_X_USE_SOURCE_STORAGE_ENABLE),m_htiSourceStorage,GetResString(IDS_X_USE_SOURCE_STORAGE_ENABLE_INFO),TRUE,m_iEnableSourceStorage == 1);
					SetTreeRadio(m_ctrlTreeOptions,m_htiUseSourceStorageDisable,GetResString(IDS_X_USE_SOURCE_STORAGE_DISABLE),m_htiSourceStorage,GetResString(IDS_X_USE_SOURCE_STORAGE_DISABLE_INFO),TRUE,m_iEnableSourceStorage == 2);
				}else
					SetTreeCheck(m_ctrlTreeOptions,m_htiUseSourceStorage,GetResString(IDS_X_USE_SOURCE_STORAGE),m_htiSourceStorage,GetResString(IDS_X_USE_SOURCE_STORAGE_INFO),FALSE,m_bEnableSourceStorage);
				if(ForFile()){
					SetTreeGroup(m_ctrlTreeOptions,m_htiAutoSaveSources,GetResString(IDS_X_AUTOMATICLY_SAVE_SOURCES),iImgAutoSave, m_htiSourceStorage, GetResString(IDS_X_AUTOMATICLY_SAVE_SOURCES_INFO));
						SetTreeRadio(m_ctrlTreeOptions,m_htiAutoSaveSourcesDefault,GetResString(IDS_X_AUTOMATICLY_SAVE_SOURCES_DEFAULT),m_htiAutoSaveSources,GetResString(IDS_X_AUTOMATICLY_SAVE_SOURCES_DEFAULT_INFO),TRUE,m_iAutoSaveSources == 0);
						SetTreeRadio(m_ctrlTreeOptions,m_htiAutoSaveSourcesEnable,GetResString(IDS_X_AUTOMATICLY_SAVE_SOURCES_ENABLE),m_htiAutoSaveSources,GetResString(IDS_X_AUTOMATICLY_SAVE_SOURCES_ENABLE_INFO),TRUE,m_iAutoSaveSources == 1);
						SetTreeRadio(m_ctrlTreeOptions,m_htiAutoSaveSourcesEnable,GetResString(IDS_X_AUTOMATICLY_SAVE_SOURCES_ENABLE2),m_htiAutoSaveSources,GetResString(IDS_X_AUTOMATICLY_SAVE_SOURCES_ENABLE2_INFO),TRUE,m_iAutoSaveSources == 2);
						SetTreeRadio(m_ctrlTreeOptions,m_htiAutoSaveSourcesDisable,GetResString(IDS_X_AUTOMATICLY_SAVE_SOURCES_DISABLE),m_htiAutoSaveSources,GetResString(IDS_X_AUTOMATICLY_SAVE_SOURCES_DISABLE_INFO),TRUE,m_iAutoSaveSources == 3);
						SetTreeNumEdit(m_ctrlTreeOptions,m_htiAutoSaveSourcesIntervals,GetResString(IDS_X_AUTOMATICLY_SAVE_SOURCES_INTERVAL), m_htiAutoSaveSources,GetResString(IDS_X_AUTOMATICLY_SAVE_SOURCES_INTERVAL_INFO));
				}else
					SetTreeCheckNumEdit(m_ctrlTreeOptions,m_htiAutoSaveSources,GetResString(IDS_X_AUTOMATICLY_SAVE_SOURCES),m_htiSourceStorage,GetResString(IDS_X_AUTOMATICLY_SAVE_SOURCES_INFO),TRUE,m_uAutoSaveSources);
				SetTreeNumEdit(m_ctrlTreeOptions,m_htiSourceStorageLimit,GetResString(IDS_X_SOURCE_STORAGE_LIMIT), m_htiSourceStorage,GetResString(IDS_X_SOURCE_STORAGE_LIMIT_INFO));
				SetTreeGroup(m_ctrlTreeOptions,m_htiStoreSources,GetResString(IDS_X_STORE_SOURCE),iImgStoreSources, m_htiSourceStorage, GetResString(IDS_X_STORE_SOURCE_INFO));
					if(ForFile()){
						SetTreeGroup(m_ctrlTreeOptions,m_htiStoreLowIDSources,GetResString(IDS_X_STORE_LOW_ID),iImgStoreLowID, m_htiStoreSources, GetResString(IDS_X_STORE_LOW_ID_INFO));
							SetTreeRadio(m_ctrlTreeOptions,m_htiStoreLowIDSourcesDefault,GetResString(IDS_X_STORE_LOW_ID_DEFAULT),m_htiStoreLowIDSources,GetResString(IDS_X_STORE_LOW_ID_DEFAULT_INFO),TRUE,m_iStoreLowIDSources == 0);
							SetTreeRadio(m_ctrlTreeOptions,m_htiStoreLowIDSourcesEnable,GetResString(IDS_X_STORE_LOW_ID_ENABLE),m_htiStoreLowIDSources,GetResString(IDS_X_STORE_LOW_ID_ENABLE_INFO),TRUE,m_iStoreLowIDSources == 1);
							SetTreeRadio(m_ctrlTreeOptions,m_htiStoreLowIDSourcesDisable,GetResString(IDS_X_STORE_LOW_ID_DISABLE),m_htiStoreLowIDSources,GetResString(IDS_X_STORE_LOW_ID_DISABLE_INFO),TRUE,m_iStoreLowIDSources == 2);
					}else
						SetTreeCheck(m_ctrlTreeOptions,m_htiStoreLowIDSources,GetResString(IDS_X_STORE_LOW_ID),m_htiStoreSources,GetResString(IDS_X_STORE_LOW_ID_INFO),FALSE,m_bStoreLowIDSources);
					if(ForFile()){
						SetTreeGroup(m_ctrlTreeOptions,m_htiStoreAlsoA4AFSources,GetResString(IDS_X_STORE_A4AF),iImgStoreA4AF, m_htiStoreSources, GetResString(IDS_X_STORE_A4AF_INFO));
							SetTreeRadio(m_ctrlTreeOptions,m_htiStoreAlsoA4AFSourcesDefault,GetResString(IDS_X_STORE_A4AF_DEFAULT),m_htiStoreAlsoA4AFSources,GetResString(IDS_X_STORE_A4AF_DEFAULT_INFO),TRUE,m_iStoreAlsoA4AFSources == 0);
							SetTreeRadio(m_ctrlTreeOptions,m_htiStoreAlsoA4AFSourcesEnable,GetResString(IDS_X_STORE_A4AF_ENABLE),m_htiStoreAlsoA4AFSources,GetResString(IDS_X_STORE_A4AF_ENABLE_INFO),TRUE,m_iStoreAlsoA4AFSources == 1);
							SetTreeRadio(m_ctrlTreeOptions,m_htiStoreAlsoA4AFSourcesDisable,GetResString(IDS_X_STORE_A4AF_DISABLE),m_htiStoreAlsoA4AFSources,GetResString(IDS_X_STORE_A4AF_DISABLE_INFO),TRUE,m_iStoreAlsoA4AFSources == 2);
					}else
						SetTreeCheck(m_ctrlTreeOptions,m_htiStoreAlsoA4AFSources,GetResString(IDS_X_STORE_A4AF),m_htiStoreSources,GetResString(IDS_X_STORE_A4AF_INFO),FALSE,m_bStoreAlsoA4AFSources);
					if(ForFile()){
						SetTreeGroup(m_ctrlTreeOptions,m_htiStoreSourcesFileStatus,GetResString(IDS_X_STORE_PART_STATUS),iImgStorePartData, m_htiStoreSources, GetResString(IDS_X_STORE_PART_STATUS_INFO));
							SetTreeRadio(m_ctrlTreeOptions,m_htiStoreSourcesFileStatusDefault,GetResString(IDS_X_STORE_PART_STATUS_DEFAULT),m_htiStoreSourcesFileStatus,GetResString(IDS_X_STORE_PART_STATUS_DEFAULT_INFO),TRUE,m_iStoreSourcesFileStatus == 0);
							SetTreeRadio(m_ctrlTreeOptions,m_htiStoreSourcesFileStatusEnable,GetResString(IDS_X_STORE_PART_STATUS_ENABLE),m_htiStoreSourcesFileStatus,GetResString(IDS_X_STORE_PART_STATUS_ENABLE_INFO),TRUE,m_iStoreSourcesFileStatus == 1);
							SetTreeRadio(m_ctrlTreeOptions,m_htiStoreSourcesFileStatusSemiEnable,GetResString(IDS_X_STORE_PART_STATUS_SEMI_ENABLE),m_htiStoreSourcesFileStatus,GetResString(IDS_X_STORE_PART_STATUS_SEMI_ENABLE_INFO),TRUE,m_iStoreSourcesFileStatus == 2);
							SetTreeRadio(m_ctrlTreeOptions,m_htiStoreSourcesFileStatusDisable,GetResString(IDS_X_STORE_PART_STATUS_DISABLE),m_htiStoreSourcesFileStatus,GetResString(IDS_X_STORE_PART_STATUS_DISABLE_INFO),TRUE,m_iStoreSourcesFileStatus == 3);
					}else
						SetTreeCheck(m_ctrlTreeOptions,m_htiStoreSourcesFileStatus,GetResString(IDS_X_STORE_PART_STATUS),m_htiStoreSources,GetResString(IDS_X_STORE_PART_STATUS_INFO),FALSE,m_uStoreSourcesFileStatus);
				if(ForFile()){
					SetTreeGroup(m_ctrlTreeOptions,m_htiAutoLoadStoredSources,GetResString(IDS_X_AUTOMATICLY_LOAD_STORED_SOURCES),iImgAutoLoad, m_htiSourceStorage, GetResString(IDS_X_AUTOMATICLY_LOAD_STORED_SOURCES_INFO));
						SetTreeRadio(m_ctrlTreeOptions,m_htiAutoLoadStoredSourcesDefault,GetResString(IDS_X_AUTOMATICLY_LOAD_STORED_SOURCES_DEFAULT),m_htiAutoLoadStoredSources,GetResString(IDS_X_AUTOMATICLY_LOAD_STORED_SOURCES_DEFAULT_INFO),TRUE,m_iAutoLoadStoredSources == 0);
						SetTreeRadio(m_ctrlTreeOptions,m_htiAutoLoadStoredSourcesEnable,GetResString(IDS_X_AUTOMATICLY_LOAD_STORED_SOURCES_ENABLE),m_htiAutoLoadStoredSources,GetResString(IDS_X_AUTOMATICLY_LOAD_STORED_SOURCES_ENABLE_INFO),TRUE,m_iAutoLoadStoredSources == 1);
						SetTreeRadio(m_ctrlTreeOptions,m_htiAutoLoadStoredSourcesSemiEnable,GetResString(IDS_X_AUTOMATICLY_LOAD_STORED_SOURCES_SEMIENABLE),m_htiAutoLoadStoredSources,GetResString(IDS_X_AUTOMATICLY_LOAD_STORED_SOURCES_SEMIENABLE_INFO),TRUE,m_iAutoLoadStoredSources == 2);
						SetTreeRadio(m_ctrlTreeOptions,m_htiAutoLoadStoredSourcesDisable,GetResString(IDS_X_AUTOMATICLY_LOAD_STORED_SOURCES_DISABLE),m_htiAutoLoadStoredSources,GetResString(IDS_X_AUTOMATICLY_LOAD_STORED_SOURCES_DISABLE_INFO),TRUE,m_iAutoLoadStoredSources == 3);
				}else
					SetTreeCheck(m_ctrlTreeOptions,m_htiAutoLoadStoredSources,GetResString(IDS_X_AUTOMATICLY_LOAD_STORED_SOURCES),m_htiSourceStorage,GetResString(IDS_X_AUTOMATICLY_LOAD_STORED_SOURCES_INFO),TRUE,m_bAutoLoadStoredSources);
				SetTreeGroup(m_ctrlTreeOptions,m_htiAutoReaskStoredSources,GetResString(IDS_X_REASK_LOAD_SOURCES_MANAGER),iImgAutoReask, m_htiSourceStorage, GetResString(IDS_X_REASK_LOAD_SOURCES_MANAGER_INFO));
					if(ForFile()){
						SetTreeRadio(m_ctrlTreeOptions,m_htiAutoReaskStoredSourcesDefault,GetResString(IDS_X_AUTO_REASK_LOAD_SOURCES_DEFAULT),m_htiAutoReaskStoredSources,GetResString(IDS_X_AUTO_REASK_LOAD_SOURCES_DEFAULT_INFO),TRUE,m_iAutoReaskStoredSources == 0);
						SetTreeRadio(m_ctrlTreeOptions,m_htiAutoReaskStoredSourcesEnable,GetResString(IDS_X_AUTO_REASK_LOAD_SOURCES_ENABLE),m_htiAutoReaskStoredSources,GetResString(IDS_X_AUTO_REASK_LOAD_SOURCES_ENABLE_INFO),TRUE,m_iAutoReaskStoredSources == 1);
						SetTreeRadio(m_ctrlTreeOptions,m_htiAutoReaskStoredSourcesDisable,GetResString(IDS_X_AUTO_REASK_LOAD_SOURCES_DISABLE),m_htiAutoReaskStoredSources,GetResString(IDS_X_AUTO_REASK_LOAD_SOURCES_DISABLE_INFO),TRUE,m_iAutoReaskStoredSources == 2);
					}else
						SetTreeCheck(m_ctrlTreeOptions,m_htiAutoReaskStoredSourcesEnable,GetResString(IDS_X_AUTO_REASK_LOAD_SOURCES_ENABLE),m_htiAutoReaskStoredSources,GetResString(IDS_X_AUTO_REASK_LOAD_SOURCES_ENABLE_INFO),FALSE,m_bAutoReaskStoredSources);
					SetTreeNumEdit(m_ctrlTreeOptions,m_htiAutoReaskStoredSourcesLimit,GetResString(IDS_X_AUTO_REASK_LOAD_SOURCES_LIMIT), m_htiAutoReaskStoredSources,GetResString(IDS_X_AUTO_REASK_LOAD_SOURCES_LIMIT_INFO));
						if(ForFile()){
							SetTreeRadio(m_ctrlTreeOptions,m_htiTotalSourceRestoreDefault,GetResString(IDS_X_TOTAL_SOURCE_RESTORE_DEFAULT),m_htiAutoReaskStoredSourcesLimit,GetResString(IDS_X_TOTAL_SOURCE_RESTORE_DEFAULT_INFO),TRUE,m_iTotalSourceRestore == 0);
							SetTreeRadio(m_ctrlTreeOptions,m_htiTotalSourceRestoreEnable,GetResString(IDS_X_TOTAL_SOURCE_RESTORE_ENABLE),m_htiAutoReaskStoredSourcesLimit,GetResString(IDS_X_TOTAL_SOURCE_RESTORE_ENABLE_INFO),TRUE,m_iTotalSourceRestore == 1);
							SetTreeRadio(m_ctrlTreeOptions,m_htiTotalSourceRestoreDisable,GetResString(IDS_X_TOTAL_SOURCE_RESTORE_DISABLE),m_htiAutoReaskStoredSourcesLimit,GetResString(IDS_X_TOTAL_SOURCE_RESTORE_DISABLE_INFO),TRUE,m_iTotalSourceRestore == 2);
						}else
							SetTreeCheck(m_ctrlTreeOptions,m_htiTotalSourceRestoreEnable,GetResString(IDS_X_TOTAL_SOURCE_RESTORE_ENABLE),m_htiAutoReaskStoredSourcesLimit,GetResString(IDS_X_TOTAL_SOURCE_RESTORE_ENABLE_INFO),FALSE,m_bTotalSourceRestore);
					if(ForFile()){
						SetTreeGroup(m_ctrlTreeOptions,m_htiStorageBootstrap,GetResString(IDS_X_STORAGE_BOOTSTRAP),iImgBootstrap, m_htiAutoReaskStoredSources, GetResString(IDS_X_STORAGE_BOOTSTRAP_INFO));
							SetTreeRadio(m_ctrlTreeOptions,m_htiStorageBootstrapDefault,GetResString(IDS_X_STORAGE_BOOTSTRAP_DEFAULT),m_htiStorageBootstrap,GetResString(IDS_X_STORAGE_BOOTSTRAP_DEFAULT_INFO),TRUE,m_iUseStorageBootstrap == 0);
							SetTreeRadio(m_ctrlTreeOptions,m_htiStorageBootstrapEnable,GetResString(IDS_X_STORAGE_BOOTSTRAP_ENABLE),m_htiStorageBootstrap,GetResString(IDS_X_STORAGE_BOOTSTRAP_ENABLE_INFO),TRUE,m_iUseStorageBootstrap == 1);
							SetTreeRadio(m_ctrlTreeOptions,m_htiStorageBootstrapDisable,GetResString(IDS_X_STORAGE_BOOTSTRAP_DISABLE),m_htiStorageBootstrap,GetResString(IDS_X_STORAGE_BOOTSTRAP_DISABLE_INFO),TRUE,m_iUseStorageBootstrap == 2);
					}else
						SetTreeCheck(m_ctrlTreeOptions,m_htiStorageBootstrap,GetResString(IDS_X_STORAGE_BOOTSTRAP_ENABLE),m_htiAutoReaskStoredSources,GetResString(IDS_X_STORAGE_BOOTSTRAP_ENABLE_INFO),FALSE,m_bUseStorageBootstrap);
						SetTreeNumEdit(m_ctrlTreeOptions,m_htiStorageBootstrapTime,GetResString(IDS_X_STORAGE_BOOTSTRAP_TIME), m_htiStorageBootstrap,GetResString(IDS_X_STORAGE_BOOTSTRAP_TIME_INFO));
						SetTreeNumEdit(m_ctrlTreeOptions,m_htiStorageBootstrapRequirement,GetResString(IDS_X_STORAGE_BOOTSTRAP_REQUIREMENT), m_htiStorageBootstrap,GetResString(IDS_X_STORAGE_BOOTSTRAP_REQUIREMENT_INFO));
					if(ForFile()){
						SetTreeNumEdit(m_ctrlTreeOptions,m_htiAutoReaskStoredSourcesDelay,GetResString(IDS_X_AUTO_REASK_LOAD_SOURCES_DELAY), m_htiAutoReaskStoredSources,GetResString(IDS_X_AUTO_REASK_LOAD_SOURCES_DELAY_INFO));
							SetTreeRadio(m_ctrlTreeOptions,m_htiAutoReaskStoredSourcesDelayDefault,GetResString(IDS_X_AUTO_REASK_LOAD_SOURCES_DELAY_DEFAULT),m_htiAutoReaskStoredSourcesDelay,GetResString(IDS_X_AUTO_REASK_LOAD_SOURCES_DELAY_DEFAULT_INFO),TRUE,m_iUseAutoReaskStoredSourcesDelay == 0);
							SetTreeRadio(m_ctrlTreeOptions,m_htiAutoReaskStoredSourcesDelayEnable,GetResString(IDS_X_AUTO_REASK_LOAD_SOURCES_DELAY_ENABLE),m_htiAutoReaskStoredSourcesDelay,GetResString(IDS_X_AUTO_REASK_LOAD_SOURCES_DELAY_ENABLE_INFO),TRUE,m_iUseAutoReaskStoredSourcesDelay == 1);
							SetTreeRadio(m_ctrlTreeOptions,m_htiAutoReaskStoredSourcesDelayDisable,GetResString(IDS_X_AUTO_REASK_LOAD_SOURCES_DELAY_DISABLE),m_htiAutoReaskStoredSourcesDelay,GetResString(IDS_X_AUTO_REASK_LOAD_SOURCES_DELAY_DISABLE_INFO),TRUE,m_iUseAutoReaskStoredSourcesDelay == 2);
					}else
						SetTreeCheckNumEdit(m_ctrlTreeOptions,m_htiAutoReaskStoredSourcesDelay,GetResString(IDS_X_AUTO_REASK_LOAD_SOURCES_DELAY),m_htiAutoReaskStoredSources,GetResString(IDS_X_AUTO_REASK_LOAD_SOURCES_DELAY_INFO),FALSE,m_bUseAutoReaskStoredSourcesDelay);
					SetTreeNumEdit(m_ctrlTreeOptions,m_htiAutoReaskLoadedSourcesDelay,GetResString(IDS_X_AUTO_REASK_LOAD_SOURCES_PROCESS_DELAY), m_htiAutoReaskStoredSources,GetResString(IDS_X_AUTO_REASK_LOAD_SOURCES_PROCESS_DELAY_INFO));
					if(ForFile()){
						SetTreeGroup(m_ctrlTreeOptions,m_htiGroupStoredSourceReask,GetResString(IDS_X_GROUPE_AUTO_REASK),iImgGroupReask, m_htiAutoReaskStoredSources, GetResString(IDS_X_GROUPE_AUTO_REASK_INFO));
							SetTreeRadio(m_ctrlTreeOptions,m_htiGroupStoredSourceReaskDefault,GetResString(IDS_X_GROUPE_AUTO_REASK_DEFAULT),m_htiGroupStoredSourceReask,GetResString(IDS_X_GROUPE_AUTO_REASK_DEFAULT_INFO),TRUE,m_iGroupStoredSourceReask == 0);
							SetTreeRadio(m_ctrlTreeOptions,m_htiGroupStoredSourceReaskEnable,GetResString(IDS_X_GROUPE_AUTO_REASK_ENABLE),m_htiGroupStoredSourceReask,GetResString(IDS_X_GROUPE_AUTO_REASK_ENABLE_INFO),TRUE,m_iGroupStoredSourceReask == 1);
							SetTreeRadio(m_ctrlTreeOptions,m_htiGroupStoredSourceReaskDisable,GetResString(IDS_X_GROUPE_AUTO_REASK_DISABLE),m_htiGroupStoredSourceReask,GetResString(IDS_X_GROUPE_AUTO_REASK_DISABLE_INFO),TRUE,m_iGroupStoredSourceReask == 2);
					}else
						SetTreeCheck(m_ctrlTreeOptions,m_htiGroupStoredSourceReask,GetResString(IDS_X_GROUPE_AUTO_REASK),m_htiAutoReaskStoredSources,GetResString(IDS_X_GROUPE_AUTO_REASK_INFO),FALSE,m_bGroupStoredSourceReask);
						SetTreeNumEdit(m_ctrlTreeOptions,m_htiStoredSourceGroupIntervals,GetResString(IDS_X_GROUPE_AUTO_REASK_INTERVALS), m_htiGroupStoredSourceReask,GetResString(IDS_X_GROUPE_AUTO_REASK_INTERVALS_INFO));
						SetTreeNumEdit(m_ctrlTreeOptions,m_htiStoredSourceGroupSize,GetResString(IDS_X_GROUPE_AUTO_REASK_SIZE), m_htiGroupStoredSourceReask,GetResString(IDS_X_GROUPE_AUTO_REASK_SIZE_INFO));
				SetTreeGroup(m_ctrlTreeOptions,m_htiOutOfDate,GetResString(IDS_X_SOURCE_OUT_OF_DATE),iImgOutOfDate, m_htiSourceStorage, GetResString(IDS_X_SOURCE_OUT_OF_DATE_INFO));
					if(ForFile()){
						SetTreeGroup(m_ctrlTreeOptions,m_htiUseSmoothOutOfDate,GetResString(IDS_X_SOURCE_SMOOTH_OUT_OF_DATE),iImgSmoothOutOfDate, m_htiOutOfDate, GetResString(IDS_X_SOURCE_SMOOTH_OUT_OF_DATE_INFO));
							SetTreeRadio(m_ctrlTreeOptions,m_htiUseSmoothOutOfDateDefault,GetResString(IDS_X_SOURCE_SMOOTH_OUT_OF_DATE_DEFAULT),m_htiUseSmoothOutOfDate,GetResString(IDS_X_SOURCE_SMOOTH_OUT_OF_DATE_DEFAULT_INFO),TRUE,m_iUseSmoothOutOfDate == 0);
							SetTreeRadio(m_ctrlTreeOptions,m_htiUseSmoothOutOfDateEnable,GetResString(IDS_X_SOURCE_SMOOTH_OUT_OF_DATE_ENABLE),m_htiUseSmoothOutOfDate,GetResString(IDS_X_SOURCE_SMOOTH_OUT_OF_DATE_ENABLE_INFO),TRUE,m_iUseSmoothOutOfDate == 1);
							SetTreeRadio(m_ctrlTreeOptions,m_htiUseSmoothOutOfDateDisable,GetResString(IDS_X_SOURCE_SMOOTH_OUT_OF_DATE_DISABLE),m_htiUseSmoothOutOfDate,GetResString(IDS_X_SOURCE_SMOOTH_OUT_OF_DATE_DISABLE_INFO),TRUE,m_iUseSmoothOutOfDate == 2);
					}else
						SetTreeCheck(m_ctrlTreeOptions,m_htiUseSmoothOutOfDate,GetResString(IDS_X_SOURCE_SMOOTH_OUT_OF_DATE),m_htiOutOfDate,GetResString(IDS_X_SOURCE_SMOOTH_OUT_OF_DATE_INFO),FALSE,m_bUseSmoothOutOfDate);
					SetTreeNumEdit(m_ctrlTreeOptions,m_htiMaxStoredFaildCount,GetResString(IDS_X_SOURCE_OUT_OF_DATE_FAILS), m_htiOutOfDate,GetResString(IDS_X_SOURCE_OUT_OF_DATE_FAILS_INFO));
					SetTreeNumEdit(m_ctrlTreeOptions,m_htiStoredOutOfDate,GetResString(IDS_X_SOURCE_OUT_OF_DATE_TIME), m_htiOutOfDate,GetResString(IDS_X_SOURCE_OUT_OF_DATE_TIME_INFO));
#endif // NEO_SS // NEO: NSS END
#ifdef NEO_CD // NEO: NCD - [NeoClientDatabase]
			if(!ForFile()){
				SetTreeGroup(m_ctrlTreeOptions,m_htiClientDatabase,GetResString(IDS_X_CLIENT_DATABASE),iImgClientDatabase, m_htiNeoSourceStorage, GetResString(IDS_X_CLIENT_DATABASE_INFO));
					SetTreeCheck(m_ctrlTreeOptions,m_htiEnableSourceList,GetResString(IDS_X_ENABLE_CLIENT_DATABASE),m_htiClientDatabase,GetResString(IDS_X_ENABLE_CLIENT_DATABASE_INFO),FALSE,m_bEnableSourceList);
					SetTreeCheck(m_ctrlTreeOptions,m_htiSaveGlobalSourceList,GetResString(IDS_X_SAVE_CLIENT_DATABASE),m_htiClientDatabase,GetResString(IDS_X_SAVE_CLIENT_DATABASE_INFO),TRUE,m_uSaveGlobalSourceList);
						SetTreeNumEdit(m_ctrlTreeOptions,m_htiGlobalSourceListCleanUpTime,GetResString(IDS_X_GLOBAL_SOURCE_LIST_CLEAN_UP_TIME), m_htiSaveGlobalSourceList,GetResString(IDS_X_GLOBAL_SOURCE_LIST_CLEAN_UP_TIME_INFO));
						SetTreeCheckNumEdit(m_ctrlTreeOptions,m_htiGlobalSourceListCleanUp,GetResString(IDS_X_GLOBAL_SOURCE_LIST_CLEAN_UP),m_htiSaveGlobalSourceList,GetResString(IDS_X_GLOBAL_SOURCE_LIST_CLEAN_UP_INFO),FALSE,m_bGlobalSourceListCleanUp);
						SetTreeCheck(m_ctrlTreeOptions,m_htiFastSourceCleanUp,GetResString(IDS_X_FAST_SOURCE_CLEAN_UP),m_htiSaveGlobalSourceList,GetResString(IDS_X_FAST_SOURCE_CLEAN_UP_INFO),FALSE,m_bFastSourceCleanUp);
					SetTreeCheck(m_ctrlTreeOptions,m_htiSaveSourceFileList,GetResString(IDS_X_SAVE_CLIENT_FILELIST),m_htiClientDatabase,GetResString(IDS_X_SAVE_CLIENT_FILELIST_INFO),FALSE,m_bSaveSourceFileList);
						SetTreeNumEdit(m_ctrlTreeOptions,m_htiSourceFileListCleanUpTime,GetResString(IDS_X_SOURCE_FILE_LIST_CLEAN_UP_TIME), m_htiSaveSourceFileList,GetResString(IDS_X_SOURCE_FILE_LIST_CLEAN_UP_TIME_INFO));
					SetTreeCheck(m_ctrlTreeOptions,m_htiSaveSourceDataInClient,GetResString(IDS_X_SAVE_CLIENT_DATABASE_IN_CLINET),m_htiClientDatabase,GetResString(IDS_X_SAVE_CLIENT_DATABASE_IN_CLINET_INFO),FALSE,m_bSaveSourceDataInClient);

					SetTreeCheck(m_ctrlTreeOptions,m_htiIPZoneCheck,GetResString(IDS_X_IP_ZONE_CHECK),m_htiClientDatabase,GetResString(IDS_X_IP_ZONE_CHECK_INFO),FALSE,m_bIPZoneCheck);

					SetTreeCheck(m_ctrlTreeOptions,m_htiSourceHashMonitor,GetResString(IDS_X_SOURCE_HASH_MONITOR),m_htiClientDatabase,GetResString(IDS_X_SOURCE_HASH_MONITOR_INFO),FALSE,m_bSourceHashMonitor);
						SetTreeNumEdit(m_ctrlTreeOptions,m_htiSourceHashMonitorBadTime,GetResString(IDS_X_SOURCE_HASH_MONITOR_TIME), m_htiSourceHashMonitor,GetResString(IDS_X_SOURCE_HASH_MONITOR_TIME_INFO));
						SetTreeNumEdit(m_ctrlTreeOptions,m_htiSourceHashMonitorMaxBad,GetResString(IDS_X_SOURCE_HASH_MONITOR_BAD), m_htiSourceHashMonitor,GetResString(IDS_X_SOURCE_HASH_MONITOR_BAD_INFO));

					SetTreeGroup(m_ctrlTreeOptions,m_htiIPTables,GetResString(IDS_X_IP_TABLES),iImgIPTables, m_htiClientDatabase, GetResString(IDS_X_IP_TABLES_INFO));
						SetTreeNumEdit(m_ctrlTreeOptions,m_htiTableAmountToStore,GetResString(IDS_X_IP_TABLE_AMOUNT_TO_STORE), m_htiIPTables,GetResString(IDS_X_IP_TABLE_AMOUNT_TO_STORE_INFO));

						SetTreeNumEdit(m_ctrlTreeOptions,m_htiIgnoreUnreachableInterval,GetResString(IDS_X_IP_TABLE_IGNORE_UNREAHABLE_INTERVALS), m_htiIPTables,GetResString(IDS_X_IP_TABLE_IGNORE_UNREAHABLE_INTERVALS_INFO));
						SetTreeNumEdit(m_ctrlTreeOptions,m_htiIgnoreUndefinedInterval,GetResString(IDS_X_IP_TABLE_IGNORE_UNDEFINED_INTERVALS), m_htiIPTables,GetResString(IDS_X_IP_TABLE_IGNORE_UNDEFINED_INTERVALS_INFO));
						SetTreeNumEdit(m_ctrlTreeOptions,m_htiBeginNewTableInterval,GetResString(IDS_X_IP_TABLE_BENIN_NEW_INTERVALS), m_htiIPTables,GetResString(IDS_X_IP_TABLE_BENIN_NEW_INTERVALS_INFO));
			}
#endif // NEO_CD // NEO: NCD END
#ifdef NEO_SA // NEO: NSA - [NeoSourceAnaliser]
			SetTreeGroup(m_ctrlTreeOptions,m_htiSourceAnaliser,GetResString(IDS_X_SOURCE_ANALISER),iImgAnaliser, m_htiNeoSourceStorage, GetResString(IDS_X_SOURCE_ANALISER_INFO));
			if(ForFile()){
				SetTreeRadio(m_ctrlTreeOptions,m_htiSourceAnaliserDefault,GetResString(IDS_X_SOURCE_ANALISER_DEFAULT),m_htiSourceAnaliser,GetResString(IDS_X_SOURCE_ANALISER_DEFAULT_INFO),TRUE,m_iEnableSourceAnalizer == 0);
				SetTreeRadio(m_ctrlTreeOptions,m_htiSourceAnaliserEnable,GetResString(IDS_X_SOURCE_ANALISER_ENABLE),m_htiSourceAnaliser,GetResString(IDS_X_SOURCE_ANALISER_ENABLE_INFO),TRUE,m_iEnableSourceAnalizer == 1);
				SetTreeRadio(m_ctrlTreeOptions,m_htiSourceAnaliserDisable,GetResString(IDS_X_SOURCE_ANALISER_DISABLE),m_htiSourceAnaliser,GetResString(IDS_X_SOURCE_ANALISER_DISABLE_INFO),TRUE,m_iEnableSourceAnalizer == 2);
			}else
				SetTreeCheck(m_ctrlTreeOptions,m_htiSourceAnaliserEnable,GetResString(IDS_X_SOURCE_ANALISER_ENABLE),m_htiSourceAnaliser,GetResString(IDS_X_SOURCE_ANALISER_ENABLE_INFO),FALSE,m_bEnableSourceAnalizer);
			if(!ForFile()){
				SetTreeNumEdit(m_ctrlTreeOptions,m_htiAnaliseIntervals,GetResString(IDS_X_ANALISIS_INTERVALS), m_htiSourceAnaliser,GetResString(IDS_X_ANALISIS_INTERVALS_INFO));
				SetTreeNumEdit(m_ctrlTreeOptions,m_htiTableAmountToAnalise,GetResString(IDS_X_IP_TABLE_TO_ANALISE), m_htiSourceAnaliser,GetResString(IDS_X_IP_TABLE_TO_ANALISE_INFO));
			}
			if(ForFile()){
				SetTreeGroup(m_ctrlTreeOptions,m_htiDontStoreTemporarySources,GetResString(IDS_X_DONT_STORE_TEMP_SOURCES),iImgDropTemp, m_htiSourceAnaliser, GetResString(IDS_X_DONT_STORE_TEMP_SOURCES_INFO));
					SetTreeRadio(m_ctrlTreeOptions,m_htiDontStoreTemporarySourcesDefault,GetResString(IDS_X_DONT_STORE_TEMP_SOURCES_DEFAULT),m_htiDontStoreTemporarySources,GetResString(IDS_X_DONT_STORE_TEMP_SOURCES_DEFAULT_INFO),TRUE,m_iDontStoreTemporarySources == 0);
					SetTreeRadio(m_ctrlTreeOptions,m_htiDontStoreTemporarySourcesEnable,GetResString(IDS_X_DONT_STORE_TEMP_SOURCES_ENABLE),m_htiDontStoreTemporarySources,GetResString(IDS_X_DONT_STORE_TEMP_SOURCES_ENABLE_INFO),TRUE,m_iDontStoreTemporarySources == 1);
					SetTreeRadio(m_ctrlTreeOptions,m_htiDontStoreTemporarySourcesDisable,GetResString(IDS_X_DONT_STORE_TEMP_SOURCES_DISABLE),m_htiDontStoreTemporarySources,GetResString(IDS_X_DONT_STORE_TEMP_SOURCES_DISABLE_INFO),TRUE,m_iDontStoreTemporarySources == 2);
			}else
				SetTreeCheck(m_ctrlTreeOptions,m_htiDontStoreTemporarySources,GetResString(IDS_X_DONT_STORE_TEMP_SOURCES),m_htiSourceAnaliser,GetResString(IDS_X_DONT_STORE_TEMP_SOURCES_INFO),FALSE,m_bDontStoreTemporarySources);

			SetTreeGroup(m_ctrlTreeOptions,m_htiReaskManager,GetResString(IDS_X_REASK_MANAGER),iImgManager, m_htiSourceAnaliser, GetResString(IDS_X_REASK_MANAGER_INFO));

				SetTreeGroup(m_ctrlTreeOptions,m_htiPropabilityMode,GetResString(IDS_X_PROPABILITY_MODE),iImgPropabilityMode, m_htiReaskManager, GetResString(IDS_X_PROPABILITY_MODE_INFO));
					if(ForFile())
						SetTreeRadio(m_ctrlTreeOptions,m_htiPropabilityModeDefault,GetResString(IDS_X_PROPABILITY_MODE_DEFAULT),m_htiPropabilityMode,GetResString(IDS_X_PROPABILITY_MODE_INFO),TRUE,m_iPropabilityMode == NULL);
					SetTreeRadio(m_ctrlTreeOptions,m_htiPropabilityModeNormal,GetResString(IDS_X_PROPABILITY_MODE_NORMAL),m_htiPropabilityMode,GetResString(IDS_X_PROPABILITY_MODE_NORMAL_INFO),ForFile(),m_iPropabilityMode == (ForFile() ? PM_MIDLE+1 : PM_MIDLE));
					SetTreeRadio(m_ctrlTreeOptions,m_htiPropabilityModeHigh,GetResString(IDS_X_PROPABILITY_MODE_HIGH),m_htiPropabilityMode,GetResString(IDS_X_PROPABILITY_MODE_HIGH_INFO),ForFile(),m_iPropabilityMode == (ForFile() ? PM_MAX+1 : PM_MAX));
					SetTreeRadio(m_ctrlTreeOptions,m_htiPropabilityModeAuto,GetResString(IDS_X_PROPABILITY_MODE_AUTO),m_htiPropabilityMode,GetResString(IDS_X_PROPABILITY_MODE_AUTO_INFO),ForFile(),m_iPropabilityMode == (ForFile() ? PM_AUTO+1 : PM_AUTO));
					SetTreeRadioNumEdit(m_ctrlTreeOptions,m_htiPropabilityModeEnhanced,GetResString(IDS_X_PROPABILITY_MODE_ENHANCED),m_htiPropabilityMode,GetResString(IDS_X_PROPABILITY_MODE_ENHANCED_INFO),ForFile(),m_iPropabilityMode == (ForFile() ? PM_ENHANCED+1 : PM_ENHANCED));

				SetTreeNumEdit(m_ctrlTreeOptions,m_htiReaskPropability,GetResString(IDS_X_REASK_PROPABILITY), m_htiReaskManager,GetResString(IDS_X_REASK_PROPABILITY_INFO));
				SetTreeNumEdit(m_ctrlTreeOptions,m_htiReservePropability,GetResString(IDS_X_RESERVE_PROPABILITY), m_htiReaskManager,GetResString(IDS_X_RESERVE_PROPABILITY_INFO));
					if(ForFile()){
						SetTreeRadio(m_ctrlTreeOptions,m_htiAutoReserveReaskDefault,GetResString(IDS_X_AUTO_RESERVE_REASK_DEFAULT),m_htiReservePropability,GetResString(IDS_X_AUTO_RESERVE_REASK_DEFAULT_INFO),TRUE,m_iAutoReserveReask == 0);
						SetTreeRadio(m_ctrlTreeOptions,m_htiAutoReserveReaskEnable,GetResString(IDS_X_AUTO_RESERVE_REASK_ENABLE),m_htiReservePropability,GetResString(IDS_X_AUTO_RESERVE_REASK_ENABLE_INFO),TRUE,m_iAutoReserveReask == 1);
						SetTreeRadio(m_ctrlTreeOptions,m_htiAutoReserveReaskDisable,GetResString(IDS_X_AUTO_RESERVE_REASK_DISABLE),m_htiReservePropability,GetResString(IDS_X_AUTO_RESERVE_REASK_DISABLE_INFO),TRUE,m_iAutoReserveReask == 2);
					}else
						SetTreeCheck(m_ctrlTreeOptions,m_htiAutoReserveReaskEnable,GetResString(IDS_X_AUTO_RESERVE_REASK_ENABLE),m_htiReservePropability,GetResString(IDS_X_AUTO_RESERVE_REASK_ENABLE_INFO),FALSE,m_bAutoReserveReask);
					SetTreeNumEdit(m_ctrlTreeOptions,m_htiReserveReaskPropability,GetResString(IDS_X_RESERVE_REASK_PROPABILITY), m_htiReservePropability,GetResString(IDS_X_RESERVE_REASK_PROPABILITY_INFO));
					if(ForFile()){
						SetTreeNumEdit(m_ctrlTreeOptions,m_htiReaskReserveSourcesDelay,GetResString(IDS_X_REASK_RESERVE_DELAY), m_htiReservePropability,GetResString(IDS_X_REASK_RESERVE_DELAY_INFO));
							SetTreeRadio(m_ctrlTreeOptions,m_htiReaskReserveSourcesDelayDefault,GetResString(IDS_X_REASK_RESERVE_DELAY_DEFAULT),m_htiReaskReserveSourcesDelay,GetResString(IDS_X_REASK_RESERVE_DELAY_DEFAULT_INFO),TRUE,m_iUseReaskReserveSourcesDelay == 0);
							SetTreeRadio(m_ctrlTreeOptions,m_htiReaskReserveSourcesDelayEnable,GetResString(IDS_X_REASK_RESERVE_DELAY_ENABLE),m_htiReaskReserveSourcesDelay,GetResString(IDS_X_REASK_RESERVE_DELAY_ENABLE_INFO),TRUE,m_iUseReaskReserveSourcesDelay == 1);
							SetTreeRadio(m_ctrlTreeOptions,m_htiReaskReserveSourcesDelayDisable,GetResString(IDS_X_REASK_RESERVE_DELAY_DISABLE),m_htiReaskReserveSourcesDelay,GetResString(IDS_X_REASK_RESERVE_DELAY_DISABLE_INFO),TRUE,m_iUseReaskReserveSourcesDelay == 2);
					}else
						SetTreeCheckNumEdit(m_ctrlTreeOptions,m_htiReaskReserveSourcesDelay,GetResString(IDS_X_REASK_RESERVE_DELAY), m_htiReservePropability,GetResString(IDS_X_REASK_RESERVE_DELAY_INFO),FALSE,m_bUseReaskReserveSourcesDelay);
					SetTreeNumEdit(m_ctrlTreeOptions,m_htiReaskReserveSourcesLimit,GetResString(IDS_X_REASK_RESERVE_LIMIT), m_htiReservePropability,GetResString(IDS_X_REASK_RESERVE_LIMIT_INFO));
				if(ForFile()){
					SetTreeGroup(m_ctrlTreeOptions,m_htiTemporarySources,GetResString(IDS_X_TEMPORARY_SOURCES_REASK),iImgTemporaryReask, m_htiReaskManager, GetResString(IDS_X_TEMPORARY_SOURCES_REASK_INFO));
						SetTreeRadio(m_ctrlTreeOptions,m_htiTemporarySourcesDefault,GetResString(IDS_X_AUTO_TEMPORARY_REASK_DEFAULT),m_htiTemporarySources,GetResString(IDS_X_AUTO_TEMPORARY_REASK_DEFAULT_INFO),TRUE,m_iAutoTemporaryReask == 0);
						SetTreeRadio(m_ctrlTreeOptions,m_htiTemporarySourcesEnable,GetResString(IDS_X_AUTO_TEMPORARY_REASK_ENABLE),m_htiTemporarySources,GetResString(IDS_X_AUTO_TEMPORARY_REASK_ENABLE_INFO),TRUE,m_iAutoTemporaryReask == 1);
						SetTreeRadio(m_ctrlTreeOptions,m_htiTemporarySourcesDisable,GetResString(IDS_X_AUTO_TEMPORARY_REASK_DISABLE),m_htiTemporarySources,GetResString(IDS_X_AUTO_TEMPORARY_REASK_DISABLE_INFO),TRUE,m_iAutoTemporaryReask == 2);
				}else
					SetTreeCheck(m_ctrlTreeOptions,m_htiTemporarySources,GetResString(IDS_X_TEMPORARY_SOURCES_REASK),m_htiReaskManager,GetResString(IDS_X_TEMPORARY_SOURCES_REASK_INFO),FALSE,m_bAutoTemporaryReask);
					SetTreeNumEdit(m_ctrlTreeOptions,m_htiTemporaryReaskPropability,GetResString(IDS_X_TEMPORARY_REASK_PROPABILITY), m_htiTemporarySources,GetResString(IDS_X_TEMPORARY_REASK_PROPABILITY_INFO));
					if(ForFile()){
						SetTreeNumEdit(m_ctrlTreeOptions,m_htiReaskTemporarySourcesDelay,GetResString(IDS_X_REASK_TEMPORARY_DELAY), m_htiTemporarySources,GetResString(IDS_X_REASK_TEMPORARY_DELAY_INFO));
							SetTreeRadio(m_ctrlTreeOptions,m_htiReaskTemporarySourcesDelayDefault,GetResString(IDS_X_REASK_TEMPORARY_DELAY_DEFAULT),m_htiReaskTemporarySourcesDelay,GetResString(IDS_X_REASK_TEMPORARY_DELAY_DEFAULT_INFO),TRUE,m_iUseReaskTemporarySourcesDelay == 0);
							SetTreeRadio(m_ctrlTreeOptions,m_htiReaskTemporarySourcesDelayEnable,GetResString(IDS_X_REASK_TEMPORARY_DELAY_ENABLE),m_htiReaskTemporarySourcesDelay,GetResString(IDS_X_REASK_TEMPORARY_DELAY_ENABLE_INFO),TRUE,m_iUseReaskTemporarySourcesDelay == 1);
							SetTreeRadio(m_ctrlTreeOptions,m_htiReaskTemporarySourcesDelayDisable,GetResString(IDS_X_REASK_TEMPORARY_DELAY_DISABLE),m_htiReaskTemporarySourcesDelay,GetResString(IDS_X_REASK_TEMPORARY_DELAY_DISABLE_INFO),TRUE,m_iUseReaskTemporarySourcesDelay == 2);
					}else
						SetTreeCheckNumEdit(m_ctrlTreeOptions,m_htiReaskTemporarySourcesDelay,GetResString(IDS_X_REASK_TEMPORARY_DELAY), m_htiTemporarySources,GetResString(IDS_X_REASK_TEMPORARY_DELAY_INFO),FALSE,m_bUseReaskTemporarySourcesDelay);
					SetTreeNumEdit(m_ctrlTreeOptions,m_htiReaskTemporarySourcesLimit,GetResString(IDS_X_REASK_TEMPORARY_LIMIT), m_htiTemporarySources,GetResString(IDS_X_REASK_TEMPORARY_LIMIT_INFO));
				//SetTreeNumEdit(m_ctrlTreeOptions,m_htiMinAnalisisQuality,GetResString(IDS_X_MIN_ANALISIS_QUALITY),m_htiReaskManager,GetResString(IDS_X_MIN_ANALISIS_QUALITY_INFO));
					//if(ForFile()){
					//	SetTreeRadio(m_ctrlTreeOptions,m_htiAutoUnsureReaskDefault,GetResString(IDS_X_AUTO_UNSURE_REASK_DEFAULT),m_htiMinAnalisisQuality,GetResString(IDS_X_AUTO_UNSURE_REASK_DEFAULT_INFO),TRUE,m_iAutoUnsureReask == 0);
					//	SetTreeRadio(m_ctrlTreeOptions,m_htiAutoUnsureReaskEnable,GetResString(IDS_X_AUTO_UNSURE_REASK_ENABLE),m_htiMinAnalisisQuality,GetResString(IDS_X_AUTO_UNSURE_REASK_ENABLE_INFO),TRUE,m_iAutoUnsureReask == 1);
					//	SetTreeRadio(m_ctrlTreeOptions,m_htiAutoUnsureReaskDisable,GetResString(IDS_X_AUTO_UNSURE_REASK_DISABLE),m_htiMinAnalisisQuality,GetResString(IDS_X_AUTO_UNSURE_REASK_DISABLE_INFO),TRUE,m_iAutoUnsureReask == 2);
					//}else
					//	SetTreeCheck(m_ctrlTreeOptions,m_htiAutoUnsureReaskEnable,GetResString(IDS_X_AUTO_UNSURE_REASK_ENABLE),m_htiMinAnalisisQuality,GetResString(IDS_X_AUTO_UNSURE_REASK_ENABLE_INFO),FALSE,m_bAutoUnsureReask);
					//if(ForFile()){
					//	SetTreeNumEdit(m_ctrlTreeOptions,m_htiReaskUnsureSourcesDelay,GetResString(IDS_X_REASK_UNSURE_DELAY), m_htiMinAnalisisQuality,GetResString(IDS_X_REASK_UNSURE_DELAY_INFO));
					//		SetTreeRadio(m_ctrlTreeOptions,m_htiReaskUnsureSourcesDelayDefault,GetResString(IDS_X_REASK_UNSURE_DELAY_DEFAULT),m_htiReaskUnsureSourcesDelay,GetResString(IDS_X_REASK_UNSURE_DELAY_DEFAULT_INFO),TRUE,m_iUseReaskUnsureSourcesDelay == 0);
					//		SetTreeRadio(m_ctrlTreeOptions,m_htiReaskUnsureSourcesDelayEnable,GetResString(IDS_X_REASK_UNSURE_DELAY_ENABLE),m_htiReaskUnsureSourcesDelay,GetResString(IDS_X_REASK_UNSURE_DELAY_ENABLE_INFO),TRUE,m_iUseReaskUnsureSourcesDelay == 1);
					//		SetTreeRadio(m_ctrlTreeOptions,m_htiReaskUnsureSourcesDelayDisable,GetResString(IDS_X_REASK_UNSURE_DELAY_DISABLE),m_htiReaskUnsureSourcesDelay,GetResString(IDS_X_REASK_UNSURE_DELAY_DISABLE_INFO),TRUE,m_iUseReaskUnsureSourcesDelay == 2);
					//}else
					//	SetTreeCheckNumEdit(m_ctrlTreeOptions,m_htiReaskUnsureSourcesDelay,GetResString(IDS_X_REASK_UNSURE_DELAY), m_htiMinAnalisisQuality,GetResString(IDS_X_REASK_UNSURE_DELAY_INFO),FALSE,m_bUseReaskUnsureSourcesDelay);
					//SetTreeNumEdit(m_ctrlTreeOptions,m_htiReaskUnsureSourcesLimit,GetResString(IDS_X_REASK_UNSURE_LIMIT), m_htiMinAnalisisQuality,GetResString(IDS_X_REASK_UNSURE_LIMIT_INFO));
				if(ForFile()){
					SetTreeGroup(m_ctrlTreeOptions,m_htiUnpredictedPropability,GetResString(IDS_X_USE_UNPREDICTED_PROPABILITY),iImgUnpredicted, m_htiReaskManager, GetResString(IDS_X_USE_UNPREDICTED_PROPABILITY_INFO));
						SetTreeRadio(m_ctrlTreeOptions,m_htiUnpredictedPropabilityDefault,GetResString(IDS_X_USE_UNPREDICTED_PROPABILITY_DEFAULT),m_htiUnpredictedPropability,GetResString(IDS_X_USE_UNPREDICTED_PROPABILITY_DEFAULT_INFO),TRUE,m_iUseUnpredictedPropability == 0);
						SetTreeRadio(m_ctrlTreeOptions,m_htiUnpredictedPropabilityEnable,GetResString(IDS_X_USE_UNPREDICTED_PROPABILITY_ENABLE),m_htiUnpredictedPropability,GetResString(IDS_X_USE_UNPREDICTED_PROPABILITY_ENABLE_INFO),TRUE,m_iUseUnpredictedPropability == 1);
						SetTreeRadio(m_ctrlTreeOptions,m_htiUnpredictedPropabilityDisable,GetResString(IDS_X_USE_UNPREDICTED_PROPABILITY_DISABLE),m_htiUnpredictedPropability,GetResString(IDS_X_USE_UNPREDICTED_PROPABILITY_DISABLE_INFO),TRUE,m_iUseUnpredictedPropability == 2);
						SetTreeNumEdit(m_ctrlTreeOptions,m_htiUnpredictedPropabilityValue,GetResString(IDS_X_USE_UNPREDICTED_PROPABILITY_VALUE), m_htiUnpredictedPropability,GetResString(IDS_X_USE_UNPREDICTED_PROPABILITY_VALUE_INFO));
				}else
					SetTreeCheckNumEdit(m_ctrlTreeOptions,m_htiUnpredictedPropability,GetResString(IDS_X_USE_UNPREDICTED_PROPABILITY), m_htiReaskManager,GetResString(IDS_X_USE_UNPREDICTED_PROPABILITY_INFO),FALSE,m_bUseUnpredictedPropability);
					if(ForFile()){
						SetTreeNumEdit(m_ctrlTreeOptions,m_htiReaskUnpredictedSourcesDelay,GetResString(IDS_X_REASK_UNPREDICTED_DELAY), m_htiUnpredictedPropability,GetResString(IDS_X_REASK_UNPREDICTED_DELAY_INFO));
							SetTreeRadio(m_ctrlTreeOptions,m_htiReaskUnpredictedSourcesDelayDefault,GetResString(IDS_X_REASK_UNPREDICTED_DELAY_DEFAULT),m_htiReaskUnpredictedSourcesDelay,GetResString(IDS_X_REASK_UNPREDICTED_DELAY_DEFAULT_INFO),TRUE,m_iUseReaskUnpredictedSourcesDelay == 0);
							SetTreeRadio(m_ctrlTreeOptions,m_htiReaskUnpredictedSourcesDelayEnable,GetResString(IDS_X_REASK_UNPREDICTED_DELAY_ENABLE),m_htiReaskUnpredictedSourcesDelay,GetResString(IDS_X_REASK_UNPREDICTED_DELAY_ENABLE_INFO),TRUE,m_iUseReaskUnpredictedSourcesDelay == 1);
							SetTreeRadio(m_ctrlTreeOptions,m_htiReaskUnpredictedSourcesDelayDisable,GetResString(IDS_X_REASK_UNPREDICTED_DELAY_DISABLE),m_htiReaskUnpredictedSourcesDelay,GetResString(IDS_X_REASK_UNPREDICTED_DELAY_DISABLE_INFO),TRUE,m_iUseReaskUnpredictedSourcesDelay == 2);
					}else
						SetTreeCheckNumEdit(m_ctrlTreeOptions,m_htiReaskUnpredictedSourcesDelay,GetResString(IDS_X_REASK_UNPREDICTED_DELAY), m_htiUnpredictedPropability,GetResString(IDS_X_REASK_UNPREDICTED_DELAY_INFO),FALSE,m_bUseReaskUnpredictedSourcesDelay);
					SetTreeNumEdit(m_ctrlTreeOptions,m_htiReaskUnpredictedSourcesLimit,GetResString(IDS_X_REASK_UNPREDICTED_LIMIT), m_htiUnpredictedPropability,GetResString(IDS_X_REASK_UNPREDICTED_LIMIT_INFO));
				if(ForFile()){
					SetTreeGroup(m_ctrlTreeOptions,m_htiFailTolerance,GetResString(IDS_X_FAIL_TOLERANCE),iImgFailTolerance, m_htiReaskManager, GetResString(IDS_X_FAIL_TOLERANCE_INFO));
						SetTreeRadio(m_ctrlTreeOptions,m_htiFailToleranceDefault,GetResString(IDS_X_FAIL_TOLERANCE_DEFAULT),m_htiFailTolerance,GetResString(IDS_X_FAIL_TOLERANCE_DEFAULT_INFO),TRUE,m_iFailTolerance == 0);
						SetTreeRadio(m_ctrlTreeOptions,m_htiFailToleranceEnable,GetResString(IDS_X_FAIL_TOLERANCE_ENABLE),m_htiFailTolerance,GetResString(IDS_X_FAIL_TOLERANCE_ENABLE_INFO),TRUE,m_iFailTolerance == 1);
						SetTreeRadio(m_ctrlTreeOptions,m_htiFailToleranceEnable,GetResString(IDS_X_FAIL_TOLERANCE_ENABLE2),m_htiFailTolerance,GetResString(IDS_X_FAIL_TOLERANCE_ENABLE2_INFO),TRUE,m_iFailTolerance == 2);
						SetTreeRadio(m_ctrlTreeOptions,m_htiFailToleranceDisable,GetResString(IDS_X_FAIL_TOLERANCE_DISABLE),m_htiFailTolerance,GetResString(IDS_X_FAIL_TOLERANCE_DISABLE_INFO),TRUE,m_iFailTolerance == 3);
						SetTreeNumEdit(m_ctrlTreeOptions,m_htiFailToleranceValue,GetResString(IDS_X_FAIL_TOLERANCE_VALUE), m_htiFailTolerance,GetResString(IDS_X_FAIL_TOLERANCE_VALUE_INFO));
				}else
					SetTreeCheckNumEdit(m_ctrlTreeOptions,m_htiFailTolerance,GetResString(IDS_X_FAIL_TOLERANCE),m_htiReaskManager,GetResString(IDS_X_FAIL_TOLERANCE_INFO),TRUE,m_uFailTolerance);
					if(ForFile()){
						SetTreeGroup(m_ctrlTreeOptions,m_htiRetryUnreachable,GetResString(IDS_X_RETRY_UNREAHABLE),iImgIgnoreUnreahable, m_htiFailTolerance, GetResString(IDS_X_RETRY_UNREAHABLE_INFO));
							SetTreeRadio(m_ctrlTreeOptions,m_htiRetryUnreachableDefault,GetResString(IDS_X_RETRY_UNREAHABLE_DEFAULT),m_htiRetryUnreachable,GetResString(IDS_X_RETRY_UNREAHABLE_DEFAULT_INFO),TRUE,m_iRetryUnreachable == 0);
							SetTreeRadio(m_ctrlTreeOptions,m_htiRetryUnreachableEnable,GetResString(IDS_X_RETRY_UNREAHABLE_ENABLE),m_htiRetryUnreachable,GetResString(IDS_X_RETRY_UNREAHABLE_ENABLE_INFO),TRUE,m_iRetryUnreachable == 1);
							SetTreeRadio(m_ctrlTreeOptions,m_htiRetryUnreachableEnable,GetResString(IDS_X_RETRY_UNREAHABLE_ENABLE2),m_htiRetryUnreachable,GetResString(IDS_X_RETRY_UNREAHABLE_ENABLE2_INFO),TRUE,m_iRetryUnreachable == 2);
							SetTreeRadio(m_ctrlTreeOptions,m_htiRetryUnreachableDisable,GetResString(IDS_X_RETRY_UNREAHABLE_DISABLE),m_htiRetryUnreachable,GetResString(IDS_X_RETRY_UNREAHABLE_DISABLE_INFO),TRUE,m_iRetryUnreachable == 3);
							SetTreeNumEdit(m_ctrlTreeOptions,m_htiRetryUnreachableIntervals,GetResString(IDS_X_UNREAHABLE_RETRY_INTERVALS), m_htiRetryUnreachable,GetResString(IDS_X_UNREAHABLE_RETRY_INTERVALS_INFO));
					}else
						SetTreeCheckNumEdit(m_ctrlTreeOptions,m_htiRetryUnreachable,GetResString(IDS_X_RETRY_UNREAHABLE),m_htiFailTolerance,GetResString(IDS_X_RETRY_UNREAHABLE_INFO),TRUE,m_uRetryUnreachable);
					SetTreeNumEdit(m_ctrlTreeOptions,m_htiUnreachableReaskPropability,GetResString(IDS_X_UNREACHABLE_REASK_PROPABILITY),m_htiFailTolerance,GetResString(IDS_X_UNREACHABLE_REASK_PROPABILITY_INFO));
					SetTreeNumEdit(m_ctrlTreeOptions,m_htiReaskUnreachableSourcesLimit,GetResString(IDS_X_REASK_UNREACHABLE_LIMIT),m_htiFailTolerance,GetResString(IDS_X_REASK_UNREACHABLE_LIMIT_INFO));

			if(!ForFile()){
				SetTreeGroup(m_ctrlTreeOptions,m_htiAdvancedAnalyser,GetResString(IDS_X_ADVANCED_ANALYSIS),iImgAdvanced, m_htiSourceAnaliser, GetResString(IDS_X_ADVANCED_ANALYSIS_INFO));
					SetTreeGroup(m_ctrlTreeOptions,m_htiDisturbanceHandling,GetResString(IDS_X_DISTURBANCE_HANDLING),iGapHandling, m_htiAdvancedAnalyser, GetResString(IDS_X_DISTURBANCE_HANDLING_INFO));
						SetTreeCheck(m_ctrlTreeOptions,m_htiHandleTableGaps,GetResString(IDS_X_GAP_HANDLING),m_htiDisturbanceHandling,GetResString(IDS_X_GAP_HANDLING_INFO),FALSE,m_bHandleTableGaps);
							SetTreeNumEdit(m_ctrlTreeOptions,m_htiPriorityGapRatio,GetResString(IDS_X_PRIO_GAP_RATIO), m_htiHandleTableGaps,GetResString(IDS_X_PRIO_GAP_RATIO_INFO));
							SetTreeNumEdit(m_ctrlTreeOptions,m_htiMaxGapSize,GetResString(IDS_X_MAX_GAP_SIZE), m_htiHandleTableGaps,GetResString(IDS_X_MAX_GAP_SIZE_INFO));
							SetTreeNumEdit(m_ctrlTreeOptions,m_htiMaxGapTime,GetResString(IDS_X_MAX_GAP_TIME), m_htiHandleTableGaps,GetResString(IDS_X_MAX_GAP_TIME_INFO));
					SetTreeCheckNumEdit(m_ctrlTreeOptions,m_htiCheckPriorityIP,GetResString(IDS_X_PRIO_IP_RATIO),m_htiDisturbanceHandling,GetResString(IDS_X_PRIO_IP_RATIO_INFO),FALSE,m_bCheckPriorityIP);
					SetTreeCheckNumEdit(m_ctrlTreeOptions,m_htiCheckPortIntegrity,GetResString(IDS_X_CHECK_PORT_RATIO),m_htiDisturbanceHandling,GetResString(IDS_X_CHECK_PORT_RATIO_INFO),FALSE,m_bCheckPortIntegrity);
					SetTreeNumEdit(m_ctrlTreeOptions,m_htiMaxMidleDiscrepanceHigh,GetResString(IDS_X_MAX_DISCREPANCE_HIGH), m_htiAdvancedAnalyser,GetResString(IDS_X_MAX_DISCREPANCE_HIGH_INFO));
					SetTreeNumEdit(m_ctrlTreeOptions,m_htiMaxMidleDiscrepanceLow,GetResString(IDS_X_MAX_DISCREPANCE_LOW), m_htiAdvancedAnalyser,GetResString(IDS_X_MAX_DISCREPANCE_LOW_INFO));
					SetTreeNumEdit(m_ctrlTreeOptions,m_htiLastSeenDurationThreshold,GetResString(IDS_X_LAST_SEEN_DURATION_THRESHOLD), m_htiAdvancedAnalyser,GetResString(IDS_X_LAST_SEEN_DURATION_THRESHOLD_INFO));
					SetTreeCheckNumEdit(m_ctrlTreeOptions,m_htiLinkTimeThreshold,GetResString(IDS_X_LINK_TIME_THRESHOLD), m_htiAdvancedAnalyser,GetResString(IDS_X_LINK_TIME_THRESHOLD_INFO),TRUE,m_uLinkTimePropability);
					SetTreeCheckNumEdit(m_ctrlTreeOptions,m_htiDualLinkedTableGravity,GetResString(IDS_X_DUAL_LINKED_TABLE_GRAVITY), m_htiAdvancedAnalyser,GetResString(IDS_X_DUAL_LINKED_TABLE_GRAVITY_INFO),FALSE,m_uLinkTimePropability);
					SetTreeCheckNumEdit(m_ctrlTreeOptions,m_htiMaxReliableTime,GetResString(IDS_X_RELIABLE_TIME_MAGNIFICATION), m_htiAdvancedAnalyser,GetResString(IDS_X_RELIABLE_TIME_MAGNIFICATION_INFO),FALSE,m_bReliableTimeMagnification);
					SetTreeNumEdit(m_ctrlTreeOptions,m_htiTempralIPBorderLine,GetResString(IDS_X_TEMPRAL_IP_BORDERLINE), m_htiAdvancedAnalyser,GetResString(IDS_X_TEMPRAL_IP_BORDERLINE_INFO));
			}
#endif // NEO_SA // NEO: NSA END

		// NEO: NSD - [NeoSourceDrop]
		SetTreeGroup(m_ctrlTreeOptions,m_htiDropCleanUp,GetResString(IDS_X_DROPSRC_CLEANUP),iImgDrop, TVI_ROOT,GetResString(IDS_X_DROPSRC_CLEANUP_INFO));
#ifdef NEO_SK // NEO: NSK - [NeoSourceKeeper]
			SetTreeGroup(m_ctrlTreeOptions,m_htiDropUnreachable,GetResString(IDS_X_DROPSRCUNREACHABLE),iImgDropUnreachable, m_htiDropCleanUp,GetResString(IDS_X_DROPSRCUNREACHABLE_INFO));
				if(ForFile()){
					SetTreeRadio(m_ctrlTreeOptions,m_htiDropUnreachableDefault,GetResString(IDS_X_DROPSRCUNREACHABLE_DEFAULT),m_htiDropUnreachable,GetResString(IDS_X_DROPSRCUNREACHABLE_DEFAULT_INFO),TRUE,m_iDropUnreachable == 0);
					SetTreeRadio(m_ctrlTreeOptions,m_htiDropUnreachableEnable,GetResString(IDS_X_DROPSRCUNREACHABLE_ENABLE),m_htiDropUnreachable,GetResString(IDS_X_DROPSRCUNREACHABLE_ENABLE_INFO),TRUE,m_iDropUnreachable == 1);
					SetTreeRadio(m_ctrlTreeOptions,m_htiDropUnreachableDisable,GetResString(IDS_X_DROPSRCUNREACHABLE_DISABLE),m_htiDropUnreachable,GetResString(IDS_X_DROPSRCUNREACHABLE_DISABLE_INFO),TRUE,m_iDropUnreachable == 2);
				}else
					SetTreeCheck(m_ctrlTreeOptions,m_htiDropUnreachableEnable,GetResString(IDS_X_DROPSRCUNREACHABLE_ENABLE),m_htiDropUnreachable,GetResString(IDS_X_DROPSRCUNREACHABLE_ENABLE_INFO),FALSE,m_bDropUnreachable);
				SetTreeNumEdit(m_ctrlTreeOptions,m_htiDropUnreachableLimit,GetResString(IDS_X_DROPSRCUNREACHABLE_LIMIT), m_htiDropUnreachable,GetResString(IDS_X_DROPSRCUNREACHABLE_LIMIT_INFO));
					if(ForFile())
						SetTreeRadio(m_ctrlTreeOptions,m_htiDropUnreachableLimitDefault,GetResString(IDS_X_DROPSRCUNREACHABLE_LIMIT_MODE_DEFAULT),m_htiDropUnreachableLimit,GetResString(IDS_X_DROPSRCUNREACHABLE_LIMIT_MODE_DEFAULT_INFO),TRUE,m_iDropUnreachableLimitMode == 0);
					else
						SetTreeRadio(m_ctrlTreeOptions,m_htiDropUnreachableLimitDisable,GetResString(IDS_X_DROPSRCUNREACHABLE_LIMIT_MODE_DISABLE),m_htiDropUnreachableLimit,GetResString(IDS_X_DROPSRCUNREACHABLE_LIMIT_MODE_DISABLE_INFO),FALSE,m_iDropUnreachableLimitMode == 0);
					SetTreeRadio(m_ctrlTreeOptions,m_htiDropUnreachableLimitTotal,GetResString(IDS_X_DROPSRCUNREACHABLE_LIMIT_MODE_TOTAL),m_htiDropUnreachableLimit,GetResString(IDS_X_DROPSRCUNREACHABLE_LIMIT_MODE_TOTAL_INFO),ForFile(),m_iDropUnreachableLimitMode == 1);
					SetTreeRadio(m_ctrlTreeOptions,m_htiDropUnreachableLimitRelativ,GetResString(IDS_X_DROPSRCUNREACHABLE_LIMIT_MODE_RELATIVE),m_htiDropUnreachableLimit,GetResString(IDS_X_DROPSRCUNREACHABLE_LIMIT_MODE_RELATIVE_INFO),ForFile(),m_iDropUnreachableLimitMode == 2);
					SetTreeRadio(m_ctrlTreeOptions,m_htiDropUnreachableLimitSpecyfic,GetResString(IDS_X_DROPSRCUNREACHABLE_LIMIT_MODE_SPECYFIC),m_htiDropUnreachableLimit,GetResString(IDS_X_DROPSRCUNREACHABLE_LIMIT_MODE_SPECYFIC_INFO),ForFile(),m_iDropUnreachableLimitMode == 3);
					if(ForFile())
						SetTreeRadio(m_ctrlTreeOptions,m_htiDropUnreachableLimitDisable,GetResString(IDS_X_DROPSRCUNREACHABLE_LIMIT_MODE_DISABLE),m_htiDropUnreachableLimit,GetResString(IDS_X_DROPSRCUNREACHABLE_LIMIT_MODE_DISABLE_INFO),TRUE,m_iDropUnreachableLimitMode == 4);
				SetTreeNumEdit(m_ctrlTreeOptions,m_htiDropUnreachableTimer,GetResString(IDS_X_DROPSRCUNREACHABLE_TIMER), m_htiDropUnreachable,GetResString(IDS_X_DROPSRCUNREACHABLE_TIMER_INFO));
#endif // NEO_SK // NEO: NSK END
#ifdef NEO_SS // NEO: NSS - [NeoSourceStorage]
			SetTreeGroup(m_ctrlTreeOptions,m_htiDropOutOfDate,GetResString(IDS_X_DROPSRCOUTOFDATE),iImgDropOutOfDate, m_htiDropCleanUp,GetResString(IDS_X_DROPSRCOUTOFDATE_INFO));
				if(ForFile()){
					SetTreeRadio(m_ctrlTreeOptions,m_htiDropOutOfDateDefault,GetResString(IDS_X_DROPSRCOUTOFDATE_DEFAULT),m_htiDropOutOfDate,GetResString(IDS_X_DROPSRCOUTOFDATE_DEFAULT_INFO),TRUE,m_iDropOutOfDate == 0);
					SetTreeRadio(m_ctrlTreeOptions,m_htiDropOutOfDateEnable,GetResString(IDS_X_DROPSRCOUTOFDATE_ENABLE),m_htiDropOutOfDate,GetResString(IDS_X_DROPSRCOUTOFDATE_ENABLE_INFO),TRUE,m_iDropOutOfDate == 1);
					SetTreeRadio(m_ctrlTreeOptions,m_htiDropOutOfDateDisable,GetResString(IDS_X_DROPSRCOUTOFDATE_DISABLE),m_htiDropOutOfDate,GetResString(IDS_X_DROPSRCOUTOFDATE_DISABLE_INFO),TRUE,m_iDropOutOfDate == 2);
				}else
					SetTreeCheck(m_ctrlTreeOptions,m_htiDropOutOfDateEnable,GetResString(IDS_X_DROPSRCOUTOFDATE_ENABLE),m_htiDropOutOfDate,GetResString(IDS_X_DROPSRCOUTOFDATE_ENABLE_INFO),FALSE,m_bDropOutOfDate);
				SetTreeNumEdit(m_ctrlTreeOptions,m_htiDropOutOfDateLimit,GetResString(IDS_X_DROPSRCOUTOFDATE_LIMIT), m_htiDropOutOfDate,GetResString(IDS_X_DROPSRCOUTOFDATE_LIMIT_INFO));
					if(ForFile())
						SetTreeRadio(m_ctrlTreeOptions,m_htiDropOutOfDateLimitDefault,GetResString(IDS_X_DROPSRCOUTOFDATE_LIMIT_MODE_DEFAULT),m_htiDropOutOfDateLimit,GetResString(IDS_X_DROPSRCOUTOFDATE_LIMIT_MODE_DEFAULT_INFO),TRUE,m_iDropOutOfDateLimitMode == 0);
					else
						SetTreeRadio(m_ctrlTreeOptions,m_htiDropOutOfDateLimitDisable,GetResString(IDS_X_DROPSRCOUTOFDATE_LIMIT_MODE_DISABLE),m_htiDropOutOfDateLimit,GetResString(IDS_X_DROPSRCOUTOFDATE_LIMIT_MODE_DISABLE_INFO),FALSE,m_iDropOutOfDateLimitMode == 0);
					SetTreeRadio(m_ctrlTreeOptions,m_htiDropOutOfDateLimitTotal,GetResString(IDS_X_DROPSRCOUTOFDATE_LIMIT_MODE_TOTAL),m_htiDropOutOfDateLimit,GetResString(IDS_X_DROPSRCOUTOFDATE_LIMIT_MODE_TOTAL_INFO),ForFile(),m_iDropOutOfDateLimitMode == 1);
					SetTreeRadio(m_ctrlTreeOptions,m_htiDropOutOfDateLimitRelativ,GetResString(IDS_X_DROPSRCOUTOFDATE_LIMIT_MODE_RELATIVE),m_htiDropOutOfDateLimit,GetResString(IDS_X_DROPSRCOUTOFDATE_LIMIT_MODE_RELATIVE_INFO),ForFile(),m_iDropOutOfDateLimitMode == 2);
					SetTreeRadio(m_ctrlTreeOptions,m_htiDropOutOfDateLimitSpecyfic,GetResString(IDS_X_DROPSRCOUTOFDATE_LIMIT_MODE_SPECYFIC),m_htiDropOutOfDateLimit,GetResString(IDS_X_DROPSRCOUTOFDATE_LIMIT_MODE_SPECYFIC_INFO),ForFile(),m_iDropOutOfDateLimitMode == 3);
					if(ForFile())
						SetTreeRadio(m_ctrlTreeOptions,m_htiDropOutOfDateLimitDisable,GetResString(IDS_X_DROPSRCOUTOFDATE_LIMIT_MODE_DISABLE),m_htiDropOutOfDateLimit,GetResString(IDS_X_DROPSRCOUTOFDATE_LIMIT_MODE_DISABLE_INFO),TRUE,m_iDropOutOfDateLimitMode == 4);
				SetTreeNumEdit(m_ctrlTreeOptions,m_htiDropOutOfDateTimer,GetResString(IDS_X_DROPSRCOUTOFDATE_TIMER), m_htiDropOutOfDate,GetResString(IDS_X_DROPSRCOUTOFDATE_TIMER_INFO));

				SetTreeGroup(m_ctrlTreeOptions,m_htiDropOutOfDatePrefs,GetResString(IDS_X_SOURCE_OUT_OF_DATE),iImgOutOfDate, m_htiDropOutOfDate, GetResString(IDS_X_SOURCE_OUT_OF_DATE_INFO));
					if(ForFile()){
						SetTreeGroup(m_ctrlTreeOptions,m_htiDropOutOfDateSmooth,GetResString(IDS_X_SOURCE_SMOOTH_OUT_OF_DATE),iImgOutOfDate, m_htiDropOutOfDatePrefs, GetResString(IDS_X_SOURCE_SMOOTH_OUT_OF_DATE_INFO));
							SetTreeRadio(m_ctrlTreeOptions,m_htiDropOutOfDateSmoothDefault,GetResString(IDS_X_SOURCE_SMOOTH_OUT_OF_DATE_DEFAULT),m_htiDropOutOfDateSmooth,GetResString(IDS_X_SOURCE_SMOOTH_OUT_OF_DATE_DEFAULT_INFO),TRUE,m_iUseSmoothOutOfDate == 0);
							SetTreeRadio(m_ctrlTreeOptions,m_htiDropOutOfDateSmoothEnable,GetResString(IDS_X_SOURCE_SMOOTH_OUT_OF_DATE_ENABLE),m_htiDropOutOfDateSmooth,GetResString(IDS_X_SOURCE_SMOOTH_OUT_OF_DATE_ENABLE_INFO),TRUE,m_iUseSmoothOutOfDate == 1);
							SetTreeRadio(m_ctrlTreeOptions,m_htiDropOutOfDateSmoothDisable,GetResString(IDS_X_SOURCE_SMOOTH_OUT_OF_DATE_DISABLE),m_htiDropOutOfDateSmooth,GetResString(IDS_X_SOURCE_SMOOTH_OUT_OF_DATE_DISABLE_INFO),TRUE,m_iUseSmoothOutOfDate == 2);
					}else
						SetTreeCheck(m_ctrlTreeOptions,m_htiDropOutOfDateSmooth,GetResString(IDS_X_SOURCE_SMOOTH_OUT_OF_DATE),m_htiDropOutOfDatePrefs,GetResString(IDS_X_SOURCE_SMOOTH_OUT_OF_DATE_INFO),FALSE,m_bUseSmoothOutOfDate);
					SetTreeNumEdit(m_ctrlTreeOptions,m_htiDropOutOfDateFails,GetResString(IDS_X_SOURCE_OUT_OF_DATE_FAILS), m_htiDropOutOfDatePrefs,GetResString(IDS_X_SOURCE_OUT_OF_DATE_FAILS_INFO));
					SetTreeNumEdit(m_ctrlTreeOptions,m_htiDropOutOfDateTime,GetResString(IDS_X_SOURCE_OUT_OF_DATE_TIME), m_htiDropOutOfDatePrefs,GetResString(IDS_X_SOURCE_OUT_OF_DATE_TIME_INFO));

#endif // NEO_SS // NEO: NSS END
#ifdef NEO_SA // NEO: NSA - [NeoSourceAnaliser]
			SetTreeGroup(m_ctrlTreeOptions,m_htiDropRetired,GetResString(IDS_X_DROPSRCRETIRED),iImgDropRetired, m_htiDropCleanUp,GetResString(IDS_X_DROPSRCRETIRED_INFO));
				if(ForFile()){
					SetTreeRadio(m_ctrlTreeOptions,m_htiDropRetiredDefault,GetResString(IDS_X_DROPSRCRETIRED_DEFAULT),m_htiDropRetired,GetResString(IDS_X_DROPSRCRETIRED_DEFAULT_INFO),TRUE,m_iDropRetired == 0);
					SetTreeRadio(m_ctrlTreeOptions,m_htiDropRetiredEnable,GetResString(IDS_X_DROPSRCRETIRED_ENABLE),m_htiDropRetired,GetResString(IDS_X_DROPSRCRETIRED_ENABLE_INFO),TRUE,m_iDropRetired == 1);
					SetTreeRadio(m_ctrlTreeOptions,m_htiDropRetiredDisable,GetResString(IDS_X_DROPSRCRETIRED_DISABLE),m_htiDropRetired,GetResString(IDS_X_DROPSRCRETIRED_DISABLE_INFO),TRUE,m_iDropRetired == 2);
				}else
					SetTreeCheck(m_ctrlTreeOptions,m_htiDropRetiredEnable,GetResString(IDS_X_DROPSRCRETIRED_ENABLE),m_htiDropRetired,GetResString(IDS_X_DROPSRCRETIRED_ENABLE_INFO),FALSE,m_bDropRetired);
				SetTreeNumEdit(m_ctrlTreeOptions,m_htiDropRetiredLimit,GetResString(IDS_X_DROPSRCRETIRED_LIMIT), m_htiDropRetired,GetResString(IDS_X_DROPSRCRETIRED_LIMIT_INFO));
					if(ForFile())
						SetTreeRadio(m_ctrlTreeOptions,m_htiDropRetiredLimitDefault,GetResString(IDS_X_DROPSRCRETIRED_LIMIT_MODE_DEFAULT),m_htiDropRetiredLimit,GetResString(IDS_X_DROPSRCRETIRED_LIMIT_MODE_DEFAULT_INFO),TRUE,m_iDropRetiredLimitMode == 0);
					else
						SetTreeRadio(m_ctrlTreeOptions,m_htiDropRetiredLimitDisable,GetResString(IDS_X_DROPSRCRETIRED_LIMIT_MODE_DISABLE),m_htiDropRetiredLimit,GetResString(IDS_X_DROPSRCRETIRED_LIMIT_MODE_DISABLE_INFO),FALSE,m_iDropRetiredLimitMode == 0);
					SetTreeRadio(m_ctrlTreeOptions,m_htiDropRetiredLimitTotal,GetResString(IDS_X_DROPSRCRETIRED_LIMIT_MODE_TOTAL),m_htiDropRetiredLimit,GetResString(IDS_X_DROPSRCRETIRED_LIMIT_MODE_TOTAL_INFO),ForFile(),m_iDropRetiredLimitMode == 1);
					SetTreeRadio(m_ctrlTreeOptions,m_htiDropRetiredLimitRelativ,GetResString(IDS_X_DROPSRCRETIRED_LIMIT_MODE_RELATIVE),m_htiDropRetiredLimit,GetResString(IDS_X_DROPSRCRETIRED_LIMIT_MODE_RELATIVE_INFO),ForFile(),m_iDropRetiredLimitMode == 2);
					SetTreeRadio(m_ctrlTreeOptions,m_htiDropRetiredLimitSpecyfic,GetResString(IDS_X_DROPSRCRETIRED_LIMIT_MODE_SPECYFIC),m_htiDropRetiredLimit,GetResString(IDS_X_DROPSRCRETIRED_LIMIT_MODE_SPECYFIC_INFO),ForFile(),m_iDropRetiredLimitMode == 3);
					if(ForFile())
						SetTreeRadio(m_ctrlTreeOptions,m_htiDropRetiredLimitDisable,GetResString(IDS_X_DROPSRCRETIRED_LIMIT_MODE_DISABLE),m_htiDropRetiredLimit,GetResString(IDS_X_DROPSRCRETIRED_LIMIT_MODE_DISABLE_INFO),TRUE,m_iDropRetiredLimitMode == 4);
				SetTreeNumEdit(m_ctrlTreeOptions,m_htiDropRetiredTimer,GetResString(IDS_X_DROPSRCRETIRED_TIMER), m_htiDropRetired,GetResString(IDS_X_DROPSRCRETIRED_TIMER_INFO));

			SetTreeGroup(m_ctrlTreeOptions,m_htiDropLoaded,GetResString(IDS_X_DROPSRCLOADED),iImgDropLoaded, m_htiDropCleanUp,GetResString(IDS_X_DROPSRCLOADED_INFO));
				if(ForFile()){
					SetTreeRadio(m_ctrlTreeOptions,m_htiDropLoadedDefault,GetResString(IDS_X_DROPSRCLOADED_DEFAULT),m_htiDropLoaded,GetResString(IDS_X_DROPSRCLOADED_DEFAULT_INFO),TRUE,m_iDropLoaded == 0);
					SetTreeRadio(m_ctrlTreeOptions,m_htiDropLoadedEnable,GetResString(IDS_X_DROPSRCLOADED_ENABLE),m_htiDropLoaded,GetResString(IDS_X_DROPSRCLOADED_ENABLE_INFO),TRUE,m_iDropLoaded == 1);
					SetTreeRadio(m_ctrlTreeOptions,m_htiDropLoadedDisable,GetResString(IDS_X_DROPSRCLOADED_DISABLE),m_htiDropLoaded,GetResString(IDS_X_DROPSRCLOADED_DISABLE_INFO),TRUE,m_iDropLoaded == 2);
				}else
					SetTreeCheck(m_ctrlTreeOptions,m_htiDropLoadedEnable,GetResString(IDS_X_DROPSRCLOADED_ENABLE),m_htiDropLoaded,GetResString(IDS_X_DROPSRCLOADED_ENABLE_INFO),FALSE,m_bDropLoaded);
				SetTreeNumEdit(m_ctrlTreeOptions,m_htiDropLoadedLimit,GetResString(IDS_X_DROPSRCLOADED_LIMIT), m_htiDropLoaded,GetResString(IDS_X_DROPSRCLOADED_LIMIT_INFO));
					if(ForFile())
						SetTreeRadio(m_ctrlTreeOptions,m_htiDropLoadedLimitDefault,GetResString(IDS_X_DROPSRCLOADED_LIMIT_MODE_DEFAULT),m_htiDropLoadedLimit,GetResString(IDS_X_DROPSRCLOADED_LIMIT_MODE_DEFAULT_INFO),TRUE,m_iDropLoadedLimitMode == 0);
					else
						SetTreeRadio(m_ctrlTreeOptions,m_htiDropLoadedLimitDisable,GetResString(IDS_X_DROPSRCLOADED_LIMIT_MODE_DISABLE),m_htiDropLoadedLimit,GetResString(IDS_X_DROPSRCLOADED_LIMIT_MODE_DISABLE_INFO),FALSE,m_iDropLoadedLimitMode == 0);
					SetTreeRadio(m_ctrlTreeOptions,m_htiDropLoadedLimitTotal,GetResString(IDS_X_DROPSRCLOADED_LIMIT_MODE_TOTAL),m_htiDropLoadedLimit,GetResString(IDS_X_DROPSRCLOADED_LIMIT_MODE_TOTAL_INFO),ForFile(),m_iDropLoadedLimitMode == 1);
					SetTreeRadio(m_ctrlTreeOptions,m_htiDropLoadedLimitRelativ,GetResString(IDS_X_DROPSRCLOADED_LIMIT_MODE_RELATIVE),m_htiDropLoadedLimit,GetResString(IDS_X_DROPSRCLOADED_LIMIT_MODE_RELATIVE_INFO),ForFile(),m_iDropLoadedLimitMode == 2);
					SetTreeRadio(m_ctrlTreeOptions,m_htiDropLoadedLimitSpecyfic,GetResString(IDS_X_DROPSRCLOADED_LIMIT_MODE_SPECYFIC),m_htiDropLoadedLimit,GetResString(IDS_X_DROPSRCLOADED_LIMIT_MODE_SPECYFIC_INFO),ForFile(),m_iDropLoadedLimitMode == 3);
					if(ForFile())
						SetTreeRadio(m_ctrlTreeOptions,m_htiDropLoadedLimitDisable,GetResString(IDS_X_DROPSRCLOADED_LIMIT_MODE_DISABLE),m_htiDropLoadedLimit,GetResString(IDS_X_DROPSRCLOADED_LIMIT_MODE_DISABLE_INFO),TRUE,m_iDropLoadedLimitMode == 4);
				SetTreeNumEdit(m_ctrlTreeOptions,m_htiDropLoadedTimer,GetResString(IDS_X_DROPSRCLOADED_TIMER), m_htiDropLoaded,GetResString(IDS_X_DROPSRCLOADED_TIMER_INFO));
#endif // NEO_SA // NEO: NSA END
		// NEO: NSD END

		m_ctrlTreeOptions.Expand(m_htiNeoSourceStorage, TVE_EXPAND);
#ifdef NEO_SS // NEO: NSS - [NeoSourceStorage]
		m_ctrlTreeOptions.Expand(m_htiSourceStorage, TVE_EXPAND);
#endif // NEO_SS // NEO: NSS END
		if(!ForFile()){
			UINT bCheck;
#ifdef NEO_CD // NEO: NCD - [NeoClientDatabase]
			bCheck = CheckNCDBEnable();
#ifdef NEO_SA // NEO: NSA - [NeoSourceAnaliser]
			m_ctrlTreeOptions.SetGroupEnable(m_htiSourceAnaliser,bCheck);
#endif // NEO_SA // NEO: NSA END
#endif // NEO_CD // NEO: NCD END
#ifdef NEO_SA // NEO: NSA - [NeoSourceAnaliser]
			m_ctrlTreeOptions.GetCheckBox(m_htiHandleTableGaps, bCheck);
			m_ctrlTreeOptions.SetGroupEnable(m_htiHandleTableGaps, bCheck);
		
			m_ctrlTreeOptions.GetCheckBox(m_htiCheckPriorityIP, bCheck);
			m_ctrlTreeOptions.SetItemEnable(m_htiCheckPriorityIP, bCheck,TRUE,TRUE);
		
			m_ctrlTreeOptions.GetCheckBox(m_htiCheckPortIntegrity, bCheck);
			m_ctrlTreeOptions.SetItemEnable(m_htiCheckPortIntegrity, bCheck,TRUE,TRUE);
#endif // NEO_SA // NEO: NSA END
		}
		m_ctrlTreeOptions.Expand(m_htiDropCleanUp, TVE_EXPAND);
		m_bInitializedTreeOpts = true;
	}

#ifdef NEO_SK // NEO: NSK - [NeoSourceKeeper]
	if(ForFile())
		DDX_TreeRadio(pDX, IDC_MOD_OPTS, m_htiSourceKeeper, m_iEnableSourceKeeper);
	else
		DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiSourceKeeper, m_bEnableSourceKeeper);
#endif // NEO_SK // NEO: NSK END

#ifdef NEO_SS // NEO: NSS - [NeoSourceStorage]
		if(ForFile())
			DDX_TreeRadio(pDX, IDC_MOD_OPTS, m_htiSourceStorage, m_iEnableSourceStorage);
		else
			DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiUseSourceStorage, m_bEnableSourceStorage);
		if(ForFile()){
			DDX_TreeRadio(pDX, IDC_MOD_OPTS, m_htiAutoSaveSources, m_iAutoSaveSources);
			DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiAutoSaveSourcesIntervals, m_iAutoSaveSourcesIntervals);
		}else{
			DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiAutoSaveSources, m_uAutoSaveSources);
			DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiAutoSaveSources, m_iAutoSaveSourcesIntervals);
		}
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiSourceStorageLimit, m_iSourceStorageLimit);
			if(ForFile())
				DDX_TreeRadio(pDX, IDC_MOD_OPTS, m_htiStoreLowIDSources, m_iStoreLowIDSources);
			else
				DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiStoreLowIDSources, m_bStoreLowIDSources);

			if(ForFile())
				DDX_TreeRadio(pDX, IDC_MOD_OPTS, m_htiStoreAlsoA4AFSources, m_iStoreAlsoA4AFSources);
			else
				DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiStoreAlsoA4AFSources, m_bStoreAlsoA4AFSources);

			if(ForFile())
				DDX_TreeRadio(pDX, IDC_MOD_OPTS, m_htiStoreSourcesFileStatus, m_iStoreSourcesFileStatus);
			else
				DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiStoreSourcesFileStatus, m_uStoreSourcesFileStatus);

		if(ForFile())
			DDX_TreeRadio(pDX, IDC_MOD_OPTS, m_htiAutoLoadStoredSources, m_iAutoLoadStoredSources);
		else
			DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiAutoLoadStoredSources, m_bAutoLoadStoredSources);

			if(ForFile())
				DDX_TreeRadio(pDX, IDC_MOD_OPTS, m_htiAutoReaskStoredSources, m_iAutoReaskStoredSources);
			else
				DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiAutoReaskStoredSourcesEnable, m_bAutoReaskStoredSources);
			DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiAutoReaskStoredSourcesLimit, m_iAutoReaskStoredSourcesLimit);
				if(ForFile())
					DDX_TreeRadio(pDX, IDC_MOD_OPTS, m_htiAutoReaskStoredSourcesLimit, m_iTotalSourceRestore);
				else
					DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiTotalSourceRestoreEnable, m_bTotalSourceRestore);

			if(ForFile())
				DDX_TreeRadio(pDX, IDC_MOD_OPTS, m_htiStorageBootstrap, m_iUseStorageBootstrap);
			else
				DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiStorageBootstrap, m_bUseStorageBootstrap);
			DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiStorageBootstrapTime, m_iStorageBootstrapTime);
			DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiStorageBootstrapRequirement, m_iStorageBootstrapRequirement);

			if(ForFile())
				DDX_TreeRadio(pDX, IDC_MOD_OPTS, m_htiAutoReaskStoredSourcesDelay, m_iUseAutoReaskStoredSourcesDelay);
			else
				DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiAutoReaskStoredSourcesDelay, m_bUseAutoReaskStoredSourcesDelay);
			DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiAutoReaskStoredSourcesDelay, m_iAutoReaskStoredSourcesDelay);
			DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiAutoReaskLoadedSourcesDelay, m_iAutoReaskLoadedSourcesDelay);

				if(ForFile())
					DDX_TreeRadio(pDX, IDC_MOD_OPTS, m_htiGroupStoredSourceReask, m_iGroupStoredSourceReask);
				else
					DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiGroupStoredSourceReask, m_bGroupStoredSourceReask);
				DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiStoredSourceGroupIntervals, m_iStoredSourceGroupIntervals);
				DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiStoredSourceGroupSize, m_iStoredSourceGroupSize);

				if(ForFile())
					DDX_TreeRadio(pDX, IDC_MOD_OPTS, m_htiUseSmoothOutOfDate, m_iUseSmoothOutOfDate);
				else
					DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiUseSmoothOutOfDate, m_bUseSmoothOutOfDate);
				DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiMaxStoredFaildCount, m_iMaxStoredFaildCount);
				DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiStoredOutOfDate, m_iStoredOutOfDate);
#endif // NEO_SS // NEO: NSS END
#ifdef NEO_CD // NEO: NCD - [NeoClientDatabase]
		if(!ForFile()){
			DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiEnableSourceList, m_bEnableSourceList);
			DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiSaveGlobalSourceList, m_uSaveGlobalSourceList);
				DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiGlobalSourceListCleanUpTime, m_iGlobalSourceListCleanUpTime);
				DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiGlobalSourceListCleanUp, m_bGlobalSourceListCleanUp);
				DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiGlobalSourceListCleanUp, m_iGlobalSourceListCleanUpIntervals);
				DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiFastSourceCleanUp, m_bFastSourceCleanUp);
			DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiSaveSourceFileList, m_bSaveSourceFileList);
				DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiSourceFileListCleanUpTime, m_iSourceFileListCleanUpTime);
			DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiSaveSourceDataInClient, m_bSaveSourceDataInClient);

			DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiIPZoneCheck, m_bIPZoneCheck);

			DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiSourceHashMonitor, m_bSourceHashMonitor);
				DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiSourceHashMonitorBadTime, m_iSourceHashMonitorBadTime);
				DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiSourceHashMonitorMaxBad, m_iSourceHashMonitorMaxBad);

				DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiTableAmountToStore, m_iTableAmountToStore);

				DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiIgnoreUnreachableInterval, m_iIgnoreUnreachableInterval);
				DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiIgnoreUndefinedInterval, m_iIgnoreUndefinedInterval);
				DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiBeginNewTableInterval, m_iBeginNewTableInterval);
		}
#endif // NEO_CD // NEO: NCD END
#ifdef NEO_SA // NEO: NSA - [NeoSourceAnaliser]
		if(ForFile())
			DDX_TreeRadio(pDX, IDC_MOD_OPTS, m_htiSourceAnaliser, m_iEnableSourceAnalizer);
		else
			DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiSourceAnaliserEnable, m_bEnableSourceAnalizer);

		if(!ForFile()){
			DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiAnaliseIntervals, m_iAnaliseIntervals);
			DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiTableAmountToAnalise, m_iTableAmountToAnalise);
		}

		if(ForFile())
			DDX_TreeRadio(pDX, IDC_MOD_OPTS, m_htiDontStoreTemporarySources, m_iDontStoreTemporarySources);
		else
			DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiDontStoreTemporarySources, m_bDontStoreTemporarySources);

			DDX_TreeRadio(pDX, IDC_MOD_OPTS, m_htiPropabilityMode, m_iPropabilityMode);
				DDX_TreeEditE0f(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiPropabilityModeEnhanced, m_fEnhancedFactor);
			DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiReaskPropability, m_iReaskPropability);

			DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiReservePropability, m_iReservePropability);
				if(ForFile())
					DDX_TreeRadio(pDX, IDC_MOD_OPTS, m_htiReservePropability, m_iAutoReserveReask);
				else
					DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiAutoReserveReaskEnable, m_bAutoReserveReask);
				DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiReserveReaskPropability, m_iReserveReaskPropability);
				DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiReaskReserveSourcesDelay, m_iReaskReserveSourcesDelay);
				if(ForFile())
					DDX_TreeRadio(pDX, IDC_MOD_OPTS, m_htiReaskReserveSourcesDelay, m_iUseReaskReserveSourcesDelay);
				else
					DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiReaskReserveSourcesDelay, m_bUseReaskReserveSourcesDelay);
				DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiReaskReserveSourcesLimit, m_iReaskReserveSourcesLimit);

			if(ForFile())
				DDX_TreeRadio(pDX, IDC_MOD_OPTS, m_htiTemporarySources, m_iAutoTemporaryReask);
			else
				DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiTemporarySources, m_bAutoTemporaryReask);
				DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiTemporaryReaskPropability, m_iTemporaryReaskPropability);
				DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiReaskTemporarySourcesDelay, m_iReaskTemporarySourcesDelay);
				if(ForFile())
					DDX_TreeRadio(pDX, IDC_MOD_OPTS, m_htiReaskTemporarySourcesDelay, m_iUseReaskTemporarySourcesDelay);
				else
					DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiReaskTemporarySourcesDelay, m_bUseReaskTemporarySourcesDelay);
				DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiReaskTemporarySourcesLimit, m_iReaskTemporarySourcesLimit);

			//DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiMinAnalisisQuality, m_iMinAnalisisQuality);
				//if(ForFile())
				//	DDX_TreeRadio(pDX, IDC_MOD_OPTS, m_htiMinAnalisisQuality, m_iAutoUnsureReask);
				//else
				//	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiAutoUnsureReaskEnable, m_bAutoUnsureReask);
				//DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiReaskUnsureSourcesDelay, m_iReaskUnsureSourcesDelay);
				//if(ForFile())
				//	DDX_TreeRadio(pDX, IDC_MOD_OPTS, m_htiReaskUnsureSourcesDelay, m_iUseReaskUnsureSourcesDelay);
				//else
				//	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiReaskUnsureSourcesDelay, m_bUseReaskUnsureSourcesDelay);
				//DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiReaskUnsureSourcesLimit, m_iReaskUnsureSourcesLimit);

			if(ForFile()){
				DDX_TreeRadio(pDX, IDC_MOD_OPTS, m_htiUnpredictedPropability, m_iUseUnpredictedPropability);
				DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiUnpredictedPropabilityValue, m_iUnpredictedPropability);
			}else{
				DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiUnpredictedPropability, m_bUseUnpredictedPropability);
				DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiUnpredictedPropability, m_iUnpredictedPropability);
			}
				DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiReaskUnpredictedSourcesDelay, m_iReaskUnpredictedSourcesDelay);
				if(ForFile())
					DDX_TreeRadio(pDX, IDC_MOD_OPTS, m_htiReaskUnpredictedSourcesDelay, m_iUseReaskUnpredictedSourcesDelay);
				else
					DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiReaskUnpredictedSourcesDelay, m_bUseReaskUnpredictedSourcesDelay);
				DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiReaskUnpredictedSourcesLimit, m_iReaskUnpredictedSourcesLimit);

			if(ForFile()){
				DDX_TreeRadio(pDX, IDC_MOD_OPTS, m_htiFailTolerance, m_iFailTolerance);
				DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiFailToleranceValue, m_iMaxFailTolerance);
			}else{
				DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiFailTolerance, m_uFailTolerance);
				DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiFailTolerance, m_iMaxFailTolerance);
			}
				if(ForFile()){
					DDX_TreeRadio(pDX, IDC_MOD_OPTS, m_htiRetryUnreachable, m_iRetryUnreachable);
					DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiRetryUnreachableIntervals, m_iRetryUnreachableIntervals);
				}else{
					DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiRetryUnreachable, m_uRetryUnreachable);
					DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiRetryUnreachable, m_iRetryUnreachableIntervals);
				}
				DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiUnreachableReaskPropability, m_iUnreachableReaskPropability);
				DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiReaskUnreachableSourcesLimit, m_iReaskUnreachableSourcesLimit);

		if(!ForFile()){
				DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiHandleTableGaps, m_bHandleTableGaps);
					DDX_TreeEditE0f(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiPriorityGapRatio, m_fPriorityGapRatio);
					DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiMaxGapSize, m_iMaxGapSize);
					DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiMaxGapTime, m_iMaxGapTime);
				DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiCheckPriorityIP, m_bCheckPriorityIP);
					DDX_TreeEditE0f(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiCheckPriorityIP, m_fPriorityIPRatio);
				DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiCheckPortIntegrity, m_bCheckPortIntegrity);
					DDX_TreeEditE0f(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiCheckPortIntegrity, m_fPortIntegrityRatio);
			DDX_TreeEditE0f(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiMaxMidleDiscrepanceHigh, m_fMaxMidleDiscrepanceHigh);
			DDX_TreeEditE0f(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiMaxMidleDiscrepanceLow, m_fMaxMidleDiscrepanceLow);
			DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiLastSeenDurationThreshold, m_iLastSeenDurationThreshold);
			DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiLinkTimeThreshold, m_uLinkTimePropability);
			DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiLinkTimeThreshold, m_iLinkTimeThreshold);
			DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiDualLinkedTableGravity, m_bUseDualLinkedTableGravity);
			DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiDualLinkedTableGravity, m_iDualLinkedTableGravity);
			DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiMaxReliableTime, m_bReliableTimeMagnification);
			DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiMaxReliableTime, m_iMaxReliableTime);
			DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiTempralIPBorderLine, m_iTempralIPBorderLine);
		}
#endif // NEO_SA // NEO: NSA END


		// NEO: NSD - [NeoSourceDrop]
#ifdef NEO_SK // NEO: NSK - [NeoSourceKeeper]
		if(ForFile()) 
			DDX_TreeRadio(pDX, IDC_MOD_OPTS, m_htiDropUnreachable, m_iDropUnreachable);
		else
			DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiDropUnreachableEnable, m_bDropUnreachable);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiDropUnreachableLimit, m_iDropUnreachableLimit);
			DDX_TreeRadio(pDX, IDC_MOD_OPTS, m_htiDropUnreachableLimit, m_iDropUnreachableLimitMode);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiDropUnreachableTimer, m_iDropUnreachableTimer);
#endif // NEO_SK // NEO: NSK END
#ifdef NEO_SS // NEO: NSS - [NeoSourceStorage]
		if(ForFile()) 
			DDX_TreeRadio(pDX, IDC_MOD_OPTS, m_htiDropOutOfDate, m_iDropOutOfDate);
		else
			DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiDropOutOfDateEnable, m_bDropOutOfDate);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiDropOutOfDateLimit, m_iDropOutOfDateLimit);
			DDX_TreeRadio(pDX, IDC_MOD_OPTS, m_htiDropOutOfDateLimit, m_iDropOutOfDateLimitMode);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiDropOutOfDateTimer, m_iDropOutOfDateTimer);
			if(ForFile())
				DDX_TreeRadio(pDX, IDC_MOD_OPTS, m_htiDropOutOfDateSmooth, m_iDropOutOfDateSmooth);
			else
				DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiDropOutOfDateSmooth, m_bDropOutOfDateSmooth);
			DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiDropOutOfDateFails, m_iDropOutOfDateFails);
			DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiDropOutOfDateTime, m_iDropOutOfDateTime);
#endif // NEO_SS // NEO: NSS END
#ifdef NEO_SA // NEO: NSA - [NeoSourceAnaliser]
		if(ForFile()) 
			DDX_TreeRadio(pDX, IDC_MOD_OPTS, m_htiDropRetired, m_iDropRetired);
		else
			DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiDropRetiredEnable, m_bDropRetired);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiDropRetiredLimit, m_iDropRetiredLimit);
			DDX_TreeRadio(pDX, IDC_MOD_OPTS, m_htiDropRetiredLimit, m_iDropRetiredLimitMode);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiDropRetiredTimer, m_iDropRetiredTimer);

		if(ForFile()) 
			DDX_TreeRadio(pDX, IDC_MOD_OPTS, m_htiDropLoaded, m_iDropLoaded);
		else
			DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiDropLoadedEnable, m_bDropLoaded);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiDropLoadedLimit, m_iDropLoadedLimit);
			DDX_TreeRadio(pDX, IDC_MOD_OPTS, m_htiDropLoadedLimit, m_iDropLoadedLimitMode);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiDropLoadedTimer, m_iDropLoadedTimer);
#endif // NEO_SA // NEO: NSA END
		// NEO: NSD END
}

BOOL CPPgSourceStorage::OnInitDialog()
{
	if(!m_bFilePreferences)
		LoadSettings();
	else
		RefreshData();

	CPropertyPage::OnInitDialog();
	InitWindowStyles(this);

	// NEO: FCFG - [FileConfiguration]
	// no need to explicitly call 'RefreshData' here, 'OnSetActive' will be called right after 'OnInitDialog'

	// start time for calling 'RefreshData'
	if(m_bFilePreferences)
		VERIFY( (m_timer = SetTimer(301, 5000, 0)) != NULL );
	// NEO: FCFG END

	return TRUE;  // return TRUE unless you set the focus to a control
				  // EXCEPTION: OCX Property Pages should return FALSE
}

BOOL CPPgSourceStorage::OnApply()
{
	// if prop page is closed by pressing ENTER we have to explicitly commit any possibly pending
	// data from an open edit control
	m_ctrlTreeOptions.HandleChildControlLosingFocus();

	if (!UpdateData())
		return FALSE;

	if(!m_bFilePreferences){
		/*
		* Globale Einstellungen Speichern
		*/
#ifdef NEO_SK // NEO: NSK - [NeoSourceKeeper]
		thePrefs.m_bEnableSourceKeeper = m_bEnableSourceKeeper;
#endif // NEO_SK // NEO: NSK END
#ifdef NEO_SS // NEO: NSS - [NeoSourceStorage]
		thePrefs.m_bEnableSourceStorage = m_bEnableSourceStorage;
		thePrefs.m_uAutoSaveSources = m_uAutoSaveSources;
		if(m_iAutoSaveSourcesIntervals) thePrefs.m_iAutoSaveSourcesIntervals = m_iAutoSaveSourcesIntervals;
		if(m_iSourceStorageLimit) thePrefs.m_iSourceStorageLimit = m_iSourceStorageLimit;
		thePrefs.m_bStoreLowIDSources = m_bStoreLowIDSources;
		thePrefs.m_bStoreAlsoA4AFSources = m_bStoreAlsoA4AFSources;
		thePrefs.m_uStoreSourcesFileStatus = m_uStoreSourcesFileStatus;
		thePrefs.m_bAutoLoadStoredSources = m_bAutoLoadStoredSources;
		thePrefs.m_bUseStorageBootstrap = m_bUseStorageBootstrap;
		if(m_iStorageBootstrapTime) thePrefs.m_iStorageBootstrapTime = m_iStorageBootstrapTime;
		if(m_iStorageBootstrapRequirement) thePrefs.m_iStorageBootstrapRequirement = m_iStorageBootstrapRequirement;

		thePrefs.m_bAutoReaskStoredSources = m_bAutoReaskStoredSources;
		if(m_iAutoReaskStoredSourcesLimit) thePrefs.m_iAutoReaskStoredSourcesLimit = m_iAutoReaskStoredSourcesLimit;
		thePrefs.m_bTotalSourceRestore = m_bTotalSourceRestore;
		thePrefs.m_bUseAutoReaskStoredSourcesDelay = m_bUseAutoReaskStoredSourcesDelay;
		if(m_iAutoReaskStoredSourcesDelay) thePrefs.m_iAutoReaskStoredSourcesDelay = m_iAutoReaskStoredSourcesDelay;

		if(m_iAutoReaskLoadedSourcesDelay) thePrefs.m_iAutoReaskLoadedSourcesDelay = m_iAutoReaskLoadedSourcesDelay;

		thePrefs.m_bGroupStoredSourceReask = m_bGroupStoredSourceReask;
		if(m_iStoredSourceGroupIntervals) thePrefs.m_iStoredSourceGroupIntervals = m_iStoredSourceGroupIntervals;
		if(m_iStoredSourceGroupSize) thePrefs.m_iStoredSourceGroupSize = m_iStoredSourceGroupSize;

		thePrefs.m_bUseSmoothOutOfDate = m_bUseSmoothOutOfDate;
		if(m_iMaxStoredFaildCount) thePrefs.m_iMaxStoredFaildCount = m_iMaxStoredFaildCount;
		if(m_iStoredOutOfDate) thePrefs.m_iStoredOutOfDate = m_iStoredOutOfDate;
#endif // NEO_SS // NEO: NSS END
#ifdef NEO_CD // NEO: NCD - [NeoClientDatabase]
		thePrefs.m_bEnableSourceList = m_bEnableSourceList;
		thePrefs.m_uSaveGlobalSourceList = m_uSaveGlobalSourceList;
		if(m_iGlobalSourceListCleanUpTime) thePrefs.m_iGlobalSourceListCleanUpTime = m_iGlobalSourceListCleanUpTime;
		thePrefs.m_bGlobalSourceListCleanUp = m_bGlobalSourceListCleanUp;
		if(m_iGlobalSourceListCleanUpIntervals) thePrefs.m_iGlobalSourceListCleanUpIntervals = m_iGlobalSourceListCleanUpIntervals;
		thePrefs.m_bFastSourceCleanUp = m_bFastSourceCleanUp;
		thePrefs.m_bSaveSourceFileList = m_bSaveSourceFileList;
		if(m_iSourceFileListCleanUpTime) thePrefs.m_iSourceFileListCleanUpTime = m_iSourceFileListCleanUpTime;
		thePrefs.m_bSaveSourceDataInClient = m_bSaveSourceDataInClient;

		thePrefs.m_bIPZoneCheck = m_bIPZoneCheck;

		thePrefs.m_bSourceHashMonitor = m_bSourceHashMonitor;
		if(m_iSourceHashMonitorBadTime) thePrefs.m_iSourceHashMonitorBadTime = m_iSourceHashMonitorBadTime;
		if(m_iSourceHashMonitorMaxBad) thePrefs.m_iSourceHashMonitorMaxBad = m_iSourceHashMonitorMaxBad;

		if(m_iTableAmountToStore) thePrefs.m_iTableAmountToStore = m_iTableAmountToStore;

		if(m_iIgnoreUnreachableInterval) thePrefs.m_iIgnoreUnreachableInterval = m_iIgnoreUnreachableInterval;
		if(m_iIgnoreUndefinedInterval) thePrefs.m_iIgnoreUndefinedInterval = m_iIgnoreUndefinedInterval;
		if(m_iBeginNewTableInterval) thePrefs.m_iBeginNewTableInterval = m_iBeginNewTableInterval;
#endif // NEO_CD // NEO: NCD END
#ifdef NEO_SA // NEO: NSA - [NeoSourceAnaliser]
		thePrefs.m_bEnableSourceAnalizer = m_bEnableSourceAnalizer;
		if(m_iAnaliseIntervals) thePrefs.m_iAnaliseIntervals = m_iAnaliseIntervals;
		if(m_iTableAmountToAnalise) thePrefs.m_iTableAmountToAnalise = m_iTableAmountToAnalise;

		thePrefs.m_bDontStoreTemporarySources = m_bDontStoreTemporarySources;

		thePrefs.m_iPropabilityMode = m_iPropabilityMode;
		if(m_fEnhancedFactor) thePrefs.m_fEnhancedFactor = m_fEnhancedFactor;

		if(m_iReaskPropability) thePrefs.m_iReaskPropability = m_iReaskPropability;
		if(m_iReservePropability) thePrefs.m_iReservePropability = m_iReservePropability;

		thePrefs.m_bAutoReserveReask = m_bAutoReserveReask;
		if(m_iReserveReaskPropability) thePrefs.m_iReserveReaskPropability = m_iReserveReaskPropability;
		thePrefs.m_bUseReaskReserveSourcesDelay = m_bUseReaskReserveSourcesDelay;
		if(m_iReaskReserveSourcesDelay) thePrefs.m_iReaskReserveSourcesDelay = m_iReaskReserveSourcesDelay;
		if(m_iReaskReserveSourcesLimit) thePrefs.m_iReaskReserveSourcesLimit = m_iReaskReserveSourcesLimit;

		thePrefs.m_bAutoTemporaryReask = m_bAutoTemporaryReask;
		if(m_iTemporaryReaskPropability) thePrefs.m_iTemporaryReaskPropability = m_iTemporaryReaskPropability;
		thePrefs.m_bUseReaskTemporarySourcesDelay = m_bUseReaskTemporarySourcesDelay;
		if(m_iReaskTemporarySourcesDelay) thePrefs.m_iReaskTemporarySourcesDelay = m_iReaskTemporarySourcesDelay;
		if(m_iReaskTemporarySourcesLimit) thePrefs.m_iReaskTemporarySourcesLimit = m_iReaskTemporarySourcesLimit;

		//if(m_iMinAnalisisQuality) thePrefs.m_iMinAnalisisQuality = m_iMinAnalisisQuality;

		//thePrefs.m_bAutoUnsureReask = m_bAutoUnsureReask;
		//thePrefs.m_bUseReaskUnsureSourcesDelay = m_bUseReaskUnsureSourcesDelay;
		//if(m_iReaskUnsureSourcesDelay) thePrefs.m_iReaskUnsureSourcesDelay = m_iReaskUnsureSourcesDelay;
		//if(m_iReaskUnsureSourcesLimit) thePrefs.m_iReaskUnsureSourcesLimit = m_iReaskUnsureSourcesLimit;

		thePrefs.m_bUseUnpredictedPropability = m_bUseUnpredictedPropability;
		if(m_iUnpredictedPropability) thePrefs.m_iUnpredictedPropability = m_iUnpredictedPropability;
		thePrefs.m_bUseReaskUnpredictedSourcesDelay = m_bUseReaskUnpredictedSourcesDelay;
		if(m_iReaskUnpredictedSourcesDelay) thePrefs.m_iReaskUnpredictedSourcesDelay = m_iReaskUnpredictedSourcesDelay;
		if(m_iReaskUnpredictedSourcesLimit) thePrefs.m_iReaskUnpredictedSourcesLimit = m_iReaskUnpredictedSourcesLimit;

		thePrefs.m_uFailTolerance = m_uFailTolerance;
		if(m_iMaxFailTolerance) thePrefs.m_iMaxFailTolerance = m_iMaxFailTolerance;
		thePrefs.m_uRetryUnreachable = m_uRetryUnreachable;
		if(m_iRetryUnreachableIntervals) thePrefs.m_iRetryUnreachableIntervals = m_iRetryUnreachableIntervals;
		if(m_iUnreachableReaskPropability) thePrefs.m_iUnreachableReaskPropability = m_iUnreachableReaskPropability;
		if(m_iReaskUnreachableSourcesLimit) thePrefs.m_iReaskUnreachableSourcesLimit = m_iReaskUnreachableSourcesLimit;

		thePrefs.m_bHandleTableGaps = m_bHandleTableGaps;
		if(m_fPriorityGapRatio) thePrefs.m_fPriorityGapRatio = m_fPriorityGapRatio;
		if(m_iMaxGapSize) thePrefs.m_iMaxGapSize = m_iMaxGapSize;
		if(m_iMaxGapTime) thePrefs.m_iMaxGapTime = m_iMaxGapTime;
		thePrefs.m_bCheckPriorityIP = m_bCheckPriorityIP;
		if(m_fPriorityIPRatio) thePrefs.m_fPriorityIPRatio = m_fPriorityIPRatio;
		thePrefs.m_bCheckPortIntegrity = m_bCheckPortIntegrity;
		if(m_fPortIntegrityRatio) thePrefs.m_fPortIntegrityRatio = m_fPortIntegrityRatio;
		if(m_fMaxMidleDiscrepanceHigh) thePrefs.m_fMaxMidleDiscrepanceHigh = m_fMaxMidleDiscrepanceHigh;
		if(m_fMaxMidleDiscrepanceLow) thePrefs.m_fMaxMidleDiscrepanceLow = m_fMaxMidleDiscrepanceLow;
		if(m_iLastSeenDurationThreshold) thePrefs.m_iLastSeenDurationThreshold = m_iLastSeenDurationThreshold;
		thePrefs.m_uLinkTimePropability = m_uLinkTimePropability;
		if(m_iLinkTimeThreshold) thePrefs.m_iLinkTimeThreshold = m_iLinkTimeThreshold;
		thePrefs.m_bUseDualLinkedTableGravity = m_bUseDualLinkedTableGravity;
		if(m_iDualLinkedTableGravity) thePrefs.m_iDualLinkedTableGravity = m_iDualLinkedTableGravity;
		thePrefs.m_bReliableTimeMagnification = m_bReliableTimeMagnification;
		if(m_iMaxReliableTime) thePrefs.m_iMaxReliableTime = m_iMaxReliableTime;
		if(m_iTempralIPBorderLine) thePrefs.m_iTempralIPBorderLine = m_iTempralIPBorderLine;
#endif // NEO_SA // NEO: NSA END

		// NEO: NSD - [NeoSourceDrop]
#ifdef NEO_SK // NEO: NSK - [NeoSourceKeeper]
		thePrefs.m_bDropUnreachable = m_bDropUnreachable;
		if(m_iDropUnreachableLimit) thePrefs.m_iDropUnreachableLimit = m_iDropUnreachableLimit;
		thePrefs.m_iDropUnreachableLimitMode = m_iDropUnreachableLimitMode;
		if(m_iDropUnreachableTimer) thePrefs.m_iDropUnreachableTimer = m_iDropUnreachableTimer;
#endif // NEO_SK // NEO: NSK END
#ifdef NEO_SS // NEO: NSS - [NeoSourceStorage]
		thePrefs.m_bDropOutOfDate = m_bDropOutOfDate;
		thePrefs.m_bDropOutOfDateSmooth = m_bDropOutOfDateSmooth;
		if(m_iDropOutOfDateFails) thePrefs.m_iDropOutOfDateFails = m_iDropOutOfDateFails;
		if(m_iDropOutOfDateTime) thePrefs.m_iDropOutOfDateTime = m_iDropOutOfDateTime;
		if(m_iDropOutOfDateLimit) thePrefs.m_iDropOutOfDateLimit = m_iDropOutOfDateLimit;
		thePrefs.m_iDropOutOfDateLimitMode = m_iDropOutOfDateLimitMode;
		if(m_iDropOutOfDateTimer) thePrefs.m_iDropOutOfDateTimer = m_iDropOutOfDateTimer;
#endif // NEO_SS // NEO: NSS END
#ifdef NEO_SA // NEO: NSA - [NeoSourceAnaliser]
		thePrefs.m_bDropRetired = m_bDropRetired;
		if(m_iDropRetiredLimit) thePrefs.m_iDropRetiredLimit = m_iDropRetiredLimit;
		thePrefs.m_iDropRetiredLimitMode = m_iDropRetiredLimitMode;
		if(m_iDropRetiredTimer) thePrefs.m_iDropRetiredTimer = m_iDropRetiredTimer;

		thePrefs.m_bDropLoaded = m_bDropLoaded;
		if(m_iDropLoadedLimit) thePrefs.m_iDropLoadedLimit = m_iDropLoadedLimit;
		thePrefs.m_iDropLoadedLimitMode = m_iDropLoadedLimitMode;
		if(m_iDropLoadedTimer) thePrefs.m_iDropLoadedTimer = m_iDropLoadedTimer;
#endif // NEO_SA // NEO: NSA END
		// NEO: NSD END

		thePrefs.CheckNeoPreferences();
		LoadSettings();

	}else{
		/*
		* Datei Einstellungen Speichern
		*/
		// NEO: FCFG - [FileConfiguration]
		CPartFile* file;
		for (int i = 0; i < m_paFiles->GetSize(); i++)
		{
			file = STATIC_DOWNCAST(CPartFile, (*m_paFiles)[i]);


			//if (file->IsPartFile())

#ifdef NEO_SK // NEO: NSK - [NeoSourceKeeper]
			if(m_iEnableSourceKeeper != -1) file->PartPrefs.m_iEnableSourceKeeper = m_iEnableSourceKeeper;
#endif // NEO_SK // NEO: NSK END
#ifdef NEO_SS // NEO: NSS - [NeoSourceStorage]
			if(m_iEnableSourceStorage != -1) file->PartPrefs.m_iEnableSourceStorage = m_iEnableSourceStorage;
			if(m_iAutoSaveSources != -1) file->PartPrefs.m_iAutoSaveSources = m_iAutoSaveSources;
			if(m_iAutoSaveSourcesIntervals) file->PartPrefs.m_iAutoSaveSourcesIntervals = (m_iAutoSaveSourcesIntervals != thePrefs.GetAutoSaveSourcesIntervals()) ? m_iAutoSaveSourcesIntervals : 0;
			if(m_iSourceStorageLimit) file->PartPrefs.m_iSourceStorageLimit = (m_iSourceStorageLimit != thePrefs.GetSourceStorageLimit()) ? m_iSourceStorageLimit : 0;
			if(m_iStoreLowIDSources != -1) file->PartPrefs.m_iStoreLowIDSources = m_iStoreLowIDSources;
			if(m_iStoreAlsoA4AFSources != -1) file->PartPrefs.m_iStoreAlsoA4AFSources = m_iStoreAlsoA4AFSources;
			if(m_iStoreSourcesFileStatus != -1) file->PartPrefs.m_iStoreSourcesFileStatus = m_iStoreSourcesFileStatus;
			if(m_iAutoLoadStoredSources != -1) file->PartPrefs.m_iAutoLoadStoredSources = m_iAutoLoadStoredSources;
			if(m_iUseStorageBootstrap != -1) file->PartPrefs.m_iUseStorageBootstrap = m_iUseStorageBootstrap;
			if(m_iStorageBootstrapTime) file->PartPrefs.m_iStorageBootstrapTime = (m_iStorageBootstrapTime != thePrefs.GetStorageBootstrapTime()) ? m_iStorageBootstrapTime : 0;
			if(m_iStorageBootstrapRequirement) file->PartPrefs.m_iStorageBootstrapRequirement = (m_iStorageBootstrapRequirement != thePrefs.GetStorageBootstrapRequirement()) ? m_iStorageBootstrapRequirement : 0;

			if(m_iAutoReaskStoredSources != -1) file->PartPrefs.m_iAutoReaskStoredSources = m_iAutoReaskStoredSources;
			if(m_iAutoReaskStoredSourcesLimit) file->PartPrefs.m_iAutoReaskStoredSourcesLimit = (m_iAutoReaskStoredSourcesLimit != thePrefs.GetAutoReaskStoredSourcesLimit()) ? m_iAutoReaskStoredSourcesLimit : 0;
			if(m_iTotalSourceRestore != -1) file->PartPrefs.m_iTotalSourceRestore = m_iTotalSourceRestore;
			if(m_iUseAutoReaskStoredSourcesDelay != -1) file->PartPrefs.m_iUseAutoReaskStoredSourcesDelay = m_iUseAutoReaskStoredSourcesDelay;
			if(m_iAutoReaskStoredSourcesDelay) file->PartPrefs.m_iAutoReaskStoredSourcesDelay = (m_iAutoReaskStoredSourcesDelay != thePrefs.GetAutoReaskStoredSourcesDelay()) ? m_iAutoReaskStoredSourcesDelay : 0;

			if(m_iAutoReaskLoadedSourcesDelay) file->PartPrefs.m_iAutoReaskLoadedSourcesDelay = (m_iAutoReaskLoadedSourcesDelay != thePrefs.GetAutoReaskLoadedSourcesDelay()) ? m_iAutoReaskLoadedSourcesDelay : 0;

			if(m_iGroupStoredSourceReask != -1) file->PartPrefs.m_iGroupStoredSourceReask = m_iGroupStoredSourceReask;
			if(m_iStoredSourceGroupIntervals) file->PartPrefs.m_iStoredSourceGroupIntervals = (m_iStoredSourceGroupIntervals != thePrefs.GetStoredSourceGroupIntervals()) ? m_iStoredSourceGroupIntervals : 0;
			if(m_iStoredSourceGroupSize) file->PartPrefs.m_iStoredSourceGroupSize = (m_iStoredSourceGroupSize != thePrefs.GetStoredSourceGroupSize()) ? m_iStoredSourceGroupSize : 0;

			if(m_iUseSmoothOutOfDate != -1) file->PartPrefs.m_iUseSmoothOutOfDate = m_iUseSmoothOutOfDate;
			if(m_iMaxStoredFaildCount) file->PartPrefs.m_iMaxStoredFaildCount = (m_iMaxStoredFaildCount != thePrefs.GetMaxStoredFaildCount()) ? m_iMaxStoredFaildCount : 0;
			if(m_iStoredOutOfDate) file->PartPrefs.m_iStoredOutOfDate = (m_iStoredOutOfDate != thePrefs.GetStoredOutOfDate()) ? m_iStoredOutOfDate : 0;
#endif // NEO_SS // NEO: NSS END
#ifdef NEO_SA // NEO: NSA - [NeoSourceAnaliser]
			if(m_iEnableSourceAnalizer != -1) file->PartPrefs.m_iEnableSourceAnalizer = m_iEnableSourceAnalizer;

			if(m_iDontStoreTemporarySources != -1) file->PartPrefs.m_iDontStoreTemporarySources = m_iDontStoreTemporarySources;

			if(m_iPropabilityMode != -1) file->PartPrefs.m_iPropabilityMode = m_iPropabilityMode;
			if(m_fEnhancedFactor) file->PartPrefs.m_fEnhancedFactor = (m_fEnhancedFactor != thePrefs.GetEnhancedFactor()) ? m_fEnhancedFactor : 0;

			if(m_iReaskPropability) file->PartPrefs.m_iReaskPropability = (m_iReaskPropability != thePrefs.GetReaskPropability()) ? m_iReaskPropability : 0;
			if(m_iReservePropability) file->PartPrefs.m_iReservePropability = (m_iReservePropability != thePrefs.GetReservePropability()) ? m_iReservePropability : 0;

			if(m_iAutoReserveReask != -1) file->PartPrefs.m_iAutoReserveReask = m_iAutoReserveReask;
			if(m_iReserveReaskPropability) file->PartPrefs.m_iReserveReaskPropability = (m_iReserveReaskPropability != thePrefs.GetReserveReaskPropability()) ? m_iReserveReaskPropability : 0;
			if(m_iUseReaskReserveSourcesDelay != -1) file->PartPrefs.m_iUseReaskReserveSourcesDelay = m_iUseReaskReserveSourcesDelay;
			if(m_iReaskReserveSourcesDelay) file->PartPrefs.m_iReaskReserveSourcesDelay = (m_iReaskReserveSourcesDelay != thePrefs.GetReaskReserveSourcesDelay()) ? m_iReaskReserveSourcesDelay : 0;
			if(m_iReaskReserveSourcesLimit) file->PartPrefs.m_iReaskReserveSourcesLimit = (m_iReaskReserveSourcesLimit != thePrefs.GetReaskReserveSourcesLimit()) ? m_iReaskReserveSourcesLimit : 0;

			if(m_iAutoTemporaryReask != -1) file->PartPrefs.m_iAutoTemporaryReask = m_iAutoTemporaryReask;
			if(m_iTemporaryReaskPropability) file->PartPrefs.m_iTemporaryReaskPropability = (m_iTemporaryReaskPropability != thePrefs.GetTemporaryReaskPropability()) ? m_iTemporaryReaskPropability : 0;
			if(m_iUseReaskTemporarySourcesDelay != -1) file->PartPrefs.m_iUseReaskTemporarySourcesDelay = m_iUseReaskTemporarySourcesDelay;
			if(m_iReaskTemporarySourcesDelay) file->PartPrefs.m_iReaskTemporarySourcesDelay = (m_iReaskTemporarySourcesDelay != thePrefs.GetReaskTemporarySourcesDelay()) ? m_iReaskTemporarySourcesDelay : 0;
			if(m_iReaskTemporarySourcesLimit) file->PartPrefs.m_iReaskTemporarySourcesLimit = (m_iReaskTemporarySourcesLimit != thePrefs.GetReaskTemporarySourcesLimit()) ? m_iReaskTemporarySourcesLimit : 0;

			//if(m_iMinAnalisisQuality) file->PartPrefs.m_iMinAnalisisQuality = (m_iMinAnalisisQuality != thePrefs.GetMinAnalisisQuality()) ? m_iMinAnalisisQuality : 0;

			//if(m_iAutoUnsureReask != -1) file->PartPrefs.m_iAutoUnsureReask = m_iAutoUnsureReask;
			//if(m_iUseReaskUnsureSourcesDelay != -1) file->PartPrefs.m_iUseReaskUnsureSourcesDelay = m_iUseReaskUnsureSourcesDelay;
			//if(m_iReaskUnsureSourcesDelay) file->PartPrefs.m_iReaskUnsureSourcesDelay = (m_iReaskUnsureSourcesDelay != thePrefs.GetReaskUnsureSourcesDelay()) ? m_iReaskUnsureSourcesDelay : 0;
			//if(m_iReaskUnsureSourcesLimit) file->PartPrefs.m_iReaskUnsureSourcesLimit = (m_iReaskUnsureSourcesLimit != thePrefs.GetReaskUnsureSourcesLimit()) ? m_iReaskUnsureSourcesLimit : 0;

			if(m_iUseUnpredictedPropability != -1) file->PartPrefs.m_iUseUnpredictedPropability = m_iUseUnpredictedPropability;
			if(m_iUnpredictedPropability) file->PartPrefs.m_iUnpredictedPropability = (m_iUnpredictedPropability != thePrefs.GetUnpredictedPropability()) ? m_iUnpredictedPropability : 0;
			if(m_iUseReaskUnpredictedSourcesDelay != -1) file->PartPrefs.m_iUseReaskUnpredictedSourcesDelay = m_iUseReaskUnpredictedSourcesDelay;
			if(m_iReaskUnpredictedSourcesDelay) file->PartPrefs.m_iReaskUnpredictedSourcesDelay = (m_iReaskUnpredictedSourcesDelay != thePrefs.GetReaskUnpredictedSourcesDelay()) ? m_iReaskUnpredictedSourcesDelay : 0;
			if(m_iReaskUnpredictedSourcesLimit) file->PartPrefs.m_iReaskUnpredictedSourcesLimit = (m_iReaskUnpredictedSourcesLimit != thePrefs.GetReaskUnpredictedSourcesLimit()) ? m_iReaskUnpredictedSourcesLimit : 0;

			if(m_iFailTolerance != -1) file->PartPrefs.m_iFailTolerance = m_iFailTolerance;
			if(m_iMaxFailTolerance) file->PartPrefs.m_iMaxFailTolerance = (m_iMaxFailTolerance != thePrefs.GetMaxFailTolerance()) ? m_iMaxFailTolerance : 0;
			if(m_iRetryUnreachable != -1) file->PartPrefs.m_iRetryUnreachable = m_iRetryUnreachable;
			if(m_iRetryUnreachableIntervals) file->PartPrefs.m_iRetryUnreachableIntervals = (m_iRetryUnreachableIntervals != thePrefs.GetRetryUnreachableIntervals()) ? m_iRetryUnreachableIntervals : 0;
			if(m_iUnreachableReaskPropability) file->PartPrefs.m_iUnreachableReaskPropability = (m_iUnreachableReaskPropability != thePrefs.GetUnreachableReaskPropability()) ? m_iUnreachableReaskPropability : 0;
			if(m_iReaskUnreachableSourcesLimit) file->PartPrefs.m_iReaskUnreachableSourcesLimit = (m_iReaskUnreachableSourcesLimit != thePrefs.GetReaskUnreachableSourcesLimit()) ? m_iReaskUnreachableSourcesLimit : 0;
#endif // NEO_SA // NEO: NSA END

			// NEO: NSD - [NeoSourceDrop]
#ifdef NEO_SK // NEO: NSK - [NeoSourceKeeper]
			if(m_iDropUnreachable != -1) file->PartPrefs.m_iDropUnreachable = m_iDropUnreachable;
			if(m_iDropUnreachableLimit) file->PartPrefs.m_iDropUnreachableLimit = (m_iDropUnreachableLimit != thePrefs.GetDropUnreachableLimit()) ? m_iDropUnreachableLimit : 0;
			if(m_iDropUnreachableLimitMode != -1) file->PartPrefs.m_iDropUnreachableLimitMode = m_iDropUnreachableLimitMode;
			if(m_iDropUnreachableTimer) file->PartPrefs.m_iDropUnreachableTimer = (m_iDropUnreachableTimer != thePrefs.GetDropUnreachableTimer()) ? m_iDropUnreachableTimer : 0;
#endif // NEO_SK // NEO: NSK END
#ifdef NEO_SS // NEO: NSS - [NeoSourceStorage]
			if(m_iDropOutOfDate != -1) file->PartPrefs.m_iDropOutOfDate = m_iDropOutOfDate;
			if(m_iDropOutOfDateLimit) file->PartPrefs.m_iDropOutOfDateLimit = (m_iDropOutOfDateLimit != thePrefs.GetDropOutOfDateLimit()) ? m_iDropOutOfDateLimit : 0;
			if(m_iDropOutOfDateLimitMode != -1) file->PartPrefs.m_iDropOutOfDateLimitMode = m_iDropOutOfDateLimitMode;
			if(m_iDropOutOfDateTimer) file->PartPrefs.m_iDropOutOfDateTimer = (m_iDropOutOfDateTimer != thePrefs.GetDropOutOfDateTimer()) ? m_iDropOutOfDateTimer : 0;

			if(m_iDropOutOfDateSmooth != -1) file->PartPrefs.m_iDropOutOfDateSmooth = m_iDropOutOfDateSmooth;
			if(m_iDropOutOfDateFails) file->PartPrefs.m_iDropOutOfDateFails = (m_iDropOutOfDateFails != thePrefs.GetDropOutOfDateFails()) ? m_iDropOutOfDateFails : 0;
			if(m_iDropOutOfDateTime) file->PartPrefs.m_iDropOutOfDateTime = (m_iDropOutOfDateTime != thePrefs.GetDropOutOfDateTime()) ? m_iDropOutOfDateTime : 0;
#endif // NEO_SS // NEO: NSS END
#ifdef NEO_SA // NEO: NSA - [NeoSourceAnaliser]
			if(m_iDropRetired != -1) file->PartPrefs.m_iDropRetired = m_iDropRetired;
			if(m_iDropRetiredLimit) file->PartPrefs.m_iDropRetiredLimit = (m_iDropRetiredLimit != thePrefs.GetDropRetiredLimit()) ? m_iDropRetiredLimit : 0;
			if(m_iDropRetiredLimitMode != -1) file->PartPrefs.m_iDropRetiredLimitMode = m_iDropRetiredLimitMode;
			if(m_iDropRetiredTimer) file->PartPrefs.m_iDropRetiredTimer = (m_iDropRetiredTimer != thePrefs.GetDropRetiredTimer()) ? m_iDropRetiredTimer : 0;

			if(m_iDropLoaded != -1) file->PartPrefs.m_iDropLoaded = m_iDropLoaded;
			if(m_iDropLoadedLimit) file->PartPrefs.m_iDropLoadedLimit = (m_iDropLoadedLimit != thePrefs.GetDropLoadedLimit()) ? m_iDropLoadedLimit : 0;
			if(m_iDropLoadedLimitMode != -1) file->PartPrefs.m_iDropLoadedLimitMode = m_iDropLoadedLimitMode;
			if(m_iDropLoadedTimer) file->PartPrefs.m_iDropLoadedTimer = (m_iDropLoadedTimer != thePrefs.GetDropLoadedTimer()) ? m_iDropLoadedTimer : 0;
#endif // NEO_SA // NEO: NSA END
			// NEO: NSD END

			file->PartPrefs.CheckTweaks();
		}

		RefreshData();
		// NEO: FCFG END
	}

	SetModified(FALSE);
	return CPropertyPage::OnApply();
}

void CPPgSourceStorage::LoadSettings()
{
	/*
	* Globale Einstellungen Laden
	*/
#ifdef NEO_SK // NEO: NSK - [NeoSourceKeeper]
	m_bEnableSourceKeeper = thePrefs.m_bEnableSourceKeeper;
#endif // NEO_SK // NEO: NSK END
#ifdef NEO_SS // NEO: NSS - [NeoSourceStorage]
	m_bEnableSourceStorage = thePrefs.m_bEnableSourceStorage;
	m_uAutoSaveSources = thePrefs.m_uAutoSaveSources;
	m_iAutoSaveSourcesIntervals = thePrefs.m_iAutoSaveSourcesIntervals;
	m_iSourceStorageLimit = thePrefs.m_iSourceStorageLimit;
	m_bStoreLowIDSources = thePrefs.m_bStoreLowIDSources;
	m_bStoreAlsoA4AFSources = thePrefs.m_bStoreAlsoA4AFSources;
	m_uStoreSourcesFileStatus = thePrefs.m_uStoreSourcesFileStatus;
	m_bAutoLoadStoredSources = thePrefs.m_bAutoLoadStoredSources;
	m_bUseStorageBootstrap = thePrefs.m_bUseStorageBootstrap;
	m_iStorageBootstrapTime = thePrefs.m_iStorageBootstrapTime;
	m_iStorageBootstrapRequirement = thePrefs.m_iStorageBootstrapRequirement;

	m_bAutoReaskStoredSources = thePrefs.m_bAutoReaskStoredSources;
	m_iAutoReaskStoredSourcesLimit = thePrefs.m_iAutoReaskStoredSourcesLimit;
	m_bTotalSourceRestore = thePrefs.m_bTotalSourceRestore;
	m_bUseAutoReaskStoredSourcesDelay = thePrefs.m_bUseAutoReaskStoredSourcesDelay;
	m_iAutoReaskStoredSourcesDelay = thePrefs.m_iAutoReaskStoredSourcesDelay;

	m_iAutoReaskLoadedSourcesDelay = thePrefs.m_iAutoReaskLoadedSourcesDelay;

	m_bGroupStoredSourceReask = thePrefs.m_bGroupStoredSourceReask;
	m_iStoredSourceGroupIntervals = thePrefs.m_iStoredSourceGroupIntervals;
	m_iStoredSourceGroupSize = thePrefs.m_iStoredSourceGroupSize;

	m_bUseSmoothOutOfDate = thePrefs.m_bUseSmoothOutOfDate;
	m_iMaxStoredFaildCount = thePrefs.m_iMaxStoredFaildCount;
	m_iStoredOutOfDate = thePrefs.m_iStoredOutOfDate;
#endif // NEO_SS // NEO: NSS END
#ifdef NEO_CD // NEO: NCD - [NeoClientDatabase]
	m_bEnableSourceList = thePrefs.m_bEnableSourceList;
	m_uSaveGlobalSourceList = thePrefs.m_uSaveGlobalSourceList;
	m_iGlobalSourceListCleanUpTime = thePrefs.m_iGlobalSourceListCleanUpTime;
	m_bGlobalSourceListCleanUp = thePrefs.m_bGlobalSourceListCleanUp;
	m_iGlobalSourceListCleanUpIntervals = thePrefs.m_iGlobalSourceListCleanUpIntervals;
	m_bFastSourceCleanUp = thePrefs.m_bFastSourceCleanUp;
	m_bSaveSourceFileList = thePrefs.m_bSaveSourceFileList;
	m_iSourceFileListCleanUpTime = thePrefs.m_iSourceFileListCleanUpTime;
	m_bSaveSourceDataInClient = thePrefs.m_bSaveSourceDataInClient;

	m_bIPZoneCheck = thePrefs.m_bIPZoneCheck;

	m_bSourceHashMonitor = thePrefs.m_bSourceHashMonitor;
	m_iSourceHashMonitorBadTime = thePrefs.m_iSourceHashMonitorBadTime;
	m_iSourceHashMonitorMaxBad = thePrefs.m_iSourceHashMonitorMaxBad;

	m_iTableAmountToStore = thePrefs.m_iTableAmountToStore;

	m_iIgnoreUnreachableInterval = thePrefs.m_iIgnoreUnreachableInterval;
	m_iIgnoreUndefinedInterval = thePrefs.m_iIgnoreUndefinedInterval;
	m_iBeginNewTableInterval = thePrefs.m_iBeginNewTableInterval;
#endif // NEO_CD // NEO: NCD END
#ifdef NEO_SA // NEO: NSA - [NeoSourceAnaliser]
	m_bEnableSourceAnalizer = thePrefs.m_bEnableSourceAnalizer;
	m_iAnaliseIntervals = thePrefs.m_iAnaliseIntervals;
	m_iTableAmountToAnalise = thePrefs.m_iTableAmountToAnalise;

	m_bDontStoreTemporarySources = thePrefs.m_bDontStoreTemporarySources;

	m_iPropabilityMode = thePrefs.m_iPropabilityMode;
	m_fEnhancedFactor = thePrefs.m_fEnhancedFactor;

	m_iReaskPropability = thePrefs.m_iReaskPropability;
	m_iReservePropability = thePrefs.m_iReservePropability;

	m_bAutoReserveReask = thePrefs.m_bAutoReserveReask;
	m_iReserveReaskPropability = thePrefs.m_iReserveReaskPropability;
	m_bUseReaskReserveSourcesDelay = thePrefs.m_bUseReaskReserveSourcesDelay;
	m_iReaskReserveSourcesDelay = thePrefs.m_iReaskReserveSourcesDelay;
	m_iReaskReserveSourcesLimit = thePrefs.m_iReaskReserveSourcesLimit;

	m_bAutoTemporaryReask = thePrefs.m_bAutoTemporaryReask;
	m_iTemporaryReaskPropability = thePrefs.m_iTemporaryReaskPropability;
	m_bUseReaskTemporarySourcesDelay = thePrefs.m_bUseReaskTemporarySourcesDelay;
	m_iReaskTemporarySourcesDelay = thePrefs.m_iReaskTemporarySourcesDelay;
	m_iReaskTemporarySourcesLimit = thePrefs.m_iReaskTemporarySourcesLimit;

	//m_iMinAnalisisQuality = thePrefs.m_iMinAnalisisQuality;

	//m_bAutoUnsureReask = thePrefs.m_bAutoUnsureReask;
	//m_bUseReaskUnsureSourcesDelay = thePrefs.m_bUseReaskUnsureSourcesDelay;
	//m_iReaskUnsureSourcesDelay = thePrefs.m_iReaskUnsureSourcesDelay;
	//m_iReaskUnsureSourcesLimit = thePrefs.m_iReaskUnsureSourcesLimit;

	m_bUseUnpredictedPropability = thePrefs.m_bUseUnpredictedPropability;
	m_iUnpredictedPropability = thePrefs.m_iUnpredictedPropability;
	m_bUseReaskUnpredictedSourcesDelay = thePrefs.m_bUseReaskUnpredictedSourcesDelay;
	m_iReaskUnpredictedSourcesDelay = thePrefs.m_iReaskUnpredictedSourcesDelay;
	m_iReaskUnpredictedSourcesLimit = thePrefs.m_iReaskUnpredictedSourcesLimit;

	m_uFailTolerance = thePrefs.m_uFailTolerance;
	m_iMaxFailTolerance = thePrefs.m_iMaxFailTolerance;
	m_uRetryUnreachable = thePrefs.m_uRetryUnreachable;
	m_iRetryUnreachableIntervals = thePrefs.m_iRetryUnreachableIntervals;
	m_iUnreachableReaskPropability = thePrefs.m_iUnreachableReaskPropability;
	m_iReaskUnreachableSourcesLimit = thePrefs.m_iReaskUnreachableSourcesLimit;

	m_bHandleTableGaps = thePrefs.m_bHandleTableGaps;
	m_fPriorityGapRatio = thePrefs.m_fPriorityGapRatio;
	m_iMaxGapSize = thePrefs.m_iMaxGapSize;
	m_iMaxGapTime = thePrefs.m_iMaxGapTime;
	m_bCheckPriorityIP = thePrefs.m_bCheckPriorityIP;
	m_fPriorityIPRatio = thePrefs.m_fPriorityIPRatio;
	m_bCheckPortIntegrity = thePrefs.m_bCheckPortIntegrity;
	m_fPortIntegrityRatio = thePrefs.m_fPortIntegrityRatio;
	m_fMaxMidleDiscrepanceHigh = thePrefs.m_fMaxMidleDiscrepanceHigh;
	m_fMaxMidleDiscrepanceLow = thePrefs.m_fMaxMidleDiscrepanceLow;
	m_iLastSeenDurationThreshold = thePrefs.m_iLastSeenDurationThreshold;
	m_uLinkTimePropability = thePrefs.m_uLinkTimePropability;
	m_iLinkTimeThreshold = thePrefs.m_iLinkTimeThreshold;
	m_bUseDualLinkedTableGravity = thePrefs.m_bUseDualLinkedTableGravity;
	m_iDualLinkedTableGravity = thePrefs.m_iDualLinkedTableGravity;
	m_bReliableTimeMagnification = thePrefs.m_bReliableTimeMagnification;
	m_iMaxReliableTime = thePrefs.m_iMaxReliableTime;
	m_iTempralIPBorderLine = thePrefs.m_iTempralIPBorderLine;
#endif // NEO_SA // NEO: NSA END

	// NEO: NSD - [NeoSourceDrop]
#ifdef NEO_SK // NEO: NSK - [NeoSourceKeeper]
	m_bDropUnreachable = thePrefs.m_bDropUnreachable;
	m_iDropUnreachableLimit = thePrefs.m_iDropUnreachableLimit;
	m_iDropUnreachableLimitMode = thePrefs.m_iDropUnreachableLimitMode;
	m_iDropUnreachableTimer = thePrefs.m_iDropUnreachableTimer;
#endif // NEO_SK // NEO: NSK END
#ifdef NEO_SS // NEO: NSS - [NeoSourceStorage]
	m_bDropOutOfDate = thePrefs.m_bDropOutOfDate;
	m_bDropOutOfDateSmooth = thePrefs.m_bDropOutOfDateSmooth;
	m_iDropOutOfDateFails = thePrefs.m_iDropOutOfDateFails;
	m_iDropOutOfDateTime = thePrefs.m_iDropOutOfDateTime;
	m_iDropOutOfDateLimit = thePrefs.m_iDropOutOfDateLimit;
	m_iDropOutOfDateLimitMode = thePrefs.m_iDropOutOfDateLimitMode;
	m_iDropOutOfDateTimer = thePrefs.m_iDropOutOfDateTimer;
#endif // NEO_SS // NEO: NSS END
#ifdef NEO_SA // NEO: NSA - [NeoSourceAnaliser]
	m_bDropRetired = thePrefs.m_bDropRetired;
	m_iDropRetiredLimit = thePrefs.m_iDropRetiredLimit;
	m_iDropRetiredLimitMode = thePrefs.m_iDropRetiredLimitMode;
	m_iDropRetiredTimer = thePrefs.m_iDropRetiredTimer;

	m_bDropLoaded = thePrefs.m_bDropLoaded;
	m_iDropLoadedLimit = thePrefs.m_iDropLoadedLimit;
	m_iDropLoadedLimitMode = thePrefs.m_iDropLoadedLimitMode;
	m_iDropLoadedTimer = thePrefs.m_iDropLoadedTimer;
#endif // NEO_SA // NEO: NSA END
	// NEO: NSD END
}

// NEO: FCFG - [FileConfiguration]
void CPPgSourceStorage::RefreshData()
{
	/*
	* Datei Einstellungen Laden
	*/

	const CPartFile* file = STATIC_DOWNCAST(CPartFile, (*m_paFiles)[0]);

#ifdef NEO_SK // NEO: NSK - [NeoSourceKeeper]
	m_iEnableSourceKeeper = file->PartPrefs.m_iEnableSourceKeeper;
#endif // NEO_SK // NEO: NSK END
#ifdef NEO_SS // NEO: NSS - [NeoSourceStorage]
	m_iEnableSourceStorage = file->PartPrefs.m_iEnableSourceStorage;
	m_iAutoSaveSources = file->PartPrefs.m_iAutoSaveSources;
	m_iAutoSaveSourcesIntervals = file->PartPrefs.m_iAutoSaveSourcesIntervals;
	m_iSourceStorageLimit = file->PartPrefs.m_iSourceStorageLimit;
	m_iStoreLowIDSources = file->PartPrefs.m_iStoreLowIDSources;
	m_iStoreAlsoA4AFSources = file->PartPrefs.m_iStoreAlsoA4AFSources;
	m_iStoreSourcesFileStatus = file->PartPrefs.m_iStoreSourcesFileStatus;
	m_iAutoLoadStoredSources = file->PartPrefs.m_iAutoLoadStoredSources;
	m_iUseStorageBootstrap = file->PartPrefs.m_iUseStorageBootstrap;
	m_iStorageBootstrapTime = file->PartPrefs.m_iStorageBootstrapTime;
	m_iStorageBootstrapRequirement = file->PartPrefs.m_iStorageBootstrapRequirement;

	m_iAutoReaskStoredSources = file->PartPrefs.m_iAutoReaskStoredSources;
	m_iAutoReaskStoredSourcesLimit = file->PartPrefs.m_iAutoReaskStoredSourcesLimit;
	m_iTotalSourceRestore = file->PartPrefs.m_iTotalSourceRestore;
	m_iUseAutoReaskStoredSourcesDelay = file->PartPrefs.m_iUseAutoReaskStoredSourcesDelay;
	m_iAutoReaskStoredSourcesDelay = file->PartPrefs.m_iAutoReaskStoredSourcesDelay;

	m_iAutoReaskLoadedSourcesDelay = file->PartPrefs.m_iAutoReaskLoadedSourcesDelay;

	m_iGroupStoredSourceReask = file->PartPrefs.m_iGroupStoredSourceReask;
	m_iStoredSourceGroupIntervals = file->PartPrefs.m_iStoredSourceGroupIntervals;
	m_iStoredSourceGroupSize = file->PartPrefs.m_iStoredSourceGroupSize;

	m_iUseSmoothOutOfDate = file->PartPrefs.m_iUseSmoothOutOfDate;
	m_iMaxStoredFaildCount = file->PartPrefs.m_iMaxStoredFaildCount;
	m_iStoredOutOfDate = file->PartPrefs.m_iStoredOutOfDate;
#endif // NEO_SS // NEO: NSS END
#ifdef NEO_SA // NEO: NSA - [NeoSourceAnaliser]
	m_iEnableSourceAnalizer = file->PartPrefs.m_iEnableSourceAnalizer;

	m_iDontStoreTemporarySources = file->PartPrefs.m_iDontStoreTemporarySources;

	m_iPropabilityMode = file->PartPrefs.m_iPropabilityMode;
	m_fEnhancedFactor = file->PartPrefs.m_fEnhancedFactor;

	m_iReaskPropability = file->PartPrefs.m_iReaskPropability;
	m_iReservePropability = file->PartPrefs.m_iReservePropability;

	m_iAutoReserveReask = file->PartPrefs.m_iAutoReserveReask;
	m_iReserveReaskPropability = file->PartPrefs.m_iReserveReaskPropability;
	m_iUseReaskReserveSourcesDelay = file->PartPrefs.m_iUseReaskReserveSourcesDelay;
	m_iReaskReserveSourcesDelay = file->PartPrefs.m_iReaskReserveSourcesDelay;
	m_iReaskReserveSourcesLimit = file->PartPrefs.m_iReaskReserveSourcesLimit;

	m_iAutoTemporaryReask = file->PartPrefs.m_iAutoTemporaryReask;
	m_iTemporaryReaskPropability = file->PartPrefs.m_iTemporaryReaskPropability;
	m_iUseReaskTemporarySourcesDelay = file->PartPrefs.m_iUseReaskTemporarySourcesDelay;
	m_iReaskTemporarySourcesDelay = file->PartPrefs.m_iReaskTemporarySourcesDelay;
	m_iReaskTemporarySourcesLimit = file->PartPrefs.m_iReaskTemporarySourcesLimit;

	//m_iMinAnalisisQuality = file->PartPrefs.m_iMinAnalisisQuality;

	//m_iAutoUnsureReask = file->PartPrefs.m_iAutoUnsureReask;
	//m_iUseReaskUnsureSourcesDelay = file->PartPrefs.m_iUseReaskUnsureSourcesDelay;
	//m_iReaskUnsureSourcesDelay = file->PartPrefs.m_iReaskUnsureSourcesDelay;
	//m_iReaskUnsureSourcesLimit = file->PartPrefs.m_iReaskUnsureSourcesLimit;

	m_iUseUnpredictedPropability = file->PartPrefs.m_iUseUnpredictedPropability;
	m_iUnpredictedPropability = file->PartPrefs.m_iUnpredictedPropability;
	m_iUseReaskUnpredictedSourcesDelay = file->PartPrefs.m_iUseReaskUnpredictedSourcesDelay;
	m_iReaskUnpredictedSourcesDelay = file->PartPrefs.m_iReaskUnpredictedSourcesDelay;
	m_iReaskUnpredictedSourcesLimit = file->PartPrefs.m_iReaskUnpredictedSourcesLimit;

	m_iFailTolerance = file->PartPrefs.m_iFailTolerance;
	m_iMaxFailTolerance = file->PartPrefs.m_iMaxFailTolerance;
	m_iRetryUnreachable = file->PartPrefs.m_iRetryUnreachable;
	m_iRetryUnreachableIntervals = file->PartPrefs.m_iRetryUnreachableIntervals;
	m_iUnreachableReaskPropability = file->PartPrefs.m_iUnreachableReaskPropability;
	m_iReaskUnreachableSourcesLimit = file->PartPrefs.m_iReaskUnreachableSourcesLimit;
#endif // NEO_SA // NEO: NSA END

	// NEO: NSD - [NeoSourceDrop]
#ifdef NEO_SK // NEO: NSK - [NeoSourceKeeper]
	m_iDropUnreachable = file->PartPrefs.m_iDropUnreachable;
	m_iDropUnreachableLimit = file->PartPrefs.m_iDropUnreachableLimit;
	m_iDropUnreachableLimitMode = file->PartPrefs.m_iDropUnreachableLimitMode;
	m_iDropUnreachableTimer = file->PartPrefs.m_iDropUnreachableTimer;
#endif // NEO_SK // NEO: NSK END
#ifdef NEO_SS // NEO: NSS - [NeoSourceStorage]
	m_iDropOutOfDate = file->PartPrefs.m_iDropOutOfDate;
	m_iDropOutOfDateLimit = file->PartPrefs.m_iDropOutOfDateLimit;
	m_iDropOutOfDateLimitMode = file->PartPrefs.m_iDropOutOfDateLimitMode;
	m_iDropOutOfDateTimer = file->PartPrefs.m_iDropOutOfDateTimer;
	m_iDropOutOfDateSmooth = file->PartPrefs.m_iDropOutOfDateSmooth;
	m_iDropOutOfDateFails = file->PartPrefs.m_iDropOutOfDateFails;
	m_iDropOutOfDateTime = file->PartPrefs.m_iDropOutOfDateTime;
#endif // NEO_SS // NEO: NSS END
#ifdef NEO_SA // NEO: NSA - [NeoSourceAnaliser]
	m_iDropLoaded = file->PartPrefs.m_iDropLoaded;
	m_iDropLoadedLimit = file->PartPrefs.m_iDropLoadedLimit;
	m_iDropLoadedLimitMode = file->PartPrefs.m_iDropLoadedLimitMode;
	m_iDropLoadedTimer = file->PartPrefs.m_iDropLoadedTimer;

	m_iDropRetired = file->PartPrefs.m_iDropRetired;
	m_iDropRetiredLimit = file->PartPrefs.m_iDropRetiredLimit;
	m_iDropRetiredLimitMode = file->PartPrefs.m_iDropRetiredLimitMode;
	m_iDropRetiredTimer = file->PartPrefs.m_iDropRetiredTimer;
#endif // NEO_SA // NEO: NSA END
	// NEO: NSD END

	for (int i = 1; i < m_paFiles->GetSize(); i++)
	{
		file = STATIC_DOWNCAST(CPartFile, (*m_paFiles)[i]);

#ifdef NEO_SK // NEO: NSK - [NeoSourceKeeper]
		if(file->PartPrefs.m_iEnableSourceKeeper != m_iEnableSourceKeeper) m_iEnableSourceKeeper = -1;
#endif // NEO_SK // NEO: NSK END
#ifdef NEO_SS // NEO: NSS - [NeoSourceStorage]
		if(m_iEnableSourceStorage != file->PartPrefs.m_iEnableSourceStorage) m_iEnableSourceStorage = -1;
		if(m_iAutoSaveSources != file->PartPrefs.m_iAutoSaveSources) m_iAutoSaveSources = -1;
		if(m_iAutoSaveSourcesIntervals != file->PartPrefs.m_iAutoSaveSourcesIntervals) m_iAutoSaveSourcesIntervals = UN_INT;
		if(m_iSourceStorageLimit != file->PartPrefs.m_iSourceStorageLimit) m_iSourceStorageLimit = UN_INT;
		if(m_iStoreLowIDSources != file->PartPrefs.m_iStoreLowIDSources) m_iStoreLowIDSources = -1;
		if(m_iStoreAlsoA4AFSources != file->PartPrefs.m_iStoreAlsoA4AFSources) m_iStoreAlsoA4AFSources = -1;
		if(m_iStoreSourcesFileStatus != file->PartPrefs.m_iStoreSourcesFileStatus) m_iStoreSourcesFileStatus = -1;
		if(m_iAutoLoadStoredSources != file->PartPrefs.m_iAutoLoadStoredSources) m_iAutoLoadStoredSources = -1;
		if(m_iUseStorageBootstrap != file->PartPrefs.m_iUseStorageBootstrap) m_iUseStorageBootstrap = -1;
		if(m_iStorageBootstrapTime != file->PartPrefs.m_iStorageBootstrapTime) m_iStorageBootstrapTime = UN_INT;
		if(m_iStorageBootstrapRequirement != file->PartPrefs.m_iStorageBootstrapRequirement) m_iStorageBootstrapRequirement = UN_INT;

		if(m_iAutoReaskStoredSources != file->PartPrefs.m_iAutoReaskStoredSources) m_iAutoReaskStoredSources = -1;
		if(m_iAutoReaskStoredSourcesLimit != file->PartPrefs.m_iAutoReaskStoredSourcesLimit) m_iAutoReaskStoredSourcesLimit = UN_INT;
		if(file->PartPrefs.m_iTotalSourceRestore != m_iTotalSourceRestore) m_iTotalSourceRestore = -1;
		if(m_iUseAutoReaskStoredSourcesDelay != file->PartPrefs.m_iUseAutoReaskStoredSourcesDelay) m_iUseAutoReaskStoredSourcesDelay = -1;
		if(m_iAutoReaskStoredSourcesDelay != file->PartPrefs.m_iAutoReaskStoredSourcesDelay) m_iAutoReaskStoredSourcesDelay = UN_INT;

		if(m_iAutoReaskLoadedSourcesDelay != file->PartPrefs.m_iAutoReaskLoadedSourcesDelay) m_iAutoReaskLoadedSourcesDelay = UN_INT;

		if(m_iGroupStoredSourceReask != file->PartPrefs.m_iGroupStoredSourceReask) m_iGroupStoredSourceReask = -1;
		if(m_iStoredSourceGroupIntervals != file->PartPrefs.m_iStoredSourceGroupIntervals) m_iStoredSourceGroupIntervals = UN_INT;
		if(m_iStoredSourceGroupSize != file->PartPrefs.m_iStoredSourceGroupSize) m_iStoredSourceGroupSize = UN_INT;

		if(m_iUseSmoothOutOfDate != file->PartPrefs.m_iUseSmoothOutOfDate) m_iUseSmoothOutOfDate = -1;
		if(m_iMaxStoredFaildCount != file->PartPrefs.m_iMaxStoredFaildCount) m_iMaxStoredFaildCount = UN_INT;
		if(m_iStoredOutOfDate != file->PartPrefs.m_iStoredOutOfDate) m_iStoredOutOfDate = UN_INT;
#endif // NEO_SS // NEO: NSS END
#ifdef NEO_SA // NEO: NSA - [NeoSourceAnaliser]
		if(file->PartPrefs.m_iEnableSourceAnalizer != m_iEnableSourceAnalizer) m_iEnableSourceAnalizer = -1;

		if(file->PartPrefs.m_iDontStoreTemporarySources != m_iDontStoreTemporarySources) m_iDontStoreTemporarySources = -1;

		if(file->PartPrefs.m_iPropabilityMode != m_iPropabilityMode) m_iPropabilityMode = -1;
		if(file->PartPrefs.m_fEnhancedFactor != m_fEnhancedFactor) m_fEnhancedFactor = UN_FLOAT;

		if(file->PartPrefs.m_iReaskPropability != m_iReaskPropability) m_iReaskPropability = UN_INT;
		if(file->PartPrefs.m_iReservePropability != m_iReservePropability) m_iReservePropability = UN_INT;

		if(file->PartPrefs.m_iAutoReserveReask != m_iAutoReserveReask) m_iAutoReserveReask = -1;
		if(file->PartPrefs.m_iReserveReaskPropability != m_iReserveReaskPropability) m_iReserveReaskPropability = UN_INT;
		if(file->PartPrefs.m_iUseReaskReserveSourcesDelay != m_iUseReaskReserveSourcesDelay) m_iUseReaskReserveSourcesDelay = -1;
		if(file->PartPrefs.m_iReaskReserveSourcesDelay != m_iReaskReserveSourcesDelay) m_iReaskReserveSourcesDelay = UN_INT;
		if(file->PartPrefs.m_iReaskReserveSourcesLimit != m_iReaskReserveSourcesLimit) m_iReaskReserveSourcesLimit = UN_INT;

		if(file->PartPrefs.m_iAutoTemporaryReask != m_iAutoTemporaryReask) m_iAutoTemporaryReask = -1;
		if(file->PartPrefs.m_iTemporaryReaskPropability != m_iTemporaryReaskPropability) m_iTemporaryReaskPropability = UN_INT;
		if(file->PartPrefs.m_iUseReaskTemporarySourcesDelay != m_iUseReaskTemporarySourcesDelay) m_iUseReaskTemporarySourcesDelay = -1;
		if(file->PartPrefs.m_iReaskTemporarySourcesDelay != m_iReaskTemporarySourcesDelay) m_iReaskTemporarySourcesDelay = UN_INT;
		if(file->PartPrefs.m_iReaskTemporarySourcesLimit != m_iReaskTemporarySourcesLimit) m_iReaskTemporarySourcesLimit = UN_INT;

		//if(file->PartPrefs.m_iMinAnalisisQuality != m_iMinAnalisisQuality) m_iMinAnalisisQuality = UN_INT;

		//if(file->PartPrefs.m_iAutoUnsureReask != m_iAutoUnsureReask) m_iAutoUnsureReask = -1;
		//if(file->PartPrefs.m_iUseReaskUnsureSourcesDelay != m_iUseReaskUnsureSourcesDelay) m_iUseReaskUnsureSourcesDelay = -1;
		//if(file->PartPrefs.m_iReaskUnsureSourcesDelay != m_iReaskUnsureSourcesDelay) m_iReaskUnsureSourcesDelay = UN_INT;
		//if(file->PartPrefs.m_iReaskUnsureSourcesLimit != m_iReaskUnsureSourcesLimit) m_iReaskUnsureSourcesLimit = UN_INT;

		if(file->PartPrefs.m_iUseUnpredictedPropability != m_iUseUnpredictedPropability) m_iUseUnpredictedPropability = -1;
		if(file->PartPrefs.m_iUnpredictedPropability != m_iUnpredictedPropability) m_iUnpredictedPropability = UN_INT;
		if(file->PartPrefs.m_iUseReaskUnpredictedSourcesDelay != m_iUseReaskUnpredictedSourcesDelay) m_iUseReaskUnpredictedSourcesDelay = -1;
		if(file->PartPrefs.m_iReaskUnpredictedSourcesDelay != m_iReaskUnpredictedSourcesDelay) m_iReaskUnpredictedSourcesDelay = UN_INT;
		if(file->PartPrefs.m_iReaskUnpredictedSourcesLimit != m_iReaskUnpredictedSourcesLimit) m_iReaskUnpredictedSourcesLimit = UN_INT;

		if(file->PartPrefs.m_iFailTolerance != m_iFailTolerance) m_iFailTolerance = -1;
		if(file->PartPrefs.m_iMaxFailTolerance != m_iMaxFailTolerance) m_iMaxFailTolerance = UN_INT;
		if(file->PartPrefs.m_iRetryUnreachable != m_iRetryUnreachable) m_iRetryUnreachable = -1;
		if(file->PartPrefs.m_iRetryUnreachableIntervals != m_iRetryUnreachableIntervals) m_iRetryUnreachableIntervals = UN_INT;
		if(file->PartPrefs.m_iUnreachableReaskPropability != m_iUnreachableReaskPropability) m_iUnreachableReaskPropability = UN_INT;
		if(file->PartPrefs.m_iReaskUnreachableSourcesLimit != m_iReaskUnreachableSourcesLimit) m_iReaskUnreachableSourcesLimit = UN_INT;
#endif // NEO_SA // NEO: NSA END

		// NEO: NSD - [NeoSourceDrop]
#ifdef NEO_SK // NEO: NSK - [NeoSourceKeeper]
		if(m_iDropUnreachable != file->PartPrefs.m_iDropUnreachable) m_iDropUnreachable = -1;
		if(m_iDropUnreachableLimit != file->PartPrefs.m_iDropUnreachableLimit) m_iDropUnreachableLimit = UN_INT;
		if(m_iDropUnreachableLimitMode != file->PartPrefs.m_iDropUnreachableLimitMode) m_iDropUnreachableLimitMode = -1;
		if(m_iDropUnreachableTimer != file->PartPrefs.m_iDropUnreachableTimer) m_iDropUnreachableTimer = UN_INT;
#endif // NEO_SK // NEO: NSK END
#ifdef NEO_SS // NEO: NSS - [NeoSourceStorage]
		if(m_iDropOutOfDate != file->PartPrefs.m_iDropOutOfDate) m_iDropOutOfDate = -1;
		if(m_iDropOutOfDateLimit != file->PartPrefs.m_iDropOutOfDateLimit) m_iDropOutOfDateLimit = UN_INT;
		if(m_iDropOutOfDateLimitMode != file->PartPrefs.m_iDropOutOfDateLimitMode) m_iDropOutOfDateLimitMode = -1;
		if(m_iDropOutOfDateTimer != file->PartPrefs.m_iDropOutOfDateTimer) m_iDropOutOfDateTimer = UN_INT;
		if(m_iDropOutOfDateSmooth != file->PartPrefs.m_iDropOutOfDateSmooth) m_iDropOutOfDateSmooth = -1;
		if(m_iDropOutOfDateFails != file->PartPrefs.m_iDropOutOfDateFails) m_iDropOutOfDateFails = UN_INT;
		if(m_iDropOutOfDateTime != file->PartPrefs.m_iDropOutOfDateTime) m_iDropOutOfDateTime = UN_INT;
#endif // NEO_SS // NEO: NSS END
#ifdef NEO_SA // NEO: NSA - [NeoSourceAnaliser]
		if(m_iDropRetired != file->PartPrefs.m_iDropRetired) m_iDropRetired = -1;
		if(m_iDropRetiredLimit != file->PartPrefs.m_iDropRetiredLimit) m_iDropRetiredLimit = UN_INT;
		if(m_iDropRetiredLimitMode != file->PartPrefs.m_iDropRetiredLimitMode) m_iDropRetiredLimitMode = -1;
		if(m_iDropRetiredTimer != file->PartPrefs.m_iDropRetiredTimer) m_iDropRetiredTimer = UN_INT;

		if(m_iDropLoaded != file->PartPrefs.m_iDropLoaded) m_iDropLoaded = -1;
		if(m_iDropLoadedLimit != file->PartPrefs.m_iDropLoadedLimit) m_iDropLoadedLimit = UN_INT;
		if(m_iDropLoadedLimitMode != file->PartPrefs.m_iDropLoadedLimitMode) m_iDropLoadedLimitMode = -1;
		if(m_iDropLoadedTimer != file->PartPrefs.m_iDropLoadedTimer) m_iDropLoadedTimer = UN_INT;
#endif // NEO_SA // NEO: NSA END
		// NEO: NSD END
	}

#ifdef NEO_SS // NEO: NSS - [NeoSourceStorage]
	if(!m_iAutoSaveSourcesIntervals)
		m_iAutoSaveSourcesIntervals = thePrefs.GetAutoSaveSourcesIntervals();
	else if(m_iAutoSaveSourcesIntervals == UN_INT)
		m_iAutoSaveSourcesIntervals = 0;

	if(!m_iSourceStorageLimit)
		m_iSourceStorageLimit = thePrefs.GetSourceStorageLimit();
	else if(m_iSourceStorageLimit == UN_INT)
		m_iSourceStorageLimit = 0;

	if(!m_iStorageBootstrapTime)
		m_iStorageBootstrapTime = thePrefs.GetStorageBootstrapTime();
	else if(m_iStorageBootstrapTime == UN_INT)
		m_iStorageBootstrapTime = 0;

	if(!m_iStorageBootstrapRequirement)
		m_iStorageBootstrapRequirement = thePrefs.GetStorageBootstrapRequirement();
	else if(m_iStorageBootstrapRequirement == UN_INT)
		m_iStorageBootstrapRequirement = 0;

	if(!m_iAutoReaskStoredSourcesLimit)
		m_iAutoReaskStoredSourcesLimit = thePrefs.GetAutoReaskStoredSourcesLimit();
	else if(m_iAutoReaskStoredSourcesLimit == UN_INT)
		m_iAutoReaskStoredSourcesLimit = 0;

	if(!m_iAutoReaskStoredSourcesDelay)
		m_iAutoReaskStoredSourcesDelay = thePrefs.GetAutoReaskStoredSourcesDelay();
	else if(m_iAutoReaskStoredSourcesDelay == UN_INT)
		m_iAutoReaskStoredSourcesDelay = 0;

	if(!m_iAutoReaskLoadedSourcesDelay)
		m_iAutoReaskLoadedSourcesDelay = thePrefs.GetAutoReaskLoadedSourcesDelay();
	else if(m_iAutoReaskLoadedSourcesDelay == UN_INT)
		m_iAutoReaskLoadedSourcesDelay = 0;

	if(!m_iStoredSourceGroupIntervals)
		m_iStoredSourceGroupIntervals = thePrefs.GetStoredSourceGroupIntervals();
	else if(m_iStoredSourceGroupIntervals == UN_INT)
		m_iStoredSourceGroupIntervals = 0;

	if(!m_iStoredSourceGroupSize)
		m_iStoredSourceGroupSize = thePrefs.GetStoredSourceGroupSize();
	else if(m_iStoredSourceGroupSize == UN_INT)
		m_iStoredSourceGroupSize = 0;

	if(!m_iMaxStoredFaildCount)
		m_iMaxStoredFaildCount = thePrefs.GetMaxStoredFaildCount();
	else if(m_iMaxStoredFaildCount == UN_INT)
		m_iMaxStoredFaildCount = 0;

	if(!m_iStoredOutOfDate)
		m_iStoredOutOfDate = thePrefs.GetStoredOutOfDate();
	else if(m_iStoredOutOfDate == UN_INT)
		m_iStoredOutOfDate = 0;
#endif // NEO_SS // NEO: NSS END
#ifdef NEO_SA // NEO: NSA - [NeoSourceAnaliser]
	if(!m_fEnhancedFactor)
		m_fEnhancedFactor = thePrefs.GetEnhancedFactor();
	else if(m_fEnhancedFactor == UN_FLOAT)
		m_fEnhancedFactor = 0;

	if(!m_iReaskPropability)
		m_iReaskPropability = thePrefs.GetReaskPropability();
	else if(m_iReaskPropability == UN_INT)
		m_iReaskPropability = 0;

	if(!m_iReservePropability)
		m_iReservePropability = thePrefs.GetReservePropability();
	else if(m_iReservePropability == UN_INT)
		m_iReservePropability = 0;


	if(!m_iReserveReaskPropability)
		m_iReserveReaskPropability = thePrefs.GetReserveReaskPropability();
	else if(m_iReserveReaskPropability == UN_INT)
		m_iReserveReaskPropability = 0;

	if(!m_iReaskReserveSourcesDelay)
		m_iReaskReserveSourcesDelay = thePrefs.GetReaskReserveSourcesDelay();
	else if(m_iReaskReserveSourcesDelay == UN_INT)
		m_iReaskReserveSourcesDelay = 0;

	if(!m_iReaskReserveSourcesLimit)
		m_iReaskReserveSourcesLimit = thePrefs.GetReaskReserveSourcesLimit();
	else if(m_iReaskReserveSourcesLimit == UN_INT)
		m_iReaskReserveSourcesLimit = 0;


	if(!m_iTemporaryReaskPropability)
		m_iTemporaryReaskPropability = thePrefs.GetTemporaryReaskPropability();
	else if(m_iTemporaryReaskPropability == UN_INT)
		m_iTemporaryReaskPropability = 0;

	if(!m_iReaskTemporarySourcesDelay)
		m_iReaskTemporarySourcesDelay = thePrefs.GetReaskTemporarySourcesDelay();
	else if(m_iReaskTemporarySourcesDelay == UN_INT)
		m_iReaskTemporarySourcesDelay = 0;

	if(!m_iReaskTemporarySourcesLimit)
		m_iReaskTemporarySourcesLimit = thePrefs.GetReaskTemporarySourcesLimit();
	else if(m_iReaskTemporarySourcesLimit == UN_INT)
		m_iReaskTemporarySourcesLimit = 0;


	//if(!m_iMinAnalisisQuality)
	//	m_iMinAnalisisQuality = thePrefs.GetMinAnalisisQuality();
	//else if(m_iMinAnalisisQuality == UN_INT)
	//	m_iMinAnalisisQuality = 0;


	//if(!m_iReaskUnsureSourcesDelay)
	//	m_iReaskUnsureSourcesDelay = thePrefs.GetReaskUnsureSourcesDelay();
	//else if(m_iReaskUnsureSourcesDelay == UN_INT)
	//	m_iReaskUnsureSourcesDelay = 0;

	//if(!m_iReaskUnsureSourcesLimit)
	//	m_iReaskUnsureSourcesLimit = thePrefs.GetReaskUnsureSourcesLimit();
	//else if(m_iReaskUnsureSourcesLimit == UN_INT)
	//	m_iReaskUnsureSourcesLimit = 0;


	if(!m_iUnpredictedPropability)
		m_iUnpredictedPropability = thePrefs.GetUnpredictedPropability();
	else if(m_iUnpredictedPropability == UN_INT)
		m_iUnpredictedPropability = 0;

	if(!m_iReaskUnpredictedSourcesDelay)
		m_iReaskUnpredictedSourcesDelay = thePrefs.GetReaskUnpredictedSourcesDelay();
	else if(m_iReaskUnpredictedSourcesDelay == UN_INT)
		m_iReaskUnpredictedSourcesDelay = 0;

	if(!m_iReaskUnpredictedSourcesLimit)
		m_iReaskUnpredictedSourcesLimit = thePrefs.GetReaskUnpredictedSourcesLimit();
	else if(m_iReaskUnpredictedSourcesLimit == UN_INT)
		m_iReaskUnpredictedSourcesLimit = 0;

	if(!m_iMaxFailTolerance)
		m_iMaxFailTolerance = thePrefs.GetMaxFailTolerance();
	else if(m_iMaxFailTolerance == UN_INT)
		m_iMaxFailTolerance = 0;

	if(!m_iRetryUnreachableIntervals)
		m_iRetryUnreachableIntervals = thePrefs.GetRetryUnreachableIntervals();
	else if(m_iRetryUnreachableIntervals == UN_INT)
		m_iRetryUnreachableIntervals = 0;

	if(!m_iUnreachableReaskPropability)
		m_iUnreachableReaskPropability = thePrefs.GetUnreachableReaskPropability();
	else if(m_iUnreachableReaskPropability == UN_INT)
		m_iUnreachableReaskPropability = 0;

	if(!m_iReaskUnreachableSourcesLimit)
		m_iReaskUnreachableSourcesLimit = thePrefs.GetReaskUnreachableSourcesLimit();
	else if(m_iReaskUnreachableSourcesLimit == UN_INT)
		m_iReaskUnreachableSourcesLimit = 0;
#endif // NEO_SA // NEO: NSA END

		// NEO: NSD - [NeoSourceDrop]
#ifdef NEO_SK // NEO: NSK - [NeoSourceKeeper]
	if(!m_iDropUnreachableLimit)
		m_iDropUnreachableLimit = thePrefs.GetDropUnreachableLimit();
	else if(m_iDropUnreachableLimit == UN_INT)
		m_iDropUnreachableLimit = 0;

	if(!m_iDropUnreachableTimer)
		m_iDropUnreachableTimer = thePrefs.GetDropUnreachableTimer();
	else if(m_iDropUnreachableTimer == UN_INT)
		m_iDropUnreachableTimer = 0;
#endif // NEO_SK // NEO: NSK END
#ifdef NEO_SS // NEO: NSS - [NeoSourceStorage]
	if(!m_iDropOutOfDateLimit)
		m_iDropOutOfDateLimit = thePrefs.GetDropOutOfDateLimit();
	else if(m_iDropOutOfDateLimit == UN_INT)
		m_iDropOutOfDateLimit = 0;

	if(!m_iDropOutOfDateTimer)
		m_iDropOutOfDateTimer = thePrefs.GetDropOutOfDateTimer();
	else if(m_iDropOutOfDateTimer == UN_INT)
		m_iDropOutOfDateTimer = 0;

	if(!m_iDropOutOfDateFails)
		m_iDropOutOfDateFails = thePrefs.GetDropOutOfDateFails();
	else if(m_iDropOutOfDateFails == UN_INT)
		m_iDropOutOfDateFails = 0;

	if(!m_iDropOutOfDateTime)
		m_iDropOutOfDateTime = thePrefs.GetDropOutOfDateTime();
	else if(m_iDropOutOfDateTime == UN_INT)
		m_iDropOutOfDateTime = 0;
#endif // NEO_SS // NEO: NSS END
#ifdef NEO_SA // NEO: NSA - [NeoSourceAnaliser]
	if(!m_iDropRetiredLimit)
		m_iDropRetiredLimit = thePrefs.GetDropRetiredLimit();
	else if(m_iDropRetiredLimit == UN_INT)
		m_iDropRetiredLimit = 0;

	if(!m_iDropRetiredTimer)
		m_iDropRetiredTimer = thePrefs.GetDropRetiredTimer();
	else if(m_iDropRetiredTimer == UN_INT)
		m_iDropRetiredTimer = 0;

	if(!m_iDropLoadedLimit)
		m_iDropLoadedLimit = thePrefs.GetDropLoadedLimit();
	else if(m_iDropLoadedLimit == UN_INT)
		m_iDropLoadedLimit = 0;

	if(!m_iDropLoadedTimer)
		m_iDropLoadedTimer = thePrefs.GetDropLoadedTimer();
	else if(m_iDropLoadedTimer == UN_INT)
		m_iDropLoadedTimer = 0;
#endif // NEO_SA // NEO: NSA END
		// NEO: NSD END

	UpdateData(FALSE);

}

void CPPgSourceStorage::OnTimer(UINT /*nIDEvent*/)
{
	if (m_bDataChanged)
	{
		RefreshData();
		m_bDataChanged = false;
	}
}

BOOL CPPgSourceStorage::OnSetActive()
{
	if (!CPropertyPage::OnSetActive())
		return FALSE;
	if (m_bDataChanged)
	{
		RefreshData();
		m_bDataChanged = false;
	}
	return TRUE;
}

LRESULT CPPgSourceStorage::OnDataChanged(WPARAM, LPARAM)
{
	m_bDataChanged = true;
	return 1;
}
// NEO: FCFG END

void CPPgSourceStorage::OnDestroy()
{
	// NEO: FCFG - [FileConfiguration]
	if (m_timer){
		KillTimer(m_timer);
		m_timer = 0;
	}
	// NEO: FCFG END

	m_ctrlTreeOptions.DeleteAllItems();
	m_ctrlTreeOptions.DestroyWindow();
	ClearAllMembers();
	CPropertyPage::OnDestroy();
}

/*void CPPgSourceStorage::Localize()
{
}*/

BOOL CPPgSourceStorage::OnKillActive()
{
	// if prop page is closed by pressing ENTER we have to explicitly commit any possibly pending
	// data from an open edit control
	m_ctrlTreeOptions.HandleChildControlLosingFocus();
	return CPropertyPage::OnKillActive();
}

LRESULT CPPgSourceStorage::OnTreeOptsCtrlNotify(WPARAM wParam, LPARAM lParam)
{
	if(!IsWindowVisible())
		return 0;

	if (wParam == IDC_MOD_OPTS){
		TREEOPTSCTRLNOTIFY* pton = (TREEOPTSCTRLNOTIFY*)lParam;
		if(pton->nmhdr.code == EN_KILLFOCUS){
			
#ifdef NEO_SS // NEO: NSS - [NeoSourceStorage]
			if(m_htiAutoSaveSources && pton->hItem == m_htiAutoSaveSources){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiAutoSaveSources, TIM_AUTO_SAVE_SOURCES_INTERVALS_MIN, ForFile() ? thePrefs.GetAutoSaveSourcesIntervals() : TIM_AUTO_SAVE_SOURCES_INTERVALS_DEF, TIM_AUTO_SAVE_SOURCES_INTERVALS_MAX)) SetModified();
			} else
			if(m_htiSourceStorageLimit && pton->hItem == m_htiSourceStorageLimit){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiSourceStorageLimit, SOURCE_STORAGE_LIMIT_MIN, ForFile() ? thePrefs.GetSourceStorageLimit() : SOURCE_STORAGE_LIMIT_DEF, SOURCE_STORAGE_LIMIT_MAX)) SetModified();
			} else
			if(m_htiStorageBootstrapTime && pton->hItem == m_htiStorageBootstrapTime){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiStorageBootstrapTime, STORAGE_BOOTSTRAP_TIME_MIN, ForFile() ? thePrefs.GetStorageBootstrapTime() : STORAGE_BOOTSTRAP_TIME_DEF, STORAGE_BOOTSTRAP_TIME_MAX)) SetModified();
			} else
			if(m_htiStorageBootstrapRequirement && pton->hItem == m_htiStorageBootstrapRequirement){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiStorageBootstrapRequirement, STORAGE_BOOTSTRAP_REQUIREMENT_MIN, ForFile() ? thePrefs.GetStorageBootstrapRequirement() : STORAGE_BOOTSTRAP_REQUIREMENT_DEF, STORAGE_BOOTSTRAP_REQUIREMENT_MAX)) SetModified();
			} else
				if(m_htiAutoReaskStoredSourcesLimit && pton->hItem == m_htiAutoReaskStoredSourcesLimit){
					if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiAutoReaskStoredSourcesLimit, AUTO_REASK_STORED_SOURCES_LIMIT_MIN, ForFile() ? thePrefs.GetAutoReaskStoredSourcesLimit() : AUTO_REASK_STORED_SOURCES_LIMIT_DEF, AUTO_REASK_STORED_SOURCES_LIMIT_MAX)) SetModified();
				} else
				if(m_htiAutoReaskStoredSourcesDelay && pton->hItem == m_htiAutoReaskStoredSourcesDelay){
					if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiAutoReaskStoredSourcesDelay, AUTO_REASK_STORED_SOURCES_DELAY_MIN, ForFile() ? thePrefs.GetAutoReaskStoredSourcesDelay() : AUTO_REASK_STORED_SOURCES_DELAY_DEF, AUTO_REASK_STORED_SOURCES_DELAY_MAX)) SetModified();
				} else
				if(m_htiAutoReaskLoadedSourcesDelay && pton->hItem == m_htiAutoReaskLoadedSourcesDelay){
					if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiAutoReaskLoadedSourcesDelay, AUTO_REASK_LOADED_SOURCES_DELAY_MIN, ForFile() ? thePrefs.GetAutoReaskLoadedSourcesDelay() : AUTO_REASK_LOADED_SOURCES_DELAY_DEF, AUTO_REASK_LOADED_SOURCES_DELAY_MAX)) SetModified();
				} else
					if(m_htiStoredSourceGroupIntervals && pton->hItem == m_htiStoredSourceGroupIntervals){
						if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiStoredSourceGroupIntervals, GROUP_INTERVALS_MIN, ForFile() ? thePrefs.GetStoredSourceGroupIntervals() : GROUP_INTERVALS_DEF, GROUP_INTERVALS_MAX)) SetModified();
					} else
					if(m_htiStoredSourceGroupSize && pton->hItem == m_htiStoredSourceGroupSize){
						if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiStoredSourceGroupSize, GROUP_SIZE_MIN, ForFile() ? thePrefs.GetStoredSourceGroupSize() : GROUP_SIZE_DEF, GROUP_SIZE_MAX)) SetModified();
					} else
				if(m_htiMaxStoredFaildCount && pton->hItem == m_htiMaxStoredFaildCount){
					if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiMaxStoredFaildCount, OUTOFDATE_MAXFAILS_MIN, ForFile() ? thePrefs.GetMaxStoredFaildCount() : OUTOFDATE_MAXFAILS_DEF, OUTOFDATE_MAXFAILS_MAX)) SetModified();
				} else
				if(m_htiStoredOutOfDate && pton->hItem == m_htiStoredOutOfDate){
					if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiStoredOutOfDate, OUTOFDATE_MAXTIME_MIN, ForFile() ? thePrefs.GetStoredOutOfDate() : OUTOFDATE_MAXTIME_DEF, OUTOFDATE_MAXTIME_MAX)) SetModified();
				}else
#endif // NEO_SS // NEO: NSS END
#ifdef NEO_CD // NEO: NCD - [NeoClientDatabase]
				if(m_htiGlobalSourceListCleanUpTime && pton->hItem == m_htiGlobalSourceListCleanUpTime){
					if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiGlobalSourceListCleanUpTime, TIM_GLOBAL_SOURCE_LIST_CLEAN_UP_TIME_MIN, TIM_GLOBAL_SOURCE_LIST_CLEAN_UP_TIME_DEF, TIM_GLOBAL_SOURCE_LIST_CLEAN_UP_TIME_MAX)) SetModified();
				} else
				if(m_htiGlobalSourceListCleanUp && pton->hItem == m_htiGlobalSourceListCleanUp){
					if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiGlobalSourceListCleanUp, TIM_GLOBAL_SOURCE_LIST_CLEAN_UP_INTERVALS_MIN, TIM_GLOBAL_SOURCE_LIST_CLEAN_UP_INTERVALS_DEF, TIM_GLOBAL_SOURCE_LIST_CLEAN_UP_INTERVALS_MAX)) SetModified();
				} else
				if(m_htiSourceFileListCleanUpTime && pton->hItem == m_htiSourceFileListCleanUpTime){
					if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiSourceFileListCleanUpTime, TIM_SOURCE_FILE_LIST_CLEAN_UP_TIME_MIN, TIM_SOURCE_FILE_LIST_CLEAN_UP_TIME_DEF, TIM_SOURCE_FILE_LIST_CLEAN_UP_TIME_MAX)) SetModified();
				} else
				if(m_htiSourceHashMonitorBadTime && pton->hItem == m_htiSourceHashMonitorBadTime){
					if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiSourceHashMonitorBadTime, TIM_SOURCE_HASH_MONITOR_BAD_TIME_MIN, TIM_SOURCE_HASH_MONITOR_BAD_TIME_DEF, TIM_SOURCE_HASH_MONITOR_BAD_TIME_MAX)) SetModified();
				} else
				if(m_htiSourceHashMonitorMaxBad && pton->hItem == m_htiSourceHashMonitorMaxBad){
					if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiSourceHashMonitorMaxBad, SOURCE_HASH_MONITOR_MAX_BAD_MIN, SOURCE_HASH_MONITOR_MAX_BAD_DEF, SOURCE_HASH_MONITOR_MAX_BAD_MAX)) SetModified();
				} else
				if(m_htiTableAmountToStore && pton->hItem == m_htiTableAmountToStore){
					if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiTableAmountToStore, TABLE_AMOUT_TO_STORE_MIN, TABLE_AMOUT_TO_STORE_DEF, TABLE_AMOUT_TO_STORE_MAX)) SetModified();
				} else
				if(m_htiIgnoreUnreachableInterval && pton->hItem == m_htiIgnoreUnreachableInterval){
					if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiIgnoreUnreachableInterval, IGNORE_UNREACHABLE_INTERVAL_MIN, IGNORE_UNREACHABLE_INTERVAL_DEF, IGNORE_UNREACHABLE_INTERVAL_MAX)) SetModified();
				} else
				if(m_htiIgnoreUndefinedInterval && pton->hItem == m_htiIgnoreUndefinedInterval){
					if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiIgnoreUndefinedInterval, IGNORE_UNDEFINED_INTERVAL_MIN, IGNORE_UNDEFINED_INTERVAL_DEF, IGNORE_UNDEFINED_INTERVAL_MAX)) SetModified();
				} else
				if(m_htiBeginNewTableInterval && pton->hItem == m_htiBeginNewTableInterval){
					if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiBeginNewTableInterval, BEGIN_NEW_TABLE_INTERVAL_MIN, BEGIN_NEW_TABLE_INTERVAL_DEF, BEGIN_NEW_TABLE_INTERVAL_MAX)) SetModified();
				} else
#endif // NEO_CD // NEO: NCD END
#ifdef NEO_SA // NEO: NSA - [NeoSourceAnaliser]
				if(m_htiAnaliseIntervals && pton->hItem == m_htiAnaliseIntervals){
					if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiAnaliseIntervals, ANALISIS_INTERVALS_MIN, ANALISIS_INTERVALS_DEF, ANALISIS_INTERVALS_MAX)) SetModified();
				} else
				if(m_htiTableAmountToAnalise && pton->hItem == m_htiTableAmountToAnalise){
					if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiTableAmountToAnalise, TABLE_AMOUT_TO_ANALISE_MIN, TABLE_AMOUT_TO_ANALISE_DEF, TABLE_AMOUT_TO_ANALISE_MAX)) SetModified();
				} else
				if(m_htiReaskPropability && pton->hItem == m_htiReaskPropability){
					if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiReaskPropability, REASK_PROPABILITY_MIN, ForFile() ? thePrefs.GetReaskPropability() : REASK_PROPABILITY_DEF, REASK_PROPABILITY_MAX)) SetModified();
				}else
				if(m_htiPropabilityModeEnhanced && pton->hItem == m_htiPropabilityModeEnhanced){
					if(CheckTreeEditLimitF(m_ctrlTreeOptions, m_htiPropabilityModeEnhanced, VAL_ENHANCED_FACTOR_MIN, ForFile() ? thePrefs.GetEnhancedFactor() : VAL_ENHANCED_FACTOR_DEF, VAL_ENHANCED_FACTOR_MAX)) SetModified();
				}else
				if(m_htiReservePropability && pton->hItem == m_htiReservePropability){
					if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiReservePropability, RESERVE_PROPABILITY_MIN, ForFile() ? thePrefs.GetReservePropability() : RESERVE_PROPABILITY_DEF, RESERVE_PROPABILITY_MAX)) SetModified();
				}else
					if(m_htiReserveReaskPropability && pton->hItem == m_htiReserveReaskPropability){
						if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiReserveReaskPropability, RESERVE_REASK_PROPABILITY_MIN, ForFile() ? thePrefs.GetReserveReaskPropability() : RESERVE_REASK_PROPABILITY_DEF, RESERVE_REASK_PROPABILITY_MAX)) SetModified();
					}else

					if(m_htiReaskReserveSourcesDelay && pton->hItem == m_htiReaskReserveSourcesDelay){
						if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiReaskReserveSourcesDelay, RESERVE_REASK_DELAY_MIN, ForFile() ? thePrefs.GetReaskReserveSourcesDelay() : RESERVE_REASK_DELAY_DEF, RESERVE_REASK_DELAY_MAX)) SetModified();
					}else
					if(m_htiReaskReserveSourcesLimit && pton->hItem == m_htiReaskReserveSourcesLimit){
						if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiReaskReserveSourcesLimit, RESERVE_REASK_LIMIT_MIN, ForFile() ? thePrefs.GetReaskReserveSourcesLimit() : RESERVE_REASK_LIMIT_DEF, RESERVE_REASK_LIMIT_MAX)) SetModified();
					}else

					if(m_htiTemporaryReaskPropability && pton->hItem == m_htiTemporaryReaskPropability){
						if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiTemporaryReaskPropability, TEMPORARY_REASK_PROPABILITY_MIN, ForFile() ? thePrefs.GetTemporaryReaskPropability() : TEMPORARY_REASK_PROPABILITY_DEF, TEMPORARY_REASK_PROPABILITY_MAX)) SetModified();
					}else
					if(m_htiReaskTemporarySourcesDelay && pton->hItem == m_htiReaskTemporarySourcesDelay){
						if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiReaskTemporarySourcesDelay, TEMPORARY_REASK_DELAY_MIN, ForFile() ? thePrefs.GetReaskTemporarySourcesDelay() : TEMPORARY_REASK_DELAY_DEF, TEMPORARY_REASK_DELAY_MAX)) SetModified();
					}else
					if(m_htiReaskTemporarySourcesLimit && pton->hItem == m_htiReaskTemporarySourcesLimit){
						if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiReaskTemporarySourcesLimit, TEMPORARY_REASK_LIMIT_MIN, ForFile() ? thePrefs.GetReaskTemporarySourcesLimit() : TEMPORARY_REASK_LIMIT_DEF, TEMPORARY_REASK_LIMIT_MAX)) SetModified();
					}else
					//if(m_htiMinAnalisisQuality && pton->hItem == m_htiMinAnalisisQuality){
					//	if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiMinAnalisisQuality, MIN_ANALISIS_QUALITY_MIN, ForFile() ? thePrefs.GetMinAnalisisQuality() : MIN_ANALISIS_QUALITY_DEF, MIN_ANALISIS_QUALITY_MAX)) SetModified();
					//}else
					//	if(m_htiReaskUnsureSourcesDelay && pton->hItem == m_htiReaskUnsureSourcesDelay){
					//		if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiReaskUnsureSourcesDelay, UNSURE_REASK_DELAY_MIN, ForFile() ? thePrefs.GetReaskUnsureSourcesDelay() : UNSURE_REASK_DELAY_DEF, UNSURE_REASK_DELAY_MAX)) SetModified();
					//	}else
					//	if(m_htiReaskUnsureSourcesLimit && pton->hItem == m_htiReaskUnsureSourcesLimit){
					//		if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiReaskUnsureSourcesLimit, UNSURE_REASK_LIMIT_MIN, ForFile() ? thePrefs.GetReaskUnsureSourcesLimit() : UNSURE_REASK_LIMIT_DEF, UNSURE_REASK_LIMIT_MAX)) SetModified();
					//	}else
					if(m_htiUnpredictedPropability && pton->hItem == m_htiUnpredictedPropability){
						if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiUnpredictedPropability, UNPREDICTED_PROPABILITY_MIN, ForFile() ? thePrefs.GetUnpredictedPropability() : UNPREDICTED_PROPABILITY_DEF, UNPREDICTED_PROPABILITY_MAX)) SetModified();
					}else
						if(m_htiReaskUnpredictedSourcesDelay && pton->hItem == m_htiReaskUnpredictedSourcesDelay){
							if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiReaskUnpredictedSourcesDelay, UNPREDICTED_REASK_DELAY_MIN, ForFile() ? thePrefs.GetReaskUnpredictedSourcesDelay() : UNPREDICTED_REASK_DELAY_DEF, UNPREDICTED_REASK_DELAY_MAX)) SetModified();
						}else
						if(m_htiReaskUnpredictedSourcesLimit && pton->hItem == m_htiReaskUnpredictedSourcesLimit){
							if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiReaskUnpredictedSourcesLimit, UNPREDICTED_REASK_LIMIT_MIN, ForFile() ? thePrefs.GetReaskUnpredictedSourcesLimit() : UNPREDICTED_REASK_LIMIT_DEF, UNPREDICTED_REASK_LIMIT_MAX)) SetModified();
						}else
					if(!ForFile() && m_htiFailTolerance && pton->hItem == m_htiFailTolerance){
						if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiFailTolerance, FAIL_TOLERANCE_MIN, FAIL_TOLERANCE_DEF, FAIL_TOLERANCE_MAX)) SetModified();
					}else
					if(ForFile() && m_htiFailToleranceValue && pton->hItem == m_htiFailToleranceValue){
						if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiFailToleranceValue, FAIL_TOLERANCE_MIN, thePrefs.GetMaxFailTolerance() , FAIL_TOLERANCE_MAX)) SetModified();
					}else
						if(!ForFile() && m_htiRetryUnreachable && pton->hItem == m_htiRetryUnreachable){
							if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiRetryUnreachable, RETRY_UNREAHABLE_INTERVALS_MIN, RETRY_UNREAHABLE_INTERVALS_DEF, RETRY_UNREAHABLE_INTERVALS_MAX)) SetModified();
						}else
						if(ForFile() && m_htiRetryUnreachableIntervals && pton->hItem == m_htiRetryUnreachableIntervals){
							if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiRetryUnreachableIntervals, RETRY_UNREAHABLE_INTERVALS_MIN, thePrefs.GetRetryUnreachableIntervals(), RETRY_UNREAHABLE_INTERVALS_MAX)) SetModified();
						}else
					if(m_htiUnreachableReaskPropability && pton->hItem == m_htiUnreachableReaskPropability){
						if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiUnreachableReaskPropability, UNREACHABLE_REASK_PROPABILITY_MIN, ForFile() ? thePrefs.GetUnreachableReaskPropability() : UNREACHABLE_REASK_PROPABILITY_DEF , UNREACHABLE_REASK_PROPABILITY_MAX)) SetModified();
					}else
					if(m_htiReaskUnreachableSourcesLimit && pton->hItem == m_htiReaskUnreachableSourcesLimit){
						if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiReaskUnreachableSourcesLimit, UNREACHABLE_REASK_LIMIT_MIN, ForFile() ? thePrefs.GetReaskUnreachableSourcesLimit() : UNREACHABLE_REASK_LIMIT_DEF , UNREACHABLE_REASK_LIMIT_MAX)) SetModified();
					}else

						if(m_htiPriorityGapRatio && pton->hItem == m_htiPriorityGapRatio){
							if(CheckTreeEditLimitF(m_ctrlTreeOptions, m_htiPriorityGapRatio, PRIORITY_GAP_RATIO_MIN, PRIORITY_GAP_RATIO_DEF, PRIORITY_GAP_RATIO_MAX)) SetModified();
						} else
						if(m_htiMaxGapSize && pton->hItem == m_htiMaxGapSize){
							if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiMaxGapSize, MAX_GAP_SIZE_MIN, MAX_GAP_SIZE_DEF, MAX_GAP_SIZE_MAX)) SetModified();
						} else
						if(m_htiMaxGapTime && pton->hItem == m_htiMaxGapTime){
							if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiMaxGapTime, MAX_GAP_TIME_MIN, MAX_GAP_TIME_DEF, MAX_GAP_TIME_MAX)) SetModified();
						} else
						if(m_htiCheckPriorityIP && pton->hItem == m_htiCheckPriorityIP){
							if(CheckTreeEditLimitF(m_ctrlTreeOptions, m_htiCheckPriorityIP, PRIORITY_IP_RATIO_MIN, PRIORITY_IP_RATIO_DEF, PRIORITY_IP_RATIO_MAX)) SetModified();
						} else
						if(m_htiCheckPortIntegrity && pton->hItem == m_htiCheckPortIntegrity){
							if(CheckTreeEditLimitF(m_ctrlTreeOptions, m_htiCheckPortIntegrity, PORT_INTEGRITY_RATIO_MIN, PORT_INTEGRITY_RATIO_DEF, PORT_INTEGRITY_RATIO_MAX)) SetModified();
						} else
					if(m_htiMaxMidleDiscrepanceHigh && pton->hItem == m_htiMaxMidleDiscrepanceHigh){
						if(CheckTreeEditLimitF(m_ctrlTreeOptions, m_htiMaxMidleDiscrepanceHigh, MAX_MIDLE_DISCREPANCE_HIGH_MIN, MAX_MIDLE_DISCREPANCE_HIGH_DEF, MAX_MIDLE_DISCREPANCE_HIGH_MAX)) SetModified();
					} else
					if(m_htiMaxMidleDiscrepanceLow && pton->hItem == m_htiMaxMidleDiscrepanceLow){
						if(CheckTreeEditLimitF(m_ctrlTreeOptions, m_htiMaxMidleDiscrepanceLow, MAX_MIDLE_DISCREPANCE_LOW_MIN, MAX_MIDLE_DISCREPANCE_LOW_DEF, MAX_MIDLE_DISCREPANCE_LOW_MAX)) SetModified();
					} else
					if(m_htiLastSeenDurationThreshold && pton->hItem == m_htiLastSeenDurationThreshold){
						if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiLastSeenDurationThreshold, LAST_SEEN_DURATION_THRESHOLD_MIN, LAST_SEEN_DURATION_THRESHOLD_DEF, LAST_SEEN_DURATION_THRESHOLD_MAX)) SetModified();
					} else
					if(m_htiLinkTimeThreshold && pton->hItem == m_htiLinkTimeThreshold){
						if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiLinkTimeThreshold, LINK_TIME_THRESHOLD_MIN, LINK_TIME_THRESHOLD_DEF, LINK_TIME_THRESHOLD_MAX)) SetModified();
					} else
					if(m_htiDualLinkedTableGravity && pton->hItem == m_htiDualLinkedTableGravity){
						if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiDualLinkedTableGravity, DUAL_LINKED_TABLE_GRAVITY_MIN, DUAL_LINKED_TABLE_GRAVITY_DEF, DUAL_LINKED_TABLE_GRAVITY_MAX)) SetModified();
					} else
					if(m_htiMaxReliableTime && pton->hItem == m_htiMaxReliableTime){
						if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiMaxReliableTime, MAX_RELIABLE_TIME_MIN, MAX_RELIABLE_TIME_DEF, MAX_RELIABLE_TIME_MAX)) SetModified();
					} else
					if(m_htiTempralIPBorderLine && pton->hItem == m_htiTempralIPBorderLine){
						if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiTempralIPBorderLine, TEMPORAL_IP_BORDERLINE_MIN, TEMPORAL_IP_BORDERLINE_DEF, TEMPORAL_IP_BORDERLINE_MAX)) SetModified();
					} else
#endif // NEO_SA // NEO: NSA END
	// NEO: NSD - [NeoSourceDrop]
#ifdef NEO_SK // NEO: NSK - [NeoSourceKeeper]
			if(m_htiDropUnreachableLimit && pton->hItem == m_htiDropUnreachableLimit){
				int m_iLimitMode; HTREEITEM hDummy;
				m_ctrlTreeOptions.GetRadioButton(m_htiDropUnreachableLimit,m_iLimitMode,hDummy);
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiDropUnreachableLimit, VAL_CLEAN_LIMIT_MIN(m_iLimitMode), (ForFile() && m_iLimitMode == thePrefs.m_iDropUnreachableLimitMode) ? thePrefs.GetDropUnreachableLimit() : VAL_CLEAN_LIMIT_DEF(m_iLimitMode), VAL_CLEAN_LIMIT_MAX(m_iLimitMode))) SetModified();
			} else
			if(m_htiDropUnreachableTimer && pton->hItem == m_htiDropUnreachableTimer){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiDropUnreachableTimer, TIM_DROP_MIN, ForFile() ? thePrefs.GetDropUnreachableTimer() : TIM_DROP_DEF, TIM_DROP_MAX)) SetModified();
			} else
#endif // NEO_SK // NEO: NSK END
#ifdef NEO_SS // NEO: NSS - [NeoSourceStorage]
			if(m_htiDropOutOfDateLimit && pton->hItem == m_htiDropOutOfDateLimit){
				int m_iLimitMode; HTREEITEM hDummy;
				m_ctrlTreeOptions.GetRadioButton(m_htiDropOutOfDateLimit,m_iLimitMode,hDummy);
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiDropOutOfDateLimit, VAL_CLEAN_LIMIT_MIN(m_iLimitMode), (ForFile() && m_iLimitMode == thePrefs.m_iDropOutOfDateLimitMode) ? thePrefs.GetDropOutOfDateLimit() : VAL_CLEAN_LIMIT_DEF(m_iLimitMode), VAL_CLEAN_LIMIT_MAX(m_iLimitMode))) SetModified();
			} else
			if(m_htiDropOutOfDateTimer && pton->hItem == m_htiDropOutOfDateTimer){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiDropOutOfDateTimer, TIM_DROP_MIN, ForFile() ? thePrefs.GetDropOutOfDateTimer() : TIM_DROP_DEF, TIM_DROP_MAX)) SetModified();
			}else

			if(m_htiDropOutOfDateFails && pton->hItem == m_htiDropOutOfDateFails){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiDropOutOfDateFails, OUTOFDATE_MAXFAILS_MIN, ForFile() ? thePrefs.GetDropOutOfDateFails() : OUTOFDATE_MAXFAILS_DEF, OUTOFDATE_MAXFAILS_MAX)) SetModified();
			} else
			if(m_htiDropOutOfDateTime && pton->hItem == m_htiDropOutOfDateTime){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiDropOutOfDateTime, OUTOFDATE_MAXTIME_MIN, ForFile() ? thePrefs.GetDropOutOfDateTime() : OUTOFDATE_MAXTIME_DEF, OUTOFDATE_MAXTIME_MAX)) SetModified();
			}else
#endif // NEO_SS // NEO: NSS END
#ifdef NEO_SA // NEO: NSA - [NeoSourceAnaliser]
			if(m_htiDropRetiredLimit && pton->hItem == m_htiDropRetiredLimit){
				int m_iLimitMode; HTREEITEM hDummy;
				m_ctrlTreeOptions.GetRadioButton(m_htiDropRetiredLimit,m_iLimitMode,hDummy);
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiDropRetiredLimit, VAL_CLEAN_LIMIT_MIN(m_iLimitMode), (ForFile() && m_iLimitMode == thePrefs.m_iDropRetiredLimitMode) ? thePrefs.GetDropRetiredLimit() : VAL_CLEAN_LIMIT_DEF(m_iLimitMode), VAL_CLEAN_LIMIT_MAX(m_iLimitMode))) SetModified();
			} else
			if(m_htiDropRetiredTimer && pton->hItem == m_htiDropRetiredTimer){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiDropRetiredTimer, TIM_DROP_MIN, ForFile() ? thePrefs.GetDropRetiredTimer() : TIM_DROP_DEF, TIM_DROP_MAX)) SetModified();
			}else

			if(m_htiDropLoadedLimit && pton->hItem == m_htiDropLoadedLimit){
				int m_iLimitMode; HTREEITEM hDummy;
				m_ctrlTreeOptions.GetRadioButton(m_htiDropLoadedLimit,m_iLimitMode,hDummy);
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiDropLoadedLimit, VAL_CLEAN_LIMIT_MIN(m_iLimitMode), (ForFile() && m_iLimitMode == thePrefs.m_iDropLoadedLimitMode) ? thePrefs.GetDropLoadedLimit() : VAL_CLEAN_LIMIT_DEF(m_iLimitMode), VAL_CLEAN_LIMIT_MAX(m_iLimitMode))) SetModified();
			}else
			if(m_htiDropLoadedTimer && pton->hItem == m_htiDropLoadedTimer){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiDropLoadedTimer, TIM_DROP_MIN, ForFile() ? thePrefs.GetDropLoadedTimer() : TIM_DROP_DEF, TIM_DROP_MAX)) SetModified();
			}else
#endif // NEO_SA // NEO: NSA END
	// NEO: NSD END
					{}
		}else{
			UINT bCheck;
			if(!ForFile()){
#ifdef NEO_CD // NEO: NCD - [NeoClientDatabase]
				bCheck = CheckNCDBEnable();
#ifdef NEO_SA // NEO: NSA - [NeoSourceAnaliser]
				m_ctrlTreeOptions.SetGroupEnable(m_htiSourceAnaliser,bCheck);
#endif // NEO_SA // NEO: NSA END
#endif // NEO_CD // NEO: NCD END
#ifdef NEO_SA // NEO: NSA - [NeoSourceAnaliser]
				if(m_htiHandleTableGaps && pton->hItem == m_htiHandleTableGaps){
					m_ctrlTreeOptions.GetCheckBox(m_htiHandleTableGaps, bCheck);
					m_ctrlTreeOptions.SetGroupEnable(m_htiHandleTableGaps, bCheck);
				}else
				if(m_htiCheckPriorityIP && pton->hItem == m_htiCheckPriorityIP){
					m_ctrlTreeOptions.GetCheckBox(m_htiCheckPriorityIP, bCheck);
					m_ctrlTreeOptions.SetItemEnable(m_htiCheckPriorityIP, bCheck,TRUE,TRUE);
				}else
				if(m_htiCheckPortIntegrity && pton->hItem == m_htiCheckPortIntegrity){
					m_ctrlTreeOptions.GetCheckBox(m_htiCheckPortIntegrity, bCheck);
					m_ctrlTreeOptions.SetItemEnable(m_htiCheckPortIntegrity, bCheck,TRUE,TRUE);
				}

				if(m_htiLinkTimeThreshold && pton->hItem == m_htiLinkTimeThreshold){
					m_ctrlTreeOptions.GetCheckBox(m_htiLinkTimeThreshold, bCheck);
					m_ctrlTreeOptions.SetItemEnable(m_htiLinkTimeThreshold, bCheck,TRUE,TRUE);
				}
				if(m_htiDualLinkedTableGravity && pton->hItem == m_htiDualLinkedTableGravity){
					if(m_htiLinkTimeThreshold)
						m_ctrlTreeOptions.GetCheckBox(m_htiLinkTimeThreshold, bCheck);
					if(bCheck)
						m_ctrlTreeOptions.GetCheckBox(m_htiDualLinkedTableGravity, bCheck);
					m_ctrlTreeOptions.SetItemEnable(m_htiDualLinkedTableGravity, bCheck,TRUE,TRUE);
				}
				if(m_htiMaxReliableTime && pton->hItem == m_htiMaxReliableTime){
					m_ctrlTreeOptions.GetCheckBox(m_htiMaxReliableTime, bCheck);
					m_ctrlTreeOptions.SetItemEnable(m_htiMaxReliableTime, bCheck,TRUE,TRUE);
				}
#endif // NEO_SA // NEO: NSA END
			}
			SetModified();
		}
	}
	return 0;
}

#ifdef NEO_CD // NEO: NCD - [NeoClientDatabase]
BOOL CPPgSourceStorage::CheckNCDBEnable(){
	UINT Enable1, Enable2;
	UINT bCheck;
	UINT bCheck1 = FALSE;
	UINT bCheck2 = FALSE;

	m_ctrlTreeOptions.GetCheckBox(m_htiEnableSourceList, bCheck);
	Enable1 = Enable2 = bCheck;

	if(Enable1){
		m_ctrlTreeOptions.GetCheckBox(m_htiSaveGlobalSourceList, bCheck1);
		if(bCheck1 == FALSE)
			Enable2 = FALSE;
		m_ctrlTreeOptions.GetCheckBox(m_htiSaveSourceFileList, bCheck2);
		if(bCheck2 == TRUE)
			Enable2 = TRUE;
	}

	m_ctrlTreeOptions.SetItemEnable(m_htiSaveGlobalSourceList, Enable1);
	m_ctrlTreeOptions.SetItemEnable(m_htiSaveSourceFileList, Enable1);
	m_ctrlTreeOptions.SetItemEnable(m_htiSaveSourceDataInClient, Enable2);
	m_ctrlTreeOptions.SetGroupEnable(m_htiIPTables,Enable2);

	if(Enable1){
		//m_ctrlTreeOptions.SetItemEnable(m_htiGlobalSourceListCleanUpTime, bCheck1);
		//m_ctrlTreeOptions.SetItemEnable(m_htiGlobalSourceListCleanUp, bCheck1);
		//if(bCheck1){
			m_ctrlTreeOptions.GetCheckBox(m_htiGlobalSourceListCleanUp, bCheck);
			m_ctrlTreeOptions.SetItemEnable(m_htiGlobalSourceListCleanUp, bCheck,TRUE,TRUE);
		//}
		m_ctrlTreeOptions.SetItemEnable(m_htiFastSourceCleanUp, /*bCheck1 &&*/ bCheck2);

		m_ctrlTreeOptions.SetItemEnable(m_htiSourceFileListCleanUpTime, bCheck2);
	}

	return Enable2;
}
#endif // NEO_CD // NEO: NCD END

LRESULT CPPgSourceStorage::DrawTreeItemHelp(WPARAM wParam, LPARAM lParam)
{
	if(!IsWindowVisible())
		return 0;

	if (wParam == IDC_MOD_OPTS){
		CString* sInfo = (CString*)lParam;
		SetDlgItemText(IDC_MOD_OPTS_INFO, *sInfo);
	}
	return FALSE;
}

void CPPgSourceStorage::OnHelp()
{
	//theApp.ShowHelp(0);
}

BOOL CPPgSourceStorage::OnCommand(WPARAM wParam, LPARAM lParam)
{
	if (wParam == ID_HELP)
	{
		OnHelp();
		return TRUE;
	}
	return __super::OnCommand(wParam, lParam);
}

BOOL CPPgSourceStorage::OnHelpInfo(HELPINFO* /*pHelpInfo*/)
{
	OnHelp();
	return TRUE;
}
