//this file is part of NeoMule
//Copyright (C)2006 David Xanatos ( Xanatos@Lycos.at / http://neomule.sourceforge.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


#include "stdafx.h"
#include "emule.h"
#include "PPgRelease.h"
#include "Preferences.h"
#include "PartFile.h"
#include "OtherFunctions.h"
#include "Neo/Functions.h"
#include "Neo/GUI/CP/TreeFunctions.h"
#include "Neo/Defaults.h"
#include "UserMsgs.h"
#include "EmuleDlg.h"// NPT
#include "SharedFilesWnd.h" // NPT
#include "SharedFilesCtrl.h" // NPT
#include "KnownFileList.h" // NPT
#include "sharedfilelist.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

// NEO: NPT - [NeoPartTraffic]
#define PT_EXPERT _T("Expert")
#define PT_NORMAL _T("Normal")
#define PT_RED	  _T("Red")
#define PT_BLUE   _T("Blue")

class CPartTrafficStyle : public CTreeOptionsCombo
{
public:
	CPartTrafficStyle();
	virtual ~CPartTrafficStyle();

protected:
	//{{AFX_VIRTUAL(CPartTrafficStyle)
	//}}AFX_VIRTUAL

	//{{AFX_MSG(CPartTrafficStyle)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()

  DECLARE_DYNCREATE(CPartTrafficStyle)
};


IMPLEMENT_DYNCREATE(CPartTrafficStyle, CTreeOptionsCombo)

CPartTrafficStyle::CPartTrafficStyle()
{
}

CPartTrafficStyle::~CPartTrafficStyle()
{
}

BEGIN_MESSAGE_MAP(CPartTrafficStyle, CTreeOptionsCombo)
	//{{AFX_MSG_MAP(CPartTrafficStyle)
	ON_WM_CREATE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


int CPartTrafficStyle::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CTreeOptionsCombo::OnCreate(lpCreateStruct) == -1)
		return -1;
	
  //Add strings to the combo
  AddString(PT_EXPERT);
  AddString(PT_NORMAL);
  AddString(PT_BLUE);
  AddString(PT_RED);
	
	return 0;
}
// NEO: NPT END 

// NEO: OCS - [OtherCreditSystems]
class CCreditSystems : public CTreeOptionsCombo
{
public:
	CCreditSystems();
	virtual ~CCreditSystems();

protected:
	//{{AFX_VIRTUAL(CCreditSystems)
	//}}AFX_VIRTUAL

	//{{AFX_MSG(CCreditSystems)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()

  DECLARE_DYNCREATE(CCreditSystems)
};


IMPLEMENT_DYNCREATE(CCreditSystems, CTreeOptionsCombo)

CCreditSystems::CCreditSystems()
{
}

CCreditSystems::~CCreditSystems()
{
}

BEGIN_MESSAGE_MAP(CCreditSystems, CTreeOptionsCombo)
	//{{AFX_MSG_MAP(CCreditSystems)
	ON_WM_CREATE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

int CCreditSystems::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CTreeOptionsCombo::OnCreate(lpCreateStruct) == -1)
		return -1;

	//Add strings to the combo
	AddString(_T("Official")); // 0
	AddString(_T("Eastshare")); // 1
	AddString(_T("Lovelace")); // 2
	AddString(_T("Pawcio")); // 3
	AddString(_T("Peace")); // 4
	AddString(_T("RT")); // 5
	AddString(_T("Sivka")); // 6
	AddString(_T("Swat")); // 7
	AddString(_T("Tk4")); // 8
	AddString(_T("Xtreme")); // 9
	AddString(_T("Zzul")); // 10

	return 0;
}

void SetTreeCS(CTreeOptionsCtrl &hCtrl,HTREEITEM  &hItem, LPCTSTR Label,HTREEITEM  Parent, LPCTSTR Info, BOOL bChecked){
	//hItem = hCtrl.InsertItem(Label, TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, Parent);
	SetTreeRadio(hCtrl,hItem,Label,Parent,Info,FALSE,bChecked);
	hCtrl.AddComboBox(hItem,RUNTIME_CLASS(CCreditSystems));
	//hCtrl.SetItemSize(hItem,10);
	//hCtrl.SetItemInfo(hItem,Info);
}

void DDX_TreeCS(CTreeOptionsCtrl* hCtrl, CDataExchange* pDX, int /*nIDC*/,HTREEITEM hItem, int& nValue)
{
	CString sText;
	if (pDX->m_bSaveAndValidate){
		sText = hCtrl->GetComboText(hItem);
		if(sText == _T("Official"))
			nValue = 0;
		else if(sText == _T("Eastshare"))
			nValue = 1;
		else if(sText == _T("Lovelace"))
			nValue = 2;
		else if(sText == _T("Pawcio"))
			nValue = 3;
		else if(sText == _T("Peace"))
			nValue = 4;
		else if(sText == _T("RT"))
			nValue = 5;
		else if(sText == _T("Sivka"))
			nValue = 6;
		else if(sText == _T("Swat"))
			nValue = 7;
		else if(sText == _T("Tk4"))
			nValue = 8;
		else if(sText == _T("Xtreme"))
			nValue = 9;
		else if(sText == _T("Zzul"))
			nValue = 10;
	}else{
		switch(nValue){
		case 0: sText = _T("Official"); break;
		case 1: sText = _T("Eastshare"); break;
		case 2: sText = _T("Lovelace"); break;
		case 3: sText = _T("Pawcio"); break;
		case 4: sText = _T("Peace"); break;
		case 5: sText = _T("RT"); break;
		case 6: sText = _T("Sivka"); break;
		case 7: sText = _T("Swat"); break;
		case 8: sText = _T("Tk4"); break;
		case 9: sText = _T("Xtreme"); break;
		case 10: sText = _T("Zzul"); break;
		}
		hCtrl->SetComboText(hItem, sText);
	}
}
// NEO: OCS END

///////////////////////////////////////////////////////////////////////////////
// CPPgRelease dialog

IMPLEMENT_DYNAMIC(CPPgRelease, CPropertyPage)

BEGIN_MESSAGE_MAP(CPPgRelease, CPropertyPage)
	ON_WM_TIMER() // NEO: FCFG - [FileConfiguration]
	ON_WM_DESTROY()
	ON_MESSAGE(UM_DATA_CHANGED, OnDataChanged) // NEO: FCFG - [FileConfiguration]
	ON_MESSAGE(WM_TREEOPTSCTRL_NOTIFY, OnTreeOptsCtrlNotify)
	ON_MESSAGE(WM_TREEITEM_HELP, DrawTreeItemHelp)
	ON_WM_HELPINFO()
END_MESSAGE_MAP()

CPPgRelease::CPPgRelease()
	: CPropertyPage(CPPgRelease::IDD)
	, m_ctrlTreeOptions(theApp.m_iDfltImageListColorFlags)
{
	// NEO: FCFG - [FileConfiguration]
	m_bFilePreferences = false;

	m_paFiles = NULL;
	m_bDataChanged = false;
	m_strCaption = GetResString(IDS_X_RELEASE_MENU);
	m_psp.pszTitle = m_strCaption;
	m_psp.dwFlags |= PSP_USETITLE;
	m_timer = 0;
	// NEO: FCFG END
	ClearAllMembers();
	m_ctrlTreeOptions.SetNeoStyle();
}

CPPgRelease::~CPPgRelease()
{
}

void CPPgRelease::ClearAllMembers()
{
	m_bInitializedTreeOpts = false;
	
	m_htiReleaseTweaks = NULL;

		m_htiPartTraffic = NULL; // NEO: NPT - [NeoPartTraffic]

		// NEO: TQ - [TweakUploadQueue]
		m_htiTweakUploadQueue = NULL;
			m_htiSaveUploadQueueWaitTime = NULL; // NEO: SQ - [SaveUploadQueue]
			m_htiUseMultiQueue = NULL; // NEO: MQ - [MultiQueue]
			m_htiUseRandomQueue = NULL; // NEO: RQ - [RandomQueue]
			m_htiNeoScoreSystem = NULL; // NEO: NFS - [NeoScoreSystem]
			// NEO: OCS - [OtherCreditSystems]
			m_htiCreditSystem = NULL;
				m_htiOfficialCreditSystem = NULL;
				m_htiNeoCreditSystem = NULL; // NEO: NCS - [NeoCreditSystem]
				m_htiOtherCreditSystem = NULL;
			// NEO: OCS END
			m_htiInfiniteQueue = NULL;
			m_htiUploadQueueOverFlow = NULL;
				m_htiQueueOverFlowDef = NULL;
				m_htiQueueOverFlowEx = NULL;
				m_htiQueueOverFlowRelease = NULL;
				m_htiQueueOverFlowCF = NULL;
			m_htiOldPrioritySystem = NULL;
			// NEO: NMFS - [NiceMultiFriendSlots]
			m_htiFriendUpload = NULL;
				m_htiFriendSlotLimit = NULL;
#ifdef NEO_UBT // NEO: BM - [BandwidthModeration]
				m_htiSeparateFriendBandwidth = NULL;
					m_htiFriendSlotSpeed = NULL;
					m_htiFriendBandwidthPercentage = NULL;
#endif // NEO_UBT // NEO: BM END
			// NEO: NMFS END
		// NEO: TQ END

		// NEO: PRSF - [PushSmallRareFiles]
		m_htiFilePushTweaks = NULL;
			m_htiPushSmallFiles = NULL;
			m_htiPushRareFiles = NULL;
			m_htiPushRatioFiles = NULL;
		// NEO: PRSF END

		// NEO: NCAP - [NeoCustomAutoPriority]
		m_htiAutoUpPriority = NULL;
			m_htiDynamicAutoUpPriorityDefault = NULL;
			m_htiDynamicAutoUpPriorityEnable = NULL;
			m_htiDynamicAutoUpPriorityDisable = NULL;
			m_htiLowUpPrioThreshold = NULL;
			m_htiHighUpPrioThreshold = NULL;
		// NEO: NCAP END

		// NEO: RT - [ReleaseTweaks]
		m_htiReleasePriority = NULL;
			m_htiReleasePriorityLevel = NULL;
			m_htiReleaseUpload = NULL;
				m_htiReleaseSlotLimit = NULL;
#ifdef NEO_UBT // NEO: BM - [BandwidthModeration]
				m_htiSeparateReleaseBandwidth = NULL;
					m_htiReleaseSlotSpeed = NULL;
					m_htiReleaseBandwidthPercentage = NULL;
#endif // NEO_UBT // NEO: BM END
			m_htiReleasePriorityMode = NULL;
				m_htiReleasePriorityModeDefault = NULL;
				m_htiReleasePriorityModeMixed = NULL;
				m_htiReleasePriorityModeBoost = NULL;
				m_htiReleasePriorityModePower = NULL;

			m_htiReleaseLimitRoot = NULL;
				m_htiReleaseLimit = NULL;
					m_htiReleaseLimitDefault = NULL;
					m_htiReleaseLimitEnable1 = NULL;
					m_htiReleaseLimitEnable2 = NULL;
					m_htiReleaseLimitDisable = NULL;
					m_htiReleaseLimitHigh = NULL;
					m_htiReleaseLimitLow = NULL;
					m_htiReleaseLimitMode = NULL;
						m_htiReleaseLimitModeDefault = NULL;
						m_htiReleaseLimitModeSimply = NULL;
						m_htiReleaseLimitModeExponential = NULL;
						m_htiReleaseLimitModeLinear = NULL;
				m_htiReleaseLimitUnion = NULL;
					m_htiReleaseLimitUnionDefault = NULL;
					m_htiReleaseLimitUnionEnable = NULL;
					m_htiReleaseLimitUnionDisable = NULL;

				m_htiReleaseLimitComplete = NULL;
					m_htiReleaseLimitCompleteDefault = NULL;
					m_htiReleaseLimitCompleteEnable1 = NULL;
					m_htiReleaseLimitCompleteEnable2 = NULL;
					m_htiReleaseLimitCompleteDisable = NULL;
					m_htiReleaseLimitCompleteHigh = NULL;
					m_htiReleaseLimitCompleteLow = NULL;
					m_htiReleaseLimitCompleteMode = NULL;
						m_htiReleaseLimitCompleteModeDefault = NULL;
						m_htiReleaseLimitCompleteModeSimply = NULL;
						m_htiReleaseLimitCompleteModeExponential = NULL;
						m_htiReleaseLimitCompleteModeLinear = NULL;

			m_htiLimitUnion = NULL;
				m_htiLimitUnionDefault = NULL;
				m_htiLimitUnionEnable = NULL;
				m_htiLimitUnionDisable = NULL;

			m_htiSourceLimitRoot = NULL;

				m_htiSourceLimit = NULL;
					m_htiSourceLimitDefault = NULL;
					m_htiSourceLimitEnable1 = NULL;
					m_htiSourceLimitEnable2 = NULL;
					m_htiSourceLimitDisable = NULL;
					m_htiSourceLimitHigh = NULL;
					m_htiSourceLimitLow = NULL;
					m_htiSourceLimitMode = NULL;
						m_htiSourceLimitModeDefault = NULL;
						m_htiSourceLimitModeSimply = NULL;
						m_htiSourceLimitModeExponential = NULL;
						m_htiSourceLimitModeLinear = NULL;
				m_htiSourceLimitUnion = NULL;
					m_htiSourceLimitUnionDefault = NULL;
					m_htiSourceLimitUnionEnable = NULL;
					m_htiSourceLimitUnionDisable = NULL;
				m_htiSourceLimitComplete = NULL;
					m_htiSourceLimitCompleteDefault = NULL;
					m_htiSourceLimitCompleteEnable1 = NULL;
					m_htiSourceLimitCompleteEnable2 = NULL;
					m_htiSourceLimitCompleteDisable = NULL;
					m_htiSourceLimitCompleteHigh = NULL;
					m_htiSourceLimitCompleteLow = NULL;
					m_htiSourceLimitCompleteMode = NULL;
						m_htiSourceLimitCompleteModeDefault = NULL;
						m_htiSourceLimitCompleteModeSimply = NULL;
						m_htiSourceLimitCompleteModeExponential = NULL;
						m_htiSourceLimitCompleteModeLinear = NULL;

				m_htiReleasePriorityNeedComplete = NULL;
		// NEO: RT END

		// NEO: IPS - [InteligentPartSharing]
		m_htiInteligentPartSharing = NULL;
			m_htiInteligentPartSharingEnable = NULL;
			m_htiInteligentPartSharingTimer = NULL;
			m_htiMaxProzentToHide = NULL;
			m_htiHideOverAvaliblyParts = NULL;
				m_htiHideOverAvaliblyPartsDefault = NULL;
				m_htiHideOverAvaliblyPartsEnable = NULL;
				m_htiHideOverAvaliblyPartsEnableAll = NULL;
				m_htiHideOverAvaliblyPartsDisable = NULL;
				m_htiHideOverAvaliblyValue = NULL;
				m_htiHideOverAvaliblyMode = NULL;
					m_htiHideOverAvaliblyMode0 = NULL;
					m_htiHideOverAvaliblyMode1 = NULL;
					m_htiHideOverAvaliblyMode2 = NULL;
				m_htiBlockHighOverAvaliblyParts = NULL;
					m_htiBlockHighOverAvaliblyPartsDefault = NULL;
					m_htiBlockHighOverAvaliblyPartsEnable = NULL;
					m_htiBlockHighOverAvaliblyPartsEnableAll = NULL;
					m_htiBlockHighOverAvaliblyPartsDisable = NULL;
					m_htiBlockHighOverAvaliblyFactor = NULL;
				// NEO: NPC - [NeoPartCatch]
				m_htiHideOverAvaliblyCatch = NULL;
					m_htiHideOverAvaliblyCatchDefault = NULL;
					m_htiHideOverAvaliblyCatchReal = NULL;
					m_htiHideOverAvaliblyCatchRealHiden = NULL;
					m_htiHideOverAvaliblyCatchHiden = NULL;
					m_htiHideOverAvaliblyCatchDisable = NULL;
				// NEO: NPC END
			m_htiHideOverSharedParts = NULL;
				m_htiHideOverSharedPartsDefault = NULL;
				m_htiHideOverSharedPartsEnable = NULL;
				m_htiHideOverSharedPartsEnableAll = NULL;
				m_htiHideOverSharedPartsDisable = NULL;
				m_htiHideOverSharedValue = NULL;
				m_htiHideOverSharedMode = NULL;
					m_htiHideOverSharedMode0 = NULL;
					m_htiHideOverSharedMode1 = NULL;
					m_htiHideOverSharedMode2 = NULL;
				m_htiDontHideUnderAvaliblyParts = NULL;
					m_htiDontHideUnderAvaliblyPartsDefault = NULL;
					m_htiDontHideUnderAvaliblyPartsEnable = NULL;
					m_htiDontHideUnderAvaliblyPartsEnableAll = NULL;
					m_htiDontHideUnderAvaliblyPartsDisable = NULL;
					m_htiDontHideUnderAvaliblyValue = NULL;
					m_htiDontHideUnderAvaliblyMode = NULL;
						m_htiDontHideUnderAvaliblyMode0 = NULL;
						m_htiDontHideUnderAvaliblyMode1 = NULL;
						m_htiDontHideUnderAvaliblyMode2 = NULL;
				m_htiBlockHighOverSharedParts = NULL;
					m_htiBlockHighOverSharedPartsDefault = NULL;
					m_htiBlockHighOverSharedPartsEnable = NULL;
					m_htiBlockHighOverSharedPartsEnableAll = NULL;
					m_htiBlockHighOverSharedPartsDisable = NULL;
					m_htiBlockHighOverSharedFactor = NULL;
				m_htiHideOverSharedCalc = NULL;
					m_htiHideOverSharedCalcDefault = NULL;
					m_htiHideOverSharedCalcHigh = NULL;
					m_htiHideOverSharedCalcLow = NULL;
			m_htiShowAlwaysNeeded = NULL;
				m_htiShowAlwaysNeededDefault = NULL;
				m_htiShowAlwaysNeededEnable = NULL;
				m_htiShowAlwaysNeededEnableAll = NULL;
				m_htiShowAlwaysNeededDisable = NULL;
				m_htiShowAlwaysNeededValue = NULL;
			m_htiShowAlwaysIncomplete = NULL;
				m_htiShowAlwaysIncompleteDefault = NULL;
				m_htiShowAlwaysIncompleteEnable = NULL;
				m_htiShowAlwaysIncompleteEnableAll = NULL;
				m_htiShowAlwaysIncompleteDisable = NULL;
		// NEO: IPS END
		// NEO: RP - [RestrictivPublishing]
		m_htiPublishing = NULL;
#ifdef LANCAST // NEO: NLC - [NeoLanCast]
			m_htiDisableSendLAN = NULL;
#endif //LANCAST // NEO: NLC END
#ifdef VOODOO // NEO: VOODOO - [UniversalPartfileInterface]
			m_htiDisableVoodoo = NULL;
#endif // VOODOO
		// NEO: RP END
		m_htiXSAnswerLimit = NULL; // NEO: NST - [NeoSourceTweaks]
}

void CPPgRelease::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_MOD_OPTS, m_ctrlTreeOptions);
	if (!m_bInitializedTreeOpts)
	{
		int iImgReleaseTweaks = 8;
		int iImgQueue = 8;
		int iImgCS = 8;
		int iImgOverflow = 8;
		int iImgMFS = 8;
		int iImgPush = 8;
		int iImgRelPrio = 8;
		int iImgRelUl = 8;
		int	iImgRelType = 8;
		int iImgRelMode = 8;
		int iImgRelUnion = 8;
		int iImgRelLimitR = 8;
		int iImgRelLimitS = 8;
		int iImgRelLimitI = 8;
		int iImgRelLimitC = 8;
		int iImgIPS = 8;
		int iImgHideOA = 8;
		int iImgHideOS = 8;
		int iImgShowUA = 8;
		int iImgShowA = 8;
		int iImgShowI = 8;
		int iImgMode = 8;
		int iImgCatch = 8;
		int iImgCalc = 8;
		int iImgBlock = 8;
		int iImgAutoPrio = 8;
		int iImgPublushing = 8;
        CImageList* piml = m_ctrlTreeOptions.GetImageList(TVSIL_NORMAL);
		if (piml){
			iImgReleaseTweaks = piml->Add(CTempIconLoader(_T("RELEASETWEAKS")));
			iImgQueue = piml->Add(CTempIconLoader(_T("TWEAKQUEUE")));
			iImgCS = piml->Add(CTempIconLoader(_T("TWEAKQUEUECREDIT")));
			iImgOverflow = piml->Add(CTempIconLoader(_T("TWEAKQUEUEOVERFLOW")));
			iImgMFS = piml->Add(CTempIconLoader(_T("FRIENDSLOTUPOAD")));
			iImgPush = piml->Add(CTempIconLoader(_T("PUSHSMALLRAREFILES")));
			iImgRelType = piml->Add(CTempIconLoader(_T("RELEASEPRIORITYTYPE")));
			iImgRelPrio = piml->Add(CTempIconLoader(_T("RELEASEPRIORITY")));
			iImgRelUl = piml->Add(CTempIconLoader(_T("RELEASEUPOAD")));
			iImgRelMode = piml->Add(CTempIconLoader(_T("RELEASEPRIORITYMODE")));
			iImgRelUnion = piml->Add(CTempIconLoader(_T("RELEASEPRIORITYUNION")));
			iImgRelLimitR = piml->Add(CTempIconLoader(_T("RELEASEPRIORITYELIMIT")));
			iImgRelLimitS = piml->Add(CTempIconLoader(_T("RELEASEPRIORITYSOURCELIMIT")));
			iImgRelLimitI = piml->Add(CTempIconLoader(_T("RELEASEPRIORITYINCOMPLETELIMIT")));
			iImgRelLimitC = piml->Add(CTempIconLoader(_T("RELEASEPRIORITYCOMPLETELIMIT")));
			iImgIPS = piml->Add(CTempIconLoader(_T("IPS")));
			iImgHideOA = piml->Add(CTempIconLoader(_T("HIDEOA")));
			iImgHideOS = piml->Add(CTempIconLoader(_T("HIDEOS")));
			iImgShowUA = piml->Add(CTempIconLoader(_T("SHOWUA")));
			iImgShowA = piml->Add(CTempIconLoader(_T("SHOWA")));
			iImgShowI = piml->Add(CTempIconLoader(_T("SHOWI")));
			iImgMode = piml->Add(CTempIconLoader(_T("IPSMODE")));
			iImgCatch = piml->Add(CTempIconLoader(_T("PARTCATCH")));
			iImgCalc = piml->Add(CTempIconLoader(_T("CALCS")));
			iImgBlock = piml->Add(CTempIconLoader(_T("BLOCKPARTS")));
			iImgAutoPrio = piml->Add(CTempIconLoader(_T("FILEPRIORITY")));
			iImgPublushing = piml->Add(CTempIconLoader(_T("PUBLISHING")));
		}
		
		SetTreeGroup(m_ctrlTreeOptions,m_htiReleaseTweaks,GetResString(IDS_X_MAIN_RELEASE),iImgReleaseTweaks, TVI_ROOT, GetResString(IDS_X_MAIN_RELEASE_INFO));
		// NEO: NPT - [NeoPartTraffic]
		if(!ForFile()){
			m_htiPartTraffic = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_X_PART_TRAFFIC),m_htiReleaseTweaks,m_uPartTraffic,TRUE);
			m_ctrlTreeOptions.AddComboBox(m_htiPartTraffic,RUNTIME_CLASS(CPartTrafficStyle));
			//m_ctrlTreeOptions.SetItemSize(m_htiPartTraffic,8);
			m_ctrlTreeOptions.SetItemInfo(m_htiPartTraffic,GetResString(IDS_X_PART_TRAFFIC_INFO));
		}
		// NEO: NPT END

		if(!ForFile()){
			// NEO: TQ - [TweakUploadQueue]
			SetTreeGroup(m_ctrlTreeOptions,m_htiTweakUploadQueue,GetResString(IDS_X_TWEAK_QUEUE),iImgQueue, m_htiReleaseTweaks, GetResString(IDS_X_TWEAK_QUEUE_INFO));
				SetTreeCheck(m_ctrlTreeOptions,m_htiSaveUploadQueueWaitTime,GetResString(IDS_X_SAVE_QUEUE),m_htiTweakUploadQueue,GetResString(IDS_X_SAVE_QUEUE_INFO),FALSE,m_bSaveUploadQueueWaitTime); // NEO: SQ - [SaveUploadQueue]
				SetTreeCheck(m_ctrlTreeOptions,m_htiUseMultiQueue,GetResString(IDS_X_MULTI_QUEUE),m_htiTweakUploadQueue,GetResString(IDS_X_MULTI_QUEUE_INFO),FALSE,m_bUseMultiQueue); // NEO: MQ - [MultiQueue]
				SetTreeCheck(m_ctrlTreeOptions,m_htiUseRandomQueue,GetResString(IDS_X_RANDOM_QUEUE),m_htiTweakUploadQueue,GetResString(IDS_X_RANDOM_QUEUE_INFO),FALSE,m_bUseRandomQueue); // NEO: RQ - [RandomQueue]
				SetTreeCheck(m_ctrlTreeOptions,m_htiNeoScoreSystem,GetResString(IDS_X_NEO_SCORE),m_htiTweakUploadQueue,GetResString(IDS_X_NEO_SCORE_INFO),FALSE,m_bNeoScoreSystem); // NEO: NFS - [NeoScoreSystem]
				//SetTreeCheck(m_ctrlTreeOptions,m_htiNeoCreditSystem,GetResString(IDS_X_NEO_CREDIT),m_htiTweakUploadQueue,GetResString(IDS_X_NEO_CREDIT_INFO),FALSE,m_bNeoCreditSystem); // NEO: NCS - [NeoCreditSystem]
				// NEO: OCS - [OtherCreditSystems]
				SetTreeGroup(m_ctrlTreeOptions,m_htiCreditSystem,GetResString(IDS_X_CREDIT_SYSTEM),iImgCS, m_htiTweakUploadQueue, GetResString(IDS_X_CREDIT_SYSTEM_INFO));
					SetTreeRadio(m_ctrlTreeOptions,m_htiOfficialCreditSystem,GetResString(IDS_X_CREDIT_SYSTEM_OFFICIAL),m_htiCreditSystem,GetResString(IDS_X_CREDIT_SYSTEM_OFFICIAL_INFO),FALSE, m_iCreditSystem == 0);
					SetTreeRadio(m_ctrlTreeOptions,m_htiNeoCreditSystem,GetResString(IDS_X_NEO_CREDIT),m_htiCreditSystem,GetResString(IDS_X_NEO_CREDIT_INFO),FALSE, m_iCreditSystem == 1);
					SetTreeCS(m_ctrlTreeOptions,m_htiOtherCreditSystem,GetResString(IDS_X_CREDIT_SYSTEM_OTHER),m_htiCreditSystem,GetResString(IDS_X_CREDIT_SYSTEM_OTHER_INFO), m_iCreditSystem == 2);
				// NEO: OCS END
				SetTreeCheck(m_ctrlTreeOptions,m_htiInfiniteQueue,GetResString(IDS_X_UNLIMITED_QUEUE),m_htiTweakUploadQueue,GetResString(IDS_X_UNLIMITED_QUEUE_INFO),FALSE,m_bInfiniteQueue);
				SetTreeGroup(m_ctrlTreeOptions,m_htiUploadQueueOverFlow,GetResString(IDS_X_OVERFLOW_QUEUE),iImgOverflow, m_htiTweakUploadQueue, GetResString(IDS_X_OVERFLOW_QUEUE_INFO));
					SetTreeCheckNumEdit(m_ctrlTreeOptions,m_htiQueueOverFlowRelease,GetResString(IDS_X_OVERFLOW_QUEUE_RELEASE), m_htiUploadQueueOverFlow,GetResString(IDS_X_OVERFLOW_QUEUE_RELEASE_INFO),TRUE, m_uQueueOverFlowRelease);
					SetTreeCheckNumEdit(m_ctrlTreeOptions,m_htiQueueOverFlowEx,GetResString(IDS_X_OVERFLOW_QUEUE_EXTENDED), m_htiUploadQueueOverFlow,GetResString(IDS_X_OVERFLOW_QUEUE_EXTENDED_INFO),TRUE, m_uQueueOverFlowEx);
					SetTreeCheckNumEdit(m_ctrlTreeOptions,m_htiQueueOverFlowDef,GetResString(IDS_X_OVERFLOW_QUEUE_DEFAULT), m_htiUploadQueueOverFlow,GetResString(IDS_X_OVERFLOW_QUEUE_DEFAULT_INFO),TRUE, m_uQueueOverFlowDef);
					SetTreeCheckNumEdit(m_ctrlTreeOptions,m_htiQueueOverFlowCF,GetResString(IDS_X_OVERFLOW_QUEUE_COMFIRND), m_htiUploadQueueOverFlow,GetResString(IDS_X_OVERFLOW_QUEUE_COMFIRND_INFO),TRUE, m_uQueueOverFlowCF);
				SetTreeCheck(m_ctrlTreeOptions,m_htiOldPrioritySystem,GetResString(IDS_X_USEOLDPRIOSYS),m_htiTweakUploadQueue,GetResString(IDS_X_USEOLDPRIOSYS_INFO),FALSE,m_bOldPrioritySystem);
			// NEO: TQ END
				// NEO: NMFS - [NiceMultiFriendSlots]
				SetTreeGroup(m_ctrlTreeOptions,m_htiFriendUpload,GetResString(IDS_X_FRIEND_UPLOAD),iImgMFS, m_htiTweakUploadQueue, GetResString(IDS_X_FRIEND_UPLOAD_INFO));
					SetTreeCheckNumEdit(m_ctrlTreeOptions,m_htiFriendSlotLimit,GetResString(IDS_X_FRIEND_SLOT_LIMIT), m_htiFriendUpload,GetResString(IDS_X_FRIEND_SLOT_LIMIT_INFO),FALSE,m_bFriendSlotLimit);
#ifdef NEO_UBT // NEO: BM - [BandwidthModeration]
					SetTreeCheck(m_ctrlTreeOptions,m_htiSeparateFriendBandwidth,GetResString(IDS_X_FRIEND_BANDWIDTH), m_htiFriendUpload,GetResString(IDS_X_FRIEND_BANDWIDTH_INFO),FALSE,m_bSeparateFriendBandwidth);
						SetTreeNumEdit(m_ctrlTreeOptions,m_htiFriendSlotSpeed,GetResString(IDS_X_FRIEND_SLOT_SPEED), m_htiSeparateFriendBandwidth,GetResString(IDS_X_FRIEND_SLOT_SPEED_INFO));
						SetTreeNumEdit(m_ctrlTreeOptions,m_htiFriendBandwidthPercentage,GetResString(IDS_X_FRIEND_BANDWIDTH_PERCENTAGE), m_htiSeparateFriendBandwidth,GetResString(IDS_X_FRIEND_BANDWIDTH_PERCENTAGE_INFO));
#endif // NEO_UBT // NEO: BM END
				// NEO: NMFS END

			// NEO: PRSF - [PushSmallRareFiles]
			SetTreeGroup(m_ctrlTreeOptions,m_htiFilePushTweaks,GetResString(IDS_X_PUSH_SMALL_RARE_FILES),iImgPush, m_htiReleaseTweaks, GetResString(IDS_X_PUSH_SMALL_RARE_FILES_INFO));
				SetTreeCheckNumEdit(m_ctrlTreeOptions,m_htiPushSmallFiles,GetResString(IDS_X_PUSH_SMALL_FILES), m_htiFilePushTweaks,GetResString(IDS_X_PUSH_SMALL_FILES_INFO),FALSE, m_bPushSmallFiles);
				SetTreeCheckNumEdit(m_ctrlTreeOptions,m_htiPushRareFiles,GetResString(IDS_X_PUSH_RARE_FILES), m_htiFilePushTweaks,GetResString(IDS_X_PUSH_RARE_FILES_INFO),FALSE, m_bPushRareFiles);
				SetTreeCheckNumEdit(m_ctrlTreeOptions,m_htiPushRatioFiles,GetResString(IDS_X_PUSH_RATIO_FILES), m_htiFilePushTweaks,GetResString(IDS_X_PUSH_RATIO_FILES_INFO),FALSE, m_bPushRatioFiles);
			// NEO: PRSF END
		}

		// NEO: NCAP - [NeoCustomAutoPriority]
		SetTreeGroup(m_ctrlTreeOptions,m_htiAutoUpPriority,GetResString(IDS_X_UP_AUTO_PRIO),iImgAutoPrio, m_htiReleaseTweaks, GetResString(IDS_X_UP_AUTO_PRIO_INFO));
			if(ForFile()){
				SetTreeRadio(m_ctrlTreeOptions,m_htiDynamicAutoUpPriorityDefault,GetResString(IDS_X_DYNAMIC_AUTO_PRIORITY_DEFAULT),m_htiAutoUpPriority,GetResString(IDS_X_DYNAMIC_AUTO_PRIORITY_DEFAULT_INFO),TRUE,m_iDynamicAutoUpPriority == 0);
				SetTreeRadioNumEdit(m_ctrlTreeOptions,m_htiDynamicAutoUpPriorityEnable,GetResString(IDS_X_DYNAMIC_AUTO_PRIORITY_ENABLE),m_htiAutoUpPriority,GetResString(IDS_X_DYNAMIC_AUTO_PRIORITY_ENABLE_INFO),TRUE,m_iDynamicAutoUpPriority == 1);
				SetTreeRadio(m_ctrlTreeOptions,m_htiDynamicAutoUpPriorityDisable,GetResString(IDS_X_DYNAMIC_AUTO_PRIORITY_DISABLE),m_htiAutoUpPriority,GetResString(IDS_X_DYNAMIC_AUTO_PRIORITY_DISABLE_INFO),TRUE,m_iDynamicAutoUpPriority == 2);
			}else
				SetTreeCheckNumEdit(m_ctrlTreeOptions,m_htiDynamicAutoUpPriorityEnable,GetResString(IDS_X_DYNAMIC_AUTO_PRIORITY_ENABLE),m_htiAutoUpPriority,GetResString(IDS_X_DYNAMIC_AUTO_PRIORITY_ENABLE_INFO),FALSE,m_bDynamicAutoUpPriority);
			SetTreeNumEdit(m_ctrlTreeOptions,m_htiLowUpPrioThreshold,GetResString(IDS_X_AUTO_PRIO_LOW), m_htiAutoUpPriority,GetResString(IDS_X_AUTO_PRIO_LOW_INFO));
			SetTreeNumEdit(m_ctrlTreeOptions,m_htiHighUpPrioThreshold,GetResString(IDS_X_AUTO_PRIO_HIGH), m_htiAutoUpPriority,GetResString(IDS_X_AUTO_PRIO_HIGH_INFO));
		// NEO: NCAP END

		// NEO: RT - [ReleaseTweaks]
		SetTreeGroup(m_ctrlTreeOptions,m_htiReleasePriority,GetResString(IDS_X_RELEASE_MAIN),iImgRelPrio, m_htiReleaseTweaks, GetResString(IDS_X_RELEASE_MAIN_INFO));
			SetTreeNumEdit(m_ctrlTreeOptions,m_htiReleasePriorityLevel,GetResString(IDS_X_RELEASE_LEVEL), m_htiReleasePriority,GetResString(IDS_X_RELEASE_LEVEL_INFO));
			if(!ForFile()){
				SetTreeGroup(m_ctrlTreeOptions,m_htiReleaseUpload,GetResString(IDS_X_RELEASE_UPLOAD),iImgRelUl, m_htiReleasePriority, GetResString(IDS_X_RELEASE_UPLOAD_INFO));
					SetTreeCheckNumEdit(m_ctrlTreeOptions,m_htiReleaseSlotLimit,GetResString(IDS_X_RELEASE_SLOT_LIMIT), m_htiReleaseUpload,GetResString(IDS_X_RELEASE_SLOT_LIMIT_INFO),TRUE,m_uReleaseSlotLimit);
#ifdef NEO_UBT // NEO: BM - [BandwidthModeration]
					SetTreeCheck(m_ctrlTreeOptions,m_htiSeparateReleaseBandwidth,GetResString(IDS_X_RELEASE_BANDWIDTH), m_htiReleaseUpload,GetResString(IDS_X_RELEASE_BANDWIDTH_INFO),TRUE,m_uSeparateReleaseBandwidth);
						SetTreeNumEdit(m_ctrlTreeOptions,m_htiReleaseSlotSpeed,GetResString(IDS_X_RELEASE_SLOT_SPEED), m_htiSeparateReleaseBandwidth,GetResString(IDS_X_RELEASE_SLOT_SPEED_INFO));
						SetTreeNumEdit(m_ctrlTreeOptions,m_htiReleaseBandwidthPercentage,GetResString(IDS_X_RELEASE_BANDWIDTH_PERCENTAGE), m_htiSeparateReleaseBandwidth,GetResString(IDS_X_RELEASE_BANDWIDTH_PERCENTAGE_INFO));
#endif // NEO_UBT // NEO: BM END
			}
			SetTreeGroup(m_ctrlTreeOptions,m_htiReleasePriorityMode,GetResString(IDS_X_RELEASE_MODE),iImgRelType, m_htiReleasePriority, GetResString(IDS_X_RELEASE_MODE_INFO));
				if(ForFile())
					SetTreeRadio(m_ctrlTreeOptions,m_htiReleasePriorityModeDefault,GetResString(IDS_X_RELEASE_MODE_DEFAULT),m_htiReleasePriorityMode,GetResString(IDS_X_RELEASE_MODE_DEFAULT_INFO),TRUE, m_iReleaseMode == 0);
				SetTreeRadio(m_ctrlTreeOptions,m_htiReleasePriorityModeMixed,GetResString(IDS_X_RELEASE_MODE_MIXED),m_htiReleasePriorityMode,GetResString(IDS_X_RELEASE_MODE_MIXED_INFO),ForFile()?TRUE:FALSE, m_iReleaseMode == (ForFile() ? 1 : 0));
				SetTreeRadio(m_ctrlTreeOptions,m_htiReleasePriorityModeBoost,GetResString(IDS_X_RELEASE_MODE_BOOST),m_htiReleasePriorityMode,GetResString(IDS_X_RELEASE_MODE_BOOST_INFO),ForFile()?TRUE:FALSE, m_iReleaseMode == (ForFile() ? 2 : 1));
				SetTreeRadio(m_ctrlTreeOptions,m_htiReleasePriorityModePower,GetResString(IDS_X_RELEASE_MODE_POWER),m_htiReleasePriorityMode,GetResString(IDS_X_RELEASE_MODE_POWER_INFO),ForFile()?TRUE:FALSE, m_iReleaseMode == (ForFile() ? 3 : 2));

			SetTreeGroup(m_ctrlTreeOptions,m_htiReleaseLimitRoot,GetResString(IDS_X_RELEASE_LIMIT_ROOT),iImgRelLimitR, m_htiReleasePriority, GetResString(IDS_X_RELEASE_LIMIT_ROOT_INFO));
				SetTreeGroup(m_ctrlTreeOptions,m_htiReleaseLimit,GetResString(IDS_X_RELEASE_LIMIT),iImgRelLimitI, m_htiReleaseLimitRoot, GetResString(IDS_X_RELEASE_LIMIT_INFO));
					SetTreeRadio(m_ctrlTreeOptions,m_htiReleaseLimitDefault,GetResString(ForFile()?IDS_X_RELEASE_LIMIT_DEFAULT:IDS_X_RELEASE_LIMIT_DISABLE),m_htiReleaseLimit,GetResString(ForFile()?IDS_X_RELEASE_LIMIT_DEFAULT_INFO:IDS_X_RELEASE_LIMIT_DISABLE),ForFile()?TRUE:FALSE, m_iReleaseLimit == 0);
					SetTreeRadio(m_ctrlTreeOptions,m_htiReleaseLimitEnable1,GetResString(IDS_X_RELEASE_LIMIT_ENABLE_SINGEL),m_htiReleaseLimit,GetResString(IDS_X_RELEASE_LIMIT_ENABLE_SINGEL_INFO),ForFile()?TRUE:FALSE, m_iReleaseLimit == 1);
					SetTreeRadio(m_ctrlTreeOptions,m_htiReleaseLimitEnable2,GetResString(IDS_X_RELEASE_LIMIT_ENABLE_BOOTH),m_htiReleaseLimit,GetResString(IDS_X_RELEASE_LIMIT_ENABLE_BOOTH_INFO),ForFile()?TRUE:FALSE, m_iReleaseLimit == 2);
					if(ForFile())
						SetTreeRadio(m_ctrlTreeOptions,m_htiReleaseLimitDisable,GetResString(IDS_X_RELEASE_LIMIT_DISABLE),m_htiReleaseLimit,GetResString(IDS_X_RELEASE_LIMIT_DISABLE_INFO),TRUE, m_iReleaseLimit == 3);
					SetTreeNumEdit(m_ctrlTreeOptions,m_htiReleaseLimitHigh,GetResString(IDS_X_RELEASE_LIMIT_HIGH), m_htiReleaseLimit,GetResString(IDS_X_RELEASE_LIMIT_HIGH_INFO));
					SetTreeNumEdit(m_ctrlTreeOptions,m_htiReleaseLimitLow,GetResString(IDS_X_RELEASE_LIMIT_LOW), m_htiReleaseLimit,GetResString(IDS_X_RELEASE_LIMIT_LOW_INFO));
					SetTreeGroup(m_ctrlTreeOptions,m_htiReleaseLimitMode,GetResString(IDS_X_RELEASE_LIMIT_MODE),iImgRelMode, m_htiReleaseLimit, GetResString(IDS_X_RELEASE_LIMIT_MODE_INFO));
						if(ForFile())
							SetTreeRadio(m_ctrlTreeOptions,m_htiReleaseLimitModeDefault,GetResString(IDS_X_RELEASE_LIMIT_MODE_DEFAULT),m_htiReleaseLimitMode,GetResString(IDS_X_RELEASE_LIMIT_MODE_DEFAULT_INFO),TRUE, m_iReleaseLimitMode == 0);
						SetTreeRadio(m_ctrlTreeOptions,m_htiReleaseLimitModeSimply,GetResString(IDS_X_RELEASE_LIMIT_MODE_SIMPLY),m_htiReleaseLimitMode,GetResString(IDS_X_RELEASE_LIMIT_MODE_SIMPLY_INFO),ForFile()?TRUE:FALSE, m_iReleaseLimitMode == (ForFile() ? 1 : 0));
						SetTreeRadio(m_ctrlTreeOptions,m_htiReleaseLimitModeLinear,GetResString(IDS_X_RELEASE_LIMIT_MODE_LINEAR),m_htiReleaseLimitMode,GetResString(IDS_X_RELEASE_LIMIT_MODE_LINEAR_INFO),ForFile()?TRUE:FALSE, m_iReleaseLimitMode == (ForFile() ? 2 : 1));
						SetTreeRadio(m_ctrlTreeOptions,m_htiReleaseLimitModeExponential,GetResString(IDS_X_RELEASE_LIMIT_MODE_EXPONENTIAL),m_htiReleaseLimitMode,GetResString(IDS_X_RELEASE_LIMIT_MODE_EXPONENTIAL_INFO),ForFile()?TRUE:FALSE, m_iReleaseLimitMode == (ForFile() ? 3 : 2));
				if(!ForFile()){
					SetTreeCheck(m_ctrlTreeOptions,m_htiReleaseLimitUnion,GetResString(IDS_X_RELEASE_LIMIT_UNION),m_htiReleaseLimitRoot,GetResString(IDS_X_RELEASE_LIMIT_UNION_INFO),FALSE,m_bReleaseLimitUnion);
				}else{
					SetTreeGroup(m_ctrlTreeOptions,m_htiReleaseLimitUnion,GetResString(IDS_X_RELEASE_LIMIT_UNION),iImgRelUnion, m_htiReleaseLimitRoot, GetResString(IDS_X_RELEASE_LIMIT_UNION_INFO));
						SetTreeRadio(m_ctrlTreeOptions,m_htiReleaseLimitUnionDefault,GetResString(IDS_X_RELEASE_LIMIT_UNION_DEFAULT),m_htiReleaseLimitUnion,GetResString(IDS_X_RELEASE_LIMIT_UNION_DEFAULT_INFO),TRUE, m_iReleaseLimitUnion == 0);
						SetTreeRadio(m_ctrlTreeOptions,m_htiReleaseLimitUnionEnable,GetResString(IDS_X_RELEASE_LIMIT_UNION_ENABLE),m_htiReleaseLimitUnion,GetResString(IDS_X_RELEASE_LIMIT_UNION_ENABLE_INFO),TRUE, m_iReleaseLimitUnion == 1);
						SetTreeRadio(m_ctrlTreeOptions,m_htiReleaseLimitUnionDisable,GetResString(IDS_X_RELEASE_LIMIT_UNION_DISABLE),m_htiReleaseLimitUnion,GetResString(IDS_X_RELEASE_LIMIT_UNION_DISABLE_INFO),TRUE, m_iReleaseLimitUnion == 2);
				}
				SetTreeGroup(m_ctrlTreeOptions,m_htiReleaseLimitComplete,GetResString(IDS_X_RELEASE_LIMIT_COMPLETE),iImgRelLimitC, m_htiReleaseLimitRoot, GetResString(IDS_X_RELEASE_LIMIT_COMPLETE_INFO));
					SetTreeRadio(m_ctrlTreeOptions,m_htiReleaseLimitCompleteDefault,GetResString(ForFile()?IDS_X_RELEASE_LIMIT_COMPLETE_DEFAULT:IDS_X_RELEASE_LIMIT_COMPLETE_DISABLE),m_htiReleaseLimitComplete,GetResString(ForFile()?IDS_X_RELEASE_LIMIT_COMPLETE_DEFAULT_INFO:IDS_X_RELEASE_LIMIT_COMPLETE_DISABLE),ForFile()?TRUE:FALSE, m_iReleaseLimitComplete == 0);
					SetTreeRadio(m_ctrlTreeOptions,m_htiReleaseLimitCompleteEnable1,GetResString(IDS_X_RELEASE_LIMIT_COMPLETE_ENABLE_SINGEL),m_htiReleaseLimitComplete,GetResString(IDS_X_RELEASE_LIMIT_COMPLETE_ENABLE_SINGEL_INFO),ForFile()?TRUE:FALSE, m_iReleaseLimitComplete == 1);
					SetTreeRadio(m_ctrlTreeOptions,m_htiReleaseLimitCompleteEnable2,GetResString(IDS_X_RELEASE_LIMIT_COMPLETE_ENABLE_BOOTH),m_htiReleaseLimitComplete,GetResString(IDS_X_RELEASE_LIMIT_COMPLETE_ENABLE_BOOTH_INFO),ForFile()?TRUE:FALSE, m_iReleaseLimitComplete == 2);
					if(ForFile())
						SetTreeRadio(m_ctrlTreeOptions,m_htiReleaseLimitCompleteDisable,GetResString(IDS_X_RELEASE_LIMIT_COMPLETE_DISABLE),m_htiReleaseLimitComplete,GetResString(IDS_X_RELEASE_LIMIT_COMPLETE_DISABLE_INFO),TRUE, m_iReleaseLimitComplete == 3);
					SetTreeNumEdit(m_ctrlTreeOptions,m_htiReleaseLimitCompleteHigh,GetResString(IDS_X_RELEASE_LIMIT_COMPLETE_HIGH), m_htiReleaseLimitComplete,GetResString(IDS_X_RELEASE_LIMIT_COMPLETE_HIGH_INFO));
					SetTreeNumEdit(m_ctrlTreeOptions,m_htiReleaseLimitCompleteLow,GetResString(IDS_X_RELEASE_LIMIT_COMPLETE_LOW), m_htiReleaseLimitComplete,GetResString(IDS_X_RELEASE_LIMIT_COMPLETE_LOW_INFO));
					SetTreeGroup(m_ctrlTreeOptions,m_htiReleaseLimitCompleteMode,GetResString(IDS_X_RELEASE_LIMIT_COMPLETE_MODE),iImgRelMode, m_htiReleaseLimitComplete, GetResString(IDS_X_RELEASE_LIMIT_COMPLETE_MODE_INFO));
						if(ForFile())
							SetTreeRadio(m_ctrlTreeOptions,m_htiReleaseLimitCompleteModeDefault,GetResString(IDS_X_RELEASE_LIMIT_COMPLETE_MODE_DEFAULT),m_htiReleaseLimitCompleteMode,GetResString(IDS_X_RELEASE_LIMIT_COMPLETE_MODE_DEFAULT_INFO),TRUE, m_iReleaseLimitCompleteMode == 0);
						SetTreeRadio(m_ctrlTreeOptions,m_htiReleaseLimitCompleteModeSimply,GetResString(IDS_X_RELEASE_LIMIT_COMPLETE_MODE_SIMPLY),m_htiReleaseLimitCompleteMode,GetResString(IDS_X_RELEASE_LIMIT_COMPLETE_MODE_SIMPLY_INFO),ForFile()?TRUE:FALSE, m_iReleaseLimitCompleteMode == (ForFile() ? 1 : 0));
						SetTreeRadio(m_ctrlTreeOptions,m_htiReleaseLimitCompleteModeLinear,GetResString(IDS_X_RELEASE_LIMIT_COMPLETE_MODE_LINEAR),m_htiReleaseLimitCompleteMode,GetResString(IDS_X_RELEASE_LIMIT_COMPLETE_MODE_LINEAR_INFO),ForFile()?TRUE:FALSE, m_iReleaseLimitCompleteMode == (ForFile() ? 2 : 1));
						SetTreeRadio(m_ctrlTreeOptions,m_htiReleaseLimitCompleteModeExponential,GetResString(IDS_X_RELEASE_LIMIT_COMPLETE_MODE_EXPONENTIAL),m_htiReleaseLimitCompleteMode,GetResString(IDS_X_RELEASE_LIMIT_COMPLETE_MODE_EXPONENTIAL_INFO),ForFile()?TRUE:FALSE, m_iReleaseLimitCompleteMode == (ForFile() ? 3 : 2));


			if(!ForFile()){
				SetTreeCheck(m_ctrlTreeOptions,m_htiLimitUnion,GetResString(IDS_X_RELEASE_LIMIT_UNION),m_htiReleasePriority,GetResString(IDS_X_RELEASE_LIMIT_UNION_INFO),FALSE,m_bLimitUnion);
			}else{
				SetTreeGroup(m_ctrlTreeOptions,m_htiLimitUnion,GetResString(IDS_X_RELEASE_LIMIT_UNION),iImgRelUnion, m_htiReleasePriority, GetResString(IDS_X_RELEASE_LIMIT_UNION_INFO));
					SetTreeRadio(m_ctrlTreeOptions,m_htiLimitUnionDefault,GetResString(IDS_X_RELEASE_LIMIT_UNION_DEFAULT),m_htiLimitUnion,GetResString(IDS_X_RELEASE_LIMIT_UNION_DEFAULT_INFO),TRUE, m_iLimitUnion == 0);
					SetTreeRadio(m_ctrlTreeOptions,m_htiLimitUnionEnable,GetResString(IDS_X_RELEASE_LIMIT_UNION_ENABLE),m_htiLimitUnion,GetResString(IDS_X_RELEASE_LIMIT_UNION_ENABLE_INFO),TRUE, m_iLimitUnion == 1);
					SetTreeRadio(m_ctrlTreeOptions,m_htiLimitUnionDisable,GetResString(IDS_X_RELEASE_LIMIT_UNION_DISABLE),m_htiLimitUnion,GetResString(IDS_X_RELEASE_LIMIT_UNION_DISABLE_INFO),TRUE, m_iLimitUnion == 2);
			}

			SetTreeGroup(m_ctrlTreeOptions,m_htiSourceLimitRoot,GetResString(IDS_X_SOURCE_LIMIT_ROOT),iImgRelLimitS, m_htiReleasePriority, GetResString(IDS_X_SOURCE_LIMIT_ROOT_INFO));
				SetTreeGroup(m_ctrlTreeOptions,m_htiSourceLimit,GetResString(IDS_X_SOURCE_LIMIT),iImgRelLimitI, m_htiSourceLimitRoot, GetResString(IDS_X_SOURCE_LIMIT_INFO));
					SetTreeRadio(m_ctrlTreeOptions,m_htiSourceLimitDefault,GetResString(ForFile()?IDS_X_SOURCE_LIMIT_DEFAULT:IDS_X_SOURCE_LIMIT_DISABLE),m_htiSourceLimit,GetResString(ForFile()?IDS_X_SOURCE_LIMIT_DEFAULT_INFO:IDS_X_SOURCE_LIMIT_DISABLE),ForFile()?TRUE:FALSE, m_iSourceLimit == 0);
					SetTreeRadio(m_ctrlTreeOptions,m_htiSourceLimitEnable1,GetResString(IDS_X_SOURCE_LIMIT_ENABLE_SINGEL),m_htiSourceLimit,GetResString(IDS_X_SOURCE_LIMIT_ENABLE_SINGEL_INFO),ForFile()?TRUE:FALSE, m_iSourceLimit == 1);
					SetTreeRadio(m_ctrlTreeOptions,m_htiSourceLimitEnable2,GetResString(IDS_X_SOURCE_LIMIT_ENABLE_BOOTH),m_htiSourceLimit,GetResString(IDS_X_SOURCE_LIMIT_ENABLE_BOOTH_INFO),ForFile()?TRUE:FALSE, m_iSourceLimit == 2);
					if(ForFile())
						SetTreeRadio(m_ctrlTreeOptions,m_htiSourceLimitDisable,GetResString(IDS_X_SOURCE_LIMIT_DISABLE),m_htiSourceLimit,GetResString(IDS_X_SOURCE_LIMIT_DISABLE_INFO),TRUE, m_iSourceLimit == 3);
					SetTreeNumEdit(m_ctrlTreeOptions,m_htiSourceLimitHigh,GetResString(IDS_X_SOURCE_LIMIT_HIGH), m_htiSourceLimit,GetResString(IDS_X_SOURCE_LIMIT_HIGH_INFO));
					SetTreeNumEdit(m_ctrlTreeOptions,m_htiSourceLimitLow,GetResString(IDS_X_SOURCE_LIMIT_LOW), m_htiSourceLimit,GetResString(IDS_X_SOURCE_LIMIT_LOW_INFO));
					SetTreeGroup(m_ctrlTreeOptions,m_htiSourceLimitMode,GetResString(IDS_X_SOURCE_LIMIT_MODE),iImgRelMode, m_htiSourceLimit, GetResString(IDS_X_SOURCE_LIMIT_MODE_INFO));
						if(ForFile())
							SetTreeRadio(m_ctrlTreeOptions,m_htiSourceLimitModeDefault,GetResString(IDS_X_SOURCE_LIMIT_MODE_DEFAULT),m_htiSourceLimitMode,GetResString(IDS_X_SOURCE_LIMIT_MODE_DEFAULT_INFO),TRUE, m_iSourceLimitMode == 0);
						SetTreeRadio(m_ctrlTreeOptions,m_htiSourceLimitModeSimply,GetResString(IDS_X_SOURCE_LIMIT_MODE_SIMPLY),m_htiSourceLimitMode,GetResString(IDS_X_SOURCE_LIMIT_MODE_SIMPLY_INFO),ForFile()?TRUE:FALSE, m_iSourceLimitMode == (ForFile() ? 1 : 0));
						SetTreeRadio(m_ctrlTreeOptions,m_htiSourceLimitModeLinear,GetResString(IDS_X_SOURCE_LIMIT_MODE_LINEAR),m_htiSourceLimitMode,GetResString(IDS_X_SOURCE_LIMIT_MODE_LINEAR_INFO),ForFile()?TRUE:FALSE, m_iSourceLimitMode == (ForFile() ? 2 : 1));
						SetTreeRadio(m_ctrlTreeOptions,m_htiSourceLimitModeExponential,GetResString(IDS_X_SOURCE_LIMIT_MODE_EXPONENTIAL),m_htiSourceLimitMode,GetResString(IDS_X_SOURCE_LIMIT_MODE_EXPONENTIAL_INFO),ForFile()?TRUE:FALSE, m_iSourceLimitMode == (ForFile() ? 3 : 2));
				if(!ForFile()){
					SetTreeCheck(m_ctrlTreeOptions,m_htiSourceLimitUnion,GetResString(IDS_X_SOURCE_LIMIT_UNION),m_htiSourceLimitRoot,GetResString(IDS_X_SOURCE_LIMIT_UNION_INFO),FALSE,m_bSourceLimitUnion);
				}else{
					SetTreeGroup(m_ctrlTreeOptions,m_htiSourceLimitUnion,GetResString(IDS_X_SOURCE_LIMIT_UNION),iImgRelUnion, m_htiSourceLimitRoot, GetResString(IDS_X_SOURCE_LIMIT_UNION_INFO));
						SetTreeRadio(m_ctrlTreeOptions,m_htiSourceLimitUnionDefault,GetResString(IDS_X_SOURCE_LIMIT_UNION_DEFAULT),m_htiSourceLimitUnion,GetResString(IDS_X_SOURCE_LIMIT_UNION_DEFAULT_INFO),TRUE, m_iSourceLimitUnion == 0);
						SetTreeRadio(m_ctrlTreeOptions,m_htiSourceLimitUnionEnable,GetResString(IDS_X_SOURCE_LIMIT_UNION_ENABLE),m_htiSourceLimitUnion,GetResString(IDS_X_SOURCE_LIMIT_UNION_ENABLE_INFO),TRUE, m_iSourceLimitUnion == 1);
						SetTreeRadio(m_ctrlTreeOptions,m_htiSourceLimitUnionDisable,GetResString(IDS_X_SOURCE_LIMIT_UNION_DISABLE),m_htiSourceLimitUnion,GetResString(IDS_X_SOURCE_LIMIT_UNION_DISABLE_INFO),TRUE, m_iSourceLimitUnion == 2);
				}
				SetTreeGroup(m_ctrlTreeOptions,m_htiSourceLimitComplete,GetResString(IDS_X_SOURCE_COMPLETE_LIMIT),iImgRelLimitC , m_htiSourceLimitRoot, GetResString(IDS_X_SOURCE_COMPLETE_LIMIT_INFO));
					SetTreeRadio(m_ctrlTreeOptions,m_htiSourceLimitCompleteDefault,GetResString(ForFile()?IDS_X_SOURCE_COMPLETE_LIMIT_DEFAULT:IDS_X_SOURCE_COMPLETE_LIMIT_DISABLE),m_htiSourceLimitComplete,GetResString(ForFile()?IDS_X_SOURCE_COMPLETE_LIMIT_DEFAULT_INFO:IDS_X_SOURCE_COMPLETE_LIMIT_DISABLE_INFO),ForFile()?TRUE:FALSE, m_iSourceLimitComplete == 0);
					SetTreeRadio(m_ctrlTreeOptions,m_htiSourceLimitCompleteEnable1,GetResString(IDS_X_SOURCE_COMPLETE_LIMIT_ENABLE_SINGEL),m_htiSourceLimitComplete,GetResString(IDS_X_SOURCE_COMPLETE_LIMIT_ENABLE_SINGEL_INFO),ForFile()?TRUE:FALSE, m_iSourceLimitComplete == 1);
					SetTreeRadio(m_ctrlTreeOptions,m_htiSourceLimitCompleteEnable2,GetResString(IDS_X_SOURCE_COMPLETE_LIMIT_ENABLE_BOOTH),m_htiSourceLimitComplete,GetResString(IDS_X_SOURCE_COMPLETE_LIMIT_ENABLE_BOOTH_INFO),ForFile()?TRUE:FALSE, m_iSourceLimitComplete == 2);
					if(ForFile())
						SetTreeRadio(m_ctrlTreeOptions,m_htiSourceLimitCompleteDisable,GetResString(IDS_X_SOURCE_COMPLETE_LIMIT_DISABLE),m_htiSourceLimitComplete,GetResString(IDS_X_SOURCE_COMPLETE_LIMIT_DISABLE_INFO),TRUE, m_iSourceLimitComplete == 3);
					SetTreeNumEdit(m_ctrlTreeOptions,m_htiSourceLimitCompleteHigh,GetResString(IDS_X_SOURCE_COMPLETE_LIMIT_HIGH), m_htiSourceLimitComplete,GetResString(IDS_X_SOURCE_COMPLETE_LIMIT_HIGH_INFO));
					SetTreeNumEdit(m_ctrlTreeOptions,m_htiSourceLimitCompleteLow,GetResString(IDS_X_SOURCE_COMPLETE_LIMIT_LOW), m_htiSourceLimitComplete,GetResString(IDS_X_SOURCE_COMPLETE_LIMIT_LOW_INFO));
					SetTreeGroup(m_ctrlTreeOptions,m_htiSourceLimitCompleteMode,GetResString(IDS_X_SOURCE_LIMIT_COMPLETE_MODE),iImgRelMode, m_htiSourceLimitComplete, GetResString(IDS_X_SOURCE_LIMIT_COMPLETE_MODE_INFO));
						if(ForFile())
							SetTreeRadio(m_ctrlTreeOptions,m_htiSourceLimitCompleteModeDefault,GetResString(IDS_X_SOURCE_LIMIT_COMPLETE_MODE_DEFAULT),m_htiSourceLimitCompleteMode,GetResString(IDS_X_SOURCE_LIMIT_COMPLETE_MODE_DEFAULT_INFO),TRUE, m_iSourceLimitCompleteMode == 0);
						SetTreeRadio(m_ctrlTreeOptions,m_htiSourceLimitCompleteModeSimply,GetResString(IDS_X_SOURCE_LIMIT_COMPLETE_MODE_SIMPLY),m_htiSourceLimitCompleteMode,GetResString(IDS_X_SOURCE_LIMIT_COMPLETE_MODE_SIMPLY_INFO),ForFile()?TRUE:FALSE, m_iSourceLimitCompleteMode == (ForFile() ? 1 : 0));
						SetTreeRadio(m_ctrlTreeOptions,m_htiSourceLimitCompleteModeLinear,GetResString(IDS_X_SOURCE_LIMIT_COMPLETE_MODE_LINEAR),m_htiSourceLimitCompleteMode,GetResString(IDS_X_SOURCE_LIMIT_COMPLETE_MODE_LINEAR_INFO),ForFile()?TRUE:FALSE, m_iSourceLimitCompleteMode == (ForFile() ? 2 : 1));
						SetTreeRadio(m_ctrlTreeOptions,m_htiSourceLimitCompleteModeExponential,GetResString(IDS_X_SOURCE_LIMIT_COMPLETE_MODE_EXPONENTIAL),m_htiSourceLimitCompleteMode,GetResString(IDS_X_SOURCE_LIMIT_COMPLETE_MODE_EXPONENTIAL_INFO),ForFile()?TRUE:FALSE, m_iSourceLimitCompleteMode == (ForFile() ? 3 : 2));

			if(!ForFile())
				SetTreeCheckNumEdit(m_ctrlTreeOptions,m_htiReleasePriorityNeedComplete,GetResString(IDS_X_RELEASE_NEED_COMPLETE), m_htiReleasePriority,GetResString(IDS_X_RELEASE_NEED_COMPLETE_INFO),TRUE,m_bReleaseNeedComplete);
			else
				SetTreeCheck(m_ctrlTreeOptions,m_htiReleasePriorityNeedComplete,GetResString(IDS_X_RELEASE_NEED_COMPLETE_DISABLE),m_htiReleasePriority,GetResString(IDS_X_RELEASE_NEED_COMPLETE_DISABLE_INFO),TRUE,m_iReleaseNeedComplete);
		// NEO: RT END

		// NEO: IPS - [InteligentPartSharing]
		SetTreeGroup(m_ctrlTreeOptions,m_htiInteligentPartSharing,GetResString(IDS_X_INTELIGENT_PART_SHARING),iImgIPS, m_htiReleaseTweaks, GetResString(IDS_X_INTELIGENT_PART_SHARING_INFO));
			if(!ForFile()){
				SetTreeCheck(m_ctrlTreeOptions,m_htiInteligentPartSharingEnable,GetResString(IDS_X_INTELIGENT_PART_SHARING_ENABLE),m_htiInteligentPartSharing,GetResString(IDS_X_INTELIGENT_PART_SHARING_ENABLE_INFO),FALSE,m_bInteligentPartSharing);
				SetTreeNumEdit(m_ctrlTreeOptions,m_htiInteligentPartSharingTimer,GetResString(IDS_X_INTELIGENT_PART_SHARING_INTERVAL), m_htiInteligentPartSharing,GetResString(IDS_X_INTELIGENT_PART_SHARING_INTERVAL_INFO));
			}
			SetTreeNumEdit(m_ctrlTreeOptions,m_htiMaxProzentToHide,GetResString(IDS_X_INTELIGENT_PART_SHARING_MAXIMUM), m_htiInteligentPartSharing,GetResString(IDS_X_INTELIGENT_PART_SHARING_MAXIMUM_INFO));
			// OA>
			SetTreeGroup(m_ctrlTreeOptions,m_htiHideOverAvaliblyParts,GetResString(IDS_X_HIDE_OVER_AVALIBLY),iImgHideOA, m_htiInteligentPartSharing, GetResString(IDS_X_HIDE_OVER_AVALIBLY_INFO));
				if(ForFile())
					SetTreeRadio(m_ctrlTreeOptions,m_htiHideOverAvaliblyPartsDefault,GetResString(IDS_X_IPS_HIDE_ENABLE_DEFAULT),m_htiHideOverAvaliblyParts,GetResString(IDS_X_IPS_HIDE_ENABLE_DEFAULT_INFO),TRUE,m_iHideOverAvaliblyParts == 0);
				else
					SetTreeRadio(m_ctrlTreeOptions,m_htiHideOverAvaliblyPartsDisable,GetResString(IDS_X_IPS_HIDE_ENABLE_DISABLE),m_htiHideOverAvaliblyParts,GetResString(IDS_X_IPS_HIDE_ENABLE_DISABLE_INFO),FALSE, m_iHideOverAvaliblyParts == 0);
				SetTreeRadio(m_ctrlTreeOptions,m_htiHideOverAvaliblyPartsEnable,GetResString(ForFile() ? IDS_X_IPS_HIDE_ENABLE_ENABLE_FILE : IDS_X_IPS_HIDE_ENABLE_ENABLE),m_htiHideOverAvaliblyParts,GetResString(ForFile() ? IDS_X_IPS_HIDE_ENABLE_ENABLE_FILE_INFO : IDS_X_IPS_HIDE_ENABLE_ENABLE_INFO),ForFile(), m_iHideOverAvaliblyParts == 1);
				if(!ForFile())
					SetTreeRadio(m_ctrlTreeOptions,m_htiHideOverAvaliblyPartsEnableAll,GetResString(IDS_X_IPS_HIDE_ENABLE_ENABLE_ALL),m_htiHideOverAvaliblyParts,GetResString(IDS_X_IPS_HIDE_ENABLE_ENABLE_ALL_INFO),FALSE, m_iHideOverAvaliblyParts == 2);
				else
					SetTreeRadio(m_ctrlTreeOptions,m_htiHideOverAvaliblyPartsDisable,GetResString(IDS_X_IPS_HIDE_ENABLE_DISABLE),m_htiHideOverAvaliblyParts,GetResString(IDS_X_IPS_HIDE_ENABLE_DISABLE_INFO),TRUE, m_iHideOverAvaliblyParts == 2);

				SetTreeNumEdit(m_ctrlTreeOptions,m_htiHideOverAvaliblyValue,GetResString(IDS_X_HIDE_OVER_AVALIBLY_VALUE), m_htiHideOverAvaliblyParts,GetResString(IDS_X_HIDE_OVER_AVALIBLY_VALUE_INFO));
				SetTreeGroup(m_ctrlTreeOptions,m_htiHideOverAvaliblyMode,GetResString(IDS_X_IPS_MODE),iImgMode, m_htiHideOverAvaliblyParts, GetResString(IDS_X_IPS_MODE_INFO));
					if(ForFile())
						SetTreeRadio(m_ctrlTreeOptions,m_htiHideOverAvaliblyMode0,GetResString(IDS_X_IPS_MODE_DEFAULT),m_htiHideOverAvaliblyMode,GetResString(IDS_X_IPS_MODE_DEFAULT_INFO),TRUE,m_iHideOverAvaliblyMode == 0);
					SetTreeRadio(m_ctrlTreeOptions,m_htiHideOverAvaliblyMode1,GetResString(IDS_X_IPS_MODE_MULTI),m_htiHideOverAvaliblyMode,GetResString(IDS_X_IPS_MODE_MULTI_INFO),ForFile(),m_iHideOverAvaliblyMode == (ForFile() ? 1 : 0));
					SetTreeRadio(m_ctrlTreeOptions,m_htiHideOverAvaliblyMode2,GetResString(IDS_X_IPS_MODE_ADD),m_htiHideOverAvaliblyMode,GetResString(IDS_X_IPS_MODE_ADD_INFO),ForFile(),m_iHideOverAvaliblyMode == (ForFile() ? 2 : 1));

				SetTreeGroup(m_ctrlTreeOptions,m_htiBlockHighOverAvaliblyParts,GetResString(IDS_X_IPS_BLOCK_PARTS),iImgMode, m_htiHideOverAvaliblyParts, GetResString(IDS_X_IPS_BLOCK_PARTS_INFO));
					if(ForFile())
						SetTreeRadio(m_ctrlTreeOptions,m_htiBlockHighOverAvaliblyPartsDefault,GetResString(IDS_X_IPS_BLOCK_ENABLE_DEFAULT),m_htiBlockHighOverAvaliblyParts,GetResString(IDS_X_IPS_BLOCK_ENABLE_DEFAULT_INFO),TRUE,m_iBlockHighOverAvaliblyParts == 0);
					else
						SetTreeRadio(m_ctrlTreeOptions,m_htiBlockHighOverAvaliblyPartsDisable,GetResString(IDS_X_IPS_BLOCK_ENABLE_DISABLE),m_htiBlockHighOverAvaliblyParts,GetResString(IDS_X_IPS_BLOCK_ENABLE_DISABLE_INFO),FALSE, m_iBlockHighOverAvaliblyParts == 0);
					SetTreeRadio(m_ctrlTreeOptions,m_htiBlockHighOverAvaliblyPartsEnable,GetResString(ForFile() ? IDS_X_IPS_BLOCK_ENABLE_ENABLE_FILE : IDS_X_IPS_BLOCK_ENABLE_ENABLE),m_htiBlockHighOverAvaliblyParts,GetResString(ForFile() ? IDS_X_IPS_BLOCK_ENABLE_ENABLE_FILE_INFO : IDS_X_IPS_BLOCK_ENABLE_ENABLE_INFO),ForFile(), m_iBlockHighOverAvaliblyParts == 1);
					if(!ForFile())
						SetTreeRadio(m_ctrlTreeOptions,m_htiBlockHighOverAvaliblyPartsEnableAll,GetResString(IDS_X_IPS_BLOCK_ENABLE_ENABLE_ALL),m_htiBlockHighOverAvaliblyParts,GetResString(IDS_X_IPS_BLOCK_ENABLE_ENABLE_ALL_INFO),FALSE, m_iBlockHighOverAvaliblyParts == 2);
					else
						SetTreeRadio(m_ctrlTreeOptions,m_htiBlockHighOverAvaliblyPartsDisable,GetResString(IDS_X_IPS_BLOCK_ENABLE_DISABLE),m_htiBlockHighOverAvaliblyParts,GetResString(IDS_X_IPS_BLOCK_ENABLE_DISABLE_INFO),TRUE, m_iBlockHighOverAvaliblyParts == 2);

					SetTreeNumEdit(m_ctrlTreeOptions,m_htiBlockHighOverAvaliblyFactor,GetResString(IDS_X_BLOCK_OVER_AVALIBLY_VALUE), m_htiBlockHighOverAvaliblyParts,GetResString(IDS_X_BLOCK_OVER_AVALIBLY_VALUE_INFO));

				// NEO: NPC - [NeoPartCatch]
				SetTreeGroup(m_ctrlTreeOptions,m_htiHideOverAvaliblyCatch,GetResString(IDS_X_PART_CATCH),iImgCatch, m_htiHideOverAvaliblyParts, GetResString(IDS_X_PART_CATCH2_INFO));
					SetTreeRadio(m_ctrlTreeOptions,m_htiHideOverAvaliblyCatchDefault,GetResString(IDS_X_PART_CATCH_DEFAULT),m_htiHideOverAvaliblyCatch,GetResString(IDS_X_PART_CATCH_DEFAULT_INFO),TRUE,m_iHideOverAvaliblyCatch == 0);
					SetTreeRadio(m_ctrlTreeOptions,m_htiHideOverAvaliblyCatchReal,GetResString(IDS_X_PART_CATCH_REAL),m_htiHideOverAvaliblyCatch,GetResString(IDS_X_PART_CATCH_REAL_INFO),TRUE,m_iHideOverAvaliblyCatch == 1);
					SetTreeRadio(m_ctrlTreeOptions,m_htiHideOverAvaliblyCatchRealHiden,GetResString(IDS_X_PART_CATCH_REAL_HIDEN),m_htiHideOverAvaliblyCatch,GetResString(IDS_X_PART_CATCH_REAL_HIDEN_INFO),TRUE,m_iHideOverAvaliblyCatch == 2);
					SetTreeRadio(m_ctrlTreeOptions,m_htiHideOverAvaliblyCatchHiden,GetResString(IDS_X_PART_CATCH_HIDEN),m_htiHideOverAvaliblyCatch,GetResString(IDS_X_PART_CATCH_HIDEN_INFO),TRUE,m_iHideOverAvaliblyCatch == 3);
					SetTreeRadio(m_ctrlTreeOptions,m_htiHideOverAvaliblyCatchDisable,GetResString(IDS_X_PART_CATCH_DISABLE),m_htiHideOverAvaliblyCatch,GetResString(IDS_X_PART_CATCH_DISABLE_INFO),TRUE,m_iHideOverAvaliblyCatch == 4);
				// NEO: NPC END
			// <OA
			// OS>
			SetTreeGroup(m_ctrlTreeOptions,m_htiHideOverSharedParts,GetResString(IDS_X_HIDE_OVER_SHARED),iImgHideOS, m_htiInteligentPartSharing, GetResString(IDS_X_HIDE_OVER_SHARED_INFO));
				if(ForFile())
					SetTreeRadio(m_ctrlTreeOptions,m_htiHideOverSharedPartsDefault,GetResString(IDS_X_IPS_HIDE_ENABLE_DEFAULT),m_htiHideOverSharedParts,GetResString(IDS_X_IPS_HIDE_ENABLE_DEFAULT_INFO),TRUE,m_iHideOverSharedParts == 0);
				else
					SetTreeRadio(m_ctrlTreeOptions,m_htiHideOverSharedPartsDisable,GetResString(IDS_X_IPS_HIDE_ENABLE_DISABLE),m_htiHideOverSharedParts,GetResString(IDS_X_IPS_HIDE_ENABLE_DISABLE_INFO),FALSE, m_iHideOverSharedParts == 0);
				SetTreeRadio(m_ctrlTreeOptions,m_htiHideOverSharedPartsEnable,GetResString(ForFile() ? IDS_X_IPS_HIDE_ENABLE_ENABLE_FILE : IDS_X_IPS_HIDE_ENABLE_ENABLE),m_htiHideOverSharedParts,GetResString(ForFile() ? IDS_X_IPS_HIDE_ENABLE_ENABLE_FILE_INFO : IDS_X_IPS_HIDE_ENABLE_ENABLE_INFO),ForFile(), m_iHideOverSharedParts == 1);
				if(!ForFile())
					SetTreeRadio(m_ctrlTreeOptions,m_htiHideOverSharedPartsEnableAll,GetResString(IDS_X_IPS_HIDE_ENABLE_ENABLE_ALL),m_htiHideOverSharedParts,GetResString(IDS_X_IPS_HIDE_ENABLE_ENABLE_ALL_INFO),FALSE, m_iHideOverSharedParts == 2);
				else
					SetTreeRadio(m_ctrlTreeOptions,m_htiHideOverSharedPartsDisable,GetResString(IDS_X_IPS_HIDE_ENABLE_DISABLE),m_htiHideOverSharedParts,GetResString(IDS_X_IPS_HIDE_ENABLE_DISABLE_INFO),TRUE, m_iHideOverSharedParts == 2);

				SetTreeNumEdit(m_ctrlTreeOptions,m_htiHideOverSharedValue,GetResString(IDS_X_HIDE_OVER_SHARED_VALUE), m_htiHideOverSharedParts,GetResString(IDS_X_HIDE_OVER_SHARED_VALUE_INFO));
				SetTreeGroup(m_ctrlTreeOptions,m_htiHideOverSharedMode,GetResString(IDS_X_IPS_MODE),iImgMode, m_htiHideOverSharedParts, GetResString(IDS_X_IPS_MODE_INFO));
					if(ForFile())
						SetTreeRadio(m_ctrlTreeOptions,m_htiHideOverSharedMode0,GetResString(IDS_X_IPS_MODE_DEFAULT),m_htiHideOverSharedMode,GetResString(IDS_X_IPS_MODE_DEFAULT_INFO),TRUE,m_iHideOverSharedMode == 0);
					SetTreeRadio(m_ctrlTreeOptions,m_htiHideOverSharedMode1,GetResString(IDS_X_IPS_MODE_MULTI),m_htiHideOverSharedMode,GetResString(IDS_X_IPS_MODE_MULTI_INFO),ForFile(),m_iHideOverSharedMode == (ForFile() ? 1 : 0));
					SetTreeRadio(m_ctrlTreeOptions,m_htiHideOverSharedMode2,GetResString(IDS_X_IPS_MODE_ADD),m_htiHideOverSharedMode,GetResString(IDS_X_IPS_MODE_ADD_INFO),ForFile(),m_iHideOverSharedMode == (ForFile() ? 2 : 1));

				// UA>
				SetTreeGroup(m_ctrlTreeOptions,m_htiDontHideUnderAvaliblyParts,GetResString(IDS_X_SHOW_UNDER_AVALIBLY),iImgShowUA, m_htiHideOverSharedParts, GetResString(IDS_X_SHOW_UNDER_AVALIBLY_INFO));
					if(ForFile())
						SetTreeRadio(m_ctrlTreeOptions,m_htiDontHideUnderAvaliblyPartsDefault,GetResString(IDS_X_IPS_SHOW_ENABLE_DEFAULT),m_htiDontHideUnderAvaliblyParts,GetResString(IDS_X_IPS_SHOW_ENABLE_DEFAULT_INFO),TRUE,m_iDontHideUnderAvaliblyParts == 0);
					else
						SetTreeRadio(m_ctrlTreeOptions,m_htiDontHideUnderAvaliblyPartsDisable,GetResString(IDS_X_IPS_SHOW_ENABLE_DISABLE),m_htiDontHideUnderAvaliblyParts,GetResString(IDS_X_IPS_SHOW_ENABLE_DISABLE_INFO),FALSE, m_iDontHideUnderAvaliblyParts == 0);
					SetTreeRadio(m_ctrlTreeOptions,m_htiDontHideUnderAvaliblyPartsEnable,GetResString(ForFile() ? IDS_X_IPS_SHOW_ENABLE_ENABLE_FILE : IDS_X_IPS_SHOW_ENABLE_ENABLE),m_htiDontHideUnderAvaliblyParts,GetResString(ForFile() ? IDS_X_IPS_SHOW_ENABLE_ENABLE_FILE_INFO : IDS_X_IPS_SHOW_ENABLE_ENABLE_INFO),ForFile(), m_iDontHideUnderAvaliblyParts == 1);
					if(!ForFile())
						SetTreeRadio(m_ctrlTreeOptions,m_htiDontHideUnderAvaliblyPartsEnableAll,GetResString(IDS_X_IPS_SHOW_ENABLE_ENABLE_ALL),m_htiDontHideUnderAvaliblyParts,GetResString(IDS_X_IPS_SHOW_ENABLE_ENABLE_ALL_INFO),FALSE, m_iDontHideUnderAvaliblyParts == 2);
					else
						SetTreeRadio(m_ctrlTreeOptions,m_htiDontHideUnderAvaliblyPartsDisable,GetResString(IDS_X_IPS_SHOW_ENABLE_DISABLE),m_htiDontHideUnderAvaliblyParts,GetResString(IDS_X_IPS_SHOW_ENABLE_DISABLE_INFO),TRUE, m_iDontHideUnderAvaliblyParts == 2);

					SetTreeNumEdit(m_ctrlTreeOptions,m_htiDontHideUnderAvaliblyValue,GetResString(IDS_X_SHOW_UNDER_AVALIBLY_VALUE), m_htiDontHideUnderAvaliblyParts,GetResString(IDS_X_SHOW_UNDER_AVALIBLY_VALUE_INFO));
					SetTreeGroup(m_ctrlTreeOptions,m_htiDontHideUnderAvaliblyMode,GetResString(IDS_X_IPS_MODE),iImgMode, m_htiDontHideUnderAvaliblyParts, GetResString(IDS_X_IPS_MODE_INFO));

						if(ForFile())
							SetTreeRadio(m_ctrlTreeOptions,m_htiDontHideUnderAvaliblyMode0,GetResString(IDS_X_IPS_MODE_DEFAULT),m_htiDontHideUnderAvaliblyMode,GetResString(IDS_X_IPS_MODE_DEFAULT_INFO),TRUE,m_iDontHideUnderAvaliblyMode == 0);
						SetTreeRadio(m_ctrlTreeOptions,m_htiDontHideUnderAvaliblyMode1,GetResString(IDS_X_IPS_MODE_MULTI),m_htiDontHideUnderAvaliblyMode,GetResString(IDS_X_IPS_MODE_MULTI_INFO),ForFile(),m_iDontHideUnderAvaliblyMode == (ForFile() ? 1 : 0));
						SetTreeRadio(m_ctrlTreeOptions,m_htiDontHideUnderAvaliblyMode2,GetResString(IDS_X_IPS_MODE_ADD),m_htiDontHideUnderAvaliblyMode,GetResString(IDS_X_IPS_MODE_ADD_INFO),ForFile(),m_iDontHideUnderAvaliblyMode == (ForFile() ? 2 : 1));
				// <UA

				SetTreeGroup(m_ctrlTreeOptions,m_htiBlockHighOverSharedParts,GetResString(IDS_X_IPS_BLOCK_PARTS),iImgMode, m_htiHideOverSharedParts, GetResString(IDS_X_IPS_BLOCK_PARTS_INFO));
					if(ForFile())
						SetTreeRadio(m_ctrlTreeOptions,m_htiBlockHighOverSharedPartsDefault,GetResString(IDS_X_IPS_BLOCK_ENABLE_DEFAULT),m_htiBlockHighOverSharedParts,GetResString(IDS_X_IPS_BLOCK_ENABLE_DEFAULT_INFO),TRUE,m_iBlockHighOverSharedParts == 0);
					else
						SetTreeRadio(m_ctrlTreeOptions,m_htiBlockHighOverSharedPartsDisable,GetResString(IDS_X_IPS_BLOCK_ENABLE_DISABLE),m_htiBlockHighOverSharedParts,GetResString(IDS_X_IPS_BLOCK_ENABLE_DISABLE_INFO),FALSE, m_iBlockHighOverSharedParts == 0);
					SetTreeRadio(m_ctrlTreeOptions,m_htiBlockHighOverSharedPartsEnable,GetResString(ForFile() ? IDS_X_IPS_BLOCK_ENABLE_ENABLE_FILE : IDS_X_IPS_BLOCK_ENABLE_ENABLE),m_htiBlockHighOverSharedParts,GetResString(ForFile() ? IDS_X_IPS_BLOCK_ENABLE_ENABLE_FILE_INFO : IDS_X_IPS_BLOCK_ENABLE_ENABLE_INFO),ForFile(), m_iBlockHighOverSharedParts == 1);
					if(!ForFile())
						SetTreeRadio(m_ctrlTreeOptions,m_htiBlockHighOverSharedPartsEnableAll,GetResString(IDS_X_IPS_BLOCK_ENABLE_ENABLE_ALL),m_htiBlockHighOverSharedParts,GetResString(IDS_X_IPS_BLOCK_ENABLE_ENABLE_ALL_INFO),FALSE, m_iBlockHighOverSharedParts == 2);
					else
						SetTreeRadio(m_ctrlTreeOptions,m_htiBlockHighOverSharedPartsDisable,GetResString(IDS_X_IPS_BLOCK_ENABLE_DISABLE),m_htiBlockHighOverSharedParts,GetResString(IDS_X_IPS_BLOCK_ENABLE_DISABLE_INFO),TRUE, m_iBlockHighOverSharedParts == 2);

					SetTreeNumEdit(m_ctrlTreeOptions,m_htiBlockHighOverSharedFactor,GetResString(IDS_X_BLOCK_OVER_SHARE_VALUE), m_htiBlockHighOverSharedParts,GetResString(IDS_X_BLOCK_OVER_SHARE_VALUE_INFO));

				SetTreeGroup(m_ctrlTreeOptions,m_htiHideOverSharedCalc,GetResString(IDS_X_IPS_BLOCK_PARTS),iImgCalc, m_htiHideOverSharedParts, GetResString(IDS_X_IPS_BLOCK_PARTS_INFO));
					if(ForFile())
						SetTreeRadio(m_ctrlTreeOptions,m_htiHideOverSharedCalcDefault,GetResString(IDS_X_IPS_OS_CALC_DEFAULT),m_htiHideOverSharedCalc,GetResString(IDS_X_IPS_OS_CALC_DEFAULT_INFO),TRUE,m_iHideOverSharedCalc == 0);
					SetTreeRadio(m_ctrlTreeOptions,m_htiHideOverSharedCalcHigh,GetResString(IDS_X_IPS_OS_CALC_HIGH),m_htiHideOverSharedCalc,GetResString(IDS_X_IPS_OS_CALC_HIGH_INFO),ForFile(),m_iHideOverSharedCalc == (ForFile() ? 1 : 0));
					SetTreeRadio(m_ctrlTreeOptions,m_htiHideOverSharedCalcLow,GetResString(IDS_X_IPS_OS_CALC_LOW),m_htiHideOverSharedCalc,GetResString(IDS_X_IPS_OS_CALC_LOW_INFO),ForFile(),m_iHideOverSharedCalc == (ForFile() ? 2 : 1));
			// <OS

			SetTreeGroup(m_ctrlTreeOptions,m_htiShowAlwaysNeeded,GetResString(IDS_X_IPS_ALWAYS_SHOW_PARTS),iImgShowA, m_htiInteligentPartSharing, GetResString(IDS_X_IPS_ALWAYS_SHOW_PARTS_INFO));
				if(ForFile())
					SetTreeRadio(m_ctrlTreeOptions,m_htiShowAlwaysNeededDefault,GetResString(IDS_X_IPS_SHOW_ENABLE_DEFAULT),m_htiShowAlwaysNeeded,GetResString(IDS_X_IPS_SHOW_ENABLE_DEFAULT_INFO),TRUE,m_iShowAlwaysNeeded == 0);
				else
					SetTreeRadio(m_ctrlTreeOptions,m_htiDontHideUnderAvaliblyPartsDisable,GetResString(IDS_X_IPS_SHOW_ENABLE_DISABLE),m_htiShowAlwaysNeeded,GetResString(IDS_X_IPS_SHOW_ENABLE_DISABLE_INFO),FALSE, m_iShowAlwaysNeeded == 0);
				SetTreeRadio(m_ctrlTreeOptions,m_htiShowAlwaysNeededEnable,GetResString(ForFile() ? IDS_X_IPS_ALWAYS_SHOW_PARTS_FILE : IDS_X_IPS_SHOW_ENABLE_ENABLE),m_htiShowAlwaysNeeded,GetResString(ForFile() ? IDS_X_IPS_ALWAYS_SHOW_PARTS_FILE_INFO : IDS_X_IPS_SHOW_ENABLE_ENABLE_INFO),ForFile(), m_iShowAlwaysNeeded == 1);
				if(!ForFile())
					SetTreeRadio(m_ctrlTreeOptions,m_htiShowAlwaysNeededEnableAll,GetResString(IDS_X_IPS_SHOW_ENABLE_ENABLE_ALL),m_htiShowAlwaysNeeded,GetResString(IDS_X_IPS_SHOW_ENABLE_ENABLE_ALL_INFO),FALSE, m_iShowAlwaysNeeded == 2);
				else
					SetTreeRadio(m_ctrlTreeOptions,m_htiShowAlwaysNeededDisable,GetResString(IDS_X_IPS_SHOW_ENABLE_DISABLE),m_htiShowAlwaysNeeded,GetResString(IDS_X_IPS_SHOW_ENABLE_DISABLE_INFO),TRUE, m_iShowAlwaysNeeded == 2);

				SetTreeNumEdit(m_ctrlTreeOptions,m_htiShowAlwaysNeededValue,GetResString(IDS_X_IPS_ALWAYS_SHOW_PARTS_VALUE), m_htiShowAlwaysNeeded,GetResString(IDS_X_IPS_ALWAYS_SHOW_PARTS_VALUE_INFO));

			SetTreeGroup(m_ctrlTreeOptions,m_htiShowAlwaysIncomplete,GetResString(IDS_X_IPS_ALWAYS_SHOW_INCOMPLETE_PARTS),iImgShowI, m_htiInteligentPartSharing, GetResString(IDS_X_IPS_ALWAYS_SHOW_INCOMPLETE_PARTS_INFO));
				if(ForFile())
					SetTreeRadio(m_ctrlTreeOptions,m_htiShowAlwaysIncompleteDefault,GetResString(IDS_X_IPS_SHOW_ENABLE_DEFAULT),m_htiShowAlwaysIncomplete,GetResString(IDS_X_IPS_SHOW_ENABLE_DEFAULT_INFO),TRUE,m_iShowAlwaysIncomplete == 0);
				else
					SetTreeRadio(m_ctrlTreeOptions,m_htiDontHideUnderAvaliblyPartsDisable,GetResString(IDS_X_IPS_SHOW_ENABLE_DISABLE),m_htiShowAlwaysIncomplete,GetResString(IDS_X_IPS_SHOW_ENABLE_DISABLE_INFO),FALSE, m_iShowAlwaysIncomplete == 0);
				SetTreeRadio(m_ctrlTreeOptions,m_htiShowAlwaysIncompleteEnable,GetResString(ForFile() ? IDS_X_IPS_INCOMPLETE_SHOW_PARTS_FILE : IDS_X_IPS_SHOW_ENABLE_ENABLE),m_htiShowAlwaysIncomplete,GetResString(ForFile() ? IDS_X_IPS_INCOMPLETE_SHOW_PARTS_FILE_INFO : IDS_X_IPS_SHOW_ENABLE_ENABLE_INFO),ForFile(), m_iShowAlwaysIncomplete == 1);
				if(!ForFile())
					SetTreeRadio(m_ctrlTreeOptions,m_htiShowAlwaysIncompleteEnableAll,GetResString(IDS_X_IPS_SHOW_ENABLE_ENABLE_ALL),m_htiShowAlwaysIncomplete,GetResString(IDS_X_IPS_SHOW_ENABLE_ENABLE_ALL_INFO),FALSE, m_iShowAlwaysIncomplete == 2);
				else
					SetTreeRadio(m_ctrlTreeOptions,m_htiShowAlwaysIncompleteDisable,GetResString(IDS_X_IPS_SHOW_ENABLE_DISABLE),m_htiShowAlwaysIncomplete,GetResString(IDS_X_IPS_SHOW_ENABLE_DISABLE_INFO),TRUE, m_iShowAlwaysIncomplete == 2);
		// NEO: IPS END

		// NEO: RP - [RestrictivPublishing]
		if(ForFile()){
			SetTreeGroup(m_ctrlTreeOptions,m_htiPublishing,GetResString(IDS_X_PUBLISHING),iImgPublushing, m_htiReleaseTweaks, GetResString(IDS_X_PUBLISHING_INFO));
#ifdef LANCAST // NEO: NLC - [NeoLanCast]
				SetTreeCheck(m_ctrlTreeOptions,m_htiDisableSendLAN,GetResString(IDS_X_PUBLISHING_NO_LAN),m_htiPublishing,GetResString(IDS_X_PUBLISHING_NO_LAN_INFO),TRUE,m_bDisableSendLAN);
#endif //LANCAST // NEO: NLC END
#ifdef VOODOO // NEO: VOODOO - [UniversalPartfileInterface]
				SetTreeCheck(m_ctrlTreeOptions,m_htiDisableVoodoo,GetResString(IDS_X_PUBLISHING_NO_VOODOO),m_htiPublishing,GetResString(IDS_X_PUBLISHING_NO_VOODOO_INFO),TRUE,m_bDisableVoodoo);
#endif // VOODOO
		}
		// NEO: RP END

		// NEO: NST - [NeoSourceTweaks]
		if(ForFile())
			SetTreeCheckNumEdit(m_ctrlTreeOptions,m_htiXSAnswerLimit,GetResString(IDS_X_XS_FORSE_ANSWER), m_htiReleaseTweaks,GetResString(IDS_X_XS_FORSE_ANSWER_INFO), TRUE, m_bEnableSendXS);
		else
			SetTreeNumEdit(m_ctrlTreeOptions,m_htiXSAnswerLimit,GetResString(IDS_X_XS_ANSWER_LIMIT), m_htiReleaseTweaks,GetResString(IDS_X_XS_ANSWER_LIMIT_INFO));
		// NEO: NST END

		if(!ForFile()){
			m_ctrlTreeOptions.SetItemEnable(m_htiPartTraffic, m_uPartTraffic, TRUE, TRUE); // NEO: NPT - [NeoPartTraffic]

			// NEO: TQ - [TweakUploadQueue]
			m_ctrlTreeOptions.SetItemEnable(m_htiOldPrioritySystem, m_bUseMultiQueue ? FALSE : TRUE); // Munti Queue have his own priority score
			m_ctrlTreeOptions.SetGroupEnable(m_htiUploadQueueOverFlow, m_bInfiniteQueue ? FALSE : TRUE);

			// NEO: NMFS - [NiceMultiFriendSlots]
			m_ctrlTreeOptions.SetItemEnable(m_htiFriendSlotLimit, m_bFriendSlotLimit, TRUE, TRUE);
#ifdef NEO_UBT // NEO: BM - [BandwidthModeration]
			m_ctrlTreeOptions.SetItemEnable(m_htiFriendSlotSpeed, m_bSeparateFriendBandwidth);
			m_ctrlTreeOptions.SetItemEnable(m_htiFriendBandwidthPercentage, m_bSeparateFriendBandwidth);
#endif // NEO_UBT // NEO: BM END
			// NEO: NMFS END

			m_ctrlTreeOptions.SetItemEnable(m_htiQueueOverFlowRelease, m_uQueueOverFlowRelease == 2, TRUE, TRUE);
			m_ctrlTreeOptions.SetItemEnable(m_htiQueueOverFlowEx, m_uQueueOverFlowEx == 2, TRUE, TRUE);
			m_ctrlTreeOptions.SetItemEnable(m_htiQueueOverFlowDef, m_uQueueOverFlowDef == 2, TRUE, TRUE);
			m_ctrlTreeOptions.SetItemEnable(m_htiQueueOverFlowCF, m_uQueueOverFlowCF == 2, TRUE, TRUE);
			// NEO: TQ END

			m_ctrlTreeOptions.SetItemEnable(m_htiReleaseSlotLimit, m_uReleaseSlotLimit, TRUE, TRUE);
#ifdef NEO_UBT // NEO: BM - [BandwidthModeration]
			m_ctrlTreeOptions.SetItemEnable(m_htiReleaseSlotSpeed, m_uSeparateReleaseBandwidth);
			m_ctrlTreeOptions.SetItemEnable(m_htiReleaseBandwidthPercentage, m_uSeparateReleaseBandwidth);
#endif // NEO_UBT // NEO: BM END
		}

		if(CheckIPSEnable())
		{
			m_ctrlTreeOptions.SetItemEnable(m_htiHideOverAvaliblyCatchReal,thePrefs.UseRealPartStatus());
			m_ctrlTreeOptions.SetItemEnable(m_htiHideOverAvaliblyCatchRealHiden,thePrefs.UseRealPartStatus() && thePrefs.UseAntiHideOS());
			m_ctrlTreeOptions.SetItemEnable(m_htiHideOverAvaliblyCatchHiden,thePrefs.UseAntiHideOS());
		}

		m_bInitializedTreeOpts = true;
		m_ctrlTreeOptions.Expand(m_htiReleaseTweaks, TVE_EXPAND);
		//m_ctrlTreeOptions.Expand(m_htiReleasePriority, TVE_EXPAND);
		m_ctrlTreeOptions.Expand(m_htiInteligentPartSharing, TVE_EXPAND);

	}

	// NEO: NPT - [NeoPartTraffic]
	if(!ForFile()){
		DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiPartTraffic, m_uPartTraffic);
		
		if (pDX->m_bSaveAndValidate){
			CString sText;
			sText = m_ctrlTreeOptions.GetComboText(m_htiPartTraffic);
			if(sText == PT_EXPERT)
				m_iPartTrafficColor = 0;
			else if(sText == PT_NORMAL)
				m_iPartTrafficColor = 1;
			else if(sText == PT_BLUE)
				m_iPartTrafficColor = 2;
			else if(sText == PT_RED)
				m_iPartTrafficColor = 3;
		}else{
			CString sText;
			switch(m_iPartTrafficColor){
			case 0: sText = PT_EXPERT; break;
			case 1: sText = PT_NORMAL; break;
			case 2: sText = PT_BLUE; break;
			case 3: sText = PT_RED; break;
			}
			m_ctrlTreeOptions.SetComboText(m_htiPartTraffic, sText);
		}
	}
	// NEO: NPT END

	if(!ForFile()){
		// NEO: TQ - [TweakUploadQueue]
		DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiSaveUploadQueueWaitTime, m_bSaveUploadQueueWaitTime); // NEO: SQ - [SaveUploadQueue]
		DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiUseMultiQueue, m_bUseMultiQueue); // NEO: MQ - [MultiQueue]
		DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiUseRandomQueue, m_bUseRandomQueue); // NEO: RQ - [RandomQueue]
		DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiNeoScoreSystem, m_bNeoScoreSystem); // NEO: NFS - [NeoScoreSystem]
		//DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiNeoCreditSystem, m_bNeoCreditSystem); // NEO: NCS - [NeoCreditSystem]
		// NEO: OCS - [OtherCreditSystems]
		DDX_TreeRadio(pDX, IDC_MOD_OPTS, m_htiCreditSystem, m_iCreditSystem);
		DDX_TreeCS(&m_ctrlTreeOptions,pDX, IDC_MOD_OPTS, m_htiOtherCreditSystem, m_iOtherCreditSystem);
		// NEO: OCS END
		DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiInfiniteQueue, m_bInfiniteQueue);

			DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiQueueOverFlowRelease, m_uQueueOverFlowRelease);
			DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiQueueOverFlowRelease, m_iQueueOverFlowRelease);

			DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiQueueOverFlowEx, m_uQueueOverFlowEx);
			DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiQueueOverFlowEx, m_iQueueOverFlowEx);

			DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiQueueOverFlowDef, m_uQueueOverFlowDef);
			DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiQueueOverFlowDef, m_iQueueOverFlowDef);

			DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiQueueOverFlowCF, m_uQueueOverFlowCF);
			DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiQueueOverFlowCF, m_iQueueOverFlowCF);

		DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiOldPrioritySystem, m_bOldPrioritySystem);
		// NEO: TQ END

			// NEO: NMFS - [NiceMultiFriendSlots]
			DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiFriendSlotLimit, m_bFriendSlotLimit);
			DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiFriendSlotLimit, m_iFriendSlotLimit);
#ifdef NEO_UBT // NEO: BM - [BandwidthModeration]
			DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiSeparateFriendBandwidth, m_bSeparateFriendBandwidth);
			DDX_TreeEditE0f(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiFriendSlotSpeed, m_fFriendSlotSpeed);
			DDX_TreeEditE0f(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiFriendBandwidthPercentage, m_fFriendBandwidthPercentage);
#endif // NEO_UBT // NEO: BM END
			// NEO: NMFS END

		// NEO: PRSF - [PushSmallRareFiles]
		DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiPushSmallFiles, m_bPushSmallFiles);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiPushSmallFiles, m_iPushSmallFilesSize);

		DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiPushRareFiles, m_bPushRareFiles);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiPushRareFiles, m_iPushRareFilesValue);

		DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiPushRatioFiles, m_bPushRatioFiles);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiPushRatioFiles, m_iPushRatioFilesValue);
		// NEO: PRSF END
	}

	// NEO: NCAP - [NeoCustomAutoPriority]
	if(ForFile())
		DDX_TreeRadio(pDX, IDC_MOD_OPTS, m_htiAutoUpPriority, m_iDynamicAutoUpPriority);
	else
		DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiDynamicAutoUpPriorityEnable, m_bDynamicAutoUpPriority);
	DDX_TreeEditE0f(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiDynamicAutoUpPriorityEnable, m_fDynamicUpPriorityFactor);
	DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiLowUpPrioThreshold, m_iLowUpPrioThreshold);
	DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiHighUpPrioThreshold, m_iHighUpPrioThreshold);
	// NEO: NCAP END

	// NEO: RT - [ReleaseTweaks]
	DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiReleasePriorityLevel, m_iReleaseLevel);
	DDX_TreeRadio(pDX, IDC_MOD_OPTS, m_htiReleasePriorityMode, m_iReleaseMode);

	//
		DDX_TreeRadio(pDX, IDC_MOD_OPTS, m_htiReleaseLimit, m_iReleaseLimit);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiReleaseLimitHigh, m_iReleaseLimitHigh);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiReleaseLimitLow, m_iReleaseLimitLow);
		DDX_TreeRadio(pDX, IDC_MOD_OPTS, m_htiReleaseLimitMode, m_iReleaseLimitMode);

		if(!ForFile()){
			DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiReleaseLimitUnion, m_bReleaseLimitUnion);
		}else{
			DDX_TreeRadio(pDX, IDC_MOD_OPTS, m_htiReleaseLimitUnion, m_iReleaseLimitUnion);
		}

		DDX_TreeRadio(pDX, IDC_MOD_OPTS, m_htiReleaseLimitComplete, m_iReleaseLimitComplete);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiReleaseLimitCompleteHigh, m_iReleaseLimitCompleteHigh);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiReleaseLimitCompleteLow, m_iReleaseLimitCompleteLow);
		DDX_TreeRadio(pDX, IDC_MOD_OPTS, m_htiReleaseLimitCompleteMode, m_iReleaseLimitCompleteMode);

	if(!ForFile()){
		DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiLimitUnion, m_bLimitUnion);
	}else{
		DDX_TreeRadio(pDX, IDC_MOD_OPTS, m_htiLimitUnion, m_iLimitUnion);
	}

		DDX_TreeRadio(pDX, IDC_MOD_OPTS, m_htiSourceLimit, m_iSourceLimit);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiSourceLimitHigh, m_iSourceLimitHigh);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiSourceLimitLow, m_iSourceLimitLow);
		DDX_TreeRadio(pDX, IDC_MOD_OPTS, m_htiSourceLimitMode, m_iSourceLimitMode);

		if(!ForFile()){
			DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiSourceLimitUnion, m_bSourceLimitUnion);
		}else{
			DDX_TreeRadio(pDX, IDC_MOD_OPTS, m_htiSourceLimitUnion, m_iSourceLimitUnion);
		}

		DDX_TreeRadio(pDX, IDC_MOD_OPTS, m_htiSourceLimitComplete, m_iSourceLimitComplete);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiSourceLimitCompleteHigh, m_iSourceLimitCompleteHigh);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiSourceLimitCompleteLow, m_iSourceLimitCompleteLow);
		DDX_TreeRadio(pDX, IDC_MOD_OPTS, m_htiSourceLimitCompleteMode, m_iSourceLimitCompleteMode);

	//

	if(!ForFile()){
		DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiReleasePriorityNeedComplete, m_bReleaseNeedComplete);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiReleasePriorityNeedComplete, m_iReleaseNeedCompleteLimit);
	}else{
		DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiReleasePriorityNeedComplete, m_iReleaseNeedComplete);
	}

	if(!ForFile()){
		DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiReleaseSlotLimit, m_uReleaseSlotLimit);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiReleaseSlotLimit, m_iReleaseSlotLimit);
#ifdef NEO_UBT // NEO: BM - [BandwidthModeration]
		DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiSeparateReleaseBandwidth, m_uSeparateReleaseBandwidth);
		DDX_TreeEditE0f(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiReleaseSlotSpeed, m_fReleaseSlotSpeed);
		DDX_TreeEditE0f(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiReleaseBandwidthPercentage, m_fReleaseBandwidthPercentage);
#endif // NEO_UBT // NEO: BM END
	}
	// NEO: RT END

	// NEO: IPS - [InteligentPartSharing]
	if(!ForFile()){
		DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiInteligentPartSharingEnable, m_bInteligentPartSharing);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiInteligentPartSharingTimer, m_iInteligentPartSharingTimer);
	}
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiMaxProzentToHide, m_iMaxProzentToHide);
		// OA>
		DDX_TreeRadio(pDX, IDC_MOD_OPTS, m_htiHideOverAvaliblyParts, m_iHideOverAvaliblyParts);
			DDX_TreeRadio(pDX, IDC_MOD_OPTS, m_htiHideOverAvaliblyMode, m_iHideOverAvaliblyMode);
			DDX_TreeEditE0f(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiHideOverAvaliblyValue, m_fHideOverAvaliblyValue);
			DDX_TreeRadio(pDX, IDC_MOD_OPTS, m_htiBlockHighOverAvaliblyParts, m_iBlockHighOverAvaliblyParts);
				DDX_TreeEditE0f(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiBlockHighOverAvaliblyFactor, m_fBlockHighOverAvaliblyFactor);
			DDX_TreeRadio(pDX, IDC_MOD_OPTS, m_htiHideOverAvaliblyCatch, m_iHideOverAvaliblyCatch);
		// <OA
		// OS>
		DDX_TreeRadio(pDX, IDC_MOD_OPTS, m_htiHideOverSharedParts, m_iHideOverSharedParts);
			DDX_TreeRadio(pDX, IDC_MOD_OPTS, m_htiHideOverSharedMode, m_iHideOverSharedMode);
			DDX_TreeEditE0f(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiHideOverSharedValue, m_fHideOverSharedValue);
			// UA>
			DDX_TreeRadio(pDX, IDC_MOD_OPTS, m_htiDontHideUnderAvaliblyParts, m_iDontHideUnderAvaliblyParts);
				DDX_TreeEditE0f(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiDontHideUnderAvaliblyValue, m_fDontHideUnderAvaliblyValue);
				DDX_TreeRadio(pDX, IDC_MOD_OPTS, m_htiDontHideUnderAvaliblyMode, m_iDontHideUnderAvaliblyMode);
			// <UA
			DDX_TreeRadio(pDX, IDC_MOD_OPTS, m_htiBlockHighOverSharedParts, m_iBlockHighOverSharedParts);
				DDX_TreeEditE0f(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiBlockHighOverSharedFactor, m_fBlockHighOverSharedFactor);
			DDX_TreeRadio(pDX, IDC_MOD_OPTS, m_htiHideOverSharedCalc, m_iHideOverSharedCalc);
		// <OS
		DDX_TreeRadio(pDX, IDC_MOD_OPTS, m_htiShowAlwaysNeeded, m_iShowAlwaysNeeded);
			DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiShowAlwaysNeededValue, m_iShowAlwaysParts);
		DDX_TreeRadio(pDX, IDC_MOD_OPTS, m_htiShowAlwaysIncomplete, m_iShowAlwaysIncomplete);
	// NEO: IPS END

	// NEO: RP - [RestrictivPublishing]
	if(ForFile()){
#ifdef LANCAST // NEO: NLC - [NeoLanCast]
		DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiDisableSendLAN, m_bDisableSendLAN);
#endif //LANCAST // NEO: NLC END
#ifdef VOODOO // NEO: VOODOO - [UniversalPartfileInterface]
		DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiDisableVoodoo, m_bDisableVoodoo);
#endif // VOODOO
	}
	// NEO: RP END

	// NEO: NST - [NeoSourceTweaks]
	if(ForFile())
		DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiXSAnswerLimit, m_bEnableSendXS);
	DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiXSAnswerLimit, m_iXSAnswerLimit);
	// NEO: NST END

}

BOOL CPPgRelease::OnInitDialog()
{
	if(!m_bFilePreferences)
		LoadSettings();
	else
		RefreshData();

	CPropertyPage::OnInitDialog();
	InitWindowStyles(this);

	// NEO: FCFG - [FileConfiguration]
	// no need to explicitly call 'RefreshData' here, 'OnSetActive' will be called right after 'OnInitDialog'

	// start time for calling 'RefreshData'
	if(m_bFilePreferences)
		VERIFY( (m_timer = SetTimer(301, 5000, 0)) != NULL );
	// NEO: FCFG END

	return TRUE;  // return TRUE unless you set the focus to a control
				  // EXCEPTION: OCX Property Pages should return FALSE
}

BOOL CPPgRelease::OnApply()
{
	// if prop page is closed by pressing ENTER we have to explicitly commit any possibly pending
	// data from an open edit control
	m_ctrlTreeOptions.HandleChildControlLosingFocus();

	if (!UpdateData())
		return FALSE;

	if(!m_bFilePreferences){
		/*
		* Globale Einstellungen Speichern
		*/

		// NEO: NPT - [NeoPartTraffic]
		UINT OldNPTState = thePrefs.m_uPartTraffic; 
		int OldColor = thePrefs.m_iPartTrafficColor;
		thePrefs.m_uPartTraffic = m_uPartTraffic; 
		thePrefs.m_iPartTrafficColor = m_iPartTrafficColor; 
		if(OldColor != m_iPartTrafficColor)
			theApp.emuledlg->sharedfileswnd->sharedfilesctrl.SetColoring(m_iPartTrafficColor);
		if(OldNPTState != thePrefs.m_uPartTraffic) {
			if(thePrefs.m_uPartTraffic && !theApp.knownfiles->IsPartTrafficLoaded())
				theApp.knownfiles->LoadPartTraffic();
			if(thePrefs.m_uPartTraffic == 1)
				theApp.emuledlg->sharedfileswnd->sharedfilesctrl.ShowColumn(13);
			else
				theApp.emuledlg->sharedfileswnd->sharedfilesctrl.HideColumn(13);
			if(thePrefs.m_uPartTraffic)
				theApp.emuledlg->sharedfileswnd->sharedfilesctrl.ShowColumn(14);
			else
				theApp.emuledlg->sharedfileswnd->sharedfilesctrl.HideColumn(14);
		}


		// NEO: NPT END

		// NEO: TQ - [TweakUploadQueue]
		thePrefs.m_bSaveUploadQueueWaitTime = m_bSaveUploadQueueWaitTime; // NEO: SQ - [SaveUploadQueue]
		thePrefs.m_bUseMultiQueue = m_bUseMultiQueue; // NEO: MQ - [MultiQueue]
		thePrefs.m_bUseRandomQueue = m_bUseRandomQueue; // NEO: RQ - [RandomQueue]

		thePrefs.m_bNeoScoreSystem = m_bNeoScoreSystem; // NEO: NFS - [NeoScoreSystem]
		//thePrefs.m_bNeoCreditSystem = m_bNeoCreditSystem; // NEO: NCS - [NeoCreditSystem]
		// NEO: OCS - [OtherCreditSystems]
		if(m_iCreditSystem == 0){
			thePrefs.m_bNeoCreditSystem = false;
			thePrefs.m_iOtherCreditSystem = 0;
		}else if(m_iCreditSystem == 1){
			thePrefs.m_bNeoCreditSystem = true;
			thePrefs.m_iOtherCreditSystem = 0;
		}else{
			thePrefs.m_bNeoCreditSystem = false;
			thePrefs.m_iOtherCreditSystem = m_iOtherCreditSystem;
		}
		// NEO: OCS END

		thePrefs.m_bInfiniteQueue = m_bInfiniteQueue;

		thePrefs.m_uQueueOverFlowRelease = m_uQueueOverFlowRelease;
		if(m_iQueueOverFlowRelease) thePrefs.m_iQueueOverFlowRelease = m_iQueueOverFlowRelease;

		thePrefs.m_uQueueOverFlowEx = m_uQueueOverFlowEx;
		if(m_iQueueOverFlowEx) thePrefs.m_iQueueOverFlowEx = m_iQueueOverFlowEx;

		thePrefs.m_uQueueOverFlowDef = m_uQueueOverFlowDef;
		if(m_iQueueOverFlowDef) thePrefs.m_iQueueOverFlowDef = m_iQueueOverFlowDef;

		thePrefs.m_uQueueOverFlowCF = m_uQueueOverFlowCF;
		if(m_iQueueOverFlowCF) thePrefs.m_iQueueOverFlowCF = m_iQueueOverFlowCF;

		thePrefs.m_bOldPrioritySystem = m_bOldPrioritySystem;
		// NEO: TQ END

		// NEO: NMFS - [NiceMultiFriendSlots]
		thePrefs.m_bFriendSlotLimit = m_bFriendSlotLimit;
		if(m_iFriendSlotLimit) thePrefs.m_iFriendSlotLimit = m_iFriendSlotLimit;
#ifdef NEO_UBT // NEO: BM - [BandwidthModeration]
		thePrefs.m_bSeparateFriendBandwidth = m_bSeparateFriendBandwidth;
		if(m_fFriendSlotSpeed) thePrefs.m_fFriendSlotSpeed = m_fFriendSlotSpeed;
		if(m_fFriendBandwidthPercentage) thePrefs.m_fFriendBandwidthPercentage = m_fFriendBandwidthPercentage;
#endif // NEO_UBT // NEO: BM END
		// NEO: NMFS END

		// NEO: PRSF - [PushSmallRareFiles]
		thePrefs.m_bPushSmallFiles = m_bPushSmallFiles;
		if(m_iPushSmallFilesSize) thePrefs.m_iPushSmallFilesSize = m_iPushSmallFilesSize;

		thePrefs.m_bPushRareFiles = m_bPushRareFiles;
		if(m_iPushRareFilesValue) thePrefs.m_iPushRareFilesValue = m_iPushRareFilesValue;

		thePrefs.m_bPushRatioFiles = m_bPushRatioFiles;
		if(m_iPushRatioFilesValue) thePrefs.m_iPushRatioFilesValue = m_iPushRatioFilesValue;
		// NEO: PRSF END

		// NEO: NCAP - [NeoCustomAutoPriority]
		thePrefs.m_bDynamicAutoUpPriority = m_bDynamicAutoUpPriority;
		if(m_fDynamicUpPriorityFactor) thePrefs.m_fDynamicUpPriorityFactor = m_fDynamicUpPriorityFactor;
		if(m_iLowUpPrioThreshold) thePrefs.m_iLowUpPrioThreshold = m_iLowUpPrioThreshold;
		if(m_iHighUpPrioThreshold) thePrefs.m_iHighUpPrioThreshold = m_iHighUpPrioThreshold;
		// NEO: NCAP END

		// NEO: RT - [ReleaseTweaks]
		thePrefs.m_iReleaseLevel = m_iReleaseLevel;
		thePrefs.m_iReleaseMode = m_iReleaseMode;

		thePrefs.m_iReleaseLimitMode = m_iReleaseLimitMode;
		thePrefs.m_bReleaseLimitUnion = m_bReleaseLimitUnion;
		thePrefs.m_iReleaseLimitCompleteMode = m_iReleaseLimitCompleteMode;

		thePrefs.m_iReleaseLimit = m_iReleaseLimit;
		if(m_iReleaseLimitHigh) thePrefs.m_iReleaseLimitHigh = m_iReleaseLimitHigh;
		if(m_iReleaseLimitLow) thePrefs.m_iReleaseLimitLow = m_iReleaseLimitLow;

		thePrefs.m_iReleaseLimitComplete = m_iReleaseLimitComplete;
		if(m_iReleaseLimitCompleteHigh) thePrefs.m_iReleaseLimitCompleteHigh = m_iReleaseLimitCompleteHigh;
		if(m_iReleaseLimitCompleteLow) thePrefs.m_iReleaseLimitCompleteLow = m_iReleaseLimitCompleteLow;

		thePrefs.m_bLimitUnion = m_bLimitUnion;

		thePrefs.m_iSourceLimitMode = m_iSourceLimitMode;
		thePrefs.m_bSourceLimitUnion = m_bSourceLimitUnion;
		thePrefs.m_iSourceLimitCompleteMode = m_iSourceLimitCompleteMode;

		thePrefs.m_iSourceLimit = m_iSourceLimit;
		if(m_iSourceLimitHigh) thePrefs.m_iSourceLimitHigh = m_iSourceLimitHigh;
		if(m_iSourceLimitLow) thePrefs.m_iSourceLimitLow = m_iSourceLimitLow;

		thePrefs.m_iSourceLimitComplete = m_iSourceLimitComplete;
		if(m_iSourceLimitCompleteHigh) thePrefs.m_iSourceLimitCompleteHigh = m_iSourceLimitCompleteHigh;
		if(m_iSourceLimitCompleteLow) thePrefs.m_iSourceLimitCompleteLow = m_iSourceLimitCompleteLow;

		thePrefs.m_bReleaseNeedComplete = m_bReleaseNeedComplete;
		if(m_iReleaseNeedCompleteLimit) thePrefs.m_iReleaseNeedCompleteLimit = m_iReleaseNeedCompleteLimit;

		thePrefs.m_uReleaseSlotLimit = m_uReleaseSlotLimit;
		if(m_iReleaseSlotLimit) thePrefs.m_iReleaseSlotLimit = m_iReleaseSlotLimit;
#ifdef NEO_UBT // NEO: BM - [BandwidthModeration]
		thePrefs.m_uSeparateReleaseBandwidth = m_uSeparateReleaseBandwidth;
		if(m_fReleaseSlotSpeed) thePrefs.m_fReleaseSlotSpeed = m_fReleaseSlotSpeed;
		if(m_fReleaseBandwidthPercentage) thePrefs.m_fReleaseBandwidthPercentage = m_fReleaseBandwidthPercentage;
#endif // NEO_UBT // NEO: BM END
		// NEO: RT END

		// NEO: IPS - [InteligentPartSharing]
		thePrefs.m_bInteligentPartSharing = m_bInteligentPartSharing;
		if(m_iInteligentPartSharingTimer) thePrefs.m_iInteligentPartSharingTimer = m_iInteligentPartSharingTimer;
		if(m_iMaxProzentToHide) thePrefs.m_iMaxProzentToHide = m_iMaxProzentToHide;

		thePrefs.m_iHideOverAvaliblyParts = m_iHideOverAvaliblyParts;
		thePrefs.m_iHideOverAvaliblyMode = m_iHideOverAvaliblyMode;
		if(m_fHideOverAvaliblyValue) thePrefs.m_fHideOverAvaliblyValue = m_fHideOverAvaliblyValue;
		thePrefs.m_iHideOverAvaliblyCatch = m_iHideOverAvaliblyCatch;

		thePrefs.m_iHideOverSharedParts = m_iHideOverSharedParts;
		thePrefs.m_iHideOverSharedMode = m_iHideOverSharedMode;
		if(m_fHideOverSharedValue) thePrefs.m_fHideOverSharedValue = m_fHideOverSharedValue;
		thePrefs.m_iHideOverSharedCalc = m_iHideOverSharedCalc;
		
		thePrefs.m_iDontHideUnderAvaliblyParts = m_iDontHideUnderAvaliblyParts;
		thePrefs.m_iDontHideUnderAvaliblyMode = m_iDontHideUnderAvaliblyMode;
		if(m_fDontHideUnderAvaliblyValue) thePrefs.m_fDontHideUnderAvaliblyValue = m_fDontHideUnderAvaliblyValue;

		thePrefs.m_iBlockHighOverAvaliblyParts = m_iBlockHighOverAvaliblyParts;
		if(m_fBlockHighOverAvaliblyFactor) thePrefs.m_fBlockHighOverAvaliblyFactor = m_fBlockHighOverAvaliblyFactor;

		thePrefs.m_iBlockHighOverSharedParts = m_iBlockHighOverSharedParts;
		if(m_fBlockHighOverSharedFactor) thePrefs.m_fBlockHighOverSharedFactor = m_fBlockHighOverSharedFactor;

		thePrefs.m_iShowAlwaysNeeded = m_iShowAlwaysNeeded;
		if(m_iShowAlwaysParts) thePrefs.m_iShowAlwaysParts = m_iShowAlwaysParts;
		thePrefs.m_iShowAlwaysIncomplete = m_iShowAlwaysIncomplete;

		if(m_iXSAnswerLimit) thePrefs.m_iXSAnswerLimit = m_iXSAnswerLimit; // NEO: NST - [NeoSourceTweaks]

		thePrefs.CheckNeoPreferences();
		LoadSettings();
		// NEO: IPS END
	}else{
		/*
		* Datei Einstellungen Speichern
		*/

		// NEO: FCFG - [FileConfiguration]
		CKnownFile* file;
		for (int i = 0; i < m_paFiles->GetSize(); i++)
		{
			file = STATIC_DOWNCAST(CKnownFile, (*m_paFiles)[i]);

			// NEO: NCAP - [NeoCustomAutoPriority]
			if(m_iDynamicAutoUpPriority != -1) file->KnownPrefs.m_iDynamicAutoUpPriority = m_iDynamicAutoUpPriority;
			if(m_fDynamicUpPriorityFactor) file->KnownPrefs.m_fDynamicUpPriorityFactor = (m_fDynamicUpPriorityFactor != thePrefs.GetDynamicUpPriorityFactor()) ? m_fDynamicUpPriorityFactor : 0;
			if(m_iLowUpPrioThreshold) file->KnownPrefs.m_iLowUpPrioThreshold = (m_iLowUpPrioThreshold != thePrefs.GetLowUpPrioThreshold()) ? m_iLowUpPrioThreshold : 0;
			if(m_iHighUpPrioThreshold) file->KnownPrefs.m_iHighUpPrioThreshold = (m_iHighUpPrioThreshold != thePrefs.GetHighUpPrioThreshold()) ? m_iHighUpPrioThreshold : 0;
			// NEO: NCAP END

			// NEO: RT - [ReleaseTweaks]
			if(m_iReleaseLevel) file->KnownPrefs.m_iReleaseLevel = m_iReleaseLevel;
			if(m_iReleaseMode != -1) file->KnownPrefs.m_iReleaseMode = m_iReleaseMode;

			if(m_iReleaseLimitMode != -1) file->KnownPrefs.m_iReleaseLimitMode = m_iReleaseLimitMode;
			if(m_iReleaseLimitUnion != -1) file->KnownPrefs.m_iReleaseLimitUnion = m_iReleaseLimitUnion;
			if(m_iReleaseLimitCompleteMode != -1) file->KnownPrefs.m_iReleaseLimitCompleteMode = m_iReleaseLimitCompleteMode;

			if(m_iReleaseLimit != -1) file->KnownPrefs.m_iReleaseLimit = m_iReleaseLimit;
			if(m_iReleaseLimitHigh) file->KnownPrefs.m_iReleaseLimitHigh = (m_iReleaseLimitHigh != thePrefs.GetReleaseLimitHigh()) ? m_iReleaseLimitHigh : 0;
			if(m_iReleaseLimitLow) file->KnownPrefs.m_iReleaseLimitLow = (m_iReleaseLimitLow != thePrefs.GetReleaseLimitLow()) ? m_iReleaseLimitLow : 0;

			if(m_iReleaseLimitComplete != -1) file->KnownPrefs.m_iReleaseLimitComplete = m_iReleaseLimitComplete;
			if(m_iReleaseLimitCompleteHigh) file->KnownPrefs.m_iReleaseLimitCompleteHigh = (m_iReleaseLimitCompleteHigh != thePrefs.GetReleaseLimitCompleteHigh()) ? m_iReleaseLimitCompleteHigh : 0;
			if(m_iReleaseLimitCompleteLow) file->KnownPrefs.m_iReleaseLimitCompleteLow = (m_iReleaseLimitCompleteLow != thePrefs.GetReleaseLimitCompleteLow()) ? m_iReleaseLimitCompleteLow : 0;

			if(m_iLimitUnion != -1) file->KnownPrefs.m_iLimitUnion = m_iLimitUnion;

			if(m_iSourceLimitMode != -1) file->KnownPrefs.m_iSourceLimitMode = m_iSourceLimitMode;
			if(m_iSourceLimitUnion != -1) file->KnownPrefs.m_iSourceLimitUnion = m_iSourceLimitUnion;
			if(m_iSourceLimitCompleteMode != -1) file->KnownPrefs.m_iSourceLimitCompleteMode = m_iSourceLimitCompleteMode;

			if(m_iSourceLimit != -1) file->KnownPrefs.m_iSourceLimit = m_iSourceLimit;
			if(m_iSourceLimitHigh) file->KnownPrefs.m_iSourceLimitHigh = (m_iSourceLimitHigh != thePrefs.GetSourceLimitHigh()) ? m_iSourceLimitHigh : 0;
			if(m_iSourceLimitLow) file->KnownPrefs.m_iSourceLimitLow = (m_iSourceLimitLow != thePrefs.GetSourceLimitLow()) ? m_iSourceLimitLow : 0;

			if(m_iSourceLimitComplete != -1) file->KnownPrefs.m_iSourceLimitComplete = m_iSourceLimitComplete;
			if(m_iSourceLimitCompleteHigh) file->KnownPrefs.m_iSourceLimitCompleteHigh = (m_iSourceLimitCompleteHigh != thePrefs.GetSourceLimitCompleteHigh()) ? m_iSourceLimitCompleteHigh : 0;
			if(m_iSourceLimitCompleteLow) file->KnownPrefs.m_iSourceLimitCompleteLow = (m_iSourceLimitCompleteLow != thePrefs.GetSourceLimitCompleteLow()) ? m_iSourceLimitCompleteLow : 0;

			if(m_iReleaseNeedComplete != BST_INDETERMINATE) file->KnownPrefs.m_iReleaseDisableNeedComplete = m_iReleaseNeedComplete;
			// NEO: RT END

			// NEO: IPS - [InteligentPartSharing]
			if(m_iMaxProzentToHide) file->KnownPrefs.m_iMaxProzentToHide = (m_iMaxProzentToHide != thePrefs.GetMaxProzentToHide()) ? m_iMaxProzentToHide : 0;

			if(m_iHideOverAvaliblyParts != -1) file->KnownPrefs.m_iHideOverAvaliblyParts = m_iHideOverAvaliblyParts;
			if(m_iHideOverAvaliblyMode != -1) file->KnownPrefs.m_iHideOverAvaliblyMode = m_iHideOverAvaliblyMode;
			if(m_fHideOverAvaliblyValue) file->KnownPrefs.m_fHideOverAvaliblyValue = (m_fHideOverAvaliblyValue != thePrefs.GetHideOverAvaliblyValue()) ? m_fHideOverAvaliblyValue : 0;
			if(m_iHideOverAvaliblyCatch != -1) file->KnownPrefs.m_iHideOverAvaliblyCatch = m_iHideOverAvaliblyCatch;

			if(m_iHideOverSharedParts != -1) file->KnownPrefs.m_iHideOverSharedParts = m_iHideOverSharedParts;
			if(m_iHideOverSharedMode != -1) file->KnownPrefs.m_iHideOverSharedMode = m_iHideOverSharedMode;
			if(m_fHideOverSharedValue) file->KnownPrefs.m_fHideOverSharedValue = (m_fHideOverSharedValue != thePrefs.GetHideOverSharedValue()) ? m_fHideOverSharedValue : 0;
			if(m_iHideOverSharedCalc != -1) file->KnownPrefs.m_iHideOverSharedCalc = m_iHideOverSharedCalc;
			
			if(m_iDontHideUnderAvaliblyParts != -1) file->KnownPrefs.m_iDontHideUnderAvaliblyParts = m_iDontHideUnderAvaliblyParts;
			if(m_iDontHideUnderAvaliblyMode != -1) 	file->KnownPrefs.m_iDontHideUnderAvaliblyMode = m_iDontHideUnderAvaliblyMode;
			if(m_fDontHideUnderAvaliblyValue) file->KnownPrefs.m_fDontHideUnderAvaliblyValue = (m_fDontHideUnderAvaliblyValue != thePrefs.GetDontHideUnderAvaliblyValue()) ? m_fDontHideUnderAvaliblyValue : 0;

			if(m_iBlockHighOverAvaliblyParts != -1) file->KnownPrefs.m_iBlockHighOverAvaliblyParts = m_iBlockHighOverAvaliblyParts;
			if(m_fBlockHighOverAvaliblyFactor) file->KnownPrefs.m_fBlockHighOverAvaliblyFactor = (m_fBlockHighOverAvaliblyFactor != thePrefs.GetBlockHighOverAvaliblyFactor()) ? m_fBlockHighOverAvaliblyFactor : 0;

			if(m_iBlockHighOverSharedParts != -1) file->KnownPrefs.m_iBlockHighOverSharedParts = m_iBlockHighOverSharedParts;
			if(m_fBlockHighOverSharedFactor) file->KnownPrefs.m_fBlockHighOverSharedFactor = (m_fBlockHighOverSharedFactor != thePrefs.GetBlockHighOverSharedFactor()) ? m_fBlockHighOverSharedFactor : 0;

			if(m_iShowAlwaysNeeded != -1) file->KnownPrefs.m_iShowAlwaysNeeded = m_iShowAlwaysNeeded;
			if(m_iShowAlwaysParts) file->KnownPrefs.m_iShowAlwaysParts = (m_iShowAlwaysParts != thePrefs.GetShowAlwaysParts()) ? m_iShowAlwaysParts : 0;

			if(m_iShowAlwaysIncomplete != -1) file->KnownPrefs.m_iShowAlwaysIncomplete = m_iShowAlwaysIncomplete;
			// NEO: IPS END

			// NEO: RP - [RestrictivPublishing]
#ifdef LANCAST // NEO: NLC - [NeoLanCast]
			if(m_bDisableSendLAN != BST_INDETERMINATE) file->KnownPrefs.m_bDisableSendLAN = I2B(m_bDisableSendLAN);
#endif //LANCAST // NEO: NLC END
#ifdef VOODOO // NEO: VOODOO - [UniversalPartfileInterface]
			if(m_bDisableVoodoo != BST_INDETERMINATE) file->KnownPrefs.m_bDisableVoodoo = I2B(m_bDisableVoodoo);
#endif // VOODOO
			// NEO: RP END

			if(m_iXSAnswerLimit) file->KnownPrefs.m_iXSAnswerLimit = (m_iXSAnswerLimit != thePrefs.GetXSAnswerLimit()) ? m_iXSAnswerLimit : 0;
			if(m_bEnableSendXS != BST_INDETERMINATE) file->KnownPrefs.m_bEnableSendXS = I2B(m_bEnableSendXS);

			file->KnownPrefs.CheckTweaks();
		}

		RefreshData();
		// NEO: FCFG END
	}
	

	SetModified(FALSE);
	return CPropertyPage::OnApply();
}

void CPPgRelease::LoadSettings()
{
	/*
	* Globale Einstellungen Laden
	*/

	m_uPartTraffic = thePrefs.m_uPartTraffic; // NEO: NPT - [NeoPartTraffic]
	m_iPartTrafficColor = thePrefs.m_iPartTrafficColor; // NEO: NPT - [NeoPartTraffic]

	// NEO: TQ - [TweakUploadQueue]
	m_bSaveUploadQueueWaitTime = thePrefs.m_bSaveUploadQueueWaitTime; // NEO: SQ - [SaveUploadQueue]
	m_bUseMultiQueue = thePrefs.m_bUseMultiQueue; // NEO: MQ - [MultiQueue]
	m_bUseRandomQueue = thePrefs.m_bUseRandomQueue; // NEO: RQ - [RandomQueue]

	m_bNeoScoreSystem = thePrefs.m_bNeoScoreSystem; // NEO: NFS - [NeoScoreSystem]
	//m_bNeoCreditSystem = thePrefs.m_bNeoCreditSystem; // NEO: NCS - [NeoCreditSystem]
	// NEO: OCS - [OtherCreditSystems]
	if(thePrefs.m_bNeoCreditSystem){
		m_iCreditSystem = 1;
		m_iOtherCreditSystem = 0;
	}else if(thePrefs.m_iOtherCreditSystem > 0){
		m_iCreditSystem = 2;
		m_iOtherCreditSystem = thePrefs.m_iOtherCreditSystem;
	}else{
		m_iCreditSystem = 0;
		m_iOtherCreditSystem = 0;
	}
	// NEO: OCS END

	m_bInfiniteQueue = thePrefs.m_bInfiniteQueue;

	m_uQueueOverFlowRelease = thePrefs.m_uQueueOverFlowRelease;
	m_iQueueOverFlowRelease = thePrefs.m_iQueueOverFlowRelease;

	m_uQueueOverFlowEx = thePrefs.m_uQueueOverFlowEx;
	m_iQueueOverFlowEx = thePrefs.m_iQueueOverFlowEx;

	m_uQueueOverFlowDef = thePrefs.m_uQueueOverFlowDef;
	m_iQueueOverFlowDef = thePrefs.m_iQueueOverFlowDef;

	m_uQueueOverFlowCF = thePrefs.m_uQueueOverFlowCF;
	m_iQueueOverFlowCF = thePrefs.m_iQueueOverFlowCF;

	m_bOldPrioritySystem = thePrefs.m_bOldPrioritySystem;
	// NEO: TQ END

	// NEO: NMFS - [NiceMultiFriendSlots]
	m_bFriendSlotLimit = thePrefs.m_bFriendSlotLimit;
	m_iFriendSlotLimit = thePrefs.m_iFriendSlotLimit;
#ifdef NEO_UBT // NEO: BM - [BandwidthModeration]
	m_bSeparateFriendBandwidth = thePrefs.m_bSeparateFriendBandwidth;
	m_fFriendSlotSpeed = thePrefs.m_fFriendSlotSpeed;
	m_fFriendBandwidthPercentage = thePrefs.m_fFriendBandwidthPercentage;
#endif // NEO_UBT // NEO: BM END
	// NEO: NMFS END

	// NEO: PRSF - [PushSmallRareFiles]
	m_bPushSmallFiles = thePrefs.m_bPushSmallFiles;
	m_iPushSmallFilesSize = thePrefs.m_iPushSmallFilesSize;

	m_bPushRareFiles = thePrefs.m_bPushRareFiles;
	m_iPushRareFilesValue = thePrefs.m_iPushRareFilesValue;

	m_bPushRatioFiles = thePrefs.m_bPushRatioFiles;
	m_iPushRatioFilesValue = thePrefs.m_iPushRatioFilesValue;
	// NEO: PRSF END

	// NEO: NCAP - [NeoCustomAutoPriority]
	m_bDynamicAutoUpPriority = thePrefs.m_bDynamicAutoUpPriority;
	m_fDynamicUpPriorityFactor = thePrefs.m_fDynamicUpPriorityFactor;
	m_iLowUpPrioThreshold = thePrefs.m_iLowUpPrioThreshold;
	m_iHighUpPrioThreshold = thePrefs.m_iHighUpPrioThreshold;
	// NEO: NCAP END

	// NEO: RT - [ReleaseTweaks]
	m_iReleaseLevel = thePrefs.m_iReleaseLevel;
	m_iReleaseMode = thePrefs.m_iReleaseMode;

	m_iReleaseLimitMode = thePrefs.m_iReleaseLimitMode;
	m_bReleaseLimitUnion = thePrefs.m_bReleaseLimitUnion;
	m_iReleaseLimitCompleteMode = thePrefs.m_iReleaseLimitCompleteMode;

	m_iReleaseLimit = thePrefs.m_iReleaseLimit;
	m_iReleaseLimitHigh = thePrefs.m_iReleaseLimitHigh;
	m_iReleaseLimitLow = thePrefs.m_iReleaseLimitLow;

	m_iReleaseLimitComplete = thePrefs.m_iReleaseLimitComplete;
	m_iReleaseLimitCompleteHigh = thePrefs.m_iReleaseLimitCompleteHigh;
	m_iReleaseLimitCompleteLow = thePrefs.m_iReleaseLimitCompleteLow;

	m_bLimitUnion = thePrefs.m_bLimitUnion;

	m_iSourceLimitMode = thePrefs.m_iSourceLimitMode;
	m_bSourceLimitUnion = thePrefs.m_bSourceLimitUnion;
	m_iSourceLimitCompleteMode = thePrefs.m_iSourceLimitCompleteMode;

	m_iSourceLimit = thePrefs.m_iSourceLimit;
	m_iSourceLimitHigh = thePrefs.m_iSourceLimitHigh;
	m_iSourceLimitLow = thePrefs.m_iSourceLimitLow;

	m_iSourceLimitComplete = thePrefs.m_iSourceLimitComplete;
	m_iSourceLimitCompleteHigh = thePrefs.m_iSourceLimitCompleteHigh;
	m_iSourceLimitCompleteLow = thePrefs.m_iSourceLimitCompleteLow;

	m_bReleaseNeedComplete = thePrefs.m_bReleaseNeedComplete;
	m_iReleaseNeedCompleteLimit = thePrefs.m_iReleaseNeedCompleteLimit;

	m_uReleaseSlotLimit = thePrefs.m_uReleaseSlotLimit;
	m_iReleaseSlotLimit = thePrefs.m_iReleaseSlotLimit;
#ifdef NEO_UBT // NEO: BM - [BandwidthModeration]
	m_uSeparateReleaseBandwidth = thePrefs.m_uSeparateReleaseBandwidth;
	m_fReleaseSlotSpeed = thePrefs.m_fReleaseSlotSpeed;
	m_fReleaseBandwidthPercentage = thePrefs.m_fReleaseBandwidthPercentage;
#endif // NEO_UBT // NEO: BM END
	// NEO: RT END

	// NEO: IPS - [InteligentPartSharing]
	m_bInteligentPartSharing = thePrefs.m_bInteligentPartSharing;
	m_iInteligentPartSharingTimer = thePrefs.m_iInteligentPartSharingTimer;
	m_iMaxProzentToHide = thePrefs.m_iMaxProzentToHide;

	m_iHideOverAvaliblyParts = thePrefs.m_iHideOverAvaliblyParts;
	m_iHideOverAvaliblyMode = thePrefs.m_iHideOverAvaliblyMode;
	m_fHideOverAvaliblyValue = thePrefs.m_fHideOverAvaliblyValue;
	m_iHideOverAvaliblyCatch = thePrefs.m_iHideOverAvaliblyCatch;

	m_iHideOverSharedParts = thePrefs.m_iHideOverSharedParts;
	m_iHideOverSharedMode = thePrefs.m_iHideOverSharedMode;
	m_fHideOverSharedValue = thePrefs.m_fHideOverSharedValue;
	m_iHideOverSharedCalc = thePrefs.m_iHideOverSharedCalc;
	
	m_iDontHideUnderAvaliblyParts = thePrefs.m_iDontHideUnderAvaliblyParts;
	m_iDontHideUnderAvaliblyMode = thePrefs.m_iDontHideUnderAvaliblyMode;
	m_fDontHideUnderAvaliblyValue = thePrefs.m_fDontHideUnderAvaliblyValue;

	m_iBlockHighOverAvaliblyParts = thePrefs.m_iBlockHighOverAvaliblyParts;
	m_fBlockHighOverAvaliblyFactor = thePrefs.m_fBlockHighOverAvaliblyFactor;

	m_iBlockHighOverSharedParts = thePrefs.m_iBlockHighOverSharedParts;
	m_fBlockHighOverSharedFactor = thePrefs.m_fBlockHighOverSharedFactor;

	m_iShowAlwaysNeeded = thePrefs.m_iShowAlwaysNeeded;
	m_iShowAlwaysParts = thePrefs.m_iShowAlwaysParts;

	m_iShowAlwaysIncomplete = thePrefs.m_iShowAlwaysIncomplete;
	// NEO: IPS END

	m_iXSAnswerLimit = thePrefs.m_iXSAnswerLimit; // NEO: NST - [NeoSourceTweaks]
}

// NEO: FCFG - [FileConfiguration]
void CPPgRelease::RefreshData()
{
	/*
	* Datei Einstellungen Laden
	*/

	const CKnownFile* file = STATIC_DOWNCAST(CKnownFile, (*m_paFiles)[0]);

	// NEO: NCAP - [NeoCustomAutoPriority]
	m_iDynamicAutoUpPriority = file->KnownPrefs.m_iDynamicAutoUpPriority;
	m_fDynamicUpPriorityFactor = file->KnownPrefs.m_fDynamicUpPriorityFactor;
	m_iLowUpPrioThreshold = file->KnownPrefs.m_iLowUpPrioThreshold;
	m_iHighUpPrioThreshold = file->KnownPrefs.m_iHighUpPrioThreshold;
	// NEO: NCAP END

	// NEO: RT - [ReleaseTweaks]
	m_iReleaseLevel = file->KnownPrefs.m_iReleaseLevel;
	m_iReleaseMode = file->KnownPrefs.m_iReleaseMode;

	m_iReleaseLimitMode = file->KnownPrefs.m_iReleaseLimitMode;
	m_iReleaseLimitUnion = file->KnownPrefs.m_iReleaseLimitUnion;
	m_iReleaseLimitCompleteMode = file->KnownPrefs.m_iReleaseLimitCompleteMode;

	m_iReleaseLimit = file->KnownPrefs.m_iReleaseLimit;
	m_iReleaseLimitHigh = file->KnownPrefs.m_iReleaseLimitHigh;
	m_iReleaseLimitLow = file->KnownPrefs.m_iReleaseLimitLow;

	m_iReleaseLimitComplete = file->KnownPrefs.m_iReleaseLimitComplete;
	m_iReleaseLimitCompleteHigh = file->KnownPrefs.m_iReleaseLimitCompleteHigh;
	m_iReleaseLimitCompleteLow = file->KnownPrefs.m_iReleaseLimitCompleteLow;

	m_iLimitUnion = file->KnownPrefs.m_iLimitUnion;

	m_iSourceLimitMode = file->KnownPrefs.m_iSourceLimitMode;
	m_iSourceLimitUnion = file->KnownPrefs.m_iSourceLimitUnion;
	m_iSourceLimitCompleteMode = file->KnownPrefs.m_iSourceLimitCompleteMode;

	m_iSourceLimit = file->KnownPrefs.m_iSourceLimit;
	m_iSourceLimitHigh = file->KnownPrefs.m_iSourceLimitHigh;
	m_iSourceLimitLow = file->KnownPrefs.m_iSourceLimitLow;

	m_iSourceLimitComplete = file->KnownPrefs.m_iSourceLimitComplete;
	m_iSourceLimitCompleteHigh = file->KnownPrefs.m_iSourceLimitCompleteHigh;
	m_iSourceLimitCompleteLow = file->KnownPrefs.m_iSourceLimitCompleteLow;

	m_iReleaseNeedComplete = file->KnownPrefs.m_iReleaseDisableNeedComplete;
	// NEO: RT END

	// NEO: IPS - [InteligentPartSharing]
	m_iMaxProzentToHide = file->KnownPrefs.m_iMaxProzentToHide;

	m_iHideOverAvaliblyParts = file->KnownPrefs.m_iHideOverAvaliblyParts;
	m_iHideOverAvaliblyMode = file->KnownPrefs.m_iHideOverAvaliblyMode;
	m_fHideOverAvaliblyValue = file->KnownPrefs.m_fHideOverAvaliblyValue;
	m_iHideOverAvaliblyCatch = file->KnownPrefs.m_iHideOverAvaliblyCatch;

	m_iHideOverSharedParts = file->KnownPrefs.m_iHideOverSharedParts;
	m_iHideOverSharedMode = file->KnownPrefs.m_iHideOverSharedMode;
	m_fHideOverSharedValue = file->KnownPrefs.m_fHideOverSharedValue;
	m_iHideOverSharedCalc = file->KnownPrefs.m_iHideOverSharedCalc;
	
	m_iDontHideUnderAvaliblyParts = file->KnownPrefs.m_iDontHideUnderAvaliblyParts;
	m_iDontHideUnderAvaliblyMode = file->KnownPrefs.m_iDontHideUnderAvaliblyMode;
	m_fDontHideUnderAvaliblyValue = file->KnownPrefs.m_fDontHideUnderAvaliblyValue;

	m_iBlockHighOverAvaliblyParts = file->KnownPrefs.m_iBlockHighOverAvaliblyParts;
	m_fBlockHighOverAvaliblyFactor = file->KnownPrefs.m_fBlockHighOverAvaliblyFactor;

	m_iBlockHighOverSharedParts = file->KnownPrefs.m_iBlockHighOverSharedParts;
	m_fBlockHighOverSharedFactor = file->KnownPrefs.m_fBlockHighOverSharedFactor;

	m_iShowAlwaysNeeded = file->KnownPrefs.m_iShowAlwaysNeeded;
	m_iShowAlwaysParts = file->KnownPrefs.m_iShowAlwaysParts;

	m_iShowAlwaysIncomplete = file->KnownPrefs.m_iShowAlwaysIncomplete;
	// NEO: IPS END

	// NEO: RP - [RestrictivPublishing]
#ifdef LANCAST // NEO: NLC - [NeoLanCast]
	m_bDisableSendLAN = file->KnownPrefs.m_bDisableSendLAN;
#endif //LANCAST // NEO: NLC END
#ifdef VOODOO // NEO: VOODOO - [UniversalPartfileInterface]
	m_bDisableVoodoo = file->KnownPrefs.m_bDisableVoodoo;
#endif // VOODOO
	// NEO: RP END

	// NEO: NST - [NeoSourceTweaks]
	m_iXSAnswerLimit = file->KnownPrefs.m_iXSAnswerLimit;
	m_bEnableSendXS = file->KnownPrefs.m_bEnableSendXS;
	// NEO: NST END

	for (int i = 1; i < m_paFiles->GetSize(); i++)
	{
		file = STATIC_DOWNCAST(CKnownFile, (*m_paFiles)[i]);

		// NEO: NCAP - [NeoCustomAutoPriority]
		if(m_iDynamicAutoUpPriority != file->KnownPrefs.m_iDynamicAutoUpPriority) m_iDynamicAutoUpPriority = -1;
		if(m_fDynamicUpPriorityFactor != file->KnownPrefs.m_fDynamicUpPriorityFactor) m_fDynamicUpPriorityFactor = UN_FLOAT;
		if(m_iLowUpPrioThreshold != file->KnownPrefs.m_iLowUpPrioThreshold) m_iLowUpPrioThreshold = UN_INT;
		if(m_iHighUpPrioThreshold != file->KnownPrefs.m_iHighUpPrioThreshold) m_iHighUpPrioThreshold = UN_INT;
		// NEO: NCAP END

		// NEO: RT - [ReleaseTweaks]
		if (m_iReleaseLevel != file->KnownPrefs.m_iReleaseLevel) m_iReleaseLevel = UN_INT;
		if (m_iReleaseMode != file->KnownPrefs.m_iReleaseMode) m_iReleaseMode = -1;

		if (m_iReleaseLimitMode != file->KnownPrefs.m_iReleaseLimitMode) m_iReleaseLimitMode = -1;
		if (m_iReleaseLimitUnion != file->KnownPrefs.m_iReleaseLimitUnion ) m_iReleaseLimitUnion = -1;
		if (m_iReleaseLimitCompleteMode != file->KnownPrefs.m_iReleaseLimitCompleteMode) m_iReleaseLimitCompleteMode = -1;

		if (m_iReleaseLimit != file->KnownPrefs.m_iReleaseLimit) m_iReleaseLimit = -1;
		if (m_iReleaseLimitHigh != file->KnownPrefs.m_iReleaseLimitHigh) m_iReleaseLimitHigh = UN_INT;
		if (m_iReleaseLimitLow != file->KnownPrefs.m_iReleaseLimitLow) m_iReleaseLimitLow = UN_INT;

		if (m_iReleaseLimitComplete != file->KnownPrefs.m_iReleaseLimitComplete) m_iReleaseLimitComplete = -1;
		if (m_iReleaseLimitCompleteHigh != file->KnownPrefs.m_iReleaseLimitCompleteHigh) m_iReleaseLimitCompleteHigh = UN_INT;
		if (m_iReleaseLimitCompleteLow != file->KnownPrefs.m_iReleaseLimitCompleteLow) m_iReleaseLimitCompleteLow = UN_INT;

		if (m_iLimitUnion != file->KnownPrefs.m_iLimitUnion ) m_iLimitUnion = -1;

		if (m_iSourceLimitMode != file->KnownPrefs.m_iSourceLimitMode) m_iSourceLimitMode = -1;
		if (m_iSourceLimitUnion != file->KnownPrefs.m_iSourceLimitUnion ) m_iSourceLimitUnion = -1;
		if (m_iSourceLimitCompleteMode != file->KnownPrefs.m_iSourceLimitCompleteMode) m_iSourceLimitCompleteMode = -1;

		if (m_iSourceLimit != file->KnownPrefs.m_iSourceLimit) m_iSourceLimit = -1;
		if (m_iSourceLimitHigh != file->KnownPrefs.m_iSourceLimitHigh) m_iSourceLimitHigh = UN_INT;
		if (m_iSourceLimitLow != file->KnownPrefs.m_iSourceLimitLow) m_iSourceLimitLow = UN_INT;

		if (m_iSourceLimitComplete != file->KnownPrefs.m_iSourceLimitComplete) m_iSourceLimitComplete = -1;
		if (m_iSourceLimitCompleteHigh != file->KnownPrefs.m_iSourceLimitCompleteHigh) m_iSourceLimitCompleteHigh = UN_INT;
		if (m_iSourceLimitCompleteLow != file->KnownPrefs.m_iSourceLimitCompleteLow) m_iSourceLimitCompleteLow = UN_INT;

		if (m_iReleaseNeedComplete != (UINT)file->KnownPrefs.m_iReleaseDisableNeedComplete) m_iReleaseNeedComplete = BST_INDETERMINATE;
		// NEO: RT END

		// NEO: IPS - [InteligentPartSharing]
		if (m_iMaxProzentToHide != file->KnownPrefs.m_iMaxProzentToHide) m_iMaxProzentToHide = UN_INT;

		if (m_iHideOverAvaliblyParts != file->KnownPrefs.m_iHideOverAvaliblyParts) m_iHideOverAvaliblyParts = -1;
		if (m_iHideOverAvaliblyMode != file->KnownPrefs.m_iHideOverAvaliblyMode) m_iHideOverAvaliblyMode = -1;
		if (m_fHideOverAvaliblyValue != file->KnownPrefs.m_fHideOverAvaliblyValue) m_fHideOverAvaliblyValue = UN_FLOAT;
		if (m_iHideOverAvaliblyCatch != file->KnownPrefs.m_iHideOverAvaliblyCatch) m_iHideOverAvaliblyCatch = -1;

		if (m_iHideOverSharedParts != file->KnownPrefs.m_iHideOverSharedParts) m_iHideOverSharedParts = -1;
		if (m_iHideOverSharedMode != file->KnownPrefs.m_iHideOverSharedMode) m_iHideOverSharedMode = -1;
		if (m_fHideOverSharedValue != file->KnownPrefs.m_fHideOverSharedValue) m_fHideOverSharedValue = UN_FLOAT;
		if (m_iHideOverSharedCalc != file->KnownPrefs.m_iHideOverSharedCalc) m_iHideOverSharedCalc = -1;
		
		if (m_iDontHideUnderAvaliblyParts != file->KnownPrefs.m_iDontHideUnderAvaliblyParts) m_iDontHideUnderAvaliblyParts = -1;
		if (m_iDontHideUnderAvaliblyMode != file->KnownPrefs.m_iDontHideUnderAvaliblyMode) m_iDontHideUnderAvaliblyMode = -1;
		if (m_fDontHideUnderAvaliblyValue != file->KnownPrefs.m_fDontHideUnderAvaliblyValue) m_fDontHideUnderAvaliblyValue = UN_FLOAT;

		if (m_iBlockHighOverAvaliblyParts != file->KnownPrefs.m_iBlockHighOverAvaliblyParts) m_iBlockHighOverAvaliblyParts = -1;
		if (m_fBlockHighOverAvaliblyFactor != file->KnownPrefs.m_fBlockHighOverAvaliblyFactor) m_fBlockHighOverAvaliblyFactor = UN_FLOAT;

		if (m_iBlockHighOverSharedParts != file->KnownPrefs.m_iBlockHighOverSharedParts) m_iBlockHighOverSharedParts = -1;
		if (m_fBlockHighOverSharedFactor != file->KnownPrefs.m_fBlockHighOverSharedFactor) m_fBlockHighOverSharedFactor = UN_FLOAT;

		if (m_iShowAlwaysNeeded != file->KnownPrefs.m_iShowAlwaysNeeded) m_iShowAlwaysNeeded = -1;
		if (m_iShowAlwaysParts != file->KnownPrefs.m_iShowAlwaysParts) m_iShowAlwaysParts = UN_INT;

		if (m_iShowAlwaysIncomplete != file->KnownPrefs.m_iShowAlwaysIncomplete) m_iShowAlwaysIncomplete = -1;
		// NEO: IPS END

		// NEO: RP - [RestrictivPublishing]
#ifdef LANCAST // NEO: NLC - [NeoLanCast]
		if (I2B(m_bDisableSendLAN) != file->KnownPrefs.m_bDisableSendLAN) m_bDisableSendLAN = BST_INDETERMINATE;
#endif //LANCAST // NEO: NLC END
#ifdef VOODOO // NEO: VOODOO - [UniversalPartfileInterface]
		if (I2B(m_bDisableVoodoo) != file->KnownPrefs.m_bDisableVoodoo) m_bDisableVoodoo = BST_INDETERMINATE;
#endif // VOODOO
		// NEO: RP END

		// NEO: NST - [NeoSourceTweaks]
		if(m_iXSAnswerLimit != file->KnownPrefs.m_iXSAnswerLimit) m_iXSAnswerLimit = UN_INT;
		if (I2B(m_bEnableSendXS) != file->KnownPrefs.m_bEnableSendXS) m_bEnableSendXS = BST_INDETERMINATE;
		// NEO: NST END
	}

	// NEO: NCAP - [NeoCustomAutoPriority]
	if (!m_fDynamicUpPriorityFactor)
		m_fDynamicUpPriorityFactor = thePrefs.GetDynamicUpPriorityFactor();
	else if(m_fDynamicUpPriorityFactor == UN_FLOAT)
		m_fDynamicUpPriorityFactor = 0;

	if (!m_iLowUpPrioThreshold)
		m_iLowUpPrioThreshold = thePrefs.GetLowUpPrioThreshold();
	else if(m_iLowUpPrioThreshold == UN_INT)
		m_iLowUpPrioThreshold = 0;

	if (!m_iHighUpPrioThreshold)
		m_iHighUpPrioThreshold = thePrefs.GetHighUpPrioThreshold();
	else if(m_iHighUpPrioThreshold == UN_INT)
		m_iHighUpPrioThreshold = 0;
	// NEO: NCAP END

	// NEO: RT - [ReleaseTweaks]
	if (!m_iReleaseLevel)
		m_iReleaseLevel = thePrefs.GetReleaseLevel();
	else if(m_iReleaseLevel == UN_INT)
		m_iReleaseLevel = 0;

	if (!m_iReleaseLimitHigh)
		m_iReleaseLimitHigh = thePrefs.GetReleaseLimitHigh();
	else if(m_iReleaseLimitHigh == UN_INT)
		m_iReleaseLimitHigh = 0;
	if (!m_iReleaseLimitLow)
		m_iReleaseLimitLow = thePrefs.GetReleaseLimitLow();
	else if(m_iReleaseLimitLow == UN_INT)
		m_iReleaseLimitLow = 0;

	if (!m_iReleaseLimitCompleteHigh)
		m_iReleaseLimitCompleteHigh = thePrefs.GetReleaseLimitCompleteHigh();
	else if(m_iReleaseLimitCompleteHigh == UN_INT)
		m_iReleaseLimitCompleteHigh = 0;
	if (!m_iReleaseLimitCompleteLow)
		m_iReleaseLimitCompleteLow = thePrefs.GetReleaseLimitCompleteLow();
	else if(m_iReleaseLimitCompleteLow == UN_INT)
		m_iReleaseLimitCompleteLow = 0;

	if (!m_iSourceLimitHigh)
		m_iSourceLimitHigh = thePrefs.GetSourceLimitHigh();
	else if(m_iSourceLimitHigh == UN_INT)
		m_iSourceLimitHigh = 0;
	if (!m_iSourceLimitLow)
		m_iSourceLimitLow = thePrefs.GetSourceLimitLow();
	else if(m_iSourceLimitLow == UN_INT)
		m_iSourceLimitLow = 0;

	if (!m_iSourceLimitCompleteHigh)
		m_iSourceLimitCompleteHigh = thePrefs.GetSourceLimitCompleteHigh();
	else if(m_iSourceLimitCompleteHigh == UN_INT)
		m_iSourceLimitCompleteHigh = 0;
	if (!m_iSourceLimitCompleteLow)
		m_iSourceLimitCompleteLow = thePrefs.GetSourceLimitCompleteLow();
	else if(m_iSourceLimitCompleteLow == UN_INT)
		m_iSourceLimitCompleteLow = 0;
	// NEO: RT END

	// NEO: IPS - [InteligentPartSharing]
	if (!m_iMaxProzentToHide)
		m_iMaxProzentToHide = thePrefs.GetMaxProzentToHide();
	else if(m_iMaxProzentToHide == UN_INT)
		m_iMaxProzentToHide = 0;

	if (!m_fHideOverAvaliblyValue)
		m_fHideOverAvaliblyValue = thePrefs.GetHideOverAvaliblyValue();
	else if(m_fHideOverAvaliblyValue == UN_FLOAT)
		m_fHideOverAvaliblyValue = 0;

	if (!m_fHideOverSharedValue)
		m_fHideOverSharedValue = thePrefs.GetHideOverSharedValue();
	else if(m_fHideOverSharedValue == UN_FLOAT)
		m_fHideOverSharedValue = 0;
	
	if (!m_fDontHideUnderAvaliblyValue)
		m_fDontHideUnderAvaliblyValue = thePrefs.GetDontHideUnderAvaliblyValue();
	else if(m_fDontHideUnderAvaliblyValue == UN_FLOAT)
		m_fDontHideUnderAvaliblyValue = 0;

	if (!m_fBlockHighOverAvaliblyFactor)
		m_fBlockHighOverAvaliblyFactor = thePrefs.GetBlockHighOverAvaliblyFactor();
	else if(m_fBlockHighOverAvaliblyFactor == UN_FLOAT)
		m_fBlockHighOverAvaliblyFactor = 0;

	if (!m_fBlockHighOverSharedFactor)
		m_fBlockHighOverSharedFactor = thePrefs.GetBlockHighOverSharedFactor();
	else if(m_fBlockHighOverSharedFactor == UN_FLOAT)
		m_fBlockHighOverSharedFactor = 0;

	if (!m_iShowAlwaysParts)
		m_iShowAlwaysParts = thePrefs.GetShowAlwaysParts();
	else if(m_iShowAlwaysParts == UN_INT)
		m_iShowAlwaysParts = 0;
	// NEO: IPS END

	// NEO: NST - [NeoSourceTweaks]
	if(!m_iXSAnswerLimit)
		m_iXSAnswerLimit = thePrefs.GetXSAnswerLimit();
	else if(m_iXSAnswerLimit == UN_INT)
		m_iXSAnswerLimit = 0;
	// NEO: NST END

	UpdateData(FALSE);
}

void CPPgRelease::OnTimer(UINT /*nIDEvent*/)
{
	if (m_bDataChanged)
	{
		RefreshData();
		m_bDataChanged = false;
	}
}

BOOL CPPgRelease::OnSetActive()
{
	if (!CPropertyPage::OnSetActive())
		return FALSE;
	if (m_bDataChanged)
	{
		RefreshData();
		m_bDataChanged = false;
	}
	return TRUE;
}

LRESULT CPPgRelease::OnDataChanged(WPARAM, LPARAM)
{
	m_bDataChanged = true;
	return 1;
}
// NEO: FCFG END

void CPPgRelease::OnDestroy()
{
	// NEO: FCFG - [FileConfiguration]
	if (m_timer){
		KillTimer(m_timer);
		m_timer = 0;
	}
	// NEO: FCFG END

	m_ctrlTreeOptions.DeleteAllItems();
	m_ctrlTreeOptions.DestroyWindow();
	ClearAllMembers();
	CPropertyPage::OnDestroy();
}

/*void CPPgRelease::Localize()
{
}*/

BOOL CPPgRelease::OnKillActive()
{
	// if prop page is closed by pressing ENTER we have to explicitly commit any possibly pending
	// data from an open edit control
	m_ctrlTreeOptions.HandleChildControlLosingFocus();
	return CPropertyPage::OnKillActive();
}

LRESULT CPPgRelease::OnTreeOptsCtrlNotify(WPARAM wParam, LPARAM lParam)
{
	if(!IsWindowVisible())
		return 0;

	if (wParam == IDC_MOD_OPTS){
		TREEOPTSCTRLNOTIFY* pton = (TREEOPTSCTRLNOTIFY*)lParam;
		if(pton->nmhdr.code == EN_KILLFOCUS){	
			// NEO: TQ - [TweakUploadQueue]
			if(!ForFile() && m_htiQueueOverFlowRelease && pton->hItem == m_htiQueueOverFlowRelease){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiQueueOverFlowRelease, VAL_QUEUE_OVERFLOW_MIN, VAL_QUEUE_OVERFLOW_DEF, VAL_QUEUE_OVERFLOW_MAX)) SetModified();
			}else if(!ForFile() && m_htiQueueOverFlowEx && pton->hItem == m_htiQueueOverFlowEx){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiQueueOverFlowEx, VAL_QUEUE_OVERFLOW_MIN, VAL_QUEUE_OVERFLOW_DEF, VAL_QUEUE_OVERFLOW_MAX)) SetModified();
			}else if(!ForFile() && m_htiQueueOverFlowDef && pton->hItem == m_htiQueueOverFlowDef){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiQueueOverFlowDef, VAL_QUEUE_OVERFLOW_MIN, VAL_QUEUE_OVERFLOW_DEF, VAL_QUEUE_OVERFLOW_MAX)) SetModified();
			}else if(!ForFile() && m_htiQueueOverFlowCF && pton->hItem == m_htiQueueOverFlowCF){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiQueueOverFlowCF, VAL_QUEUE_OVERFLOW_MIN, VAL_QUEUE_OVERFLOW_DEF, VAL_QUEUE_OVERFLOW_MAX)) SetModified();
			}
			// NEO: TQ END
			// NEO: NMFS - [NiceMultiFriendSlots]
			else if(!ForFile() && m_htiFriendSlotLimit && pton->hItem == m_htiFriendSlotLimit){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiFriendSlotLimit, VAL_FRIEND_SLOT_LIMIT_MIN, VAL_FRIEND_SLOT_LIMIT_DEF, VAL_FRIEND_SLOT_LIMIT_MAX)) SetModified();
			}
#ifdef NEO_UBT // NEO: BM - [BandwidthModeration]
			else if(!ForFile() && m_htiFriendSlotSpeed && pton->hItem == m_htiFriendSlotSpeed){
				if(CheckTreeEditLimitF(m_ctrlTreeOptions, m_htiFriendSlotSpeed, VAL_FRIEND_SLOT_SPEED_MIN, VAL_FRIEND_SLOT_SPEED_DEF, VAL_FRIEND_SLOT_SPEED_MAX)) SetModified();
			}
			else if(!ForFile() && m_htiFriendBandwidthPercentage && pton->hItem == m_htiFriendBandwidthPercentage){
				if(CheckTreeEditLimitF(m_ctrlTreeOptions, m_htiFriendBandwidthPercentage, VAL_FRIEND_BANDWIDTH_PERCENTAGE_MIN, VAL_FRIEND_BANDWIDTH_PERCENTAGE_DEF, VAL_FRIEND_BANDWIDTH_PERCENTAGE_MAX)) SetModified();
			}
#endif // NEO_UBT // NEO: BM END
			// NEO: NMFS END
			// NEO: FCFG - [FileConfiguration]
			// NEO: IPS - [InteligentPartSharing]
			if(m_htiInteligentPartSharingTimer && pton->hItem == m_htiInteligentPartSharingTimer){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiInteligentPartSharingTimer, TIM_IPS_TIMER_MIN, TIM_IPS_TIMER_DEF, TIM_IPS_TIMER_MAX)) SetModified();
			}else if(m_htiMaxProzentToHide && pton->hItem == m_htiMaxProzentToHide){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiMaxProzentToHide, VAL_IPS_MAX_MIN, VAL_IPS_MAX_DEF, VAL_IPS_MAX_MAX)) SetModified();
			}
				// OA>
				else if(m_htiHideOverAvaliblyValue && pton->hItem == m_htiHideOverAvaliblyValue){
					if(CheckTreeEditLimitF(m_ctrlTreeOptions, m_htiHideOverAvaliblyValue, ForFile() ? thePrefs.GetHideOverAvaliblyValue() : m_iHideOverAvaliblyMode ? VAL_IPS_OA_MIN2 : VAL_IPS_OA_MIN1, m_iHideOverAvaliblyMode ? VAL_IPS_OA_DEF2 : VAL_IPS_OA_DEF1, m_iHideOverAvaliblyMode ? VAL_IPS_OA_MAX2 : VAL_IPS_OA_MAX1)) SetModified();
				}else if(m_htiBlockHighOverAvaliblyFactor && pton->hItem == m_htiBlockHighOverAvaliblyFactor){
					if(CheckTreeEditLimitF(m_ctrlTreeOptions, m_htiBlockHighOverAvaliblyFactor, VAL_IPS_OAF_MIN, ForFile() ? thePrefs.GetBlockHighOverAvaliblyFactor() : VAL_IPS_OAF_DEF, VAL_IPS_OAF_MAX)) SetModified();
				}
				// <OA
				// OS>
				else if(m_htiHideOverSharedValue && pton->hItem == m_htiHideOverSharedValue){
					if(CheckTreeEditLimitF(m_ctrlTreeOptions, m_htiHideOverSharedValue, ForFile() ? thePrefs.GetHideOverSharedValue() : m_iHideOverSharedMode ? VAL_IPS_OS_MIN2 : VAL_IPS_OS_MIN1, m_iHideOverSharedMode ? VAL_IPS_OS_DEF2 : VAL_IPS_OS_DEF1, m_iHideOverSharedMode ? VAL_IPS_OS_MAX2 : VAL_IPS_OS_MAX1)) SetModified();
				}	// UA>
					else if(m_htiDontHideUnderAvaliblyValue && pton->hItem == m_htiDontHideUnderAvaliblyValue){
						if(CheckTreeEditLimitF(m_ctrlTreeOptions, m_htiDontHideUnderAvaliblyValue, ForFile() ? thePrefs.GetDontHideUnderAvaliblyValue() : m_iDontHideUnderAvaliblyMode ? VAL_IPS_UA_MIN2 : VAL_IPS_UA_MIN1, m_iDontHideUnderAvaliblyMode ? VAL_IPS_UA_DEF2 : VAL_IPS_UA_DEF1, m_iDontHideUnderAvaliblyMode ? VAL_IPS_UA_MAX2 : VAL_IPS_UA_MAX1)) SetModified();
					// <UA
				}else if(m_htiBlockHighOverSharedFactor && pton->hItem == m_htiBlockHighOverSharedFactor){
					if(CheckTreeEditLimitF(m_ctrlTreeOptions, m_htiBlockHighOverSharedFactor, VAL_IPS_OSF_MIN, ForFile() ? thePrefs.GetBlockHighOverSharedFactor() : VAL_IPS_OSF_DEF, VAL_IPS_OSF_MAX)) SetModified();
				}
				// <OS
				else if(m_htiShowAlwaysNeededValue && pton->hItem == m_htiShowAlwaysNeededValue){
					if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiShowAlwaysNeededValue, VAL_SHOW_ALWAYS_PARTS_MIN, ForFile() ? thePrefs.GetShowAlwaysParts() : VAL_SHOW_ALWAYS_PARTS_DEF, VAL_SHOW_ALWAYS_PARTS_MAX)) SetModified();
				}

			// NEO: IPS END
			// NEO: NCAP - [NeoCustomAutoPriority]
			else if(m_htiDynamicAutoUpPriorityEnable && pton->hItem == m_htiDynamicAutoUpPriorityEnable){
				if(CheckTreeEditLimitF(m_ctrlTreeOptions, m_htiDynamicAutoUpPriorityEnable, VAL_DYNAMIC_PRIORITY_FACTOR_MIN, ForFile() ? thePrefs.GetDynamicUpPriorityFactor() : VAL_DYNAMIC_PRIORITY_FACTOR_DEF, VAL_DYNAMIC_PRIORITY_FACTOR_MAX)) SetModified();
			}
			else if(m_htiLowUpPrioThreshold && pton->hItem == m_htiLowUpPrioThreshold){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiLowUpPrioThreshold, VAL_LOW_UP_PRIO_THRESHOLD_MIN, ForFile() ? thePrefs.GetLowUpPrioThreshold() : VAL_LOW_UP_PRIO_THRESHOLD_DEF, VAL_LOW_UP_PRIO_THRESHOLD_MAX)) SetModified();
			}
			else if(m_htiHighUpPrioThreshold && pton->hItem == m_htiHighUpPrioThreshold){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiHighUpPrioThreshold, VAL_HIGH_UP_PRIO_THRESHOLD_MIN, ForFile() ? thePrefs.GetHighUpPrioThreshold() : VAL_HIGH_UP_PRIO_THRESHOLD_DEF, VAL_HIGH_UP_PRIO_THRESHOLD_MAX)) SetModified();
			}
			// NEO: NCAP END
			// NEO: RT - [ReleaseTweaks]
			else if(m_htiReleasePriorityLevel && pton->hItem == m_htiReleasePriorityLevel){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiReleasePriorityLevel, VAL_RELEASE_LEVEL_MIN, ForFile() ? thePrefs.GetReleaseLevel() : VAL_RELEASE_LEVEL_DEF, VAL_RELEASE_LEVEL_MAX)) SetModified();
			}else if(m_htiReleaseLimitHigh && pton->hItem == m_htiReleaseLimitHigh){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiReleaseLimitHigh, VAL_RELEASE_LIMIT_MIN, ForFile() ? thePrefs.GetReleaseLimitHigh() : VAL_RELEASE_LIMIT_DEF, VAL_RELEASE_LIMIT_MAX)) SetModified();
			}else if(m_htiReleaseLimitLow && pton->hItem == m_htiReleaseLimitLow){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiReleaseLimitLow, VAL_RELEASE_LIMIT_MIN, ForFile() ? thePrefs.GetReleaseLimitLow() : VAL_RELEASE_LIMIT_DEF, VAL_RELEASE_LIMIT_MAX)) SetModified();
			}
			else if(m_htiReleaseLimitCompleteHigh && pton->hItem == m_htiReleaseLimitCompleteHigh){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiReleaseLimitCompleteHigh, VAL_RELEASE_CLIMIT_MIN,  ForFile() ? thePrefs.GetReleaseLimitCompleteHigh() : VAL_RELEASE_CLIMIT_DEF, VAL_RELEASE_CLIMIT_MAX)) SetModified();
			}else if(m_htiReleaseLimitCompleteLow && pton->hItem == m_htiReleaseLimitCompleteLow){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiReleaseLimitCompleteLow, VAL_RELEASE_CLIMIT_MIN,  ForFile() ? thePrefs.GetReleaseLimitCompleteLow() : VAL_RELEASE_CLIMIT_DEF, VAL_RELEASE_CLIMIT_MAX)) SetModified();
			}
			else if(m_htiSourceLimitHigh && pton->hItem == m_htiSourceLimitHigh){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiSourceLimitHigh, VAL_SOURCE_LIMIT_MIN, ForFile() ? thePrefs.GetSourceLimitHigh() : VAL_SOURCE_LIMIT_DEF, VAL_SOURCE_LIMIT_MAX)) SetModified();
			}else if(m_htiSourceLimitLow && pton->hItem == m_htiSourceLimitLow){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiSourceLimitLow, VAL_SOURCE_LIMIT_MIN, ForFile() ? thePrefs.GetSourceLimitLow() : VAL_SOURCE_LIMIT_DEF, VAL_SOURCE_LIMIT_MAX)) SetModified();
			}
			else if(m_htiSourceLimitCompleteHigh && pton->hItem == m_htiSourceLimitCompleteHigh){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiSourceLimitCompleteHigh, VAL_RELEASE_CLIMIT_MIN,  ForFile() ? thePrefs.GetSourceLimitCompleteHigh() : VAL_RELEASE_CLIMIT_DEF, VAL_RELEASE_CLIMIT_MAX)) SetModified();
			}else if(m_htiSourceLimitCompleteLow && pton->hItem == m_htiSourceLimitCompleteLow){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiSourceLimitCompleteLow, VAL_RELEASE_CLIMIT_MIN,  ForFile() ? thePrefs.GetSourceLimitCompleteLow() : VAL_RELEASE_CLIMIT_DEF, VAL_RELEASE_CLIMIT_MAX)) SetModified();
			}
			else if(!ForFile() && m_htiReleasePriorityNeedComplete && pton->hItem == m_htiReleasePriorityNeedComplete){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiReleasePriorityNeedComplete, VAL_RELEASE_CL_MIN, VAL_RELEASE_CL_DEF, VAL_RELEASE_CL_MAX)) SetModified();
			}
			else if(m_htiReleaseSlotLimit && pton->hItem == m_htiReleaseSlotLimit){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiReleaseSlotLimit, VAL_RELEASE_SLOT_LIMIT_MIN, VAL_RELEASE_SLOT_LIMIT_DEF, VAL_RELEASE_SLOT_LIMIT_MAX)) SetModified();
			}
#ifdef NEO_UBT // NEO: BM - [BandwidthModeration]
			else if(!ForFile() && m_htiReleaseSlotSpeed && pton->hItem == m_htiReleaseSlotSpeed){
				if(CheckTreeEditLimitF(m_ctrlTreeOptions, m_htiReleaseSlotSpeed, VAL_RELEASE_SLOT_SPEED_MIN, VAL_RELEASE_SLOT_SPEED_DEF, VAL_RELEASE_SLOT_SPEED_MAX)) SetModified();
			}
			else if(!ForFile() && m_htiReleaseBandwidthPercentage && pton->hItem == m_htiReleaseBandwidthPercentage){
				if(CheckTreeEditLimitF(m_ctrlTreeOptions, m_htiReleaseBandwidthPercentage, VAL_RELEASE_BANDWIDTH_PERCENTAGE_MIN, VAL_RELEASE_BANDWIDTH_PERCENTAGE_DEF, VAL_RELEASE_BANDWIDTH_PERCENTAGE_MAX)) SetModified();
			}
#endif // NEO_UBT// NEO: BM END
			// NEO: RT END
			// NEO: FCFG END
			// NEO: NST - [NeoSourceTweaks]
 			else if(m_htiXSAnswerLimit && pton->hItem == m_htiXSAnswerLimit){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiXSAnswerLimit, VAL_XS_ANSWER_LIMIT_MIN, ForFile() ? thePrefs.GetXSAnswerLimit() : VAL_XS_ANSWER_LIMIT_DEF, VAL_XS_ANSWER_LIMIT_MAX)) SetModified();
			}
			// NEO: NST END
		}else{
			// NEO: NPT - [NeoPartTraffic]
			UINT bCheck;
			if (m_htiPartTraffic && pton->hItem == m_htiPartTraffic){
				m_ctrlTreeOptions.GetCheckBox(m_htiPartTraffic, bCheck);
				m_ctrlTreeOptions.SetItemEnable(m_htiPartTraffic, bCheck, TRUE, TRUE);

				CheckIPSEnable();
			}
			// NEO: NPT END

			// NEO: TQ - [TweakUploadQueue]
			else if(m_htiUseMultiQueue && pton->hItem == m_htiUseMultiQueue){
				m_ctrlTreeOptions.GetCheckBox(m_htiUseMultiQueue, bCheck); // NEO: MQ - [MultiQueue]
				m_ctrlTreeOptions.SetItemEnable(m_htiOldPrioritySystem, bCheck ? FALSE : TRUE); // Munti Queue have his own priority score
			}else if(m_htiInfiniteQueue && pton->hItem == m_htiInfiniteQueue){
				m_ctrlTreeOptions.GetCheckBox(m_htiInfiniteQueue, bCheck);
				m_ctrlTreeOptions.SetGroupEnable(m_htiUploadQueueOverFlow, bCheck ? FALSE : TRUE);
			}
			else if(m_htiUseRandomQueue && pton->hItem == m_htiUseRandomQueue){
				m_ctrlTreeOptions.GetCheckBox(m_htiUseRandomQueue, bCheck); // NEO: RQ - [RandomQueue]
				m_ctrlTreeOptions.SetItemEnable(m_htiNeoScoreSystem, bCheck ? FALSE : TRUE); // ofcorse no need for time based score improvement
			}
			else if(m_htiQueueOverFlowRelease && pton->hItem == m_htiQueueOverFlowRelease){
				m_ctrlTreeOptions.GetCheckBox(m_htiQueueOverFlowRelease, bCheck);
				m_ctrlTreeOptions.SetItemEnable(m_htiQueueOverFlowRelease, bCheck == 2, TRUE, TRUE);
			}else if(m_htiQueueOverFlowEx && pton->hItem == m_htiQueueOverFlowEx){
				m_ctrlTreeOptions.GetCheckBox(m_htiQueueOverFlowEx, bCheck);
				m_ctrlTreeOptions.SetItemEnable(m_htiQueueOverFlowEx, bCheck == 2, TRUE, TRUE);
			}else if(m_htiQueueOverFlowDef && pton->hItem == m_htiQueueOverFlowDef){
				m_ctrlTreeOptions.GetCheckBox(m_htiQueueOverFlowDef, bCheck);
				m_ctrlTreeOptions.SetItemEnable(m_htiQueueOverFlowDef, bCheck == 2, TRUE, TRUE);
			}else if(m_htiQueueOverFlowCF && pton->hItem == m_htiQueueOverFlowCF){
				m_ctrlTreeOptions.GetCheckBox(m_htiQueueOverFlowCF, bCheck);
				m_ctrlTreeOptions.SetItemEnable(m_htiQueueOverFlowCF, bCheck == 2, TRUE, TRUE);
			}
			// NEO: TQ END

			// NEO: NMFS - [NiceMultiFriendSlots]
			if (m_htiFriendSlotLimit && pton->hItem == m_htiFriendSlotLimit){
				m_ctrlTreeOptions.GetCheckBox(m_htiFriendSlotLimit, bCheck);
				m_ctrlTreeOptions.SetItemEnable(m_htiFriendSlotLimit, bCheck, TRUE, TRUE);
			}
#ifdef NEO_UBT // NEO: BM - [BandwidthModeration]
			if (m_htiSeparateFriendBandwidth && pton->hItem == m_htiSeparateFriendBandwidth){
				m_ctrlTreeOptions.GetCheckBox(m_htiSeparateFriendBandwidth, bCheck);
				m_ctrlTreeOptions.SetItemEnable(m_htiFriendSlotSpeed, bCheck);
				m_ctrlTreeOptions.SetItemEnable(m_htiFriendBandwidthPercentage, bCheck);
			}
#endif // NEO_UBT // NEO: BM END
			// NEO: NMFS END

			if (m_htiReleaseSlotLimit && pton->hItem == m_htiReleaseSlotLimit){
				m_ctrlTreeOptions.GetCheckBox(m_htiReleaseSlotLimit, bCheck);
				m_ctrlTreeOptions.SetItemEnable(m_htiReleaseSlotLimit, bCheck, TRUE, TRUE);
			}
#ifdef NEO_UBT // NEO: BM - [BandwidthModeration]
			if (m_htiSeparateReleaseBandwidth && pton->hItem == m_htiSeparateReleaseBandwidth){
				m_ctrlTreeOptions.GetCheckBox(m_htiSeparateReleaseBandwidth, bCheck);
				m_ctrlTreeOptions.SetItemEnable(m_htiReleaseSlotSpeed, bCheck);
				m_ctrlTreeOptions.SetItemEnable(m_htiReleaseBandwidthPercentage, bCheck);
			}
#endif // NEO_UBT // NEO: BM END

			// NEO: IPS - [InteligentPartSharing]
			else if(m_htiInteligentPartSharingEnable && pton->hItem == m_htiInteligentPartSharingEnable){
				CheckIPSEnable();
			}
			// NEO: IPS END
			SetModified();
		}
	}
	return 0;
}

// NEO: IPS - [InteligentPartSharing]
bool CPPgRelease::CheckIPSEnable(){
	UINT bCheck;
	UINT bPTCheck;

	if(!ForFile()){
		m_ctrlTreeOptions.GetCheckBox(m_htiInteligentPartSharingEnable, bCheck);
		m_ctrlTreeOptions.GetCheckBox(m_htiPartTraffic, bPTCheck);
	}
	else{
		bCheck = thePrefs.IsInteligentPartSharing();
		bPTCheck = thePrefs.UsePartTraffic();
	}

	if(!ForFile())
		m_ctrlTreeOptions.SetItemEnable(m_htiInteligentPartSharingTimer,bCheck);
	m_ctrlTreeOptions.SetItemEnable(m_htiMaxProzentToHide,bCheck);
	m_ctrlTreeOptions.SetItemEnable(m_htiHideOverAvaliblyParts,bCheck);
	m_ctrlTreeOptions.SetItemEnable(m_htiHideOverSharedParts,bCheck && bPTCheck);
	m_ctrlTreeOptions.SetItemEnable(m_htiShowAlwaysNeeded,bCheck);

	return bCheck != FALSE;
}
// NEO: IPS END

LRESULT CPPgRelease::DrawTreeItemHelp(WPARAM wParam, LPARAM lParam)
{
	if(!IsWindowVisible())
		return 0;

	if (wParam == IDC_MOD_OPTS){
		CString* sInfo = (CString*)lParam;
		SetDlgItemText(IDC_MOD_OPTS_INFO, *sInfo);
	}
	return FALSE;
}

void CPPgRelease::OnHelp()
{
	//theApp.ShowHelp(0);
}

BOOL CPPgRelease::OnCommand(WPARAM wParam, LPARAM lParam)
{
	if (wParam == ID_HELP)
	{
		OnHelp();
		return TRUE;
	}
	return __super::OnCommand(wParam, lParam);
}

BOOL CPPgRelease::OnHelpInfo(HELPINFO* /*pHelpInfo*/)
{
	OnHelp();
	return TRUE;
}
