//this file is part of NeoMule
//Copyright (C)2006 David Xanatos ( Xanatos@Lycos.at / http://neomule.sourceforge.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


#pragma once
#include "Neo\GUI\CP\TreeOptionsCtrl.h" // NEO - [TreeControl] <-- Xanatos --

class CPPgNetwork : public CPropertyPage
{
	DECLARE_DYNAMIC(CPPgNetwork)

public:
	CPPgNetwork();
	virtual ~CPPgNetwork();

// Dialog Data
	enum { IDD = IDD_PPG_MOD };

protected:
	CTreeOptionsCtrl m_ctrlTreeOptions; // NEO - [TreeControl] <-- Xanatos --
	bool m_bInitializedTreeOpts;

	HTREEITEM m_htiNetwork;
		HTREEITEM m_htiObelixConnectionControl; // NEO: OCC - [ObelixConnectionControl]
#ifdef NEO_BC // NEO: NBC - [NeoBandwidthControl]
		HTREEITEM m_htiManageConnections;
		HTREEITEM m_htiNAFC;
			HTREEITEM m_htiNAFCEnabled;
			HTREEITEM m_htiAdapterIP;
				HTREEITEM m_htiISPMask;
				HTREEITEM m_htiBindToAdapter;
			HTREEITEM m_htiMSS;
				HTREEITEM m_htiUseDoubleSendSize;
		HTREEITEM m_htiPinger;
			HTREEITEM m_htiCheckConnection;
			HTREEITEM m_htiPingMode;
				HTREEITEM m_htiPingICMP;
				HTREEITEM m_htiPingRAW;
				HTREEITEM m_htiPingUDP;
				HTREEITEM m_htiNoTTL;
			HTREEITEM m_htiHostToPing;
			HTREEITEM m_htiStaticLowestPing;
#endif // NEO_BC // NEO: NBC END

		// NEO: NATS - [NatSupport]
		HTREEITEM m_htiNAT;
			HTREEITEM m_htiNATSupportEnabled;
				HTREEITEM m_htiNATPortRefreshIvterval;
				HTREEITEM m_htiNATPortMaxLatencyTime;
				HTREEITEM m_htiNATPortMaxFails;
				HTREEITEM m_htiNATPortFastRefresh;
#ifdef NATTUNNELING // NEO: NATT - [NatTraversal]
			HTREEITEM m_htiNATPortRelaiable;
			HTREEITEM m_htiNATTraversalEnabled;
				HTREEITEM m_htiRestrictedNat;
				HTREEITEM m_htiFullConeNat;
				HTREEITEM m_htiSymetricNat;
				HTREEITEM m_htiDontTrustNatPorts;
			HTREEITEM m_htiLowIDUplaodCallBack; // NEO: LUC - [LowIDUplaodCallBack]
#endif //NATTUNNELING // NEO: NATT END
			HTREEITEM m_htiReuseTCPPort;
		// NEO: NATS END

		// NEO: RIC - [ReaskOnIDChange]
		HTREEITEM m_htiOnIDChange;
			HTREEITEM m_htiCheckIPChange;
			HTREEITEM m_htiInformOnIPChange;
			HTREEITEM m_htiReAskOnIPChange;
			HTREEITEM m_htiQuickStartOnIPChange; // NEO: QS - [QuickStart]
			HTREEITEM m_htiCheckL2HIDChange;
			HTREEITEM m_htiReconnectKadOnIPChange;
			HTREEITEM m_htiRebindSocketsOnIPChange;
		// NEO: RIC END
		// NEO: QS - [QuickStart]
		HTREEITEM m_htiQuickStart;
			HTREEITEM m_htiQuickStartEnable;
			HTREEITEM m_htiQuickStartTime;
			HTREEITEM m_htiQuickStartTimePerFile;
			HTREEITEM m_htiQuickMaxConperFive;
			HTREEITEM m_htiQuickMaxHalfOpen;
			HTREEITEM m_htiQuickMaxConnections;
		// NEO: QS END
		// NEO: IFWS - [ICSFirewall]
		HTREEITEM m_htiICSFirewall;
			HTREEITEM m_htiICFSupport;
			HTREEITEM m_htiICFClearOnClose;
		// NEO: IFWS END
		// NEO: UPNP - [UPnPNat]
		HTREEITEM m_htiUPnPNatSupport;
			HTREEITEM m_htiUPnPNat;
			HTREEITEM m_htiUPnPClearOnClose;
			HTREEITEM m_htiUPnPTryRandom;
		// NEO: UPNP END
		HTREEITEM m_htiDownloadKeepAliveTimeout; // NEO: DKA - [DownloadKeepAlive]
		HTREEITEM m_htiTCPConnectionRetry; // NEO: TCR - [TCPConnectionRetry]
		HTREEITEM m_htiTCPDisableNagle;
		HTREEITEM m_htiRecheckKadFirewalled; // NEO: RKF - [RecheckKadFirewalled]
		HTREEITEM m_htiReConnectOnLowID; // NEO: RLD - [ReconnectOnLowID]


	// NEO: OCC - [ObelixConnectionControl]
	bool	m_bObelixConnectionControl;
	int		m_iObelixConnectionControlValue;
	// NEO: OCC END
#ifdef NEO_BC // NEO: NBC - [NeoBandwidthControl]
	bool	m_bManageConnections;
	float	m_fManageConnectionsFactor;

	UINT	m_uNAFCEnabled;
	bool	m_bISPCustomIP;
	DWORD	m_uISPZone;
	DWORD	m_uISPMask;
	bool	m_bBindToAdapter;


	bool	m_bCheckConnection;
	bool	m_bStaticLowestPing;
	int		m_iPingMode;
	bool	m_bNoTTL;
	bool	m_bManualHostToPing;
	CString m_sPingServer;

	bool	m_bAutoMSS;
	int		m_iMSS;

	bool	m_bUseDoubleSendSize;
#endif // NEO_BC // NEO: NBC END

	// NEO: NATS - [NatSupport]
	bool	m_bNATSupportEnabled;
	float	m_fNATPortRefreshIvterval;
	int		m_iNATPortMaxLatencyTime;
	int		m_iNATPortMaxFails;
	bool	m_bNATPortFastRefresh;

#ifdef NATTUNNELING // NEO: NATT - [NatTraversal]
	bool	m_bNATPortRelaiable;
	bool	m_bNATTraversalEnabled;
	bool	m_bDontTrustNatPorts;
	int		m_iNatCharacteristic;
	UINT	m_uLowIDUplaodCallBack; // NEO: LUC - [LowIDUplaodCallBack]
#endif //NATTUNNELING // NEO: NATT END
	UINT	m_uReuseTCPPort;
	// NEO: NATS END

	// NEO: RIC - [ReaskOnIDChange]
	UINT	m_uCheckIPChange;
	bool	m_bInformOnIPChange;
	bool	m_bReAskOnIPChange;
	bool	m_bQuickStartOnIPChange; // NEO: QS - [QuickStart]
	bool	m_bCheckL2HIDChange;
	bool	m_bReconnectKadOnIPChange;
	bool	m_bRebindSocketsOnIPChange;
	// NEO: RIC END
	// NEO: QS - [QuickStart]
	UINT	m_uQuickStart;
	int		m_iQuickStartTime;
	int		m_iQuickStartTimePerFile;
	int		m_iQuickMaxConperFive;
	int		m_iQuickMaxHalfOpen;
	int		m_iQuickMaxConnections;
	// NEO: QS END
	// NEO: IFWS - [ICSFirewall]
	UINT	m_uICFSupport;
	bool	m_bICFClearOnClose;
	// NEO: IFWS END
	// NEO: UPNP - [UPnPNat]
	UINT	m_uUPnPNat;
	bool	m_bUPnPClearOnClose;
	bool	m_bUPnPTryRandom;
	// NEO: UPNP END
	// NEO: DKA - [DownloadKeepAlive]
	bool	m_bEnableDownloadKeepAlive;
	int		m_iDownloadKeepAliveTimeout;
	// NEO: DKA END
	// NEO: TCR - [TCPConnectionRetry]
	bool	m_bTCPConnectionRetry;
	int		m_iTCPConnectionRetry;
	// NEO: TCR END
	bool	m_bTCPDisableNagle;
	// NEO: RKF - [RecheckKadFirewalled]
	bool	m_bRecheckKadFirewalled;
	int		m_iRecheckKadFirewalled;
	// NEO: RKF END
	// NEO: RLD - [ReconnectOnLowID]
	bool	m_bReConnectOnLowID;
	int		m_iReConnectOnLowID;
	// NEO: RLD END

	void ClearAllMembers();

	//void Localize();
	void LoadSettings();

	virtual BOOL OnInitDialog();
	virtual BOOL OnApply();
	virtual BOOL OnKillActive();
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	virtual BOOL OnCommand(WPARAM wParam, LPARAM lParam);

	DECLARE_MESSAGE_MAP()
	afx_msg void OnDestroy();
	afx_msg LRESULT OnTreeOptsCtrlNotify(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT DrawTreeItemHelp(WPARAM wParam, LPARAM lParam);
	afx_msg void OnHelp();
	afx_msg BOOL OnHelpInfo(HELPINFO* pHelpInfo);

private:
#ifdef NEO_BC // NEO: NBC - [NeoBandwidthControl]
	void CheckNAFCEnable();
#endif // NEO_BC // NEO: NBC END

	void CheckNATEnable(); // NEO: NATS - [NatSupport]
};
