//this file is part of NeoMule
//Copyright (C)2006 David Xanatos ( Xanatos@Lycos.at / http://neomule.sourceforge.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


#include "stdafx.h"
#include "emule.h"
#include "PPgNetwork.h"
#include "Preferences.h"
#include "OtherFunctions.h"
#include "Neo\Defaults.h"
#include "Neo\GUI\CP\TreeFunctions.h"
#ifdef NEO_BC // NEO: NBC - [NeoBandwidthControl] -- Xanatos -->
#include "Neo/BandwidthControl/BandwidthControl.h"
#endif // NEO_BC // NEO: NBC END <-- Xanatos --

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

///////////////////////////////////////////////////////////////////////////////
// CPPgNetwork dialog

IMPLEMENT_DYNAMIC(CPPgNetwork, CPropertyPage)

BEGIN_MESSAGE_MAP(CPPgNetwork, CPropertyPage)
	ON_WM_DESTROY()
	ON_MESSAGE(WM_TREEOPTSCTRL_NOTIFY, OnTreeOptsCtrlNotify)
	ON_MESSAGE(WM_TREEITEM_HELP, DrawTreeItemHelp)
	ON_WM_HELPINFO()
END_MESSAGE_MAP()

CPPgNetwork::CPPgNetwork()
	: CPropertyPage(CPPgNetwork::IDD)
	, m_ctrlTreeOptions(theApp.m_iDfltImageListColorFlags)
{
	ClearAllMembers();
	m_ctrlTreeOptions.SetNeoStyle();
}

CPPgNetwork::~CPPgNetwork()
{
}

void CPPgNetwork::ClearAllMembers()
{
	m_bInitializedTreeOpts = false;
	
	m_htiNetwork = NULL;
		m_htiObelixConnectionControl = NULL; // NEO: OCC - [ObelixConnectionControl]
#ifdef NEO_BC // NEO: NBC - [NeoBandwidthControl]
		m_htiManageConnections = NULL;
		m_htiNAFC = NULL;
			m_htiNAFCEnabled = NULL;
			m_htiAdapterIP = NULL;
				m_htiISPMask = NULL;
				m_htiBindToAdapter = NULL;
			m_htiMSS = NULL;
				m_htiUseDoubleSendSize = NULL;
		m_htiPinger = NULL;
			m_htiCheckConnection = NULL;
			m_htiPingMode = NULL;
				m_htiPingICMP = NULL;
				m_htiPingRAW = NULL;
				m_htiPingUDP = NULL;
				m_htiNoTTL = NULL;
			m_htiHostToPing = NULL;
			m_htiStaticLowestPing = NULL;
#endif // NEO_BC // NEO: NBC END

		// NEO: NATS - [NatSupport]
		m_htiNAT = NULL;
			m_htiNATSupportEnabled = NULL;
				m_htiNATPortRefreshIvterval = NULL;
				m_htiNATPortMaxLatencyTime = NULL;
				m_htiNATPortMaxFails = NULL;
				m_htiNATPortFastRefresh = NULL;
#ifdef NATTUNNELING // NEO: NATT - [NatTraversal]
			m_htiNATPortRelaiable = NULL;
			m_htiNATTraversalEnabled = NULL;
				m_htiRestrictedNat = NULL;
				m_htiFullConeNat = NULL;
				m_htiSymetricNat = NULL;
				m_htiDontTrustNatPorts = NULL;
			m_htiLowIDUplaodCallBack = NULL; // NEO: LUC - [LowIDUplaodCallBack]
#endif //NATTUNNELING // NEO: NATT END
			m_htiReuseTCPPort = NULL;
		// NEO: NATS END

		// NEO: QS - [QuickStart]
		m_htiQuickStart = NULL;
			m_htiQuickStartEnable = NULL;
			m_htiQuickStartTime = NULL;
			m_htiQuickStartTimePerFile = NULL;
			m_htiQuickMaxConperFive = NULL;
			m_htiQuickMaxHalfOpen = NULL;
			m_htiQuickMaxConnections = NULL;
		// NEO: QS END
		// NEO: IFWS - [ICSFirewall]
		m_htiICSFirewall = NULL;
			m_htiICFSupport = NULL;
			m_htiICFClearOnClose = NULL;
		// NEO: IFWS END
		// NEO: UPNP - [UPnPNat]
		m_htiUPnPNatSupport = NULL;
			m_htiUPnPNat = NULL;
			m_htiUPnPClearOnClose = NULL;
			m_htiUPnPTryRandom = NULL;
		// NEO: UPNP END
		// NEO: RIC - [ReaskOnIDChange]
		m_htiOnIDChange = NULL;
			m_htiCheckIPChange = NULL;
			m_htiInformOnIPChange = NULL;
			m_htiReAskOnIPChange = NULL;
			m_htiQuickStartOnIPChange = NULL; // NEO: QS - [QuickStart]
			m_htiCheckL2HIDChange = NULL;
			m_htiReconnectKadOnIPChange = NULL;
			m_htiRebindSocketsOnIPChange = NULL;
		// NEO: RIC END
		m_htiDownloadKeepAliveTimeout = NULL; // NEO: DKA - [DownloadKeepAlive]
		m_htiTCPConnectionRetry = NULL; // NEO: TCR - [TCPConnectionRetry]
		m_htiTCPDisableNagle = NULL;
		m_htiRecheckKadFirewalled = NULL; // NEO: RKF - [RecheckKadFirewalled]

		m_htiReConnectOnLowID = NULL; // NEO: RLD - [ReconnectOnLowID]
}

void CPPgNetwork::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_MOD_OPTS, m_ctrlTreeOptions);
	if (!m_bInitializedTreeOpts)
	{
		int iImgNetwork = 8;
#ifdef NEO_BC // NEO: NBC - [NeoBandwidthControl]
		int iImgNAFC = 8;
		int iImgPinger = 8;
		int iImgPing = 8;
#endif // NEO_BC // NEO: NBC END 
		int iImgNAT = 8; // NEO: NATS - [NatSupport]
		int iImgReaskOnIDChange = 8;
		int iImgQuickStart = 8;
		int iImgWinXPFW = 8; 
		int iImgUPnP = 8; // NEO: UPNP - [UPnPNat]
        CImageList* piml = m_ctrlTreeOptions.GetImageList(TVSIL_NORMAL);
		if (piml){
			iImgNetwork = piml->Add(CTempIconLoader(_T("NETWORKTWEAKS")));
#ifdef NEO_BC // NEO: NBC - [NeoBandwidthControl]
			iImgNAFC = piml->Add(CTempIconLoader(_T("NAFC")));
			iImgPinger = piml->Add(CTempIconLoader(_T("PINGER")));
			iImgPing = piml->Add(CTempIconLoader(_T("PING")));
#endif // NEO_BC // NEO: NBC END
			iImgNAT = piml->Add(CTempIconLoader(_T("NAT"))); // NEO: NATS - [NatSupport]
			iImgReaskOnIDChange = piml->Add(CTempIconLoader(_T("REASKONIDCHANGE")));
			iImgWinXPFW  = piml->Add(CTempIconLoader(_T("WXPFW")));
			iImgUPnP = piml->Add(CTempIconLoader(_T("UPNP"))); // NEO: UPNP - [UPnPNat]
			iImgQuickStart = piml->Add(CTempIconLoader(_T("QUICKSTART")));
		}

		SetTreeGroup(m_ctrlTreeOptions,m_htiNetwork,GetResString(IDS_X_NETWORK_TWEAKS),iImgNetwork, TVI_ROOT, GetResString(IDS_X_NETWORK_TWEAKS_INFO));
			SetTreeCheckNumEdit(m_ctrlTreeOptions,m_htiObelixConnectionControl,GetResString(IDS_X_OCC),m_htiNetwork,GetResString(IDS_X_OCC_INFO),FALSE,m_bObelixConnectionControl); // NEO: OCC - [ObelixConnectionControl]
#ifdef NEO_BC // NEO: NBC - [NeoBandwidthControl]
			SetTreeCheckNumEdit(m_ctrlTreeOptions,m_htiManageConnections,GetResString(IDS_X_MANAGE_CONNECTIONS),m_htiNetwork,GetResString(IDS_X_MANAGE_CONNECTIONS_INFO),FALSE,m_bManageConnections);
			SetTreeGroup(m_ctrlTreeOptions,m_htiNAFC,GetResString(IDS_X_NAFC),iImgNAFC, m_htiNetwork, GetResString(IDS_X_NAFC_INFO));
				SetTreeCheck(m_ctrlTreeOptions,m_htiNAFCEnabled,GetResString(IDS_X_NAFC_ENABLE),m_htiNAFC,GetResString(IDS_X_NAFC_ENABLE_INFO),TRUE,m_uNAFCEnabled);
				SetTreeAdapterIndex(m_ctrlTreeOptions,m_htiAdapterIP,GetResString(IDS_X_NAFC_ADAPTER),m_htiNAFC,GetResString(IDS_X_NAFC_ADAPTER_INFO),FALSE,TRUE,FALSE, m_bISPCustomIP);
					SetTreeAdapterIndex(m_ctrlTreeOptions,m_htiISPMask,GetResString(IDS_X_NAFC_ADAPTER_MASK),m_htiAdapterIP,GetResString(IDS_X_NAFC_ADAPTER_MASK_INFO),TRUE);
					SetTreeCheck(m_ctrlTreeOptions,m_htiBindToAdapter,GetResString(IDS_X_BIND),m_htiAdapterIP,GetResString(IDS_X_BIND_INFO),FALSE,m_bBindToAdapter);
				SetTreeCheckNumEdit(m_ctrlTreeOptions,m_htiMSS,GetResString(IDS_X_MSS), m_htiNAFC,GetResString(IDS_X_MSS_INFO),FALSE,m_bAutoMSS);
					SetTreeCheck(m_ctrlTreeOptions,m_htiUseDoubleSendSize,GetResString(IDS_X_USE_DOUBLE_SEND_SIZE),m_htiMSS,GetResString(IDS_X_USE_DOUBLE_SEND_SIZE_INFO),FALSE,m_bUseDoubleSendSize);
			SetTreeGroup(m_ctrlTreeOptions,m_htiPinger,GetResString(IDS_X_PINGER),iImgPinger, m_htiNetwork, GetResString(IDS_X_PINGER_INFO));
				SetTreeCheck(m_ctrlTreeOptions,m_htiCheckConnection,GetResString(IDS_X_CHECK_CONNECTION),m_htiPinger,GetResString(IDS_X_CHECK_CONNECTION_INFO),FALSE,m_bCheckConnection);
				SetTreeGroup(m_ctrlTreeOptions,m_htiPingMode,GetResString(IDS_X_PING),iImgPing, m_htiPinger, GetResString(IDS_X_PING_INFO));
					SetTreeRadio(m_ctrlTreeOptions,m_htiPingICMP,GetResString(IDS_X_PING_ICMP),m_htiPingMode,GetResString(IDS_X_PING_ICMP_INFO),FALSE,m_iPingMode == 0);
					SetTreeRadio(m_ctrlTreeOptions,m_htiPingRAW,GetResString(IDS_X_PING_RAW),m_htiPingMode,GetResString(IDS_X_PING_RAW_INFO),FALSE,m_iPingMode == 1);
					SetTreeRadio(m_ctrlTreeOptions,m_htiPingUDP,GetResString(IDS_X_PING_UDP),m_htiPingMode,GetResString(IDS_X_PING_UDP_INFO),FALSE,m_iPingMode == 2);
					SetTreeCheck(m_ctrlTreeOptions,m_htiNoTTL,GetResString(IDS_X_NOTTL),m_htiPingMode,GetResString(IDS_X_NOTTL_INFO),FALSE,m_bNoTTL);
				SetTreeCheckEdit(m_ctrlTreeOptions,m_htiHostToPing,GetResString(IDS_X_HOST_TO_PING), m_htiPinger,GetResString(IDS_X_HOST_TO_PING_INFO),FALSE, m_bManualHostToPing);
				SetTreeCheck(m_ctrlTreeOptions,m_htiStaticLowestPing,GetResString(IDS_X_STATIC_LOWEST_PING),m_htiPinger,GetResString(IDS_X_STATIC_LOWEST_PING_INFO),FALSE,m_bStaticLowestPing);
#endif // NEO_BC // NEO: NBC END

		// NEO: NATS - [NatSupport]
			SetTreeGroup(m_ctrlTreeOptions,m_htiNAT,GetResString(IDS_X_NAT),iImgNAT, m_htiNetwork, GetResString(IDS_X_NAT_INFO));
				SetTreeCheck(m_ctrlTreeOptions,m_htiNATSupportEnabled,GetResString(IDS_X_NAT_SUPPORT),m_htiNAT,GetResString(IDS_X_NAT_SUPPORT_INFO),FALSE,m_bNATSupportEnabled);
					SetTreeNumEdit(m_ctrlTreeOptions,m_htiNATPortRefreshIvterval,GetResString(IDS_X_NAT_REFRESH_INTERVALS), m_htiNATSupportEnabled,GetResString(IDS_X_NAT_REFRESH_INTERVALS_INFO));
					SetTreeNumEdit(m_ctrlTreeOptions,m_htiNATPortMaxLatencyTime,GetResString(IDS_X_NAT_MAX_LATENCY), m_htiNATSupportEnabled,GetResString(IDS_X_NAT_MAX_LATENCY_INFO));
					SetTreeNumEdit(m_ctrlTreeOptions,m_htiNATPortMaxFails,GetResString(IDS_X_NAT_MAX_FAILS), m_htiNATSupportEnabled,GetResString(IDS_X_NAT_MAX_FAILS));
					SetTreeCheck(m_ctrlTreeOptions,m_htiNATPortFastRefresh,GetResString(IDS_X_NAT_FAST_REFRESH),m_htiNATSupportEnabled,GetResString(IDS_X_NAT_FAST_REFRESH_INFO),FALSE,m_bNATPortFastRefresh);
#ifdef NATTUNNELING // NEO: NATT - [NatTraversal]
				SetTreeCheck(m_ctrlTreeOptions,m_htiNATPortRelaiable,GetResString(IDS_X_NAT_RELAIABLE_PORT),m_htiNAT,GetResString(IDS_X_NAT_RELAIABLE_PORT_INFO),FALSE,m_bNATPortRelaiable);
				SetTreeCheck(m_ctrlTreeOptions,m_htiNATTraversalEnabled,GetResString(IDS_X_NAT_TRAVERSAL),m_htiNAT,GetResString(IDS_X_NAT_TRAVERSAL_INFO),FALSE,m_bNATTraversalEnabled);
					SetTreeRadio(m_ctrlTreeOptions,m_htiRestrictedNat,GetResString(IDS_X_NAT_TYPE_RESTRICTED),m_htiNATTraversalEnabled,GetResString(IDS_X_NAT_TYPE_RESTRICTED_INFO),FALSE,m_iNatCharacteristic == 0);
					SetTreeRadio(m_ctrlTreeOptions,m_htiFullConeNat,GetResString(IDS_X_NAT_TYPE_FULL_CONE),m_htiNATTraversalEnabled,GetResString(IDS_X_NAT_TYPE_FULL_CONE_INFO),FALSE,m_iNatCharacteristic == 1);
					SetTreeRadio(m_ctrlTreeOptions,m_htiSymetricNat,GetResString(IDS_X_NAT_TYPE_SYMETRIC),m_htiNATTraversalEnabled,GetResString(IDS_X_NAT_TYPE_SYMETRIC_INFO),FALSE,m_iNatCharacteristic == 2);
					SetTreeCheck(m_ctrlTreeOptions,m_htiDontTrustNatPorts,GetResString(IDS_X_NAT_DONT_TRUST_PORTS),m_htiNATTraversalEnabled,GetResString(IDS_X_NAT_DONT_TRUST_PORTS_INFO),FALSE,m_bDontTrustNatPorts);
				SetTreeCheck(m_ctrlTreeOptions,m_htiLowIDUplaodCallBack,GetResString(IDS_X_LOWID_UPLAOD_CALLBACK),m_htiNAT,GetResString(IDS_X_LOWID_UPLAOD_CALLBACK_INFO),TRUE,m_uLowIDUplaodCallBack); // NEO: LUC - [LowIDUplaodCallBack]
#endif //NATTUNNELING // NEO: NATT END
				SetTreeCheck(m_ctrlTreeOptions,m_htiReuseTCPPort,GetResString(IDS_RE_USE_TCP_PORT),m_htiNAT,GetResString(IDS_RE_USE_TCP_PORT_INFO),FALSE,m_uReuseTCPPort);
		// NEO: NATS END

			// NEO: RIC - [ReaskOnIDChange]
			SetTreeGroup(m_ctrlTreeOptions,m_htiOnIDChange,GetResString(IDS_X_ON_ID_CHANGE),iImgReaskOnIDChange, m_htiNetwork, GetResString(IDS_X_ON_ID_CHANGE_INFO));
				SetTreeCheck(m_ctrlTreeOptions,m_htiCheckIPChange,GetResString(IDS_X_CHECK_ID_CHANGES),m_htiOnIDChange,GetResString(IDS_X_CHECK_ID_CHANGES_INFO),TRUE,m_uCheckIPChange);
					SetTreeCheck(m_ctrlTreeOptions,m_htiCheckL2HIDChange,GetResString(IDS_X_CHECK_L2H_CHANGES),m_htiCheckIPChange,GetResString(IDS_X_CHECK_L2H_CHANGES_INFO),FALSE,m_bCheckL2HIDChange);
				SetTreeCheck(m_ctrlTreeOptions,m_htiInformOnIPChange,GetResString(IDS_X_INFORM_ON_ID_CHANGE),m_htiOnIDChange,GetResString(IDS_X_INFORM_ON_ID_CHANGE_INFO),FALSE,m_bInformOnIPChange);
				SetTreeCheck(m_ctrlTreeOptions,m_htiReAskOnIPChange,GetResString(IDS_X_REASK_ON_ID_CHANGE),m_htiOnIDChange,GetResString(IDS_X_REASK_ON_ID_CHANGE_INFO),FALSE,m_bReAskOnIPChange);
					SetTreeCheck(m_ctrlTreeOptions,m_htiQuickStartOnIPChange,GetResString(IDS_X_QUICK_START_ON_ID_CHANGE),m_htiReAskOnIPChange,GetResString(IDS_X_QUICK_START_ON_ID_CHANGE_INFO),FALSE,m_bQuickStartOnIPChange); // NEO: QS - [QuickStart]
				SetTreeCheck(m_ctrlTreeOptions,m_htiReconnectKadOnIPChange,GetResString(IDS_X_RECONNECTKAD_ON_ID_CHANGE),m_htiOnIDChange,GetResString(IDS_X_RECONNECTKAD_ON_ID_CHANGE_INFO),FALSE,m_bReconnectKadOnIPChange);
				SetTreeCheck(m_ctrlTreeOptions,m_htiRebindSocketsOnIPChange,GetResString(IDS_X_REBIND_SOCKETS_ON_IP_CHANGE),m_htiOnIDChange,GetResString(IDS_X_REBIND_SOCKETS_ON_IP_CHANGE_INFO),FALSE,m_bRebindSocketsOnIPChange);
			// NEO: RIC END
			// NEO: QS - [QuickStart]
			SetTreeGroup(m_ctrlTreeOptions,m_htiQuickStart,GetResString(IDS_X_QUICK_START),iImgQuickStart, m_htiNetwork, GetResString(IDS_X_QUICK_START_INFO));
				SetTreeCheck(m_ctrlTreeOptions,m_htiQuickStartEnable,GetResString(IDS_X_QUICK_START_ENABLE),m_htiQuickStart,GetResString(IDS_X_QUICK_START_ENABLE_INFO),TRUE,m_uQuickStart);
				SetTreeNumEdit(m_ctrlTreeOptions,m_htiQuickStartTime,GetResString(IDS_X_QUICK_START_TIME), m_htiQuickStart,GetResString(IDS_X_QUICK_START_TIME_INFO));
				SetTreeNumEdit(m_ctrlTreeOptions,m_htiQuickStartTimePerFile,GetResString(IDS_X_QUICK_START_TIME_PER_FILE), m_htiQuickStart,GetResString(IDS_X_QUICK_START_TIME_PER_FILE_INFO));
				SetTreeNumEdit(m_ctrlTreeOptions,m_htiQuickMaxConperFive,GetResString(IDS_X_QUICK_START_MAXPER5), m_htiQuickStart,GetResString(IDS_X_QUICK_START_MAXPER5_INFO));
				SetTreeNumEdit(m_ctrlTreeOptions,m_htiQuickMaxHalfOpen,GetResString(IDS_X_QUICK_START_MAXHALF), m_htiQuickStart,GetResString(IDS_X_QUICK_START_MAXHALF_INFO));
				SetTreeNumEdit(m_ctrlTreeOptions,m_htiQuickMaxConnections,GetResString(IDS_X_QUICK_START_MAXCON), m_htiQuickStart,GetResString(IDS_X_QUICK_START_MAXCON_INFO));
			// NEO: QS END
			// NEO: IFWS - [ICSFirewall]
			SetTreeGroup(m_ctrlTreeOptions,m_htiICSFirewall,GetResString(IDS_X_ICS_FIREWALL),iImgWinXPFW, m_htiNetwork, GetResString(IDS_X_ICS_FIREWALL_INFO));
				SetTreeCheck(m_ctrlTreeOptions,m_htiICFSupport,GetResString(IDS_X_ICS_SUPPORT),m_htiICSFirewall,GetResString(IDS_X_ICS_SUPPORT_INFO),FALSE,m_uICFSupport);
				SetTreeCheck(m_ctrlTreeOptions,m_htiICFClearOnClose,GetResString(IDS_X_ICF_CLEAR_ON_CLOSE),m_htiICSFirewall,GetResString(IDS_X_ICF_CLEAR_ON_CLOSE_INFO),FALSE,m_bICFClearOnClose);
			// NEO: IFWS END
			// NEO: UPNP - [UPnPNat]
			SetTreeGroup(m_ctrlTreeOptions,m_htiUPnPNatSupport,GetResString(IDS_X_UPNP),iImgUPnP, m_htiNetwork, GetResString(IDS_X_UPNP_INFO));
				SetTreeCheck(m_ctrlTreeOptions,m_htiUPnPNat,GetResString(IDS_X_UPNP_SUPPORT),m_htiUPnPNatSupport,GetResString(IDS_X_UPNP_SUPPORT_INFO),TRUE,m_uUPnPNat);
				SetTreeCheck(m_ctrlTreeOptions,m_htiUPnPClearOnClose,GetResString(IDS_X_UPNP_CLEAR_ON_CLOSE),m_htiUPnPNatSupport,GetResString(IDS_X_UPNP_CLEAR_ON_CLOSE_INFO),FALSE,m_bUPnPClearOnClose);
				SetTreeCheck(m_ctrlTreeOptions,m_htiUPnPTryRandom,GetResString(IDS_X_UPNP_TRY_RANDOM),m_htiUPnPNatSupport,GetResString(IDS_X_UPNP_TRY_RANDOM_INFO),FALSE,m_bUPnPTryRandom);
			// NEO: UPNP END
			SetTreeCheckNumEdit(m_ctrlTreeOptions,m_htiDownloadKeepAliveTimeout,GetResString(IDS_X_DOWNLOAD_KEEP_ALIVE), m_htiNetwork,GetResString(IDS_X_DOWNLOAD_KEEP_ALIVE_INFO),FALSE, m_bTCPConnectionRetry); // NEO: DKA - [DownloadKeepAlive]
			SetTreeCheckNumEdit(m_ctrlTreeOptions,m_htiTCPConnectionRetry,GetResString(IDS_X_TCP_CON_RETRY), m_htiNetwork,GetResString(IDS_X_TCP_CON_RETRY_INFO),FALSE, m_bTCPConnectionRetry); // NEO: TCR - [TCPConnectionRetry]
			SetTreeCheck(m_ctrlTreeOptions,m_htiTCPDisableNagle,GetResString(IDS_X_TCP_DISABLE_NAGLE),m_htiNetwork,GetResString(IDS_X_TCP_DISABLE_NAGLE_INFO),FALSE,m_bTCPDisableNagle);
			SetTreeCheckNumEdit(m_ctrlTreeOptions,m_htiRecheckKadFirewalled,GetResString(IDS_FIREWALLED_CHECK), m_htiNetwork,GetResString(IDS_FIREWALLED_CHECK_INFO),FALSE, m_bRecheckKadFirewalled); // NEO: RKF - [RecheckKadFirewalled]
			SetTreeCheckNumEdit(m_ctrlTreeOptions,m_htiReConnectOnLowID,GetResString(IDS_LOW_ID_RETRY), m_htiNetwork,GetResString(IDS_LOW_ID_RETRY_INFO),FALSE, m_bReConnectOnLowID); // NEO: RLD - [ReconnectOnLowID]


		UINT bCheck;
		// NEO: OCC- [ObelixConnectionControl]
		m_ctrlTreeOptions.GetCheckBox(m_htiObelixConnectionControl, bCheck);
		m_ctrlTreeOptions.SetItemEnable(m_htiObelixConnectionControl, bCheck,FALSE,TRUE);
		// NEO: OCC END
#ifdef NEO_BC // NEO: NBC - [NeoBandwidthControl]
		m_ctrlTreeOptions.GetCheckBox(m_htiManageConnections, bCheck);
		m_ctrlTreeOptions.SetItemEnable(m_htiManageConnections, bCheck,FALSE,TRUE);

		CheckNAFCEnable();

		m_ctrlTreeOptions.GetCheckBox(m_htiMSS, bCheck);
		m_ctrlTreeOptions.SetItemEnable(m_htiMSS, !bCheck,FALSE,TRUE);
#endif // NEO_BC // NEO: NBC END

		CheckNATEnable(); // NEO: NATS - [NatSupport]

		// NEO: RIC - [ReaskOnIDChange]
		m_ctrlTreeOptions.SetItemEnable(m_htiCheckL2HIDChange,m_uCheckIPChange); 
		m_ctrlTreeOptions.SetItemEnable(m_htiInformOnIPChange,m_uCheckIPChange); 
		m_ctrlTreeOptions.SetItemEnable(m_htiReAskOnIPChange,m_uCheckIPChange); 
		m_ctrlTreeOptions.SetItemEnable(m_htiQuickStartOnIPChange,m_uCheckIPChange && m_uQuickStart); 
		m_ctrlTreeOptions.SetItemEnable(m_htiReconnectKadOnIPChange,m_uCheckIPChange); 
		m_ctrlTreeOptions.SetItemEnable(m_htiRebindSocketsOnIPChange,m_uCheckIPChange); 
		// NEO: RIC END
		// NEO: QS - [QuickStart]
		m_ctrlTreeOptions.SetItemEnable(m_htiQuickStartTime, m_uQuickStart); 
		m_ctrlTreeOptions.SetItemEnable(m_htiQuickStartTimePerFile, m_uQuickStart); 
		m_ctrlTreeOptions.SetItemEnable(m_htiQuickMaxConperFive, m_uQuickStart); 
		m_ctrlTreeOptions.SetItemEnable(m_htiQuickMaxHalfOpen, m_uQuickStart); 
		m_ctrlTreeOptions.SetItemEnable(m_htiQuickMaxConnections, m_uQuickStart); 
		// NEO: QS END

		m_ctrlTreeOptions.SetItemEnable(m_htiDownloadKeepAliveTimeout, m_bEnableDownloadKeepAlive, TRUE, TRUE); // NEO: DKA - [DownloadKeepAlive]
		m_ctrlTreeOptions.SetItemEnable(m_htiTCPConnectionRetry, m_bTCPConnectionRetry, TRUE, TRUE); // NEO: TCR - [TCPConnectionRetry]

		m_ctrlTreeOptions.SetItemEnable(m_htiICSFirewall, thePrefs.GetWindowsVersion() == _WINVER_XP_); // NEO: IFWS - [ICSFirewall]
		// NEO: UPNP - [UPnPNat]
		m_ctrlTreeOptions.SetItemEnable(m_htiUPnPClearOnClose,m_uUPnPNat); 
		m_ctrlTreeOptions.SetItemEnable(m_htiUPnPTryRandom,m_uUPnPNat); 
		// NEO: UPNP END

		m_ctrlTreeOptions.Expand(m_htiNetwork, TVE_EXPAND);
		m_bInitializedTreeOpts = true;
	}

	// NEO: OCC - [ObelixConnectionControl]
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiObelixConnectionControl, m_bObelixConnectionControl);
	DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiObelixConnectionControl, m_iObelixConnectionControlValue);
	// NEO: OCC END

#ifdef NEO_BC // NEO: NBC - [NeoBandwidthControl]
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiManageConnections, m_bManageConnections);
	DDX_TreeEditE0f(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiManageConnections, m_fManageConnectionsFactor);
		DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiNAFCEnabled, m_uNAFCEnabled);
		DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiAdapterIP, m_bISPCustomIP);
		DDX_AdapterIndex(&m_ctrlTreeOptions,pDX, IDC_MOD_OPTS, m_htiAdapterIP, m_uISPZone);
			DDX_AdapterIndex(&m_ctrlTreeOptions,pDX, IDC_MOD_OPTS, m_htiISPMask, m_uISPMask);
			DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiBindToAdapter, m_bBindToAdapter);

		DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiMSS, m_bAutoMSS); 
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiMSS, m_iMSS);

		DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiUseDoubleSendSize, m_bUseDoubleSendSize); 

		DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiCheckConnection, m_bCheckConnection);
			DDX_TreeRadio(pDX, IDC_MOD_OPTS, m_htiPingMode, m_iPingMode);
			DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiNoTTL, m_bNoTTL);
		DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiHostToPing, m_bManualHostToPing);
		DDX_TreeEdit(pDX, IDC_MOD_OPTS, m_htiHostToPing, m_sPingServer);
		DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiStaticLowestPing, m_bStaticLowestPing);
#endif // NEO_BC // NEO: NBC END

		// NEO: NATS - [NatSupport]
		DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiNATSupportEnabled, m_bNATSupportEnabled); 
			DDX_TreeEditE0f(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiNATPortRefreshIvterval, m_fNATPortRefreshIvterval);
			DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiNATPortMaxLatencyTime, m_iNATPortMaxLatencyTime);
			DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiNATPortMaxFails, m_iNATPortMaxFails);
			DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiNATPortFastRefresh, m_bNATPortFastRefresh); 
#ifdef NATTUNNELING // NEO: NATT - [NatTraversal]
		DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiNATPortRelaiable, m_bNATPortRelaiable); 
		DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiNATTraversalEnabled, m_bNATTraversalEnabled); 
			DDX_TreeRadio(pDX, IDC_MOD_OPTS, m_htiNATTraversalEnabled, m_iNatCharacteristic); 
			DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiDontTrustNatPorts, m_bDontTrustNatPorts); 
		DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiLowIDUplaodCallBack, m_uLowIDUplaodCallBack); // NEO: LUC - [LowIDUplaodCallBack]
#endif //NATTUNNELING // NEO: NATT END
		DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiReuseTCPPort, m_uReuseTCPPort); 
		// NEO: NATS END

		// NEO: RIC - [ReaskOnIDChange]
		DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiCheckIPChange, m_uCheckIPChange);
		DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiInformOnIPChange, m_bInformOnIPChange);
		DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiReAskOnIPChange, m_bReAskOnIPChange);
		DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiQuickStartOnIPChange, m_bQuickStartOnIPChange); // NEO: QS - [QuickStart]
		DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiCheckL2HIDChange, m_bCheckL2HIDChange);
		DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiReconnectKadOnIPChange, m_bReconnectKadOnIPChange);
		DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiRebindSocketsOnIPChange, m_bRebindSocketsOnIPChange);
		// NEO: RIC END
		// NEO: QS - [QuickStart]
		DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiQuickStartEnable, m_uQuickStart);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiQuickStartTime, m_iQuickStartTime);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiQuickStartTimePerFile, m_iQuickStartTimePerFile);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiQuickMaxConperFive, m_iQuickMaxConperFive);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiQuickMaxHalfOpen, m_iQuickMaxHalfOpen);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiQuickMaxConnections, m_iQuickMaxConnections);
		// NEO: QS END
		// NEO: IFWS - [ICSFirewall]
		DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiICFSupport, m_uICFSupport);
		DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiICFClearOnClose, m_bICFClearOnClose);
		// NEO: IFWS END
		// NEO: UPNP - [UPnPNat]
		DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiUPnPNat, m_uUPnPNat);
		DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiUPnPClearOnClose, m_bUPnPClearOnClose);
		DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiUPnPTryRandom, m_bUPnPTryRandom);
		// NEO: UPNP END
	// NEO: DKA - [DownloadKeepAlive]
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiDownloadKeepAliveTimeout, m_bEnableDownloadKeepAlive);
	DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiDownloadKeepAliveTimeout, m_iDownloadKeepAliveTimeout);
	// NEO: DKA END
	// NEO: TCR - [TCPConnectionRetry]
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiTCPConnectionRetry, m_bTCPConnectionRetry);
	DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiTCPConnectionRetry, m_iTCPConnectionRetry);
	// NEO: TCR END
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiTCPDisableNagle, m_bTCPDisableNagle);
	// NEO: RKF - [RecheckKadFirewalled]
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiRecheckKadFirewalled, m_bRecheckKadFirewalled);
	DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiRecheckKadFirewalled, m_iRecheckKadFirewalled);
	// NEO: RKF END
	// NEO: RLD - [ReconnectOnLowID]
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiReConnectOnLowID, m_bReConnectOnLowID);
	DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiReConnectOnLowID, m_iReConnectOnLowID);
	// NEO: RLD END

}

BOOL CPPgNetwork::OnInitDialog()
{
	LoadSettings();

	CPropertyPage::OnInitDialog();
	InitWindowStyles(this);

	return TRUE;  // return TRUE unless you set the focus to a control
				  // EXCEPTION: OCX Property Pages should return FALSE
}

void CPPgNetwork::LoadSettings()
{
	/*
	* Globale Einstellungen Laden
	*/

	// NEO: OCC - [ObelixConnectionControl]
	m_bObelixConnectionControl = thePrefs.m_bObelixConnectionControl;
	m_iObelixConnectionControlValue = thePrefs.m_iObelixConnectionControlValue;
	// NEO: OCC END

#ifdef NEO_BC // NEO: NBC - [NeoBandwidthControl]
	m_bManageConnections = thePrefs.m_bManageConnections;
	m_fManageConnectionsFactor = thePrefs.m_fManageConnectionsFactor;

	m_uNAFCEnabled = thePrefs.m_uNAFCEnabled;
	m_bISPCustomIP = thePrefs.m_bISPCustomIP;
	m_uISPZone = thePrefs.m_uISPZone;
	m_uISPMask = thePrefs.m_uISPMask;
	m_bBindToAdapter = thePrefs.m_bBindToAdapter;

	m_bCheckConnection = thePrefs.m_bCheckConnection;
	m_bStaticLowestPing = thePrefs.m_bStaticLowestPing;
	m_iPingMode = thePrefs.m_iPingMode;
	m_bNoTTL = thePrefs.m_bNoTTL;
	m_bManualHostToPing = thePrefs.m_bManualHostToPing;
	m_sPingServer = thePrefs.m_sPingServer;

	m_bAutoMSS = thePrefs.m_bAutoMSS;
	m_iMSS = thePrefs.m_iMSS;

	m_bUseDoubleSendSize = thePrefs.m_bUseDoubleSendSize;
#endif // NEO_BC // NEO: NBC END

	// NEO: NATS - [NatSupport]
	m_bNATSupportEnabled = thePrefs.m_bNATSupportEnabled;
	m_fNATPortRefreshIvterval = thePrefs.m_fNATPortRefreshIvterval;
	m_iNATPortMaxLatencyTime = thePrefs.m_iNATPortMaxLatencyTime;
	m_iNATPortMaxFails = thePrefs.m_iNATPortMaxFails;
	m_bNATPortFastRefresh = thePrefs.m_bNATPortFastRefresh;

#ifdef NATTUNNELING // NEO: NATT - [NatTraversal]
	m_bNATPortRelaiable = thePrefs.m_bNATPortRelaiable;
	m_bNATTraversalEnabled = thePrefs.m_bNATTraversalEnabled;
	m_bDontTrustNatPorts = thePrefs.m_bDontTrustNatPorts;
	m_iNatCharacteristic = thePrefs.m_iNatCharacteristic;
	m_uLowIDUplaodCallBack = thePrefs.m_uLowIDUplaodCallBack; // NEO: LUC - [LowIDUplaodCallBack]
#endif //NATTUNNELING // NEO: NATT END
	m_uReuseTCPPort = thePrefs.m_uReuseTCPPort;
	// NEO: NATS END

	// NEO: DKA - [DownloadKeepAlive]
	m_bEnableDownloadKeepAlive = thePrefs.m_bEnableDownloadKeepAlive;
	m_iDownloadKeepAliveTimeout = thePrefs.m_iDownloadKeepAliveTimeout;
	// NEO: DKA END
	// NEO: TCR - [TCPConnectionRetry]
	m_bTCPConnectionRetry = thePrefs.m_bTCPConnectionRetry;
	m_iTCPConnectionRetry = thePrefs.m_iTCPConnectionRetry;
	// NEO: TCR END
	m_bTCPDisableNagle = thePrefs.m_bTCPDisableNagle;

	// NEO: QS - [QuickStart]
	m_uQuickStart = thePrefs.m_uQuickStart;
	m_iQuickStartTime = thePrefs.m_iQuickStartTime;
	m_iQuickStartTimePerFile = thePrefs.m_iQuickStartTimePerFile;
	m_iQuickMaxConperFive = thePrefs.m_iQuickMaxConperFive;
	m_iQuickMaxHalfOpen = thePrefs.m_iQuickMaxHalfOpen;
	m_iQuickMaxConnections = thePrefs.m_iQuickMaxConnections;
	// NEO: QS END

	// NEO: IFWS - [ICSFirewall]
	m_uICFSupport = thePrefs.m_uICFSupport;
	m_bICFClearOnClose = thePrefs.m_bICFClearOnClose;
	// NEO: IFWS END

	// NEO: UPNP - [UPnPNat]
	m_uUPnPNat = thePrefs.m_uUPnPNat;
	m_bUPnPClearOnClose = thePrefs.m_bUPnPClearOnClose;
	m_bUPnPTryRandom = thePrefs.m_bUPnPTryRandom;
	// NEO: UPNP END

	// NEO: RIC - [ReaskOnIDChange]
	m_uCheckIPChange = thePrefs.m_uCheckIPChange;
	m_bInformOnIPChange = thePrefs.m_bInformOnIPChange;
	m_bReAskOnIPChange = thePrefs.m_bReAskOnIPChange;
	m_bQuickStartOnIPChange = thePrefs.m_bQuickStartOnIPChange; // NEO: QS - [QuickStart]
	m_bCheckL2HIDChange = thePrefs.m_bCheckL2HIDChange;
	m_bReconnectKadOnIPChange = thePrefs.m_bReconnectKadOnIPChange;
	m_bRebindSocketsOnIPChange = thePrefs.m_bRebindSocketsOnIPChange;
	// NEO: RIC END

	// NEO: RKF - [RecheckKadFirewalled]
	m_bRecheckKadFirewalled = thePrefs.m_bRecheckKadFirewalled;
	m_iRecheckKadFirewalled = thePrefs.m_iRecheckKadFirewalled;
	// NEO: RKF END

	// NEO: RLD - [ReconnectOnLowID]
	m_bReConnectOnLowID = thePrefs.m_bReConnectOnLowID;
	m_iReConnectOnLowID = thePrefs.m_iReConnectOnLowID;
	// NEO: RLD END

}

BOOL CPPgNetwork::OnApply()
{
	// if prop page is closed by pressing ENTER we have to explicitly commit any possibly pending
	// data from an open edit control
	m_ctrlTreeOptions.HandleChildControlLosingFocus();

	if (!UpdateData())
		return FALSE;

	/*
	* Globale Einstellungen Speichern
	*/

	// NEO: OCC - [ObelixConnectionControl]
	thePrefs.m_bObelixConnectionControl = m_bObelixConnectionControl;
	thePrefs.m_iObelixConnectionControlValue = m_iObelixConnectionControlValue;
	// NEO: OCC END

#ifdef NEO_BC // NEO: NBC - [NeoBandwidthControl]
	thePrefs.m_bManageConnections = m_bManageConnections;
	thePrefs.m_fManageConnectionsFactor = m_fManageConnectionsFactor;

	thePrefs.m_uNAFCEnabled = m_uNAFCEnabled;
	bool ReConNAFC = false;
	if(thePrefs.m_bISPCustomIP != m_bISPCustomIP || thePrefs.m_uISPZone != m_uISPZone || thePrefs.m_uISPMask != m_uISPMask)
		ReConNAFC = true;
	thePrefs.m_bISPCustomIP = m_bISPCustomIP;
	thePrefs.m_uISPZone = m_uISPZone;
	thePrefs.m_uISPMask = m_uISPMask;
	bool UnBind = false;
	if(thePrefs.m_bBindToAdapter != m_bBindToAdapter){
		if(m_bBindToAdapter)
			ReConNAFC = true;
		else
			UnBind = true;
	}
	thePrefs.m_bBindToAdapter = m_bBindToAdapter;
	if(ReConNAFC)
		theApp.bandwidthControl->SetAdapterIndex();
	if(UnBind)
		theApp.BindToAddress();

	thePrefs.m_bCheckConnection = m_bCheckConnection;
	thePrefs.m_bStaticLowestPing = m_bStaticLowestPing;
	thePrefs.m_iPingMode = m_iPingMode;
	thePrefs.m_bNoTTL = m_bNoTTL;
	thePrefs.m_bManualHostToPing = m_bManualHostToPing;
	if (thePrefs.m_sPingServer != m_sPingServer){
		thePrefs.m_sPingServer = m_sPingServer;
		if(m_bManualHostToPing){
			if (!theApp.bandwidthControl->SetPingedServer(m_sPingServer))
				AfxMessageBox(GetResString(IDS_X_PING_SVR_ERR),MB_OK | MB_ICONERROR,NULL);
		}
	}

	thePrefs.m_bAutoMSS = m_bAutoMSS;
	thePrefs.m_iMSS = m_iMSS;

	thePrefs.m_bUseDoubleSendSize = m_bUseDoubleSendSize;
#endif // NEO_BC // NEO: NBC END

	// NEO: NATS - [NatSupport]
	thePrefs.m_bNATSupportEnabled = m_bNATSupportEnabled;
	thePrefs.m_fNATPortRefreshIvterval = m_fNATPortRefreshIvterval;
	thePrefs.m_iNATPortMaxLatencyTime = m_iNATPortMaxLatencyTime;
	thePrefs.m_iNATPortMaxFails = m_iNATPortMaxFails;
	thePrefs.m_bNATPortFastRefresh = m_bNATPortFastRefresh;

#ifdef NATTUNNELING // NEO: NATT - [NatTraversal]
	thePrefs.m_bNATPortRelaiable = m_bNATPortRelaiable;
	thePrefs.m_bNATTraversalEnabled = m_bNATTraversalEnabled;
	thePrefs.m_bDontTrustNatPorts = m_bDontTrustNatPorts;
	thePrefs.m_iNatCharacteristic = m_iNatCharacteristic;
	thePrefs.m_uLowIDUplaodCallBack = m_uLowIDUplaodCallBack; // NEO: LUC - [LowIDUplaodCallBack]
#endif //NATTUNNELING // NEO: NATT END
	thePrefs.m_uReuseTCPPort = m_uReuseTCPPort;
	// NEO: NATS END

	// NEO: DKA - [DownloadKeepAlive]
	thePrefs.m_bEnableDownloadKeepAlive = m_bEnableDownloadKeepAlive;
	thePrefs.m_iDownloadKeepAliveTimeout = m_iDownloadKeepAliveTimeout;
	// NEO: DKA END
	// NEO: TCR - [TCPConnectionRetry]
	thePrefs.m_bTCPConnectionRetry = m_bTCPConnectionRetry;
	thePrefs.m_iTCPConnectionRetry = m_iTCPConnectionRetry;
	// NEO: TCR END
	thePrefs.m_bTCPDisableNagle = m_bTCPDisableNagle;

	// NEO: QS - [QuickStart]
	thePrefs.m_uQuickStart = m_uQuickStart;
	thePrefs.m_iQuickStartTime = m_iQuickStartTime;
	thePrefs.m_iQuickStartTimePerFile = m_iQuickStartTimePerFile;
	thePrefs.m_iQuickMaxConperFive = m_iQuickMaxConperFive;
	thePrefs.m_iQuickMaxHalfOpen = m_iQuickMaxHalfOpen;
	thePrefs.m_iQuickMaxConnections = m_iQuickMaxConnections;
	// NEO: QS END

	// NEO: IFWS - [ICSFirewall]
	thePrefs.m_uICFSupport = m_uICFSupport;
	thePrefs.m_bICFClearOnClose = m_bICFClearOnClose;
	// NEO: IFWS END

	// NEO: UPNP - [UPnPNat]
	thePrefs.m_uUPnPNat = m_uUPnPNat;
	thePrefs.m_bUPnPClearOnClose = m_bUPnPClearOnClose;
	thePrefs.m_bUPnPTryRandom = m_bUPnPTryRandom;
	// NEO: UPNP END

	// NEO: RIC - [ReaskOnIDChange]
	thePrefs.m_uCheckIPChange = m_uCheckIPChange;
	thePrefs.m_bInformOnIPChange = m_bInformOnIPChange;
	thePrefs.m_bReAskOnIPChange = m_bReAskOnIPChange;
	thePrefs.m_bQuickStartOnIPChange = m_bQuickStartOnIPChange; // NEO: QS - [QuickStart]
	thePrefs.m_bCheckL2HIDChange = m_bCheckL2HIDChange;
	thePrefs.m_bReconnectKadOnIPChange = m_bReconnectKadOnIPChange;
	thePrefs.m_bRebindSocketsOnIPChange = m_bRebindSocketsOnIPChange;
	// NEO: RIC END

	// NEO: RKF - [RecheckKadFirewalled]
	thePrefs.m_bRecheckKadFirewalled = m_bRecheckKadFirewalled;
	thePrefs.m_iRecheckKadFirewalled = m_iRecheckKadFirewalled;
	// NEO: RKF END

	// NEO: RLD - [ReconnectOnLowID]
	thePrefs.m_bReConnectOnLowID = m_bReConnectOnLowID;
	thePrefs.m_iReConnectOnLowID = m_iReConnectOnLowID;
	// NEO: RLD END

	thePrefs.CheckNeoPreferences();
	LoadSettings();

	SetModified(FALSE);
	return CPropertyPage::OnApply();
}

BOOL CPPgNetwork::OnKillActive()
{
	// if prop page is closed by pressing ENTER we have to explicitly commit any possibly pending
	// data from an open edit control
	m_ctrlTreeOptions.HandleChildControlLosingFocus();
	return CPropertyPage::OnKillActive();
}

void CPPgNetwork::OnDestroy()
{
	m_ctrlTreeOptions.DeleteAllItems();
	m_ctrlTreeOptions.DestroyWindow();
	ClearAllMembers();
	CPropertyPage::OnDestroy();
}

LRESULT CPPgNetwork::OnTreeOptsCtrlNotify(WPARAM wParam, LPARAM lParam)
{
	if(!IsWindowVisible())
		return 0;

	if (wParam == IDC_MOD_OPTS){
		TREEOPTSCTRLNOTIFY* pton = (TREEOPTSCTRLNOTIFY*)lParam;
		if(pton->nmhdr.code == EN_KILLFOCUS){		
			// NEO: OCC - [ObelixConnectionControl]
			if(m_htiObelixConnectionControl && pton->hItem == m_htiObelixConnectionControl){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiObelixConnectionControl, VAL_OCC_MIN, VAL_OCC_DEF, VAL_OCC_MAX)) SetModified();
			}else
			// NEO: OCC END
#ifdef NEO_BC // NEO: NBC - [NeoBandwidthControl]
			if (m_htiManageConnections && pton->hItem == m_htiManageConnections){
				if(CheckTreeEditLimitF(m_ctrlTreeOptions, m_htiManageConnections, VAL_CON_CTRL_MIN, VAL_CON_CTRL_DEF, VAL_CON_CTRL_MAX)) SetModified();
			}else
#endif // NEO_BC // NEO: NBC END
			// NEO: NATS - [NatSupport]
			if (m_htiNATPortRefreshIvterval && pton->hItem == m_htiNATPortRefreshIvterval){
				if(CheckTreeEditLimitF(m_ctrlTreeOptions, m_htiNATPortRefreshIvterval, VAL_NAT_PORT_REFRESH_IVTERVAL_MIN, VAL_NAT_PORT_REFRESH_IVTERVAL_DEF, VAL_NAT_PORT_REFRESH_IVTERVAL_MAX)) SetModified();
			}else
			if(m_htiNATPortMaxLatencyTime && pton->hItem == m_htiNATPortMaxLatencyTime){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiNATPortMaxLatencyTime, VAL_NAT_PORT_MAX_LATENCY_TIME_MIN, VAL_NAT_PORT_MAX_LATENCY_TIME_DEF, VAL_NAT_PORT_MAX_LATENCY_TIME_MAX)) SetModified();
			}else
			if(m_htiNATPortMaxFails && pton->hItem == m_htiNATPortMaxFails){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiNATPortMaxFails, VAL_NAT_PORT_MAX_FAILS_MIN, VAL_NAT_PORT_MAX_FAILS_DEF, VAL_NAT_PORT_MAX_FAILS_MAX)) SetModified();
			}else
			// NEO: NATS END
			// NEO: DKA - [DownloadKeepAlive]
			if(m_htiDownloadKeepAliveTimeout && pton->hItem == m_htiDownloadKeepAliveTimeout){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiDownloadKeepAliveTimeout, VAL_DOWNLOAD_KEEP_ALIVE_TIMEOUT_MIN, VAL_DOWNLOAD_KEEP_ALIVE_TIMEOUT_DEF, VAL_DOWNLOAD_KEEP_ALIVE_TIMEOUT_MAX)) SetModified();
			}else
			// NEO: DKA END
			// NEO: TCR - [TCPConnectionRetry]
			if(m_htiTCPConnectionRetry && pton->hItem == m_htiTCPConnectionRetry){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiTCPConnectionRetry, VAL_TCP_CON_RETRY_MIN, VAL_TCP_CON_RETRY_DEF, VAL_TCP_CON_RETRY_MAX)) SetModified();
			}else
			// NEO: TCR END
			if(m_htiQuickStartTime && pton->hItem == m_htiQuickStartTime){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiQuickStartTime, TIM_QUICK_START_MIN, TIM_QUICK_START_DEF, TIM_QUICK_START_MAX)) SetModified();
			}else if(m_htiQuickStartTimePerFile && pton->hItem == m_htiQuickStartTimePerFile){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiQuickStartTimePerFile, VAL_QUICK_START_PF_MIN, VAL_QUICK_START_PF_DEF, VAL_QUICK_START_PF_MAX)) SetModified();
			}
			// NEO: RKF - [RecheckKadFirewalled]
			else if(m_htiRecheckKadFirewalled && pton->hItem == m_htiRecheckKadFirewalled){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiRecheckKadFirewalled, TIM_RECHECK_KAD_FIREWALLED_MIN, TIM_RECHECK_KAD_FIREWALLED_DEF, TIM_RECHECK_KAD_FIREWALLED_MAX)) SetModified();
			}
			// NEO: RKF END
			// NEO: RLD - [ReconnectOnLowID]
			else if(m_htiReConnectOnLowID && pton->hItem == m_htiReConnectOnLowID){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiReConnectOnLowID, VAL_RECONNECT_ON_LOWID_TRYS_MIN, VAL_RECONNECT_ON_LOWID_TRYS_DEF, VAL_RECONNECT_ON_LOWID_TRYS_MAX)) SetModified();
			}
			// NEO: RLD END
		}else{
			UINT bCheck;
			// NEO: OCC- [ObelixConnectionControl]
			if(m_htiObelixConnectionControl && pton->hItem == m_htiObelixConnectionControl){
				m_ctrlTreeOptions.GetCheckBox(m_htiObelixConnectionControl, bCheck);
				m_ctrlTreeOptions.SetItemEnable(m_htiObelixConnectionControl, bCheck,FALSE,TRUE);
			}
			// NEO: OCC END
#ifdef NEO_BC // NEO: NBC - [NeoBandwidthControl]
			else if(m_htiManageConnections && pton->hItem == m_htiManageConnections){
				m_ctrlTreeOptions.GetCheckBox(m_htiManageConnections, bCheck);
				m_ctrlTreeOptions.SetItemEnable(m_htiManageConnections, bCheck,FALSE,TRUE);
			}else if (m_htiNAFCEnabled && pton->hItem == m_htiNAFCEnabled){
				CheckNAFCEnable();
			}else if (m_htiAdapterIP && pton->hItem == m_htiAdapterIP){
				CheckNAFCEnable();
			}else if (m_htiMSS && pton->hItem == m_htiMSS){
				m_ctrlTreeOptions.GetCheckBox(m_htiMSS, bCheck);
				m_ctrlTreeOptions.SetItemEnable(m_htiMSS, !bCheck,FALSE,TRUE);
			}else
#endif // NEO_BC // NEO: NBC END
			// NEO: NATS - [NatSupport]
			if (m_htiNATSupportEnabled && pton->hItem == m_htiNATSupportEnabled){
				CheckNATEnable();
			}else 
#ifdef NATTUNNELING // NEO: NATT - [NatTraversal]
			if (m_htiNATPortRelaiable && pton->hItem == m_htiNATPortRelaiable){
				CheckNATEnable();
			}else 
			if (m_htiNATTraversalEnabled && pton->hItem == m_htiNATTraversalEnabled){
				CheckNATEnable();
			}else 
#endif //NATTUNNELING // NEO: NATT END
			// NEO: NATS END
			// NEO: RIC - [ReaskOnIDChange]
			if (m_htiCheckIPChange && pton->hItem == m_htiCheckIPChange){
				m_ctrlTreeOptions.GetCheckBox(m_htiCheckIPChange, bCheck);

				m_ctrlTreeOptions.SetItemEnable(m_htiCheckL2HIDChange,bCheck); 
				m_ctrlTreeOptions.SetItemEnable(m_htiInformOnIPChange,bCheck); 
				m_ctrlTreeOptions.SetItemEnable(m_htiReAskOnIPChange,bCheck); 
				UINT bCheck2;
				m_ctrlTreeOptions.GetCheckBox(m_htiQuickStartEnable, bCheck2);
				m_ctrlTreeOptions.SetItemEnable(m_htiQuickStartOnIPChange,bCheck && bCheck2); 
				m_ctrlTreeOptions.SetItemEnable(m_htiReconnectKadOnIPChange,bCheck); 
				m_ctrlTreeOptions.SetItemEnable(m_htiRebindSocketsOnIPChange,bCheck); 	
			}else
			// NEO: RIC END
			// NEO: QS - [QuickStart]
			if (m_htiQuickStartEnable && pton->hItem == m_htiQuickStartEnable){
				m_ctrlTreeOptions.GetCheckBox(m_htiQuickStartEnable, bCheck);
				
				m_ctrlTreeOptions.SetItemEnable(m_htiQuickStartTime, bCheck); 
				m_ctrlTreeOptions.SetItemEnable(m_htiQuickStartTimePerFile, bCheck); 
				m_ctrlTreeOptions.SetItemEnable(m_htiQuickMaxConperFive, bCheck); 
				m_ctrlTreeOptions.SetItemEnable(m_htiQuickMaxHalfOpen, bCheck); 
				m_ctrlTreeOptions.SetItemEnable(m_htiQuickMaxConnections, bCheck); 
			}else
			// NEO: QS END
			// NEO: UPNP - [UPnPNat]
			if (m_htiUPnPNat && pton->hItem == m_htiUPnPNat){
				m_ctrlTreeOptions.GetCheckBox(m_htiUPnPNat, bCheck);

				m_ctrlTreeOptions.SetItemEnable(m_htiUPnPClearOnClose,bCheck); 
				m_ctrlTreeOptions.SetItemEnable(m_htiUPnPTryRandom,bCheck); 
			}else
			// NEO: UPNP END
			// NEO: DKA - [DownloadKeepAlive]
			if (m_htiDownloadKeepAliveTimeout && pton->hItem == m_htiDownloadKeepAliveTimeout){
				m_ctrlTreeOptions.GetCheckBox(m_htiDownloadKeepAliveTimeout, bCheck);
				m_ctrlTreeOptions.SetItemEnable(m_htiDownloadKeepAliveTimeout, bCheck, TRUE, TRUE);
			}else
			// NEO: DKA END
			// NEO: TCR - [TCPConnectionRetry]
			if (m_htiTCPConnectionRetry && pton->hItem == m_htiTCPConnectionRetry){
				m_ctrlTreeOptions.GetCheckBox(m_htiTCPConnectionRetry, bCheck);
				m_ctrlTreeOptions.SetItemEnable(m_htiTCPConnectionRetry, bCheck, TRUE, TRUE);
			}
			// NEO: TCR END
			SetModified();
		}
	}
	return 0;
}

#ifdef NEO_BC // NEO: NBC - [NeoBandwidthControl]
void CPPgNetwork::CheckNAFCEnable()
{
	UINT bCheck1;
	m_ctrlTreeOptions.GetCheckBox(m_htiNAFCEnabled, bCheck1);
	m_ctrlTreeOptions.SetItemEnable(m_htiAdapterIP, bCheck1);

	UINT bCheck2;
	m_ctrlTreeOptions.GetCheckBox(m_htiAdapterIP, bCheck2);
	m_ctrlTreeOptions.SetItemEnable(m_htiBindToAdapter, (bCheck1 && bCheck2));
}
#endif // NEO_BC // NEO: NBC END

// NEO: NATS - [NatSupport]
void CPPgNetwork::CheckNATEnable()
{
	UINT bCheck;
	m_ctrlTreeOptions.GetCheckBox(m_htiNATSupportEnabled, bCheck);
	m_ctrlTreeOptions.SetGroupEnable(m_htiNATSupportEnabled, bCheck);

#ifdef NATTUNNELING // NEO: NATT - [NatTraversal]
	m_ctrlTreeOptions.GetCheckBox(m_htiNATTraversalEnabled, bCheck);
	m_ctrlTreeOptions.SetGroupEnable(m_htiNATTraversalEnabled, bCheck);
#endif //NATTUNNELING // NEO: NATT END
}
// NEO: NATS END

LRESULT CPPgNetwork::DrawTreeItemHelp(WPARAM wParam, LPARAM lParam)
{
	if(!IsWindowVisible())
		return 0;

	if (wParam == IDC_MOD_OPTS){
		CString* sInfo = (CString*)lParam;
		SetDlgItemText(IDC_MOD_OPTS_INFO, *sInfo);
	}
	return FALSE;
}

void CPPgNetwork::OnHelp()
{
	//theApp.ShowHelp(0);
}

BOOL CPPgNetwork::OnCommand(WPARAM wParam, LPARAM lParam)
{
	if (wParam == ID_HELP)
	{
		OnHelp();
		return TRUE;
	}
	return __super::OnCommand(wParam, lParam);
}

BOOL CPPgNetwork::OnHelpInfo(HELPINFO* /*pHelpInfo*/)
{
	OnHelp();
	return TRUE;
}
