//this file is part of NeoMule
//Copyright (C)2006 David Xanatos ( Xanatos@Lycos.at / http://neomule.sourceforge.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


#include "stdafx.h"
#include "emule.h"
#include "PPgInterface.h"
#include "Preferences.h"
#include "OtherFunctions.h"
#include "Neo/GUI/CP/TreeFunctions.h"
#include "emuledlg.h"
#include "MuleToolbarCtrl.h"
#include "Neo/Functions.h"
#ifdef IP2COUNTRY // NEO: IP2C - [IPtoCountry] -- Xanatos -->
#include "Neo\GUI\IP2Country.h"
#include "transferwnd.h"
#include "serverwnd.h"
#endif // IP2COUNTRY // NEO: IP2C END <-- Xanatos --
// NEO: FC - [FakeCheck]
#include "Neo/GUI/Fakecheck.h"
#include "searchdlg.h"
#include "searchresultswnd.h"
// NEO: FC - [FakeCheck]
#include "downloadqueue.h" // NEO: NTB - [NeoToolbarButtons]
#ifdef NEO_BC // NEO: NBC - [NeoBandwidthControl] -- Xanatos -->
#include "Neo/BandwidthControl/BandwidthControl.h"
#endif // NEO_BC // NEO: NBC END <-- Xanatos --
#include "Neo/Defaults.h"
#include "TransferWnd.h"
#include "emuledlg.h"
#include "SharedFilesWnd.h"
#include "Neo\GUI\toolbar\NeoToolBarCtrl.h" // NEO: CTB - [CoolToolBar] <-- Xanatos --
#include "Neo/GUI/Funnynick.h" // NEO: FN - [FunnyNick] <-- Xanatos --

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

// NEO: NTB - [NeoToolbarButtons]

class CNeoToolbarButton : public CTreeOptionsCombo
{
public:
	CNeoToolbarButton();
	virtual ~CNeoToolbarButton();

protected:
	//{{AFX_VIRTUAL(CNeoToolbarButton)
	//}}AFX_VIRTUAL

	//{{AFX_MSG(CNeoToolbarButton)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()

  DECLARE_DYNCREATE(CNeoToolbarButton)
};


IMPLEMENT_DYNCREATE(CNeoToolbarButton, CTreeOptionsCombo)

CNeoToolbarButton::CNeoToolbarButton()
{
}

CNeoToolbarButton::~CNeoToolbarButton()
{
}

BEGIN_MESSAGE_MAP(CNeoToolbarButton, CTreeOptionsCombo)
	//{{AFX_MSG_MAP(CNeoToolbarButton)
	ON_WM_CREATE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

CString GetNeoCmdWStr(uint8 uNeoCmdL, uint8 uNeoCmdW);
int CNeoToolbarButton::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CTreeOptionsCombo::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	switch((uint8)(m_pTreeCtrl->GetOpaque(m_hTreeCtrlItem,TRUE)))
	{
		case 0:
			AddString(GetResString(IDS_X_COLLECT_ALL_SOURCES));
			AddString(GetResString(IDS_X_COLLECT_XS_SOURCES));
			AddString(GetResString(IDS_X_COLLECT_SVR_SOURCES));
			AddString(GetResString(IDS_X_COLLECT_KAD_SOURCES));
			AddString(GetResString(IDS_X_COLLECT_UDP_SOURCES));
#ifdef VOODOO // NEO: VOODOOn - [VoodooExtensionForNeo]
			AddString(GetResString(IDS_X_COLLECT_VOODOO_SOURCES));
#endif // VOODOO // NEO: VOODOOn END
			AddString(GetResString(IDS_X_AHL_INCREASE));
			AddString(GetResString(IDS_X_AHL_DECREASE));
			break;
		case 1:
			AddString(GetResString(IDS_X_DROP_NNP));
			AddString(GetResString(IDS_X_DROP_FULLQ));
			AddString(GetResString(IDS_X_DROP_HIGHQ));
				// NEO: TCR - [TCPConnectionRetry]
			AddString(GetResString(IDS_X_DROP_WAITINGRETRY));
				// NEO: TCR END
				// NEO: XSC - [ExtremeSourceCache]
			AddString(GetResString(IDS_X_DROP_CACHED));
				// NEO: XSC END
#ifdef NEO_SS // NEO: NSS - [NeoSourceStorage]
			AddString(GetResString(IDS_X_DROP_OUTOFDATE));
			AddString(GetResString(IDS_X_DROP_LOADED));
			AddString(GetResString(IDS_X_DROP_LOADEDWAITING));
#ifdef NEO_SA // NEO: NSA - [NeoSourceAnaliser]
			AddString(GetResString(IDS_X_DROP_RESERVE));
#endif // NEO_SA // NEO: NSA END
			AddString(GetResString(IDS_X_DROP_RETIRED));
#endif // NEO_SS // NEO: NSS END
#ifdef NEO_SK // NEO: NSK - [NeoSourceKeeper]
			AddString(GetResString(IDS_X_DROP_UNREACHABLE));
#endif // NEO_SK // NEO: NSK END
			AddString(GetResString(IDS_X_DROP_TOMANY));
			AddString(GetResString(IDS_X_DROP_UNKNOWN));
			AddString(GetResString(IDS_X_DROP_BAD));
			AddString(GetResString(IDS_X_DROP_LOW2LOW));
			break;
		case 2:
			AddString(GetResString(IDS_X_REASK_FULLQ));
			AddString(GetResString(IDS_X_REASK_NNP));
			// NEO: TCR - [TCPConnectionRetry]
			AddString(GetResString(IDS_X_REASK_WAITINGRETRY));
			// NEO: TCR END
			// NEO: XSC - [ExtremeSourceCache]
			AddString(GetResString(IDS_X_REASK_CACHED));
			// NEO: XSC END
#ifdef NEO_SS // NEO: NSS - [NeoSourceStorage]
			AddString(GetResString(IDS_X_REASK_LOADEDGRPOUP));
			AddString(GetResString(IDS_X_REASK_LOADED));
			AddString(GetResString(IDS_X_REASK_LOADEDWAITING));
#ifdef NEO_SA // NEO: NSA - [NeoSourceAnaliser]
			AddString(GetResString(IDS_X_REASK_RESERVE));
#endif // NEO_SA // NEO: NSA END
#endif // NEO_SS // NEO: NSS END
#ifdef NEO_SK // NEO: NSK - [NeoSourceKeeper]
#endif // NEO_SK // NEO: NSK END
			break;
		case 3:
#ifdef NEO_SS // NEO: NSS - [NeoSourceStorage]
			AddString(GetResString(IDS_X_LOADSRCMANUALLY));
			AddString(GetResString(IDS_X_SAVESRCMANUALLY));
			AddString(GetResString(IDS_X_IMPORTSRCMANUALLY));
			AddString(GetResString(IDS_X_EXPORTSRCMANUALLY));
 #ifdef NEO_CD // NEO: NCD - [NeoClientDatabase] // NEO: SFL - [SourceFileList]
			AddString(GetResString(IDS_X_FINDSOURCES));
 #endif // NEO_CD // NEO: NCD END // NEO: SFL END
#endif // NEO_SS // NEO: NSS END
			break;
		case 4:
			// NEO: PP - [PasswordProtection]
			AddString(GetResString(IDS_X_PWPROT_SHOW));
			AddString(GetResString(IDS_X_PWPROT_HIDE));
			AddString(GetResString(IDS_X_PWPROT_SET));
			AddString(GetResString(IDS_X_PWPROT_CHANGE));
			AddString(GetResString(IDS_X_PWPROT_UNSET));
			// NEO: PP END
			// NEO: FCFG - [FileConfiguration]
			AddString(GetResString(IDS_DL_INFO));
			AddString(GetResString(IDS_X_FILE_TWEAKS));
			// NEO: FCFG END
#ifdef VOODOO // NEO: VOODOOn - [VoodooExtensionForNeo]
			AddString(GetResString(IDS_X_VOODOO_LIST));
#endif // VOODOO // NEO: VOODOOn END
			AddString(GetResString(IDS_X_SEP));
			break;
		default:
			ASSERT(0);
	}

	return 0;
}

CString GetNeoCmdLStr(uint8 uNeoCmdL);
void SetTreeNeoToolbarButton(CTreeOptionsCtrl &hCtrl, tNeoButton* hItem, HTREEITEM Parent, int i, int *iImgNeoBtn)
{
	SetTreeGroup(hCtrl,hItem->m_htiButton,StrLine(GetResString(IDS_X_NEO_BTN),i),iImgNeoBtn[i%8],Parent,_T(""));
	for (int j=0; j<ARRSIZE(hItem->m_htiGroups); j++)
	{
		uint8 uNeoCmdL = 0;
		switch(j)
		{
			case 0: uNeoCmdL = INST_COLLECT; break;
			case 1: uNeoCmdL = INST_DROP; break;
			case 2: uNeoCmdL = INST_REASK; break;
			case 3: uNeoCmdL = INST_STORAGE; break;
			case 4: uNeoCmdL = INST_OTHER; break;
			default:
				ASSERT(0);
		}
		SetTreeRadio(hCtrl,hItem->m_htiGroups[j],GetNeoCmdLStr(uNeoCmdL),hItem->m_htiButton,_T(""),TRUE,FALSE);
		hCtrl.AddComboBox(hItem->m_htiGroups[j],RUNTIME_CLASS(CNeoToolbarButton),0,(DWORD)j);
		//hCtrl.SetItemSize(hCtrl,hItem->m_htiGroups[j],10);
	}
}

void DeleteTreeNeoToolbarButton(CTreeOptionsCtrl &hCtrl, tNeoButton* hItem){
	for (int j=0; j<ARRSIZE(hItem->m_htiGroups); j++)
		hCtrl.DeleteItem(hItem->m_htiGroups[j]);
	hCtrl.DeleteItem(hItem->m_htiButton);
}

void DDX_TreeNeoToolbarButton(CTreeOptionsCtrl* hCtrl, CDataExchange* pDX, int /*nIDC*/, tNeoButton* hItem, UINT& nValue)
{
	if (pDX->m_bSaveAndValidate){
		int iNeoCmdL = 0;
		DDX_TreeRadio(pDX, IDC_MOD_OPTS, hItem->m_htiButton, iNeoCmdL);
		CString SNeoCmdW;
		if(iNeoCmdL != -1)
			SNeoCmdW = hCtrl->GetComboText(hItem->m_htiGroups[iNeoCmdL]);
		if(SNeoCmdW.IsEmpty())
			iNeoCmdL = -1;

		uint8 uNeoCmdL = 0;
		uint8 uNeoCmdW = 0;
		switch(iNeoCmdL){
			case -1: 
				uNeoCmdL = 0; 
				uNeoCmdW = 0;
				break;
			case 0: uNeoCmdL = INST_COLLECT; 
				for(uint8 j = 0xA1; j <= 0xAB; j++){
					if(SNeoCmdW == GetNeoCmdWStr(uNeoCmdL,j)){
						uNeoCmdW = j;
						break;
					}
				}
				break;
			case 1: uNeoCmdL = INST_DROP; 
				for(uint8 j = 0xB1; j <= 0xBF; j++){
					if(SNeoCmdW == GetNeoCmdWStr(uNeoCmdL,j)){
						uNeoCmdW = j;
						break;
					}
				}
				break;
			case 2: uNeoCmdL = INST_REASK; 
				for(uint8 j = 0xC1; j <= 0xCB; j++){
					if(SNeoCmdW == GetNeoCmdWStr(uNeoCmdL,j)){
						uNeoCmdW = j;
						break;
					}
				}
				break;
			case 3: uNeoCmdL = INST_STORAGE; 
				for(uint8 j = 0xD1; j <= 0xD5; j++){
					if(SNeoCmdW == GetNeoCmdWStr(uNeoCmdL,j)){
						uNeoCmdW = j;
						break;
					}
				}
				break;
			case 4: uNeoCmdL = INST_OTHER; 
				for(uint8 j = 0xE1; j <= 0xE8; j++){
					if(SNeoCmdW == GetNeoCmdWStr(uNeoCmdL,j)){
						uNeoCmdW = j;
						break;
					}
				}
				if(SNeoCmdW == GetNeoCmdWStr(uNeoCmdL,INST_SEP))
					uNeoCmdW = INST_SEP;
				break;
			default:
				ASSERT(0);
		}

		if(uNeoCmdL != 0 && uNeoCmdW != 0)
		{
			nValue = uNeoCmdL;
			nValue |= uNeoCmdW << 16;
		}else
			nValue = 0;
	}
	else
	{
		uint8 uNeoCmdL = (uint8)(nValue);
		uint8 uNeoCmdW = (uint8)(nValue >> 16);

		int iNeoCmdL = -1;
		switch(uNeoCmdL)
		{
			case 0: iNeoCmdL = -1; break;
			case INST_COLLECT: iNeoCmdL = 0; break;
			case INST_DROP: iNeoCmdL = 1; break;
			case INST_REASK: iNeoCmdL = 2; break;
			case INST_STORAGE: iNeoCmdL = 3; break;
			case INST_OTHER: iNeoCmdL = 4; break;
			default:
				ASSERT(0);
		}
		DDX_TreeRadio(pDX, IDC_MOD_OPTS, hItem->m_htiButton, iNeoCmdL);

		CString SNeoCmdW = _T("");
		for(uint8 j=0; j<ARRSIZE(hItem->m_htiGroups); j++)
			hCtrl->SetComboText(hItem->m_htiGroups[j], SNeoCmdW);
		SNeoCmdW = GetNeoCmdWStr(uNeoCmdL,uNeoCmdW); 
		if(iNeoCmdL != -1)
			hCtrl->SetComboText(hItem->m_htiGroups[iNeoCmdL], SNeoCmdW);
	}
}
// NEO: NTB END


// NEO: CTB - [CoolToolBar]
class CCoolToolbarButton : public CTreeOptionsCombo
{
public:
	CCoolToolbarButton();
	virtual ~CCoolToolbarButton();

protected:
	DWORD GetWindowStyle();
	//{{AFX_VIRTUAL(CCoolToolbarButton)
	//}}AFX_VIRTUAL

	//{{AFX_MSG(CCoolToolbarButton)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()

  DECLARE_DYNCREATE(CCoolToolbarButton)
};


IMPLEMENT_DYNCREATE(CCoolToolbarButton, CTreeOptionsCombo)

CCoolToolbarButton::CCoolToolbarButton()
{
}

CCoolToolbarButton::~CCoolToolbarButton()
{
}

BEGIN_MESSAGE_MAP(CCoolToolbarButton, CTreeOptionsCombo)
	//{{AFX_MSG_MAP(CCoolToolbarButton)
	ON_WM_CREATE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

DWORD CCoolToolbarButton::GetWindowStyle()
{
	return WS_CHILD | WS_VISIBLE | WS_VSCROLL | CBS_DROPDOWN;
}

int CCoolToolbarButton::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CTreeOptionsCombo::OnCreate(lpCreateStruct) == -1)
		return -1;
	
  //Add strings to the combo
	AddString(GetResString(IDS_MAIN_BTN_CONNECT));
	AddString(GetResString(IDS_EM_KADEMLIA));
	AddString(GetResString(IDS_EM_SERVER));
	AddString(GetResString(IDS_EM_TRANS));
	AddString(GetResString(IDS_EM_SEARCH));
	AddString(GetResString(IDS_X_EM_SHARE));
	AddString(GetResString(IDS_EM_MESSAGES));
	AddString(GetResString(IDS_IRC));
	AddString(GetResString(IDS_EM_STATISTIC));
	AddString(GetResString(IDS_EM_PREFS));
	AddString(GetResString(IDS_TOOLS));
	AddString(GetResString(IDS_EM_HELP));
#ifdef VOODOO // NEO: VOODOO - [UniversalPartfileInterface]
	AddString(GetResString(IDS_X_EM_VOODOO));
#endif // VOODOO // NEO: VOODOO END

	return 0;
}

void DDX_TreeCoolToolbarButton(CTreeOptionsCtrl* hCtrl, CDataExchange* pDX, int /*nIDC*/, HTREEITEM hItem, UINT& nValue)
{
	if (pDX->m_bSaveAndValidate){
		CString sText;
		sText = hCtrl->GetComboText(hItem);
		if(sText == GetResString(IDS_MAIN_BTN_CONNECT))
			nValue = 0;
		else if(sText == GetResString(IDS_EM_KADEMLIA))
			nValue = 1;
		else if(sText == GetResString(IDS_EM_SERVER))
			nValue = 2;
		else if(sText == GetResString(IDS_EM_TRANS))
			nValue = 3;
		else if(sText == GetResString(IDS_EM_SEARCH))
			nValue = 4;
		else if(sText == GetResString(IDS_X_EM_SHARE))
			nValue = 5;
		else if(sText == GetResString(IDS_EM_MESSAGES))
			nValue = 6;
		else if(sText == GetResString(IDS_IRC))
			nValue = 7;
		else if(sText == GetResString(IDS_EM_STATISTIC))
			nValue = 8;
		else if(sText == GetResString(IDS_EM_PREFS))
			nValue = 9;
		else if(sText == GetResString(IDS_TOOLS))
			nValue = 10;
		else if(sText == GetResString(IDS_EM_HELP))
			nValue = 11;
#ifdef VOODOO // NEO: VOODOO - [UniversalPartfileInterface]
		else if(sText == GetResString(IDS_X_EM_VOODOO))
			nValue = 12;
#endif // VOODOO // NEO: VOODOO END
		else
			nValue = _tstol(sText) << 8;
	}else{
		CString sText;
		switch(nValue){
		case 0: sText = GetResString(IDS_MAIN_BTN_CONNECT); break;
		case 1: sText = GetResString(IDS_EM_KADEMLIA); break;
		case 2: sText = GetResString(IDS_EM_SERVER); break;
		case 3: sText = GetResString(IDS_EM_TRANS); break;
		case 4: sText = GetResString(IDS_EM_SEARCH); break;
		case 5: sText = GetResString(IDS_X_EM_SHARE); break;
		case 6: sText = GetResString(IDS_EM_MESSAGES); break;
		case 7: sText = GetResString(IDS_IRC); break;
		case 8: sText = GetResString(IDS_EM_STATISTIC); break;
		case 9: sText = GetResString(IDS_EM_PREFS); break;
		case 10: sText = GetResString(IDS_TOOLS); break;
		case 11: sText = GetResString(IDS_EM_HELP); break;
#ifdef VOODOO // NEO: VOODOO - [UniversalPartfileInterface]
		case 12: sText = GetResString(IDS_X_EM_VOODOO); break;
#endif // VOODOO // NEO: VOODOO END
		default:
			sText.Format(_T("%i"),(uint8)(nValue >> 8));
		}
		hCtrl->SetComboText(hItem, sText);
	}
}
// NEO: CTB END

// NEO: MM - [NeoMiniMule]
class CTreeOptionsSpinCtrl255 : public CTreeOptionsSpinCtrl
{
public:
	CTreeOptionsSpinCtrl255();
	virtual ~CTreeOptionsSpinCtrl255();

protected:
	virtual void GetDefaultRange(int &lower, int& upper);

	//{{AFX_VIRTUAL(CTreeOptionsSpinCtrl255)
	//}}AFX_VIRTUAL

	//{{AFX_MSG(CTreeOptionsSpinCtrl255)
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()

  DECLARE_DYNCREATE(CTreeOptionsSpinCtrl255)
};

IMPLEMENT_DYNCREATE(CTreeOptionsSpinCtrl255, CTreeOptionsSpinCtrl)

CTreeOptionsSpinCtrl255::CTreeOptionsSpinCtrl255()
{
}

CTreeOptionsSpinCtrl255::~CTreeOptionsSpinCtrl255()
{
}

BEGIN_MESSAGE_MAP(CTreeOptionsSpinCtrl255, CTreeOptionsSpinCtrl)
	//{{AFX_MSG_MAP(CTreeOptionsSpinCtrl255)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

void CTreeOptionsSpinCtrl255::GetDefaultRange(int &lower, int& upper)
{
	lower = 0;
	upper = 255;
}
// NEO: MM END

// NEO: IM - [InvisibelMode]
class CInvisibelModeHotKeyModifier : public CTreeOptionsCombo
{
public:
	CInvisibelModeHotKeyModifier();
	virtual ~CInvisibelModeHotKeyModifier();

protected:
	//{{AFX_VIRTUAL(CInvisibelModeHotKeyModifier)
	//}}AFX_VIRTUAL

	//{{AFX_MSG(CInvisibelModeHotKeyModifier)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()

  DECLARE_DYNCREATE(CInvisibelModeHotKeyModifier)
};


IMPLEMENT_DYNCREATE(CInvisibelModeHotKeyModifier, CTreeOptionsCombo)

CInvisibelModeHotKeyModifier::CInvisibelModeHotKeyModifier()
{
}

CInvisibelModeHotKeyModifier::~CInvisibelModeHotKeyModifier()
{
}

BEGIN_MESSAGE_MAP(CInvisibelModeHotKeyModifier, CTreeOptionsCombo)
	//{{AFX_MSG_MAP(CInvisibelModeHotKeyModifier)
	ON_WM_CREATE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


int CInvisibelModeHotKeyModifier::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CTreeOptionsCombo::OnCreate(lpCreateStruct) == -1)
		return -1;
	
  //Add strings to the combo
	AddString(GetResString(IDS_X_CTRLKEY));
	AddString(GetResString(IDS_X_ALTKEY));
	AddString(GetResString(IDS_X_SHIFTKEY));
	AddString(GetResString(IDS_X_CTRLKEY) + _T(" + ") + GetResString(IDS_X_ALTKEY));
	AddString(GetResString(IDS_X_CTRLKEY) + _T(" + ") + GetResString(IDS_X_SHIFTKEY));
	AddString(GetResString(IDS_X_ALTKEY) + _T(" + ") + GetResString(IDS_X_SHIFTKEY));
	AddString(GetResString(IDS_X_CTRLKEY) + _T(" + ") + GetResString(IDS_X_ALTKEY) + _T(" + ") + GetResString(IDS_X_SHIFTKEY));

	return 0;
}


class CInvisibelModeHotKey : public CTreeOptionsCombo
{
public:
	CInvisibelModeHotKey();
	virtual ~CInvisibelModeHotKey();

protected:
	//{{AFX_VIRTUAL(CInvisibelModeHotKey)
	//}}AFX_VIRTUAL

	//{{AFX_MSG(CInvisibelModeHotKey)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()

  DECLARE_DYNCREATE(CInvisibelModeHotKey)
};


IMPLEMENT_DYNCREATE(CInvisibelModeHotKey, CTreeOptionsCombo)

CInvisibelModeHotKey::CInvisibelModeHotKey()
{
}

CInvisibelModeHotKey::~CInvisibelModeHotKey()
{
}

BEGIN_MESSAGE_MAP(CInvisibelModeHotKey, CTreeOptionsCombo)
	//{{AFX_MSG_MAP(CInvisibelModeHotKey)
	ON_WM_CREATE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


int CInvisibelModeHotKey::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CTreeOptionsCombo::OnCreate(lpCreateStruct) == -1)
		return -1;
	
  //Add strings to the combo
	for(int i='A'; i<='Z'; i++)
		AddString(CString((char)(i)));
	for(int i='0'; i<='9'; i++)
		AddString(CString((char)(i)));
	
	return 0;
}
// NEO: IM END

///////////////////////////////////////////////////////////////////////////////
// CPPgInterface dialog

IMPLEMENT_DYNAMIC(CPPgInterface, CPropertyPage)

BEGIN_MESSAGE_MAP(CPPgInterface, CPropertyPage)
	ON_WM_DESTROY()
	ON_MESSAGE(WM_TREEOPTSCTRL_NOTIFY, OnTreeOptsCtrlNotify)
	ON_MESSAGE(WM_TREEITEM_HELP, DrawTreeItemHelp)
	ON_WM_HELPINFO()
END_MESSAGE_MAP()

CPPgInterface::CPPgInterface()
	: CPropertyPage(CPPgInterface::IDD)
	, m_ctrlTreeOptions(theApp.m_iDfltImageListColorFlags)
{
	// NEO: NTB - [NeoToolbarButtons]
	m_htiNeoToolbarButtons = NULL;
	m_cntNeoToolbarButtons = 0;
	// NEO: NTB END
	// NEO: CTB - [CoolToolBar]
	m_htiCoolToolbarButtons = NULL;
	m_cntCoolToolbarButtons = 0;
	// NEO: CTB END
	ClearAllMembers();
	m_ctrlTreeOptions.SetNeoStyle();
}

CPPgInterface::~CPPgInterface()
{
	ClearNeoToolbarMembers(); // NEO: NTB - [NeoToolbarButtons]
}

void CPPgInterface::ClearAllMembers()
{
	m_bInitializedTreeOpts = false;

	m_htiInterface = NULL;
#ifdef A4AF_CATS // NEO: MAC - [MorphA4AFCategories]
		m_htiMorphCats = NULL;
			m_htiShowCatNames = NULL;
			m_htiShowCategoryFlags = NULL;
			m_htiActiveCatDefault = NULL;
			m_htiSelCatOnAdd = NULL;
			m_htiAutoSetResumeOrder = NULL;
			m_htiSmallFileDLPush = NULL;
			m_htiStartDLInEmptyCats = NULL;
			m_htiUseAutoCat = NULL;
#endif // A4AF_CATS // NEO: MAC END
		m_htiUseChunkDots = NULL; // NEO: MOD - [ChunkDots]
		m_htiUseRelativeChunkDisplay = NULL; // NEO: MOD - [RelativeChunkDisplay]
		m_htiUseTreeStyle = NULL; // NEO: NTS - [NeoTreeStyle]
		m_htiClassicShareStatusBar = NULL;
		m_htiShowFileTypeIcon = NULL; // NEO: NI - [NewIcons]
		m_htiShowFileStatusIcons = NULL; // NEO: FSI - [FileStatusIcons]
		m_htiCollorShareFiles = NULL;
		m_htiCheckAlreadyDownloaded = NULL;
		m_htiStartNextFileByPriority = NULL;
#ifdef IP2COUNTRY // NEO: IP2C - [IP2Country]
		m_htiIP2Country = NULL;
			m_htiIP2CountryNameDisable = NULL; 
			m_htiIP2CountryNameShort = NULL; 
			m_htiIP2CountryNameMidle = NULL; 
			m_htiIP2CountryNameLong = NULL; 
			m_htiIP2CountryShowFlag = NULL; 
#endif // IP2COUNTRY // NEO: IP2C END
		m_htiUseFakeCheck = NULL; // NEO: FC - [FakeCheck]
		// NEO: FDC - [FileNameDisparityCheck]
		m_htiUseFileCheck = NULL; 
			m_htiFileCheckSensitivity = NULL; 
			m_htiFileCheckThreshold = NULL; 
			m_htiFileCheckAmount = NULL; 
		// NEO: FDC END
		// NEO: FN - [FunnyNick]
		m_htiUseFunnyNick = NULL;
			m_htiFunnyNickFilter = NULL;
			m_htiFunnyNickSymbol = NULL;
		// NEO: FN END
		m_htiShowBanner = NULL;
		m_htiShowHashProgres = NULL;
		m_htiUsePlusSpeedMeter = NULL; // NEO: PSM - [PlusSpeedMeter]
		// NEO: NSTI - [NewSystemTrayIcon]
		m_htiNewSystemTrayIcon = NULL;
			m_htiShowSystemTrayUpload = NULL;
			m_htiThinSystemTrayBars = NULL;
			m_htiTrayBarsMaxCollor = NULL;
		// NEO: NSTI END
		m_htiStaticTrayIcon = NULL; // NEO: STI - [StaticTray]
		m_htiDisableAutoSort = NULL; // NEO: SE - [SortExtension]
		m_htiShowClientPercentage = NULL; // NEO: MOD - [Percentage]
		// NEO: SI - [SysInfo]
		m_htiDrawSysInfoGraph = NULL;
		m_htiShowSysInfoOnTitle = NULL;
		// NEO: SI END	
		m_htiShowMyFullInfo = NULL;
		// NEO: NTB - [NeoToolbarButtons]
		m_htiNeoToolbar = NULL;
			ClearNeoToolbarMembers();
		// NEO: NTB END
		// NEO: CTB - [CoolToolBar]
		m_htiCoolToolbar = NULL;
			m_htiCoolToolbarText = NULL;
			m_htiCoolToolbarCenter = NULL;
			m_htiCoolToolbarRight = NULL;
			m_htiCoolToolbarButtonCount = NULL;
			delete [] m_htiCoolToolbarButtons;
			m_htiCoolToolbarButtons = NULL;
			m_cntCoolToolbarButtons = 0;
		// NEO: CTB END
		// NEO: NMX - [NeoMenuXP]
		m_htiXPMenuStyle = NULL;
			m_htiXPMenuStyleOffice = NULL;
			m_htiXPMenuStyleStartMenu = NULL;
			m_htiXPMenuStyleXP = NULL;
			m_htiShowXPSideBar = NULL;
			m_htiShowXPBitmap = NULL;
			m_htiGrayMenuIcon = NULL;
		// NEO: NMX END
		// NEO: MM - [NeoMiniMule]
		m_htiMiniMule = NULL;
			m_htiAutoShowMiniMule = NULL;
			m_htiMiniMuleOnTop = NULL;
			m_htiUpdateHidenMiniMule = NULL;
			m_htiMiniMuleTransparency = NULL;
			m_htiMiniMuleBack = NULL;
			m_htiMiniMuleLabel = NULL;
		// NEO: MM END
		// NEO: IM - [InvisibelMode]
		m_htiInvisibelMode = NULL;
			m_htiInvisibelModeHotKeyModifier = NULL;
			m_htiInvisibelModeHotKey = NULL;
		// NEO: IM END
		m_htiSmoothStatisticsGraphs = NULL;
		m_htiTrayPasswordProtection = NULL; // NEO: TPP - [TrayPasswordProtection]
}

// NEO: NTB - [NeoToolbarButtons]
void CPPgInterface::ClearNeoToolbarMembers(bool bTree)
{
	if(m_htiNeoToolbarButtons){
		if(bTree){
			for (int i=0; i<m_cntNeoToolbarButtons; i++)
				DeleteTreeNeoToolbarButton(m_ctrlTreeOptions,&(m_htiNeoToolbarButtons[i]));
		}
		delete [] m_htiNeoToolbarButtons;
		m_htiNeoToolbarButtons = NULL;
		m_cntNeoToolbarButtons = 0;
	}
}

void CPPgInterface::CreateNeoToolbarMembers(int *iImgNeoBtn)
{
	ASSERT(m_htiNeoToolbarButtons == NULL);
	m_cntNeoToolbarButtons = m_iNeoToolbarButtonCount;
	m_htiNeoToolbarButtons = new tNeoButton[m_cntNeoToolbarButtons];
	for (int i=0; i<m_cntNeoToolbarButtons; i++)
		SetTreeNeoToolbarButton(m_ctrlTreeOptions,&(m_htiNeoToolbarButtons[i]),m_htiNeoToolbar,i,iImgNeoBtn);
}
// NEO: NTB END

void ReloadFakeList(){
	theApp.FakeCheck->LoadFromFile();
}

// NEO: FN - [FunnyNick]
void ReloadFunnyNick(){
	theApp.funnynick->ReloadDatabase();
}
// NEO: FN END

void CPPgInterface::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_MOD_OPTS, m_ctrlTreeOptions);

	static int iImgNeoBtn[8] = {8,8,8,8,8,8,8,8}; // NEO: NTB - [NeoToolbarButtons]
	if (!m_bInitializedTreeOpts)
	{
		int iImgInterface = 8;
#ifdef A4AF_CATS // NEO: MAC - [MorphA4AFCategories]
		int iImgCat = 8;
#endif // A4AF_CATS // NEO: MAC END
		int iImgSysTray = 8; // NEO: NSTI - [NewSystemTrayIcon]
#ifdef IP2COUNTRY // NEO: IP2C - [IP2Country]
		int iImgIP2C = 8;
#endif // IP2COUNTRY // NEO: IP2C END
		int iImgXP = 0; // NEO: NMX - [NeoMenuXP]
		//int iImgNeoBtn[8] = {8,8,8,8,8,8,8,8}; // NEO: NTB - [NeoToolbarButtons]

        CImageList* piml = m_ctrlTreeOptions.GetImageList(TVSIL_NORMAL);
		if (piml){
			iImgInterface = piml->Add(CTempIconLoader(_T("INTERFACE")));
#ifdef A4AF_CATS // NEO: MAC - [MorphA4AFCategories]
			iImgCat = piml->Add(CTempIconLoader(_T("CATEGORY")));
#endif // A4AF_CATS // NEO: MAC END
			iImgSysTray = piml->Add(CTempIconLoader(_T("NTI"))); // NEO: NSTI - [NewSystemTrayIcon]
#ifdef IP2COUNTRY // NEO: IP2C - [IP2Country]
			iImgIP2C = piml->Add(CTempIconLoader(_T("SEARCHMETHOD_GLOBAL")));
#endif // IP2COUNTRY // NEO: IP2C END
			iImgXP = piml->Add(CTempIconLoader(_T("MenuXP"))); // NEO: NMX - [NeoMenuXP]
			// NEO: NTB - [NeoToolbarButtons]
			iImgNeoBtn[0] = piml->Add(CTempIconLoader(_T("NEO_BTN_BLUE")));
			iImgNeoBtn[1] = piml->Add(CTempIconLoader(_T("NEO_BTN_CYNA")));
			iImgNeoBtn[2] = piml->Add(CTempIconLoader(_T("NEO_BTN_GREEN")));
			iImgNeoBtn[3] = piml->Add(CTempIconLoader(_T("NEO_BTN_OLIVE")));
			iImgNeoBtn[4] = piml->Add(CTempIconLoader(_T("NEO_BTN_MAGENTA")));
			iImgNeoBtn[5] = piml->Add(CTempIconLoader(_T("NEO_BTN_RED")));
			iImgNeoBtn[6] = piml->Add(CTempIconLoader(_T("NEO_BTN_YELOW")));
			iImgNeoBtn[7] = piml->Add(CTempIconLoader(_T("NEO_BTN_ORANGE")));
			// NEO: NTB END
		}

		SetTreeGroup(m_ctrlTreeOptions,m_htiInterface,GetResString(IDS_X_GUI),iImgInterface, TVI_ROOT, GetResString(IDS_X_GUI_INFO));
#ifdef A4AF_CATS // NEO: MAC - [MorphA4AFCategories]
			SetTreeGroup(m_ctrlTreeOptions,m_htiMorphCats,GetResString(IDS_X_MORPH_CATS),iImgCat, m_htiInterface, GetResString(IDS_X_MORPH_CATS_INFO));
				SetTreeCheck(m_ctrlTreeOptions,m_htiShowCatNames,GetResString(IDS_X_SHOW_CAT_NAMES),m_htiMorphCats,GetResString(IDS_X_SHOW_CAT_NAMES_INFO),FALSE,m_bShowCatNames);
				SetTreeCheck(m_ctrlTreeOptions,m_htiShowCategoryFlags,GetResString(IDS_X_SHOW_CAT_FLAGS),m_htiMorphCats,GetResString(IDS_X_SHOW_CAT_FLAGS_INFO),TRUE,m_uShowCategoryFlags);
				SetTreeCheck(m_ctrlTreeOptions,m_htiSelCatOnAdd,GetResString(IDS_X_SEL_CAT_ON_ADD),m_htiMorphCats,GetResString(IDS_X_SEL_CAT_ON_ADD_INFO),FALSE,m_bSelCatOnAdd);
				SetTreeCheck(m_ctrlTreeOptions,m_htiActiveCatDefault,GetResString(IDS_X_ACTIVE_CAT_DEFAULT),m_htiMorphCats,GetResString(IDS_X_ACTIVE_CAT_DEFAULT_INFO),FALSE,m_bActiveCatDefault);
				SetTreeCheck(m_ctrlTreeOptions,m_htiUseAutoCat,GetResString(IDS_X_USE_AUTO_CAT),m_htiMorphCats,GetResString(IDS_X_USE_AUTO_CAT_INFO),FALSE,m_bUseAutoCat);
				SetTreeCheck(m_ctrlTreeOptions,m_htiCheckAlreadyDownloaded,GetResString(IDS_X_CHECK_ALREADY_DOWNLOADED),m_htiMorphCats,GetResString(IDS_X_CHECK_ALREADY_DOWNLOADED_INFO),FALSE,m_bCheckAlreadyDownloaded);
				SetTreeCheck(m_ctrlTreeOptions,m_htiStartNextFileByPriority,GetResString(IDS_X_START_NEXT_FILE_BY_PRIORITY),m_htiMorphCats,GetResString(IDS_X_START_NEXT_FILE_BY_PRIORITY_INFO),FALSE,m_bStartNextFileByPriority);
				SetTreeCheck(m_ctrlTreeOptions,m_htiAutoSetResumeOrder,GetResString(IDS_X_AUTO_SET_RESUME_ORDER),m_htiMorphCats,GetResString(IDS_X_AUTO_SET_RESUME_ORDER_INFO),FALSE,m_bAutoSetResumeOrder);
				SetTreeCheckNumEdit(m_ctrlTreeOptions,m_htiSmallFileDLPush,GetResString(IDS_X_SMALL_FILE_DL_PUSH),m_htiMorphCats,GetResString(IDS_X_SMALL_FILE_DL_PUSH_INFO),FALSE,m_bSmallFileDLPush);
				SetTreeCheckNumEdit(m_ctrlTreeOptions,m_htiStartDLInEmptyCats,GetResString(IDS_X_START_DL_IN_EMPTY_CATS),m_htiMorphCats,GetResString(IDS_X_START_DL_IN_EMPTY_CATS_INFO),FALSE,m_bStartDLInEmptyCats);
#endif // A4AF_CATS // NEO: MAC END
			SetTreeCheck(m_ctrlTreeOptions,m_htiUseChunkDots,GetResString(IDS_X_USE_DOTS),m_htiInterface,GetResString(IDS_X_USE_DOTS_INFO),FALSE,m_bUseChunkDots); // NEO: MOD - [ChunkDots]
			SetTreeCheck(m_ctrlTreeOptions,m_htiUseRelativeChunkDisplay,GetResString(IDS_X_USE_RCD),m_htiInterface,GetResString(IDS_X_USE_RCD_INFO),FALSE,m_bUseRelativeChunkDisplay); // NEO: MOD - [RelativeChunkDisplay]
			SetTreeCheck(m_ctrlTreeOptions,m_htiUseTreeStyle,GetResString(IDS_X_USE_TREE),m_htiInterface,GetResString(IDS_X_USE_TREE_INFO),FALSE,m_bUseTreeStyle); // NEO: NTS - [NeoTreeStyle]
			SetTreeCheck(m_ctrlTreeOptions,m_htiClassicShareStatusBar,GetResString(IDS_X_CLASSIC_SHARED_BARS),m_htiInterface,GetResString(IDS_X_CLASSIC_SHARED_BARS_INFO),FALSE,m_bClassicShareStatusBar); 
			SetTreeCheck(m_ctrlTreeOptions,m_htiShowFileTypeIcon,GetResString(IDS_X_SHOW_FTI),m_htiInterface,GetResString(IDS_X_SHOW_FTI_INFO),FALSE,m_bShowFileTypeIcon); // NEO: NI - [NewIcons]
			SetTreeCheck(m_ctrlTreeOptions,m_htiShowFileStatusIcons,GetResString(IDS_X_SHOW_FSI),m_htiInterface,GetResString(IDS_X_SHOW_FSI_INFO),FALSE,m_bShowFileStatusIcons); // NEO: FSI - [FileStatusIcons]
			SetTreeCheck(m_ctrlTreeOptions,m_htiCollorShareFiles,GetResString(IDS_X_COLLOR_SHARE_FILES),m_htiInterface,GetResString(IDS_X_COLLOR_SHARE_FILES_INFO),FALSE,m_bCollorShareFiles);
#ifdef IP2COUNTRY // NEO: IP2C - [IP2Country]
			SetTreeGroup(m_ctrlTreeOptions,m_htiIP2Country,GetResString(IDS_X_IP2COUNTRY_MAIN),iImgIP2C, m_htiInterface, GetResString(IDS_X_IP2COUNTRY_MAIN_INFO));
				SetTreeRadio(m_ctrlTreeOptions,m_htiIP2CountryNameDisable,GetResString(IDS_X_IP2COUNTRY_DISABLED),m_htiIP2Country,GetResString(IDS_X_IP2COUNTRY_DISABLED_INFO),FALSE,m_iIP2CountryNameMode == IP2CountryName_DISABLE);
				SetTreeRadio(m_ctrlTreeOptions,m_htiIP2CountryNameShort,GetResString(IDS_X_IP2COUNTRY_SHORT),m_htiIP2Country,GetResString(IDS_X_IP2COUNTRY_SHORT_INFO),FALSE,m_iIP2CountryNameMode == IP2CountryName_SHORT);
				SetTreeRadio(m_ctrlTreeOptions,m_htiIP2CountryNameMidle,GetResString(IDS_X_IP2COUNTRY_MIDLE),m_htiIP2Country,GetResString(IDS_X_IP2COUNTRY_MIDLE_INFO),FALSE,m_iIP2CountryNameMode == IP2CountryName_MID);
				SetTreeRadio(m_ctrlTreeOptions,m_htiIP2CountryNameLong,GetResString(IDS_X_IP2COUNTRY_LONG),m_htiIP2Country,GetResString(IDS_X_IP2COUNTRY_LONG_INFO),FALSE,m_iIP2CountryNameMode == IP2CountryName_LONG);
				SetTreeCheck(m_ctrlTreeOptions,m_htiIP2CountryShowFlag,GetResString(IDS_X_IP2COUNTRY_FLAGS),m_htiIP2Country,GetResString(IDS_X_IP2COUNTRY_FLAGS_INFO),TRUE,m_uIP2CountryShowFlag);
#endif // IP2COUNTRY // NEO: IP2C END
			// NEO: FC - [FakeCheck]
			SetTreeCheck(m_ctrlTreeOptions,m_htiUseFakeCheck,GetResString(IDS_X_USE_FAKE_CHECK),m_htiInterface,GetResString(IDS_X_USE_FAKE_CHECK_INFO),FALSE,m_bUseFakeCheck);
			m_ctrlTreeOptions.AddButton(m_htiUseFakeCheck,RUNTIME_CLASS(CTreeOptionsButton),&ReloadFakeList);
			// NEO: FC END
			// NEO: FDC - [FileNameDisparityCheck]
			SetTreeCheck(m_ctrlTreeOptions,m_htiUseFileCheck,GetResString(IDS_X_USE_FILE_CHECK),m_htiInterface,GetResString(IDS_X_USE_FILE_CHECK_INFO),FALSE,m_bUseFileCheck);
				SetTreeEdit(m_ctrlTreeOptions,m_htiFileCheckSensitivity,GetResString(IDS_X_FILE_CHECK_SENSITIVITY), m_htiUseFileCheck,GetResString(IDS_X_FILE_CHECK_SENSITIVITY_INFO));
				SetTreeCheckNumEdit(m_ctrlTreeOptions,m_htiFileCheckThreshold,GetResString(IDS_X_FILE_CHECK_THRESHOLD), m_htiUseFileCheck,GetResString(IDS_X_FILE_CHECK_THRESHOLD_INFO),FALSE,m_bUseFileCheckThreshold);
				SetTreeEdit(m_ctrlTreeOptions,m_htiFileCheckAmount,GetResString(IDS_X_FILE_CHECK_AMOUNT), m_htiUseFileCheck,GetResString(IDS_X_FILE_CHECK_AMOUNT_INFO));
			// NEO: FDC END
			// NEO: FN - [FunnyNick]
			SetTreeCheck(m_ctrlTreeOptions,m_htiUseFunnyNick,GetResString(IDS_X_USE_FUNNY_NICK),m_htiInterface,GetResString(IDS_X_USE_FUNNY_NICK_INFO),FALSE,m_bUseFunnyNick);
			m_ctrlTreeOptions.AddButton(m_htiUseFunnyNick,RUNTIME_CLASS(CTreeOptionsButton),&ReloadFunnyNick);
				SetTreeEdit(m_ctrlTreeOptions,m_htiFunnyNickFilter,GetResString(IDS_X_FUNNY_NICK_FILTER), m_htiUseFunnyNick,GetResString(IDS_X_FUNNY_NICK_FILTER_INFO));
				SetTreeEdit(m_ctrlTreeOptions,m_htiFunnyNickSymbol,GetResString(IDS_X_FUNNY_NICK_SYMBOL), m_htiUseFunnyNick,GetResString(IDS_X_FUNNY_NICK_SYMBOL_INFO));
			// NEO: FN END
			SetTreeCheck(m_ctrlTreeOptions,m_htiShowBanner,GetResString(IDS_X_SHOW_BANNER),m_htiInterface,GetResString(IDS_X_SHOW_BANNER_INFO),FALSE,m_bShowBanner);
			SetTreeCheck(m_ctrlTreeOptions,m_htiShowHashProgres,GetResString(IDS_X_HASH_PROGRES),m_htiInterface,GetResString(IDS_X_HASH_PROGRES_INFO),FALSE,m_bShowHashProgres);
			SetTreeCheck(m_ctrlTreeOptions,m_htiUsePlusSpeedMeter,GetResString(IDS_X_PLUS_METER),m_htiInterface,GetResString(IDS_X_PLUS_METER_INFO),TRUE,m_uUsePlusSpeedMeter); // NEO: PSM - [PlusSpeedMeter]
			// NEO: NSTI - [NewSystemTrayIcon]
			SetTreeGroup(m_ctrlTreeOptions,m_htiNewSystemTrayIcon,GetResString(IDS_X_NSTI),iImgSysTray, m_htiInterface, GetResString(IDS_X_NSTI_INFO));
				SetTreeCheck(m_ctrlTreeOptions,m_htiShowSystemTrayUpload,GetResString(IDS_X_NSTI_UL),m_htiNewSystemTrayIcon,GetResString(IDS_X_NSTI_UL_INFO),FALSE,m_bShowSystemTrayUpload);
				SetTreeCheck(m_ctrlTreeOptions,m_htiThinSystemTrayBars,GetResString(IDS_X_NSTI_UL_THIN),m_htiNewSystemTrayIcon,GetResString(IDS_X_NSTI_UL_THIN_INFO),FALSE,m_bThinSystemTrayBars);
				SetTreeNumEdit(m_ctrlTreeOptions,m_htiTrayBarsMaxCollor,GetResString(IDS_X_NSTI_MAX),m_htiNewSystemTrayIcon,GetResString(IDS_X_NSTI_MAX_INFO));
			// NEO: NSTI END
			SetTreeCheck(m_ctrlTreeOptions,m_htiStaticTrayIcon,GetResString(IDS_X_STATIC_TRAY_ICON),m_htiInterface,GetResString(IDS_X_STATIC_TRAY_ICON_INFO),FALSE,m_bStaticTrayIcon); // NEO: STI - [StaticTray]
			SetTreeCheck(m_ctrlTreeOptions,m_htiDisableAutoSort,GetResString(IDS_X_DISABLE_AUTOSORT),m_htiInterface,GetResString(IDS_X_DISABLE_AUTOSORT_INFO),TRUE,m_uDisableAutoSort); // NEO: SE - [SortExtension]
			SetTreeCheck(m_ctrlTreeOptions,m_htiShowClientPercentage,GetResString(IDS_X_SHOW_CLIENT_PERCENTAGE),m_htiInterface,GetResString(IDS_X_SHOW_CLIENT_PERCENTAGE_INFO),FALSE,m_uShowClientPercentage); // NEO: MOD - [Percentage]
			// NEO: SI - [SysInfo]
			SetTreeCheck(m_ctrlTreeOptions,m_htiDrawSysInfoGraph,GetResString(IDS_X_USE_SYS_INFO),m_htiInterface,GetResString(IDS_X_USE_SYS_INFO_INFO),FALSE,m_bDrawSysInfoGraph);
			SetTreeCheck(m_ctrlTreeOptions,m_htiShowSysInfoOnTitle,GetResString(IDS_X_USE_SYS_INFO_TITLE),m_htiInterface,GetResString(IDS_X_USE_SYS_INFO_TITLE_INFO),FALSE,m_bShowSysInfoOnTitle);
			// NEO: SI END	
			SetTreeCheck(m_ctrlTreeOptions,m_htiShowMyFullInfo,GetResString(IDS_X_SHOW_MY_FULL_INFO),m_htiInterface,GetResString(IDS_X_SHOW_MY_FULL_INFO_INFO),FALSE,m_bShowMyFullInfo);
			// NEO: NTB - [NeoToolbarButtons]
			SetTreeCheckNumEdit(m_ctrlTreeOptions,m_htiNeoToolbar,GetResString(IDS_X_SHOW_NEO_TOOLBAR),m_htiInterface,GetResString(IDS_X_SHOW_NEO_TOOLBAR_INFO),TRUE,m_uNeoToolbar);
				CreateNeoToolbarMembers(iImgNeoBtn);
			// NEO: NTB END
			// NEO: CTB - [CoolToolBar]
			SetTreeCheck(m_ctrlTreeOptions,m_htiCoolToolbar,GetResString(IDS_X_USE_COOL_TOOLBAR),m_htiInterface,GetResString(IDS_X_USE_COOL_TOOLBAR_INFO),FALSE,m_bCoolToolbar);
				SetTreeCheck(m_ctrlTreeOptions,m_htiCoolToolbarText,GetResString(IDS_X_USE_COOL_TOOLBAR_TEXT),m_htiCoolToolbar,GetResString(IDS_X_USE_COOL_TOOLBAR_TEXT_INFO),TRUE,m_uCoolToolbarText);
				SetTreeNumEdit(m_ctrlTreeOptions,m_htiCoolToolbarCenter,GetResString(IDS_X_COOL_TOOLBAR_CENTER),m_htiCoolToolbar,GetResString(IDS_X_COOL_TOOLBAR_CENTER_INFO));
				SetTreeNumEdit(m_ctrlTreeOptions,m_htiCoolToolbarRight,GetResString(IDS_X_COOL_TOOLBAR_RIGHT),m_htiCoolToolbar,GetResString(IDS_X_COOL_TOOLBAR_RIGHT_INFO));
				SetTreeNumEdit(m_ctrlTreeOptions,m_htiCoolToolbarButtonCount,GetResString(IDS_X_COOL_TOOLBAR_BUTTONS),m_htiCoolToolbar,GetResString(IDS_X_COOL_TOOLBAR_BUTTONS_INFO));
			// NEO: CTB END
			// NEO: NMX - [NeoMenuXP]
			SetTreeGroup(m_ctrlTreeOptions,m_htiXPMenuStyle,GetResString(IDS_X_XP_MENU_STYLE),iImgXP, m_htiInterface, GetResString(IDS_X_XP_MENU_STYLE_INFO));
				SetTreeRadio(m_ctrlTreeOptions,m_htiXPMenuStyleOffice,GetResString(IDS_X_OFFICE_MENUS),m_htiXPMenuStyle,GetResString(IDS_X_OFFICE_MENUS_INFO),FALSE,m_iXPMenuStyle == 0);
				SetTreeRadio(m_ctrlTreeOptions,m_htiXPMenuStyleStartMenu,GetResString(IDS_X_START_MENUS),m_htiXPMenuStyle,GetResString(IDS_X_START_MENUS_INFO),FALSE,m_iXPMenuStyle == 1);
				SetTreeRadio(m_ctrlTreeOptions,m_htiXPMenuStyleXP,GetResString(IDS_X_XP_MENUS),m_htiXPMenuStyle,GetResString(IDS_X_XP_MENUS_INFO),FALSE,m_iXPMenuStyle == 2);
				SetTreeCheck(m_ctrlTreeOptions,m_htiShowXPSideBar,GetResString(IDS_X_SHOW_XP_SIDEBAR),m_htiXPMenuStyle,GetResString(IDS_X_SHOW_XP_SIDEBAR_INFO),FALSE,m_bShowXPSideBar);
				SetTreeCheck(m_ctrlTreeOptions,m_htiShowXPBitmap,GetResString(IDS_X_SHOW_XP_BITMAP),m_htiXPMenuStyle,GetResString(IDS_X_SHOW_XP_BITMAP_INFO),FALSE,m_bShowXPBitmap);
				SetTreeCheck(m_ctrlTreeOptions,m_htiGrayMenuIcon,GetResString(IDS_X_GRAY_MENU_ICON),m_htiXPMenuStyle,GetResString(IDS_X_GRAY_MENU_ICON_INFO),FALSE,m_bGrayMenuIcon);
			// NEO: NMX END
			// NEO: MM - [NeoMiniMule]
			SetTreeCheck(m_ctrlTreeOptions,m_htiMiniMule,GetResString(IDS_X_MINIMULE_PREF),m_htiInterface,GetResString(IDS_X_MINIMULE_PREF_INFO),FALSE,m_bEnableMiniMule);
				SetTreeCheck(m_ctrlTreeOptions,m_htiAutoShowMiniMule,GetResString(IDS_X_AUTO_MINIMULE),m_htiMiniMule,GetResString(IDS_X_AUTO_MINIMULE_INFO),FALSE,m_bAutoShowMiniMule);
				SetTreeCheck(m_ctrlTreeOptions,m_htiMiniMuleOnTop,GetResString(IDS_X_MINIMULE_ONTOP),m_htiMiniMule,GetResString(IDS_X_MINIMULE_ONTOP_INFO),FALSE,m_bMiniMuleOnTop);
				SetTreeCheck(m_ctrlTreeOptions,m_htiUpdateHidenMiniMule,GetResString(IDS_X_UDATE_HIDEN_MINIMULE),m_htiMiniMule,GetResString(IDS_X_UDATE_HIDEN_MINIMULE_INFO),FALSE,m_bUpdateHidenMiniMule);
				//SetTreeCheckNumEdit(m_ctrlTreeOptions,m_htiMiniMuleTransparency,GetResString(IDS_X_MINIMULE_TRANSPARENCY),m_htiMiniMule,GetResString(IDS_X_MINIMULE_TRANSPARENCY_INFO),FALSE, m_iMiniMuleTransparency);
				m_htiMiniMuleTransparency = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_X_MINIMULE_TRANSPARENCY),m_htiMiniMule,m_iMiniMuleTransparency,FALSE);
				m_ctrlTreeOptions.AddEditBox(m_htiMiniMuleTransparency,RUNTIME_CLASS(CNumTreeOptionsEdit),RUNTIME_CLASS(CTreeOptionsSpinCtrl255));
				m_ctrlTreeOptions.SetItemInfo(m_htiMiniMuleTransparency,GetResString(IDS_X_MINIMULE_TRANSPARENCY_INFO));
				SetTreeCheck(m_ctrlTreeOptions,m_htiMiniMuleBack,GetResString(IDS_X_MINIMULE_BACK),m_htiMiniMule,GetResString(IDS_X_MINIMULE_BACK_INFO),FALSE,m_bMiniMuleBack);
				SetTreeEdit(m_ctrlTreeOptions,m_htiMiniMuleLabel,GetResString(IDS_X_MINIMULE_LABEL), m_htiMiniMule,GetResString(IDS_X_MINIMULE_LABEL_INFO));
			// NEO: MM END
			// NEO: IM - [InvisibelMode]
			SetTreeCheck(m_ctrlTreeOptions,m_htiInvisibelMode,GetResString(IDS_X_INVISIBLE_MODE),m_htiInterface,GetResString(IDS_X_INVISIBLE_MODE_INFO),FALSE,m_bInvisibleMode);

				m_htiInvisibelModeHotKeyModifier = m_ctrlTreeOptions.InsertItem(GetResString(IDS_X_INVISIBLE_KEY_MOD), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiInvisibelMode);
				m_ctrlTreeOptions.AddComboBox(m_htiInvisibelModeHotKeyModifier,RUNTIME_CLASS(CInvisibelModeHotKeyModifier));
				//m_ctrlTreeOptions.SetItemSize(m_htiInvisibelModeHotKeyModifier,15);
				m_ctrlTreeOptions.SetItemInfo(m_htiInvisibelModeHotKeyModifier,GetResString(IDS_X_INVISIBLE_KEY_MOD_INFO));

				m_htiInvisibelModeHotKey = m_ctrlTreeOptions.InsertItem(GetResString(IDS_X_INVISIBLE_KEY), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiInvisibelMode);
				m_ctrlTreeOptions.AddComboBox(m_htiInvisibelModeHotKey,RUNTIME_CLASS(CInvisibelModeHotKey));
				//m_ctrlTreeOptions.SetItemSize(m_htiInvisibelModeHotKey,5);
				m_ctrlTreeOptions.SetItemInfo(m_htiInvisibelModeHotKey,GetResString(IDS_X_INVISIBLE_KEY_INFO));
			// NEO: IM END

			SetTreeCheckEdit(m_ctrlTreeOptions,m_htiTrayPasswordProtection,GetResString(IDS_X_TRAY_PASSWORD_PROTECTION),m_htiInterface,GetResString(IDS_X_TRAY_PASSWORD_PROTECTION_INFO),FALSE,m_bTrayPasswordProtection);// NEO: TPP - [TrayPasswordProtection]

			SetTreeCheck(m_ctrlTreeOptions,m_htiSmoothStatisticsGraphs,GetResString(IDS_X_SMOOTH_STATISTICS_GRAPHS),m_htiInterface,GetResString(IDS_X_SMOOTH_STATISTICS_GRAPHS_INFO),FALSE,m_bSmoothStatisticsGraphs);


		m_ctrlTreeOptions.SetItemEnable(m_htiMiniMuleTransparency, m_iMiniMuleTransparency,TRUE,TRUE); // NEO: MM - [NeoMiniMule]

		// NEO: IM - [InvisibelMode]
		m_ctrlTreeOptions.SetItemEnable(m_htiInvisibelModeHotKeyModifier, m_bInvisibleMode);
		m_ctrlTreeOptions.SetItemEnable(m_htiInvisibelModeHotKey, m_bInvisibleMode);
		// NEO: IM END

		m_ctrlTreeOptions.Expand(m_htiInterface, TVE_EXPAND);

		UINT bCheck;
		// NEO: FC - [FakeCheck]
		m_ctrlTreeOptions.GetCheckBox(m_htiUseFakeCheck, bCheck);
		m_ctrlTreeOptions.SetItemEnable(m_htiUseFakeCheck, bCheck, TRUE, TRUE);
		// NEO: FC END

		// NEO: FDC - [FileNameDisparityCheck]
		m_ctrlTreeOptions.GetCheckBox(m_htiUseFileCheck, bCheck);
		m_ctrlTreeOptions.SetItemEnable(m_htiFileCheckSensitivity, bCheck);
		m_ctrlTreeOptions.SetItemEnable(m_htiFileCheckThreshold, bCheck);
		m_ctrlTreeOptions.SetItemEnable(m_htiFileCheckAmount, bCheck);
		if(bCheck)
		{
			m_ctrlTreeOptions.GetCheckBox(m_htiFileCheckThreshold, bCheck);
			m_ctrlTreeOptions.SetItemEnable(m_htiFileCheckThreshold, bCheck,TRUE,TRUE);
		}
		// NEO: FDC END

		// NEO: FN - [FunnyNick]
		m_ctrlTreeOptions.GetCheckBox(m_htiUseFunnyNick, bCheck);
		m_ctrlTreeOptions.SetItemEnable(m_htiUseFunnyNick, bCheck, TRUE, TRUE);
		m_ctrlTreeOptions.SetGroupEnable(m_htiUseFunnyNick, bCheck);
		// NEO: FN END

		// NEO: NTB - [NeoToolbarButtons]
		m_ctrlTreeOptions.GetCheckBox(m_htiNeoToolbar, bCheck);
		m_ctrlTreeOptions.SetItemEnable(m_htiNeoToolbar, bCheck,TRUE,TRUE);
		//m_ctrlTreeOptions.SetGroupEnable(m_htiNeoToolbar, bCheck);
		// NEO: NTB END

		// NEO: CTB - [CoolToolBar]
		m_ctrlTreeOptions.GetCheckBox(m_htiCoolToolbar, bCheck);
		m_ctrlTreeOptions.SetGroupEnable(m_htiCoolToolbar, bCheck);
		// NEO: CTB END

		CheckMMEnable(); // NEO: IM - [InvisibelMode]

		//m_ctrlTreeOptions.SendMessage(WM_VSCROLL, SB_TOP);
		m_bInitializedTreeOpts = true;
	}

#ifdef A4AF_CATS // NEO: MAC - [MorphA4AFCategories]
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiShowCatNames,m_bShowCatNames);
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiShowCategoryFlags,m_uShowCategoryFlags);
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiActiveCatDefault,m_bActiveCatDefault);
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiSelCatOnAdd,m_bSelCatOnAdd);
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiAutoSetResumeOrder,m_bAutoSetResumeOrder);
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiSmallFileDLPush,m_bSmallFileDLPush);
	DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiSmallFileDLPush, m_iSmallFileDLPush);
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiStartDLInEmptyCats,m_bStartDLInEmptyCats);
	DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiStartDLInEmptyCats, m_iStartDLInEmptyCats);
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiUseAutoCat,m_bUseAutoCat);
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiCheckAlreadyDownloaded,m_bCheckAlreadyDownloaded);
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiStartNextFileByPriority,m_bStartNextFileByPriority);
#endif // A4AF_CATS // NEO: MAC END
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiUseChunkDots,m_bUseChunkDots);  // NEO: MOD - [ChunkDots]
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiUseRelativeChunkDisplay,m_bUseRelativeChunkDisplay);  // NEO: MOD - [RelativeChunkDisplay]
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiUseTreeStyle,m_bUseTreeStyle); // NEO: NTS - [NeoTreeStyle]
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiClassicShareStatusBar,m_bClassicShareStatusBar);
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiShowFileTypeIcon,m_bShowFileTypeIcon); // NEO: NI - [NewIcons]
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiShowFileStatusIcons,m_bShowFileStatusIcons); // NEO: FSI - [FileStatusIcons]
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiCollorShareFiles,m_bCollorShareFiles); 
#ifdef IP2COUNTRY // NEO: IP2C - [IP2Country]
	DDX_TreeRadio(pDX, IDC_MOD_OPTS, m_htiIP2Country, m_iIP2CountryNameMode);
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiIP2CountryShowFlag,m_uIP2CountryShowFlag);
#endif // IP2COUNTRY // NEO: IP2C END
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiUseFakeCheck,m_bUseFakeCheck); // NEO: FC - [FakeCheck]
	// NEO: FDC - [FileNameDisparityCheck]
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiUseFileCheck,m_bUseFileCheck);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiFileCheckSensitivity, m_iFileCheckSensitivity);
		DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiFileCheckThreshold,m_bUseFileCheckThreshold);
			DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiFileCheckThreshold, m_iFileCheckThreshold);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiFileCheckAmount, m_iFileCheckAmount);
	// NEO: FDC END
	// NEO: FN - [FunnyNick]
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiUseFunnyNick,m_bUseFunnyNick);
		DDX_TreeEdit(pDX, IDC_MOD_OPTS, m_htiFunnyNickFilter,m_sFunnyNickFilter);
		DDX_TreeEdit(pDX, IDC_MOD_OPTS, m_htiFunnyNickSymbol,m_sFunnyNickSymbol);
	// NEO: FN END
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiShowBanner,m_bShowBanner);
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiShowHashProgres,m_bShowHashProgres);
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiUsePlusSpeedMeter,m_uUsePlusSpeedMeter); // NEO: PSM - [PlusSpeedMeter]
	// NEO: NSTI - [NewSystemTrayIcon]
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiShowSystemTrayUpload,m_bShowSystemTrayUpload);
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiThinSystemTrayBars,m_bThinSystemTrayBars);
	DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiTrayBarsMaxCollor,m_iTrayBarsMaxCollor);
	// NEO: NSTI END
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiStaticTrayIcon,m_bStaticTrayIcon); // NEO: STI - [StaticTray]
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiDisableAutoSort,m_uDisableAutoSort); // NEO: SE - [SortExtension]
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiShowClientPercentage,m_uShowClientPercentage); // NEO: MOD - [Percentage]
	// NEO: SI - [SysInfo]
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiDrawSysInfoGraph,m_bDrawSysInfoGraph);
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiShowSysInfoOnTitle,m_bShowSysInfoOnTitle);
	// NEO: SI END	
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiShowMyFullInfo,m_bShowMyFullInfo);
	// NEO: NTB - [NeoToolbarButtons]
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiNeoToolbar,m_uNeoToolbar);
	DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiNeoToolbar, m_iNeoToolbarButtonCount);
	if(m_iNeoToolbarButtonCount != m_cntNeoToolbarButtons){
		ClearNeoToolbarMembers(true);
		CreateNeoToolbarMembers(iImgNeoBtn);

		CArray<UINT> tmpNeoToolbarButton;
		int tmpNeoToolbarButtons = m_NeoToolbarButtons.GetSize();
		tmpNeoToolbarButton.SetSize(tmpNeoToolbarButtons);
		for (int i=0; i<tmpNeoToolbarButtons; i++)
			tmpNeoToolbarButton[i] = m_NeoToolbarButtons[i];
		m_NeoToolbarButtons.RemoveAll();
		m_NeoToolbarButtons.SetSize(m_iNeoToolbarButtonCount);
		tmpNeoToolbarButtons = min(m_NeoToolbarButtons.GetSize(),tmpNeoToolbarButton.GetSize());
		CDataExchange pDXtmp = *pDX;
		pDXtmp.m_bSaveAndValidate = FALSE;
		for (int i=0; i<tmpNeoToolbarButtons; i++){
			m_NeoToolbarButtons[i] = tmpNeoToolbarButton[i];
			DDX_TreeNeoToolbarButton(&m_ctrlTreeOptions, &pDXtmp, IDC_MOD_OPTS, &(m_htiNeoToolbarButtons[i]), m_NeoToolbarButtons[i]);
		}
	}
	else{
		for (int i=0; i<m_cntNeoToolbarButtons; i++)
			DDX_TreeNeoToolbarButton(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, &(m_htiNeoToolbarButtons[i]), m_NeoToolbarButtons[i]);
	}
	// NEO: NTB END
	// NEO: CTB - [CoolToolBar]
	DDX_TreeCheck(pDX, IDC_MOD_OPTS,m_htiCoolToolbar,m_bCoolToolbar);
		DDX_TreeCheck(pDX, IDC_MOD_OPTS,m_htiCoolToolbarText,m_uCoolToolbarText);
		DDX_TreeEdit(pDX, IDC_MOD_OPTS, m_htiCoolToolbarCenter, m_iCoolToolbarCenter);
		DDX_TreeEdit(pDX, IDC_MOD_OPTS, m_htiCoolToolbarRight, m_iCoolToolbarRight);
		DDX_TreeEdit(pDX, IDC_MOD_OPTS, m_htiCoolToolbarButtonCount, m_iCoolToolbarButtonCount);
		if(m_iCoolToolbarButtonCount != m_cntCoolToolbarButtons){
			for (int i=0; i<m_cntCoolToolbarButtons; i++)
				m_ctrlTreeOptions.DeleteItem(m_htiCoolToolbarButtons[i]);
			
			delete [] m_htiCoolToolbarButtons;
			m_htiCoolToolbarButtons = NULL;
			m_cntCoolToolbarButtons = 0;

			if(m_iCoolToolbarButtonCount)
			{
				m_htiCoolToolbarButtons = new HTREEITEM[m_iCoolToolbarButtonCount];
				m_cntCoolToolbarButtons = m_iCoolToolbarButtonCount;

				for (int i=0; i<m_cntCoolToolbarButtons; i++)
				{
					m_htiCoolToolbarButtons[i] = m_ctrlTreeOptions.InsertItem(StrLine(GetResString(IDS_X_COOLBAR_BUTTON),i), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiCoolToolbarButtonCount);
					m_ctrlTreeOptions.AddComboBox(m_htiCoolToolbarButtons[i],RUNTIME_CLASS(CCoolToolbarButton));
					//m_ctrlTreeOptions.SetItemSize(m_htiCoolToolbarButtons[i],15);
					m_ctrlTreeOptions.SetItemInfo(m_htiCoolToolbarButtons[i],GetResString(IDS_X_COOLBAR_BUTTON_INFO));
				}

				CArray<UINT> tmpCoolToolbarButton;
				int tmpCoolToolbarButtons = m_CoolToolbarButtons.GetSize();
				tmpCoolToolbarButton.SetSize(tmpCoolToolbarButtons);
				for (int i=0; i<tmpCoolToolbarButtons; i++)
					tmpCoolToolbarButton[i] = m_CoolToolbarButtons[i];

				m_CoolToolbarButtons.RemoveAll();
				m_CoolToolbarButtons.SetSize(m_iCoolToolbarButtonCount);

				tmpCoolToolbarButtons = min(m_CoolToolbarButtons.GetSize(),tmpCoolToolbarButton.GetSize());
				CDataExchange pDXtmp = *pDX;
				pDXtmp.m_bSaveAndValidate = FALSE;
				for (int i=0; i<tmpCoolToolbarButtons; i++){
					m_CoolToolbarButtons[i] = tmpCoolToolbarButton[i];
					DDX_TreeCoolToolbarButton(&m_ctrlTreeOptions, &pDXtmp, IDC_MOD_OPTS, m_htiCoolToolbarButtons[i], m_CoolToolbarButtons[i]);
				}
			}
		}
		else
		{
			for (int i=0; i<m_cntCoolToolbarButtons; i++)
				DDX_TreeCoolToolbarButton(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiCoolToolbarButtons[i], m_CoolToolbarButtons[i]);
		}

	// NEO: CTB END
	// NEO: NMX - [NeoMenuXP]
	DDX_TreeRadio(pDX, IDC_MOD_OPTS,m_htiXPMenuStyle,m_iXPMenuStyle);
	DDX_TreeCheck(pDX, IDC_MOD_OPTS,m_htiShowXPSideBar,m_bShowXPSideBar);
	DDX_TreeCheck(pDX, IDC_MOD_OPTS,m_htiShowXPBitmap,m_bShowXPBitmap);
	DDX_TreeCheck(pDX, IDC_MOD_OPTS,m_htiGrayMenuIcon,m_bGrayMenuIcon);
	// NEO: NMX END
	// NEO: MM - [NeoMiniMule]
	DDX_TreeCheck(pDX, IDC_MOD_OPTS,m_htiMiniMule,m_bEnableMiniMule);
	DDX_TreeCheck(pDX, IDC_MOD_OPTS,m_htiAutoShowMiniMule,m_bAutoShowMiniMule);
	DDX_TreeCheck(pDX, IDC_MOD_OPTS,m_htiMiniMuleOnTop,m_bMiniMuleOnTop);
	DDX_TreeCheck(pDX, IDC_MOD_OPTS,m_htiUpdateHidenMiniMule,m_bUpdateHidenMiniMule);
	DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiMiniMuleTransparency, m_iMiniMuleTransparency);
	bool bMiniMuleTransparency = I2B(m_iMiniMuleTransparency);
	DDX_TreeCheck(pDX, IDC_MOD_OPTS,m_htiMiniMuleTransparency,bMiniMuleTransparency);
	if(!bMiniMuleTransparency)
		m_iMiniMuleTransparency = 0;
	else if(!m_iMiniMuleTransparency)
		m_iMiniMuleTransparency = 64;
	DDX_TreeCheck(pDX, IDC_MOD_OPTS,m_htiMiniMuleBack,m_bMiniMuleBack);
	DDX_TreeEdit(pDX, IDC_MOD_OPTS, m_htiMiniMuleLabel, m_sMiniMuleLabel);
	// NEO: MM END
	// NEO: IM - [InvisibelMode]
	DDX_TreeCheck(pDX, IDC_MOD_OPTS,m_htiInvisibelMode,m_bInvisibleMode);
	if (pDX->m_bSaveAndValidate)
	{
		CString sKeyMod;
		sKeyMod = m_ctrlTreeOptions.GetComboText(m_htiInvisibelModeHotKeyModifier);

		m_iInvisibleModeHotKeyModifier = 0;
		if (sKeyMod.Find(GetResString(IDS_X_CTRLKEY))!=-1)
			m_iInvisibleModeHotKeyModifier |= MOD_CONTROL;
		if (sKeyMod.Find(GetResString(IDS_X_ALTKEY))!=-1)
			m_iInvisibleModeHotKeyModifier |= MOD_ALT;
		if (sKeyMod.Find(GetResString(IDS_X_SHIFTKEY))!=-1)
			m_iInvisibleModeHotKeyModifier |= MOD_SHIFT;

		CString sKey;
		sKey = m_ctrlTreeOptions.GetComboText(m_htiInvisibelModeHotKey);

		m_cInvisibleModeHotKey = sKey[0];
	}
	else
	{
		m_ctrlTreeOptions.SetComboText(m_htiInvisibelModeHotKey,CString(m_cInvisibleModeHotKey));

		CString sKeyMod;
		bool bPlus = false;

		if(m_iInvisibleModeHotKeyModifier & MOD_CONTROL){
			sKeyMod.Format(GetResString(IDS_X_CTRLKEY));
			bPlus = true;
		}
		if(m_iInvisibleModeHotKeyModifier & MOD_ALT){
			if(bPlus)
				sKeyMod.Append(_T(" + "));
			sKeyMod.Append(GetResString(IDS_X_ALTKEY));
			bPlus = true;
		}
		if(m_iInvisibleModeHotKeyModifier & MOD_SHIFT){
			if(bPlus)
				sKeyMod.Append(_T(" + "));
			sKeyMod.Append(GetResString(IDS_X_SHIFTKEY));
			bPlus = true;
		}

		m_ctrlTreeOptions.SetComboText(m_htiInvisibelModeHotKeyModifier,sKeyMod);

		m_ctrlTreeOptions.SetComboText(m_htiInvisibelModeHotKey,CString(m_cInvisibleModeHotKey));
	}
	// NEO: IM END

	// NEO: TPP - [TrayPasswordProtection]
	DDX_TreeCheck(pDX, IDC_MOD_OPTS,m_htiTrayPasswordProtection, m_bTrayPasswordProtection);
	DDX_TreeEdit(pDX, IDC_MOD_OPTS, m_htiTrayPasswordProtection, m_sTrayPassword);
	// NEO: TPP END

	DDX_TreeCheck(pDX, IDC_MOD_OPTS,m_htiSmoothStatisticsGraphs,m_bSmoothStatisticsGraphs);
}

BOOL CPPgInterface::OnInitDialog()
{
	LoadSettings();

	CPropertyPage::OnInitDialog();
	InitWindowStyles(this);

	SetDlgItemText(IDC_MOD_OPTS_INFO, GetResString(IDS_X_GUI_INFO)); // We set the first info

	return TRUE;  // return TRUE unless you set the focus to a control
				  // EXCEPTION: OCX Property Pages should return FALSE
}

void CPPgInterface::LoadSettings()
{
#ifdef A4AF_CATS // NEO: MAC - [MorphA4AFCategories]
	m_bShowCatNames = thePrefs.m_bShowCatNames;
	m_uShowCategoryFlags = thePrefs.m_uShowCategoryFlags;
	m_bActiveCatDefault = thePrefs.m_bActiveCatDefault;
	m_bSelCatOnAdd = thePrefs.m_bSelCatOnAdd;
	m_bAutoSetResumeOrder = thePrefs.m_bAutoSetResumeOrder;
	m_bSmallFileDLPush = thePrefs.m_bSmallFileDLPush;
	m_iSmallFileDLPush = thePrefs.m_iSmallFileDLPush;
	m_bStartDLInEmptyCats = thePrefs.m_bStartDLInEmptyCats;
	m_iStartDLInEmptyCats = thePrefs.m_iStartDLInEmptyCats;
	m_bUseAutoCat = thePrefs.m_bUseAutoCat;
	m_bCheckAlreadyDownloaded = thePrefs.m_bCheckAlreadyDownloaded;
	m_bStartNextFileByPriority = thePrefs.m_bStartNextFileByPriority;
#endif // A4AF_CATS // NEO: MAC END
	m_bUseChunkDots = thePrefs.m_bUseChunkDots; // NEO: MOD - [ChunkDots]
	m_bUseRelativeChunkDisplay = thePrefs.m_bUseRelativeChunkDisplay; // NEO: MOD - [RelativeChunkDisplay]
	m_bUseTreeStyle = thePrefs.m_bUseTreeStyle; // NEO: NTS - [NeoTreeStyle]
	m_bClassicShareStatusBar = thePrefs.m_bClassicShareStatusBar;
	m_bShowFileTypeIcon = thePrefs.m_bShowFileTypeIcon; // NEO: NI - [NewIcons]
	m_bShowFileStatusIcons = thePrefs.m_bShowFileStatusIcons; // NEO: FSI - [FileStatusIcons]
	m_bCollorShareFiles = thePrefs.m_bCollorShareFiles;
#ifdef IP2COUNTRY // NEO: IP2C - [IP2Country]
	m_iIP2CountryNameMode = thePrefs.m_iIP2CountryNameMode; 
	m_uIP2CountryShowFlag = thePrefs.m_uIP2CountryShowFlag; 
#endif // IP2COUNTRY // NEO: IP2C END
	m_bUseFakeCheck = thePrefs.m_bUseFakeCheck; // NEO: FC - [FakeCheck]
	// NEO: FDC - [FileNameDisparityCheck]
	m_bUseFileCheck = thePrefs.m_bUseFileCheck;
	m_iFileCheckSensitivity = thePrefs.m_iFileCheckSensitivity;
	m_bUseFileCheckThreshold = thePrefs.m_bUseFileCheckThreshold;
	m_iFileCheckThreshold = thePrefs.m_iFileCheckThreshold;
	m_iFileCheckAmount = thePrefs.m_iFileCheckAmount;
	// NEO: FDC END
	// NEO: FN - [FunnyNick]
	m_bUseFunnyNick = thePrefs.m_bUseFunnyNick;
	m_sFunnyNickFilter = thePrefs.m_sFunnyNickFilter;
	m_sFunnyNickSymbol = thePrefs.m_sFunnyNickSymbol;
	// NEO: FN END
	m_bShowBanner = thePrefs.m_bShowBanner;
	m_bShowHashProgres = thePrefs.m_bShowHashProgres;
	m_uUsePlusSpeedMeter = thePrefs.m_uUsePlusSpeedMeter; // NEO: PSM - [PlusSpeedMeter]
	// NEO: NSTI - [NewSystemTrayIcon]
	m_bShowSystemTrayUpload = thePrefs.m_bShowSystemTrayUpload;
	m_bThinSystemTrayBars = thePrefs.m_bThinSystemTrayBars;
	m_iTrayBarsMaxCollor = thePrefs.m_iTrayBarsMaxCollor;
	// NEO: NSTI END
	m_bStaticTrayIcon = thePrefs.m_bStaticTrayIcon; // NEO: STI - [StaticTray]
	m_uDisableAutoSort = thePrefs.m_uDisableAutoSort; // NEO: SE - [SortExtension]
	m_uShowClientPercentage = thePrefs.m_uShowClientPercentage; // NEO: MOD - [Percentage]
	// NEO: SI - [SysInfo]
	m_bDrawSysInfoGraph = thePrefs.m_bDrawSysInfoGraph;
	m_bShowSysInfoOnTitle = thePrefs.m_bShowSysInfoOnTitle;
	// NEO: SI END
	m_bShowMyFullInfo = thePrefs.m_bShowMyFullInfo;
	// NEO: NTB - [NeoToolbarButtons]
	m_uNeoToolbar = thePrefs.m_uNeoToolbar;
	m_iNeoToolbarButtonCount = thePrefs.m_iNeoToolbarButtonCount;
	m_NeoToolbarButtons.SetSize(m_iNeoToolbarButtonCount);
	for(int i=0; i<m_iNeoToolbarButtonCount; i++)
		m_NeoToolbarButtons[i] = thePrefs.m_NeoToolbarButtons[i];
	// NEO: NTB END
	// NEO: MM - [NeoMiniMule]
	m_bEnableMiniMule = thePrefs.m_bEnableMiniMule;
	m_bAutoShowMiniMule = thePrefs.m_bAutoShowMiniMule;
	m_bMiniMuleOnTop = thePrefs.m_bMiniMuleOnTop;
	m_bUpdateHidenMiniMule = thePrefs.m_bUpdateHidenMiniMule;
	m_iMiniMuleTransparency = thePrefs.m_uMiniMuleTransparency;
	m_bMiniMuleBack = thePrefs.m_bMiniMuleBack;
	m_sMiniMuleLabel = thePrefs.m_sMiniMuleLabel;
	// NEO: MM END
	// NEO: CTB - [CoolToolBar]
	m_bCoolToolbar = thePrefs.m_bCoolToolbar;

	m_uCoolToolbarText = thePrefs.m_uCoolToolbarText;
	
	m_iCoolToolbarCenter = thePrefs.m_iCoolToolbarCenter;
	m_iCoolToolbarRight = thePrefs.m_iCoolToolbarRight;

	m_iCoolToolbarButtonCount = thePrefs.m_iCoolToolbarButtonCount;
	m_CoolToolbarButtons.SetSize(m_iCoolToolbarButtonCount);
	for(int i=0; i<m_iCoolToolbarButtonCount; i++)
		m_CoolToolbarButtons[i] = thePrefs.m_CoolToolbarButtons[i];
	// NEO: CTB END
	// NEO: NMX - [NeoMenuXP]
	m_bShowXPSideBar = thePrefs.m_bShowXPSideBar;
	m_bShowXPBitmap = thePrefs.m_bShowXPBitmap;
	m_iXPMenuStyle = thePrefs.m_iXPMenuStyle;
	m_bGrayMenuIcon = thePrefs.m_bGrayMenuIcon;
	// NEO: NMX END
	// NEO: IM - [InvisibelMode]
	m_bInvisibleMode = thePrefs.m_bInvisibleMode;		
	m_iInvisibleModeHotKeyModifier = thePrefs.m_iInvisibleModeHotKeyModifier;
	m_cInvisibleModeHotKey = thePrefs.m_cInvisibleModeHotKey;
	// NEO: IM END
	// NEO: TPP - [TrayPasswordProtection]
	m_bTrayPasswordProtection = thePrefs.m_bTrayPasswordProtection;
	m_sTrayPassword = thePrefs.m_sTrayPassword;
	// NEO: TPP END

	m_bSmoothStatisticsGraphs = thePrefs.m_bSmoothStatisticsGraphs;
}

BOOL CPPgInterface::OnApply()
{
	// if prop page is closed by pressing ENTER we have to explicitly commit any possibly pending
	// data from an open edit control
	m_ctrlTreeOptions.HandleChildControlLosingFocus();

	if (!UpdateData())
		return FALSE;

#ifdef A4AF_CATS // NEO: MAC - [MorphA4AFCategories]
	thePrefs.m_bShowCatNames = m_bShowCatNames;
	if(thePrefs.m_uShowCategoryFlags != m_uShowCategoryFlags){
		thePrefs.m_uShowCategoryFlags = m_uShowCategoryFlags;
		theApp.emuledlg->transferwnd->UpdateCatTabIcons(true);
		theApp.emuledlg->transferwnd->VerifyCatTabSize();
	}
	thePrefs.m_bActiveCatDefault = m_bActiveCatDefault;
	thePrefs.m_bSelCatOnAdd = m_bSelCatOnAdd;
	thePrefs.m_bAutoSetResumeOrder = m_bAutoSetResumeOrder;
	thePrefs.m_bSmallFileDLPush = m_bSmallFileDLPush;
	thePrefs.m_iSmallFileDLPush = m_iSmallFileDLPush;
	thePrefs.m_bStartDLInEmptyCats = m_bStartDLInEmptyCats;
	thePrefs.m_iStartDLInEmptyCats = m_iStartDLInEmptyCats;
	thePrefs.m_bUseAutoCat = m_bUseAutoCat;
	thePrefs.m_bCheckAlreadyDownloaded = m_bCheckAlreadyDownloaded;
	thePrefs.m_bStartNextFileByPriority = m_bStartNextFileByPriority;
#endif // A4AF_CATS // NEO: MAC END
	thePrefs.m_bUseChunkDots = m_bUseChunkDots; // NEO: MOD - [ChunkDots]
	thePrefs.m_bUseRelativeChunkDisplay = m_bUseRelativeChunkDisplay; // NEO: MOD - [RelativeChunkDisplay]
	thePrefs.m_bUseTreeStyle = m_bUseTreeStyle; // NEO: NTS - [NeoTreeStyle]
	thePrefs.m_bClassicShareStatusBar = m_bClassicShareStatusBar;
	thePrefs.m_bShowFileTypeIcon = m_bShowFileTypeIcon; // NEO: NI - [NewIcons]
	thePrefs.m_bShowFileStatusIcons = m_bShowFileStatusIcons; // NEO: FSI - [FileStatusIcons]
	thePrefs.m_bCollorShareFiles = m_bCollorShareFiles;
#ifdef IP2COUNTRY // NEO: IP2C - [IP2Country]
	if(	(thePrefs.m_iIP2CountryNameMode != IP2CountryName_DISABLE || thePrefs.m_uIP2CountryShowFlag) !=
		(m_iIP2CountryNameMode != IP2CountryName_DISABLE || m_uIP2CountryShowFlag)	){
		//check if need to load or unload DLL and ip table
		if(m_iIP2CountryNameMode != IP2CountryName_DISABLE || m_uIP2CountryShowFlag)
			theApp.ip2country->Load();
		else
			theApp.ip2country->Unload();
		if(m_iIP2CountryNameMode != IP2CountryName_DISABLE){
			theApp.emuledlg->serverwnd->serverlistctrl.ShowColumn(16);
			theApp.emuledlg->transferwnd->clientlistctrl.ShowColumn(9);
			theApp.emuledlg->transferwnd->queuelistctrl.ShowColumn(14);
			theApp.emuledlg->transferwnd->uploadlistctrl.ShowColumn(12);
			theApp.emuledlg->transferwnd->downloadclientsctrl.ShowColumn(9);
		}else{
			theApp.emuledlg->serverwnd->serverlistctrl.ShowColumn(16);
			theApp.emuledlg->transferwnd->clientlistctrl.HideColumn(9);
			theApp.emuledlg->transferwnd->queuelistctrl.HideColumn(14);
			theApp.emuledlg->transferwnd->uploadlistctrl.HideColumn(12);
			theApp.emuledlg->transferwnd->downloadclientsctrl.HideColumn(9);
		}
	}
	thePrefs.m_iIP2CountryNameMode = m_iIP2CountryNameMode;
	thePrefs.m_uIP2CountryShowFlag = m_uIP2CountryShowFlag;
#endif // IP2COUNTRY // NEO: IP2C END
	// NEO: FC - [FakeCheck]
	if(thePrefs.m_bUseFakeCheck != m_bUseFakeCheck){
		if(m_bUseFakeCheck)
			theApp.emuledlg->searchwnd->m_pwndResults->searchlistctrl.ShowColumn(14);
		else
			theApp.emuledlg->searchwnd->m_pwndResults->searchlistctrl.HideColumn(14);
	}
	thePrefs.m_bUseFakeCheck = m_bUseFakeCheck;
	// NEO: FC END
	// NEO: FDC - [FileNameDisparityCheck]
	thePrefs.m_bUseFileCheck = m_bUseFileCheck;
	thePrefs.m_iFileCheckSensitivity = m_iFileCheckSensitivity;
	thePrefs.m_bUseFileCheckThreshold = m_bUseFileCheckThreshold;
	thePrefs.m_iFileCheckThreshold = m_iFileCheckThreshold;
	thePrefs.m_iFileCheckAmount = m_iFileCheckAmount;
	// NEO: FDC END
	// NEO: FN - [FunnyNick]
	thePrefs.m_bUseFunnyNick = m_bUseFunnyNick;
	thePrefs.m_sFunnyNickFilter = m_sFunnyNickFilter;
	thePrefs.m_sFunnyNickSymbol = m_sFunnyNickSymbol;
	// NEO: FN END
	thePrefs.m_bShowBanner = m_bShowBanner;
	thePrefs.m_bShowHashProgres = m_bShowHashProgres;
	thePrefs.m_uUsePlusSpeedMeter = m_uUsePlusSpeedMeter; // NEO: PSM - [PlusSpeedMeter]
	// NEO: NSTI - [NewSystemTrayIcon]
	thePrefs.m_bShowSystemTrayUpload = m_bShowSystemTrayUpload;
	thePrefs.m_bThinSystemTrayBars = m_bThinSystemTrayBars;
	if(thePrefs.m_iTrayBarsMaxCollor != m_iTrayBarsMaxCollor)
	{
		thePrefs.m_iTrayBarsMaxCollor = m_iTrayBarsMaxCollor;
		theApp.emuledlg->UpdateTrayBarsColors();
	}
	// NEO: NSTI END
	thePrefs.m_bStaticTrayIcon = m_bStaticTrayIcon; // NEO: STI - [StaticTray]
	thePrefs.m_uDisableAutoSort = m_uDisableAutoSort; // NEO: SE - [SortExtension]
	thePrefs.m_uShowClientPercentage = m_uShowClientPercentage; // NEO: MOD - [Percentage]
	// NEO: SI - [SysInfo]
	thePrefs.m_bDrawSysInfoGraph = m_bDrawSysInfoGraph;
	thePrefs.m_bShowSysInfoOnTitle = m_bShowSysInfoOnTitle;
	// NEO: SI END
	thePrefs.m_bShowMyFullInfo = m_bShowMyFullInfo;
	// NEO: NTB - [NeoToolbarButtons]
	bool bUpdateToolbar = false;
	if(thePrefs.m_uNeoToolbar != m_uNeoToolbar){
		thePrefs.m_uNeoToolbar = m_uNeoToolbar;
		bUpdateToolbar = true;
	}
	if(thePrefs.m_iNeoToolbarButtonCount != m_iNeoToolbarButtonCount){
		thePrefs.m_iNeoToolbarButtonCount = m_iNeoToolbarButtonCount;
		bUpdateToolbar = true;
		thePrefs.m_NeoToolbarButtons.RemoveAll();
		thePrefs.m_NeoToolbarButtons.SetSize(m_iNeoToolbarButtonCount);
		for(int i=0; i<m_iNeoToolbarButtonCount; i++){
			thePrefs.m_NeoToolbarButtons[i] = m_NeoToolbarButtons[i];
		}
	}
	else{
		for(int i=0; i<m_iNeoToolbarButtonCount; i++){
			if(thePrefs.m_NeoToolbarButtons[i] != m_NeoToolbarButtons[i]){
				thePrefs.m_NeoToolbarButtons[i] = m_NeoToolbarButtons[i];
				bUpdateToolbar = true;
			}
		}
	}
	if(bUpdateToolbar)
		theApp.emuledlg->transferwnd->ResetTransToolbar();
	// NEO: NTB END
	// NEO: CTB - [CoolToolBar]
	if(thePrefs.m_bCoolToolbar != m_bCoolToolbar)
	{
		thePrefs.m_bCoolToolbar = m_bCoolToolbar; 
		if (AfxMessageBox(GetResString(IDS_SETTINGCHANGED_RESTART),MB_YESNO | MB_ICONEXCLAMATION,0)==IDYES)
			theApp.emuledlg->RestartMuleApp();
	}

	bool bLocalizeCoolbar = false;
	if(thePrefs.m_uCoolToolbarText != m_uCoolToolbarText)
	{
		thePrefs.m_uCoolToolbarText = m_uCoolToolbarText;
		bLocalizeCoolbar = true;
	}
	
	bool bSizeCoolbar = false;
	if(thePrefs.m_iCoolToolbarCenter != m_iCoolToolbarCenter
	 || thePrefs.m_iCoolToolbarRight != m_iCoolToolbarRight)
	{
		thePrefs.m_iCoolToolbarCenter = m_iCoolToolbarCenter;
		thePrefs.m_iCoolToolbarRight = m_iCoolToolbarRight;
		bSizeCoolbar = true;
	}
	
	bool bUpdateCoolbar = false;
	if(thePrefs.m_iCoolToolbarButtonCount != m_iCoolToolbarButtonCount){
		bUpdateCoolbar = true;
		thePrefs.m_iCoolToolbarButtonCount = m_iCoolToolbarButtonCount;
		thePrefs.m_CoolToolbarButtons.RemoveAll();
		thePrefs.m_CoolToolbarButtons.SetSize(m_iCoolToolbarButtonCount);
		for(int i=0; i<m_iCoolToolbarButtonCount; i++){
			thePrefs.m_CoolToolbarButtons[i] = m_CoolToolbarButtons[i];
		}
	}
	else{
		for(int i=0; i<m_iCoolToolbarButtonCount; i++){
			if(thePrefs.m_CoolToolbarButtons[i] != m_CoolToolbarButtons[i]){
				thePrefs.m_CoolToolbarButtons[i] = m_CoolToolbarButtons[i];
				bUpdateCoolbar = true;
			}
		}
	}
	if(theApp.emuledlg->toolbar->IsCoolToolbar())
	{
		if(bUpdateCoolbar)
			((CNeoToolbarCtrl*)theApp.emuledlg->toolbar)->CreateButtons();
		else if(bSizeCoolbar)
			((CNeoToolbarCtrl*)theApp.emuledlg->toolbar)->UpdateSize();
		if(bLocalizeCoolbar || bUpdateCoolbar)
			theApp.emuledlg->toolbar->Localize();
	}
	// NEO: CTB END
	// NEO: NMX - [NeoMenuXP]
	if( thePrefs.m_bShowXPSideBar != m_bShowXPSideBar
	 || thePrefs.m_bShowXPBitmap != m_bShowXPBitmap
	 || thePrefs.m_iXPMenuStyle != m_iXPMenuStyle
	 || thePrefs.m_bGrayMenuIcon != m_bGrayMenuIcon)
	{
		thePrefs.m_bShowXPSideBar = m_bShowXPSideBar;
		thePrefs.m_bShowXPBitmap = m_bShowXPBitmap;
		thePrefs.m_iXPMenuStyle = m_iXPMenuStyle;
		thePrefs.m_bGrayMenuIcon = m_bGrayMenuIcon;

		theApp.emuledlg->transferwnd->downloadlistctrl.CreateMenues();
		theApp.emuledlg->searchwnd->CreateMenus();
		theApp.emuledlg->searchwnd->m_pwndResults->searchlistctrl.CreateMenues();
		theApp.emuledlg->sharedfileswnd->sharedfilesctrl.CreateMenues();
		theApp.emuledlg->sharedfileswnd->m_ctlSharedDirTree.CreateMenues();
	}
	// NEO: NMX END

	// NEO: MM - [NeoMiniMule]
	thePrefs.m_bEnableMiniMule = m_bEnableMiniMule;
	thePrefs.m_bAutoShowMiniMule = m_bAutoShowMiniMule;
	thePrefs.m_bMiniMuleOnTop = m_bMiniMuleOnTop;
	thePrefs.m_bUpdateHidenMiniMule = m_bUpdateHidenMiniMule;
	thePrefs.m_uMiniMuleTransparency = (uint8)m_iMiniMuleTransparency;
	thePrefs.m_bMiniMuleBack = m_bMiniMuleBack;
	thePrefs.m_sMiniMuleLabel = m_sMiniMuleLabel;
	// NEO: MM END

	thePrefs.SetInvisibleMode(m_bInvisibleMode,m_iInvisibleModeHotKeyModifier,m_cInvisibleModeHotKey); // NEO: IM - [InvisibelMode]
	//thePrefs.m_bInvisibleMode = m_bInvisibleMode;
	//thePrefs.m_iInvisibleModeHotKeyModifier = m_iInvisibleModeHotKeyModifier;
	//thePrefs.m_cInvisibleModeHotKey = m_cInvisibleModeHotKey;

	if(thePrefs.m_bSmoothStatisticsGraphs != m_bSmoothStatisticsGraphs)
	{
		thePrefs.m_bSmoothStatisticsGraphs = m_bSmoothStatisticsGraphs;
#ifdef NEO_BC // NEO: NBC - [NeoBandwidthControl]
		theApp.bandwidthControl->InitStats(false);
#endif // NEO_BC // NEO: NBC END
	}

	// NEO: TPP - [TrayPasswordProtection]
	thePrefs.m_bTrayPasswordProtection = m_bTrayPasswordProtection;
	thePrefs.m_sTrayPassword = m_sTrayPassword;
	// NEO: TPP END

	thePrefs.CheckNeoPreferences();
	LoadSettings();

	// NEO: SI - [SysInfo]
	if (!thePrefs.ShowSysInfoOnTitle())
		theApp.emuledlg->SetWindowText(theApp.GetAppTitle(true)); // NEO: NV - [NeoVersion]
	// NEO: SI END

	SetModified(FALSE);

	theApp.emuledlg->toolbar->ShowSpeedMeter(thePrefs.UsePlusSpeedMeter() ? true : false); // NEO: PSM - [PlusSpeedMeter] // NEO: CTB - [CoolToolBar]	

	// NEO: STI - [StaticTray]
	if(thePrefs.UseStaticTrayIcon()) 
		theApp.emuledlg->TrayShow(true);
	// NEO: MOD END

	return CPropertyPage::OnApply();
}

BOOL CPPgInterface::OnKillActive()
{
	// if prop page is closed by pressing ENTER we have to explicitly commit any possibly pending
	// data from an open edit control
	m_ctrlTreeOptions.HandleChildControlLosingFocus();
	return CPropertyPage::OnKillActive();
}

void CPPgInterface::OnDestroy()
{
	m_ctrlTreeOptions.DeleteAllItems();
	m_ctrlTreeOptions.DestroyWindow();
	ClearAllMembers();
	CPropertyPage::OnDestroy();
}

LRESULT CPPgInterface::OnTreeOptsCtrlNotify(WPARAM wParam, LPARAM lParam)
{
	if(!IsWindowVisible())
		return 0;

	if (wParam == IDC_MOD_OPTS){
		TREEOPTSCTRLNOTIFY* pton = (TREEOPTSCTRLNOTIFY*)lParam;
		if(pton->nmhdr.code == EN_KILLFOCUS){
			// NEO: NTB - [NeoToolbarButtons]
			if(m_htiNeoToolbar && pton->hItem == m_htiNeoToolbar){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiNeoToolbar, 1, 8, 100)) SetModified();
			}
			// NEO: NTB END
			// NEO: MM - [NeoMiniMule]
			if(m_htiMiniMuleTransparency && pton->hItem == m_htiMiniMuleTransparency){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiMiniMuleTransparency, 0, 128, 255)) SetModified();
			}
			// NEO: MM END
		}else if(pton->nmhdr.code == BN_CLICKED){
			UINT bCheck;
			// NEO: FC - [FakeCheck]
			if(m_htiUseFakeCheck && pton->hItem == m_htiUseFakeCheck){
				m_ctrlTreeOptions.GetCheckBox(m_htiUseFakeCheck, bCheck);
				m_ctrlTreeOptions.SetItemEnable(m_htiUseFakeCheck, bCheck, TRUE, TRUE);
			}
			// NEO: FC END
			// NEO: FDC - [FileNameDisparityCheck]
			if(m_htiUseFileCheck && pton->hItem == m_htiUseFileCheck){
				m_ctrlTreeOptions.GetCheckBox(m_htiUseFileCheck, bCheck);
				m_ctrlTreeOptions.SetItemEnable(m_htiFileCheckSensitivity, bCheck);
				m_ctrlTreeOptions.SetItemEnable(m_htiFileCheckThreshold, bCheck);
				m_ctrlTreeOptions.SetItemEnable(m_htiFileCheckAmount, bCheck);
			}
			else if(m_htiFileCheckThreshold && pton->hItem == m_htiFileCheckThreshold){
				m_ctrlTreeOptions.GetCheckBox(m_htiFileCheckThreshold, bCheck);
				m_ctrlTreeOptions.SetItemEnable(m_htiFileCheckThreshold, bCheck,TRUE,TRUE);
			}
			else if(m_htiFileCheckSensitivity && pton->hItem == m_htiFileCheckSensitivity){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiFileCheckSensitivity, VAL_FILE_CHECK_SENSITIVITY_MIN, VAL_FILE_CHECK_SENSITIVITY_DEF, VAL_FILE_CHECK_SENSITIVITY_MAX)) SetModified();
			}else if(m_htiFileCheckThreshold && pton->hItem == m_htiFileCheckThreshold){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiFileCheckThreshold, VAL_FILE_CHECK_THRESHOLD_MIN, VAL_FILE_CHECK_THRESHOLD_DEF, VAL_FILE_CHECK_THRESHOLD_MAX)) SetModified();
			}else if(m_htiFileCheckAmount && pton->hItem == m_htiFileCheckAmount){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiFileCheckAmount, VAL_FILE_CHECK_AMOUNT_MIN, VAL_FILE_CHECK_AMOUNT_DEF, VAL_FILE_CHECK_AMOUNT_MAX)) SetModified();
			}
			// NEO: FDC END
			// NEO: FN - [FunnyNick]
			if(m_htiUseFunnyNick && pton->hItem == m_htiUseFunnyNick){
				m_ctrlTreeOptions.GetCheckBox(m_htiUseFunnyNick, bCheck);
				m_ctrlTreeOptions.SetItemEnable(m_htiUseFunnyNick, bCheck, TRUE, TRUE);
				m_ctrlTreeOptions.SetGroupEnable(m_htiUseFunnyNick, bCheck);
			}
			// NEO: FN END
			// NEO: NSTI - [NewSystemTrayIcon]
			else if(m_htiTrayBarsMaxCollor && pton->hItem == m_htiTrayBarsMaxCollor){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiTrayBarsMaxCollor, 1, 1, 17)) SetModified();
			}
			// NEO: NSTI END
			// NEO: NTB - [NeoToolbarButtons]
			else if(m_htiNeoToolbar && pton->hItem == m_htiNeoToolbar){
				m_ctrlTreeOptions.GetCheckBox(m_htiNeoToolbar, bCheck);
				m_ctrlTreeOptions.SetItemEnable(m_htiNeoToolbar, bCheck,TRUE,TRUE);
				//m_ctrlTreeOptions.SetGroupEnable(m_htiNeoToolbarButtons, bCheck);
			}
			// NEO: NTB END
			// NEO: CTB - [CoolToolBar]
			else if(m_htiCoolToolbar && pton->hItem == m_htiCoolToolbar){
				m_ctrlTreeOptions.GetCheckBox(m_htiCoolToolbar, bCheck);
				m_ctrlTreeOptions.SetGroupEnable(m_htiCoolToolbar, bCheck);
			}
			// NEO: CTB END
			// NEO: MM - [NeoMiniMule]
			else if(m_htiMiniMule && pton->hItem == m_htiMiniMule){
				CheckMMEnable();
			}
			else if(m_htiMiniMuleTransparency && pton->hItem == m_htiMiniMuleTransparency){
				CheckMMEnable();
			}
			// NEO: MM END
			// NEO: IM - [InvisibelMode]
			else if(m_htiInvisibelMode && pton->hItem == m_htiInvisibelMode){
				m_ctrlTreeOptions.GetCheckBox(m_htiInvisibelMode, bCheck);
				m_ctrlTreeOptions.SetItemEnable(m_htiInvisibelModeHotKeyModifier, bCheck);
				m_ctrlTreeOptions.SetItemEnable(m_htiInvisibelModeHotKey, bCheck);
			}
			// NEO: IM END
			SetModified();
		}else{
			SetModified();
		}
	}
	return 0;
}

void CPPgInterface::CheckMMEnable()
{
	UINT bCheck;
	m_ctrlTreeOptions.GetCheckBox(m_htiMiniMule, bCheck);
	m_ctrlTreeOptions.SetGroupEnable(m_htiMiniMule, bCheck);
	if(bCheck){
		m_ctrlTreeOptions.GetCheckBox(m_htiMiniMuleTransparency, bCheck);
		m_ctrlTreeOptions.SetItemEnable(m_htiMiniMuleTransparency, bCheck,TRUE,TRUE);
		if(bCheck){
			if(m_ctrlTreeOptions.GetEditText(m_htiMiniMuleTransparency).IsEmpty())
				m_ctrlTreeOptions.SetEditText(m_htiMiniMuleTransparency,_T("128"));
		}
	}
}

LRESULT CPPgInterface::DrawTreeItemHelp(WPARAM wParam, LPARAM lParam)
{
	if(!IsWindowVisible())
		return 0;

	if (wParam == IDC_MOD_OPTS){
		CString* sInfo = (CString*)lParam;
		SetDlgItemText(IDC_MOD_OPTS_INFO, *sInfo);
	}
	return FALSE;
}

void CPPgInterface::OnHelp()
{
	//theApp.ShowHelp(0);
}

BOOL CPPgInterface::OnCommand(WPARAM wParam, LPARAM lParam)
{
	if (wParam == ID_HELP)
	{
		OnHelp();
		return TRUE;
	}
	return __super::OnCommand(wParam, lParam);
}

BOOL CPPgInterface::OnHelpInfo(HELPINFO* /*pHelpInfo*/)
{
	OnHelp();
	return TRUE;
}
