//this file is part of NeoMule
//Copyright (C)2006 David Xanatos ( Xanatos@Lycos.at / http://neomule.sourceforge.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


#include "stdafx.h"
#include "emule.h"
#include "PPgFileTweaks.h"
#include "Preferences.h"
#include "PartFile.h"
#include "OtherFunctions.h"
#include "Neo/Functions.h"
#include "Neo/GUI/CP/TreeFunctions.h"
#include "Neo/Defaults.h"
#include "UserMsgs.h"
#include "downloadqueue.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif


///////////////////////////////////////////////////////////////////////////////
// CPPgFileTweaks dialog

IMPLEMENT_DYNAMIC(CPPgFileTweaks, CPropertyPage)

BEGIN_MESSAGE_MAP(CPPgFileTweaks, CPropertyPage)
	ON_WM_TIMER() // NEO: FCFG - [FileConfiguration]
	ON_WM_DESTROY()
	ON_MESSAGE(UM_DATA_CHANGED, OnDataChanged) // NEO: FCFG - [FileConfiguration]
	ON_MESSAGE(WM_TREEOPTSCTRL_NOTIFY, OnTreeOptsCtrlNotify)
	ON_MESSAGE(WM_TREEITEM_HELP, DrawTreeItemHelp)
	ON_WM_HELPINFO()
END_MESSAGE_MAP()

CPPgFileTweaks::CPPgFileTweaks()
	: CPropertyPage(CPPgFileTweaks::IDD)
	, m_ctrlTreeOptions(theApp.m_iDfltImageListColorFlags)
{
	// NEO: FCFG - [FileConfiguration]
	m_paFiles = NULL;
	m_bDataChanged = false;
	//m_strCaption = GetResString(IDS_FILEINFORMATION);
	//m_psp.pszTitle = m_strCaption;
	//m_psp.dwFlags |= PSP_USETITLE;
	m_timer = 0;
	// NEO: FCFG END
	ClearAllMembers();
	m_ctrlTreeOptions.SetNeoStyle();
}

CPPgFileTweaks::~CPPgFileTweaks()
{
}

void CPPgFileTweaks::ClearAllMembers()
{
	m_bInitializedTreeOpts = false;

	m_htiChunkSelectionMode = NULL;
		m_htiChunkSelectionModeDefeult = NULL;
		m_htiChunkSelectionModeNormal = NULL;
		m_htiChunkSelectionModeICS = NULL;
		m_htiChunkSelectionModeRC4 = NULL;
		// NEO: RC4 - [RareChunksV4]
		m_htiRareChunkV4Orde = NULL;
			m_htiRareChunkV4OrdeNormal = NULL;
			m_htiRareChunkV4OrdeLeft = NULL;
			m_htiRareChunkV4OrdeRight = NULL;
			m_htiRareChunkV4SameBlock = NULL;
		// NEO: RC4 END
		// NEO: SCT - [SubChunkTransfer]
		m_htiSubChunkTransfer = NULL;
			m_htiSubChunkTransferDefault = NULL;
			m_htiSubChunkTransferEnable = NULL;
			m_htiSubChunkTransferDisable = NULL;
		// NEO: SCT END
		// NEO: NPC - [NeoPartCatch]
		m_htiPartCatch = NULL;
			m_htiPartCatchDefault = NULL;
			m_htiPartCatchReal = NULL;
			m_htiPartCatchRealHiden = NULL;
			m_htiPartCatchHiden = NULL;
			m_htiPartCatchDisable = NULL;
		// NEO: NPC END
#ifdef A4AF_CATS // NEO: MAC - [MorphA4AFCategories]
	m_htiA4AFFlags = NULL;
		m_htiA4AFFlagsNone = NULL;
		m_htiA4AFFlagsOn = NULL;
		m_htiA4AFFlagsOff = NULL;
#endif // A4AF_CATS // NEO: MAC END
#ifdef LANCAST // NEO: NLC - [NeoLanCast]
	m_htiLanCastReask = NULL;
		m_htiDisableLAN = NULL;
		m_htiLANIntervals = NULL;
		m_htiLanReaskIntervals = NULL;
		m_htiNnPLanReaskIntervals = NULL;
#endif //LANCAST // NEO: NLC END
}

void CPPgFileTweaks::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_MOD_OPTS, m_ctrlTreeOptions);
	if (!m_bInitializedTreeOpts)
	{
		int iImgChunkMode = 8;
		int iImgRCMode = 8;
		int iImgSubChunkTransfer = 8;
		int iImgPartCatch = 8;
#ifdef A4AF_CATS // NEO: MAC - [MorphA4AFCategories]
		int iImgA4AF = 8;
#endif // A4AF_CATS // NEO: MAC END
#ifdef LANCAST // NEO: NLC - [NeoLanCast]
		int iImgReaskLan = 8;
#endif //LANCAST // NEO: NLC END
        CImageList* piml = m_ctrlTreeOptions.GetImageList(TVSIL_NORMAL);
		if (piml){
			iImgChunkMode = piml->Add(CTempIconLoader(_T("CHUNKSELECTION")));
			iImgRCMode = piml->Add(CTempIconLoader(_T("RCMODE")));
			iImgSubChunkTransfer = piml->Add(CTempIconLoader(_T("SCT")));
			iImgPartCatch = piml->Add(CTempIconLoader(_T("PARTCATCH")));
#ifdef A4AF_CATS // NEO: MAC - [MorphA4AFCategories]
			iImgA4AF = piml->Add(CTempIconLoader(_T("ADVA4AF")));
#endif // A4AF_CATS // NEO: MAC END
#ifdef LANCAST // NEO: NLC - [NeoLanCast]
			iImgReaskLan = piml->Add(CTempIconLoader(_T("REASKLAN")));
#endif //LANCAST // NEO: NLC END
		}

		SetTreeGroup(m_ctrlTreeOptions,m_htiChunkSelectionMode,GetResString(IDS_X_CHUNK_SELECTION),iImgChunkMode, TVI_ROOT, GetResString(IDS_X_CHUNK_SELECTION_INFO));
			SetTreeRadio(m_ctrlTreeOptions,m_htiChunkSelectionModeDefeult,GetResString(IDS_X_CS_DEFAULT),m_htiChunkSelectionMode,GetResString(IDS_X_CS_DEFAULT_INFO),TRUE,m_iChunkSelectionMode == CS_DEFAULT);
			SetTreeRadio(m_ctrlTreeOptions,m_htiChunkSelectionModeNormal,GetResString(IDS_X_CS_NORMAL),m_htiChunkSelectionMode,GetResString(IDS_X_CS_NORMAL_INFO),TRUE,m_iChunkSelectionMode == CS_NORMAL);
			SetTreeRadio(m_ctrlTreeOptions,m_htiChunkSelectionModeICS,GetResString(IDS_X_CS_ICS),m_htiChunkSelectionMode,GetResString(IDS_X_CS_ICS_INFO),TRUE,m_iChunkSelectionMode == CS_ICS);
			SetTreeRadio(m_ctrlTreeOptions,m_htiChunkSelectionModeRC4,GetResString(IDS_X_CS_RC4),m_htiChunkSelectionMode,GetResString(IDS_X_CS_RC4_INFO),TRUE,m_iChunkSelectionMode == CS_RC4);
			// NEO: RC4 - [RareChunksV4]
			SetTreeGroup(m_ctrlTreeOptions,m_htiRareChunkV4Orde,GetResString(IDS_X_RC_V4),iImgRCMode, m_htiChunkSelectionMode, GetResString(IDS_X_RC_V4_INFO));
				SetTreeRadio(m_ctrlTreeOptions,m_htiRareChunkV4OrdeNormal,GetResString(IDS_X_RC_V4_NORMAL),m_htiRareChunkV4Orde,GetResString(IDS_X_RC_V4_NORMAL_INFO),TRUE,m_iRareChunkV4Orde == RC4_NOMAL);
				SetTreeRadio(m_ctrlTreeOptions,m_htiRareChunkV4OrdeLeft,GetResString(IDS_X_RC_V4_LEFT),m_htiRareChunkV4Orde,GetResString(IDS_X_RC_V4_LEFT_INFO),TRUE,m_iRareChunkV4Orde == RC4_LEFT);
				SetTreeRadio(m_ctrlTreeOptions,m_htiRareChunkV4OrdeRight, GetResString(IDS_X_RC_V4_RIGHT),m_htiRareChunkV4Orde,GetResString(IDS_X_RC_V4_RIGHT_INFO),TRUE,m_iRareChunkV4Orde == RC4_RIGHT);
				SetTreeCheck(m_ctrlTreeOptions,m_htiRareChunkV4SameBlock,GetResString(IDS_X_RC_V4_BLOCK),m_htiRareChunkV4Orde,GetResString(IDS_X_RC_V4_BLOCK),TRUE,m_bRareChunkV4SameBlock);
			// NEO: RC4 END
			// NEO: SCT - [SubChunkTransfer]
			SetTreeGroup(m_ctrlTreeOptions,m_htiSubChunkTransfer,GetResString(IDS_X_SCT),iImgSubChunkTransfer, m_htiChunkSelectionMode, GetResString(IDS_X_SCT_INFO));
				SetTreeRadio(m_ctrlTreeOptions,m_htiSubChunkTransferDefault,GetResString(IDS_X_SCT_DEFAULT),m_htiSubChunkTransfer,GetResString(IDS_X_SCT_DEFAULT_INFO),TRUE,m_iSubChunkTransfer == 0);
				SetTreeRadio(m_ctrlTreeOptions,m_htiSubChunkTransferEnable,GetResString(IDS_X_SCT_ENABLE),m_htiSubChunkTransfer,GetResString(IDS_X_SCT_ENABLE_INFO),TRUE,m_iSubChunkTransfer == 1);
				SetTreeRadio(m_ctrlTreeOptions,m_htiSubChunkTransferDisable,GetResString(IDS_X_SCT_DISABLE),m_htiSubChunkTransfer,GetResString(IDS_X_SCT_DISABLE_INFO),TRUE,m_iSubChunkTransfer == 2);
			// NEO: SCT END
			// NEO: NPC - [NeoPartCatch]
			SetTreeGroup(m_ctrlTreeOptions,m_htiPartCatch,GetResString(IDS_X_PART_CATCH),iImgPartCatch, m_htiChunkSelectionMode, GetResString(IDS_X_PART_CATCH_INFO));
				SetTreeRadio(m_ctrlTreeOptions,m_htiPartCatchDefault,GetResString(IDS_X_PART_CATCH_DEFAULT),m_htiPartCatch,GetResString(IDS_X_PART_CATCH_DEFAULT_INFO),TRUE,m_iPartCatch == 0);
				SetTreeRadio(m_ctrlTreeOptions,m_htiPartCatchReal,GetResString(IDS_X_PART_CATCH_REAL),m_htiPartCatch,GetResString(IDS_X_PART_CATCH_REAL_INFO),TRUE,m_iPartCatch == 1);
				SetTreeRadio(m_ctrlTreeOptions,m_htiPartCatchRealHiden,GetResString(IDS_X_PART_CATCH_REAL_HIDEN),m_htiPartCatch,GetResString(IDS_X_PART_CATCH_REAL_HIDEN_INFO),TRUE,m_iPartCatch == 2);
				SetTreeRadio(m_ctrlTreeOptions,m_htiPartCatchHiden,GetResString(IDS_X_PART_CATCH_HIDEN),m_htiPartCatch,GetResString(IDS_X_PART_CATCH_HIDEN_INFO),TRUE,m_iPartCatch == 3);
				SetTreeRadio(m_ctrlTreeOptions,m_htiPartCatchDisable,GetResString(IDS_X_PART_CATCH_DISABLE),m_htiPartCatch,GetResString(IDS_X_PART_CATCH_DISABLE_INFO),TRUE,m_iPartCatch == 4);
			// NEO: NPC END
#ifdef A4AF_CATS // NEO: MAC - [MorphA4AFCategories]
		SetTreeGroup(m_ctrlTreeOptions,m_htiA4AFFlags,GetResString(IDS_X_A4AF_FLAGS),iImgA4AF, TVI_ROOT, GetResString(IDS_X_A4AF_FLAGS_INFO));
			SetTreeRadio(m_ctrlTreeOptions,m_htiA4AFFlagsNone,GetResString(IDS_X_A4AF_NONEFLAG),m_htiA4AFFlags,GetResString(IDS_X_A4AF_NONEFLAG_INFO),TRUE,m_iA4AFFlags == 0);
			SetTreeRadio(m_ctrlTreeOptions,m_htiA4AFFlagsOn,GetResString(IDS_X_A4AF_ONFLAG),m_htiA4AFFlags,GetResString(IDS_X_A4AF_ONFLAG_INFO),TRUE,m_iA4AFFlags == 1);
			SetTreeRadio(m_ctrlTreeOptions,m_htiA4AFFlagsOff,GetResString(IDS_X_A4AF_OFFFLAG),m_htiA4AFFlags,GetResString(IDS_X_A4AF_OFFFLAG_INFO),TRUE,m_iA4AFFlags == 2);
#endif // A4AF_CATS // NEO: MAC END
#ifdef LANCAST // NEO: NLC - [NeoLanCast]
		SetTreeGroup(m_ctrlTreeOptions,m_htiLanCastReask,GetResString(IDS_X_LAN_REASK_MAIN),iImgReaskLan, TVI_ROOT, GetResString(IDS_X_LAN_REASK_MAIN_INFO));
			SetTreeCheck(m_ctrlTreeOptions,m_htiDisableLAN,GetResString(IDS_X_LAN_DISABLE),m_htiLanCastReask,GetResString(IDS_X_LAN_DISABLE_INFO),TRUE,m_bDisableLAN);
			SetTreeNumEdit(m_ctrlTreeOptions,m_htiLANIntervals,GetResString(IDS_X_LAN_GET_SRC_TIME), m_htiLanCastReask,GetResString(IDS_X_LAN_GET_SRC_TIME_INFO));
			SetTreeNumEdit(m_ctrlTreeOptions,m_htiLanReaskIntervals,GetResString(IDS_X_LAN_DL_REASK), m_htiLanCastReask,GetResString(IDS_X_LAN_DL_REASK_INFO));
			SetTreeNumEdit(m_ctrlTreeOptions,m_htiNnPLanReaskIntervals,GetResString(IDS_X_LAN_NNP_REASK), m_htiLanCastReask,GetResString(IDS_X_LAN_NNP_REASK_INFO));

		m_ctrlTreeOptions.SetItemEnable(m_htiLanCastReask, thePrefs.IsLancastEnabled());
#endif //LANCAST // NEO: NLC END

		m_ctrlTreeOptions.SetItemEnable(m_htiPartCatchReal,thePrefs.UseRealPartStatus());
		m_ctrlTreeOptions.SetItemEnable(m_htiPartCatchRealHiden,thePrefs.UseRealPartStatus() && thePrefs.UseAntiHideOS());
		m_ctrlTreeOptions.SetItemEnable(m_htiPartCatchHiden,thePrefs.UseAntiHideOS());

		m_ctrlTreeOptions.SetItemEnable(m_htiChunkSelectionModeICS,thePrefs.UseInteligentChunkSelection());
		m_ctrlTreeOptions.SetGroupEnable(m_htiRareChunkV4Orde,(m_iChunkSelectionMode == CS_RC4));
		m_ctrlTreeOptions.SetGroupEnable(m_htiSubChunkTransfer,thePrefs.UseSubChunkTransfer());	// NEO: SCT - [SubChunkTransfer]

		m_ctrlTreeOptions.Expand(m_htiChunkSelectionMode, TVE_EXPAND);
		m_ctrlTreeOptions.Expand(m_htiSubChunkTransfer, TVE_EXPAND);
#ifdef A4AF_CATS // NEO: MAC - [MorphA4AFCategories]
		m_ctrlTreeOptions.Expand(m_htiA4AFFlags, TVE_EXPAND);
#endif // A4AF_CATS // NEO: MAC END
		m_bInitializedTreeOpts = true;
	}

	DDX_TreeRadio(pDX, IDC_MOD_OPTS, m_htiChunkSelectionMode, m_iChunkSelectionMode);
	DDX_TreeRadio(pDX, IDC_MOD_OPTS, m_htiRareChunkV4Orde, m_iRareChunkV4Orde);
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiRareChunkV4SameBlock, m_bRareChunkV4SameBlock);

	DDX_TreeRadio(pDX, IDC_MOD_OPTS, m_htiSubChunkTransfer, m_iSubChunkTransfer); // NEO: SCT - [SubChunkTransfer]

	DDX_TreeRadio(pDX, IDC_MOD_OPTS, m_htiPartCatch, m_iPartCatch); // NEO: NPC - [NeoPartCatch]

#ifdef A4AF_CATS // NEO: MAC - [MorphA4AFCategories]
	DDX_TreeRadio(pDX, IDC_MOD_OPTS, m_htiA4AFFlags, m_iA4AFFlags); 
#endif // A4AF_CATS // NEO: MAC END

#ifdef LANCAST // NEO: NLC - [NeoLanCast]
	DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiLANIntervals, m_iLANIntervals);

	DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiLanReaskIntervals, m_iLanReaskIntervals);
	DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiNnPLanReaskIntervals, m_iNnPLanReaskIntervals);
#endif //LANCAST // NEO: NLC END
}

BOOL CPPgFileTweaks::OnInitDialog()
{
	RefreshData();

	CPropertyPage::OnInitDialog();
	InitWindowStyles(this);

	// NEO: FCFG - [FileConfiguration]
	// no need to explicitly call 'RefreshData' here, 'OnSetActive' will be called right after 'OnInitDialog'

	// start time for calling 'RefreshData'
	VERIFY( (m_timer = SetTimer(301, 5000, 0)) != NULL );
	// NEO: FCFG END

	return TRUE;  // return TRUE unless you set the focus to a control
				  // EXCEPTION: OCX Property Pages should return FALSE
}

BOOL CPPgFileTweaks::OnApply()
{
	// if prop page is closed by pressing ENTER we have to explicitly commit any possibly pending
	// data from an open edit control
	m_ctrlTreeOptions.HandleChildControlLosingFocus();

	if (!UpdateData())
		return FALSE;

	/*
	* Datei Einstellungen Speichern
	*/

	// NEO: FCFG - [FileConfiguration]
	CPartFile* file;
	for (int i = 0; i < m_paFiles->GetSize(); i++)
	{
		file = STATIC_DOWNCAST(CPartFile, (*m_paFiles)[i]);

		//if (file->IsPartFile())

		if (m_iChunkSelectionMode != -1) file->PartPrefs.m_iChunkSelectionMode = m_iChunkSelectionMode;
		// NEO: RC4 - [RareChunksV4]
		if (m_iRareChunkV4Orde != -1) file->PartPrefs.m_iRareChunkV4Orde = m_iRareChunkV4Orde;
		if (m_bRareChunkV4SameBlock != BST_INDETERMINATE) file->PartPrefs.m_bRareChunkV4SameBlock = I2B(m_bRareChunkV4SameBlock == 1);
		// NEO: RC4 END

		if(m_iSubChunkTransfer != -1) file->PartPrefs.m_iSubChunkTransfer = m_iSubChunkTransfer; // NEO: SCT - [SubChunkTransfer]

		if(m_iPartCatch != -1) file->PartPrefs.m_iPartCatch = m_iPartCatch; // NEO: NPC - [NeoPartCatch]

#ifdef A4AF_CATS // NEO: MAC - [MorphA4AFCategories]
		if(m_iA4AFFlags != -1) file->PartPrefs.m_iA4AFFlags = m_iA4AFFlags;
#endif // A4AF_CATS // NEO: MAC END

#ifdef LANCAST // NEO: NLC - [NeoLanCast]
		if(m_bDisableLAN != BST_INDETERMINATE) file->PartPrefs.m_bDisableLAN = I2B(m_bDisableLAN);
		if(m_iLANIntervals) file->PartPrefs.m_iLANIntervals = m_iLANIntervals;

		if(m_iLanReaskIntervals) file->PartPrefs.m_iLanReaskIntervals = m_iLanReaskIntervals;
		if(m_iNnPLanReaskIntervals) file->PartPrefs.m_iNnPLanReaskIntervals = m_iNnPLanReaskIntervals;
#endif //LANCAST // NEO: NLC END

		file->PartPrefs.CheckTweaks();
	}
	// NEO: FCFG END

	RefreshData();
	
	SetModified(FALSE);
	return CPropertyPage::OnApply();
}

// NEO: FCFG - [FileConfiguration]
void CPPgFileTweaks::RefreshData()
{
	/*
	* Datei Einstellungen Laden
	*/

	const CPartFile* file = STATIC_DOWNCAST(CPartFile, (*m_paFiles)[0]);

	//if (file->IsPartFile())

	m_iChunkSelectionMode = file->PartPrefs.m_iChunkSelectionMode;
	// NEO: RC4 - [RareChunksV4]
	m_iRareChunkV4Orde = file->PartPrefs.m_iRareChunkV4Orde;
	m_bRareChunkV4SameBlock = file->PartPrefs.m_bRareChunkV4SameBlock;
	// NEO: RC4 END

	m_iSubChunkTransfer = file->PartPrefs.m_iSubChunkTransfer; // NEO: SCT - [SubChunkTransfer]

	m_iPartCatch = file->PartPrefs.m_iPartCatch; // NEO: NPC - [NeoPartCatch]

#ifdef A4AF_CATS // NEO: MAC - [MorphA4AFCategories]
	m_iA4AFFlags = file->PartPrefs.m_iA4AFFlags;
#endif // A4AF_CATS // NEO: MAC END

#ifdef LANCAST // NEO: NLC - [NeoLanCast]
	m_bDisableLAN = file->PartPrefs.m_bDisableLAN;
	m_iLANIntervals = file->PartPrefs.m_iLANIntervals;

	m_iLanReaskIntervals = file->PartPrefs.m_iLanReaskIntervals;
	m_iNnPLanReaskIntervals = file->PartPrefs.m_iNnPLanReaskIntervals;
#endif //LANCAST // NEO: NLC END

	for (int i = 1; i < m_paFiles->GetSize(); i++)
	{
		file = STATIC_DOWNCAST(CPartFile, (*m_paFiles)[i]);

		//if (file->IsPartFile())

		if (m_iChunkSelectionMode != file->PartPrefs.m_iChunkSelectionMode) m_iChunkSelectionMode = -1;
		// NEO: RC4 - [RareChunksV4]
		if (m_iRareChunkV4Orde != file->PartPrefs.m_iRareChunkV4Orde) m_iRareChunkV4Orde = -1;
		if (I2B(m_bRareChunkV4SameBlock == 1) != file->PartPrefs.m_bRareChunkV4SameBlock) m_bRareChunkV4SameBlock = BST_INDETERMINATE;
		// NEO: RC4 END

		if(m_iSubChunkTransfer != file->PartPrefs.m_iSubChunkTransfer) m_iSubChunkTransfer = -1; // NEO: SCT - [SubChunkTransfer]

		if(m_iPartCatch != file->PartPrefs.m_iPartCatch) m_iPartCatch = -1; // NEO: NPC - [NeoPartCatch]

#ifdef A4AF_CATS // NEO: MAC - [MorphA4AFCategories]
		if(m_iA4AFFlags != file->PartPrefs.m_iA4AFFlags) m_iA4AFFlags = -1;
#endif // A4AF_CATS // NEO: MAC END

#ifdef LANCAST // NEO: NLC - [NeoLanCast]
		if((m_bDisableLAN == 1) != file->PartPrefs.m_bDisableLAN) m_bDisableLAN = BST_INDETERMINATE;
		if(m_iLANIntervals != file->PartPrefs.m_iLANIntervals) m_iLANIntervals = UN_INT;

		if(m_iLanReaskIntervals != file->PartPrefs.m_iLanReaskIntervals) m_iLanReaskIntervals = UN_INT;
		if(m_iNnPLanReaskIntervals != file->PartPrefs.m_iNnPLanReaskIntervals) m_iNnPLanReaskIntervals = UN_INT;
#endif //LANCAST // NEO: NLC END
	}

	if(!m_iLANIntervals)
		m_iLANIntervals = thePrefs.GetLANIntervals();
	else if(m_iLANIntervals == UN_INT)
		m_iLANIntervals = 0;

	if(!m_iLanReaskIntervals)
		m_iLanReaskIntervals = thePrefs.GetLanReaskIntervals();
	else if(m_iLanReaskIntervals == UN_INT)
		m_iLanReaskIntervals = 0;

	if(!m_iNnPLanReaskIntervals)
		m_iNnPLanReaskIntervals = thePrefs.GetNnPLanReaskIntervals();
	else if(m_iNnPLanReaskIntervals == UN_INT)
		m_iNnPLanReaskIntervals = 0;

	UpdateData(FALSE);

}

void CPPgFileTweaks::OnTimer(UINT /*nIDEvent*/)
{
	if (m_bDataChanged)
	{
		RefreshData();
		m_bDataChanged = false;
	}
}

BOOL CPPgFileTweaks::OnSetActive()
{
	if (!CPropertyPage::OnSetActive())
		return FALSE;
	if (m_bDataChanged)
	{
		RefreshData();
		m_bDataChanged = false;
	}
	return TRUE;
}

LRESULT CPPgFileTweaks::OnDataChanged(WPARAM, LPARAM)
{
	m_bDataChanged = true;
	return 1;
}
// NEO: FCFG END

void CPPgFileTweaks::OnDestroy()
{
	// NEO: FCFG - [FileConfiguration]
	if (m_timer){
		KillTimer(m_timer);
		m_timer = 0;
	}
	// NEO: FCFG END

	m_ctrlTreeOptions.DeleteAllItems();
	m_ctrlTreeOptions.DestroyWindow();
	ClearAllMembers();
	CPropertyPage::OnDestroy();
}

/*void CPPgFileTweaks::Localize()
{
}*/

BOOL CPPgFileTweaks::OnKillActive()
{
	// if prop page is closed by pressing ENTER we have to explicitly commit any possibly pending
	// data from an open edit control
	m_ctrlTreeOptions.HandleChildControlLosingFocus();
	return CPropertyPage::OnKillActive();
}

LRESULT CPPgFileTweaks::OnTreeOptsCtrlNotify(WPARAM wParam, LPARAM lParam)
{
	if(!IsWindowVisible())
		return 0;

	if (wParam == IDC_MOD_OPTS){
		TREEOPTSCTRLNOTIFY* pton = (TREEOPTSCTRLNOTIFY*)lParam;
		if(pton->nmhdr.code == EN_KILLFOCUS){	
#ifdef LANCAST // NEO: NLC - [NeoLanCast]
			if(m_htiLANIntervals && pton->hItem == m_htiLANIntervals){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiLANIntervals, TIM_LAN_INTERVAL_MIN, TIM_LAN_INTERVAL_DEF, TIM_LAN_INTERVAL_MAX)) SetModified();
			}else if(m_htiLanReaskIntervals && pton->hItem == m_htiLanReaskIntervals){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiLanReaskIntervals, TIM_REASK_LAN_MIN, TIM_REASK_LAN_DEF, TIM_REASK_LAN_MAX)) SetModified();
			}else if(m_htiNnPLanReaskIntervals && pton->hItem == m_htiNnPLanReaskIntervals){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiNnPLanReaskIntervals, TIM_REASK_NNP_LAN_MIN, TIM_REASK_NNP_LAN_DEF, TIM_REASK_NNP_LAN_MAX)) SetModified();
			}
#endif //LANCAST // NEO: NLC END
		}else
		if(pton->nmhdr.code == BN_CLICKED){
			if((m_htiChunkSelectionModeRC4 && pton->hItem == m_htiChunkSelectionModeRC4)
				|| (m_htiChunkSelectionModeDefeult && pton->hItem == m_htiChunkSelectionModeDefeult)
				|| (m_htiChunkSelectionModeNormal && pton->hItem == m_htiChunkSelectionModeNormal)
				|| (m_htiChunkSelectionModeICS && pton->hItem == m_htiChunkSelectionModeICS)
				|| (m_htiChunkSelectionModeRC4 && pton->hItem == m_htiChunkSelectionModeRC4)
				){
				BOOL bCheck;
				m_ctrlTreeOptions.GetRadioButton(m_htiChunkSelectionModeRC4,bCheck);
				m_ctrlTreeOptions.SetGroupEnable(m_htiRareChunkV4Orde,bCheck);
			}
			SetModified();
		}
	}
	return 0;
}

LRESULT CPPgFileTweaks::DrawTreeItemHelp(WPARAM wParam, LPARAM lParam)
{
	if(!IsWindowVisible())
		return 0;

	if (wParam == IDC_MOD_OPTS){
		CString* sInfo = (CString*)lParam;
		SetDlgItemText(IDC_MOD_OPTS_INFO, *sInfo);
	}
	return FALSE;
}

void CPPgFileTweaks::OnHelp()
{
	//theApp.ShowHelp(0);
}

BOOL CPPgFileTweaks::OnCommand(WPARAM wParam, LPARAM lParam)
{
	if (wParam == ID_HELP)
	{
		OnHelp();
		return TRUE;
	}
	return __super::OnCommand(wParam, lParam);
}

BOOL CPPgFileTweaks::OnHelpInfo(HELPINFO* /*pHelpInfo*/)
{
	OnHelp();
	return TRUE;
}
