// PPgAdvWebserver.cpp : implementation file
#include "stdafx.h"
#include "emule.h"
#include "emuledlg.h"
#include "otherfunctions.h"
#include "WebServer.h"
#include "PPgAdvWebServer.h"
#include "PreferencesDlg.h"
#include "MD5Sum.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

// NEO: WAM - [WebInterfaceAccountManagement] -- Xanatos -->

#define HIDDEN_PASSWORD _T("*****")

IMPLEMENT_DYNAMIC(CPPgAdvWebServer, CPropertyPage)
CPPgAdvWebServer::CPPgAdvWebServer()
	: CPropertyPage(CPPgAdvWebServer::IDD)
{
	m_bIsInit = false;
	// NEO: NDP - [NeoDoublePrefs]
	m_imageList.DeleteImageList();
	m_imageList.Create(16, 16, theApp.m_iDfltImageListColorFlags | ILC_MASK, 14+1, 0);
	m_imageList.Add(CTempIconLoader(_T("WEB")));
	m_imageList.Add(CTempIconLoader(_T("WEB2")));
	// NEO: NDP END
}

CPPgAdvWebServer::~CPPgAdvWebServer()
{
}


void CPPgAdvWebServer::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);

	DDX_Control(pDX, IDC_TAB_WEBSVR2, m_tabCtr); // NEO: NDP - [NeoDoublePrefs]

	DDX_Control(pDX, IDC_ACCOUNTSELECT, m_cbAccountSelector); 
	DDX_Control(pDX, IDC_ADVADMIN_USERLEVEL, m_cbUserlevel); 
}

BEGIN_MESSAGE_MAP(CPPgAdvWebServer, CPropertyPage)
	ON_BN_CLICKED(IDC_ADVADMINENABLED, OnSettingsChangeBox)	
	ON_CBN_SELCHANGE(IDC_ACCOUNTSELECT, UpdateSelection)
	ON_BN_CLICKED(IDC_ADVADMIN_KAD, OnSettingsChange)
	ON_BN_CLICKED(IDC_ADVADMIN_TRANSFER, OnSettingsChange)
	ON_BN_CLICKED(IDC_ADVADMIN_SEARCH, OnSettingsChange)
	ON_BN_CLICKED(IDC_ADVADMIN_SERVER, OnSettingsChange)
	ON_BN_CLICKED(IDC_ADVADMIN_SHARED, OnSettingsChange)
	ON_BN_CLICKED(IDC_ADVADMIN_STATS, OnSettingsChange)
	ON_BN_CLICKED(IDC_ADVADMIN_PREFS, OnSettingsChange)
	ON_CBN_SELCHANGE(IDC_ADVADMIN_USERLEVEL, OnSettingsChange)	
	ON_BN_CLICKED(IDC_ADVADMIN_DELETE, OnBnClickedDel)
	ON_BN_CLICKED(IDC_ADVADMIN_NEW, OnBnClickedNew)	
	ON_EN_CHANGE(IDC_ADVADMIN_PASS, OnSettingsChange)
	ON_EN_CHANGE(IDC_ADVADMIN_CAT, OnSettingsChange)
	ON_EN_CHANGE(IDC_ADVADMIN_USER, OnSettingsChange)
	ON_NOTIFY(TCN_SELCHANGE, IDC_TAB_WEBSVR2, OnTcnSelchangeTabWebsvr2) // NEO: NDP - [NeoDoublePrefs]
	ON_WM_HELPINFO()
END_MESSAGE_MAP()


BOOL CPPgAdvWebServer::OnInitDialog()
{
	CPropertyPage::OnInitDialog();
	InitWindowStyles(this);
 
	InitTab(true,theApp.emuledlg->preferenceswnd->StartPageWebServer); // NEO: NDP - [NeoDoublePrefs]

	FillComboBox();
	FillUserlevelBox();

	LoadSettings();
	Localize();

	return TRUE;
}

void CPPgAdvWebServer::LoadSettings(void)
{
	if(m_hWnd)
	{
		CheckDlgButton(IDC_ADVADMINENABLED, thePrefs.UseAdvWebsrv());
		m_bIsInit = true;
	}
}

BOOL CPPgAdvWebServer::OnApply()
{	
	thePrefs.m_bAdvWebsrv = (IsDlgButtonChecked(IDC_ADVADMINENABLED)!=0);

	theApp.webserver->SaveWebServConf(); 

	SetModified(FALSE);

	LoadSettings();
	return CPropertyPage::OnApply();
}

void CPPgAdvWebServer::Localize(void)
{
	if(m_hWnd){
		SetWindowText(_T("Adv ") + GetResString(IDS_PW_WS));

		GetDlgItem(IDC_ADVADMINENABLED)->SetWindowText(GetResString(IDS_X_ADVADMINENABLED));
		GetDlgItem(IDC_ADVADMIN_NOTE)->SetWindowText(GetResString(IDS_X_ADVADMIN_NOTE));
		GetDlgItem(IDC_STATIC_ADVADMIN)->SetWindowText(GetResString(IDS_X_ADVADMIN_GROUP));
		GetDlgItem(IDC_STATIC_ADVADMIN_ACC)->SetWindowText(GetResString(IDS_X_ADVADMIN_ACC));
		GetDlgItem(IDC_ADVADMIN_DELETE)->SetWindowText(GetResString(IDS_X_ADVADMIN_DELETE));
		GetDlgItem(IDC_ADVADMIN_NEW)->SetWindowText(GetResString(IDS_X_ADVADMIN_NEW));
		GetDlgItem(IDC_ADVADMIN_KAD)->SetWindowText(GetResString(IDS_X_ADVADMIN_KAD));
		GetDlgItem(IDC_ADVADMIN_TRANSFER)->SetWindowText(GetResString(IDS_X_ADVADMIN_TRANSFER));
		GetDlgItem(IDC_ADVADMIN_SEARCH)->SetWindowText(GetResString(IDS_X_ADVADMIN_SEARCH));
		GetDlgItem(IDC_ADVADMIN_SERVER)->SetWindowText(GetResString(IDS_X_ADVADMIN_SERVER));
		GetDlgItem(IDC_ADVADMIN_SHARED)->SetWindowText(GetResString(IDS_X_ADVADMIN_SHARED));
		GetDlgItem(IDC_ADVADMIN_STATS)->SetWindowText(GetResString(IDS_X_ADVADMIN_STATS));
		GetDlgItem(IDC_ADVADMIN_PREFS)->SetWindowText(GetResString(IDS_X_ADVADMIN_PREFS));
		GetDlgItem(IDC_STATIC_ADVADMIN_USERLEVEL)->SetWindowText(GetResString(IDS_X_ADVADMIN_USERLEVEL));
		GetDlgItem(IDC_STATIC_ADVADMIN_PASS)->SetWindowText(GetResString(IDS_X_ADVADMIN_PASS));
		GetDlgItem(IDC_STATIC_ADVADMIN_USER)->SetWindowText(GetResString(IDS_X_ADVADMIN_USER));
		GetDlgItem(IDC_STATIC_ADVADMIN_CATS)->SetWindowText(GetResString(IDS_X_ADVADMIN_CAT));
	}
}

void CPPgAdvWebServer::OnHelp()
{
	
}

BOOL CPPgAdvWebServer::OnCommand(WPARAM wParam, LPARAM lParam)
{
	if (wParam == ID_HELP)
	{
		OnHelp();
		return TRUE;
	}
	return __super::OnCommand(wParam, lParam);
}

BOOL CPPgAdvWebServer::OnHelpInfo(HELPINFO* /*pHelpInfo*/)
{
	OnHelp();
	return TRUE;
}

BOOL CPPgAdvWebServer::OnSetActive()
{
	SetBoxes();
	return TRUE;
}

afx_msg void CPPgAdvWebServer::SetBoxes()
{
	bool bWSEnalbed = ((theApp.emuledlg->preferenceswnd->m_wndWebServer.GetDlgItem(IDC_WSENABLED) == NULL && thePrefs.GetWSIsEnabled()) ||(theApp.emuledlg->preferenceswnd->m_wndWebServer.GetDlgItem(IDC_WSENABLED) != NULL && theApp.emuledlg->preferenceswnd->m_wndWebServer.IsDlgButtonChecked(IDC_WSENABLED)));

	if(bWSEnalbed && IsDlgButtonChecked(IDC_ADVADMINENABLED)!=0)
	{
		GetDlgItem(IDC_ADVADMINENABLED)->EnableWindow(TRUE);
		m_cbAccountSelector.EnableWindow(TRUE);
		GetDlgItem(IDC_ADVADMIN_DELETE)->EnableWindow(TRUE);
		GetDlgItem(IDC_ADVADMIN_NEW)->EnableWindow(TRUE);
		GetDlgItem(IDC_ADVADMIN_KAD)->EnableWindow(TRUE);
		GetDlgItem(IDC_ADVADMIN_TRANSFER)->EnableWindow(TRUE);
		GetDlgItem(IDC_ADVADMIN_SEARCH)->EnableWindow(TRUE);
		GetDlgItem(IDC_ADVADMIN_SERVER)->EnableWindow(TRUE);
		GetDlgItem(IDC_ADVADMIN_SHARED)->EnableWindow(TRUE);
		GetDlgItem(IDC_ADVADMIN_STATS)->EnableWindow(TRUE);
		GetDlgItem(IDC_ADVADMIN_PREFS)->EnableWindow(TRUE);
		m_cbUserlevel.EnableWindow(TRUE);
		GetDlgItem(IDC_ADVADMIN_PASS)->EnableWindow(TRUE);
		GetDlgItem(IDC_ADVADMIN_USER)->EnableWindow(TRUE);
		GetDlgItem(IDC_ADVADMIN_CAT)->EnableWindow(TRUE);
	}
	else
	{	
		if(bWSEnalbed)
			GetDlgItem(IDC_ADVADMINENABLED)->EnableWindow(TRUE);
		else
			GetDlgItem(IDC_ADVADMINENABLED)->EnableWindow(FALSE);
		m_cbAccountSelector.EnableWindow(FALSE);
		GetDlgItem(IDC_ADVADMIN_DELETE)->EnableWindow(FALSE);
		GetDlgItem(IDC_ADVADMIN_NEW)->EnableWindow(FALSE);
		GetDlgItem(IDC_ADVADMIN_KAD)->EnableWindow(FALSE);
		GetDlgItem(IDC_ADVADMIN_TRANSFER)->EnableWindow(FALSE);
		GetDlgItem(IDC_ADVADMIN_SEARCH)->EnableWindow(FALSE);
		GetDlgItem(IDC_ADVADMIN_SERVER)->EnableWindow(FALSE);
		GetDlgItem(IDC_ADVADMIN_SHARED)->EnableWindow(FALSE);
		GetDlgItem(IDC_ADVADMIN_STATS)->EnableWindow(FALSE);
		GetDlgItem(IDC_ADVADMIN_PREFS)->EnableWindow(FALSE);
		m_cbUserlevel.EnableWindow(FALSE);
		GetDlgItem(IDC_ADVADMIN_PASS)->EnableWindow(FALSE);
		GetDlgItem(IDC_ADVADMIN_USER)->EnableWindow(FALSE);
		GetDlgItem(IDC_ADVADMIN_CAT)->EnableWindow(FALSE);
	}
}

void CPPgAdvWebServer::UpdateSelection()
{
	const int i = m_cbAccountSelector.GetCurSel();
	WebServDef tmp;
	if(i == -1 || !theApp.webserver->AdvLogins.Lookup(i, tmp))
	{
		//reset all if no selection possible
		GetDlgItem(IDC_ADVADMIN_DELETE)->EnableWindow(FALSE);
		GetDlgItem(IDC_ADVADMIN_NEW)->EnableWindow(TRUE);
		CheckDlgButton(IDC_ADVADMIN_KAD, BST_UNCHECKED);
		CheckDlgButton(IDC_ADVADMIN_TRANSFER, BST_UNCHECKED);
		CheckDlgButton(IDC_ADVADMIN_SEARCH, BST_UNCHECKED);
		CheckDlgButton(IDC_ADVADMIN_SERVER, BST_UNCHECKED);
		CheckDlgButton(IDC_ADVADMIN_SHARED, BST_UNCHECKED);
		CheckDlgButton(IDC_ADVADMIN_STATS, BST_UNCHECKED);
		CheckDlgButton(IDC_ADVADMIN_PREFS, BST_UNCHECKED);
		m_cbUserlevel.SetCurSel(0);
		GetDlgItem(IDC_ADVADMIN_PASS)->SetWindowText(_T(""));
		GetDlgItem(IDC_ADVADMIN_USER)->SetWindowText(_T(""));
		GetDlgItem(IDC_ADVADMIN_CAT)->SetWindowText(_T(""));
	}
	else
	{
		//set all data to our selectors
		GetDlgItem(IDC_ADVADMIN_DELETE)->EnableWindow(TRUE);
		GetDlgItem(IDC_ADVADMIN_NEW)->EnableWindow(FALSE);
		CheckDlgButton(IDC_ADVADMIN_KAD, tmp.RightsToKad);
		CheckDlgButton(IDC_ADVADMIN_TRANSFER, tmp.RightsToTransfered);
		CheckDlgButton(IDC_ADVADMIN_SEARCH, tmp.RightsToSearch);
		CheckDlgButton(IDC_ADVADMIN_SERVER, tmp.RightsToServers);
		CheckDlgButton(IDC_ADVADMIN_SHARED, tmp.RightsToSharedList);
		CheckDlgButton(IDC_ADVADMIN_STATS, tmp.RightsToStats);
		CheckDlgButton(IDC_ADVADMIN_PREFS, tmp.RightsToPrefs);
		m_cbUserlevel.SetCurSel(tmp.RightsToAddRemove);
		GetDlgItem(IDC_ADVADMIN_PASS)->SetWindowText(HIDDEN_PASSWORD);
		GetDlgItem(IDC_ADVADMIN_USER)->SetWindowText(tmp.User);
		GetDlgItem(IDC_ADVADMIN_CAT)->SetWindowText(tmp.RightsToCategories);
	}
}

void CPPgAdvWebServer::FillComboBox()
{
	//clear old values first
	m_cbAccountSelector.ResetContent();
	m_cbAccountSelector.InsertString(0, GetResString(IDS_X_ADVADMIN_NEW));
	for(POSITION pos = theApp.webserver->AdvLogins.GetHeadPosition(); pos; theApp.webserver->AdvLogins.GetNext(pos))
		m_cbAccountSelector.InsertString(theApp.webserver->AdvLogins.GetKeyAt(pos), theApp.webserver->AdvLogins.GetValueAt(pos).User);	
}

void CPPgAdvWebServer::FillUserlevelBox()
{
	//clear old values first
	m_cbUserlevel.ResetContent();
	m_cbUserlevel.InsertString(0, GetResString(IDS_X_ADVADMIN_GUEST));
	m_cbUserlevel.InsertString(1, GetResString(IDS_X_ADVADMIN_OPERATOR));
	m_cbUserlevel.InsertString(2, GetResString(IDS_X_ADVADMIN_ADMIN));
	m_cbUserlevel.InsertString(3, GetResString(IDS_X_ADVADMIN_HIADMIN));
}


#define SET_TCHAR_TO_STRING(t, s) {_stprintf(t, _T("%s"), s);}

void CPPgAdvWebServer::OnSettingsChange()
{
	SetModified();

	const int i = m_cbAccountSelector.GetCurSel();
	WebServDef tmp;
	if(i == -1 || !theApp.webserver->AdvLogins.Lookup(i, tmp))
		return;

	tmp.RightsToKad = IsDlgButtonChecked(IDC_ADVADMIN_KAD)!=0;
	tmp.RightsToTransfered = IsDlgButtonChecked(IDC_ADVADMIN_TRANSFER)!=0;
	tmp.RightsToSearch = IsDlgButtonChecked(IDC_ADVADMIN_SEARCH)!=0;
	tmp.RightsToServers = IsDlgButtonChecked(IDC_ADVADMIN_SERVER)!=0;
	tmp.RightsToSharedList = IsDlgButtonChecked(IDC_ADVADMIN_SHARED)!=0;
	tmp.RightsToStats = IsDlgButtonChecked(IDC_ADVADMIN_STATS)!=0;
	tmp.RightsToPrefs = IsDlgButtonChecked(IDC_ADVADMIN_PREFS)!=0;
	//tmp.RightsToAddRemove = IsDlgButtonChecked(IDC_ADVADMIN_ADMIN)!=0;
	int j = m_cbUserlevel.GetCurSel();
	ASSERT(j <= 3); //only 0,1,2,3 allowed
	tmp.RightsToAddRemove = (uint8)j;

	
	CString buffer;
	GetDlgItem(IDC_ADVADMIN_PASS)->GetWindowText(buffer);
	if(buffer != HIDDEN_PASSWORD)
		SET_TCHAR_TO_STRING(tmp.Pass, MD5Sum(buffer).GetHash());
	
	GetDlgItem(IDC_ADVADMIN_USER)->GetWindowText(buffer);
	SET_TCHAR_TO_STRING(tmp.User, buffer);

	GetDlgItem(IDC_ADVADMIN_CAT)->GetWindowText(buffer);
	SET_TCHAR_TO_STRING(tmp.RightsToCategories, buffer);

	theApp.webserver->AdvLogins.SetAt(i, tmp);

	FillComboBox();
	m_cbAccountSelector.SetCurSel(i);
}

void CPPgAdvWebServer::OnBnClickedNew()
{
	SetModified();

	const int i = theApp.webserver->AdvLogins.IsEmpty() ? 1 : theApp.webserver->AdvLogins.GetCount()+1;

	WebServDef tmp;
	tmp.RightsToKad = IsDlgButtonChecked(IDC_ADVADMIN_KAD)!=0;
	tmp.RightsToTransfered = IsDlgButtonChecked(IDC_ADVADMIN_TRANSFER)!=0;
	tmp.RightsToSearch = IsDlgButtonChecked(IDC_ADVADMIN_SEARCH)!=0;
	tmp.RightsToServers = IsDlgButtonChecked(IDC_ADVADMIN_SERVER)!=0;
	tmp.RightsToSharedList = IsDlgButtonChecked(IDC_ADVADMIN_SHARED)!=0;
	tmp.RightsToStats = IsDlgButtonChecked(IDC_ADVADMIN_STATS)!=0;
	tmp.RightsToPrefs = IsDlgButtonChecked(IDC_ADVADMIN_PREFS)!=0;
	//tmp.RightsToAddRemove = IsDlgButtonChecked(IDC_ADVADMIN_ADMIN)!=0;
	int j = m_cbUserlevel.GetCurSel();
	ASSERT(j <= 3); //only 0,1,2,3 allowed
	tmp.RightsToAddRemove = (uint8)j;

	CString buffer;
	GetDlgItem(IDC_ADVADMIN_PASS)->GetWindowText(buffer);
	if(buffer != HIDDEN_PASSWORD)
		SET_TCHAR_TO_STRING(tmp.Pass, MD5Sum(buffer).GetHash());

	GetDlgItem(IDC_ADVADMIN_USER)->GetWindowText(buffer);
	SET_TCHAR_TO_STRING(tmp.User, buffer);

	GetDlgItem(IDC_ADVADMIN_CAT)->GetWindowText(buffer);
	SET_TCHAR_TO_STRING(tmp.RightsToCategories, buffer);

	theApp.webserver->AdvLogins.SetAt(i, tmp);

	FillComboBox();
	m_cbAccountSelector.SetCurSel(i);

	GetDlgItem(IDC_ADVADMIN_DELETE)->EnableWindow(TRUE);
	GetDlgItem(IDC_ADVADMIN_NEW)->EnableWindow(FALSE);
}

void CPPgAdvWebServer::OnBnClickedDel()
{
	SetModified();

	const int i = m_cbAccountSelector.GetCurSel();  
    WebServDef tmp;  
    if(i == -1 || !theApp.webserver->AdvLogins.Lookup(i, tmp))   
         return;  
  
	CRBMap<uint32, WebServDef> tmpmap;  
  
    //retrieve all "wrong" entries  
    for(POSITION pos = theApp.webserver->AdvLogins.GetHeadPosition(); pos;)  
    {  
         POSITION pos2 = pos;  
         theApp.webserver->AdvLogins.GetNext(pos);  
  
         const int j = theApp.webserver->AdvLogins.GetKeyAt(pos2);  
         if(j == i)  
              theApp.webserver->AdvLogins.RemoveAt(pos2);  
         else if(j > i)  
         {  
              tmpmap.SetAt(j-1, theApp.webserver->AdvLogins.GetValueAt(pos2));  
              theApp.webserver->AdvLogins.RemoveAt(pos2);  
         }  
    }
	
	//reinsert all "wrong" entries correctly
	for(POSITION pos = tmpmap.GetHeadPosition(); pos; tmpmap.GetNext(pos))
		theApp.webserver->AdvLogins.SetAt(tmpmap.GetKeyAt(pos), tmpmap.GetValueAt(pos));

	FillComboBox();
	m_cbAccountSelector.SetCurSel(0); //set to the empty field
}

// NEO: NDP - [NeoDoublePrefs]
void CPPgAdvWebServer::InitTab(bool firstinit, int Page)
{
	if (firstinit) {
		m_tabCtr.DeleteAllItems();
		m_tabCtr.SetImageList(&m_imageList);
		m_tabCtr.InsertItem(TCIF_TEXT | TCIF_IMAGE | TCIF_PARAM, Websvr1, GetResString(IDS_PW_WS), 0, (LPARAM)Websvr1); 
		m_tabCtr.InsertItem(TCIF_TEXT | TCIF_IMAGE | TCIF_PARAM, Websvr2, GetResString(IDS_X_PW_WS2), 1, (LPARAM)Websvr2); 
	}

	m_tabCtr.SetCurSel(Page);
}
void CPPgAdvWebServer::OnTcnSelchangeTabWebsvr2(NMHDR* /*pNMHDR*/, LRESULT *pResult)
{
	int cur_sel = m_tabCtr.GetCurSel();
	theApp.emuledlg->preferenceswnd->SwitchTab(cur_sel);
	*pResult = 0;
}
// NEO: NDP END

// NEO: WAM END <-- Xanatos --