//this file is part of NeoMule
//Copyright (C)2006 David Xanatos ( Xanatos@Lycos.at / http://neomule.sourceforge.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#pragma once

// NEO: SCT - [SubChunkTransfer] -- Xanatos -->
#pragma pack(1)
struct tBlockMap{
	uint8 map[7]; // the last byte contains 3 obional bit flags

	void Reset()						{memset(&map,0,sizeof(uint8)*7);Relaiable = false;}
	bool IsEmpty()						{return ((map[0] | map[1] | map[2] | map[3] | map[4] | map[5] | (map[6] & 0x1F)) == 0); }

	bool IsBlockDone(uint8 block)		{return ((map[block / 8] & (1 << (block % 8))) != 0);}
	void SetBlockDone(uint8 block)		{map[block / 8] |= (1 << (block % 8));}
	void ClearBlockDone(uint8 block)	{map[block / 8] &= ~(1 << (block % 8));}

	bool IsVerified()					{return ((map[6] & 0x80) != 0);}
	void SetVerified()					{map[6] |= 0x80;}
	void ClearVerified()				{map[6] &= ~0x80;}

	bool Relaiable;
};
#pragma pack()
typedef CMap<uint16,uint16,tBlockMap,tBlockMap&> CBlockMaps;
// NEO: SCT END <-- Xanatos --