#pragma once

#include "Neo\GUI\DblScope.h" // NEO: PSM - [PlusSpeedMeter] <-- Xanatos --

#define IDC_TOOLBAR			16127
#define IDC_TOOLBARBUTTON	16129

#define	TBBTN_CONNECT	(IDC_TOOLBARBUTTON + 0)
#define	TBBTN_KAD		(IDC_TOOLBARBUTTON + 1)
#define	TBBTN_SERVER	(IDC_TOOLBARBUTTON + 2)
#define	TBBTN_TRANSFERS	(IDC_TOOLBARBUTTON + 3)
#define	TBBTN_SEARCH	(IDC_TOOLBARBUTTON + 4)
#define	TBBTN_SHARED	(IDC_TOOLBARBUTTON + 5)
#define	TBBTN_MESSAGES	(IDC_TOOLBARBUTTON + 6)
#define	TBBTN_IRC		(IDC_TOOLBARBUTTON + 7)
#define	TBBTN_STATS		(IDC_TOOLBARBUTTON + 8)
#define	TBBTN_OPTIONS	(IDC_TOOLBARBUTTON + 9)
#define	TBBTN_TOOLS		(IDC_TOOLBARBUTTON + 10)
#define	TBBTN_HELP		(IDC_TOOLBARBUTTON + 11)
#ifdef VOODOO // NEO: VOODOO - [UniversalPartfileInterface] -- Xanatos -->
#define	TBBTN_VOODOO	(IDC_TOOLBARBUTTON + 12)
#endif // VOODOO // NEO: VOODOO END <-- Xanatos --

#define	MULE_TOOLBAR_BAND_NR	0

// NEO: CTB - [CoolToolBar] -- Xanatos --
// moved form the MuleStatusbarCtrl.cpp
#define	NUM_BUTTON_BITMAPS	14

#define	EMULTB_BASEEXT		_T("eMuleToolbar.kad02")

static const LPCTSTR _apszTBFiles[] = 
{
	_T("*.") EMULTB_BASEEXT _T(".bmp"),
	_T("*.") EMULTB_BASEEXT _T(".gif"),
	_T("*.") EMULTB_BASEEXT _T(".png")
};

static const LPCTSTR _apszSkinFiles[] = 
{
	_T("*.") EMULSKIN_BASEEXT _T(".ini"),
};

#define	MAX_TOOLBAR_FILES	100
#define	MAX_SKIN_FILES		100
// NEO: CTB END -- Xanatos --

// NEO: CTB - [CoolToolBar] -- Xanatos -->
class CVirtualToolbarCtrl 
{
public:
	CVirtualToolbarCtrl() {}
	virtual ~CVirtualToolbarCtrl() {}

	virtual bool			IsCoolToolbar() {return false;}
	virtual	CWnd*			GetWnd() = 0;
	virtual BOOL			SetButtonInfo(int nID, TBBUTTONINFO* ptbbi) = 0;
	virtual	int				GetButtonCount() const = 0;
	virtual	UINT			CommandToIndex(UINT nID) const = 0;
	virtual BOOL			GetButton(int nIndex, LPTBBUTTON lpButton) const = 0;
	virtual void			PressMuleButton(int nID) = 0;
	virtual void			Localize(void) = 0;
	virtual	BOOL			MapAccelerator(TCHAR chAccel, UINT* pIDBtn) = 0;

	// NEO: PSM - [PlusSpeedMeter] -- Xanatos -->
	virtual void			SetSpeedMeterRange(int iValue1, int iValue2) = 0;
	virtual void			SetSpeedMeterValues(int iValue1, int iValue2) = 0;
	virtual void			ShowSpeedMeter(bool bShow) = 0;
	virtual bool			IsSpeedMeterEnabled() const = 0;
	// NEO: PSM END <-- Xanatos --

	virtual BOOL Create(DWORD dwStyle, const RECT& rect, CWnd* pParentWnd, UINT nID) = 0;
};
// NEO: CTB - [CoolToolBar] <-- Xanatos --

enum EToolbarLabelType {
	NoLabels	= 0,
	LabelsBelow = 1,
	LabelsRight = 2
};

class CMuleToolbarCtrl : public CToolBarCtrl, CVirtualToolbarCtrl // NEO: CTB - [CoolToolBar] <-- Xanatos --
{
	DECLARE_DYNAMIC(CMuleToolbarCtrl)

public:
	CMuleToolbarCtrl();
	virtual ~CMuleToolbarCtrl();

	void Init();
	void Localize();
	void Refresh();
	void SaveCurHeight();
	void UpdateBackground();
	void PressMuleButton(int nID);

	static int GetDefaultLabelType() { return (int)LabelsBelow; }

	// NEO: CTB - [CoolToolBar] -- Xanatos -->
	CWnd* GetWnd() {return this;}
	int  GetButtonCount() const {return CToolBarCtrl::GetButtonCount();}
	UINT CommandToIndex(UINT nID) const {return CToolBarCtrl::CommandToIndex(nID);}
	BOOL GetButton(int nIndex, LPTBBUTTON lpButton) const {return CToolBarCtrl::GetButton(nIndex,lpButton);}
	BOOL SetButtonInfo(int nID, TBBUTTONINFO* ptbbi) {return CToolBarCtrl::SetButtonInfo(nID,ptbbi);}
	BOOL MapAccelerator(TCHAR chAccel, UINT* pIDBtn) {return CToolBarCtrl::MapAccelerator(chAccel, pIDBtn);}
	BOOL Create(DWORD dwStyle, const RECT& rect, CWnd* pParentWnd, UINT nID) {return CToolBarCtrl::Create(dwStyle, rect, pParentWnd, nID);}
	// NEO: CTB END <-- Xanatos --

	// NEO: PSM - [PlusSpeedMeter] -- Xanatos -->
	void SetSpeedMeterRange(int iValue1, int iValue2){
														int iMaxRange = iValue2;
														if (iValue1 > iMaxRange)
															iMaxRange = iValue1;
														UINT nLastMaxRange, nLastMinRange;
														m_ctrlSpeedMeter.GetRange(nLastMaxRange, nLastMinRange);
														if ((int)nLastMaxRange != iMaxRange)
															m_ctrlSpeedMeter.SetRange(iMaxRange, nLastMinRange);
													}
	void SetSpeedMeterValues(int iValue1, int iValue2)	{ m_ctrlSpeedMeter.AddValues(iValue1/1024,iValue2/1024); }
	void ShowSpeedMeter(bool bShow);
	bool IsSpeedMeterEnabled() const					{ return m_bUseSpeedMeter == TRUE; }
	// NEO: PSM END <-- Xanatos --

protected:
	CSize		m_sizBtnBmp;
	int			m_iPreviousHeight;
	int			m_iLastPressedButton;
	int			m_buttoncount;
#ifdef VOODOO // NEO: VOODOO - [UniversalPartfileInterface] -- Xanatos -->
	TBBUTTON	TBButtons[13];
	TCHAR		TBStrings[13][200];
#else
	TBBUTTON	TBButtons[12];
	TCHAR		TBStrings[12][200];
#endif // VOODOO // NEO: VOODOO END <-- Xanatos --
	CStringArray m_astrToolbarPaths;
	EToolbarLabelType m_eLabelType;
	CStringArray m_astrSkinPaths;
	CBitmap		m_bmpBack;

	// NEO: PSM - [PlusSpeedMeter] -- Xanatos -->
	CDblScope		m_ctrlSpeedMeter;
	bool			m_bUseSpeedMeter;
	// NEO: PSM END <-- Xanatos --

	void ChangeToolbarBitmap(const CString& rstrPath, bool bRefresh);
	void ChangeTextLabelStyle(EToolbarLabelType eLabelType, bool bRefresh, bool bForceUpdateButtons = false);
	void UpdateIdealSize();
	void SetAllButtonsStrings();
	void SetAllButtonsWidth();
	void ForceRecalcLayout();

#ifdef _DEBUG
	void Dump();
#endif

	void AutoSize();
	virtual	BOOL OnCommand(WPARAM wParam, LPARAM lParam);

	DECLARE_MESSAGE_MAP()
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnSysColorChange();
	afx_msg void OnNMRclick(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnTbnQueryDelete(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnTbnQueryInsert(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnTbnGetButtonInfo(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnTbnToolbarChange(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnTbnReset(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnTbnInitCustomize(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnTbnEndAdjust(NMHDR* pNMHDR, LRESULT* pResult);
};
