//this file is part of eMule
//Copyright (C)2002 Merkur ( devs@emule-project.net / http://www.emule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#pragma once
#include "EncryptedStreamSocket.h"
#include "OtherFunctions.h"
#include "ThrottledSocket.h" // ZZ:UploadBandWithThrottler (UDP)
#include "Neo/NeoDebugC.h" // NEO: ND - [NeoDebug] <-- Xanatos --

class Packet;
#ifdef NEO_DBT // NEO: NDBT - [NeoDownloadBandwidthThrottler] -- Xanatos -->
class CReceiveData;
#endif // NEO_DBT // NEO: NDBT END <-- Xanatos --
#ifdef NATTUNNELING // NEO: UTCP - [UserModeTCP] -- Xanatos -->
class CAbstractSocket;
#else
class CAsyncProxySocketLayer;
#endif //NATTUNNELING // NEO: UTCP END <-- Xanatos --

#define	ES_DISCONNECTED		0xFF
#define	ES_NOTCONNECTED		0x00
#define	ES_CONNECTED		0x01

#define PACKET_HEADER_SIZE	6

struct StandardPacketQueueEntry {
    uint32 actualPayloadSize;
    Packet* packet;
};

#if !defined DONT_USE_SOCKET_BUFFERING // NEO: DSB - [DynamicSocketBuffer] -- Xanatos -->
struct BufferedPacket {
	UINT	remainpacketsize;
	UINT	packetpayloadsize;
	bool	iscontrolpacket;
	bool	isforpartfile;
};
#endif // NEO: DSB - [DynamicSocketBuffer] <-- Xanatos --

#ifdef NATTUNNELING // NEO: UTCP - [UserModeTCP] -- Xanatos -->
class CEMSocket : public CObject, public ThrottledFileSocket // ZZ:UploadBandWithThrottler (UDP)
#else
class CEMSocket : public CEncryptedStreamSocket, public ThrottledFileSocket // ZZ:UploadBandWithThrottler (UDP)
#endif //NATTUNNELING // NEO: UTCP END <-- Xanatos --
{
	DECLARE_DYNAMIC(CEMSocket)

public:
#ifdef NATTUNNELING // NEO: UTCP - [UserModeTCP] -- Xanatos -->
	CEMSocket(bool bNatSocket = false);
#else
	CEMSocket();
#endif //NATTUNNELING // NEO: UTCP END <-- Xanatos --
	virtual ~CEMSocket();

#ifdef NEO_UBT // NEO: NUBT - [NeoUploadBandwidthThrottler] -- Xanatos -->
	virtual void 	SendPacket(Packet* packet, bool delpacket = true, bool controlpacket = true, uint32 actualPayloadSize = 0);
#else
	virtual void 	SendPacket(Packet* packet, bool delpacket = true, bool controlpacket = true, uint32 actualPayloadSize = 0, bool bForceImmediateSend = false);
#endif // NEO_UBT // NEO: NUBT END <-- Xanatos --
    bool	IsConnected() const			{return byConnected == ES_CONNECTED;}
//#ifdef NEO_DBT // NEO: NDBT - [NeoDownloadBandwidthThrottler] -- Xanatos -->
//	void	SetConnected()				{byConnected = ES_CONNECTED;}
//#endif // NEO_DBT // NEO: NDBT END <-- Xanatos --
	uint8	GetConState() const			{return byConnected;}
	virtual bool IsRawDataMode() const	{ return false; }
	void	SetDownloadLimit(uint32 limit);
	void	DisableDownloadLimit();
	bool	IsDownloadLimit()			{ return downloadLimitEnable; } // NEO: DKA - [DownloadKeepAlive] <-- Xanatos --
	BOOL	AsyncSelect(long lEvent);
	// NEO: NDBT - [NeoDownloadBandwidthThrottler] -- Xanatos -->
	void	ReceiveData();
	void	ProcessReceivedData(char *rptr,const char *rend, bool &bPacketResult);
#ifdef NEO_DBT 
	void	SetPriorityReceive(UINT is) {priorityReceive = is;}
	bool	IsPriorityReceive() {return priorityReceive == TRUE;}
	bool	IsImmediateReceive() {return priorityReceive == 2;}

	virtual int Receive(uint32 size);
	bool	ProcessData(bool ignore = false);

	virtual bool IsEmpty() const {return (pendingOnReceive == false);}
#endif // NEO_DBT 
	// NEO: NDBT END <-- Xanatos --
#ifdef NEO_UBT // NEO: NUBT - [NeoUploadBandwidthThrottler] -- Xanatos -->
	bool	ControlPacketQueueIsEmpty() const;
	bool	StandardPacketQueueIsEmpty() const;

   	//DWORD	GetBusyTimeSince() { return m_dwBusy; }; //MORPH - Added by SiRoB, Show busyTime
	//float	GetBusyRatioTime() { return (float)(m_dwBusyDelta+(m_dwBusy?GetTickCount()-m_dwBusy:0))/(1+m_dwBusyDelta+(m_dwBusy?GetTickCount()-m_dwBusy:0)+m_dwNotBusyDelta+(m_dwNotBusy?GetTickCount()-m_dwNotBusy:0)); };
 #if !defined DONT_USE_SOCKET_BUFFERING // NEO: DSB - [DynamicSocketBuffer]
	void	SetSocketBufferLimit(uint32 limit) { bufferlimit = limit; }

	void	SetSendBufferSize(uint32 SendBufferSize = 0);
	void	SetRecvBufferSize(uint32 RecvBufferSize = 0);
	uint32	GetSendBufferSize() { return m_uCurrentSendBufferSize; };
	uint32	GetRecvBufferSize() { return m_uCurrentRecvBufferSize; };

	//DWORD	GetRTT() { return m_bRTTAvailable?m_dwRTT:(DWORD)-1; };
	//DWORD	GetRTTo() { return m_bRTToAvailable?m_dwRTTo:(DWORD)-1; };
 #endif // NEO: DSB - [DynamicSocketBuffer]	

	bool	IsSending() const { return (sendbuffer != NULL);}
	//bool	HasBlock() {return (standartpacket_queue.GetCount() != 0);}
	//bool	HasControlPacket() {return (controlpacket_queue.GetCount() != 0);}
	void	SetPrioritySend(UINT is) {prioritySend = is;}
	bool	IsPrioritySend() {return prioritySend == TRUE;}
	bool	IsImmediateSend() {return prioritySend == 2;}
#endif // NEO_UBT // NEO: NUBT END <-- Xanatos --
	virtual bool IsBusy() const			{return m_bBusy;}
    virtual bool HasQueues() const		{return (sendbuffer || standartpacket_queue.GetCount() > 0 || controlpacket_queue.GetCount() > 0);} // not trustworthy threaded? but it's ok if we don't get the correct result now and then

    uint32	GetNextFragSize(uint32 current, uint32 minFragSize);
    bool    HasSent() { return m_hasSent; }

	virtual UINT GetTimeOut() const;
	virtual void SetTimeOut(UINT uTimeOut);

	virtual BOOL Connect(LPCSTR lpszHostAddress, UINT nHostPort);
	virtual BOOL Connect(SOCKADDR* pSockAddr, int iSockAddrLen);

#ifdef NATTUNNELING // NEO: UTCP - [UserModeTCP] -- Xanatos -->
	virtual void Close();
	BOOL GetPeerName(SOCKADDR* lpSockAddr, int* lpSockAddrLen);
#else
	virtual void Close() { CAsyncSocketEx::Close(); }
#endif //NATTUNNELING // NEO: UTCP END <-- Xanatos --

#ifndef NATTUNNELING // NEO: UTCP <-- Xanatos --
	void InitProxySupport();
	virtual void RemoveAllLayers();
	const CString GetLastProxyError() const { return m_strLastProxyError; }
	bool GetProxyConnectFailed() const { return m_bProxyConnectFailed; }
#endif //NATTUNNELING // NEO: UTCP END <-- Xanatos --

	CString GetFullErrorMessage(DWORD dwError);

	DWORD GetLastCalledSend() { return lastCalledSend; }

    uint64 GetSentBytesCompleteFileSinceLastCallAndReset();
    uint64 GetSentBytesPartFileSinceLastCallAndReset();
    uint64 GetSentBytesControlPacketSinceLastCallAndReset();
    uint64 GetSentPayloadSinceLastCallAndReset();
    void TruncateQueues();

#ifdef NEO_UBT // NEO: NUBT - [NeoUploadBandwidthThrottler] -- Xanatos -->
    virtual SocketSentBytes Send(uint32 maxNumberOfBytesToSend, uint32 minFragSize, bool onlyAllowedToSendControlPacket = false, uint16 maxNumberOfPacketsToSend = 0xFFFF);
#else
    virtual SocketSentBytes SendControlData(uint32 maxNumberOfBytesToSend, uint32 minFragSize) { return Send(maxNumberOfBytesToSend, minFragSize, true); };
    virtual SocketSentBytes SendFileAndControlData(uint32 maxNumberOfBytesToSend, uint32 minFragSize) { return Send(maxNumberOfBytesToSend, minFragSize, false); };
#endif // NEO_UBT // NEO: NUBT END <-- Xanatos --

    uint32	GetNeededBytes();

#ifdef _DEBUG
	// Diagnostic Support
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

#ifdef NATTUNNELING // NEO: UTCP - [UserModeTCP] -- Xanatos -->
	CAbstractSocket* m_Socket;
#endif //NATTUNNELING // NEO: UTCP END <-- Xanatos --

protected:
#ifdef NATTUNNELING // NEO: UTCP - [UserModeTCP] -- Xanatos -->
	friend class	CTCPSocket;
	friend class	CNATSocket;
#endif //NATTUNNELING // NEO: UTCP END <-- Xanatos --
	
#ifdef NEO_DBT // NEO: NDBT - [NeoDownloadBandwidthThrottler] -- Xanatos -->
	virtual bool	DataReceived(const BYTE* pcData, UINT uSize);
#else
	virtual void	DataReceived(const BYTE* pcData, UINT uSize);
#endif // NEO_DBT // NEO: NDBT END <-- Xanatos --
	virtual bool	PacketReceived(Packet* packet) = 0;
	virtual void	OnError(int nErrorCode) = 0;
	virtual void	OnClose(int nErrorCode);
#ifdef NEO_BC // NEO: NBC - [NeoBandwidthControl] -- Xanatos -->
	virtual void	OnConnect(int nErrorCode);
#endif // NEO_BC // NEO: NBC END <-- Xanatos --
	virtual void	OnSend(int nErrorCode);	
	virtual void	OnReceive(int nErrorCode);

	uint8	byConnected;
	UINT	m_uTimeOut;

#ifndef NATTUNNELING // NEO: UTCP <-- Xanatos --
	virtual int	OnLayerCallback(const CAsyncSocketExLayer *pLayer, int nType, int nCode, WPARAM wParam, LPARAM lParam);

	bool	m_bProxyConnectFailed;
	CAsyncProxySocketLayer* m_pProxyLayer;
	CString m_strLastProxyError;
#endif //NATTUNNELING // NEO: UTCP END <-- Xanatos --

#ifdef NEO_DBT // NEO: NDBT - [NeoDownloadBandwidthThrottler] -- Xanatos -->
	CTypedPtrList<CPtrList, CReceiveData*> downloaddata_queue;
    CCriticalSection2 receiveLocker; // NEO: ND - [NeoDebug]
#endif // NEO_DBT // NEO: NDBT END <-- Xanatos --

private:
#ifndef NEO_UBT // NEO: NUBT -- Xanatos -->
    virtual SocketSentBytes Send(uint32 maxNumberOfBytesToSend, uint32 minFragSize, bool onlyAllowedToSendControlPacket);
#endif // NEO_UBT // NEO: NUBT END <-- Xanatos --
	void	ClearQueues();	
	virtual int Receive(void* lpBuf, int nBufLen, int nFlags = 0);

	// Download (pseudo) rate control	
	uint32	downloadLimit;
	bool	downloadLimitEnable;
	bool	pendingOnReceive;

	// Download partial header
	char	pendingHeader[PACKET_HEADER_SIZE];	// actually, this holds only 'PACKET_HEADER_SIZE-1' bytes.
	uint32	pendingHeaderSize;

	// Download partial packet
	Packet* pendingPacket;
	uint32  pendingPacketSize;

	// Upload control
	char*	sendbuffer;
#if !defined DONT_USE_SOCKET_BUFFERING // NEO: DSB - [DynamicSocketBuffer] -- Xanatos -->
	//DWORD	m_dwlastOnSendTick;
	//DWORD	m_dwRTTo;
	//bool	m_bRTToAvailable;
	//DWORD	m_dwRTT;
	//bool	m_bRTTAvailable;
	uint32	m_uCurrentRecvBufferSize;
	uint32	m_uCurrentSendBufferSize;
	uint32 currentBufferSize;
#endif // NEO: DSB - [DynamicSocketBuffer] <-- Xanatos --
	uint32	sendblen;
	uint32	sent;

	CTypedPtrList<CPtrList, Packet*> controlpacket_queue;
	CList<StandardPacketQueueEntry> standartpacket_queue;
#if !defined DONT_USE_SOCKET_BUFFERING // NEO: DSB - [DynamicSocketBuffer] -- Xanatos -->
	CList<BufferedPacket*> m_currentPacket_in_buffer_list;
#else
	bool m_currentPacket_is_controlpacket;
	bool m_currentPackageIsFromPartFile;
#endif // NEO: DSB - [DynamicSocketBuffer] <-- Xanatos --
    CCriticalSection2 sendLocker; // NEO: ND - [NeoDebug] <-- Xanatos --
    uint64 m_numberOfSentBytesCompleteFile;
    uint64 m_numberOfSentBytesPartFile;
    uint64 m_numberOfSentBytesControlPacket;
	bool m_bAccelerateUpload;
    DWORD lastCalledSend;
    DWORD lastSent;
	uint32 lastFinishedStandard;
#if !defined DONT_USE_SOCKET_BUFFERING // NEO: DSB - [DynamicSocketBuffer] -- Xanatos -->
	uint32 sendblenWithoutControlPacket; //Used to know if a controlpacket is already buffered
	uint32 bufferlimit;
#else
	uint32 m_actualPayloadSize;
#endif // NEO: DSB - [DynamicSocketBuffer] <-- Xanatos --
    uint32 m_actualPayloadSizeSent;
    bool m_bBusy;
    bool m_hasSent;
#ifdef NEO_DBT // NEO: NDBT - [NeoDownloadBandwidthThrottler] -- Xanatos -->
    UINT	priorityReceive;
#endif // NEO_DBT // NEO: NDBT END <-- Xanatos --
#ifdef NEO_UBT // NEO: NUBT - [NeoUploadBandwidthThrottler] -- Xanatos -->
    UINT	prioritySend;
#endif // NEO_UBT // NEO: NUBT END <-- Xanatos --

	// NEO: NUBT - [NeoUploadBandwidthThrottler] -- Xanatos -->
	//DWORD m_dwBusy;
	//DWORD m_dwBusyDelta;
    //DWORD m_dwNotBusy;
	//DWORD m_dwNotBusyDelta;
	// NEO: NUBT END <-- Xanatos --
};
