//this file is part of eMule
//Copyright (C)2002 Merkur ( devs@emule-project.net / http://www.emule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#include "stdafx.h"
#include "emule.h"
#include "DownloadListCtrl.h"
#include "otherfunctions.h" 
#include "updownclient.h"
#include "MenuCmds.h"
#include "ClientDetailDialog.h"
#include "FileDetailDialog.h"
#include "commentdialoglst.h"
#include "MetaDataDlg.h"
#include "InputBox.h"
#include "KademliaWnd.h"
#include "emuledlg.h"
#include "DownloadQueue.h"
#include "FriendList.h"
#include "PartFile.h"
#include "ClientCredits.h"
#include "MemDC.h"
#include "ChatWnd.h"
#include "TransferWnd.h"
#include "Kademlia/Kademlia/Kademlia.h"
#include "Kademlia/Kademlia/Prefs.h"
#include "Kademlia/net/KademliaUDPListener.h"
#include "WebServices.h"
#include "Preview.h"
#include "StringConversion.h"
#include "AddSourceDlg.h"
#include "ToolTipCtrlX.h"
#include "CollectionViewDialog.h"
#include "SearchDlg.h"
#include "SharedFileList.h"
#include "Neo/GUI/FilePreferencesDialog.h" // NEO: FCFG - [FileConfiguration] <-- Xanatos --
#include "Neo/Functions.h" // NEO: MOD <-- Xanatos --
#include "friend.h" // NEO: MOD - [NeoMenus] <-- Xanatos --
#include "Neo/NeoOpCodes.h"// NEO: NXI - [NeoExtraInfo] <-- Xanatos --
#include "Neo/Edt.h" // NEO: EDT - [EstimatedDownloadTime] <-- Xanatos --
#ifdef NEO_CD // NEO: NCD - [NeoClientDatabase] -- Xanatos -->
#include "Neo/SourceList.h"
#endif // NEO_CD // NEO: NCD END <-- Xanatos --
#ifdef ARGOS // NEO: NA - [NeoArgos] -- Xanatos -->
#include "Neo/Argos.h"
#endif // ARGOS // NEO: NA END <-- Xanatos --
#ifdef VOODOO // NEO: VOODOO - [UniversalPartfileInterface] -- Xanatos -->
#include "Neo/voodoo.h"
#endif // VOODOO // NEO: VOODOO END <-- Xanatos --
#include "Neo/ClientFileStatus.h"// NEO: SCFS - [SmartClientFileStatus] <-- Xanatos --
#include "Neo/GUI/MassRename.h" // NEO: MMR - [MorphMassRemane] <-- Xanatos --
#include "uploadqueue.h" // NEO: NMFS - [NiceMultiFriendSlots] <-- Xanatos --
#include "SafeFile.h"// NEO: FCFG - [FileConfiguration] <-- Xanatos --

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


// CDownloadListCtrl

#define DLC_DT_TEXT (DT_LEFT|DT_SINGLELINE|DT_VCENTER|DT_NOPREFIX|DT_END_ELLIPSIS)
#define DLC_BARUPDATE 512

#define	FILE_ITEM_MARGIN_X	4
#define RATING_ICON_WIDTH	16


IMPLEMENT_DYNAMIC(CtrlItem_Struct, CObject)

IMPLEMENT_DYNAMIC(CDownloadListCtrl, CMuleListCtrl)

BEGIN_MESSAGE_MAP(CDownloadListCtrl, CMuleListCtrl)
	ON_WM_CONTEXTMENU()
	ON_WM_SYSCOLORCHANGE()
	ON_NOTIFY_REFLECT(LVN_ITEMACTIVATE, OnItemActivate)
	ON_NOTIFY_REFLECT(LVN_ITEMCHANGED, OnListModified)
	ON_NOTIFY_REFLECT(LVN_INSERTITEM, OnListModified)
	ON_NOTIFY_REFLECT(LVN_DELETEITEM, OnListModified)
	ON_NOTIFY_REFLECT(LVN_COLUMNCLICK, OnColumnClick)
	ON_NOTIFY_REFLECT(NM_CLICK, OnClickDownloadlist) // NEO: NTS - [NeoTreeStyle] <-- Xanatos --
	ON_NOTIFY_REFLECT(NM_DBLCLK, OnNMDblclkDownloadlist)
	ON_NOTIFY_REFLECT(LVN_GETDISPINFO, OnGetDispInfo)
	//ON_NOTIFY_REFLECT(LVN_GETINFOTIP, OnLvnGetInfoTip) // NEO: NTT - [NewToolTips] <-- Xanatos --
END_MESSAGE_MAP()

CDownloadListCtrl::CDownloadListCtrl()
	: CDownloadListListCtrlItemWalk(this)
{
	//m_tooltip = new CToolTipCtrlX; // NEO: NTT - [NewToolTips] <-- Xanatos --
	//SetGeneralPurposeFind(true, false); // NEO: LF - [ListFind] <-- Xanatos --
}

CDownloadListCtrl::~CDownloadListCtrl()
{
	if (m_PrioMenu)
		VERIFY( m_PrioMenu.DestroyMenu() );
	// NEO: MOD - [NeoMenus] -- Xanatos -->
	if (m_ConfigMenu) 
		VERIFY( m_ConfigMenu.DestroyMenu() ); // NEO: FCFG - [FileConfiguration]
	if (m_UpPrioMenu) 
		VERIFY( m_UpPrioMenu.DestroyMenu() ); 
	if (m_PermMenu) 
		VERIFY(m_PermMenu.DestroyMenu() ); // NEO: SSP - [ShowSharePermissions]
	if (m_PWProtMenu) 
		VERIFY( m_PWProtMenu.DestroyMenu() ); // NEO: PP - [PasswordProtection]
	if (m_CollectMenu) 
		VERIFY( m_CollectMenu.DestroyMenu() ); // NEO: MSH - [ManualSourceHandling]
    if (m_SourcesMenu)
		VERIFY( m_SourcesMenu.DestroyMenu() );
	if (m_ReaskMenu) 
		VERIFY( m_ReaskMenu.DestroyMenu() ); // NEO: MDR - [ManualDownloadReask]
	if (m_A4AFMenu)
		VERIFY( m_A4AFMenu.DestroyMenu() );  // NEO: MCM - [ManualClientManagement]
	if (m_DropMenu) 
		VERIFY( m_DropMenu.DestroyMenu() ); // NEO: MDS - [ManualDropSources]
	if (m_TempDirMenu) 
		VERIFY( m_TempDirMenu.DestroyMenu() ); // NEO: MTD - [MultiTempDirectories]
	// NEO: MOD END <-- Xanatos --
	if (m_FileMenu)
		VERIFY( m_FileMenu.DestroyMenu() );
	
	while (m_ListItems.empty() == false) {
		delete m_ListItems.begin()->second; // second = CtrlItem_Struct*
		m_ListItems.erase(m_ListItems.begin());
	}
	//delete m_tooltip; // NEO: NTT - [NewToolTips] <-- Xanatos --
}

void CDownloadListCtrl::Init()
{
	SetName(_T("DownloadListCtrl"));
	CImageList ilDummyImageList; //dummy list for getting the proper height of listview entries
	ilDummyImageList.Create(1, theApp.GetSmallSytemIconSize().cy, theApp.m_iDfltImageListColorFlags|ILC_MASK, 1, 1); 
	SetImageList(&ilDummyImageList, LVSIL_SMALL);
	ASSERT( (GetStyle() & LVS_SHAREIMAGELISTS) == 0 );
	ilDummyImageList.Detach();

	SetStyle();
	ModifyStyle(LVS_SINGLESEL,0);
	EnableDual(); // NEO: SEa - [SortAltExtension] <-- Xanatos --
	
	// NEO: NTT - [NewToolTips] -- Xanatos --
	/*CToolTipCtrl* tooltip = GetToolTips();
	if (tooltip){
		m_tooltip->SubclassWindow(*tooltip);
		tooltip->ModifyStyle(0, TTS_NOPREFIX);
		tooltip->SetDelayTime(TTDT_AUTOPOP, 20000);
		tooltip->SetDelayTime(TTDT_INITIAL, thePrefs.GetToolTipDelay()*1000);
	}*/

	InsertColumn(0,GetResString(IDS_DL_FILENAME),LVCFMT_LEFT, 260);
	InsertColumn(1,GetResString(IDS_DL_SIZE),LVCFMT_LEFT, 60);
	InsertColumn(2,GetResString(IDS_DL_TRANSF),LVCFMT_LEFT, 65);
	InsertColumn(3,GetResString(IDS_DL_TRANSFCOMPL),LVCFMT_LEFT, 65);
	InsertColumn(4,GetResString(IDS_DL_SPEED),LVCFMT_LEFT, 65);
	InsertColumn(5,GetResString(IDS_DL_PROGRESS),LVCFMT_LEFT, 170);
	InsertColumn(6,GetResString(IDS_DL_SOURCES),LVCFMT_LEFT, 50);
	InsertColumn(7,GetResString(IDS_PRIORITY),LVCFMT_LEFT, 55);
	InsertColumn(8,GetResString(IDS_STATUS),LVCFMT_LEFT, 70);
	InsertColumn(9,GetResString(IDS_DL_REMAINS),LVCFMT_LEFT, 110);
	CString lsctitle=GetResString(IDS_LASTSEENCOMPL);
	lsctitle.Remove(_T(':'));
	InsertColumn(10, lsctitle,LVCFMT_LEFT, 220);
	lsctitle=GetResString(IDS_FD_LASTCHANGE);
	lsctitle.Remove(_T(':'));
	InsertColumn(11, lsctitle,LVCFMT_LEFT, 220);
#ifdef A4AF_CATS // NEO: MAC - [MorphA4AFCategories] -- Xanatos -->
	InsertColumn(12, GetResString(IDS_X_CAT_COLCATEGORY),LVCFMT_LEFT,60);
#else
	InsertColumn(12, GetResString(IDS_CAT) ,LVCFMT_LEFT, 100);
#endif // A4AF_CATS // NEO: MAC END <-- Xanatos --
	InsertColumn(13, GetResString(IDS_X_LIMIT_COL) ,LVCFMT_LEFT, 50); // NEO: AHL - [AutoHardLimit] <-- Xanatos --
	InsertColumn(14,GetResString(IDS_X_DL_FOLDER),LVCFMT_LEFT, 260); // NEO: MTD - [MultiTempDirectories] <-- Xanatos --
	InsertColumn(15,GetResString(IDS_X_DL_REMAINS_SIZE),LVCFMT_LEFT, 65); // NEO: MOD <-- Xanatos --
#ifdef A4AF_CATS // NEO: MAC - [MorphA4AFCategories] -- Xanatos -->
	InsertColumn(16, GetResString(IDS_X_CAT_COLORDER),LVCFMT_LEFT,60);
#endif // A4AF_CATS // NEO: MAC END <-- Xanatos --
#ifdef WEBCACHE // NEO: WC - [WebCache] -- Xanatos -->
	InsertColumn(17, GetResString(IDS_X_DL_WEBCACHE_CAPABLE) ,LVCFMT_LEFT, 100); //JP Webcache column
#endif // NEO: WC END <-- Xanatos --

	SetAllIcons();
	Localize();
	LoadSettings();
	curTab=0;

	//if (thePrefs.GetShowActiveDownloadsBold()) // NEO: FIX <-- Xanatos --
	CFont* pFont = GetFont();
	LOGFONT lfFont = {0};
	pFont->GetLogFont(&lfFont);
	lfFont.lfWeight = FW_BOLD;
	m_fontBold.CreateFontIndirect(&lfFont);

	// NEO: MOD - [Percentage] -- Xanatos -->
	lfFont.lfHeight = 11;
	lfFont.lfWeight = FW_NORMAL;
	m_fontSmall.CreateFontIndirect(&lfFont);
	// NEO: MOD END <-- Xanatos --

	// Barry - Use preferred sort order from preferences
	m_bRemainSort=thePrefs.TransferlistRemainSortStyle();

	uint8 adder=0;
	if ((GetSortItem()!=9 && GetSortItem()!=2 && (GetSortItem()!=3 || !IsAlternate())) || !m_bRemainSort ) // MOD - [SessionDL] <-- Xanatos --
		SetSortArrow();
	else {
		SetSortArrow(GetSortItem(), GetSortAscending()?arrowDoubleUp : arrowDoubleDown);
		// MOD - [SessionDL] -- Xanatos -->
		if(GetSortItem()==2)
			adder=18;
		else if(GetSortItem()==3 && IsAlternate())
			adder=27;
		else
		// MOD END <-- Xanatos --
			adder=81;
	}
	
	SortItems(SortProc, GetSortItem() + (GetSortAscending()? 0:100) + adder);
}

void CDownloadListCtrl::OnSysColorChange()
{
	CMuleListCtrl::OnSysColorChange();
	SetAllIcons();
	CreateMenues();
}

// NEO: NI - [NewIcons] -- Xanatos -->
enum EnumDownloadListIcons
{
	DL_BLANK = 0,

	DL_SRC_DOWNLOADING,
	DL_SRC_ON_QUEUE,
	DL_SRC_CONNECTING,
	DL_SRC_NNPFQ,
	DL_SRC_UNKNOWN,
	//DL_ClientCompatible,
	//DL_Friend,
	//DL_ClientEDonkey,
	//DL_ClientMLDonkey,
	DL_RatingReceived,
	DL_BadRatingReceived,
	//DL_ClientEDonkeyHybrid,
	//DL_ClientShareaza,
	//DL_Server,
	//DL_ClientAMule,
	//DL_ClientLPhant,
	//DL_ClientSecureOvl,

	// NEO: NCI - [NewClientIcons]
	DL_CLIENT_CDONKEY,
	DL_CLIENT_EDONKEY,
	DL_CLIENT_EMULE,
	DL_CLIENT_HYBRID,
	DL_CLIENT_MLDONKEY,
	DL_CLIENT_OLDEMULE,
	DL_CLIENT_SHAREAZA,
	DL_CLIENT_UNKNOWN,
	DL_CLIENT_XMULE,
	DL_CLIENT_AMULE,
	DL_CLIENT_LPHANT,
	DL_CLIENT_EMULEPLUS,
	DL_CLIENT_TRUSTYFILES,
	DL_CLIENT_HYDRANODE,
	DL_SERVER,
	// NEO: NCI END

	DL_CLIENT_NEO, // NEO: MID - [ModID]
	
	DL_CREDIT_UP,
	DL_CREDIT_DOWN,
	DL_CREDIT_UP_DOWN,

	DL_FRIEND_CLIENT,
	DL_FRIEND_SLOT_CLIENT,
	DL_COMMUNITY_CLIENT,

	DL_ARGOS_BANNED,
#ifdef ARGOS // NEO: NA - [NeoArgos]
	DL_ARGOS_BANNED_SOFT,
	DL_ARGOS_BANNED_SOFT2,
	DL_ARGOS_LEECHER,
#endif //ARGOS // NEO: NA END

	DL_SHOW_SHARED,
	DL_LOW_ID_CLIENT,
#ifdef LANCAST // NEO: NLC - [NeoLanCast]
	DL_LANCAST_CLIENT,
#endif //LANCAST // NEO: NLC END

	DL_SECUREHASH_BLUE,
	DL_SECUREHASH_GREEN,
	DL_SECUREHASH_YELLOW,
	DL_SECUREHASH_RED,

	DL_ICON_EXTENDED,
	DL_ICON_EXTENDED1,
	DL_ICON_EXTENDED2,
	DL_ICON_EXTENDED3,
	DL_ICON_EXTENDED4,
	DL_ICON_EXTENDED5,
	DL_ICON_EXTENDED6,
	DL_ICON_EXTENDED7,
	DL_ICON_EXTENDED8,
	DL_ICON_EXTENDED9,
	DL_ICON_EXTENDED10,
	DL_ICON_EXTENDED11,
	DL_ICON_EXTENDED12,

	// NEO: FSI - [FileStatusIcons]
	DL_STATUS_COMPLETE,
	DL_STATUS_COMPLETING,
	DL_STATUS_DOWNLOADING,
	DL_STATUS_IMPORTING, // NEO: PIX - [PartImportExport]
	DL_STATUS_ERRONEOUS,
	DL_STATUS_HASHING,	
	DL_STATUS_MOVING, // NEO: MTD - [MultiTempDirectories]
	DL_STATUS_PAUSED,
	DL_STATUS_STANDBY,
	DL_STATUS_SUSPEND,
	DL_STATUS_STALLED,
	DL_STATUS_STOPPED,
	DL_STATUS_WAITING,
	DL_STATUS_WAITINGHASH,
	// NEO: FSI END

	// NEO: XC - [ExtendedComments]
	DL_ICON_RATING_NOTRATED,
	DL_ICON_RATING_FAKE,
	DL_ICON_RATING_POOR,
	DL_ICON_RATING_FAIR,
	DL_ICON_RATING_GOOD,
	DL_ICON_RATING_EXCELLENT,
	DL_ICON_RATING_LOOKING,
	DL_ICON_RATING_LOCAL,
	// NEO: XC END

	DL_ICON_Obfu,

	DL_ICON_SECURITY, // NEO: PP - [PasswordProtection]

	DL_ICON_DISPARITY, // NEO: FDC - [FileNameDisparityCheck]
};
// NEO: NI END <-- Xanatos --

void CDownloadListCtrl::SetAllIcons()
{
	m_ImageList.DeleteImageList();
	m_ImageList.Create(16,16,theApp.m_iDfltImageListColorFlags|ILC_MASK,0,1);
	m_ImageList.SetBkColor(CLR_NONE);

	// NEO: NI - [NewIcons] -- Xanatos -->
	m_ImageList.Add(CTempIconLoader(_T("EMPTY")));
	m_ImageList.Add(CTempIconLoader(_T("SrcDownloading")));
	m_ImageList.Add(CTempIconLoader(_T("SrcOnQueue")));
	m_ImageList.Add(CTempIconLoader(_T("SrcConnecting")));
	m_ImageList.Add(CTempIconLoader(_T("SrcNNPQF")));
	m_ImageList.Add(CTempIconLoader(_T("SrcUnknown")));
	//m_ImageList.Add(CTempIconLoader(_T("ClientCompatible")));
	//m_ImageList.Add(CTempIconLoader(_T("Friend")));
	//m_ImageList.Add(CTempIconLoader(_T("ClientEDonkey")));
	//m_ImageList.Add(CTempIconLoader(_T("ClientMLDonkey")));
	m_ImageList.Add(CTempIconLoader(_T("RatingReceived")));
	m_ImageList.Add(CTempIconLoader(_T("BadRatingReceived")));
	//m_ImageList.Add(CTempIconLoader(_T("ClientEDonkeyHybrid")));
	//m_ImageList.Add(CTempIconLoader(_T("ClientShareaza")));
	//m_ImageList.Add(CTempIconLoader(_T("Server")));
	//m_ImageList.Add(CTempIconLoader(_T("ClientAMule")));
	//m_ImageList.Add(CTempIconLoader(_T("ClientLPhant")));
	//m_ImageList.SetOverlayImage(m_ImageList.Add(CTempIconLoader(_T("ClientSecureOvl"))), 1);

	// NEO: NCI - [NewClientIcons]
	m_ImageList.Add(CTempIconLoader(_T("CLIENT_CDONKEY")));
	m_ImageList.Add(CTempIconLoader(_T("CLIENT_EDONKEY")));
	m_ImageList.Add(CTempIconLoader(_T("CLIENT_EMULE")));
	m_ImageList.Add(CTempIconLoader(_T("CLIENT_HYBRID")));
	m_ImageList.Add(CTempIconLoader(_T("CLIENT_MLDONKEY")));
	m_ImageList.Add(CTempIconLoader(_T("CLIENT_OLDEMULE")));
	m_ImageList.Add(CTempIconLoader(_T("CLIENT_SHAREAZA")));
	m_ImageList.Add(CTempIconLoader(_T("CLIENT_UNKNOWN")));
	m_ImageList.Add(CTempIconLoader(_T("CLIENT_XMULE")));
	m_ImageList.Add(CTempIconLoader(_T("CLIENT_AMULE")));
	m_ImageList.Add(CTempIconLoader(_T("CLIENT_LPHANT")));
	m_ImageList.Add(CTempIconLoader(_T("CLIENT_EMULEPLUS")));
	m_ImageList.Add(CTempIconLoader(_T("CLIENT_TRUSTYFILES")));
	m_ImageList.Add(CTempIconLoader(_T("CLIENT_HYDRANODE")));
	m_ImageList.Add(CTempIconLoader(_T("SERVER")));
	// NEO: NCI END

	m_ImageList.Add(CTempIconLoader(_T("CLIENT_NEO"))); // NEO: MID - [ModID]
	
	m_ImageList.Add(CTempIconLoader(_T("CREDIT_UP")));
	m_ImageList.Add(CTempIconLoader(_T("CREDIT_DOWN")));
	m_ImageList.Add(CTempIconLoader(_T("CREDIT_UP_DOWN")));

	m_ImageList.Add(CTempIconLoader(_T("FRIEND_CLIENT")));
	m_ImageList.Add(CTempIconLoader(_T("FRIEND_SLOT_CLIENT")));
	m_ImageList.Add(CTempIconLoader(_T("COMMUNITY_CLIENT")));

	m_ImageList.Add(CTempIconLoader(_T("ARGOS_BANNED")));
#ifdef ARGOS // NEO: NA - [NeoArgos]
	m_ImageList.Add(CTempIconLoader(_T("ARGOS_BANNED_SOFT")));
	m_ImageList.Add(CTempIconLoader(_T("ARGOS_BANNED_SOFT2")));
	m_ImageList.Add(CTempIconLoader(_T("ARGOS_LEECHER")));
#endif //ARGOS // NEO: NA END

	m_ImageList.Add(CTempIconLoader(_T("SHOW_SHARED")));
	m_ImageList.Add(CTempIconLoader(_T("LOW_ID_CLIENT")));
#ifdef LANCAST // NEO: NLC - [NeoLanCast]
	m_ImageList.Add(CTempIconLoader(_T("LANCAST_CLIENT")));
#endif //LANCAST // NEO: NLC END

	m_ImageList.Add(CTempIconLoader(_T("SECUREHASH_BLUE")));
	m_ImageList.Add(CTempIconLoader(_T("SECUREHASH_GREEN")));
	m_ImageList.Add(CTempIconLoader(_T("SECUREHASH_YELLOW")));
	m_ImageList.Add(CTempIconLoader(_T("SECUREHASH_RED")));

	m_ImageList.Add(CTempIconLoader(_T("EXTENDED")));
	m_ImageList.Add(CTempIconLoader(_T("EXTENDED1")));
	m_ImageList.Add(CTempIconLoader(_T("EXTENDED2")));
	m_ImageList.Add(CTempIconLoader(_T("EXTENDED3")));
	m_ImageList.Add(CTempIconLoader(_T("EXTENDED4")));
	m_ImageList.Add(CTempIconLoader(_T("EXTENDED5")));
	m_ImageList.Add(CTempIconLoader(_T("EXTENDED6")));
	m_ImageList.Add(CTempIconLoader(_T("EXTENDED7")));
	m_ImageList.Add(CTempIconLoader(_T("EXTENDED8")));
	m_ImageList.Add(CTempIconLoader(_T("EXTENDED9")));
	m_ImageList.Add(CTempIconLoader(_T("EXTENDED10")));
	m_ImageList.Add(CTempIconLoader(_T("EXTENDED11")));
	m_ImageList.Add(CTempIconLoader(_T("EXTENDED12")));

	// NEO: FSI - [FileStatusIcons]
	m_ImageList.Add(CTempIconLoader(_T("STATUS_COMPLETE")));
	m_ImageList.Add(CTempIconLoader(_T("STATUS_COMPLETING")));
	m_ImageList.Add(CTempIconLoader(_T("STATUS_DOWNLOADING")));
	m_ImageList.Add(CTempIconLoader(_T("STATUS_IMPORTING"))); // NEO: PIX - [PartImportExport]
	m_ImageList.Add(CTempIconLoader(_T("STATUS_ERRONEOUS")));
	m_ImageList.Add(CTempIconLoader(_T("STATUS_HASHING")));
	m_ImageList.Add(CTempIconLoader(_T("STATUS_MOVING"))); // NEO: MTD - [MultiTempDirectories]
	m_ImageList.Add(CTempIconLoader(_T("STATUS_PAUSED")));
	m_ImageList.Add(CTempIconLoader(_T("STATUS_STANDBY")));
	m_ImageList.Add(CTempIconLoader(_T("STATUS_SUSPEND")));
	m_ImageList.Add(CTempIconLoader(_T("STATUS_STALLED")));
	m_ImageList.Add(CTempIconLoader(_T("STATUS_STOPPED")));
	m_ImageList.Add(CTempIconLoader(_T("STATUS_WAITING")));
	m_ImageList.Add(CTempIconLoader(_T("STATUS_WAITINGHASH")));
	// NEO: FSI END

	// NEO: XC - [ExtendedComments]
	m_ImageList.Add(CTempIconLoader(_T("RATING_NOTRATED")));
	m_ImageList.Add(CTempIconLoader(_T("RATING_FAKE")));
	m_ImageList.Add(CTempIconLoader(_T("RATING_POOR")));
	m_ImageList.Add(CTempIconLoader(_T("RATING_FAIR")));
	m_ImageList.Add(CTempIconLoader(_T("RATING_GOOD")));
	m_ImageList.Add(CTempIconLoader(_T("RATING_EXCELLENT")));
	m_ImageList.Add(CTempIconLoader(_T("Collection_Search"))); // rating for comments are searched on kad
	m_ImageList.Add(CTempIconLoader(_T("FileCommentsOvl")));
	// NEO: XC END

	m_ImageList.Add(CTempIconLoader(_T("OverlayObfu")));
	//m_ImageList.Add(CTempIconLoader(_T("OverlaySecureObfu")));

	m_ImageList.Add(CTempIconLoader(_T("PWPROT_USE"))); // NEO: PP - [PasswordProtection]

	m_ImageList.Add(CTempIconLoader(_T("FILENAMEDISPARITY"))); // NEO: FDC - [FileNameDisparityCheck]
	// NEO: NI END <-- Xanatos --
}

void CDownloadListCtrl::Localize()
{
	CHeaderCtrl* pHeaderCtrl = GetHeaderCtrl();
	HDITEM hdi;
	hdi.mask = HDI_TEXT;
	CString strRes;

	strRes = GetResString(IDS_DL_FILENAME);
	hdi.pszText = const_cast<LPTSTR>((LPCTSTR)strRes);
	pHeaderCtrl->SetItem(0, &hdi);

	strRes = GetResString(IDS_DL_SIZE);
	hdi.pszText = const_cast<LPTSTR>((LPCTSTR)strRes);
	pHeaderCtrl->SetItem(1, &hdi);

	strRes = GetResString(IDS_DL_TRANSF);
	hdi.pszText = const_cast<LPTSTR>((LPCTSTR)strRes);
	pHeaderCtrl->SetItem(2, &hdi);

	strRes = GetResString(IDS_DL_TRANSFCOMPL);
	hdi.pszText = const_cast<LPTSTR>((LPCTSTR)strRes);
	pHeaderCtrl->SetItem(3, &hdi);

	strRes = GetResString(IDS_DL_SPEED);
	hdi.pszText = const_cast<LPTSTR>((LPCTSTR)strRes);
	pHeaderCtrl->SetItem(4, &hdi);

	strRes = GetResString(IDS_DL_PROGRESS);
	hdi.pszText = const_cast<LPTSTR>((LPCTSTR)strRes);
	pHeaderCtrl->SetItem(5, &hdi);

	strRes = GetResString(IDS_DL_SOURCES);
	hdi.pszText = const_cast<LPTSTR>((LPCTSTR)strRes);
	pHeaderCtrl->SetItem(6, &hdi);

	strRes = GetResString(IDS_PRIORITY);
	hdi.pszText = const_cast<LPTSTR>((LPCTSTR)strRes);
	pHeaderCtrl->SetItem(7, &hdi);

	strRes = GetResString(IDS_STATUS);
	hdi.pszText = const_cast<LPTSTR>((LPCTSTR)strRes);
	pHeaderCtrl->SetItem(8, &hdi);

	strRes = GetResString(IDS_DL_REMAINS);
	hdi.pszText = const_cast<LPTSTR>((LPCTSTR)strRes);
	pHeaderCtrl->SetItem(9, &hdi);

	strRes = GetResString(IDS_LASTSEENCOMPL);
	strRes.Remove(_T(':'));
	hdi.pszText = const_cast<LPTSTR>((LPCTSTR)strRes);
	pHeaderCtrl->SetItem(10, &hdi);

	strRes = GetResString(IDS_FD_LASTCHANGE);
	strRes.Remove(_T(':'));
	hdi.pszText = const_cast<LPTSTR>((LPCTSTR)strRes);
	pHeaderCtrl->SetItem(11, &hdi);

#ifdef A4AF_CATS // NEO: MAC - [MorphA4AFCategories] -- Xanatos -->
	strRes = GetResString(IDS_X_CAT_COLCATEGORY);
	hdi.pszText = const_cast<LPTSTR>((LPCTSTR)strRes);
	pHeaderCtrl->SetItem(12, &hdi);
#else
	strRes = GetResString(IDS_CAT);
	hdi.pszText = const_cast<LPTSTR>((LPCTSTR)strRes);
	pHeaderCtrl->SetItem(12, &hdi);
#endif // A4AF_CATS // NEO: MAC END <-- Xanatos --

	// NEO: AHL - [AutoHardLimit] -- Xanatos -->
	strRes = GetResString(IDS_X_LIMIT_COL);
	hdi.pszText = const_cast<LPTSTR>((LPCTSTR)strRes);
	pHeaderCtrl->SetItem(13, &hdi);
	// NEO: AHL END <-- Xanatos --

	// NEO: MTD - [MultiTempDirectories] -- Xanatos -->
	strRes = GetResString(IDS_X_DL_FOLDER);
	hdi.pszText = const_cast<LPTSTR>((LPCTSTR)strRes);
	pHeaderCtrl->SetItem(14, &hdi);
	// NEO: MTD END <-- Xanatos --

	// NEO: MOD -- Xanatos -->
	strRes = GetResString(IDS_X_DL_REMAINS_SIZE);
	hdi.pszText = const_cast<LPTSTR>((LPCTSTR)strRes);
	pHeaderCtrl->SetItem(15, &hdi);
	// NEO: MOD END <-- Xanatos --

#ifdef A4AF_CATS // NEO: MAC - [MorphA4AFCategories] -- Xanatos -->
	strRes = GetResString(IDS_X_CAT_COLORDER);
	hdi.pszText = const_cast<LPTSTR>((LPCTSTR)strRes);
	pHeaderCtrl->SetItem(16, &hdi);
#endif // A4AF_CATS // NEO: MAC END <-- Xanatos --

	CreateMenues();

	ShowFilesCount();
}

void CDownloadListCtrl::AddFile(CPartFile* toadd)
{
	// Create new Item
    CtrlItem_Struct* newitem = new CtrlItem_Struct;
    int itemnr = GetItemCount();
    newitem->owner = NULL;
    newitem->type = FILE_TYPE;
    newitem->value = toadd;
    newitem->parent = NULL;
	newitem->dwUpdated = 0; 

	// The same file shall be added only once
	ASSERT(m_ListItems.find(toadd) == m_ListItems.end());
	m_ListItems.insert(ListItemsPair(toadd, newitem));

	if (toadd->CheckShowItemInGivenCat(curTab))
		InsertItem(LVIF_PARAM|LVIF_TEXT,itemnr,LPSTR_TEXTCALLBACK,0,0,0,(LPARAM)newitem);

	ShowFilesCount();
}

void CDownloadListCtrl::AddSource(CPartFile* owner, CUpDownClient* source, bool notavailable)
{
	// Create new Item
    CtrlItem_Struct* newitem = new CtrlItem_Struct;
    newitem->owner = owner;
    newitem->type = (notavailable) ? UNAVAILABLE_SOURCE : AVAILABLE_SOURCE;
    newitem->value = source;
	newitem->dwUpdated = 0; 

	// Update cross link to the owner
	ListItems::const_iterator ownerIt = m_ListItems.find(owner);
	ASSERT(ownerIt != m_ListItems.end());
	CtrlItem_Struct* ownerItem = ownerIt->second;
	ASSERT(ownerItem->value == owner);
	newitem->parent = ownerItem;

	// The same source could be added a few time but only one time per file 
	{
		// Update the other instances of this source
		bool bFound = false;
		std::pair<ListItems::const_iterator, ListItems::const_iterator> rangeIt = m_ListItems.equal_range(source);
		for(ListItems::const_iterator it = rangeIt.first; it != rangeIt.second; it++){
			CtrlItem_Struct* cur_item = it->second;

			// Check if this source has been already added to this file => to be sure
			if(cur_item->owner == owner){
				// Update this instance with its new setting
				cur_item->type = newitem->type;
				cur_item->dwUpdated = 0;
				bFound = true;
			}
			else if(notavailable == false){
				// The state 'Available' is exclusive
				cur_item->type = UNAVAILABLE_SOURCE;
				cur_item->dwUpdated = 0;
			}
		}

		if(bFound == true){
			delete newitem; 
			return;
		}
	}
	m_ListItems.insert(ListItemsPair(source, newitem));

	if (owner->srcarevisible) {
		// find parent from the CListCtrl to add source
		LVFINDINFO find;
		find.flags = LVFI_PARAM;
		find.lParam = (LPARAM)ownerItem;
		int result = FindItem(&find);
		if (result != -1)
			InsertItem(LVIF_PARAM|LVIF_TEXT,result+1,LPSTR_TEXTCALLBACK,0,0,0,(LPARAM)newitem);
	}
}

void CDownloadListCtrl::RemoveSource(CUpDownClient* source, CPartFile* owner)
{
	if (!theApp.emuledlg->IsRunning())
		return;

	// Retrieve all entries matching the source
	std::pair<ListItems::iterator, ListItems::iterator> rangeIt = m_ListItems.equal_range(source);
	for(ListItems::iterator it = rangeIt.first; it != rangeIt.second; ){
		CtrlItem_Struct* delItem  = it->second;
		if(owner == NULL || owner == delItem->owner){
			// Remove it from the m_ListItems			
			it = m_ListItems.erase(it);

			// Remove it from the CListCtrl
 			LVFINDINFO find;
			find.flags = LVFI_PARAM;
			find.lParam = (LPARAM)delItem;
			int result = FindItem(&find);
			if (result != -1)
				DeleteItem(result);

			// finally it could be delete
			delete delItem;
		}
		else{
			it++;
		}
	}
}

bool CDownloadListCtrl::RemoveFile(const CPartFile* toremove)
{
	bool bResult = false;
	if (!theApp.emuledlg->IsRunning())
		return bResult;
	// Retrieve all entries matching the File or linked to the file
	// Remark: The 'asked another files' clients must be removed from here
	ASSERT(toremove != NULL);
	// NEO: SEa - [SortAltExtension] -- Xanatos -->
	if(toremove->IsPartFile() && toremove->srcarevisible==true)
		SetAlternate(FALSE);
	// NEO: SEa END <-- Xanatos --
	for(ListItems::iterator it = m_ListItems.begin(); it != m_ListItems.end(); ){
		CtrlItem_Struct* delItem = it->second;
		if(delItem->owner == toremove || delItem->value == (void*)toremove){
			// Remove it from the m_ListItems
			it = m_ListItems.erase(it);

			// Remove it from the CListCtrl
			LVFINDINFO find;
			find.flags = LVFI_PARAM;
			find.lParam = (LPARAM)delItem;
			int result = FindItem(&find);
			if (result != -1)
				DeleteItem(result);

			// finally it could be delete
			delete delItem;
			bResult = true;
		}
		else {
			it++;
		}
	}
	ShowFilesCount();
	return bResult;
}

void CDownloadListCtrl::UpdateItem(void* toupdate)
{
	if (!theApp.emuledlg->IsRunning())
		return;

	// Retrieve all entries matching the source
	std::pair<ListItems::const_iterator, ListItems::const_iterator> rangeIt = m_ListItems.equal_range(toupdate);
	for(ListItems::const_iterator it = rangeIt.first; it != rangeIt.second; it++){
		CtrlItem_Struct* updateItem  = it->second;

		// Find entry in CListCtrl and update object
 		LVFINDINFO find;
		find.flags = LVFI_PARAM;
		find.lParam = (LPARAM)updateItem;
		int result = FindItem(&find);
		if (result != -1){
			updateItem->dwUpdated = 0;
			Update(result);
		}
	}
}

void CDownloadListCtrl::DrawFileItem(CDC *dc, int nColumn, LPCRECT lpRect, CtrlItem_Struct *lpCtrlItem, CString* lpText) // NEO: LF - [ListFind] <-- Xanatos --
{
	// NEO: LF - [ListFind] -- Xanatos -->
	UINT uDTFlags = DLC_DT_TEXT; 
	if(!lpText){ 
		if(lpRect->left >= lpRect->right)
			return;

		if(nColumn < 7 || nColumn >= 15)
			uDTFlags |= DT_RIGHT;
	}else if(nColumn == 0){
		*lpText = ((CPartFile*)lpCtrlItem->value)->GetFileName();
		return;
	}else if(nColumn == 5){
		return;
	}
	// NEO: LF END <-- Xanatos --

	// NEO: NI - [NewIcons] -- Xanatos -->
	int iIcon; 
	int PlusMinus=0;
	// NEO: NI END <-- Xanatos --
	CString buffer;
	CPartFile *lpPartFile = (CPartFile*)lpCtrlItem->value;
	switch(nColumn)
	{
	case 0:{	// file name
#ifdef A4AF_CATS // NEO: MAC - [MorphA4AFCategories] -- Xanatos -->
		// Show collor only when more categorys are shown together
		//if (!g_bLowColorDesktop && !thePrefs.GetCategory(curTab)->viewfilters.nFromCats) {
		if (!g_bLowColorDesktop && thePrefs.GetCategory(curTab)->viewfilters.nFromCats < 2) { // Lit Cat Filter
			DWORD dwCatColor = thePrefs.GetCatColor(lpPartFile->GetCategory());
			if (dwCatColor > 0)
				dc->SetTextColor(dwCatColor);
		}
#endif // A4AF_CATS // NEO: MAC END <-- Xanatos --

		CRect rcDraw(lpRect);

		// NEO: NTS - [NeoTreeStyle] -- Xanatos -->
		if(thePrefs.UseTreeStyle()){
			rcDraw.left += 14;
			PlusMinus += 14;
		}
		// NEO: NTS END <-- Xanatos --

		// NEO: NI - [NewIcons] -- Xanatos -->
		if (thePrefs.ShowFileTypeIcon()){
			int iImage = theApp.GetFileTypeSystemImageIdx(lpPartFile->GetFileName(true)); // NEO: PP - [PasswordProtection]
			if (theApp.GetSystemImageList() != NULL)
				::ImageList_Draw(theApp.GetSystemImageList(), iImage, dc->GetSafeHdc(), rcDraw.left-4, rcDraw.top+1, ILD_TRANSPARENT);
			rcDraw.left+=19;
			PlusMinus+=19;
		}

		// NEO: FSI - [FileStatusIcons]
		if (thePrefs.ShowFileStatusIcons()){
			switch (lpPartFile->GetPartFileStatus()){
				case PS_COMPLETING:
					iIcon = DL_STATUS_COMPLETING;
					break;
				case PS_COMPLETE:
					iIcon = DL_STATUS_COMPLETE;
					break;
				case PS_DOWNLOADING:
					iIcon = DL_STATUS_DOWNLOADING;
					break;
				// NEO: PIX - [PartImportExport]
				case PS_IMPORTING:
					iIcon = DL_STATUS_IMPORTING;
					break;
				// NEO: PIX EMD
				case PS_STANDBY:
					iIcon = DL_STATUS_STANDBY;
					break;
				case PS_SUSPEND:
					iIcon = DL_STATUS_SUSPEND;
					break;
				case PS_WAITINGFORSOURCE:
					iIcon = DL_STATUS_WAITING;
					break;
				// NEO: SSH - [SlugFillerSafeHash]
				//case PS_WAITINGFORHASH:
				//	iIcon = DL_STATUS_WAITINGHASH;
				//	break;
				case PS_HASHING:
					iIcon = DL_STATUS_HASHING;
					break;
				// NEO: SSH END
				// NEO: MTD - [MultiTempDirectories]
				case PS_MOVING:
					iIcon = DL_STATUS_MOVING;
					break;
				// NEO: MTD END
				case PS_PAUSED:
					iIcon = DL_STATUS_PAUSED;
					break;
				case PS_STALLED:
					iIcon = DL_STATUS_STALLED;
					break;
				case PS_STOPPED:
					iIcon = DL_STATUS_STOPPED;
					break;
				case PS_ERROR:
					iIcon = DL_STATUS_ERRONEOUS;
					break;
				default:
					iIcon = DL_STATUS_ERRONEOUS;
			}
			POINT ipoint= {rcDraw.left-5,rcDraw.top+1};
			m_ImageList.Draw(dc, iIcon, ipoint, ILD_NORMAL);

			rcDraw.left+=17;
			PlusMinus+=17;
		}
		// NEO: FSI END

		// NEO: XC - [ExtendedComments]
		if (thePrefs.ShowRatingIndicator()){
			POINT point = {rcDraw.left-6,rcDraw.top+2};
			if (lpPartFile->HasComment() || lpPartFile->HasRating() || lpPartFile->IsKadCommentSearchRunning())
				m_ImageList.Draw(dc, DL_ICON_RATING_NOTRATED + lpPartFile->UserRating(true), point, ILD_NORMAL);
			
			POINT point2 = {rcDraw.left-6,rcDraw.top};
			if (!lpPartFile->GetFileComment().IsEmpty() || lpPartFile->GetFileRating())
				m_ImageList.Draw(dc, DL_ICON_RATING_LOCAL, point2, ILD_TRANSPARENT);

			if (thePrefs.UseTreeStyle() 
			 || lpPartFile->HasComment() || lpPartFile->HasRating() || lpPartFile->IsKadCommentSearchRunning()
			 || lpPartFile->GetFileRating() || !lpPartFile->GetFileComment().IsEmpty()){
				rcDraw.left+=10;
				PlusMinus+=10;
			}
		}
		// NEO: XC END

		// NEO: FDC - [FileNameDisparityCheck]
		if(thePrefs.UseFileCheck() && lpPartFile->DissimilarName())
		{
			POINT point= {rcDraw.left-2,rcDraw.top+1};
			m_ImageList.Draw(dc, DL_ICON_DISPARITY, point, ILD_NORMAL);
			rcDraw.left += 16;
			PlusMinus += 16;
		}
		// NEO: FDC END

		// NEO: PP - [PasswordProtection]
		if (lpPartFile->IsPWProt())
		{
			POINT point= {rcDraw.left-2,rcDraw.top+1};
			m_ImageList.Draw(dc, DL_ICON_SECURITY, point, ILD_NORMAL);
			rcDraw.left += 16;
			PlusMinus += 16;
		}
		// NEO: PP END

		dc->DrawText(lpPartFile->GetFileName(), rcDraw, DLC_DT_TEXT);
		rcDraw.left-=PlusMinus;
		// NEO: NI END <-- Xanatos --
		break;
	}

	case 1:		// size
		buffer = CastItoXBytes(lpPartFile->GetFileSize(), false, false);
		break;

	case 2:		// transferred
		buffer = StrLine(_T("%s (%s)"), CastItoXBytes(lpPartFile->GetTransferred(), false, false),  CastItoXBytes(lpPartFile->GetTransferredSession(), false, false)); // MOD - [SessionDL] <-- Xanatos --
		break;

	case 3:		// transferred complete
		buffer = CastItoXBytes(lpPartFile->GetCompletedSize(), false, false);
		break;
	case 4:		// speed
		if (lpPartFile->GetTransferringSrcCount()){
			buffer.Format(_T("%s"), CastItoXBytes(lpPartFile->GetDatarate(), false, true));
#ifdef LANCAST // NEO: NLC - [NeoLanCast] -- Xanatos -->
			if(lpPartFile->GetLanDatarate() > 0)
				buffer.AppendFormat(_T(" + (%s)"), CastItoXBytes(lpPartFile->GetLanDatarate(), false, true));
#endif //LANCAST // NEO: NLC END <-- Xanatos --
		}
#ifdef VOODOO // NEO: VOODOO - [UniversalPartfileInterface] -- Xanatos -->
		if(lpPartFile->GetVoodooDatarate() > 0)
			buffer.AppendFormat(_T(" + [%s]"), CastItoXBytes(lpPartFile->GetVoodooDatarate(), false, true));
#endif // VOODOO // NEO: VOODOO END <-- Xanatos --
		break;

	case 5:		// progress
		{
			CRect rcDraw(*lpRect);
			rcDraw.bottom--;
			rcDraw.top++;

			// added
			int iWidth = rcDraw.Width();
			int iHeight = rcDraw.Height();
			if (lpCtrlItem->status == (HBITMAP)NULL)
				VERIFY(lpCtrlItem->status.CreateBitmap(1, 1, 1, 8, NULL));
			CDC cdcStatus;
			HGDIOBJ hOldBitmap;
			cdcStatus.CreateCompatibleDC(dc);
			int cx = lpCtrlItem->status.GetBitmapDimension().cx; 
			DWORD dwTicks = GetTickCount();
			if(lpCtrlItem->dwUpdated + DLC_BARUPDATE < dwTicks || cx !=  iWidth || !lpCtrlItem->dwUpdated) {
				lpCtrlItem->status.DeleteObject(); 
				lpCtrlItem->status.CreateCompatibleBitmap(dc,  iWidth, iHeight); 
				lpCtrlItem->status.SetBitmapDimension(iWidth,  iHeight); 
				hOldBitmap = cdcStatus.SelectObject(lpCtrlItem->status); 

				RECT rec_status; 
				rec_status.left = 0; 
				rec_status.top = 0; 
				rec_status.bottom = iHeight; 
				rec_status.right = iWidth; 
				lpPartFile->DrawStatusBar(&cdcStatus,  &rec_status, thePrefs.UseFlatBar()); 

				lpCtrlItem->dwUpdated = dwTicks + (rand() % 128); 
			} else 
				hOldBitmap = cdcStatus.SelectObject(lpCtrlItem->status); 

			dc->BitBlt(rcDraw.left, rcDraw.top, iWidth, iHeight,  &cdcStatus, 0, 0, SRCCOPY); 
			cdcStatus.SelectObject(hOldBitmap);
			//added end

			// NEO: MOD - [Percentage] -- Xanatos -->
			// HoaX_69: BEGIN Display percent in progress bar
			if (thePrefs.GetUseDwlPercentage()) {
				COLORREF oldclr = dc->SetTextColor(RGB(0,0,0));
				int iOMode = dc->SetBkMode(TRANSPARENT);
				if(thePrefs.GetUseDwlPercentage() == TRUE)
					buffer.Format(_T("%.1f%%"), lpPartFile->GetPercentCompleted());
				else
					buffer.Format(_T("%.1f%% / %.1f%%"), lpPartFile->GetPercentCompleted(), lpPartFile->GetPercentCompleted() - lpPartFile->GetPercentCompletedInitial());
				CFont *pOldFont = dc->SelectObject(&m_fontSmall);
				rcDraw.OffsetRect(-1,0);
				dc->DrawText(buffer, buffer.GetLength(), &rcDraw, (DLC_DT_TEXT & ~DT_LEFT) | DT_CENTER);
				rcDraw.OffsetRect(2,0);
				dc->DrawText(buffer, buffer.GetLength(), &rcDraw, (DLC_DT_TEXT & ~DT_LEFT) | DT_CENTER);
				rcDraw.OffsetRect(-1,-1);
				dc->DrawText(buffer, buffer.GetLength(), &rcDraw, (DLC_DT_TEXT & ~DT_LEFT) | DT_CENTER);
				rcDraw.OffsetRect(0,2);
				dc->DrawText(buffer, buffer.GetLength(), &rcDraw, (DLC_DT_TEXT & ~DT_LEFT) | DT_CENTER);
				rcDraw.OffsetRect(0,-1);
				dc->SetTextColor(RGB(255,255,255));
				dc->DrawText(buffer, buffer.GetLength(), &rcDraw, (DLC_DT_TEXT & ~DT_LEFT) | DT_CENTER);

				dc->SelectObject(pOldFont);
				dc->SetBkMode(iOMode);
				dc->SetTextColor(oldclr);

				// Old official code
				//COLORREF oldclr = dc->SetTextColor(RGB(255,255,255));
				//int iOMode = dc->SetBkMode(TRANSPARENT);
				//buffer.Format(_T("%.1f%%"), lpPartFile->GetPercentCompleted());
				//dc->DrawText(buffer, buffer.GetLength(), &rcDraw, (DLC_DT_TEXT & ~DT_LEFT) | DT_CENTER);
				//dc->SetBkMode(iOMode);
				//dc->SetTextColor(oldclr);
			}
			// NEO: MOD END <-- Xanatos --
		}
		break;

	case 6:		// sources
		{
			UINT sc = (lpPartFile->GetSourceCount() - lpPartFile->GetCachedSourceCount()); // NEO: XSC - [ExtremeSourceCache] <-- Xanatos --
			UINT ncsc = lpPartFile->GetNotCurrentSourcesCount();
// ZZ:DownloadManager -->
            if(!(lpPartFile->GetStatus() == PS_PAUSED && sc == 0) && lpPartFile->GetStatus() != PS_COMPLETE) {
                buffer.Format(_T("%i"), sc-ncsc);
				if(ncsc>0) buffer.AppendFormat(_T("/%i"), sc);
				if(lpPartFile->GetCachedSourceCount() > 0)  buffer.AppendFormat(_T("[%i]"), lpPartFile->GetCachedSourceCount()); // NEO: XSC - [ExtremeSourceCache] <-- Xanatos --
                if(thePrefs.IsExtControlsEnabled() && lpPartFile->GetSrcA4AFCount() > 0) buffer.AppendFormat(_T("+%i"), lpPartFile->GetSrcA4AFCount());
				if(lpPartFile->GetTransferringSrcCount() > 0) buffer.AppendFormat(_T(" (%i)"), lpPartFile->GetTransferringSrcCount());
            } else {
                buffer = _T("");
			}
// <-- ZZ:DownloadManager
			// NEO: AHL - [AutoHardLimit] -- Xanatos --
			//if (thePrefs.IsExtControlsEnabled() && lpPartFile->GetPrivateMaxSources() != 0)
			//	buffer.AppendFormat(_T(" [%i]"), lpPartFile->GetPrivateMaxSources());
			//dc->DrawText(buffer,buffer.GetLength(),const_cast<LPRECT>(lpRect), DLC_DT_TEXT | DT_RIGHT);
		}
		break;

	case 7:		// prio
		switch(lpPartFile->GetDownPriority()) {
		case PR_LOW:
			if( lpPartFile->IsAutoDownPriority() )
				buffer = GetResString(IDS_PRIOAUTOLOW);
			else
				buffer = GetResString(IDS_PRIOLOW);
			break;
		case PR_NORMAL:
			if( lpPartFile->IsAutoDownPriority() )
				buffer = GetResString(IDS_PRIOAUTONORMAL);
			else
				buffer = GetResString(IDS_PRIONORMAL);
			break;
		case PR_HIGH:
			if( lpPartFile->IsAutoDownPriority() )
				buffer = GetResString(IDS_PRIOAUTOHIGH);
			else
				buffer = GetResString(IDS_PRIOHIGH);
			break;
		}
		break;

	case 8:		// <<--9/21/02
		buffer = lpPartFile->getPartfileStatus();
		// NEO: SSH - [SlugFillerSafeHash] -- Xanatos -->
		if(lpPartFile->GetPartsHashing())
			buffer.AppendFormat(GetResString(IDS_X_ISHASHING),lpPartFile->GetPartsHashing());
		// NEO: SSH END <-- Xanatos --
		break;

	case 9:		// remaining time
		{
			if (lpPartFile->GetStatus()!=PS_COMPLETING && lpPartFile->GetStatus()!=PS_COMPLETE ){
				// time 
				// NEO: MOD -- Xanatos -->
				if(thePrefs.UseSimpleTimeRemainingComputation() == 2)
					buffer.Format(_T("%s (%s)"), CastSecondsToHM(lpPartFile->getTimeRemainingSimple()), CastSecondsToHM(lpPartFile->getTimeRemaining()));
				else if (thePrefs.UseSimpleTimeRemainingComputation() == 1)
					buffer = CastSecondsToHM(lpPartFile->getTimeRemainingSimple());
				else
					buffer = CastSecondsToHM(lpPartFile->getTimeRemaining());
				// NEO: MOD <-- Xanatos --
			}
		}
		break;
	case 10: // last seen complete
		{
			CString tempbuffer;
			if (lpPartFile->m_nCompleteSourcesCountLo == 0)
			{
				tempbuffer.Format(_T("< %u"), lpPartFile->m_nCompleteSourcesCountHi);
			}
			else if (lpPartFile->m_nCompleteSourcesCountLo == lpPartFile->m_nCompleteSourcesCountHi)
			{
				tempbuffer.Format(_T("%u"), lpPartFile->m_nCompleteSourcesCountLo);
			}
			else
			{
				tempbuffer.Format(_T("%u - %u"), lpPartFile->m_nCompleteSourcesCountLo, lpPartFile->m_nCompleteSourcesCountHi);
			}
			if (lpPartFile->lastseencomplete==NULL)
				buffer.Format(_T("%s (%s)"),GetResString(IDS_NEVER),tempbuffer);
			else
				buffer.Format(_T("%s (%s)"),lpPartFile->lastseencomplete.Format( thePrefs.GetDateTimeFormat()),tempbuffer);
		}
		break;
	case 11: // last receive
		if (!IsColumnHidden(11)) {
				if(lpPartFile->GetFileDate()!=NULL && lpPartFile->GetCompletedSize() > (uint64)0)
				buffer=lpPartFile->GetCFileDate().Format( thePrefs.GetDateTimeFormat());
			else
				buffer.Format(_T("%s"),GetResString(IDS_NEVER));
		}
		break;
	case 12: // cat
		if (!IsColumnHidden(12)) {
#ifdef A4AF_CATS // NEO: MAC - [MorphA4AFCategories] -- Xanatos -->
			if (!thePrefs.ShowCatNameInDownList())
				buffer.Format(_T("%u"), lpPartFile->GetCategory());
			else
				buffer.Format(_T("%s"), thePrefs.GetCategory(lpPartFile->GetCategory())->title);
			dc->DrawText(buffer, buffer.GetLength(),const_cast<LPRECT>(lpRect), DLC_DT_TEXT);
			break;
#else
			buffer=(lpPartFile->GetCategory()!=0)?
				thePrefs.GetCategory(lpPartFile->GetCategory())->title:_T("");
#endif // A4AF_CATS // NEO: MAC END <-- Xanatos --
		}
		break;
	// NEO: AHL - [AutoHardLimit] -- Xanatos -->
	case 13:
		buffer.Empty();
		if(lpPartFile->PartPrefs.UseAutoHardLimit()) 
			buffer.AppendFormat(_T("A:"));

		// NEO: ASL - [AutoSoftLock]
		if (lpPartFile->GetWaitingSourceCount())
			buffer.AppendFormat(_T("%i;%i/%i"),lpPartFile->PartPrefs.GetHardLimit(),lpPartFile->GetValidSourcesCount(),lpPartFile->GetWaitingSourceCount());
		else
			buffer.AppendFormat(_T("%i;%i"),lpPartFile->PartPrefs.GetHardLimit(),lpPartFile->GetValidSourcesCount());

		// NEO: XSC - [ExtremeSourceCache]
		if(lpPartFile->PartPrefs.UseSourceCache() && lpPartFile->GetCachedSourceCount())
			buffer.AppendFormat(_T("(%i)"),lpPartFile->GetCachedSourceCount());
		// NEO: XSC END

		if(lpPartFile->PartPrefs.UseAutoSoftLock() && lpPartFile->CheckSoftLock()) 
			buffer.AppendFormat(_T("L"));
		// NEO: ASL END
		break;
	// NEO: AHL END <-- Xanatos --
	// NEO: MTD - [MultiTempDirectories] -- Xanatos -->
	case 14:
		buffer = lpPartFile->GetPath();
		break;
	// NEO: MTD END <-- Xanatos --
	// NEO: MOD -- Xanatos -->
	case 15:
		buffer = CastItoXBytes((lpPartFile->GetFileSize() - lpPartFile->GetCompletedSize()), false, false);
		break;
	// NEO: MOD END <-- Xanatos --
#ifdef A4AF_CATS // NEO: MAC - [MorphA4AFCategories] -- Xanatos -->
	case 16: // Resume Mod
		buffer.Format(_T("%u"), lpPartFile->GetCatResumeOrder());
		break;
#endif // A4AF_CATS // NEO: MAC END <-- Xanatos --
#ifdef WEBCACHE // NEO: WC - [WebCache] -- Xanatos -->
	case 17:
		{
			UINT wcsc = lpPartFile->GetWebcacheSourceCount();
			UINT wcsc_our = 0;
			UINT wcsc_not_our = 0;
			if(thePrefs.IsExtControlsEnabled())
			{
				wcsc_our = lpPartFile->GetWebcacheSourceOurProxyCount();
				wcsc_not_our = lpPartFile->GetWebcacheSourceNotOurProxyCount();
			}

			UINT sc = (lpPartFile->GetSourceCount() - lpPartFile->GetCachedSourceCount()) + lpPartFile->GetSrcA4AFCount(); // NEO: XSC - [ExtremeSourceCache] <-- Xanatos -- 
			double PercentWCClients;
			if (sc !=0)
				PercentWCClients = (double) 100 * wcsc / sc;
			else
				PercentWCClients = 0;
            if(wcsc > 0 && !(lpPartFile->GetStatus() == PS_PAUSED && wcsc == 0) && lpPartFile->GetStatus() != PS_COMPLETE) {
				if(thePrefs.IsExtControlsEnabled())
					buffer.Format(_T("%i/%i/%i (%1.1f%%)"), wcsc, wcsc_our, wcsc_not_our, PercentWCClients);
				else
                buffer.Format(_T("%i (%1.1f%%)"), wcsc, PercentWCClients);
            } else {
                buffer = _T("");
			}
		}
		break;
#endif // NEO: WC END <-- Xanatos --
	}

	// NEO: LF - [ListFind] -- Xanatos -->
	if(!lpText){
		if (nColumn != 0 && nColumn != 5)
			dc->DrawText(buffer,buffer.GetLength(),const_cast<LPRECT>(lpRect), uDTFlags);
	}else
		*lpText = buffer;
	// NEO: LF END <-- Xanatos --
	
}

void CDownloadListCtrl::DrawSourceItem(CDC *dc, int nColumn, LPCRECT lpRect, CtrlItem_Struct *lpCtrlItem, CString* lpText) // NEO: LF - [ListFind] <-- Xanatos --
{
	// NEO: LF - [ListFind] -- Xanatos -->
	CString buffer;
	CUpDownClient *lpUpDownClient = (CUpDownClient*)lpCtrlItem->value;

	UINT uDTFlags = DLC_DT_TEXT; 
	if(!lpText){ 
		if(lpRect->left >= lpRect->right)
			return;
		
		if(nColumn == 2 || nColumn == 4)
			uDTFlags |= DT_RIGHT;
	}else if(nColumn == 0){
		if (lpUpDownClient->GetUserName().IsEmpty()) // NEO: FIX - [StabilityFix] <-- Xanatos --
			*lpText = _T("?");
		else
			*lpText = lpUpDownClient->GetUserName();
		return;
#ifdef IP2COUNTRY // NEO: IP2C - [IPtoCountry]
	}else if(nColumn == 12){
		*lpText = lpUpDownClient->GetCountryName();
		return;
#endif // IP2COUNTRY // NEO: IP2C END
	}else if(nColumn == 5){
		return;
	}else if(nColumn == 7){
		if(lpUpDownClient->IsRemoteQueueFull())
			buffer = GetResString(IDS_QUEUEFULL);
		else
			buffer.Format(_T("%u"), lpUpDownClient->GetRemoteQueueRank());
		*lpText = buffer;
		return;
	}
	// NEO: LF END <-- Xanatos --

	switch(nColumn) {

	case 0:		// icon, name, status
		{
			RECT cur_rec = *lpRect;
			// NEO: NTS - [NeoTreeStyle] -- Xanatos -->
			if(thePrefs.UseTreeStyle()){
				cur_rec.left += 14;
			}
			// NEO: NTS END <-- Xanatos --
			// NEO: NI - [NewIcons] -- Xanatos -->
			POINT point = {cur_rec.left, cur_rec.top+1};
			// NEO: NCI - [NewClientIcons]
			if (lpCtrlItem->type == AVAILABLE_SOURCE){
				switch (lpUpDownClient->GetDownloadState()) {
				case DS_CONNECTINGWAITING: // NEO: MDR - [ManualDownloadReask]
				case DS_CONNECTIONRETRY: // NEO: TCR - [TCPConnectionRetry]
#if defined(NEO_SK) || defined(NEO_SS) // NEO: NSK - [NeoSourceKeeper] // NEO: NSS - [NeoSourceStorage]
				case DS_REVIVAL:
#endif // NEO_SK // NEO_SS // NEO: NSK END // NEO: NSS END
#ifdef NEO_SS // NEO: NSS - [NeoSourceStorage]
				case DS_RESERVE:
				case DS_LOADEDWAITING:
#endif // NEO_SS // NEO: NSS END
				case DS_CONNECTING:
				case DS_HALTED: // NEO: SD - [StandByDL] <-- Xanatos --
				case DS_CONNECTED:
				case DS_WAITCALLBACKKAD:
				case DS_WAITCALLBACK:
				case DS_TOOMANYCONNS:
				case DS_TOOMANYCONNSKAD:
					m_ImageList.Draw(dc, DL_SRC_CONNECTING, point, ILD_NORMAL);
					break;
				case DS_ONQUEUE:
					if(lpUpDownClient->IsRemoteQueueFull())
						m_ImageList.Draw(dc, DL_SRC_NNPFQ, point, ILD_NORMAL);
					else
						m_ImageList.Draw(dc, DL_SRC_ON_QUEUE, point, ILD_NORMAL);
					break;
				case DS_DOWNLOADING:
				case DS_REQHASHSET:
					m_ImageList.Draw(dc, DL_SRC_DOWNLOADING, point, ILD_NORMAL);
					break;
				case DS_NONEEDEDPARTS:
#ifdef NEO_SK // NEO: NSK - [NeoSourceKeeper]
				case DS_UNREACHABLE:
#endif // NEO_SK // NEO: NSK END
#ifdef NEO_SS // NEO: NSS - [NeoSourceStorage]
				case DS_RETIRED:
#endif // NEO_SS // NEO: NSS END
				case DS_ERROR:
					m_ImageList.Draw(dc, DL_SRC_NNPFQ, point, ILD_NORMAL);
					break;
				case DS_CACHED: // NEO: XSC - [ExtremeSourceCache] <-- Xanatos --
#ifdef NEO_SS // NEO: NSS - [NeoSourceStorage]
				case DS_LOADED:
#endif // NEO_SS // NEO: NSS END
				default:
					m_ImageList.Draw(dc, DL_SRC_UNKNOWN, point, ILD_NORMAL);
				}
			}
			else {
				m_ImageList.Draw(dc, DL_SRC_NNPFQ, point, ILD_NORMAL);
			}
			cur_rec.left += 20;
			// NEO: NCI END
		
			POINT point2= {cur_rec.left,cur_rec.top+1};
			switch (lpUpDownClient->GetClientSoft())
			{
				case SO_URL:
					m_ImageList.Draw(dc, DL_SERVER, point2, ILD_NORMAL);
					break;
				case SO_CDONKEY:
					m_ImageList.Draw(dc, DL_CLIENT_CDONKEY,point2, ILD_NORMAL);
					break;
				case SO_AMULE: 
					m_ImageList.Draw(dc, DL_CLIENT_AMULE, point2, ILD_NORMAL);
					break;					
				case SO_LPHANT:
					m_ImageList.Draw(dc, DL_CLIENT_LPHANT, point2, ILD_NORMAL);
					break;
				case SO_EMULEPLUS:
					m_ImageList.Draw(dc, DL_CLIENT_EMULEPLUS, point2, ILD_NORMAL);
					break;
				case SO_HYDRANODE:
					m_ImageList.Draw(dc, DL_CLIENT_HYDRANODE, point2, ILD_NORMAL);
					break;
				case SO_TRUSTYFILES:
					m_ImageList.Draw(dc, DL_CLIENT_TRUSTYFILES, point2, ILD_NORMAL);
					break;
				case SO_XMULE:
					m_ImageList.Draw(dc, DL_CLIENT_XMULE, point2, ILD_NORMAL);
					break;
				case SO_SHAREAZA:
					m_ImageList.Draw(dc, DL_CLIENT_SHAREAZA, point2, ILD_NORMAL);
					break;
				case SO_EDONKEYHYBRID:
					m_ImageList.Draw(dc, DL_CLIENT_HYBRID, point2, ILD_NORMAL);
					break;
				case SO_MLDONKEY:
					m_ImageList.Draw(dc, DL_CLIENT_MLDONKEY, point2, ILD_NORMAL);
					break;
				case SO_EMULE:
					if(lpUpDownClient->IsNeoMod()) // NEO: MID - [ModID]
						m_ImageList.Draw(dc, DL_CLIENT_NEO, point2, ILD_NORMAL); 
					else
						m_ImageList.Draw(dc, DL_CLIENT_EMULE, point2, ILD_NORMAL);
					break;
				case SO_OLDEMULE:
					m_ImageList.Draw(dc, DL_CLIENT_OLDEMULE, point2, ILD_NORMAL);
					break;
				case SO_EDONKEY:
					m_ImageList.Draw(dc, DL_CLIENT_EDONKEY, point2, ILD_NORMAL);
					break;
				case SO_UNKNOWN:
					m_ImageList.Draw(dc, DL_CLIENT_UNKNOWN, point2, ILD_NORMAL);
					break;
				default:
					m_ImageList.Draw(dc, DL_CLIENT_UNKNOWN, point2, ILD_NORMAL);
			}

			if (lpUpDownClient->IsBanned()) 
				m_ImageList.Draw(dc, DL_ARGOS_BANNED, point2, ILD_TRANSPARENT);
#ifdef ARGOS // NEO: NA - [NeoArgos]
			else if(theApp.argos->IsArgos(lpUpDownClient->GetConnectIP())){
				if (theApp.argos->GetPunishment(lpUpDownClient) == 0) 
					m_ImageList.Draw(dc, DL_ARGOS_BANNED_SOFT, point2, ILD_TRANSPARENT);
				else if (theApp.argos->GetPunishment(lpUpDownClient) != 0) 
					m_ImageList.Draw(dc, DL_ARGOS_BANNED_SOFT2, point2, ILD_TRANSPARENT);
				else
					m_ImageList.Draw(dc, DL_ARGOS_LEECHER, point2, ILD_TRANSPARENT);
			}
#endif //ARGOS // NEO: NA END
			else if (lpUpDownClient->GetFriendSlot())
				m_ImageList.Draw(dc, DL_FRIEND_SLOT_CLIENT, point2, ILD_TRANSPARENT);
			else if (lpUpDownClient->IsFriend())
				m_ImageList.Draw(dc, DL_FRIEND_CLIENT, point2, ILD_TRANSPARENT);
			else if (lpUpDownClient->IsCommunity())
				m_ImageList.Draw(dc, DL_COMMUNITY_CLIENT, point2, ILD_TRANSPARENT);
			else if (lpUpDownClient->Credits()){ 
				if (lpUpDownClient->credits->GetScoreRatio(lpUpDownClient->GetIP()) > 1 && lpUpDownClient->credits->GetRemoteScoreRatio() > 1)
					m_ImageList.Draw(dc, DL_CREDIT_UP_DOWN, point2, ILD_TRANSPARENT);
				else if (lpUpDownClient->credits->GetScoreRatio(lpUpDownClient->GetIP()) > 1)
					m_ImageList.Draw(dc, DL_CREDIT_UP, point2, ILD_TRANSPARENT);
				else if (lpUpDownClient->credits->GetRemoteScoreRatio() > 1)
					m_ImageList.Draw(dc, DL_CREDIT_DOWN, point2, ILD_TRANSPARENT);
			}

#ifdef LANCAST // NEO: NLC - [NeoLanCast]
			if(lpUpDownClient->IsLanClient()) 
				m_ImageList.Draw(dc, DL_LANCAST_CLIENT, point2, ILD_TRANSPARENT);
			else // Lan Client's dont need SUI
#endif //LANCAST // NEO: NLC END ENC
				if(theApp.clientcredits->CryptoAvailable() && lpUpDownClient->Credits())
					switch(lpUpDownClient->Credits()->GetCurrentIdentState(lpUpDownClient->GetIP())){
					case IS_NOTAVAILABLE:
						m_ImageList.Draw(dc, DL_SECUREHASH_BLUE, point2, ILD_TRANSPARENT); // BLUE
						break;
					case IS_IDENTIFIED:
						m_ImageList.Draw(dc, DL_SECUREHASH_GREEN, point2, ILD_TRANSPARENT); // GREEN
						break;
					case IS_IDNEEDED:
						m_ImageList.Draw(dc, DL_SECUREHASH_YELLOW, point2, ILD_TRANSPARENT); // YELLOW
						break;
					case IS_IDBADGUY:
					case IS_IDFAILED:
						m_ImageList.Draw(dc, DL_SECUREHASH_RED, point2, ILD_TRANSPARENT); // RED
						break;
					}

			if(lpUpDownClient->GetViewSharedFilesSupport() && lpUpDownClient->GetClientSoft() == SO_EMULE)
				m_ImageList.Draw(dc, DL_SHOW_SHARED, point2, ILD_TRANSPARENT);

			if(lpUpDownClient->HasLowID())
				m_ImageList.Draw(dc, DL_LOW_ID_CLIENT, point2, ILD_TRANSPARENT);

			if(!lpUpDownClient->IsNeoMod()) 
				if(
					lpUpDownClient->GetCommentVersion() > 1
					|| lpUpDownClient->GetIncompletePartVersion()
					|| lpUpDownClient->GetSubChunksVer()
					|| lpUpDownClient->GetHidenPartStatusVersion()
					|| lpUpDownClient->GetBlockedPartStatusVersion()
#ifdef NATTUNNELING // NEO: NATT - [NatTraversal]
					|| lpUpDownClient->GetNatTraversalVersion()
#endif //NATTUNNELING // NEO: NATT END
					|| lpUpDownClient->GetNeoXSVersion()
					|| lpUpDownClient->GetExtraInfoVersion()
					|| lpUpDownClient->GetDownloadTimeVersion()
					|| lpUpDownClient->GetL2HACSupport()
#ifdef WEBCACHE // NEO: WC - [WebCache]
					|| lpUpDownClient->SupportsWebCache()
#endif // NEO: WC END
					)
			{
				m_ImageList.Draw(dc, DL_ICON_EXTENDED, point2, ILD_TRANSPARENT);
				if(lpUpDownClient->GetCommentVersion() > 1)
					m_ImageList.Draw(dc, DL_ICON_EXTENDED1, point2, ILD_TRANSPARENT);
				if(lpUpDownClient->GetIncompletePartVersion())
					m_ImageList.Draw(dc, DL_ICON_EXTENDED2, point2, ILD_TRANSPARENT);
				if(lpUpDownClient->GetSubChunksVer())
					m_ImageList.Draw(dc, DL_ICON_EXTENDED3, point2, ILD_TRANSPARENT);
				if(lpUpDownClient->GetExtraInfoVersion())
					m_ImageList.Draw(dc, DL_ICON_EXTENDED4, point2, ILD_TRANSPARENT);
				if(lpUpDownClient->GetDownloadTimeVersion())
					m_ImageList.Draw(dc, DL_ICON_EXTENDED5, point2, ILD_TRANSPARENT);
				if(lpUpDownClient->GetL2HACSupport())
					m_ImageList.Draw(dc, DL_ICON_EXTENDED6, point2, ILD_TRANSPARENT);
				if(lpUpDownClient->GetHidenPartStatusVersion())
					m_ImageList.Draw(dc, DL_ICON_EXTENDED7, point2, ILD_TRANSPARENT);
				if(lpUpDownClient->GetBlockedPartStatusVersion())
					m_ImageList.Draw(dc, DL_ICON_EXTENDED8, point2, ILD_TRANSPARENT);
#ifdef NATTUNNELING // NEO: NATT - [NatTraversal]
				if(lpUpDownClient->GetNatTraversalVersion() > 0)
					m_ImageList.Draw(dc, DL_ICON_EXTENDED10, point2, ILD_TRANSPARENT);
#endif //NATTUNNELING // NEO: NATT END
				if(lpUpDownClient->GetNeoXSVersion())
					m_ImageList.Draw(dc, DL_ICON_EXTENDED11, point2, ILD_TRANSPARENT);
#ifdef WEBCACHE // NEO: WC - [WebCache] -- Xanatos -->
				if(lpUpDownClient->SupportsWebCache())
					m_ImageList.Draw(dc, DL_ICON_EXTENDED12, point2, ILD_TRANSPARENT);
#endif // NEO: WC END <-- Xanatos --
			}

			if(lpUpDownClient->IsObfuscatedConnectionEstablished())
				m_ImageList.Draw(dc, DL_ICON_Obfu, point2, ILD_TRANSPARENT);

			// NEO: NI END <-- Xanatos --
			cur_rec.left += 20;

#ifdef IP2COUNTRY // NEO: IP2C - [IPtoCountry] -- Xanatos -->
			const bool bShowFlags = thePrefs.IsIP2CountryShowFlag() && theApp.ip2country->ShowCountryFlag()
								&& (thePrefs.IsIP2CountryShowFlag() == 2 || IsColumnHidden(2));
			if(bShowFlags){
				POINT point3= {cur_rec.left,cur_rec.top+1};
				theApp.ip2country->GetFlagImageList()->DrawIndirect(dc, lpUpDownClient->GetCountryFlagIndex(), point3, CSize(18,16), CPoint(0,0), ILD_NORMAL);
				cur_rec.left+=20;
			}
#endif // IP2COUNTRY // NEO: IP2C END <-- Xanatos --

			if (lpUpDownClient->GetUserName().IsEmpty()) // NEO: FIX - [StabilityFix] <-- Xanatos --
				buffer = _T("?");
			else
				buffer = lpUpDownClient->GetUserName();
			dc->DrawText(buffer,buffer.GetLength(),&cur_rec, DLC_DT_TEXT);
		}
		break;

	case 1:		// size
		switch(lpUpDownClient->GetSourceFrom()){
			case SF_SERVER:
				buffer = _T("eD2K Server");
				break;
			case SF_KADEMLIA:
				buffer = GetResString(IDS_KADEMLIA);
				break;
			case SF_SOURCE_EXCHANGE:
				buffer = GetResString(IDS_SE);
				break;
			case SF_PASSIVE:
				buffer = GetResString(IDS_PASSIVE);
				break;
#ifdef NEO_SS // NEO: NSS - [NeoSourceStorage] -- Xanatos -->
			case SF_STORAGE:
				buffer = GetResString(IDS_X_STORAGE);
				break;
#endif // NEO_SS // NEO: NSS END <-- Xanatos --
#ifdef LANCAST // NEO: NLC - [NeoLanCast] -- Xanatos -->
			case SF_LANCAST:
				buffer = GetResString(IDS_X_LANCAST);
				break;
#endif //LANCAST // NEO: NLC END <-- Xanatos --
#ifdef VOODOO // NEO: VOODOOx - [VoodooSourceExchange] -- Xanatos -->
			case SF_VOODOO:
				buffer = GetResString(IDS_X_VOODOO);
				break;
#endif // VOODOO // NEO: VOODOOx END <-- Xanatos --
			case SF_LINK:
				buffer = GetResString(IDS_SW_LINK);
				break;
		}
		break;

	case 2:// transferred
		buffer = StrLine(_T("%s (%s)"), lpUpDownClient->Credits() ? CastItoXBytes(lpUpDownClient->Credits()->GetDownloadedTotal(), false, false) : _T("???"),  CastItoXBytes(lpUpDownClient->GetTransferredDown(), false, false)); // MOD - [SessionDL] <-- Xanatos --
		break;
	case 3:// completed
		/*// - 'Transferred' column: Show transferred data
		// - 'Completed' column: If 'Transferred' column is hidden, show the amount of transferred data
		//	  in 'Completed' column. This is plain wrong (at least when receiving compressed data), but
		//	  users seem to got used to it.
		if (lpCtrlItem->type == AVAILABLE_SOURCE && lpUpDownClient->GetTransferredDown()) {
			buffer = CastItoXBytes(lpUpDownClient->GetTransferredDown(), false, false);
		}*/
		buffer = StrLine(_T("%s (%s)"), lpUpDownClient->Credits() ? CastItoXBytes(lpUpDownClient->Credits()->GetUploadedTotal(), false, false) : _T("???"),  CastItoXBytes(lpUpDownClient->GetTransferredUp(), false, false)); // MOD - [SessionDL] <-- Xanatos --

		break;

	case 4:		// speed
		if (lpCtrlItem->type == AVAILABLE_SOURCE && lpUpDownClient->GetDownloadDatarate()){
			if (lpUpDownClient->GetDownloadDatarate())
				buffer.Format(_T("%s"), CastItoXBytes(lpUpDownClient->GetDownloadDatarate(), false, true));
		}
		break;

	case 5:		// file info
		{
			CRect rcDraw(*lpRect);
			rcDraw.bottom--; 
			rcDraw.top++; 

			int iWidth = rcDraw.Width();
			int iHeight = rcDraw.Height();
			if (lpCtrlItem->status == (HBITMAP)NULL)
				VERIFY(lpCtrlItem->status.CreateBitmap(1, 1, 1, 8, NULL)); 
			CDC cdcStatus;
			HGDIOBJ hOldBitmap;
			cdcStatus.CreateCompatibleDC(dc);
			int cx = lpCtrlItem->status.GetBitmapDimension().cx;
			DWORD dwTicks = GetTickCount();
			if(lpCtrlItem->dwUpdated + DLC_BARUPDATE < dwTicks || cx !=  iWidth  || !lpCtrlItem->dwUpdated) { 
				lpCtrlItem->status.DeleteObject(); 
				lpCtrlItem->status.CreateCompatibleBitmap(dc,  iWidth, iHeight); 
				lpCtrlItem->status.SetBitmapDimension(iWidth,  iHeight); 
				hOldBitmap = cdcStatus.SelectObject(lpCtrlItem->status); 

				RECT rec_status; 
				rec_status.left = 0; 
				rec_status.top = 0; 
				rec_status.bottom = iHeight; 
				rec_status.right = iWidth; 
				lpUpDownClient->DrawStatusBar(&cdcStatus,  &rec_status,(CPartFile*)lpCtrlItem->owner, thePrefs.UseFlatBar());   // NEO: MFSB - [MultiFileStatusBars] <-- Xanatos --

				lpCtrlItem->dwUpdated = dwTicks + (rand() % 128); 
			} else 
				hOldBitmap = cdcStatus.SelectObject(lpCtrlItem->status); 

			dc->BitBlt(rcDraw.left, rcDraw.top, iWidth, iHeight,  &cdcStatus, 0, 0, SRCCOPY); 
			cdcStatus.SelectObject(hOldBitmap);
		}
		break;

	case 6:		// sources
	{
		buffer = lpUpDownClient->DbgGetFullClientSoftVer(); // NEO: MIDI - [ModIDInfo] <-- Xanatos --
		if (buffer.IsEmpty())
			buffer = GetResString(IDS_UNKNOWN);
		break;
	}

	case 7:		// prio
		if (lpUpDownClient->GetDownloadState()==DS_ONQUEUE){
		// NEO: CQR - [CollorQueueRank] -- Xanatos -->
			int iDeltaRemoteQueueRank = lpUpDownClient->GetDeltaRemoteQueueRank();
			UINT iRemoteQueueRank = lpUpDownClient->GetRemoteQueueRank();
			UINT iInitialRemoteQueueRank = lpUpDownClient->GetInitialRemoteQueueRank();

			if( lpUpDownClient->IsRemoteQueueFull() ){
				if (iInitialRemoteQueueRank){
					if (lpUpDownClient->GetTransferredDown())
						dc->SetTextColor((COLORREF)RGB(190,190,60)); // Yelow
					else
						dc->SetTextColor((COLORREF)RGB(190,60,60)); // Red
					buffer.Format(_T("%s [%u]"), GetResString(IDS_QUEUEFULL), iInitialRemoteQueueRank);
				}else{
					buffer = GetResString(IDS_QUEUEFULL);
				}
				dc->DrawText(buffer,buffer.GetLength(),const_cast<LPRECT>(lpRect), DLC_DT_TEXT);
				dc->SetTextColor((COLORREF)RGB(0,0,0)); // black
			}else{
				if ( lpUpDownClient->GetRemoteQueueRank()){
					if (iDeltaRemoteQueueRank < 0){
						dc->SetTextColor((COLORREF)RGB(10,160,70)); // Green
						buffer.Format(_T("QR: %u (-%d) [%u]"), iRemoteQueueRank, -iDeltaRemoteQueueRank, iInitialRemoteQueueRank);
					}else if (iDeltaRemoteQueueRank == 0){
						dc->SetTextColor((COLORREF)RGB(5,65,195)); // Blue
						buffer.Format(_T("QR: %u [%u]"), iRemoteQueueRank, iInitialRemoteQueueRank);
					}else if (iDeltaRemoteQueueRank == (int)iRemoteQueueRank){
						buffer.Format(_T("QR: %u"), iRemoteQueueRank);
					}else{
						if (lpUpDownClient->GetTransferredDown())
							dc->SetTextColor((COLORREF)RGB(190,190,60)); // Yelow
						else
							dc->SetTextColor((COLORREF)RGB(190,60,60)); // Red
						buffer.Format(_T("QR: %u (+%d) [%u]"), iRemoteQueueRank, iDeltaRemoteQueueRank, iInitialRemoteQueueRank);
					}
					dc->DrawText(buffer,buffer.GetLength(),const_cast<LPRECT>(lpRect), DLC_DT_TEXT);
					dc->SetTextColor((COLORREF)RGB(0,0,0)); // black
				}else{
					dc->DrawText(_T(""),const_cast<LPRECT>(lpRect), DLC_DT_TEXT);
				}
			}
		// NEO: CQR END <-- Xanatos --
		}
		else{
			dc->DrawText(buffer, buffer.GetLength(), const_cast<LPRECT>(lpRect), DLC_DT_TEXT);
		}
		break;

	case 8:	{	// status
		if (lpCtrlItem->type == AVAILABLE_SOURCE){
			buffer = lpUpDownClient->GetDownloadStateDisplayString();
		}
		else {
			buffer = GetResString(IDS_ASKED4ANOTHERFILE);

// ZZ:DownloadManager -->
            if(thePrefs.IsExtControlsEnabled()) {
                if(lpUpDownClient->IsInNoNeededList(lpCtrlItem->owner)) {
                    buffer += _T(" (") + GetResString(IDS_NONEEDEDPARTS) + _T(")");
                } else if(lpUpDownClient->GetDownloadState() == DS_DOWNLOADING) {
                    buffer += _T(" (") + GetResString(IDS_TRANSFERRING) + _T(")");
                } else if(lpUpDownClient->IsSwapSuspended(lpUpDownClient->GetRequestFile())) {
                    buffer += _T(" (") + GetResString(IDS_SOURCESWAPBLOCKED) + _T(")");
                }

                if (lpUpDownClient && lpUpDownClient->GetRequestFile() && lpUpDownClient->GetRequestFile()->GetFileName()){
                    buffer.AppendFormat(_T(": \"%s\""),lpUpDownClient->GetRequestFile()->GetFileName());
                }
            }
		}

        if(thePrefs.IsExtControlsEnabled() && !lpUpDownClient->m_OtherRequests_list.IsEmpty()) {
            buffer.Append(_T("*"));
        }
// ZZ:DownloadManager <--

		break;
	}
	case 9:		// remaining time & size
		// NEO: EDT - [EstimatedDownloadTime] -- Xanatos -->
		if (thePrefs.UseEstimatedDownloadTime() &&
			(lpUpDownClient->GetDownloadTimeVersion()) &&
			(lpCtrlItem->type != UNAVAILABLE_SOURCE) &&
			(lpUpDownClient->GetDownloadState() != DS_DOWNLOADING))
			buffer = theApp.edt->FormatEDT(lpUpDownClient);
		else
			buffer.Empty();
		// NEO: EDT END <-- Xanatos --
		break;
	case 10:	// last seen complete
		// NEO: MOD -- Xanatos -->
		if (lpUpDownClient->GetLastSeen() > 0)
			buffer = CastSecondsToHM(time(NULL) - lpUpDownClient->GetLastSeen());
		else
			buffer.Empty();
		// NEO: MOD END <-- Xanatos --
		break;
	case 11:	// last received
		// NEO: MOD -- Xanatos -->
		if (lpUpDownClient->GetLastAskedTime() > 0)
			buffer = Time2MinStr(::GetTickCount() - lpUpDownClient->GetLastAskedTime());
		else
			buffer.Empty();
		// NEO: MOD END <-- Xanatos --
		break;
	case 12:{	// category
#ifdef IP2COUNTRY // NEO: IP2C - [IPtoCountry] -- Xanatos -->
			RECT cur_rec = *lpRect;
			const bool bShowFlags = thePrefs.IsIP2CountryShowFlag() == 1 && theApp.ip2country->ShowCountryFlag();
			if(bShowFlags){
				POINT point3= {cur_rec.left,cur_rec.top+1};
				theApp.ip2country->GetFlagImageList()->DrawIndirect(dc, lpUpDownClient->GetCountryFlagIndex(), point3, CSize(18,16), CPoint(0,0), ILD_NORMAL);
				cur_rec.left+=20;
			}
			buffer.Format(_T("%s"), lpUpDownClient->GetCountryName());
			dc->DrawText(buffer,buffer.GetLength(),&cur_rec,DLC_DT_TEXT);
#endif // IP2COUNTRY // NEO: IP2C END <-- Xanatos --
		}
		break;
#ifdef ARGOS // NEO: NA - [NeoArgos] -- Xanatos -->
	case 13:
		if(thePrefs.UseArgosSystem())
			buffer = theApp.argos->GetArgosString(lpUpDownClient);
		break;
#endif //ARGOS // NEO: NA END <-- Xanatos -
#ifdef WEBCACHE // NEO: WC - [WebCache] -- Xanatos -->
	case 17: {
		if (lpUpDownClient->SupportsWebCache())
			{
				buffer = lpUpDownClient->GetWebCacheName();
				if (lpUpDownClient->IsBehindOurWebCache())
					if(dc) dc->SetTextColor(RGB(0, 180, 0)); //if is behind our webcache display green
				else if (buffer != _T(""))
					if(dc) dc->SetTextColor(RGB(255, 0, 0)); // if webcache info is there but not our own set red
				else
					buffer = _T("no proxy set");	// if no webcache info colour is black
			}
			else
				buffer = "";
 			if(dc) dc->SetTextColor(RGB(0, 0, 0));
			break;
		}
	//JP Webcache END
#endif // NEO: WC END <-- Xanatos --
	}

	// NEO: LF - [ListFind] -- Xanatos -->
	if(!lpText){
#ifdef IP2COUNTRY // NEO: IP2C - [IPtoCountry]
		if (nColumn != 0 && nColumn != 5 && nColumn != 7 && nColumn != 12)
#else
		if (nColumn != 0 && nColumn != 5 && nColumn != 7)
#endif // IP2COUNTRY // NEO: IP2C END
			dc->DrawText(buffer,buffer.GetLength(),const_cast<LPRECT>(lpRect), uDTFlags);
	}else
		*lpText = buffer;
	// NEO: LF END <-- Xanatos --

}

void CDownloadListCtrl::DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct)
{
	if (!theApp.emuledlg->IsRunning())
		return;
	if (!lpDrawItemStruct->itemData)
		return;
	CDC* odc = CDC::FromHandle(lpDrawItemStruct->hDC);
	BOOL bCtrlFocused = ((GetFocus() == this) || (GetStyle() & LVS_SHOWSELALWAYS));
	if (lpDrawItemStruct->itemState & ODS_SELECTED) {
		if (bCtrlFocused)
			odc->SetBkColor(m_crHighlight);
		else
			odc->SetBkColor(m_crNoHighlight);
	}
	else
		odc->SetBkColor(GetBkColor());
	CtrlItem_Struct* content = (CtrlItem_Struct*)lpDrawItemStruct->itemData;
	CMemDC dc(odc, &lpDrawItemStruct->rcItem);
	CFont* pOldFont;
	if (thePrefs.GetShowActiveDownloadsBold() && m_fontBold.m_hObject){ // NEO: FIX <-- Xanatos --
		if (content->type == FILE_TYPE){
			if (((const CPartFile*)content->value)->GetTransferringSrcCount())
				pOldFont = dc.SelectObject(&m_fontBold);
			else
				pOldFont = dc.SelectObject(GetFont());
		}
		else if (content->type == UNAVAILABLE_SOURCE || content->type == AVAILABLE_SOURCE){
			if (((const CUpDownClient*)content->value)->GetDownloadState() == DS_DOWNLOADING)
				pOldFont = dc.SelectObject(&m_fontBold);
			else
				pOldFont = dc.SelectObject(GetFont());
		}
		else
			pOldFont = dc.SelectObject(GetFont());
	}
	else
		pOldFont = dc.SelectObject(GetFont());
	CRect cur_rec(lpDrawItemStruct->rcItem);
	COLORREF crOldTextColor = dc.SetTextColor((lpDrawItemStruct->itemState & ODS_SELECTED) ? m_crHighlightText : m_crWindowText);

	int iOldBkMode;
	if (m_crWindowTextBk == CLR_NONE){
		DefWindowProc(WM_ERASEBKGND, (WPARAM)(HDC)dc, 0);
		iOldBkMode = dc.SetBkMode(TRANSPARENT);
	}
	else
		iOldBkMode = OPAQUE;

	BOOL notLast = lpDrawItemStruct->itemID + 1 != (UINT)GetItemCount();
	BOOL notFirst = lpDrawItemStruct->itemID != 0;
	int tree_start=0;
	int tree_end=0;

	//offset was 4, now it's the standard 2 spaces
	int iTreeOffset = dc.GetTextExtent(_T(" "), 1 ).cx*2;
	CHeaderCtrl *pHeaderCtrl = GetHeaderCtrl();
	int iCount = pHeaderCtrl->GetItemCount();
	cur_rec.right = cur_rec.left;
	cur_rec.right -= FILE_ITEM_MARGIN_X;
	cur_rec.left += FILE_ITEM_MARGIN_X;

	if (content->type == FILE_TYPE)
	{
#ifndef A4AF_CATS // NEO: MAC - [MorphA4AFCategories] -- Xanatos -->
		if (!g_bLowColorDesktop || (lpDrawItemStruct->itemState & ODS_SELECTED) == 0) {
			DWORD dwCatColor = thePrefs.GetCatColor(((/*const*/ CPartFile*)content->value)->GetCategory());
			if (dwCatColor > 0)
				dc.SetTextColor(dwCatColor);
		}
#endif // A4AF_CATS // NEO: MAC END <-- Xanatos --

		for (int iCurrent = 0; iCurrent < iCount; iCurrent++)
		{
			int iColumn = pHeaderCtrl->OrderToIndex(iCurrent);
			int cx = CListCtrl::GetColumnWidth(iColumn);

			// NEO: NTS - [NeoTreeStyle] -- Xanatos -->
			if (iColumn == 0 && thePrefs.UseTreeStyle()){ 
				tree_start = cur_rec.left - 1;
				tree_end = cur_rec.left + 1;
			}
			// NEO: NTS END <-- Xanatos --

			if(iColumn == 5 && !thePrefs.UseTreeStyle()) { // NEO: NTS - [NeoTreeStyle] <-- Xanatos --
				int iNextLeft = cur_rec.left + cx;
				//set up tree vars
				cur_rec.left = cur_rec.right + iTreeOffset;
				cur_rec.right = cur_rec.left + min(8, cx);
				tree_start = cur_rec.left + 1;
				tree_end = cur_rec.right;
				//normal column stuff
				cur_rec.left = cur_rec.right + 1;
				cur_rec.right = tree_start + cx - iTreeOffset;
				DrawFileItem(dc, 5, &cur_rec, content);
				cur_rec.left = iNextLeft;
			} else {
				cur_rec.right += cx;
				DrawFileItem(dc, iColumn, &cur_rec, content);
				cur_rec.left += cx;
			}

		}

	}
	else if (content->type == UNAVAILABLE_SOURCE || content->type == AVAILABLE_SOURCE)
	{
		for (int iCurrent = 0; iCurrent < iCount; iCurrent++)
		{
			int iColumn = pHeaderCtrl->OrderToIndex(iCurrent);
			int cx = CListCtrl::GetColumnWidth(iColumn);

			// NEO: NTS - [NeoTreeStyle] -- Xanatos -->
			if (iColumn == 0 && thePrefs.UseTreeStyle()){
				tree_start = cur_rec.left - 1;
				tree_end = cur_rec.left + 1;
			}
			// NEO: NTS END <-- Xanatos --

			if(iColumn == 5 && !thePrefs.UseTreeStyle()) { // NEO: NTS - [NeoTreeStyle] <-- Xanatos --
				int iNextLeft = cur_rec.left + cx;
				//set up tree vars
				cur_rec.left = cur_rec.right + iTreeOffset;
				cur_rec.right = cur_rec.left + min(8, cx);
				tree_start = cur_rec.left + 1;
				tree_end = cur_rec.right;
				//normal column stuff
				cur_rec.left = cur_rec.right + 1;
				cur_rec.right = tree_start + cx - iTreeOffset;
				DrawSourceItem(dc, 5, &cur_rec, content);
				cur_rec.left = iNextLeft;
			} else {
				cur_rec.right += cx;
				DrawSourceItem(dc, iColumn, &cur_rec, content);
				cur_rec.left += cx;
			}
		}
	}

	//draw rectangle around selected item(s)
	if (content->type == FILE_TYPE && (lpDrawItemStruct->itemState & ODS_SELECTED))
	{
		RECT outline_rec = lpDrawItemStruct->rcItem;

		outline_rec.top--;
		outline_rec.bottom++;
		dc.FrameRect(&outline_rec, &CBrush(GetBkColor()));
		outline_rec.top++;
		outline_rec.bottom--;
		outline_rec.left++;
		outline_rec.right--;

		if(notFirst && (GetItemState(lpDrawItemStruct->itemID - 1, LVIS_SELECTED))) {
			CtrlItem_Struct* prev = (CtrlItem_Struct*)this->GetItemData(lpDrawItemStruct->itemID - 1);
			if(prev->type == FILE_TYPE)
				outline_rec.top--;
		} 

		if(notLast && (GetItemState(lpDrawItemStruct->itemID + 1, LVIS_SELECTED))) {
			CtrlItem_Struct* next = (CtrlItem_Struct*)this->GetItemData(lpDrawItemStruct->itemID + 1);
			if(next->type == FILE_TYPE)
				outline_rec.bottom++;
		} 

		if(bCtrlFocused)
			dc.FrameRect(&outline_rec, &CBrush(m_crFocusLine));
		else
			dc.FrameRect(&outline_rec, &CBrush(m_crNoFocusLine));
	}
	//draw focus rectangle around non-highlightable items when they have the focus
	else if (((lpDrawItemStruct->itemState & ODS_FOCUS) == ODS_FOCUS) && (GetFocus() == this))
	{
		RECT focus_rec;
		focus_rec.top    = lpDrawItemStruct->rcItem.top;
		focus_rec.bottom = lpDrawItemStruct->rcItem.bottom;
		focus_rec.left   = lpDrawItemStruct->rcItem.left + 1;
		focus_rec.right  = lpDrawItemStruct->rcItem.right - 1;
		dc.FrameRect(&focus_rec, &CBrush(m_crNoFocusLine));
	}

	//draw tree last so it draws over selected and focus (looks better)
	// NEO: NTS - [NeoTreeStyle] -- Xanatos -->
	if(thePrefs.UseTreeStyle()){
		if(tree_start < tree_end)
		{
			//set new bounds
			RECT tree_rect;
			tree_rect.top    = lpDrawItemStruct->rcItem.top;
			tree_rect.bottom = lpDrawItemStruct->rcItem.bottom;
			tree_rect.left   = tree_start;
			tree_rect.right  = tree_end;
			dc->SetBoundsRect(&tree_rect, DCB_DISABLE);

			//gather some information
			BOOL hasNext = notLast &&
				((CtrlItem_Struct*)this->GetItemData(lpDrawItemStruct->itemID + 1))->type != FILE_TYPE;
			BOOL isOpenRoot = hasNext && content->type == FILE_TYPE;
			BOOL isChild = content->type != FILE_TYPE;

			//might as well calculate these now
			int treeCenter = tree_start + 4;
			int middle = (cur_rec.top + cur_rec.bottom + 1) / 2;

			//set up a new pen for drawing the tree
			CPen pn, *oldpn;
			pn.CreatePen(PS_SOLID, 1, RGB(128,128,128)/*m_crWindowText*/);
			oldpn = dc->SelectObject(&pn);

			if(isChild)
			{
				//draw the line to the status bar
				dc->MoveTo(tree_end+10, middle);
				dc->LineTo(tree_start + 4, middle);

				//draw the line to the child node
				if(hasNext)
				{
					dc->MoveTo(treeCenter, middle);
					dc->LineTo(treeCenter, cur_rec.bottom + 1);
				}
			}
			else if (isOpenRoot || (content->type == FILE_TYPE /* && itemdata->parts > 1*/))
			{
				//draw box
				RECT circle_rec;
				circle_rec.top    = middle - 5;
				circle_rec.bottom = middle + 4;
				circle_rec.left   = treeCenter - 4;
				circle_rec.right  = treeCenter + 5;
				dc->FrameRect(&circle_rec, &CBrush(RGB(128,128,128)/*m_crWindowText*/));
				CPen penBlack;
				penBlack.CreatePen(PS_SOLID, 1, m_crWindowText);
				CPen* pOldPen2;
				pOldPen2 = dc->SelectObject(&penBlack);


				CPartFile *lpPartFile = (CPartFile*)content->value;

				if ( lpPartFile->GetSourceCount() > 0 || lpPartFile->GetSrcA4AFCount() > 0
						  &&  !(lpPartFile->GetStatus() == PS_COMPLETING || lpPartFile->GetStatus() == PS_COMPLETE || lpPartFile->GetStatus() == PS_STOPPED) )
				{
					dc->MoveTo(treeCenter-2,middle - 1);
					dc->LineTo(treeCenter+3,middle - 1);

					if (!lpPartFile->srcarevisible)
					{
						dc->MoveTo(treeCenter,middle-3);
						dc->LineTo(treeCenter,middle+2);
					}
				}
				dc->SelectObject(pOldPen2);
				//draw the line to the child node
				if (hasNext)
				{
					dc->MoveTo(treeCenter, middle + 4);
					dc->LineTo(treeCenter, cur_rec.bottom + 1);
				}
			}

			//draw the line back up to parent node
			if (notFirst && isChild)
			{
				dc->MoveTo(treeCenter, middle);
				dc->LineTo(treeCenter, cur_rec.top - 1);
			}

			//put the old pen back
			dc->SelectObject(oldpn);
			pn.DeleteObject();
		}
	}
	else
	// NEO: NTS END <-- Xanatos --

	if(tree_start < tree_end) {
		//set new bounds
		RECT tree_rect;
		tree_rect.top    = lpDrawItemStruct->rcItem.top;
		tree_rect.bottom = lpDrawItemStruct->rcItem.bottom;
		tree_rect.left   = tree_start;
		tree_rect.right  = tree_end;
		dc.SetBoundsRect(&tree_rect, DCB_DISABLE);

		//gather some information
		BOOL hasNext = notLast &&
			((CtrlItem_Struct*)this->GetItemData(lpDrawItemStruct->itemID + 1))->type != FILE_TYPE;
		BOOL isOpenRoot = hasNext && content->type == FILE_TYPE;
		BOOL isChild = content->type != FILE_TYPE;
		//BOOL isExpandable = !isChild && ((CPartFile*)content->value)->GetSourceCount() > 0;
		//might as well calculate these now
		int treeCenter = tree_start + 3;
		int middle = (cur_rec.top + cur_rec.bottom + 1) / 2;

		//set up a new pen for drawing the tree
		CPen pn, *oldpn;
		pn.CreatePen(PS_SOLID, 1, m_crWindowText);
		oldpn = dc.SelectObject(&pn);

		if(isChild) {
			//draw the line to the status bar
			dc.MoveTo(tree_end, middle);
			dc.LineTo(tree_start + 3, middle);

			//draw the line to the child node
			if(hasNext) {
				dc.MoveTo(treeCenter, middle);
				dc.LineTo(treeCenter, cur_rec.bottom + 1);
			}
		} else if(isOpenRoot) {
			//draw circle
			RECT circle_rec;
			COLORREF crBk = dc.GetBkColor();
			circle_rec.top    = middle - 2;
			circle_rec.bottom = middle + 3;
			circle_rec.left   = treeCenter - 2;
			circle_rec.right  = treeCenter + 3;
			dc.FrameRect(&circle_rec, &CBrush(m_crWindowText));
			dc.SetPixelV(circle_rec.left,      circle_rec.top,    crBk);
			dc.SetPixelV(circle_rec.right - 1, circle_rec.top,    crBk);
			dc.SetPixelV(circle_rec.left,      circle_rec.bottom - 1, crBk);
			dc.SetPixelV(circle_rec.right - 1, circle_rec.bottom - 1, crBk);
			//draw the line to the child node
			if(hasNext) {
				dc.MoveTo(treeCenter, middle + 3);
				dc.LineTo(treeCenter, cur_rec.bottom + 1);
			}
		} /*else if(isExpandable) {
			//draw a + sign
			dc.MoveTo(treeCenter, middle - 2);
			dc.LineTo(treeCenter, middle + 3);
			dc.MoveTo(treeCenter - 2, middle);
			dc.LineTo(treeCenter + 3, middle);
		}*/

		//draw the line back up to parent node
		if(notFirst && isChild) {
			dc.MoveTo(treeCenter, middle);
			dc.LineTo(treeCenter, cur_rec.top - 1);
		}

		//put the old pen back
		dc.SelectObject(oldpn);
		pn.DeleteObject();
	}

	//put the original objects back
	if (m_crWindowTextBk == CLR_NONE)
		dc.SetBkMode(iOldBkMode);
	dc.SelectObject(pOldFont);
	dc.SetTextColor(crOldTextColor);
}

void CDownloadListCtrl::HideSources(CPartFile* toCollapse)
{
	SetRedraw(false);
	// NEO: SEa - [SortAltExtension] -- Xanatos -->
	if(toCollapse->srcarevisible==true)
		SetAlternate(FALSE);
	// NEO: SEa END <-- Xanatos --
	int pre = 0;
	int post = 0;
	for (int i = 0; i < GetItemCount(); i++)
	{
		CtrlItem_Struct* item = (CtrlItem_Struct*)GetItemData(i);
		if (item->owner == toCollapse)
		{
			pre++;
			item->dwUpdated = 0;
			item->status.DeleteObject();
			DeleteItem(i--);
			post++;
		}
	}
	if (pre - post == 0)
		toCollapse->srcarevisible = false;
	SetRedraw(true);
}

void CDownloadListCtrl::ExpandCollapseItem(int iItem, int iAction, bool bCollapseSource)
{
	if (iItem == -1)
		return;
	CtrlItem_Struct* content = (CtrlItem_Struct*)GetItemData(iItem);

	// to collapse/expand files when one of its source is selected
	if (bCollapseSource && content->parent != NULL)
	{
		content=content->parent;
		
 		LVFINDINFO find;
		find.flags = LVFI_PARAM;
		find.lParam = (LPARAM)content;
		iItem = FindItem(&find);
		if (iItem == -1)
			return;
	}

	if (!content || content->type != FILE_TYPE)
		return;
	
	CPartFile* partfile = reinterpret_cast<CPartFile*>(content->value);
	if (!partfile)
		return;

	if (partfile->CanOpenFile()) {
		partfile->OpenFile();
		return;
	}

	// Check if the source branch is disable
	if (!partfile->srcarevisible)
	{
		// NEO: SEa - [SortAltExtension] -- Xanatos -->
		//if (IsAlternate()) // only one file at the time
		//	return;
		// NEO: SEa END <-- Xanatos --
		if (iAction > COLLAPSE_ONLY)
		{
			SetRedraw(false);
			
			// Go throught the whole list to find out the sources for this file
			// Remark: don't use GetSourceCount() => UNAVAILABLE_SOURCE
			for (ListItems::const_iterator it = m_ListItems.begin(); it != m_ListItems.end(); it++)
			{
				const CtrlItem_Struct* cur_item = it->second;
				if (cur_item->owner == partfile)
				{
					partfile->srcarevisible = true;
					InsertItem(LVIF_PARAM|LVIF_TEXT, iItem+1, LPSTR_TEXTCALLBACK, 0, 0, 0, (LPARAM)cur_item);
				}
			}

			SetRedraw(true);
		}
	}
	else {
		if (iAction == EXPAND_COLLAPSE || iAction == COLLAPSE_ONLY)
		{
			if (GetItemState(iItem, LVIS_SELECTED | LVIS_FOCUSED) != (LVIS_SELECTED | LVIS_FOCUSED))
			{
				SetItemState(iItem, LVIS_SELECTED | LVIS_FOCUSED, LVIS_SELECTED | LVIS_FOCUSED);
				SetSelectionMark(iItem);
			}
			HideSources(partfile);
		}
	}

	// NEO: SE - [SortExtension] -- Xanatos -->
	if(partfile->srcarevisible == true)
		SetAlternate(TRUE); // NEO: SEa - [SortAltExtension]

	AlterSortArrow();

	uint8 adder=0;
	if ((GetSortItem()!=9 && GetSortItem()!=2 && (GetSortItem()!=3 || !IsAlternate())) || !m_bRemainSort ) // MOD - [SessionDL] <-- Xanatos --
		SetSortArrow();
	else {
		SetSortArrow(GetSortItem(), GetSortAscending()?arrowDoubleUp : arrowDoubleDown);
		// MOD - [SessionDL] -- Xanatos -->
		if(GetSortItem()==2)
			adder=18;
		else if(GetSortItem()==3 && IsAlternate())
			adder=27;
		else
		// MOD END <-- Xanatos --
			adder=81;
	}

	if (thePrefs.DisableAutoSort() != 1 && IsAlternate())
		SortItems(SortProc, GetSortItem() + (GetSortAscending()? 0:100) + 2000 + adder); // NEO: SEa - [SortAltExtension]
	// NEO: SE END <-- Xanatos --
}

void CDownloadListCtrl::OnItemActivate(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMITEMACTIVATE pNMIA = reinterpret_cast<LPNMITEMACTIVATE>(pNMHDR);

	if (thePrefs.IsDoubleClickEnabled() || pNMIA->iSubItem > 0)
		ExpandCollapseItem(pNMIA->iItem, EXPAND_COLLAPSE);
	*pResult = 0;
}

void CDownloadListCtrl::OnContextMenu(CWnd* /*pWnd*/, CPoint point)
{
	int iSel = GetNextItem(-1, LVIS_SELECTED);
	if (iSel != -1)
	{
		const CtrlItem_Struct* content = (CtrlItem_Struct*)GetItemData(iSel);
		if (content->type == FILE_TYPE)
		{
			// get merged settings
			bool bFirstItem = true;
			int iSelectedItems = 0;
			int iFilesNotDone = 0;
			int iFilesToPause = 0;
			int iFilesToStop = 0;
			int iFilesToResume = 0;
			// NEO: MOD - [NeoMenus] -- Xanatos -->
			int iFilesNotStopped = 0;
			// NEO: MOD END <-- Xanatos --
			int iFilesToOpen = 0;
            int iFilesGetPreviewParts = 0;
            int iFilesPreviewType = 0;
			int iFilesToPreview = 0;
			int iFilesToCancel = 0;
			UINT uPrioMenuItem = 0;
			// NEO: MOD - [NeoMenus] -- Xanatos -->
			UINT uUpPrioMenuItem = 0;
			UINT uPermMenuItem = 0; // NEO: SSP - [ShowSharePermissions]
			int iFilesProtected = 0; // NEO: PP - [PasswordProtection]
			CPartFile* pSingleSelFile = NULL;
			// NEO: MOD END <-- Xanatos --
			POSITION pos = GetFirstSelectedItemPosition();
			while (pos)
			{
				const CtrlItem_Struct* pItemData = (CtrlItem_Struct*)GetItemData(GetNextSelectedItem(pos));
				if (pItemData->type != FILE_TYPE)
					continue;
				const CPartFile* pFile = (CPartFile*)pItemData->value;
				if (bFirstItem)
					pSingleSelFile = const_cast <CPartFile*> (pFile); // NEO: MOD - [NeoMenus] <-- Xanatos --
				iSelectedItems++;

				bool bFileDone = (pFile->GetStatus()==PS_COMPLETE || pFile->GetStatus()==PS_COMPLETING);
				iFilesToCancel += pFile->GetStatus() != PS_COMPLETING ? 1 : 0;
				iFilesNotDone += !bFileDone ? 1 : 0;
				iFilesToStop += pFile->CanStopFile() ? 1 : 0;
				iFilesToPause += pFile->CanPauseFile() ? 1 : 0;
				iFilesToResume += pFile->CanResumeFile() ? 1 : 0;
				// NEO: MOD - [NeoMenus] -- Xanatos -->
				iFilesNotStopped += pFile->IsStopped() ? 0 : 1;
				// NEO: MOD END <-- Xanatos --
				iFilesToOpen += pFile->CanOpenFile() ? 1 : 0;
                iFilesGetPreviewParts += pFile->GetPreviewPrio() ? 1 : 0;
                iFilesPreviewType += pFile->IsPreviewableFileType() ? 1 : 0;
				iFilesToPreview += pFile->IsReadyForPreview() ? 1 : 0;

				UINT uCurPrioMenuItem = 0;
				if (pFile->IsAutoDownPriority())
					uCurPrioMenuItem = MP_DLPRIOAUTO;
				else if (pFile->GetDownPriority() == PR_HIGH)
					uCurPrioMenuItem = MP_DLPRIOHIGH;
				else if (pFile->GetDownPriority() == PR_NORMAL)
					uCurPrioMenuItem = MP_DLPRIONORMAL;
				else if (pFile->GetDownPriority() == PR_LOW)
					uCurPrioMenuItem = MP_DLPRIOLOW;
				else
					ASSERT(0);

                if (bFirstItem)
					uPrioMenuItem = uCurPrioMenuItem;
                else if (uPrioMenuItem != uCurPrioMenuItem)
					uPrioMenuItem = 0;

				// NEO: MOD - [NeoMenus] -- Xanatos -->
				UINT uCurUpPrioMenuItem = 0;
				if (pFile->IsAutoUpPriority())
					uCurUpPrioMenuItem = MP_PRIOAUTO;
				else if (pFile->GetUpPriority() == PR_VERYLOW)
					uCurUpPrioMenuItem = MP_PRIOVERYLOW;
				else if (pFile->GetUpPriority() == PR_LOW)
					uCurUpPrioMenuItem = MP_PRIOLOW;
				else if (pFile->GetUpPriority() == PR_NORMAL)
					uCurUpPrioMenuItem = MP_PRIONORMAL;
				else if (pFile->GetUpPriority() == PR_HIGH)
					uCurUpPrioMenuItem = MP_PRIOHIGH;
				else if (pFile->GetUpPriority() == PR_VERYHIGH)
					uCurUpPrioMenuItem = MP_PRIOVERYHIGH;
				else
					ASSERT(0);

                if (bFirstItem)
					uUpPrioMenuItem = uCurUpPrioMenuItem;
                else if (uUpPrioMenuItem != uCurUpPrioMenuItem)
					uUpPrioMenuItem = 0;

				iFilesProtected += (pFile->IsPWProt()); // NEO: PP - [PasswordProtection]

				// NEO: SSP - [ShowSharePermissions]
				UINT uCurPermMenuItem = 0;
				if (pFile->GetPermissions() == PERM_DEFAULT)
					uCurPermMenuItem = MP_PERMDEFAULT;
				else if (pFile->GetPermissions() == PERM_ALL)
					uCurPermMenuItem = MP_PERMALL;
				else if (pFile->GetPermissions() == PERM_COMMUNITY) // NEO: NC - [NiceCommunity]
					uCurPermMenuItem = MP_PERMCOMMUNITY;
				else if (pFile->GetPermissions() == PERM_FRIENDS)
					uCurPermMenuItem = MP_PERMFRIENDS;
				else if (pFile->GetPermissions() == PERM_NONE)
					uCurPermMenuItem = MP_PERMNONE;
				else
					ASSERT(0);

				if (bFirstItem)
					uPermMenuItem = uCurPermMenuItem;
				else if (uPermMenuItem != uCurPermMenuItem)
					uPermMenuItem = 0;
				// NEO: SSP END
				// NEO: MOD END <-- Xanatos --

				bFirstItem = false;
			}

			// NEO: MOD - [NeoMenus] -- Xanatos -->
			// enable commands if there is at least one item which can be used for the action
			m_FileMenu.EnableMenuItem(MP_RESUME, iFilesToResume > 0 ? MF_ENABLED : MF_GRAYED);

			// NEO: OCF - [OnlyCompleetFiles]
			m_FileMenu.EnableMenuItem(MP_FORCE, iFilesToStop > 0 ? MF_ENABLED : MF_GRAYED);
			//m_FileMenu.CheckMenuItem(MP_FORCE, pSingleSelFile->GetForced() ? MF_CHECKED : MF_UNCHECKED);
			m_FileMenu.ChangeMenuIcon(MP_FORCE, GetResString(IDS_X_DL_FORCE), pSingleSelFile->GetForced() ? _T("FORCE2") : _T("FORCE"));
			// NEO: OCF END

			// NEO: SD - [StandByDL]
			m_FileMenu.EnableMenuItem(MP_STANDBY, iFilesToStop > 0 ? MF_ENABLED : MF_GRAYED);
			//m_FileMenu.CheckMenuItem(MP_STANDBY, pSingleSelFile->GetStandBy() ? MF_CHECKED : MF_UNCHECKED);
			m_FileMenu.ChangeMenuIcon(MP_STANDBY, GetResString(IDS_X_DL_STANDBY), pSingleSelFile->GetStandBy() ? _T("STANDBY2") : _T("STANDBY"));
			// NEO: SD END

			// NEO: SC - [SuspendCollecting]
			m_FileMenu.EnableMenuItem(MP_SUSPEND, iFilesToStop > 0 ? MF_ENABLED : MF_GRAYED);
			//m_FileMenu.CheckMenuItem(MP_SUSPEND, pSingleSelFile->GetSuspend() ? MF_CHECKED : MF_UNCHECKED);
			m_FileMenu.ChangeMenuIcon(MP_SUSPEND, GetResString(IDS_X_DL_SUSPEND), pSingleSelFile->GetSuspend() ? _T("SUSPEND2") : _T("SUSPEND"));
			// NEO: SC END

			m_FileMenu.EnableMenuItem(MP_CANCEL, iFilesToCancel > 0 ? MF_ENABLED : MF_GRAYED);
			m_FileMenu.EnableMenuItem(MP_STOP, iFilesToStop > 0 ? MF_ENABLED : MF_GRAYED);
			m_FileMenu.EnableMenuItem(MP_PAUSE, iFilesToPause > 0 ? MF_ENABLED : MF_GRAYED);
			m_FileMenu.EnableMenuItem((UINT_PTR)m_PrioMenu.m_hMenu, iFilesNotDone > 0 ? MF_ENABLED : MF_GRAYED);
			m_PrioMenu.CheckMenuRadioItem(MP_DLPRIOLOW, MP_DLPRIOAUTO, uPrioMenuItem, 0);
			m_FileMenu.EnableMenuItem((UINT_PTR)m_UpPrioMenu.m_hMenu, iSelectedItems > 0 ? MF_ENABLED : MF_GRAYED);
			m_UpPrioMenu.CheckMenuRadioItem(MP_PRIOVERYLOW, MP_PRIOAUTO, uUpPrioMenuItem, 0);
			m_UpPrioMenu.CheckMenuItem(MP_PRIORELEASE, pSingleSelFile->IsReleasePriority() ? MF_CHECKED : MF_UNCHECKED); // NEO: RT - [ReleaseTweaks]
			// NEO: SSP - [ShowSharePermissions]
			m_FileMenu.EnableMenuItem((UINT_PTR)m_PermMenu.m_hMenu, (iSelectedItems > 0 && thePrefs.UseCustomPermissions()) ? MF_ENABLED : MF_GRAYED);
			m_PermMenu.CheckMenuRadioItem(MP_PERMALL, MP_PERMDEFAULT, uPermMenuItem, 0);
			// NEO: SSP END
			// NEO: PP - [PasswordProtection]
			m_PWProtMenu.EnableMenuItem(MP_PWPROT_SET, (iSelectedItems > 1 || (iSelectedItems == 1 && !iFilesProtected)) ? MF_ENABLED : MF_GRAYED);
			m_PWProtMenu.EnableMenuItem(MP_PWPROT_CHANGE, (iFilesProtected > 0) ? MF_ENABLED : MF_GRAYED);
			m_PWProtMenu.EnableMenuItem(MP_PWPROT_UNSET, (iFilesProtected > 0) ? MF_ENABLED : MF_GRAYED);
			// NEO: PP END
			// NEO: MOD END <-- Xanatos --
			
			bool bOpenEnabled = (iSelectedItems == 1 && iFilesToOpen == 1);
			m_FileMenu.EnableMenuItem(MP_OPEN, bOpenEnabled ? MF_ENABLED : MF_GRAYED);
            if(thePrefs.IsExtControlsEnabled() && !thePrefs.GetPreviewPrio()) {
			    m_FileMenu.EnableMenuItem(MP_TRY_TO_GET_PREVIEW_PARTS, (iSelectedItems == 1 && iFilesPreviewType == 1 && iFilesToPreview == 0 && iFilesNotDone == 1) ? MF_ENABLED : MF_GRAYED);
			    m_FileMenu.CheckMenuItem(MP_TRY_TO_GET_PREVIEW_PARTS, (iSelectedItems == 1 && iFilesGetPreviewParts == 1) ? MF_CHECKED : MF_UNCHECKED);
            }
			m_FileMenu.EnableMenuItem(MP_PREVIEW, (iSelectedItems == 1 && iFilesToPreview == 1) ? MF_ENABLED : MF_GRAYED);
			CTitleMenu PreviewMenu;
			PreviewMenu.CreateMenu();
			PreviewMenu.AddMenuTitle(NULL, true);
			int iPreviewMenuEntries = thePreviewApps.GetAllMenuEntries(PreviewMenu, (iSelectedItems == 1) ? pSingleSelFile : NULL); // NEO: MOD - [NeoMenus] <-- Xanatos --
			if (iPreviewMenuEntries)
				m_FileMenu.InsertMenu(MP_METINFO, MF_POPUP | (iSelectedItems == 1 ? MF_ENABLED : MF_GRAYED), (UINT_PTR)PreviewMenu.m_hMenu, GetResString(IDS_DL_PREVIEW));

			bool bDetailsEnabled = (iSelectedItems > 0);
			m_FileMenu.EnableMenuItem(MP_METINFO, bDetailsEnabled ? MF_ENABLED : MF_GRAYED);
			if (thePrefs.IsDoubleClickEnabled() && bOpenEnabled)
				m_FileMenu.SetDefaultItem(MP_OPEN);
			else if (!thePrefs.IsDoubleClickEnabled() && bDetailsEnabled)
				m_FileMenu.SetDefaultItem(MP_METINFO);
			else
				m_FileMenu.SetDefaultItem((UINT)-1);
			// NEO: MOD - [NeoMenus] -- Xanatos -->
			m_FileMenu.EnableMenuItem(MP_VIEWFILECOMMENTS, (iSelectedItems == 1 /*&& iFilesNotDone == 1*/) ? MF_ENABLED : MF_GRAYED);
			// NEO: FCFG - [FileConfiguration]
			m_FileMenu.EnableMenuItem(MP_TWEAKS, (iSelectedItems > 0 /*iFilesNotDone > 0*/) ? MF_ENABLED : MF_GRAYED);
			m_FileMenu.EnableMenuItem((UINT_PTR)m_ConfigMenu.m_hMenu, (iSelectedItems > 0 /*iFilesNotDone > 0*/) ? MF_ENABLED : MF_GRAYED);
			m_ConfigMenu.EnableMenuItem(MP_FCFG_COPY, iSelectedItems == 1 ? MF_ENABLED : MF_GRAYED);
			m_ConfigMenu.EnableMenuItem(MP_FCFG_PASTE, theApp.IsEd2kLinkInClipboard("NEO:FCFG",8) ? MF_ENABLED : MF_GRAYED);
			m_ConfigMenu.EnableMenuItem(MP_FCFG_PASTE2, theApp.IsEd2kLinkInClipboard("NEO:FCFG",8) && theApp.CopyTextFromClipboard().Find(_T("PCFG:")) > -1 ? MF_ENABLED : MF_GRAYED);
			// NEO: FCFG END
			m_FileMenu.EnableMenuItem((UINT_PTR)m_CollectMenu.m_hMenu, iFilesNotStopped > 0 ? MF_ENABLED : MF_GRAYED); // NEO: MSH - [ManualSourceHandling]
			m_FileMenu.EnableMenuItem((UINT_PTR)m_SourcesMenu.m_hMenu, (iFilesNotStopped > 0) ? MF_ENABLED : MF_GRAYED); 
#ifdef NEO_SS // NEO: NSS - [NeoSourceStorage]
			m_SourcesMenu.EnableMenuItem(MP_LOADSOURCE, (iFilesNotStopped > 0 && pSingleSelFile->PartPrefs.EnableSourceStorage()) ? MF_ENABLED : MF_GRAYED);
			m_SourcesMenu.EnableMenuItem(MP_SAVESOURCE, (iFilesNotStopped > 0 && pSingleSelFile->PartPrefs.EnableSourceStorage()) ? MF_ENABLED : MF_GRAYED);

			m_SourcesMenu.EnableMenuItem(MP_IMPORTSOURCE, (iSelectedItems > 0 && pSingleSelFile->PartPrefs.EnableSourceStorage()) ? MF_ENABLED : MF_GRAYED);
			m_SourcesMenu.EnableMenuItem(MP_EXPORTSOURCE, (iSelectedItems > 0 && pSingleSelFile->PartPrefs.EnableSourceStorage()) ? MF_ENABLED : MF_GRAYED);
#ifdef NEO_CD // NEO: NCD - [NeoClientDatabase] // NEO: SFL - [SourceFileList]
			m_SourcesMenu.EnableMenuItem(MP_FINDSOURCES, (iFilesNotStopped > 0 && pSingleSelFile->PartPrefs.EnableSourceStorage()) ? MF_ENABLED : MF_GRAYED);
#endif // NEO_CD // NEO: NCD END // NEO: SFL END
#endif // NEO_SS // NEO: NSS END

			m_FileMenu.EnableMenuItem((UINT_PTR)m_ReaskMenu.m_hMenu, iFilesNotStopped > 0 ? MF_ENABLED : MF_GRAYED); // NEO: MDR - [ManualDownloadReask]
			m_FileMenu.EnableMenuItem((UINT_PTR)m_A4AFMenu.m_hMenu, iFilesNotStopped > 0 ? MF_ENABLED : MF_GRAYED); // NEO: MCM - [ManualClientManagement]
			m_FileMenu.EnableMenuItem((UINT_PTR)m_DropMenu.m_hMenu, iFilesNotStopped > 0 ? MF_ENABLED : MF_GRAYED); // NEO: MDS - [ManualDropSources]

#ifdef VOODOO // NEO: VOODOOn - [VoodooExtensionForNeo]
			m_CollectMenu.EnableMenuItem(MP_COLLECT_VOODOO_SOURCES, (pSingleSelFile->KnownPrefs.UseVoodoo()) ? MF_ENABLED : MF_GRAYED);
#endif // VOODOO // NEO: VOODOOn END

			// NEO: AHL - [AutoHardLimit]
			m_CollectMenu.EnableMenuItem(MP_AHL_INCREASE, (pSingleSelFile->PartPrefs.UseAutoHardLimit()) ? MF_ENABLED : MF_GRAYED);
			m_CollectMenu.EnableMenuItem(MP_AHL_DECREASE, (pSingleSelFile->PartPrefs.UseAutoHardLimit()) ? MF_ENABLED : MF_GRAYED);
			// NEO: AHL END

			m_SourcesMenu.EnableMenuItem(MP_ADDSOURCE, (iSelectedItems == 1 && iFilesToStop == 1) ? MF_ENABLED : MF_GRAYED);
#ifdef NEO_CD // NEO: NCD - [NeoClientDatabase] // NEO: SFL - [SourceFileList]
			m_SourcesMenu.EnableMenuItem(MP_FINDSOURCES, (thePrefs.SaveSourceFileList()) ? MF_ENABLED : MF_GRAYED);
#endif // NEO_CD // NEO: NCD END // NEO: SFL END

#ifdef NEO_SS // NEO: NSS - [NeoSourceStorage]
			m_SourcesMenu.EnableMenuItem(MP_REASK_LOADEDGROUP, (iFilesNotDone > 0 && pSingleSelFile->PartPrefs.GroupStoredSourceReask()) ? MF_ENABLED : MF_GRAYED);
#endif // NEO_SS // NEO: NSS END

			// NEO: MCM - [ManualClientManagement]
#ifdef A4AF_CATS // NEO: MAC - [MorphA4AFCategories]
			m_A4AFMenu.EnableMenuItem(MP_FORCEA4AF, thePrefs.UseSmartA4AFSwapping() && iSelectedItems == 1 && iFilesNotDone == 1? MF_ENABLED : MF_GRAYED);
			//m_A4AFMenu.CheckMenuItem(MP_FORCEA4AF, iSelectedItems == 1 && (theApp.downloadqueue->forcea4af_file == pSingleSelFile) ? MF_CHECKED : MF_UNCHECKED);
			m_A4AFMenu.ChangeMenuIcon(MP_FORCEA4AF, GetResString(IDS_X_A4AF_FORCEALL), (theApp.downloadqueue->forcea4af_file == pSingleSelFile) ? _T("ADVA4AFALL2") : _T("ADVA4AFALL"));
#endif // A4AF_CATS // NEO: MAC END
			// NEO: MCM END

			m_FileMenu.EnableMenuItem(MP_IMPORT, (iSelectedItems == 1 && iFilesNotDone == 1) ? MF_ENABLED : MF_GRAYED); // NEO: PIX - [PartImportExport]
			if(thePrefs.GetAllocCompleteMode() == false)
				m_FileMenu.EnableMenuItem(MP_PREALOCATE, (iFilesNotDone > 0 && pSingleSelFile->IncompleteAllocateSpace()) ? MF_ENABLED : MF_GRAYED); // NEO: MOD - [PreAllocate]
			m_FileMenu.EnableMenuItem((UINT_PTR)m_TempDirMenu.m_hMenu, (iFilesNotDone > 0) ? MF_ENABLED : MF_GRAYED); // NEO: MTD - [MultiTempDirectories]
			// NEO: MOD END <-- Xanatos --

			int total;
			m_FileMenu.EnableMenuItem(MP_CLEARCOMPLETED, GetCompleteDownloads(curTab, total) > 0 ? MF_ENABLED : MF_GRAYED);

			if(thePrefs.GetShowCopyEd2kLinkCmd())
				m_FileMenu.EnableMenuItem(MP_GETED2KLINK, iSelectedItems > 0 ? MF_ENABLED : MF_GRAYED);
			else
				m_FileMenu.EnableMenuItem(MP_SHOWED2KLINK, iSelectedItems > 0 ? MF_ENABLED : MF_GRAYED);
			m_FileMenu.EnableMenuItem(MP_PASTE, theApp.IsEd2kFileLinkInClipboard() ? MF_ENABLED : MF_GRAYED);
			m_FileMenu.EnableMenuItem(MP_FIND, GetItemCount() > 0 ? MF_ENABLED : MF_GRAYED);
			m_FileMenu.EnableMenuItem(MP_SEARCHRELATED, iSelectedItems == 1 && theApp.emuledlg->searchwnd->CanSearchRelatedFiles() ? MF_ENABLED : MF_GRAYED);
			m_FileMenu.EnableMenuItem(MP_MASSRENAME, iSelectedItems > 0 ? MF_ENABLED : MF_GRAYED); // NEO: MMR - [MorphMassRemane] <-- Xanatos --

			CTitleMenu WebMenu;
			WebMenu.CreateMenu();
			WebMenu.AddMenuTitle(NULL, true);
			int iWebMenuEntries = theWebServices.GetFileMenuEntries(&WebMenu);
			UINT flag = (iWebMenuEntries == 0 || iSelectedItems != 1) ? MF_GRAYED : MF_ENABLED;
			m_FileMenu.AppendMenu(MF_POPUP | flag, (UINT_PTR)WebMenu.m_hMenu, GetResString(IDS_WEBSERVICES), _T("WEB"));

			// create cat-submenue
			CTitleMenu CatsMenu;
			CatsMenu.CreateMenu();
			CatsMenu.AddMenuTitle(NULL, true);
			UpdateCatMenu(CatsMenu,pSingleSelFile ? pSingleSelFile->GetCategory() : 0); // NEO: NSC - [NeoSharedCategories] <-- Xanatos --
			flag = (thePrefs.GetCatCount() == 1) ? MF_GRAYED : MF_ENABLED;
			/*CString label;
			if (thePrefs.GetCatCount()>1) {
				for (int i = 0; i < thePrefs.GetCatCount(); i++){
					if (i>0) {
						label=thePrefs.GetCategory(i)->title;
						label.Replace(_T("&"), _T("&&") );
					}
					CatsMenu.AppendMenu(MF_STRING,MP_ASSIGNCAT+i, (i==0)?GetResString(IDS_CAT_UNASSIGN):label);
				}
			}*/
			m_FileMenu.AppendMenu(MF_POPUP | flag, (UINT_PTR)CatsMenu.m_hMenu, GetResString(IDS_TOCAT), _T("CATEGORY"));

#ifdef A4AF_CATS // NEO: MAC - [MorphA4AFCategories] -- Xanatos -->
			CTitleMenu mnuOrder;
			if (this->GetSelectedCount() > 1) {
				mnuOrder.CreatePopupMenu();
				mnuOrder.AddMenuTitle(NULL, true);
				mnuOrder.AppendMenu(MF_STRING, MP_CAT_ORDERAUTOINC, GetResString(IDS_X_CAT_MNUAUTOINC), _T("FILELINEARPRIOAUTO"));
				mnuOrder.AppendMenu(MF_STRING, MP_CAT_ORDERSTEPTHRU, GetResString(IDS_X_CAT_MNUSTEPTHRU), _T("FILELINEARPRIOMANUAL"));
				mnuOrder.AppendMenu(MF_STRING, MP_CAT_ORDERALLSAME, GetResString(IDS_X_CAT_MNUALLSAME), _T("FILELINEARPRIOSAME"));
				m_FileMenu.AppendMenu(MF_STRING | MF_POPUP, (UINT_PTR)mnuOrder.m_hMenu, GetResString(IDS_X_CAT_SETORDER), _T("FILELINEARPRIO"));
			}
			else {
				m_FileMenu.AppendMenu(MF_STRING, MP_CAT_SETRESUMEORDER, GetResString(IDS_X_CAT_SETORDER), _T("FILELINEARPRIO"));
			}
#endif // A4AF_CATS // NEO: MAC END <-- Xanatos --

			// NEO: MTD - [MultiTempDirectories] -- Xanatos -->
			CTitleMenu TempMoveMenu;
			TempMoveMenu.CreateMenu();
			TempMoveMenu.AddMenuTitle(NULL, true);
			UpdateMTDMenu(TempMoveMenu,pSingleSelFile->GetPath(),true);
			m_TempDirMenu.AppendMenu(MF_STRING|MF_POPUP,(UINT_PTR)TempMoveMenu.m_hMenu, GetResString(IDS_X_MTD_MOVE), _T("MTD_MOVE"));
			// NEO: MTD END <-- Xanatos --

			GetPopupMenuPos(*this, point);
			m_FileMenu.TrackPopupMenu(TPM_LEFTALIGN |TPM_RIGHTBUTTON, point.x, point.y, this);
			VERIFY( m_FileMenu.RemoveMenu(m_FileMenu.GetMenuItemCount() - 1, MF_BYPOSITION) );
			VERIFY( m_FileMenu.RemoveMenu(m_FileMenu.GetMenuItemCount() - 1, MF_BYPOSITION) );
			VERIFY( m_TempDirMenu.RemoveMenu(m_TempDirMenu.GetMenuItemCount() - 1, MF_BYPOSITION) ); // NEO: MTD - [MultiTempDirectories] <-- Xanatos --
			if (iPreviewMenuEntries)
				VERIFY( m_FileMenu.RemoveMenu((UINT)PreviewMenu.m_hMenu, MF_BYCOMMAND) );
#ifdef A4AF_CATS // NEO: MAC - [MorphA4AFCategories] -- Xanatos -->
			m_FileMenu.RemoveMenu(m_FileMenu.GetMenuItemCount()-1,MF_BYPOSITION);
			if (mnuOrder)
				VERIFY( mnuOrder.DestroyMenu() );
#endif // A4AF_CATS // NEO: MAC END <-- Xanatos --
			VERIFY( WebMenu.DestroyMenu() );
			VERIFY( CatsMenu.DestroyMenu() );
			VERIFY( PreviewMenu.DestroyMenu() );
			VERIFY( TempMoveMenu.DestroyMenu() ); // NEO: MTD - [MultiTempDirectories] <-- Xanatos --
		}
		else{
			// NEO: MOD - [NeoMenus] -- Xanatos -->
			CPartFile* pSingleSelFile = NULL;
			CUpDownClient* pSingleSelClient = NULL;
			int iSelectedItems = 0;
			int iThisFileItems = 0;
			int iOtherFileItems = 0;
			int iLoadingItems = 0;
			bool bFirstItem = true;

			POSITION pos = GetFirstSelectedItemPosition();
			while (pos)
			{
				const CtrlItem_Struct* pItemData = (CtrlItem_Struct*)GetItemData(GetNextSelectedItem(pos));
				if (pItemData->type == FILE_TYPE)
					continue;
				const CUpDownClient* pClient = (CUpDownClient*)pItemData->value;
				if (bFirstItem)
					pSingleSelClient = const_cast <CUpDownClient*> (pClient);
				if (bFirstItem)
					pSingleSelFile = (CPartFile*)pItemData->owner;
				iSelectedItems++;

				if(pSingleSelFile == pClient->GetRequestFile())
					iThisFileItems++;
				else
					iOtherFileItems++;

				if(pClient->GetDownloadState() == DS_DOWNLOADING)
					iLoadingItems++;
				bFirstItem = false;
			}

			CTitleMenu ClientMenu;
			ClientMenu.CreatePopupMenu();
			ClientMenu.AddMenuTitle(GetResString(IDS_CLIENTS), true);
			ClientMenu.AppendMenu(MF_STRING | (iSelectedItems == 1 && pSingleSelClient) ? MF_ENABLED : MF_GRAYED, MP_DETAIL, GetResString(IDS_SHOWDETAILS), _T("CLIENTDETAILS"));
			ClientMenu.SetDefaultItem(MP_DETAIL);
			ClientMenu.AppendMenu(MF_STRING | ((iSelectedItems == 1 && pSingleSelClient && pSingleSelClient->IsEd2kClient() && pSingleSelClient->GetViewSharedFilesSupport()) ? MF_ENABLED : MF_GRAYED), MP_SHOWLIST, GetResString(IDS_VIEWFILES), _T("VIEWFILES"));
			ClientMenu.AppendMenu(MF_SEPARATOR);
			ClientMenu.AppendMenu(MF_STRING | ((iSelectedItems == 1 && pSingleSelClient && pSingleSelClient->IsEd2kClient() && !pSingleSelClient->IsFriend()) ? MF_ENABLED : MF_GRAYED), MP_ADDFRIEND, GetResString(IDS_ADDFRIEND), _T("ADDFRIEND"));
			ClientMenu.AppendMenu(MF_STRING | ((iSelectedItems == 1 && pSingleSelClient && pSingleSelClient->IsEd2kClient() && pSingleSelClient->IsFriend()) ? MF_ENABLED : MF_GRAYED), MP_REMOVEFRIEND, GetResString(IDS_REMOVEFRIEND), _T("DELETEFRIEND"));
			ClientMenu.AppendMenu(MF_STRING | ((iSelectedItems == 1 && pSingleSelClient && pSingleSelClient->IsEd2kClient()) ? MF_ENABLED : MF_GRAYED), MP_MESSAGE, GetResString(IDS_SEND_MSG), _T("SENDMESSAGE"));
			ClientMenu.AppendMenu(MF_STRING | ((iSelectedItems == 1 && pSingleSelClient && pSingleSelClient->IsEd2kClient() && pSingleSelClient->IsFriend()) ? MF_ENABLED : MF_GRAYED), MP_FRIENDSLOT, GetResString(IDS_FRIENDSLOT), (pSingleSelClient && pSingleSelClient->IsEd2kClient() && pSingleSelClient->GetFriendSlot()) ? _T("FRIENDSLOT2") : _T("FRIENDSLOT"));
			// NEO: NXI - [NeoExtraInfo]
			if(pSingleSelClient && pSingleSelClient->m_ExtraInfo)
				ClientMenu.AppendMenu(MF_STRING	| ((iSelectedItems == 1 && pSingleSelClient->m_ExtraInfo->SomeInfosLen > 0) ? MF_ENABLED : MF_GRAYED), MP_SOMEINFO, StrLine(GetResString(IDS_X_SOMEINFO),pSingleSelClient->m_ExtraInfo->SomeInfosLen), _T("SOMEINFO"));
			// NEO: NXI END
			
			if (thePrefs.IsExtControlsEnabled())
				ClientMenu.AppendMenu(MF_SEPARATOR);


			// NEO: MCM - [ManualClientManagement]
			CTitleMenu A4AFMenu;
			A4AFMenu.CreateMenu();
			A4AFMenu.AddMenuTitle(GetResString(IDS_X_SRC_MANAGEMENT), true);
			if (thePrefs.IsExtControlsEnabled()) {
				A4AFMenu.AppendMenu(MF_STRING | ((iOtherFileItems > 0 && pSingleSelClient && pSingleSelClient->IsEd2kClient() && content->type == UNAVAILABLE_SOURCE) ? MF_ENABLED : MF_GRAYED),MP_SWAP_TO_CLIENT,GetResString(IDS_X_SWAP_TO_CLIENT), _T("SWAPTO"));
				A4AFMenu.AppendMenu(MF_STRING | ((iThisFileItems > 0 && pSingleSelClient && pSingleSelClient->IsEd2kClient() && content->type == AVAILABLE_SOURCE) ? MF_ENABLED : MF_GRAYED),MP_SWAP_FROM_CLIENT,GetResString(IDS_X_SWAP_FROM_CLIENT), _T("SWAPFROM"));
				A4AFMenu.AppendMenu(MF_STRING | ((iThisFileItems > 0 && pSingleSelClient && pSingleSelClient->IsEd2kClient() && (content->type == AVAILABLE_SOURCE || pSingleSelClient->IsSwapingDisabled()) ) ? MF_ENABLED : MF_GRAYED),MP_LOCK_CLIENT,GetResString((pSingleSelClient && pSingleSelClient->IsSwapingDisabled()) ? (content->owner == pSingleSelClient->GetRequestFile() ? IDS_X_MP_UNLOCK_CLIENT : IDS_X_MP_UNLOCKFROM_CLIENT) : IDS_X_MP_LOCK_CLIENT), (pSingleSelClient && pSingleSelClient->IsSwapingDisabled()) ? (content->owner == pSingleSelClient->GetRequestFile() ? _T("UNLOCK") : _T("UNLOCKFROM")) : _T("LOCKTO"));
				A4AFMenu.AppendMenu(MF_STRING | ((iSelectedItems > 0 && pSingleSelClient && pSingleSelClient->IsEd2kClient()) ? MF_ENABLED : MF_GRAYED),MP_DROP_CLIENT, GetResString(IDS_X_DROP_CLIENT), _T("DROPCLIENT"));
				A4AFMenu.AppendMenu(MF_STRING | ((iLoadingItems > 0 && pSingleSelClient && pSingleSelClient->IsEd2kClient()) ? MF_ENABLED : MF_GRAYED),MP_STOP_CLIENT, GetResString(IDS_X_STOP_CLIENT), _T("CANCEL"));
				
				ClientMenu.AppendMenu(MF_STRING|MF_POPUP,(UINT_PTR)A4AFMenu.m_hMenu, GetResString(IDS_X_SRC_MANAGEMENT), _T("MANAGECLIENT"));
			}
			// NEO: MCM END

			if (thePrefs.IsExtControlsEnabled())
				ClientMenu.AppendMenu(MF_STRING | ((pSingleSelClient && pSingleSelClient->IsEd2kClient()) ? MF_ENABLED : MF_GRAYED), MP_EXPORTCLIENT, GetResString(IDS_X_EXPORT_SINGLE_SRC), _T("SINGLESRC"));
			ClientMenu.AppendMenu(MF_SEPARATOR);
			ClientMenu.AppendMenu(MF_STRING | (GetItemCount() > 0 ? MF_ENABLED : MF_GRAYED), MP_FIND, GetResString(IDS_FIND), _T("Search"));
			if (Kademlia::CKademlia::IsRunning() && !Kademlia::CKademlia::IsConnected()){
				ClientMenu.AppendMenu(MF_SEPARATOR);
				ClientMenu.AppendMenu(MF_STRING | ((pSingleSelClient && pSingleSelClient->IsEd2kClient() && pSingleSelClient->GetKadPort()!=0) ? MF_ENABLED : MF_GRAYED), MP_BOOT, GetResString(IDS_BOOTSTRAP), _T("KADBOOTSTRAP"));
			}

			GetPopupMenuPos(*this, point);
			ClientMenu.TrackPopupMenu(TPM_LEFTALIGN |TPM_RIGHTBUTTON, point.x, point.y, this);
			
			VERIFY( A4AFMenu.DestroyMenu() );
			// NEO: MOD END <-- Xanatos --
			VERIFY( ClientMenu.DestroyMenu() );
		}
	}
	else{	// nothing selected
		int total;
		// NEO: MOD - [NeoMenus] -- Xanatos -->
		m_FileMenu.EnableMenuItem(MP_RESUME,MF_GRAYED);
		m_FileMenu.EnableMenuItem(MP_FORCE,MF_GRAYED); // NEO: OCF - [OnlyCompleetFiles]
		m_FileMenu.EnableMenuItem(MP_STANDBY,MF_GRAYED); // NEO: SD - [StandByDL]
		m_FileMenu.EnableMenuItem(MP_SUSPEND,MF_GRAYED); // NEO: SC - [SuspendCollecting]
		m_FileMenu.EnableMenuItem(MP_CANCEL,MF_GRAYED);
		m_FileMenu.EnableMenuItem(MP_PAUSE,MF_GRAYED);
		m_FileMenu.EnableMenuItem(MP_STOP,MF_GRAYED);
		
		m_FileMenu.EnableMenuItem((UINT_PTR)m_PrioMenu.m_hMenu, MF_GRAYED);
		m_FileMenu.EnableMenuItem((UINT_PTR)m_UpPrioMenu.m_hMenu, MF_GRAYED);
		m_FileMenu.EnableMenuItem((UINT_PTR)m_PermMenu.m_hMenu, MF_GRAYED); // NEO: SSP - [ShowSharePermissions]
		// NEO: PP - [PasswordProtection]
		m_PWProtMenu.EnableMenuItem(MP_PWPROT_SET, MF_GRAYED);
		m_PWProtMenu.EnableMenuItem(MP_PWPROT_CHANGE, MF_GRAYED);
		m_PWProtMenu.EnableMenuItem(MP_PWPROT_UNSET, MF_GRAYED);
		// NEO: PP END
		// NEO: MOD END <-- Xanatos --
		m_FileMenu.EnableMenuItem(MP_OPEN, MF_GRAYED);

		if (thePrefs.IsExtControlsEnabled() && !thePrefs.GetPreviewPrio()) {
			m_FileMenu.EnableMenuItem(MP_TRY_TO_GET_PREVIEW_PARTS, MF_GRAYED);
			m_FileMenu.CheckMenuItem(MP_TRY_TO_GET_PREVIEW_PARTS, MF_UNCHECKED);
        }
		m_FileMenu.EnableMenuItem(MP_PREVIEW, MF_GRAYED);
		m_FileMenu.EnableMenuItem(MP_METINFO, MF_GRAYED);
		m_FileMenu.EnableMenuItem(MP_VIEWFILECOMMENTS, MF_GRAYED);
		// NEO: MOD - [NeoMenus] -- Xanatos -->
		// NEO: FCFG - [FileConfiguration]
		m_FileMenu.EnableMenuItem(MP_TWEAKS, MF_GRAYED);
		m_FileMenu.EnableMenuItem((UINT_PTR)m_ConfigMenu.m_hMenu, MF_GRAYED);
		// NEO: FCFG END
		m_FileMenu.EnableMenuItem((UINT_PTR)m_CollectMenu.m_hMenu, MF_GRAYED); // NEO: MSH - [ManualSourceHandling]
		m_FileMenu.EnableMenuItem((UINT_PTR)m_SourcesMenu.m_hMenu, MF_GRAYED);
		m_FileMenu.EnableMenuItem((UINT_PTR)m_ReaskMenu.m_hMenu, MF_GRAYED); // NEO: MDR - [ManualDownloadReask]
		m_FileMenu.EnableMenuItem((UINT_PTR)m_A4AFMenu.m_hMenu, MF_GRAYED); // NEO: MCM - [ManualClientManagement]
		m_FileMenu.EnableMenuItem((UINT_PTR)m_DropMenu.m_hMenu, MF_GRAYED); // NEO: MDS - [ManualDropSources]
		m_FileMenu.EnableMenuItem(MP_IMPORT, MF_GRAYED); // NEO: PIX - [PartImportExport]
		if(thePrefs.GetAllocCompleteMode() == false)
			m_FileMenu.EnableMenuItem(MP_PREALOCATE, MF_GRAYED); // NEO: MOD - [PreAllocate]
		m_FileMenu.EnableMenuItem((UINT_PTR)m_TempDirMenu.m_hMenu, MF_GRAYED); // NEO: MTD - [MultiTempDirectories]
		// NEO: MOD END <-- Xanatos --
		m_FileMenu.EnableMenuItem(MP_CLEARCOMPLETED, GetCompleteDownloads(curTab,total) > 0 ? MF_ENABLED : MF_GRAYED);
		if(thePrefs.GetShowCopyEd2kLinkCmd())
			m_FileMenu.EnableMenuItem(MP_GETED2KLINK, MF_GRAYED);
		else
			m_FileMenu.EnableMenuItem(MP_SHOWED2KLINK, MF_GRAYED);
		m_FileMenu.EnableMenuItem(MP_PASTE, theApp.IsEd2kFileLinkInClipboard() ? MF_ENABLED : MF_GRAYED);
		m_FileMenu.SetDefaultItem((UINT)-1);
		m_FileMenu.EnableMenuItem(MP_SEARCHRELATED, MF_GRAYED);
		m_FileMenu.EnableMenuItem(MP_MASSRENAME, MF_GRAYED); // NEO: MMR - [MorphMassRemane] <-- Xanatos --
		m_FileMenu.EnableMenuItem(MP_FIND, GetItemCount() > 0 ? MF_ENABLED : MF_GRAYED);

		// also show the "Web Services" entry, even if its disabled and therefore not useable, it though looks a little 
		// less confusing this way.
		CTitleMenu WebMenu;
		WebMenu.CreateMenu();
		WebMenu.AddMenuTitle(NULL, true);
		theWebServices.GetFileMenuEntries(&WebMenu);
		m_FileMenu.AppendMenu(MF_POPUP | MF_GRAYED, (UINT_PTR)WebMenu.m_hMenu, GetResString(IDS_WEBSERVICES), _T("WEB"));

		GetPopupMenuPos(*this, point);
		m_FileMenu.TrackPopupMenu(TPM_LEFTALIGN |TPM_RIGHTBUTTON, point.x, point.y, this);
		VERIFY( m_FileMenu.RemoveMenu(m_FileMenu.GetMenuItemCount() - 1, MF_BYPOSITION) );
		VERIFY( WebMenu.DestroyMenu() );
	}
}

BOOL CDownloadListCtrl::OnCommand(WPARAM wParam, LPARAM /*lParam*/)
{
	wParam = LOWORD(wParam);

	switch (wParam)
	{
		case MP_PASTE:
			if (theApp.IsEd2kFileLinkInClipboard())
				theApp.PasteClipboard(curTab);
			return TRUE;
		case MP_FIND:
			OnFindStart();
			return TRUE;
	}

	int iSel = GetNextItem(-1, LVIS_SELECTED | LVIS_FOCUSED);
	if (iSel == -1)
		iSel = GetNextItem(-1, LVIS_SELECTED);
	if (iSel != -1)
	{
		const CtrlItem_Struct* content = (CtrlItem_Struct*)GetItemData(iSel);
		if (content->type == FILE_TYPE)
		{
			//for multiple selections 
			UINT selectedCount = 0;
			CTypedPtrList<CPtrList, CPartFile*> selectedList; 
			POSITION pos = GetFirstSelectedItemPosition();
			while(pos != NULL) 
			{ 
				int index = GetNextSelectedItem(pos);
				if(index > -1) 
				{
					if (((const CtrlItem_Struct*)GetItemData(index))->type == FILE_TYPE)
					{
						selectedCount++;
						selectedList.AddTail((CPartFile*)((const CtrlItem_Struct*)GetItemData(index))->value);
					}
				} 
			} 

			CPartFile* file = (CPartFile*)content->value;
			switch (wParam)
			{
				case MP_MTD_UNLOAD: // NEO: MTD - [MultiTempDirectories]
				case MP_CANCEL:
				case MPG_DELETE: // keyboard del will continue to remove completed files from the screen while cancel will now also be available for complete files
				{
					if (selectedCount > 0)
					{
						SetRedraw(false);
						CString fileList;
						bool validdelete = false;
						bool removecompl = false;
						for (pos = selectedList.GetHeadPosition(); pos != 0; )
						{
							CPartFile* cur_file = selectedList.GetNext(pos);
							if (cur_file->GetStatus() != PS_COMPLETING && cur_file->GetStatus() != PS_COMPLETE && cur_file->GetStatus() != PS_MOVING || wParam == MP_CANCEL){ // NEO: MTD - [MultiTempDirectories] <-- Xanatos --
								validdelete = true;
								if (selectedCount < 50)
									fileList.Append(_T("\n") + CString(cur_file->GetFileName()));
							}
							else if (cur_file->GetStatus() == PS_COMPLETE)
								removecompl = true;

						}
						CString quest;
						// NEO: MTD - [MultiTempDirectories] -- Xanatos -->
						bool bUnloadOnly = false;
						if(wParam == MP_MTD_UNLOAD){
							bUnloadOnly = true;
							if (selectedCount == 1)
								quest = GetResString(IDS_X_Q_UNLOADDL2);
							else
								quest = GetResString(IDS_X_Q_UNLOADDL);
						}else
						// NEO: MTD END <-- Xanatos --
							if (selectedCount == 1)
								quest = GetResString(IDS_Q_CANCELDL2);
							else
								quest = GetResString(IDS_Q_CANCELDL);
						if ((removecompl && !validdelete) || (validdelete && AfxMessageBox(quest + fileList, MB_DEFBUTTON2 | MB_ICONQUESTION | MB_YESNO) == IDYES))
						{
							bool bRemovedItems = false;
							while (!selectedList.IsEmpty())
							{
								HideSources(selectedList.GetHead());
								switch (selectedList.GetHead()->GetStatus())
								{
									// NEO: SSH - [SlugFillerSafeHash] -- Xanatos --
									//case PS_WAITINGFORHASH:
									//case PS_HASHING:
									case PS_COMPLETING:
									case PS_MOVING: // NEO: MTD - [MultiTempDirectories] <-- Xanatos --
									case PS_IMPORTING: // NEO: PIX - [PartImportExport] <-- Xanatos --
										selectedList.RemoveHead();
										bRemovedItems = true;
										break;
									case PS_COMPLETE:
										if (wParam == MP_CANCEL){
											BOOL delsucc = FALSE;
											if (!PathFileExists(selectedList.GetHead()->GetFilePath()))
												delsucc = TRUE;
											else{
												// Delete
												if (!thePrefs.GetRemoveToBin()){
													delsucc = DeleteFile(selectedList.GetHead()->GetFilePath());
												}
												else{
													// delete to recycle bin :(
													TCHAR todel[MAX_PATH+1];
													memset(todel, 0, sizeof todel);
													_tcsncpy(todel, selectedList.GetHead()->GetFilePath(), ARRSIZE(todel)-2);

													SHFILEOPSTRUCT fp = {0};
													fp.wFunc = FO_DELETE;
													fp.hwnd = theApp.emuledlg->m_hWnd;
													fp.pFrom = todel;
													fp.fFlags = FOF_ALLOWUNDO | FOF_NOCONFIRMATION | FOF_SILENT;// | FOF_NOERRORUI
													delsucc = (SHFileOperation(&fp) == 0);
												}
											}
											if (delsucc){
												theApp.sharedfiles->RemoveFile(selectedList.GetHead());
											}
											else{
												CString strError;
												strError.Format( GetResString(IDS_ERR_DELFILE) + _T("\r\n\r\n%s"), selectedList.GetHead()->GetFilePath(), GetErrorMessage(GetLastError()));
												AfxMessageBox(strError);
											}
										}
										RemoveFile(selectedList.GetHead());
										selectedList.RemoveHead();
										bRemovedItems = true;
										break;
									case PS_PAUSED:
										selectedList.GetHead()->DeleteFile(bUnloadOnly); // NEO: MTD - [MultiTempDirectories] <-- Xanatos --
										selectedList.RemoveHead();
										bRemovedItems = true;
										break;
									default:
										if (selectedList.GetHead()->GetCategory())
											theApp.downloadqueue->StartNextFileIfPrefs(selectedList.GetHead()->GetCategory());
										selectedList.GetHead()->DeleteFile(bUnloadOnly); // NEO: MTD - [MultiTempDirectories] <-- Xanatos --
										selectedList.RemoveHead();
										bRemovedItems = true;
								}
							}
							if (bRemovedItems)
							{
								AutoSelectItem();
								theApp.emuledlg->transferwnd->UpdateCatTabTitles();
							}
						}
						SetRedraw(true);
					}
					break;
				}
				// NEO: MOD - [NeoMenus] -- Xanatos -->
				// NEO: OCF - [OnlyCompleetFiles]
				case MP_FORCE:{
					SetRedraw(false);
					bool bNewState = !file->GetForced();
					while (!selectedList.IsEmpty()){
						CPartFile* partfile = selectedList.GetHead();
						partfile->SetForced(bNewState);
#ifdef VOODOO // NEO: VOODOO - [UniversalPartfileInterface]
						if(partfile->KnownPrefs.UseVoodoo())
							theApp.voodoo->ManifestDownloadInstruction(partfile,INST_FORCE,bNewState);
#endif // VOODOO // NEO: VOODOO END
						selectedList.RemoveHead();
					}
					SetRedraw(true);
					break;
				}
				// NEO: END
				// NEO: SD - [StandByDL]
				case MP_STANDBY:{
					SetRedraw(false);
					bool bNewState = !file->GetStandBy();
					while (!selectedList.IsEmpty()){
						CPartFile* partfile = selectedList.GetHead();
						partfile->SetStandBy(bNewState);
#ifdef VOODOO // NEO: VOODOO - [UniversalPartfileInterface]
						if(partfile->KnownPrefs.UseVoodoo())
							theApp.voodoo->ManifestDownloadInstruction(partfile,INST_STANDBY,bNewState);
#endif // VOODOO // NEO: VOODOO END
						selectedList.RemoveHead();
					}
					SetRedraw(true);
					break;
				}
				// NEO: SD END
				// NEO: SC - [SuspendCollecting]
				case MP_SUSPEND:{
					SetRedraw(false);
					bool bNewState = !file->GetSuspend();
					while (!selectedList.IsEmpty()){
						CPartFile* partfile = selectedList.GetHead();
						partfile->SetSuspend(bNewState);
#ifdef VOODOO // NEO: VOODOO - [UniversalPartfileInterface]
						if(partfile->KnownPrefs.UseVoodoo())
							theApp.voodoo->ManifestDownloadInstruction(partfile,INST_SUSPEND,bNewState);
#endif // VOODOO // NEO: VOODOO END
						selectedList.RemoveHead();
					}
					SetRedraw(true);
					break;
				}
				// NEO: SC END

				case MP_DLPRIOLOW:
				case MP_DLPRIONORMAL:
				case MP_DLPRIOHIGH:
				case MP_DLPRIOAUTO:
				{
					uint8 uPriority = PR_NORMAL;
					switch (wParam) {
						case MP_DLPRIOLOW:		uPriority = PR_LOW;		break;
						case MP_DLPRIONORMAL:	uPriority = PR_NORMAL;	break;
						case MP_DLPRIOHIGH:		uPriority = PR_HIGH;	break;
						case MP_DLPRIOAUTO:		uPriority = PR_AUTO;	break;
					}
					SetRedraw(false);
					POSITION pos = selectedList.GetHeadPosition();
					while (pos != NULL)
					{
						CPartFile* file = selectedList.GetNext(pos);
						if(uPriority == PR_AUTO){
							file->SetAutoDownPriority(true);
							file->SetDownPriority(PR_HIGH);
						}else{
							file->SetAutoDownPriority(false);
							file->SetDownPriority(uPriority);
						}
#ifdef VOODOO // NEO: VOODOO - [UniversalPartfileInterface]
						if(file->KnownPrefs.UseVoodoo())
							theApp.voodoo->ManifestDownloadInstruction(file,INST_DL_PRIO,uPriority);
#endif // VOODOO // NEO: VOODOO END
					}
					SetRedraw(true);
					break;
				}

				case MP_PRIOVERYLOW:
				case MP_PRIOLOW:
				case MP_PRIONORMAL:
				case MP_PRIOHIGH:
				case MP_PRIOVERYHIGH:
				case MP_PRIOAUTO:
				{
					uint8 uPriority = PR_NORMAL;
					switch (wParam) {
						case MP_PRIOVERYLOW:	uPriority = PR_VERYLOW;		break;
						case MP_PRIOLOW:		uPriority = PR_LOW;			break;
						case MP_PRIONORMAL:		uPriority = PR_NORMAL;		break;
						case MP_PRIOHIGH:		uPriority = PR_HIGH;		break;
						case MP_PRIOVERYHIGH:	uPriority = PR_VERYHIGH;	break;
						case MP_PRIOAUTO:		uPriority = PR_AUTO;		break;
					}
					SetRedraw(false);
					POSITION pos = selectedList.GetHeadPosition();
					while (pos != NULL)
					{
						CPartFile* file = selectedList.GetNext(pos);
						if(uPriority == PR_AUTO){
							file->SetAutoUpPriority(true);
							file->UpdateAutoUpPriority();
						}else{
							file->SetAutoUpPriority(false);
							file->SetUpPriority(uPriority);
						}
#ifdef VOODOO // NEO: VOODOO - [UniversalPartfileInterface]
						if(file->KnownPrefs.UseVoodoo())
							theApp.voodoo->ManifestShareInstruction(file,INST_UL_PRIO,uPriority);
#endif // VOODOO // NEO: VOODOO END
					}
					SetRedraw(true);
					break;
				}
				// NEO: RT - [ReleaseTweaks]
				case MP_PRIORELEASE:{
					SetRedraw(false);
					bool bNewState = !file->IsReleasePriority();
					while (!selectedList.IsEmpty()){
						file = selectedList.GetHead();
						file->SetReleasePriority(bNewState);
#ifdef VOODOO // NEO: VOODOO - [UniversalPartfileInterface]
						if(file->KnownPrefs.UseVoodoo())
							theApp.voodoo->ManifestShareInstruction(file,INST_UL_PRIO,PR_RELEASE,bNewState);
#endif // VOODOO // NEO: VOODOO END
						selectedList.RemoveHead();
					}
					SetRedraw(true);
					break;
				}
				// NEO: RT END
				// NEO: SSP - [ShowSharePermissions]
				case MP_PERMNONE:
				case MP_PERMFRIENDS:
				case MP_PERMALL: 
				case MP_PERMDEFAULT: 
				{
					SetRedraw(false);
					while(!selectedList.IsEmpty()) { 
						CPartFile *file = selectedList.GetHead();
						switch (wParam)
						{
							case MP_PERMNONE:
								file->SetPermissions(PERM_NONE);
								break;
							case MP_PERMCOMMUNITY:
								file->SetPermissions(PERM_COMMUNITY); // NEO: NC - [NiceCommunity]
								break;
							case MP_PERMFRIENDS:
								file->SetPermissions(PERM_FRIENDS);
								break;
							case MP_PERMALL:
								file->SetPermissions(PERM_ALL);
								break;
							case MP_PERMDEFAULT:
								file->SetPermissions(PERM_DEFAULT);
								break;								
						}
						selectedList.RemoveHead();
					}
					SetRedraw(true);
					break;
				}
				// NEO: SSP END
				// NEO: PP - [PasswordProtection]
				case MP_PWPROT_SET:
					theApp.downloadqueue->ExecuteNeoCommand(selectedList,INST_OTHER,INST_OTHER_PROTECT_SET);
					break;
				case MP_PWPROT_CHANGE:
					theApp.downloadqueue->ExecuteNeoCommand(selectedList,INST_OTHER,INST_OTHER_PROTECT_CHANGE);
					break;
				case MP_PWPROT_UNSET:
					theApp.downloadqueue->ExecuteNeoCommand(selectedList,INST_OTHER,INST_OTHER_PROTECT_UNSET);
					break;
				// NEO: PP END
#ifdef A4AF_CATS // NEO: MAC - [MorphA4AFCategories]
				// This is only called when there is a single selection, so we'll handle it thusly.
				case MP_CAT_SETRESUMEORDER: {
					InputBox	inputOrder;
					CString		currOrder;

					currOrder.Format(_T("%u"), file->GetCatResumeOrder());
					inputOrder.SetLabels(GetResString(IDS_X_CAT_SETORDER), GetResString(IDS_X_CAT_ORDER), currOrder);
					inputOrder.SetNumber(true);
					if (inputOrder.DoModal() == IDOK)
					{
					int newOrder = inputOrder.GetInputInt();
						if  (newOrder < 0 || newOrder == file->GetCatResumeOrder()) break;

					file->SetCatResumeOrder(newOrder);
					Invalidate(); // Display the new category.
					}
					break;
				}
				// These next three are only called when there are multiple selections.
				case MP_CAT_ORDERAUTOINC: {
					// This option asks the user for a starting point, and then increments each selected item
					// automatically.  It uses whatever order they appear in the list, from top to bottom.
					InputBox	inputOrder;
					if (selectedCount <= 1) break;
						
					inputOrder.SetLabels(GetResString(IDS_X_CAT_SETORDER), GetResString(IDS_X_CAT_EXPAUTOINC), _T("0"));
					inputOrder.SetNumber(true);
                    if (inputOrder.DoModal() == IDOK)
					{
					int newOrder = inputOrder.GetInputInt();
					if  (newOrder < 0) break;

					while (!selectedList.IsEmpty()) {
						selectedList.GetHead()->SetCatResumeOrder(newOrder);
						newOrder++;
						selectedList.RemoveHead();
					}
					Invalidate();
					}
					break;
				}
				case MP_CAT_ORDERSTEPTHRU: {
					// This option asks the user for a different resume modifier for each file.  It
					// displays the filename in the inputbox so that they don't get confused about
					// which one they're setting at any given moment.
					InputBox	inputOrder;
					CString		currOrder;
					CString		currFile;
					CString		currInstructions;
					int			newOrder = 0;

					if (selectedCount <= 1) break;
					inputOrder.SetNumber(true);

					while (!selectedList.IsEmpty()) {
						currOrder.Format(_T("%u"), selectedList.GetHead()->GetCatResumeOrder());
						currFile = selectedList.GetHead()->GetFileName();
                        if (currFile.GetLength() > 50) currFile = currFile.Mid(0,47) + _T("...");
						currInstructions.Format(_T("%s %s"), GetResString(IDS_X_CAT_EXPSTEPTHRU), currFile);
						inputOrder.SetLabels(GetResString(IDS_X_CAT_SETORDER), currInstructions, currOrder);

						if (inputOrder.DoModal() == IDCANCEL) {
							if (MessageBox(GetResString(IDS_X_CAT_ABORTSTEPTHRU), GetResString(IDS_X_ABORT), MB_YESNO) == IDYES) {
								break;
							}
							else {
								selectedList.RemoveHead();
								continue;
							}
						}

						newOrder = inputOrder.GetInputInt();
						selectedList.GetHead()->SetCatResumeOrder(newOrder);
						selectedList.RemoveHead();
					}
					RedrawItems(0, GetItemCount() - 1);
					break;
				}
				case MP_CAT_ORDERALLSAME: {
					// This option asks the user for a single resume modifier and applies it to
					// all the selected files.
					InputBox	inputOrder;
					CString		currOrder;

					if (selectedCount <= 1) break;

					inputOrder.SetLabels(GetResString(IDS_X_CAT_SETORDER), GetResString(IDS_X_CAT_EXPALLSAME), _T("0"));
					inputOrder.SetNumber(true);
					if (inputOrder.DoModal() == IDCANCEL)
						break;

					int newOrder = inputOrder.GetInputInt();
					if  (newOrder < 0) break;

					while (!selectedList.IsEmpty()) {
						selectedList.GetHead()->SetCatResumeOrder(newOrder);
						selectedList.RemoveHead();
					}
					RedrawItems(0, GetItemCount() - 1);
					break;
				}
				case MP_FORCEA4AF: {
					if (file && theApp.downloadqueue->forcea4af_file != file)
						theApp.downloadqueue->forcea4af_file = file;
					else if (file && theApp.downloadqueue->forcea4af_file == file)
						theApp.downloadqueue->forcea4af_file = NULL;
#ifdef VOODOO // NEO: VOODOO - [UniversalPartfileInterface]
					if(file && file->KnownPrefs.UseVoodoo())
						theApp.voodoo->ManifestDownloadInstruction(file,INST_FORCE_ALL_A4AF,(theApp.downloadqueue->forcea4af_file == file));
#endif // VOODOO // NEO: VOODOO END
					break;
				}
#endif // A4AF_CATS // NEO: MAC END
				// NEO: MCM - [ManualClientManagement]
				case MP_SWAP_TO_A4AF:
					while (!selectedList.IsEmpty()){
						CPartFile* partfile = selectedList.GetHead();
						partfile->CollectAllA4AF();
#ifdef VOODOO // NEO: VOODOO - [UniversalPartfileInterface]
						if(partfile->KnownPrefs.UseVoodoo())
							theApp.voodoo->ManifestDownloadInstruction(partfile,INST_GET_ALL_A4AF);
#endif // VOODOO // NEO: VOODOO END
						selectedList.RemoveHead();
					}
					break;
				case MP_SWAP_FROM_A4AF:
					while (!selectedList.IsEmpty()){
						CPartFile* partfile = selectedList.GetHead();
						partfile->ReleaseAllA4AF();
#ifdef VOODOO // NEO: VOODOO - [UniversalPartfileInterface]
						if(partfile->KnownPrefs.UseVoodoo())
							theApp.voodoo->ManifestDownloadInstruction(partfile,INST_DROP_ALL_A4AF);
#endif // VOODOO // NEO: VOODOO END
						selectedList.RemoveHead();
					}
					break;
				// NEO: MCM END
				// NEO: MOD END <-- Xanatos --
				case MP_PAUSE:
					SetRedraw(false);
					while (!selectedList.IsEmpty()){
						CPartFile* partfile = selectedList.GetHead();
						if (partfile->CanPauseFile())
							partfile->PauseFile();
						selectedList.RemoveHead();
					}
					SetRedraw(true);
					break;
				case MP_RESUME:
					SetRedraw(false);
					while (!selectedList.IsEmpty()){
						CPartFile* partfile = selectedList.GetHead();
						if (partfile->CanResumeFile()){
							if (partfile->GetStatus() == PS_INSUFFICIENT)
								partfile->ResumeFileInsufficient();
							else
								partfile->ResumeFile();
						}
						selectedList.RemoveHead();
					}
					SetRedraw(true);
					break;
				case MP_STOP:
					SetRedraw(false);
					while (!selectedList.IsEmpty()){
						CPartFile *partfile = selectedList.GetHead();
						if (partfile->CanStopFile()){
							HideSources(partfile);
							partfile->StopFile();
						}
						selectedList.RemoveHead();
					}
					SetRedraw(true);
					theApp.emuledlg->transferwnd->UpdateCatTabTitles();
					break;
				//case MP_CLEARCOMPLETED: // NEO: MOD -- Xanatos --
				//	SetRedraw(false);
				//	ClearCompleted();
				//	SetRedraw(true);
				//	break;
				case MPG_F2:
					if (GetAsyncKeyState(VK_CONTROL) < 0 || selectedCount > 1) {
						// when ctrl is pressed -> filename cleanup
						if (IDYES==AfxMessageBox(GetResString(IDS_MANUAL_FILENAMECLEANUP),MB_YESNO))
							while (!selectedList.IsEmpty()){
								CPartFile *partfile = selectedList.GetHead();
								if (partfile->IsPartFile()) {
									partfile->SetFileName(CleanupFilename(partfile->GetFileName()));
								}
								selectedList.RemoveHead();
							}
					} else {
						if (file->GetStatus() != PS_COMPLETE && file->GetStatus() != PS_COMPLETING)
						{
							InputBox inputbox;
							CString title = GetResString(IDS_RENAME);
							title.Remove(_T('&'));
							inputbox.SetLabels(title, GetResString(IDS_DL_FILENAME), file->GetFileName());
							inputbox.SetEditFilenameMode();
							if (inputbox.DoModal()==IDOK && !inputbox.GetInput().IsEmpty() && IsValidEd2kString(inputbox.GetInput()))
							{
								file->SetFileName(inputbox.GetInput(), true);
								file->UpdateDisplayedInfo();
								file->SavePartFile();
							}
						}
						else
							MessageBeep(MB_OK);
					}
					break;
				case MPG_ALTENTER:
				case MP_METINFO:
					ShowFileDialog();
					break;
				case MP_COPYSELECTED:
				case MP_GETED2KLINK:{
					CString str;
					while (!selectedList.IsEmpty()){
						if (!str.IsEmpty())
							str += _T("\r\n");
						str += CreateED2kLink(selectedList.GetHead());
						selectedList.RemoveHead();
					}
					theApp.CopyTextToClipboard(str);
					break;
				}
				case MP_SEARCHRELATED:
					if (selectedCount > 1)
						break;
					theApp.emuledlg->searchwnd->SearchRelatedFiles(file);
					theApp.emuledlg->SetActiveDialog(theApp.emuledlg->searchwnd);
					break;
				// NEO: MMR - [MorphMassRemane] -- Xanatos -->
				case MP_MASSRENAME: {
					CMassRenameDialog* MRDialog = new CMassRenameDialog;
					// Add the files to the dialog
					POSITION pos = selectedList.GetHeadPosition();
					while (pos != NULL) {
						CPartFile*  file = selectedList.GetAt (pos);
						MRDialog->m_FileList.AddTail (file);
						selectedList.GetNext (pos);
					}
					MRDialog->OpenDialog();
				}
				break;
				// NEO: MMR END <-- Xanatos --
				case MP_OPEN:
				case IDA_ENTER:
					if (selectedCount > 1)
						break;
					if (file->CanOpenFile())
						file->OpenFile();
					break;
				case MP_TRY_TO_GET_PREVIEW_PARTS:
					if (selectedCount > 1)
						break;
                    file->SetPreviewPrio(!file->GetPreviewPrio());
                    break;
				case MP_PREVIEW:
					if (selectedCount > 1)
						break;
					file->PreviewFile();
					break;
				case MP_VIEWFILECOMMENTS:
					ShowFileDialog(IDD_COMMENTLST);
					break;
				// NEO: MOD - [NeoMenus] -- Xanatos -->
				// NEO: FCFG - [FileConfiguration]
				case MP_TWEAKS:
					ShowFileDialog(NULL, TRUE);
					break;
				case MP_FCFG_CLEAR:
					while (!selectedList.IsEmpty()){
						selectedList.GetHead()->PartPrefs.ResetTweaks();
						selectedList.GetHead()->KnownPrefs.ResetTweaks();
						selectedList.RemoveHead();
					}
					break;
				case MP_FCFG_COPY:
					{
						if (selectedCount > 1)
							break;

						CString data;
						data.Append(_T("NEO:FCFG\r\n"));

						CSafeMemFile partPrefs(128);
						file->PartPrefs.SavePartPrefs(&partPrefs);
						data.AppendFormat(_T("PCFG:%s:\r\n"),EncodeBase16(partPrefs.GetBuffer(),(int)partPrefs.GetLength()));

						CSafeMemFile knownPrefs(128);
						file->KnownPrefs.SaveKnownPrefs(&knownPrefs);
						data.AppendFormat(_T("KCFG:%s:\r\n"),EncodeBase16(knownPrefs.GetBuffer(),(int)knownPrefs.GetLength()));

						theApp.CopyTextToClipboard(data);
					}
					break;
				case MP_FCFG_PASTE:
					{
						CString data = theApp.CopyTextFromClipboard();
						if(data.Find(_T("KCFG:")) > -1)
						{
							int iKCFGstart = data.Find(_T("KCFG:"))+5;
							int iKCFGend = data.Find(_T(":"),iKCFGstart);
							CString sKCFGstr = data.Mid(iKCFGstart,iKCFGend-iKCFGstart);

							BYTE* KCFGbuff = new BYTE[sKCFGstr.GetLength()/2];
							DecodeBase16(sKCFGstr,sKCFGstr.GetLength(),KCFGbuff,sKCFGstr.GetLength()/2);
							CSafeMemFile knownPrefs(KCFGbuff,sKCFGstr.GetLength()/2);

							for (pos = selectedList.GetHeadPosition(); pos != 0; ){
								knownPrefs.SeekToBegin();
								selectedList.GetNext(pos)->KnownPrefs.LoadKnownPrefs(&knownPrefs);
							}

							delete [] KCFGbuff;
						}
					}
				case MP_FCFG_PASTE2:
					{
						CString data = theApp.CopyTextFromClipboard();
						if(data.Find(_T("PCFG:")) > -1)
						{
							int iPCFGstart = data.Find(_T("PCFG:"))+5;
							int iPCFGend = data.Find(_T(":"),iPCFGstart);
							CString sPCFGstr = data.Mid(iPCFGstart,iPCFGend-iPCFGstart);

							BYTE* PCFGbuff = new BYTE[sPCFGstr.GetLength()/2];
							DecodeBase16(sPCFGstr,sPCFGstr.GetLength(),PCFGbuff,sPCFGstr.GetLength()/2);
							CSafeMemFile partPrefs(PCFGbuff,sPCFGstr.GetLength()/2);
							
							for (pos = selectedList.GetHeadPosition(); pos != 0; ){
								partPrefs.SeekToBegin();
								selectedList.GetNext(pos)->PartPrefs.LoadPartPrefs(&partPrefs);
							}

							delete [] PCFGbuff;
						}
					}
					break;
				// NEO: FCFG END
				// NEO: MSH - [ManualSourceHandling]
				case MP_COLLECT_ALL_SOURCES: // Hawkynt: get all Sources I can find
					theApp.downloadqueue->ExecuteNeoCommand(selectedList,INST_COLLECT,INST_COLLECT_ALL_SOURCES); // NEO: NDC - [NeoDownloadCommands]
					break;
				case MP_COLLECT_XS_SOURCES:
					theApp.downloadqueue->ExecuteNeoCommand(selectedList,INST_COLLECT,INST_COLLECT_XS_SOURCES); // NEO: NDC - [NeoDownloadCommands]
					break;
				case MP_COLLECT_SVR_SOURCES:
					theApp.downloadqueue->ExecuteNeoCommand(selectedList,INST_COLLECT,INST_COLLECT_SVR_SOURCES); // NEO: NDC - [NeoDownloadCommands]
					break;
				case MP_COLLECT_KAD_SOURCES:
					theApp.downloadqueue->ExecuteNeoCommand(selectedList,INST_COLLECT,INST_COLLECT_KAD_SOURCES); // NEO: NDC - [NeoDownloadCommands]
					break;
				case MP_COLLECT_UDP_SOURCES:
					theApp.downloadqueue->ExecuteNeoCommand(selectedList,INST_COLLECT,INST_COLLECT_UDP_SOURCES); // NEO: NDC - [NeoDownloadCommands]
					break;
#ifdef VOODOO // NEO: VOODOOn - [VoodooExtensionForNeo]
				case MP_COLLECT_VOODOO_SOURCES:
					theApp.downloadqueue->ExecuteNeoCommand(selectedList,INST_COLLECT,INST_COLLECT_VOODOO_SOURCES); // NEO: NDC - [NeoDownloadCommands]
#endif // VOODOO // NEO: VOODOOn END
				// NEO: MSH END
				// NEO: MDR - [ManualDownloadReask]
				// NEO: TCR - [TCPConnectionRetry]
				case MP_REASK_WAITINGRETRY:
					theApp.downloadqueue->ExecuteNeoCommand(selectedList,INST_REASK,INST_REASK_WAITINGRETRY); // NEO: NDC - [NeoDownloadCommands]
					break;
				// NEO: TCR END
				// NEO: XSC - [ExtremeSourceCache]
				case MP_REASK_CACHED:
					theApp.downloadqueue->ExecuteNeoCommand(selectedList,INST_REASK,INST_REASK_CACHED); // NEO: NDC - [NeoDownloadCommands]
					break;
				// NEO: XSC END
#ifdef NEO_SS // NEO: NSS - [NeoSourceStorage]
				case MP_REASK_LOADEDGROUP:
					theApp.downloadqueue->ExecuteNeoCommand(selectedList,INST_REASK,INST_REASK_LOADEDGROUP); // NEO: NDC - [NeoDownloadCommands]
					break;
				case MP_REASK_LOADED:
					theApp.downloadqueue->ExecuteNeoCommand(selectedList,INST_REASK,INST_REASK_LOADED); // NEO: NDC - [NeoDownloadCommands]
					break;
				case MP_REASK_LOADEDWAITING:
					theApp.downloadqueue->ExecuteNeoCommand(selectedList,INST_REASK,INST_REASK_LOADEDWAITING); // NEO: NDC - [NeoDownloadCommands]
					break;
#ifdef NEO_SA // NEO: NSA - [NeoSourceAnaliser]
				case MP_REASK_RESERVE:
					theApp.downloadqueue->ExecuteNeoCommand(selectedList,INST_REASK,INST_REASK_RESERVE); // NEO: NDC - [NeoDownloadCommands]
					break;
#endif // NEO_SA // NEO: NSA END
#endif // NEO_SS // NEO: NSS END
#ifdef NEO_SK // NEO: NSK - [NeoSourceKeeper]
#endif // NEO_SK // NEO: NSK END
				case MP_REASK_FULLQ:
					theApp.downloadqueue->ExecuteNeoCommand(selectedList,INST_REASK,INST_REASK_FULLQ); // NEO: NDC - [NeoDownloadCommands]
					break;
				case MP_REASK_NNP:
					theApp.downloadqueue->ExecuteNeoCommand(selectedList,INST_REASK,INST_REASK_NNP); // NEO: NDC - [NeoDownloadCommands]
					break;
				// NEO: MDR END
				// NEO: MDS - [ManualDropSources]
				case MP_DROP_NNP:
					theApp.downloadqueue->ExecuteNeoCommand(selectedList,INST_DROP,INST_DROP_NNP); // NEO: NDC - [NeoDownloadCommands]
					break;
				case MP_DROP_FULLQ:
					theApp.downloadqueue->ExecuteNeoCommand(selectedList,INST_DROP,INST_DROP_FULLQ); // NEO: NDC - [NeoDownloadCommands]
					break;
				case MP_DROP_HIGHQ:
					theApp.downloadqueue->ExecuteNeoCommand(selectedList,INST_DROP,INST_DROP_HIGHQ); // NEO: NDC - [NeoDownloadCommands]
					break;
				// NEO: TCR - [TCPConnectionRetry]
				case MP_DROP_WAITINGRETRY:
					theApp.downloadqueue->ExecuteNeoCommand(selectedList,INST_DROP,INST_DROP_WAITINGRETRY); // NEO: NDC - [NeoDownloadCommands]
					break;
				// NEO: TCR END
				// NEO: XSC - [ExtremeSourceCache]
				case MP_DROP_CACHED:
					theApp.downloadqueue->ExecuteNeoCommand(selectedList,INST_DROP,INST_DROP_CACHED); // NEO: NDC - [NeoDownloadCommands]
					break;
				// NEO: XSC END
#ifdef NEO_SS // NEO: NSS - [NeoSourceStorage]
				case MP_DROP_OUTOFDATE:
					theApp.downloadqueue->ExecuteNeoCommand(selectedList,INST_DROP,INST_DROP_OUTOFDATE); // NEO: NDC - [NeoDownloadCommands]
					break;
				case MP_DROP_LOADED:
					theApp.downloadqueue->ExecuteNeoCommand(selectedList,INST_DROP,INST_DROP_LOADED); // NEO: NDC - [NeoDownloadCommands]
					break;
				case MP_DROP_LOADEDWAITING:
					theApp.downloadqueue->ExecuteNeoCommand(selectedList,INST_DROP,INST_DROP_LOADEDWAITING); // NEO: NDC - [NeoDownloadCommands]
					break;
#ifdef NEO_SA // NEO: NSA - [NeoSourceAnaliser]
				case MP_DROP_RESERVE:
					theApp.downloadqueue->ExecuteNeoCommand(selectedList,INST_DROP,INST_DROP_RESERVE); // NEO: NDC - [NeoDownloadCommands]
					break;
#endif // NEO_SA // NEO: NSA END
				case MP_DROP_RETIRED:
					theApp.downloadqueue->ExecuteNeoCommand(selectedList,INST_DROP,INST_DROP_RETIRED); // NEO: NDC - [NeoDownloadCommands]
					break;
#endif // NEO_SS // NEO: NSS END
#ifdef NEO_SK // NEO: NSK - [NeoSourceKeeper]
				case MP_DROP_UNREACHABLE:
					theApp.downloadqueue->ExecuteNeoCommand(selectedList,INST_DROP,INST_DROP_UNREACHABLE); // NEO: NDC - [NeoDownloadCommands]
					break;
#endif // NEO_SK // NEO: NSK END
				case MP_DROP_TOMANY:
					theApp.downloadqueue->ExecuteNeoCommand(selectedList,INST_DROP,INST_DROP_TOMANY); // NEO: NDC - [NeoDownloadCommands]
					break;
				case MP_DROP_UNKNOWN:
					theApp.downloadqueue->ExecuteNeoCommand(selectedList,INST_DROP,INST_DROP_UNKNOWN); // NEO: NDC - [NeoDownloadCommands]
					break;
				case MP_DROP_BAD:
					theApp.downloadqueue->ExecuteNeoCommand(selectedList,INST_DROP,INST_DROP_BAD); // NEO: NDC - [NeoDownloadCommands]
					break;
				case MP_DROP_LOW2LOW:
					theApp.downloadqueue->ExecuteNeoCommand(selectedList,INST_DROP,INST_DROP_LOW2LOW); // NEO: NDC - [NeoDownloadCommands]
					break;
				// NEO: MDS END

				// NEO: PIX - [PartImportExport]
				case MP_IMPORT:
					if(selectedCount > 1)
						break;
					file->ImportParts();
					break;
				// NEO: PIX

				// NEO: MOD - [PreAllocate]
				case MP_PREALOCATE:
					while (!selectedList.IsEmpty()){
						if(selectedList.GetHead()->IncompleteAllocateSpace())
							selectedList.GetHead()->AllocateNeededSpace();
						selectedList.RemoveHead();
					}
					break;
				// NEO: MOD END

				// NEO: AHL - [AutoHardLimit]
				case MP_AHL_INCREASE:
					theApp.downloadqueue->ExecuteNeoCommand(selectedList,INST_COLLECT,INST_AHL_INCREASE); // NEO: NDC - [NeoDownloadCommands]
					break;
				case MP_AHL_DECREASE:
					theApp.downloadqueue->ExecuteNeoCommand(selectedList,INST_COLLECT,INST_AHL_DECREASE); // NEO: NDC - [NeoDownloadCommands]
					break;
				// NEO: AHL END

#ifdef NEO_SS // NEO: NSS - [NeoSourceStorage]
				case MP_LOADSOURCE:
					theApp.downloadqueue->ExecuteNeoCommand(selectedList,INST_STORAGE,INST_STORAGE_LOAD); // NEO: NDC - [NeoDownloadCommands]
					break;
				case MP_SAVESOURCE:
					theApp.downloadqueue->ExecuteNeoCommand(selectedList,INST_STORAGE,INST_STORAGE_SAVE); // NEO: NDC - [NeoDownloadCommands]
					break;
				case MP_IMPORTSOURCE:
					theApp.downloadqueue->ExecuteNeoCommand(selectedList,INST_STORAGE,INST_STORAGE_IMPORT); // NEO: NDC - [NeoDownloadCommands]
					break;
				case MP_EXPORTSOURCE:
					theApp.downloadqueue->ExecuteNeoCommand(selectedList,INST_STORAGE,INST_STORAGE_EXPORT); // NEO: NDC - [NeoDownloadCommands]
					break;
 #ifdef NEO_CD // NEO: NCD - [NeoClientDatabase] // NEO: SFL - [SourceFileList]
				case MP_FINDSOURCES:
					theApp.downloadqueue->ExecuteNeoCommand(selectedList,INST_STORAGE,INST_STORAGE_FIND); // NEO: NDC - [NeoDownloadCommands]
					break;
 #endif // NEO_CD // NEO: NCD END // NEO: SFL END
#endif // NEO_SS // NEO: NSS END

				// NEO: MOD END <-- Xanatos --

				case MP_SHOWED2KLINK:
					ShowFileDialog(IDD_ED2KLINK);
					break;
				// NEO: NST - [NeoSourceTweaks] -- Xanatos --
				/*case MP_SETSOURCELIMIT: {
					CString temp;
					temp.Format(_T("%u"),file->GetPrivateMaxSources());
					InputBox inputbox;
					CString title = GetResString(IDS_SETPFSLIMIT);
					inputbox.SetLabels(title, GetResString(IDS_SETPFSLIMITEXPLAINED), temp );

					if (inputbox.DoModal()==IDOK  )
					{
						temp=inputbox.GetInput();
						uint16 newlimit=_tstoi( temp.GetBuffer() );
						while (!selectedList.IsEmpty()){
							CPartFile *partfile = selectedList.GetHead();
							partfile->SetPrivateMaxSources(newlimit);
							selectedList.RemoveHead();
						}
					}
					break;
				}*/
				case MP_ADDSOURCE: {
					if (selectedCount > 1)
						break;

					// NEO: MLD - [ModelesDialogs] -- Xanatos -->
					CAddSourceDlg* as = new CAddSourceDlg(); 
					as->SetFile(file);
					as->OpenDialog(); 
					// NEO: MLD END <-- Xanatos --
					break;
				}
				default:
					// NEO: MTD - [MultiTempDirectories] -- Xanatos -->
					if (wParam>=MP_TEMPLIST && wParam<=MP_TEMPLIST+99) {
						CString tempdir = thePrefs.GetTempDir(wParam-MP_TEMPLIST);
						
						if (selectedCount > 0)
						{
							SetRedraw(false);
							CString fileList;
							bool validmove = false;
							for (pos = selectedList.GetHeadPosition(); pos != 0; )
							{
								CPartFile* cur_file = selectedList.GetNext(pos);
								if (cur_file->GetStatus() != PS_COMPLETING && /*cur_file->GetStatus() != PS_HASHING &&*/ cur_file->GetStatus() != PS_MOVING && cur_file->GetStatus() != PS_IMPORTING){ // NEO: PIX - [PartImportExport] // NEO: SSH - [SlugFillerSafeHash]
									validmove = true;
									if (selectedCount < 50)
										fileList.Append(_T("\n") + CString(cur_file->GetFileName()));
								}
							}

							CString quest;
							if (selectedCount == 1)
								quest = GetResString(IDS_X_TEMPMOVE2);
							else
								quest = GetResString(IDS_X_TEMPMOVE);
							if (validmove && AfxMessageBox(quest + fileList, MB_DEFBUTTON2 | MB_ICONQUESTION | MB_YESNO) == IDYES)
							{
								//bool bMovedItems = false;
								while (!selectedList.IsEmpty())
								{
									CPartFile* cur_file = selectedList.GetHead();
									selectedList.RemoveHead();

									if(!CompareDirectories(cur_file->GetPath(), tempdir))
										continue;

									if (cur_file->GetStatus() != PS_COMPLETING && /*cur_file->GetStatus() != PS_HASHING &&*/ cur_file->GetStatus() != PS_MOVING && cur_file->GetStatus() != PS_IMPORTING){ // NEO: PIX - [PartImportExport] // NEO: SSH - [SlugFillerSafeHash]
										cur_file->MovePartFile(tempdir);
										//bMovedItems = true;
									}
									
								}
								//if (bMovedItems)
								//	AutoSelectItem();
							}
							SetRedraw(true);
						}
					}else
					// NEO: MTD END <-- Xanatos --
					if (wParam>=MP_WEBURL && wParam<=MP_WEBURL+99){
						theWebServices.RunURL(file, wParam);
					}
					else if (wParam>=MP_ASSIGNCAT && wParam<=MP_ASSIGNCAT+99){
						SetRedraw(FALSE);
						while (!selectedList.IsEmpty()){
							CPartFile *partfile = selectedList.GetHead();
							partfile->SetCategory(wParam - MP_ASSIGNCAT);
							partfile->UpdateDisplayedInfo(true);
							selectedList.RemoveHead();
						}
						SetRedraw(TRUE);
						UpdateCurrentCategoryView();
						if (thePrefs.ShowCatTabInfos())
							theApp.emuledlg->transferwnd->UpdateCatTabTitles();
					}
					else if (wParam>=MP_PREVIEW_APP_MIN && wParam<=MP_PREVIEW_APP_MAX){
						thePreviewApps.RunApp(file, wParam);
					}
					break;
			}
		}
		else{
			CUpDownClient* client = (CUpDownClient*)content->value;
			CPartFile* file = (CPartFile*)content->owner; // added by sivka

			// NEO: MOD - [NeoMenus] -- Xanatos -->
			UINT selectedCount = 0;
			CTypedPtrList<CPtrList, CUpDownClient*> selectedList; 
			POSITION pos = GetFirstSelectedItemPosition();
			while(pos != NULL) 
			{ 
				int index = GetNextSelectedItem(pos);
				if(index > -1) 
				{
					if (((const CtrlItem_Struct*)GetItemData(index))->type != FILE_TYPE)
					{
						selectedCount++;
						selectedList.AddTail((CUpDownClient*)((const CtrlItem_Struct*)GetItemData(index))->value);
					}
				} 
			} 
			// NEO: MOD END <-- Xanatos --

			switch (wParam){
				case MP_SHOWLIST:
					ShowClientDialog(client, IDD_BROWSEFILES); // NEO: XSF - [ExtendedSharedFiles] <-- Xanatos --
					//client->RequestSharedFileList();
					break;
				case MP_MESSAGE:
					theApp.emuledlg->chatwnd->StartSession(client);
					break;
				// NEO: MOD - [NeoMenus] -- Xanatos -->
				case MP_ADDFRIEND:
					if(theApp.friendlist->AddFriend(client))
						UpdateItem(client);
					break;
				case MP_REMOVEFRIEND:
					theApp.friendlist->RemoveFriend(client->m_Friend);
					UpdateItem(client);
					break;
				case MP_FRIENDSLOT:
					// NEO: NMFS - [NiceMultiFriendSlots] -- Xanatos -->
					if(!client->m_Friend->GetFriendSlot()){
						if(!thePrefs.IsFriendSlotLimit())
							theApp.friendlist->RemoveAllFriendSlots();
						client->m_Friend->SetFriendSlot(true);
					}else
						client->m_Friend->SetFriendSlot(false);
					// NEO: NMFS END <-- Xanatos --
					break;
				// NEO: MOD END <-- Xanatos --
				// NEO: NXI - [NeoExtraInfo] -- Xanatos -->
				case MP_SOMEINFO:
					theApp.emuledlg->chatwnd->chatselector.StartSession(client);
					theApp.emuledlg->chatwnd->chatselector.SendMessage(EIS_STRING_INFO_REQ);
					break;
				// NEO: NXI END <-- Xanatos --
				case MPG_ALTENTER:
				case MP_DETAIL:
					ShowClientDialog(client);
					break;
				case MP_BOOT:
					if (client->GetKadPort())
						Kademlia::CKademlia::Bootstrap(ntohl(client->GetIP()), client->GetKadPort(), (client->GetKadVersion() > 1));

					break;
				// NEO: MOD - [NeoMenus] -- Xanatos -->
// ZZ:DownloadManager -->
				/*case MP_A4AF_CHECK_THIS_NOW:
					if (file->GetStatus(false) == PS_READY || file->GetStatus(false) == PS_EMPTY)
					{
						if (client->GetDownloadState() != DS_DOWNLOADING)
						{
							client->SwapToAnotherFile(_T("Manual init of source check. Test to be like ProcessA4AFClients(). CDownloadListCtrl::OnCommand() MP_SWAP_A4AF_DEBUG_THIS"), false, false, false, NULL, true, true, true); // ZZ:DownloadManager
							UpdateItem(file);
						}
					}
					break;*/
// <-- ZZ:DownloadManager
				// NEO: MCM - [ManualClientManagement]
				case MP_SWAP_TO_CLIENT:
					while (!selectedList.IsEmpty()){
						if (selectedList.GetHead()->GetDownloadState() != DS_DOWNLOADING && selectedList.GetHead()->GetRequestFile() != file)
						{
							selectedList.GetHead()->DoSwap(file, false, _T("Manual: Swap to this File"),true); // ZZ:DownloadManager
							UpdateItem(file);
						}
						selectedList.RemoveHead();
					}
					break;
				case MP_SWAP_FROM_CLIENT:
					while (!selectedList.IsEmpty()){
						if (selectedList.GetHead()->GetDownloadState() != DS_DOWNLOADING && selectedList.GetHead()->GetRequestFile() == file)
						{
							selectedList.GetHead()->SwapToAnotherFile(_T("Manual: Swap to an Other File"), false, true, false, NULL, true, true, true); // ZZ:DownloadManager
							UpdateItem(file);
						}
						selectedList.RemoveHead();
					}
					break;
				case MP_LOCK_CLIENT:
					while (!selectedList.IsEmpty() && selectedList.GetHead()->GetRequestFile() == file){
						selectedList.GetHead()->DisableSwaping(!client->IsSwapingDisabled());
						UpdateItem(file);
						selectedList.RemoveHead();
					}
					break;
				case MP_DROP_CLIENT:
					while (!selectedList.IsEmpty()){
						theApp.downloadqueue->RemoveSource(selectedList.GetHead());
						selectedList.GetHead()->ClearWhenNeeded();
						selectedList.RemoveHead();
					}
					break;
				case MP_STOP_CLIENT:
					while (!selectedList.IsEmpty()){
						if (selectedList.GetHead()->GetDownloadState() == DS_DOWNLOADING && selectedList.GetHead()->GetRequestFile() == file) {
							selectedList.GetHead()->SendCancelTransfer();
							selectedList.GetHead()->SetDownloadState(DS_ONQUEUE);
							UpdateItem(file);
						}
						selectedList.RemoveHead();
					}
					break;
				// NEO: MCM END
#ifdef NEO_SS // NEO: NSS - [NeoSourceStorage]
				case MP_EXPORTCLIENT:{
					CFileDialog dlg(FALSE, _T(".met.src"), NULL, OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, _T("Source Files (*.met.src)|*.met.src||"), NULL, 0);
					if(dlg.DoModal()!=IDOK)
						break;
					file->ExportSources(dlg.GetPathName(),selectedList);
					break;
				}
#endif // NEO_SS // NEO: NSS END
				// NEO: MOD END <-- Xanatos --
			}
		}
	}
	//else /*nothing selected*/ // NEO: MOD <-- Xanatos --

	switch (wParam){
		// NEO: PP - [PasswordProtection] -- Xanatos -->
		case MP_PWPROT_SHOW:
			SetRedraw(false);
			theApp.emuledlg->transferwnd->NeoCommand(INST_OTHER,INST_OTHER_PROTECT_SHOW);
			SetRedraw(true);
			break;
		case MP_PWPROT_HIDE:
			SetRedraw(false);
			theApp.emuledlg->transferwnd->NeoCommand(INST_OTHER,INST_OTHER_PROTECT_HIDE);
			SetRedraw(true);
			break;
		// NEO: PP END <-- Xanatos --
		case MP_CLEARCOMPLETED:
			ClearCompleted();
			break;
	}


	return TRUE;
}

void CDownloadListCtrl::OnColumnClick( NMHDR* pNMHDR, LRESULT* pResult){
	NM_LISTVIEW* pNMListView = (NM_LISTVIEW*)pNMHDR;

	// Barry - Store sort order in preferences
	// Determine ascending based on whether already sorted on this column
	int sortItem = GetSortItem();
	bool m_oldSortAscending = GetSortAscending();

	if (sortItem==9 || sortItem==2 || (sortItem==3 && IsAlternate())) {  // MOD - [SessionDL] <-- Xanatos --
		m_bRemainSort=(sortItem != pNMListView->iSubItem) ? false : (m_oldSortAscending?m_bRemainSort:!m_bRemainSort);
	}

	bool sortAscending = (sortItem != pNMListView->iSubItem) ? true : !m_oldSortAscending;
	
	// Item is column clicked
	sortItem = pNMListView->iSubItem;
	UpdateSortHistory(sortItem + (sortAscending ? 0:100), 100);
	
	// Save new preferences
	thePrefs.TransferlistRemainSortStyle(m_bRemainSort);
	
	// Sort table
	uint8 adder=0;
	if ((sortItem!=9 && GetSortItem()!=2 && (GetSortItem()!=3 || !IsAlternate())) || !m_bRemainSort ) // MOD - [SessionDL] <-- Xanatos --
		SetSortArrow(sortItem, sortAscending);
	else {
        SetSortArrow(sortItem, sortAscending?arrowDoubleUp : arrowDoubleDown);
		// MOD - [SessionDL] -- Xanatos -->
		if(GetSortItem()==2)
			adder=18;
		else if(GetSortItem()==3 && IsAlternate())
			adder=27;
		else
		// MOD END <-- Xanatos --
			adder=81;
	}
	
	SortItems(SortProc, sortItem + (sortAscending ? 0:100) + (IsAlternate()?2000:0) + adder ); // NEO: SEa - [SortAltExtension] <-- Xanatos --

	*pResult = 0;
}

int CDownloadListCtrl::SortProc(LPARAM lParam1, LPARAM lParam2, LPARAM lParamSort){
	CtrlItem_Struct* item1 = (CtrlItem_Struct*)lParam1;
	CtrlItem_Struct* item2 = (CtrlItem_Struct*)lParam2;

	// NEO: SEa - [SortAltExtension] -- Xanatos -->
	bool showSrc=false;  
	if (lParamSort>=2000)
	{ 
		showSrc=true; 
		lParamSort-=2000; 
	} 
	// NEO: SEa END <-- Xanatos --

	//int dwOrgSort = lParamSort;

	int sortMod = 1;
	if(lParamSort >= 100) 
	{
		sortMod = -1;
		lParamSort -= 100;
	}

	int comp;

	/*if(item1->type == FILE_TYPE && item2->type != FILE_TYPE) 
	{
		if (showSrc) return 0; // NEO: SEa - [SortAltExtension] <-- Xanatos --
		
		if(item1->value == item2->parent->value)
			return -1;

		comp = Compare((CPartFile*)item1->value, (CPartFile*)(item2->parent->value), lParamSort);

	}
	else if(item2->type == FILE_TYPE && item1->type != FILE_TYPE) 
	{
		if (showSrc) return 0; // NEO: SEa - [SortAltExtension] <-- Xanatos --

		if(item1->parent->value == item2->value)
			return 1;

		comp = Compare((CPartFile*)(item1->parent->value), (CPartFile*)item2->value, lParamSort);

	}
	else*/ 
	if (item1->type == FILE_TYPE && item2->type == FILE_TYPE) // NEO: SE - [SortExtension] -- Xanatos --
	{
		if (showSrc) return 0; // NEO: SEa - [SortAltExtension] <-- Xanatos --

		CPartFile* file1 = (CPartFile*)item1->value;
		CPartFile* file2 = (CPartFile*)item2->value;

		comp = Compare(file1, file2, lParamSort);

	}
	else if(item1->type != FILE_TYPE && item2->type != FILE_TYPE) // NEO: SE - [SortExtension] <-- Xanatos --
	{
		if (item1->parent->value != item2->parent->value) // different files
			return 0; // NEO: SEa - [SortAltExtension] <-- Xanatos --
		/*{
			comp = Compare((CPartFile*)(item1->parent->value), (CPartFile*)(item2->parent->value), lParamSort);
			return sortMod * comp;
		}*/

		if (item1->type != item2->type) // different source types
			return item1->type - item2->type;

		CUpDownClient* client1 = (CUpDownClient*)item1->value;
		CUpDownClient* client2 = (CUpDownClient*)item2->value;
		comp = Compare(client1, client2, lParamSort);
	}
	// NEO: SE - [SortExtension] -- Xanatos -->
	else // compare file and source
	{
		return 0;
	}
	// NEO: SE END <-- Xanatos --

	// NEO: SE - [SortExtension] -- Xanatos --
	/*int dwNextSort;
	//call secondary sortorder, if this one results in equal
	//(Note: yes I know this call is evil OO wise, but better than changing a lot more code, while we have only one instance anyway - might be fixed later)
	if (comp == 0 && (dwNextSort = theApp.emuledlg->transferwnd->downloadlistctrl.GetNextSortOrder(dwOrgSort)) != (-1)){
		return SortProc(lParam1, lParam2, dwNextSort);
	}
	else*/
	
	return sortMod * comp;
}

void CDownloadListCtrl::ClearCompleted(int incat){
	if (incat==-2)
		incat=curTab;

	// Search for completed file(s)
	for(ListItems::iterator it = m_ListItems.begin(); it != m_ListItems.end(); ){
		CtrlItem_Struct* cur_item = it->second;
		it++; // Already point to the next iterator. 
		if(cur_item->type == FILE_TYPE){
			CPartFile* file = reinterpret_cast<CPartFile*>(cur_item->value);
			if(file->IsPartFile() == false
#ifdef VOODOO // NEO: VOODOO - [UniversalPartfileInterface] -- Xanatos -->
			 || (file->IsVoodooFile() && file->GetAnyMaster() == NULL) // remove all voodoo files without masters
#endif // VOODOO // NEO: VOODOO END <-- Xanatos --	
			 && (file->CheckShowItemInGivenCat(incat) || incat==-1) ){
				if (RemoveFile(file))
					it = m_ListItems.begin();
			}
		}
	}
	if (thePrefs.ShowCatTabInfos())
		theApp.emuledlg->transferwnd->UpdateCatTabTitles();
}

void CDownloadListCtrl::ClearCompleted(const CPartFile* pFile)
{
	if (!pFile->IsPartFile())
	{
		for (ListItems::iterator it = m_ListItems.begin(); it != m_ListItems.end(); )
		{
			CtrlItem_Struct* cur_item = it->second;
			it++;
			if (cur_item->type == FILE_TYPE)
			{
				const CPartFile* pCurFile = reinterpret_cast<CPartFile*>(cur_item->value);
				if (pCurFile == pFile)
				{
					RemoveFile(pCurFile);
					return;
				}
			}
		}
	}
}

void CDownloadListCtrl::SetStyle()
{
	if (thePrefs.IsDoubleClickEnabled())
		SetExtendedStyle(LVS_EX_FULLROWSELECT | LVS_EX_INFOTIP);
	else
		SetExtendedStyle(LVS_EX_ONECLICKACTIVATE | LVS_EX_FULLROWSELECT | LVS_EX_INFOTIP);
}

void CDownloadListCtrl::OnListModified(NMHDR* pNMHDR, LRESULT* /*pResult*/)
{
	NM_LISTVIEW *pNMListView = (NM_LISTVIEW*)pNMHDR;

	//this works because true is equal to 1 and false equal to 0
	BOOL notLast = pNMListView->iItem + 1 != GetItemCount();
	BOOL notFirst = pNMListView->iItem != 0;
	RedrawItems(pNMListView->iItem - notFirst, pNMListView->iItem + notLast);
}

int CDownloadListCtrl::Compare(const CPartFile* file1, const CPartFile* file2, LPARAM lParamSort)
{
	int comp=0;
	switch(lParamSort)
	{
		case 0: //filename asc
			comp=CompareLocaleStringNoCase(file1->GetFileName(),file2->GetFileName());
			break;
		case 1: //size asc
			comp=CompareUnsigned64(file1->GetFileSize(), file2->GetFileSize());
			break;
		case 2: //transferred asc
			comp=CompareUnsigned64(file1->GetTransferred(), file2->GetTransferred());
			break;
		// MOD - [SessionDL] -- Xanatos -->
		case 20: //transferred session asc
			comp=CompareUnsigned64(file1->GetTransferredSession(), file2->GetTransferredSession());
			break;
		// MOD END <-- Xanatos --
		case 3: //completed asc
			comp=CompareUnsigned64(file1->GetCompletedSize(), file2->GetCompletedSize());
			break;
		case 4: //speed asc
			comp=CompareUnsigned(file1->GetDatarate(), file2->GetDatarate());
			break;
		case 5: //progress asc
			comp = CompareFloat(file1->GetPercentCompleted(), file2->GetPercentCompleted());
			break;
		case 6: //sources asc
			comp=CompareUnsigned(file1->GetSourceCount(), file2->GetSourceCount());
			break;
		case 7: //priority asc
			comp=CompareUnsigned(file1->GetDownPriority(), file2->GetDownPriority());
			break;
		case 8: //Status asc 
			comp=CompareUnsigned(file1->getPartfileStatusRang(),file2->getPartfileStatusRang());
			break;
		case 9: //Remaining Time asc
		{
			//Make ascending sort so we can have the smaller remaining time on the top 
			//instead of unknowns so we can see which files are about to finish better..
			time_t f1 = file1->getTimeRemaining();
			time_t f2 = file2->getTimeRemaining();
			//Same, do nothing.
			if( f1 == f2 ) 
			{
				comp=0;
				break;
			}
			//If descending, put first on top as it is unknown
			//If ascending, put first on bottom as it is unknown
			if( f1 == -1 ) 
			{
				comp=1;
				break;
			}
			//If descending, put second on top as it is unknown
			//If ascending, put second on bottom as it is unknown
			if( f2 == -1 ) 
			{
				comp=-1;
				break;
			}
			//If descending, put first on top as it is bigger.
			//If ascending, put first on bottom as it is bigger.
			comp = CompareUnsigned(f1, f2);
			break;
		}
		case 90: //Remaining SIZE asc
			comp=CompareUnsigned64(file1->GetFileSize()-file1->GetCompletedSize(), file2->GetFileSize()-file2->GetCompletedSize());
			break;
		case 10: //last seen complete asc
			if (file1->lastseencomplete > file2->lastseencomplete)
				comp=1;
			else if(file1->lastseencomplete < file2->lastseencomplete)
				comp=-1;
			else
				comp=0;
			break;
		case 11: //last received Time asc
			if (file1->GetFileDate() > file2->GetFileDate())
				comp=1;
			else if(file1->GetFileDate() < file2->GetFileDate())
				comp=-1;
			else
				comp=0;
			break;
		case 12:
#ifdef A4AF_CATS // NEO: MAC - [MorphA4AFCategories] -- Xanatos -->
			if (file1->GetCategory() > file2->GetCategory())
				comp=1;
			else if (file1->GetCategory() < file2->GetCategory())
				comp=-1;
			else
				comp=0;
#else
			//TODO: 'GetCategory' SHOULD be a 'const' function and 'GetResString' should NOT be called..
			comp=CompareLocaleStringNoCase(	(const_cast<CPartFile*>(file1)->GetCategory()!=0)?thePrefs.GetCategory(const_cast<CPartFile*>(file1)->GetCategory())->title:GetResString(IDS_ALL),
											(const_cast<CPartFile*>(file2)->GetCategory()!=0)?thePrefs.GetCategory(const_cast<CPartFile*>(file2)->GetCategory())->title:GetResString(IDS_ALL) );
#endif // A4AF_CATS // NEO: MAC END <-- Xanatos --
			break;
		// NEO: AHL - [AutoHardLimit] -- Xanatos -->
		case 13:
			comp=(const_cast<CPartFile*>(file1)->PartPrefs.GetHardLimit() > const_cast<CPartFile*>(file2)->PartPrefs.GetHardLimit());
			if(comp == 0)
			{
				comp=(const_cast<CPartFile*>(file1)->PartPrefs.UseAutoHardLimit() > const_cast<CPartFile*>(file2)->PartPrefs.UseAutoHardLimit());
				if(comp == 0)
				{
					comp=(file1->GetAutoHardLimit() > file2->GetAutoHardLimit());
					if(comp == 0)
					{
						comp=(file1->GetValidSourcesCount() > file2->GetValidSourcesCount());
						if(comp == 0)
						{
							comp=(file1->GetWaitingSourceCount() > file2->GetWaitingSourceCount());
							if(comp == 0)
							{
								comp=(const_cast<CPartFile*>(file1)->PartPrefs.UseSourceCache() > const_cast<CPartFile*>(file2)->PartPrefs.UseSourceCache());
								if(comp == 0)
									comp=(file1->GetAutoSoftLocked() > file2->GetAutoSoftLocked());
							}
						}
					}
				}
			}
			break;
		// NEO: AHL END <-- Xanatos --
		// NEO: MTD - [MultiTempDirectories] -- Xanatos -->
		case 14:
			comp=CompareLocaleStringNoCase(file1->GetPath(),file2->GetPath());
			break;
		// NEO: MTD END <-- Xanatos --
		// NEO: MOD -- Xanatos -->
		case 15:
			comp=CompareUnsigned64((file1->GetFileSize() - file1->GetCompletedSize()), (file2->GetFileSize() - file2->GetCompletedSize()));
			break;
		// NEO: MOD END <-- Xanatos --
#ifdef A4AF_CATS // NEO: MAC - [MorphA4AFCategories] -- Xanatos -->
		case 16:
			/*if (CPartFile::RightFileHasHigherPrio(file2, file1)) // lit
				comp=1;
			else if (CPartFile::RightFileHasHigherPrio(file1, file2))
				comp=-1;
			else
				comp=0;*/
			comp = (file1->GetCatResumeOrder() - file2->GetCatResumeOrder());
			break;
#endif // A4AF_CATS // NEO: MAC END <-- Xanatos --
#ifdef WEBCACHE // NEO: WC - [WebCache] -- Xanatos -->
		case 17:
			comp = file1->GetWebcacheSourceCount() - file2->GetWebcacheSourceCount();
			break;
#endif // NEO: WC END <-- Xanatos --
		default:
			comp=0;
	}
	return comp;
 }

int CDownloadListCtrl::Compare(const CUpDownClient *client1, const CUpDownClient *client2, LPARAM lParamSort)
{
	switch (lParamSort)
	{
	case 0: //name asc
		/*if (client1->GetUserName() == client2->GetUserName())
			return 0;
		else if (!client1->GetUserName())	// place clients with no usernames at bottom
			return 1;
		else if (!client2->GetUserName())	// place clients with no usernames at bottom
			return -1;*/
		return CompareLocaleStringNoCase(client1->GetUserName(), client2->GetUserName()); // NEO: FIX - [StabilityFix] <-- Xanatos --

	case 1: //size but we use status asc
		return client1->GetSourceFrom() - client2->GetSourceFrom();

	// MOD - [SessionDL] -- Xanatos -->
	case 2://transferred asc
		return CompareUnsigned(client1->GetTransferredDown(), client2->GetTransferredDown());

	case 20: //transferred session asc
		return  CompareUnsigned64(client1->Credits() ? client1->Credits()->GetDownloadedTotal() : 0, client2->Credits() ? client2->Credits()->GetDownloadedTotal() : 0);

	case 3://completed asc
		return CompareUnsigned(client1->GetTransferredUp(), client2->GetTransferredUp());

	case 30: //completed session asc
		return  CompareUnsigned64(client1->Credits() ? client1->Credits()->GetUploadedTotal() : 0, client2->Credits() ? client2->Credits()->GetUploadedTotal() : 0);
	// MOD END <-- Xanatos --

	case 4: //speed asc
		return CompareUnsigned(client1->GetDownloadDatarate(), client2->GetDownloadDatarate());

	case 5: //progress asc
		return CompareUnsigned(client1->GetAvailablePartCount(), client2->GetAvailablePartCount());

	case 6:
		/*if (client1->GetClientSoft() == client2->GetClientSoft())
			return CompareUnsigned(client2->GetVersion(), client1->GetVersion());
		return CompareUnsigned(client1->GetClientSoft(), client2->GetClientSoft());*/
		return wcscmp(client1->DbgGetFullClientSoftVer(), client2->DbgGetFullClientSoftVer()); // NEO: MIDI - [ModIDInfo] <-- Xanatos --
	case 7: //qr asc
		if (client1->GetDownloadState() == DS_DOWNLOADING){
			if (client2->GetDownloadState() == DS_DOWNLOADING)
				return 0;
			else
				return -1;
		}
		else if (client2->GetDownloadState() == DS_DOWNLOADING)
			return 1;
		if (client1->GetRemoteQueueRank() == 0 
			&& client1->GetDownloadState() == DS_ONQUEUE && client1->IsRemoteQueueFull() == true)
			return 1;
		if (client2->GetRemoteQueueRank() == 0 
			&& client2->GetDownloadState() == DS_ONQUEUE && client2->IsRemoteQueueFull() == true)
			return -1;
		if (client1->GetRemoteQueueRank() == 0)
			return 1;
		if (client2->GetRemoteQueueRank() == 0)
			return -1;
		return CompareUnsigned(client1->GetRemoteQueueRank(), client2->GetRemoteQueueRank());

	case 8:
		if (client1->GetDownloadState() == client2->GetDownloadState()){
			if (client1->IsRemoteQueueFull() && client2->IsRemoteQueueFull())
				return 0;
			else if (client1->IsRemoteQueueFull())
				return 1;
			else if (client2->IsRemoteQueueFull())
				return -1;
		}
		return client1->GetDownloadState() - client2->GetDownloadState();

	// NEO: EDT - [EstimatedDownloadTime] -- Xanatos -->
	case 9:
		if ((client1->GetDownloadTimeVersion()) != (client2->GetDownloadTimeVersion()))
			return (int)((client2->GetDownloadTimeVersion()) - (client1->GetDownloadTimeVersion()));
		if(client1->GetDownloadState() == DS_DOWNLOADING)
			if(client2->GetDownloadState() == DS_DOWNLOADING)
				return CompareUnsigned(client2->GetDownloadDatarate(), client1->GetDownloadDatarate());
			else
				return -1;
		else if (client2->GetDownloadState() == DS_DOWNLOADING)
			return 1;
		if(client1->GetDownloadTimeVal() == EDT_INFINITE_TIME) return 1;
		if(client2->GetDownloadTimeVal() == EDT_INFINITE_TIME) return -1;
		if(client1->GetDownloadTimeVal() == IDS_X_EDT_UNDEFINED) return 1;
		if(client2->GetDownloadTimeVal() == IDS_X_EDT_UNDEFINED) return -1;
		return client1->GetDownloadTimeVal() - client2->GetDownloadTimeVal();
	// NEO: EDT END <-- Xanatos --

	// NEO: MOD -- Xanatos -->
	case 10:	// last seen complete
		return client1->GetLastSeen() - client2->GetLastSeen();
	case 11:	// last received
		return client1->GetLastAskedTime() - client2->GetLastAskedTime();
	// NEO: MOD END <-- Xanatos --

#ifdef IP2COUNTRY // NEO: IP2C - [IPtoCountry] -- Xanatos -->
	case 12:
		if(client1->GetCountryName(true) && client2->GetCountryName(true))
			return CompareLocaleStringNoCase(client1->GetCountryName(true), client2->GetCountryName(true));
		else if(client1->GetCountryName(true))
			return 1;
		else
			return -1;
#endif // IP2COUNTRY // NEO: IP2C END <-- Xanatos --

#ifdef ARGOS // NEO: NA - [NeoArgos] -- Xanatos -->
	case 13:
		return wcscmp(theApp.argos->GetArgosString(client1), theApp.argos->GetArgosString(client2));
#endif //ARGOS // NEO: NA END <-- Xanatos --
#ifdef WEBCACHE // NEO: WC - [WebCache] -- Xanatos -->
	//JP Webcache START 	
	case 17:
		if (client1->SupportsWebCache() && client2->SupportsWebCache() )
			return CompareLocaleStringNoCase(client1->GetWebCacheName(),client2->GetWebCacheName());
		else
			return client1->SupportsWebCache() - client2->SupportsWebCache();
	//JP Webcache END
#endif // NEO: WC END <-- Xanatos --

	default:
		return 0;
	}
}

// NEO: NTS - [NeoTreeStyle] -- Xanatos -->
void CDownloadListCtrl::OnClickDownloadlist(NMHDR* pNMHDR, LRESULT* /*pResult*/)
{
	POINT point;
	::GetCursorPos(&point);
	CPoint p = point; 
    ScreenToClient(&p);

	LPNMITEMACTIVATE pNMIA = reinterpret_cast<LPNMITEMACTIVATE>(pNMHDR);

	if (p.x<14) 
		ExpandCollapseItem(pNMIA->iItem,2);
}
// NEO: NTS END <-- Xanatos --

void CDownloadListCtrl::OnNMDblclkDownloadlist(NMHDR* /*pNMHDR*/, LRESULT* pResult)
{
	int iSel = GetSelectionMark();
	if (iSel != -1)
	{
		const CtrlItem_Struct* content = (CtrlItem_Struct*)GetItemData(iSel);
		if (content && content->value)
		{
			if (content->type == FILE_TYPE)
			{
				if (!thePrefs.IsDoubleClickEnabled())
				{
					CPoint pt;
					::GetCursorPos(&pt);
					ScreenToClient(&pt);
					LVHITTESTINFO hit;
					hit.pt = pt;
					if (HitTest(&hit) >= 0 && (hit.flags & LVHT_ONITEM))
					{
						LVHITTESTINFO subhit;
						subhit.pt = pt;
						if (SubItemHitTest(&subhit) >= 0 && subhit.iSubItem == 0)
						{
							CPartFile* file = (CPartFile*)content->value;
							if (thePrefs.ShowRatingIndicator() 
								&& (file->HasComment() || file->HasRating() || file->IsKadCommentSearchRunning()) 
								&& pt.x >= FILE_ITEM_MARGIN_X+theApp.GetSmallSytemIconSize().cx 
								&& pt.x <= FILE_ITEM_MARGIN_X+theApp.GetSmallSytemIconSize().cx+RATING_ICON_WIDTH)
								ShowFileDialog(IDD_COMMENTLST);
							else if (thePrefs.GetPreviewOnIconDblClk()
									 && pt.x >= FILE_ITEM_MARGIN_X 
									 && pt.x < FILE_ITEM_MARGIN_X+theApp.GetSmallSytemIconSize().cx) {
								if (file->IsReadyForPreview())
									file->PreviewFile();
								else
									MessageBeep(MB_OK);
							}
							else
								ShowFileDialog(0);
						}
					}
				}
			}
			else
			{
				ShowClientDialog((CUpDownClient*)content->value);
			}
		}
	}
	
	*pResult = 0;
}

void CDownloadListCtrl::CreateMenues()
{
	if (m_PrioMenu) 
		VERIFY( m_PrioMenu.DestroyMenu() );
	// NEO: MOD - [NeoMenus] -- Xanatos -->
	if (m_ConfigMenu)
		VERIFY( m_ConfigMenu.DestroyMenu() ); // NEO: FCFG - [FileConfiguration]
	if (m_UpPrioMenu) 
		VERIFY( m_UpPrioMenu.DestroyMenu() );
	if (m_PermMenu) 
		VERIFY( m_PermMenu.DestroyMenu() ); // NEO: SSP - [ShowSharePermissions]
	if (m_PWProtMenu) 
		VERIFY( m_PWProtMenu.DestroyMenu() ); // NEO: PP - [PasswordProtection]
	if (m_CollectMenu) 
		VERIFY( m_CollectMenu.DestroyMenu() ); // NEO: MSH - [ManualSourceHandling]
	if (m_SourcesMenu) 
		VERIFY( m_SourcesMenu.DestroyMenu() );
	if (m_ReaskMenu) 
		VERIFY( m_ReaskMenu.DestroyMenu() ); // NEO: MDR - [ManualDownloadReask]
	if (m_A4AFMenu)
		VERIFY( m_A4AFMenu.DestroyMenu() );  // NEO: MCM - [ManualClientManagement]
	if (m_DropMenu) 
		VERIFY( m_DropMenu.DestroyMenu() ); // NEO: MDS - [ManualDropSources]	if (m_TempDirMenu) 
	if (m_TempDirMenu)
		VERIFY( m_TempDirMenu.DestroyMenu() ); // NEO: MTD - [MultiTempDirectories]
	// NEO: MOD END <-- Xanatos --
	if (m_FileMenu) 
		VERIFY( m_FileMenu.DestroyMenu() );

	m_PrioMenu.CreateMenu();
	m_PrioMenu.AddMenuTitle(NULL, true);
	m_PrioMenu.AppendMenu(MF_STRING,MP_DLPRIOLOW,GetResString(IDS_PRIOLOW));
	m_PrioMenu.AppendMenu(MF_STRING,MP_DLPRIONORMAL,GetResString(IDS_PRIONORMAL));
	m_PrioMenu.AppendMenu(MF_STRING,MP_DLPRIOHIGH, GetResString(IDS_PRIOHIGH));
	m_PrioMenu.AppendMenu(MF_STRING,MP_DLPRIOAUTO, GetResString(IDS_PRIOAUTO));

	// NEO: MOD - [NeoMenus] -- Xanatos -->
	// NEO: FCFG - [FileConfiguration]
	m_ConfigMenu.CreateMenu();
	m_ConfigMenu.AddMenuTitle(NULL, true);
	m_ConfigMenu.AppendMenu(MF_STRING,MP_FCFG_CLEAR, GetResString(IDS_X_FCFG_CLEAR), _T("FCFGCLEAR"));
	m_ConfigMenu.AppendMenu(MF_STRING,MP_FCFG_COPY, GetResString(IDS_X_FCFG_COPY), _T("FCFGCOPY"));
	m_ConfigMenu.AppendMenu(MF_STRING,MP_FCFG_PASTE, GetResString(IDS_X_FCFG_PASTE), _T("FCFGPASTE"));
	m_ConfigMenu.AppendMenu(MF_STRING,MP_FCFG_PASTE2, GetResString(IDS_X_FCFG_PASTE2), _T("FCFGPASTE"));
	// NEO: FCFG END

	m_UpPrioMenu.CreateMenu();
	m_UpPrioMenu.AddMenuTitle(NULL, true);
	m_UpPrioMenu.AppendMenu(MF_STRING,MP_PRIOVERYLOW,GetResString(IDS_PRIOVERYLOW));
	m_UpPrioMenu.AppendMenu(MF_STRING,MP_PRIOLOW,GetResString(IDS_PRIOLOW));
	m_UpPrioMenu.AppendMenu(MF_STRING,MP_PRIONORMAL,GetResString(IDS_PRIONORMAL));
	m_UpPrioMenu.AppendMenu(MF_STRING,MP_PRIOHIGH, GetResString(IDS_PRIOHIGH));
	m_UpPrioMenu.AppendMenu(MF_STRING,MP_PRIOVERYHIGH, GetResString(IDS_PRIOVERYHIGH)); // NEO: RT - [ReleaseTweaks]
	m_UpPrioMenu.AppendMenu(MF_STRING,MP_PRIOAUTO, GetResString(IDS_PRIOAUTO));//UAP
	m_UpPrioMenu.AppendMenu(MF_SEPARATOR);
	m_UpPrioMenu.AppendMenu(MF_STRING,MP_PRIORELEASE, GetResString(IDS_PRIORELEASE)); // NEO: RT - [ReleaseTweaks]

	// NEO: SSP - [ShowSharePermissions]
	m_PermMenu.CreateMenu();
	m_PermMenu.AddMenuTitle(NULL, true);
	/*CString buffer;
	switch (thePrefs.GetPermissions()){
		case PERM_ALL:
			buffer.Format(" (%s)",GetResString(IDS_FSTATUS_PUBLIC));
			break;
		case PERM_FRIENDS:
			buffer.Format(" (%s)",GetResString(IDS_FSTATUS_FRIENDSONLY));
			break;
		case PERM_COMMUNITY:
			buffer.Format(" (%s)",GetResString(IDS_X_FSTATUS_COMMUNITY));
			break;
		case PERM_NOONE:
			buffer.Format(" (%s)",GetResString(IDS_HIDDEN));
			break;
		default:
			buffer = " (?)";
			break;
	}*/
	m_PermMenu.AppendMenu(MF_STRING,MP_PERMDEFAULT, GetResString(IDS_DEFAULT) /*+ buffer*/);
	m_PermMenu.AppendMenu(MF_STRING,MP_PERMNONE, GetResString(IDS_HIDDEN));
	m_PermMenu.AppendMenu(MF_STRING,MP_PERMFRIENDS, GetResString(IDS_FSTATUS_FRIENDSONLY));
	m_PermMenu.AppendMenu(MF_STRING,MP_PERMALL, GetResString(IDS_FSTATUS_PUBLIC));
	// NEO: SSP END

	// NEO: PP - [PasswordProtection]
	m_PWProtMenu.CreateMenu();
	m_PWProtMenu.AddMenuTitle(NULL, true);
	m_PWProtMenu.AppendMenu(MF_STRING,MP_PWPROT_SHOW,GetResString(IDS_X_PWPROT_SHOW), _T("PWPROT_SHOW"));
	m_PWProtMenu.AppendMenu(MF_STRING,MP_PWPROT_HIDE,GetResString(IDS_X_PWPROT_HIDE), _T("PWPROT_HIDE"));
	m_PWProtMenu.AppendMenu(MF_SEPARATOR);
	m_PWProtMenu.AppendMenu(MF_STRING,MP_PWPROT_SET,GetResString(IDS_X_PWPROT_SET), _T("PWPROT_SET"));
	m_PWProtMenu.AppendMenu(MF_STRING,MP_PWPROT_CHANGE,GetResString(IDS_X_PWPROT_CHANGE), _T("PWPROT_CHANGE"));
	m_PWProtMenu.AppendMenu(MF_STRING,MP_PWPROT_UNSET,GetResString(IDS_X_PWPROT_UNSET), _T("PWPROT_UNSET"));
	// NEO: PP END

	// NEO: MSH - [ManualSourceHandling]
	m_CollectMenu.CreateMenu();
	m_CollectMenu.AddMenuTitle(NULL, true);
	m_CollectMenu.AppendMenu(MF_STRING,MP_COLLECT_ALL_SOURCES,GetResString(IDS_X_COLLECT_ALL_SOURCES), _T("SRCALL"));
	m_CollectMenu.AppendMenu(MF_SEPARATOR);
	m_CollectMenu.AppendMenu(MF_STRING,MP_COLLECT_XS_SOURCES,GetResString(IDS_X_COLLECT_XS_SOURCES), _T("XSSRC"));
	m_CollectMenu.AppendMenu(MF_STRING,MP_COLLECT_SVR_SOURCES,GetResString(IDS_X_COLLECT_SVR_SOURCES), _T("SVRSRC"));
	m_CollectMenu.AppendMenu(MF_STRING,MP_COLLECT_KAD_SOURCES,GetResString(IDS_X_COLLECT_KAD_SOURCES), _T("KADSRC"));
	m_CollectMenu.AppendMenu(MF_STRING,MP_COLLECT_UDP_SOURCES,GetResString(IDS_X_COLLECT_UDP_SOURCES), _T("UDPSRC"));
#ifdef VOODOO // NEO: VOODOOn - [VoodooExtensionForNeo]
	m_CollectMenu.AppendMenu(MF_SEPARATOR);
	m_CollectMenu.AppendMenu(MF_STRING,MP_COLLECT_VOODOO_SOURCES,GetResString(IDS_X_COLLECT_VOODOO_SOURCES), _T("SRCVOODOO"));
#endif // VOODOO // NEO: VOODOOn END
	// NEO: AHL - [AutoHardLimit]
	m_CollectMenu.AppendMenu(MF_SEPARATOR);
	m_CollectMenu.AppendMenu(MF_STRING,MP_AHL_INCREASE, GetResString(IDS_X_AHL_INCREASE), _T("AHLINCREASE"));
	m_CollectMenu.AppendMenu(MF_STRING,MP_AHL_DECREASE, GetResString(IDS_X_AHL_DECREASE), _T("AHLDECREASE"));
	// NEO: AHL END
	// NEO: MSH END

	m_SourcesMenu.CreateMenu();
	m_SourcesMenu.AddMenuTitle(NULL, true);
	m_SourcesMenu.AppendMenu(MF_STRING,MP_ADDSOURCE, GetResString(IDS_ADDSRCMANUALLY), _T("MANADDSRC"));
#ifdef NEO_SS // NEO: NSS - [NeoSourceStorage]
	m_SourcesMenu.AppendMenu(MF_SEPARATOR);
	m_SourcesMenu.AppendMenu(MF_STRING,MP_LOADSOURCE, GetResString(IDS_X_LOADSRCMANUALLY), _T("LOADSRC"));
	m_SourcesMenu.AppendMenu(MF_STRING,MP_SAVESOURCE, GetResString(IDS_X_SAVESRCMANUALLY), _T("SAVESRC"));
	m_SourcesMenu.AppendMenu(MF_SEPARATOR);
	m_SourcesMenu.AppendMenu(MF_STRING,MP_IMPORTSOURCE, GetResString(IDS_X_IMPORTSRCMANUALLY), _T("IMPORTSRC"));
	m_SourcesMenu.AppendMenu(MF_STRING,MP_EXPORTSOURCE, GetResString(IDS_X_EXPORTSRCMANUALLY), _T("EXPOERSRC"));
 #ifdef NEO_CD // NEO: NCD - [NeoClientDatabase] // NEO: SFL - [SourceFileList]
	m_SourcesMenu.AppendMenu(MF_SEPARATOR);
	m_SourcesMenu.AppendMenu(MF_STRING,MP_FINDSOURCES, GetResString(IDS_X_FINDSOURCES), _T("FINDSOURCES"));
 #endif // NEO_CD // NEO: NCD END // NEO: SFL END
#endif // NEO_SS // NEO: NSS END

	// NEO: MDR - [ManualDownloadReask]
	m_ReaskMenu.CreateMenu();
	m_ReaskMenu.AddMenuTitle(NULL, true);
	m_ReaskMenu.AppendMenu(MF_STRING,MP_REASK_FULLQ,GetResString(IDS_X_REASK_FULLQ), _T("REASKFULLQ"));
	m_ReaskMenu.AppendMenu(MF_STRING,MP_REASK_NNP,GetResString(IDS_X_REASK_NNP), _T("REASKNNP")); 
	m_ReaskMenu.AppendMenu(MF_SEPARATOR);
	m_ReaskMenu.AppendMenu(MF_STRING,MP_REASK_WAITINGRETRY,GetResString(IDS_X_REASK_WAITINGRETRY), _T("REASKWAITINGRETRY")); // NEO: TCR - [TCPConnectionRetry]
	m_ReaskMenu.AppendMenu(MF_STRING,MP_REASK_CACHED,GetResString(IDS_X_REASK_CACHED), _T("REASKCACHED")); // NEO: XSC - [ExtremeSourceCache]
#ifdef NEO_SS // NEO: NSS - [NeoSourceStorage]
	m_ReaskMenu.AppendMenu(MF_STRING,MP_REASK_LOADEDGROUP,GetResString(IDS_X_REASK_LOADEDGRPOUP), _T("REASKLOADEDGROUP"));
	m_ReaskMenu.AppendMenu(MF_STRING,MP_REASK_LOADED,GetResString(IDS_X_REASK_LOADED), _T("REASKLOADED"));
	m_ReaskMenu.AppendMenu(MF_STRING,MP_REASK_LOADEDWAITING,GetResString(IDS_X_REASK_LOADEDWAITING), _T("REASKLOADEDWAITING"));
#ifdef NEO_SA // NEO: NSA - [NeoSourceAnaliser]
	m_ReaskMenu.AppendMenu(MF_STRING,MP_REASK_RESERVE,GetResString(IDS_X_REASK_RESERVE), _T("REASKRESERVE"));
#endif // NEO_SA // NEO: NSA END
#endif // NEO_SS // NEO: NSS END
#ifdef NEO_SK // NEO: NSK - [NeoSourceKeeper]
#endif // NEO_SK // NEO: NSK END
	// NEO: MDR END

	// NEO: MCM - [ManualClientManagement]
	m_A4AFMenu.CreateMenu();
	m_A4AFMenu.AddMenuTitle(NULL, true); 
#ifdef A4AF_CATS // NEO: MAC - [MorphA4AFCategories]
	m_A4AFMenu.AppendMenu(MF_STRING, MP_FORCEA4AF, GetResString(IDS_X_A4AF_FORCEALL), _T("ADVA4AFALL"));
	m_A4AFMenu.AppendMenu(MF_SEPARATOR);
#endif // A4AF_CATS // NEO: MAC END
	m_A4AFMenu.AppendMenu(MF_STRING,MP_SWAP_TO_A4AF,GetResString(IDS_X_SWAP_TO_A4AF), _T("ADVA4AFTO"));
	m_A4AFMenu.AppendMenu(MF_STRING,MP_SWAP_FROM_A4AF,GetResString(IDS_X_SWAP_FROM_A4AF), _T("ADVA4AFFROM"));
	// NEO: MCM END

	// NEO: MDS - [ManualDropSources]
	m_DropMenu.CreateMenu();
	m_DropMenu.AddMenuTitle(NULL, true);
	m_DropMenu.AppendMenu(MF_STRING,MP_DROP_NNP,GetResString(IDS_X_DROP_NNP), _T("DROPNNP"));
	m_DropMenu.AppendMenu(MF_STRING,MP_DROP_FULLQ,GetResString(IDS_X_DROP_FULLQ), _T("DROPFULLQ"));
	m_DropMenu.AppendMenu(MF_STRING,MP_DROP_HIGHQ,GetResString(IDS_X_DROP_HIGHQ), _T("DROPHIGHQ"));
	m_DropMenu.AppendMenu(MF_SEPARATOR);
	m_DropMenu.AppendMenu(MF_STRING,MP_DROP_WAITINGRETRY,GetResString(IDS_X_DROP_WAITINGRETRY), _T("DROPWAITINGRETRY")); // NEO: TCR - [TCPConnectionRetry]
	m_DropMenu.AppendMenu(MF_STRING,MP_DROP_CACHED,GetResString(IDS_X_DROP_CACHED), _T("DROPCACHED")); // NEO: XSC - [ExtremeSourceCache]
#ifdef NEO_SS // NEO: NSS - [NeoSourceStorage]
	m_DropMenu.AppendMenu(MF_STRING,MP_DROP_OUTOFDATE,GetResString(IDS_X_DROP_OUTOFDATE), _T("DROPOUTOFDATE"));
	m_DropMenu.AppendMenu(MF_STRING,MP_DROP_LOADED,GetResString(IDS_X_DROP_LOADED), _T("DROPLOADED"));
	m_DropMenu.AppendMenu(MF_STRING,MP_DROP_LOADEDWAITING,GetResString(IDS_X_DROP_LOADEDWAITING), _T("DROPLOADEDWAITING"));
#ifdef NEO_SA // NEO: NSA - [NeoSourceAnaliser]
	m_DropMenu.AppendMenu(MF_STRING,MP_DROP_RESERVE,GetResString(IDS_X_DROP_RESERVE), _T("DROPRESERVE"));
	m_DropMenu.AppendMenu(MF_STRING,MP_DROP_RETIRED,GetResString(IDS_X_DROP_RETIRED), _T("DROPRETIRED"));
#endif // NEO_SA // NEO: NSA END
#endif // NEO_SS // NEO: NSS END
#ifdef NEO_SK // NEO: NSK - [NeoSourceKeeper]
	m_DropMenu.AppendMenu(MF_STRING,MP_DROP_UNREACHABLE,GetResString(IDS_X_DROP_UNREACHABLE), _T("DROPUNREACHABLE"));
#endif // NEO_SK // NEO: NSK END
	m_DropMenu.AppendMenu(MF_SEPARATOR);
	m_DropMenu.AppendMenu(MF_STRING,MP_DROP_TOMANY,GetResString(IDS_X_DROP_TOMANY), _T("DROPTOMANY"));
	m_DropMenu.AppendMenu(MF_STRING,MP_DROP_UNKNOWN,GetResString(IDS_X_DROP_UNKNOWN), _T("DROPUNKNOWN"));
	m_DropMenu.AppendMenu(MF_STRING,MP_DROP_BAD,GetResString(IDS_X_DROP_BAD), _T("DROPBAD"));
	m_DropMenu.AppendMenu(MF_STRING,MP_DROP_LOW2LOW,GetResString(IDS_X_DROP_LOW2LOW), _T("DROPLOW2LOW"));
	// NEO: MDS END

	// NEO: MTD - [MultiTempDirectories]
	m_TempDirMenu.CreateMenu();
	m_TempDirMenu.AddMenuTitle(NULL, true);
	m_TempDirMenu.AppendMenu(MF_STRING,MP_MTD_UNLOAD,GetResString(IDS_X_MTD_UNLOAD), _T("MTD_UNLOAD"));
	m_TempDirMenu.AppendMenu(MF_SEPARATOR);
	// NEO: MTD END
	// NEO: MOD END <-- Xanatos --

	m_FileMenu.CreatePopupMenu();
	m_FileMenu.AddMenuTitle(GetResString(IDS_DOWNLOADMENUTITLE), true);
	// NEO: MOD - [NeoMenus] -- Xanatos -->
	m_FileMenu.AppendMenu(MF_STRING,MP_RESUME, GetResString(IDS_DL_RESUME), _T("RESUME"));
	m_FileMenu.AppendMenu(MF_STRING,MP_FORCE, GetResString(IDS_X_DL_FORCE), _T("FORCE")); // NEO: OCF - [OnlyCompleetFiles]
	m_FileMenu.AppendMenu(MF_STRING,MP_STANDBY, GetResString(IDS_X_DL_STANDBY), _T("STANDBY")); // NEO: SD - [StandByDL]
	m_FileMenu.AppendMenu(MF_STRING,MP_SUSPEND, GetResString(IDS_X_DL_SUSPEND), _T("SUSPEND")); // NEO: SC - [SuspendCollecting]
	m_FileMenu.AppendMenu(MF_STRING,MP_PAUSE, GetResString(IDS_DL_PAUSE), _T("PAUSE"));
	m_FileMenu.AppendMenu(MF_STRING,MP_STOP, GetResString(IDS_DL_STOP), _T("STOP"));
	m_FileMenu.AppendMenu(MF_STRING,MP_CANCEL,GetResString(IDS_MAIN_BTN_CANCEL), _T("DELETE"));
	m_FileMenu.AppendMenu(MF_SEPARATOR);
	m_FileMenu.AppendMenu(MF_STRING|MF_POPUP,(UINT_PTR)m_PrioMenu.m_hMenu, GetResString(IDS_PRIORITY) + _T(" (") + GetResString(IDS_DOWNLOAD) + _T(")"), _T("FILEPRIORITY"));
	m_FileMenu.AppendMenu(MF_STRING|MF_POPUP,(UINT_PTR)m_UpPrioMenu.m_hMenu, GetResString(IDS_PRIORITY) + _T(" (") + GetResString(IDS_PW_CON_UPLBL) + _T(")"), _T("FILEPRIORITY"));
	m_FileMenu.AppendMenu(MF_SEPARATOR);
	m_FileMenu.AppendMenu(MF_STRING|MF_POPUP,(UINT_PTR)m_PermMenu.m_hMenu, GetResString(IDS_PERMISSION), _T("SHAREPERM")); // NEO: SSP - [ShowSharePermissions]
	m_FileMenu.AppendMenu(MF_STRING|MF_POPUP,(UINT_PTR)m_PWProtMenu.m_hMenu, GetResString(IDS_X_PWPROT_MENU), _T("PWPROT")); // NEO: PP - [PasswordProtection]
	// NEO: MOD END <-- Xanatos --
	m_FileMenu.AppendMenu(MF_SEPARATOR);

	m_FileMenu.AppendMenu(MF_STRING,MP_OPEN, GetResString(IDS_DL_OPEN), _T("OPENFILE"));
	if (thePrefs.IsExtControlsEnabled() && !thePrefs.GetPreviewPrio())
    	m_FileMenu.AppendMenu(MF_STRING,MP_TRY_TO_GET_PREVIEW_PARTS, GetResString(IDS_DL_TRY_TO_GET_PREVIEW_PARTS));
	m_FileMenu.AppendMenu(MF_STRING,MP_MASSRENAME,GetResString(IDS_X_MASSRENAME), _T("FILEMASSRENAME")); // NEO: MMR - [MorphMassRemane] <-- Xanatos --
	m_FileMenu.AppendMenu(MF_STRING,MP_PREVIEW, GetResString(IDS_DL_PREVIEW), _T("PREVIEW"));
	m_FileMenu.AppendMenu(MF_STRING,MP_METINFO, GetResString(IDS_DL_INFO), _T("FILEINFO"));
	m_FileMenu.AppendMenu(MF_STRING,MP_VIEWFILECOMMENTS, GetResString(IDS_CMT_SHOWALL), _T("FILECOMMENTS"));
	// NEO: MOD - [NeoMenus] -- Xanatos -->
	// NEO: FCFG - [FileConfiguration]
	m_FileMenu.AppendMenu(MF_STRING,MP_TWEAKS, GetResString(IDS_X_FILE_TWEAKS), _T("FILECONFIG"));
	m_FileMenu.AppendMenu(MF_STRING|MF_POPUP,(UINT_PTR)m_ConfigMenu.m_hMenu, GetResString(IDS_X_FCFG_CMD), _T("FCFGCMD"));
	// NEO: FCFG END
	m_FileMenu.AppendMenu(MF_SEPARATOR);
	m_FileMenu.AppendMenu(MF_STRING|MF_POPUP,(UINT_PTR)m_CollectMenu.m_hMenu, GetResString(IDS_X_SOURCE_COLLECTING), _T("COLLECTING")); // NEO: MSH - [ManualSourceHandling]
	m_FileMenu.AppendMenu(MF_STRING|MF_POPUP,(UINT_PTR)m_SourcesMenu.m_hMenu, GetResString(IDS_X_SOURCE_STORAGE), _T("STORAGE"));
	m_FileMenu.AppendMenu(MF_STRING|MF_POPUP,(UINT_PTR)m_ReaskMenu.m_hMenu, GetResString(IDS_X_REASK), _T("REASK")); // NEO: MDR - [ManualDownloadReask]
	m_FileMenu.AppendMenu(MF_STRING|MF_POPUP,(UINT_PTR)m_A4AFMenu.m_hMenu, GetResString(IDS_X_A4AF_MENU), _T("ADVA4AF")); ; // NEO: MCM - [ManualClientManagement]
	m_FileMenu.AppendMenu(MF_STRING|MF_POPUP,(UINT_PTR)m_DropMenu.m_hMenu, GetResString(IDS_X_DROP), _T("DROP")); // NEO: MDS - [ManualDropSources]
	m_FileMenu.AppendMenu(MF_SEPARATOR);
	m_FileMenu.AppendMenu(MF_STRING,MP_IMPORT, GetResString(IDS_X_IMPORT_PARTS), _T("PARTIMPORT")); // NEO: PIX - [PartImportExport]
	if(thePrefs.GetAllocCompleteMode() == false) // only when full allocation is disabled
		m_FileMenu.AppendMenu(MF_STRING,MP_PREALOCATE, GetResString(IDS_X_PREALOCATE), _T("PREALOCATE")); // NEO: MOD - [PreAllocate]
	m_FileMenu.AppendMenu(MF_STRING|MF_POPUP,(UINT_PTR)m_TempDirMenu.m_hMenu, GetResString(IDS_X_TEMPDIRMENUTITLE), _T("TEMPDIRS")); // NEO: MTD - [MultiTempDirectories]
	// NEO: MOD END <-- Xanatos --

	m_FileMenu.AppendMenu(MF_SEPARATOR);
	m_FileMenu.AppendMenu(MF_STRING,MP_CLEARCOMPLETED, GetResString(IDS_DL_CLEAR), _T("CLEARCOMPLETE"));

	m_FileMenu.AppendMenu(MF_SEPARATOR);
	// Add 'Copy & Paste' commands
	if (thePrefs.GetShowCopyEd2kLinkCmd())
		m_FileMenu.AppendMenu(MF_STRING, MP_GETED2KLINK, GetResString(IDS_DL_LINK1), _T("ED2KLINK"));
	else
		m_FileMenu.AppendMenu(MF_STRING, MP_SHOWED2KLINK, GetResString(IDS_DL_SHOWED2KLINK), _T("ED2KLINK"));
	m_FileMenu.AppendMenu(MF_STRING, MP_PASTE, GetResString(IDS_SW_DIRECTDOWNLOAD), _T("PASTELINK"));
	m_FileMenu.AppendMenu(MF_SEPARATOR);

	// Search commands
	//
	m_FileMenu.AppendMenu(MF_STRING, MP_SEARCHRELATED, GetResString(IDS_SEARCHRELATED), _T("KadFileSearch"));
	m_FileMenu.AppendMenu(MF_STRING, MP_FIND, GetResString(IDS_FIND), _T("Search"));
	m_FileMenu.AppendMenu(MF_SEPARATOR);
	// Web-services and categories will be added on-the-fly..
}

CString CDownloadListCtrl::getTextList()
{
	CString out;

	for (ListItems::iterator it = m_ListItems.begin(); it != m_ListItems.end(); it++)
	{
		const CtrlItem_Struct* cur_item = it->second;
		if (cur_item->type == FILE_TYPE)
		{
			const CPartFile* file = reinterpret_cast<CPartFile*>(cur_item->value);

			CString temp;
			temp.Format(_T("\n%s\t [%.1f%%] %i/%i - %s"),
						file->GetFileName(),
						file->GetPercentCompleted(),
						file->GetTransferringSrcCount(),
						file->GetSourceCount(), 
						file->getPartfileStatus());

			out += temp;
		}
	}

	return out;
}

int CDownloadListCtrl::GetFilesCountInCurCat()
{
	int iCount = 0;
	for (ListItems::const_iterator it = m_ListItems.begin(); it != m_ListItems.end(); it++)
	{
		CtrlItem_Struct* cur_item = it->second;
		if (cur_item->type == FILE_TYPE)
		{
			CPartFile* file = (CPartFile*)cur_item->value;
			if (file->CheckShowItemInGivenCat(curTab))
				iCount++;
		}
	}
	return iCount;
}

void CDownloadListCtrl::ShowFilesCount()
{
	theApp.emuledlg->transferwnd->UpdateFilesCount(GetFilesCountInCurCat());
}

void CDownloadListCtrl::ShowSelectedFileDetails()
{
	POINT point;
	::GetCursorPos(&point);
	CPoint pt = point; 
    ScreenToClient(&pt); 
    int it = HitTest(pt);
    if (it == -1)
		return;

	SetItemState(-1, 0, LVIS_SELECTED);
	SetItemState(it, LVIS_SELECTED | LVIS_FOCUSED, LVIS_SELECTED | LVIS_FOCUSED);
	SetSelectionMark(it);   // display selection mark correctly! 

	CtrlItem_Struct* content = (CtrlItem_Struct*)GetItemData(GetSelectionMark());
	if (content->type == FILE_TYPE)
	{
		CPartFile* file = (CPartFile*)content->value;
		if (thePrefs.ShowRatingIndicator() 
			&& (file->HasComment() || file->HasRating() || file->IsKadCommentSearchRunning()) 
			&& pt.x >= FILE_ITEM_MARGIN_X+theApp.GetSmallSytemIconSize().cx 
			&& pt.x <= FILE_ITEM_MARGIN_X+theApp.GetSmallSytemIconSize().cx+RATING_ICON_WIDTH)
			ShowFileDialog(IDD_COMMENTLST);
		else
			ShowFileDialog(0);
	}
	else
	{
		ShowClientDialog((CUpDownClient*)content->value);
	}
}

int CDownloadListCtrl::GetCompleteDownloads(int cat, int& total)
{
	total = 0;
	int count = 0;
	for (ListItems::const_iterator it = m_ListItems.begin(); it != m_ListItems.end(); it++)
	{
		const CtrlItem_Struct* cur_item = it->second;
		if (cur_item->type == FILE_TYPE)
		{
			/*const*/ CPartFile* file = reinterpret_cast<CPartFile*>(cur_item->value);
			if (file->CheckShowItemInGivenCat(cat) || cat==-1)
			{
				total++;
				if (file->GetStatus() == PS_COMPLETE)
					count++;
#ifdef VOODOO // NEO: VOODOO - [UniversalPartfileInterface] -- Xanatos -->
				else if (file->IsVoodooFile() && file->GetAnyMaster() == NULL) // remove all voodoo files without masters
					count++;
#endif // VOODOO // NEO: VOODOO END <-- Xanatos --	
			}
		}
	}
	return count;
}

void CDownloadListCtrl::UpdateCurrentCategoryView(){
	ChangeCategory(curTab);
}

void CDownloadListCtrl::UpdateCurrentCategoryView(CPartFile* thisfile) {

	ListItems::const_iterator it = m_ListItems.find(thisfile);
	if (it != m_ListItems.end()) {
		const CtrlItem_Struct* cur_item = it->second;
		if (cur_item->type == FILE_TYPE){
			CPartFile* file = reinterpret_cast<CPartFile*>(cur_item->value);
			
			if (!file->CheckShowItemInGivenCat(curTab) || file->IsPWProtHidden()) // NEO: PP - [PasswordProtection] <-- Xanatos --
				HideFile(file);
			else
				ShowFile(file);
		}
	}

}

void CDownloadListCtrl::ChangeCategory(int newsel){

	SetRedraw(FALSE);

	// remove all displayed files with a different cat and show the correct ones
	for(ListItems::const_iterator it = m_ListItems.begin(); it != m_ListItems.end(); it++){
		const CtrlItem_Struct* cur_item = it->second;
		if (cur_item->type == FILE_TYPE){
			CPartFile* file = reinterpret_cast<CPartFile*>(cur_item->value);
			
			if (!file->CheckShowItemInGivenCat(newsel) || file->IsPWProtHidden()) // NEO: PP - [PasswordProtection] <-- Xanatos --
				HideFile(file);
			else
				ShowFile(file);
		}
	}

	SetRedraw(TRUE);
	curTab=newsel;
	ShowFilesCount();
	// NEO: SE - [SortExtension] -- Xanatos -->
	AlterSortArrow();

	uint8 adder=0;
	if ((GetSortItem()!=9 && GetSortItem()!=2 && GetSortItem()!=3) || !m_bRemainSort ) // MOD - [SessionDL] <-- Xanatos --
		SetSortArrow();
	else {
		SetSortArrow(GetSortItem(), GetSortAscending()?arrowDoubleUp : arrowDoubleDown);
		// MOD - [SessionDL] -- Xanatos -->
		if(GetSortItem()==2)
			adder=18;
		else
		if(GetSortItem()==2)
			adder=27;
		else
		// MOD END <-- Xanatos --
			adder=81;
	}

	if (thePrefs.DisableAutoSort() == 2)
		SortItems(SortProc, GetSortItem() + (GetSortAscending()? 0:100) + adder);
	// NEO: SE END <-- Xanatos --
}

void CDownloadListCtrl::HideFile(CPartFile* tohide)
{
	HideSources(tohide);

	// Retrieve all entries matching the source
	std::pair<ListItems::const_iterator, ListItems::const_iterator> rangeIt = m_ListItems.equal_range(tohide);
	for(ListItems::const_iterator it = rangeIt.first; it != rangeIt.second; it++){
		CtrlItem_Struct* updateItem  = it->second;

		// Find entry in CListCtrl and update object
 		LVFINDINFO find;
		find.flags = LVFI_PARAM;
		find.lParam = (LPARAM)updateItem;
		int result = FindItem(&find);
		if (result != -1){
			DeleteItem(result);
			return;
		}
	}
}

void CDownloadListCtrl::ShowFile(CPartFile* toshow){
	// Retrieve all entries matching the source
	std::pair<ListItems::const_iterator, ListItems::const_iterator> rangeIt = m_ListItems.equal_range(toshow);
	ListItems::const_iterator it = rangeIt.first;
	if(it != rangeIt.second){
		CtrlItem_Struct* updateItem  = it->second;

		// Check if entry is already in the List
 		LVFINDINFO find;
		find.flags = LVFI_PARAM;
		find.lParam = (LPARAM)updateItem;
		int result = FindItem(&find);
		if (result == -1)
			InsertItem(LVIF_PARAM|LVIF_TEXT,GetItemCount(),LPSTR_TEXTCALLBACK,0,0,0,(LPARAM)updateItem);
	}
}

void CDownloadListCtrl::GetDisplayedFiles(CArray<CPartFile*,CPartFile*> *list){
	for(ListItems::iterator it = m_ListItems.begin(); it != m_ListItems.end(); ){
		CtrlItem_Struct* cur_item = it->second;
		it++; // Already point to the next iterator. 
		if(cur_item->type == FILE_TYPE){
			CPartFile* file = reinterpret_cast<CPartFile*>(cur_item->value);
			list->Add(file);
		}
	}	
}

void CDownloadListCtrl::MoveCompletedfilesCat(uint8 from, uint8 to)
{
	int mycat;

	for(ListItems::iterator it = m_ListItems.begin(); it != m_ListItems.end(); ){
		CtrlItem_Struct* cur_item = it->second;
		it++; // Already point to the next iterator.
		if(cur_item->type == FILE_TYPE){
			CPartFile* file = reinterpret_cast<CPartFile*>(cur_item->value);
			if (!file->IsPartFile()){
				mycat=file->GetCategory();
				if ( mycat>=min(from,to) && mycat<=max(from,to)) {
					if (mycat==from) 
						file->SetCategory(to); 
					else
						if (from<to)
							file->SetCategory(mycat-1);
						else
							file->SetCategory(mycat+1);
				}
			}
		}
	}
}

void CDownloadListCtrl::OnGetDispInfo(NMHDR* pNMHDR, LRESULT* pResult)
{
    NMLVDISPINFO* pDispInfo = (NMLVDISPINFO*)pNMHDR;
	/*TRACE("CDownloadListCtrl::OnGetDispInfo iItem=%d iSubItem=%d", pDispInfo->item.iItem, pDispInfo->item.iSubItem);
	if (pDispInfo->item.mask & LVIF_TEXT)
		TRACE(" LVIF_TEXT");
	if (pDispInfo->item.mask & LVIF_IMAGE)
		TRACE(" LVIF_IMAGE");
	if (pDispInfo->item.mask & LVIF_STATE)
		TRACE(" LVIF_STATE");
	TRACE("\n");*/

	// Although we have an owner drawn listview control we store the text for the primary item in the listview, to be
	// capable of quick searching those items via the keyboard. Because our listview items may change their contents,
	// we do this via a text callback function. The listview control will send us the LVN_DISPINFO notification if
	// it needs to know the contents of the primary item.
	//
	// But, the listview control sends this notification all the time, even if we do not search for an item. At least
	// this notification is only sent for the visible items and not for all items in the list. Though, because this
	// function is invoked *very* often, no *NOT* put any time consuming code here in.

    if (pDispInfo->item.mask & LVIF_TEXT){
        const CtrlItem_Struct* pItem = reinterpret_cast<CtrlItem_Struct*>(pDispInfo->item.lParam);
        if (pItem != NULL && pItem->value != NULL){
			if (pItem->type == FILE_TYPE){
				switch (pDispInfo->item.iSubItem){
					case 0:
						// NEO: NTT - [NewToolTips] -- Xanatos --
						/*if (pDispInfo->item.cchTextMax > 0){
							_tcsncpy(pDispInfo->item.pszText, ((CPartFile*)pItem->value)->GetFileName(), pDispInfo->item.cchTextMax);
							pDispInfo->item.pszText[pDispInfo->item.cchTextMax-1] = _T('\0');
						}*/
						break;
					default:
						// shouldn't happen
						pDispInfo->item.pszText[0] = _T('\0');
						break;
				}
			}
			else if (pItem->type == UNAVAILABLE_SOURCE || pItem->type == AVAILABLE_SOURCE){
				switch (pDispInfo->item.iSubItem){
					case 0:
						// NEO: NTT - [NewToolTips] -- Xanatos --
						/*if (!((CUpDownClient*)pItem->value)->GetUserName().IsEmpty() && pDispInfo->item.cchTextMax > 0){// NEO: FIX - [StabilityFix] <-- Xanatos --
							_tcsncpy(pDispInfo->item.pszText, ((CUpDownClient*)pItem->value)->GetUserName(), pDispInfo->item.cchTextMax);
							pDispInfo->item.pszText[pDispInfo->item.cchTextMax-1] = _T('\0');
						}*/
						break;
					default:
						// shouldn't happen
						pDispInfo->item.pszText[0] = _T('\0');
						break;
				}
			}
			else
				ASSERT(0);
        }
    }
    *pResult = 0;
}

// NEO: NTT - [NewToolTips] -- Xanatos --
/*void CDownloadListCtrl::OnLvnGetInfoTip(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMLVGETINFOTIP pGetInfoTip = reinterpret_cast<LPNMLVGETINFOTIP>(pNMHDR);
	if (pGetInfoTip->iSubItem == 0)
	{
		LVHITTESTINFO hti = {0};
		::GetCursorPos(&hti.pt);
		ScreenToClient(&hti.pt);
		if (SubItemHitTest(&hti) == -1 || hti.iItem != pGetInfoTip->iItem || hti.iSubItem != 0){
			// don' show the default label tip for the main item, if the mouse is not over the main item
			if ((pGetInfoTip->dwFlags & LVGIT_UNFOLDED) == 0 && pGetInfoTip->cchTextMax > 0 && pGetInfoTip->pszText[0] != '\0')
				pGetInfoTip->pszText[0] = '\0';
			return;
		}

		const CtrlItem_Struct* content = (CtrlItem_Struct*)GetItemData(pGetInfoTip->iItem);
		if (content && pGetInfoTip->pszText && pGetInfoTip->cchTextMax > 0)
		{
			CString info;

			// build info text and display it
			if (content->type == 1) // for downloading files
			{
				const CPartFile* partfile = (CPartFile*)content->value;
				info = partfile->GetInfoSummary();
			}
			else if (content->type == 3 || content->type == 2) // for sources
			{
				const CUpDownClient* client = (CUpDownClient*)content->value;
				if (client->IsEd2kClient())
				{
					in_addr server;
					server.S_un.S_addr = client->GetServerIP();
					info.Format(GetResString(IDS_USERINFO)
								+ GetResString(IDS_SERVER) + _T(":%s:%u\n\n")
								+ GetResString(IDS_NEXT_REASK) + _T(":%s"),
								!client->GetUserName().IsEmpty() ? client->GetUserName() : _T("?"), // NEO: FIX - [StabilityFix] <-- Xanatos --
								ipstr(server), client->GetServerPort(),
								CastSecondsToHM(client->GetTimeUntilReask(client->GetRequestFile()) / 1000));
					if (thePrefs.IsExtControlsEnabled())
						info.AppendFormat(_T(" (%s)"), CastSecondsToHM(client->GetTimeUntilReask(content->owner) / 1000));
					info += _T('\n');
					info.AppendFormat(GetResString(IDS_SOURCEINFO), client->GetAskedCountDown(), client->GetAvailablePartCount());
					info += _T('\n');

					if (content->type == 2)
					{
						info += GetResString(IDS_CLIENTSOURCENAME) + (!client->GetClientFilename().IsEmpty() ? client->GetClientFilename() : _T("-"));
						if(const CClientFileStatus* status = client->GetFileStatus(client->GetRequestFile())) // NEO: SCFS - [SmartClientFileStatus] <-- Xanatos --
						{
							if (!status->GetFileComment().IsEmpty())
								info += _T("\n") + GetResString(IDS_CMT_READ) + _T(" ") + status->GetFileComment();
							else
								info += _T("\n") + GetResString(IDS_CMT_NONE);
							info += _T("\n") + GetRateString(status->GetFileRating());
						}
					}
					else
					{	// client asked twice
						info += GetResString(IDS_ASKEDFAF);
                        if (client->GetRequestFile() && client->GetRequestFile()->GetFileName())
                            info.AppendFormat(_T(":%s"), client->GetRequestFile()->GetFileName());
					}

                    if (thePrefs.IsExtControlsEnabled() && !client->m_OtherRequests_list.IsEmpty())
					{
						CSimpleArray<const CString*> apstrFileNames;
						POSITION pos = client->m_OtherRequests_list.GetHeadPosition();
						while (pos)
							apstrFileNames.Add(&client->m_OtherRequests_list.GetNext(pos)->GetFileName());
						Sort(apstrFileNames);
						if (content->type == 2)
							info += _T('\n');
						info += _T('\n');
						info += GetResString(IDS_A4AF_FILES);
						info += _T(':');
						for (int i = 0; i < apstrFileNames.GetSize(); i++)
						{
							const CString* pstrFileName = apstrFileNames[i];
							if (info.GetLength() + (i > 0 ? 2 : 0) + pstrFileName->GetLength() >= pGetInfoTip->cchTextMax) {
								static const TCHAR szEllipses[] = _T("\n:...");
								if (info.GetLength() + (int)ARRSIZE(szEllipses) - 1 < pGetInfoTip->cchTextMax)
									info += szEllipses;
								break;
							}
							if (i > 0)
								info += _T("\n:");
							info += *pstrFileName;
						}
                    }
				}
				else
				{
					info.Format(_T("URL:%s\nAvailable parts:%u"), client->GetUserName(), client->GetAvailablePartCount());
				}
			}

			_tcsncpy(pGetInfoTip->pszText, info, pGetInfoTip->cchTextMax);
			pGetInfoTip->pszText[pGetInfoTip->cchTextMax-1] = _T('\0');
		}
	}
	*pResult = 0;
}*/

void CDownloadListCtrl::ShowFileDialog(UINT uInvokePage, BOOL Preferences) // NEO: FCFG - [FileConfiguration] <-- Xanatos --
{
	//CSimpleArray<CPartFile*> aFiles;
	CTypedPtrList<CPtrList, CPartFile*> partFileList; // NEO: MLD - [ModelesDialogs] <-- Xanatos --
	POSITION pos = GetFirstSelectedItemPosition();
	while (pos != NULL)
	{
		int iItem = GetNextSelectedItem(pos);
		if (iItem != -1)
		{
			const CtrlItem_Struct* pCtrlItem = (CtrlItem_Struct*)GetItemData(iItem);
			if (pCtrlItem->type == FILE_TYPE)
				partFileList.AddTail((CPartFile*)pCtrlItem->value); // NEO: MLD - [ModelesDialogs] <-- Xanatos --
				//aFiles.Add((CPartFile*)pCtrlItem->value);
		}
	}

	//if (aFiles.GetSize() > 0)
	if (partFileList.GetCount() > 0) // NEO: MLD - [ModelesDialogs] <-- Xanatos --
	{
		// NEO: MLD - [ModelesDialogs] -- Xanatos -->
		// NEO: FCFG - [FileConfiguration]
		if(Preferences){
			partFileList.GetHead()->GetPreferencesDialogInterface()->OpenPreferencesDialog(partFileList, uInvokePage, this);
		}else{
		// NEO: FCFG END
			partFileList.GetHead()->GetDetailDialogInterface()->OpenDetailDialog(partFileList, uInvokePage, this);
		}
		// NEO: MLD END <-- Xanatos --
	}
}

CDownloadListListCtrlItemWalk::CDownloadListListCtrlItemWalk(CDownloadListCtrl* pListCtrl)
	: CListCtrlItemWalk(pListCtrl)
{
	m_pDownloadListCtrl = pListCtrl;
	m_eItemType = (ItemType)-1;
}

CObject* CDownloadListListCtrlItemWalk::GetPrevSelectableItem(CObject* pCurrentObj)	// NEO: MLD - [ModelesDialogs] <-- Xanatos --
{
	ASSERT( m_pDownloadListCtrl != NULL );
	if (m_pDownloadListCtrl == NULL)
		return NULL;

	// NEO: MLD - [ModelesDialogs] -- Xanatos -->
	std::pair<CDownloadListCtrl::ListItems::iterator, CDownloadListCtrl::ListItems::iterator> rangeIt = m_pDownloadListCtrl->m_ListItems.equal_range(pCurrentObj);
	const CtrlItem_Struct* current_ctrl_item = NULL;
	for(CDownloadListCtrl::ListItems::iterator it = rangeIt.first; it != rangeIt.second; it++) {
		current_ctrl_item = rangeIt.first->second;
		if (rangeIt.first->second->type != UNAVAILABLE_SOURCE)	// we skip A4AF, so find the non-A4AF one if one exists
			break;
	}
	if (!current_ctrl_item)
		return NULL;

	if (pCurrentObj->IsKindOf(RUNTIME_CLASS(CPartFile))) //current_ctrl_item->type == FILE_TYPE
		SetItemType(FILE_TYPE);
	else
		SetItemType(AVAILABLE_SOURCE);	// must be this, unavailable sources are skipped due to duplicates
	// NEO: MLD <-- Xanatos --

	ASSERT( m_eItemType != (ItemType)-1 );

	int iItemCount = m_pDownloadListCtrl->GetItemCount();
	if (iItemCount >= 2)
	{
		// NEO: MLD - [ModelesDialogs] -- Xanatos -->
		LVFINDINFO find;
		find.flags = LVFI_PARAM;
		find.lParam = (LPARAM)current_ctrl_item;
		int iItem = m_pDownloadListCtrl->FindItem(&find);
		POSITION pos;
		if (iItem != (-1) || (pos = m_pDownloadListCtrl->GetFirstSelectedItemPosition()) != NULL) // Fix
		{
			if(iItem == -1)
				iItem = m_pDownloadListCtrl->GetNextSelectedItem(pos);
		// NEO: MLD <-- Xanatos --
		/*POSITION pos = m_pDownloadListCtrl->GetFirstSelectedItemPosition();
		if (pos)
		{
			int iItem = m_pDownloadListCtrl->GetNextSelectedItem(pos);*/

			int iCurSelItem = iItem;
			while (iItem-1 >= 0)
			{
				iItem--;

				const CtrlItem_Struct* ctrl_item = (CtrlItem_Struct*)m_pDownloadListCtrl->GetItemData(iItem);
				//if (ctrl_item->type == m_eItemType || (m_eItemType != FILE_TYPE && ctrl_item->type != FILE_TYPE))
				if (ctrl_item->type == m_eItemType)	// skip A4AF because they won't be recognized on next call // NEO: MLD - [ModelesDialogs] <-- Xanatos --
				{
					m_pDownloadListCtrl->SetItemState(iCurSelItem, 0, LVIS_SELECTED | LVIS_FOCUSED);
					m_pDownloadListCtrl->SetItemState(iItem, LVIS_SELECTED | LVIS_FOCUSED, LVIS_SELECTED | LVIS_FOCUSED);
					m_pDownloadListCtrl->SetSelectionMark(iItem);
					m_pDownloadListCtrl->EnsureVisible(iItem, FALSE);
					return STATIC_DOWNCAST(CObject, (CObject*)ctrl_item->value);
				}
			}
		}
	}
	return NULL;
}

CObject* CDownloadListListCtrlItemWalk::GetNextSelectableItem(CObject* pCurrentObj)	// NEO: MLD - [ModelesDialogs] <-- Xanatos --
{
	ASSERT( m_pDownloadListCtrl != NULL );
	if (m_pDownloadListCtrl == NULL)
		return NULL;

	// NEO: MLD - [ModelesDialogs] -- Xanatos -->
	std::pair<CDownloadListCtrl::ListItems::iterator, CDownloadListCtrl::ListItems::iterator> rangeIt = m_pDownloadListCtrl->m_ListItems.equal_range(pCurrentObj);
	const CtrlItem_Struct* current_ctrl_item = NULL;
	for(CDownloadListCtrl::ListItems::iterator it = rangeIt.first; it != rangeIt.second; it++) {
		current_ctrl_item = rangeIt.first->second;
		if (rangeIt.first->second->type != UNAVAILABLE_SOURCE)	// we skip A4AF, so find the non-A4AF one if one exists
			break;
	}
	if (!current_ctrl_item)
		return NULL;

	if (pCurrentObj->IsKindOf(RUNTIME_CLASS(CPartFile))) //current_ctrl_item->type == FILE_TYPE
		CDownloadListListCtrlItemWalk::SetItemType(FILE_TYPE);
	else
		CDownloadListListCtrlItemWalk::SetItemType(AVAILABLE_SOURCE);	// must be this, unavailable sources are skipped due to duplicates
	// NEO: MLD <-- Xanatos --

	ASSERT( m_eItemType != (ItemType)-1 );

	int iItemCount = m_pDownloadListCtrl->GetItemCount();
	if (iItemCount >= 2)
	{
		// NEO: MLD - [ModelesDialogs] -- Xanatos -->
		LVFINDINFO find;
		find.flags = LVFI_PARAM;
		find.lParam = (LPARAM)current_ctrl_item;
		int iItem = m_pDownloadListCtrl->FindItem(&find);
		POSITION pos;
		if (iItem != (-1) || (pos = m_pDownloadListCtrl->GetFirstSelectedItemPosition()) != NULL) // Fix
		{
			if(iItem == -1)
				iItem = m_pDownloadListCtrl->GetNextSelectedItem(pos);
		// NEO: MLD <-- Xanatos --
		/*POSITION pos = m_pDownloadListCtrl->GetFirstSelectedItemPosition();
		if (pos)
		{
			int iItem = m_pDownloadListCtrl->GetNextSelectedItem(pos);*/
			int iCurSelItem = iItem;
			while (iItem+1 < iItemCount)
			{
				iItem++;

				const CtrlItem_Struct* ctrl_item = (CtrlItem_Struct*)m_pDownloadListCtrl->GetItemData(iItem);
				//if (ctrl_item->type == m_eItemType || (m_eItemType != FILE_TYPE && ctrl_item->type != FILE_TYPE))
				if (ctrl_item->type == m_eItemType)	// skip A4AF because they won't be recognized on next call // NEO: MLD - [ModelesDialogs] <-- Xanatos --
				{
					m_pDownloadListCtrl->SetItemState(iCurSelItem, 0, LVIS_SELECTED | LVIS_FOCUSED);
					m_pDownloadListCtrl->SetItemState(iItem, LVIS_SELECTED | LVIS_FOCUSED, LVIS_SELECTED | LVIS_FOCUSED);
					m_pDownloadListCtrl->SetSelectionMark(iItem);
					m_pDownloadListCtrl->EnsureVisible(iItem, FALSE);
					return STATIC_DOWNCAST(CObject, (CObject*)ctrl_item->value);
				}
			}
		}
	}
	return NULL;
}

void CDownloadListCtrl::ShowClientDialog(CUpDownClient* pClient, UINT uInvokePage) // NEO: MOD - [ClientsDetails] <-- Xanatos --
{
	pClient->GetDetailDialogInterface()->OpenDetailDialog(this, uInvokePage); // NEO: MLD - [ModelesDialogs] <-- Xanatos --
	//CDownloadListListCtrlItemWalk::SetItemType(AVAILABLE_SOURCE); // just set to something !=FILE_TYPE
	//CClientDetailDialog* dialog = new CClientDetailDialog(pClient, this);
	//dialog.DoModal();
}

// NEO: LF - [ListFind] -- Xanatos -->
CString	CDownloadListCtrl::GetItemTextEx(int nItem, int nSubItem){

	CtrlItem_Struct* pSingleSelItem = (CtrlItem_Struct*)GetItemData(nItem);

	CString buffer;
	if (pSingleSelItem->type == FILE_TYPE)
		DrawFileItem(NULL,nSubItem,NULL,pSingleSelItem,&buffer);
	else if (pSingleSelItem->type == UNAVAILABLE_SOURCE || pSingleSelItem->type == AVAILABLE_SOURCE)
		DrawSourceItem(NULL,nSubItem,NULL,pSingleSelItem,&buffer);

	return buffer;
}
// NEO: LF END <-- Xanatos --
