//this file is part of eMule
//Copyright (C)2002 Merkur ( devs@emule-project.net / http://www.emule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#pragma once

#include "ResizableLib/ResizablePage.h"
#include "ResizableLib/ResizableSheet.h"
#include "Neo/GUI/Modeless.h" // NEO: MLD - [ModelesDialogs] <-- Xanatos --
#include "Neo/GUI/RequestedFiles.h" // NEO: RFL - [RequestFileList] <-- Xanatos --
#include "Neo/GUI/SharedFilesPage.h" // NEO: XSF - [ExtendedSharedFiles] <-- Xanatos --
#ifdef NEO_CD // NEO: NCD - [NeoClientDatabase] -- Xanatos -->
#include "Neo/GUI/SourceInfo.h"
#endif // NEO_CD // NEO: NCD END <-- Xanatos --
#include "Neo/GUI/ExtraInfo.h" // NEO: NXI - [NeoExtraInfo] <-- Xanatos --
#ifdef ARGOS // NEO: NA - [NeoArgos] -- Xanatos -->
#include "Neo/GUI/ArgosInfo.h" 
#endif // ARGOS // NEO: NA END <-- Xanatos --

class CUpDownClient;

///////////////////////////////////////////////////////////////////////////////
// CClientDetailPage

class CClientDetailPage : public CResizablePage
{
	DECLARE_DYNAMIC(CClientDetailPage)

public:
	CClientDetailPage();   // standard constructor
	virtual ~CClientDetailPage();

	void SetClients(const CSimpleArray<CObject*>* paClients) { m_paClients = paClients; m_bDataChanged = true; }

	enum { IDD = IDD_SOURCEDETAILWND };

protected:
	const CSimpleArray<CObject*>* m_paClients;
	bool m_bDataChanged;

	void Localize();
	void RefreshData();

	virtual BOOL OnInitDialog();
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	virtual BOOL OnSetActive();

	DECLARE_MESSAGE_MAP()
	afx_msg LRESULT OnDataChanged(WPARAM, LPARAM);
};


///////////////////////////////////////////////////////////////////////////////
// CClientDetailDialog

class CClientDetailDialog : public  CListViewWalkerModelessPropertySheet // NEO: MLD - [ModelesDialogs] <-- Xanatos --
{
	DECLARE_DYNAMIC(CClientDetailDialog)

public:
	CClientDetailDialog(CUpDownClient* pClient, CListCtrlItemWalk* pListCtrl = NULL, UINT uInvokePage = 0); // NEO: MOD - [ClientsDetails] <-- Xanatos --
	CClientDetailDialog(const CSimpleArray<CUpDownClient*>* paClients, CListCtrlItemWalk* pListCtrl = NULL, UINT uInvokePage = 0); // NEO: MOD - [ClientsDetails] <-- Xanatos --
	virtual ~CClientDetailDialog();

	void	UpdateTree(CString newDir)	{ m_wndSharedFiles.UpdateTree(newDir); } // NEO: XSF - [ExtendedSharedFiles] <-- Xanatos --

protected:
	CClientDetailPage m_wndClient;
#ifdef NEO_CD // NEO: NCD - [NeoClientDatabase] -- Xanatos -->
	CSourceDetailPage m_wndSource;
#endif // NEO_CD // NEO: NCD END <-- Xanatos --
	CClientExtraInfoPage m_wndExtraInfo; // NEO: NXI - [NeoExtraInfo] <-- Xanatos --
	CReqFilesPage m_wndReqFiles; // NEO: RFL - [RequestFileList] <-- Xanatos --
	CSharedFilesPage m_wndSharedFiles; // NEO: XSF - [ExtendedSharedFiles] <-- Xanatos --
#ifdef ARGOS // NEO: NA - [NeoArgos] -- Xanatos -->
	CClientArgosInfoPage m_wndArgos; 
#endif // ARGOS // NEO: NA END <-- Xanatos --
	UINT m_uInvokePage;	// NEO: MOD - [ClientsDetails] <-- Xanatos --

	void Construct();

	virtual BOOL OnInitDialog();

	DECLARE_MESSAGE_MAP()
	afx_msg void OnDestroy();
};

// NEO: MLD - [ModelesDialogs] -- Xanatos -->
///////////////////////////////////////////////////////////////////////////////
// CClientDetailDialogInterface

class CClientDetailDialogInterface : public CListViewWalkerModelessPropertySheetInterface
{
public:
	CClientDetailDialogInterface(CUpDownClient* owner);
	void	OpenDetailDialog(CListCtrlItemWalk* pListCtrl = NULL, UINT uInvokePage = 0); // NEO: MOD - [ClientsDetails]
	void	OpenDetailDialog(const CSimpleArray<CUpDownClient*>* paClients, CListCtrlItemWalk* pListCtrl = NULL, UINT uInvokePage = 0); // NEO: MOD - [ClientsDetails]
	void	UpdateTree(CString newDir);	// NEO: XSF - [ExtendedSharedFiles] <-- Xanatos --

protected:
	virtual CListViewWalkerModelessPropertySheet* CreatePropertySheet(va_list);
};
// NEO: MLD <-- Xanatos --
