//this file is part of NeoMule
//Copyright (C)2006 David Xanatos ( Xanatos@Lycos.at / http://neomule.sourceforge.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


#pragma once

// NEO: NCFG - [NeoConfiguration] -- Xanatos -->

// NEO: FCFG - [FileConfiguration]
#define NEOFILE_VERSION					NEOFILE_VERSION_400
#define NEOFILE_VERSION_OLD				NEOFILE_VERSION_300
#define NEOFILE_VERSION_254				0xD0
#define NEOFILE_VERSION_255				0xD1
#define NEOFILE_VERSION_300				0xD2
#define NEOFILE_VERSION_400				0xD3

#define KNOWNPREFSFILE_VERSION			KNOWNPREFSFILE_VERSION_400
#define KNOWNPREFSFILE_VERSION_OLD		KNOWNPREFSFILE_VERSION_300
#define KNOWNPREFSFILE_VERSION_254		0xB0
#define KNOWNPREFSFILE_VERSION_300		0xB1
#define KNOWNPREFSFILE_VERSION_400		0xB2
// NEO: FCFG END

// NEO: NPT - [NeoPartTraffic]
#define TRAFFICFILE_VERSION				TRAFFICFILE_VERSION_400
#define TRAFFICFILE_VERSION_OLD			TRAFFICFILE_VERSION_254
#define TRAFFICFILE_VERSION_254			0xA0 // not more supported
#define TRAFFICFILE_VERSION_300			0xA1
#define TRAFFICFILE_VERSION_400			0xA2
// NEO: NPT END

// NEO: XC - [ExtendedComments]
#define COMMENTSFILE_VERSION			COMMENTSFILE_VERSION_300
#define COMMENTSFILE_VERSION_OLD		COMMENTSFILE_VERSION_255
#define COMMENTSFILE_VERSION_255		0xC0
#define COMMENTSFILE_VERSION_300		0xC1
// NEO: XC END

#define NFT_CHUNK_MODE					0x14 //<int>
// NEO: RC4 - [RareChunksV4]
#define NFT_RC_ORDER					0x15 //<int>
#define NFT_RC_BLOCK					0x13 //<int>
// NEO: RC4 END

// NEO: NST - [NeoSourceTweaks]
#define	NFT_HARD_LIMIT					0x01 //<int>
#define	NFT_SWAP_LIMIT					0x37 //<int>
#define	NFT_CLEANUP_LIMIT				0x38 //<int>
#define	NFT_CALC_LIMITS					0x36 //<int>

#define NFT_XS_STATE					0x02 //<int>
#define NFT_XS_LIMIT					0x03 //<int>
#define NFT_XS_INTERVALS				0x04 //<int>
#define NFT_XS_ANSWER_LIMIT				0x0D //<int>
#define NFT_ENABLE_SEND_XS				0x0E //<int>
#define NFT_XS_DELAY					0x0A //<int>
#define NFT_XS_DELAY_VALUE				0x0B //<int>

#define NFT_SVR_STATE					0x05 //<int>
#define NFT_SVR_LIMIT					0x06 //<int>
#define NFT_SVR_INTERVALS				0x07 //<int>

#define NFT_KAD_STATE					0x08 //<int>
#define NFT_KAD_LIMIT					0x09 //<int>
#define NFT_KAD_INTERVALS				0x10 //<int>
#define NFT_KAD_DELAY					0x82 //<int>
#define NFT_KAD_DELAY_VALUE				0x83 //<int>

#define NFT_UDP_STATE					0x11 //<int>
#define NFT_UDP_LIMIT					0x12 //<int>
#define NFT_UDP_INTERVALS				0x49 //<int>
// NEO: NST END

#ifdef LANCAST // NEO: NLC - [NeoLanCast]
#define NFT_LAN_STATE					0x45
#define NFT_LAN_INTERVALS				0x46

#define NFT_LAN_REASK_TIMER				0x47
#define NFT_NNP_LAN_REASK_TIMER			0x48
#endif //LANCAST // NEO: NLC END

// NEO: NSD - [NeoSourceDrop]
#define NFT_LOW2LOW_CLEANUP_TIME		0xA3
#if defined(NEO_SK) || defined(NEO_SS) // NEO: NSK - [NeoSourceKeeper] // NEO: NSS - [NeoSourceStorage]
#define NFT_BAD_CLEANUP_TIME			0xA4
#define NFT_GONE_CLEANUP_TIME			0xA5
#define NFT_SUSPEND_CLEANUP_TIME		0xA6
#endif // NEO_SK // NEO_SS // NEO: NSK END // NEO: NSS END
#define NFT_NNP_CLEANUP_TIME			0xA7
#define NFT_FULLQ_CLEANUP_TIME			0xA8
// NEO: NSD END

// NEO: ASL - [AutoSoftLock]
#define NFT_ASL_ENABLE					0x16 //<int>
#define NFT_ASL_VALUE					0x17 //<int>
// NEO: ASL END

// NEO: AHL - [AutoHardLimit]
#define NFT_AHL_MODE					0x18 //<int>
#define	NFT_AHL_MIN_SRC					0x40 //<int>
#define NFT_AHL_TIMER					0x19 //<int>
// NEO: AHL END

// NEO: DR - [DownloadReask]
#define NFT_REASK_TIMER					0x20 //<int>

#define NFT_NNP_REASK_ENABLE			0x21 //<int>
#define NFT_NNP_REASK_TIMER				0x22 //<int>

#define NFT_FULLQ_REASK_ENABLE			0x23 //<int>
#define NFT_FULLQ_REASK_TIMER			0x24 //<int>
// NEO: DR END

// NEO: XSC - [ExtremeSourceCache]
#define NFT_USE_SOURCE_CACHE			0xDC
#define NFT_SOURCE_CACHE_LIMIT			0xDD
#define NFT_SOURCE_CACHE_TIME			0xDE //<--- last
// NEO: XSC END

#ifdef NEO_SK // NEO: NSK - [NeoSourceKeeper]
#define NFT_SOURCE_KEEPER				0x50
#endif // NEO_SK // NEO: NSK END
#ifdef NEO_SS // NEO: NSS - [NeoSourceStorage]
	
#define NFT_SOURCE_STORAGE				0x51
#define	NFT_AUTO_SAVE_SOURCES			0x81
#define NFT_AUTO_SAVE_SOURCES_INTERVALS	0xEA
#define NFT_SOURCE_STORAGE_LIMIT		0x52
#define NFT_AUTO_LOAD_SOURCES			0x53

#define NFT_USE_STORAGE_BOOTSTRAP		0xD9
#define NFT_STORAGE_BOOTSTRAP_TIME		0xDA
#define NFT_STORAGE_BOOTSTRAP_REQUIREMENT	0xDB

#define NFT_STORE_LOW_ID				0x54
#define NFT_STORE_A4AF					0x55
#define NFT_STORE_FILE_STATUS			0x56
			
#define NFT_AUTO_REASK_STORED_SOURCES		0x57
#define NFT_AUTO_REASK_STORED_SOURCES_LIMIT	0x58
#define NFT_TOTAL_SOURCE_RESTORE		0xA9
#define NFT_USE_AUTO_REASK_STORED_SOURCES_DELAY	0x79
#define NFT_AUTO_REASK_STORED_SOURCES_DELAY	0x59
			
#define NFT_AUTO_REASK_LOADED_SOURCES_DELAY	0x60
			
#define NFT_GROUP_STORAGE				0x61
#define NFT_GROUP_INTERVALS				0x62
#define NFT_GROUP_SIZE					0x63
			
#define NFT_USE_SMOOTH_OUTOFDATE		0x64
#define NFT_OUTOFDATE_MAXFAILS			0x65
#define NFT_OUTOFDATE_MAXTIME			0x66

#endif // NEO_SS // NEO: NSS END
#ifdef NEO_SA // NEO: NSA - [NeoSourceAnaliser]
#define NFT_SOURCE_ANALISER				0x67

#define NFT_DONT_STORE_TEMP_SOURCES		0x70
			
#define NFT_RETRY_UNREAHABLE			0x71
#define NFT_RETRY_UNREAHABLE_INTERVALS	0x72
#define NFT_FAIL_TOLERANCE				0xB3
#define NFT_MAX_FAIL_TOLERANCE			0xB4

#define NFT_REASK_PROPABILITY			0x76			
#define NFT_RESERVE_PROPABILITY			0x74

#define NFT_AUTO_RESERVE_REASK			0x80	
#define NFT_RESERVE_REASK_PROPABILITY	0x75
#define	NFT_USE_RESERVE_REASK_DELAY		0xB8
#define NFT_RESERVE_REASK_DELAY			0x77
#define NFT_RESERVE_REASK_LIMIT			0x78

#define NFT_AUTO_TEMPORARY_REASK		0xB9
#define NFT_TEMPORARY_REASK_PROPABILITY	0xBA
#define NFT_USE_TEMPORARY_REASK_DELAY	0xBB
#define NFT_TEMPORARY_REASK_DELAY		0xBC
#define NFT_TEMPORARY_REASK_LIMIT		0xBD

//#define NFT_MIN_ANALISIS_QUALITY		0x68

//#define NFT_AUTO_UNSURE_REASK			0xBE
//#define NFT_USE_UNSURE_REASK_DELAY		0xBF
//#define NFT_UNSURE_REASK_DELAY			0xD1
//#define NFT_UNSURE_REASK_LIMIT			0xD2

#define NFT_USE_UNPREDICTED_PROPABILITY	0xD3
#define NFT_UNPREDICTED_PROPABILITY		0xD4
#define NFT_AUTO_UNPREDICTED_REASK		0xD5
#define NFT_USE_UNPREDICTED_REASK_DELAY	0xD6
#define NFT_UNPREDICTED_REASK_DELAY		0xD7
#define NFT_UNPREDICTED_REASK_LIMIT		0xD8

#define	NFT_PROBABILITY_MODE			0x73
#define	NFT_ENHANCED_FACTOR				0xB5
#define NFT_UNREACHABLE_REASK_PROPABILITY 0xB6
#define NFT_UNREACHABLE_REASK_LIMIT		0xB7
#endif // NEO_SA // NEO: NSA END

// NEO: DS - [DropSources]
#define NFT_DROP_NNP_ENABLE				0x25 //<int>
#define NFT_DROP_NNP_LIMIT				0x26 //<int>
#define NFT_DROP_NNP_LIMIT_MODE			0xE3 //<int>
#define NFT_DROP_NNP_TIMER				0x27 //<int>

#define NFT_DROP_FULLQ_ENABLE			0x28 //<int>
#define NFT_DROP_FULLQ_LIMIT			0x29 //<int>
#define NFT_DROP_FULLQ_LIMIT_MODE		0xE4 //<int>
#define NFT_DROP_FULLQ_TIMER			0x30 //<int>

#define NFT_DROP_HIGHQ_ENABLE			0x31 //<int>
#define NFT_DROP_HIGHQ_VALUE			0x32 //<int>
#define NFT_DROP_HIGHQ_LIMIT			0x33 //<int>
#define NFT_DROP_HIGHQ_LIMIT_MODE		0xE5 //<int>
#define NFT_DROP_HIGHQ_TIMER			0x34 //<int>

#define NFT_USE_DONT_ASK_THIS_IP		0xB1
#define NFT_DONT_ASK_THIS_IP_TIME		0xB2
// NEO: DS END

// NEO: NSD - [NeoSourceDrop]
#ifdef NEO_SK // NEO: NSK - [NeoSourceKeeper]
#define NFT_DROP_UNREACHABLE_ENABLE		0x90
#define NFT_DROP_UNREACHABLE_LIMIT		0x91
#define NFT_DROP_UNREACHABLE_LIMIT_MODE	0xE6
#define NFT_DROP_UNREACHABLE_TIMER		0x92
#endif // NEO_SK // NEO: NSK END
#ifdef NEO_SS // NEO: NSS - [NeoSourceStorage]
#define NFT_DROP_OUTOFDATE_ENABLE		0x93
#define NFT_DROP_OUTOFDATE_SMOOTH		0x94
#define NFT_DROP_OUTOFDATE_FAILS		0x95
#define NFT_DROP_OUTOFDATE_TIME			0x96
#define NFT_DROP_OUTOFDATE_LIMIT		0x97
#define NFT_DROP_OUTOFDATE_LIMIT_MODE	0xE7
#define NFT_DROP_OUTOFDATE_TIMER		0x98
#endif // NEO_SS // NEO: NSS END
#ifdef NEO_SA // NEO: NSA - [NeoSourceAnaliser]
#define NFT_DROP_RETIRED_ENABLE			0x99
#define NFT_DROP_RETIRED_LIMIT			0x9A
#define NFT_DROP_RETIRED_LIMIT_MODE		0xE8
#define NFT_DROP_RETIRED_TIMER			0x9B

#define NFT_DROP_LOADED_ENABLE			0x9C
#define NFT_DROP_LOADED_LIMIT			0x9D
#define NFT_DROP_LOADED_LIMIT_MODE		0xE9
#define NFT_DROP_LOADED_TIMER			0x9E
#endif // NEO_SA // NEO: NSA END
// NEO: NSD END

// NEO: NCAP - [NeoCustomAutoPriority]
#define	NFT_DYNAMIC_AUTO_DOWN_PRIORITY	0xAA
#define	NFT_DYNAMIC_DOWN_PRIORITY_FACTOR 0xAB
#define NFT_LOW_DOWN_PRIO_THRESHOLD		0xA1
#define NFT_HIGH_DOWN_PRIO_THRESHOLD	0xA2
// NEO: NCAP END

#define NFT_SUB_CHUNK_TRANSFER			0x3B //<int> // NEO: SCT - [SubChunkTransfer]

#define NFT_PART_CATCH					0x35 //<int> // NEO: NPC - [NeoPartCatch]

#define NFT_PR_PART_NORMAL 				0xC0 //<int> Part Number
// NEO: MPS - [ManualPartSharing]
#define NFT_PR_PART_ON 					0xC1 //<int> Part Number
#define NFT_PR_PART_HIDEN				0xC2 //<int> Part Number
#define NFT_PR_PART_OFF					0xC3 //<int> Part Number
// NEO: MPS END
#define NFT_PR_PART_WANTED				0xC9 //<int> Part Number // NEO: MCS - [ManualChunkSelection]

// NEO: IPS - [InteligentPartSharing]
#define NFT_IPS_MAXIMUM					0x01 //<int>

#define NFT_IPS_HIDE_OA					0x02 //<int>
#define NFT_IPS_OA_MODE					0x03 //<int>
#define NFT_IPS_OA_VALUE				0x04 //<int>
#define NFT_IPS_OA_CATCH				0x57 //<int>

#define NFT_IPS_HIDE_OS					0x05 //<int>
#define NFT_IPS_OS_MODE					0x06 //<int>
#define NFT_IPS_OS_VALUE				0x07 //<int>
#define NFT_IPS_OS_CALC					0x58 //<int>

#define NFT_IPS_SHOW_UA					0x08 //<int>
#define NFT_IPS_UA_MODE					0x09 //<int>
#define NFT_IPS_UA_VALUE				0x10 //<int>

#define NFT_IPS_BLOCK_OA				0x11 //<int>
#define NFT_IPS_OA_FACTOR				0x12 //<int>

#define NFT_IPS_BLOCK_OS				0x13 //<int>
#define NFT_IPS_OS_FACTOR				0x14 //<int>

#define NFT_IPS_SHOW_ALWAYS_NEEDED		0x44 //<int>
#define NFT_IPS_SHOW_ALWAYS_PARTS		0x45 //<int>

#define	NFT_IPS_SHOW_ALWAYS_INCOMPLETE	0x46 //<int>
// NEO: IPS END

// NEO: RT - [ReleaseTweaks]
#define NFT_RELEASE_LEVEL				0x21 //<int>
#define	NFT_RELEASE_MODE				0x0C //<int>

#define NFT_RELEASE_LIMIT_MODE			0x52 //<int>
#define NFT_RELEASE_LIMIT_UNION			0x53 //<int>
#define NFT_RELEASE_LIMIT_COMPLETE_MODE	0x60 //<int>

#define NFT_RELEASE_LIMIT				0x54 //<int>
#define NFT_RELEASE_LIMIT_HIGH			0x55 //<int>
#define NFT_RELEASE_LIMIT_LOW			0x56 //<int>

#define NFT_RELEASE_LIMIT_COMPLETE		0x62 //<int>
#define NFT_RELEASE_LIMIT_COMPLETE_HIGH	0x63 //<int>
#define NFT_RELEASE_LIMIT_COMPLETE_LOW  0x59 //<int>

#define NFT_LIMIT_UNION					0x61 //<int>

#define NFT_SOURCE_LIMIT_MODE			0x22 //<int>
#define NFT_SOURCE_LIMIT_UNION			0x23 //<int>
#define NFT_SOURCE_LIMIT_COMPLETE_MODE	0x51

#define NFT_SOURCE_LIMIT				0x24 //<int>
#define NFT_SOURCE_LIMIT_HIGH			0x25 //<int>
#define NFT_SOURCE_LIMIT_LOW			0x42 //<int>

#define NFT_SOURCE_COMPLETE_LIMIT		0x26 //<int>
#define NFT_SOURCE_COMPLETE_LIMIT_HIGH	0x27 //<int>
#define NFT_SOURCE_COMPLETE_LIMIT_LOW  0x43 //<int>

#define NFT_RELEASE_DISABLE_NEED_COMPLETE 0x28 //<int>
// NEO: RT END

// NEO: RP - [RestrictivPublishing]
#ifdef VOODOO // NEO: VOODOO - [UniversalPartfileInterface]
#define NFT_DISABLE_VOODOO				0x3a
#endif // VOODOO
#define NFT_DISABLE_PUBLISHING			0x37
#ifdef LANCAST // NEO: NLC - [NeoLanCast]
#define NFT_DISABLE_SEND_LAN			0x31
#endif //LANCAST // NEO: NLC END
// NEO: RP END


#ifdef A4AF_CATS // NEO: MAC - [MorphA4AFCategories]
#define NFT_A4AF_FLAGS 0x41
#endif // A4AF_CATS // NEO: MAC END

// NEO: NCAP - [NeoCustomAutoPriority]
#define NFT_DYNAMIC_AUTO_UP_PRIORITY	0x35
#define NFT_DYNAMIC_UP_PRIORITY_FACTOR	0x36
#define NFT_LOW_UP_PRIO_THRESHOLD		0x29
#define NFT_HIGH_UP_PRIO_THRESHOLD		0x30
// NEO: NCAP END

// NEO: NCFG END <-- Xanatos --

#ifdef NEO_SS // NEO: NSS - [NeoSourceStorage] -- Xanatos -->
#define SRCFILE_VERSION					SRCFILE_VERSION_400
//#define SRCFILE_VERSION_OLD				SRCFILE_VERSION_

#define SRCFILE_VERSION_400				0xE0

#define MULTI_SRCFILE_VERSION			MULTI_SRCFILE_VERSION_400
//#define SRCFILE_VERSION_OLD				SRCFILE_VERSION_

#define MULTI_SRCFILE_VERSION_400		0xF0
#endif // NEO_SS // NEO: NSS END <-- Xanatos --

#if defined(NEO_SS) || defined(NEO_SC) // NEO: NCD - [NeoClientDatabase] // NEO: NSS - [NeoSourceStorage] -- Xanatos -->
// Primary Group:
#define SFT_IP							0x01
#define SFT_IP2							0x16
#define SFT_SERVER_IP					0x02
#define SFT_HYBRID_ID					0x03
#define SFT_PORT						0x04
#define SFT_SERVER_PORT					0x05
#define SFT_USER_NAME					0x06
#define SFT_USER_HASH					0x07
#define SFT_UDP_PORT					0x08
#define SFT_KAD_PORT					0x09
#define SFT_BUDDY_ID					0xB0
#define SFT_BUDDY_IP					0xB1
#define SFT_BUDDY_PORT					0xB2
#define SFT_FAILD_CONTRYS				0x10 // NEO: TCR - [TCPConnectionRetry]
#define SFT_LAST_SEEN					0x15
#define SFT_CLIENT_SOFTWARE				0x11
#define SFT_SOFTWARE_VERSION			0x12
#define SFT_CLIENT_VERSION				0x13
#define SFT_CLIENT_MODIFICATION			0x14
#endif // NEO_SS // NEO_CD // NEO: NCD END // NEO: NSS END <-- Xanatos --

#ifdef NEO_SS // NEO: NSS - [NeoSourceStorage] -- Xanatos -->
// Secundary Group:
#define SFT_SOURCE_EXCHANGE				0x21
#define SFT_FILE_COMMENTS				0x22
#define SFT_FILE_STATUS					0x23 // NEO: XCFS - [ExtendedClientFileStatus]
#ifdef NATTUNNELING // NEO: NATT - [NatTraversal]
#define SFT_NATTRAVERSAL				0x39
#endif // NATTUNNELING // NEO: NATT END
// NEO: ICS
#define SFT_EXTRA_INFO					0x25 // NEO: NXI - [NeoExtraInfo]
#define SFT_EDT_SUPPORT					0x26 // NEO: EDT - [EstimatedDownloadTime]
#define SFT_L2HAC_SUPPORT				0x27 // NEO: L2H - [LowID2HighIDAutoCallback]
#define SFT_NEOFEATURES					0x40 // NEO: NMP - [NeoModProt]
#define SFT_NOSHARE_VIEW				0x28

// PartFile informations
#define SFT_SOURCE_REQFILE				0x50
#define SFT_SOURCE_OWNER				0x51

#define SFT_PART_STATUS					0x52
#define SFT_INC_PART_STATUS				0x53 // NEO: ICS - [InteligentChunkSelection]
#define SFT_HIDEN_PART_STATUS			0x54 // NEO: RPS - [RealPartStatus]
#define SFT_BLOCKED_PART_STATUS			0x55 // NEO: RPS - [RealPartStatus]
#define SFT_SEEN_PART_STATUS			0x56 // NEO: AHOS - [AntiHideOS]

#define SFT_FILE_NAME					0x60 // NEO: SCFS - [SmartClientFileStatus] <-- Xanatos --
#endif // NEO_SS // NEO: NSS END <-- Xanatos --


#ifdef NEO_CD // NEO: NCD - [NeoClientDatabase] -- Xanatos -->
#define SOURCEFILE_VERSION				SOURCEFILE_VERSION_400
//#define SOURCEFILE_VERSION_OLD			SOURCEFILE_VERSION_

#define SOURCEFILE_VERSION_400			0xF0

#define SFT_IP_ZONE						0x30
#define SFT_IP_ZONE_LEVEL				0x31

#ifdef NEO_SA // NEO: NSA - [NeoSourceAnaliser]
#define SFT_STATIC_IP					0x32
#define SFT_MAX_ON_TIME					0x33
#define SFT_MID_ON_TIME					0x34
#define SFT_MIN_ON_TIME					0x35
#define SFT_MAX_OFF_TIME				0x36
#define SFT_MID_OFF_TIME				0x37
#define SFT_MIN_OFF_TIME				0x38
#define SFT_MAX_IP_TIME					0x45
#define SFT_MID_IP_TIME					0x46
#define SFT_MIN_IP_TIME					0x47
#define SFT_MAX_FAILD_COUNT				0x39
#define SFT_MID_FAILD_COUNT				0x40
#define SFT_MIN_FAILD_COUNT				0x41
#define SFT_LAST_ANALYSIS				0x42
#define SFT_ANALYSIS_QUALITY			0x43
#define SFT_ANALYSIS_NEEDED				0x44
#define SFT_LAST_SEEN_DURATION			0x48
#define SFT_TOTAL_SEEN_DURATION			0x49
#define SFT_LAST_LINK_TIME	 			0x50
#define SFT_PORT_INTEGRITY_TIME			0x51
#endif // NEO_SA // NEO: NSA END

#define IFT_IP							0x01
#define IFT_PORT						0x02
#define IFT_FIRSTSEEN					0x03
#define IFT_LASTSEEN					0x04
#define IFT_UNREACHABLE					0x05

// NEO: SFL - [SourceFileList]
#define FFT_HASH						0x01
#define FFT_SIZE						0x02
#define FFT_LASTSEEN					0x03
// NEO: SFL END
#endif // NEO_CD // NEO: NCD END <-- Xanatos --

#ifdef LANCAST // NEO: NLC - [NeoLanCast] -- Xanatos -->
#define LANCAST_PORT			5000
#define LANCAST_GROUP			_T("224.0.0.1")

#define OP_LANCASTPROT			0xC6

#define OP_HASH					0x01	// Broadcast hash
#define OP_HASHSEARCH			0x02	// Search the subnet for a hash
#define OP_HASHSEARCHRESPONSE	0x03	// Hash found on this client
#define OP_FILESEARCH			0x04	// Search the subnet for a file
#define OP_FILESEARCHRESPONSE	0x05	// File found on this client
#ifdef VOODOO // NEO: VOODOO - [UniversalPartfileInterface]
#define OP_VOODOOREQUEST		0x06	// Search the subnet for voodoo clients
#endif // VOODOO // NEO: VOODOO END
#endif //LANCAST // NEO: NLC END <-- Xanatos --


// NEO: NXI - [NeoExtraInfo] -- Xanatos -->
#define EI_SUI_STATE					0x01

	// File Priorities
#define EI_UL_PRIO						0x11
#define EI_UL_RELEASE					0x12
#define EI_DL_PRIO						0x15

	// Credit system
#define EI_CREDIT_SCORE					0x21
#define EI_CREDIT_SYSTEM				0x22

	// Score Informations
#define EI_QUELE_SYSTEM					0x30
#define EI_WAITING_TIME					0x31
#define EI_QUEUE_RATING					0x32
#define EI_QUEUE_SCORE					0x33
#define EI_PRIVATE_SLOT					0x34
#define EI_WAITING_USERS				0x39

	// Bandwidth infos 
#define EI_MAX_UL_CAPACITY				0xA1
#define EI_MAX_DL_CAPACITY				0xA2

	// Other File infos
#define EI_LAST_SEEN_REQ_FILE			0x40

#define EI_REQ_FILE_SOURCES				0x41
#define EI_REQ_FILE_COMP_SOURCES		0x42

#define EI_UP_REQ_FILE_SOURCES			0x43
#define EI_UP_REQ_FILE_COMP_SOURCES		0x44

	// Other infos
#define EI_UP_TIMR						0x50
#define EI_ID_AGE						0x51

#define EI_STRING_INFO					0xF0

#define EIS_STRING_INFO_REQ			_T("SomeInfo?")
#define EIS_STRING_INFO_ANS			_T("SomeInfo:")

// Info Packetes to send
#define NIX_HELLO					0x00000001L	
#define NIX_SUI						0x00000002L
#define NIX_REQUP					0x00000004L
#define NIX_REQDOWN					0x00000008L
#define NIX_RANKING					0x00000010L	


// Remote Queue System Flags
#define REMOTE_QS_SAVE_WAIT_TIME	0x00000001L	
//#define REMOTE_QS_		0x00000002L	// Reserved
//#define REMOTE_QS_		0x00000004L	// Reserved
#define REMOTE_QS_ONE_PER_FILE		0x00000008L	
#define REMOTE_QS_EXPONENTIAL		0x00000010L	
#define REMOTE_QS_PROBABILISTIC		0x00000020L	
#define REMOTE_QS_INFINITE			0x00000040L	
#define REMOTE_QS_PAYBACK_FIRST		0x00000080L	
#define REMOTE_QS_OLD_PRIO_SYS		0x00000100L	

// Remote Credit system ID's
#define REMOTE_CS_NONE		0
#define REMOTE_CS_OFFICIAL	1
#define REMOTE_CS_NEO		2
#define REMOTE_CS_LOVELACE	3
#define REMOTE_CS_PEACE		4
#define REMOTE_CS_SIVKA		5
#define REMOTE_CS_RT		6
#define REMOTE_CS_SWAT		7
#define REMOTE_CS_PAWCIO	8
#define REMOTE_CS_EASTSHARE	9
#define REMOTE_CS_TK4		10
#define REMOTE_CS_XTREME	11
#define REMOTE_CS_ZZUL		12
// NEO: NXI END <-- Xanatos --

// NEO: EDT - [EstimatedDownloadTime] -- Xanatos -->
#define EDT_PERIOD_CACHE		50
#define EDT_MIN_PERIOD_CACHE	30
#define EDT_UNDEFINED			0xFFFFFFFF //((uint32)(-1))
#define EDT_INFINITE_TIME		0xFFFFFFFF
#define EDT_INFINITE_ERR		0xFFFFFFFE
#define EDT_IMMINENT			300
#define EDT_EDW_THRESHOLD		28800
// NEO: EDT END <-- Xanatos --
