//this file is part of NeoMule
//Copyright (C)2006 David Xanatos ( Xanatos@Lycos.at / http://neomule.sourceforge.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include "stdafx.h"
#ifdef _DEBUG
#include "DebugHelpers.h"
#endif

CString GetErrorMessage(CException* e)
{
	ASSERT(e != NULL);
	try{
	const size_t bs = 255;
	TCHAR b[bs];
	e->GetErrorMessage(b, bs);
	return CString(b);
	}catch(...){}
	return CString(_T("N/A"));
}

CString InterpreteErrorCode(unsigned int code)
{
	switch (code){
	case 0x00000000:						return _T("Error: User Abborted this function manualy");
	case EXCEPTION_ACCESS_VIOLATION:		return _T("Error: The thread attempted to read from or write to a virtual address for which it does not have the appropriate access.");
	case EXCEPTION_BREAKPOINT:				return _T("Error: A breakpoint was encountered.");
	case EXCEPTION_DATATYPE_MISALIGNMENT:	return _T("Error: The thread attempted to read or write data that is misaligned on hardware that does not provide alignment. For example, 16-bit values must be aligned on 2-byte boundaries, 32-bit values on 4-byte boundaries, and so on.");
	case EXCEPTION_SINGLE_STEP:				return _T("Error: A trace trap or other single-instruction mechanism signaled that one instruction has been executed.");
	case EXCEPTION_ARRAY_BOUNDS_EXCEEDED:	return _T("Error: The thread attempted to access an array element that is out of bounds, and the underlying hardware supports bounds checking.");
	case EXCEPTION_FLT_DENORMAL_OPERAND:	return _T("Error: One of the operands in a floating-point operation is denormal. A denormal value is one that is too small to represent as a standard floating-point value.");
	case EXCEPTION_FLT_DIVIDE_BY_ZERO:		return _T("Error: The thread attempted to divide a floating-point value by a floating-point divisor of zero.");
	case EXCEPTION_FLT_INEXACT_RESULT:		return _T("Error: The result of a floating-point operation cannot be represented exactly as a decimal fraction.");
	case EXCEPTION_FLT_INVALID_OPERATION:	return _T("Error: This exception represents any floating-point exception not included in this list.");
	case EXCEPTION_FLT_OVERFLOW:			return _T("Error: The exponent of a floating-point operation is greater than the magnitude allowed by the corresponding type.");
	case EXCEPTION_FLT_STACK_CHECK:			return _T("Error: The stack overflowed or underflowed as the result of a floating-point operation.");
	case EXCEPTION_FLT_UNDERFLOW:			return _T("Error: The exponent of a floating-point operation is less than the magnitude allowed by the corresponding type.");
	case EXCEPTION_INT_DIVIDE_BY_ZERO:		return _T("Error: The thread attempted to divide an integer value by an integer divisor of zero.");
	case EXCEPTION_INT_OVERFLOW:			return _T("Error: The result of an integer operation caused a carry out of the most significant bit of the result.");
	case EXCEPTION_PRIV_INSTRUCTION:		return _T("Error: The thread attempted to execute an instruction whose operation is not allowed in the current machine mode.");
	case EXCEPTION_NONCONTINUABLE_EXCEPTION: return _T("Error: The thread attempted to continue execution after a noncontinuable exception occurred.");
	}

	return _T("Error: Unknown");
}

CString InterpreteErrorInfo(struct _EXCEPTION_POINTERS *ep)
{
	CString strExError;
	if (ep){
		const EXCEPTION_RECORD* er = ep->ExceptionRecord;
		strExError.Format(_T("Exception: %08x at 0x%08x"), er->ExceptionCode, er->ExceptionAddress);
	}
	else
		strExError.Format(_T("Exception: Unknown"));

	return strExError;
}

#ifdef _DEBUG_NEO
#include "Neo/NeoDebugC.h"

BOOL CCriticalSection2::Lock(DWORD dwTimeout)
{
	ASSERT(dwTimeout == INFINITE); // CCriticalSection always ignors this parameter
	if(CMutex::Lock(60*1000) == FALSE)
		DebugBreak();
	return TRUE; // CCriticalSection always return true
}
#endif //_DEBUG_NEO

