//this file is part of eMule
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#pragma once

// NEO: FC - [FakeCheck] -- Xanatos -->
struct Fakes_Struct{
   uchar			Hash[16];
   uint64			Lenght;
   CString			RealTitle;
};

#define	DFLT_FAKECHECK_FILENAME	_T("fakes.dat")

typedef CTypedPtrArray<CPtrArray, Fakes_Struct*> CFakecheckArray;

class CFakecheck
{
public:
	CFakecheck();
	~CFakecheck();
	void	AddFake(uchar* Hash,uint32& Lenght,CString& Realtitle);
	void	RemoveAllFakes();
	int		LoadFromFile();
	LPCTSTR	IsFake(const uchar* Hash2test, const EMFileSize lenght);
	LPTSTR	GetFake(const uchar* Hash2test, const EMFileSize lenght);
	CString GetDefaultFilePath() const;
	void	DownloadFakeList(); // NEO: AU - [AutoUpdate]
private:
	CFakecheckArray m_fakelist;
};
// NEO: FC END <-- Xanatos --