//this file is part of NeoMule
//Copyright (C)2006 David Xanatos ( Xanatos@Lycos.at / http://neomule.sourceforge.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


#pragma once

#include "xSkinButton.h"
#include "SpeedGraph.h"
#include "MuleToolbarCtrl.h"

// NEO: CTB - [CoolToolBar] -- Xanatos -->

// classname definition
#define MTC_CLASSNAME		_T("NeoToolbarCtrl")

/////////////////////////////////////////////////////////////////////////////
// CNeoToolbarCtrl window
/////////////////////////////////////////////////////////////////////////////
class CNeoToolbarCtrl : public CWnd, CVirtualToolbarCtrl
{
public:

	/////////////////////////////////////////////////////////////////////////////
	// PUBLIC: constructor/destructor
	/////////////////////////////////////////////////////////////////////////////
	CNeoToolbarCtrl();
	virtual ~CNeoToolbarCtrl();

	/////////////////////////////////////////////////////////////////////////////
	// PUBLIC: methods
	/////////////////////////////////////////////////////////////////////////////
	bool					IsCoolToolbar() {return true;}
	BOOL					SetButtonInfo(int nID, TBBUTTONINFO* ptbbi);
	void					PressMuleButton(int nID);
	void					Localize(void);
	bool					IsSpeedMeterEnabled() const {return m_bUseSpeedMeter == TRUE;}
	void					ShowSpeedMeter(bool bShow){
								if(m_bUseSpeedMeter != 2 || !bShow)
									m_bUseSpeedMeter = bShow;
								m_co_UpTrafficGraph.ShowWindow(m_bUseSpeedMeter == TRUE ? SW_SHOW : SW_HIDE);
								m_co_DownTrafficGraph.ShowWindow(m_bUseSpeedMeter == TRUE ? SW_SHOW : SW_HIDE);
								if(m_bCreated)
									RedrawWindow();
							}
	void					SetSpeedMeterRange(int iValue1, int iValue2){
								m_co_UpTrafficGraph.Init_Graph(_T("Up"),iValue1); 
								m_co_DownTrafficGraph.Init_Graph(_T("Down"),iValue2);
							}
	void					SetSpeedMeterValues(int iValue1, int iValue2){
								m_co_UpTrafficGraph.Set_TrafficValue(iValue1); 
								m_co_DownTrafficGraph.Set_TrafficValue(iValue2);
							}
	void					UpdateMeterColor();
	CWnd*					GetWnd() {return this;}
	int						GetButtonCount() const {return m_co_Buttons.GetSize();}
	UINT					CommandToIndex(UINT nID) const;
	BOOL					GetButton(int nIndex, LPTBBUTTON lpButton) const;
	BOOL					MapAccelerator(TCHAR chAccel, UINT* pIDBtn);

	// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CNeoToolbarCtrl)
	virtual BOOL Create(DWORD dwStyle, const RECT& rect, CWnd* pParentWnd, UINT nID);
	virtual BOOL OnCommand(WPARAM wParam,LPARAM lParam );
	//}}AFX_VIRTUAL

	void					CreateButtons();

	// Generated message map functions
protected:
	friend class CemuleDlg;
	friend class CPPgInterface;

	/////////////////////////////////////////////////////////////////////////////
	// PROTECTED: methods
	/////////////////////////////////////////////////////////////////////////////
	void					UpdateSkin();
	void					UpdateSize(int width = 0);
	void					SetAccelerator(CString buff, UINT pIDBtn);

	/////////////////////////////////////////////////////////////////////////////
	// PROTECTED: attributes
	/////////////////////////////////////////////////////////////////////////////

	// background
	CBitmap m_co_ToolLeft;
	CBitmap m_co_ToolMid;
	CBitmap m_co_ToolRight;

	// button skins
	CArray<CxSkinButton> m_co_Buttons;
	
	// speed meters
	CSpeedGraph m_co_UpTrafficGraph;
	CSpeedGraph m_co_DownTrafficGraph;

	CStringArray m_astrSkinPaths;

	CMap <TCHAR,TCHAR,UINT,UINT> m_MapAccelerator;

	//{{AFX_MSG(CNeoToolbarCtrl)
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg void OnSize(UINT nType, int cx, int cy);	
	afx_msg void OnContextMenu(CWnd* pWnd, CPoint point);
	afx_msg void OnSysColorChange();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

private:
	/////////////////////////////////////////////////////////////////////////////
	// PRIVATE: attributes
	/////////////////////////////////////////////////////////////////////////////

	UINT		m_bUseSpeedMeter;

	BOOL		m_bCreated;

	int			m_uMinSize;


public:
	virtual BOOL			RegisterWndClass()
	{
		WNDCLASS			wnd;
		HINSTANCE			hInst = AfxGetInstanceHandle();

		if ( !(::GetClassInfo( hInst, m_strClassName, &wnd )) )
		{
			wnd.style				= CS_DBLCLKS | CS_HREDRAW | CS_VREDRAW;
			wnd.lpfnWndProc			= ::DefWindowProc;
			wnd.cbClsExtra			= wnd.cbWndExtra = 0;
			wnd.hInstance			= hInst;
			wnd.hIcon				= NULL;
			wnd.hCursor				= AfxGetApp()->LoadStandardCursor(IDC_ARROW);
			wnd.hbrBackground		= NULL;
			wnd.lpszMenuName		= NULL;
			wnd.lpszClassName		= m_strClassName;

			if ( !AfxRegisterClass(&wnd) )
			{
				AfxThrowResourceException();
				return FALSE;
			}
		}

		return TRUE;
	}

protected:
	// class registration/information
	CString					m_strClassName;
};

// NEO: CTB END <-- Xanatos --