#pragma once
#include "DblScope.h"
#include "ResizableLib\ResizableDialog.h"

//void InitWindowStyles(CWnd* pWnd);

class CMiniMule : public CResizableDialog
{
	friend class CemuleDlg;	
	DECLARE_DYNAMIC(CMiniMule)

public:
	CMiniMule(CWnd* pParent = NULL);   // standard constructor
	virtual ~CMiniMule();
// Dialog Data
	enum { IDD = IDD_MINIMULE };

	void SetSpeedMeterValues(int iValue1, int iValue2)	{m_ctrlSpeedMeter.AddValues(iValue1,iValue2);}
	void SetSpeedMeterRange();

    bool SetTransparent(BYTE bAlpha, BOOL reset);
	void MMUpdate(BOOL reset = FALSE);

	void SetManual()	{ manual = true; }
	bool IsManual()		{ return manual; }

	void Show();
	void Hide();

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	afx_msg void OnContextMenu(CWnd* pWnd, CPoint point);
	afx_msg void OnWindowPosChanging( WINDOWPOS* lpwndpos );
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnDestroy();
	virtual BOOL OnInitDialog();
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg void OnPaint();
	afx_msg void OnSysColorChange();
	//afx_msg void OnShowWindow(BOOL bShow, UINT nStatus);
	void OnClose();

	virtual CWnd* GetResizableWnd() { return this; };


	DECLARE_MESSAGE_MAP()

private:
	CDblScope m_ctrlSpeedMeter;
	//HICON m_hCSConn;
	//HICON m_hCSCing;
	//HICON m_hCSDconn;
	CBitmap m_Back;
	CString m_Label;
	//CRect m_rcText;
	COLORREF m_crTextColor;

	bool manual;

	void Init();
};
