//this file is part of NeoMule
//Copyright (C)2006 David Xanatos ( Xanatos@Lycos.at / http://neomule.sourceforge.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#pragma once
// NEO: FCFG - [FileConfiguration] -- Xanatos -->

#include <list>
#include "Neo/PrefFunctions.h"

class CTag;
class CKnownFile;
class CPartFile;
class CFileDataIO;

class CPPgSources;
class CPPgFileTweaks;
class CPPgRelease;

#define PR_PART_NORMAL 		0
// NEO: MPS - [ManualPartSharing]
#define PR_PART_ON 			1
#define PR_PART_HIDEN		2
#define PR_PART_OFF			3
// NEO: MPS END
#define PR_PART_WANTED		9 // NEO: MCS - [ManualChunkSelection]

#define CS_DEFAULT	0
#define CS_NORMAL	1
#define CS_ICS		2 // NEO: ICS - [InteligentChunkSelection]
#define CS_RC4		3 // NEO: RC4 - [RareChunksV4]

// NEO: RC4 - [RareChunksV4]
#define RC4_NOMAL	0
#define RC4_LEFT	1
#define RC4_RIGHT	2
// NEO: RC4 END

// NEO: NPC - [NeoPartCatch]
#define PART_CATCH_DISABLED		0
#define PART_CATCH_REAL			1
#define PART_CATCH_REAL_HIDEN	2
#define PART_CATCH_HIDEN		3
// NEO: NPC END

// NEO: RT - [ReleaseTweaks]
#define REL_MIXED		0
#define REL_BOOST		1
#define REL_POWER		2

#define REL_SIMPLY		0
#define REL_LINEAR		1
#define REL_EXPONENTIAL	2

#define LIM_DISABLE		0
#define LIM_SINGLE		1
#define LIM_BOOTH		2
// NEO: RT END


#ifdef NEO_SA // NEO: NSA - [NeoSourceAnaliser]
#define	PM_MIDLE		0
#define	PM_MAX			1
#define	PM_AUTO			2
#define	PM_ENHANCED		3
#define	PM_MIN			4
#endif // NEO_SA // NEO: NSA END

#define	PARTNEO_EXT		_T(".neo")
#define	PARTNEO_BAK_EXT	_T(".bak")
#define	PARTNEO_TMP_EXT	_T(".backup")

class CKnownPreferences
{
public:
	CKnownPreferences();
	~CKnownPreferences();

	void	SetParent(CKnownFile* File)	{KnownFile = File;}

	bool	SaveKnownPrefs(CFileDataIO* file);
	bool	LoadKnownPrefs(CFileDataIO* file);

	bool	HasPreferences();

	// NEO: IPS - [InteligentPartSharing]
	bool	IsInteligentPartSharing();

	int		GetMaxProzentToHide();

	bool	IsHideOverAvaliblyParts();
	int		GetHideOverAvaliblyMode();
	float	GetHideOverAvaliblyValue();
	int		GetHideOverAvaliblyCatch();

	bool	IsHideOverSharedParts();
	int		GetHideOverSharedMode();
	float	GetHideOverSharedValue();
	int		GetHideOverSharedCalc();
	
	bool	IsDontHideUnderAvaliblyParts();
	int		GetDontHideUnderAvaliblyMode();
	float	GetDontHideUnderAvaliblyValue();

	bool	IsBlockHighOverAvaliblyParts();
	float	GetBlockHighOverAvaliblyFactor();

	bool	IsBlockHighOverSharedParts();
	float	GetBlockHighOverSharedFactor();

	bool	IsShowAlwaysNeeded();
	int		GetShowAlwaysParts();

	bool	IsShowAlwaysIncomplete();
	// NEO: IPS END

	// NEO: RT - [ReleaseTweaks]
	int		GetReleaseLevel();
	int		GetReleaseMode();

	int		GetReleaseLimitMode();
	bool	IsReleaseLimitUnion();
	int		GetReleaseLimitCompleteMode();

	int		IsReleaseLimit();
	int		GetReleaseLimitHigh();
	int		GetReleaseLimitLow();

	bool	IsLimitUnion();

	int		IsReleaseLimitComplete();
	int		GetReleaseLimitCompleteHigh();
	int		GetReleaseLimitCompleteLow();

	int		GetSourceLimitMode();
	bool	IsSourceLimitUnion();
	int		GetSourceLimitCompleteMode();

	int		IsSourceLimit();
	int		GetSourceLimitHigh();
	int		GetSourceLimitLow();

	int		IsSourceLimitComplete();
	int		GetSourceLimitCompleteHigh();
	int		GetSourceLimitCompleteLow();

	bool	IsReleaseNeedComplete();
	int		GetReleaseNeedCompleteLimit();
	// NEO: RT END - [ReleaseTweaks]

	// NEO: NCAP - [NeoCustomAutoPriority]
	bool	UseDynamicAutoUpPriority();
	float	GetDynamicUpPriorityFactor();
	int		GetLowUpPrioThreshold();
	int		GetHighUpPrioThreshold();
	// NEO: NCAP END

	// NEO: NST - [NeoSourceTweaks]
	int		GetXSAnswerLimit(); 
	bool	SendXS(); 
	// NEO: NST END
	// NEO: RP - [RestrictivPublishing]
#ifdef LANCAST // NEO: NLC - [NeoLanCast]
	bool	SendLAN();
#endif //LANCAST // NEO: NLC END
#ifdef VOODOO // NEO: VOODOO - [UniversalPartfileInterface]
	bool	UseVoodoo(bool bTotal = false);
#endif // VOODOO
	// NEO: RP END

	int		UsePartCatch(); // NEO: NPC - [NeoPartCatch]

	// NEO: MPS - [ManualPartSharing]
	void	SetManagedPart(UINT part, uint8 status) { m_ManagedParts[part] = status; }
	uint8	GetManagedPart(UINT part) const;
	bool	HasManagedParts() const;
	// NEO: MPS END

	void CheckTweaks();
	void ResetTweaks();

protected:
	friend class CPPgRelease;

	// NEO: IPS - [InteligentPartSharing]
	int		m_iMaxProzentToHide;

	int		m_iHideOverAvaliblyParts;
	int		m_iHideOverAvaliblyMode;
	float	m_fHideOverAvaliblyValue;
	int		m_iHideOverAvaliblyCatch;

	int		m_iHideOverSharedParts;
	int		m_iHideOverSharedMode;
	float	m_fHideOverSharedValue;
	int		m_iHideOverSharedCalc;
	
	int		m_iDontHideUnderAvaliblyParts;
	int		m_iDontHideUnderAvaliblyMode;
	float	m_fDontHideUnderAvaliblyValue;

	int		m_iBlockHighOverAvaliblyParts;
	float	m_fBlockHighOverAvaliblyFactor;

	int		m_iBlockHighOverSharedParts;
	float	m_fBlockHighOverSharedFactor;

	int		m_iShowAlwaysNeeded;
	int		m_iShowAlwaysParts;

	int		m_iShowAlwaysIncomplete;
	// NEO: IPS END

	// NEO: RT - [ReleaseTweaks]
	int		m_iReleaseLevel;
	int		m_iReleaseMode;

	int		m_iReleaseLimitMode;
	int		m_iReleaseLimitUnion;
	int		m_iReleaseLimitCompleteMode;

	int		m_iReleaseLimit;
	int		m_iReleaseLimitHigh;
	int		m_iReleaseLimitLow;

	int		m_iReleaseLimitComplete;
	int		m_iReleaseLimitCompleteHigh;
	int		m_iReleaseLimitCompleteLow;
			
	int		m_iLimitUnion;
			
	int		m_iSourceLimitMode;
	int		m_iSourceLimitUnion;
	int		m_iSourceLimitCompleteMode;

	int		m_iSourceLimit;
	int		m_iSourceLimitHigh;
	int		m_iSourceLimitLow;

	int		m_iSourceLimitComplete;
	int		m_iSourceLimitCompleteHigh;
	int		m_iSourceLimitCompleteLow;

	int		m_iReleaseDisableNeedComplete;
	// NEO: RT END

	// NEO: RP - [RestrictivPublishing]
#ifdef VOODOO // NEO: VOODOO - [UniversalPartfileInterface]
	bool	m_bDisableVoodoo;
#endif // VOODOO
#ifdef LANCAST // NEO: NLC - [NeoLanCast]
	bool	m_bDisableSendLAN;
#endif //LANCAST // NEO: NLC END
	// NEO: RP END

	// NEO: NCAP - [NeoCustomAutoPriority]
	int 	m_iDynamicAutoUpPriority;
	float	m_fDynamicUpPriorityFactor;
	int		m_iLowUpPrioThreshold;
	int		m_iHighUpPrioThreshold;
	// NEO: NCAP END

	// NEO: NST - [NeoSourceTweaks]
	int		m_iXSAnswerLimit;
	bool	m_bEnableSendXS;
	// NEO: NST END

	CMap<UINT, UINT, uint8, uint8> m_ManagedParts; // NEO: MCS - [ManualChunkSelection]

	CArray<CTag*, CTag*> taglist;

private:
	void ClearTags();

	CKnownFile* KnownFile;
};

class CPartPreferences
{
public:
	CPartPreferences();
	~CPartPreferences();

	void	SetParent(CPartFile* File)	{PartFile = File;}

	bool	SavePartPrefs(CFileDataIO* file);
	bool	LoadPartPrefs(CFileDataIO* file);

	int		GetChunkSelectionMode();

	// NEO: RC4 - [RareChunksV4]
	int		GetRareChunkV4Order()		{ return m_iRareChunkV4Orde; }
	bool	GetRareChunkV4SameBlock() 	{ return m_bRareChunkV4SameBlock; }
	// NEO: RC4 END

	bool	UseSubChunkTransfer(); // NEO: SCT - [SubChunkTransfer]

	int		UsePartCatch(); // NEO: NPC - [NeoPartCatch]
	bool	UseAntiHideOS(); // NEO: AHOS - [AntiHideOS]
	bool	UseRealPartStatus(); // NEO: NPC - [NeoPartCatch]

#ifdef A4AF_CATS // NEO: MAC - [MorphA4AFCategories]
	bool	ForceAllA4AF();
	bool	ForceA4AFOff();
#endif // A4AF_CATS // NEO: MAC END

	// NEO: NST - [NeoSourceTweaks]
	int		GetHardLimit(bool bIgnoreAuto = false);
	int		GetSwapLimit();
	int		GetCleanUpLimit();
	bool	IsCalcStandardLimits();

	bool	UseXS();
	int		GetXSLimit(bool bIgnoreAuto = false);
	int		GetXSIntervals();
	uint32	GetXSIntervalsMs()			{return MIN2MS(GetXSIntervals());}
	int		GetXSDelayValue();

	bool	UseSVR();
	int		GetSVRLimit(bool bIgnoreAuto = false);
	int		GetSVRIntervals();
	uint32	GetSVRIntervalsMs()			{return MIN2MS(GetSVRIntervals());}

	bool	UseKAD();
	int		GetKADLimit(bool bIgnoreAuto = false);
	int		GetKADIntervals();
	uint32	GetKADIntervalsMs()			{return MIN2MS(GetKADIntervals());}
	int		GetKADDelayValue();

	bool	UseUDP();
	int		GetUDPLimit(bool bIgnoreAuto = false);
	int		GetUDPIntervals();
	uint32	GetUDPIntervalsMs()			{return MIN2MS(GetUDPIntervals());}
	// NEO: NST END

#ifdef LANCAST // NEO: NLC - [NeoLanCast]
	bool	UseLAN();
	int		GetLANIntervals();
	uint32	GetLANIntervalsMs()			{return MIN2MS(GetLANIntervals());}

	int		GetLanReaskIntervals();
	uint32	GetLanReaskIntervalsMs()	{return MIN2MS(GetLanReaskIntervals());}

	int		GetNnPLanReaskIntervals();
	uint32	GetNnPLanReaskIntervalsMs()	{return MIN2MS(GetNnPLanReaskIntervals());}
#endif //LANCAST // NEO: NLC END

	// NEO: NSD - [NeoSourceDrop]
	int		GetLow2LowCleanUpTime();
	uint32	GetLow2LowCleanUpTimeMs()	{return (GetLow2LowCleanUpTime()*100);}
#if defined(NEO_SK) || defined(NEO_SS) // NEO: NSK - [NeoSourceKeeper] // NEO: NSS - [NeoSourceStorage]
	int		GetBadCleanUpTime();
	uint32	GetBadCleanUpTimeMs()		{return (GetBadCleanUpTime()*100);}
	int		GetGoneCleanUpTime();
	uint32	GetGoneCleanUpTimeMs()		{return (GetGoneCleanUpTime()*100);}
	int		GetSuspendCleanUpTime();
	uint32	GetSuspendCleanUpTimeMs()	{return (GetSuspendCleanUpTime()*100);}
#endif // NEO_SK // NEO_SS // NEO: NSK END // NEO: NSS END
	int		GetNnPCleanUpTime();
	uint32	GetNnPCleanUpTimeMs()		{return (GetNnPCleanUpTime()*100);}
	int		GetFullQCleanUpTime();
	uint32	GetFullQCleanUpTimeMs()		{return (GetFullQCleanUpTime()*100);}
	// NEO: NSD END

	// NEO: ASL - [AutoSoftLock]
	bool	UseAutoSoftLock();
	int		GetAutoSoftLockValue();
	// NEO: ASL END

	// NEO: AHL - [AutoHardLimit]
	int		UseAutoHardLimit();
	int		GetGlobalHardLimit();
	int		GetMinimalHardLimit();
	int		GetAutoHardLimitTimer();
	uint32	GetAutoHardLimitTimerMs()		{return SEC2MS(GetAutoHardLimitTimer());}
	// NEO: AHL END

	// NEO: XSC - [ExtremeSourceCache]
	bool	UseSourceCache();
	int		GetSourceCacheLimit();
	int		GetSourceCacheTime();
	uint32	GetSourceCacheTimeMs() 			{return MIN2MS(GetSourceCacheTime());}
	// NEO: XSC END

	// NEO: DR - [DownloadReask]
	int		GetReaskIntervals();
#ifdef NEO_SS // NEO: NSS - [NeoSourceStorage]
	uint32	GetReaskIntervalsS()			{return MIN2S(GetReaskIntervals());}
#endif // NEO_SS // NEO: NSS END
	uint32	GetReaskIntervalsMs(bool bZZ = false)		{return MIN2MS(bZZ ? (GetReaskIntervals() * 7L) / 10L : GetReaskIntervals());}

	bool	DontNnPReask();
	int		GetNnPReaskIntervals();
	uint32	GetNnPReaskIntervalsMs()		{return MIN2MS(GetNnPReaskIntervals());}

	bool	DontFullQReask();
	int		GetFullQReaskIntervals();
	uint32	GetFullQReaskIntervalsMs()		{return MIN2MS(GetFullQReaskIntervals());}
	// NEO: DR END

#ifdef NEO_SK // NEO: NSK - [NeoSourceKeeper]
	bool	EnableSourceKeeper();
#endif // NEO_SK // NEO: NSK END
#ifdef NEO_SS // NEO: NSS - [NeoSourceStorage]
	bool	EnableSourceStorage();
	UINT	AutoSaveSources();
	int		GetAutoSaveSourcesIntervals();
	uint32	GetAutoSaveSourcesIntervalsMs()			{return MIN2MS(GetAutoSaveSourcesIntervals());}
	int		GetSourceStorageLimit();
	UINT	AutoLoadStoredSources();
	bool	UseStorageBootstrap();
	int		GetStorageBootstrapTime();
	uint32	GetStorageBootstrapTimeS()			{return MIN2S(GetStorageBootstrapTime());}
	int		GetStorageBootstrapRequirement();
	bool	StoreLowIDSources();
	bool	StoreAlsoA4AFSources();
	UINT	StoreSourcesFileStatus();

	int		AutoReaskStoredSources();
	int		GetAutoReaskStoredSourcesLimit();
	bool	IsTotalSourceRestore();
	bool	UseAutoReaskStoredSourcesDelay();
	int		GetAutoReaskStoredSourcesDelay();
	uint32	GetAutoReaskStoredSourcesDelayS()	{return MIN2S(GetAutoReaskStoredSourcesDelay());}

	int		GetAutoReaskLoadedSourcesDelay();
	uint32	GetAutoReaskLoadedSourcesDelayMs()	{return SEC2MS(GetAutoReaskStoredSourcesDelay());}

	bool	GroupStoredSourceReask();
	int		GetStoredSourceGroupIntervals();
	uint32	GetStoredSourceGroupIntervalsMs(UINT uSourceCount = 0)	{return SEC2MS(GetStoredSourceGroupIntervals() * (1 + uSourceCount));}
	int		GetStoredSourceGroupSize();

	bool	UseSmoothOutOfDate();
	int		GetMaxStoredFaildCount();
	int		GetStoredOutOfDate();
#endif // NEO_SS // NEO: NSS END
#ifdef NEO_SA // NEO: NSA - [NeoSourceAnaliser]
	bool	EnableSourceAnalizer();

	bool	DontStoreTemporarySources();

	int		GetPropabilityMode();
	float	GetEnhancedFactor();

	int		GetReaskPropability();
	int		GetReservePropability();

	bool	AutoReserveReask();
	int		GetReserveReaskPropability();
	bool	UseReaskReserveSourcesDelay();
	int		GetReaskReserveSourcesDelay();
	uint32	GetReaskReserveSourcesDelayS()		{return MIN2S(GetReaskReserveSourcesDelay());}
	int		GetReaskReserveSourcesLimit();

	bool	AutoTemporaryReask();
	int		GetTemporaryReaskPropability();
	bool	UseReaskTemporarySourcesDelay();
	int		GetReaskTemporarySourcesDelay();
	uint32	GetReaskTemporarySourcesDelayS()	{return MIN2S(GetReaskTemporarySourcesDelay());}
	int		GetReaskTemporarySourcesLimit();

	//int		GetMinAnalisisQuality();

	//bool	AutoUnsureReask();
	//bool	UseReaskUnsureSourcesDelay();
	//int		GetReaskUnsureSourcesDelay();
	//uint32	GetReaskUnsureSourcesDelayS()		{return MIN2S(GetReaskUnsureSourcesDelay());}
	//int		GetReaskUnsureSourcesLimit();

	bool	UseUnpredictedPropability();
	int		GetUnpredictedPropability();
	bool	UseReaskUnpredictedSourcesDelay();
	int		GetReaskUnpredictedSourcesDelay();
	uint32	GetReaskUnpredictedSourcesDelayS()	{return MIN2S(GetReaskUnpredictedSourcesDelay());}
	int		GetReaskUnpredictedSourcesLimit();

	UINT	RetryUnreachable();
	int		GetRetryUnreachableIntervals();
	uint32	GetRetryUnreachableIntervalsMs()	{return MIN2MS(GetRetryUnreachableIntervals());}

	UINT	IsFailTolerance();
	int		GetMaxFailTolerance();
	int		GetUnreachableReaskPropability();
	int		GetReaskUnreachableSourcesLimit();
#endif // NEO_SA // NEO: NSA END

	// NEO: DS - [DropSources]
	UINT	UseDropNnP();
	int		GetDropNnPLimit();
	int		GetDropNnPLimitMode();
	int		GetDropNnPTimer();
	uint32	GetDropNnPTimerMs()				{return MIN2MS(GetDropNnPTimer());}

	UINT	UseDropFullQ();
	int		GetDropFullQLimit();
	int		GetDropFullQLimitMode();
	int		GetDropFullQTimer();
	uint32	GetDropFullQTimerMs()			{return MIN2MS(GetDropFullQTimer());}

	UINT	UseDropHighQ();
	int		GetDropHighQValue();
	int		GetDropHighQLimit();
	int		GetDropHighQLimitMode();
	int		GetDropHighQTimer();
	uint32	GetDropHighQTimerMs()			{return MIN2MS(GetDropHighQTimer());}

	bool	UseDontAskThisIPList();
	int		GetDontAskThisIPCleanUpTime();
	uint32	GetDontAskThisIPCleanUpTimeMs() {return MIN2MS(GetDontAskThisIPCleanUpTime());}
	// NEO: DS END

	// NEO: NSD - [NeoSourceDrop]
#ifdef NEO_SK // NEO: NSK - [NeoSourceKeeper]
	bool	UseDropUnreachable();
	int		GetDropUnreachableLimit();
	int		GetDropUnreachableLimitMode();
	int		GetDropUnreachableTimer();
	uint32	GetDropUnreachableTimerMs()		{return MIN2MS(GetDropUnreachableTimer());}
#endif // NEO_SK // NEO: NSK END
#ifdef NEO_SS // NEO: NSS - [NeoSourceStorage]
	bool	UseDropOutOfDate();
	bool	UseDropOutOfDateSmooth();
	int		GetDropOutOfDateFails();
	int		GetDropOutOfDateTime();
	int		GetDropOutOfDateLimit();
	int		GetDropOutOfDateLimitMode();
	int		GetDropOutOfDateTimer();
	uint32	GetDropOutOfDateTimerMs()		{return MIN2MS(GetDropOutOfDateTimer());}
#endif // NEO_SS // NEO: NSS END
#ifdef NEO_SA // NEO: NSA - [NeoSourceAnaliser]
	bool	UseDropRetired();
	int		GetDropRetiredLimit();
	int		GetDropRetiredLimitMode();
	int		GetDropRetiredTimer();
	uint32	GetDropRetiredTimerMs()			{return MIN2MS(GetDropRetiredTimer());}

	bool	UseDropLoaded();
	int		GetDropLoadedLimit();
	int		GetDropLoadedLimitMode();
	int		GetDropLoadedTimer();
	uint32	GetDropLoadedTimerMs()			{return MIN2MS(GetDropLoadedTimer());}
#endif // NEO_SA // NEO: NSA END
	// NEO: NSD END

	// NEO: NCAP - [NeoCustomAutoPriority]
	bool	UseDynamicAutoDownPriority();
	float	GetDynamicDownPriorityFactor();
	int		GetLowDownPrioThreshold();
	int		GetHighDownPrioThreshold();
	// NEO: NCAP END

	// NEO: MCS - [ManualChunkSelection]
	void	SetWantedPart(UINT part, uint8 status) { m_WantedParts[part] = status; }
	uint8	GetWantedPart(UINT part) const;
	bool	HasWantedParts() const;
	// NEO: MCS END

	void CheckTweaks();
	void ResetTweaks();

protected:
	friend class CPPgSources;
#if defined(NEO_SK) || defined(NEO_SS) || defined(NEO_CD) // ||defined(NEO_SA) // NEO: NSS - [NeoSourceStorage]
	friend class CPPgSourceStorage;
#endif // NEO: NSS END
	friend class CPPgFileTweaks;

	int		m_iChunkSelectionMode;

	// NEO: RC4 - [RareChunksV4]
	int		m_iRareChunkV4Orde;
	bool	m_bRareChunkV4SameBlock;
	// NEO: RC4 END

	int		m_iSubChunkTransfer; // NEO: SCT - [SubChunkTransfer]

	int		m_iPartCatch; // NEO: NPC - [NeoPartCatch]

#ifdef A4AF_CATS // NEO: MAC - [MorphA4AFCategories]
	int		m_iA4AFFlags;
#endif // A4AF_CATS // NEO: MAC END

	// NEO: NST - [NeoSourceTweaks]
	int		m_iHardLimit;
	int		m_iSwapLimit;
	int		m_iCleanUpLimit;
	int		m_iCalcStandardLimits;

	int		m_iXSState;
	int		m_iXSLimit;
	int		m_iXSIntervals;
	int		m_iXSDelayValue;

	int		m_iSVRState;
	int		m_iSVRLimit;
	int		m_iSVRIntervals;

	int		m_iKADState;
	int		m_iKADLimit;
	int		m_iKADIntervals;
	int		m_iKADDelayValue;

	int		m_iUDPState;
	int		m_iUDPLimit;
	int		m_iUDPIntervals;
	// NEO: NST END

#ifdef LANCAST // NEO: NLC - [NeoLanCast]
	bool	m_bDisableLAN;
	int		m_iLANIntervals;

	int		m_iLanReaskIntervals;

	int		m_iNnPLanReaskIntervals;
#endif //LANCAST // NEO: NLC END

	// NEO: NSD - [NeoSourceDrop]
	int		m_iLow2LowCleanUpTime;
#if defined(NEO_SK) || defined(NEO_SS) // NEO: NSK - [NeoSourceKeeper] // NEO: NSS - [NeoSourceStorage]
	int		m_iBadCleanUpTime;
	int		m_iGoneCleanUpTime;
	int		m_iSuspendCleanUpTime;
#endif // NEO_SK // NEO_SS // NEO: NSK END // NEO: NSS END
	int		m_iNnPCleanUpTime;
	int		m_iFullQCleanUpTime;
	// NEO: NSD END

	// NEO: ASL - [AutoSoftLock]
	int		m_iAutoSoftLock;
	int		m_iAutoSoftLockValue;
	// NEO: ASL END

	// NEO: AHL - [AutoHardLimit]
	int		m_iAutoHardLimit;
	int		m_iMinimalHardLimit;
	int		m_iAutoHardLimitTimer;
	// NEO: AHL END

	// NEO: XSC - [ExtremeSourceCache]
	int		m_iSourceCache;
	int		m_iSourceCacheLimit;
	int		m_iSourceCacheTime;
	// NEO: XSC END

	// NEO: DR - [DownloadReask]
	int		m_iReaskIntervals;

	int		m_iNnPReask;
	int		m_iNnPReaskIntervals;

	int		m_iFullQReask;
	int		m_iFullQReaskIntervals;
	// NEO: DR END

#ifdef NEO_SK // NEO: NSK - [NeoSourceKeeper]
	int		m_iEnableSourceKeeper;
#endif // NEO_SK // NEO: NSK END
#ifdef NEO_SS // NEO: NSS - [NeoSourceStorage]
	int		m_iEnableSourceStorage;
	int		m_iAutoSaveSources;
	int		m_iAutoSaveSourcesIntervals;
	int		m_iSourceStorageLimit;
	int		m_iAutoLoadStoredSources;
	int		m_iUseStorageBootstrap;
	int		m_iStorageBootstrapTime;
	int		m_iStorageBootstrapRequirement;
	int		m_iStoreLowIDSources;
	int		m_iStoreAlsoA4AFSources;
	int		m_iStoreSourcesFileStatus;

	int		m_iAutoReaskStoredSources;
	int		m_iAutoReaskStoredSourcesLimit;
	int		m_iTotalSourceRestore;
	int		m_iUseAutoReaskStoredSourcesDelay;
	int		m_iAutoReaskStoredSourcesDelay;

	int		m_iAutoReaskLoadedSourcesDelay;

	int		m_iGroupStoredSourceReask;
	int		m_iStoredSourceGroupIntervals;
	int		m_iStoredSourceGroupSize;

	int		m_iUseSmoothOutOfDate;
	int		m_iMaxStoredFaildCount;
	int		m_iStoredOutOfDate;
#endif // NEO_SS // NEO: NSS END
#ifdef NEO_SA // NEO: NSA - [NeoSourceAnaliser]
	int		m_iEnableSourceAnalizer;

	int		m_iDontStoreTemporarySources;

	int		m_iPropabilityMode;
	float	m_fEnhancedFactor;

	int		m_iReaskPropability;
	int		m_iReservePropability;

	int		m_iAutoReserveReask;
	int		m_iReserveReaskPropability;
	int		m_iUseReaskReserveSourcesDelay;
	int		m_iReaskReserveSourcesDelay;
	int		m_iReaskReserveSourcesLimit;

	int		m_iAutoTemporaryReask;
	int		m_iTemporaryReaskPropability;
	int		m_iUseReaskTemporarySourcesDelay;
	int		m_iReaskTemporarySourcesDelay;
	int		m_iReaskTemporarySourcesLimit;

	//int		m_iMinAnalisisQuality;

	//int		m_iAutoUnsureReask;
	//int		m_iUseReaskUnsureSourcesDelay;
	//int		m_iReaskUnsureSourcesDelay;
	//int		m_iReaskUnsureSourcesLimit;

	int		m_iUseUnpredictedPropability;
	int		m_iUnpredictedPropability;
	int		m_iUseReaskUnpredictedSourcesDelay;
	int		m_iReaskUnpredictedSourcesDelay;
	int		m_iReaskUnpredictedSourcesLimit;

	int		m_iRetryUnreachable;
	int		m_iRetryUnreachableIntervals;
	int		m_iFailTolerance;
	int		m_iMaxFailTolerance;
	int		m_iUnreachableReaskPropability;
	int		m_iReaskUnreachableSourcesLimit;
#endif // NEO_SA // NEO: NSA END

	// NEO: DS - [DropSources]
	int		m_iDropNnP;
	int		m_iDropNnPLimit;
	int		m_iDropNnPLimitMode;
	int		m_iDropNnPTimer;

	int		m_iDropFullQ;
	int		m_iDropFullQLimit;
	int		m_iDropFullQLimitMode;
	int		m_iDropFullQTimer;

	int		m_iDropHighQ;
	int		m_iDropHighQValue;
	int		m_iDropHighQLimit;
	int		m_iDropHighQLimitMode;
	int		m_iDropHighQTimer;

	int		m_iUseDontAskThisIP;
	int		m_iDontAskThisIPTime;
	// NEO: DS END

	// NEO: NSD - [NeoSourceDrop]
#ifdef NEO_SK // NEO: NSK - [NeoSourceKeeper]
	int		m_iDropUnreachable;
	int		m_iDropUnreachableLimit;
	int		m_iDropUnreachableLimitMode;
	int		m_iDropUnreachableTimer;
#endif // NEO_SK // NEO: NSK END
#ifdef NEO_SS // NEO: NSS - [NeoSourceStorage]
	int		m_iDropOutOfDate;
	int		m_iDropOutOfDateSmooth;
	int		m_iDropOutOfDateFails;
	int		m_iDropOutOfDateTime;
	int		m_iDropOutOfDateLimit;
	int		m_iDropOutOfDateLimitMode;
	int		m_iDropOutOfDateTimer;
#endif // NEO_SS // NEO: NSS END
#ifdef NEO_SA // NEO: NSA - [NeoSourceAnaliser]
	int		m_iDropRetired;
	int		m_iDropRetiredLimit;
	int		m_iDropRetiredLimitMode;
	int		m_iDropRetiredTimer;

	int		m_iDropLoaded;
	int		m_iDropLoadedLimit;
	int		m_iDropLoadedLimitMode;
	int		m_iDropLoadedTimer;
#endif // NEO_SA // NEO: NSA END
	// NEO: NSD END

	// NEO: NCAP - [NeoCustomAutoPriority]
	int		m_iDynamicAutoDownPriority;
	float	m_fDynamicDownPriorityFactor;
	int		m_iLowDownPrioThreshold;
	int		m_iHighDownPrioThreshold;
	// NEO: NCAP END

	CMap<UINT, UINT, uint8, uint8> m_WantedParts; // NEO: MCS - [ManualChunkSelection]

	CArray<CTag*, CTag*> taglist;

private:
	void ClearTags();

	CPartFile* PartFile;
};

// NEO: FCFG END <-- Xanatos --