//this file is part of NeoMule
//Copyright (C)2006 David Xanatos ( Xanatos@Lycos.at / http://neomule.sourceforge.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


#include "stdafx.h"
#include "emule.h"
#include "PPgLancast.h"
#include "Preferences.h"
#include "OtherFunctions.h"
#include "Neo\Defaults.h"
#include "Neo\GUI\CP\TreeFunctions.h"
#ifdef NEO_BC // NEO: NBC - [NeoBandwidthControl] -- Xanatos -->
#include "Neo/BandwidthControl/BandwidthControl.h"
#endif // NEO_BC // NEO: NBC END <-- Xanatos --
#include "Neo/Lancast.h"
#ifdef VOODOO // NEO: VOODOO - [UniversalPartfileInterface] -- Xanatos -->
#include "Neo/voodoo.h"
#include "eMuleDlg.h"
#include "SearchDlg.h"
#include "SearchParamsWnd.h"
#include "SearchResultsWnd.h"
#endif // VOODOO // NEO: VOODOO END <-- Xanatos --



#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

#ifdef LANCAST // NEO: NLC - [NeoLanCast] -- Xanatos -->


///////////////////////////////////////////////////////////////////////////////
// CPPgLancast dialog

IMPLEMENT_DYNAMIC(CPPgLancast, CPropertyPage)

BEGIN_MESSAGE_MAP(CPPgLancast, CPropertyPage)
	ON_WM_DESTROY()
	ON_MESSAGE(WM_TREEOPTSCTRL_NOTIFY, OnTreeOptsCtrlNotify)
	ON_MESSAGE(WM_TREEITEM_HELP, DrawTreeItemHelp)
	ON_WM_HELPINFO()
END_MESSAGE_MAP()

CPPgLancast::CPPgLancast()
	: CPropertyPage(CPPgLancast::IDD)
	, m_ctrlTreeOptions(theApp.m_iDfltImageListColorFlags)
{
	ClearAllMembers();
	m_ctrlTreeOptions.SetNeoStyle();
}

CPPgLancast::~CPPgLancast()
{
}

void CPPgLancast::ClearAllMembers()
{
	m_bInitializedTreeOpts = false;
	
	m_htiLanSupport = NULL;
		m_htiLancastUpload = NULL;
			m_htiMaxLanUpload = NULL;
			m_htiDirectLanUpload = NULL;
			m_htiLanUploadSlots = NULL;
				m_htiMaxLanUploadSlots = NULL;
			m_htiLanUploadBufferSize = NULL;
		m_htiLancastDownload = NULL;
			m_htiMaxLanDownload = NULL;
			m_htiDirectLanDownload = NULL;
			m_htiLanDownloadBufferSize = NULL;
		m_htiCustomLanCastAdapter = NULL;
			m_htiCustomLanCastMask = NULL;
		m_htiLancast = NULL;
			m_htiLancastEnabled = NULL;
			m_htiCustomizedLanCast = NULL;
				m_htiLanCastPort = NULL;
			m_htiLanCastReask = NULL;
				m_htiLANIntervals = NULL;
				m_htiLanReaskIntervals = NULL;
				m_htiNnPLanReaskIntervals = NULL;
			m_htiAutoBroadcastLanFiles = NULL;
			m_htiUseLanMultiTransfer = NULL;
#ifdef VOODOO // NEO: VOODOO - [UniversalPartfileInterface]
		m_htiVoodoo = NULL;
			m_htiUseVoodooTransfer = NULL;
			m_htiSlaveAllowed = NULL;
			m_htiSlaveHosting = NULL;
			m_htiAutoConnectVoodoo = NULL;
			m_htiUseVirtualVoodooFiles = NULL;
			m_htiHideVoodooFiles = NULL;
			m_htiUseVoodooSourceExchange = NULL;
			m_htiUseVoodooSearch = NULL;
			m_htiVoodooNeoCommands = NULL;
			m_htiVoodooNeoPreferences = NULL;
			m_htiVoodooSpell = NULL;
			m_htiVoodooPort = NULL;
			m_htiVoodooCastEnabled = NULL;
				m_htiSearchForSlaves = NULL;
				m_htiSearchForMaster = NULL;
#endif // VOODOO // NEO: VOODOO END
}

void CPPgLancast::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_MOD_OPTS, m_ctrlTreeOptions);
	if (!m_bInitializedTreeOpts)
	{
		int	iImgLanSupport = 8;
		int iImgUploadControl = 8;
		int iImgUpload = 8;
		int iImgDownloadControl = 8;
		int iImgLancast = 8;
		int iImgReaskLan = 8;
#ifdef VOODOO // NEO: VOODOO - [UniversalPartfileInterface]
		int iImgVoodoo = 8;
#endif // VOODOO // NEO: VOODOO END

        CImageList* piml = m_ctrlTreeOptions.GetImageList(TVSIL_NORMAL);
		if (piml){
			iImgLanSupport = piml->Add(CTempIconLoader(_T("LANSYSTEM")));
			iImgUploadControl = piml->Add(CTempIconLoader(_T("UPLOADCONTROL")));
			iImgUpload = piml->Add(CTempIconLoader(_T("UPLOADTWEAKS")));
			iImgDownloadControl = piml->Add(CTempIconLoader(_T("DOWNLOADCONTROL")));
			iImgLancast = piml->Add(CTempIconLoader(_T("LANCAST")));
			iImgReaskLan = piml->Add(CTempIconLoader(_T("REASKLAN")));
#ifdef VOODOO // NEO: VOODOO - [UniversalPartfileInterface]
			iImgVoodoo = piml->Add(CTempIconLoader(_T("VOODOO")));
#endif // VOODOO // NEO: VOODOO END
		}

		SetTreeGroup(m_ctrlTreeOptions,m_htiLanSupport,GetResString(IDS_X_LANSUPPORT),iImgLanSupport, TVI_ROOT, GetResString(IDS_X_LANSUPPORT_INFO));
			SetTreeGroup(m_ctrlTreeOptions,m_htiLancastUpload,GetResString(IDS_X_LAN_UPLOAD),iImgUploadControl, m_htiLanSupport, GetResString(IDS_X_LAN_UPLOAD_INFO));
				SetTreeNumEdit(m_ctrlTreeOptions,m_htiMaxLanUpload,GetResString(IDS_X_MAX_LAN_UPLOAD), m_htiLancastUpload,GetResString(IDS_X_MAX_LAN_UPLOAD_INFO));
				SetTreeCheck(m_ctrlTreeOptions,m_htiDirectLanUpload,GetResString(IDS_X_LAN_DIRECT_UPLOAD),m_htiLancastUpload,GetResString(IDS_X_LAN_DIRECT_UPLOAD_INFO),FALSE,m_bDirectLanUpload);
				SetTreeGroup(m_ctrlTreeOptions,m_htiLanUploadSlots,GetResString(IDS_X_LAN_UPLOAD_SLOTS),iImgUpload,m_htiLancastUpload, GetResString(IDS_X_LAN_UPLOAD_SLOTS_INFO));
					SetTreeNumEdit(m_ctrlTreeOptions,m_htiMaxLanUploadSlots,GetResString(IDS_X_MAX_LAN_SLOTS), m_htiLanUploadSlots,GetResString(IDS_X_MAX_LAN_SLOTS_INFO));
				SetTreeCheckNumEdit(m_ctrlTreeOptions,m_htiLanUploadBufferSize,GetResString(IDS_X_LAN_UPLOAD_BUFFER), m_htiLancastUpload,GetResString(IDS_X_LAN_UPLOAD_BUFFER_INFO),FALSE, m_bSetLanUploadBuffer);
			SetTreeGroup(m_ctrlTreeOptions,m_htiLancastDownload,GetResString(IDS_X_LAN_DOWNLOAD),iImgDownloadControl, m_htiLanSupport, GetResString(IDS_X_LAN_DOWNLOAD_INFO));
				SetTreeNumEdit(m_ctrlTreeOptions,m_htiMaxLanDownload,GetResString(IDS_X_MAX_LAN_DOWNLOAD), m_htiLancastDownload,GetResString(IDS_X_MAX_LAN_DOWNLOAD_INFO));
				SetTreeCheck(m_ctrlTreeOptions,m_htiDirectLanDownload,GetResString(IDS_X_LAN_DIRECT_DOWNLOAD),m_htiLancastDownload,GetResString(IDS_X_LAN_DIRECT_DOWNLOAD_INFO),FALSE,m_bDirectLanDownload);
				SetTreeCheckNumEdit(m_ctrlTreeOptions,m_htiLanDownloadBufferSize,GetResString(IDS_X_LAN_DOWNLOAD_BUFFER), m_htiLancastDownload,GetResString(IDS_X_LAN_DOWNLOAD_BUFFER_INFO),FALSE, m_bSetLanDownloadBuffer);
			SetTreeAdapterIndex(m_ctrlTreeOptions,m_htiCustomLanCastAdapter,GetResString(IDS_X_LAN_ADAPTER),m_htiLanSupport,GetResString(IDS_X_LAN_ADAPTER_INFO),FALSE,TRUE,FALSE, m_bCustomLanCastAdapter);
				SetTreeAdapterIndex(m_ctrlTreeOptions,m_htiCustomLanCastMask,GetResString(IDS_X_LAN_MASK),m_htiCustomLanCastAdapter,GetResString(IDS_X_LAN_MASK_INFO),TRUE);
			SetTreeGroup(m_ctrlTreeOptions,m_htiLancast,GetResString(IDS_X_LANCAST_MAIN),iImgLancast, m_htiLanSupport, GetResString(IDS_X_LANCAST_MAIN_INFO));
				SetTreeCheck(m_ctrlTreeOptions,m_htiLancastEnabled,GetResString(IDS_X_LAN_ENABLE),m_htiLancast,GetResString(IDS_X_LAN_ENABLE_INFO),FALSE,m_bLancastEnabled);
				SetTreeCheckNumEdit(m_ctrlTreeOptions,m_htiCustomizedLanCast,GetResString(IDS_X_LAN_GROUPE), m_htiLancast,GetResString(IDS_X_LAN_GROUPE_INFO),FALSE, m_bCustomizedLanCast);
					SetTreeNumEdit(m_ctrlTreeOptions,m_htiLanCastPort,GetResString(IDS_X_LAN_PORT), m_htiCustomizedLanCast,GetResString(IDS_X_LAN_PORT_INFO));
				SetTreeGroup(m_ctrlTreeOptions,m_htiLanCastReask,GetResString(IDS_X_LAN_REASK),iImgReaskLan, m_htiLancast, GetResString(IDS_X_LAN_REASK_INFO));
					SetTreeNumEdit(m_ctrlTreeOptions,m_htiLANIntervals,GetResString(IDS_X_LAN_GET_SRC_TIME), m_htiLanCastReask,GetResString(IDS_X_LAN_GET_SRC_TIME_INFO));
					SetTreeNumEdit(m_ctrlTreeOptions,m_htiLanReaskIntervals,GetResString(IDS_X_LAN_DL_REASK), m_htiLanCastReask,GetResString(IDS_X_LAN_DL_REASK_INFO));
					SetTreeNumEdit(m_ctrlTreeOptions,m_htiNnPLanReaskIntervals,GetResString(IDS_X_LAN_NNP_REASK), m_htiLanCastReask,GetResString(IDS_X_LAN_NNP_REASK_INFO));
				SetTreeCheckNumEdit(m_ctrlTreeOptions,m_htiAutoBroadcastLanFiles,GetResString(IDS_X_LAN_BROADCAST), m_htiLancast,GetResString(IDS_X_LAN_BROADCAST_INFO),FALSE, m_bAutoBroadcastLanFiles);
				SetTreeCheck(m_ctrlTreeOptions,m_htiUseLanMultiTransfer,GetResString(IDS_X_USE_LAN_MULTI_TRANSFER),m_htiLancast,GetResString(IDS_X_USE_LAN_MULTI_TRANSFER_INFO),FALSE,m_bUseLanMultiTransfer);
#ifdef VOODOO // NEO: VOODOO - [UniversalPartfileInterface]
			SetTreeGroup(m_ctrlTreeOptions,m_htiVoodoo,GetResString(IDS_X_VOODOO_MAIN),iImgVoodoo, m_htiLanSupport, GetResString(IDS_X_VOODOO_MAIN_INFO));
				SetTreeCheck(m_ctrlTreeOptions,m_htiUseVoodooTransfer,GetResString(IDS_X_USE_VOODOO_TRANSFER),m_htiVoodoo,GetResString(IDS_X_USE_VOODOO_TRANSFER_INFO),FALSE,m_bUseVoodooTransfer);
				SetTreeCheck(m_ctrlTreeOptions,m_htiSlaveAllowed,GetResString(IDS_X_SLAVE_ALLOWED),m_htiVoodoo,GetResString(IDS_X_SLAVE_ALLOWED_INFO),FALSE,m_bSlaveAllowed);
				SetTreeCheck(m_ctrlTreeOptions,m_htiSlaveHosting,GetResString(IDS_X_SLAVE_HOSTING),m_htiVoodoo,GetResString(IDS_X_SLAVE_HOSTING_INFO),FALSE,m_bSlaveHosting);
				SetTreeCheck(m_ctrlTreeOptions,m_htiAutoConnectVoodoo,GetResString(IDS_X_AUTO_CONNECT_VOODOO),m_htiVoodoo,GetResString(IDS_X_AUTO_CONNECT_VOODOO_INFO),TRUE,m_uAutoConnectVoodoo);
				SetTreeCheck(m_ctrlTreeOptions,m_htiUseVirtualVoodooFiles,GetResString(IDS_X_USE_VIRTUAL_VOODOO_FILES),m_htiVoodoo,GetResString(IDS_X_USE_VIRTUAL_VOODOO_FILES_INFO),TRUE,m_uUseVirtualVoodooFiles);
				SetTreeCheck(m_ctrlTreeOptions,m_htiHideVoodooFiles,GetResString(IDS_X_HIDE_VOODOO_FILES),m_htiVoodoo,GetResString(IDS_X_HIDE_VOODOO_FILES_INFO),FALSE,m_bHideVoodooFiles);
				SetTreeCheck(m_ctrlTreeOptions,m_htiUseVoodooSourceExchange,GetResString(IDS_X_USE_VOODOO_SOURCE_EXCHANGE),m_htiVoodoo,GetResString(IDS_X_USE_VOODOO_SOURCE_EXCHANGE_INFO),TRUE,m_uUseVoodooSourceExchange);
				SetTreeCheck(m_ctrlTreeOptions,m_htiUseVoodooSearch,GetResString(IDS_X_USE_VOODOO_SEARCH),m_htiVoodoo,GetResString(IDS_X_USE_VOODOO_SEARCH_INFO),FALSE,m_bUseVoodooSearch);
				SetTreeCheck(m_ctrlTreeOptions,m_htiVoodooNeoCommands,GetResString(IDS_X_VOODOO_NEO_COMMANDS),m_htiVoodoo,GetResString(IDS_X_VOODOO_NEO_COMMANDS_INFO),FALSE,m_bVoodooNeoCommands);
				SetTreeCheck(m_ctrlTreeOptions,m_htiVoodooNeoPreferences,GetResString(IDS_X_VOODOO_NEO_PREFERENCES),m_htiVoodoo,GetResString(IDS_X_VOODOO_NEO_PREFERENCES_INFO),FALSE,m_bVoodooNeoPreferences);
				SetTreeEdit(m_ctrlTreeOptions,m_htiVoodooSpell,GetResString(IDS_X_VOODOO_SPELL), m_htiVoodoo,GetResString(IDS_X_VOODOO_SPELL_INFO));
				SetTreeNumEdit(m_ctrlTreeOptions,m_htiVoodooPort,GetResString(IDS_X_VOODOO_SOCKET_PORT), m_htiVoodoo,GetResString(IDS_X_VOODOO_SOCKET_PORT_INFO));
				SetTreeCheckNumEdit(m_ctrlTreeOptions,m_htiVoodooCastEnabled,GetResString(IDS_X_VOODOOCAST),m_htiVoodoo,GetResString(IDS_X_VOODOOCAST_INFO),TRUE,m_uVoodooCastEnabled);
					SetTreeCheck(m_ctrlTreeOptions,m_htiSearchForSlaves,GetResString(IDS_X_SEARCH_FOR_SLAVES), m_htiVoodooCastEnabled,GetResString(IDS_X_SEARCH_FOR_SLAVES_INFO),TRUE, m_uSearchForSlaves);
					SetTreeCheck(m_ctrlTreeOptions,m_htiSearchForMaster,GetResString(IDS_X_SEARCH_FOR_MASTER), m_htiVoodooCastEnabled,GetResString(IDS_X_SEARCH_FOR_MASTER_INFO),TRUE, m_uSearchForMaster);
					//SetTreeCheck(m_ctrlTreeOptions,m_htiVoodooSearchIntervals,GetResString(IDS_X_VOODOO_SEARCH_INTERVALS), m_htiVoodooCastEnabled,GetResString(IDS_X_VOODOO_SEARCH_INTERVALS_INFO));
#endif // VOODOO // NEO: VOODOO END

			CheckEnable();

		m_ctrlTreeOptions.Expand(m_htiLanSupport, TVE_EXPAND);
		m_bInitializedTreeOpts = true;
	}

	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiDirectLanDownload, m_bDirectLanDownload);
	DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiMaxLanDownload, m_iMaxLanDownload);
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiLanUploadBufferSize, m_bSetLanUploadBuffer);
	DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiLanUploadBufferSize, m_iLanUploadBufferSize);

	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiDirectLanUpload, m_bDirectLanUpload);
	DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiMaxLanUpload, m_iMaxLanUpload);
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiLanDownloadBufferSize, m_bSetLanDownloadBuffer);
	DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiLanDownloadBufferSize, m_iLanDownloadBufferSize);

		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiMaxLanUploadSlots, m_iMaxLanUploadSlots);

	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiCustomLanCastAdapter, m_bCustomLanCastAdapter);
	DDX_AdapterIndex(&m_ctrlTreeOptions,pDX, IDC_MOD_OPTS, m_htiCustomLanCastAdapter, m_uLanCastAdapterIPAdress);
		DDX_AdapterIndex(&m_ctrlTreeOptions,pDX, IDC_MOD_OPTS, m_htiCustomLanCastMask, m_uLanCastAdapterSubNet);

	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiLancastEnabled, m_bLancastEnabled);

	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiCustomizedLanCast, m_bCustomizedLanCast);
		DDX_TreeEdit(pDX, IDC_MOD_OPTS, m_htiCustomizedLanCast, m_sLanCastGroup);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiLanCastPort, m_uLanCastPort);

		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiLANIntervals, m_iLANIntervals);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiLanReaskIntervals, m_iLanReaskIntervals);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiNnPLanReaskIntervals, m_iNnPLanReaskIntervals);

	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiAutoBroadcastLanFiles, m_bAutoBroadcastLanFiles);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiAutoBroadcastLanFiles, m_iAutoBroadcastLanFiles);

	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiUseLanMultiTransfer, m_bUseLanMultiTransfer);

#ifdef VOODOO // NEO: VOODOO - [UniversalPartfileInterface]
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiUseVoodooTransfer, m_bUseVoodooTransfer);
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiSlaveAllowed, m_bSlaveAllowed);
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiSlaveHosting, m_bSlaveHosting);
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiAutoConnectVoodoo, m_uAutoConnectVoodoo);
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiUseVirtualVoodooFiles, m_uUseVirtualVoodooFiles);
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiHideVoodooFiles, m_bHideVoodooFiles);
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiUseVoodooSourceExchange, m_uUseVoodooSourceExchange);
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiUseVoodooSearch, m_bUseVoodooSearch);
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiVoodooNeoCommands, m_bVoodooNeoCommands);
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiVoodooNeoPreferences, m_bVoodooNeoPreferences);
	DDX_TreeEdit(pDX, IDC_MOD_OPTS, m_htiVoodooSpell, m_sVoodooSpell);
	DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiVoodooPort, m_nVoodooPort);
	DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiVoodooCastEnabled, m_uVoodooCastEnabled);
		DDX_TreeEditE0(&m_ctrlTreeOptions, pDX, IDC_MOD_OPTS, m_htiVoodooCastEnabled, m_iVoodooSearchIntervals);
		DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiSearchForSlaves, m_uSearchForSlaves);
		DDX_TreeCheck(pDX, IDC_MOD_OPTS, m_htiSearchForMaster, m_uSearchForMaster);
#endif // VOODOO // NEO: VOODOO END

}

BOOL CPPgLancast::OnInitDialog()
{
	LoadSettings();

	CPropertyPage::OnInitDialog();
	InitWindowStyles(this);

	return TRUE;  // return TRUE unless you set the focus to a control
				  // EXCEPTION: OCX Property Pages should return FALSE
}

void CPPgLancast::LoadSettings()
{
	/*
	* Globale Einstellungen Laden
	*/

	m_bLancastEnabled = thePrefs.m_bLancastEnabled;

	m_iMaxLanDownload = thePrefs.m_iMaxLanDownload;
	m_bDirectLanDownload = thePrefs.m_bDirectLanDownload;
	m_bSetLanDownloadBuffer = thePrefs.m_bSetLanDownloadBuffer;
	m_iLanDownloadBufferSize = thePrefs.m_iLanDownloadBufferSize;

	m_iMaxLanUpload = thePrefs.m_iMaxLanUpload;
	m_bDirectLanUpload = thePrefs.m_bDirectLanUpload;
	m_bSetLanUploadBuffer = thePrefs.m_bSetLanUploadBuffer;
	m_iLanUploadBufferSize = thePrefs.m_iLanUploadBufferSize;

	m_iMaxLanUploadSlots = thePrefs.m_iMaxLanUploadSlots;

	m_bCustomizedLanCast = thePrefs.m_bCustomizedLanCast;
	m_sLanCastGroup = thePrefs.m_sLanCastGroup;
	m_uLanCastPort = thePrefs.m_uLanCastPort;

	m_bCustomLanCastAdapter = thePrefs.m_bCustomLanCastAdapter;
	m_uLanCastAdapterIPAdress = thePrefs.m_uLanCastAdapterIPAdress;
	m_uLanCastAdapterSubNet = thePrefs.m_uLanCastAdapterSubNet;

	m_iLANIntervals = thePrefs.m_iLANIntervals;

	m_iLanReaskIntervals = thePrefs.m_iLanReaskIntervals;
	m_iNnPLanReaskIntervals = thePrefs.m_iNnPLanReaskIntervals;

	m_bAutoBroadcastLanFiles = thePrefs.m_bAutoBroadcastLanFiles;
	m_iAutoBroadcastLanFiles = thePrefs.m_iAutoBroadcastLanFiles;

	m_bUseLanMultiTransfer = thePrefs.m_bUseLanMultiTransfer;

#ifdef VOODOO // NEO: VOODOO - [UniversalPartfileInterface]
	m_bUseVoodooTransfer = thePrefs.m_bUseVoodooTransfer;
	m_bSlaveAllowed = thePrefs.m_bSlaveAllowed;
	m_bSlaveHosting = thePrefs.m_bSlaveHosting;

	m_sVoodooSpell = thePrefs.m_sVoodooSpell;
	m_nVoodooPort = thePrefs.m_nVoodooPort;

	m_uAutoConnectVoodoo = thePrefs.m_uAutoConnectVoodoo;

	m_uUseVirtualVoodooFiles = thePrefs.m_uUseVirtualVoodooFiles;
	m_bHideVoodooFiles = thePrefs.m_bHideVoodooFiles;

	m_uUseVoodooSourceExchange = thePrefs.m_uUseVoodooSourceExchange;

	m_bUseVoodooSearch = thePrefs.m_bUseVoodooSearch;

	m_bVoodooNeoCommands = thePrefs.m_bVoodooNeoCommands;
	m_bVoodooNeoPreferences = thePrefs.m_bVoodooNeoPreferences;

	m_uVoodooCastEnabled = thePrefs.m_uVoodooCastEnabled;

	m_uSearchForSlaves = thePrefs.m_uSearchForSlaves;
	m_uSearchForMaster = thePrefs.m_uSearchForMaster;
	m_iVoodooSearchIntervals = thePrefs.m_iVoodooSearchIntervals;
#endif // VOODOO // NEO: VOODOO END

}

BOOL CPPgLancast::OnApply()
{
	// if prop page is closed by pressing ENTER we have to explicitly commit any possibly pending
	// data from an open edit control
	m_ctrlTreeOptions.HandleChildControlLosingFocus();

	if (!UpdateData())
		return FALSE;

	/*
	* Globale Einstellungen Speichern
	*/

	bool bUpdateLancast = (thePrefs.m_bLancastEnabled != m_bLancastEnabled);
	thePrefs.m_bLancastEnabled = m_bLancastEnabled;

	thePrefs.m_iMaxLanDownload = (uint16)m_iMaxLanDownload;
	thePrefs.m_bDirectLanDownload = m_bDirectLanDownload;
	thePrefs.m_bSetLanDownloadBuffer = m_bSetLanDownloadBuffer;
	thePrefs.m_iLanDownloadBufferSize = m_iLanDownloadBufferSize;

	thePrefs.m_iMaxLanUpload = (uint16)m_iMaxLanUpload;
	thePrefs.m_bDirectLanUpload = m_bDirectLanUpload;
	thePrefs.m_bSetLanUploadBuffer = m_bSetLanUploadBuffer;
	thePrefs.m_iLanUploadBufferSize = m_iLanUploadBufferSize;

	thePrefs.m_iMaxLanUploadSlots = m_iMaxLanUploadSlots;

	if ((thePrefs.m_bCustomizedLanCast != m_bCustomizedLanCast)
	 ||	(thePrefs.m_sLanCastGroup != m_sLanCastGroup)
	 || (thePrefs.m_uLanCastPort != m_uLanCastPort))
		bUpdateLancast = true;

	thePrefs.m_bCustomizedLanCast = m_bCustomizedLanCast;
	thePrefs.m_sLanCastGroup = m_sLanCastGroup;
	thePrefs.m_uLanCastPort = (uint16)m_uLanCastPort;

	bool bUpdateLanAdapter =  ((thePrefs.m_bCustomLanCastAdapter != m_bCustomLanCastAdapter)
	 ||	(thePrefs.m_uLanCastAdapterIPAdress != m_uLanCastAdapterIPAdress)
	 || (thePrefs.m_uLanCastAdapterSubNet != m_uLanCastAdapterSubNet));

	if(bUpdateLancast)
		bUpdateLanAdapter = true;

	thePrefs.m_bCustomLanCastAdapter = m_bCustomLanCastAdapter;
	thePrefs.m_uLanCastAdapterIPAdress = m_uLanCastAdapterIPAdress;
	thePrefs.m_uLanCastAdapterSubNet = m_uLanCastAdapterSubNet;

	thePrefs.m_iLANIntervals = m_iLANIntervals;

	thePrefs.m_iLanReaskIntervals = m_iLanReaskIntervals;
	thePrefs.m_iNnPLanReaskIntervals = m_iNnPLanReaskIntervals;

	thePrefs.m_bAutoBroadcastLanFiles = m_bAutoBroadcastLanFiles;
	thePrefs.m_iAutoBroadcastLanFiles = m_iAutoBroadcastLanFiles;

	thePrefs.m_bUseLanMultiTransfer = m_bUseLanMultiTransfer;

#ifdef VOODOO // NEO: VOODOO - [UniversalPartfileInterface]
	bool bUpdateVoodoo = ((thePrefs.m_bUseVoodooTransfer != m_bUseVoodooTransfer)
					|| (thePrefs.m_bSlaveAllowed != m_bSlaveAllowed));

	bool bUpdateVoodooSocket = ((thePrefs.m_bSlaveAllowed != m_bSlaveAllowed)
						||(thePrefs.m_bSlaveHosting != m_bSlaveHosting));

	if(bUpdateVoodooSocket)
		bUpdateLanAdapter = true;

	thePrefs.m_bUseVoodooTransfer = m_bUseVoodooTransfer;
	thePrefs.m_bSlaveAllowed = m_bSlaveAllowed;
	thePrefs.m_bSlaveHosting = m_bSlaveHosting;

	thePrefs.m_sVoodooSpell = m_sVoodooSpell;
	bool bUpdateVoodooPort = (thePrefs.m_nVoodooPort != m_nVoodooPort);
	thePrefs.m_nVoodooPort = (uint16)m_nVoodooPort;

	thePrefs.m_uAutoConnectVoodoo = m_uAutoConnectVoodoo;

	thePrefs.m_uUseVirtualVoodooFiles = m_uUseVirtualVoodooFiles;
	thePrefs.m_bHideVoodooFiles = m_bHideVoodooFiles;

	thePrefs.m_uUseVoodooSourceExchange = m_uUseVoodooSourceExchange;

	thePrefs.m_bUseVoodooSearch = m_bUseVoodooSearch;
	theApp.emuledlg->searchwnd->m_pwndResults->m_pwndParams->m_ctlVoodoo.EnableWindow(m_bUseVoodooSearch);  // NEO: VOODOOs - [VoodooSearchForwarding]

	thePrefs.m_bVoodooNeoCommands = m_bVoodooNeoCommands;
	thePrefs.m_bVoodooNeoPreferences = m_bVoodooNeoPreferences;

	thePrefs.m_uVoodooCastEnabled = m_uVoodooCastEnabled;

	thePrefs.m_uSearchForSlaves = m_uSearchForSlaves;
	thePrefs.m_uSearchForMaster = m_uSearchForMaster;
	thePrefs.m_iVoodooSearchIntervals = m_iVoodooSearchIntervals;
#endif // VOODOO // NEO: VOODOO END

	if(bUpdateLanAdapter)
		theApp.lancast->SelectAdapters();

#ifdef VOODOO // NEO: VOODOO - [UniversalPartfileInterface]
	if(bUpdateVoodoo && (thePrefs.m_bUseVoodooTransfer || thePrefs.m_bSlaveAllowed)){
		if(!theApp.voodoo->IsStarted())
			theApp.voodoo->Start();
	}else if(bUpdateVoodoo){
		if(theApp.voodoo->IsStarted())
			theApp.voodoo->Stop();
	}
	if(bUpdateVoodooSocket && (thePrefs.m_bSlaveAllowed || thePrefs.m_bSlaveHosting)){
		if(!theApp.voodoo->IsListening())
			theApp.voodoo->StartListening();
	}else if(bUpdateVoodooSocket){
		if(theApp.voodoo->IsListening())
			theApp.voodoo->Close();
	}else if(bUpdateVoodooPort){
		if(theApp.voodoo->IsListening())
			theApp.voodoo->Rebind();
	}
#endif // VOODOO // NEO: VOODOO END

	if(bUpdateLancast){
		if(theApp.lancast->IsConnected())
			theApp.lancast->Stop();
		if(thePrefs.m_bLancastEnabled)
			theApp.lancast->Start();
	}

	thePrefs.CheckNeoPreferences();
	LoadSettings();

	SetModified(FALSE);
	return CPropertyPage::OnApply();
}

BOOL CPPgLancast::OnKillActive()
{
	// if prop page is closed by pressing ENTER we have to explicitly commit any possibly pending
	// data from an open edit control
	m_ctrlTreeOptions.HandleChildControlLosingFocus();
	return CPropertyPage::OnKillActive();
}

void CPPgLancast::OnDestroy()
{
	m_ctrlTreeOptions.DeleteAllItems();
	m_ctrlTreeOptions.DestroyWindow();
	ClearAllMembers();
	CPropertyPage::OnDestroy();
}

LRESULT CPPgLancast::OnTreeOptsCtrlNotify(WPARAM wParam, LPARAM lParam)
{
	if(!IsWindowVisible())
		return 0;

	if (wParam == IDC_MOD_OPTS){
		TREEOPTSCTRLNOTIFY* pton = (TREEOPTSCTRLNOTIFY*)lParam;
		if(pton->nmhdr.code == EN_KILLFOCUS){			
			if(m_htiLanDownloadBufferSize && pton->hItem == m_htiLanDownloadBufferSize){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiLanDownloadBufferSize, VAL_LAN_DOWNLOAD_BUFFER_MIN, VAL_LAN_DOWNLOAD_BUFFER_DEF, VAL_LAN_DOWNLOAD_BUFFER_MAX)) SetModified();
			}else if(m_htiLanUploadBufferSize && pton->hItem == m_htiLanUploadBufferSize){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiLanUploadBufferSize, VAL_LAN_UPLOAD_BUFFER_MIN, VAL_LAN_UPLOAD_BUFFER_DEF, VAL_LAN_UPLOAD_BUFFER_MAX)) SetModified();
			}else 
			if(m_htiMaxLanUploadSlots && pton->hItem == m_htiMaxLanUploadSlots){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiMaxLanUploadSlots, VAL_MAX_LAN_UPLOAD_SLOTS_MIN, VAL_MAX_LAN_UPLOAD_SLOTS_DEF, VAL_MAX_LAN_UPLOAD_SLOTS_MAX)) SetModified();
			}else 
			if(m_htiLANIntervals && pton->hItem == m_htiLANIntervals){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiLANIntervals, TIM_LAN_INTERVAL_MIN, TIM_LAN_INTERVAL_DEF, TIM_LAN_INTERVAL_MAX)) SetModified();
			}else if(m_htiLanReaskIntervals && pton->hItem == m_htiLanReaskIntervals){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiLanReaskIntervals, TIM_REASK_LAN_MIN, TIM_REASK_LAN_DEF, TIM_REASK_LAN_MAX)) SetModified();
			}else if(m_htiNnPLanReaskIntervals && pton->hItem == m_htiNnPLanReaskIntervals){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiNnPLanReaskIntervals, TIM_REASK_NNP_LAN_MIN, TIM_REASK_NNP_LAN_DEF, TIM_REASK_NNP_LAN_MAX)) SetModified();
			}else 

			if(m_htiAutoBroadcastLanFiles && pton->hItem == m_htiAutoBroadcastLanFiles){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiAutoBroadcastLanFiles, TIM_AUTO_BROADCAST_LAN_FILES_MIN, TIM_AUTO_BROADCAST_LAN_FILES_DEF, TIM_AUTO_BROADCAST_LAN_FILES_MAX)) SetModified();
			}
#ifdef VOODOO // NEO: VOODOO - [UniversalPartfileInterface]
			else if(m_htiVoodooCastEnabled && pton->hItem == m_htiVoodooCastEnabled){
				if(CheckTreeEditLimit(m_ctrlTreeOptions, m_htiVoodooCastEnabled, TIM_VOODOO_SEARCH_MIN, TIM_VOODOO_SEARCH_DEF, TIM_VOODOO_SEARCH_MAX)) SetModified();
			}
#endif // VOODOO // NEO: VOODOO END
		}else{
			UINT bCheck;
			if(m_htiLancastEnabled && pton->hItem == m_htiLancastEnabled){
				CheckEnable();
			}else
#ifdef VOODOO // NEO: VOODOO - [UniversalPartfileInterface]
			if(m_htiUseVoodooTransfer && pton->hItem == m_htiUseVoodooTransfer){
				CheckEnable();
			}else
			if(m_htiSlaveHosting && pton->hItem == m_htiSlaveHosting){
				CheckEnable();
			}else
			if(m_htiSlaveAllowed && pton->hItem == m_htiSlaveAllowed){
				CheckEnable();
			}else
#endif // VOODOO // NEO: VOODOO END
			if(m_htiLanDownloadBufferSize && pton->hItem == m_htiLanDownloadBufferSize){
				m_ctrlTreeOptions.GetCheckBox(m_htiLanDownloadBufferSize, bCheck);
				m_ctrlTreeOptions.SetItemEnable(m_htiLanDownloadBufferSize, bCheck, TRUE, TRUE);
			}
			else if(m_htiLanUploadBufferSize && pton->hItem == m_htiLanUploadBufferSize){
				m_ctrlTreeOptions.GetCheckBox(m_htiLanUploadBufferSize, bCheck);
				m_ctrlTreeOptions.SetItemEnable(m_htiLanUploadBufferSize, bCheck, TRUE, TRUE);
			}else
			if(m_htiAutoBroadcastLanFiles && pton->hItem == m_htiAutoBroadcastLanFiles){
				m_ctrlTreeOptions.GetCheckBox(m_htiAutoBroadcastLanFiles, bCheck);
				m_ctrlTreeOptions.SetItemEnable(m_htiAutoBroadcastLanFiles, bCheck,TRUE,TRUE);
			}else
			if(m_htiCustomLanCastAdapter && pton->hItem == m_htiCustomLanCastAdapter){
				m_ctrlTreeOptions.GetCheckBox(m_htiCustomLanCastAdapter, bCheck);
				m_ctrlTreeOptions.SetGroupEnable(m_htiCustomLanCastAdapter, bCheck);
				m_ctrlTreeOptions.SetItemEnable(m_htiCustomLanCastAdapter, bCheck,TRUE,TRUE);
			}else
			if(m_htiCustomizedLanCast && pton->hItem == m_htiCustomizedLanCast){
				m_ctrlTreeOptions.GetCheckBox(m_htiCustomizedLanCast, bCheck);
				m_ctrlTreeOptions.SetGroupEnable(m_htiCustomizedLanCast, bCheck);
				m_ctrlTreeOptions.SetItemEnable(m_htiCustomizedLanCast, bCheck,TRUE,TRUE);
			}else
			if(m_htiDirectLanDownload && pton->hItem == m_htiDirectLanDownload){
				m_ctrlTreeOptions.GetCheckBox(m_htiDirectLanDownload, bCheck);
				m_ctrlTreeOptions.SetItemEnable(m_htiMaxLanDownload, !bCheck);
			}
#ifdef VOODOO // NEO: VOODOO - [UniversalPartfileInterface]
			if(m_htiUseVoodooTransfer && pton->hItem == m_htiUseVoodooTransfer){
				m_ctrlTreeOptions.GetCheckBox(m_htiUseVoodooTransfer, bCheck);
				m_ctrlTreeOptions.SetGroupEnable(m_htiSlaveHosting, bCheck);
			}
			if(m_htiVoodooCastEnabled && pton->hItem == m_htiVoodooCastEnabled){
				m_ctrlTreeOptions.GetCheckBox(m_htiVoodooCastEnabled, bCheck);
				m_ctrlTreeOptions.SetItemEnable(m_htiVoodooCastEnabled, bCheck,FALSE,TRUE);
				m_ctrlTreeOptions.SetGroupEnable(m_htiVoodooCastEnabled, bCheck);
			}
#endif // VOODOO // NEO: VOODOO END
			SetModified();
		}
	}
	return 0;
}

void CPPgLancast::CheckEnable(){
	UINT bLanSupport;
	UINT bLanCast;
	m_ctrlTreeOptions.GetCheckBox(m_htiLancastEnabled, bLanCast);
	bLanSupport = bLanCast;
#ifdef VOODOO // NEO: VOODOO - [UniversalPartfileInterface]
	UINT bVoodoo;
	m_ctrlTreeOptions.GetCheckBox(m_htiUseVoodooTransfer, bVoodoo);
	if(!bVoodoo)
		m_ctrlTreeOptions.GetCheckBox(m_htiSlaveAllowed, bVoodoo);
	if(bVoodoo)
		bLanSupport = TRUE;
#endif // VOODOO // NEO: VOODOO END

	m_ctrlTreeOptions.SetItemEnable(m_htiLancastUpload, bLanSupport);
	m_ctrlTreeOptions.SetItemEnable(m_htiLancastDownload, bLanSupport);
	m_ctrlTreeOptions.SetItemEnable(m_htiCustomLanCastAdapter, bLanSupport);

	m_ctrlTreeOptions.SetItemEnable(m_htiCustomizedLanCast, bLanCast);
	m_ctrlTreeOptions.SetItemEnable(m_htiLanCastReask, bLanCast);
	m_ctrlTreeOptions.SetItemEnable(m_htiAutoBroadcastLanFiles, bLanCast);
	m_ctrlTreeOptions.SetItemEnable(m_htiUseLanMultiTransfer, bLanCast);

	UINT bCheck;

	if(bLanSupport){
		m_ctrlTreeOptions.GetCheckBox(m_htiLanDownloadBufferSize, bCheck);
		m_ctrlTreeOptions.SetItemEnable(m_htiLanDownloadBufferSize, bCheck, TRUE, TRUE);
		m_ctrlTreeOptions.GetCheckBox(m_htiLanUploadBufferSize, bCheck);
		m_ctrlTreeOptions.SetItemEnable(m_htiLanUploadBufferSize, bCheck, TRUE, TRUE);

		m_ctrlTreeOptions.GetCheckBox(m_htiCustomLanCastAdapter, bCheck);
		m_ctrlTreeOptions.SetGroupEnable(m_htiCustomLanCastAdapter, bCheck);
		m_ctrlTreeOptions.SetItemEnable(m_htiCustomLanCastAdapter, bCheck,TRUE,TRUE);
		m_ctrlTreeOptions.SetItemEnable(m_htiCustomLanCastMask, bCheck);

		m_ctrlTreeOptions.GetCheckBox(m_htiDirectLanDownload, bCheck);
		m_ctrlTreeOptions.SetItemEnable(m_htiMaxLanDownload, !bCheck && bLanCast);
		m_ctrlTreeOptions.SetItemEnable(m_htiMaxLanUpload, bLanCast);
	}

	if(bLanCast){
		m_ctrlTreeOptions.GetCheckBox(m_htiCustomizedLanCast, bCheck);
		m_ctrlTreeOptions.SetGroupEnable(m_htiCustomizedLanCast, bCheck);
		m_ctrlTreeOptions.SetItemEnable(m_htiCustomizedLanCast, bCheck,TRUE,TRUE);

		m_ctrlTreeOptions.GetCheckBox(m_htiAutoBroadcastLanFiles, bCheck);
		m_ctrlTreeOptions.SetItemEnable(m_htiAutoBroadcastLanFiles, bCheck,TRUE,TRUE);
	}

#ifdef VOODOO // NEO: VOODOO - [UniversalPartfileInterface]
	UINT bVoodooSocket = FALSE;
	if(bVoodoo){
		m_ctrlTreeOptions.GetCheckBox(m_htiSlaveHosting, bVoodooSocket);
		if(!bVoodooSocket)
			m_ctrlTreeOptions.GetCheckBox(m_htiSlaveAllowed, bVoodooSocket);
	}
	m_ctrlTreeOptions.SetItemEnable(m_htiSlaveHosting, bVoodoo);
	m_ctrlTreeOptions.SetItemEnable(m_htiAutoConnectVoodoo, bVoodoo);
	m_ctrlTreeOptions.SetItemEnable(m_htiUseVirtualVoodooFiles, bVoodoo);
	m_ctrlTreeOptions.SetItemEnable(m_htiHideVoodooFiles, bVoodoo);
	m_ctrlTreeOptions.SetItemEnable(m_htiUseVoodooSourceExchange, bVoodoo);
	m_ctrlTreeOptions.SetItemEnable(m_htiUseVoodooSearch, bVoodoo);
	m_ctrlTreeOptions.SetItemEnable(m_htiVoodooNeoCommands, bVoodoo);
	m_ctrlTreeOptions.SetItemEnable(m_htiVoodooNeoPreferences, bVoodoo);
	m_ctrlTreeOptions.SetItemEnable(m_htiVoodooSpell, bVoodoo);
	m_ctrlTreeOptions.SetItemEnable(m_htiVoodooPort, bVoodooSocket);
	m_ctrlTreeOptions.SetItemEnable(m_htiVoodooCastEnabled, bVoodoo && bLanCast);

	if(bVoodoo){
		m_ctrlTreeOptions.GetCheckBox(m_htiUseVoodooTransfer, bCheck);
		m_ctrlTreeOptions.SetItemEnable(m_htiSlaveHosting, bCheck);

		m_ctrlTreeOptions.GetCheckBox(m_htiVoodooCastEnabled, bCheck);
		m_ctrlTreeOptions.SetGroupEnable(m_htiVoodooCastEnabled, bCheck && bLanCast);
	}
#endif // VOODOO // NEO: VOODOO END
}

LRESULT CPPgLancast::DrawTreeItemHelp(WPARAM wParam, LPARAM lParam)
{
	if(!IsWindowVisible())
		return 0;

	if (wParam == IDC_MOD_OPTS){
		CString* sInfo = (CString*)lParam;
		SetDlgItemText(IDC_MOD_OPTS_INFO, *sInfo);
	}
	return FALSE;
}

void CPPgLancast::OnHelp()
{
	//theApp.ShowHelp(0);
}

BOOL CPPgLancast::OnCommand(WPARAM wParam, LPARAM lParam)
{
	if (wParam == ID_HELP)
	{
		OnHelp();
		return TRUE;
	}
	return __super::OnCommand(wParam, lParam);
}

BOOL CPPgLancast::OnHelpInfo(HELPINFO* /*pHelpInfo*/)
{
	OnHelp();
	return TRUE;
}

#endif //LANCAST // NEO: NLC END <-- Xanatos --