// EM Neo Backup
//
// License
// -------
// This code is provided "as is" with no expressed or implied warranty.
// 
// You may use this code in a non commercial open source product with 
// or without acknowledgement. You may not sell this code or any 
// modification of this code.
//
//
// Copyright (c) 2004 
// http://neomule.sourceforge.net 
// davidxanatos@lycos.at
////////////////////////////////////////////////////////////////////////

// NEO: NB - [NeoBackup] -- Xanatos -->

// .\Neo\PPgModBackup.cpp : Implementierungsdatei
//

#include "stdafx.h"
#include "emule.h"
#include "emuledlg.h"
#include "preferences.h"
#include "otherfunctions.h"
#include "ppgbackup.h"
#include "Neo\EMBackup.h"
#include "Neo\defaults.h" 
#include "Neo\functions.h" 

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

// PPgModBackup-Dialogfeld

IMPLEMENT_DYNAMIC(CPPgBackup, CPropertyPage)
CPPgBackup::CPPgBackup()
	: CPropertyPage(CPPgBackup::IDD)
{
}

CPPgBackup::~CPPgBackup()
{
}

void CPPgBackup::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
}


BEGIN_MESSAGE_MAP(CPPgBackup, CPropertyPage)
	ON_BN_CLICKED(IDC_BACKUP_NOW, OnBackupNow)
	ON_BN_CLICKED(IDC_BACKUP_BROWSE, OnBrowserDir)
	ON_BN_CLICKED(IDC_BACKUP_BROWSE2, OnBrowserDir2)

	ON_BN_CLICKED(IDB_CFG_FILE_DAT, OnBoxesChange)
	ON_BN_CLICKED(IDB_CFG_FILE_MET, OnBoxesChange)
	ON_BN_CLICKED(IDB_CFG_FILE_INI, OnBoxesChange)

	ON_BN_CLICKED(IDB_TMP_FILE_PART, OnBnClickedPart)
	ON_BN_CLICKED(IDB_TMP_FILE_PART_MET, OnBoxesChange)
	ON_BN_CLICKED(IDB_TMP_FILE_PART_MET_NEO, OnBoxesChange)
	ON_BN_CLICKED(IDB_TMP_FILE_PART_MET_SRC, OnBoxesChange)
	
	ON_BN_CLICKED(IDB_AUTO_BACKUP, OnBoxesChange)
	ON_BN_CLICKED(IDB_RUNTIME_BACKUP, OnBoxesChange)
	ON_EN_CHANGE(IDC_BACKUP_TIME, OnSettingsChange)
	ON_BN_CLICKED(IDB_AUTO_RESTORE_CFG, OnSettingsChange)
	ON_BN_CLICKED(IDB_AUTO_RESTORE_MAIN_CFG, OnSettingsChange)
	ON_BN_CLICKED(IDB_AUTO_RESTORE_TMP, OnSettingsChange)
	ON_BN_CLICKED(IDB_AUTO_RESTORE_MET, OnSettingsChange)
	ON_BN_CLICKED(IDB_AUTO_RESTORE_MET_NEO, OnSettingsChange)
	ON_BN_CLICKED(IDB_AUTO_RESTORE_MET_SRC, OnSettingsChange)
	ON_BN_CLICKED(IDB_AUTO_RESTORE_PART, OnSettingsChange)

	ON_BN_CLICKED(IDB_DOUBLE_BACKUP, OnBoxesChange)	
	ON_BN_CLICKED(IDB_EXCLUDE_PART, OnSettingsChange)

	ON_EN_CHANGE(IDC_BACKUP_DIR, OnSettingsChange)
	ON_EN_CHANGE(IDC_BACKUP_DIR2, OnSettingsChange)

	ON_BN_CLICKED(IDB_ENABLE_BACKUP, OnBoxesChange)
END_MESSAGE_MAP()

BOOL CPPgBackup::OnInitDialog()
{
	CPropertyPage::OnInitDialog();

	LoadSettings();
	Localize();

	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}

void CPPgBackup::LoadSettings(void)
{
	if(m_hWnd){	
	CheckDlgButton(IDB_ENABLE_BACKUP,theApp.BackupEngine->prefs.Enable);

	CheckDlgButton(IDB_CFG_FILE_DAT,(theApp.BackupEngine->prefs.FilesToBackup & EMB_CFG_DAT) ? 1 : 0);
	CheckDlgButton(IDB_CFG_FILE_MET,(theApp.BackupEngine->prefs.FilesToBackup & EMB_CFG_MET) ? 1 : 0);
	CheckDlgButton(IDB_CFG_FILE_INI,(theApp.BackupEngine->prefs.FilesToBackup & EMB_CFG_INI) ? 1 : 0);

	CheckDlgButton(IDB_TMP_FILE_PART,(theApp.BackupEngine->prefs.FilesToBackup & EMB_TMP_PART) ? 1 : 0);
	CheckDlgButton(IDB_TMP_FILE_PART_MET,(theApp.BackupEngine->prefs.FilesToBackup & EMB_TMP_PART_MET) ? 1 : 0);
	CheckDlgButton(IDB_TMP_FILE_PART_MET_NEO,(theApp.BackupEngine->prefs.FilesToBackup & EMB_TMP_PART_MET_NEO) ? 1 : 0);
	CheckDlgButton(IDB_TMP_FILE_PART_MET_SRC,(theApp.BackupEngine->prefs.FilesToBackup & EMB_TMP_PART_MET_SRC) ? 1 : 0);

	CheckDlgButton(IDB_AUTO_BACKUP,theApp.BackupEngine->prefs.AutoBackup);
	CheckDlgButton(IDB_RUNTIME_BACKUP,theApp.BackupEngine->prefs.RunTimeBackup);
	GetDlgItem(IDC_BACKUP_TIME)->SetWindowText(Time2MinStr(theApp.BackupEngine->prefs.RunTimeBackupTime));
	
	CheckDlgButton(IDB_AUTO_RESTORE_CFG,(theApp.BackupEngine->prefs.FilesToAutoRestore & EMB_CFG) ? 1 : 0);
	CheckDlgButton(IDB_AUTO_RESTORE_MAIN_CFG,(theApp.BackupEngine->prefs.FilesToAutoRestore & EMB_CFG_MAIN) ? 1 : 0);
	CheckDlgButton(IDB_AUTO_RESTORE_TMP,(theApp.BackupEngine->prefs.FilesToAutoRestore & EMB_TMP) ? 1 : 0);

	CheckDlgButton(IDB_AUTO_RESTORE_MET,(theApp.BackupEngine->prefs.FilesToAutoRestore & EMB_TMP_PART_MET) ? 1 : 0);
	CheckDlgButton(IDB_AUTO_RESTORE_MET_NEO,(theApp.BackupEngine->prefs.FilesToAutoRestore & EMB_TMP_PART_MET_NEO) ? 1 : 0);
	CheckDlgButton(IDB_AUTO_RESTORE_MET_SRC,(theApp.BackupEngine->prefs.FilesToAutoRestore & EMB_TMP_PART_MET_SRC) ? 1 : 0);
	CheckDlgButton(IDB_AUTO_RESTORE_PART,(theApp.BackupEngine->prefs.FilesToAutoRestore & EMB_TMP_PART) ? 1 : 0);

	GetDlgItem(IDC_BACKUP_DIR)->SetWindowText(theApp.BackupEngine->prefs.BackupDir);

	CheckDlgButton(IDB_DOUBLE_BACKUP,theApp.BackupEngine->prefs.DoubleBackup);
	CheckDlgButton(IDB_EXCLUDE_PART,theApp.BackupEngine->prefs.ExcludePartFiles);
	GetDlgItem(IDC_BACKUP_DIR2)->SetWindowText(theApp.BackupEngine->prefs.BackupDir2);

	SetBoxes();
	}
}

BOOL CPPgBackup::OnApply()
{
	WCHAR buffer[MAX_PATH];
	if(m_hWnd){
		if (!TestDirs())
			return FALSE;

		if (GetFileTypeList() == NULL)
			CheckDlgButton(IDB_AUTO_BACKUP,0);

		BOOL isAuto = IsDlgButtonChecked(IDB_AUTO_BACKUP);

		if (!(isAuto && (IsDlgButtonChecked(IDB_CFG_FILE_DAT) || IsDlgButtonChecked(IDB_CFG_FILE_MET) || IsDlgButtonChecked(IDB_CFG_FILE_INI))))
			CheckDlgButton(IDB_AUTO_RESTORE_CFG,0);

		if (!(isAuto && (IsDlgButtonChecked(IDB_TMP_FILE_PART_MET) || IsDlgButtonChecked(IDB_TMP_FILE_PART_MET_NEO) || IsDlgButtonChecked(IDB_TMP_FILE_PART_MET_SRC) )))
			CheckDlgButton(IDB_AUTO_RESTORE_TMP,0);

		if (!(IsDlgButtonChecked(IDB_CFG_FILE_MET) && isAuto))
			CheckDlgButton(IDB_AUTO_RESTORE_MAIN_CFG,0);

		if (!(IsDlgButtonChecked(IDB_TMP_FILE_PART_MET) && isAuto))
			CheckDlgButton(IDB_AUTO_RESTORE_MET,0);

		if (!(IsDlgButtonChecked(IDB_TMP_FILE_PART_MET_NEO) && isAuto))
			CheckDlgButton(IDB_AUTO_RESTORE_MET_NEO,0);

		if (!(IsDlgButtonChecked(IDB_TMP_FILE_PART_MET_SRC) && isAuto))
			CheckDlgButton(IDB_AUTO_RESTORE_MET_SRC,0);

		if (!(IsDlgButtonChecked(IDB_TMP_FILE_PART) && IsDlgButtonChecked(IDB_TMP_FILE_PART_MET) && isAuto))
			CheckDlgButton(IDB_AUTO_RESTORE_PART,0);

		theApp.BackupEngine->prefs.Enable = I2B(IsDlgButtonChecked(IDB_ENABLE_BACKUP));

		theApp.BackupEngine->prefs.FilesToBackup = NULL;

		theApp.BackupEngine->prefs.FilesToBackup |= IsDlgButtonChecked(IDB_CFG_FILE_DAT) ? EMB_CFG_DAT : NULL;
		theApp.BackupEngine->prefs.FilesToBackup |= IsDlgButtonChecked(IDB_CFG_FILE_MET) ? EMB_CFG_MET : NULL;
		theApp.BackupEngine->prefs.FilesToBackup |= IsDlgButtonChecked(IDB_CFG_FILE_INI) ? EMB_CFG_INI : NULL;

		theApp.BackupEngine->prefs.FilesToBackup |= IsDlgButtonChecked(IDB_TMP_FILE_PART) ? EMB_TMP_PART : NULL;
		theApp.BackupEngine->prefs.FilesToBackup |= IsDlgButtonChecked(IDB_TMP_FILE_PART_MET) ? EMB_TMP_PART_MET : NULL;
		theApp.BackupEngine->prefs.FilesToBackup |= IsDlgButtonChecked(IDB_TMP_FILE_PART_MET_NEO) ? EMB_TMP_PART_MET_NEO : NULL;
		theApp.BackupEngine->prefs.FilesToBackup |= IsDlgButtonChecked(IDB_TMP_FILE_PART_MET_SRC) ? EMB_TMP_PART_MET_SRC : NULL;

		theApp.BackupEngine->prefs.AutoBackup = I2B(IsDlgButtonChecked(IDB_AUTO_BACKUP));
		theApp.BackupEngine->prefs.RunTimeBackup = I2B(IsDlgButtonChecked(IDB_RUNTIME_BACKUP));
		GetDlgItem(IDC_BACKUP_TIME)->GetWindowText(buffer, 20);
		theApp.BackupEngine->prefs.RunTimeBackupTime = MinStr2Time(buffer,MIN_BACKUP_TIME,DEF_BACKUP_TIME,NULL);

		theApp.BackupEngine->prefs.FilesToAutoRestore = NULL;

		theApp.BackupEngine->prefs.FilesToAutoRestore |= IsDlgButtonChecked(IDB_AUTO_RESTORE_CFG) ? EMB_CFG : NULL;
		theApp.BackupEngine->prefs.FilesToAutoRestore |= IsDlgButtonChecked(IDB_AUTO_RESTORE_MAIN_CFG) ? EMB_CFG_MAIN : NULL;
		theApp.BackupEngine->prefs.FilesToAutoRestore |= IsDlgButtonChecked(IDB_AUTO_RESTORE_TMP) ? EMB_TMP : NULL;

		theApp.BackupEngine->prefs.FilesToAutoRestore |= IsDlgButtonChecked(IDB_AUTO_RESTORE_MET) ? EMB_TMP_PART_MET : NULL;
		theApp.BackupEngine->prefs.FilesToAutoRestore |= IsDlgButtonChecked(IDB_AUTO_RESTORE_MET_NEO) ? EMB_TMP_PART_MET_NEO : NULL;
		theApp.BackupEngine->prefs.FilesToAutoRestore |= IsDlgButtonChecked(IDB_AUTO_RESTORE_MET_NEO) ? EMB_TMP_PART_MET_SRC : NULL;
		theApp.BackupEngine->prefs.FilesToAutoRestore |= IsDlgButtonChecked(IDB_AUTO_RESTORE_PART) ? EMB_TMP_PART : NULL;

		GetDlgItem(IDC_BACKUP_DIR)->GetWindowText(buffer,MAX_PATH);
		MakeFoldername(buffer);
		_stprintf(theApp.BackupEngine->prefs.BackupDir,_T("%s"), buffer);

		theApp.BackupEngine->prefs.DoubleBackup = I2B(IsDlgButtonChecked(IDB_DOUBLE_BACKUP));
		theApp.BackupEngine->prefs.ExcludePartFiles = I2B(IsDlgButtonChecked(IDB_EXCLUDE_PART));

		GetDlgItem(IDC_BACKUP_DIR2)->GetWindowText(buffer,MAX_PATH);
		MakeFoldername(buffer);
		_stprintf(theApp.BackupEngine->prefs.BackupDir2,_T("%s"), buffer);

		theApp.BackupEngine->SavePreferences();
	}
	SetModified(FALSE);
	return CPropertyPage::OnApply();
}

void CPPgBackup::Localize(void)
{	
	if(m_hWnd)
	{
		GetDlgItem(IDC_BACK_CONFIG)->SetWindowText(GetResString(IDS_X_BACK_CONFIG));
		GetDlgItem(IDC_BACK_TEMP)->SetWindowText(GetResString(IDS_X_BACK_TEMP));
		GetDlgItem(IDC_GROUP_BACKUP_OPTIONS)->SetWindowText(GetResString(IDS_X_GROUP_BACKUP_OPTIONS));
		GetDlgItem(IDB_AUTO_BACKUP)->SetWindowText(GetResString(IDS_X_AUTO_BACKUP));
		GetDlgItem(IDB_RUNTIME_BACKUP)->SetWindowText(GetResString(IDS_X_RUNTIME_BACKUP));
		GetDlgItem(IDB_AUTO_RESTORE_CFG)->SetWindowText(GetResString(IDS_X_AUTO_RESTORE_CFG));
		GetDlgItem(IDB_AUTO_RESTORE_TMP)->SetWindowText(GetResString(IDS_X_AUTO_RESTORE_TMP));
		GetDlgItem(IDB_AUTO_RESTORE_MAIN_CFG)->SetWindowText(GetResString(IDS_X_AUTO_RESTORE_MAIN_CFG));
		GetDlgItem(IDB_AUTO_RESTORE_MET)->SetWindowText(GetResString(IDS_X_AUTO_RESTORE_MET));
		GetDlgItem(IDB_AUTO_RESTORE_MET_NEO)->SetWindowText(GetResString(IDS_X_AUTO_RESTORE_MET_NEO));
		GetDlgItem(IDB_AUTO_RESTORE_MET_SRC)->SetWindowText(GetResString(IDS_X_AUTO_RESTORE_MET_SRC));
		GetDlgItem(IDB_AUTO_RESTORE_PART)->SetWindowText(GetResString(IDS_X_AUTO_RESTORE_PART));
		GetDlgItem(IDC_BACKUP_DIRS)->SetWindowText(GetResString(IDS_X_BACKUP_DIRS));
		GetDlgItem(IDB_DOUBLE_BACKUP)->SetWindowText(GetResString(IDS_X_DOUBLE_BACKUP));
		GetDlgItem(IDB_EXCLUDE_PART)->SetWindowText(GetResString(IDS_X_EXCLUDE_PART));
		GetDlgItem(IDC_BACKUP_NOW)->SetWindowText(GetResString(IDS_X_BACKUP_NOW));
		GetDlgItem(IDB_ENABLE_BACKUP)->SetWindowText(GetResString(IDS_X_ENABLE_BACKUP));
	}
}

void CPPgBackup::SetBoxes()
{
	bool Disable = false;
	if(IsDlgButtonChecked(IDB_ENABLE_BACKUP)){
		GetDlgItem(IDB_CFG_FILE_DAT)->EnableWindow();
		GetDlgItem(IDB_CFG_FILE_MET)->EnableWindow();
		GetDlgItem(IDB_CFG_FILE_INI)->EnableWindow();

		GetDlgItem(IDB_TMP_FILE_PART)->EnableWindow();
		GetDlgItem(IDB_TMP_FILE_PART_MET)->EnableWindow();
		GetDlgItem(IDB_TMP_FILE_PART_MET_NEO)->EnableWindow();
		GetDlgItem(IDB_TMP_FILE_PART_MET_SRC)->EnableWindow();
	}else{
		GetDlgItem(IDB_CFG_FILE_DAT)->EnableWindow(0);
		GetDlgItem(IDB_CFG_FILE_MET)->EnableWindow(0);
		GetDlgItem(IDB_CFG_FILE_INI)->EnableWindow(0);

		GetDlgItem(IDB_TMP_FILE_PART)->EnableWindow(0);
		GetDlgItem(IDB_TMP_FILE_PART_MET)->EnableWindow(0);
		GetDlgItem(IDB_TMP_FILE_PART_MET_NEO)->EnableWindow(0);
		GetDlgItem(IDB_TMP_FILE_PART_MET_SRC)->EnableWindow(0);
		Disable = true;
	}

	if(GetFileTypeList() != NULL && Disable == false){
		GetDlgItem(IDB_AUTO_BACKUP)->EnableWindow();
		GetDlgItem(IDC_BACKUP_DIR)->EnableWindow();
		GetDlgItem(IDC_BACKUP_BROWSE)->EnableWindow();
		GetDlgItem(IDC_BACKUP_NOW)->EnableWindow();

		BOOL isAuto = IsDlgButtonChecked(IDB_AUTO_BACKUP);
		BOOL isDouble = IsDlgButtonChecked(IDB_DOUBLE_BACKUP);

		GetDlgItem(IDB_RUNTIME_BACKUP)->EnableWindow(isAuto);
		GetDlgItem(IDC_BACKUP_TIME)->EnableWindow(isAuto && IsDlgButtonChecked(IDB_RUNTIME_BACKUP));

		GetDlgItem(IDB_DOUBLE_BACKUP)->EnableWindow(isAuto);
		GetDlgItem(IDB_AUTO_RESTORE_CFG)->EnableWindow(isAuto && (IsDlgButtonChecked(IDB_CFG_FILE_DAT) || IsDlgButtonChecked(IDB_CFG_FILE_MET) || IsDlgButtonChecked(IDB_CFG_FILE_INI)));

		GetDlgItem(IDC_BACKUP_DIR2)->EnableWindow(isDouble);
		GetDlgItem(IDC_BACKUP_BROWSE2)->EnableWindow(isDouble);

		GetDlgItem(IDB_AUTO_RESTORE_MAIN_CFG)->EnableWindow((IsDlgButtonChecked(IDB_CFG_FILE_MET) && isAuto));
		GetDlgItem(IDB_AUTO_RESTORE_TMP)->EnableWindow(isAuto && (IsDlgButtonChecked(IDB_TMP_FILE_PART_MET) || IsDlgButtonChecked(IDB_TMP_FILE_PART_MET_NEO) || IsDlgButtonChecked(IDB_TMP_FILE_PART_MET_SRC) ));
		GetDlgItem(IDB_AUTO_RESTORE_MET)->EnableWindow((IsDlgButtonChecked(IDB_TMP_FILE_PART_MET) && isAuto));
		GetDlgItem(IDB_AUTO_RESTORE_MET_NEO)->EnableWindow((IsDlgButtonChecked(IDB_TMP_FILE_PART_MET_NEO) && isAuto));
		GetDlgItem(IDB_AUTO_RESTORE_MET_SRC)->EnableWindow((IsDlgButtonChecked(IDB_TMP_FILE_PART_MET_SRC) && isAuto));
		GetDlgItem(IDB_AUTO_RESTORE_PART)->EnableWindow((IsDlgButtonChecked(IDB_TMP_FILE_PART) && IsDlgButtonChecked(IDB_TMP_FILE_PART_MET) && isAuto));

		GetDlgItem(IDB_EXCLUDE_PART)->EnableWindow((IsDlgButtonChecked(IDB_TMP_FILE_PART) && isDouble));
	}else{
		GetDlgItem(IDB_AUTO_BACKUP)->EnableWindow(0);
		GetDlgItem(IDB_RUNTIME_BACKUP)->EnableWindow(0);
		GetDlgItem(IDC_BACKUP_TIME)->EnableWindow(0);
		GetDlgItem(IDB_AUTO_RESTORE_CFG)->EnableWindow(0);
		GetDlgItem(IDB_AUTO_RESTORE_MAIN_CFG)->EnableWindow(0);
		GetDlgItem(IDB_AUTO_RESTORE_TMP)->EnableWindow(0);
		GetDlgItem(IDB_AUTO_RESTORE_MET)->EnableWindow(0);
		GetDlgItem(IDB_AUTO_RESTORE_MET_NEO)->EnableWindow(0);
		GetDlgItem(IDB_AUTO_RESTORE_MET_SRC)->EnableWindow(0);
		GetDlgItem(IDB_AUTO_RESTORE_PART)->EnableWindow(0);

		GetDlgItem(IDC_BACKUP_DIR)->EnableWindow(0);
		GetDlgItem(IDC_BACKUP_BROWSE)->EnableWindow(0);

		GetDlgItem(IDB_DOUBLE_BACKUP)->EnableWindow(0);
		GetDlgItem(IDB_EXCLUDE_PART)->EnableWindow(0);

		GetDlgItem(IDC_BACKUP_DIR2)->EnableWindow(0);
		GetDlgItem(IDC_BACKUP_BROWSE2)->EnableWindow(0);

		GetDlgItem(IDC_BACKUP_NOW)->EnableWindow(0);
	}
}

void CPPgBackup::BackupNow()
{
	DWORD tFiles = GetFileTypeList();
	if (tFiles == NULL){
		AfxMessageBox(GetResString(IDS_X_BACKUP_NOW_NOFILES),MB_ICONEXCLAMATION,0);
		return;
	}

	if (AfxMessageBox((tFiles & EMB_TMP_PART) ? GetResString(IDS_X_BACKUP_NOW_QUESTION2) : GetResString(IDS_X_BACKUP_NOW_QUESTION),MB_YESNO,0) == IDYES)
	{
		if (tFiles & EMB_TMP_PART) tFiles ^= EMB_TMP_PART;
		if(!theApp.BackupEngine->Backup(tFiles))
			AfxMessageBox(GetResString(IDS_X_BACKUP_NOW_SUCCESS),MB_OK,0);
	}
}

BOOL CPPgBackup::SelectDir(TCHAR* outdir, CString titletext)
{
	CoInitialize(0);
	BOOL done;
	TCHAR* buffer = new TCHAR[MAX_PATH];
	BROWSEINFO bi = { GetSafeHwnd(), 0, buffer, titletext, BIF_VALIDATE | BIF_NEWDIALOGSTYLE | BIF_RETURNONLYFSDIRS, 0, 0, 0};
	LPITEMIDLIST pidl = SHBrowseForFolder(&bi);
	delete[] buffer;
	done = SHGetPathFromIDList(pidl,outdir);
	LPMALLOC ppMalloc;
	if(SHGetMalloc(&ppMalloc) == NOERROR)
	{
		ppMalloc->Free(pidl);
		ppMalloc->Release();
	}
	CoUninitialize();
	return done;
}

void CPPgBackup::BrowserDir(){
	TCHAR buffer[MAX_PATH];	
	if(SelectDir(buffer,GetResString(IDS_X_SELECT_BACKUPDIR)))
	{
		GetDlgItem(IDC_BACKUP_DIR)->SetWindowText(buffer);
		SetModified();
	}
}

void CPPgBackup::BrowserDir2(){
	TCHAR buffer[MAX_PATH];	
	if(SelectDir(buffer,GetResString(IDS_X_SELECT_BACKUPDIR2)))
	{
		GetDlgItem(IDC_BACKUP_DIR2)->SetWindowText(buffer);
		SetModified();
	}
}

void CPPgBackup::OnBnClickedPart()
{
	if (IsDlgButtonChecked(IDB_TMP_FILE_PART))
		if (AfxMessageBox(GetResString(IDS_X_BACK_BACKUP_LONGTIME),MB_ICONQUESTION|MB_YESNO,0)== IDNO)
			CheckDlgButton(IDB_TMP_FILE_PART,0);

	SetBoxes();
	SetModified();
}


DWORD CPPgBackup::GetFileTypeList(){
	DWORD FilesToBackup = NULL;

	if (IsDlgButtonChecked(IDB_CFG_FILE_DAT)) FilesToBackup = FilesToBackup | EMB_CFG_DAT;
	if (IsDlgButtonChecked(IDB_CFG_FILE_MET)) FilesToBackup = FilesToBackup | EMB_CFG_MET;
	if (IsDlgButtonChecked(IDB_CFG_FILE_INI)) FilesToBackup = FilesToBackup | EMB_CFG_INI;

	if (IsDlgButtonChecked(IDB_TMP_FILE_PART)) FilesToBackup = FilesToBackup | EMB_TMP_PART;
	if (IsDlgButtonChecked(IDB_TMP_FILE_PART_MET)) FilesToBackup = FilesToBackup | EMB_TMP_PART_MET;
	if (IsDlgButtonChecked(IDB_TMP_FILE_PART_MET_NEO)) FilesToBackup = FilesToBackup | EMB_TMP_PART_MET_NEO;
	if (IsDlgButtonChecked(IDB_TMP_FILE_PART_MET_SRC)) FilesToBackup = FilesToBackup | EMB_TMP_PART_MET_SRC;

	return FilesToBackup;
}

bool CPPgBackup::TestDirs(){
	WCHAR buffer[MAX_PATH];
	WCHAR buffer2[MAX_PATH];

	GetDlgItem(IDC_BACKUP_DIR)->GetWindowText(buffer,MAX_PATH);
	MakeFoldername(buffer);
	GetDlgItem(IDC_BACKUP_DIR2)->GetWindowText(buffer2,MAX_PATH);
	MakeFoldername(buffer2);

	if (CompareDirectories(buffer, buffer2)==0 && IsDlgButtonChecked(IDB_DOUBLE_BACKUP)){
		AfxMessageBox(GetResString(IDS_X_BACK_DIR_ERROR_SAME));
		return false;
	}

	if (CompareDirectories(buffer, thePrefs.GetIncomingDir())==0 || CompareDirectories(buffer, thePrefs.GetTempDir())==0 || CompareDirectories(buffer, thePrefs.GetConfigDir())==0){
		AfxMessageBox(GetResString(IDS_X_BACK_DIR_ERROR_USED));
		return false;
	}
	return true;
}
// PPgModBackup-Meldungshandler

// NEO: NB END <-- Xanatos --