//this file is part of eMule
//Copyright (C)2002 Merkur ( devs@emule-project.net / http://www.emule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#pragma once
#include "EncryptedDatagramSocket.h"
#ifdef NEO_DBT // NEO: NDBT - [NeoDownloadBandwidthThrottler] -- Xanatos -->
#include "Neo/BandwidthControl/DownloadBandwidthThrottler.h"
#endif // NEO_DBT // NEO: NDBT END <-- Xanatos --
#ifdef NEO_UBT // NEO: NUBT - [NeoUploadBandwidthThrottler] -- Xanatos -->
#include "Neo/BandwidthControl/UploadBandwidthThrottler.h" // ZZ:UploadBandWithThrottler (UDP)
#else
#include "UploadBandwidthThrottler.h" // ZZ:UploadBandWithThrottler (UDP)
#endif // NEO_UBT // NEO: NUBT END <-- Xanatos --
#include "Neo/NeoDebugC.h" // NEO: ND - [NeoDebug] <-- Xanatos --

class Packet;
#ifdef NEO_DBT // NEO: NDBT - [NeoDownloadBandwidthThrottler] -- Xanatos -->
class CReceiveData;
#endif // NEO_DBT // NEO: NDBT END <-- Xanatos --
#ifdef NATTUNNELING // NEO: UTCP - [UserModeTCP] -- Xanatos -->
class CNATSocket;
#endif //NATTUNNELING // NEO: UTCP END <-- Xanatos --

#pragma pack(1)
struct UDPPack
{
	Packet* packet;
	uint32 dwIP;
	uint16 nPort;
	uint32 dwTime;
	bool	bEncrypt;
	uchar	achTargetClientHash[16];
#ifdef NEO_UBT // NEO: NUBT - [NeoUploadBandwidthThrottler] -- Xanatos -->
	bool priority;
#endif // NEO_UBT // NEO: NUBT END <-- Xanatos --
	//uint16 nPriority; We could add a priority system here to force some packets.
};
#pragma pack()

class CClientUDPSocket : public CAsyncSocket, public CEncryptedDatagramSocket, public ThrottledControlSocket // ZZ:UploadBandWithThrottler (UDP)
{
public:
	CClientUDPSocket();
	virtual ~CClientUDPSocket();

	// NEO: KAX - [KadAuxPort] -- Xanatos -->
	bool	Create(bool bKad = false); 
	bool	Rebind(bool bKad = false); 
	// NEO: KAX END <-- Xanatos --
	uint16	GetConnectedPort()			{ return m_port; }

#ifdef NEO_DBT // NEO: NDBT - [NeoDownloadBandwidthThrottler] -- Xanatos -->
	bool	IsEmpty() const {return m_pendingPackets == 0;}
	int		Receive(uint32 size);
	bool	ProcessData(bool ignore = false);
	virtual bool	IsPriorityReceive() {return theApp.clientudp != theApp.clientkad && this == theApp.clientkad ;}
#endif // NEO_DBT // NEO: NDBT END <-- Xanatos --
	bool	isUDP() const {return true;}
#ifdef NEO_UBT // NEO: NUBT - [NeoUploadBandwidthThrottler] -- Xanatos -->
	bool	SendPacket(Packet* packet, uint32 dwIP, uint16 nPort, bool bEncrypt, const uchar* pachTargetClientHash, bool priority = false);
    SocketSentBytes  Send(uint32 maxNumberOfBytesToSend, uint32 minFragSize, bool onlyAllowedToSendControlPacket = false, uint16 maxNumberOfPacketsToSend = 0xFFFF);
	bool	ControlPacketQueueIsEmpty() const {return !controlpacket_queue.GetCount();}
	bool	IsPrioritySend();
#else
	bool	SendPacket(Packet* packet, uint32 dwIP, uint16 nPort, bool bEncrypt, const uchar* pachTargetClientHash);
    SocketSentBytes  SendControlData(uint32 maxNumberOfBytesToSend, uint32 minFragSize); // ZZ:UploadBandWithThrottler (UDP)
#endif // NEO_UBT // NEO: NUBT END <-- Xanatos --

#ifdef NATTUNNELING // NEO: UTCP - [UserModeTCP] -- Xanatos -->
	void	ProcessNat();
	void	AddNatSocket(CNATSocket* toadd);
	void	RemoveNatSocket(CNATSocket* todel);
	CNATSocket* FindNatSocket(uint32 natIP, uint16 natPort);
#endif //NATTUNNELING // NEO: UTCP END <-- Xanatos --

protected:
	friend class CClientReqSocket; // NEO: MOD - [CodeImprovement] <-- Xanatos --

	bool	ProcessPacket(const BYTE* packet, UINT size, uint8 opcode, uint32 ip, uint16 port);
	bool	ProcessModPacket(const BYTE* packet, UINT size, uint8 opcode, uint32 ip, uint16 port); // NEO: NMP - [NeoModProt] <-- Xanatos --

	virtual void	OnSend(int nErrorCode);	
	virtual void	OnReceive(int nErrorCode);

	// NEO: NDBT - [NeoDownloadBandwidthThrottler] -- Xanatos -->
	void	ProcessReceivedData(BYTE* buffer, int length, SOCKADDR_IN &sockAddr, DWORD dwError);
#ifdef NEO_DBT 
	uint16	m_pendingPackets;
	CTypedPtrList<CPtrList, CReceiveData*> downloaddata_queue;
    CCriticalSection2 receiveLocker; // NEO: ND - [NeoDebug]
#endif // NEO_DBT 
	// NEO: NDBT END <-- Xanatos --
#ifdef NEO_UBT // NEO: NUBT - [NeoUploadBandwidthThrottler] -- Xanatos -->
	POSITION lastPriorityPacket;
#endif // NEO_UBT // NEO: NUBT END <-- Xanatos --

private:
	int		SendTo(char* lpBuf,int nBufLen,uint32 dwIP, uint16 nPort);
    bool	IsBusy() const { return m_bWouldBlock; }
	bool	m_bWouldBlock;
	uint16	m_port;
	MyUPnP::UPNPNAT_MAPPING* mapping; // NEO: UPNP - [UPnPNat] <-- Xanatos --

	CTypedPtrList<CPtrList, UDPPack*> controlpacket_queue;

    CCriticalSection2 sendLocker; // ZZ:UploadBandWithThrottler (UDP) // NEO: ND - [NeoDebug] <-- Xanatos --

#ifdef NATTUNNELING // NEO: UTCP - [UserModeTCP] -- Xanatos -->
	CTypedPtrList<CPtrList, CNATSocket*> nat_socket_list;
#endif //NATTUNNELING // NEO: UTCP END <-- Xanatos --

};
