//this file is part of eMule
//Copyright (C)2002-2006 Merkur ( strEmail.Format("%s@%s", "devteam", "emule-project.net") / http://www.emule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#include "stdafx.h"
#include "emule.h"
#include "SearchDlg.h"
#include "PPgTweaksMod1.h"
#include "Preferences.h"
#include "OtherFunctions.h"
#include "emuledlg.h"
#include "HelpIDs.h"
#include "Log.h"
#include "UserMsgs.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

///////////////////////////////////////////////////////////////////////////////
// CPPgTweaksMod1 dialog

IMPLEMENT_DYNAMIC(CPPgTweaksMod1, CPropertyPage)

BEGIN_MESSAGE_MAP(CPPgTweaksMod1, CPropertyPage)
	ON_WM_HSCROLL()
	ON_WM_DESTROY()
	ON_MESSAGE(UM_TREEOPTSCTRL_NOTIFY, OnTreeOptsCtrlNotify)
	ON_WM_HELPINFO()
END_MESSAGE_MAP()

CPPgTweaksMod1::CPPgTweaksMod1()
	: CPropertyPage(CPPgTweaksMod1::IDD)
	, m_ctrlTreeOptions(theApp.m_iDfltImageListColorFlags)
{
	m_bInitializedTreeOpts = false;

	SetNull();
}

CPPgTweaksMod1::~CPPgTweaksMod1(){}
void CPPgTweaksMod1::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_PP_OPTS, m_ctrlTreeOptions);

	if (!m_bInitializedTreeOpts)
	{
		//>> pP: SourceDrops
		int iImgDrop  = 8;
		int iImgNNS   = 8;
		int iImgFQ    = 8;
		int iImgHQR   = 8;
		int iImgUNK   = 8;
		int iImgTM    = 8;
		//<< pP: SourceDrops
		int iImgAHL	  = 8;
		int iImgReask = 8; //>> pP: ReaskAfterChangedIP [Stulle]
		int	iImgSLS	  = 8; //>> pP: SaveLoadSources [enkeyDEV]

		CImageList* piml = m_ctrlTreeOptions.GetImageList(TVSIL_NORMAL);
		if (piml)
		{
			//>> pP: SourceDrops
			iImgDrop  = piml->Add(CTempIconLoader(L"ICON_DROP"));
			iImgNNS   = piml->Add(CTempIconLoader(L"ICON_DROPNNS"));
			iImgFQ    = piml->Add(CTempIconLoader(L"ICON_DROPFQ"));
			iImgHQR   = piml->Add(CTempIconLoader(L"ICON_DROPHQR"));
			iImgUNK   = piml->Add(CTempIconLoader(L"ICON_DROPUNK"));
			iImgTM    = piml->Add(CTempIconLoader(L"ICON_DROPTM"));
			//<< pP: SourceDrops
			iImgAHL	  = piml->Add(CTempIconLoader(L"TWEAK"));
			iImgReask = piml->Add(CTempIconLoader(L"REASKSROURCES")); //>> pP: ReaskAfterChangedIP [Stulle]
			iImgSLS	  = piml->Add(CTempIconLoader(L"SLS"));		   //>> pP: SaveLoadSources [enkeyDEV]
		}

		//>> pP: ReaskAfterChangedIP [Stulle]
		m_htiReaskGrp     = m_ctrlTreeOptions.InsertGroup(GetResString(IDS_CONCHECK7), iImgReask, TVI_ROOT);
		m_htiReaskSources = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_CONCHECK8), m_htiReaskGrp, m_bReaskSources);
		m_htiInformQueue  = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_CONCHECK9), m_htiReaskGrp, m_bInformQueue);
		// ==> Timer for ReAsk File Sources - Stulle
		//m_htiReAskFileSrc = m_ctrlTreeOptions.InsertItem(thePrefs.ResCon(10), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiReaskGrp);
		//m_ctrlTreeOptions.AddEditBox(m_htiReAskFileSrc, RUNTIME_CLASS(CNumTreeOptionsEdit));
		// <== Timer for ReAsk File Sources - Stulle
		//<< pP: ReaskAfterChangedIP [Stulle]

		//>> pP: SLS
		m_htiSLS = m_ctrlTreeOptions.InsertGroup(GetResString(IDS_SLSLABEL), iImgSLS, TVI_ROOT);
		m_htiUseSLS = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_SLSCHECKLABEL), m_htiSLS, m_bUseSaveLoadSources);
		m_htiSLSlimit = m_ctrlTreeOptions.InsertItem(GetResString(IDS_SLSACTIVATIONLABEL), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiSLS);
		m_ctrlTreeOptions.AddEditBox(m_htiSLSlimit, RUNTIME_CLASS(CNumTreeOptionsEdit));
		m_htiSLSnumber = m_ctrlTreeOptions.InsertItem(GetResString(IDS_SLSSAVEVALUE), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiSLS);
		m_ctrlTreeOptions.AddEditBox(m_htiSLSnumber, RUNTIME_CLASS(CNumTreeOptionsEdit));
		//<< pP: SLS

		//>> pP: AutoHL
		m_htiAutoHL_Group = m_ctrlTreeOptions.InsertGroup(GetResString(IDS_AHL0), iImgAHL, TVI_ROOT);
		m_htiAutoHL_Enabled = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_AHL1), m_htiAutoHL_Group, m_bAutoHL_Enabled);
		m_htiAutoHL_OptGrp = m_ctrlTreeOptions.InsertGroup(RemoveAmbersand(GetResString(IDS_EM_PREFS)), iImgAHL, m_htiAutoHL_Group);
		m_htiAutoHL_MaxFiles = m_ctrlTreeOptions.InsertItem(GetResString(IDS_AHL2), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiAutoHL_OptGrp);
		m_ctrlTreeOptions.AddEditBox(m_htiAutoHL_MaxFiles, RUNTIME_CLASS(CNumTreeOptionsEdit));
		m_htiAutoHL_MinFiles = m_ctrlTreeOptions.InsertItem(GetResString(IDS_AHL3), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiAutoHL_OptGrp);
		m_ctrlTreeOptions.AddEditBox(m_htiAutoHL_MinFiles, RUNTIME_CLASS(CNumTreeOptionsEdit));
		m_htiAutoHL_Time = m_ctrlTreeOptions.InsertItem(GetResString(IDS_AHL4), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiAutoHL_OptGrp);
		m_ctrlTreeOptions.AddEditBox(m_htiAutoHL_Time, RUNTIME_CLASS(CNumTreeOptionsEdit));
		m_htiAutoHL_UseDrop = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_AHL5), m_htiAutoHL_OptGrp, m_bAutoHL_UseDrop);
		//<< pP: AutoHL

		//>> pP: SourceDrops
		//groups
		m_htiDropGrp = m_ctrlTreeOptions.InsertGroup(GetResString(IDS_DROP0), iImgDrop, TVI_ROOT);
		m_htiNNSGrp  = m_ctrlTreeOptions.InsertGroup(GetResString(IDS_NONEEDEDPARTS), iImgNNS, m_htiDropGrp);
		m_htiFQGrp   = m_ctrlTreeOptions.InsertGroup(GetResString(IDS_QUEUEFULL), iImgFQ, m_htiDropGrp);
		m_htiHQRGrp = m_ctrlTreeOptions.InsertGroup(GetResString(IDS_DROP1), iImgHQR, m_htiDropGrp);
		m_htiUNKGrp  = m_ctrlTreeOptions.InsertGroup(GetResString(IDS_UNKNOWN), iImgUNK, m_htiDropGrp);
		m_htiTMGrp = m_ctrlTreeOptions.InsertGroup(GetResString(IDS_DROP6), iImgTM, m_htiDropGrp);

		//nns
		m_htiDropNNS = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_DROP5), m_htiNNSGrp, m_bDropNNS);
		m_htiDropNNSTime = m_ctrlTreeOptions.InsertItem(GetResString(IDS_DROP2), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiNNSGrp);
		m_ctrlTreeOptions.AddEditBox(m_htiDropNNSTime, RUNTIME_CLASS(CNumTreeOptionsEdit));
		//fq
		m_htiDropFQ  = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_DROP5), m_htiFQGrp, m_bDropFQ);
		m_htiDropFQTime = m_ctrlTreeOptions.InsertItem(GetResString(IDS_DROP2), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiFQGrp);
		m_ctrlTreeOptions.AddEditBox(m_htiDropFQTime, RUNTIME_CLASS(CNumTreeOptionsEdit));
		//hqr
		m_htiDropHQR = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_DROP5), m_htiHQRGrp, m_bDropHQR);
		m_htiDropHQRTime = m_ctrlTreeOptions.InsertItem(GetResString(IDS_DROP2), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiHQRGrp);
		m_ctrlTreeOptions.AddEditBox(m_htiDropHQRTime, RUNTIME_CLASS(CNumTreeOptionsEdit));
		m_htiDropHQRLimit = m_ctrlTreeOptions.InsertItem(GetResString(IDS_DROP3), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiHQRGrp);
		m_ctrlTreeOptions.AddEditBox(m_htiDropHQRLimit, RUNTIME_CLASS(CNumTreeOptionsEdit));
		//unk
		m_htiDropUNK = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_DROP5), m_htiUNKGrp, m_bDropUNK);
		m_htiDropUNKTime = m_ctrlTreeOptions.InsertItem(GetResString(IDS_DROP2), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiUNKGrp);
		m_ctrlTreeOptions.AddEditBox(m_htiDropUNKTime, RUNTIME_CLASS(CNumTreeOptionsEdit));
		//tm
		m_htiDropTM = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_DROP5), m_htiTMGrp, m_bDropTM);
		m_htiDropTMTime = m_ctrlTreeOptions.InsertItem(GetResString(IDS_DROP2), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiTMGrp);
		m_ctrlTreeOptions.AddEditBox(m_htiDropTMTime, RUNTIME_CLASS(CNumTreeOptionsEdit));

		//misc
		m_htiDropBR   = m_ctrlTreeOptions.InsertCheckBox(L"Drop blocking Clients", m_htiDropGrp, m_bDropBR); //>> pP: Drop Blocking Clients [XRay]
		m_htiLogDrops = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_DROP4), m_htiDropGrp, m_bLogDrops);
//		m_htiDropLimit = m_ctrlTreeOptions.InsertItem(GetResString(IDS_DROP7), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiDropGrp);
//		m_ctrlTreeOptions.AddEditBox(m_htiDropLimit, RUNTIME_CLASS(CNumTreeOptionsEdit));
		//<< pP: SourceDrops


		// expand/collapse
		m_ctrlTreeOptions.Expand(m_htiDropGrp, TVE_EXPAND);
/*
		m_ctrlTreeOptions.Expand(m_htiNNSGrp,  TVE_EXPAND);
		m_ctrlTreeOptions.Expand(m_htiFQGrp,   TVE_EXPAND);
		m_ctrlTreeOptions.Expand(m_htiHQRGrp,  TVE_EXPAND);
		m_ctrlTreeOptions.Expand(m_htiUNKGrp,  TVE_EXPAND);
		m_ctrlTreeOptions.Expand(m_htiTMGrp,   TVE_EXPAND);
*/
		m_ctrlTreeOptions.Expand(m_htiAutoHL_Group, TVE_EXPAND);
		m_ctrlTreeOptions.Expand(m_htiReaskGrp, TVE_EXPAND);
		m_ctrlTreeOptions.Expand(m_htiSLS, TVE_EXPAND);

        m_ctrlTreeOptions.SendMessage(WM_VSCROLL, SB_TOP);
        m_bInitializedTreeOpts = true;
	}

	//>> pP: SLS
	DDX_TreeCheck(pDX, IDC_PP_OPTS, m_htiUseSLS, m_bUseSaveLoadSources);
	DDX_TreeEdit(pDX, IDC_PP_OPTS, m_htiSLSlimit, m_iSLSlimit);
	DDV_MinMaxInt(pDX, m_iSLSlimit, 1, 200);
	DDX_TreeEdit(pDX, IDC_PP_OPTS, m_htiSLSnumber, m_iSLSnumber);
	DDV_MinMaxInt(pDX, m_iSLSnumber, 1, 100);
	//<< pP: SLS

	//>> pP: ReaskAfterChangedIP [Stulle]
	DDX_TreeCheck(pDX, IDC_PP_OPTS, m_htiInformQueue, m_bInformQueue);
	DDX_TreeCheck(pDX, IDC_PP_OPTS, m_htiReaskSources, m_bReaskSources);
	//<< pP: ReaskAfterChangedIP [Stulle]
	// ==> Timer for ReAsk File Sources - Stulle
	//DDX_TreeEdit(pDX, IDC_PP_OPTS, m_htiReAskFileSrc, m_iReAskFileSrc);
	//DDV_MinMaxInt(pDX, m_iReAskFileSrc, 29, 55);
	// <== Timer for ReAsk File Sources - Stulle

	//>> pP: SourceDrops
	DDX_TreeCheck(pDX, IDC_PP_OPTS, m_htiDropNNS, m_bDropNNS);
	DDX_TreeEdit( pDX, IDC_PP_OPTS, m_htiDropNNSTime, m_iDropNNSTime);
	DDV_MinMaxInt(pDX, m_iDropNNSTime, 15, 255);
	DDX_TreeCheck(pDX, IDC_PP_OPTS, m_htiDropFQ, m_bDropFQ);
	DDX_TreeEdit( pDX, IDC_PP_OPTS, m_htiDropFQTime, m_iDropFQTime);
	DDV_MinMaxInt(pDX, m_iDropFQTime, 15, 255);
	DDX_TreeCheck(pDX, IDC_PP_OPTS, m_htiDropHQR, m_bDropHQR);
	DDX_TreeEdit( pDX, IDC_PP_OPTS, m_htiDropHQRTime, m_iDropHQRTime);
	DDV_MinMaxInt(pDX, m_iDropHQRTime, 15, 255);
	DDX_TreeEdit( pDX, IDC_PP_OPTS, m_htiDropHQRLimit, m_iDropHQRLimit);
	//DDV_MinMaxInt(pDX, m_iDropHQRLimit, 1, INT_MAX);
	DDX_TreeCheck(pDX, IDC_PP_OPTS, m_htiDropUNK, m_bDropUNK);
	DDX_TreeEdit( pDX, IDC_PP_OPTS, m_htiDropUNKTime, m_iDropUNKTime);
	DDV_MinMaxInt(pDX, m_iDropUNKTime, 15, 255);
	DDX_TreeCheck(pDX, IDC_PP_OPTS, m_htiDropTM, m_bDropTM);
	DDX_TreeEdit( pDX, IDC_PP_OPTS, m_htiDropTMTime, m_iDropTMTime);
	DDV_MinMaxInt(pDX, m_iDropTMTime, 15, 255);
	DDX_TreeCheck(pDX, IDC_PP_OPTS, m_htiDropBR, m_bDropBR);
	DDX_TreeCheck(pDX, IDC_PP_OPTS, m_htiLogDrops, m_bLogDrops);
//	DDX_TreeEdit( pDX, IDC_PP_OPTS, m_htiDropLimit, m_iDropLimit);
//	DDV_MinMaxInt(pDX, m_iDropLimit, 25, 1000);
	//<< pP: SourceDrops

	//>> pP: AutoHL
	DDX_TreeCheck(pDX, IDC_PP_OPTS, m_htiAutoHL_Enabled, m_bAutoHL_Enabled);
	DDX_TreeCheck(pDX, IDC_PP_OPTS, m_htiAutoHL_UseDrop, m_bAutoHL_UseDrop);
	DDX_TreeEdit(pDX, IDC_PP_OPTS, m_htiAutoHL_MaxFiles, m_uAutoHL_MaxFiles);
	DDV_MinMaxInt(pDX, m_uAutoHL_MaxFiles, 1, INT_MAX);
	DDX_TreeEdit(pDX, IDC_PP_OPTS, m_htiAutoHL_MinFiles, m_uAutoHL_MinFiles);
	DDV_MinMaxInt(pDX, m_uAutoHL_MinFiles, 1, INT_MAX);
	DDX_TreeEdit(pDX, IDC_PP_OPTS, m_htiAutoHL_Time, m_uAutoHL_Time);
	DDV_MinMaxInt(pDX, m_uAutoHL_Time, 3, 240);
	//<< pP: AutoHL
}

BOOL CPPgTweaksMod1::OnInitDialog()
{
	//>> pP: ReaskAfterChangedIP [Stulle]
	m_bReaskSources = thePrefs.GetRASAIPC();
	m_bInformQueue  = thePrefs.GetIQCAOC();
	//<< pP: ReaskAfterChangedIP [Stulle]
	//m_iReAskFileSrc = thePrefs.GetReAskTimeDif(); // Timer for ReAsk File Sources - Stulle

	//>> pP: SLS
	m_bUseSaveLoadSources = thePrefs.UseSaveLoadSources();
	m_iSLSlimit = thePrefs.GetActivationLimitSLS();
	m_iSLSnumber = thePrefs.GetSourcesToSaveSLS();
	//<< pP: SLS

	//>> pP: AutoHL
	m_bAutoHL_Enabled  = thePrefs.GetAutoHL_Enabled();
	m_bAutoHL_UseDrop  = thePrefs.GetAutoHL_UseDrop();
	m_uAutoHL_MaxFiles = thePrefs.GetAutoHL_MaxFiles();
	m_uAutoHL_MinFiles = thePrefs.GetAutoHL_MinFiles();
	m_uAutoHL_Time	   = thePrefs.GetAutoHL_Time();
	//<< pP: AutoHL

	//>> pP: SourceDrops
	m_bDropNNS      = thePrefs.GetDropNoNeededSources_AutoEnabled();
	m_iDropNNSTime  = thePrefs.GetDropNoNeededSources_AutoDelay();
	m_bDropFQ       = thePrefs.GetDropFullQueueSources_AutoEnabled();
	m_iDropFQTime   = thePrefs.GetDropFullQueueSources_AutoDelay();
	m_bDropHQR      = thePrefs.GetDropTooHighRQR_AutoEnabled();
	m_iDropHQRTime  = thePrefs.GetDropTooHighRQR_AutoDelay();
	m_iDropHQRLimit = thePrefs.GetDropTooHighRQR_Limit();
	m_bDropUNK      = thePrefs.GetDropUnknownSources_AutoEnabled();
	m_iDropUNKTime  = thePrefs.GetDropUnknownSources_AutoDelay();
	m_bDropTM       = thePrefs.GetDropTooManyConns_AutoEnabled();
	m_iDropTMTime   = thePrefs.GetDropTooManyConns_AutoDelay();
	m_bDropBR		= thePrefs.GetDropBlockingClients();
	m_bLogDrops     = thePrefs.GetLogDrops();
	//m_iDropLimit	= thePrefs.GetDropSourceLimit();
	//<< pP: SourceDrops

	m_ctrlTreeOptions.SetImageListColorFlags(theApp.m_iDfltImageListColorFlags);
    CPropertyPage::OnInitDialog();
	InitWindowStyles(this);
	m_ctrlTreeOptions.SetItemHeight(m_ctrlTreeOptions.GetItemHeight() + 2);

	return TRUE;  // return TRUE unless you set the focus to a control
				  // EXCEPTION: OCX Property Pages should return FALSE
}

BOOL CPPgTweaksMod1::OnKillActive()
{
	// if prop page is closed by pressing ENTER we have to explicitly commit any possibly pending
	// data from an open edit control
	m_ctrlTreeOptions.HandleChildControlLosingFocus();
	return CPropertyPage::OnKillActive();
}

BOOL CPPgTweaksMod1::OnApply()
{
	// if prop page is closed by pressing ENTER we have to explicitly commit any possibly pending
	// data from an open edit control
	m_ctrlTreeOptions.HandleChildControlLosingFocus();

	if (!UpdateData())
		return FALSE;

	//>> pP: ReaskAfterChangedIP [Stulle]
	thePrefs.SetRASAIPC(m_bReaskSources);
	thePrefs.SetIQCAOC(m_bInformQueue);
	//<< pP: ReaskAfterChangedIP [Stulle]
	//thePrefs.SetReAskTimeDif((uint8)m_iReAskFileSrc); // Timer for ReAsk File Sources - Stulle

	//>> pP: SLS
	thePrefs.SetSaveLoadSource(m_bUseSaveLoadSources);
	thePrefs.SetActivationLimitSLS((uint8)m_iSLSlimit);
	thePrefs.SetSourcesToSaveSLS((uint8)m_iSLSnumber);
	//<< pP: SLS

	//>> pP: SourceDrops
	thePrefs.SetDropNoNeededSources_AutoEnabled(m_bDropNNS);
	thePrefs.SetDropFullQueueSources_AutoEnabled(m_bDropFQ);
	thePrefs.SetDropTooHighRQR_AutoEnabled(m_bDropHQR);
	thePrefs.SetDropUnknownSources_AutoEnabled(m_bDropUNK);
	thePrefs.SetDropTooManyConns_AutoEnabled(m_bDropTM);
	thePrefs.SetDropTooHighRQR_Limit((uint16)m_iDropHQRLimit);
	// nns timer
	bool updatetimer = thePrefs.GetDropNoNeededSources_AutoDelay() != (uint8)m_iDropNNSTime;
	thePrefs.SetDropNoNeededSources_AutoDelay((uint8)m_iDropNNSTime);
	if (updatetimer) thePrefs.SetDropNoNeededSources_AutoNext();
	// fq timer
	updatetimer = thePrefs.GetDropFullQueueSources_AutoDelay() != (uint8)m_iDropFQTime;
	thePrefs.SetDropFullQueueSources_AutoDelay((uint8)m_iDropFQTime);
	if (updatetimer) thePrefs.SetDropFullQueueSources_AutoNext();
	// hqr timer
	updatetimer = thePrefs.GetDropTooHighRQR_AutoDelay() != (uint8)m_iDropHQRTime;
	thePrefs.SetDropTooHighRQR_AutoDelay((uint8)m_iDropHQRTime);
	if (updatetimer) thePrefs.SetDropTooHighRQR_AutoNext();
	// unk timer
	updatetimer = thePrefs.GetDropUnknownSources_AutoDelay() != (uint8)m_iDropUNKTime;
	thePrefs.SetDropUnknownSources_AutoDelay((uint8)m_iDropUNKTime);
	if (updatetimer) thePrefs.SetDropUnknownSources_AutoNext();
	// tm timer
	updatetimer = thePrefs.GetDropTooManyConns_AutoDelay() != (uint8)m_iDropTMTime;
	thePrefs.SetDropTooManyConns_AutoDelay((uint8)m_iDropTMTime);
	if (updatetimer) thePrefs.SetDropTooManyConns_AutoNext();

	thePrefs.SetDropBlockingClients(m_bDropBR);
	//thePrefs.SetDropSourceLimit((uint16)m_iDropLimit);
	thePrefs.SetLogDrops(m_bLogDrops);
	//<< pP: SourceDrops

	//>> pP: AutoHL
	if (m_uAutoHL_Time != thePrefs.GetAutoHL_Time() && thePrefs.GetAutoHL_Delay() > ::GetTickCount()+MIN2MS(m_uAutoHL_Time))
		thePrefs.SetAutoHL_Delay();

	if (thePrefs.GetAutoHL_Enabled() != m_bAutoHL_Enabled)
	{
		thePrefs.SetAutoHL_DelayReset();
		AddModLogLine(L"AutoHL: Reset timer due to settings change.");
	}
	thePrefs.SetAutoHL_Enabled(m_bAutoHL_Enabled);
	thePrefs.SetAutoHL_UseDrop(m_bAutoHL_UseDrop);
	thePrefs.SetAutoHL_MaxFiles((uint16)m_uAutoHL_MaxFiles);
	thePrefs.SetAutoHL_MinFiles((uint16)m_uAutoHL_MinFiles);
	thePrefs.SetAutoHL_Time(    (uint8) m_uAutoHL_Time);
	//<< pP: AutoHL

	//thePrefs.SaveModPrefs(L"ModPrefs1");
	SetModified(FALSE);
	return CPropertyPage::OnApply();
}

//void CPPgTweaksMod1::OnHScroll(UINT /*nSBCode*/, UINT /*nPos*/, CScrollBar* pScrollBar){}
//void CPPgTweaksMod1::Localize(void){if(m_hWnd){;}}

void CPPgTweaksMod1::OnDestroy()
{
	m_ctrlTreeOptions.DeleteAllItems();
	m_ctrlTreeOptions.DestroyWindow();
	m_bInitializedTreeOpts = false;

	SetNull();
    
    CPropertyPage::OnDestroy();
}

LRESULT CPPgTweaksMod1::OnTreeOptsCtrlNotify(WPARAM wParam, LPARAM /*lParam*/)
{
	if (wParam == IDC_PP_OPTS)
		SetModified();

	return 0;
}

void CPPgTweaksMod1::OnHelp(){ShellExecute(NULL, NULL, MOD_FORUMLINK, NULL, thePrefs.GetMuleDirectory(EMULE_EXECUTEABLEDIR), SW_SHOWDEFAULT);}
BOOL CPPgTweaksMod1::OnCommand(WPARAM wParam, LPARAM lParam){if (wParam == ID_HELP){OnHelp();return TRUE;}return __super::OnCommand(wParam, lParam);}
BOOL CPPgTweaksMod1::OnHelpInfo(HELPINFO*){OnHelp();return TRUE;}

void CPPgTweaksMod1::SetNull()
{
	//>> pP: SLS
	m_htiSLS = NULL;
	m_htiUseSLS = NULL;
	m_bUseSaveLoadSources = false;
	m_htiSLSlimit = NULL;
	m_iSLSlimit = 0;
	m_htiSLSnumber = NULL;
	m_iSLSnumber = 0;
	//<< pP: SLS

	//>> pP: AutoHL
	m_htiAutoHL_Group	 = NULL;
	m_htiAutoHL_Enabled  = NULL;
	m_htiAutoHL_UseDrop  = NULL;
	m_htiAutoHL_MaxFiles = NULL;
	m_htiAutoHL_MinFiles = NULL;
	m_htiAutoHL_Time     = NULL;
	m_htiAutoHL_OptGrp   = NULL;
	m_bAutoHL_Enabled	 = 0;
	m_bAutoHL_UseDrop	 = 0;
	m_uAutoHL_MaxFiles	 = 0;
	m_uAutoHL_MinFiles	 = 0;
	m_uAutoHL_Time		 = 0;
	//<<pP: AutoHL

	//>> pP: SourceDrops
	m_htiDropGrp = NULL;
	m_htiNNSGrp = NULL;
	m_htiFQGrp = NULL;
	m_htiHQRGrp = NULL;
	m_htiUNKGrp = NULL;
	m_htiTMGrp = NULL;
	m_htiDropNNS = NULL;
	m_htiDropNNSTime = NULL;
	m_htiDropFQ = NULL;
	m_htiDropFQTime = NULL;
	m_htiDropHQR = NULL;
	m_htiDropHQRTime = NULL;
	m_htiDropHQRLimit = NULL;
	m_htiDropUNK = NULL;
	m_htiDropUNKTime = NULL;
	m_htiDropTM = NULL;
	m_htiDropTMTime = NULL;
	m_bDropNNS = 0;
	m_iDropNNSTime = 0;
	m_bDropFQ = 0;
	m_iDropFQTime = 0;
	m_bDropHQR = 0;
	m_iDropHQRTime = 0;
	m_iDropHQRLimit = 0;
	m_bDropUNK = 0;
	m_iDropUNKTime = 0;
	m_bDropTM = 0;
	m_iDropTMTime = 0;
	m_htiDropBR = NULL;
	m_bDropBR = 0;
	m_htiLogDrops = NULL;
	m_bLogDrops = 0;
	//m_htiDropLimit = NULL;
	//m_iDropLimit = 0;
	//<< pP: SourceDrops

	//>> pP: ReaskAfterChangedIP
	m_htiReaskGrp = NULL;
	m_htiReaskSources = NULL;
	m_htiInformQueue = NULL;
	m_bInformQueue = false;
	m_bReaskSources = false;
	//<< pP: ReaskAfterChangedIP
	m_htiReAskFileSrc = NULL; // Timer for ReAsk File Sources - Stulle
	m_iReAskFileSrc = 0; // Timer for ReAsk File Sources - Stulle
}

void CPPgTweaksMod1::Localize(void)
{
	if (m_hWnd)
	{
		CString str;
		str.Format(L"%s 2 (Mod)", GetResString(IDS_PW_TWEAK));
		SetWindowText(str);

		//>> pP: SLS
		if (m_htiSLS)				m_ctrlTreeOptions.SetItemText(m_htiSLS, GetResString(IDS_SLSLABEL));
		if (m_htiUseSLS)			m_ctrlTreeOptions.SetItemText(m_htiUseSLS, GetResString(IDS_SLSCHECKLABEL));
		if (m_htiSLSlimit)			m_ctrlTreeOptions.SetEditLabel(m_htiSLSlimit, GetResString(IDS_SLSACTIVATIONLABEL));
		if (m_htiSLSnumber)			m_ctrlTreeOptions.SetEditLabel(m_htiSLSnumber, GetResString(IDS_SLSACTIVATIONLABEL));
		//<< pP: SLS

		//>> pP: ReaskAfterChangedIP [Stulle]
		if (m_htiReaskGrp)			m_ctrlTreeOptions.SetItemText(m_htiReaskGrp, GetResString(IDS_CONCHECK7));
		if (m_htiReaskSources)		m_ctrlTreeOptions.SetItemText(m_htiReaskSources, GetResString(IDS_CONCHECK8));
		if (m_htiInformQueue)		m_ctrlTreeOptions.SetItemText(m_htiInformQueue, GetResString(IDS_CONCHECK9));
		//<< pP: ReaskAfterChangedIP [Stulle]
		if (m_htiReAskFileSrc)      m_ctrlTreeOptions.SetItemText(m_htiReAskFileSrc, GetResString(IDS_CONCHECK10));

		//>> pP: AutoHL
		if (m_htiAutoHL_Group)		m_ctrlTreeOptions.SetItemText(m_htiAutoHL_Group, GetResString(IDS_AHL0));
		if (m_htiAutoHL_Enabled)    m_ctrlTreeOptions.SetItemText(m_htiAutoHL_Enabled, GetResString(IDS_AHL1));
		if (m_htiAutoHL_MaxFiles)   m_ctrlTreeOptions.SetEditLabel(m_htiAutoHL_MaxFiles, GetResString(IDS_AHL2));
		if (m_htiAutoHL_MinFiles)   m_ctrlTreeOptions.SetEditLabel(m_htiAutoHL_MinFiles, GetResString(IDS_AHL3));
		if (m_htiAutoHL_Time)		m_ctrlTreeOptions.SetEditLabel(m_htiAutoHL_Time, GetResString(IDS_AHL4));
		if (m_htiAutoHL_UseDrop)    m_ctrlTreeOptions.SetItemText(m_htiAutoHL_UseDrop, GetResString(IDS_AHL5));
		//<< pP: AutoHL

		//>> pP: SourceDrops
		if (m_htiDropGrp)		m_ctrlTreeOptions.SetItemText(m_htiDropGrp,		GetResString(IDS_DROP0));
		if (m_htiNNSGrp)		m_ctrlTreeOptions.SetItemText(m_htiNNSGrp,		GetResString(IDS_NONEEDEDPARTS));
		if (m_htiFQGrp)			m_ctrlTreeOptions.SetItemText(m_htiFQGrp,		GetResString(IDS_QUEUEFULL));
		if (m_htiHQRGrp)		m_ctrlTreeOptions.SetItemText(m_htiHQRGrp,		GetResString(IDS_DROP1));
		if (m_htiUNKGrp)		m_ctrlTreeOptions.SetItemText(m_htiUNKGrp,		GetResString(IDS_UNKNOWN));
		if (m_htiTMGrp)			m_ctrlTreeOptions.SetItemText(m_htiTMGrp,		GetResString(IDS_DROP6));
		if (m_htiDropNNS)		m_ctrlTreeOptions.SetItemText(m_htiDropNNS,		GetResString(IDS_DROP5));
		if (m_htiDropNNSTime)	m_ctrlTreeOptions.SetEditLabel(m_htiDropNNSTime, GetResString(IDS_DROP2));
		if (m_htiDropFQ)		m_ctrlTreeOptions.SetItemText(m_htiDropFQ,		GetResString(IDS_DROP5));
		if (m_htiDropFQTime)	m_ctrlTreeOptions.SetEditLabel(m_htiDropFQTime, GetResString(IDS_DROP2));
		if (m_htiDropHQR)		m_ctrlTreeOptions.SetItemText(m_htiDropHQR,		GetResString(IDS_DROP5));
		if (m_htiDropHQRTime)	m_ctrlTreeOptions.SetEditLabel(m_htiDropHQRTime, GetResString(IDS_DROP2));
		if (m_htiDropHQRLimit)	m_ctrlTreeOptions.SetEditLabel(m_htiDropHQRLimit, GetResString(IDS_DROP3));
		if (m_htiDropUNK)		m_ctrlTreeOptions.SetItemText(m_htiDropUNK,		GetResString(IDS_DROP5));
		if (m_htiDropUNKTime)   m_ctrlTreeOptions.SetEditLabel(m_htiDropUNKTime, GetResString(IDS_DROP2));
		if (m_htiDropTM)		m_ctrlTreeOptions.SetItemText(m_htiDropTM,		GetResString(IDS_DROP5));
		if (m_htiDropTMTime)	m_ctrlTreeOptions.SetEditLabel(m_htiDropTMTime, GetResString(IDS_DROP2));
		if (m_htiLogDrops)		m_ctrlTreeOptions.SetItemText(m_htiLogDrops,	GetResString(IDS_DROP4));
		//if (m_htiDropLimit)		m_ctrlTreeOptions.SetEditLabel(m_htiDropLimit, GetResString(IDS_DROP7));
	}
}