//this file is part of eMule
//Copyright (C)2006 David Xanatos ( Xanatos@Lycos.at / http://neomule.sourceforge.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include "stdafx.h" 
#include "emule.h"
#include "UpDownClient.h"
#include "UserMsgs.h"
#include "ClientCredits.h"
#include "Preferences.h"
#include "AntileechInfo.h"
#include "ClientAnalyzer.h"
#include ".\antileechinfo.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

///////////////////////////////////////////////////////////////////////////////
// CAntileechInfoPage

IMPLEMENT_DYNAMIC(CAntileechInfoPage, CResizablePage)

BEGIN_MESSAGE_MAP(CAntileechInfoPage, CResizablePage)
	ON_MESSAGE(UM_DATA_CHANGED, OnDataChanged)
END_MESSAGE_MAP()

CAntileechInfoPage::CAntileechInfoPage()
	: CResizablePage(CAntileechInfoPage::IDD,0)
{
	m_paClients = NULL;
	m_bDataChanged = false;
	m_strCaption = L"Antileech Info";
	m_psp.pszTitle = m_strCaption;
	m_psp.dwFlags |= PSP_USETITLE;
}

CAntileechInfoPage::~CAntileechInfoPage(){}

void CAntileechInfoPage::DoDataExchange(CDataExchange* pDX)
{
	CResizablePage::DoDataExchange(pDX);
}

BOOL CAntileechInfoPage::OnInitDialog()
{
	CResizablePage::OnInitDialog();
	InitWindowStyles(this);

	Localize();
	return TRUE;
}

BOOL CAntileechInfoPage::OnSetActive()
{
	if (!CResizablePage::OnSetActive())
		return FALSE;

	if (m_bDataChanged)
	{
		CUpDownClient* client = STATIC_DOWNCAST(CUpDownClient, (*m_paClients)[0]);
		if (client && client->GetAntiLeechData())
		{
			GetHashlistOutput(client);
			GetAnalyzerOutput(client);
		}
		m_bDataChanged = false;
	}
	return TRUE;
}

void CAntileechInfoPage::GetAnalyzerOutput(CUpDownClient* client)
{
	CString str = L"";
	HICON hBadUDRatio, hBadUDSessions, hBadNick, hBadMod, hBadScoreCA, hBadScoreOffi, hSpams, hFastXS, hExploit, hReask, hModFake, hFileFake, hModThief, hNickThief  = { theApp.LoadIcon(L"EMPTY", 16, 16) };

	const HICON hEmpty		= theApp.LoadIcon(L"EMPTY", 16, 16);
	const HICON hBad		= theApp.LoadIcon(L"CDA_BAD", 16, 16);
	const HICON hBadGuy		= theApp.LoadIcon(L"BADGUY", 16, 16);
	const HICON hVeryBad	= theApp.LoadIcon(L"VERYBADGUY", 16, 16);

	if (thePrefs.UseCreditSystem()==2)
	{
// username
		//>> pP: FunnyNick
		if (client->GetUserName())
		{
			str = client->GetUserName();
			if (thePrefs.GetDisplayFunnyNick() && client->HasFunnyNick())
				str.AppendFormat(L" (Real: %s)", client->GetUserName(false));

			GetDlgItem(IDC_CDA_FULLUSERNAME)->SetWindowText(str);
		}
		else
			GetDlgItem(IDC_CDA_FULLUSERNAME)->SetWindowText(GetResString(IDS_UNKNOWN));

		if (client->GetIsGPLEvilNick())
			hBadNick = hVeryBad;
		else if (client->GetAntiLeechData()->GetBadForThisSession() & AT_NICKTHIEF)
			hBadNick = hBadGuy;
		else
			hBadNick = hEmpty;
		((CStatic*)GetDlgItem(IDC_CDA_ICON_BADNICK))->SetIcon(hBadNick);
	//>> pP: FunnyNick

// Modname
		GetDlgItem(IDC_CDA_MODNAMEFULL)->SetWindowText(client->DbgGetFullClientSoftVer());

		if (client->GetIsGPLEvilMod()) // todo: add modicon?
			hBadMod = hVeryBad;
		else if (client->GetAntiLeechData()->GetBadForThisSession() & AT_MODTHIEF || client->GetAntiLeechData()->GetBadForThisSession() & AT_MODFAKER)
			hBadMod = hBadGuy;
		else
			hBadMod = hEmpty;
		((CStatic*)GetDlgItem(IDC_CDA_ICON_BADMOD))->SetIcon(hBadMod);

// uploads
		GetDlgItem(IDC_CDA_ULCOMP)->SetWindowText(CastItoXBytes(client->GetAntiLeechData()->GetDownloadedFull(), false, false));
		GetDlgItem(IDC_CDA_ULPART)->SetWindowText(CastItoXBytes(client->GetAntiLeechData()->GetDownloadedPartial(), false, false));
		GetDlgItem(IDC_CDA_ULRARE)->SetWindowText(CastItoXBytes(client->GetAntiLeechData()->GetDownloadedRare(), false, false));
		GetDlgItem(IDC_CDA_ULTOTAL)->SetWindowText(CastItoXBytes(client->GetAntiLeechData()->GetDownloadedTotal(), false, false));

// downloads
		GetDlgItem(IDC_CDA_DLCOMP)->SetWindowText(CastItoXBytes(client->GetAntiLeechData()->GetUploadedFull(), false, false));
		GetDlgItem(IDC_CDA_DLPART)->SetWindowText(CastItoXBytes(client->GetAntiLeechData()->GetUploadedPartial(), false, false));
		GetDlgItem(IDC_CDA_DLRARE)->SetWindowText(CastItoXBytes(client->GetAntiLeechData()->GetUploadedRare(), false, false));
		GetDlgItem(IDC_CDA_DLTOTAL)->SetWindowText(CastItoXBytes(client->GetAntiLeechData()->GetUploadedTotal(), false, false));

// ud ratio
		uint64 chunksDL =  (uint64)((double)client->GetAntiLeechData()->GetDownloadedTotal()/PARTSIZE + AT_ROUNDOFFSET);
		uint64 chunksUL =  (uint64)((double)client->GetAntiLeechData()->GetUploadedTotal()/PARTSIZE + AT_ROUNDOFFSET);
/*
		if (!chunksUL && !chunksDL)
			str = L"";
		if(chunksDL < chunksUL)
			str = GetResString(IDS_CDA_BAD);
		else
			str = GetResString(IDS_CDA_GOOD);
	
		//str.AppendFormat(L" CA: %s (%.2f)", thePrefs.UseCreditSystem()==2 ? L"on" : L"off", client->GetAntiLeechData()->GetScore());
		GetDlgItem(IDC_CDA_UDRATING)->SetWindowText(str);
*/
		if(chunksDL < chunksUL)
			hBadUDRatio = hBad;
		else
			hBadUDRatio = hEmpty;
		((CStatic*)GetDlgItem(IDC_CDA_ICON_UDRATIO))->SetIcon(hBadUDRatio);
		str.Format(L"%I64u/%I64u", chunksUL, chunksDL);
		GetDlgItem(IDC_CDA_UDCHUNKS)->SetWindowText(str);

// scores
		str.Format(L"%.2f (Analyzer)", client->GetAntiLeechData()->GetScore());
		GetDlgItem(IDC_CDA_SCORES_CA)->SetWindowText(str);
		if (client->GetAntiLeechData()->GetScore() < 1.0f)
			hBadScoreCA = hBad;
		else
			hBadScoreCA = hEmpty;
		((CStatic*)GetDlgItem(IDC_CDA_ICON_SCORECA))->SetIcon(hBadScoreCA);

		str.Format(L"%.2f (Official)", client->Credits()->GetScoreRatio(client->GetIP()));
		GetDlgItem(IDC_CDA_SCORES_OFFI)->SetWindowText(str);
		if (client->Credits()->GetScoreRatio(client->GetIP()) <= 1.0f) // Note: 1.0 Is not really bad, but the starter score. 
			hBadScoreOffi = hBad;
		else
			hBadScoreOffi = hEmpty;
		((CStatic*)GetDlgItem(IDC_CDA_ICON_SCOREOFFI))->SetIcon(hBadScoreOffi);

// failed ul/dl
		if (client->GetAntiLeechData()->GetBadULSessions() || client->GetAntiLeechData()->GetBadDLSessions())
		{
			str.Format(L"%u/%u", client->GetAntiLeechData()->GetBadULSessions(), client->GetAntiLeechData()->GetBadDLSessions());
			hBadUDSessions = hBad;
		}
		else
		{
			str = GetResString(IDS_CDA_NONE);
			hBadUDSessions = hEmpty;
		}
		GetDlgItem(IDC_CDA_FAILED)->SetWindowText(str);
		((CStatic*)GetDlgItem(IDC_CDA_ICON_FAILEDUD))->SetIcon(hBadUDSessions);

// behaviour
		if (client->GetAntiLeechData()->GetBadForThisSession() & AT_NICKTHIEF)
		{
			GetDlgItem(IDC_CDA_NICKTHIEFINFO)->SetWindowText(GetResString(IDS_YES));
			hNickThief = hBad;
		}
		else
		{
			GetDlgItem(IDC_CDA_NICKTHIEFINFO)->SetWindowText(GetResString(IDS_NO));
			hNickThief = hEmpty;
		}
		((CStatic*)GetDlgItem(IDC_CDA_ICON_NICKTHIEF))->SetIcon(hNickThief);

		if (client->GetAntiLeechData()->GetBadForThisSession() & AT_MODTHIEF)
		{
			GetDlgItem(IDC_CDA_MODTHIEFINFO)->SetWindowText(GetResString(IDS_YES));
			hModThief = hBad;
		}
		else
		{
			GetDlgItem(IDC_CDA_MODTHIEFINFO)->SetWindowText(GetResString(IDS_NO));
			hModThief = hEmpty;
		}
		((CStatic*)GetDlgItem(IDC_CDA_ICON_MODTHIEF))->SetIcon(hModThief);
	
		if (client->GetAntiLeechData()->GetBadForThisSession() & AT_MODFAKER)
		{
			GetDlgItem(IDC_CDA_MODFAKERINFO)->SetWindowText(GetResString(IDS_YES));
			hModFake = hBad;
		}
		else
		{
			GetDlgItem(IDC_CDA_MODFAKERINFO)->SetWindowText(GetResString(IDS_NO));
			hModFake = hEmpty;
		}
		((CStatic*)GetDlgItem(IDC_CDA_ICON_MODFAKE))->SetIcon(hModFake);
	
		if (client->GetAntiLeechData()->GetBadForThisSession() & AT_UDPFNFFAKER)
		{
			GetDlgItem(IDC_CDA_FILEFAKERINFO)->SetWindowText(GetResString(IDS_YES));
			hFileFake = hBad;
		}
		else
		{
			GetDlgItem(IDC_CDA_FILEFAKERINFO)->SetWindowText(GetResString(IDS_NO));
			hFileFake = hEmpty;
		}
		((CStatic*)GetDlgItem(IDC_CDA_ICON_FILEFAKE))->SetIcon(hFileFake);

		if (client->GetAntiLeechData()->GetSpams())
		{
			str.Format(L"%u", client->GetAntiLeechData()->GetSpams());
			hSpams = hBad;
		}
		else
		{
			str = GetResString(IDS_CDA_NONE);
			hSpams = hEmpty;
		}
		GetDlgItem(IDC_CDA_SPAMMERINFO)->SetWindowText(str);
		((CStatic*)GetDlgItem(IDC_CDA_ICON_SPAMS))->SetIcon(hSpams);

		if (client->GetAntiLeechData()->GetFastXSAsks())
		{
			str.Format(L"%u", client->GetAntiLeechData()->GetFastXSAsks());
			hFastXS = hBad;
		}
		else
		{
			str = GetResString(IDS_CDA_NONE);
			hFastXS = hEmpty;
		}
		GetDlgItem(IDC_CDA_FASTXSINFO)->SetWindowText(str);
		((CStatic*)GetDlgItem(IDC_CDA_ICON_FASTXS))->SetIcon(hFastXS);

		if(client->GetAntiLeechData()->IsXSExploiter())
		{
			str.Format(L"%u | %u", client->GetAntiLeechData()->GetXSAsks(), client->GetAntiLeechData()->GetXSAnsw());
			hExploit = hBad;
		}
		else
		{
			str = GetResString(IDS_CDA_NONE);
			hExploit = hEmpty;
		}
		GetDlgItem(IDC_CDA_XSEXPLOITINFO)->SetWindowText(str);
		((CStatic*)GetDlgItem(IDC_CDA_ICON_EXPLOIT))->SetIcon(hExploit);

		if (client->GetAntiLeechData()->GetReaskCount() && client->GetAntiLeechData()->GetAvgReaskTime() < FILEREASKTIME)
		{
			str.Format(L"%u @ %s avg", client->GetAntiLeechData()->GetReaskCount(), CastSecondsToHM(client->GetAntiLeechData()->GetAvgReaskTime()/1000));
			hReask = hBad;
		}
		else
		{
			str = GetResString(IDS_CDA_NONE);
			hReask = hEmpty;
		}
		GetDlgItem(IDC_CDA_REASKINFO)->SetWindowText(str);
		((CStatic*)GetDlgItem(IDC_CDA_ICON_REASK))->SetIcon(hReask);

// group icons
		HICON hClient;
		if(client->IsFriend())
			hClient = theApp.LoadIcon(_T("FRIEND"), 16, 16);
		else
			hClient = theApp.LoadIcon(_T("STATSCLIENTS"), 16, 16);
		((CStatic*)GetDlgItem(IDC_CDA_CLIENTICON))->SetIcon(hClient);

		HICON hTranfer;
		if (chunksUL > 0 && chunksDL > 0)
			hTranfer = theApp.LoadIcon(_T("UP1DOWN1"), 16, 16);
		else if (chunksDL > 0)
			hTranfer = theApp.LoadIcon(_T("UP0DOWN1"), 16, 16);
		else if (chunksUL > 0)
			hTranfer = theApp.LoadIcon(_T("UP1DOWN0"), 16, 16);
		else
			hTranfer = theApp.LoadIcon(_T("UP0DOWN0"), 16, 16);
		((CStatic*)GetDlgItem(IDC_CDA_TRANSICON))->SetIcon(hTranfer);

		HICON hBehave; // could be simplified if no "bad" state gets added
		hBehave = theApp.LoadIcon(_T("SRCUNKNOWN"), 16, 16);
		((CStatic*)GetDlgItem(IDC_CDA_BEHAVEICON))->SetIcon(hBehave);
	}
	else
	{
// nothing stored/CA off
		// CA state
		str = L"ClientAnalyzer is disabled!";
		GetDlgItem(IDC_CDA_CA_INFO)->SetWindowText(str);

		GetDlgItem(IDC_CDA_FULLUSERNAME)->SetWindowText(L"-");
		GetDlgItem(IDC_CDA_MODNAMEFULL)->SetWindowText(L"-");
		GetDlgItem(IDC_CDA_ULCOMP)->SetWindowText(L"-");
		GetDlgItem(IDC_CDA_ULPART)->SetWindowText(L"-");
		GetDlgItem(IDC_CDA_ULRARE)->SetWindowText(L"-");
		GetDlgItem(IDC_CDA_ULTOTAL)->SetWindowText(L"-");
		GetDlgItem(IDC_CDA_DLCOMP)->SetWindowText(L"-");
		GetDlgItem(IDC_CDA_DLPART)->SetWindowText(L"-");
		GetDlgItem(IDC_CDA_DLRARE)->SetWindowText(L"-");
		GetDlgItem(IDC_CDA_DLTOTAL)->SetWindowText(L"-");
		GetDlgItem(IDC_CDA_UDCHUNKS)->SetWindowText(L"-");
		GetDlgItem(IDC_CDA_UDRATING)->SetWindowText(L"-");
		GetDlgItem(IDC_CDA_FAILED)->SetWindowText(L"");
		GetDlgItem(IDC_CDA_NICKTHIEFINFO)->SetWindowText(L"-");
		GetDlgItem(IDC_CDA_MODTHIEFINFO)->SetWindowText(L"-");
		GetDlgItem(IDC_CDA_MODFAKERINFO)->SetWindowText(L"-");
		GetDlgItem(IDC_CDA_FILEFAKERINFO)->SetWindowText(L"-");
		GetDlgItem(IDC_CDA_SPAMMERINFO)->SetWindowText(L"-");
		GetDlgItem(IDC_CDA_FASTXSINFO)->SetWindowText(L"-");
		GetDlgItem(IDC_CDA_XSEXPLOITINFO)->SetWindowText(L"-");
		GetDlgItem(IDC_CDA_REASKINFO)->SetWindowText(L"-");
		GetDlgItem(IDC_CDA_SCORES)->SetWindowText(L"-");
		GetDlgItem(IDC_CDA_SCORES_CA)->SetWindowText(L"-");
		GetDlgItem(IDC_CDA_SCORES_OFFI)->SetWindowText(L"-");

		((CStatic*)GetDlgItem(IDC_CDA_BEHAVEICON))->SetIcon(hEmpty);
		((CStatic*)GetDlgItem(IDC_CDA_TRANSICON))->SetIcon(hEmpty);
		((CStatic*)GetDlgItem(IDC_CDA_CLIENTICON))->SetIcon(hEmpty);
//
		((CStatic*)GetDlgItem(IDC_CDA_ICON_BADNICK))->SetIcon(hEmpty);
		((CStatic*)GetDlgItem(IDC_CDA_ICON_BADMOD))->SetIcon(hEmpty);
		((CStatic*)GetDlgItem(IDC_CDA_ICON_UDRATIO))->SetIcon(hEmpty);
		((CStatic*)GetDlgItem(IDC_CDA_ICON_SCORECA))->SetIcon(hEmpty);
		((CStatic*)GetDlgItem(IDC_CDA_ICON_SCOREOFFI))->SetIcon(hEmpty);
		((CStatic*)GetDlgItem(IDC_CDA_ICON_FAILEDUD))->SetIcon(hEmpty);
		((CStatic*)GetDlgItem(IDC_CDA_ICON_NICKTHIEF))->SetIcon(hEmpty);
		((CStatic*)GetDlgItem(IDC_CDA_ICON_MODTHIEF))->SetIcon(hEmpty);
		((CStatic*)GetDlgItem(IDC_CDA_ICON_MODTHIEF))->SetIcon(hEmpty);
		((CStatic*)GetDlgItem(IDC_CDA_ICON_MODFAKE))->SetIcon(hEmpty);
		((CStatic*)GetDlgItem(IDC_CDA_ICON_FILEFAKE))->SetIcon(hEmpty);
		((CStatic*)GetDlgItem(IDC_CDA_ICON_SPAMS))->SetIcon(hEmpty);
		((CStatic*)GetDlgItem(IDC_CDA_ICON_FASTXS))->SetIcon(hEmpty);
		((CStatic*)GetDlgItem(IDC_CDA_ICON_EXPLOIT))->SetIcon(hEmpty);
		((CStatic*)GetDlgItem(IDC_CDA_ICON_REASK))->SetIcon(hEmpty);
	}

	bool b = (thePrefs.UseCreditSystem()==2);
	GetDlgItem(IDC_CDA_FULLUSERNAME)->EnableWindow(b);
	GetDlgItem(IDC_CDA_MODNAMEFULL)->EnableWindow(b);
	GetDlgItem(IDC_CDA_ULCOMP)->EnableWindow(b);
	GetDlgItem(IDC_CDA_ULPART)->EnableWindow(b);
	GetDlgItem(IDC_CDA_ULRARE)->EnableWindow(b);
	GetDlgItem(IDC_CDA_ULTOTAL)->EnableWindow(b);
	GetDlgItem(IDC_CDA_DLCOMP)->EnableWindow(b);
	GetDlgItem(IDC_CDA_DLPART)->EnableWindow(b);
	GetDlgItem(IDC_CDA_DLRARE)->EnableWindow(b);
	GetDlgItem(IDC_CDA_DLTOTAL)->EnableWindow(b);
	GetDlgItem(IDC_CDA_UDCHUNKS)->EnableWindow(b);
	GetDlgItem(IDC_CDA_UDRATING)->EnableWindow(b);
	GetDlgItem(IDC_CDA_FAILED)->EnableWindow(b);
	GetDlgItem(IDC_CDA_NICKTHIEFINFO)->EnableWindow(b);
	GetDlgItem(IDC_CDA_MODTHIEFINFO)->EnableWindow(b);
	GetDlgItem(IDC_CDA_MODFAKERINFO)->EnableWindow(b);
	GetDlgItem(IDC_CDA_FILEFAKERINFO)->EnableWindow(b);
	GetDlgItem(IDC_CDA_SPAMMERINFO)->EnableWindow(b);
	GetDlgItem(IDC_CDA_FASTXSINFO)->EnableWindow(b);
	GetDlgItem(IDC_CDA_XSEXPLOITINFO)->EnableWindow(b);
	GetDlgItem(IDC_CDA_REASKINFO)->EnableWindow(b);
	GetDlgItem(IDC_CDA_SCORES)->EnableWindow(b);
	GetDlgItem(IDC_CDA_SCORES_CA)->EnableWindow(b);
	GetDlgItem(IDC_CDA_SCORES_OFFI)->EnableWindow(b);
//
	GetDlgItem(IDC_CDA_CLIENT)->EnableWindow(b);
	GetDlgItem(IDC_CDA_TRANSFERES)->EnableWindow(b);
	GetDlgItem(IDC_CDA_BEHAVE)->EnableWindow(b);
	GetDlgItem(IDC_CDA_USERNAME)->EnableWindow(b);
	GetDlgItem(IDC_CDA_MODNAME)->EnableWindow(b);
	GetDlgItem(IDC_CDA_UL)->EnableWindow(b);
	GetDlgItem(IDC_CDA_DL)->EnableWindow(b);
	GetDlgItem(IDC_CDA_COMPLETE)->EnableWindow(b);
	GetDlgItem(IDC_CDA_RARE)->EnableWindow(b);
	GetDlgItem(IDC_CDA_PART)->EnableWindow(b);
	GetDlgItem(IDC_CDA_TOTAL)->EnableWindow(b);
	GetDlgItem(IDC_CDA_UDRATIO)->EnableWindow(b);
	GetDlgItem(IDC_CDA_UDFAILED)->EnableWindow(b);
	GetDlgItem(IDC_CDA_NICKTHIEF)->EnableWindow(b);
	GetDlgItem(IDC_CDA_MODTHIEF)->EnableWindow(b);
	GetDlgItem(IDC_CDA_MODFAKER)->EnableWindow(b);
	GetDlgItem(IDC_CDA_FILEFAKER)->EnableWindow(b);
	GetDlgItem(IDC_CDA_REASKS)->EnableWindow(b);
	GetDlgItem(IDC_CDA_SPAMMER)->EnableWindow(b);
	GetDlgItem(IDC_CDA_FASTXS)->EnableWindow(b);
	GetDlgItem(IDC_CDA_XSEXPLOITER)->EnableWindow(b);
}

void CAntileechInfoPage::GetHashlistOutput(CUpDownClient* client)
{
	HICON hGPL, hFincan, HSui, hHashList = { theApp.LoadIcon(L"EMPTY", 16, 16) };
	HICON hBad = theApp.LoadIcon(L"CDA_BAD", 16, 16);
	HICON hEmpty = theApp.LoadIcon(L"EMPTY", 16, 16);
	CString str = L"";

//>> gpl
	hGPL = hEmpty;
	if (client->GetIsGPLEvilMod() || client->GetIsGPLEvilNick())
	{
		if (client->GetIsGPLEvilMod() && client->GetIsGPLEvilNick())
			str.Format(L"Bad Nick/Mod");
		else if (client->GetIsGPLEvilNick())
			str.Format(L"Bad Nick");
		else if (client->GetIsGPLEvilMod())
			str.Format(L"Bad Mod");
		hGPL = hBad;
	}
	else
		str = GetResString(IDS_NO);
	GetDlgItem(IDC_CDA_GPLINFO)->SetWindowText(str);
	((CStatic*)GetDlgItem(IDC_CDA_ICON_GPL))->SetIcon(hGPL);
//<< gpl

//>> fincan
	hFincan = hEmpty;
	if (thePrefs.GetCheckFincan())
	{
		if (client->GetIsFincanMod())
		{
			GetDlgItem(IDC_CDA_FINCANINFO)->SetWindowText(GetResString(IDS_YES));
			hFincan = hBad;
		}
		else
			GetDlgItem(IDC_CDA_FINCANINFO)->SetWindowText(GetResString(IDS_NO));
	}
	else
		GetDlgItem(IDC_CDA_FINCANINFO)->SetWindowText(L"-");

	((CStatic*)GetDlgItem(IDC_CDA_ICON_FINCAN))->SetIcon(hFincan);
	GetDlgItem(IDC_CDA_FINCANINFO)->EnableWindow(thePrefs.GetCheckFincan());
	GetDlgItem(IDC_CDA_FINCAN)->EnableWindow(thePrefs.GetCheckFincan());
//<< fincan

//>> suileecher
	HSui = hEmpty;
	if (thePrefs.GetCheckSuiBan())
	{
		if (client->GetIsSuiFaker())
		{
			GetDlgItem(IDC_CDA_SUILEECHERINFO)->SetWindowText(GetResString(IDS_YES));
			HSui = hBad;
		}
		else
			GetDlgItem(IDC_CDA_SUILEECHERINFO)->SetWindowText(GetResString(IDS_NO));
	}
	else
		GetDlgItem(IDC_CDA_SUILEECHERINFO)->SetWindowText(L"-");

	((CStatic*)GetDlgItem(IDC_CDA_ICON_SUI))->SetIcon(HSui);
	GetDlgItem(IDC_CDA_SUILEECHERINFO)->EnableWindow(thePrefs.GetCheckSuiBan());
	GetDlgItem(IDC_CDA_SUIBAN)->EnableWindow(thePrefs.GetCheckSuiBan());
//<< suileecher

	if (client->GetIsBadMod())
		hHashList = theApp.LoadIcon(_T("VERYBADGUY"), 16, 16);
	else
		hHashList = theApp.LoadIcon(_T("SRCDOWNLOADING"), 16, 16);
	((CStatic*)GetDlgItem(IDC_CDA_HASHICON))->SetIcon(hHashList);

	//GetDlgItem(IDC_CDA_HASHLISTS)->EnableWindow(thePrefs.GetUseHashlists());
}

LRESULT CAntileechInfoPage::OnDataChanged(WPARAM, LPARAM)
{
	m_bDataChanged = true;
	return 1;
}

void CAntileechInfoPage::Localize()
{
	LOGFONT lf; 
	CFont* pFont = GetFont(); 
	pFont->GetLogFont(&lf); 
	lf.lfWeight = FW_BOLD;
	m_bFont.CreateFontIndirect( &lf );

	GetDlgItem(IDC_CDA_CLIENT)->SetFont(&m_bFont);
	GetDlgItem(IDC_CDA_TRANSFERES)->SetFont(&m_bFont);
	GetDlgItem(IDC_CDA_HASHLISTS)->SetFont(&m_bFont);
	GetDlgItem(IDC_CDA_BEHAVE)->SetFont(&m_bFont);
	GetDlgItem(IDC_CDA_CA_INFO)->SetFont(&m_bFont);
	
// labels
// main
	GetDlgItem(IDC_CDA_CLIENT)->SetWindowText(GetResString(IDS_CD_GENERAL));
	GetDlgItem(IDC_CDA_TRANSFERES)->SetWindowText(GetResString(IDS_CD_TRANS));
	GetDlgItem(IDC_CDA_BEHAVE)->SetWindowText(GetResString(IDS_CDA_BEHAVE));
// sub
	GetDlgItem(IDC_CDA_USERNAME)->SetWindowText(GetResString(IDS_CD_UNAME));
	GetDlgItem(IDC_CDA_MODNAME)->SetWindowText(GetResString(IDS_CD_CSOFT) + L':');
	GetDlgItem(IDC_CDA_UL)->SetWindowText(GetResString(IDS_CDA_UL));
	GetDlgItem(IDC_CDA_DL)->SetWindowText(GetResString(IDS_CDA_DL));
	GetDlgItem(IDC_CDA_COMPLETE)->SetWindowText(GetResString(IDS_CDA_COMPLETE));
	GetDlgItem(IDC_CDA_RARE)->SetWindowText(GetResString(IDS_CDA_RARE));
	GetDlgItem(IDC_CDA_PART)->SetWindowText(GetResString(IDS_CDA_PART));
	GetDlgItem(IDC_CDA_TOTAL)->SetWindowText(GetResString(IDS_CDA_TOTAL));
	GetDlgItem(IDC_CDA_UDRATIO)->SetWindowText(GetResString(IDS_CDA_UDRATIO));
	GetDlgItem(IDC_CDA_UDFAILED)->SetWindowText(GetResString(IDS_CDA_UDFAILED));

	GetDlgItem(IDC_CDA_NICKTHIEF)->SetWindowText(GetResString(IDS_CDA_NICKTHIEF));
	GetDlgItem(IDC_CDA_MODTHIEF)->SetWindowText(GetResString(IDS_CDA_MODTHIEF));
	GetDlgItem(IDC_CDA_MODFAKER)->SetWindowText(GetResString(IDS_CDA_MODFAKER));
	GetDlgItem(IDC_CDA_FILEFAKER)->SetWindowText(GetResString(IDS_CDA_FILEFAKER));
	GetDlgItem(IDC_CDA_REASKS)->SetWindowText(GetResString(IDS_CDA_REASKS));
	GetDlgItem(IDC_CDA_SPAMMER)->SetWindowText(GetResString(IDS_CDA_SPAMMER));
	GetDlgItem(IDC_CDA_FASTXS)->SetWindowText(GetResString(IDS_CDA_FASTXS));
	GetDlgItem(IDC_CDA_XSEXPLOITER)->SetWindowText(GetResString(IDS_CDA_XSEXPLOITER));

// hashlists
	GetDlgItem(IDC_CDA_GPL)->SetWindowText(GetResString(IDS_CDA_GPL));
	GetDlgItem(IDC_CDA_SUIBAN)->SetWindowText(GetResString(IDS_CDA_SUIBAN));
	GetDlgItem(IDC_CDA_FINCAN)->SetWindowText(GetResString(IDS_CDA_FINCAN));
	GetDlgItem(IDC_CDA_SCORES)->SetWindowText(AddColon(GetResString(IDS_CD_SCORES)));

	CString str = GetResString(IDS_CDA_HASHLISTS);
	if (!thePrefs.GetUseHashlists())
		str.AppendFormat(L" (%s)", GetResString(IDS_DISABLED));
	GetDlgItem(IDC_CDA_HASHLISTS)->SetWindowText(str);

	if (thePrefs.UseCreditSystem()==2)
		str = L"";
	else
		str = L"ClientAnalyzer is disabled!";
	GetDlgItem(IDC_CDA_CA_INFO)->SetWindowText(L"");

// info
	GetDlgItem(IDC_CDA_FULLUSERNAME)->SetWindowText(GetResString(IDS_UNKNOWN));
	GetDlgItem(IDC_CDA_MODNAMEFULL)->SetWindowText(GetResString(IDS_UNKNOWN));
	GetDlgItem(IDC_CDA_ULCOMP)->SetWindowText(GetResString(IDS_UNKNOWN));
	GetDlgItem(IDC_CDA_ULPART)->SetWindowText(GetResString(IDS_UNKNOWN));
	GetDlgItem(IDC_CDA_ULRARE)->SetWindowText(GetResString(IDS_UNKNOWN));
	GetDlgItem(IDC_CDA_ULTOTAL)->SetWindowText(GetResString(IDS_UNKNOWN));
	GetDlgItem(IDC_CDA_DLCOMP)->SetWindowText(GetResString(IDS_UNKNOWN));
	GetDlgItem(IDC_CDA_DLPART)->SetWindowText(GetResString(IDS_UNKNOWN));
	GetDlgItem(IDC_CDA_DLRARE)->SetWindowText(GetResString(IDS_UNKNOWN));
	GetDlgItem(IDC_CDA_DLTOTAL)->SetWindowText(GetResString(IDS_UNKNOWN));
	GetDlgItem(IDC_CDA_UDCHUNKS)->SetWindowText(GetResString(IDS_UNKNOWN));
	GetDlgItem(IDC_CDA_UDRATING)->SetWindowText(L"");
	GetDlgItem(IDC_CDA_FAILED)->SetWindowText(GetResString(IDS_UNKNOWN));
	GetDlgItem(IDC_CDA_NICKTHIEFINFO)->SetWindowText(GetResString(IDS_UNKNOWN));
	GetDlgItem(IDC_CDA_MODTHIEFINFO)->SetWindowText(GetResString(IDS_UNKNOWN));
	GetDlgItem(IDC_CDA_MODFAKERINFO)->SetWindowText(GetResString(IDS_UNKNOWN));
	GetDlgItem(IDC_CDA_FILEFAKERINFO)->SetWindowText(GetResString(IDS_UNKNOWN));
	GetDlgItem(IDC_CDA_SPAMMERINFO)->SetWindowText(GetResString(IDS_UNKNOWN));
	GetDlgItem(IDC_CDA_FASTXSINFO)->SetWindowText(GetResString(IDS_UNKNOWN));
	GetDlgItem(IDC_CDA_XSEXPLOITINFO)->SetWindowText(GetResString(IDS_UNKNOWN));
	GetDlgItem(IDC_CDA_REASKINFO)->SetWindowText(GetResString(IDS_UNKNOWN));
	GetDlgItem(IDC_CDA_GPLINFO)->SetWindowText(GetResString(IDS_UNKNOWN));
	GetDlgItem(IDC_CDA_FINCANINFO)->SetWindowText(GetResString(IDS_UNKNOWN));
	GetDlgItem(IDC_CDA_SUILEECHERINFO)->SetWindowText(GetResString(IDS_UNKNOWN));
	GetDlgItem(IDC_CDA_SCORES_CA)->SetWindowText(GetResString(IDS_UNKNOWN));
	GetDlgItem(IDC_CDA_SCORES_OFFI)->SetWindowText(GetResString(IDS_UNKNOWN));
/*	GetDlgItem()->SetWindowText(GetResString());*/
}
