//this file is part of eMule
//Copyright (C)2002-2006 Merkur ( strEmail.Format("%s@%s", "devteam", "emule-project.net") / http://www.emule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#include "stdafx.h"
#include "emule.h"
#include "PPgTweaksMod3.h"
#include "Preferences.h"
#include "OtherFunctions.h"
#include "emuledlg.h"
#include "Log.h"
#include "UserMsgs.h"
#include "IPFilter.h"
#include "DownloadQueue.h"  //>> pP: AutoDownPrio

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

///////////////////////////////////////////////////////////////////////////////
// CPPgTweaksMod3 dialog

IMPLEMENT_DYNAMIC(CPPgTweaksMod3, CPropertyPage)

BEGIN_MESSAGE_MAP(CPPgTweaksMod3, CPropertyPage)
	ON_WM_HSCROLL()
	ON_WM_DESTROY()
	ON_MESSAGE(UM_TREEOPTSCTRL_NOTIFY, OnTreeOptsCtrlNotify)
	ON_WM_HELPINFO()
END_MESSAGE_MAP()

CPPgTweaksMod3::CPPgTweaksMod3()
	: CPropertyPage(CPPgTweaksMod3::IDD)
	, m_ctrlTreeOptions(theApp.m_iDfltImageListColorFlags)
{
	m_bInitializedTreeOpts = false;

	SetNull();
}

CPPgTweaksMod3::~CPPgTweaksMod3(){}
void CPPgTweaksMod3::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_PP_OPTS3, m_ctrlTreeOptions);

	if (!m_bInitializedTreeOpts)
	{
		int	iImgAPrio		= 8; //>> pP: AutoDownPrio
		int iImgADP_Perc    = 8;
		int iImgADP_Dyn     = 8;
		int iImgUSC			= 8; //>> pP: Slotlimiter
		int iImgConchecker	= 8;
		int iImgSecure		= 8;		
		int iImgIPF			= 8;
		int iImgEmulator	= 8;

		CImageList* piml = m_ctrlTreeOptions.GetImageList(TVSIL_NORMAL);
		if (piml)
		{
			iImgAPrio		= piml->Add(CTempIconLoader(L"FILEPRIORITY"));
			iImgADP_Perc	= piml->Add(CTempIconLoader(L"PRIORITY"));
			iImgADP_Dyn     = piml->Add(CTempIconLoader(L"DYNPRIORITY"));
			iImgUSC			= piml->Add(CTempIconLoader(L"TWEAK"));
			iImgConchecker	= piml->Add(CTempIconLoader(L"UPLOAD"));
			iImgSecure		= piml->Add(CTempIconLoader(L"VERYBADGUY"));
			iImgIPF			= piml->Add(CTempIconLoader(L"SECURITY"));
			iImgEmulator	= piml->Add(CTempIconLoader(L"SOURCEPREFS"));
		}

		//>> pP: Slotlimiter
		m_htiSlotlimiterGroup  = m_ctrlTreeOptions.InsertGroup(thePrefs.ResSL(0), iImgUSC, TVI_ROOT);
		m_htiSlotlimiter_None  = m_ctrlTreeOptions.InsertRadioButton(thePrefs.ResSL(1), m_htiSlotlimiterGroup, m_uSlotlimiterMode == 0);
		m_htiSlotlimiter_Speed = m_ctrlTreeOptions.InsertRadioButton(thePrefs.ResSL(2), m_htiSlotlimiterGroup, m_uSlotlimiterMode == 1);
		m_htiSlotlimiter_Slots = m_ctrlTreeOptions.InsertRadioButton(thePrefs.ResSL(3), m_htiSlotlimiterGroup, m_uSlotlimiterMode == 2);
		m_htiSlotlimiterSpeed = m_ctrlTreeOptions.InsertItem(thePrefs.ResSL(4), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiSlotlimiterGroup);
		m_ctrlTreeOptions.AddEditBox(m_htiSlotlimiterSpeed, RUNTIME_CLASS(CNumTreeOptionsEdit));
		m_htiSlotlimiterSlots = m_ctrlTreeOptions.InsertItem(thePrefs.ResSL(5), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiSlotlimiterGroup);
		m_ctrlTreeOptions.AddEditBox(m_htiSlotlimiterSlots, RUNTIME_CLASS(CNumTreeOptionsEdit));
		m_ctrlTreeOptions.Expand(m_htiSlotlimiterGroup, TVE_EXPAND);
		//<< pP: Slotlimiter

		//>> pP: AutoDownPrio
		m_htiGrpAPrio       = m_ctrlTreeOptions.InsertGroup(thePrefs.ResADP(0), iImgAPrio, TVI_ROOT); // todo: localize
		m_htiOfficialPrio   = m_ctrlTreeOptions.InsertRadioButton(L"Use official/manual priority", m_htiGrpAPrio, m_iUseAPrio == 0);
		m_htiPercentagePrio = m_ctrlTreeOptions.InsertRadioButton(L"Base on fixed percentages", m_htiGrpAPrio, m_iUseAPrio == 1);
		m_htiDynamicPrio    = m_ctrlTreeOptions.InsertRadioButton(L"Base on partfile completition", m_htiGrpAPrio, m_iUseAPrio == 2);

		m_htiGrpDynADP		= m_ctrlTreeOptions.InsertGroup(L"Completition based settings", iImgADP_Dyn, m_htiGrpAPrio);
		m_htiDynMaxHigh     = m_ctrlTreeOptions.InsertItem(L"Max files on HIGH prio (per Cat)", TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiGrpDynADP);
		m_ctrlTreeOptions.AddEditBox(m_htiDynMaxHigh, RUNTIME_CLASS(CNumTreeOptionsEdit));
		m_htiDynMaxNorm		= m_ctrlTreeOptions.InsertItem(L"Max files on NORMAL prio (per Cat)",  TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiGrpDynADP);
		m_ctrlTreeOptions.AddEditBox(m_htiDynMaxNorm, RUNTIME_CLASS(CNumTreeOptionsEdit));

		m_htiGrpPercADP		= m_ctrlTreeOptions.InsertGroup(L"Percentage settings", iImgADP_Perc, m_htiGrpAPrio);
		m_htiAPrioHigh      = m_ctrlTreeOptions.InsertItem(thePrefs.ResADP(2), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiGrpPercADP);
		m_ctrlTreeOptions.AddEditBox(m_htiAPrioHigh, RUNTIME_CLASS(CNumTreeOptionsEdit));
		m_htiAPrioNorm      = m_ctrlTreeOptions.InsertItem(thePrefs.ResADP(3), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiGrpPercADP);
		m_ctrlTreeOptions.AddEditBox(m_htiAPrioNorm, RUNTIME_CLASS(CNumTreeOptionsEdit));

		m_htiAPrioLog = m_ctrlTreeOptions.InsertCheckBox(thePrefs.ResADP(4), m_htiGrpAPrio, m_bAPrioLog);
		//<< pP: AutoDownPrio

		//>> evl: ConChecker [eWombat]
		m_htiConcheckerGroup = m_ctrlTreeOptions.InsertGroup(thePrefs.ResCon(0), iImgConchecker, TVI_ROOT);
		m_htiConcheckerActive = m_ctrlTreeOptions.InsertCheckBox(thePrefs.ResCon(6), m_htiConcheckerGroup, m_bConcheckerActive);
		m_htiConCheckerOptGrp = m_ctrlTreeOptions.InsertGroup(thePrefs.ResMisc(4), iImgConchecker, m_htiConcheckerGroup);
		m_htiConcheckerPingtypeRadio = m_ctrlTreeOptions.InsertGroup(thePrefs.ResCon(1), iImgConchecker, m_htiConCheckerOptGrp);
		m_htiConcheckerPingICMP = m_ctrlTreeOptions.InsertRadioButton(thePrefs.ResCon(2), m_htiConcheckerPingtypeRadio, m_iConcheckerPingtype == 0);
		m_htiConcheckerPingRAW = m_ctrlTreeOptions.InsertRadioButton(thePrefs.ResCon(3), m_htiConcheckerPingtypeRadio, m_iConcheckerPingtype == 1);
		m_htiConcheckerTTL = m_ctrlTreeOptions.InsertItem(thePrefs.ResCon(4), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiConCheckerOptGrp);
		m_ctrlTreeOptions.AddEditBox(m_htiConcheckerTTL, RUNTIME_CLASS(CNumTreeOptionsEdit));
		m_htiConcheckerPingtimeout = m_ctrlTreeOptions.InsertItem(thePrefs.ResCon(5), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiConCheckerOptGrp);
		m_ctrlTreeOptions.AddEditBox(m_htiConcheckerPingtimeout, RUNTIME_CLASS(CNumTreeOptionsEdit));
		m_ctrlTreeOptions.Expand(m_htiConcheckerGroup, TVE_EXPAND);
		//<< evl: ConChecker [eWombat]

		// ==> Emulate others by WiZaRd/Spike/shadow2004 - sFrQlXeRt
		m_htiEmulator = m_ctrlTreeOptions.InsertGroup(L"Emulate other", iImgEmulator, TVI_ROOT);
		m_htiEnableMLDonkey = m_ctrlTreeOptions.InsertCheckBox(L"MLDonkey", m_htiEmulator, m_bEmuMLDonkey);
		m_htiEnableeDonkey = m_ctrlTreeOptions.InsertCheckBox(L"eDonkey", m_htiEmulator, m_bEmueDonkey);
		m_htiEnableeDonkeyHybrid = m_ctrlTreeOptions.InsertCheckBox(L"eDonkey Hybrid", m_htiEmulator, m_bEmueDonkeyHybrid);
		m_htiEnableShareaza = m_ctrlTreeOptions.InsertCheckBox(L"Shareaza", m_htiEmulator, m_bEmuShareaza);
		m_htiEnableLphant = m_ctrlTreeOptions.InsertCheckBox(L"LPhant", m_htiEmulator, m_bEmuLphant);
		m_htiLogEmulator = m_ctrlTreeOptions.InsertCheckBox(thePrefs.ResMisc(19), m_htiEmulator, m_bLogEmulator);
		m_ctrlTreeOptions.Expand(m_htiEmulator, TVE_EXPAND);
		// <== Emulate others by WiZaRd/Spike/shadow2004 - sFrQlXeRt

		//>> evl: IPFilterUpdate
		m_htiIPFGroup			 = m_ctrlTreeOptions.InsertGroup(thePrefs.ResIPF(0), iImgIPF, TVI_ROOT);
		m_htiIPFAutoUpdate		 = m_ctrlTreeOptions.InsertCheckBox(thePrefs.ResIPF(1),    m_htiIPFGroup, m_bIPFAutoUpdate);
		m_htiIPFSelGrp			 = m_ctrlTreeOptions.InsertGroup(thePrefs.ResIPF(0), iImgIPF, m_htiIPFGroup);
		m_htiIPFPAWCIO			 = m_ctrlTreeOptions.InsertRadioButton(thePrefs.ResIPF(2), m_htiIPFSelGrp, m_bIPFilterSelection == 0);
		m_htiIPFUSER			 = m_ctrlTreeOptions.InsertRadioButton(thePrefs.ResIPF(5), m_htiIPFSelGrp, m_bIPFilterSelection == 1);
		m_htiIPFAutoUpdateCustom = m_ctrlTreeOptions.InsertItem(thePrefs.ResIPF(6), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiIPFSelGrp);
		m_ctrlTreeOptions.AddEditBox(m_htiIPFAutoUpdateCustom, RUNTIME_CLASS(CTreeOptionsEditEx));
		m_ctrlTreeOptions.Expand(m_htiIPFGroup, TVE_EXPAND);
		//<< evl: IPFilterUpdate

		//>> pP: LeecherSecure
		m_htiAntileecherGrp		= m_ctrlTreeOptions.InsertGroup(L"Leecher secure", iImgSecure, TVI_ROOT);
		m_htiAntiFincan			= m_ctrlTreeOptions.InsertCheckBox(L"Fincan Hashcheck", m_htiAntileecherGrp, m_bAntiFincan);
		m_htiAntiSuiBan			= m_ctrlTreeOptions.InsertCheckBox(L"UpSession check (SUI Ban)", m_htiAntileecherGrp, m_bAntiSuiBan);
		m_htiUseHashLists		= m_ctrlTreeOptions.InsertCheckBox(L"Store hashes for later detection", m_htiAntileecherGrp, m_bUseHashLists);
		m_htiAntiLeecherLog		= m_ctrlTreeOptions.InsertCheckBox(thePrefs.ResMisc(19) , m_htiAntileecherGrp, m_bAntiLeecherLog);
		//<< pP: LeecherSecure

		//>> evl: CReport
		m_htiStatsOnExit	     = m_ctrlTreeOptions.InsertCheckBox(thePrefs.ResMisc(2), TVI_ROOT, m_bStatsOnExit);
		m_ctrlTreeOptions.SetCheckBoxEnable(m_htiStatsOnExit, false);
		//<< evl: CReport

        m_ctrlTreeOptions.SendMessage(WM_VSCROLL, SB_TOP);
        m_bInitializedTreeOpts = true;
	}

	DDX_TreeCheck(pDX, IDC_PP_OPTS3, m_htiStatsOnExit, m_bStatsOnExit);	//>> evl: CReport

	//>> pP: Slotlimiter
	DDX_TreeRadio(pDX, IDC_PP_OPTS3, m_htiSlotlimiterGroup, m_uSlotlimiterMode);
	DDX_TreeEdit(pDX,  IDC_PP_OPTS3, m_htiSlotlimiterSlots, m_uSlotlimiterSlots);
	DDX_TreeEdit(pDX,  IDC_PP_OPTS3, m_htiSlotlimiterSpeed, m_uSlotlimiterSpeed);
	DDV_MinMaxInt(pDX, m_uSlotlimiterSlots, 1, 250);
	DDV_MinMaxInt(pDX, m_uSlotlimiterSpeed, 1, 250);
	//<< pP: Slotlimiter

	//>> pP: AutoDownPrio
	DDX_TreeRadio(pDX, IDC_PP_OPTS3, m_htiGrpAPrio, m_iUseAPrio);
	DDX_TreeCheck(pDX, IDC_PP_OPTS3, m_htiAPrioLog, m_bAPrioLog);
	DDX_TreeEdit(pDX, IDC_PP_OPTS3, m_htiAPrioHigh, m_iAPrioHigh);
	DDX_TreeEdit(pDX, IDC_PP_OPTS3, m_htiAPrioNorm, m_iAPrioNorm);
	DDV_MinMaxInt(pDX, m_iAPrioHigh, 1+m_iAPrioNorm, 99);
	DDV_MinMaxInt(pDX, m_iAPrioNorm, 1			   , m_iAPrioHigh-1);
	DDX_TreeEdit(pDX, IDC_PP_OPTS3, m_htiDynMaxHigh, m_iDynMaxHigh);
	DDX_TreeEdit(pDX, IDC_PP_OPTS3, m_htiDynMaxNorm, m_iDynMaxNorm);
	//<< pP: AutoDownPrio

	//>> evl: ConChecker [eWombat]
	DDX_TreeCheck(pDX, IDC_PP_OPTS3, m_htiConcheckerActive, m_bConcheckerActive);	
	DDX_TreeEdit(pDX, IDC_PP_OPTS3, m_htiConcheckerTTL, m_iConcheckerTTL);
	DDV_MinMaxInt(pDX, m_iConcheckerTTL, 8, 64);
	DDX_TreeEdit(pDX, IDC_PP_OPTS3, m_htiConcheckerPingtimeout, m_iConcheckerPingtimeout);
	DDV_MinMaxInt(pDX, m_iConcheckerPingtimeout, 1, 64);
	DDX_TreeRadio(pDX, IDC_PP_OPTS3, m_htiConcheckerPingtypeRadio, m_iConcheckerPingtype); 
	//<< evl: ConChecker [eWombat]

	//>> evl: IPFilterUpdate
	DDX_TreeCheck(pDX, IDC_PP_OPTS3, m_htiIPFAutoUpdate,		m_bIPFAutoUpdate);
	DDX_TreeRadio(pDX, IDC_PP_OPTS3, m_htiIPFSelGrp,			m_bIPFilterSelection);
	DDX_TreeEdit( pDX, IDC_PP_OPTS3, m_htiIPFAutoUpdateCustom,	m_strIPFAutoUpdateCustom);
	//<< evl: IPFilterUpdate

	//>> pP: LeecherSecure
	DDX_TreeCheck(pDX, IDC_PP_OPTS3, m_htiAntiFincan, m_bAntiFincan);
	DDX_TreeCheck(pDX, IDC_PP_OPTS3, m_htiAntiSuiBan, m_bAntiSuiBan);
	DDX_TreeCheck(pDX, IDC_PP_OPTS3, m_htiUseHashLists, m_bUseHashLists);
	DDX_TreeCheck(pDX, IDC_PP_OPTS3, m_htiAntiLeecherLog, m_bAntiLeecherLog);
	//<< pP: LeecherSecure

	// ==> Emulate others by WiZaRd/Spike/shadow2004 - sFrQlXeRt
	DDX_TreeCheck(pDX, IDC_PP_OPTS3, m_htiEnableMLDonkey, m_bEmuMLDonkey);
	DDX_TreeCheck(pDX, IDC_PP_OPTS3, m_htiEnableeDonkey, m_bEmueDonkey);
	DDX_TreeCheck(pDX, IDC_PP_OPTS3, m_htiEnableeDonkeyHybrid, m_bEmueDonkeyHybrid);
	DDX_TreeCheck(pDX, IDC_PP_OPTS3, m_htiEnableShareaza, m_bEmuShareaza);
	DDX_TreeCheck(pDX, IDC_PP_OPTS3, m_htiEnableLphant, m_bEmuLphant);
	DDX_TreeCheck(pDX, IDC_PP_OPTS3, m_htiLogEmulator, m_bLogEmulator);
	// <== Emulate others by WiZaRd/Spike/shadow2004 - sFrQlXeRt
}

BOOL CPPgTweaksMod3::OnInitDialog()
{

	//>> evl: ConChecker [eWombat]
	m_bConcheckerActive = thePrefs.GetCheckCon();	
	m_iConcheckerTTL = thePrefs.GetPingTTL();
	m_iConcheckerPingtimeout = thePrefs.GetPingTimeout();
	m_iConcheckerPingtype = thePrefs.GetICMP() ? 0 : 1; 
	//<< evl: ConChecker [eWombat]

	//>> evl: IPFilterUpdate
	m_bIPFAutoUpdate = thePrefs.GetDoIPFilterUpdate();
	m_bIPFilterSelection = thePrefs.GetIPFilterSelection();
	m_strIPFAutoUpdateCustom = thePrefs.GetIPFilterCustomPath();

	if (m_strIPFAutoUpdateCustom.IsEmpty())
		m_strIPFAutoUpdateCustom = thePrefs.ResIPF(7);
	//>> evl: IPFilterUpdate

	//>> pP: Slotlimiter
	m_uSlotlimiterMode  = thePrefs.GetSlotlimiterMode();
	m_uSlotlimiterSpeed = thePrefs.GetSlotlimiterSpeed();
	m_uSlotlimiterSlots = thePrefs.GetSlotlimiterSlots();
	//<< pP: Slotlimiter

	//>> pP: AutoDownPrio
	m_iUseAPrio  = thePrefs.GetAutoPrioEnabled();
	m_bAPrioLog  = thePrefs.GetAutoPrioLog();
	m_iAPrioHigh = thePrefs.GetAutoPrioHigh();
	m_iAPrioNorm = thePrefs.GetAutoPrioNormal();
	m_iDynMaxHigh= thePrefs.GetDynADP_MaxHigh();
	m_iDynMaxNorm= thePrefs.GetDynADP_MaxNorm();
	//<< pP: AutoDownPrio

	//>> pP: LeecherSecure
	m_bAntiFincan = thePrefs.GetCheckFincan();
	m_bAntiLeecherLog = thePrefs.GetLogLeecher();
	m_bAntiSuiBan = thePrefs.GetCheckSuiBan();
	m_bUseHashLists = thePrefs.GetUseHashlists();
	//<< pP: LeecherSecure

	//>> evl: CReport
	m_bStatsOnExit = thePrefs.GetCreateReportFileOnClose();
	//<< evl: CReport
  
	// ==> Emulate others by WiZaRd/Spike/shadow2004 - sFrQlXeRt
	m_bEmuMLDonkey      = thePrefs.GetIsEmuMLDonkey();
	m_bEmueDonkey       = thePrefs.GetIsEmueDonkey();
	m_bEmueDonkeyHybrid = thePrefs.GetIsEmueDonkeyHybrid();
	m_bEmuShareaza      = thePrefs.GetIsEmuShareaza();
	m_bEmuLphant		= thePrefs.GetIsEmuLphant();
	m_bLogEmulator		= thePrefs.GetLogEmulator();
	// <== Emulate others by WiZaRd/Spike/shadow2004 - sFrQlXeRt

	m_ctrlTreeOptions.SetImageListColorFlags(theApp.m_iDfltImageListColorFlags);
    CPropertyPage::OnInitDialog();
	InitWindowStyles(this);
	m_ctrlTreeOptions.SetItemHeight(m_ctrlTreeOptions.GetItemHeight() + 2);

	return TRUE;  // return TRUE unless you set the focus to a control
				  // EXCEPTION: OCX Property Pages should return FALSE
}

BOOL CPPgTweaksMod3::OnKillActive()
{
	// if prop page is closed by pressing ENTER we have to explicitly commit any possibly pending
	// data from an open edit control
	m_ctrlTreeOptions.HandleChildControlLosingFocus();
	return CPropertyPage::OnKillActive();
}

BOOL CPPgTweaksMod3::OnApply()
{
	// if prop page is closed by pressing ENTER we have to explicitly commit any possibly pending
	// data from an open edit control
	m_ctrlTreeOptions.HandleChildControlLosingFocus();

	if (!UpdateData())
		return FALSE;

	//>> evl: ConChecker [eWombat]
	const bool bSetPrefs = m_iConcheckerTTL != thePrefs.GetPingTTL() || m_iConcheckerPingtimeout != thePrefs.GetPingTimeout() || (uint8)m_iConcheckerPingtype != (thePrefs.GetICMP() ? 0 : 1);
	thePrefs.SetPingTTL((uint8)m_iConcheckerTTL);
	thePrefs.SetPingTimeout((uint8)m_iConcheckerPingtimeout);
	thePrefs.SetICMP(m_iConcheckerPingtype == 0); 

	if(m_bConcheckerActive != thePrefs.GetCheckCon())
	{
		thePrefs.SetCheckCon(m_bConcheckerActive);
		if(m_bConcheckerActive)
			theApp.conchecker.Start();
		else
		{
			theApp.conchecker.Stop();
			AddModLogLine(L"Conchecker stopped in prefs()");
		}
	}
	
	if(bSetPrefs)
		theApp.conchecker.SetPreferences();
	//<< evl: ConChecker [eWombat]

	//>> evl: IPFilterUpdate
	if (m_strIPFAutoUpdateCustom == thePrefs.ResIPF(7))
		m_strIPFAutoUpdateCustom.Empty();

	if (m_bIPFilterSelection == 1 && m_strIPFAutoUpdateCustom.IsEmpty())
	{
		m_bIPFilterSelection=0; // custom update without path. switch back to pawcio.
		AddModLogLine(LOG_RED, L"IPFIlter: Custom IPfilter selected with empty path. Using default filter instead.");
	}

	bool bChanged = (m_bIPFAutoUpdate != thePrefs.GetDoIPFilterUpdate()) || ((int)thePrefs.GetIPFilterSelection() != m_bIPFilterSelection || m_strIPFAutoUpdateCustom != thePrefs.GetIPFilterCustomPath());
	thePrefs.SetDoIPFilterUpdate(m_bIPFAutoUpdate);
	thePrefs.SetIPFilterSelection(m_bIPFilterSelection==1);
	thePrefs.SetIPFilterCustomPath(m_strIPFAutoUpdateCustom);

	//>> evl: after changed settings if no filter exists or it expired.
	if (bChanged && (!PathFileExists(theApp.ipfilter->GetDefaultFilePath())|| thePrefs.GetNextUpdateTimeIPF() < ::GetTickCount()))
	{
		thePrefs.SetNextUpdateTimeIPF(0); // update in 10 seconds
		AddModLogLine(LOG_LILA, L"IPFIlter: Timer restarted after settings changed.");
	}
	//>> evl: IPFilterUpdate

	//>> pP: Slotlimiter
	thePrefs.SetSlotlimiterMode( (uint8)m_uSlotlimiterMode);
	thePrefs.SetSlotlimiterSpeed((uint8)m_uSlotlimiterSpeed);
	thePrefs.SetSlotlimiterSlots((uint8)m_uSlotlimiterSlots);
	//AddModLogLine(L"Slotlimiter: Speed = %u, Slots = %u", thePrefs.GetUploadClientDatarate(), thePrefs.GetMaxUpClientsAllowed());
	//<< pP: Slotlimiter

	//>> autoprio
	bool bReset =  thePrefs.GetAutoPrioEnabled() != m_iUseAPrio;
	thePrefs.SetAutoPrioLog(m_bAPrioLog);
	thePrefs.SetAutoPrioEnabled((uint8)m_iUseAPrio);
	thePrefs.SetAutoPrioHigh((uint8)m_iAPrioHigh);
	thePrefs.SetAutoPrioNormal((uint8)m_iAPrioNorm);
	thePrefs.SetDynADP_MaxHigh((uint8)m_iDynMaxHigh);
	thePrefs.SetDynADP_MaxNorm((uint8)m_iDynMaxNorm);
	if (bReset)
		theApp.downloadqueue->ADP_Reset();
	//<< autoprio

	//>> pP: LeecherSecure
	thePrefs.SetCheckFincan(m_bAntiFincan);
	thePrefs.SetCheckSuiBan(m_bAntiSuiBan);
	thePrefs.SetUseHashlists(m_bUseHashLists);
	thePrefs.SetLogLeecher(m_bAntiLeecherLog);
	//<< pP: LeecherSecure

	//>> evl: CReport
	thePrefs.SetCreateReportFileOnClose(m_bStatsOnExit);
	//<< evl: CReport

	// ==> Emulate others by WiZaRd/Spike/shadow2004 - sFrQlXeRt
	thePrefs.SetIsEmuMLDonkey(m_bEmuMLDonkey);
	thePrefs.SetIsEmueDonkey(m_bEmueDonkey);
	thePrefs.SetIsEmueDonkeyHybrid(m_bEmueDonkeyHybrid);
	thePrefs.SetIsEmuShareaza(m_bEmuShareaza);
	thePrefs.SetIsEmuLphant(m_bEmuLphant);
	thePrefs.SetLogEmulator(m_bLogEmulator);
	// <== Emulate others by WiZaRd/Spike/shadow2004 - sFrQlXeRt

	SetModified(FALSE);
	return CPropertyPage::OnApply();
}

//void CPPgTweaksMod3::OnHScroll(UINT /*nSBCode*/, UINT /*nPos*/, CScrollBar* pScrollBar){}
//void CPPgTweaksMod3::Localize(void){if(m_hWnd){;}}

void CPPgTweaksMod3::OnDestroy()
{
	m_ctrlTreeOptions.DeleteAllItems();
	m_ctrlTreeOptions.DestroyWindow();
	m_bInitializedTreeOpts = false;

	SetNull();
    
    CPropertyPage::OnDestroy();
}

LRESULT CPPgTweaksMod3::OnTreeOptsCtrlNotify(WPARAM wParam, LPARAM /*lParam*/)
{
	if (wParam == IDC_PP_OPTS3)
		SetModified();

	return 0;
}

void CPPgTweaksMod3::OnHelp(){ShellExecute(NULL, NULL, MOD_FORUMLINK, NULL, thePrefs.GetMuleDirectory(EMULE_EXECUTEABLEDIR), SW_SHOWDEFAULT);}
BOOL CPPgTweaksMod3::OnCommand(WPARAM wParam, LPARAM lParam){if (wParam == ID_HELP){OnHelp();return TRUE;}return __super::OnCommand(wParam, lParam);}
BOOL CPPgTweaksMod3::OnHelpInfo(HELPINFO*){OnHelp();return TRUE;}

void CPPgTweaksMod3::SetNull()
{
	//>> evl: ConChecker [eWombat]
	m_htiConcheckerGroup = NULL;
	m_htiConcheckerActive = NULL;
	m_htiConcheckerPingtypeRadio = NULL;
	m_htiConcheckerPingICMP = NULL;
	m_htiConcheckerPingRAW = NULL;
	m_htiConcheckerTTL = NULL;
	m_htiConcheckerPingtimeout = NULL;
	m_htiConCheckerOptGrp = NULL;
	m_bConcheckerActive = false;
	m_iConcheckerPingtype = 0;
	m_iConcheckerTTL = 0;
	m_iConcheckerPingtimeout = 0;
	//<< evl: ConChecker [eWombat]

	//>> pP: Slotlimiter
	m_htiSlotlimiterGroup  = NULL;
	m_htiSlotlimiterSpeed  = NULL;
	m_htiSlotlimiterSlots  = NULL;
	m_htiSlotlimiter_None  = NULL;
	m_htiSlotlimiter_Slots = NULL;
	m_htiSlotlimiter_Speed = NULL;
	m_uSlotlimiterMode     = 0;
	m_uSlotlimiterSpeed    = 0;
	m_uSlotlimiterSlots    = 0;
	//<< pP: Slotlimiter

	//>> pP: AutoDownPrio
	m_htiGrpAPrio  = NULL;
	m_htiGrpDynADP = NULL;
	m_htiGrpPercADP = NULL;
	m_htiOfficialPrio = NULL;
	m_htiDynamicPrio = NULL;
	m_htiPercentagePrio = NULL;
	m_htiDynMaxHigh = NULL;
	m_htiDynMaxNorm = NULL;
	m_htiAPrioHigh = NULL;
	m_htiAPrioNorm = NULL;
	m_htiAPrioLog  = NULL;
	m_iDynMaxHigh = 0;
	m_iDynMaxNorm = 0;
	m_bAPrioLog    = 0;
	m_iUseAPrio    = 0;
	m_iAPrioHigh   = 0;
	m_iAPrioNorm   = 0;
	//<< pP: AutoDownPrio

	//>> evl: IPFilterUpdate
	m_htiIPFGroup = NULL;
	m_htiIPFAutoUpdate = NULL;
	m_htiIPFAutoUpdateLocation = NULL;
	m_htiIPFAutoUpdateCustom = NULL;
	m_htiIPFPAWCIO = NULL;
	m_htiIPFUSER = NULL;
	m_htiIPFSelGrp = NULL;
	m_bIPFAutoUpdate = false;
	m_bIPFilterSelection = 0;
	m_strIPFAutoUpdateCustom.Empty();
	//<< evl: IPFilterUpdate

	//>> evl: CReport
	m_htiStatsOnExit = NULL;
	m_bStatsOnExit = false;
	//>> evl: CReport

	// ==> Emulate others by WiZaRd/Spike/shadow2004 - sFrQlXeRt
	m_htiEmulator = NULL;
	m_htiEnableMLDonkey = NULL;
	m_htiEnableeDonkey = NULL;
	m_htiEnableeDonkeyHybrid = NULL;
	m_htiEnableShareaza = NULL;
	m_htiEnableLphant = NULL;
	m_htiLogEmulator = NULL;
	m_bEmuMLDonkey = false;
	m_bEmueDonkey = false;
	m_bEmueDonkeyHybrid = false;
	m_bEmuShareaza = false;
	m_bEmuLphant = false;
	m_bLogEmulator = false;
	// <== Emulate others by WiZaRd/Spike/shadow2004 - sFrQlXeRt

	//>> pP: LeecherSecure
	m_htiAntileecherGrp = NULL;
	m_htiAntiFincan = NULL;
	m_htiUseHashLists = NULL;
	m_htiAntiSuiBan = NULL;
	m_htiAntiLeecherLog = NULL;
	m_bAntiFincan = false;
	m_bUseHashLists = false;
	m_bAntiSuiBan = false;
	m_bAntiLeecherLog = false;
	//<< pP: LeecherSecure
}

void CPPgTweaksMod3::Localize(void)
{
	if (m_hWnd)
	{
		//thePrefs.Localize_Init(); //>> pP: Localize.ini

		CString str;
		str.Format(L"%s 2 (Mod)", GetResString(IDS_PW_TWEAK));
		SetWindowText(str);

		// ==> Emulate others by WiZaRd/Spike/shadow2004 - sFrQlXeRt
		if (m_htiEmulator) m_ctrlTreeOptions.SetItemText(m_htiEmulator, thePrefs.ResMisc(7));
		/*
		if (m_htiEnableMLDonkey) m_ctrlTreeOptions.SetItemText(m_htiEnableMLDonkey, GetResString(IDS_EMUMLDONKEY));
		if (m_htiEnableeDonkey) m_ctrlTreeOptions.SetItemText(m_htiEnableeDonkey, GetResString(IDS_EMUEDONKEY));
		if (m_htiEnableeDonkeyHybrid) m_ctrlTreeOptions.SetItemText(m_htiEnableeDonkeyHybrid, GetResString(IDS_EMUEDONKEYHYBRID));
		if (m_htiEnableShareaza) m_ctrlTreeOptions.SetItemText(m_htiEnableShareaza, GetResString(IDS_EMUSHAREAZA2));
		if (m_htiEnableLphant) m_ctrlTreeOptions.SetItemText(m_htiEnableLphant, GetResString(IDS_EMULPHANT));
		*/
		if (m_htiLogEmulator) m_ctrlTreeOptions.SetItemText(m_htiLogEmulator, thePrefs.ResMisc(19));
		// <== Emulate others by WiZaRd/Spike/shadow2004 - sFrQlXeRt

		//>> pP: Slotlimiter
		if (m_htiSlotlimiterGroup)    m_ctrlTreeOptions.SetItemText(m_htiSlotlimiterGroup, thePrefs.ResSL(0));
		if (m_htiSlotlimiter_None)    m_ctrlTreeOptions.SetEditLabel(m_htiSlotlimiter_None ,thePrefs.ResSL(1));
		if (m_htiSlotlimiter_Speed)   m_ctrlTreeOptions.SetEditLabel(m_htiSlotlimiter_Speed ,thePrefs.ResSL(2));
		if (m_htiSlotlimiter_Slots)   m_ctrlTreeOptions.SetEditLabel(m_htiSlotlimiter_Slots ,thePrefs.ResSL(3));
		if (m_htiSlotlimiterSpeed)    m_ctrlTreeOptions.SetEditLabel(m_htiSlotlimiterSpeed ,thePrefs.ResSL(4));
		if (m_htiSlotlimiterSlots)    m_ctrlTreeOptions.SetEditLabel(m_htiSlotlimiterSlots ,thePrefs.ResSL(5));
		//<< pP: Slotlimiter

		//>> pP: AutoDownPrio
		if (m_htiGrpAPrio)	m_ctrlTreeOptions.SetItemText(m_htiGrpAPrio, thePrefs.ResADP(0));
		//if (m_htiUseAPrio)	m_ctrlTreeOptions.SetItemText(m_htiUseAPrio, thePrefs.ResADP(1));
		if (m_htiAPrioHigh)	m_ctrlTreeOptions.SetEditLabel(m_htiAPrioHigh, thePrefs.ResADP(2));
		if (m_htiAPrioNorm)	m_ctrlTreeOptions.SetEditLabel(m_htiAPrioNorm, thePrefs.ResADP(3));
		if (m_htiAPrioLog)	m_ctrlTreeOptions.SetItemText(m_htiAPrioLog, thePrefs.ResADP(4));
		//if (m_htiADPOptGrp) m_ctrlTreeOptions.SetItemText(m_htiADPOptGrp, thePrefs.ResMisc(4));
		//<< pP: AutoDownPrio

		//>> evl: ConChecker [eWombat]
		if (m_htiConcheckerGroup)			m_ctrlTreeOptions.SetItemText(m_htiConcheckerGroup, thePrefs.ResCon(0));
		if (m_htiConcheckerActive)			m_ctrlTreeOptions.SetItemText(m_htiConcheckerActive, thePrefs.ResCon(6));
		if (m_htiConcheckerPingtypeRadio)	m_ctrlTreeOptions.SetItemText(m_htiConcheckerPingtypeRadio, thePrefs.ResCon(1));
		if (m_htiConcheckerPingICMP)		m_ctrlTreeOptions.SetEditLabel(m_htiConcheckerPingICMP, thePrefs.ResCon(2));
		if (m_htiConcheckerPingRAW)			m_ctrlTreeOptions.SetEditLabel(m_htiConcheckerPingRAW, thePrefs.ResCon(3));
		if (m_htiConcheckerTTL)				m_ctrlTreeOptions.SetEditLabel(m_htiConcheckerTTL, thePrefs.ResCon(4));
		if (m_htiConcheckerPingtimeout)		m_ctrlTreeOptions.SetEditLabel(m_htiConcheckerPingtimeout, thePrefs.ResCon(5));
		if (m_htiConCheckerOptGrp)			m_ctrlTreeOptions.SetItemText(m_htiConCheckerOptGrp, thePrefs.ResMisc(4));
		//<< evl: ConChecker [eWombat]

		//>> evl: IPFilterUpdate
		if (m_htiIPFGroup)			    m_ctrlTreeOptions.SetItemText(m_htiIPFGroup, thePrefs.ResIPF(0));
		if (m_htiIPFAutoUpdate)		    m_ctrlTreeOptions.SetItemText(m_htiIPFAutoUpdate, thePrefs.ResIPF(1));
		if (m_htiIPFSelGrp)			    m_ctrlTreeOptions.SetItemText(m_htiIPFSelGrp, thePrefs.ResIPF(0));
		if (m_htiIPFPAWCIO)			    m_ctrlTreeOptions.SetEditLabel(m_htiIPFPAWCIO, thePrefs.ResIPF(2));
		if (m_htiIPFUSER)			    m_ctrlTreeOptions.SetEditLabel(m_htiIPFUSER, thePrefs.ResIPF(5));
		if (m_htiIPFAutoUpdateCustom)	m_ctrlTreeOptions.SetEditLabel(m_htiIPFAutoUpdateCustom, thePrefs.ResIPF(6));
		//<< evl: IPFilterUpdate

		//>> evl: CReport
		if (m_htiStatsOnExit)				m_ctrlTreeOptions.SetItemText(m_htiStatsOnExit, thePrefs.ResMisc(2));
		//>> evl: CReport
	}
}