//this file is part of eMule
//Copyright (C)2002-2006 Merkur ( strEmail.Format("%s@%s", "devteam", "emule-project.net") / http://www.emule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#include "stdafx.h"
#include "emule.h"
#include "SearchDlg.h"
#include "PPgTweaksMod2.h"
#include "Preferences.h"
#include "OtherFunctions.h"
#include "emuledlg.h"
#include "HelpIDs.h"
#include "UserMsgs.h"
#include "ClientList.h"
#include "Log.h"
#include "Addons/ip2country/IP2Country.h"
#include "addons/ModIcons/ModIconMapping.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

///////////////////////////////////////////////////////////////////////////////
// CPPgTweaksMod2 dialog

IMPLEMENT_DYNAMIC(CPPgTweaksMod2, CPropertyPage)

BEGIN_MESSAGE_MAP(CPPgTweaksMod2, CPropertyPage)
	ON_WM_HSCROLL()
	ON_WM_DESTROY()
	ON_MESSAGE(UM_TREEOPTSCTRL_NOTIFY, OnTreeOptsCtrlNotify)
	ON_WM_HELPINFO()
END_MESSAGE_MAP()

CPPgTweaksMod2::CPPgTweaksMod2()
	: CPropertyPage(CPPgTweaksMod2::IDD)
	, m_ctrlTreeOptions(theApp.m_iDfltImageListColorFlags)
{
	m_bInitializedTreeOpts = false;

	SetNull();
}

CPPgTweaksMod2::~CPPgTweaksMod2(){}
void CPPgTweaksMod2::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_PP_OPTS2, m_ctrlTreeOptions);

	if (!m_bInitializedTreeOpts)
	{
		int iImgDisplay = 8;
		int iImgFN		= 8; //>> evl: FunnyNicks [xrmb]
		int iImgModIcon = 8;
		int iImgCol     = 8;
		int iImgIP2C    = 8; //>> evl: IP2C [EastShare]


		CImageList* piml = m_ctrlTreeOptions.GetImageList(TVSIL_NORMAL);
		if (piml)
		{
			iImgDisplay = piml->Add(CTempIconLoader(L"DISPLAYPREFS"));			 //Display tweaks (group icon)
			iImgFN      = piml->Add(CTempIconLoader(L"RENAME"));                 //>> evl: FunnyNicks [xrmb]
			iImgModIcon = piml->Add(CTempIconLoader(L"SO_KATANA"));              //>> evl: ModIconDLL [WiZaRd/Shadow2004]
			iImgCol		= piml->Add(CTempIconLoader(L"SEARCHFILETYPE_PICTURE")); //>> pP: ColoredActiveDLs
			iImgIP2C    = piml->Add(CTempIconLoader(L"WEB"));        	         //>> evl: IP2C [EastShare]
		}

		//Display tweaks
		m_htiDisplayGroup		= m_ctrlTreeOptions.InsertGroup(GetResString(IDS_PW_DISPLAY), iImgDisplay, TVI_ROOT);
		m_htiClientPercentages	= m_ctrlTreeOptions.InsertCheckBox(thePrefs.ResMisc(16), m_htiDisplayGroup, m_bClientPercentages); // X-Ray :: ClientPercentage
		m_htiChunkDots			= m_ctrlTreeOptions.InsertCheckBox(thePrefs.ResFN(9),	 m_htiDisplayGroup, m_bChunkDots);	//>> pP: Chunkdots [Slugfiller]
		m_htiShowDiffQR         = m_ctrlTreeOptions.InsertCheckBox(thePrefs.ResMisc(18), m_htiDisplayGroup, m_bShowDiffqr); //>> pP: DiffQR [jva]


		// stuff to manipulte the lists:
		//>> evl: FunnyNicks [xrmb]
		m_htiFunnyNick_Group     = m_ctrlTreeOptions.InsertGroup(      thePrefs.ResFN(0), iImgFN, TVI_ROOT);
		m_htiFunnyNick_Show      = m_ctrlTreeOptions.InsertCheckBox(   thePrefs.ResFN(1), m_htiFunnyNick_Group, m_bFunnyNick_Show);
		m_htiFunnyNick_Group_Type= m_ctrlTreeOptions.InsertGroup(      thePrefs.ResFN(2), iImgDisplay, m_htiFunnyNick_Group);
		m_htiFunnyNick_Long      = m_ctrlTreeOptions.InsertRadioButton(thePrefs.ResFN(3), m_htiFunnyNick_Group_Type, m_iFunnyNick_Type == 0);
		m_htiFunnyNick_Short     = m_ctrlTreeOptions.InsertRadioButton(thePrefs.ResFN(4), m_htiFunnyNick_Group_Type, m_iFunnyNick_Type == 1);
		m_htiFunnyNick_None      = m_ctrlTreeOptions.InsertRadioButton(thePrefs.ResFN(10),m_htiFunnyNick_Group_Type, m_iFunnyNick_Type == 2);
		m_htiFunnyNick_Group_Pos = m_ctrlTreeOptions.InsertGroup(      thePrefs.ResFN(5), iImgDisplay, m_htiFunnyNick_Group);
		m_htiFunnyNick_Front     = m_ctrlTreeOptions.InsertRadioButton(thePrefs.ResFN(6), m_htiFunnyNick_Group_Pos, m_iFunnyNick_Pos  == 0);
		m_htiFunnyNick_back      = m_ctrlTreeOptions.InsertRadioButton(thePrefs.ResFN(7), m_htiFunnyNick_Group_Pos, m_iFunnyNick_Pos  == 1);
		//>> evl: FunnyNicks [xrmb]
		//>> evl: IP2C [EastShare]
		m_htiI2CGroup		= m_ctrlTreeOptions.InsertGroup(      thePrefs.ResIP2C(0),	iImgIP2C,      TVI_ROOT);
		m_htiI2CShowFlag	= m_ctrlTreeOptions.InsertCheckBox(   thePrefs.ResIP2C(4),	m_htiI2CGroup, m_bI2CShowFlag);
		m_htiIP2CFileFlags  = m_ctrlTreeOptions.InsertCheckBox(   thePrefs.ResIP2C(5),	m_htiI2CGroup, m_bIP2CFileFlags);
		m_htiIP2CUpdate     = m_ctrlTreeOptions.InsertCheckBox(   thePrefs.ResIP2C(6),	m_htiI2CGroup, m_bIP2CUpdate);
		m_htiI2CCapGroup	= m_ctrlTreeOptions.InsertGroup(      thePrefs.ResIP2C(7),	iImgIP2C,      m_htiI2CGroup);
		m_htiI2C2Letter		= m_ctrlTreeOptions.InsertRadioButton(thePrefs.ResIP2C(1),	m_htiI2CCapGroup, m_iI2CCaption == 0);
		m_htiI2C3Letter		= m_ctrlTreeOptions.InsertRadioButton(thePrefs.ResIP2C(2),	m_htiI2CCapGroup, m_iI2CCaption == 1);
		m_htiI2CFullCaption	= m_ctrlTreeOptions.InsertRadioButton(thePrefs.ResIP2C(3),	m_htiI2CCapGroup, m_iI2CCaption == 2);
		//<< evl: IP2C [EastShare]

		//>> evl: ModIconDLL [WiZaRd/Shadow2004]
		m_htiModIconGrp		     = m_ctrlTreeOptions.InsertGroup(thePrefs.ResMIM(0),    iImgModIcon,     TVI_ROOT);
		m_htiShowModIcons		 = m_ctrlTreeOptions.InsertCheckBox(thePrefs.ResMIM(1), m_htiModIconGrp, m_bShowModIcons);
		m_htiModIconUpdate       = m_ctrlTreeOptions.InsertCheckBox(thePrefs.ResMIM(2),	m_htiModIconGrp, m_bModIconUpdate);
		//<< evl: ModIconDLL [WiZaRd/Shadow2004]

		//>> pP: ColoredActiveDLs
		m_htiGrpColor  = m_ctrlTreeOptions.InsertGroup(thePrefs.ResColor(0), iImgCol, TVI_ROOT);
		m_htiColBLK    = m_ctrlTreeOptions.InsertRadioButton(thePrefs.ResColor(1), m_htiGrpColor, m_iColorNr == 0);
		m_htiColGRN    = m_ctrlTreeOptions.InsertRadioButton(thePrefs.ResColor(2), m_htiGrpColor, m_iColorNr == 1);
		m_htiColBLU    = m_ctrlTreeOptions.InsertRadioButton(thePrefs.ResColor(3), m_htiGrpColor, m_iColorNr == 2);
		m_htiColRED    = m_ctrlTreeOptions.InsertRadioButton(thePrefs.ResColor(4), m_htiGrpColor, m_iColorNr == 3);
		m_htiColYEL    = m_ctrlTreeOptions.InsertRadioButton(thePrefs.ResColor(5), m_htiGrpColor, m_iColorNr == 4);
		m_htiColGRY    = m_ctrlTreeOptions.InsertRadioButton(thePrefs.ResColor(6), m_htiGrpColor, m_iColorNr == 5);
		m_htiColorName = m_ctrlTreeOptions.InsertCheckBox(   thePrefs.ResColor(8), m_htiGrpColor, m_bColorName);
		m_htiBoldDLs   = m_ctrlTreeOptions.InsertCheckBox(   thePrefs.ResColor(7), m_htiGrpColor, m_bBoldDLs); //>> pP: BoldActiveDLs
		//<< pP: ColoredActiveDLs

		// expand/collapse
		m_ctrlTreeOptions.Expand(m_htiI2CGroup,			TVE_EXPAND);
		m_ctrlTreeOptions.Expand(m_htiModIconGrp,		TVE_EXPAND);
		m_ctrlTreeOptions.Expand(m_htiGrpColor,			TVE_EXPAND);
		m_ctrlTreeOptions.Expand(m_htiFunnyNick_Group,	TVE_EXPAND);

        m_ctrlTreeOptions.SendMessage(WM_VSCROLL, SB_TOP);
        m_bInitializedTreeOpts = true;
	}

	//>> evl: IP2C [EastShare]
	//DDX_TreeRadio(pDX, IDC_PP_OPTS2, m_htiI2CGroup,      m_iI2CCaption);
	DDX_TreeCheck(pDX, IDC_PP_OPTS2, m_htiI2CShowFlag,   m_bI2CShowFlag);
	DDX_TreeCheck(pDX, IDC_PP_OPTS2, m_htiIP2CFileFlags, m_bIP2CFileFlags);
	DDX_TreeCheck(pDX, IDC_PP_OPTS2, m_htiIP2CUpdate,    m_bIP2CUpdate);
	DDX_TreeRadio(pDX, IDC_PP_OPTS2, m_htiI2CCapGroup,	 m_iI2CCaption);
	//<< evl: IP2C [EastShare]

	//>> evl: FunnyNicks [xrmb]
	DDX_TreeCheck(pDX, IDC_PP_OPTS2, m_htiFunnyNick_Show, m_bFunnyNick_Show);
	DDX_TreeRadio(pDX, IDC_PP_OPTS2, m_htiFunnyNick_Group_Type, m_iFunnyNick_Type);
	DDX_TreeRadio(pDX, IDC_PP_OPTS2, m_htiFunnyNick_Group_Pos,  m_iFunnyNick_Pos);
	//<< evl: FunnyNicks [xrmb]

	//>> evl: ModIconDLL [WiZaRd/Shadow2004]
	DDX_TreeCheck(pDX, IDC_PP_OPTS2, m_htiShowModIcons, m_bShowModIcons);
	DDX_TreeCheck(pDX, IDC_PP_OPTS2, m_htiModIconUpdate, m_bModIconUpdate);
	//>> evl: ModIconDLL [WiZaRd/Shadow2004]
	DDX_TreeCheck(pDX, IDC_PP_OPTS2, m_htiBoldDLs, m_bBoldDLs);  //>> pP: BoldActiveDLs
	DDX_TreeRadio(pDX, IDC_PP_OPTS2, m_htiGrpColor, m_iColorNr); //>> pP: ColoredActiveDLs
	DDX_TreeCheck(pDX, IDC_PP_OPTS2, m_htiColorName, m_bColorName); //>> pP: ColoredActiveDLs

	DDX_TreeCheck(pDX, IDC_PP_OPTS2, m_htiClientPercentages, m_bClientPercentages); // X-Ray :: ClientPercentage
	DDX_TreeCheck(pDX, IDC_PP_OPTS2, m_htiChunkDots, m_bChunkDots); //>> pP: Chunkdots [Slugfiller]
	DDX_TreeCheck(pDX, IDC_PP_OPTS2, m_htiShowDiffQR, m_bShowDiffqr); //>> pP: DiffQR [jva]

}

BOOL CPPgTweaksMod2::OnInitDialog()
{
	m_bClientPercentages = thePrefs.GetUseClientPercentage(); // X-Ray :: ClientPercentage
	m_bChunkDots = thePrefs.GetShowChunkdots();//>> pP: Chunkdots [Slugfiller]
	m_bShowDiffqr = thePrefs.GetShowDiffQR(); //>> pP: DiffQR [jva]
	m_iColorNr = thePrefs.GetDownloadColor();
	m_bColorName = thePrefs.GetColorNameOnly();
	m_bBoldDLs = thePrefs.GetShowDownloadsBold();

	//>> evl: ModIconDLL [WiZaRd/Shadow2004]
	m_bShowModIcons = thePrefs.GetShowModIcons();
	m_bModIconUpdate= thePrefs.IsAutoUpdateModIconDllEnabled();
	//<< evl: ModIconDLL [WiZaRd/Shadow2004]

	//>> evl: FunnyNicks [xrmb]
	m_bFunnyNick_Show = thePrefs.GetDisplayFunnyNick();
	m_iFunnyNick_Pos  = thePrefs.GetDisplayFunnyNickAfterName();
	m_iFunnyNick_Type = thePrefs.GetFunnyNickTagLength();
	//<< evl: FunnyNicks [xrmb]

	//>> evl: IP2C [EastShare]
	m_bI2CShowFlag   = thePrefs.IsIP2CountryShowFlag();
	m_bIP2CFileFlags = thePrefs.GetIP2CoutryFlagsOnFiles();
	m_bIP2CUpdate    = thePrefs.GetAutoUpdateIP2Country();
	m_iI2CCaption    = thePrefs.GetIP2CountryNameMode();
	//<< evl: IP2C [EastShare]

	m_ctrlTreeOptions.SetImageListColorFlags(theApp.m_iDfltImageListColorFlags);
    CPropertyPage::OnInitDialog();
	InitWindowStyles(this);
	m_ctrlTreeOptions.SetItemHeight(m_ctrlTreeOptions.GetItemHeight() + 2);

	return TRUE;  // return TRUE unless you set the focus to a control
				  // EXCEPTION: OCX Property Pages should return FALSE
}

BOOL CPPgTweaksMod2::OnKillActive()
{
	// if prop page is closed by pressing ENTER we have to explicitly commit any possibly pending
	// data from an open edit control
	m_ctrlTreeOptions.HandleChildControlLosingFocus();
	return CPropertyPage::OnKillActive();
}

BOOL CPPgTweaksMod2::OnApply()
{
	// if prop page is closed by pressing ENTER we have to explicitly commit any possibly pending
	// data from an open edit control
	m_ctrlTreeOptions.HandleChildControlLosingFocus();

	if (!UpdateData())
		return FALSE;

	thePrefs.SetUseClientPercentage(m_bClientPercentages); // X-Ray :: ClientPercentage
	thePrefs.SetShowChunkdots(m_bChunkDots); //>> pP: Chunkdots [Slugfiller]
	thePrefs.SetShowDiffQR(m_bShowDiffqr); //>> pP: DiffQR [jva]
	//>> pP: ColoredActiveDLs
	thePrefs.SetColorNameOnly(m_bColorName);
	if (m_iColorNr > 5 || m_iColorNr < 0)
		m_iColorNr = 0;

	DWORD dwColor = 0;
	switch (m_iColorNr)
	{
		case  0: dwColor = RGB(0,0,0);       break; //black
		case  1: dwColor = RGB(192,  0,  0); break; //Red
		case  2: dwColor = RGB(  0,140,  0); break; //Green
		case  3: dwColor = RGB(  0,  0,211); break; //Blue
		case  4: dwColor = RGB(192,192,192); break; //Grey
		case  5: dwColor = RGB(230,200, 60); break; //Yellow
	}
	thePrefs.SetDownloadColor((uint8)m_iColorNr);
	thePrefs.SetDownloadColorCode(dwColor);
	thePrefs.SetShowDownloadsBold(m_bBoldDLs);
	thePrefs.m_bShowActiveDownloadsBold = m_bBoldDLs;
	//<< pP: ColoredActiveDLs



	//>> evl: FunnyNicks [xrmb]
	//>> pP: update on changes
	bool bChange =	thePrefs.GetDisplayFunnyNick()				!= m_bFunnyNick_Show   || 
					thePrefs.GetDisplayFunnyNickAfterName()==1	!= m_iFunnyNick_Pos==1 ||
					thePrefs.GetFunnyNickTagLength()			!= m_iFunnyNick_Type;
	//<< pP: update on changes
	thePrefs.SetDisplayFunnyNick(m_bFunnyNick_Show);
	thePrefs.SetDisplayFunnyNickAfterName(m_iFunnyNick_Pos==1);
	thePrefs.SetFunnyNickTagLength((uint8)m_iFunnyNick_Type);
	//>> pP: update on changes
	if (bChange)
		theApp.clientlist->UpdateFunnyNicks(); // update all Funny Nicks here...
	//<< pP: update on changes
	//<< evl: FunnyNicks [xrmb]

	//>> pP: check for missing files
	bool bMissIP2C = (m_bI2CShowFlag != thePrefs.IsIP2CountryShowFlag() // settings changed
					 && m_bI2CShowFlag && !m_bIP2CUpdate // flag are enabled, autoupdate is off
					 && (   !PathFileExists(thePrefs.GetMuleDirectory(EMULE_CONFIGDIR) + L"countryflag32.dll")      // hires lib missing
						 || !PathFileExists(thePrefs.GetMuleDirectory(EMULE_CONFIGDIR) + L"countryflag.dll")        // lores lib missing
						 || !PathFileExists(thePrefs.GetMuleDirectory(EMULE_CONFIGDIR) + DFLT_IP2COUNTRY_FILENAME)  // countrylist missing
					    )
					 );

	bool bMissMiM = (m_bShowModIcons != thePrefs.GetShowModIcons() // settings changed
					 && m_bShowModIcons && !m_bModIconUpdate // icons are enabled, autoupdate is off
					 && !PathFileExists(thePrefs.GetMuleDirectory(EMULE_CONFIGDIR) + DFLT_MODICONDLL_FILENAME)
					);

	if (bMissMiM || bMissIP2C)
	{
		CString s = L"You activated ";

		if (bMissIP2C && bMissMiM)
			s.Append(L"Ip2Country & ModIcons");
		else if (bMissMiM)
			s.Append(L"ModIcons");
		else
			s.Append(L"Ip2Country");
	
		s.Append(L", but there are some needed files missing\r\nand AutoUpdate is switched off. Do you want to download these files now once\r\nfrom www.emulesector.eu (Katanas homeboard)?\r\nOtherwise the feature(s) will be turned off again.");

		if(AfxMessageBox(s, MB_ICONQUESTION|MB_YESNO) == IDYES)
			theApp.ip2country->UpdateIP2CountryURL();
		else
			m_bI2CShowFlag = false;
	}
	//<< pP: check for missing files

	//>> evl: ModIconDLL [WiZaRd/Shadow2004]
	thePrefs.SetShowModIcons(m_bShowModIcons);
	thePrefs.SetAutoUpdateModIconDll(m_bModIconUpdate);
	//<< evl: ModIconDLL [WiZaRd/Shadow2004]

	//>> evl: IP2C [EastShare]
	thePrefs.SetIP2CountryShowFlag(m_bI2CShowFlag);
	thePrefs.SetIP2CoutryFlagsOnFiles(m_bIP2CFileFlags);
	thePrefs.SetAutoUpdateIP2Country(m_bIP2CUpdate);
	thePrefs.SetIP2CountryNameMode((uint8)m_iI2CCaption);

	//Check if ip2country is loaded at this point
	if (!theApp.ip2country->IsIP2Country())
		theApp.ip2country->Load();
	theApp.ip2country->Refresh();
	//<< evl: IP2C [EastShare]

	SetModified(FALSE);
	return CPropertyPage::OnApply();
}

//void CPPgTweaksMod2::OnHScroll(UINT /*nSBCode*/, UINT /*nPos*/, CScrollBar* pScrollBar){}
//void CPPgTweaksMod2::Localize(void){if(m_hWnd){;}}

void CPPgTweaksMod2::OnDestroy()
{
	m_ctrlTreeOptions.DeleteAllItems();
	m_ctrlTreeOptions.DestroyWindow();
	m_bInitializedTreeOpts = false;

	SetNull();
    
    CPropertyPage::OnDestroy();
}

LRESULT CPPgTweaksMod2::OnTreeOptsCtrlNotify(WPARAM wParam, LPARAM /*lParam*/)
{
	if (wParam == IDC_PP_OPTS2)
		SetModified();

	return 0;
}

void CPPgTweaksMod2::OnHelp(){ShellExecute(NULL, NULL, MOD_FORUMLINK, NULL, thePrefs.GetMuleDirectory(EMULE_EXECUTEABLEDIR), SW_SHOWDEFAULT);}
BOOL CPPgTweaksMod2::OnCommand(WPARAM wParam, LPARAM lParam){if (wParam == ID_HELP){OnHelp();return TRUE;}return __super::OnCommand(wParam, lParam);}
BOOL CPPgTweaksMod2::OnHelpInfo(HELPINFO*){OnHelp();return TRUE;}

void CPPgTweaksMod2::SetNull()
{
	//>> evl: FunnyNicks [xrmb]
	m_htiDisplayGroup    = NULL;
	m_htiListAddonGroup  = NULL;
	m_htiFunnyNick_Group = NULL;
	m_htiFunnyNick_Group_Pos  = NULL;
	m_htiFunnyNick_Group_Type = NULL;
	m_htiFunnyNick_Long  = NULL;
	m_htiFunnyNick_Short = NULL;
	m_htiFunnyNick_None  = NULL;
	m_htiFunnyNick_Front = NULL;
	m_htiFunnyNick_back  = NULL;
	m_htiFunnyNick_Show  = NULL;
	m_bFunnyNick_Show = 0;
	m_iFunnyNick_Pos  = 0;
	m_iFunnyNick_Type = 0;
	//>> evl: FunnyNicks [xrmb]

	//>> evl: ModIconDLL [WiZaRd/Shadow2004]
	m_htiShowModIcons	= NULL;
	m_htiModIconGrp		= NULL;
	m_htiModIconUpdate	= NULL;
	m_bModIconUpdate	= 0;
	m_bShowModIcons		= 0;
	//<< evl: ModIconDLL [WiZaRd/Shadow2004]

	//>> pP: Chunkdots [Slugfiller]
	m_htiChunkDots = NULL;
	m_bChunkDots = 0;
	//<< pP: Chunkdots [Slugfiller]

	//>> evl: IP2C [EastShare]
	m_htiI2CGroup = NULL;
	m_htiI2CCapGroup = NULL;
	m_htiI2C2Letter = NULL;
	m_htiI2C3Letter = NULL;
	m_htiI2CFullCaption = NULL;
	m_htiI2CShowFlag = NULL;
	m_htiIP2CFileFlags = NULL;
	m_htiIP2CUpdate = NULL;
	m_bIP2CUpdate = false;
	m_iI2CCaption = 0;
	m_bI2CShowFlag = false;
	m_bIP2CFileFlags = false;
	//<< evl: IP2C [EastShare]

	m_htiGrpColor = NULL;
	m_htiBoldDLs = NULL;
	m_htiColBLK = NULL;
	m_htiColYEL = NULL;
	m_htiColBLU = NULL;
	m_htiColRED = NULL;
	m_htiColGRN = NULL;
	m_htiColGRY = NULL;
	m_bBoldDLs = 0;
	m_iColorNr = 0;
	m_bColorName = 0;
	m_htiColorName = NULL;

	// X-Ray :: ClientPercentage :: Start
	m_htiClientPercentages = NULL;
	m_bClientPercentages = false;
	// X-Ray :: ClientPercentage :: End

	//>> pP: DiffQR [jva]
	m_htiShowDiffQR = NULL;
	m_bShowDiffqr = false;
	//<< pP: DiffQR [jva]
}

void CPPgTweaksMod2::Localize(void)
{
	if (m_hWnd)
	{
		CString str;
		str.Format(L"%s 2 (Mod)", GetResString(IDS_PW_TWEAK));
		SetWindowText(str);

		//Display tweaks
		if (m_htiDisplayGroup)			m_ctrlTreeOptions.SetItemText(m_htiDisplayGroup, GetResString(IDS_PW_DISPLAY));
		if (m_htiFunnyNick_Group)       m_ctrlTreeOptions.SetItemText(m_htiFunnyNick_Group, thePrefs.ResFN(0));
		if (m_htiFunnyNick_Show )       m_ctrlTreeOptions.SetItemText(m_htiFunnyNick_Show,  thePrefs.ResFN(1));
		if (m_htiFunnyNick_Group_Type)  m_ctrlTreeOptions.SetItemText(m_htiFunnyNick_Group_Type, thePrefs.ResFN(2));
		if (m_htiFunnyNick_Long)        m_ctrlTreeOptions.SetEditLabel(m_htiFunnyNick_Long, thePrefs.ResFN(3));
		if (m_htiFunnyNick_Short)       m_ctrlTreeOptions.SetEditLabel(m_htiFunnyNick_Short, thePrefs.ResFN(4));
		if (m_htiFunnyNick_None)        m_ctrlTreeOptions.SetEditLabel(m_htiFunnyNick_None, thePrefs.ResFN(10));
		if (m_htiFunnyNick_Group_Pos)   m_ctrlTreeOptions.SetItemText(m_htiFunnyNick_Group_Pos, thePrefs.ResFN(5));
		if (m_htiFunnyNick_Front)       m_ctrlTreeOptions.SetEditLabel(m_htiFunnyNick_Front, thePrefs.ResFN(6));
		if (m_htiFunnyNick_back )       m_ctrlTreeOptions.SetEditLabel(m_htiFunnyNick_back, thePrefs.ResFN(7));
		//>> evl: FunnyNicks [xrmb]

		//>> evl: IP2C [EastShare]
		if (m_htiI2CGroup)		        m_ctrlTreeOptions.SetItemText(m_htiI2CGroup, thePrefs.ResIP2C(0));
		if (m_htiI2C2Letter)		    m_ctrlTreeOptions.SetEditLabel(m_htiI2C2Letter, thePrefs.ResIP2C(1));
		if (m_htiI2C3Letter)	        m_ctrlTreeOptions.SetEditLabel(m_htiI2C3Letter, thePrefs.ResIP2C(2));
		if (m_htiI2CFullCaption)	    m_ctrlTreeOptions.SetEditLabel(m_htiI2CFullCaption, thePrefs.ResIP2C(3));
		if (m_htiI2CShowFlag)	        m_ctrlTreeOptions.SetItemText(m_htiI2CShowFlag, thePrefs.ResIP2C(4));
		if (m_htiIP2CFileFlags)         m_ctrlTreeOptions.SetItemText(m_htiIP2CFileFlags, thePrefs.ResIP2C(5));
		if (m_htiIP2CUpdate)            m_ctrlTreeOptions.SetItemText(m_htiIP2CUpdate, thePrefs.ResIP2C(6));
		if (m_htiI2CCapGroup)		    m_ctrlTreeOptions.SetItemText(m_htiI2CCapGroup, thePrefs.ResIP2C(7));
		//<< evl: IP2C [EastShare]

		//>> evl: ModIconDLL [WiZaRd/Shadow2004]
		if (m_htiModIconGrp)		    m_ctrlTreeOptions.SetItemText(m_htiModIconGrp, thePrefs.ResMIM(0));
		if (m_htiShowModIcons)		    m_ctrlTreeOptions.SetItemText(m_htiShowModIcons, thePrefs.ResMIM(1));
		if (m_htiModIconUpdate)         m_ctrlTreeOptions.SetItemText(m_htiModIconUpdate, thePrefs.ResMIM(2));
		//<< evl: ModIconDLL [WiZaRd/Shadow2004]

		//>> pP: ColoredActiveDLs
		if (m_htiGrpColor)   m_ctrlTreeOptions.SetItemText(m_htiGrpColor, thePrefs.ResColor(0));
		if (m_htiColBLK)     m_ctrlTreeOptions.SetEditLabel(m_htiColBLK, thePrefs.ResColor(1));
		if (m_htiColGRN)     m_ctrlTreeOptions.SetEditLabel(m_htiColGRN, thePrefs.ResColor(2));
		if (m_htiColBLU)     m_ctrlTreeOptions.SetEditLabel(m_htiColBLU, thePrefs.ResColor(3));
		if (m_htiColRED)     m_ctrlTreeOptions.SetEditLabel(m_htiColRED, thePrefs.ResColor(4));
		if (m_htiColYEL)     m_ctrlTreeOptions.SetEditLabel(m_htiColYEL, thePrefs.ResColor(5));
		if (m_htiColGRY)     m_ctrlTreeOptions.SetEditLabel(m_htiColGRY, thePrefs.ResColor(6));
		if (m_htiBoldDLs)    m_ctrlTreeOptions.SetItemText(m_htiBoldDLs ,thePrefs.ResColor(7)); //>> pP: BoldActiveDLs
		if (m_htiColorName)  m_ctrlTreeOptions.SetItemText(m_htiColorName, thePrefs.ResColor(8));
		//<< pP: ColoredActiveDLs

		if (m_htiChunkDots)     m_ctrlTreeOptions.SetItemText(m_htiChunkDots, thePrefs.ResFN(9));	//>> pP: Chunkdots [Slugfiller]
		if (m_htiClientPercentages) m_ctrlTreeOptions.SetItemText(m_htiClientPercentages, thePrefs.ResMisc(16)); // X-Ray :: ClientPercentage :: Start
		if (m_htiShowDiffQR)	m_ctrlTreeOptions.SetItemText(m_htiShowDiffQR, thePrefs.ResMisc(18)); //>> pP: DiffQR [jva]
	}
}