//this file is part of eMule
//Copyright (C)2006 David Xanatos ( Xanatos@Lycos.at / http://neomule.sourceforge.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include "stdafx.h" 
#include "emule.h"
#include "UpDownClient.h"
#include "UserMsgs.h"
#include "ClientCredits.h"
#include "Preferences.h"
#include "AntileechInfo.h"
#include "ClientAnalyzer.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

///////////////////////////////////////////////////////////////////////////////
// CAntileechInfoPage

IMPLEMENT_DYNAMIC(CAntileechInfoPage, CResizablePage)

BEGIN_MESSAGE_MAP(CAntileechInfoPage, CResizablePage)
	ON_MESSAGE(UM_DATA_CHANGED, OnDataChanged)
END_MESSAGE_MAP()

CAntileechInfoPage::CAntileechInfoPage()
	: CResizablePage(CAntileechInfoPage::IDD,0)
{
	m_paClients = NULL;
	m_bDataChanged = false;
	m_strCaption = L"Antileech Info";
	m_psp.pszTitle = m_strCaption;
	m_psp.dwFlags |= PSP_USETITLE;
}

CAntileechInfoPage::~CAntileechInfoPage(){}

void CAntileechInfoPage::DoDataExchange(CDataExchange* pDX)
{
	CResizablePage::DoDataExchange(pDX);
}

BOOL CAntileechInfoPage::OnInitDialog()
{
	CResizablePage::OnInitDialog();
	InitWindowStyles(this);

	Localize();
	return TRUE;
}

BOOL CAntileechInfoPage::OnSetActive()
{
	if (!CResizablePage::OnSetActive())
		return FALSE;

	if (m_bDataChanged)
	{
		CUpDownClient* client = STATIC_DOWNCAST(CUpDownClient, (*m_paClients)[0]);
		if (client && client->GetAntiLeechData())
		{
			CString str = L"";
// username
			//>> pP: FunnyNick
			if (client->GetUserName())
			{
				str = client->GetUserName();
				if (thePrefs.GetDisplayFunnyNick() && client->HasFunnyNick())
					str.AppendFormat(L" (Real: %s)", client->GetUserName(false));

				GetDlgItem(IDC_CDA_FULLUSERNAME)->SetWindowText(str);
			}
			else
				GetDlgItem(IDC_CDA_FULLUSERNAME)->SetWindowText(GetResString(IDS_UNKNOWN));
			//>> pP: FunnyNick
// Modname
			GetDlgItem(IDC_CDA_MODNAMEFULL)->SetWindowText(client->DbgGetFullClientSoftVer());
// uploads
			GetDlgItem(IDC_CDA_ULCOMP)->SetWindowText(CastItoXBytes(client->GetAntiLeechData()->GetDownloadedFull(), false, false));
			GetDlgItem(IDC_CDA_ULPART)->SetWindowText(CastItoXBytes(client->GetAntiLeechData()->GetDownloadedPartial(), false, false));
			GetDlgItem(IDC_CDA_ULRARE)->SetWindowText(CastItoXBytes(client->GetAntiLeechData()->GetDownloadedRare(), false, false));
			GetDlgItem(IDC_CDA_ULTOTAL)->SetWindowText(CastItoXBytes(client->GetAntiLeechData()->GetDownloadedTotal(), false, false));
// downloads
			GetDlgItem(IDC_CDA_DLCOMP)->SetWindowText(CastItoXBytes(client->GetAntiLeechData()->GetUploadedFull(), false, false));
			GetDlgItem(IDC_CDA_DLPART)->SetWindowText(CastItoXBytes(client->GetAntiLeechData()->GetUploadedPartial(), false, false));
			GetDlgItem(IDC_CDA_DLRARE)->SetWindowText(CastItoXBytes(client->GetAntiLeechData()->GetUploadedRare(), false, false));
			GetDlgItem(IDC_CDA_DLTOTAL)->SetWindowText(CastItoXBytes(client->GetAntiLeechData()->GetUploadedTotal(), false, false));
// ud ratio
			uint64 chunksDL =  (uint64)((double)client->GetAntiLeechData()->GetDownloadedTotal()/PARTSIZE + AT_ROUNDOFFSET);
			uint64 chunksUL =  (uint64)((double)client->GetAntiLeechData()->GetUploadedTotal()/PARTSIZE + AT_ROUNDOFFSET);

			if (!chunksUL && !chunksDL)
				GetDlgItem(IDC_CDA_UDRATING)->SetWindowText(L"");
			if(chunksDL < chunksUL)
				GetDlgItem(IDC_CDA_UDRATING)->SetWindowText(GetResString(IDS_CDA_BAD));
			else
				GetDlgItem(IDC_CDA_UDRATING)->SetWindowText(GetResString(IDS_CDA_GOOD));

			str.Format(L"%I64u/%I64u", chunksUL, chunksDL);
			GetDlgItem(IDC_CDA_UDCHUNKS)->SetWindowText(str);
// failed ul/dl
			str.Format(L"%u/%u", client->GetAntiLeechData()->GetBadULSessions(), client->GetAntiLeechData()->GetBadDLSessions());
			GetDlgItem(IDC_CDA_FAILED)->SetWindowText(str);
// behaviour
			GetDlgItem(IDC_CDA_NICKTHIEFINFO)->SetWindowText((client->GetAntiLeechData()->GetBadForThisSession() & AT_NICKTHIEF)   ? GetResString(IDS_YES) : GetResString(IDS_NO));
			GetDlgItem(IDC_CDA_MODTHIEFINFO)->SetWindowText((client->GetAntiLeechData()->GetBadForThisSession()  & AT_MODTHIEF)    ? GetResString(IDS_YES) : GetResString(IDS_NO));
			GetDlgItem(IDC_CDA_MODFAKERINFO)->SetWindowText((client->GetAntiLeechData()->GetBadForThisSession()  & AT_MODFAKER)    ? GetResString(IDS_YES) : GetResString(IDS_NO));
			GetDlgItem(IDC_CDA_FILEFAKERINFO)->SetWindowText((client->GetAntiLeechData()->GetBadForThisSession() & AT_UDPFNFFAKER) ? GetResString(IDS_YES) : GetResString(IDS_NO));

			if (client->GetAntiLeechData()->GetSpams())
				str.Format(L"%u", client->GetAntiLeechData()->GetSpams());
			else
				str = GetResString(IDS_CDA_NONE);
			GetDlgItem(IDC_CDA_SPAMMERINFO)->SetWindowText(str);

			if (client->GetAntiLeechData()->GetFastXSAsks())
				str.Format(L"%u", client->GetAntiLeechData()->GetFastXSAsks());
			else
				str = GetResString(IDS_CDA_NONE);
			GetDlgItem(IDC_CDA_FASTXSINFO)->SetWindowText(str);

			if(client->GetAntiLeechData()->IsXSExploiter())
				str.Format(L"%u | %u", client->GetAntiLeechData()->GetXSAsks(), client->GetAntiLeechData()->GetXSAnsw());
			else
				str = GetResString(IDS_CDA_NONE);
			GetDlgItem(IDC_CDA_XSEXPLOITINFO)->SetWindowText(str);

			str.Format(L"%u @ %s avg", client->GetAntiLeechData()->GetReaskCount(), CastSecondsToHM(client->GetAntiLeechData()->GetAvgReaskTime()/1000));
			GetDlgItem(IDC_CDA_REASKINFO)->SetWindowText(str);
// hashlist
			if (client->GetIsGPLEvilMod() && client->GetIsGPLEvilNick())
				str.Format(L"Bad Nick & Mod");
			else if (client->GetIsGPLEvilNick())
				str.Format(L"Bad Nick");
			else if (client->GetIsGPLEvilMod())
				str.Format(L"Bad Mod");
			else
				str = GetResString(IDS_NO);
			GetDlgItem(IDC_CDA_GPLINFO)->SetWindowText(str);
			GetDlgItem(IDC_CDA_FINCANINFO)->SetWindowText((client->GetIsFincanMod()) ? GetResString(IDS_YES) : GetResString(IDS_NO));
			GetDlgItem(IDC_CDA_SUILEECHERINFO)->SetWindowText((client->GetIsSuiFaker()) ? GetResString(IDS_YES) : GetResString(IDS_NO));
// icons
			HICON hClient;
			//>> pP: ClientAnalyzer [Wizard]
			if (client->IsBanned() || (client->IsBadGuy() && thePrefs.UseCreditSystem()==2))
				hClient = theApp.LoadIcon(L"BADGUY", 16, 16);
			//<< pP: ClientAnalyzer [Wizard]
			else if(client->IsFriend())
				hClient = theApp.LoadIcon(_T("FRIEND"), 16, 16);
			else
				hClient = theApp.LoadIcon(_T("STATSCLIENTS"), 16, 16);
			((CStatic*)GetDlgItem(IDC_CDA_CLIENTICON))->SetIcon(hClient);

			HICON hTranfer;
			if (chunksUL > 0 && chunksDL > 0)
				hTranfer = theApp.LoadIcon(_T("UP1DOWN1"), 16, 16);
			else if (chunksDL > 0)
				hTranfer = theApp.LoadIcon(_T("UP0DOWN1"), 16, 16);
			else if (chunksUL > 0)
				hTranfer = theApp.LoadIcon(_T("UP1DOWN0"), 16, 16);
			else
				hTranfer = theApp.LoadIcon(_T("UP0DOWN0"), 16, 16);
			((CStatic*)GetDlgItem(IDC_CDA_TRANSICON))->SetIcon(hTranfer);

			HICON hBehave;
			hBehave = theApp.LoadIcon(_T("SRCUNKNOWN"), 16, 16);
			((CStatic*)GetDlgItem(IDC_CDA_BEHAVEICON))->SetIcon(hBehave);

			HICON hHashList;
			if (client->GetIsBadMod())
				hHashList = theApp.LoadIcon(_T("VERYBADGUY"), 16, 16);
			else
				hHashList = theApp.LoadIcon(_T("SRCDOWNLOADING"), 16, 16);
			((CStatic*)GetDlgItem(IDC_CDA_HASHICON))->SetIcon(hHashList);
		}
		else
		{
// nothing stored
			GetDlgItem(IDC_CDA_FULLUSERNAME)->SetWindowText(GetResString(IDS_UNKNOWN));
			GetDlgItem(IDC_CDA_MODNAMEFULL)->SetWindowText(GetResString(IDS_UNKNOWN));
			GetDlgItem(IDC_CDA_ULCOMP)->SetWindowText(GetResString(IDS_UNKNOWN));
			GetDlgItem(IDC_CDA_ULPART)->SetWindowText(GetResString(IDS_UNKNOWN));
			GetDlgItem(IDC_CDA_ULRARE)->SetWindowText(GetResString(IDS_UNKNOWN));
			GetDlgItem(IDC_CDA_ULTOTAL)->SetWindowText(GetResString(IDS_UNKNOWN));
			GetDlgItem(IDC_CDA_DLCOMP)->SetWindowText(GetResString(IDS_UNKNOWN));
			GetDlgItem(IDC_CDA_DLPART)->SetWindowText(GetResString(IDS_UNKNOWN));
			GetDlgItem(IDC_CDA_DLRARE)->SetWindowText(GetResString(IDS_UNKNOWN));
			GetDlgItem(IDC_CDA_DLTOTAL)->SetWindowText(GetResString(IDS_UNKNOWN));
			GetDlgItem(IDC_CDA_UDCHUNKS)->SetWindowText(GetResString(IDS_UNKNOWN));
			GetDlgItem(IDC_CDA_UDRATING)->SetWindowText(L"");
			GetDlgItem(IDC_CDA_FAILED)->SetWindowText(GetResString(IDS_UNKNOWN));
			GetDlgItem(IDC_CDA_NICKTHIEFINFO)->SetWindowText(GetResString(IDS_UNKNOWN));
			GetDlgItem(IDC_CDA_MODTHIEFINFO)->SetWindowText(GetResString(IDS_UNKNOWN));
			GetDlgItem(IDC_CDA_MODFAKERINFO)->SetWindowText(GetResString(IDS_UNKNOWN));
			GetDlgItem(IDC_CDA_FILEFAKERINFO)->SetWindowText(GetResString(IDS_UNKNOWN));
			GetDlgItem(IDC_CDA_SPAMMERINFO)->SetWindowText(GetResString(IDS_UNKNOWN));
			GetDlgItem(IDC_CDA_FASTXSINFO)->SetWindowText(GetResString(IDS_UNKNOWN));
			GetDlgItem(IDC_CDA_XSEXPLOITINFO)->SetWindowText(GetResString(IDS_UNKNOWN));
			GetDlgItem(IDC_CDA_REASKINFO)->SetWindowText(GetResString(IDS_UNKNOWN));
			GetDlgItem(IDC_CDA_GPLINFO)->SetWindowText(GetResString(IDS_UNKNOWN));
			GetDlgItem(IDC_CDA_FINCANINFO)->SetWindowText(GetResString(IDS_UNKNOWN));
			GetDlgItem(IDC_CDA_SUILEECHERINFO)->SetWindowText(GetResString(IDS_UNKNOWN));

			HICON hNuthin = theApp.LoadIcon(L"SRCUNKNOWN", 16, 16);
			((CStatic*)GetDlgItem(IDC_CDA_BEHAVEICON))->SetIcon(hNuthin);
			((CStatic*)GetDlgItem(IDC_CDA_TRANSICON))->SetIcon(hNuthin);
			((CStatic*)GetDlgItem(IDC_CDA_CLIENTICON))->SetIcon(hNuthin);
			((CStatic*)GetDlgItem(IDC_CDA_HASHICON))->SetIcon(hNuthin);
		}
		m_bDataChanged = false;
	}
	return TRUE;
}

LRESULT CAntileechInfoPage::OnDataChanged(WPARAM, LPARAM)
{
	m_bDataChanged = true;
	return 1;
}

void CAntileechInfoPage::Localize()
{
	LOGFONT lf; 
	CFont* pFont = GetFont(); 
	pFont->GetLogFont(&lf); 
	lf.lfWeight = FW_BOLD;
	m_bFont.CreateFontIndirect( &lf );

	GetDlgItem(IDC_CDA_CLIENT)->SetFont(&m_bFont);
	GetDlgItem(IDC_CDA_TRANSFERES)->SetFont(&m_bFont);
	GetDlgItem(IDC_CDA_HASHLISTS)->SetFont(&m_bFont);
	GetDlgItem(IDC_CDA_BEHAVE)->SetFont(&m_bFont);
	
	// labels
	GetDlgItem(IDC_CDA_CLIENT)->SetWindowText(GetResString(IDS_CD_GENERAL));
	GetDlgItem(IDC_CDA_USERNAME)->SetWindowText(GetResString(IDS_CD_UNAME));
	GetDlgItem(IDC_CDA_MODNAME)->SetWindowText(GetResString(IDS_CD_CSOFT) + L':');
	GetDlgItem(IDC_CDA_TRANSFERES)->SetWindowText(GetResString(IDS_CD_TRANS));
	GetDlgItem(IDC_CDA_UL)->SetWindowText(GetResString(IDS_CDA_UL));
	GetDlgItem(IDC_CDA_DL)->SetWindowText(GetResString(IDS_CDA_DL));
	GetDlgItem(IDC_CDA_COMPLETE)->SetWindowText(GetResString(IDS_CDA_COMPLETE));
	GetDlgItem(IDC_CDA_RARE)->SetWindowText(GetResString(IDS_CDA_RARE));
	GetDlgItem(IDC_CDA_PART)->SetWindowText(GetResString(IDS_CDA_PART));
	GetDlgItem(IDC_CDA_TOTAL)->SetWindowText(GetResString(IDS_CDA_TOTAL));
	GetDlgItem(IDC_CDA_UDRATIO)->SetWindowText(GetResString(IDS_CDA_UDRATIO));
	GetDlgItem(IDC_CDA_UDFAILED)->SetWindowText(GetResString(IDS_CDA_UDFAILED));
	GetDlgItem(IDC_CDA_BEHAVE)->SetWindowText(GetResString(IDS_CDA_BEHAVE));
	GetDlgItem(IDC_CDA_NICKTHIEF)->SetWindowText(GetResString(IDS_CDA_NICKTHIEF));
	GetDlgItem(IDC_CDA_MODTHIEF)->SetWindowText(GetResString(IDS_CDA_MODTHIEF));
	GetDlgItem(IDC_CDA_MODFAKER)->SetWindowText(GetResString(IDS_CDA_MODFAKER));
	GetDlgItem(IDC_CDA_FILEFAKER)->SetWindowText(GetResString(IDS_CDA_FILEFAKER));
	GetDlgItem(IDC_CDA_REASKS)->SetWindowText(GetResString(IDS_CDA_REASKS));
	GetDlgItem(IDC_CDA_SPAMMER)->SetWindowText(GetResString(IDS_CDA_SPAMMER));
	GetDlgItem(IDC_CDA_FASTXS)->SetWindowText(GetResString(IDS_CDA_FASTXS));
	GetDlgItem(IDC_CDA_XSEXPLOITER)->SetWindowText(GetResString(IDS_CDA_XSEXPLOITER));
	GetDlgItem(IDC_CDA_HASHLISTS)->SetWindowText(GetResString(IDS_CDA_HASHLISTS));
	GetDlgItem(IDC_CDA_GPL)->SetWindowText(GetResString(IDS_CDA_GPL));
	GetDlgItem(IDC_CDA_SUIBAN)->SetWindowText(GetResString(IDS_CDA_SUIBAN));
	GetDlgItem(IDC_CDA_FINCAN)->SetWindowText(GetResString(IDS_CDA_FINCAN));

	// info
	GetDlgItem(IDC_CDA_FULLUSERNAME)->SetWindowText(GetResString(IDS_UNKNOWN));
	GetDlgItem(IDC_CDA_MODNAMEFULL)->SetWindowText(GetResString(IDS_UNKNOWN));
	GetDlgItem(IDC_CDA_ULCOMP)->SetWindowText(GetResString(IDS_UNKNOWN));
	GetDlgItem(IDC_CDA_ULPART)->SetWindowText(GetResString(IDS_UNKNOWN));
	GetDlgItem(IDC_CDA_ULRARE)->SetWindowText(GetResString(IDS_UNKNOWN));
	GetDlgItem(IDC_CDA_ULTOTAL)->SetWindowText(GetResString(IDS_UNKNOWN));
	GetDlgItem(IDC_CDA_DLCOMP)->SetWindowText(GetResString(IDS_UNKNOWN));
	GetDlgItem(IDC_CDA_DLPART)->SetWindowText(GetResString(IDS_UNKNOWN));
	GetDlgItem(IDC_CDA_DLRARE)->SetWindowText(GetResString(IDS_UNKNOWN));
	GetDlgItem(IDC_CDA_DLTOTAL)->SetWindowText(GetResString(IDS_UNKNOWN));
	GetDlgItem(IDC_CDA_UDCHUNKS)->SetWindowText(GetResString(IDS_UNKNOWN));
	GetDlgItem(IDC_CDA_UDRATING)->SetWindowText(L"");
	GetDlgItem(IDC_CDA_FAILED)->SetWindowText(GetResString(IDS_UNKNOWN));
	GetDlgItem(IDC_CDA_NICKTHIEFINFO)->SetWindowText(GetResString(IDS_UNKNOWN));
	GetDlgItem(IDC_CDA_MODTHIEFINFO)->SetWindowText(GetResString(IDS_UNKNOWN));
	GetDlgItem(IDC_CDA_MODFAKERINFO)->SetWindowText(GetResString(IDS_UNKNOWN));
	GetDlgItem(IDC_CDA_FILEFAKERINFO)->SetWindowText(GetResString(IDS_UNKNOWN));
	GetDlgItem(IDC_CDA_SPAMMERINFO)->SetWindowText(GetResString(IDS_UNKNOWN));
	GetDlgItem(IDC_CDA_FASTXSINFO)->SetWindowText(GetResString(IDS_UNKNOWN));
	GetDlgItem(IDC_CDA_XSEXPLOITINFO)->SetWindowText(GetResString(IDS_UNKNOWN));
	GetDlgItem(IDC_CDA_REASKINFO)->SetWindowText(GetResString(IDS_UNKNOWN));
	GetDlgItem(IDC_CDA_GPLINFO)->SetWindowText(GetResString(IDS_UNKNOWN));
	GetDlgItem(IDC_CDA_FINCANINFO)->SetWindowText(GetResString(IDS_UNKNOWN));
	GetDlgItem(IDC_CDA_SUILEECHERINFO)->SetWindowText(GetResString(IDS_UNKNOWN));
/*	GetDlgItem()->SetWindowText(GetResString());*/
}