//>> pP: LocalizeMod
#include "log.h"
#define LANGUAGEFILENAME L"ModLang.ini"
int CPreferences::m_iLangFileVersion;
DWORD CPreferences::m_dwLangFileUpdate;
CStringList CPreferences::m_strModRes_CC;
CStringList CPreferences::m_strModRes_CA;
CStringList CPreferences::m_strModRes_Misc;
CStringList CPreferences::m_strModRes_SL;
CStringList CPreferences::m_strModRes_ADP;
CStringList CPreferences::m_strModRes_AHL;
CStringList CPreferences::m_strModRes_FN;
CStringList CPreferences::m_strModRes_IP2C;
CStringList CPreferences::m_strModRes_MIM;
CStringList CPreferences::m_strModRes_COL;
CStringList CPreferences::m_strModRes_SLS;
CStringList CPreferences::m_strModRes_IPF;
CStringList CPreferences::m_strModRes_Drop;
CStringList CPreferences::m_strModRes_Stats;
CStringList CPreferences::m_strModRes_FeedB;

#include "IPFilter.h"
void CPreferences::Localize_Init(bool bNoDownload)
{
	CString strPath;
	strPath.Format(L"%s%s", GetMuleDirectory(EMULE_ADDLANGDIR), LANGUAGEFILENAME);

	if (!bNoDownload || !PathFileExists(strPath))
	{
		m_dwLangFileUpdate = 0;
		DownloadLanguageIni();
	}

	Localize_LoadResStrings(false);
}

void CPreferences::DownloadLanguageIni()
{
	if (m_dwLangFileUpdate > ::GetTickCount())
		return;

	CString strFrom, strTo;
	strFrom.Format(L"%s%s", MOD_DLLPATH, LANGUAGEFILENAME);
	strTo.Format(L"%s%s", thePrefs.GetMuleDirectory(EMULE_ADDLANGDIR), LANGUAGEFILENAME);

	if (URLDownloadToFile(0, strFrom, strTo, 0, 0)) // returns true on failure oO
	{
		theApp.QueueLogLineEx(LOG_ERROR, L"Download of languagefile from '%s' failed.", strFrom);
		thePrefs.m_dwLangFileUpdate = ::GetTickCount() + DAY2MS(1);
	}
	else
	{
		theApp.QueueLogLineEx(LOG_SUCCESS, L"Languagefile downloaded from '%s'.", strFrom);
		thePrefs.m_dwLangFileUpdate = ::GetTickCount() + DAY2MS(7);
	}
}

void CPreferences::Localize_UnInit()
{
	m_strModRes_CA.RemoveAll();
	m_strModRes_Misc.RemoveAll();
	m_strModRes_SL.RemoveAll();
	m_strModRes_ADP.RemoveAll();
	m_strModRes_AHL.RemoveAll();
	m_strModRes_FN.RemoveAll();
	m_strModRes_IP2C.RemoveAll();
	m_strModRes_MIM.RemoveAll();
	m_strModRes_COL.RemoveAll();
	m_strModRes_SLS.RemoveAll();
	m_strModRes_IPF.RemoveAll();
	m_strModRes_Drop.RemoveAll();
	m_strModRes_Stats.RemoveAll();
	m_strModRes_FeedB.RemoveAll();
}

void CPreferences::Localize_LoadResStrings(bool bLanguagechanged)
{
	CString strPath;
	strPath.Format(L"%s%s", GetMuleDirectory(EMULE_ADDLANGDIR), LANGUAGEFILENAME);

	CIni ini(strPath, L"Version");
	int uTempVersion = ini.GetInt(L"LangVer", 0, L"Version");
	DEBUG_ONLY(TRACE(L"Localize: LangFileVersion %u\n", uTempVersion));

	 // Versioncheck: the file is not newer and we already loaded those strings and we did not switch language in prefs
	if (bLanguagechanged)
		; // already logged further below
	else if (m_iLangFileVersion == uTempVersion && m_strModRes_COL.GetCount() != 0)
	{
		theApp.QueueLogLineEx(0, L"Localize: Current stringset v%u is uptodate. (%i)", m_iLangFileVersion, bLanguagechanged);
		return;
	}

	//>> evl: Show current language/support state
	//bool bSupportedLang = true;
	CString strLang, strSection;
	switch (m_wLanguageID)
	{
		case 1031:
			strLang = L"German";
			strSection = L"1031";
			break;
		case 1033:
			strLang = L"English";
			strSection = L"1033";
			break;
		case 1043:
			strLang = L"Dutch";
			strSection = L"1043";
			break;
		default:
			//bSupportedLang = false;
			strSection = L"1033";	// English is also hardcoded, but the file might be corrected or newer
									// hardcoded strings are used when there is none found in the file
			strLang = L"not localized, defaulting to English";
			break;
	}
	//<< evl: Show current language/support state

	if (m_iLangFileVersion != uTempVersion)
		theApp.QueueLogLineEx(0, L"Localize: Loading updated stringset v%u, (old: v%u). Current language (%u) is %s .", uTempVersion, m_iLangFileVersion, m_wLanguageID, strLang);
	else if (bLanguagechanged)
		theApp.QueueLogLineEx(0, L"Localize: Reloading stringset after language was changed in prefs. New language (%u) is %s.", m_wLanguageID, strLang);
	else
		theApp.QueueLogLineEx(0, L"Localize: Loading stringset v%i (Startup). Current language (%u) is %s.", uTempVersion, m_wLanguageID, strLang);

	m_iLangFileVersion = uTempVersion; // update local languagefile version

	//>> evl: ConChecker [eWombat]
	m_strModRes_CC.RemoveAll();
	m_strModRes_CC.AddHead(ini.GetString(L"ConChecker0", L"ConChecker", strSection));
	m_strModRes_CC.AddTail(ini.GetString(L"ConChecker1", L"Choose ping method:"));
	m_strModRes_CC.AddTail(ini.GetString(L"ConChecker2", L"ICMP"));
	m_strModRes_CC.AddTail(ini.GetString(L"ConChecker3", L"RAW"));
	m_strModRes_CC.AddTail(ini.GetString(L"ConChecker4", L"TTL"));
	m_strModRes_CC.AddTail(ini.GetString(L"ConChecker5", L"Ping timeout"));
	m_strModRes_CC.AddTail(ini.GetString(L"ConChecker6", L"Check for connection loss?"));
	//<< evl: ConChecker [eWombat]
	//>> evl: ReaskAfterChangedIP [Stulle]
	m_strModRes_CC.AddTail(ini.GetString(L"ConChecker7", L"Reask after IP changes"));
	m_strModRes_CC.AddTail(ini.GetString(L"ConChecker8", L"Reask all sources"));
	m_strModRes_CC.AddTail(ini.GetString(L"ConChecker9", L"Inform queue'd clients"));
	//<< evl: ReaskAfterChangedIP [Stulle]
	m_strModRes_CC.AddTail(ini.GetString(L"ConChecker10", L"Reask sources after [29-58 min]"));
	DEBUG_ONLY(TRACE(L"Localize: Added Con, count %u\n", m_strModRes_CC.GetCount()));

	// Analyzer
	m_strModRes_CA.RemoveAll();
	m_strModRes_CA.AddHead(ini.GetString(L"CA0", L"Use ClientAnalyzer reward/punishing (recommended)"));
	m_strModRes_CA.AddTail(ini.GetString(L"CA1", L"Do not reward uploaders"));
	m_strModRes_CA.AddTail(ini.GetString(L"CA2", L"Use official rewarding (WARNING! Easily exploitable!)"));
	m_strModRes_CA.AddTail(ini.GetString(L"CA3", L"Log Client Analyzer actions")); // IDS_LOG_ANALYZER_EVENTS
	m_strModRes_CA.AddTail(ini.GetString(L"CA4", L"Anti-Leech Info:")); //IDS_ANTILEECH_LABEL     
	DEBUG_ONLY(TRACE(L"Localize: Added Analyzer, count %u\n", m_strModRes_CA.GetCount()));

	// Labels and misc stuff
	m_strModRes_Misc.RemoveAll();
	m_strModRes_Misc.AddHead(ini.GetString(L"Misc0", L"List Addons"));
	m_strModRes_Misc.AddTail(ini.GetString(L"Misc1", L"Mod Options"));
	m_strModRes_Misc.AddTail(ini.GetString(L"Misc2", L"Export sessionstats on exit (slows down closing)"));
	m_strModRes_Misc.AddTail(ini.GetString(L"Misc3", L"The default language is 'English'.\r\n\r\nDo you want to set it to Dutch now?\r\nYou can also change this to any other\r\nlanguage later in the Preferences."));
	m_strModRes_Misc.AddTail(ini.GetString(L"Misc4", RemoveAmbersand(GetResString(IDS_EM_PREFS))));
	m_strModRes_Misc.AddTail(ini.GetString(L"Misc5", L"ModLog"));
	m_strModRes_Misc.AddTail(ini.GetString(L"Misc6", L"LeechLog"));
	m_strModRes_Misc.AddTail(ini.GetString(L"Misc7", L"Emulate other"));
	m_strModRes_Misc.AddTail(ini.GetString(L"Misc8", L"Export MOD Stats (Session)"));
	m_strModRes_Misc.AddTail(ini.GetString(L"Misc9", L"Source options"));
	m_strModRes_Misc.AddTail(ini.GetString(L"Misc10", L"Display options"));
	m_strModRes_Misc.AddTail(ini.GetString(L"Misc11", L"Other options"));
	m_strModRes_Misc.AddTail(ini.GetString(L"Misc12", L"SlotFocus"));
	m_strModRes_Misc.AddTail(ini.GetString(L"Misc13", L"Enable FloodControl"));
	m_strModRes_Misc.AddTail(ini.GetString(L"Misc14", L" (Upload)"));
	m_strModRes_Misc.AddTail(ini.GetString(L"Misc15", L"Ul/Dl"));
	m_strModRes_Misc.AddTail(ini.GetString(L"Misc16", L"Show client percentages"));
	m_strModRes_Misc.AddTail(ini.GetString(L"Misc17", L"DiffQR"));
	m_strModRes_Misc.AddTail(ini.GetString(L"Misc18", L"Show RQR changes"));
	m_strModRes_Misc.AddTail(ini.GetString(L"Misc19", L"Write to log"));
	m_strModRes_Misc.AddTail(ini.GetString(L"Misc20", L"Store hashes for later detection"));
	m_strModRes_Misc.AddTail(ini.GetString(L"Misc21", L"Own Score"));
	DEBUG_ONLY(TRACE(L"Localize: Added Misc, count %u\n", m_strModRes_Misc.GetCount()));

	//>> pP: Slotlimiter
	m_strModRes_SL.RemoveAll();
	m_strModRes_SL.AddHead(ini.GetString(L"SL0", L"Slotlimiter"));
	m_strModRes_SL.AddTail(ini.GetString(L"SL1", L"Official Limit"));
	m_strModRes_SL.AddTail(ini.GetString(L"SL2", L"Custom slotspeed"));
	m_strModRes_SL.AddTail(ini.GetString(L"SL3", L"Custom max. slots"));
	m_strModRes_SL.AddTail(ini.GetString(L"SL4", L"Custom slotspeed (kB/s)"));
	m_strModRes_SL.AddTail(ini.GetString(L"SL5", L"Custom max. open slots"));
	DEBUG_ONLY(TRACE(L"Localize: Added SlotLimiter, count %u\n", m_strModRes_SL.GetCount()));
	//<< pP: Slotlimiter

	//>> pP: AutoDownPrio
	m_strModRes_ADP.RemoveAll();
	m_strModRes_ADP.AddHead(ini.GetString(L"ADP0", L"AutoPriority (DL)"));
	m_strModRes_ADP.AddTail(ini.GetString(L"ADP1", L"Activate AutoPrio"));
	m_strModRes_ADP.AddTail(ini.GetString(L"ADP2", L"Auto High Priority treshold (%)"));
	m_strModRes_ADP.AddTail(ini.GetString(L"ADP3", L"Auto Normal Priority treshold (%)"));
	m_strModRes_ADP.AddTail(ini.GetString(L"ADP4", L"Log priority changes"));
	DEBUG_ONLY(TRACE(L"Localize: Added ADP, count %u\n", m_strModRes_ADP.GetCount()));
	//<< pP: AutoDownPrio

	//>> pP: AutoHL
	m_strModRes_AHL.RemoveAll();
	m_strModRes_AHL.AddHead(ini.GetString(L"AHL0", L"Auto Hardlimit"));
	m_strModRes_AHL.AddTail(ini.GetString(L"AHL1", L"Activate AutoHL"));
	m_strModRes_AHL.AddTail(ini.GetString(L"AHL2", L"Max. Global sources"));
	m_strModRes_AHL.AddTail(ini.GetString(L"AHL3", L"Min. Sources per file"));
	m_strModRes_AHL.AddTail(ini.GetString(L"AHL4", L"Recheck every X minutes"));
	m_strModRes_AHL.AddTail(ini.GetString(L"AHL5", L"Drop sources to reach max. srcs"));
	DEBUG_ONLY(TRACE(L"Localize: Added AHL, count %u\n", m_strModRes_AHL.GetCount()));
	//<< pP: AutoHL

	//>> evl: FunnyNicks [xrmb]
	m_strModRes_FN.RemoveAll();
	m_strModRes_FN.AddHead(ini.GetString(L"FN0", L"FunnyNicks"));
	m_strModRes_FN.AddTail(ini.GetString(L"FN1", L"Show FunnyNicks"));
	m_strModRes_FN.AddTail(ini.GetString(L"FN2", L"Tag length"));
	m_strModRes_FN.AddTail(ini.GetString(L"FN3", L"Show [FunnyNick]"));
	m_strModRes_FN.AddTail(ini.GetString(L"FN4", L"Show [FN]"));
	m_strModRes_FN.AddTail(ini.GetString(L"FN5", L"Tag placement"));
	m_strModRes_FN.AddTail(ini.GetString(L"FN6", L"Tag before name"));
	m_strModRes_FN.AddTail(ini.GetString(L"FN7", L"Tag after name"));
	m_strModRes_FN.AddTail(ini.GetString(L"FN8", L"fn8 -- free")); //L"Emulate communities"); //>> evl: EmulateComm [evcz]
	m_strModRes_FN.AddTail(ini.GetString(L"FN9", L"Show ChunkDots"));
	m_strModRes_FN.AddTail(ini.GetString(L"FN10", L"None"));
	DEBUG_ONLY(TRACE(L"Localize: Added FN, count %u\n", m_strModRes_FN.GetCount()));
	//>> evl: FunnyNicks [xrmb]

	//>> evl: IP2C [EastShare]
	m_strModRes_IP2C.RemoveAll();
	m_strModRes_IP2C.AddHead(ini.GetString(L"IP2C0", GetResString(IDS_IP2COUNTRY)));
	m_strModRes_IP2C.AddTail(ini.GetString(L"IP2C1", GetResString(IDS_IP2COUNTRY_2LETTERS)));
	m_strModRes_IP2C.AddTail(ini.GetString(L"IP2C2", GetResString(IDS_IP2COUNTRY_3LETTERS)));
	m_strModRes_IP2C.AddTail(ini.GetString(L"IP2C3", GetResString(IDS_IP2COUNTRY_FULLCAPTION)));
	m_strModRes_IP2C.AddTail(ini.GetString(L"IP2C4", GetResString(IDS_IP2COUNTRY_SHOWFLAGS)));
	m_strModRes_IP2C.AddTail(ini.GetString(L"IP2C5", L"Show flags on files (origin)"));
	m_strModRes_IP2C.AddTail(ini.GetString(L"IP2C6", L"Enable AutoUpdate"));
	m_strModRes_IP2C.AddTail(ini.GetString(L"IP2C7", L"Caption"));
	m_strModRes_IP2C.AddTail(ini.GetString(L"IP2C8", GetResString(IDS_COUNTRY)));
	DEBUG_ONLY(TRACE(L"Localize: Added ip2c, count %u\n", m_strModRes_IP2C.GetCount()));
	//<< evl: IP2C [EastShare]

	//>> evl: ModIconDLL [WiZaRd/Shadow2004]
	m_strModRes_MIM.RemoveAll();
	m_strModRes_MIM.AddHead(ini.GetString(L"MIM0", L"ModIcons"));
	m_strModRes_MIM.AddTail(ini.GetString(L"MIM1", L"Show ModIcons in all lists"));
	m_strModRes_MIM.AddTail(ini.GetString(L"MIM2", L"Enable AutoUpdate"));
	DEBUG_ONLY(TRACE(L"Localize: Added MIM, count %u\n", m_strModRes_MIM.GetCount()));
	//<< evl: ModIconDLL [WiZaRd/Shadow2004]

	//>> pP: ColoredActiveDLs
	m_strModRes_COL.RemoveAll();
	m_strModRes_COL.AddHead(ini.GetString(L"Color0", L"Colored active downloads"));
	m_strModRes_COL.AddTail(ini.GetString(L"Color1", L"Black (default)"));
	m_strModRes_COL.AddTail(ini.GetString(L"Color2", L"Red"));
	m_strModRes_COL.AddTail(ini.GetString(L"Color3", L"Green"));
	m_strModRes_COL.AddTail(ini.GetString(L"Color4", L"Blue"));
	m_strModRes_COL.AddTail(ini.GetString(L"Color5", L"Grey"));
	m_strModRes_COL.AddTail(ini.GetString(L"Color6", L"Yellow"));
	m_strModRes_COL.AddTail(ini.GetString(L"Color7", L"Bold active downloads")); //>> pP: BoldActiveDLs
	m_strModRes_COL.AddTail(ini.GetString(L"Color8", L"Only Color fist column"));
	DEBUG_ONLY(TRACE(L"Localize: Added Coloring, count %u\n", m_strModRes_COL.GetCount()));
	//<< pP: ColoredActiveDLs

	//>> evl: SaveLoadSources [enkeyDEV]
	m_strModRes_SLS.RemoveAll();
	m_strModRes_SLS.AddHead(ini.GetString(L"SLS0", L"SLS")); // IDS_SLS
	m_strModRes_SLS.AddTail(ini.GetString(L"SLS1", L"Save/Load Sources")); // IDS_SLSLABEL
	m_strModRes_SLS.AddTail(ini.GetString(L"SLS2", L"Enable Save/Load Sources")); // IDS_SLSCHECKLABEL
	m_strModRes_SLS.AddTail(ini.GetString(L"SLS3", L"Activationlimit for saving Sources")); // IDS_SLSACTIVATIONLABEL
	m_strModRes_SLS.AddTail(ini.GetString(L"SLS4", L"Maximum number of Sources to save")); // IDS_SLSSAVEVALUE
	DEBUG_ONLY(TRACE(L"Localize: Added SLS, count %u\n", m_strModRes_SLS.GetCount()));
	//<< evl: SaveLoadSources [enkeyDEV]

	m_strModRes_IPF.RemoveAll();
	m_strModRes_IPF.AddHead(ini.GetString(L"IPF0", L"IP-Filter updates"));
	m_strModRes_IPF.AddTail(ini.GetString(L"IPF1", L"Enable updates"));
	m_strModRes_IPF.AddTail(ini.GetString(L"IPF2", L"Pawcio filter "));
	m_strModRes_IPF.AddTail(ini.GetString(L"IPF3", L"Bluetack filter 'normal'"));
	m_strModRes_IPF.AddTail(ini.GetString(L"IPF4", L"Bluetack filter 'paranoid'"));
	m_strModRes_IPF.AddTail(ini.GetString(L"IPF5", L"From custom location"));
	m_strModRes_IPF.AddTail(ini.GetString(L"IPF6", L"URL"));
	m_strModRes_IPF.AddTail(ini.GetString(L"IPF7", L"-Enter URL here-"));
	DEBUG_ONLY(TRACE(L"Localize: Added IPF, count %u\n", m_strModRes_IPF.GetCount()));

	//>> pP: SourceDrops
	m_strModRes_Drop.RemoveAll();
	m_strModRes_Drop.AddHead(ini.GetString(L"Drop0", L"Drop sources"));
	m_strModRes_Drop.AddTail(ini.GetString(L"Drop1", L"High QRs"));
	m_strModRes_Drop.AddTail(ini.GetString(L"Drop2", L"Timer in minutes [15..255]"));
	m_strModRes_Drop.AddTail(ini.GetString(L"Drop3", L"Highest RQR"));
	m_strModRes_Drop.AddTail(ini.GetString(L"Drop4", L"Log drops"));
	m_strModRes_Drop.AddTail(ini.GetString(L"Drop5", L"Enable drop"));
	m_strModRes_Drop.AddTail(ini.GetString(L"Drop6", L"Too many conns."));
	m_strModRes_Drop.AddTail(ini.GetString(L"Drop7", L"Don't drop if there are less than X srcs"));
	m_strModRes_Drop.AddTail(ini.GetString(L"Drop8", L"Drop NNS"));
	m_strModRes_Drop.AddTail(ini.GetString(L"Drop9", L"Drop FullQ"));
	m_strModRes_Drop.AddTail(ini.GetString(L"Drop10", L"Drop TooMany"));
	m_strModRes_Drop.AddTail(ini.GetString(L"Drop11", L"Drop Unknown"));
	m_strModRes_Drop.AddTail(ini.GetString(L"Drop12", L"Drop HighQRs (>%i)"));
	DEBUG_ONLY(TRACE(L"Localize: Added Drops, count %u\n", m_strModRes_Drop.GetCount()));
	//<< pP: SourceDrops

	// StatisticDlg entries & Feedback stuff
	m_strModRes_Stats.RemoveAll();
	// CA
	m_strModRes_Stats.AddHead(ini.GetString(L"Stats0", L"Nickthieveries:"));
	m_strModRes_Stats.AddTail(ini.GetString(L"Stats1", L"Modthieveries:"));
	m_strModRes_Stats.AddTail(ini.GetString(L"Stats2", L"File fakes:"));
	m_strModRes_Stats.AddTail(ini.GetString(L"Stats3", L"UDP-FNF fakes:"));
	m_strModRes_Stats.AddTail(ini.GetString(L"Stats4", L"Fast asks:"));
	m_strModRes_Stats.AddTail(ini.GetString(L"Stats5", L"Spams:"));
	m_strModRes_Stats.AddTail(ini.GetString(L"Stats6", L"FastXS:"));
	m_strModRes_Stats.AddTail(ini.GetString(L"Stats7", L"ClientAnalyzer"));
	//>> pP: Powershare
	m_strModRes_Stats.AddTail(ini.GetString(L"Stats8", L"Upload on complete files:"));
	m_strModRes_Stats.AddTail(ini.GetString(L"Stats9", L"Upload on incomplete files:"));
	m_strModRes_Stats.AddTail(ini.GetString(L"Stats10", L"Powershare"));
	m_strModRes_Stats.AddTail(ini.GetString(L"Stats11", L"Total upload via Powershare:"));
	//>> pP: FileStats [IceCream]
	m_strModRes_Stats.AddTail(ini.GetString(L"Stats12", L"Feedback"));
	m_strModRes_Stats.AddTail(ini.GetString(L"Stats13", L"Colored (Blue-Green) with Upload"));
	m_strModRes_Stats.AddTail(ini.GetString(L"Stats14", L"Colored (Blue-Green) without Upload"));
	m_strModRes_Stats.AddTail(ini.GetString(L"Stats15", L"Colored (Purple-Red) with Upload"));
	m_strModRes_Stats.AddTail(ini.GetString(L"Stats16", L"Colored (Purple-Red) without Upload"));
	m_strModRes_Stats.AddTail(ini.GetString(L"Stats17", L"Pure Text with Upload"));
	m_strModRes_Stats.AddTail(ini.GetString(L"Stats18", L"Pure Text without Upload"));
	//>> pP: Antileech stats
	m_strModRes_Stats.AddTail(ini.GetString(L"Stats19", L"Antileech Stats"));
	m_strModRes_Stats.AddTail(ini.GetString(L"Stats20", L"GPL breakers"));
	m_strModRes_Stats.AddTail(ini.GetString(L"Stats21", L"Fincan Mods"));
	m_strModRes_Stats.AddTail(ini.GetString(L"Stats22", L"Vagaa Mods"));
	m_strModRes_Stats.AddTail(ini.GetString(L"Stats23", L"SUI Faker"));
	DEBUG_ONLY(TRACE(L"Localize: Added Stats, count %u\n", m_strModRes_Stats.GetCount()));

	//>> pP: FileStats [IceCream]
	m_strModRes_FeedB.AddHead(ResStats(12)); // cleanup ^^
	m_strModRes_FeedB.AddTail(ini.GetString(L"Feedb1",  L"Copy feedback to clipboard (localized)"));// IDS_COPYFEEDBACK
	m_strModRes_FeedB.AddTail(ini.GetString(L"Feedb2",  L"Copy feedback to clipboard (English)"));	// IDS_COPYFEEDBACK_US
	m_strModRes_FeedB.AddTail(ini.GetString(L"Feedb3",  L"Feedback from"));							// IDS_FEEDBACK_FROM
	m_strModRes_FeedB.AddTail(ini.GetString(L"Feedb4",  L"Transferred:"));							// IDS_FEEDBACK_TRANSFERRED
	m_strModRes_FeedB.AddTail(ini.GetString(L"Feedb5",  L"Requested:"));							// IDS_FEEDBACK_REQUESTED
	m_strModRes_FeedB.AddTail(ini.GetString(L"Feedb6",  L"Accepted Requests:"));					// IDS_FEEDBACK_ACCEPTED
	m_strModRes_FeedB.AddTail(ini.GetString(L"Feedb7",  L"Complete sources:"));						// IDS_FEEDBACK_COMPLETE
	m_strModRes_FeedB.AddTail(ini.GetString(L"Feedb8",  L"File name:"));							// IDS_FEEDBACK_FILENAME
	m_strModRes_FeedB.AddTail(ini.GetString(L"Feedb9",  L"File type:"));							// IDS_FEEDBACK_FILETYPE
	m_strModRes_FeedB.AddTail(ini.GetString(L"Feedb10", L"Size:"));									// IDS_FEEDBACK_FILESIZE
	m_strModRes_FeedB.AddTail(ini.GetString(L"Feedb11", L"Downloaded:"));							// IDS_FEEDBACK_DOWNLOADED
	m_strModRes_FeedB.AddTail(ini.GetString(L"Feedb12", L"Total sources:"));						// IDS_FEEDBACK_TOTAL
	m_strModRes_FeedB.AddTail(ini.GetString(L"Feedb13", L"Available sources:"));					// IDS_FEEDBACK_AVAILABLE
	m_strModRes_FeedB.AddTail(ini.GetString(L"Feedb14", L"No Needed Part sources:"));				// IDS_FEEDBACK_NONEEDPART
	m_strModRes_FeedB.AddTail(ini.GetString(L"Feedb15", L"Created:"));
	m_strModRes_FeedB.AddTail(ini.GetString(L"Feedb16", L"Add BBcodes (forumfriendly)"));
	DEBUG_ONLY(TRACE(L"Localize: Added FeedB, count %u\n", m_strModRes_FeedB.GetCount()));
	//<< pP: FileStats [IceCream]

	//Localize_ExportResStrings(); // copy current stringset to clipboard, parts not translated will appear in English [debug]
	//theApp.QueueLogLineEx(0, L"Localize: Stringset v%u loaded.", m_iLangFileVersion);
}

void CPreferences::Localize_ExportResStrings()
{
	//Exports all ResStrings to the Clipboard [forum friendly quote]
	CString ret = L"[quote]\r\n";

	theApp.QueueLogLineEx(0, L"Start Export...");

	for (uint8 n = 0; n < m_strModRes_CC.GetCount(); n++)
		ret.AppendFormat(L"ConChecker%u=%s\r\n", n, ResCon(n));

	ret.Append(L"\r\n");
	for (uint8 n = 0; n < m_strModRes_CA.GetCount(); n++)
		ret.AppendFormat(L"CA%u=%s\r\n", n, ResCA(n));

	ret.Append(L"\r\n");
	for (uint8 n = 0; n < m_strModRes_Misc.GetCount(); n++)
		ret.AppendFormat(L"Misc%u=%s\r\n", n, ResMisc(n));

	ret.Append(L"\r\n");
	for (uint8 n = 0; n < m_strModRes_SL.GetCount(); n++)
		ret.AppendFormat(L"SL%i=%s\r\n", n, ResSL(n));

	ret.Append(L"\r\n");
	for (uint8 n = 0; n < m_strModRes_ADP.GetCount(); n++)
		ret.AppendFormat(L"ADP%u=%s\r\n", n, ResADP(n));

	ret.Append(L"\r\n");
	for (uint8 n = 0; n < m_strModRes_AHL.GetCount(); n++)
		ret.AppendFormat(L"AHL%u=%s\r\n", n, ResAHL(n));

	ret.Append(L"\r\n");
	for (uint8 n = 0; n < m_strModRes_FN.GetCount(); n++)
		ret.AppendFormat(L"FN%u=%s\r\n", n, ResFN(n));

	ret.Append(L"\r\n");
	for (uint8 n = 0; n < m_strModRes_IP2C.GetCount(); n++)
		ret.AppendFormat(L"IP2C%u=%s\r\n", n, ResIP2C(n));

	ret.Append(L"\r\n");
	for (uint8 n = 0; n < m_strModRes_MIM.GetCount(); n++)
		ret.AppendFormat(L"MIM%u=%s\r\n", n, ResMIM(n));

	ret.Append(L"\r\n");
	for (uint8 n = 0; n < m_strModRes_COL.GetCount(); n++)
		ret.AppendFormat(L"Color%u=%s\r\n", n, ResColor(n));

	ret.Append(L"\r\n");
	for (uint8 n = 0; n < m_strModRes_SLS.GetCount(); n++)
		ret.AppendFormat(L"SLS%u=%s\r\n", n, ResSLS(n));

	ret.Append(L"\r\n");
	for (uint8 n = 0; n < m_strModRes_IPF.GetCount(); n++)
		ret.AppendFormat(L"IPF%u=%s\r\n", n, ResIPF(n));

	ret.Append(L"\r\n");
	for (uint8 n = 0; n < m_strModRes_Drop.GetCount(); n++)
		ret.AppendFormat(L"Drop%u=%s\r\n", n, ResDrop(n));

	ret.Append(L"\r\n");
	for (uint8 n = 0; n < m_strModRes_Stats.GetCount(); n++)
		ret.AppendFormat(L"Stats%u=%s\r\n", n, ResStats(n));

	ret.Append(L"\r\n");
	for (uint8 n = 0; n < m_strModRes_FeedB.GetCount(); n++)
		ret.AppendFormat(L"FeedB%u=%s\r\n", n, ResFeedB(n));

	ret.Append(L"[/quote]");
	theApp.QueueLogLineEx(0, L"...Export done.");
	theApp.CopyTextToClipboard(ret);
	ret.Empty();
}
//<< pP: LocalizeMod